"""
    Sifflet Backend API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from sifflet.apis.client.api_client import ApiClient, Endpoint as _Endpoint
from sifflet.apis.client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from sifflet.apis.client.model.assets_catalog_dto import AssetsCatalogDto


class CatalogControllerApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_search_results_and_filter_endpoint = _Endpoint(
            settings={
                'response_type': (AssetsCatalogDto,),
                'auth': [
                    'JWT'
                ],
                'endpoint_path': '/api/v1/catalogs/_search-assets',
                'operation_id': 'get_search_results_and_filter',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'page_num',
                    'page_size',
                    'search',
                    'sort_by',
                    'sort_desc',
                    'datasources',
                    'tags',
                    'health',
                    'asset_type',
                ],
                'required': [
                    'page_num',
                    'page_size',
                ],
                'nullable': [
                ],
                'enum': [
                    'health',
                    'asset_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('health',): {

                        "CRITICAL": "CRITICAL",
                        "AT_RISK": "AT_RISK",
                        "HEALTHY": "HEALTHY",
                        "UNMONITORED": "UNMONITORED",
                        "NOT_SUPPORTED": "NOT_SUPPORTED"
                    },
                    ('asset_type',): {

                        "TABLES": "TABLES",
                        "DASHBOARDS": "DASHBOARDS",
                        "METRICS": "METRICS",
                        "MODELS": "MODELS",
                        "DAGS": "DAGS"
                    },
                },
                'openapi_types': {
                    'page_num':
                        (int,),
                    'page_size':
                        (int,),
                    'search':
                        (str,),
                    'sort_by':
                        ([str],),
                    'sort_desc':
                        ([bool],),
                    'datasources':
                        ([str],),
                    'tags':
                        ([str],),
                    'health':
                        ([str],),
                    'asset_type':
                        ([str],),
                },
                'attribute_map': {
                    'page_num': 'pageNum',
                    'page_size': 'pageSize',
                    'search': 'search',
                    'sort_by': 'sortBy',
                    'sort_desc': 'sortDesc',
                    'datasources': 'datasources',
                    'tags': 'tags',
                    'health': 'health',
                    'asset_type': 'assetType',
                },
                'location_map': {
                    'page_num': 'query',
                    'page_size': 'query',
                    'search': 'query',
                    'sort_by': 'query',
                    'sort_desc': 'query',
                    'datasources': 'query',
                    'tags': 'query',
                    'health': 'query',
                    'asset_type': 'query',
                },
                'collection_format_map': {
                    'sort_by': 'multi',
                    'sort_desc': 'multi',
                    'datasources': 'multi',
                    'tags': 'multi',
                    'health': 'multi',
                    'asset_type': 'multi',
                }
            },
            headers_map={
                'accept': [
                    '*/*'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def get_search_results_and_filter(
        self,
        page_num,
        page_size,
        **kwargs
    ):
        """get_search_results_and_filter  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_search_results_and_filter(page_num, page_size, async_req=True)
        >>> result = thread.get()

        Args:
            page_num (int):
            page_size (int):

        Keyword Args:
            search (str): [optional]
            sort_by ([str]): [optional]
            sort_desc ([bool]): [optional]
            datasources ([str]): [optional]
            tags ([str]): [optional]
            health ([str]): [optional]
            asset_type ([str]): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            AssetsCatalogDto
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['page_num'] = \
            page_num
        kwargs['page_size'] = \
            page_size
        return self.get_search_results_and_filter_endpoint.call_with_http_info(**kwargs)

