"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const app = new core_1.App();
const stack = new core_1.Stack(app, 'integ-user-pool');
new lib_1.UserPool(stack, 'myuserpool', {
    userPoolName: 'MyUserPool',
    userInvitation: {
        emailSubject: 'invitation email subject from the integ test',
        emailBody: 'invitation email body from the integ test for {username}. Temp password is {####}.',
        smsMessage: 'invitation sms message from the integ test for {username}. Temp password is {####}.',
    },
    selfSignUpEnabled: true,
    userVerification: {
        emailBody: 'verification email body from the integ test. Code is {####}.',
        emailSubject: 'verification email subject from the integ test',
        smsMessage: 'verification sms message from the integ test. Code is {####}.',
    },
    signInAliases: {
        username: true,
        email: true,
    },
    autoVerify: {
        email: true,
        phone: true,
    },
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcudXNlci1wb29sLWV4cGxpY2l0LXByb3BzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcudXNlci1wb29sLWV4cGxpY2l0LXByb3BzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsd0NBQTJDO0FBQzNDLGdDQUFrQztBQUVsQyxNQUFNLEdBQUcsR0FBRyxJQUFJLFVBQUcsRUFBRSxDQUFDO0FBQ3RCLE1BQU0sS0FBSyxHQUFHLElBQUksWUFBSyxDQUFDLEdBQUcsRUFBRSxpQkFBaUIsQ0FBQyxDQUFDO0FBRWhELElBQUksY0FBUSxDQUFDLEtBQUssRUFBRSxZQUFZLEVBQUU7SUFDaEMsWUFBWSxFQUFFLFlBQVk7SUFDMUIsY0FBYyxFQUFFO1FBQ2QsWUFBWSxFQUFFLDhDQUE4QztRQUM1RCxTQUFTLEVBQUUsb0ZBQW9GO1FBQy9GLFVBQVUsRUFBRSxxRkFBcUY7S0FDbEc7SUFDRCxpQkFBaUIsRUFBRSxJQUFJO0lBQ3ZCLGdCQUFnQixFQUFFO1FBQ2hCLFNBQVMsRUFBRSw4REFBOEQ7UUFDekUsWUFBWSxFQUFFLGdEQUFnRDtRQUM5RCxVQUFVLEVBQUUsK0RBQStEO0tBQzVFO0lBQ0QsYUFBYSxFQUFFO1FBQ2IsUUFBUSxFQUFFLElBQUk7UUFDZCxLQUFLLEVBQUUsSUFBSTtLQUNaO0lBQ0QsVUFBVSxFQUFFO1FBQ1YsS0FBSyxFQUFFLElBQUk7UUFDWCxLQUFLLEVBQUUsSUFBSTtLQUNaO0NBQ0YsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQXBwLCBTdGFjayB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgVXNlclBvb2wgfSBmcm9tICcuLi9saWInO1xuXG5jb25zdCBhcHAgPSBuZXcgQXBwKCk7XG5jb25zdCBzdGFjayA9IG5ldyBTdGFjayhhcHAsICdpbnRlZy11c2VyLXBvb2wnKTtcblxubmV3IFVzZXJQb29sKHN0YWNrLCAnbXl1c2VycG9vbCcsIHtcbiAgdXNlclBvb2xOYW1lOiAnTXlVc2VyUG9vbCcsXG4gIHVzZXJJbnZpdGF0aW9uOiB7XG4gICAgZW1haWxTdWJqZWN0OiAnaW52aXRhdGlvbiBlbWFpbCBzdWJqZWN0IGZyb20gdGhlIGludGVnIHRlc3QnLFxuICAgIGVtYWlsQm9keTogJ2ludml0YXRpb24gZW1haWwgYm9keSBmcm9tIHRoZSBpbnRlZyB0ZXN0IGZvciB7dXNlcm5hbWV9LiBUZW1wIHBhc3N3b3JkIGlzIHsjIyMjfS4nLFxuICAgIHNtc01lc3NhZ2U6ICdpbnZpdGF0aW9uIHNtcyBtZXNzYWdlIGZyb20gdGhlIGludGVnIHRlc3QgZm9yIHt1c2VybmFtZX0uIFRlbXAgcGFzc3dvcmQgaXMgeyMjIyN9LicsXG4gIH0sXG4gIHNlbGZTaWduVXBFbmFibGVkOiB0cnVlLFxuICB1c2VyVmVyaWZpY2F0aW9uOiB7XG4gICAgZW1haWxCb2R5OiAndmVyaWZpY2F0aW9uIGVtYWlsIGJvZHkgZnJvbSB0aGUgaW50ZWcgdGVzdC4gQ29kZSBpcyB7IyMjI30uJyxcbiAgICBlbWFpbFN1YmplY3Q6ICd2ZXJpZmljYXRpb24gZW1haWwgc3ViamVjdCBmcm9tIHRoZSBpbnRlZyB0ZXN0JyxcbiAgICBzbXNNZXNzYWdlOiAndmVyaWZpY2F0aW9uIHNtcyBtZXNzYWdlIGZyb20gdGhlIGludGVnIHRlc3QuIENvZGUgaXMgeyMjIyN9LicsXG4gIH0sXG4gIHNpZ25JbkFsaWFzZXM6IHtcbiAgICB1c2VybmFtZTogdHJ1ZSxcbiAgICBlbWFpbDogdHJ1ZSxcbiAgfSxcbiAgYXV0b1ZlcmlmeToge1xuICAgIGVtYWlsOiB0cnVlLFxuICAgIHBob25lOiB0cnVlLFxuICB9LFxufSk7Il19