import { Construct, Resource } from '@aws-cdk/core';
import { IUserPool } from './user-pool';
/**
 * Types of authentication flow
 */
export declare enum AuthFlow {
    /**
     * Enable flow for server-side or admin authentication (no client app)
     */
    ADMIN_NO_SRP = "ADMIN_NO_SRP_AUTH",
    /**
     * Enable custom authentication flow
     */
    CUSTOM_FLOW_ONLY = "CUSTOM_AUTH_FLOW_ONLY",
    /**
     * Enable auth using username & password
     */
    USER_PASSWORD = "USER_PASSWORD_AUTH"
}
export interface UserPoolClientProps {
    /**
     * Name of the application client
     * @default cloudformation generated name
     */
    readonly userPoolClientName?: string;
    /**
     * The UserPool resource this client will have access to
     */
    readonly userPool: IUserPool;
    /**
     * Whether to generate a client secret
     * @default false
     */
    readonly generateSecret?: boolean;
    /**
     * List of enabled authentication flows
     * @default no enabled flows
     */
    readonly enabledAuthFlows?: AuthFlow[];
}
/**
 * Define a UserPool App Client
 */
export declare class UserPoolClient extends Resource {
    /**
     * @attribute
     */
    readonly userPoolClientId: string;
    /**
     * @attribute
     */
    readonly userPoolClientName: string;
    /**
     * @attribute
     */
    readonly userPoolClientClientSecret: string;
    constructor(scope: Construct, id: string, props: UserPoolClientProps);
}
