# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from ._inputs import *

__all__ = ['AssumableRolesArgs', 'AssumableRoles']

@pulumi.input_type
class AssumableRolesArgs:
    def __init__(__self__, *,
                 admin: pulumi.Input['AdminRoleWithMFAArgs'],
                 force_detach_policies: Optional[pulumi.Input[bool]] = None,
                 max_session_duration: Optional[pulumi.Input[int]] = None,
                 mfa_age: Optional[pulumi.Input[int]] = None,
                 poweruser: Optional[pulumi.Input['PoweruserRoleWithMFAArgs']] = None,
                 readonly: Optional[pulumi.Input['ReadonlyRoleWithMFAArgs']] = None,
                 trusted_role_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 trusted_role_services: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AssumableRoles resource.
        :param pulumi.Input[bool] force_detach_policies: Whether policies should be detached from this role when destroying.
        :param pulumi.Input[int] max_session_duration: Maximum CLI/API session duration in seconds between 3600 and 43200.
        :param pulumi.Input[int] mfa_age: Max age of valid MFA (in seconds) for roles which require MFA.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] trusted_role_arns: ARNs of AWS entities who can assume these roles.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] trusted_role_services: AWS Services that can assume these roles.
        """
        pulumi.set(__self__, "admin", admin)
        if force_detach_policies is None:
            force_detach_policies = False
        if force_detach_policies is not None:
            pulumi.set(__self__, "force_detach_policies", force_detach_policies)
        if max_session_duration is None:
            max_session_duration = 3600
        if max_session_duration is not None:
            pulumi.set(__self__, "max_session_duration", max_session_duration)
        if mfa_age is None:
            mfa_age = 86400
        if mfa_age is not None:
            pulumi.set(__self__, "mfa_age", mfa_age)
        if poweruser is not None:
            pulumi.set(__self__, "poweruser", poweruser)
        if readonly is not None:
            pulumi.set(__self__, "readonly", readonly)
        if trusted_role_arns is not None:
            pulumi.set(__self__, "trusted_role_arns", trusted_role_arns)
        if trusted_role_services is not None:
            pulumi.set(__self__, "trusted_role_services", trusted_role_services)

    @property
    @pulumi.getter
    def admin(self) -> pulumi.Input['AdminRoleWithMFAArgs']:
        return pulumi.get(self, "admin")

    @admin.setter
    def admin(self, value: pulumi.Input['AdminRoleWithMFAArgs']):
        pulumi.set(self, "admin", value)

    @property
    @pulumi.getter(name="forceDetachPolicies")
    def force_detach_policies(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether policies should be detached from this role when destroying.
        """
        return pulumi.get(self, "force_detach_policies")

    @force_detach_policies.setter
    def force_detach_policies(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_detach_policies", value)

    @property
    @pulumi.getter(name="maxSessionDuration")
    def max_session_duration(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum CLI/API session duration in seconds between 3600 and 43200.
        """
        return pulumi.get(self, "max_session_duration")

    @max_session_duration.setter
    def max_session_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_session_duration", value)

    @property
    @pulumi.getter(name="mfaAge")
    def mfa_age(self) -> Optional[pulumi.Input[int]]:
        """
        Max age of valid MFA (in seconds) for roles which require MFA.
        """
        return pulumi.get(self, "mfa_age")

    @mfa_age.setter
    def mfa_age(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mfa_age", value)

    @property
    @pulumi.getter
    def poweruser(self) -> Optional[pulumi.Input['PoweruserRoleWithMFAArgs']]:
        return pulumi.get(self, "poweruser")

    @poweruser.setter
    def poweruser(self, value: Optional[pulumi.Input['PoweruserRoleWithMFAArgs']]):
        pulumi.set(self, "poweruser", value)

    @property
    @pulumi.getter
    def readonly(self) -> Optional[pulumi.Input['ReadonlyRoleWithMFAArgs']]:
        return pulumi.get(self, "readonly")

    @readonly.setter
    def readonly(self, value: Optional[pulumi.Input['ReadonlyRoleWithMFAArgs']]):
        pulumi.set(self, "readonly", value)

    @property
    @pulumi.getter(name="trustedRoleArns")
    def trusted_role_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        ARNs of AWS entities who can assume these roles.
        """
        return pulumi.get(self, "trusted_role_arns")

    @trusted_role_arns.setter
    def trusted_role_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "trusted_role_arns", value)

    @property
    @pulumi.getter(name="trustedRoleServices")
    def trusted_role_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        AWS Services that can assume these roles.
        """
        return pulumi.get(self, "trusted_role_services")

    @trusted_role_services.setter
    def trusted_role_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "trusted_role_services", value)


class AssumableRoles(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin: Optional[pulumi.Input[pulumi.InputType['AdminRoleWithMFAArgs']]] = None,
                 force_detach_policies: Optional[pulumi.Input[bool]] = None,
                 max_session_duration: Optional[pulumi.Input[int]] = None,
                 mfa_age: Optional[pulumi.Input[int]] = None,
                 poweruser: Optional[pulumi.Input[pulumi.InputType['PoweruserRoleWithMFAArgs']]] = None,
                 readonly: Optional[pulumi.Input[pulumi.InputType['ReadonlyRoleWithMFAArgs']]] = None,
                 trusted_role_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 trusted_role_services: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Create a AssumableRoles resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] force_detach_policies: Whether policies should be detached from this role when destroying.
        :param pulumi.Input[int] max_session_duration: Maximum CLI/API session duration in seconds between 3600 and 43200.
        :param pulumi.Input[int] mfa_age: Max age of valid MFA (in seconds) for roles which require MFA.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] trusted_role_arns: ARNs of AWS entities who can assume these roles.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] trusted_role_services: AWS Services that can assume these roles.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AssumableRolesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AssumableRoles resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AssumableRolesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AssumableRolesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin: Optional[pulumi.Input[pulumi.InputType['AdminRoleWithMFAArgs']]] = None,
                 force_detach_policies: Optional[pulumi.Input[bool]] = None,
                 max_session_duration: Optional[pulumi.Input[int]] = None,
                 mfa_age: Optional[pulumi.Input[int]] = None,
                 poweruser: Optional[pulumi.Input[pulumi.InputType['PoweruserRoleWithMFAArgs']]] = None,
                 readonly: Optional[pulumi.Input[pulumi.InputType['ReadonlyRoleWithMFAArgs']]] = None,
                 trusted_role_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 trusted_role_services: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AssumableRolesArgs.__new__(AssumableRolesArgs)

            if admin is None and not opts.urn:
                raise TypeError("Missing required property 'admin'")
            __props__.__dict__["admin"] = admin
            if force_detach_policies is None:
                force_detach_policies = False
            __props__.__dict__["force_detach_policies"] = force_detach_policies
            if max_session_duration is None:
                max_session_duration = 3600
            __props__.__dict__["max_session_duration"] = max_session_duration
            if mfa_age is None:
                mfa_age = 86400
            __props__.__dict__["mfa_age"] = mfa_age
            __props__.__dict__["poweruser"] = poweruser
            __props__.__dict__["readonly"] = readonly
            __props__.__dict__["trusted_role_arns"] = trusted_role_arns
            __props__.__dict__["trusted_role_services"] = trusted_role_services
        super(AssumableRoles, __self__).__init__(
            'aws-iam:index:AssumableRoles',
            resource_name,
            __props__,
            opts,
            remote=True)

    @property
    @pulumi.getter
    def admin(self) -> pulumi.Output[Mapping[str, str]]:
        return pulumi.get(self, "admin")

    @property
    @pulumi.getter
    def poweruser(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "poweruser")

    @property
    @pulumi.getter
    def readonly(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "readonly")

