/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import weka.core.Instances;
import weka.core.WekaException;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.DataCollector;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="TextViewer", category="Visualization", toolTipText="View textual output", iconPath="weka/gui/knowledgeflow/icons/DefaultText.gif")
public class TextViewer
extends BaseStep
implements DataCollector {
    private static final long serialVersionUID = 8602416209256135064L;
    protected Map<String, String> m_results = new LinkedHashMap<String, String>();
    protected transient TextNotificationListener m_viewerListener;

    @Override
    public void stepInit() {
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        return Arrays.asList("text", "dataSet", "trainingSet", "testSet");
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        return this.getStepManager().numIncomingConnections() > 0 ? Arrays.asList("text") : new ArrayList<String>();
    }

    @Override
    public synchronized void processIncoming(Data data) throws WekaException {
        this.getStepManager().processing();
        String title = (String)data.getPayloadElement("aux_textTitle");
        if (title == null && (data.getConnectionName().equals("dataSet") || data.getConnectionName().equals("trainingSet") || data.getConnectionName().equals("testSet"))) {
            title = ((Instances)data.getPrimaryPayload()).relationName();
        }
        if (title != null) {
            this.getStepManager().logDetailed("Storing result: " + title);
        }
        String body = data.getPayloadElement(data.getConnectionName()).toString();
        Integer setNum = (Integer)data.getPayloadElement("aux_set_num");
        if (title != null && body != null) {
            String name = new SimpleDateFormat("HH:mm:ss.SSS - ").format(new Date());
            if (this.m_results.containsKey(name = name + title + (setNum != null ? " (" + setNum + ")" : ""))) {
                try {
                    Thread.sleep(5L);
                    name = new SimpleDateFormat("HH:mm:ss.SSS - ").format(new Date());
                    name = name + title + (setNum != null ? " (" + setNum + ")" : "");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.m_results.put(name, body);
            if (this.m_viewerListener != null) {
                this.m_viewerListener.acceptTextResult(name + title + (setNum != null ? " (" + setNum + ")" : ""), body);
            }
        }
        Data textData = new Data("text", body);
        textData.setPayloadElement("aux_textTitle", title);
        this.getStepManager().outputData(textData);
        this.getStepManager().finished();
    }

    @Override
    public Map<String, String> getInteractiveViewers() {
        LinkedHashMap<String, String> views = new LinkedHashMap<String, String>();
        if (this.m_viewerListener == null) {
            views.put("Show results", "weka.gui.knowledgeflow.steps.TextViewerInteractiveView");
        }
        return views;
    }

    public synchronized Map<String, String> getResults() {
        return this.m_results;
    }

    @Override
    public Object retrieveData() {
        return this.getResults();
    }

    @Override
    public void restoreData(Object data) {
        if (!(data instanceof Map)) {
            throw new IllegalArgumentException("Argument must be a Map");
        }
        this.m_results = (Map)data;
    }

    public void setTextNotificationListener(TextNotificationListener l) {
        this.m_viewerListener = l;
    }

    public void removeTextNotificationListener(TextNotificationListener l) {
        if (l == this.m_viewerListener) {
            this.m_viewerListener = null;
        }
    }

    public static interface TextNotificationListener {
        public void acceptTextResult(String var1, String var2);
    }
}

