/* * * * *
 *  AzTETmain_kw.hpp 
 *  Copyright (C) 2011, 2012 Rie Johnson, 2018 RGF-team
 *
 * This software may be modified and distributed under the terms
 * of the MIT license.  See the COPYING file for details.
 * * * * */

#ifndef _AZ_TET_MAIN_KW_HPP_
#define _AZ_TET_MAIN_KW_HPP_

#define kw_train         "train"
#define kw_train_test    "train_test"
#define kw_predict       "predict"
#define kw_batch_predict "batch_predict"
#define kw_train_predict "train_predict"
#define kw_features      "output_features"
#define kw_dump_model    "dump_model"
#define kw_feature_importances    "feature_importances"
#define help_train         "Train and save models to files."
#define help_train_test    "Train and test models.  Optionally models can be saved to files."
#define help_train_predict "Train models and save predictions on test data to files.  Models can also be saved to files."  
#define help_predict       "Apply a model saved by \"train\" to new data."
#define help_batch_predict "Apply several models to new data."
#define help_features      "Output features generated by tree ensembles."

#define kw_alg_name "algorithm="
#define kw_train_x_fn "train_x_fn="
#define kw_train_y_fn "train_y_fn="
#define kw_fdic_fn "x_name_fn="
#define kw_model_stem "model_fn_prefix="
#define kw_model_names_fn "model_names_fn="
#define kw_model_fn "model_fn="
#define kw_prev_model_fn "model_fn_for_warmstart="
#define kw_pred_fn "prediction_fn="
#define kw_pred_fn_suffix "pred_fn_suffix="
#define kw_fi_fn "feature_importances_fn="
#define kw_not_doLog "DontLog"
#define kw_doLog "Log"
#define kw_doDump "Dump"
#define kw_eval_fn "evaluation_fn=" 
#define kw_doAppend_eval "Append_evaluation"
#define kw_test_x_fn "test_x_fn="
#define kw_test_y_fn "test_y_fn="
#define kw_dw_fn "train_w_fn="
#define kw_doSaveLastModelOnly "SaveLastModelOnly"

#define kw_xv_doShuffle "ShuffleData"
#define kw_xv_num "num_xv="
#define kw_xv_fn "xv_fn="
#define kw_input_x_fn "input_x_fn="
#define kw_output_x_fn "output_x_fn="
#define kw_features_digits "features_digits="
#define kw_doSparse_features "SparseFeatures"

#define help_train_x_fn "Path to the feature file of training data."
#define help_train_y_fn "Path to the target file of training data."
#define help_fi_fn "Path to the feature importance file to be saved."
#define help_fdic_fn    "Path to the file of feature names."
#define help_model_stem "To save models, path names are generated by attaching \"-01\", \"-02\",... to this value."
#define help_model_stem_tp "Path names to model files are generated by attaching \"-01\", \"-02\",... to this value.  Path names to prediction files and model info files are generated by attaching \".pred\" of \".info\" to the model path names." 
#define help_model_names_fn_out "Path to the file to write model path names to.  If omitted, model path names are not saved."
#define help_model_names_fn_inp "Path to the file to read model path names from."
#define help_model_fn   "Path to the model file to be tested"
#define help_prev_model_fn "Path to the input model file from which training should do warm-start."
#define help_prev_model_fn_others "Path to the input model file from which training should do warm-start.  (WARNING) Some algorithms do not support warm-start and return error if this parameter is specified."
#define help_pred_fn_out  "Path to the file to write predictions to."
#define help_pred_fn_inp  "Path to the file to read predictions from."
#define help_pred_fn_suffix "The path names of the predictions files are generated by attaching this to the path names of the corresponding models."
#define help_not_doLog  "Suppress logging-purpose output to stdout."
#define help_doDump     "Enable dump to stderr for the verbose components." 
#define help_eval_fn    "Path to the file to write evaluation to."
#define help_doAppend_eval "Open the evaluation result file with append mode."
#define help_test_x_fn  "Path to the feature file of test data"
#define help_test_y_fn  "Path to the target file of test data"
#define help_dw_fn "Path to the file of user-defined weights assigned to training data points."
#define help_doSaveLastModelOnly "Save the last/largest model only."
#define help_doSaveLastModelOnly_traintest "Save the last/largest model only.  Referred to only when model_fn_suffix is specified."

#define help_input_x_fn "Path to the input feature file."
#define help_output_x_fn "Path to the output feature file."
#define help_features_digits "How many digits should be retained in the output."
#define help_doSparse_features "Write features in the sparse data format."

/* #define dflt_model_names_fn "model_list.txt" */
#define dflt_model_stem ""

#define Az_config "config"

#endif 
