"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArtifactType = void 0;
/**
 * Type of cloud artifact.
 */
var ArtifactType;
(function (ArtifactType) {
    /**
     * Stub required because of JSII.
     */
    ArtifactType["NONE"] = "none";
    /**
     * The artifact is an ROS stack.
     */
    ArtifactType["ALIYUN_ROS_STACK"] = "aliyun:ros:stack";
    /**
     * The artifact contains the CDK application's construct tree.
     */
    ArtifactType["CDK_TREE"] = "cdk:tree";
    /**
     * Manifest for all assets in the Cloud Assembly
     */
    ArtifactType["ASSET_MANIFEST"] = "cdk:asset-manifest";
    /**
     * Nested Cloud Assembly
     */
    ArtifactType["NESTED_CLOUD_ASSEMBLY"] = "cdk:cloud-assembly";
})(ArtifactType = exports.ArtifactType || (exports.ArtifactType = {}));
//# sourceMappingURL=data:application/json;base64,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