"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArtifactMetadataEntryType = void 0;
/**
 * Type of artifact metadata entry.
 */
var ArtifactMetadataEntryType;
(function (ArtifactMetadataEntryType) {
    /**
     * Metadata key used to print INFO-level messages by the toolkit when an app is syntheized.
     */
    ArtifactMetadataEntryType["INFO"] = "aliyun:ros:info";
    /**
     * Metadata key used to print WARNING-level messages by the toolkit when an app is syntheized.
     */
    ArtifactMetadataEntryType["WARN"] = "aliyun:ros:warning";
    /**
     * Metadata key used to print ERROR-level messages by the toolkit when an app is syntheized.
     */
    ArtifactMetadataEntryType["ERROR"] = "aliyun:ros:error";
    /**
     * Represents the ROS logical ID of a resource at a certain path.
     */
    ArtifactMetadataEntryType["LOGICAL_ID"] = "aliyun:ros:logicalId";
    /**
     * Represents tags of a stack.
     */
    ArtifactMetadataEntryType["STACK_TAGS"] = "aliyun:ros:stack-tags";
})(ArtifactMetadataEntryType = exports.ArtifactMetadataEntryType || (exports.ArtifactMetadataEntryType = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWV0YWRhdGEtc2NoZW1hLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsibWV0YWRhdGEtc2NoZW1hLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQTJDQTs7R0FFRztBQUNILElBQVkseUJBeUJYO0FBekJELFdBQVkseUJBQXlCO0lBQ25DOztPQUVHO0lBQ0gscURBQXdCLENBQUE7SUFFeEI7O09BRUc7SUFDSCx3REFBMkIsQ0FBQTtJQUUzQjs7T0FFRztJQUNILHVEQUEwQixDQUFBO0lBRTFCOztPQUVHO0lBQ0gsZ0VBQW1DLENBQUE7SUFFbkM7O09BRUc7SUFDSCxpRUFBb0MsQ0FBQTtBQUN0QyxDQUFDLEVBekJXLHlCQUF5QixHQUF6QixpQ0FBeUIsS0FBekIsaUNBQXlCLFFBeUJwQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxyXG4gKiBNZXRhZGF0YSBFbnRyeSBzcGVjIGZvciBzdGFjayB0YWcuXHJcbiAqL1xyXG5leHBvcnQgaW50ZXJmYWNlIFRhZyB7XHJcbiAgLyoqXHJcbiAgICogVGFnIGtleS5cclxuICAgKi9cclxuICByZWFkb25seSBrZXk6IHN0cmluZztcclxuXHJcbiAgLyoqXHJcbiAgICogVGFnIHZhbHVlLlxyXG4gICAqL1xyXG4gIHJlYWRvbmx5IHZhbHVlOiBzdHJpbmc7XHJcbn1cclxuXHJcbi8vIFR5cGUgYWxpYXNlcyBmb3IgbWV0YWRhdGEgZW50cmllcy5cclxuLy8gVXNlZCBzaW1wbHkgdG8gYXNzaWduIG5hbWVzIHRvIGRhdGEgdHlwZXMgZm9yIG1vcmUgY2xhcml0eS5cclxuXHJcbi8qKlxyXG4gKiBAc2VlIEFydGlmYWN0TWV0YWRhdGFFbnRyeVR5cGUuSU5GT1xyXG4gKiBAc2VlIEFydGlmYWN0TWV0YWRhdGFFbnRyeVR5cGUuV0FSTlxyXG4gKiBAc2VlIEFydGlmYWN0TWV0YWRhdGFFbnRyeVR5cGUuRVJST1JcclxuICovXHJcbmV4cG9ydCB0eXBlIExvZ01lc3NhZ2VNZXRhZGF0YUVudHJ5ID0gc3RyaW5nO1xyXG5cclxuLyoqXHJcbiAqIEBzZWUgQXJ0aWZhY3RNZXRhZGF0YUVudHJ5VHlwZS5MT0dJQ0FMX0lEXHJcbiAqL1xyXG5leHBvcnQgdHlwZSBMb2dpY2FsSWRNZXRhZGF0YUVudHJ5ID0gc3RyaW5nO1xyXG5cclxuLyoqXHJcbiAqIEBzZWUgQXJ0aWZhY3RNZXRhZGF0YUVudHJ5VHlwZS5TVEFDS19UQUdTXHJcbiAqL1xyXG5leHBvcnQgdHlwZSBTdGFja1RhZ3NNZXRhZGF0YUVudHJ5ID0gVGFnW107XHJcblxyXG4vKipcclxuICogVW5pb24gdHlwZSBmb3IgYWxsIG1ldGFkYXRhIGVudHJpZXMgdGhhdCBtaWdodCBleGlzdCBpbiB0aGUgbWFuaWZlc3QuXHJcbiAqL1xyXG5leHBvcnQgdHlwZSBNZXRhZGF0YUVudHJ5RGF0YSA9XHJcbiAgfCBMb2dNZXNzYWdlTWV0YWRhdGFFbnRyeVxyXG4gIHwgTG9naWNhbElkTWV0YWRhdGFFbnRyeVxyXG4gIHwgU3RhY2tUYWdzTWV0YWRhdGFFbnRyeTtcclxuXHJcbi8qKlxyXG4gKiBUeXBlIG9mIGFydGlmYWN0IG1ldGFkYXRhIGVudHJ5LlxyXG4gKi9cclxuZXhwb3J0IGVudW0gQXJ0aWZhY3RNZXRhZGF0YUVudHJ5VHlwZSB7XHJcbiAgLyoqXHJcbiAgICogTWV0YWRhdGEga2V5IHVzZWQgdG8gcHJpbnQgSU5GTy1sZXZlbCBtZXNzYWdlcyBieSB0aGUgdG9vbGtpdCB3aGVuIGFuIGFwcCBpcyBzeW50aGVpemVkLlxyXG4gICAqL1xyXG4gIElORk8gPSBcImFsaXl1bjpyb3M6aW5mb1wiLFxyXG5cclxuICAvKipcclxuICAgKiBNZXRhZGF0YSBrZXkgdXNlZCB0byBwcmludCBXQVJOSU5HLWxldmVsIG1lc3NhZ2VzIGJ5IHRoZSB0b29sa2l0IHdoZW4gYW4gYXBwIGlzIHN5bnRoZWl6ZWQuXHJcbiAgICovXHJcbiAgV0FSTiA9IFwiYWxpeXVuOnJvczp3YXJuaW5nXCIsXHJcblxyXG4gIC8qKlxyXG4gICAqIE1ldGFkYXRhIGtleSB1c2VkIHRvIHByaW50IEVSUk9SLWxldmVsIG1lc3NhZ2VzIGJ5IHRoZSB0b29sa2l0IHdoZW4gYW4gYXBwIGlzIHN5bnRoZWl6ZWQuXHJcbiAgICovXHJcbiAgRVJST1IgPSBcImFsaXl1bjpyb3M6ZXJyb3JcIixcclxuXHJcbiAgLyoqXHJcbiAgICogUmVwcmVzZW50cyB0aGUgUk9TIGxvZ2ljYWwgSUQgb2YgYSByZXNvdXJjZSBhdCBhIGNlcnRhaW4gcGF0aC5cclxuICAgKi9cclxuICBMT0dJQ0FMX0lEID0gXCJhbGl5dW46cm9zOmxvZ2ljYWxJZFwiLFxyXG5cclxuICAvKipcclxuICAgKiBSZXByZXNlbnRzIHRhZ3Mgb2YgYSBzdGFjay5cclxuICAgKi9cclxuICBTVEFDS19UQUdTID0gXCJhbGl5dW46cm9zOnN0YWNrLXRhZ3NcIixcclxufVxyXG5cclxuLyoqXHJcbiAqIEEgbWV0YWRhdGEgZW50cnkgaW4gYSBjbG91ZCBhc3NlbWJseSBhcnRpZmFjdC5cclxuICovXHJcbmV4cG9ydCBpbnRlcmZhY2UgTWV0YWRhdGFFbnRyeSB7XHJcbiAgLyoqXHJcbiAgICogVGhlIHR5cGUgb2YgdGhlIG1ldGFkYXRhIGVudHJ5LlxyXG4gICAqL1xyXG4gIHJlYWRvbmx5IHR5cGU6IHN0cmluZztcclxuXHJcbiAgLyoqXHJcbiAgICogVGhlIGRhdGEuXHJcbiAgICpcclxuICAgKiBAZGVmYXVsdCAtIG5vIGRhdGEuXHJcbiAgICovXHJcbiAgcmVhZG9ubHkgZGF0YT86IE1ldGFkYXRhRW50cnlEYXRhO1xyXG5cclxuICAvKipcclxuICAgKiBBIHN0YWNrIHRyYWNlIGZvciB3aGVuIHRoZSBlbnRyeSB3YXMgY3JlYXRlZC5cclxuICAgKlxyXG4gICAqIEBkZWZhdWx0IC0gbm8gdHJhY2UuXHJcbiAgICovXHJcbiAgcmVhZG9ubHkgdHJhY2U/OiBzdHJpbmdbXTtcclxufVxyXG4iXX0=