# Copyright (c) Microsoft. All rights reserved.

from typing import Literal, Union, get_args

AZURE_CHAT_MESSAGE_CONTENT_TYPE = Literal["AzureChatMessageContent"]
OPENAI_CHAT_MESSAGE_CONTENT_TYPE = Literal["OpenAIChatMessageContent"]
CHAT_MESSAGE_CONTENT_TYPE = Literal["ChatMessageContent"]

AZURE_CHAT_MESSAGE_CONTENT: AZURE_CHAT_MESSAGE_CONTENT_TYPE = get_args(AZURE_CHAT_MESSAGE_CONTENT_TYPE)[0]
OPENAI_CHAT_MESSAGE_CONTENT: OPENAI_CHAT_MESSAGE_CONTENT_TYPE = get_args(OPENAI_CHAT_MESSAGE_CONTENT_TYPE)[0]
CHAT_MESSAGE_CONTENT: CHAT_MESSAGE_CONTENT_TYPE = get_args(CHAT_MESSAGE_CONTENT_TYPE)[0]

CHAT_MESSAGE_CONTENT_TYPE_NAMES = Union[
    CHAT_MESSAGE_CONTENT_TYPE, OPENAI_CHAT_MESSAGE_CONTENT_TYPE, AZURE_CHAT_MESSAGE_CONTENT_TYPE
]
