"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateTestDistro = void 0;
const core_1 = require("@aws-solutions-constructs/core");
const cloudfront = require("aws-cdk-lib/aws-cloudfront");
const origins = require("aws-cdk-lib/aws-cloudfront-origins");
function CreateTestDistro(stack, id) {
    const newDistro = new cloudfront.Distribution(stack, id, {
        defaultBehavior: {
            origin: new origins.OriginGroup({
                primaryOrigin: new origins.HttpOrigin("www.example.com"),
                fallbackOrigin: new origins.HttpOrigin("admin.example.com"),
                // optional, defaults to: 500, 502, 503 and 504
                fallbackStatusCodes: [404],
            }),
        },
    });
    core_1.addCfnSuppressRules(newDistro, [{ id: "W10", reason: "Test Resource" }]);
    core_1.addCfnSuppressRules(newDistro, [{ id: "W70", reason: "Test Resource" }]);
    return newDistro;
}
exports.CreateTestDistro = CreateTestDistro;
//# sourceMappingURL=data:application/json;base64,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