# -*- coding: utf-8 -*-
# Generated by Django 1.11.26 on 2019-12-08 20:37
from __future__ import unicode_literals

import datetime
from django.db import migrations, models
from django.utils.timezone import utc
import enumfields.fields
import jsonfield.fields
import security.enums


class Migration(migrations.Migration):
    dependencies = [
        ('security', '0019_migration'),
    ]

    operations = [
        migrations.CreateModel(
            name='CeleryTaskRunLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('celery_task_id', models.CharField(db_index=True, max_length=250, verbose_name='celery ID')),
                ('start', models.DateTimeField(blank=True, null=True, verbose_name='start')),
                ('stop', models.DateTimeField(blank=True, null=True, verbose_name='stop')),
                ('state', enumfields.fields.NumEnumField(default=1, enum=security.enums.CeleryTaskRunLogState,
                                                         verbose_name='state')),
                ('name', models.CharField(max_length=250, verbose_name='task name')),
                ('task_args',
                 jsonfield.fields.JSONField(blank=True, editable=False, null=True, verbose_name='task args')),
                ('task_kwargs',
                 jsonfield.fields.JSONField(blank=True, editable=False, null=True, verbose_name='task kwargs')),
                ('result', jsonfield.fields.JSONField(blank=True, editable=False, null=True, verbose_name='result')),
                ('error_message', models.TextField(blank=True, null=True, verbose_name='error message')),
                ('output', models.TextField(blank=True, editable=False, null=True, verbose_name='output')),
                ('retries', models.PositiveSmallIntegerField(default=0, verbose_name='retries')),
                ('estimated_time_of_next_retry',
                 models.DateTimeField(blank=True, null=True, verbose_name='estimated time of arrival')),
            ],
            options={
                'verbose_name': 'celery task run',
                'verbose_name_plural': 'celery tasks run',
                'ordering': ('created_at',),
            },
        ),
        migrations.AlterModelOptions(
            name='celerytasklog',
            options={'ordering': ('-created_at',), 'verbose_name': 'celery task',
                     'verbose_name_plural': 'celery tasks'},
        ),
        migrations.AddField(
            model_name='celerytasklog',
            name='estimated_time_of_first_arrival',
            field=models.DateTimeField(default=datetime.datetime(2019, 12, 8, 20, 37, 13, 372524, tzinfo=utc),
                                       verbose_name='estimated time of first arrival'),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='celerytasklog',
            name='is_set_as_stale',
            field=models.BooleanField(default=False, verbose_name='set as stale'),
        ),
        migrations.AlterField(
            model_name='celerytasklog',
            name='celery_task_id',
            field=models.CharField(db_index=True, max_length=250, verbose_name='celery ID')
        ),
        migrations.AlterField(
            model_name='celerytasklog',
            name='task_args',
            field=jsonfield.fields.JSONField(blank=True, editable=False, null=True, verbose_name='task args'),
        ),
        migrations.AlterField(
            model_name='celerytasklog',
            name='task_kwargs',
            field=jsonfield.fields.JSONField(blank=True, editable=False, null=True, verbose_name='task kwargs'),
        ),
        migrations.AlterUniqueTogether(
            name='celerytasklog',
            unique_together=set([]),
        ),
        migrations.RemoveField(
            model_name='celerytasklog',
            name='error_message',
        ),
        migrations.RemoveField(
            model_name='celerytasklog',
            name='estimated_time_of_arrival',
        ),
        migrations.RemoveField(
            model_name='celerytasklog',
            name='output',
        ),
        migrations.RemoveField(
            model_name='celerytasklog',
            name='retries',
        ),
        migrations.RemoveField(
            model_name='celerytasklog',
            name='start',
        ),
        migrations.RemoveField(
            model_name='celerytasklog',
            name='state',
        ),
        migrations.RemoveField(
            model_name='celerytasklog',
            name='stop',
        ),
    ]
