# This file was auto-generated by Fern from our API Definition.

import typing
from ..core.client_wrapper import SyncClientWrapper
from ..types.block_input import BlockInput
from ..core.request_options import RequestOptions
from ..types.src_handlers_create_workflow_revision_response import SrcHandlersCreateWorkflowRevisionResponse
from ..core.unchecked_base_model import construct_type
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from ..types.src_handlers_list_workflows_response import SrcHandlersListWorkflowsResponse
from ..types.src_handlers_create_workflow_response import SrcHandlersCreateWorkflowResponse
from ..types.src_handlers_get_workflow_response import SrcHandlersGetWorkflowResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..types.src_handlers_update_workflow_response import SrcHandlersUpdateWorkflowResponse
from ..types.src_handlers_delete_workflow_response import SrcHandlersDeleteWorkflowResponse
from .types.workflows_run_stream_request_inputs_value import WorkflowsRunStreamRequestInputsValue
from ..types.workflow_run_stream_response import WorkflowRunStreamResponse
import httpx_sse
import json
from .types.workflows_run_request_inputs_value import WorkflowsRunRequestInputsValue
from ..types.workflow_run_response import WorkflowRunResponse
from ..types.workflow_config_input import WorkflowConfigInput
from .types.src_handlers_workflows_execute_with_config_req_body_inputs_value import (
    SrcHandlersWorkflowsExecuteWithConfigReqBodyInputsValue,
)
from .types.workflows_run_with_config_response import WorkflowsRunWithConfigResponse
from ..core.client_wrapper import AsyncClientWrapper

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class WorkflowsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create_revision(
        self,
        *,
        workflow_id: typing.Optional[str] = None,
        workflow_key: typing.Optional[str] = None,
        workflow_display_name: typing.Optional[str] = OMIT,
        workflow_schema_version: typing.Optional[str] = OMIT,
        workflow_img_url: typing.Optional[str] = OMIT,
        workflow_description: typing.Optional[str] = OMIT,
        blocks: typing.Optional[typing.Sequence[BlockInput]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SrcHandlersCreateWorkflowRevisionResponse:
        """
        Parameters
        ----------
        workflow_id : typing.Optional[str]

        workflow_key : typing.Optional[str]

        workflow_display_name : typing.Optional[str]

        workflow_schema_version : typing.Optional[str]

        workflow_img_url : typing.Optional[str]

        workflow_description : typing.Optional[str]

        blocks : typing.Optional[typing.Sequence[BlockInput]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SrcHandlersCreateWorkflowRevisionResponse
            Successful Response

        Examples
        --------
        from scoutos import Scout

        client = Scout(
            api_key="YOUR_API_KEY",
        )
        client.workflows.create_revision()
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/workflows/revisions",
            method="POST",
            params={
                "workflow_id": workflow_id,
                "workflow_key": workflow_key,
            },
            json={
                "workflow_display_name": workflow_display_name,
                "workflow_schema_version": workflow_schema_version,
                "workflow_img_url": workflow_img_url,
                "workflow_description": workflow_description,
                "blocks": blocks,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SrcHandlersCreateWorkflowRevisionResponse,
                    construct_type(
                        type_=SrcHandlersCreateWorkflowRevisionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def list(
        self,
        *,
        sort: typing.Optional[str] = None,
        direction: typing.Optional[str] = None,
        start_at: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        query: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SrcHandlersListWorkflowsResponse:
        """
        List all workflows in the organization

        Parameters
        ----------
        sort : typing.Optional[str]
            Field to sort by

        direction : typing.Optional[str]
            Sort in ascending or descending order

        start_at : typing.Optional[str]
            created_at to start at

        limit : typing.Optional[int]
            Limit of records to return

        query : typing.Optional[str]
            Search query

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SrcHandlersListWorkflowsResponse
            Successful Response

        Examples
        --------
        from scoutos import Scout

        client = Scout(
            api_key="YOUR_API_KEY",
        )
        client.workflows.list()
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/workflows",
            method="GET",
            params={
                "sort": sort,
                "direction": direction,
                "start_at": start_at,
                "limit": limit,
                "query": query,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SrcHandlersListWorkflowsResponse,
                    construct_type(
                        type_=SrcHandlersListWorkflowsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create(
        self,
        *,
        workflow_key: typing.Optional[str] = None,
        workflow_display_name: typing.Optional[str] = OMIT,
        workflow_schema_version: typing.Optional[str] = OMIT,
        workflow_img_url: typing.Optional[str] = OMIT,
        workflow_description: typing.Optional[str] = OMIT,
        blocks: typing.Optional[typing.Sequence[BlockInput]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SrcHandlersCreateWorkflowResponse:
        """
        Parameters
        ----------
        workflow_key : typing.Optional[str]
            A unique key to identify the workflow

        workflow_display_name : typing.Optional[str]

        workflow_schema_version : typing.Optional[str]

        workflow_img_url : typing.Optional[str]

        workflow_description : typing.Optional[str]

        blocks : typing.Optional[typing.Sequence[BlockInput]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SrcHandlersCreateWorkflowResponse
            Successful Response

        Examples
        --------
        from scoutos import Scout

        client = Scout(
            api_key="YOUR_API_KEY",
        )
        client.workflows.create()
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/workflows",
            method="POST",
            params={
                "workflow_key": workflow_key,
            },
            json={
                "workflow_display_name": workflow_display_name,
                "workflow_schema_version": workflow_schema_version,
                "workflow_img_url": workflow_img_url,
                "workflow_description": workflow_description,
                "blocks": blocks,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SrcHandlersCreateWorkflowResponse,
                    construct_type(
                        type_=SrcHandlersCreateWorkflowResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get(
        self, workflow_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SrcHandlersGetWorkflowResponse:
        """
        Fetch app configuration by ID.

        Parameters
        ----------
        workflow_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SrcHandlersGetWorkflowResponse
            Successful Response

        Examples
        --------
        from scoutos import Scout

        client = Scout(
            api_key="YOUR_API_KEY",
        )
        client.workflows.get(
            workflow_id="workflow_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/workflows/{jsonable_encoder(workflow_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SrcHandlersGetWorkflowResponse,
                    construct_type(
                        type_=SrcHandlersGetWorkflowResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update(
        self,
        workflow_id: str,
        *,
        workflow_display_name: typing.Optional[str] = OMIT,
        workflow_schema_version: typing.Optional[str] = OMIT,
        workflow_img_url: typing.Optional[str] = OMIT,
        workflow_description: typing.Optional[str] = OMIT,
        blocks: typing.Optional[typing.Sequence[BlockInput]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SrcHandlersUpdateWorkflowResponse:
        """
        Parameters
        ----------
        workflow_id : str

        workflow_display_name : typing.Optional[str]

        workflow_schema_version : typing.Optional[str]

        workflow_img_url : typing.Optional[str]

        workflow_description : typing.Optional[str]

        blocks : typing.Optional[typing.Sequence[BlockInput]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SrcHandlersUpdateWorkflowResponse
            Successful Response

        Examples
        --------
        from scoutos import Scout

        client = Scout(
            api_key="YOUR_API_KEY",
        )
        client.workflows.update(
            workflow_id="workflow_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/workflows/{jsonable_encoder(workflow_id)}",
            method="PUT",
            json={
                "workflow_display_name": workflow_display_name,
                "workflow_schema_version": workflow_schema_version,
                "workflow_img_url": workflow_img_url,
                "workflow_description": workflow_description,
                "blocks": blocks,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SrcHandlersUpdateWorkflowResponse,
                    construct_type(
                        type_=SrcHandlersUpdateWorkflowResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def delete(
        self, workflow_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SrcHandlersDeleteWorkflowResponse:
        """
        Parameters
        ----------
        workflow_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SrcHandlersDeleteWorkflowResponse
            Successful Response

        Examples
        --------
        from scoutos import Scout

        client = Scout(
            api_key="YOUR_API_KEY",
        )
        client.workflows.delete(
            workflow_id="workflow_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/workflows/{jsonable_encoder(workflow_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SrcHandlersDeleteWorkflowResponse,
                    construct_type(
                        type_=SrcHandlersDeleteWorkflowResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def run_stream(
        self,
        workflow_id: str,
        *,
        environment: typing.Optional[str] = None,
        revision_id: typing.Optional[str] = None,
        session_id: typing.Optional[str] = None,
        inputs: typing.Optional[typing.Dict[str, WorkflowsRunStreamRequestInputsValue]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[WorkflowRunStreamResponse]:
        """
        Parameters
        ----------
        workflow_id : str

        environment : typing.Optional[str]
            Specifies the execution environment for the workflow. The available environments include:

            - `production`: The production environment, where workflows are executed under live conditions.
            - `staging`: A staging environment used for testing prior to production deployment.
            - `development`: A development environment used for testing new changes.
            - `console`: The console environment, runs latest changes on a workflow.

        revision_id : typing.Optional[str]

        session_id : typing.Optional[str]

        inputs : typing.Optional[typing.Dict[str, WorkflowsRunStreamRequestInputsValue]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.Iterator[WorkflowRunStreamResponse]


        Examples
        --------
        from scoutos import Scout

        client = Scout(
            api_key="YOUR_API_KEY",
        )
        response = client.workflows.run_stream(
            workflow_id="string",
            environment="string",
            revision_id="string",
            session_id="string",
            inputs={"string": True},
        )
        for chunk in response:
            yield chunk
        """
        with self._client_wrapper.httpx_client.stream(
            f"v2/workflows/{jsonable_encoder(workflow_id)}/execute",
            method="POST",
            params={
                "environment": environment,
                "revision_id": revision_id,
                "session_id": session_id,
            },
            json={
                "inputs": inputs,
                "streaming": True,
            },
            request_options=request_options,
            omit=OMIT,
        ) as _response:
            try:
                if 200 <= _response.status_code < 300:
                    _event_source = httpx_sse.EventSource(_response)
                    for _sse in _event_source.iter_sse():
                        try:
                            yield typing.cast(
                                WorkflowRunStreamResponse,
                                construct_type(
                                    type_=WorkflowRunStreamResponse,  # type: ignore
                                    object_=json.loads(_sse.data),
                                ),
                            )
                        except:
                            pass
                    return
                _response.read()
                if _response.status_code == 422:
                    raise UnprocessableEntityError(
                        typing.cast(
                            HttpValidationError,
                            construct_type(
                                type_=HttpValidationError,  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                _response_json = _response.json()
            except JSONDecodeError:
                raise ApiError(status_code=_response.status_code, body=_response.text)
            raise ApiError(status_code=_response.status_code, body=_response_json)

    def run(
        self,
        workflow_id: str,
        *,
        environment: typing.Optional[str] = None,
        revision_id: typing.Optional[str] = None,
        session_id: typing.Optional[str] = None,
        inputs: typing.Optional[typing.Dict[str, WorkflowsRunRequestInputsValue]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowRunResponse:
        """
        Parameters
        ----------
        workflow_id : str

        environment : typing.Optional[str]
            Specifies the execution environment for the workflow. The available environments include:

            - `production`: The production environment, where workflows are executed under live conditions.
            - `staging`: A staging environment used for testing prior to production deployment.
            - `development`: A development environment used for testing new changes.
            - `console`: The console environment, runs latest changes on a workflow.

        revision_id : typing.Optional[str]

        session_id : typing.Optional[str]

        inputs : typing.Optional[typing.Dict[str, WorkflowsRunRequestInputsValue]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowRunResponse


        Examples
        --------
        from scoutos import Scout

        client = Scout(
            api_key="YOUR_API_KEY",
        )
        client.workflows.run(
            workflow_id="workflow_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/workflows/{jsonable_encoder(workflow_id)}/execute",
            method="POST",
            params={
                "environment": environment,
                "revision_id": revision_id,
                "session_id": session_id,
            },
            json={
                "inputs": inputs,
                "streaming": False,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    WorkflowRunResponse,
                    construct_type(
                        type_=WorkflowRunResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def run_with_config(
        self,
        *,
        workflow_config: WorkflowConfigInput,
        environment: typing.Optional[str] = None,
        revision_id: typing.Optional[str] = None,
        session_id: typing.Optional[str] = None,
        workflow_key: typing.Optional[str] = OMIT,
        inputs: typing.Optional[typing.Dict[str, SrcHandlersWorkflowsExecuteWithConfigReqBodyInputsValue]] = OMIT,
        streaming: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowsRunWithConfigResponse:
        """
        Parameters
        ----------
        workflow_config : WorkflowConfigInput

        environment : typing.Optional[str]
            Specifies the execution environment for the workflow. The available environments include:

            - `production`: The production environment, where workflows are executed under live conditions.
            - `staging`: A staging environment used for testing prior to production deployment.
            - `development`: A development environment used for testing new changes.
            - `console`: The console environment, runs latest changes on a workflow.

        revision_id : typing.Optional[str]

        session_id : typing.Optional[str]

        workflow_key : typing.Optional[str]

        inputs : typing.Optional[typing.Dict[str, SrcHandlersWorkflowsExecuteWithConfigReqBodyInputsValue]]

        streaming : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowsRunWithConfigResponse
            Successful Response

        Examples
        --------
        from scoutos import Scout, WorkflowConfigInput

        client = Scout(
            api_key="YOUR_API_KEY",
        )
        client.workflows.run_with_config(
            workflow_config=WorkflowConfigInput(),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/workflows/execute",
            method="POST",
            params={
                "environment": environment,
                "revision_id": revision_id,
                "session_id": session_id,
            },
            json={
                "workflow_key": workflow_key,
                "inputs": inputs,
                "streaming": streaming,
                "workflow_config": workflow_config,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    WorkflowsRunWithConfigResponse,
                    construct_type(
                        type_=WorkflowsRunWithConfigResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncWorkflowsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create_revision(
        self,
        *,
        workflow_id: typing.Optional[str] = None,
        workflow_key: typing.Optional[str] = None,
        workflow_display_name: typing.Optional[str] = OMIT,
        workflow_schema_version: typing.Optional[str] = OMIT,
        workflow_img_url: typing.Optional[str] = OMIT,
        workflow_description: typing.Optional[str] = OMIT,
        blocks: typing.Optional[typing.Sequence[BlockInput]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SrcHandlersCreateWorkflowRevisionResponse:
        """
        Parameters
        ----------
        workflow_id : typing.Optional[str]

        workflow_key : typing.Optional[str]

        workflow_display_name : typing.Optional[str]

        workflow_schema_version : typing.Optional[str]

        workflow_img_url : typing.Optional[str]

        workflow_description : typing.Optional[str]

        blocks : typing.Optional[typing.Sequence[BlockInput]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SrcHandlersCreateWorkflowRevisionResponse
            Successful Response

        Examples
        --------
        import asyncio

        from scoutos import AsyncScout

        client = AsyncScout(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflows.create_revision()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/workflows/revisions",
            method="POST",
            params={
                "workflow_id": workflow_id,
                "workflow_key": workflow_key,
            },
            json={
                "workflow_display_name": workflow_display_name,
                "workflow_schema_version": workflow_schema_version,
                "workflow_img_url": workflow_img_url,
                "workflow_description": workflow_description,
                "blocks": blocks,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SrcHandlersCreateWorkflowRevisionResponse,
                    construct_type(
                        type_=SrcHandlersCreateWorkflowRevisionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def list(
        self,
        *,
        sort: typing.Optional[str] = None,
        direction: typing.Optional[str] = None,
        start_at: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        query: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SrcHandlersListWorkflowsResponse:
        """
        List all workflows in the organization

        Parameters
        ----------
        sort : typing.Optional[str]
            Field to sort by

        direction : typing.Optional[str]
            Sort in ascending or descending order

        start_at : typing.Optional[str]
            created_at to start at

        limit : typing.Optional[int]
            Limit of records to return

        query : typing.Optional[str]
            Search query

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SrcHandlersListWorkflowsResponse
            Successful Response

        Examples
        --------
        import asyncio

        from scoutos import AsyncScout

        client = AsyncScout(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflows.list()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/workflows",
            method="GET",
            params={
                "sort": sort,
                "direction": direction,
                "start_at": start_at,
                "limit": limit,
                "query": query,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SrcHandlersListWorkflowsResponse,
                    construct_type(
                        type_=SrcHandlersListWorkflowsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create(
        self,
        *,
        workflow_key: typing.Optional[str] = None,
        workflow_display_name: typing.Optional[str] = OMIT,
        workflow_schema_version: typing.Optional[str] = OMIT,
        workflow_img_url: typing.Optional[str] = OMIT,
        workflow_description: typing.Optional[str] = OMIT,
        blocks: typing.Optional[typing.Sequence[BlockInput]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SrcHandlersCreateWorkflowResponse:
        """
        Parameters
        ----------
        workflow_key : typing.Optional[str]
            A unique key to identify the workflow

        workflow_display_name : typing.Optional[str]

        workflow_schema_version : typing.Optional[str]

        workflow_img_url : typing.Optional[str]

        workflow_description : typing.Optional[str]

        blocks : typing.Optional[typing.Sequence[BlockInput]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SrcHandlersCreateWorkflowResponse
            Successful Response

        Examples
        --------
        import asyncio

        from scoutos import AsyncScout

        client = AsyncScout(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflows.create()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/workflows",
            method="POST",
            params={
                "workflow_key": workflow_key,
            },
            json={
                "workflow_display_name": workflow_display_name,
                "workflow_schema_version": workflow_schema_version,
                "workflow_img_url": workflow_img_url,
                "workflow_description": workflow_description,
                "blocks": blocks,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SrcHandlersCreateWorkflowResponse,
                    construct_type(
                        type_=SrcHandlersCreateWorkflowResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get(
        self, workflow_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SrcHandlersGetWorkflowResponse:
        """
        Fetch app configuration by ID.

        Parameters
        ----------
        workflow_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SrcHandlersGetWorkflowResponse
            Successful Response

        Examples
        --------
        import asyncio

        from scoutos import AsyncScout

        client = AsyncScout(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflows.get(
                workflow_id="workflow_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/workflows/{jsonable_encoder(workflow_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SrcHandlersGetWorkflowResponse,
                    construct_type(
                        type_=SrcHandlersGetWorkflowResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update(
        self,
        workflow_id: str,
        *,
        workflow_display_name: typing.Optional[str] = OMIT,
        workflow_schema_version: typing.Optional[str] = OMIT,
        workflow_img_url: typing.Optional[str] = OMIT,
        workflow_description: typing.Optional[str] = OMIT,
        blocks: typing.Optional[typing.Sequence[BlockInput]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SrcHandlersUpdateWorkflowResponse:
        """
        Parameters
        ----------
        workflow_id : str

        workflow_display_name : typing.Optional[str]

        workflow_schema_version : typing.Optional[str]

        workflow_img_url : typing.Optional[str]

        workflow_description : typing.Optional[str]

        blocks : typing.Optional[typing.Sequence[BlockInput]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SrcHandlersUpdateWorkflowResponse
            Successful Response

        Examples
        --------
        import asyncio

        from scoutos import AsyncScout

        client = AsyncScout(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflows.update(
                workflow_id="workflow_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/workflows/{jsonable_encoder(workflow_id)}",
            method="PUT",
            json={
                "workflow_display_name": workflow_display_name,
                "workflow_schema_version": workflow_schema_version,
                "workflow_img_url": workflow_img_url,
                "workflow_description": workflow_description,
                "blocks": blocks,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SrcHandlersUpdateWorkflowResponse,
                    construct_type(
                        type_=SrcHandlersUpdateWorkflowResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def delete(
        self, workflow_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SrcHandlersDeleteWorkflowResponse:
        """
        Parameters
        ----------
        workflow_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SrcHandlersDeleteWorkflowResponse
            Successful Response

        Examples
        --------
        import asyncio

        from scoutos import AsyncScout

        client = AsyncScout(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflows.delete(
                workflow_id="workflow_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/workflows/{jsonable_encoder(workflow_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SrcHandlersDeleteWorkflowResponse,
                    construct_type(
                        type_=SrcHandlersDeleteWorkflowResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def run_stream(
        self,
        workflow_id: str,
        *,
        environment: typing.Optional[str] = None,
        revision_id: typing.Optional[str] = None,
        session_id: typing.Optional[str] = None,
        inputs: typing.Optional[typing.Dict[str, WorkflowsRunStreamRequestInputsValue]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[WorkflowRunStreamResponse]:
        """
        Parameters
        ----------
        workflow_id : str

        environment : typing.Optional[str]
            Specifies the execution environment for the workflow. The available environments include:

            - `production`: The production environment, where workflows are executed under live conditions.
            - `staging`: A staging environment used for testing prior to production deployment.
            - `development`: A development environment used for testing new changes.
            - `console`: The console environment, runs latest changes on a workflow.

        revision_id : typing.Optional[str]

        session_id : typing.Optional[str]

        inputs : typing.Optional[typing.Dict[str, WorkflowsRunStreamRequestInputsValue]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.AsyncIterator[WorkflowRunStreamResponse]


        Examples
        --------
        import asyncio

        from scoutos import AsyncScout

        client = AsyncScout(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.workflows.run_stream(
                workflow_id="string",
                environment="string",
                revision_id="string",
                session_id="string",
                inputs={"string": True},
            )
            async for chunk in response:
                yield chunk


        asyncio.run(main())
        """
        async with self._client_wrapper.httpx_client.stream(
            f"v2/workflows/{jsonable_encoder(workflow_id)}/execute",
            method="POST",
            params={
                "environment": environment,
                "revision_id": revision_id,
                "session_id": session_id,
            },
            json={
                "inputs": inputs,
                "streaming": True,
            },
            request_options=request_options,
            omit=OMIT,
        ) as _response:
            try:
                if 200 <= _response.status_code < 300:
                    _event_source = httpx_sse.EventSource(_response)
                    async for _sse in _event_source.aiter_sse():
                        try:
                            yield typing.cast(
                                WorkflowRunStreamResponse,
                                construct_type(
                                    type_=WorkflowRunStreamResponse,  # type: ignore
                                    object_=json.loads(_sse.data),
                                ),
                            )
                        except:
                            pass
                    return
                await _response.aread()
                if _response.status_code == 422:
                    raise UnprocessableEntityError(
                        typing.cast(
                            HttpValidationError,
                            construct_type(
                                type_=HttpValidationError,  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                _response_json = _response.json()
            except JSONDecodeError:
                raise ApiError(status_code=_response.status_code, body=_response.text)
            raise ApiError(status_code=_response.status_code, body=_response_json)

    async def run(
        self,
        workflow_id: str,
        *,
        environment: typing.Optional[str] = None,
        revision_id: typing.Optional[str] = None,
        session_id: typing.Optional[str] = None,
        inputs: typing.Optional[typing.Dict[str, WorkflowsRunRequestInputsValue]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowRunResponse:
        """
        Parameters
        ----------
        workflow_id : str

        environment : typing.Optional[str]
            Specifies the execution environment for the workflow. The available environments include:

            - `production`: The production environment, where workflows are executed under live conditions.
            - `staging`: A staging environment used for testing prior to production deployment.
            - `development`: A development environment used for testing new changes.
            - `console`: The console environment, runs latest changes on a workflow.

        revision_id : typing.Optional[str]

        session_id : typing.Optional[str]

        inputs : typing.Optional[typing.Dict[str, WorkflowsRunRequestInputsValue]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowRunResponse


        Examples
        --------
        import asyncio

        from scoutos import AsyncScout

        client = AsyncScout(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflows.run(
                workflow_id="workflow_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/workflows/{jsonable_encoder(workflow_id)}/execute",
            method="POST",
            params={
                "environment": environment,
                "revision_id": revision_id,
                "session_id": session_id,
            },
            json={
                "inputs": inputs,
                "streaming": False,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    WorkflowRunResponse,
                    construct_type(
                        type_=WorkflowRunResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def run_with_config(
        self,
        *,
        workflow_config: WorkflowConfigInput,
        environment: typing.Optional[str] = None,
        revision_id: typing.Optional[str] = None,
        session_id: typing.Optional[str] = None,
        workflow_key: typing.Optional[str] = OMIT,
        inputs: typing.Optional[typing.Dict[str, SrcHandlersWorkflowsExecuteWithConfigReqBodyInputsValue]] = OMIT,
        streaming: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowsRunWithConfigResponse:
        """
        Parameters
        ----------
        workflow_config : WorkflowConfigInput

        environment : typing.Optional[str]
            Specifies the execution environment for the workflow. The available environments include:

            - `production`: The production environment, where workflows are executed under live conditions.
            - `staging`: A staging environment used for testing prior to production deployment.
            - `development`: A development environment used for testing new changes.
            - `console`: The console environment, runs latest changes on a workflow.

        revision_id : typing.Optional[str]

        session_id : typing.Optional[str]

        workflow_key : typing.Optional[str]

        inputs : typing.Optional[typing.Dict[str, SrcHandlersWorkflowsExecuteWithConfigReqBodyInputsValue]]

        streaming : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowsRunWithConfigResponse
            Successful Response

        Examples
        --------
        import asyncio

        from scoutos import AsyncScout, WorkflowConfigInput

        client = AsyncScout(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflows.run_with_config(
                workflow_config=WorkflowConfigInput(),
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/workflows/execute",
            method="POST",
            params={
                "environment": environment,
                "revision_id": revision_id,
                "session_id": session_id,
            },
            json={
                "workflow_key": workflow_key,
                "inputs": inputs,
                "streaming": streaming,
                "workflow_config": workflow_config,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    WorkflowsRunWithConfigResponse,
                    construct_type(
                        type_=WorkflowsRunWithConfigResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
