# This file was auto-generated by Fern from our API Definition.

import typing
from ..core.client_wrapper import SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.src_handlers_get_workflow_environments_response import SrcHandlersGetWorkflowEnvironmentsResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.unchecked_base_model import construct_type
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from ..types.environment_deployment_config import EnvironmentDeploymentConfig
from ..types.src_handlers_update_workflow_environment_response import SrcHandlersUpdateWorkflowEnvironmentResponse
from ..core.client_wrapper import AsyncClientWrapper

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class EnvironmentsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self, workflow_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SrcHandlersGetWorkflowEnvironmentsResponse:
        """
        List all environments for a workflow in the organization

        Parameters
        ----------
        workflow_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SrcHandlersGetWorkflowEnvironmentsResponse
            Successful Response

        Examples
        --------
        from scoutos import Scout

        client = Scout(
            api_key="YOUR_API_KEY",
        )
        client.environments.list(
            workflow_id="workflow_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/workflows/{jsonable_encoder(workflow_id)}/environments",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SrcHandlersGetWorkflowEnvironmentsResponse,
                    construct_type(
                        type_=SrcHandlersGetWorkflowEnvironmentsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update(
        self,
        workflow_id: str,
        environment_id: str,
        *,
        name: str,
        description: str,
        deployments: typing.Sequence[EnvironmentDeploymentConfig],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SrcHandlersUpdateWorkflowEnvironmentResponse:
        """
        Update deployments within a workflow environment

        Parameters
        ----------
        workflow_id : str

        environment_id : str

        name : str

        description : str

        deployments : typing.Sequence[EnvironmentDeploymentConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SrcHandlersUpdateWorkflowEnvironmentResponse
            Successful Response

        Examples
        --------
        from scoutos import EnvironmentDeploymentConfig, Scout

        client = Scout(
            api_key="YOUR_API_KEY",
        )
        client.environments.update(
            workflow_id="workflow_id",
            environment_id="environment_id",
            name="name",
            description="description",
            deployments=[
                EnvironmentDeploymentConfig(
                    revision_lookup="latest",
                )
            ],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/workflows/{jsonable_encoder(workflow_id)}/environments/{jsonable_encoder(environment_id)}",
            method="PUT",
            json={
                "name": name,
                "description": description,
                "deployments": deployments,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SrcHandlersUpdateWorkflowEnvironmentResponse,
                    construct_type(
                        type_=SrcHandlersUpdateWorkflowEnvironmentResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncEnvironmentsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self, workflow_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SrcHandlersGetWorkflowEnvironmentsResponse:
        """
        List all environments for a workflow in the organization

        Parameters
        ----------
        workflow_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SrcHandlersGetWorkflowEnvironmentsResponse
            Successful Response

        Examples
        --------
        import asyncio

        from scoutos import AsyncScout

        client = AsyncScout(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.environments.list(
                workflow_id="workflow_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/workflows/{jsonable_encoder(workflow_id)}/environments",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SrcHandlersGetWorkflowEnvironmentsResponse,
                    construct_type(
                        type_=SrcHandlersGetWorkflowEnvironmentsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update(
        self,
        workflow_id: str,
        environment_id: str,
        *,
        name: str,
        description: str,
        deployments: typing.Sequence[EnvironmentDeploymentConfig],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SrcHandlersUpdateWorkflowEnvironmentResponse:
        """
        Update deployments within a workflow environment

        Parameters
        ----------
        workflow_id : str

        environment_id : str

        name : str

        description : str

        deployments : typing.Sequence[EnvironmentDeploymentConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SrcHandlersUpdateWorkflowEnvironmentResponse
            Successful Response

        Examples
        --------
        import asyncio

        from scoutos import AsyncScout, EnvironmentDeploymentConfig

        client = AsyncScout(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.environments.update(
                workflow_id="workflow_id",
                environment_id="environment_id",
                name="name",
                description="description",
                deployments=[
                    EnvironmentDeploymentConfig(
                        revision_lookup="latest",
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/workflows/{jsonable_encoder(workflow_id)}/environments/{jsonable_encoder(environment_id)}",
            method="PUT",
            json={
                "name": name,
                "description": description,
                "deployments": deployments,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SrcHandlersUpdateWorkflowEnvironmentResponse,
                    construct_type(
                        type_=SrcHandlersUpdateWorkflowEnvironmentResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
