# This file was auto-generated by Fern from our API Definition.

import typing
from ..core.client_wrapper import SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.collection_service_handlers_get_collections_response import CollectionServiceHandlersGetCollectionsResponse
from ..core.unchecked_base_model import construct_type
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from ..types.collection_service_handlers_create_collection_response import (
    CollectionServiceHandlersCreateCollectionResponse,
)
from ..types.collection_service_handlers_get_collection_response import CollectionServiceHandlersGetCollectionResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..types.collection_service_handlers_update_collection_response import (
    CollectionServiceHandlersUpdateCollectionResponse,
)
from ..types.collection_service_handlers_delete_collection_response import (
    CollectionServiceHandlersDeleteCollectionResponse,
)
from ..core.client_wrapper import AsyncClientWrapper

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CollectionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        start_at: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CollectionServiceHandlersGetCollectionsResponse:
        """
        Parameters
        ----------
        start_at : typing.Optional[str]
            created_at to start at

        limit : typing.Optional[int]
            Limit of records to return

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CollectionServiceHandlersGetCollectionsResponse
            Successful Response

        Examples
        --------
        from scoutos import Scout

        client = Scout(
            api_key="YOUR_API_KEY",
        )
        client.collections.list()
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/collections",
            method="GET",
            params={
                "start_at": start_at,
                "limit": limit,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    CollectionServiceHandlersGetCollectionsResponse,
                    construct_type(
                        type_=CollectionServiceHandlersGetCollectionsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create(
        self,
        *,
        collection_display_name: typing.Optional[str] = OMIT,
        collection_img_url: typing.Optional[str] = OMIT,
        collection_description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CollectionServiceHandlersCreateCollectionResponse:
        """
        Parameters
        ----------
        collection_display_name : typing.Optional[str]

        collection_img_url : typing.Optional[str]

        collection_description : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CollectionServiceHandlersCreateCollectionResponse
            Successful Response

        Examples
        --------
        from scoutos import Scout

        client = Scout(
            api_key="YOUR_API_KEY",
        )
        client.collections.create()
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/collections",
            method="POST",
            json={
                "collection_display_name": collection_display_name,
                "collection_img_url": collection_img_url,
                "collection_description": collection_description,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    CollectionServiceHandlersCreateCollectionResponse,
                    construct_type(
                        type_=CollectionServiceHandlersCreateCollectionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get(
        self, collection_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CollectionServiceHandlersGetCollectionResponse:
        """
        Parameters
        ----------
        collection_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CollectionServiceHandlersGetCollectionResponse
            Successful Response

        Examples
        --------
        from scoutos import Scout

        client = Scout(
            api_key="YOUR_API_KEY",
        )
        client.collections.get(
            collection_id="collection_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/collections/{jsonable_encoder(collection_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    CollectionServiceHandlersGetCollectionResponse,
                    construct_type(
                        type_=CollectionServiceHandlersGetCollectionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update(
        self,
        collection_id: str,
        *,
        collection_display_name: typing.Optional[str] = OMIT,
        collection_img_url: typing.Optional[str] = OMIT,
        collection_description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CollectionServiceHandlersUpdateCollectionResponse:
        """
        Parameters
        ----------
        collection_id : str

        collection_display_name : typing.Optional[str]

        collection_img_url : typing.Optional[str]

        collection_description : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CollectionServiceHandlersUpdateCollectionResponse
            Successful Response

        Examples
        --------
        from scoutos import Scout

        client = Scout(
            api_key="YOUR_API_KEY",
        )
        client.collections.update(
            collection_id="collection_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/collections/{jsonable_encoder(collection_id)}",
            method="PUT",
            json={
                "collection_display_name": collection_display_name,
                "collection_img_url": collection_img_url,
                "collection_description": collection_description,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    CollectionServiceHandlersUpdateCollectionResponse,
                    construct_type(
                        type_=CollectionServiceHandlersUpdateCollectionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def delete(
        self, collection_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CollectionServiceHandlersDeleteCollectionResponse:
        """
        Delete a collection given a collection_id.

        Parameters
        ----------
        collection_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CollectionServiceHandlersDeleteCollectionResponse
            Successful Response

        Examples
        --------
        from scoutos import Scout

        client = Scout(
            api_key="YOUR_API_KEY",
        )
        client.collections.delete(
            collection_id="collection_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/collections/{jsonable_encoder(collection_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    CollectionServiceHandlersDeleteCollectionResponse,
                    construct_type(
                        type_=CollectionServiceHandlersDeleteCollectionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncCollectionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        start_at: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CollectionServiceHandlersGetCollectionsResponse:
        """
        Parameters
        ----------
        start_at : typing.Optional[str]
            created_at to start at

        limit : typing.Optional[int]
            Limit of records to return

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CollectionServiceHandlersGetCollectionsResponse
            Successful Response

        Examples
        --------
        import asyncio

        from scoutos import AsyncScout

        client = AsyncScout(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.collections.list()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/collections",
            method="GET",
            params={
                "start_at": start_at,
                "limit": limit,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    CollectionServiceHandlersGetCollectionsResponse,
                    construct_type(
                        type_=CollectionServiceHandlersGetCollectionsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create(
        self,
        *,
        collection_display_name: typing.Optional[str] = OMIT,
        collection_img_url: typing.Optional[str] = OMIT,
        collection_description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CollectionServiceHandlersCreateCollectionResponse:
        """
        Parameters
        ----------
        collection_display_name : typing.Optional[str]

        collection_img_url : typing.Optional[str]

        collection_description : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CollectionServiceHandlersCreateCollectionResponse
            Successful Response

        Examples
        --------
        import asyncio

        from scoutos import AsyncScout

        client = AsyncScout(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.collections.create()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/collections",
            method="POST",
            json={
                "collection_display_name": collection_display_name,
                "collection_img_url": collection_img_url,
                "collection_description": collection_description,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    CollectionServiceHandlersCreateCollectionResponse,
                    construct_type(
                        type_=CollectionServiceHandlersCreateCollectionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get(
        self, collection_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CollectionServiceHandlersGetCollectionResponse:
        """
        Parameters
        ----------
        collection_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CollectionServiceHandlersGetCollectionResponse
            Successful Response

        Examples
        --------
        import asyncio

        from scoutos import AsyncScout

        client = AsyncScout(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.collections.get(
                collection_id="collection_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/collections/{jsonable_encoder(collection_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    CollectionServiceHandlersGetCollectionResponse,
                    construct_type(
                        type_=CollectionServiceHandlersGetCollectionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update(
        self,
        collection_id: str,
        *,
        collection_display_name: typing.Optional[str] = OMIT,
        collection_img_url: typing.Optional[str] = OMIT,
        collection_description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CollectionServiceHandlersUpdateCollectionResponse:
        """
        Parameters
        ----------
        collection_id : str

        collection_display_name : typing.Optional[str]

        collection_img_url : typing.Optional[str]

        collection_description : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CollectionServiceHandlersUpdateCollectionResponse
            Successful Response

        Examples
        --------
        import asyncio

        from scoutos import AsyncScout

        client = AsyncScout(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.collections.update(
                collection_id="collection_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/collections/{jsonable_encoder(collection_id)}",
            method="PUT",
            json={
                "collection_display_name": collection_display_name,
                "collection_img_url": collection_img_url,
                "collection_description": collection_description,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    CollectionServiceHandlersUpdateCollectionResponse,
                    construct_type(
                        type_=CollectionServiceHandlersUpdateCollectionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def delete(
        self, collection_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CollectionServiceHandlersDeleteCollectionResponse:
        """
        Delete a collection given a collection_id.

        Parameters
        ----------
        collection_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CollectionServiceHandlersDeleteCollectionResponse
            Successful Response

        Examples
        --------
        import asyncio

        from scoutos import AsyncScout

        client = AsyncScout(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.collections.delete(
                collection_id="collection_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/collections/{jsonable_encoder(collection_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    CollectionServiceHandlersDeleteCollectionResponse,
                    construct_type(
                        type_=CollectionServiceHandlersDeleteCollectionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
