
# dizionario che conterrà i deployers
DEPLOYERS = {}


# Dizionario contenente la configurazione del logging
# Nota: i file di output vengono sovrascritti all'accensione del server da quelli specificati nella configurazione kaomi

LOG_CONF = {
    'version': 1,

    'formatters': {
        'void': {
            'format': ''
        },
        'standard': {
            'format': '[%(asctime)s][%(levelname)s][%(name)s] %(message)s'
        },
        'console': {
            'format': '[%(asctime)s][%(levelname)s] %(message)s'
        }
    },
    
    'handlers': {
        'default': {
            'level': 'INFO',
            'class': 'logging.StreamHandler',
            'formatter': 'standard',
            'stream': 'ext://sys.stdout'
        },
        'cherrypy_console': {
            'level': 'INFO',
            'class': 'logging.StreamHandler',
            'formatter': 'console',
            'stream': 'ext://sys.stdout'
        },
        'cherrypy_access': {
            'level': 'INFO',
            'class': 'kaomi_server.log.CompressingRotatingFileHandler',
            'formatter': 'standard',
            'filename': 'access.log',
            'maxBytes': 52428800,
            'backupCount': 100,
            'encoding': 'utf8'
        },
        'cherrypy_error': {
            'level': 'INFO',
            'class': 'kaomi_server.log.CompressingRotatingFileHandler',
            'formatter': 'standard',
            'filename': 'error.log',
            'maxBytes': 52428800,
            'backupCount': 100,
            'encoding': 'utf8'
        },
        'cherrypy_app': {
            'level': 'DEBUG',
            'class': 'kaomi_server.log.CompressingRotatingFileHandler',
            'formatter': 'standard',
            'filename': 'app.log',
            'maxBytes': 52428800,
            'backupCount': 100,
            'encoding': 'utf8'
        },
    },

    'loggers': {
        '': {
            'handlers': ['cherrypy_app'],
            'level': 'DEBUG'
        },
        'cherrypy.app': {
            'handlers': ['cherrypy_app'],
            'level': 'DEBUG'
        },
        'cherrypy.access': {
            'handlers': ['cherrypy_access'],
            'level': 'DEBUG',
            'propagate': False
        },
        'cherrypy.error': {
            'handlers': ['cherrypy_console', 'cherrypy_error'],
            'level': 'DEBUG',
            'propagate': False
        },
    }
}


