"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import temporalio.api.common.v1.message_pb2
import temporalio.api.enums.v1.workflow_pb2
import temporalio.api.failure.v1.message_pb2
import temporalio.bridge.proto.child_workflow.child_workflow_pb2
import temporalio.bridge.proto.common.common_pb2
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _ActivityCancellationType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ActivityCancellationTypeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _ActivityCancellationType.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    TRY_CANCEL: _ActivityCancellationType.ValueType  # 0
    """/ Initiate a cancellation request and immediately report cancellation to the workflow."""

    WAIT_CANCELLATION_COMPLETED: _ActivityCancellationType.ValueType  # 1
    """/ Wait for activity cancellation completion. Note that activity must heartbeat to receive a
    / cancellation notification. This can block the cancellation for a long time if activity
    / doesn't heartbeat or chooses to ignore the cancellation request.
    """

    ABANDON: _ActivityCancellationType.ValueType  # 2
    """/ Do not request cancellation of the activity and immediately report cancellation to the
    / workflow
    """

class ActivityCancellationType(
    _ActivityCancellationType, metaclass=_ActivityCancellationTypeEnumTypeWrapper
):
    pass

TRY_CANCEL: ActivityCancellationType.ValueType  # 0
"""/ Initiate a cancellation request and immediately report cancellation to the workflow."""

WAIT_CANCELLATION_COMPLETED: ActivityCancellationType.ValueType  # 1
"""/ Wait for activity cancellation completion. Note that activity must heartbeat to receive a
/ cancellation notification. This can block the cancellation for a long time if activity
/ doesn't heartbeat or chooses to ignore the cancellation request.
"""

ABANDON: ActivityCancellationType.ValueType  # 2
"""/ Do not request cancellation of the activity and immediately report cancellation to the
/ workflow
"""

global___ActivityCancellationType = ActivityCancellationType

class WorkflowCommand(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    START_TIMER_FIELD_NUMBER: builtins.int
    SCHEDULE_ACTIVITY_FIELD_NUMBER: builtins.int
    RESPOND_TO_QUERY_FIELD_NUMBER: builtins.int
    REQUEST_CANCEL_ACTIVITY_FIELD_NUMBER: builtins.int
    CANCEL_TIMER_FIELD_NUMBER: builtins.int
    COMPLETE_WORKFLOW_EXECUTION_FIELD_NUMBER: builtins.int
    FAIL_WORKFLOW_EXECUTION_FIELD_NUMBER: builtins.int
    CONTINUE_AS_NEW_WORKFLOW_EXECUTION_FIELD_NUMBER: builtins.int
    CANCEL_WORKFLOW_EXECUTION_FIELD_NUMBER: builtins.int
    SET_PATCH_MARKER_FIELD_NUMBER: builtins.int
    START_CHILD_WORKFLOW_EXECUTION_FIELD_NUMBER: builtins.int
    CANCEL_UNSTARTED_CHILD_WORKFLOW_EXECUTION_FIELD_NUMBER: builtins.int
    REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_FIELD_NUMBER: builtins.int
    SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_FIELD_NUMBER: builtins.int
    CANCEL_SIGNAL_WORKFLOW_FIELD_NUMBER: builtins.int
    SCHEDULE_LOCAL_ACTIVITY_FIELD_NUMBER: builtins.int
    REQUEST_CANCEL_LOCAL_ACTIVITY_FIELD_NUMBER: builtins.int
    UPSERT_WORKFLOW_SEARCH_ATTRIBUTES_FIELD_NUMBER: builtins.int
    @property
    def start_timer(self) -> global___StartTimer: ...
    @property
    def schedule_activity(self) -> global___ScheduleActivity: ...
    @property
    def respond_to_query(self) -> global___QueryResult: ...
    @property
    def request_cancel_activity(self) -> global___RequestCancelActivity: ...
    @property
    def cancel_timer(self) -> global___CancelTimer: ...
    @property
    def complete_workflow_execution(self) -> global___CompleteWorkflowExecution: ...
    @property
    def fail_workflow_execution(self) -> global___FailWorkflowExecution: ...
    @property
    def continue_as_new_workflow_execution(
        self,
    ) -> global___ContinueAsNewWorkflowExecution: ...
    @property
    def cancel_workflow_execution(self) -> global___CancelWorkflowExecution: ...
    @property
    def set_patch_marker(self) -> global___SetPatchMarker: ...
    @property
    def start_child_workflow_execution(
        self,
    ) -> global___StartChildWorkflowExecution: ...
    @property
    def cancel_unstarted_child_workflow_execution(
        self,
    ) -> global___CancelUnstartedChildWorkflowExecution: ...
    @property
    def request_cancel_external_workflow_execution(
        self,
    ) -> global___RequestCancelExternalWorkflowExecution: ...
    @property
    def signal_external_workflow_execution(
        self,
    ) -> global___SignalExternalWorkflowExecution: ...
    @property
    def cancel_signal_workflow(self) -> global___CancelSignalWorkflow: ...
    @property
    def schedule_local_activity(self) -> global___ScheduleLocalActivity: ...
    @property
    def request_cancel_local_activity(self) -> global___RequestCancelLocalActivity: ...
    @property
    def upsert_workflow_search_attributes(
        self,
    ) -> global___UpsertWorkflowSearchAttributes: ...
    def __init__(
        self,
        *,
        start_timer: typing.Optional[global___StartTimer] = ...,
        schedule_activity: typing.Optional[global___ScheduleActivity] = ...,
        respond_to_query: typing.Optional[global___QueryResult] = ...,
        request_cancel_activity: typing.Optional[global___RequestCancelActivity] = ...,
        cancel_timer: typing.Optional[global___CancelTimer] = ...,
        complete_workflow_execution: typing.Optional[
            global___CompleteWorkflowExecution
        ] = ...,
        fail_workflow_execution: typing.Optional[global___FailWorkflowExecution] = ...,
        continue_as_new_workflow_execution: typing.Optional[
            global___ContinueAsNewWorkflowExecution
        ] = ...,
        cancel_workflow_execution: typing.Optional[
            global___CancelWorkflowExecution
        ] = ...,
        set_patch_marker: typing.Optional[global___SetPatchMarker] = ...,
        start_child_workflow_execution: typing.Optional[
            global___StartChildWorkflowExecution
        ] = ...,
        cancel_unstarted_child_workflow_execution: typing.Optional[
            global___CancelUnstartedChildWorkflowExecution
        ] = ...,
        request_cancel_external_workflow_execution: typing.Optional[
            global___RequestCancelExternalWorkflowExecution
        ] = ...,
        signal_external_workflow_execution: typing.Optional[
            global___SignalExternalWorkflowExecution
        ] = ...,
        cancel_signal_workflow: typing.Optional[global___CancelSignalWorkflow] = ...,
        schedule_local_activity: typing.Optional[global___ScheduleLocalActivity] = ...,
        request_cancel_local_activity: typing.Optional[
            global___RequestCancelLocalActivity
        ] = ...,
        upsert_workflow_search_attributes: typing.Optional[
            global___UpsertWorkflowSearchAttributes
        ] = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "cancel_signal_workflow",
            b"cancel_signal_workflow",
            "cancel_timer",
            b"cancel_timer",
            "cancel_unstarted_child_workflow_execution",
            b"cancel_unstarted_child_workflow_execution",
            "cancel_workflow_execution",
            b"cancel_workflow_execution",
            "complete_workflow_execution",
            b"complete_workflow_execution",
            "continue_as_new_workflow_execution",
            b"continue_as_new_workflow_execution",
            "fail_workflow_execution",
            b"fail_workflow_execution",
            "request_cancel_activity",
            b"request_cancel_activity",
            "request_cancel_external_workflow_execution",
            b"request_cancel_external_workflow_execution",
            "request_cancel_local_activity",
            b"request_cancel_local_activity",
            "respond_to_query",
            b"respond_to_query",
            "schedule_activity",
            b"schedule_activity",
            "schedule_local_activity",
            b"schedule_local_activity",
            "set_patch_marker",
            b"set_patch_marker",
            "signal_external_workflow_execution",
            b"signal_external_workflow_execution",
            "start_child_workflow_execution",
            b"start_child_workflow_execution",
            "start_timer",
            b"start_timer",
            "upsert_workflow_search_attributes",
            b"upsert_workflow_search_attributes",
            "variant",
            b"variant",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "cancel_signal_workflow",
            b"cancel_signal_workflow",
            "cancel_timer",
            b"cancel_timer",
            "cancel_unstarted_child_workflow_execution",
            b"cancel_unstarted_child_workflow_execution",
            "cancel_workflow_execution",
            b"cancel_workflow_execution",
            "complete_workflow_execution",
            b"complete_workflow_execution",
            "continue_as_new_workflow_execution",
            b"continue_as_new_workflow_execution",
            "fail_workflow_execution",
            b"fail_workflow_execution",
            "request_cancel_activity",
            b"request_cancel_activity",
            "request_cancel_external_workflow_execution",
            b"request_cancel_external_workflow_execution",
            "request_cancel_local_activity",
            b"request_cancel_local_activity",
            "respond_to_query",
            b"respond_to_query",
            "schedule_activity",
            b"schedule_activity",
            "schedule_local_activity",
            b"schedule_local_activity",
            "set_patch_marker",
            b"set_patch_marker",
            "signal_external_workflow_execution",
            b"signal_external_workflow_execution",
            "start_child_workflow_execution",
            b"start_child_workflow_execution",
            "start_timer",
            b"start_timer",
            "upsert_workflow_search_attributes",
            b"upsert_workflow_search_attributes",
            "variant",
            b"variant",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["variant", b"variant"]
    ) -> typing.Optional[
        typing_extensions.Literal[
            "start_timer",
            "schedule_activity",
            "respond_to_query",
            "request_cancel_activity",
            "cancel_timer",
            "complete_workflow_execution",
            "fail_workflow_execution",
            "continue_as_new_workflow_execution",
            "cancel_workflow_execution",
            "set_patch_marker",
            "start_child_workflow_execution",
            "cancel_unstarted_child_workflow_execution",
            "request_cancel_external_workflow_execution",
            "signal_external_workflow_execution",
            "cancel_signal_workflow",
            "schedule_local_activity",
            "request_cancel_local_activity",
            "upsert_workflow_search_attributes",
        ]
    ]: ...

global___WorkflowCommand = WorkflowCommand

class StartTimer(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SEQ_FIELD_NUMBER: builtins.int
    START_TO_FIRE_TIMEOUT_FIELD_NUMBER: builtins.int
    seq: builtins.int
    """/ Lang's incremental sequence number, used as the operation identifier"""

    @property
    def start_to_fire_timeout(self) -> google.protobuf.duration_pb2.Duration: ...
    def __init__(
        self,
        *,
        seq: builtins.int = ...,
        start_to_fire_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "start_to_fire_timeout", b"start_to_fire_timeout"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "seq", b"seq", "start_to_fire_timeout", b"start_to_fire_timeout"
        ],
    ) -> None: ...

global___StartTimer = StartTimer

class CancelTimer(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SEQ_FIELD_NUMBER: builtins.int
    seq: builtins.int
    """/ Lang's incremental sequence number as passed to `StartTimer`"""

    def __init__(
        self,
        *,
        seq: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["seq", b"seq"]
    ) -> None: ...

global___CancelTimer = CancelTimer

class ScheduleActivity(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class HeadersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> temporalio.api.common.v1.message_pb2.Payload: ...
        def __init__(
            self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[temporalio.api.common.v1.message_pb2.Payload] = ...,
        ) -> None: ...
        def HasField(
            self, field_name: typing_extensions.Literal["value", b"value"]
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal["key", b"key", "value", b"value"],
        ) -> None: ...

    SEQ_FIELD_NUMBER: builtins.int
    ACTIVITY_ID_FIELD_NUMBER: builtins.int
    ACTIVITY_TYPE_FIELD_NUMBER: builtins.int
    NAMESPACE_FIELD_NUMBER: builtins.int
    TASK_QUEUE_FIELD_NUMBER: builtins.int
    HEADERS_FIELD_NUMBER: builtins.int
    ARGUMENTS_FIELD_NUMBER: builtins.int
    SCHEDULE_TO_CLOSE_TIMEOUT_FIELD_NUMBER: builtins.int
    SCHEDULE_TO_START_TIMEOUT_FIELD_NUMBER: builtins.int
    START_TO_CLOSE_TIMEOUT_FIELD_NUMBER: builtins.int
    HEARTBEAT_TIMEOUT_FIELD_NUMBER: builtins.int
    RETRY_POLICY_FIELD_NUMBER: builtins.int
    CANCELLATION_TYPE_FIELD_NUMBER: builtins.int
    DO_NOT_EAGERLY_EXECUTE_FIELD_NUMBER: builtins.int
    seq: builtins.int
    """/ Lang's incremental sequence number, used as the operation identifier"""

    activity_id: typing.Text
    activity_type: typing.Text
    namespace: typing.Text
    task_queue: typing.Text
    """The name of the task queue to place this activity request in"""

    @property
    def headers(
        self,
    ) -> google.protobuf.internal.containers.MessageMap[
        typing.Text, temporalio.api.common.v1.message_pb2.Payload
    ]: ...
    @property
    def arguments(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        temporalio.api.common.v1.message_pb2.Payload
    ]:
        """/ Arguments/input to the activity. Called "input" upstream."""
        pass
    @property
    def schedule_to_close_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """/ Indicates how long the caller is willing to wait for an activity completion. Limits how long
        / retries will be attempted. Either this or start_to_close_timeout_seconds must be specified.
        / When not specified defaults to the workflow execution timeout.
        """
        pass
    @property
    def schedule_to_start_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """/ Limits time an activity task can stay in a task queue before a worker picks it up. This
        / timeout is always non retryable as all a retry would achieve is to put it back into the same
        / queue. Defaults to schedule_to_close_timeout or workflow execution timeout if not specified.
        """
        pass
    @property
    def start_to_close_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """/ Maximum time an activity is allowed to execute after a pick up by a worker. This timeout is
        / always retryable. Either this or schedule_to_close_timeout must be specified.
        """
        pass
    @property
    def heartbeat_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """/ Maximum time allowed between successful worker heartbeats."""
        pass
    @property
    def retry_policy(self) -> temporalio.api.common.v1.message_pb2.RetryPolicy:
        """/ Activities are provided by a default retry policy controlled through the service dynamic
        / configuration. Retries are happening up to schedule_to_close_timeout. To disable retries set
        / retry_policy.maximum_attempts to 1.
        """
        pass
    cancellation_type: global___ActivityCancellationType.ValueType
    """/ Defines how the workflow will wait (or not) for cancellation of the activity to be confirmed"""

    do_not_eagerly_execute: builtins.bool
    """/ If set, the worker will not tell the service that it can immediately start executing this
    / activity. When unset/default, workers will always attempt to do so if activity execution
    / slots are available.
    """

    def __init__(
        self,
        *,
        seq: builtins.int = ...,
        activity_id: typing.Text = ...,
        activity_type: typing.Text = ...,
        namespace: typing.Text = ...,
        task_queue: typing.Text = ...,
        headers: typing.Optional[
            typing.Mapping[typing.Text, temporalio.api.common.v1.message_pb2.Payload]
        ] = ...,
        arguments: typing.Optional[
            typing.Iterable[temporalio.api.common.v1.message_pb2.Payload]
        ] = ...,
        schedule_to_close_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        schedule_to_start_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        start_to_close_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        heartbeat_timeout: typing.Optional[google.protobuf.duration_pb2.Duration] = ...,
        retry_policy: typing.Optional[
            temporalio.api.common.v1.message_pb2.RetryPolicy
        ] = ...,
        cancellation_type: global___ActivityCancellationType.ValueType = ...,
        do_not_eagerly_execute: builtins.bool = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "heartbeat_timeout",
            b"heartbeat_timeout",
            "retry_policy",
            b"retry_policy",
            "schedule_to_close_timeout",
            b"schedule_to_close_timeout",
            "schedule_to_start_timeout",
            b"schedule_to_start_timeout",
            "start_to_close_timeout",
            b"start_to_close_timeout",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "activity_id",
            b"activity_id",
            "activity_type",
            b"activity_type",
            "arguments",
            b"arguments",
            "cancellation_type",
            b"cancellation_type",
            "do_not_eagerly_execute",
            b"do_not_eagerly_execute",
            "headers",
            b"headers",
            "heartbeat_timeout",
            b"heartbeat_timeout",
            "namespace",
            b"namespace",
            "retry_policy",
            b"retry_policy",
            "schedule_to_close_timeout",
            b"schedule_to_close_timeout",
            "schedule_to_start_timeout",
            b"schedule_to_start_timeout",
            "seq",
            b"seq",
            "start_to_close_timeout",
            b"start_to_close_timeout",
            "task_queue",
            b"task_queue",
        ],
    ) -> None: ...

global___ScheduleActivity = ScheduleActivity

class ScheduleLocalActivity(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class HeadersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> temporalio.api.common.v1.message_pb2.Payload: ...
        def __init__(
            self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[temporalio.api.common.v1.message_pb2.Payload] = ...,
        ) -> None: ...
        def HasField(
            self, field_name: typing_extensions.Literal["value", b"value"]
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal["key", b"key", "value", b"value"],
        ) -> None: ...

    SEQ_FIELD_NUMBER: builtins.int
    ACTIVITY_ID_FIELD_NUMBER: builtins.int
    ACTIVITY_TYPE_FIELD_NUMBER: builtins.int
    ATTEMPT_FIELD_NUMBER: builtins.int
    ORIGINAL_SCHEDULE_TIME_FIELD_NUMBER: builtins.int
    HEADERS_FIELD_NUMBER: builtins.int
    ARGUMENTS_FIELD_NUMBER: builtins.int
    SCHEDULE_TO_CLOSE_TIMEOUT_FIELD_NUMBER: builtins.int
    SCHEDULE_TO_START_TIMEOUT_FIELD_NUMBER: builtins.int
    START_TO_CLOSE_TIMEOUT_FIELD_NUMBER: builtins.int
    RETRY_POLICY_FIELD_NUMBER: builtins.int
    LOCAL_RETRY_THRESHOLD_FIELD_NUMBER: builtins.int
    CANCELLATION_TYPE_FIELD_NUMBER: builtins.int
    seq: builtins.int
    """/ Lang's incremental sequence number, used as the operation identifier"""

    activity_id: typing.Text
    activity_type: typing.Text
    attempt: builtins.int
    """/ Local activities can start with a non-1 attempt, if lang has been told to backoff using
    / a timer before retrying. It should pass the attempt number from a `DoBackoff` activity
    / resolution.
    """

    @property
    def original_schedule_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """/ If this local activity is a retry (as per the attempt field) this needs to be the original
        / scheduling time (as provided in `DoBackoff`)
        """
        pass
    @property
    def headers(
        self,
    ) -> google.protobuf.internal.containers.MessageMap[
        typing.Text, temporalio.api.common.v1.message_pb2.Payload
    ]: ...
    @property
    def arguments(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        temporalio.api.common.v1.message_pb2.Payload
    ]:
        """/ Arguments/input to the activity."""
        pass
    @property
    def schedule_to_close_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """/ Indicates how long the caller is willing to wait for local activity completion. Limits how
        / long retries will be attempted. When not specified defaults to the workflow execution
        / timeout (which may be unset).
        """
        pass
    @property
    def schedule_to_start_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """/ Limits time the local activity can idle internally before being executed. That can happen if
        / the worker is currently at max concurrent local activity executions. This timeout is always
        / non retryable as all a retry would achieve is to put it back into the same queue. Defaults
        / to `schedule_to_close_timeout` if not specified and that is set. Must be <=
        / `schedule_to_close_timeout` when set, otherwise, it will be clamped down.
        """
        pass
    @property
    def start_to_close_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """/ Maximum time the local activity is allowed to execute after the task is dispatched. This
        / timeout is always retryable. Either or both of `schedule_to_close_timeout` and this must be
        / specified. If set, this must be <= `schedule_to_close_timeout`, otherwise, it will be
        / clamped down.
        """
        pass
    @property
    def retry_policy(self) -> temporalio.api.common.v1.message_pb2.RetryPolicy:
        """/ Specify a retry policy for the local activity. By default local activities will be retried
        / indefinitely.
        """
        pass
    @property
    def local_retry_threshold(self) -> google.protobuf.duration_pb2.Duration:
        """/ If the activity is retrying and backoff would exceed this value, lang will be told to
        / schedule a timer and retry the activity after. Otherwise, backoff will happen internally in
        / core. Defaults to 1 minute.
        """
        pass
    cancellation_type: global___ActivityCancellationType.ValueType
    """/ Defines how the workflow will wait (or not) for cancellation of the activity to be
    / confirmed. Lang should default this to `WAIT_CANCELLATION_COMPLETED`, even though proto
    / will default to `TRY_CANCEL` automatically.
    """

    def __init__(
        self,
        *,
        seq: builtins.int = ...,
        activity_id: typing.Text = ...,
        activity_type: typing.Text = ...,
        attempt: builtins.int = ...,
        original_schedule_time: typing.Optional[
            google.protobuf.timestamp_pb2.Timestamp
        ] = ...,
        headers: typing.Optional[
            typing.Mapping[typing.Text, temporalio.api.common.v1.message_pb2.Payload]
        ] = ...,
        arguments: typing.Optional[
            typing.Iterable[temporalio.api.common.v1.message_pb2.Payload]
        ] = ...,
        schedule_to_close_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        schedule_to_start_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        start_to_close_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        retry_policy: typing.Optional[
            temporalio.api.common.v1.message_pb2.RetryPolicy
        ] = ...,
        local_retry_threshold: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        cancellation_type: global___ActivityCancellationType.ValueType = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "local_retry_threshold",
            b"local_retry_threshold",
            "original_schedule_time",
            b"original_schedule_time",
            "retry_policy",
            b"retry_policy",
            "schedule_to_close_timeout",
            b"schedule_to_close_timeout",
            "schedule_to_start_timeout",
            b"schedule_to_start_timeout",
            "start_to_close_timeout",
            b"start_to_close_timeout",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "activity_id",
            b"activity_id",
            "activity_type",
            b"activity_type",
            "arguments",
            b"arguments",
            "attempt",
            b"attempt",
            "cancellation_type",
            b"cancellation_type",
            "headers",
            b"headers",
            "local_retry_threshold",
            b"local_retry_threshold",
            "original_schedule_time",
            b"original_schedule_time",
            "retry_policy",
            b"retry_policy",
            "schedule_to_close_timeout",
            b"schedule_to_close_timeout",
            "schedule_to_start_timeout",
            b"schedule_to_start_timeout",
            "seq",
            b"seq",
            "start_to_close_timeout",
            b"start_to_close_timeout",
        ],
    ) -> None: ...

global___ScheduleLocalActivity = ScheduleLocalActivity

class RequestCancelActivity(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SEQ_FIELD_NUMBER: builtins.int
    seq: builtins.int
    """/ Lang's incremental sequence number as passed to `ScheduleActivity`"""

    def __init__(
        self,
        *,
        seq: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["seq", b"seq"]
    ) -> None: ...

global___RequestCancelActivity = RequestCancelActivity

class RequestCancelLocalActivity(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SEQ_FIELD_NUMBER: builtins.int
    seq: builtins.int
    """/ Lang's incremental sequence number as passed to `ScheduleLocalActivity`"""

    def __init__(
        self,
        *,
        seq: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["seq", b"seq"]
    ) -> None: ...

global___RequestCancelLocalActivity = RequestCancelLocalActivity

class QueryResult(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    QUERY_ID_FIELD_NUMBER: builtins.int
    SUCCEEDED_FIELD_NUMBER: builtins.int
    FAILED_FIELD_NUMBER: builtins.int
    query_id: typing.Text
    """/ Corresponds to the id provided in the activation job"""

    @property
    def succeeded(self) -> global___QuerySuccess: ...
    @property
    def failed(self) -> temporalio.api.failure.v1.message_pb2.Failure: ...
    def __init__(
        self,
        *,
        query_id: typing.Text = ...,
        succeeded: typing.Optional[global___QuerySuccess] = ...,
        failed: typing.Optional[temporalio.api.failure.v1.message_pb2.Failure] = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "failed", b"failed", "succeeded", b"succeeded", "variant", b"variant"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "failed",
            b"failed",
            "query_id",
            b"query_id",
            "succeeded",
            b"succeeded",
            "variant",
            b"variant",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["variant", b"variant"]
    ) -> typing.Optional[typing_extensions.Literal["succeeded", "failed"]]: ...

global___QueryResult = QueryResult

class QuerySuccess(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    RESPONSE_FIELD_NUMBER: builtins.int
    @property
    def response(self) -> temporalio.api.common.v1.message_pb2.Payload: ...
    def __init__(
        self,
        *,
        response: typing.Optional[temporalio.api.common.v1.message_pb2.Payload] = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["response", b"response"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["response", b"response"]
    ) -> None: ...

global___QuerySuccess = QuerySuccess

class CompleteWorkflowExecution(google.protobuf.message.Message):
    """/ Issued when the workflow completes successfully"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    RESULT_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> temporalio.api.common.v1.message_pb2.Payload: ...
    def __init__(
        self,
        *,
        result: typing.Optional[temporalio.api.common.v1.message_pb2.Payload] = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["result", b"result"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["result", b"result"]
    ) -> None: ...

global___CompleteWorkflowExecution = CompleteWorkflowExecution

class FailWorkflowExecution(google.protobuf.message.Message):
    """/ Issued when the workflow errors out"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    FAILURE_FIELD_NUMBER: builtins.int
    @property
    def failure(self) -> temporalio.api.failure.v1.message_pb2.Failure: ...
    def __init__(
        self,
        *,
        failure: typing.Optional[temporalio.api.failure.v1.message_pb2.Failure] = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["failure", b"failure"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["failure", b"failure"]
    ) -> None: ...

global___FailWorkflowExecution = FailWorkflowExecution

class ContinueAsNewWorkflowExecution(google.protobuf.message.Message):
    """TODO: Maybe combine all execution resolves into one message
    / Continue the workflow as a new execution. Unless noted otherwise, unset or default field values
    / will re-use the issuing workflow's values.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class MemoEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> temporalio.api.common.v1.message_pb2.Payload: ...
        def __init__(
            self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[temporalio.api.common.v1.message_pb2.Payload] = ...,
        ) -> None: ...
        def HasField(
            self, field_name: typing_extensions.Literal["value", b"value"]
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal["key", b"key", "value", b"value"],
        ) -> None: ...

    class HeadersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> temporalio.api.common.v1.message_pb2.Payload: ...
        def __init__(
            self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[temporalio.api.common.v1.message_pb2.Payload] = ...,
        ) -> None: ...
        def HasField(
            self, field_name: typing_extensions.Literal["value", b"value"]
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal["key", b"key", "value", b"value"],
        ) -> None: ...

    class SearchAttributesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> temporalio.api.common.v1.message_pb2.Payload: ...
        def __init__(
            self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[temporalio.api.common.v1.message_pb2.Payload] = ...,
        ) -> None: ...
        def HasField(
            self, field_name: typing_extensions.Literal["value", b"value"]
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal["key", b"key", "value", b"value"],
        ) -> None: ...

    WORKFLOW_TYPE_FIELD_NUMBER: builtins.int
    TASK_QUEUE_FIELD_NUMBER: builtins.int
    ARGUMENTS_FIELD_NUMBER: builtins.int
    WORKFLOW_RUN_TIMEOUT_FIELD_NUMBER: builtins.int
    WORKFLOW_TASK_TIMEOUT_FIELD_NUMBER: builtins.int
    MEMO_FIELD_NUMBER: builtins.int
    HEADERS_FIELD_NUMBER: builtins.int
    SEARCH_ATTRIBUTES_FIELD_NUMBER: builtins.int
    workflow_type: typing.Text
    """/ The identifier the lang-specific sdk uses to execute workflow code"""

    task_queue: typing.Text
    """/ Task queue for the new workflow execution"""

    @property
    def arguments(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        temporalio.api.common.v1.message_pb2.Payload
    ]:
        """/ Inputs to the workflow code. Should be specified. Will not re-use old arguments, as that
        / typically wouldn't make any sense.
        """
        pass
    @property
    def workflow_run_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """/ Timeout for a single run of the new workflow."""
        pass
    @property
    def workflow_task_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """/ Timeout of a single workflow task."""
        pass
    @property
    def memo(
        self,
    ) -> google.protobuf.internal.containers.MessageMap[
        typing.Text, temporalio.api.common.v1.message_pb2.Payload
    ]:
        """/ Memo fields"""
        pass
    @property
    def headers(
        self,
    ) -> google.protobuf.internal.containers.MessageMap[
        typing.Text, temporalio.api.common.v1.message_pb2.Payload
    ]:
        """/ Header fields"""
        pass
    @property
    def search_attributes(
        self,
    ) -> google.protobuf.internal.containers.MessageMap[
        typing.Text, temporalio.api.common.v1.message_pb2.Payload
    ]:
        """/ Search attributes"""
        pass
    def __init__(
        self,
        *,
        workflow_type: typing.Text = ...,
        task_queue: typing.Text = ...,
        arguments: typing.Optional[
            typing.Iterable[temporalio.api.common.v1.message_pb2.Payload]
        ] = ...,
        workflow_run_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        workflow_task_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        memo: typing.Optional[
            typing.Mapping[typing.Text, temporalio.api.common.v1.message_pb2.Payload]
        ] = ...,
        headers: typing.Optional[
            typing.Mapping[typing.Text, temporalio.api.common.v1.message_pb2.Payload]
        ] = ...,
        search_attributes: typing.Optional[
            typing.Mapping[typing.Text, temporalio.api.common.v1.message_pb2.Payload]
        ] = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "workflow_run_timeout",
            b"workflow_run_timeout",
            "workflow_task_timeout",
            b"workflow_task_timeout",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "arguments",
            b"arguments",
            "headers",
            b"headers",
            "memo",
            b"memo",
            "search_attributes",
            b"search_attributes",
            "task_queue",
            b"task_queue",
            "workflow_run_timeout",
            b"workflow_run_timeout",
            "workflow_task_timeout",
            b"workflow_task_timeout",
            "workflow_type",
            b"workflow_type",
        ],
    ) -> None: ...

global___ContinueAsNewWorkflowExecution = ContinueAsNewWorkflowExecution

class CancelWorkflowExecution(google.protobuf.message.Message):
    """/ Indicate a workflow has completed as cancelled. Generally sent as a response to an activation
    / containing a cancellation job.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    def __init__(
        self,
    ) -> None: ...

global___CancelWorkflowExecution = CancelWorkflowExecution

class SetPatchMarker(google.protobuf.message.Message):
    """/ A request to set/check if a certain patch is present or not"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PATCH_ID_FIELD_NUMBER: builtins.int
    DEPRECATED_FIELD_NUMBER: builtins.int
    patch_id: typing.Text
    """A user-chosen identifier for this patch. If the same identifier is used in multiple places in
    the code, those places are considered to be versioned as one unit. IE: The check call will
    return the same result for all of them
    """

    deprecated: builtins.bool
    """Can be set to true to indicate that branches using this change are being removed, and all
    future worker deployments will only have the "with change" code in them.
    """

    def __init__(
        self,
        *,
        patch_id: typing.Text = ...,
        deprecated: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "deprecated", b"deprecated", "patch_id", b"patch_id"
        ],
    ) -> None: ...

global___SetPatchMarker = SetPatchMarker

class StartChildWorkflowExecution(google.protobuf.message.Message):
    """/ Start a child workflow execution"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class HeadersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> temporalio.api.common.v1.message_pb2.Payload: ...
        def __init__(
            self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[temporalio.api.common.v1.message_pb2.Payload] = ...,
        ) -> None: ...
        def HasField(
            self, field_name: typing_extensions.Literal["value", b"value"]
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal["key", b"key", "value", b"value"],
        ) -> None: ...

    class MemoEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> temporalio.api.common.v1.message_pb2.Payload: ...
        def __init__(
            self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[temporalio.api.common.v1.message_pb2.Payload] = ...,
        ) -> None: ...
        def HasField(
            self, field_name: typing_extensions.Literal["value", b"value"]
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal["key", b"key", "value", b"value"],
        ) -> None: ...

    class SearchAttributesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> temporalio.api.common.v1.message_pb2.Payload: ...
        def __init__(
            self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[temporalio.api.common.v1.message_pb2.Payload] = ...,
        ) -> None: ...
        def HasField(
            self, field_name: typing_extensions.Literal["value", b"value"]
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal["key", b"key", "value", b"value"],
        ) -> None: ...

    SEQ_FIELD_NUMBER: builtins.int
    NAMESPACE_FIELD_NUMBER: builtins.int
    WORKFLOW_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_TYPE_FIELD_NUMBER: builtins.int
    TASK_QUEUE_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_TIMEOUT_FIELD_NUMBER: builtins.int
    WORKFLOW_RUN_TIMEOUT_FIELD_NUMBER: builtins.int
    WORKFLOW_TASK_TIMEOUT_FIELD_NUMBER: builtins.int
    PARENT_CLOSE_POLICY_FIELD_NUMBER: builtins.int
    WORKFLOW_ID_REUSE_POLICY_FIELD_NUMBER: builtins.int
    RETRY_POLICY_FIELD_NUMBER: builtins.int
    CRON_SCHEDULE_FIELD_NUMBER: builtins.int
    HEADERS_FIELD_NUMBER: builtins.int
    MEMO_FIELD_NUMBER: builtins.int
    SEARCH_ATTRIBUTES_FIELD_NUMBER: builtins.int
    CANCELLATION_TYPE_FIELD_NUMBER: builtins.int
    seq: builtins.int
    """/ Lang's incremental sequence number, used as the operation identifier"""

    namespace: typing.Text
    workflow_id: typing.Text
    workflow_type: typing.Text
    task_queue: typing.Text
    @property
    def input(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        temporalio.api.common.v1.message_pb2.Payload
    ]: ...
    @property
    def workflow_execution_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """/ Total workflow execution timeout including retries and continue as new."""
        pass
    @property
    def workflow_run_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """/ Timeout of a single workflow run."""
        pass
    @property
    def workflow_task_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """/ Timeout of a single workflow task."""
        pass
    parent_close_policy: temporalio.bridge.proto.child_workflow.child_workflow_pb2.ParentClosePolicy.ValueType
    """/ Default: PARENT_CLOSE_POLICY_TERMINATE."""

    workflow_id_reuse_policy: temporalio.api.enums.v1.workflow_pb2.WorkflowIdReusePolicy.ValueType
    """string control = 11; (unused from StartChildWorkflowExecutionCommandAttributes)
    Default: WORKFLOW_ID_REUSE_POLICY_ALLOW_DUPLICATE.
    """

    @property
    def retry_policy(self) -> temporalio.api.common.v1.message_pb2.RetryPolicy: ...
    cron_schedule: typing.Text
    @property
    def headers(
        self,
    ) -> google.protobuf.internal.containers.MessageMap[
        typing.Text, temporalio.api.common.v1.message_pb2.Payload
    ]:
        """/ Header fields"""
        pass
    @property
    def memo(
        self,
    ) -> google.protobuf.internal.containers.MessageMap[
        typing.Text, temporalio.api.common.v1.message_pb2.Payload
    ]:
        """/ Memo fields"""
        pass
    @property
    def search_attributes(
        self,
    ) -> google.protobuf.internal.containers.MessageMap[
        typing.Text, temporalio.api.common.v1.message_pb2.Payload
    ]:
        """/ Search attributes"""
        pass
    cancellation_type: temporalio.bridge.proto.child_workflow.child_workflow_pb2.ChildWorkflowCancellationType.ValueType
    """/ Defines behaviour of the underlying workflow when child workflow cancellation has been requested."""

    def __init__(
        self,
        *,
        seq: builtins.int = ...,
        namespace: typing.Text = ...,
        workflow_id: typing.Text = ...,
        workflow_type: typing.Text = ...,
        task_queue: typing.Text = ...,
        input: typing.Optional[
            typing.Iterable[temporalio.api.common.v1.message_pb2.Payload]
        ] = ...,
        workflow_execution_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        workflow_run_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        workflow_task_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        parent_close_policy: temporalio.bridge.proto.child_workflow.child_workflow_pb2.ParentClosePolicy.ValueType = ...,
        workflow_id_reuse_policy: temporalio.api.enums.v1.workflow_pb2.WorkflowIdReusePolicy.ValueType = ...,
        retry_policy: typing.Optional[
            temporalio.api.common.v1.message_pb2.RetryPolicy
        ] = ...,
        cron_schedule: typing.Text = ...,
        headers: typing.Optional[
            typing.Mapping[typing.Text, temporalio.api.common.v1.message_pb2.Payload]
        ] = ...,
        memo: typing.Optional[
            typing.Mapping[typing.Text, temporalio.api.common.v1.message_pb2.Payload]
        ] = ...,
        search_attributes: typing.Optional[
            typing.Mapping[typing.Text, temporalio.api.common.v1.message_pb2.Payload]
        ] = ...,
        cancellation_type: temporalio.bridge.proto.child_workflow.child_workflow_pb2.ChildWorkflowCancellationType.ValueType = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "retry_policy",
            b"retry_policy",
            "workflow_execution_timeout",
            b"workflow_execution_timeout",
            "workflow_run_timeout",
            b"workflow_run_timeout",
            "workflow_task_timeout",
            b"workflow_task_timeout",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "cancellation_type",
            b"cancellation_type",
            "cron_schedule",
            b"cron_schedule",
            "headers",
            b"headers",
            "input",
            b"input",
            "memo",
            b"memo",
            "namespace",
            b"namespace",
            "parent_close_policy",
            b"parent_close_policy",
            "retry_policy",
            b"retry_policy",
            "search_attributes",
            b"search_attributes",
            "seq",
            b"seq",
            "task_queue",
            b"task_queue",
            "workflow_execution_timeout",
            b"workflow_execution_timeout",
            "workflow_id",
            b"workflow_id",
            "workflow_id_reuse_policy",
            b"workflow_id_reuse_policy",
            "workflow_run_timeout",
            b"workflow_run_timeout",
            "workflow_task_timeout",
            b"workflow_task_timeout",
            "workflow_type",
            b"workflow_type",
        ],
    ) -> None: ...

global___StartChildWorkflowExecution = StartChildWorkflowExecution

class CancelUnstartedChildWorkflowExecution(google.protobuf.message.Message):
    """/ Cancel a not-yet-started child workflow"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    CHILD_WORKFLOW_SEQ_FIELD_NUMBER: builtins.int
    child_workflow_seq: builtins.int
    """Sequence number as given to the `StartChildWorkflowExecution` command"""

    def __init__(
        self,
        *,
        child_workflow_seq: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "child_workflow_seq", b"child_workflow_seq"
        ],
    ) -> None: ...

global___CancelUnstartedChildWorkflowExecution = CancelUnstartedChildWorkflowExecution

class RequestCancelExternalWorkflowExecution(google.protobuf.message.Message):
    """/ Request cancellation of an external workflow execution (which may be a started child)"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SEQ_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_FIELD_NUMBER: builtins.int
    CHILD_WORKFLOW_ID_FIELD_NUMBER: builtins.int
    seq: builtins.int
    """/ Lang's incremental sequence number, used as the operation identifier"""

    @property
    def workflow_execution(
        self,
    ) -> temporalio.bridge.proto.common.common_pb2.NamespacedWorkflowExecution:
        """A specific workflow instance"""
        pass
    child_workflow_id: typing.Text
    """The desired target must be a child of the issuing workflow, and this is its workflow id"""

    def __init__(
        self,
        *,
        seq: builtins.int = ...,
        workflow_execution: typing.Optional[
            temporalio.bridge.proto.common.common_pb2.NamespacedWorkflowExecution
        ] = ...,
        child_workflow_id: typing.Text = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "child_workflow_id",
            b"child_workflow_id",
            "target",
            b"target",
            "workflow_execution",
            b"workflow_execution",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "child_workflow_id",
            b"child_workflow_id",
            "seq",
            b"seq",
            "target",
            b"target",
            "workflow_execution",
            b"workflow_execution",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["target", b"target"]
    ) -> typing.Optional[
        typing_extensions.Literal["workflow_execution", "child_workflow_id"]
    ]: ...

global___RequestCancelExternalWorkflowExecution = RequestCancelExternalWorkflowExecution

class SignalExternalWorkflowExecution(google.protobuf.message.Message):
    """/ Send a signal to an external or child workflow"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class HeadersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> temporalio.api.common.v1.message_pb2.Payload: ...
        def __init__(
            self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[temporalio.api.common.v1.message_pb2.Payload] = ...,
        ) -> None: ...
        def HasField(
            self, field_name: typing_extensions.Literal["value", b"value"]
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal["key", b"key", "value", b"value"],
        ) -> None: ...

    SEQ_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_FIELD_NUMBER: builtins.int
    CHILD_WORKFLOW_ID_FIELD_NUMBER: builtins.int
    SIGNAL_NAME_FIELD_NUMBER: builtins.int
    ARGS_FIELD_NUMBER: builtins.int
    HEADERS_FIELD_NUMBER: builtins.int
    seq: builtins.int
    """/ Lang's incremental sequence number, used as the operation identifier"""

    @property
    def workflow_execution(
        self,
    ) -> temporalio.bridge.proto.common.common_pb2.NamespacedWorkflowExecution:
        """A specific workflow instance"""
        pass
    child_workflow_id: typing.Text
    """The desired target must be a child of the issuing workflow, and this is its workflow id"""

    signal_name: typing.Text
    """/ Name of the signal handler"""

    @property
    def args(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        temporalio.api.common.v1.message_pb2.Payload
    ]:
        """/ Arguments for the handler"""
        pass
    @property
    def headers(
        self,
    ) -> google.protobuf.internal.containers.MessageMap[
        typing.Text, temporalio.api.common.v1.message_pb2.Payload
    ]:
        """/ Headers to attach to the signal"""
        pass
    def __init__(
        self,
        *,
        seq: builtins.int = ...,
        workflow_execution: typing.Optional[
            temporalio.bridge.proto.common.common_pb2.NamespacedWorkflowExecution
        ] = ...,
        child_workflow_id: typing.Text = ...,
        signal_name: typing.Text = ...,
        args: typing.Optional[
            typing.Iterable[temporalio.api.common.v1.message_pb2.Payload]
        ] = ...,
        headers: typing.Optional[
            typing.Mapping[typing.Text, temporalio.api.common.v1.message_pb2.Payload]
        ] = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "child_workflow_id",
            b"child_workflow_id",
            "target",
            b"target",
            "workflow_execution",
            b"workflow_execution",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "args",
            b"args",
            "child_workflow_id",
            b"child_workflow_id",
            "headers",
            b"headers",
            "seq",
            b"seq",
            "signal_name",
            b"signal_name",
            "target",
            b"target",
            "workflow_execution",
            b"workflow_execution",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["target", b"target"]
    ) -> typing.Optional[
        typing_extensions.Literal["workflow_execution", "child_workflow_id"]
    ]: ...

global___SignalExternalWorkflowExecution = SignalExternalWorkflowExecution

class CancelSignalWorkflow(google.protobuf.message.Message):
    """/ Can be used to cancel not-already-sent `SignalExternalWorkflowExecution` commands"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SEQ_FIELD_NUMBER: builtins.int
    seq: builtins.int
    """/ Lang's incremental sequence number as passed to `SignalExternalWorkflowExecution`"""

    def __init__(
        self,
        *,
        seq: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["seq", b"seq"]
    ) -> None: ...

global___CancelSignalWorkflow = CancelSignalWorkflow

class UpsertWorkflowSearchAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class SearchAttributesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> temporalio.api.common.v1.message_pb2.Payload: ...
        def __init__(
            self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[temporalio.api.common.v1.message_pb2.Payload] = ...,
        ) -> None: ...
        def HasField(
            self, field_name: typing_extensions.Literal["value", b"value"]
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal["key", b"key", "value", b"value"],
        ) -> None: ...

    SEARCH_ATTRIBUTES_FIELD_NUMBER: builtins.int
    @property
    def search_attributes(
        self,
    ) -> google.protobuf.internal.containers.MessageMap[
        typing.Text, temporalio.api.common.v1.message_pb2.Payload
    ]:
        """/ SearchAttributes fields - equivalent to indexed_fields on api. Key = search index, Value =
        / value?
        """
        pass
    def __init__(
        self,
        *,
        search_attributes: typing.Optional[
            typing.Mapping[typing.Text, temporalio.api.common.v1.message_pb2.Payload]
        ] = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "search_attributes", b"search_attributes"
        ],
    ) -> None: ...

global___UpsertWorkflowSearchAttributes = UpsertWorkflowSearchAttributes
