"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import abc
import grpc
import temporalio.api.workflowservice.v1.request_response_pb2

class WorkflowServiceStub:
    """WorkflowService API defines how Temporal SDKs and other clients interact with the Temporal server
    to create and interact with workflows and activities.

    Users are expected to call `StartWorkflowExecution` to create a new workflow execution.

    To drive workflows, a worker using a Temporal SDK must exist which regularly polls for workflow
    and activity tasks from the service. For each workflow task, the sdk must process the
    (incremental or complete) event history and respond back with any newly generated commands.

    For each activity task, the worker is expected to execute the user's code which implements that
    activity, responding with completion or failure.
    """

    def __init__(self, channel: grpc.Channel) -> None: ...
    RegisterNamespace: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.RegisterNamespaceRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.RegisterNamespaceResponse,
    ]
    """RegisterNamespace creates a new namespace which can be used as a container for all resources.

    A Namespace is a top level entity within Temporal, and is used as a container for resources
    like workflow executions, task queues, etc. A Namespace acts as a sandbox and provides
    isolation for all resources within the namespace. All resources belongs to exactly one
    namespace.
    """

    DescribeNamespace: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.DescribeNamespaceRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.DescribeNamespaceResponse,
    ]
    """DescribeNamespace returns the information and configuration for a registered namespace."""

    ListNamespaces: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.ListNamespacesRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.ListNamespacesResponse,
    ]
    """ListNamespaces returns the information and configuration for all namespaces."""

    UpdateNamespace: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.UpdateNamespaceRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.UpdateNamespaceResponse,
    ]
    """UpdateNamespace is used to update the information and configuration of a registered
    namespace.

    (-- api-linter: core::0134::method-signature=disabled
        aip.dev/not-precedent: UpdateNamespace RPC doesn't follow Google API format. --)
    (-- api-linter: core::0134::response-message-name=disabled
        aip.dev/not-precedent: UpdateNamespace RPC doesn't follow Google API format. --)
    """

    DeprecateNamespace: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.DeprecateNamespaceRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.DeprecateNamespaceResponse,
    ]
    """DeprecateNamespace is used to update the state of a registered namespace to DEPRECATED.

    Once the namespace is deprecated it cannot be used to start new workflow executions. Existing
    workflow executions will continue to run on deprecated namespaces.
    Deprecated.
    """

    StartWorkflowExecution: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.StartWorkflowExecutionRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.StartWorkflowExecutionResponse,
    ]
    """StartWorkflowExecution starts a new workflow execution.

    It will create the execution with a `WORKFLOW_EXECUTION_STARTED` event in its history and
    also schedule the first workflow task. Returns `WorkflowExecutionAlreadyStarted`, if an
    instance already exists with same workflow id.
    """

    GetWorkflowExecutionHistory: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.GetWorkflowExecutionHistoryRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.GetWorkflowExecutionHistoryResponse,
    ]
    """GetWorkflowExecutionHistory returns the history of specified workflow execution. Fails with
    `NotFound` if the specified workflow execution is unknown to the service.
    """

    GetWorkflowExecutionHistoryReverse: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.GetWorkflowExecutionHistoryReverseRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.GetWorkflowExecutionHistoryReverseResponse,
    ]
    """GetWorkflowExecutionHistoryReverse returns the history of specified workflow execution in reverse 
    order (starting from last event). Fails with`NotFound` if the specified workflow execution is 
    unknown to the service.
    """

    PollWorkflowTaskQueue: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.PollWorkflowTaskQueueRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.PollWorkflowTaskQueueResponse,
    ]
    """PollWorkflowTaskQueue is called by workers to make progress on workflows.

    A WorkflowTask is dispatched to callers for active workflow executions with pending workflow
    tasks. The worker is expected to call `RespondWorkflowTaskCompleted` when it is done
    processing the task. The service will create a `WorkflowTaskStarted` event in the history for
    this task before handing it to the worker.
    """

    RespondWorkflowTaskCompleted: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.RespondWorkflowTaskCompletedRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.RespondWorkflowTaskCompletedResponse,
    ]
    """RespondWorkflowTaskCompleted is called by workers to successfully complete workflow tasks
    they received from `PollWorkflowTaskQueue`.

    Completing a WorkflowTask will write a `WORKFLOW_TASK_COMPLETED` event to the workflow's
    history, along with events corresponding to whatever commands the SDK generated while
    executing the task (ex timer started, activity task scheduled, etc).
    """

    RespondWorkflowTaskFailed: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.RespondWorkflowTaskFailedRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.RespondWorkflowTaskFailedResponse,
    ]
    """RespondWorkflowTaskFailed is called by workers to indicate the processing of a workflow task
    failed.

    This results in a `WORKFLOW_TASK_FAILED` event written to the history, and a new workflow
    task will be scheduled. This API can be used to report unhandled failures resulting from
    applying the workflow task.

    Temporal will only append first WorkflowTaskFailed event to the history of workflow execution
    for consecutive failures.
    """

    PollActivityTaskQueue: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.PollActivityTaskQueueRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.PollActivityTaskQueueResponse,
    ]
    """PollActivityTaskQueue is called by workers to process activity tasks from a specific task
    queue.

    The worker is expected to call one of the `RespondActivityTaskXXX` methods when it is done
    processing the task.

    An activity task is dispatched whenever a `SCHEDULE_ACTIVITY_TASK` command is produced during
    workflow execution. An in memory `ACTIVITY_TASK_STARTED` event is written to mutable state
    before the task is dispatched to the worker. The started event, and the final event
    (`ACTIVITY_TASK_COMPLETED` / `ACTIVITY_TASK_FAILED` / `ACTIVITY_TASK_TIMED_OUT`) will both be
    written permanently to Workflow execution history when Activity is finished. This is done to
    avoid writing many events in the case of a failure/retry loop.
    """

    RecordActivityTaskHeartbeat: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.RecordActivityTaskHeartbeatRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.RecordActivityTaskHeartbeatResponse,
    ]
    """RecordActivityTaskHeartbeat is optionally called by workers while they execute activities.

    If worker fails to heartbeat within the `heartbeat_timeout` interval for the activity task,
    then it will be marked as timed out and an `ACTIVITY_TASK_TIMED_OUT` event will be written to
    the workflow history. Calling `RecordActivityTaskHeartbeat` will fail with `NotFound` in
    such situations, in that event, the SDK should request cancellation of the activity.
    """

    RecordActivityTaskHeartbeatById: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.RecordActivityTaskHeartbeatByIdRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.RecordActivityTaskHeartbeatByIdResponse,
    ]
    """See `RecordActivityTaskHeartbeat`. This version allows clients to record heartbeats by
    namespace/workflow id/activity id instead of task token.

    (-- api-linter: core::0136::prepositions=disabled
        aip.dev/not-precedent: "By" is used to indicate request type. --)
    """

    RespondActivityTaskCompleted: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.RespondActivityTaskCompletedRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.RespondActivityTaskCompletedResponse,
    ]
    """RespondActivityTaskCompleted is called by workers when they successfully complete an activity
    task.

    This results in a new `ACTIVITY_TASK_COMPLETED` event being written to the workflow history
    and a new workflow task created for the workflow. Fails with `NotFound` if the task token is
    no longer valid due to activity timeout, already being completed, or never having existed.
    """

    RespondActivityTaskCompletedById: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.RespondActivityTaskCompletedByIdRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.RespondActivityTaskCompletedByIdResponse,
    ]
    """See `RecordActivityTaskCompleted`. This version allows clients to record completions by
    namespace/workflow id/activity id instead of task token.

    (-- api-linter: core::0136::prepositions=disabled
        aip.dev/not-precedent: "By" is used to indicate request type. --)
    """

    RespondActivityTaskFailed: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.RespondActivityTaskFailedRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.RespondActivityTaskFailedResponse,
    ]
    """RespondActivityTaskFailed is called by workers when processing an activity task fails.

    This results in a new `ACTIVITY_TASK_FAILED` event being written to the workflow history and
    a new workflow task created for the workflow. Fails with `NotFound` if the task token is no
    longer valid due to activity timeout, already being completed, or never having existed.
    """

    RespondActivityTaskFailedById: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.RespondActivityTaskFailedByIdRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.RespondActivityTaskFailedByIdResponse,
    ]
    """See `RecordActivityTaskFailed`. This version allows clients to record failures by
    namespace/workflow id/activity id instead of task token.

    (-- api-linter: core::0136::prepositions=disabled
        aip.dev/not-precedent: "By" is used to indicate request type. --)
    """

    RespondActivityTaskCanceled: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.RespondActivityTaskCanceledRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.RespondActivityTaskCanceledResponse,
    ]
    """RespondActivityTaskFailed is called by workers when processing an activity task fails.

    This results in a new `ACTIVITY_TASK_CANCELED` event being written to the workflow history
    and a new workflow task created for the workflow. Fails with `NotFound` if the task token is
    no longer valid due to activity timeout, already being completed, or never having existed.
    """

    RespondActivityTaskCanceledById: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.RespondActivityTaskCanceledByIdRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.RespondActivityTaskCanceledByIdResponse,
    ]
    """See `RecordActivityTaskCanceled`. This version allows clients to record failures by
    namespace/workflow id/activity id instead of task token.

    (-- api-linter: core::0136::prepositions=disabled
        aip.dev/not-precedent: "By" is used to indicate request type. --)
    """

    RequestCancelWorkflowExecution: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.RequestCancelWorkflowExecutionRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.RequestCancelWorkflowExecutionResponse,
    ]
    """RequestCancelWorkflowExecution is called by workers when they want to request cancellation of
    a workflow execution.

    This result in a new `WORKFLOW_EXECUTION_CANCEL_REQUESTED` event being written to the
    workflow history and a new workflow task created for the workflow. Fails with `NotFound` if
    the workflow is already completed or doesn't exist.
    """

    SignalWorkflowExecution: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.SignalWorkflowExecutionRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.SignalWorkflowExecutionResponse,
    ]
    """SignalWorkflowExecution is used to send a signal to a running workflow execution.

    This results in a `WORKFLOW_EXECUTION_SIGNALED` event recorded in the history and a workflow
    task being created for the execution.
    """

    SignalWithStartWorkflowExecution: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.SignalWithStartWorkflowExecutionRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.SignalWithStartWorkflowExecutionResponse,
    ]
    """SignalWithStartWorkflowExecution is used to ensure a signal is sent to a workflow, even if
    it isn't yet started.

    If the workflow is running, a `WORKFLOW_EXECUTION_SIGNALED` event is recorded in the history
    and a workflow task is generated.

    If the workflow is not running or not found, then the workflow is created with
    `WORKFLOW_EXECUTION_STARTED` and `WORKFLOW_EXECUTION_SIGNALED` events in its history, and a
    workflow task is generated.

    (-- api-linter: core::0136::prepositions=disabled
        aip.dev/not-precedent: "With" is used to indicate combined operation. --)
    """

    ResetWorkflowExecution: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.ResetWorkflowExecutionRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.ResetWorkflowExecutionResponse,
    ]
    """ResetWorkflowExecution will reset an existing workflow execution to a specified
    `WORKFLOW_TASK_COMPLETED` event (exclusive). It will immediately terminate the current
    execution instance.
    TODO: Does exclusive here mean *just* the completed event, or also WFT started? Otherwise the task is doomed to time out?
    """

    TerminateWorkflowExecution: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.TerminateWorkflowExecutionRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.TerminateWorkflowExecutionResponse,
    ]
    """TerminateWorkflowExecution terminates an existing workflow execution by recording a
    `WORKFLOW_EXECUTION_TERMINATED` event in the history and immediately terminating the
    execution instance.
    """

    ListOpenWorkflowExecutions: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.ListOpenWorkflowExecutionsRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.ListOpenWorkflowExecutionsResponse,
    ]
    """ListOpenWorkflowExecutions is a visibility API to list the open executions in a specific namespace."""

    ListClosedWorkflowExecutions: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.ListClosedWorkflowExecutionsRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.ListClosedWorkflowExecutionsResponse,
    ]
    """ListClosedWorkflowExecutions is a visibility API to list the closed executions in a specific namespace."""

    ListWorkflowExecutions: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.ListWorkflowExecutionsRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.ListWorkflowExecutionsResponse,
    ]
    """ListWorkflowExecutions is a visibility API to list workflow executions in a specific namespace."""

    ListArchivedWorkflowExecutions: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.ListArchivedWorkflowExecutionsRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.ListArchivedWorkflowExecutionsResponse,
    ]
    """ListArchivedWorkflowExecutions is a visibility API to list archived workflow executions in a specific namespace."""

    ScanWorkflowExecutions: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.ScanWorkflowExecutionsRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.ScanWorkflowExecutionsResponse,
    ]
    """ScanWorkflowExecutions is a visibility API to list large amount of workflow executions in a specific namespace without order."""

    CountWorkflowExecutions: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.CountWorkflowExecutionsRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.CountWorkflowExecutionsResponse,
    ]
    """CountWorkflowExecutions is a visibility API to count of workflow executions in a specific namespace."""

    GetSearchAttributes: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.GetSearchAttributesRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.GetSearchAttributesResponse,
    ]
    """GetSearchAttributes is a visibility API to get all legal keys that could be used in list APIs"""

    RespondQueryTaskCompleted: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.RespondQueryTaskCompletedRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.RespondQueryTaskCompletedResponse,
    ]
    """RespondQueryTaskCompleted is called by workers to complete queries which were delivered on
    the `query` (not `queries`) field of a `PollWorkflowTaskQueueResponse`.

    Completing the query will unblock the corresponding client call to `QueryWorkflow` and return
    the query result a response.
    """

    ResetStickyTaskQueue: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.ResetStickyTaskQueueRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.ResetStickyTaskQueueResponse,
    ]
    """ResetStickyTaskQueue resets the sticky task queue related information in the mutable state of
    a given workflow. This is prudent for workers to perform if a workflow has been paged out of
    their cache.

    Things cleared are:
    1. StickyTaskQueue
    2. StickyScheduleToStartTimeout
    """

    QueryWorkflow: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.QueryWorkflowRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.QueryWorkflowResponse,
    ]
    """QueryWorkflow requests a query be executed for a specified workflow execution."""

    DescribeWorkflowExecution: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.DescribeWorkflowExecutionRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.DescribeWorkflowExecutionResponse,
    ]
    """DescribeWorkflowExecution returns information about the specified workflow execution."""

    DescribeTaskQueue: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.DescribeTaskQueueRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.DescribeTaskQueueResponse,
    ]
    """DescribeTaskQueue returns information about the target task queue."""

    GetClusterInfo: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.GetClusterInfoRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.GetClusterInfoResponse,
    ]
    """GetClusterInfo returns information about temporal cluster"""

    GetSystemInfo: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.GetSystemInfoRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.GetSystemInfoResponse,
    ]
    """GetSystemInfo returns information about the system."""

    ListTaskQueuePartitions: grpc.UnaryUnaryMultiCallable[
        temporalio.api.workflowservice.v1.request_response_pb2.ListTaskQueuePartitionsRequest,
        temporalio.api.workflowservice.v1.request_response_pb2.ListTaskQueuePartitionsResponse,
    ]

class WorkflowServiceServicer(metaclass=abc.ABCMeta):
    """WorkflowService API defines how Temporal SDKs and other clients interact with the Temporal server
    to create and interact with workflows and activities.

    Users are expected to call `StartWorkflowExecution` to create a new workflow execution.

    To drive workflows, a worker using a Temporal SDK must exist which regularly polls for workflow
    and activity tasks from the service. For each workflow task, the sdk must process the
    (incremental or complete) event history and respond back with any newly generated commands.

    For each activity task, the worker is expected to execute the user's code which implements that
    activity, responding with completion or failure.
    """

    @abc.abstractmethod
    def RegisterNamespace(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.RegisterNamespaceRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.RegisterNamespaceResponse:
        """RegisterNamespace creates a new namespace which can be used as a container for all resources.

        A Namespace is a top level entity within Temporal, and is used as a container for resources
        like workflow executions, task queues, etc. A Namespace acts as a sandbox and provides
        isolation for all resources within the namespace. All resources belongs to exactly one
        namespace.
        """
        pass
    @abc.abstractmethod
    def DescribeNamespace(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.DescribeNamespaceRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.DescribeNamespaceResponse:
        """DescribeNamespace returns the information and configuration for a registered namespace."""
        pass
    @abc.abstractmethod
    def ListNamespaces(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.ListNamespacesRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.ListNamespacesResponse:
        """ListNamespaces returns the information and configuration for all namespaces."""
        pass
    @abc.abstractmethod
    def UpdateNamespace(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.UpdateNamespaceRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.UpdateNamespaceResponse:
        """UpdateNamespace is used to update the information and configuration of a registered
        namespace.

        (-- api-linter: core::0134::method-signature=disabled
            aip.dev/not-precedent: UpdateNamespace RPC doesn't follow Google API format. --)
        (-- api-linter: core::0134::response-message-name=disabled
            aip.dev/not-precedent: UpdateNamespace RPC doesn't follow Google API format. --)
        """
        pass
    @abc.abstractmethod
    def DeprecateNamespace(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.DeprecateNamespaceRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.DeprecateNamespaceResponse:
        """DeprecateNamespace is used to update the state of a registered namespace to DEPRECATED.

        Once the namespace is deprecated it cannot be used to start new workflow executions. Existing
        workflow executions will continue to run on deprecated namespaces.
        Deprecated.
        """
        pass
    @abc.abstractmethod
    def StartWorkflowExecution(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.StartWorkflowExecutionRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.StartWorkflowExecutionResponse:
        """StartWorkflowExecution starts a new workflow execution.

        It will create the execution with a `WORKFLOW_EXECUTION_STARTED` event in its history and
        also schedule the first workflow task. Returns `WorkflowExecutionAlreadyStarted`, if an
        instance already exists with same workflow id.
        """
        pass
    @abc.abstractmethod
    def GetWorkflowExecutionHistory(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.GetWorkflowExecutionHistoryRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.GetWorkflowExecutionHistoryResponse:
        """GetWorkflowExecutionHistory returns the history of specified workflow execution. Fails with
        `NotFound` if the specified workflow execution is unknown to the service.
        """
        pass
    @abc.abstractmethod
    def GetWorkflowExecutionHistoryReverse(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.GetWorkflowExecutionHistoryReverseRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.GetWorkflowExecutionHistoryReverseResponse:
        """GetWorkflowExecutionHistoryReverse returns the history of specified workflow execution in reverse
        order (starting from last event). Fails with`NotFound` if the specified workflow execution is
        unknown to the service.
        """
        pass
    @abc.abstractmethod
    def PollWorkflowTaskQueue(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.PollWorkflowTaskQueueRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.PollWorkflowTaskQueueResponse:
        """PollWorkflowTaskQueue is called by workers to make progress on workflows.

        A WorkflowTask is dispatched to callers for active workflow executions with pending workflow
        tasks. The worker is expected to call `RespondWorkflowTaskCompleted` when it is done
        processing the task. The service will create a `WorkflowTaskStarted` event in the history for
        this task before handing it to the worker.
        """
        pass
    @abc.abstractmethod
    def RespondWorkflowTaskCompleted(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.RespondWorkflowTaskCompletedRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.RespondWorkflowTaskCompletedResponse:
        """RespondWorkflowTaskCompleted is called by workers to successfully complete workflow tasks
        they received from `PollWorkflowTaskQueue`.

        Completing a WorkflowTask will write a `WORKFLOW_TASK_COMPLETED` event to the workflow's
        history, along with events corresponding to whatever commands the SDK generated while
        executing the task (ex timer started, activity task scheduled, etc).
        """
        pass
    @abc.abstractmethod
    def RespondWorkflowTaskFailed(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.RespondWorkflowTaskFailedRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.RespondWorkflowTaskFailedResponse:
        """RespondWorkflowTaskFailed is called by workers to indicate the processing of a workflow task
        failed.

        This results in a `WORKFLOW_TASK_FAILED` event written to the history, and a new workflow
        task will be scheduled. This API can be used to report unhandled failures resulting from
        applying the workflow task.

        Temporal will only append first WorkflowTaskFailed event to the history of workflow execution
        for consecutive failures.
        """
        pass
    @abc.abstractmethod
    def PollActivityTaskQueue(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.PollActivityTaskQueueRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.PollActivityTaskQueueResponse:
        """PollActivityTaskQueue is called by workers to process activity tasks from a specific task
        queue.

        The worker is expected to call one of the `RespondActivityTaskXXX` methods when it is done
        processing the task.

        An activity task is dispatched whenever a `SCHEDULE_ACTIVITY_TASK` command is produced during
        workflow execution. An in memory `ACTIVITY_TASK_STARTED` event is written to mutable state
        before the task is dispatched to the worker. The started event, and the final event
        (`ACTIVITY_TASK_COMPLETED` / `ACTIVITY_TASK_FAILED` / `ACTIVITY_TASK_TIMED_OUT`) will both be
        written permanently to Workflow execution history when Activity is finished. This is done to
        avoid writing many events in the case of a failure/retry loop.
        """
        pass
    @abc.abstractmethod
    def RecordActivityTaskHeartbeat(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.RecordActivityTaskHeartbeatRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.RecordActivityTaskHeartbeatResponse:
        """RecordActivityTaskHeartbeat is optionally called by workers while they execute activities.

        If worker fails to heartbeat within the `heartbeat_timeout` interval for the activity task,
        then it will be marked as timed out and an `ACTIVITY_TASK_TIMED_OUT` event will be written to
        the workflow history. Calling `RecordActivityTaskHeartbeat` will fail with `NotFound` in
        such situations, in that event, the SDK should request cancellation of the activity.
        """
        pass
    @abc.abstractmethod
    def RecordActivityTaskHeartbeatById(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.RecordActivityTaskHeartbeatByIdRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.RecordActivityTaskHeartbeatByIdResponse:
        """See `RecordActivityTaskHeartbeat`. This version allows clients to record heartbeats by
        namespace/workflow id/activity id instead of task token.

        (-- api-linter: core::0136::prepositions=disabled
            aip.dev/not-precedent: "By" is used to indicate request type. --)
        """
        pass
    @abc.abstractmethod
    def RespondActivityTaskCompleted(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.RespondActivityTaskCompletedRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.RespondActivityTaskCompletedResponse:
        """RespondActivityTaskCompleted is called by workers when they successfully complete an activity
        task.

        This results in a new `ACTIVITY_TASK_COMPLETED` event being written to the workflow history
        and a new workflow task created for the workflow. Fails with `NotFound` if the task token is
        no longer valid due to activity timeout, already being completed, or never having existed.
        """
        pass
    @abc.abstractmethod
    def RespondActivityTaskCompletedById(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.RespondActivityTaskCompletedByIdRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.RespondActivityTaskCompletedByIdResponse:
        """See `RecordActivityTaskCompleted`. This version allows clients to record completions by
        namespace/workflow id/activity id instead of task token.

        (-- api-linter: core::0136::prepositions=disabled
            aip.dev/not-precedent: "By" is used to indicate request type. --)
        """
        pass
    @abc.abstractmethod
    def RespondActivityTaskFailed(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.RespondActivityTaskFailedRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.RespondActivityTaskFailedResponse:
        """RespondActivityTaskFailed is called by workers when processing an activity task fails.

        This results in a new `ACTIVITY_TASK_FAILED` event being written to the workflow history and
        a new workflow task created for the workflow. Fails with `NotFound` if the task token is no
        longer valid due to activity timeout, already being completed, or never having existed.
        """
        pass
    @abc.abstractmethod
    def RespondActivityTaskFailedById(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.RespondActivityTaskFailedByIdRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.RespondActivityTaskFailedByIdResponse:
        """See `RecordActivityTaskFailed`. This version allows clients to record failures by
        namespace/workflow id/activity id instead of task token.

        (-- api-linter: core::0136::prepositions=disabled
            aip.dev/not-precedent: "By" is used to indicate request type. --)
        """
        pass
    @abc.abstractmethod
    def RespondActivityTaskCanceled(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.RespondActivityTaskCanceledRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.RespondActivityTaskCanceledResponse:
        """RespondActivityTaskFailed is called by workers when processing an activity task fails.

        This results in a new `ACTIVITY_TASK_CANCELED` event being written to the workflow history
        and a new workflow task created for the workflow. Fails with `NotFound` if the task token is
        no longer valid due to activity timeout, already being completed, or never having existed.
        """
        pass
    @abc.abstractmethod
    def RespondActivityTaskCanceledById(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.RespondActivityTaskCanceledByIdRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.RespondActivityTaskCanceledByIdResponse:
        """See `RecordActivityTaskCanceled`. This version allows clients to record failures by
        namespace/workflow id/activity id instead of task token.

        (-- api-linter: core::0136::prepositions=disabled
            aip.dev/not-precedent: "By" is used to indicate request type. --)
        """
        pass
    @abc.abstractmethod
    def RequestCancelWorkflowExecution(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.RequestCancelWorkflowExecutionRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.RequestCancelWorkflowExecutionResponse:
        """RequestCancelWorkflowExecution is called by workers when they want to request cancellation of
        a workflow execution.

        This result in a new `WORKFLOW_EXECUTION_CANCEL_REQUESTED` event being written to the
        workflow history and a new workflow task created for the workflow. Fails with `NotFound` if
        the workflow is already completed or doesn't exist.
        """
        pass
    @abc.abstractmethod
    def SignalWorkflowExecution(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.SignalWorkflowExecutionRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.SignalWorkflowExecutionResponse:
        """SignalWorkflowExecution is used to send a signal to a running workflow execution.

        This results in a `WORKFLOW_EXECUTION_SIGNALED` event recorded in the history and a workflow
        task being created for the execution.
        """
        pass
    @abc.abstractmethod
    def SignalWithStartWorkflowExecution(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.SignalWithStartWorkflowExecutionRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.SignalWithStartWorkflowExecutionResponse:
        """SignalWithStartWorkflowExecution is used to ensure a signal is sent to a workflow, even if
        it isn't yet started.

        If the workflow is running, a `WORKFLOW_EXECUTION_SIGNALED` event is recorded in the history
        and a workflow task is generated.

        If the workflow is not running or not found, then the workflow is created with
        `WORKFLOW_EXECUTION_STARTED` and `WORKFLOW_EXECUTION_SIGNALED` events in its history, and a
        workflow task is generated.

        (-- api-linter: core::0136::prepositions=disabled
            aip.dev/not-precedent: "With" is used to indicate combined operation. --)
        """
        pass
    @abc.abstractmethod
    def ResetWorkflowExecution(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.ResetWorkflowExecutionRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.ResetWorkflowExecutionResponse:
        """ResetWorkflowExecution will reset an existing workflow execution to a specified
        `WORKFLOW_TASK_COMPLETED` event (exclusive). It will immediately terminate the current
        execution instance.
        TODO: Does exclusive here mean *just* the completed event, or also WFT started? Otherwise the task is doomed to time out?
        """
        pass
    @abc.abstractmethod
    def TerminateWorkflowExecution(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.TerminateWorkflowExecutionRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.TerminateWorkflowExecutionResponse:
        """TerminateWorkflowExecution terminates an existing workflow execution by recording a
        `WORKFLOW_EXECUTION_TERMINATED` event in the history and immediately terminating the
        execution instance.
        """
        pass
    @abc.abstractmethod
    def ListOpenWorkflowExecutions(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.ListOpenWorkflowExecutionsRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.ListOpenWorkflowExecutionsResponse:
        """ListOpenWorkflowExecutions is a visibility API to list the open executions in a specific namespace."""
        pass
    @abc.abstractmethod
    def ListClosedWorkflowExecutions(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.ListClosedWorkflowExecutionsRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.ListClosedWorkflowExecutionsResponse:
        """ListClosedWorkflowExecutions is a visibility API to list the closed executions in a specific namespace."""
        pass
    @abc.abstractmethod
    def ListWorkflowExecutions(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.ListWorkflowExecutionsRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.ListWorkflowExecutionsResponse:
        """ListWorkflowExecutions is a visibility API to list workflow executions in a specific namespace."""
        pass
    @abc.abstractmethod
    def ListArchivedWorkflowExecutions(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.ListArchivedWorkflowExecutionsRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.ListArchivedWorkflowExecutionsResponse:
        """ListArchivedWorkflowExecutions is a visibility API to list archived workflow executions in a specific namespace."""
        pass
    @abc.abstractmethod
    def ScanWorkflowExecutions(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.ScanWorkflowExecutionsRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.ScanWorkflowExecutionsResponse:
        """ScanWorkflowExecutions is a visibility API to list large amount of workflow executions in a specific namespace without order."""
        pass
    @abc.abstractmethod
    def CountWorkflowExecutions(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.CountWorkflowExecutionsRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.CountWorkflowExecutionsResponse:
        """CountWorkflowExecutions is a visibility API to count of workflow executions in a specific namespace."""
        pass
    @abc.abstractmethod
    def GetSearchAttributes(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.GetSearchAttributesRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.GetSearchAttributesResponse:
        """GetSearchAttributes is a visibility API to get all legal keys that could be used in list APIs"""
        pass
    @abc.abstractmethod
    def RespondQueryTaskCompleted(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.RespondQueryTaskCompletedRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.RespondQueryTaskCompletedResponse:
        """RespondQueryTaskCompleted is called by workers to complete queries which were delivered on
        the `query` (not `queries`) field of a `PollWorkflowTaskQueueResponse`.

        Completing the query will unblock the corresponding client call to `QueryWorkflow` and return
        the query result a response.
        """
        pass
    @abc.abstractmethod
    def ResetStickyTaskQueue(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.ResetStickyTaskQueueRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.ResetStickyTaskQueueResponse:
        """ResetStickyTaskQueue resets the sticky task queue related information in the mutable state of
        a given workflow. This is prudent for workers to perform if a workflow has been paged out of
        their cache.

        Things cleared are:
        1. StickyTaskQueue
        2. StickyScheduleToStartTimeout
        """
        pass
    @abc.abstractmethod
    def QueryWorkflow(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.QueryWorkflowRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.QueryWorkflowResponse:
        """QueryWorkflow requests a query be executed for a specified workflow execution."""
        pass
    @abc.abstractmethod
    def DescribeWorkflowExecution(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.DescribeWorkflowExecutionRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.DescribeWorkflowExecutionResponse:
        """DescribeWorkflowExecution returns information about the specified workflow execution."""
        pass
    @abc.abstractmethod
    def DescribeTaskQueue(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.DescribeTaskQueueRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.DescribeTaskQueueResponse:
        """DescribeTaskQueue returns information about the target task queue."""
        pass
    @abc.abstractmethod
    def GetClusterInfo(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.GetClusterInfoRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.GetClusterInfoResponse:
        """GetClusterInfo returns information about temporal cluster"""
        pass
    @abc.abstractmethod
    def GetSystemInfo(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.GetSystemInfoRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.GetSystemInfoResponse:
        """GetSystemInfo returns information about the system."""
        pass
    @abc.abstractmethod
    def ListTaskQueuePartitions(
        self,
        request: temporalio.api.workflowservice.v1.request_response_pb2.ListTaskQueuePartitionsRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.workflowservice.v1.request_response_pb2.ListTaskQueuePartitionsResponse: ...

def add_WorkflowServiceServicer_to_server(
    servicer: WorkflowServiceServicer, server: grpc.Server
) -> None: ...
