# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from temporalio.api.workflowservice.v1 import (
    request_response_pb2 as temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2,
)


class WorkflowServiceStub(object):
    """WorkflowService API defines how Temporal SDKs and other clients interact with the Temporal server
    to create and interact with workflows and activities.

    Users are expected to call `StartWorkflowExecution` to create a new workflow execution.

    To drive workflows, a worker using a Temporal SDK must exist which regularly polls for workflow
    and activity tasks from the service. For each workflow task, the sdk must process the
    (incremental or complete) event history and respond back with any newly generated commands.

    For each activity task, the worker is expected to execute the user's code which implements that
    activity, responding with completion or failure.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.RegisterNamespace = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/RegisterNamespace",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RegisterNamespaceRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RegisterNamespaceResponse.FromString,
        )
        self.DescribeNamespace = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/DescribeNamespace",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.DescribeNamespaceRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.DescribeNamespaceResponse.FromString,
        )
        self.ListNamespaces = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/ListNamespaces",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListNamespacesRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListNamespacesResponse.FromString,
        )
        self.UpdateNamespace = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/UpdateNamespace",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.UpdateNamespaceRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.UpdateNamespaceResponse.FromString,
        )
        self.DeprecateNamespace = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/DeprecateNamespace",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.DeprecateNamespaceRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.DeprecateNamespaceResponse.FromString,
        )
        self.StartWorkflowExecution = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/StartWorkflowExecution",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.StartWorkflowExecutionRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.StartWorkflowExecutionResponse.FromString,
        )
        self.GetWorkflowExecutionHistory = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/GetWorkflowExecutionHistory",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetWorkflowExecutionHistoryRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetWorkflowExecutionHistoryResponse.FromString,
        )
        self.GetWorkflowExecutionHistoryReverse = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/GetWorkflowExecutionHistoryReverse",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetWorkflowExecutionHistoryReverseRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetWorkflowExecutionHistoryReverseResponse.FromString,
        )
        self.PollWorkflowTaskQueue = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/PollWorkflowTaskQueue",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.PollWorkflowTaskQueueRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.PollWorkflowTaskQueueResponse.FromString,
        )
        self.RespondWorkflowTaskCompleted = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/RespondWorkflowTaskCompleted",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondWorkflowTaskCompletedRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondWorkflowTaskCompletedResponse.FromString,
        )
        self.RespondWorkflowTaskFailed = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/RespondWorkflowTaskFailed",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondWorkflowTaskFailedRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondWorkflowTaskFailedResponse.FromString,
        )
        self.PollActivityTaskQueue = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/PollActivityTaskQueue",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.PollActivityTaskQueueRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.PollActivityTaskQueueResponse.FromString,
        )
        self.RecordActivityTaskHeartbeat = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/RecordActivityTaskHeartbeat",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RecordActivityTaskHeartbeatRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RecordActivityTaskHeartbeatResponse.FromString,
        )
        self.RecordActivityTaskHeartbeatById = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/RecordActivityTaskHeartbeatById",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RecordActivityTaskHeartbeatByIdRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RecordActivityTaskHeartbeatByIdResponse.FromString,
        )
        self.RespondActivityTaskCompleted = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/RespondActivityTaskCompleted",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskCompletedRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskCompletedResponse.FromString,
        )
        self.RespondActivityTaskCompletedById = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/RespondActivityTaskCompletedById",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskCompletedByIdRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskCompletedByIdResponse.FromString,
        )
        self.RespondActivityTaskFailed = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/RespondActivityTaskFailed",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskFailedRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskFailedResponse.FromString,
        )
        self.RespondActivityTaskFailedById = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/RespondActivityTaskFailedById",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskFailedByIdRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskFailedByIdResponse.FromString,
        )
        self.RespondActivityTaskCanceled = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/RespondActivityTaskCanceled",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskCanceledRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskCanceledResponse.FromString,
        )
        self.RespondActivityTaskCanceledById = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/RespondActivityTaskCanceledById",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskCanceledByIdRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskCanceledByIdResponse.FromString,
        )
        self.RequestCancelWorkflowExecution = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/RequestCancelWorkflowExecution",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RequestCancelWorkflowExecutionRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RequestCancelWorkflowExecutionResponse.FromString,
        )
        self.SignalWorkflowExecution = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/SignalWorkflowExecution",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.SignalWorkflowExecutionRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.SignalWorkflowExecutionResponse.FromString,
        )
        self.SignalWithStartWorkflowExecution = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/SignalWithStartWorkflowExecution",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.SignalWithStartWorkflowExecutionRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.SignalWithStartWorkflowExecutionResponse.FromString,
        )
        self.ResetWorkflowExecution = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/ResetWorkflowExecution",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ResetWorkflowExecutionRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ResetWorkflowExecutionResponse.FromString,
        )
        self.TerminateWorkflowExecution = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/TerminateWorkflowExecution",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.TerminateWorkflowExecutionRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.TerminateWorkflowExecutionResponse.FromString,
        )
        self.ListOpenWorkflowExecutions = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/ListOpenWorkflowExecutions",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListOpenWorkflowExecutionsRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListOpenWorkflowExecutionsResponse.FromString,
        )
        self.ListClosedWorkflowExecutions = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/ListClosedWorkflowExecutions",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListClosedWorkflowExecutionsRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListClosedWorkflowExecutionsResponse.FromString,
        )
        self.ListWorkflowExecutions = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/ListWorkflowExecutions",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListWorkflowExecutionsRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListWorkflowExecutionsResponse.FromString,
        )
        self.ListArchivedWorkflowExecutions = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/ListArchivedWorkflowExecutions",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListArchivedWorkflowExecutionsRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListArchivedWorkflowExecutionsResponse.FromString,
        )
        self.ScanWorkflowExecutions = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/ScanWorkflowExecutions",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ScanWorkflowExecutionsRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ScanWorkflowExecutionsResponse.FromString,
        )
        self.CountWorkflowExecutions = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/CountWorkflowExecutions",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.CountWorkflowExecutionsRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.CountWorkflowExecutionsResponse.FromString,
        )
        self.GetSearchAttributes = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/GetSearchAttributes",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetSearchAttributesRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetSearchAttributesResponse.FromString,
        )
        self.RespondQueryTaskCompleted = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/RespondQueryTaskCompleted",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondQueryTaskCompletedRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondQueryTaskCompletedResponse.FromString,
        )
        self.ResetStickyTaskQueue = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/ResetStickyTaskQueue",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ResetStickyTaskQueueRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ResetStickyTaskQueueResponse.FromString,
        )
        self.QueryWorkflow = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/QueryWorkflow",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.QueryWorkflowRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.QueryWorkflowResponse.FromString,
        )
        self.DescribeWorkflowExecution = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/DescribeWorkflowExecution",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.DescribeWorkflowExecutionRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.DescribeWorkflowExecutionResponse.FromString,
        )
        self.DescribeTaskQueue = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/DescribeTaskQueue",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.DescribeTaskQueueRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.DescribeTaskQueueResponse.FromString,
        )
        self.GetClusterInfo = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/GetClusterInfo",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetClusterInfoRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetClusterInfoResponse.FromString,
        )
        self.GetSystemInfo = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/GetSystemInfo",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetSystemInfoRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetSystemInfoResponse.FromString,
        )
        self.ListTaskQueuePartitions = channel.unary_unary(
            "/temporal.api.workflowservice.v1.WorkflowService/ListTaskQueuePartitions",
            request_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListTaskQueuePartitionsRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListTaskQueuePartitionsResponse.FromString,
        )


class WorkflowServiceServicer(object):
    """WorkflowService API defines how Temporal SDKs and other clients interact with the Temporal server
    to create and interact with workflows and activities.

    Users are expected to call `StartWorkflowExecution` to create a new workflow execution.

    To drive workflows, a worker using a Temporal SDK must exist which regularly polls for workflow
    and activity tasks from the service. For each workflow task, the sdk must process the
    (incremental or complete) event history and respond back with any newly generated commands.

    For each activity task, the worker is expected to execute the user's code which implements that
    activity, responding with completion or failure.
    """

    def RegisterNamespace(self, request, context):
        """RegisterNamespace creates a new namespace which can be used as a container for all resources.

        A Namespace is a top level entity within Temporal, and is used as a container for resources
        like workflow executions, task queues, etc. A Namespace acts as a sandbox and provides
        isolation for all resources within the namespace. All resources belongs to exactly one
        namespace.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def DescribeNamespace(self, request, context):
        """DescribeNamespace returns the information and configuration for a registered namespace."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def ListNamespaces(self, request, context):
        """ListNamespaces returns the information and configuration for all namespaces."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def UpdateNamespace(self, request, context):
        """UpdateNamespace is used to update the information and configuration of a registered
        namespace.

        (-- api-linter: core::0134::method-signature=disabled
        aip.dev/not-precedent: UpdateNamespace RPC doesn't follow Google API format. --)
        (-- api-linter: core::0134::response-message-name=disabled
        aip.dev/not-precedent: UpdateNamespace RPC doesn't follow Google API format. --)
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def DeprecateNamespace(self, request, context):
        """DeprecateNamespace is used to update the state of a registered namespace to DEPRECATED.

        Once the namespace is deprecated it cannot be used to start new workflow executions. Existing
        workflow executions will continue to run on deprecated namespaces.
        Deprecated.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def StartWorkflowExecution(self, request, context):
        """StartWorkflowExecution starts a new workflow execution.

        It will create the execution with a `WORKFLOW_EXECUTION_STARTED` event in its history and
        also schedule the first workflow task. Returns `WorkflowExecutionAlreadyStarted`, if an
        instance already exists with same workflow id.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def GetWorkflowExecutionHistory(self, request, context):
        """GetWorkflowExecutionHistory returns the history of specified workflow execution. Fails with
        `NotFound` if the specified workflow execution is unknown to the service.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def GetWorkflowExecutionHistoryReverse(self, request, context):
        """GetWorkflowExecutionHistoryReverse returns the history of specified workflow execution in reverse
        order (starting from last event). Fails with`NotFound` if the specified workflow execution is
        unknown to the service.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def PollWorkflowTaskQueue(self, request, context):
        """PollWorkflowTaskQueue is called by workers to make progress on workflows.

        A WorkflowTask is dispatched to callers for active workflow executions with pending workflow
        tasks. The worker is expected to call `RespondWorkflowTaskCompleted` when it is done
        processing the task. The service will create a `WorkflowTaskStarted` event in the history for
        this task before handing it to the worker.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def RespondWorkflowTaskCompleted(self, request, context):
        """RespondWorkflowTaskCompleted is called by workers to successfully complete workflow tasks
        they received from `PollWorkflowTaskQueue`.

        Completing a WorkflowTask will write a `WORKFLOW_TASK_COMPLETED` event to the workflow's
        history, along with events corresponding to whatever commands the SDK generated while
        executing the task (ex timer started, activity task scheduled, etc).
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def RespondWorkflowTaskFailed(self, request, context):
        """RespondWorkflowTaskFailed is called by workers to indicate the processing of a workflow task
        failed.

        This results in a `WORKFLOW_TASK_FAILED` event written to the history, and a new workflow
        task will be scheduled. This API can be used to report unhandled failures resulting from
        applying the workflow task.

        Temporal will only append first WorkflowTaskFailed event to the history of workflow execution
        for consecutive failures.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def PollActivityTaskQueue(self, request, context):
        """PollActivityTaskQueue is called by workers to process activity tasks from a specific task
        queue.

        The worker is expected to call one of the `RespondActivityTaskXXX` methods when it is done
        processing the task.

        An activity task is dispatched whenever a `SCHEDULE_ACTIVITY_TASK` command is produced during
        workflow execution. An in memory `ACTIVITY_TASK_STARTED` event is written to mutable state
        before the task is dispatched to the worker. The started event, and the final event
        (`ACTIVITY_TASK_COMPLETED` / `ACTIVITY_TASK_FAILED` / `ACTIVITY_TASK_TIMED_OUT`) will both be
        written permanently to Workflow execution history when Activity is finished. This is done to
        avoid writing many events in the case of a failure/retry loop.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def RecordActivityTaskHeartbeat(self, request, context):
        """RecordActivityTaskHeartbeat is optionally called by workers while they execute activities.

        If worker fails to heartbeat within the `heartbeat_timeout` interval for the activity task,
        then it will be marked as timed out and an `ACTIVITY_TASK_TIMED_OUT` event will be written to
        the workflow history. Calling `RecordActivityTaskHeartbeat` will fail with `NotFound` in
        such situations, in that event, the SDK should request cancellation of the activity.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def RecordActivityTaskHeartbeatById(self, request, context):
        """See `RecordActivityTaskHeartbeat`. This version allows clients to record heartbeats by
        namespace/workflow id/activity id instead of task token.

        (-- api-linter: core::0136::prepositions=disabled
        aip.dev/not-precedent: "By" is used to indicate request type. --)
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def RespondActivityTaskCompleted(self, request, context):
        """RespondActivityTaskCompleted is called by workers when they successfully complete an activity
        task.

        This results in a new `ACTIVITY_TASK_COMPLETED` event being written to the workflow history
        and a new workflow task created for the workflow. Fails with `NotFound` if the task token is
        no longer valid due to activity timeout, already being completed, or never having existed.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def RespondActivityTaskCompletedById(self, request, context):
        """See `RecordActivityTaskCompleted`. This version allows clients to record completions by
        namespace/workflow id/activity id instead of task token.

        (-- api-linter: core::0136::prepositions=disabled
        aip.dev/not-precedent: "By" is used to indicate request type. --)
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def RespondActivityTaskFailed(self, request, context):
        """RespondActivityTaskFailed is called by workers when processing an activity task fails.

        This results in a new `ACTIVITY_TASK_FAILED` event being written to the workflow history and
        a new workflow task created for the workflow. Fails with `NotFound` if the task token is no
        longer valid due to activity timeout, already being completed, or never having existed.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def RespondActivityTaskFailedById(self, request, context):
        """See `RecordActivityTaskFailed`. This version allows clients to record failures by
        namespace/workflow id/activity id instead of task token.

        (-- api-linter: core::0136::prepositions=disabled
        aip.dev/not-precedent: "By" is used to indicate request type. --)
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def RespondActivityTaskCanceled(self, request, context):
        """RespondActivityTaskFailed is called by workers when processing an activity task fails.

        This results in a new `ACTIVITY_TASK_CANCELED` event being written to the workflow history
        and a new workflow task created for the workflow. Fails with `NotFound` if the task token is
        no longer valid due to activity timeout, already being completed, or never having existed.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def RespondActivityTaskCanceledById(self, request, context):
        """See `RecordActivityTaskCanceled`. This version allows clients to record failures by
        namespace/workflow id/activity id instead of task token.

        (-- api-linter: core::0136::prepositions=disabled
        aip.dev/not-precedent: "By" is used to indicate request type. --)
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def RequestCancelWorkflowExecution(self, request, context):
        """RequestCancelWorkflowExecution is called by workers when they want to request cancellation of
        a workflow execution.

        This result in a new `WORKFLOW_EXECUTION_CANCEL_REQUESTED` event being written to the
        workflow history and a new workflow task created for the workflow. Fails with `NotFound` if
        the workflow is already completed or doesn't exist.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def SignalWorkflowExecution(self, request, context):
        """SignalWorkflowExecution is used to send a signal to a running workflow execution.

        This results in a `WORKFLOW_EXECUTION_SIGNALED` event recorded in the history and a workflow
        task being created for the execution.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def SignalWithStartWorkflowExecution(self, request, context):
        """SignalWithStartWorkflowExecution is used to ensure a signal is sent to a workflow, even if
        it isn't yet started.

        If the workflow is running, a `WORKFLOW_EXECUTION_SIGNALED` event is recorded in the history
        and a workflow task is generated.

        If the workflow is not running or not found, then the workflow is created with
        `WORKFLOW_EXECUTION_STARTED` and `WORKFLOW_EXECUTION_SIGNALED` events in its history, and a
        workflow task is generated.

        (-- api-linter: core::0136::prepositions=disabled
        aip.dev/not-precedent: "With" is used to indicate combined operation. --)
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def ResetWorkflowExecution(self, request, context):
        """ResetWorkflowExecution will reset an existing workflow execution to a specified
        `WORKFLOW_TASK_COMPLETED` event (exclusive). It will immediately terminate the current
        execution instance.
        TODO: Does exclusive here mean *just* the completed event, or also WFT started? Otherwise the task is doomed to time out?
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def TerminateWorkflowExecution(self, request, context):
        """TerminateWorkflowExecution terminates an existing workflow execution by recording a
        `WORKFLOW_EXECUTION_TERMINATED` event in the history and immediately terminating the
        execution instance.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def ListOpenWorkflowExecutions(self, request, context):
        """ListOpenWorkflowExecutions is a visibility API to list the open executions in a specific namespace."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def ListClosedWorkflowExecutions(self, request, context):
        """ListClosedWorkflowExecutions is a visibility API to list the closed executions in a specific namespace."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def ListWorkflowExecutions(self, request, context):
        """ListWorkflowExecutions is a visibility API to list workflow executions in a specific namespace."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def ListArchivedWorkflowExecutions(self, request, context):
        """ListArchivedWorkflowExecutions is a visibility API to list archived workflow executions in a specific namespace."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def ScanWorkflowExecutions(self, request, context):
        """ScanWorkflowExecutions is a visibility API to list large amount of workflow executions in a specific namespace without order."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def CountWorkflowExecutions(self, request, context):
        """CountWorkflowExecutions is a visibility API to count of workflow executions in a specific namespace."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def GetSearchAttributes(self, request, context):
        """GetSearchAttributes is a visibility API to get all legal keys that could be used in list APIs"""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def RespondQueryTaskCompleted(self, request, context):
        """RespondQueryTaskCompleted is called by workers to complete queries which were delivered on
        the `query` (not `queries`) field of a `PollWorkflowTaskQueueResponse`.

        Completing the query will unblock the corresponding client call to `QueryWorkflow` and return
        the query result a response.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def ResetStickyTaskQueue(self, request, context):
        """ResetStickyTaskQueue resets the sticky task queue related information in the mutable state of
        a given workflow. This is prudent for workers to perform if a workflow has been paged out of
        their cache.

        Things cleared are:
        1. StickyTaskQueue
        2. StickyScheduleToStartTimeout
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def QueryWorkflow(self, request, context):
        """QueryWorkflow requests a query be executed for a specified workflow execution."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def DescribeWorkflowExecution(self, request, context):
        """DescribeWorkflowExecution returns information about the specified workflow execution."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def DescribeTaskQueue(self, request, context):
        """DescribeTaskQueue returns information about the target task queue."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def GetClusterInfo(self, request, context):
        """GetClusterInfo returns information about temporal cluster"""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def GetSystemInfo(self, request, context):
        """GetSystemInfo returns information about the system."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def ListTaskQueuePartitions(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")


def add_WorkflowServiceServicer_to_server(servicer, server):
    rpc_method_handlers = {
        "RegisterNamespace": grpc.unary_unary_rpc_method_handler(
            servicer.RegisterNamespace,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RegisterNamespaceRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RegisterNamespaceResponse.SerializeToString,
        ),
        "DescribeNamespace": grpc.unary_unary_rpc_method_handler(
            servicer.DescribeNamespace,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.DescribeNamespaceRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.DescribeNamespaceResponse.SerializeToString,
        ),
        "ListNamespaces": grpc.unary_unary_rpc_method_handler(
            servicer.ListNamespaces,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListNamespacesRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListNamespacesResponse.SerializeToString,
        ),
        "UpdateNamespace": grpc.unary_unary_rpc_method_handler(
            servicer.UpdateNamespace,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.UpdateNamespaceRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.UpdateNamespaceResponse.SerializeToString,
        ),
        "DeprecateNamespace": grpc.unary_unary_rpc_method_handler(
            servicer.DeprecateNamespace,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.DeprecateNamespaceRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.DeprecateNamespaceResponse.SerializeToString,
        ),
        "StartWorkflowExecution": grpc.unary_unary_rpc_method_handler(
            servicer.StartWorkflowExecution,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.StartWorkflowExecutionRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.StartWorkflowExecutionResponse.SerializeToString,
        ),
        "GetWorkflowExecutionHistory": grpc.unary_unary_rpc_method_handler(
            servicer.GetWorkflowExecutionHistory,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetWorkflowExecutionHistoryRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetWorkflowExecutionHistoryResponse.SerializeToString,
        ),
        "GetWorkflowExecutionHistoryReverse": grpc.unary_unary_rpc_method_handler(
            servicer.GetWorkflowExecutionHistoryReverse,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetWorkflowExecutionHistoryReverseRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetWorkflowExecutionHistoryReverseResponse.SerializeToString,
        ),
        "PollWorkflowTaskQueue": grpc.unary_unary_rpc_method_handler(
            servicer.PollWorkflowTaskQueue,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.PollWorkflowTaskQueueRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.PollWorkflowTaskQueueResponse.SerializeToString,
        ),
        "RespondWorkflowTaskCompleted": grpc.unary_unary_rpc_method_handler(
            servicer.RespondWorkflowTaskCompleted,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondWorkflowTaskCompletedRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondWorkflowTaskCompletedResponse.SerializeToString,
        ),
        "RespondWorkflowTaskFailed": grpc.unary_unary_rpc_method_handler(
            servicer.RespondWorkflowTaskFailed,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondWorkflowTaskFailedRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondWorkflowTaskFailedResponse.SerializeToString,
        ),
        "PollActivityTaskQueue": grpc.unary_unary_rpc_method_handler(
            servicer.PollActivityTaskQueue,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.PollActivityTaskQueueRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.PollActivityTaskQueueResponse.SerializeToString,
        ),
        "RecordActivityTaskHeartbeat": grpc.unary_unary_rpc_method_handler(
            servicer.RecordActivityTaskHeartbeat,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RecordActivityTaskHeartbeatRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RecordActivityTaskHeartbeatResponse.SerializeToString,
        ),
        "RecordActivityTaskHeartbeatById": grpc.unary_unary_rpc_method_handler(
            servicer.RecordActivityTaskHeartbeatById,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RecordActivityTaskHeartbeatByIdRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RecordActivityTaskHeartbeatByIdResponse.SerializeToString,
        ),
        "RespondActivityTaskCompleted": grpc.unary_unary_rpc_method_handler(
            servicer.RespondActivityTaskCompleted,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskCompletedRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskCompletedResponse.SerializeToString,
        ),
        "RespondActivityTaskCompletedById": grpc.unary_unary_rpc_method_handler(
            servicer.RespondActivityTaskCompletedById,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskCompletedByIdRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskCompletedByIdResponse.SerializeToString,
        ),
        "RespondActivityTaskFailed": grpc.unary_unary_rpc_method_handler(
            servicer.RespondActivityTaskFailed,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskFailedRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskFailedResponse.SerializeToString,
        ),
        "RespondActivityTaskFailedById": grpc.unary_unary_rpc_method_handler(
            servicer.RespondActivityTaskFailedById,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskFailedByIdRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskFailedByIdResponse.SerializeToString,
        ),
        "RespondActivityTaskCanceled": grpc.unary_unary_rpc_method_handler(
            servicer.RespondActivityTaskCanceled,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskCanceledRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskCanceledResponse.SerializeToString,
        ),
        "RespondActivityTaskCanceledById": grpc.unary_unary_rpc_method_handler(
            servicer.RespondActivityTaskCanceledById,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskCanceledByIdRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskCanceledByIdResponse.SerializeToString,
        ),
        "RequestCancelWorkflowExecution": grpc.unary_unary_rpc_method_handler(
            servicer.RequestCancelWorkflowExecution,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RequestCancelWorkflowExecutionRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RequestCancelWorkflowExecutionResponse.SerializeToString,
        ),
        "SignalWorkflowExecution": grpc.unary_unary_rpc_method_handler(
            servicer.SignalWorkflowExecution,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.SignalWorkflowExecutionRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.SignalWorkflowExecutionResponse.SerializeToString,
        ),
        "SignalWithStartWorkflowExecution": grpc.unary_unary_rpc_method_handler(
            servicer.SignalWithStartWorkflowExecution,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.SignalWithStartWorkflowExecutionRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.SignalWithStartWorkflowExecutionResponse.SerializeToString,
        ),
        "ResetWorkflowExecution": grpc.unary_unary_rpc_method_handler(
            servicer.ResetWorkflowExecution,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ResetWorkflowExecutionRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ResetWorkflowExecutionResponse.SerializeToString,
        ),
        "TerminateWorkflowExecution": grpc.unary_unary_rpc_method_handler(
            servicer.TerminateWorkflowExecution,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.TerminateWorkflowExecutionRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.TerminateWorkflowExecutionResponse.SerializeToString,
        ),
        "ListOpenWorkflowExecutions": grpc.unary_unary_rpc_method_handler(
            servicer.ListOpenWorkflowExecutions,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListOpenWorkflowExecutionsRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListOpenWorkflowExecutionsResponse.SerializeToString,
        ),
        "ListClosedWorkflowExecutions": grpc.unary_unary_rpc_method_handler(
            servicer.ListClosedWorkflowExecutions,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListClosedWorkflowExecutionsRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListClosedWorkflowExecutionsResponse.SerializeToString,
        ),
        "ListWorkflowExecutions": grpc.unary_unary_rpc_method_handler(
            servicer.ListWorkflowExecutions,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListWorkflowExecutionsRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListWorkflowExecutionsResponse.SerializeToString,
        ),
        "ListArchivedWorkflowExecutions": grpc.unary_unary_rpc_method_handler(
            servicer.ListArchivedWorkflowExecutions,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListArchivedWorkflowExecutionsRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListArchivedWorkflowExecutionsResponse.SerializeToString,
        ),
        "ScanWorkflowExecutions": grpc.unary_unary_rpc_method_handler(
            servicer.ScanWorkflowExecutions,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ScanWorkflowExecutionsRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ScanWorkflowExecutionsResponse.SerializeToString,
        ),
        "CountWorkflowExecutions": grpc.unary_unary_rpc_method_handler(
            servicer.CountWorkflowExecutions,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.CountWorkflowExecutionsRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.CountWorkflowExecutionsResponse.SerializeToString,
        ),
        "GetSearchAttributes": grpc.unary_unary_rpc_method_handler(
            servicer.GetSearchAttributes,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetSearchAttributesRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetSearchAttributesResponse.SerializeToString,
        ),
        "RespondQueryTaskCompleted": grpc.unary_unary_rpc_method_handler(
            servicer.RespondQueryTaskCompleted,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondQueryTaskCompletedRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondQueryTaskCompletedResponse.SerializeToString,
        ),
        "ResetStickyTaskQueue": grpc.unary_unary_rpc_method_handler(
            servicer.ResetStickyTaskQueue,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ResetStickyTaskQueueRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ResetStickyTaskQueueResponse.SerializeToString,
        ),
        "QueryWorkflow": grpc.unary_unary_rpc_method_handler(
            servicer.QueryWorkflow,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.QueryWorkflowRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.QueryWorkflowResponse.SerializeToString,
        ),
        "DescribeWorkflowExecution": grpc.unary_unary_rpc_method_handler(
            servicer.DescribeWorkflowExecution,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.DescribeWorkflowExecutionRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.DescribeWorkflowExecutionResponse.SerializeToString,
        ),
        "DescribeTaskQueue": grpc.unary_unary_rpc_method_handler(
            servicer.DescribeTaskQueue,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.DescribeTaskQueueRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.DescribeTaskQueueResponse.SerializeToString,
        ),
        "GetClusterInfo": grpc.unary_unary_rpc_method_handler(
            servicer.GetClusterInfo,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetClusterInfoRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetClusterInfoResponse.SerializeToString,
        ),
        "GetSystemInfo": grpc.unary_unary_rpc_method_handler(
            servicer.GetSystemInfo,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetSystemInfoRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetSystemInfoResponse.SerializeToString,
        ),
        "ListTaskQueuePartitions": grpc.unary_unary_rpc_method_handler(
            servicer.ListTaskQueuePartitions,
            request_deserializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListTaskQueuePartitionsRequest.FromString,
            response_serializer=temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListTaskQueuePartitionsResponse.SerializeToString,
        ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
        "temporal.api.workflowservice.v1.WorkflowService", rpc_method_handlers
    )
    server.add_generic_rpc_handlers((generic_handler,))


# This class is part of an EXPERIMENTAL API.
class WorkflowService(object):
    """WorkflowService API defines how Temporal SDKs and other clients interact with the Temporal server
    to create and interact with workflows and activities.

    Users are expected to call `StartWorkflowExecution` to create a new workflow execution.

    To drive workflows, a worker using a Temporal SDK must exist which regularly polls for workflow
    and activity tasks from the service. For each workflow task, the sdk must process the
    (incremental or complete) event history and respond back with any newly generated commands.

    For each activity task, the worker is expected to execute the user's code which implements that
    activity, responding with completion or failure.
    """

    @staticmethod
    def RegisterNamespace(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/RegisterNamespace",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RegisterNamespaceRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RegisterNamespaceResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def DescribeNamespace(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/DescribeNamespace",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.DescribeNamespaceRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.DescribeNamespaceResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def ListNamespaces(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/ListNamespaces",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListNamespacesRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListNamespacesResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def UpdateNamespace(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/UpdateNamespace",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.UpdateNamespaceRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.UpdateNamespaceResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def DeprecateNamespace(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/DeprecateNamespace",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.DeprecateNamespaceRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.DeprecateNamespaceResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def StartWorkflowExecution(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/StartWorkflowExecution",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.StartWorkflowExecutionRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.StartWorkflowExecutionResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def GetWorkflowExecutionHistory(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/GetWorkflowExecutionHistory",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetWorkflowExecutionHistoryRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetWorkflowExecutionHistoryResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def GetWorkflowExecutionHistoryReverse(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/GetWorkflowExecutionHistoryReverse",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetWorkflowExecutionHistoryReverseRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetWorkflowExecutionHistoryReverseResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def PollWorkflowTaskQueue(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/PollWorkflowTaskQueue",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.PollWorkflowTaskQueueRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.PollWorkflowTaskQueueResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def RespondWorkflowTaskCompleted(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/RespondWorkflowTaskCompleted",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondWorkflowTaskCompletedRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondWorkflowTaskCompletedResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def RespondWorkflowTaskFailed(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/RespondWorkflowTaskFailed",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondWorkflowTaskFailedRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondWorkflowTaskFailedResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def PollActivityTaskQueue(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/PollActivityTaskQueue",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.PollActivityTaskQueueRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.PollActivityTaskQueueResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def RecordActivityTaskHeartbeat(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/RecordActivityTaskHeartbeat",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RecordActivityTaskHeartbeatRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RecordActivityTaskHeartbeatResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def RecordActivityTaskHeartbeatById(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/RecordActivityTaskHeartbeatById",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RecordActivityTaskHeartbeatByIdRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RecordActivityTaskHeartbeatByIdResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def RespondActivityTaskCompleted(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/RespondActivityTaskCompleted",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskCompletedRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskCompletedResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def RespondActivityTaskCompletedById(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/RespondActivityTaskCompletedById",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskCompletedByIdRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskCompletedByIdResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def RespondActivityTaskFailed(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/RespondActivityTaskFailed",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskFailedRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskFailedResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def RespondActivityTaskFailedById(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/RespondActivityTaskFailedById",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskFailedByIdRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskFailedByIdResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def RespondActivityTaskCanceled(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/RespondActivityTaskCanceled",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskCanceledRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskCanceledResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def RespondActivityTaskCanceledById(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/RespondActivityTaskCanceledById",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskCanceledByIdRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondActivityTaskCanceledByIdResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def RequestCancelWorkflowExecution(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/RequestCancelWorkflowExecution",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RequestCancelWorkflowExecutionRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RequestCancelWorkflowExecutionResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def SignalWorkflowExecution(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/SignalWorkflowExecution",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.SignalWorkflowExecutionRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.SignalWorkflowExecutionResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def SignalWithStartWorkflowExecution(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/SignalWithStartWorkflowExecution",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.SignalWithStartWorkflowExecutionRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.SignalWithStartWorkflowExecutionResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def ResetWorkflowExecution(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/ResetWorkflowExecution",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ResetWorkflowExecutionRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ResetWorkflowExecutionResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def TerminateWorkflowExecution(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/TerminateWorkflowExecution",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.TerminateWorkflowExecutionRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.TerminateWorkflowExecutionResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def ListOpenWorkflowExecutions(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/ListOpenWorkflowExecutions",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListOpenWorkflowExecutionsRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListOpenWorkflowExecutionsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def ListClosedWorkflowExecutions(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/ListClosedWorkflowExecutions",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListClosedWorkflowExecutionsRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListClosedWorkflowExecutionsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def ListWorkflowExecutions(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/ListWorkflowExecutions",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListWorkflowExecutionsRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListWorkflowExecutionsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def ListArchivedWorkflowExecutions(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/ListArchivedWorkflowExecutions",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListArchivedWorkflowExecutionsRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListArchivedWorkflowExecutionsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def ScanWorkflowExecutions(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/ScanWorkflowExecutions",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ScanWorkflowExecutionsRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ScanWorkflowExecutionsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def CountWorkflowExecutions(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/CountWorkflowExecutions",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.CountWorkflowExecutionsRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.CountWorkflowExecutionsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def GetSearchAttributes(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/GetSearchAttributes",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetSearchAttributesRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetSearchAttributesResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def RespondQueryTaskCompleted(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/RespondQueryTaskCompleted",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondQueryTaskCompletedRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.RespondQueryTaskCompletedResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def ResetStickyTaskQueue(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/ResetStickyTaskQueue",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ResetStickyTaskQueueRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ResetStickyTaskQueueResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def QueryWorkflow(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/QueryWorkflow",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.QueryWorkflowRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.QueryWorkflowResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def DescribeWorkflowExecution(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/DescribeWorkflowExecution",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.DescribeWorkflowExecutionRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.DescribeWorkflowExecutionResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def DescribeTaskQueue(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/DescribeTaskQueue",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.DescribeTaskQueueRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.DescribeTaskQueueResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def GetClusterInfo(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/GetClusterInfo",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetClusterInfoRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetClusterInfoResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def GetSystemInfo(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/GetSystemInfo",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetSystemInfoRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.GetSystemInfoResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def ListTaskQueuePartitions(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.workflowservice.v1.WorkflowService/ListTaskQueuePartitions",
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListTaskQueuePartitionsRequest.SerializeToString,
            temporal_dot_api_dot_workflowservice_dot_v1_dot_request__response__pb2.ListTaskQueuePartitionsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )
