"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import abc
import grpc
import temporalio.api.operatorservice.v1.request_response_pb2

class OperatorServiceStub:
    """OperatorService API defines how Temporal SDKs and other clients interact with the Temporal server
    to perform administrative functions like registering a search attribute or a namespace.
    APIs in this file could be not compatible with Temporal Cloud, hence it's usage in SDKs should be limited by
    designated APIs that clearly state that they shouldn't be used by the main Application (Workflows & Activities) framework.
    (-- Search Attribute --)
    """

    def __init__(self, channel: grpc.Channel) -> None: ...
    AddSearchAttributes: grpc.UnaryUnaryMultiCallable[
        temporalio.api.operatorservice.v1.request_response_pb2.AddSearchAttributesRequest,
        temporalio.api.operatorservice.v1.request_response_pb2.AddSearchAttributesResponse,
    ]
    """AddSearchAttributes add custom search attributes.

    Returns ALREADY_EXISTS status code if a Search Attribute with any of the specified names already exists
    Returns INTERNAL status code with temporalio.api.errordetails.v1.SystemWorkflowFailure in Error Details if registration process fails,
    """

    RemoveSearchAttributes: grpc.UnaryUnaryMultiCallable[
        temporalio.api.operatorservice.v1.request_response_pb2.RemoveSearchAttributesRequest,
        temporalio.api.operatorservice.v1.request_response_pb2.RemoveSearchAttributesResponse,
    ]
    """RemoveSearchAttributes removes custom search attributes.

    Returns NOT_FOUND status code if a Search Attribute with any of the specified names is not registered
    """

    ListSearchAttributes: grpc.UnaryUnaryMultiCallable[
        temporalio.api.operatorservice.v1.request_response_pb2.ListSearchAttributesRequest,
        temporalio.api.operatorservice.v1.request_response_pb2.ListSearchAttributesResponse,
    ]
    """ListSearchAttributes returns comprehensive information about search attributes."""

    DeleteNamespace: grpc.UnaryUnaryMultiCallable[
        temporalio.api.operatorservice.v1.request_response_pb2.DeleteNamespaceRequest,
        temporalio.api.operatorservice.v1.request_response_pb2.DeleteNamespaceResponse,
    ]
    """DeleteNamespace synchronously deletes a namespace and asynchronously reclaims all namespace resources.
    (-- api-linter: core::0135::method-signature=disabled
        aip.dev/not-precedent: DeleteNamespace RPC doesn't follow Google API format. --)
    (-- api-linter: core::0135::response-message-name=disabled
        aip.dev/not-precedent: DeleteNamespace RPC doesn't follow Google API format. --)
    """

class OperatorServiceServicer(metaclass=abc.ABCMeta):
    """OperatorService API defines how Temporal SDKs and other clients interact with the Temporal server
    to perform administrative functions like registering a search attribute or a namespace.
    APIs in this file could be not compatible with Temporal Cloud, hence it's usage in SDKs should be limited by
    designated APIs that clearly state that they shouldn't be used by the main Application (Workflows & Activities) framework.
    (-- Search Attribute --)
    """

    @abc.abstractmethod
    def AddSearchAttributes(
        self,
        request: temporalio.api.operatorservice.v1.request_response_pb2.AddSearchAttributesRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.operatorservice.v1.request_response_pb2.AddSearchAttributesResponse:
        """AddSearchAttributes add custom search attributes.

        Returns ALREADY_EXISTS status code if a Search Attribute with any of the specified names already exists
        Returns INTERNAL status code with temporalio.api.errordetails.v1.SystemWorkflowFailure in Error Details if registration process fails,
        """
        pass
    @abc.abstractmethod
    def RemoveSearchAttributes(
        self,
        request: temporalio.api.operatorservice.v1.request_response_pb2.RemoveSearchAttributesRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.operatorservice.v1.request_response_pb2.RemoveSearchAttributesResponse:
        """RemoveSearchAttributes removes custom search attributes.

        Returns NOT_FOUND status code if a Search Attribute with any of the specified names is not registered
        """
        pass
    @abc.abstractmethod
    def ListSearchAttributes(
        self,
        request: temporalio.api.operatorservice.v1.request_response_pb2.ListSearchAttributesRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.operatorservice.v1.request_response_pb2.ListSearchAttributesResponse:
        """ListSearchAttributes returns comprehensive information about search attributes."""
        pass
    @abc.abstractmethod
    def DeleteNamespace(
        self,
        request: temporalio.api.operatorservice.v1.request_response_pb2.DeleteNamespaceRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.operatorservice.v1.request_response_pb2.DeleteNamespaceResponse:
        """DeleteNamespace synchronously deletes a namespace and asynchronously reclaims all namespace resources.
        (-- api-linter: core::0135::method-signature=disabled
            aip.dev/not-precedent: DeleteNamespace RPC doesn't follow Google API format. --)
        (-- api-linter: core::0135::response-message-name=disabled
            aip.dev/not-precedent: DeleteNamespace RPC doesn't follow Google API format. --)
        """
        pass

def add_OperatorServiceServicer_to_server(
    servicer: OperatorServiceServicer, server: grpc.Server
) -> None: ...
