"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import temporalio.api.common.v1.message_pb2
import temporalio.api.enums.v1.event_type_pb2
import temporalio.api.enums.v1.failed_cause_pb2
import temporalio.api.enums.v1.workflow_pb2
import temporalio.api.failure.v1.message_pb2
import temporalio.api.taskqueue.v1.message_pb2
import temporalio.api.workflow.v1.message_pb2
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class WorkflowExecutionStartedEventAttributes(google.protobuf.message.Message):
    """Always the first event in workflow history"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    WORKFLOW_TYPE_FIELD_NUMBER: builtins.int
    PARENT_WORKFLOW_NAMESPACE_FIELD_NUMBER: builtins.int
    PARENT_WORKFLOW_EXECUTION_FIELD_NUMBER: builtins.int
    PARENT_INITIATED_EVENT_ID_FIELD_NUMBER: builtins.int
    TASK_QUEUE_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_TIMEOUT_FIELD_NUMBER: builtins.int
    WORKFLOW_RUN_TIMEOUT_FIELD_NUMBER: builtins.int
    WORKFLOW_TASK_TIMEOUT_FIELD_NUMBER: builtins.int
    CONTINUED_EXECUTION_RUN_ID_FIELD_NUMBER: builtins.int
    INITIATOR_FIELD_NUMBER: builtins.int
    CONTINUED_FAILURE_FIELD_NUMBER: builtins.int
    LAST_COMPLETION_RESULT_FIELD_NUMBER: builtins.int
    ORIGINAL_EXECUTION_RUN_ID_FIELD_NUMBER: builtins.int
    IDENTITY_FIELD_NUMBER: builtins.int
    FIRST_EXECUTION_RUN_ID_FIELD_NUMBER: builtins.int
    RETRY_POLICY_FIELD_NUMBER: builtins.int
    ATTEMPT_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_EXPIRATION_TIME_FIELD_NUMBER: builtins.int
    CRON_SCHEDULE_FIELD_NUMBER: builtins.int
    FIRST_WORKFLOW_TASK_BACKOFF_FIELD_NUMBER: builtins.int
    MEMO_FIELD_NUMBER: builtins.int
    SEARCH_ATTRIBUTES_FIELD_NUMBER: builtins.int
    PREV_AUTO_RESET_POINTS_FIELD_NUMBER: builtins.int
    HEADER_FIELD_NUMBER: builtins.int
    @property
    def workflow_type(self) -> temporalio.api.common.v1.message_pb2.WorkflowType: ...
    parent_workflow_namespace: typing.Text
    """If this workflow is a child, the namespace our parent lives in"""

    @property
    def parent_workflow_execution(
        self,
    ) -> temporalio.api.common.v1.message_pb2.WorkflowExecution: ...
    parent_initiated_event_id: builtins.int
    """TODO: What is this? ID of the event that requested this workflow execution if we are a child?"""

    @property
    def task_queue(self) -> temporalio.api.taskqueue.v1.message_pb2.TaskQueue: ...
    @property
    def input(self) -> temporalio.api.common.v1.message_pb2.Payloads:
        """SDK will deserialize this and provide it as arguments to the workflow function"""
        pass
    @property
    def workflow_execution_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Total workflow execution timeout including retries and continue as new."""
        pass
    @property
    def workflow_run_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Timeout of a single workflow run."""
        pass
    @property
    def workflow_task_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Timeout of a single workflow task."""
        pass
    continued_execution_run_id: typing.Text
    """Run id of the previous workflow which continued-as-new or retired or cron executed into this
    workflow.
    """

    initiator: temporalio.api.enums.v1.workflow_pb2.ContinueAsNewInitiator.ValueType
    @property
    def continued_failure(self) -> temporalio.api.failure.v1.message_pb2.Failure: ...
    @property
    def last_completion_result(
        self,
    ) -> temporalio.api.common.v1.message_pb2.Payloads: ...
    original_execution_run_id: typing.Text
    """This is the run id when the WorkflowExecutionStarted event was written"""

    identity: typing.Text
    """Identity of the client who requested this execution"""

    first_execution_run_id: typing.Text
    """This is the very first runId along the chain of ContinueAsNew and Reset."""

    @property
    def retry_policy(self) -> temporalio.api.common.v1.message_pb2.RetryPolicy: ...
    attempt: builtins.int
    """Starting at 1, the number of times we have tried to execute this workflow"""

    @property
    def workflow_execution_expiration_time(
        self,
    ) -> google.protobuf.timestamp_pb2.Timestamp:
        """The absolute time at which the workflow will be timed out.
        This is passed without change to the next run/retry of a workflow.
        """
        pass
    cron_schedule: typing.Text
    """If this workflow runs on a cron schedule, it will appear here"""

    @property
    def first_workflow_task_backoff(self) -> google.protobuf.duration_pb2.Duration:
        """For a cron workflow, this contains the amount of time between when this iteration of
        the cron workflow was scheduled and when it should run next per its cron_schedule.
        """
        pass
    @property
    def memo(self) -> temporalio.api.common.v1.message_pb2.Memo: ...
    @property
    def search_attributes(
        self,
    ) -> temporalio.api.common.v1.message_pb2.SearchAttributes: ...
    @property
    def prev_auto_reset_points(
        self,
    ) -> temporalio.api.workflow.v1.message_pb2.ResetPoints: ...
    @property
    def header(self) -> temporalio.api.common.v1.message_pb2.Header: ...
    def __init__(
        self,
        *,
        workflow_type: typing.Optional[
            temporalio.api.common.v1.message_pb2.WorkflowType
        ] = ...,
        parent_workflow_namespace: typing.Text = ...,
        parent_workflow_execution: typing.Optional[
            temporalio.api.common.v1.message_pb2.WorkflowExecution
        ] = ...,
        parent_initiated_event_id: builtins.int = ...,
        task_queue: typing.Optional[
            temporalio.api.taskqueue.v1.message_pb2.TaskQueue
        ] = ...,
        input: typing.Optional[temporalio.api.common.v1.message_pb2.Payloads] = ...,
        workflow_execution_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        workflow_run_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        workflow_task_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        continued_execution_run_id: typing.Text = ...,
        initiator: temporalio.api.enums.v1.workflow_pb2.ContinueAsNewInitiator.ValueType = ...,
        continued_failure: typing.Optional[
            temporalio.api.failure.v1.message_pb2.Failure
        ] = ...,
        last_completion_result: typing.Optional[
            temporalio.api.common.v1.message_pb2.Payloads
        ] = ...,
        original_execution_run_id: typing.Text = ...,
        identity: typing.Text = ...,
        first_execution_run_id: typing.Text = ...,
        retry_policy: typing.Optional[
            temporalio.api.common.v1.message_pb2.RetryPolicy
        ] = ...,
        attempt: builtins.int = ...,
        workflow_execution_expiration_time: typing.Optional[
            google.protobuf.timestamp_pb2.Timestamp
        ] = ...,
        cron_schedule: typing.Text = ...,
        first_workflow_task_backoff: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        memo: typing.Optional[temporalio.api.common.v1.message_pb2.Memo] = ...,
        search_attributes: typing.Optional[
            temporalio.api.common.v1.message_pb2.SearchAttributes
        ] = ...,
        prev_auto_reset_points: typing.Optional[
            temporalio.api.workflow.v1.message_pb2.ResetPoints
        ] = ...,
        header: typing.Optional[temporalio.api.common.v1.message_pb2.Header] = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "continued_failure",
            b"continued_failure",
            "first_workflow_task_backoff",
            b"first_workflow_task_backoff",
            "header",
            b"header",
            "input",
            b"input",
            "last_completion_result",
            b"last_completion_result",
            "memo",
            b"memo",
            "parent_workflow_execution",
            b"parent_workflow_execution",
            "prev_auto_reset_points",
            b"prev_auto_reset_points",
            "retry_policy",
            b"retry_policy",
            "search_attributes",
            b"search_attributes",
            "task_queue",
            b"task_queue",
            "workflow_execution_expiration_time",
            b"workflow_execution_expiration_time",
            "workflow_execution_timeout",
            b"workflow_execution_timeout",
            "workflow_run_timeout",
            b"workflow_run_timeout",
            "workflow_task_timeout",
            b"workflow_task_timeout",
            "workflow_type",
            b"workflow_type",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "attempt",
            b"attempt",
            "continued_execution_run_id",
            b"continued_execution_run_id",
            "continued_failure",
            b"continued_failure",
            "cron_schedule",
            b"cron_schedule",
            "first_execution_run_id",
            b"first_execution_run_id",
            "first_workflow_task_backoff",
            b"first_workflow_task_backoff",
            "header",
            b"header",
            "identity",
            b"identity",
            "initiator",
            b"initiator",
            "input",
            b"input",
            "last_completion_result",
            b"last_completion_result",
            "memo",
            b"memo",
            "original_execution_run_id",
            b"original_execution_run_id",
            "parent_initiated_event_id",
            b"parent_initiated_event_id",
            "parent_workflow_execution",
            b"parent_workflow_execution",
            "parent_workflow_namespace",
            b"parent_workflow_namespace",
            "prev_auto_reset_points",
            b"prev_auto_reset_points",
            "retry_policy",
            b"retry_policy",
            "search_attributes",
            b"search_attributes",
            "task_queue",
            b"task_queue",
            "workflow_execution_expiration_time",
            b"workflow_execution_expiration_time",
            "workflow_execution_timeout",
            b"workflow_execution_timeout",
            "workflow_run_timeout",
            b"workflow_run_timeout",
            "workflow_task_timeout",
            b"workflow_task_timeout",
            "workflow_type",
            b"workflow_type",
        ],
    ) -> None: ...

global___WorkflowExecutionStartedEventAttributes = (
    WorkflowExecutionStartedEventAttributes
)

class WorkflowExecutionCompletedEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    RESULT_FIELD_NUMBER: builtins.int
    WORKFLOW_TASK_COMPLETED_EVENT_ID_FIELD_NUMBER: builtins.int
    NEW_EXECUTION_RUN_ID_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> temporalio.api.common.v1.message_pb2.Payloads:
        """Serialized result of workflow completion (ie: The return value of the workflow function)"""
        pass
    workflow_task_completed_event_id: builtins.int
    """The `WORKFLOW_TASK_COMPLETED` event which this command was reported with"""

    new_execution_run_id: typing.Text
    """If another run is started by cron, this contains the new run id."""

    def __init__(
        self,
        *,
        result: typing.Optional[temporalio.api.common.v1.message_pb2.Payloads] = ...,
        workflow_task_completed_event_id: builtins.int = ...,
        new_execution_run_id: typing.Text = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["result", b"result"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "new_execution_run_id",
            b"new_execution_run_id",
            "result",
            b"result",
            "workflow_task_completed_event_id",
            b"workflow_task_completed_event_id",
        ],
    ) -> None: ...

global___WorkflowExecutionCompletedEventAttributes = (
    WorkflowExecutionCompletedEventAttributes
)

class WorkflowExecutionFailedEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    FAILURE_FIELD_NUMBER: builtins.int
    RETRY_STATE_FIELD_NUMBER: builtins.int
    WORKFLOW_TASK_COMPLETED_EVENT_ID_FIELD_NUMBER: builtins.int
    NEW_EXECUTION_RUN_ID_FIELD_NUMBER: builtins.int
    @property
    def failure(self) -> temporalio.api.failure.v1.message_pb2.Failure:
        """Serialized result of workflow failure (ex: An exception thrown, or error returned)"""
        pass
    retry_state: temporalio.api.enums.v1.workflow_pb2.RetryState.ValueType
    workflow_task_completed_event_id: builtins.int
    """The `WORKFLOW_TASK_COMPLETED` event which this command was reported with"""

    new_execution_run_id: typing.Text
    """If another run is started by cron or retry, this contains the new run id."""

    def __init__(
        self,
        *,
        failure: typing.Optional[temporalio.api.failure.v1.message_pb2.Failure] = ...,
        retry_state: temporalio.api.enums.v1.workflow_pb2.RetryState.ValueType = ...,
        workflow_task_completed_event_id: builtins.int = ...,
        new_execution_run_id: typing.Text = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["failure", b"failure"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "failure",
            b"failure",
            "new_execution_run_id",
            b"new_execution_run_id",
            "retry_state",
            b"retry_state",
            "workflow_task_completed_event_id",
            b"workflow_task_completed_event_id",
        ],
    ) -> None: ...

global___WorkflowExecutionFailedEventAttributes = WorkflowExecutionFailedEventAttributes

class WorkflowExecutionTimedOutEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    RETRY_STATE_FIELD_NUMBER: builtins.int
    NEW_EXECUTION_RUN_ID_FIELD_NUMBER: builtins.int
    retry_state: temporalio.api.enums.v1.workflow_pb2.RetryState.ValueType
    new_execution_run_id: typing.Text
    """If another run is started by cron or retry, this contains the new run id."""

    def __init__(
        self,
        *,
        retry_state: temporalio.api.enums.v1.workflow_pb2.RetryState.ValueType = ...,
        new_execution_run_id: typing.Text = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "new_execution_run_id",
            b"new_execution_run_id",
            "retry_state",
            b"retry_state",
        ],
    ) -> None: ...

global___WorkflowExecutionTimedOutEventAttributes = (
    WorkflowExecutionTimedOutEventAttributes
)

class WorkflowExecutionContinuedAsNewEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    NEW_EXECUTION_RUN_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_TYPE_FIELD_NUMBER: builtins.int
    TASK_QUEUE_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    WORKFLOW_RUN_TIMEOUT_FIELD_NUMBER: builtins.int
    WORKFLOW_TASK_TIMEOUT_FIELD_NUMBER: builtins.int
    WORKFLOW_TASK_COMPLETED_EVENT_ID_FIELD_NUMBER: builtins.int
    BACKOFF_START_INTERVAL_FIELD_NUMBER: builtins.int
    INITIATOR_FIELD_NUMBER: builtins.int
    FAILURE_FIELD_NUMBER: builtins.int
    LAST_COMPLETION_RESULT_FIELD_NUMBER: builtins.int
    HEADER_FIELD_NUMBER: builtins.int
    MEMO_FIELD_NUMBER: builtins.int
    SEARCH_ATTRIBUTES_FIELD_NUMBER: builtins.int
    new_execution_run_id: typing.Text
    """The run ID of the new workflow started by this continue-as-new"""

    @property
    def workflow_type(self) -> temporalio.api.common.v1.message_pb2.WorkflowType: ...
    @property
    def task_queue(self) -> temporalio.api.taskqueue.v1.message_pb2.TaskQueue: ...
    @property
    def input(self) -> temporalio.api.common.v1.message_pb2.Payloads: ...
    @property
    def workflow_run_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Timeout of a single workflow run."""
        pass
    @property
    def workflow_task_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Timeout of a single workflow task."""
        pass
    workflow_task_completed_event_id: builtins.int
    """The `WORKFLOW_TASK_COMPLETED` event which this command was reported with"""

    @property
    def backoff_start_interval(self) -> google.protobuf.duration_pb2.Duration:
        """TODO: How and is this used?"""
        pass
    initiator: temporalio.api.enums.v1.workflow_pb2.ContinueAsNewInitiator.ValueType
    @property
    def failure(self) -> temporalio.api.failure.v1.message_pb2.Failure:
        """TODO: David are these right?
        Deprecated. If a workflow's retry policy would cause a new run to start when the current one
        has failed, this field would be populated with that failure. Now (when supported by server
        and sdk) the final event will be `WORKFLOW_EXECUTION_FAILED` with `new_execution_run_id` set.
        """
        pass
    @property
    def last_completion_result(self) -> temporalio.api.common.v1.message_pb2.Payloads:
        """TODO: Is this the result of *this* workflow as it continued-as-new?"""
        pass
    @property
    def header(self) -> temporalio.api.common.v1.message_pb2.Header: ...
    @property
    def memo(self) -> temporalio.api.common.v1.message_pb2.Memo: ...
    @property
    def search_attributes(
        self,
    ) -> temporalio.api.common.v1.message_pb2.SearchAttributes: ...
    def __init__(
        self,
        *,
        new_execution_run_id: typing.Text = ...,
        workflow_type: typing.Optional[
            temporalio.api.common.v1.message_pb2.WorkflowType
        ] = ...,
        task_queue: typing.Optional[
            temporalio.api.taskqueue.v1.message_pb2.TaskQueue
        ] = ...,
        input: typing.Optional[temporalio.api.common.v1.message_pb2.Payloads] = ...,
        workflow_run_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        workflow_task_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        workflow_task_completed_event_id: builtins.int = ...,
        backoff_start_interval: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        initiator: temporalio.api.enums.v1.workflow_pb2.ContinueAsNewInitiator.ValueType = ...,
        failure: typing.Optional[temporalio.api.failure.v1.message_pb2.Failure] = ...,
        last_completion_result: typing.Optional[
            temporalio.api.common.v1.message_pb2.Payloads
        ] = ...,
        header: typing.Optional[temporalio.api.common.v1.message_pb2.Header] = ...,
        memo: typing.Optional[temporalio.api.common.v1.message_pb2.Memo] = ...,
        search_attributes: typing.Optional[
            temporalio.api.common.v1.message_pb2.SearchAttributes
        ] = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "backoff_start_interval",
            b"backoff_start_interval",
            "failure",
            b"failure",
            "header",
            b"header",
            "input",
            b"input",
            "last_completion_result",
            b"last_completion_result",
            "memo",
            b"memo",
            "search_attributes",
            b"search_attributes",
            "task_queue",
            b"task_queue",
            "workflow_run_timeout",
            b"workflow_run_timeout",
            "workflow_task_timeout",
            b"workflow_task_timeout",
            "workflow_type",
            b"workflow_type",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "backoff_start_interval",
            b"backoff_start_interval",
            "failure",
            b"failure",
            "header",
            b"header",
            "initiator",
            b"initiator",
            "input",
            b"input",
            "last_completion_result",
            b"last_completion_result",
            "memo",
            b"memo",
            "new_execution_run_id",
            b"new_execution_run_id",
            "search_attributes",
            b"search_attributes",
            "task_queue",
            b"task_queue",
            "workflow_run_timeout",
            b"workflow_run_timeout",
            "workflow_task_completed_event_id",
            b"workflow_task_completed_event_id",
            "workflow_task_timeout",
            b"workflow_task_timeout",
            "workflow_type",
            b"workflow_type",
        ],
    ) -> None: ...

global___WorkflowExecutionContinuedAsNewEventAttributes = (
    WorkflowExecutionContinuedAsNewEventAttributes
)

class WorkflowTaskScheduledEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TASK_QUEUE_FIELD_NUMBER: builtins.int
    START_TO_CLOSE_TIMEOUT_FIELD_NUMBER: builtins.int
    ATTEMPT_FIELD_NUMBER: builtins.int
    @property
    def task_queue(self) -> temporalio.api.taskqueue.v1.message_pb2.TaskQueue:
        """The task queue this workflow task was enqueued in, which could be a normal or sticky queue"""
        pass
    @property
    def start_to_close_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """How long the worker has to process this task once receiving it before it times out

        (-- api-linter: core::0140::prepositions=disabled
            aip.dev/not-precedent: "to" is used to indicate interval. --)
        """
        pass
    attempt: builtins.int
    """Starting at 1, how many attempts there have been to complete this task"""

    def __init__(
        self,
        *,
        task_queue: typing.Optional[
            temporalio.api.taskqueue.v1.message_pb2.TaskQueue
        ] = ...,
        start_to_close_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        attempt: builtins.int = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "start_to_close_timeout",
            b"start_to_close_timeout",
            "task_queue",
            b"task_queue",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "attempt",
            b"attempt",
            "start_to_close_timeout",
            b"start_to_close_timeout",
            "task_queue",
            b"task_queue",
        ],
    ) -> None: ...

global___WorkflowTaskScheduledEventAttributes = WorkflowTaskScheduledEventAttributes

class WorkflowTaskStartedEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SCHEDULED_EVENT_ID_FIELD_NUMBER: builtins.int
    IDENTITY_FIELD_NUMBER: builtins.int
    REQUEST_ID_FIELD_NUMBER: builtins.int
    scheduled_event_id: builtins.int
    """The id of the `WORKFLOW_TASK_SCHEDULED` event this task corresponds to"""

    identity: typing.Text
    """Identity of the worker who picked up this task"""

    request_id: typing.Text
    """TODO: ? Appears unused?"""

    def __init__(
        self,
        *,
        scheduled_event_id: builtins.int = ...,
        identity: typing.Text = ...,
        request_id: typing.Text = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "identity",
            b"identity",
            "request_id",
            b"request_id",
            "scheduled_event_id",
            b"scheduled_event_id",
        ],
    ) -> None: ...

global___WorkflowTaskStartedEventAttributes = WorkflowTaskStartedEventAttributes

class WorkflowTaskCompletedEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SCHEDULED_EVENT_ID_FIELD_NUMBER: builtins.int
    STARTED_EVENT_ID_FIELD_NUMBER: builtins.int
    IDENTITY_FIELD_NUMBER: builtins.int
    BINARY_CHECKSUM_FIELD_NUMBER: builtins.int
    scheduled_event_id: builtins.int
    """The id of the `WORKFLOW_TASK_SCHEDULED` event this task corresponds to"""

    started_event_id: builtins.int
    """The id of the `WORKFLOW_TASK_STARTED` event this task corresponds to"""

    identity: typing.Text
    """Identity of the worker who completed this task"""

    binary_checksum: typing.Text
    """Binary ID of the worker who completed this task"""

    def __init__(
        self,
        *,
        scheduled_event_id: builtins.int = ...,
        started_event_id: builtins.int = ...,
        identity: typing.Text = ...,
        binary_checksum: typing.Text = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "binary_checksum",
            b"binary_checksum",
            "identity",
            b"identity",
            "scheduled_event_id",
            b"scheduled_event_id",
            "started_event_id",
            b"started_event_id",
        ],
    ) -> None: ...

global___WorkflowTaskCompletedEventAttributes = WorkflowTaskCompletedEventAttributes

class WorkflowTaskTimedOutEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SCHEDULED_EVENT_ID_FIELD_NUMBER: builtins.int
    STARTED_EVENT_ID_FIELD_NUMBER: builtins.int
    TIMEOUT_TYPE_FIELD_NUMBER: builtins.int
    scheduled_event_id: builtins.int
    """The id of the `WORKFLOW_TASK_SCHEDULED` event this task corresponds to"""

    started_event_id: builtins.int
    """The id of the `WORKFLOW_TASK_STARTED` event this task corresponds to"""

    timeout_type: temporalio.api.enums.v1.workflow_pb2.TimeoutType.ValueType
    def __init__(
        self,
        *,
        scheduled_event_id: builtins.int = ...,
        started_event_id: builtins.int = ...,
        timeout_type: temporalio.api.enums.v1.workflow_pb2.TimeoutType.ValueType = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "scheduled_event_id",
            b"scheduled_event_id",
            "started_event_id",
            b"started_event_id",
            "timeout_type",
            b"timeout_type",
        ],
    ) -> None: ...

global___WorkflowTaskTimedOutEventAttributes = WorkflowTaskTimedOutEventAttributes

class WorkflowTaskFailedEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SCHEDULED_EVENT_ID_FIELD_NUMBER: builtins.int
    STARTED_EVENT_ID_FIELD_NUMBER: builtins.int
    CAUSE_FIELD_NUMBER: builtins.int
    FAILURE_FIELD_NUMBER: builtins.int
    IDENTITY_FIELD_NUMBER: builtins.int
    BASE_RUN_ID_FIELD_NUMBER: builtins.int
    NEW_RUN_ID_FIELD_NUMBER: builtins.int
    FORK_EVENT_VERSION_FIELD_NUMBER: builtins.int
    BINARY_CHECKSUM_FIELD_NUMBER: builtins.int
    scheduled_event_id: builtins.int
    """The id of the `WORKFLOW_TASK_SCHEDULED` event this task corresponds to"""

    started_event_id: builtins.int
    """The id of the `WORKFLOW_TASK_STARTED` event this task corresponds to"""

    cause: temporalio.api.enums.v1.failed_cause_pb2.WorkflowTaskFailedCause.ValueType
    @property
    def failure(self) -> temporalio.api.failure.v1.message_pb2.Failure:
        """The failure details"""
        pass
    identity: typing.Text
    """If a worker explicitly failed this task, it's identity. TODO: What is this set to if server fails the task?"""

    base_run_id: typing.Text
    """The original run id of the workflow. For reset workflow."""

    new_run_id: typing.Text
    """If the workflow is being reset, the new run id."""

    fork_event_version: builtins.int
    """TODO: ?"""

    binary_checksum: typing.Text
    """If a worker explicitly failed this task, it's binary id"""

    def __init__(
        self,
        *,
        scheduled_event_id: builtins.int = ...,
        started_event_id: builtins.int = ...,
        cause: temporalio.api.enums.v1.failed_cause_pb2.WorkflowTaskFailedCause.ValueType = ...,
        failure: typing.Optional[temporalio.api.failure.v1.message_pb2.Failure] = ...,
        identity: typing.Text = ...,
        base_run_id: typing.Text = ...,
        new_run_id: typing.Text = ...,
        fork_event_version: builtins.int = ...,
        binary_checksum: typing.Text = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["failure", b"failure"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "base_run_id",
            b"base_run_id",
            "binary_checksum",
            b"binary_checksum",
            "cause",
            b"cause",
            "failure",
            b"failure",
            "fork_event_version",
            b"fork_event_version",
            "identity",
            b"identity",
            "new_run_id",
            b"new_run_id",
            "scheduled_event_id",
            b"scheduled_event_id",
            "started_event_id",
            b"started_event_id",
        ],
    ) -> None: ...

global___WorkflowTaskFailedEventAttributes = WorkflowTaskFailedEventAttributes

class ActivityTaskScheduledEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ACTIVITY_ID_FIELD_NUMBER: builtins.int
    ACTIVITY_TYPE_FIELD_NUMBER: builtins.int
    NAMESPACE_FIELD_NUMBER: builtins.int
    TASK_QUEUE_FIELD_NUMBER: builtins.int
    HEADER_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    SCHEDULE_TO_CLOSE_TIMEOUT_FIELD_NUMBER: builtins.int
    SCHEDULE_TO_START_TIMEOUT_FIELD_NUMBER: builtins.int
    START_TO_CLOSE_TIMEOUT_FIELD_NUMBER: builtins.int
    HEARTBEAT_TIMEOUT_FIELD_NUMBER: builtins.int
    WORKFLOW_TASK_COMPLETED_EVENT_ID_FIELD_NUMBER: builtins.int
    RETRY_POLICY_FIELD_NUMBER: builtins.int
    activity_id: typing.Text
    """The worker/user assigned identifier for the activity"""

    @property
    def activity_type(self) -> temporalio.api.common.v1.message_pb2.ActivityType: ...
    namespace: typing.Text
    @property
    def task_queue(self) -> temporalio.api.taskqueue.v1.message_pb2.TaskQueue: ...
    @property
    def header(self) -> temporalio.api.common.v1.message_pb2.Header: ...
    @property
    def input(self) -> temporalio.api.common.v1.message_pb2.Payloads: ...
    @property
    def schedule_to_close_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Indicates how long the caller is willing to wait for an activity completion. Limits how long
        retries will be attempted. Either this or `start_to_close_timeout` must be specified.

        (-- api-linter: core::0140::prepositions=disabled
            aip.dev/not-precedent: "to" is used to indicate interval. --)
        """
        pass
    @property
    def schedule_to_start_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Limits time an activity task can stay in a task queue before a worker picks it up. This
        timeout is always non retryable, as all a retry would achieve is to put it back into the same
        queue. Defaults to `schedule_to_close_timeout` or workflow execution timeout if not
        specified.

        (-- api-linter: core::0140::prepositions=disabled
            aip.dev/not-precedent: "to" is used to indicate interval. --)
        """
        pass
    @property
    def start_to_close_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Maximum time an activity is allowed to execute after being picked up by a worker. This
        timeout is always retryable. Either this or `schedule_to_close_timeout` must be
        specified.

        (-- api-linter: core::0140::prepositions=disabled
            aip.dev/not-precedent: "to" is used to indicate interval. --)
        """
        pass
    @property
    def heartbeat_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Maximum permitted time between successful worker heartbeats."""
        pass
    workflow_task_completed_event_id: builtins.int
    """The `WORKFLOW_TASK_COMPLETED` event which this command was reported with"""

    @property
    def retry_policy(self) -> temporalio.api.common.v1.message_pb2.RetryPolicy:
        """Activities are assigned a default retry policy controlled by the service's dynamic
        configuration. Retries will happen up to `schedule_to_close_timeout`. To disable retries set
        retry_policy.maximum_attempts to 1.
        """
        pass
    def __init__(
        self,
        *,
        activity_id: typing.Text = ...,
        activity_type: typing.Optional[
            temporalio.api.common.v1.message_pb2.ActivityType
        ] = ...,
        namespace: typing.Text = ...,
        task_queue: typing.Optional[
            temporalio.api.taskqueue.v1.message_pb2.TaskQueue
        ] = ...,
        header: typing.Optional[temporalio.api.common.v1.message_pb2.Header] = ...,
        input: typing.Optional[temporalio.api.common.v1.message_pb2.Payloads] = ...,
        schedule_to_close_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        schedule_to_start_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        start_to_close_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        heartbeat_timeout: typing.Optional[google.protobuf.duration_pb2.Duration] = ...,
        workflow_task_completed_event_id: builtins.int = ...,
        retry_policy: typing.Optional[
            temporalio.api.common.v1.message_pb2.RetryPolicy
        ] = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "activity_type",
            b"activity_type",
            "header",
            b"header",
            "heartbeat_timeout",
            b"heartbeat_timeout",
            "input",
            b"input",
            "retry_policy",
            b"retry_policy",
            "schedule_to_close_timeout",
            b"schedule_to_close_timeout",
            "schedule_to_start_timeout",
            b"schedule_to_start_timeout",
            "start_to_close_timeout",
            b"start_to_close_timeout",
            "task_queue",
            b"task_queue",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "activity_id",
            b"activity_id",
            "activity_type",
            b"activity_type",
            "header",
            b"header",
            "heartbeat_timeout",
            b"heartbeat_timeout",
            "input",
            b"input",
            "namespace",
            b"namespace",
            "retry_policy",
            b"retry_policy",
            "schedule_to_close_timeout",
            b"schedule_to_close_timeout",
            "schedule_to_start_timeout",
            b"schedule_to_start_timeout",
            "start_to_close_timeout",
            b"start_to_close_timeout",
            "task_queue",
            b"task_queue",
            "workflow_task_completed_event_id",
            b"workflow_task_completed_event_id",
        ],
    ) -> None: ...

global___ActivityTaskScheduledEventAttributes = ActivityTaskScheduledEventAttributes

class ActivityTaskStartedEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SCHEDULED_EVENT_ID_FIELD_NUMBER: builtins.int
    IDENTITY_FIELD_NUMBER: builtins.int
    REQUEST_ID_FIELD_NUMBER: builtins.int
    ATTEMPT_FIELD_NUMBER: builtins.int
    LAST_FAILURE_FIELD_NUMBER: builtins.int
    scheduled_event_id: builtins.int
    """The id of the `ACTIVITY_TASK_SCHEDULED` event this task corresponds to"""

    identity: typing.Text
    """id of the worker that picked up this task"""

    request_id: typing.Text
    """TODO ??"""

    attempt: builtins.int
    """Starting at 1, the number of times this task has been attempted"""

    @property
    def last_failure(self) -> temporalio.api.failure.v1.message_pb2.Failure:
        """Will be set to the most recent failure details, if this task has previously failed and then
        been retried.
        """
        pass
    def __init__(
        self,
        *,
        scheduled_event_id: builtins.int = ...,
        identity: typing.Text = ...,
        request_id: typing.Text = ...,
        attempt: builtins.int = ...,
        last_failure: typing.Optional[
            temporalio.api.failure.v1.message_pb2.Failure
        ] = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["last_failure", b"last_failure"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "attempt",
            b"attempt",
            "identity",
            b"identity",
            "last_failure",
            b"last_failure",
            "request_id",
            b"request_id",
            "scheduled_event_id",
            b"scheduled_event_id",
        ],
    ) -> None: ...

global___ActivityTaskStartedEventAttributes = ActivityTaskStartedEventAttributes

class ActivityTaskCompletedEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    RESULT_FIELD_NUMBER: builtins.int
    SCHEDULED_EVENT_ID_FIELD_NUMBER: builtins.int
    STARTED_EVENT_ID_FIELD_NUMBER: builtins.int
    IDENTITY_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> temporalio.api.common.v1.message_pb2.Payloads:
        """Serialized results of the activity. IE: The return value of the activity function"""
        pass
    scheduled_event_id: builtins.int
    """The id of the `ACTIVITY_TASK_SCHEDULED` event this completion corresponds to"""

    started_event_id: builtins.int
    """The id of the `ACTIVITY_TASK_STARTED` event this completion corresponds to"""

    identity: typing.Text
    """id of the worker that completed this task"""

    def __init__(
        self,
        *,
        result: typing.Optional[temporalio.api.common.v1.message_pb2.Payloads] = ...,
        scheduled_event_id: builtins.int = ...,
        started_event_id: builtins.int = ...,
        identity: typing.Text = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["result", b"result"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "identity",
            b"identity",
            "result",
            b"result",
            "scheduled_event_id",
            b"scheduled_event_id",
            "started_event_id",
            b"started_event_id",
        ],
    ) -> None: ...

global___ActivityTaskCompletedEventAttributes = ActivityTaskCompletedEventAttributes

class ActivityTaskFailedEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    FAILURE_FIELD_NUMBER: builtins.int
    SCHEDULED_EVENT_ID_FIELD_NUMBER: builtins.int
    STARTED_EVENT_ID_FIELD_NUMBER: builtins.int
    IDENTITY_FIELD_NUMBER: builtins.int
    RETRY_STATE_FIELD_NUMBER: builtins.int
    @property
    def failure(self) -> temporalio.api.failure.v1.message_pb2.Failure:
        """Failure details"""
        pass
    scheduled_event_id: builtins.int
    """The id of the `ACTIVITY_TASK_SCHEDULED` event this failure corresponds to"""

    started_event_id: builtins.int
    """The id of the `ACTIVITY_TASK_STARTED` event this failure corresponds to"""

    identity: typing.Text
    """id of the worker that failed this task"""

    retry_state: temporalio.api.enums.v1.workflow_pb2.RetryState.ValueType
    def __init__(
        self,
        *,
        failure: typing.Optional[temporalio.api.failure.v1.message_pb2.Failure] = ...,
        scheduled_event_id: builtins.int = ...,
        started_event_id: builtins.int = ...,
        identity: typing.Text = ...,
        retry_state: temporalio.api.enums.v1.workflow_pb2.RetryState.ValueType = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["failure", b"failure"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "failure",
            b"failure",
            "identity",
            b"identity",
            "retry_state",
            b"retry_state",
            "scheduled_event_id",
            b"scheduled_event_id",
            "started_event_id",
            b"started_event_id",
        ],
    ) -> None: ...

global___ActivityTaskFailedEventAttributes = ActivityTaskFailedEventAttributes

class ActivityTaskTimedOutEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    FAILURE_FIELD_NUMBER: builtins.int
    SCHEDULED_EVENT_ID_FIELD_NUMBER: builtins.int
    STARTED_EVENT_ID_FIELD_NUMBER: builtins.int
    RETRY_STATE_FIELD_NUMBER: builtins.int
    @property
    def failure(self) -> temporalio.api.failure.v1.message_pb2.Failure:
        """If this activity had failed, was retried, and then timed out, that failure is stored as the
        `cause` in here.
        """
        pass
    scheduled_event_id: builtins.int
    """The id of the `ACTIVITY_TASK_SCHEDULED` event this timeout corresponds to"""

    started_event_id: builtins.int
    """The id of the `ACTIVITY_TASK_STARTED` event this timeout corresponds to"""

    retry_state: temporalio.api.enums.v1.workflow_pb2.RetryState.ValueType
    def __init__(
        self,
        *,
        failure: typing.Optional[temporalio.api.failure.v1.message_pb2.Failure] = ...,
        scheduled_event_id: builtins.int = ...,
        started_event_id: builtins.int = ...,
        retry_state: temporalio.api.enums.v1.workflow_pb2.RetryState.ValueType = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["failure", b"failure"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "failure",
            b"failure",
            "retry_state",
            b"retry_state",
            "scheduled_event_id",
            b"scheduled_event_id",
            "started_event_id",
            b"started_event_id",
        ],
    ) -> None: ...

global___ActivityTaskTimedOutEventAttributes = ActivityTaskTimedOutEventAttributes

class ActivityTaskCancelRequestedEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SCHEDULED_EVENT_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_TASK_COMPLETED_EVENT_ID_FIELD_NUMBER: builtins.int
    scheduled_event_id: builtins.int
    """The id of the `ACTIVITY_TASK_SCHEDULED` event this cancel request corresponds to"""

    workflow_task_completed_event_id: builtins.int
    """The `WORKFLOW_TASK_COMPLETED` event which this command was reported with"""

    def __init__(
        self,
        *,
        scheduled_event_id: builtins.int = ...,
        workflow_task_completed_event_id: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "scheduled_event_id",
            b"scheduled_event_id",
            "workflow_task_completed_event_id",
            b"workflow_task_completed_event_id",
        ],
    ) -> None: ...

global___ActivityTaskCancelRequestedEventAttributes = (
    ActivityTaskCancelRequestedEventAttributes
)

class ActivityTaskCanceledEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    DETAILS_FIELD_NUMBER: builtins.int
    LATEST_CANCEL_REQUESTED_EVENT_ID_FIELD_NUMBER: builtins.int
    SCHEDULED_EVENT_ID_FIELD_NUMBER: builtins.int
    STARTED_EVENT_ID_FIELD_NUMBER: builtins.int
    IDENTITY_FIELD_NUMBER: builtins.int
    @property
    def details(self) -> temporalio.api.common.v1.message_pb2.Payloads:
        """Additional information that the activity reported upon confirming cancellation"""
        pass
    latest_cancel_requested_event_id: builtins.int
    """id of the most recent `ACTIVITY_TASK_CANCEL_REQUESTED` event which refers to the same
    activity
    """

    scheduled_event_id: builtins.int
    """The id of the `ACTIVITY_TASK_SCHEDULED` event this cancel confirmation corresponds to"""

    started_event_id: builtins.int
    """The id of the `ACTIVITY_TASK_STARTED` event this cancel confirmation corresponds to"""

    identity: typing.Text
    """id of the worker who canceled this activity"""

    def __init__(
        self,
        *,
        details: typing.Optional[temporalio.api.common.v1.message_pb2.Payloads] = ...,
        latest_cancel_requested_event_id: builtins.int = ...,
        scheduled_event_id: builtins.int = ...,
        started_event_id: builtins.int = ...,
        identity: typing.Text = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["details", b"details"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "details",
            b"details",
            "identity",
            b"identity",
            "latest_cancel_requested_event_id",
            b"latest_cancel_requested_event_id",
            "scheduled_event_id",
            b"scheduled_event_id",
            "started_event_id",
            b"started_event_id",
        ],
    ) -> None: ...

global___ActivityTaskCanceledEventAttributes = ActivityTaskCanceledEventAttributes

class TimerStartedEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TIMER_ID_FIELD_NUMBER: builtins.int
    START_TO_FIRE_TIMEOUT_FIELD_NUMBER: builtins.int
    WORKFLOW_TASK_COMPLETED_EVENT_ID_FIELD_NUMBER: builtins.int
    timer_id: typing.Text
    """The worker/user assigned id for this timer"""

    @property
    def start_to_fire_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """How long until this timer fires

        (-- api-linter: core::0140::prepositions=disabled
            aip.dev/not-precedent: "to" is used to indicate interval. --)
        """
        pass
    workflow_task_completed_event_id: builtins.int
    """The `WORKFLOW_TASK_COMPLETED` event which this command was reported with"""

    def __init__(
        self,
        *,
        timer_id: typing.Text = ...,
        start_to_fire_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        workflow_task_completed_event_id: builtins.int = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "start_to_fire_timeout", b"start_to_fire_timeout"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "start_to_fire_timeout",
            b"start_to_fire_timeout",
            "timer_id",
            b"timer_id",
            "workflow_task_completed_event_id",
            b"workflow_task_completed_event_id",
        ],
    ) -> None: ...

global___TimerStartedEventAttributes = TimerStartedEventAttributes

class TimerFiredEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TIMER_ID_FIELD_NUMBER: builtins.int
    STARTED_EVENT_ID_FIELD_NUMBER: builtins.int
    timer_id: typing.Text
    """Will match the `timer_id` from `TIMER_STARTED` event for this timer"""

    started_event_id: builtins.int
    """The id of the `TIMER_STARTED` event itself"""

    def __init__(
        self,
        *,
        timer_id: typing.Text = ...,
        started_event_id: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "started_event_id", b"started_event_id", "timer_id", b"timer_id"
        ],
    ) -> None: ...

global___TimerFiredEventAttributes = TimerFiredEventAttributes

class TimerCanceledEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TIMER_ID_FIELD_NUMBER: builtins.int
    STARTED_EVENT_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_TASK_COMPLETED_EVENT_ID_FIELD_NUMBER: builtins.int
    IDENTITY_FIELD_NUMBER: builtins.int
    timer_id: typing.Text
    """Will match the `timer_id` from `TIMER_STARTED` event for this timer"""

    started_event_id: builtins.int
    """The id of the `TIMER_STARTED` event itself"""

    workflow_task_completed_event_id: builtins.int
    """The `WORKFLOW_TASK_COMPLETED` event which this command was reported with"""

    identity: typing.Text
    """The id of the worker who requested this cancel"""

    def __init__(
        self,
        *,
        timer_id: typing.Text = ...,
        started_event_id: builtins.int = ...,
        workflow_task_completed_event_id: builtins.int = ...,
        identity: typing.Text = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "identity",
            b"identity",
            "started_event_id",
            b"started_event_id",
            "timer_id",
            b"timer_id",
            "workflow_task_completed_event_id",
            b"workflow_task_completed_event_id",
        ],
    ) -> None: ...

global___TimerCanceledEventAttributes = TimerCanceledEventAttributes

class WorkflowExecutionCancelRequestedEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    CAUSE_FIELD_NUMBER: builtins.int
    EXTERNAL_INITIATED_EVENT_ID_FIELD_NUMBER: builtins.int
    EXTERNAL_WORKFLOW_EXECUTION_FIELD_NUMBER: builtins.int
    IDENTITY_FIELD_NUMBER: builtins.int
    cause: typing.Text
    """User provided reason for requesting cancellation
    TODO: shall we create a new field with name "reason" and deprecate this one?
    """

    external_initiated_event_id: builtins.int
    """TODO: Is this the ID of the event in the workflow which initiated this cancel, if there was one?"""

    @property
    def external_workflow_execution(
        self,
    ) -> temporalio.api.common.v1.message_pb2.WorkflowExecution: ...
    identity: typing.Text
    """id of the worker or client who requested this cancel"""

    def __init__(
        self,
        *,
        cause: typing.Text = ...,
        external_initiated_event_id: builtins.int = ...,
        external_workflow_execution: typing.Optional[
            temporalio.api.common.v1.message_pb2.WorkflowExecution
        ] = ...,
        identity: typing.Text = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "external_workflow_execution", b"external_workflow_execution"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "cause",
            b"cause",
            "external_initiated_event_id",
            b"external_initiated_event_id",
            "external_workflow_execution",
            b"external_workflow_execution",
            "identity",
            b"identity",
        ],
    ) -> None: ...

global___WorkflowExecutionCancelRequestedEventAttributes = (
    WorkflowExecutionCancelRequestedEventAttributes
)

class WorkflowExecutionCanceledEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    WORKFLOW_TASK_COMPLETED_EVENT_ID_FIELD_NUMBER: builtins.int
    DETAILS_FIELD_NUMBER: builtins.int
    workflow_task_completed_event_id: builtins.int
    """The `WORKFLOW_TASK_COMPLETED` event which this command was reported with"""

    @property
    def details(self) -> temporalio.api.common.v1.message_pb2.Payloads: ...
    def __init__(
        self,
        *,
        workflow_task_completed_event_id: builtins.int = ...,
        details: typing.Optional[temporalio.api.common.v1.message_pb2.Payloads] = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["details", b"details"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "details",
            b"details",
            "workflow_task_completed_event_id",
            b"workflow_task_completed_event_id",
        ],
    ) -> None: ...

global___WorkflowExecutionCanceledEventAttributes = (
    WorkflowExecutionCanceledEventAttributes
)

class MarkerRecordedEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class DetailsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> temporalio.api.common.v1.message_pb2.Payloads: ...
        def __init__(
            self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[temporalio.api.common.v1.message_pb2.Payloads] = ...,
        ) -> None: ...
        def HasField(
            self, field_name: typing_extensions.Literal["value", b"value"]
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal["key", b"key", "value", b"value"],
        ) -> None: ...

    MARKER_NAME_FIELD_NUMBER: builtins.int
    DETAILS_FIELD_NUMBER: builtins.int
    WORKFLOW_TASK_COMPLETED_EVENT_ID_FIELD_NUMBER: builtins.int
    HEADER_FIELD_NUMBER: builtins.int
    FAILURE_FIELD_NUMBER: builtins.int
    marker_name: typing.Text
    """Workers use this to identify the "types" of various markers. Ex: Local activity, side effect."""

    @property
    def details(
        self,
    ) -> google.protobuf.internal.containers.MessageMap[
        typing.Text, temporalio.api.common.v1.message_pb2.Payloads
    ]:
        """Serialized information recorded in the marker"""
        pass
    workflow_task_completed_event_id: builtins.int
    """The `WORKFLOW_TASK_COMPLETED` event which this command was reported with"""

    @property
    def header(self) -> temporalio.api.common.v1.message_pb2.Header: ...
    @property
    def failure(self) -> temporalio.api.failure.v1.message_pb2.Failure:
        """Some uses of markers, like a local activity, could "fail". If they did that is recorded here."""
        pass
    def __init__(
        self,
        *,
        marker_name: typing.Text = ...,
        details: typing.Optional[
            typing.Mapping[typing.Text, temporalio.api.common.v1.message_pb2.Payloads]
        ] = ...,
        workflow_task_completed_event_id: builtins.int = ...,
        header: typing.Optional[temporalio.api.common.v1.message_pb2.Header] = ...,
        failure: typing.Optional[temporalio.api.failure.v1.message_pb2.Failure] = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "failure", b"failure", "header", b"header"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "details",
            b"details",
            "failure",
            b"failure",
            "header",
            b"header",
            "marker_name",
            b"marker_name",
            "workflow_task_completed_event_id",
            b"workflow_task_completed_event_id",
        ],
    ) -> None: ...

global___MarkerRecordedEventAttributes = MarkerRecordedEventAttributes

class WorkflowExecutionSignaledEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SIGNAL_NAME_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    IDENTITY_FIELD_NUMBER: builtins.int
    HEADER_FIELD_NUMBER: builtins.int
    signal_name: typing.Text
    """The name/type of the signal to fire"""

    @property
    def input(self) -> temporalio.api.common.v1.message_pb2.Payloads:
        """Will be deserialized and provided as argument(s) to the signal handler"""
        pass
    identity: typing.Text
    """id of the worker/client who sent this signal"""

    @property
    def header(self) -> temporalio.api.common.v1.message_pb2.Header:
        """Headers that were passed by the sender of the signal and copied by temporal
        server into the workflow task.
        """
        pass
    def __init__(
        self,
        *,
        signal_name: typing.Text = ...,
        input: typing.Optional[temporalio.api.common.v1.message_pb2.Payloads] = ...,
        identity: typing.Text = ...,
        header: typing.Optional[temporalio.api.common.v1.message_pb2.Header] = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal["header", b"header", "input", b"input"],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "header",
            b"header",
            "identity",
            b"identity",
            "input",
            b"input",
            "signal_name",
            b"signal_name",
        ],
    ) -> None: ...

global___WorkflowExecutionSignaledEventAttributes = (
    WorkflowExecutionSignaledEventAttributes
)

class WorkflowExecutionTerminatedEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    REASON_FIELD_NUMBER: builtins.int
    DETAILS_FIELD_NUMBER: builtins.int
    IDENTITY_FIELD_NUMBER: builtins.int
    reason: typing.Text
    """User/client provided reason for termination"""

    @property
    def details(self) -> temporalio.api.common.v1.message_pb2.Payloads: ...
    identity: typing.Text
    """id of the client who requested termination"""

    def __init__(
        self,
        *,
        reason: typing.Text = ...,
        details: typing.Optional[temporalio.api.common.v1.message_pb2.Payloads] = ...,
        identity: typing.Text = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["details", b"details"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "details", b"details", "identity", b"identity", "reason", b"reason"
        ],
    ) -> None: ...

global___WorkflowExecutionTerminatedEventAttributes = (
    WorkflowExecutionTerminatedEventAttributes
)

class RequestCancelExternalWorkflowExecutionInitiatedEventAttributes(
    google.protobuf.message.Message
):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    WORKFLOW_TASK_COMPLETED_EVENT_ID_FIELD_NUMBER: builtins.int
    NAMESPACE_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_FIELD_NUMBER: builtins.int
    CONTROL_FIELD_NUMBER: builtins.int
    CHILD_WORKFLOW_ONLY_FIELD_NUMBER: builtins.int
    REASON_FIELD_NUMBER: builtins.int
    workflow_task_completed_event_id: builtins.int
    """The `WORKFLOW_TASK_COMPLETED` event which this command was reported with"""

    namespace: typing.Text
    """The namespace the workflow to be cancelled lives in"""

    @property
    def workflow_execution(
        self,
    ) -> temporalio.api.common.v1.message_pb2.WorkflowExecution: ...
    control: typing.Text
    """Deprecated"""

    child_workflow_only: builtins.bool
    """Workers are expected to set this to true if the workflow they are requesting to cancel is
    a child of the workflow which issued the request
    """

    reason: typing.Text
    """Reason for requesting the cancellation"""

    def __init__(
        self,
        *,
        workflow_task_completed_event_id: builtins.int = ...,
        namespace: typing.Text = ...,
        workflow_execution: typing.Optional[
            temporalio.api.common.v1.message_pb2.WorkflowExecution
        ] = ...,
        control: typing.Text = ...,
        child_workflow_only: builtins.bool = ...,
        reason: typing.Text = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "workflow_execution", b"workflow_execution"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "child_workflow_only",
            b"child_workflow_only",
            "control",
            b"control",
            "namespace",
            b"namespace",
            "reason",
            b"reason",
            "workflow_execution",
            b"workflow_execution",
            "workflow_task_completed_event_id",
            b"workflow_task_completed_event_id",
        ],
    ) -> None: ...

global___RequestCancelExternalWorkflowExecutionInitiatedEventAttributes = (
    RequestCancelExternalWorkflowExecutionInitiatedEventAttributes
)

class RequestCancelExternalWorkflowExecutionFailedEventAttributes(
    google.protobuf.message.Message
):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    CAUSE_FIELD_NUMBER: builtins.int
    WORKFLOW_TASK_COMPLETED_EVENT_ID_FIELD_NUMBER: builtins.int
    NAMESPACE_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_FIELD_NUMBER: builtins.int
    INITIATED_EVENT_ID_FIELD_NUMBER: builtins.int
    CONTROL_FIELD_NUMBER: builtins.int
    cause: temporalio.api.enums.v1.failed_cause_pb2.CancelExternalWorkflowExecutionFailedCause.ValueType
    workflow_task_completed_event_id: builtins.int
    """The `WORKFLOW_TASK_COMPLETED` event which this command was reported with"""

    namespace: typing.Text
    """namespace of the workflow which failed to cancel"""

    @property
    def workflow_execution(
        self,
    ) -> temporalio.api.common.v1.message_pb2.WorkflowExecution: ...
    initiated_event_id: builtins.int
    """id of the `REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_INITIATED` event this failure
    corresponds to
    """

    control: typing.Text
    """Deprecated"""

    def __init__(
        self,
        *,
        cause: temporalio.api.enums.v1.failed_cause_pb2.CancelExternalWorkflowExecutionFailedCause.ValueType = ...,
        workflow_task_completed_event_id: builtins.int = ...,
        namespace: typing.Text = ...,
        workflow_execution: typing.Optional[
            temporalio.api.common.v1.message_pb2.WorkflowExecution
        ] = ...,
        initiated_event_id: builtins.int = ...,
        control: typing.Text = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "workflow_execution", b"workflow_execution"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "cause",
            b"cause",
            "control",
            b"control",
            "initiated_event_id",
            b"initiated_event_id",
            "namespace",
            b"namespace",
            "workflow_execution",
            b"workflow_execution",
            "workflow_task_completed_event_id",
            b"workflow_task_completed_event_id",
        ],
    ) -> None: ...

global___RequestCancelExternalWorkflowExecutionFailedEventAttributes = (
    RequestCancelExternalWorkflowExecutionFailedEventAttributes
)

class ExternalWorkflowExecutionCancelRequestedEventAttributes(
    google.protobuf.message.Message
):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    INITIATED_EVENT_ID_FIELD_NUMBER: builtins.int
    NAMESPACE_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_FIELD_NUMBER: builtins.int
    initiated_event_id: builtins.int
    """id of the `REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_INITIATED` event this event corresponds
    to
    """

    namespace: typing.Text
    """namespace of the to-be-cancelled workflow"""

    @property
    def workflow_execution(
        self,
    ) -> temporalio.api.common.v1.message_pb2.WorkflowExecution: ...
    def __init__(
        self,
        *,
        initiated_event_id: builtins.int = ...,
        namespace: typing.Text = ...,
        workflow_execution: typing.Optional[
            temporalio.api.common.v1.message_pb2.WorkflowExecution
        ] = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "workflow_execution", b"workflow_execution"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "initiated_event_id",
            b"initiated_event_id",
            "namespace",
            b"namespace",
            "workflow_execution",
            b"workflow_execution",
        ],
    ) -> None: ...

global___ExternalWorkflowExecutionCancelRequestedEventAttributes = (
    ExternalWorkflowExecutionCancelRequestedEventAttributes
)

class SignalExternalWorkflowExecutionInitiatedEventAttributes(
    google.protobuf.message.Message
):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    WORKFLOW_TASK_COMPLETED_EVENT_ID_FIELD_NUMBER: builtins.int
    NAMESPACE_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_FIELD_NUMBER: builtins.int
    SIGNAL_NAME_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    CONTROL_FIELD_NUMBER: builtins.int
    CHILD_WORKFLOW_ONLY_FIELD_NUMBER: builtins.int
    HEADER_FIELD_NUMBER: builtins.int
    workflow_task_completed_event_id: builtins.int
    """The `WORKFLOW_TASK_COMPLETED` event which this command was reported with"""

    namespace: typing.Text
    """namespace of the to-be-signalled workflow"""

    @property
    def workflow_execution(
        self,
    ) -> temporalio.api.common.v1.message_pb2.WorkflowExecution: ...
    signal_name: typing.Text
    """name/type of the signal to fire in the external workflow"""

    @property
    def input(self) -> temporalio.api.common.v1.message_pb2.Payloads:
        """Serialized arguments to provide to the signal handler"""
        pass
    control: typing.Text
    """Deprecated"""

    child_workflow_only: builtins.bool
    """Workers are expected to set this to true if the workflow they are requesting to cancel is
    a child of the workflow which issued the request
    """

    @property
    def header(self) -> temporalio.api.common.v1.message_pb2.Header: ...
    def __init__(
        self,
        *,
        workflow_task_completed_event_id: builtins.int = ...,
        namespace: typing.Text = ...,
        workflow_execution: typing.Optional[
            temporalio.api.common.v1.message_pb2.WorkflowExecution
        ] = ...,
        signal_name: typing.Text = ...,
        input: typing.Optional[temporalio.api.common.v1.message_pb2.Payloads] = ...,
        control: typing.Text = ...,
        child_workflow_only: builtins.bool = ...,
        header: typing.Optional[temporalio.api.common.v1.message_pb2.Header] = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "header",
            b"header",
            "input",
            b"input",
            "workflow_execution",
            b"workflow_execution",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "child_workflow_only",
            b"child_workflow_only",
            "control",
            b"control",
            "header",
            b"header",
            "input",
            b"input",
            "namespace",
            b"namespace",
            "signal_name",
            b"signal_name",
            "workflow_execution",
            b"workflow_execution",
            "workflow_task_completed_event_id",
            b"workflow_task_completed_event_id",
        ],
    ) -> None: ...

global___SignalExternalWorkflowExecutionInitiatedEventAttributes = (
    SignalExternalWorkflowExecutionInitiatedEventAttributes
)

class SignalExternalWorkflowExecutionFailedEventAttributes(
    google.protobuf.message.Message
):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    CAUSE_FIELD_NUMBER: builtins.int
    WORKFLOW_TASK_COMPLETED_EVENT_ID_FIELD_NUMBER: builtins.int
    NAMESPACE_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_FIELD_NUMBER: builtins.int
    INITIATED_EVENT_ID_FIELD_NUMBER: builtins.int
    CONTROL_FIELD_NUMBER: builtins.int
    cause: temporalio.api.enums.v1.failed_cause_pb2.SignalExternalWorkflowExecutionFailedCause.ValueType
    workflow_task_completed_event_id: builtins.int
    """The `WORKFLOW_TASK_COMPLETED` event which this command was reported with"""

    namespace: typing.Text
    @property
    def workflow_execution(
        self,
    ) -> temporalio.api.common.v1.message_pb2.WorkflowExecution: ...
    initiated_event_id: builtins.int
    control: typing.Text
    """Deprecated"""

    def __init__(
        self,
        *,
        cause: temporalio.api.enums.v1.failed_cause_pb2.SignalExternalWorkflowExecutionFailedCause.ValueType = ...,
        workflow_task_completed_event_id: builtins.int = ...,
        namespace: typing.Text = ...,
        workflow_execution: typing.Optional[
            temporalio.api.common.v1.message_pb2.WorkflowExecution
        ] = ...,
        initiated_event_id: builtins.int = ...,
        control: typing.Text = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "workflow_execution", b"workflow_execution"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "cause",
            b"cause",
            "control",
            b"control",
            "initiated_event_id",
            b"initiated_event_id",
            "namespace",
            b"namespace",
            "workflow_execution",
            b"workflow_execution",
            "workflow_task_completed_event_id",
            b"workflow_task_completed_event_id",
        ],
    ) -> None: ...

global___SignalExternalWorkflowExecutionFailedEventAttributes = (
    SignalExternalWorkflowExecutionFailedEventAttributes
)

class ExternalWorkflowExecutionSignaledEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    INITIATED_EVENT_ID_FIELD_NUMBER: builtins.int
    NAMESPACE_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_FIELD_NUMBER: builtins.int
    CONTROL_FIELD_NUMBER: builtins.int
    initiated_event_id: builtins.int
    """id of the `SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_INITIATED` event this event corresponds to"""

    namespace: typing.Text
    """namespace of the workflow which was signaled"""

    @property
    def workflow_execution(
        self,
    ) -> temporalio.api.common.v1.message_pb2.WorkflowExecution: ...
    control: typing.Text
    """Deprecated"""

    def __init__(
        self,
        *,
        initiated_event_id: builtins.int = ...,
        namespace: typing.Text = ...,
        workflow_execution: typing.Optional[
            temporalio.api.common.v1.message_pb2.WorkflowExecution
        ] = ...,
        control: typing.Text = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "workflow_execution", b"workflow_execution"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "control",
            b"control",
            "initiated_event_id",
            b"initiated_event_id",
            "namespace",
            b"namespace",
            "workflow_execution",
            b"workflow_execution",
        ],
    ) -> None: ...

global___ExternalWorkflowExecutionSignaledEventAttributes = (
    ExternalWorkflowExecutionSignaledEventAttributes
)

class UpsertWorkflowSearchAttributesEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    WORKFLOW_TASK_COMPLETED_EVENT_ID_FIELD_NUMBER: builtins.int
    SEARCH_ATTRIBUTES_FIELD_NUMBER: builtins.int
    workflow_task_completed_event_id: builtins.int
    """The `WORKFLOW_TASK_COMPLETED` event which this command was reported with"""

    @property
    def search_attributes(
        self,
    ) -> temporalio.api.common.v1.message_pb2.SearchAttributes: ...
    def __init__(
        self,
        *,
        workflow_task_completed_event_id: builtins.int = ...,
        search_attributes: typing.Optional[
            temporalio.api.common.v1.message_pb2.SearchAttributes
        ] = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "search_attributes", b"search_attributes"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "search_attributes",
            b"search_attributes",
            "workflow_task_completed_event_id",
            b"workflow_task_completed_event_id",
        ],
    ) -> None: ...

global___UpsertWorkflowSearchAttributesEventAttributes = (
    UpsertWorkflowSearchAttributesEventAttributes
)

class StartChildWorkflowExecutionInitiatedEventAttributes(
    google.protobuf.message.Message
):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    NAMESPACE_FIELD_NUMBER: builtins.int
    WORKFLOW_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_TYPE_FIELD_NUMBER: builtins.int
    TASK_QUEUE_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_TIMEOUT_FIELD_NUMBER: builtins.int
    WORKFLOW_RUN_TIMEOUT_FIELD_NUMBER: builtins.int
    WORKFLOW_TASK_TIMEOUT_FIELD_NUMBER: builtins.int
    PARENT_CLOSE_POLICY_FIELD_NUMBER: builtins.int
    CONTROL_FIELD_NUMBER: builtins.int
    WORKFLOW_TASK_COMPLETED_EVENT_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_ID_REUSE_POLICY_FIELD_NUMBER: builtins.int
    RETRY_POLICY_FIELD_NUMBER: builtins.int
    CRON_SCHEDULE_FIELD_NUMBER: builtins.int
    HEADER_FIELD_NUMBER: builtins.int
    MEMO_FIELD_NUMBER: builtins.int
    SEARCH_ATTRIBUTES_FIELD_NUMBER: builtins.int
    namespace: typing.Text
    """Namespace of the child workflow"""

    workflow_id: typing.Text
    @property
    def workflow_type(self) -> temporalio.api.common.v1.message_pb2.WorkflowType: ...
    @property
    def task_queue(self) -> temporalio.api.taskqueue.v1.message_pb2.TaskQueue: ...
    @property
    def input(self) -> temporalio.api.common.v1.message_pb2.Payloads: ...
    @property
    def workflow_execution_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Total workflow execution timeout including retries and continue as new."""
        pass
    @property
    def workflow_run_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Timeout of a single workflow run."""
        pass
    @property
    def workflow_task_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Timeout of a single workflow task."""
        pass
    parent_close_policy: temporalio.api.enums.v1.workflow_pb2.ParentClosePolicy.ValueType
    """Default: PARENT_CLOSE_POLICY_TERMINATE."""

    control: typing.Text
    """Deprecated"""

    workflow_task_completed_event_id: builtins.int
    """The `WORKFLOW_TASK_COMPLETED` event which this command was reported with"""

    workflow_id_reuse_policy: temporalio.api.enums.v1.workflow_pb2.WorkflowIdReusePolicy.ValueType
    """Default: WORKFLOW_ID_REUSE_POLICY_ALLOW_DUPLICATE."""

    @property
    def retry_policy(self) -> temporalio.api.common.v1.message_pb2.RetryPolicy: ...
    cron_schedule: typing.Text
    """If this child runs on a cron schedule, it will appear here"""

    @property
    def header(self) -> temporalio.api.common.v1.message_pb2.Header: ...
    @property
    def memo(self) -> temporalio.api.common.v1.message_pb2.Memo: ...
    @property
    def search_attributes(
        self,
    ) -> temporalio.api.common.v1.message_pb2.SearchAttributes: ...
    def __init__(
        self,
        *,
        namespace: typing.Text = ...,
        workflow_id: typing.Text = ...,
        workflow_type: typing.Optional[
            temporalio.api.common.v1.message_pb2.WorkflowType
        ] = ...,
        task_queue: typing.Optional[
            temporalio.api.taskqueue.v1.message_pb2.TaskQueue
        ] = ...,
        input: typing.Optional[temporalio.api.common.v1.message_pb2.Payloads] = ...,
        workflow_execution_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        workflow_run_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        workflow_task_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        parent_close_policy: temporalio.api.enums.v1.workflow_pb2.ParentClosePolicy.ValueType = ...,
        control: typing.Text = ...,
        workflow_task_completed_event_id: builtins.int = ...,
        workflow_id_reuse_policy: temporalio.api.enums.v1.workflow_pb2.WorkflowIdReusePolicy.ValueType = ...,
        retry_policy: typing.Optional[
            temporalio.api.common.v1.message_pb2.RetryPolicy
        ] = ...,
        cron_schedule: typing.Text = ...,
        header: typing.Optional[temporalio.api.common.v1.message_pb2.Header] = ...,
        memo: typing.Optional[temporalio.api.common.v1.message_pb2.Memo] = ...,
        search_attributes: typing.Optional[
            temporalio.api.common.v1.message_pb2.SearchAttributes
        ] = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "header",
            b"header",
            "input",
            b"input",
            "memo",
            b"memo",
            "retry_policy",
            b"retry_policy",
            "search_attributes",
            b"search_attributes",
            "task_queue",
            b"task_queue",
            "workflow_execution_timeout",
            b"workflow_execution_timeout",
            "workflow_run_timeout",
            b"workflow_run_timeout",
            "workflow_task_timeout",
            b"workflow_task_timeout",
            "workflow_type",
            b"workflow_type",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "control",
            b"control",
            "cron_schedule",
            b"cron_schedule",
            "header",
            b"header",
            "input",
            b"input",
            "memo",
            b"memo",
            "namespace",
            b"namespace",
            "parent_close_policy",
            b"parent_close_policy",
            "retry_policy",
            b"retry_policy",
            "search_attributes",
            b"search_attributes",
            "task_queue",
            b"task_queue",
            "workflow_execution_timeout",
            b"workflow_execution_timeout",
            "workflow_id",
            b"workflow_id",
            "workflow_id_reuse_policy",
            b"workflow_id_reuse_policy",
            "workflow_run_timeout",
            b"workflow_run_timeout",
            "workflow_task_completed_event_id",
            b"workflow_task_completed_event_id",
            "workflow_task_timeout",
            b"workflow_task_timeout",
            "workflow_type",
            b"workflow_type",
        ],
    ) -> None: ...

global___StartChildWorkflowExecutionInitiatedEventAttributes = (
    StartChildWorkflowExecutionInitiatedEventAttributes
)

class StartChildWorkflowExecutionFailedEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    NAMESPACE_FIELD_NUMBER: builtins.int
    WORKFLOW_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_TYPE_FIELD_NUMBER: builtins.int
    CAUSE_FIELD_NUMBER: builtins.int
    CONTROL_FIELD_NUMBER: builtins.int
    INITIATED_EVENT_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_TASK_COMPLETED_EVENT_ID_FIELD_NUMBER: builtins.int
    namespace: typing.Text
    """Namespace of the child workflow"""

    workflow_id: typing.Text
    @property
    def workflow_type(self) -> temporalio.api.common.v1.message_pb2.WorkflowType: ...
    cause: temporalio.api.enums.v1.failed_cause_pb2.StartChildWorkflowExecutionFailedCause.ValueType
    control: typing.Text
    """Deprecated"""

    initiated_event_id: builtins.int
    """Id of the `START_CHILD_WORKFLOW_EXECUTION_INITIATED` event which this event corresponds to"""

    workflow_task_completed_event_id: builtins.int
    """The `WORKFLOW_TASK_COMPLETED` event which this command was reported with"""

    def __init__(
        self,
        *,
        namespace: typing.Text = ...,
        workflow_id: typing.Text = ...,
        workflow_type: typing.Optional[
            temporalio.api.common.v1.message_pb2.WorkflowType
        ] = ...,
        cause: temporalio.api.enums.v1.failed_cause_pb2.StartChildWorkflowExecutionFailedCause.ValueType = ...,
        control: typing.Text = ...,
        initiated_event_id: builtins.int = ...,
        workflow_task_completed_event_id: builtins.int = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["workflow_type", b"workflow_type"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "cause",
            b"cause",
            "control",
            b"control",
            "initiated_event_id",
            b"initiated_event_id",
            "namespace",
            b"namespace",
            "workflow_id",
            b"workflow_id",
            "workflow_task_completed_event_id",
            b"workflow_task_completed_event_id",
            "workflow_type",
            b"workflow_type",
        ],
    ) -> None: ...

global___StartChildWorkflowExecutionFailedEventAttributes = (
    StartChildWorkflowExecutionFailedEventAttributes
)

class ChildWorkflowExecutionStartedEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    NAMESPACE_FIELD_NUMBER: builtins.int
    INITIATED_EVENT_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_FIELD_NUMBER: builtins.int
    WORKFLOW_TYPE_FIELD_NUMBER: builtins.int
    HEADER_FIELD_NUMBER: builtins.int
    namespace: typing.Text
    """Namespace of the child workflow"""

    initiated_event_id: builtins.int
    """Id of the `START_CHILD_WORKFLOW_EXECUTION_INITIATED` event which this event corresponds to"""

    @property
    def workflow_execution(
        self,
    ) -> temporalio.api.common.v1.message_pb2.WorkflowExecution: ...
    @property
    def workflow_type(self) -> temporalio.api.common.v1.message_pb2.WorkflowType: ...
    @property
    def header(self) -> temporalio.api.common.v1.message_pb2.Header: ...
    def __init__(
        self,
        *,
        namespace: typing.Text = ...,
        initiated_event_id: builtins.int = ...,
        workflow_execution: typing.Optional[
            temporalio.api.common.v1.message_pb2.WorkflowExecution
        ] = ...,
        workflow_type: typing.Optional[
            temporalio.api.common.v1.message_pb2.WorkflowType
        ] = ...,
        header: typing.Optional[temporalio.api.common.v1.message_pb2.Header] = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "header",
            b"header",
            "workflow_execution",
            b"workflow_execution",
            "workflow_type",
            b"workflow_type",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "header",
            b"header",
            "initiated_event_id",
            b"initiated_event_id",
            "namespace",
            b"namespace",
            "workflow_execution",
            b"workflow_execution",
            "workflow_type",
            b"workflow_type",
        ],
    ) -> None: ...

global___ChildWorkflowExecutionStartedEventAttributes = (
    ChildWorkflowExecutionStartedEventAttributes
)

class ChildWorkflowExecutionCompletedEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    RESULT_FIELD_NUMBER: builtins.int
    NAMESPACE_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_FIELD_NUMBER: builtins.int
    WORKFLOW_TYPE_FIELD_NUMBER: builtins.int
    INITIATED_EVENT_ID_FIELD_NUMBER: builtins.int
    STARTED_EVENT_ID_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> temporalio.api.common.v1.message_pb2.Payloads: ...
    namespace: typing.Text
    """Namespace of the child workflow"""

    @property
    def workflow_execution(
        self,
    ) -> temporalio.api.common.v1.message_pb2.WorkflowExecution: ...
    @property
    def workflow_type(self) -> temporalio.api.common.v1.message_pb2.WorkflowType: ...
    initiated_event_id: builtins.int
    """Id of the `START_CHILD_WORKFLOW_EXECUTION_INITIATED` event which this event corresponds to"""

    started_event_id: builtins.int
    """Id of the `CHILD_WORKFLOW_EXECUTION_STARTED` event which this event corresponds to"""

    def __init__(
        self,
        *,
        result: typing.Optional[temporalio.api.common.v1.message_pb2.Payloads] = ...,
        namespace: typing.Text = ...,
        workflow_execution: typing.Optional[
            temporalio.api.common.v1.message_pb2.WorkflowExecution
        ] = ...,
        workflow_type: typing.Optional[
            temporalio.api.common.v1.message_pb2.WorkflowType
        ] = ...,
        initiated_event_id: builtins.int = ...,
        started_event_id: builtins.int = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "result",
            b"result",
            "workflow_execution",
            b"workflow_execution",
            "workflow_type",
            b"workflow_type",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "initiated_event_id",
            b"initiated_event_id",
            "namespace",
            b"namespace",
            "result",
            b"result",
            "started_event_id",
            b"started_event_id",
            "workflow_execution",
            b"workflow_execution",
            "workflow_type",
            b"workflow_type",
        ],
    ) -> None: ...

global___ChildWorkflowExecutionCompletedEventAttributes = (
    ChildWorkflowExecutionCompletedEventAttributes
)

class ChildWorkflowExecutionFailedEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    FAILURE_FIELD_NUMBER: builtins.int
    NAMESPACE_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_FIELD_NUMBER: builtins.int
    WORKFLOW_TYPE_FIELD_NUMBER: builtins.int
    INITIATED_EVENT_ID_FIELD_NUMBER: builtins.int
    STARTED_EVENT_ID_FIELD_NUMBER: builtins.int
    RETRY_STATE_FIELD_NUMBER: builtins.int
    @property
    def failure(self) -> temporalio.api.failure.v1.message_pb2.Failure: ...
    namespace: typing.Text
    """Namespace of the child workflow"""

    @property
    def workflow_execution(
        self,
    ) -> temporalio.api.common.v1.message_pb2.WorkflowExecution: ...
    @property
    def workflow_type(self) -> temporalio.api.common.v1.message_pb2.WorkflowType: ...
    initiated_event_id: builtins.int
    """Id of the `START_CHILD_WORKFLOW_EXECUTION_INITIATED` event which this event corresponds to"""

    started_event_id: builtins.int
    """Id of the `CHILD_WORKFLOW_EXECUTION_STARTED` event which this event corresponds to"""

    retry_state: temporalio.api.enums.v1.workflow_pb2.RetryState.ValueType
    def __init__(
        self,
        *,
        failure: typing.Optional[temporalio.api.failure.v1.message_pb2.Failure] = ...,
        namespace: typing.Text = ...,
        workflow_execution: typing.Optional[
            temporalio.api.common.v1.message_pb2.WorkflowExecution
        ] = ...,
        workflow_type: typing.Optional[
            temporalio.api.common.v1.message_pb2.WorkflowType
        ] = ...,
        initiated_event_id: builtins.int = ...,
        started_event_id: builtins.int = ...,
        retry_state: temporalio.api.enums.v1.workflow_pb2.RetryState.ValueType = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "failure",
            b"failure",
            "workflow_execution",
            b"workflow_execution",
            "workflow_type",
            b"workflow_type",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "failure",
            b"failure",
            "initiated_event_id",
            b"initiated_event_id",
            "namespace",
            b"namespace",
            "retry_state",
            b"retry_state",
            "started_event_id",
            b"started_event_id",
            "workflow_execution",
            b"workflow_execution",
            "workflow_type",
            b"workflow_type",
        ],
    ) -> None: ...

global___ChildWorkflowExecutionFailedEventAttributes = (
    ChildWorkflowExecutionFailedEventAttributes
)

class ChildWorkflowExecutionCanceledEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    DETAILS_FIELD_NUMBER: builtins.int
    NAMESPACE_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_FIELD_NUMBER: builtins.int
    WORKFLOW_TYPE_FIELD_NUMBER: builtins.int
    INITIATED_EVENT_ID_FIELD_NUMBER: builtins.int
    STARTED_EVENT_ID_FIELD_NUMBER: builtins.int
    @property
    def details(self) -> temporalio.api.common.v1.message_pb2.Payloads: ...
    namespace: typing.Text
    """Namespace of the child workflow"""

    @property
    def workflow_execution(
        self,
    ) -> temporalio.api.common.v1.message_pb2.WorkflowExecution: ...
    @property
    def workflow_type(self) -> temporalio.api.common.v1.message_pb2.WorkflowType: ...
    initiated_event_id: builtins.int
    """Id of the `START_CHILD_WORKFLOW_EXECUTION_INITIATED` event which this event corresponds to"""

    started_event_id: builtins.int
    """Id of the `CHILD_WORKFLOW_EXECUTION_STARTED` event which this event corresponds to"""

    def __init__(
        self,
        *,
        details: typing.Optional[temporalio.api.common.v1.message_pb2.Payloads] = ...,
        namespace: typing.Text = ...,
        workflow_execution: typing.Optional[
            temporalio.api.common.v1.message_pb2.WorkflowExecution
        ] = ...,
        workflow_type: typing.Optional[
            temporalio.api.common.v1.message_pb2.WorkflowType
        ] = ...,
        initiated_event_id: builtins.int = ...,
        started_event_id: builtins.int = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "details",
            b"details",
            "workflow_execution",
            b"workflow_execution",
            "workflow_type",
            b"workflow_type",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "details",
            b"details",
            "initiated_event_id",
            b"initiated_event_id",
            "namespace",
            b"namespace",
            "started_event_id",
            b"started_event_id",
            "workflow_execution",
            b"workflow_execution",
            "workflow_type",
            b"workflow_type",
        ],
    ) -> None: ...

global___ChildWorkflowExecutionCanceledEventAttributes = (
    ChildWorkflowExecutionCanceledEventAttributes
)

class ChildWorkflowExecutionTimedOutEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    NAMESPACE_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_FIELD_NUMBER: builtins.int
    WORKFLOW_TYPE_FIELD_NUMBER: builtins.int
    INITIATED_EVENT_ID_FIELD_NUMBER: builtins.int
    STARTED_EVENT_ID_FIELD_NUMBER: builtins.int
    RETRY_STATE_FIELD_NUMBER: builtins.int
    namespace: typing.Text
    """Namespace of the child workflow"""

    @property
    def workflow_execution(
        self,
    ) -> temporalio.api.common.v1.message_pb2.WorkflowExecution: ...
    @property
    def workflow_type(self) -> temporalio.api.common.v1.message_pb2.WorkflowType: ...
    initiated_event_id: builtins.int
    """Id of the `START_CHILD_WORKFLOW_EXECUTION_INITIATED` event which this event corresponds to"""

    started_event_id: builtins.int
    """Id of the `CHILD_WORKFLOW_EXECUTION_STARTED` event which this event corresponds to"""

    retry_state: temporalio.api.enums.v1.workflow_pb2.RetryState.ValueType
    def __init__(
        self,
        *,
        namespace: typing.Text = ...,
        workflow_execution: typing.Optional[
            temporalio.api.common.v1.message_pb2.WorkflowExecution
        ] = ...,
        workflow_type: typing.Optional[
            temporalio.api.common.v1.message_pb2.WorkflowType
        ] = ...,
        initiated_event_id: builtins.int = ...,
        started_event_id: builtins.int = ...,
        retry_state: temporalio.api.enums.v1.workflow_pb2.RetryState.ValueType = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "workflow_execution",
            b"workflow_execution",
            "workflow_type",
            b"workflow_type",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "initiated_event_id",
            b"initiated_event_id",
            "namespace",
            b"namespace",
            "retry_state",
            b"retry_state",
            "started_event_id",
            b"started_event_id",
            "workflow_execution",
            b"workflow_execution",
            "workflow_type",
            b"workflow_type",
        ],
    ) -> None: ...

global___ChildWorkflowExecutionTimedOutEventAttributes = (
    ChildWorkflowExecutionTimedOutEventAttributes
)

class ChildWorkflowExecutionTerminatedEventAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    NAMESPACE_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_FIELD_NUMBER: builtins.int
    WORKFLOW_TYPE_FIELD_NUMBER: builtins.int
    INITIATED_EVENT_ID_FIELD_NUMBER: builtins.int
    STARTED_EVENT_ID_FIELD_NUMBER: builtins.int
    namespace: typing.Text
    """Namespace of the child workflow"""

    @property
    def workflow_execution(
        self,
    ) -> temporalio.api.common.v1.message_pb2.WorkflowExecution: ...
    @property
    def workflow_type(self) -> temporalio.api.common.v1.message_pb2.WorkflowType: ...
    initiated_event_id: builtins.int
    """Id of the `START_CHILD_WORKFLOW_EXECUTION_INITIATED` event which this event corresponds to"""

    started_event_id: builtins.int
    """Id of the `CHILD_WORKFLOW_EXECUTION_STARTED` event which this event corresponds to"""

    def __init__(
        self,
        *,
        namespace: typing.Text = ...,
        workflow_execution: typing.Optional[
            temporalio.api.common.v1.message_pb2.WorkflowExecution
        ] = ...,
        workflow_type: typing.Optional[
            temporalio.api.common.v1.message_pb2.WorkflowType
        ] = ...,
        initiated_event_id: builtins.int = ...,
        started_event_id: builtins.int = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "workflow_execution",
            b"workflow_execution",
            "workflow_type",
            b"workflow_type",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "initiated_event_id",
            b"initiated_event_id",
            "namespace",
            b"namespace",
            "started_event_id",
            b"started_event_id",
            "workflow_execution",
            b"workflow_execution",
            "workflow_type",
            b"workflow_type",
        ],
    ) -> None: ...

global___ChildWorkflowExecutionTerminatedEventAttributes = (
    ChildWorkflowExecutionTerminatedEventAttributes
)

class HistoryEvent(google.protobuf.message.Message):
    """History events are the method by which Temporal SDKs advance (or recreate) workflow state.
    See the `EventType` enum for more info about what each event is for.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    EVENT_ID_FIELD_NUMBER: builtins.int
    EVENT_TIME_FIELD_NUMBER: builtins.int
    EVENT_TYPE_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    TASK_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_STARTED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_COMPLETED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_FAILED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_TIMED_OUT_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    WORKFLOW_TASK_SCHEDULED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    WORKFLOW_TASK_STARTED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    WORKFLOW_TASK_COMPLETED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    WORKFLOW_TASK_TIMED_OUT_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    WORKFLOW_TASK_FAILED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    ACTIVITY_TASK_SCHEDULED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    ACTIVITY_TASK_STARTED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    ACTIVITY_TASK_COMPLETED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    ACTIVITY_TASK_FAILED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    ACTIVITY_TASK_TIMED_OUT_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    TIMER_STARTED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    TIMER_FIRED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    ACTIVITY_TASK_CANCEL_REQUESTED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    ACTIVITY_TASK_CANCELED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    TIMER_CANCELED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    MARKER_RECORDED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_SIGNALED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_TERMINATED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_CANCEL_REQUESTED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_CANCELED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_INITIATED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_FAILED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    EXTERNAL_WORKFLOW_EXECUTION_CANCEL_REQUESTED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_CONTINUED_AS_NEW_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    START_CHILD_WORKFLOW_EXECUTION_INITIATED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    START_CHILD_WORKFLOW_EXECUTION_FAILED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    CHILD_WORKFLOW_EXECUTION_STARTED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    CHILD_WORKFLOW_EXECUTION_COMPLETED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    CHILD_WORKFLOW_EXECUTION_FAILED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    CHILD_WORKFLOW_EXECUTION_CANCELED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    CHILD_WORKFLOW_EXECUTION_TIMED_OUT_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    CHILD_WORKFLOW_EXECUTION_TERMINATED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_INITIATED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_FAILED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    EXTERNAL_WORKFLOW_EXECUTION_SIGNALED_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    UPSERT_WORKFLOW_SEARCH_ATTRIBUTES_EVENT_ATTRIBUTES_FIELD_NUMBER: builtins.int
    event_id: builtins.int
    """Monotonically increasing event number, starts at 1."""

    @property
    def event_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    event_type: temporalio.api.enums.v1.event_type_pb2.EventType.ValueType
    version: builtins.int
    """TODO: What is this? Appears unused by SDKs"""

    task_id: builtins.int
    """TODO: What is this? Appears unused by SDKs"""

    @property
    def workflow_execution_started_event_attributes(
        self,
    ) -> global___WorkflowExecutionStartedEventAttributes: ...
    @property
    def workflow_execution_completed_event_attributes(
        self,
    ) -> global___WorkflowExecutionCompletedEventAttributes: ...
    @property
    def workflow_execution_failed_event_attributes(
        self,
    ) -> global___WorkflowExecutionFailedEventAttributes: ...
    @property
    def workflow_execution_timed_out_event_attributes(
        self,
    ) -> global___WorkflowExecutionTimedOutEventAttributes: ...
    @property
    def workflow_task_scheduled_event_attributes(
        self,
    ) -> global___WorkflowTaskScheduledEventAttributes: ...
    @property
    def workflow_task_started_event_attributes(
        self,
    ) -> global___WorkflowTaskStartedEventAttributes: ...
    @property
    def workflow_task_completed_event_attributes(
        self,
    ) -> global___WorkflowTaskCompletedEventAttributes: ...
    @property
    def workflow_task_timed_out_event_attributes(
        self,
    ) -> global___WorkflowTaskTimedOutEventAttributes: ...
    @property
    def workflow_task_failed_event_attributes(
        self,
    ) -> global___WorkflowTaskFailedEventAttributes: ...
    @property
    def activity_task_scheduled_event_attributes(
        self,
    ) -> global___ActivityTaskScheduledEventAttributes: ...
    @property
    def activity_task_started_event_attributes(
        self,
    ) -> global___ActivityTaskStartedEventAttributes: ...
    @property
    def activity_task_completed_event_attributes(
        self,
    ) -> global___ActivityTaskCompletedEventAttributes: ...
    @property
    def activity_task_failed_event_attributes(
        self,
    ) -> global___ActivityTaskFailedEventAttributes: ...
    @property
    def activity_task_timed_out_event_attributes(
        self,
    ) -> global___ActivityTaskTimedOutEventAttributes: ...
    @property
    def timer_started_event_attributes(
        self,
    ) -> global___TimerStartedEventAttributes: ...
    @property
    def timer_fired_event_attributes(self) -> global___TimerFiredEventAttributes: ...
    @property
    def activity_task_cancel_requested_event_attributes(
        self,
    ) -> global___ActivityTaskCancelRequestedEventAttributes: ...
    @property
    def activity_task_canceled_event_attributes(
        self,
    ) -> global___ActivityTaskCanceledEventAttributes: ...
    @property
    def timer_canceled_event_attributes(
        self,
    ) -> global___TimerCanceledEventAttributes: ...
    @property
    def marker_recorded_event_attributes(
        self,
    ) -> global___MarkerRecordedEventAttributes: ...
    @property
    def workflow_execution_signaled_event_attributes(
        self,
    ) -> global___WorkflowExecutionSignaledEventAttributes: ...
    @property
    def workflow_execution_terminated_event_attributes(
        self,
    ) -> global___WorkflowExecutionTerminatedEventAttributes: ...
    @property
    def workflow_execution_cancel_requested_event_attributes(
        self,
    ) -> global___WorkflowExecutionCancelRequestedEventAttributes: ...
    @property
    def workflow_execution_canceled_event_attributes(
        self,
    ) -> global___WorkflowExecutionCanceledEventAttributes: ...
    @property
    def request_cancel_external_workflow_execution_initiated_event_attributes(
        self,
    ) -> global___RequestCancelExternalWorkflowExecutionInitiatedEventAttributes: ...
    @property
    def request_cancel_external_workflow_execution_failed_event_attributes(
        self,
    ) -> global___RequestCancelExternalWorkflowExecutionFailedEventAttributes: ...
    @property
    def external_workflow_execution_cancel_requested_event_attributes(
        self,
    ) -> global___ExternalWorkflowExecutionCancelRequestedEventAttributes: ...
    @property
    def workflow_execution_continued_as_new_event_attributes(
        self,
    ) -> global___WorkflowExecutionContinuedAsNewEventAttributes: ...
    @property
    def start_child_workflow_execution_initiated_event_attributes(
        self,
    ) -> global___StartChildWorkflowExecutionInitiatedEventAttributes: ...
    @property
    def start_child_workflow_execution_failed_event_attributes(
        self,
    ) -> global___StartChildWorkflowExecutionFailedEventAttributes: ...
    @property
    def child_workflow_execution_started_event_attributes(
        self,
    ) -> global___ChildWorkflowExecutionStartedEventAttributes: ...
    @property
    def child_workflow_execution_completed_event_attributes(
        self,
    ) -> global___ChildWorkflowExecutionCompletedEventAttributes: ...
    @property
    def child_workflow_execution_failed_event_attributes(
        self,
    ) -> global___ChildWorkflowExecutionFailedEventAttributes: ...
    @property
    def child_workflow_execution_canceled_event_attributes(
        self,
    ) -> global___ChildWorkflowExecutionCanceledEventAttributes: ...
    @property
    def child_workflow_execution_timed_out_event_attributes(
        self,
    ) -> global___ChildWorkflowExecutionTimedOutEventAttributes: ...
    @property
    def child_workflow_execution_terminated_event_attributes(
        self,
    ) -> global___ChildWorkflowExecutionTerminatedEventAttributes: ...
    @property
    def signal_external_workflow_execution_initiated_event_attributes(
        self,
    ) -> global___SignalExternalWorkflowExecutionInitiatedEventAttributes: ...
    @property
    def signal_external_workflow_execution_failed_event_attributes(
        self,
    ) -> global___SignalExternalWorkflowExecutionFailedEventAttributes: ...
    @property
    def external_workflow_execution_signaled_event_attributes(
        self,
    ) -> global___ExternalWorkflowExecutionSignaledEventAttributes: ...
    @property
    def upsert_workflow_search_attributes_event_attributes(
        self,
    ) -> global___UpsertWorkflowSearchAttributesEventAttributes: ...
    def __init__(
        self,
        *,
        event_id: builtins.int = ...,
        event_time: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        event_type: temporalio.api.enums.v1.event_type_pb2.EventType.ValueType = ...,
        version: builtins.int = ...,
        task_id: builtins.int = ...,
        workflow_execution_started_event_attributes: typing.Optional[
            global___WorkflowExecutionStartedEventAttributes
        ] = ...,
        workflow_execution_completed_event_attributes: typing.Optional[
            global___WorkflowExecutionCompletedEventAttributes
        ] = ...,
        workflow_execution_failed_event_attributes: typing.Optional[
            global___WorkflowExecutionFailedEventAttributes
        ] = ...,
        workflow_execution_timed_out_event_attributes: typing.Optional[
            global___WorkflowExecutionTimedOutEventAttributes
        ] = ...,
        workflow_task_scheduled_event_attributes: typing.Optional[
            global___WorkflowTaskScheduledEventAttributes
        ] = ...,
        workflow_task_started_event_attributes: typing.Optional[
            global___WorkflowTaskStartedEventAttributes
        ] = ...,
        workflow_task_completed_event_attributes: typing.Optional[
            global___WorkflowTaskCompletedEventAttributes
        ] = ...,
        workflow_task_timed_out_event_attributes: typing.Optional[
            global___WorkflowTaskTimedOutEventAttributes
        ] = ...,
        workflow_task_failed_event_attributes: typing.Optional[
            global___WorkflowTaskFailedEventAttributes
        ] = ...,
        activity_task_scheduled_event_attributes: typing.Optional[
            global___ActivityTaskScheduledEventAttributes
        ] = ...,
        activity_task_started_event_attributes: typing.Optional[
            global___ActivityTaskStartedEventAttributes
        ] = ...,
        activity_task_completed_event_attributes: typing.Optional[
            global___ActivityTaskCompletedEventAttributes
        ] = ...,
        activity_task_failed_event_attributes: typing.Optional[
            global___ActivityTaskFailedEventAttributes
        ] = ...,
        activity_task_timed_out_event_attributes: typing.Optional[
            global___ActivityTaskTimedOutEventAttributes
        ] = ...,
        timer_started_event_attributes: typing.Optional[
            global___TimerStartedEventAttributes
        ] = ...,
        timer_fired_event_attributes: typing.Optional[
            global___TimerFiredEventAttributes
        ] = ...,
        activity_task_cancel_requested_event_attributes: typing.Optional[
            global___ActivityTaskCancelRequestedEventAttributes
        ] = ...,
        activity_task_canceled_event_attributes: typing.Optional[
            global___ActivityTaskCanceledEventAttributes
        ] = ...,
        timer_canceled_event_attributes: typing.Optional[
            global___TimerCanceledEventAttributes
        ] = ...,
        marker_recorded_event_attributes: typing.Optional[
            global___MarkerRecordedEventAttributes
        ] = ...,
        workflow_execution_signaled_event_attributes: typing.Optional[
            global___WorkflowExecutionSignaledEventAttributes
        ] = ...,
        workflow_execution_terminated_event_attributes: typing.Optional[
            global___WorkflowExecutionTerminatedEventAttributes
        ] = ...,
        workflow_execution_cancel_requested_event_attributes: typing.Optional[
            global___WorkflowExecutionCancelRequestedEventAttributes
        ] = ...,
        workflow_execution_canceled_event_attributes: typing.Optional[
            global___WorkflowExecutionCanceledEventAttributes
        ] = ...,
        request_cancel_external_workflow_execution_initiated_event_attributes: typing.Optional[
            global___RequestCancelExternalWorkflowExecutionInitiatedEventAttributes
        ] = ...,
        request_cancel_external_workflow_execution_failed_event_attributes: typing.Optional[
            global___RequestCancelExternalWorkflowExecutionFailedEventAttributes
        ] = ...,
        external_workflow_execution_cancel_requested_event_attributes: typing.Optional[
            global___ExternalWorkflowExecutionCancelRequestedEventAttributes
        ] = ...,
        workflow_execution_continued_as_new_event_attributes: typing.Optional[
            global___WorkflowExecutionContinuedAsNewEventAttributes
        ] = ...,
        start_child_workflow_execution_initiated_event_attributes: typing.Optional[
            global___StartChildWorkflowExecutionInitiatedEventAttributes
        ] = ...,
        start_child_workflow_execution_failed_event_attributes: typing.Optional[
            global___StartChildWorkflowExecutionFailedEventAttributes
        ] = ...,
        child_workflow_execution_started_event_attributes: typing.Optional[
            global___ChildWorkflowExecutionStartedEventAttributes
        ] = ...,
        child_workflow_execution_completed_event_attributes: typing.Optional[
            global___ChildWorkflowExecutionCompletedEventAttributes
        ] = ...,
        child_workflow_execution_failed_event_attributes: typing.Optional[
            global___ChildWorkflowExecutionFailedEventAttributes
        ] = ...,
        child_workflow_execution_canceled_event_attributes: typing.Optional[
            global___ChildWorkflowExecutionCanceledEventAttributes
        ] = ...,
        child_workflow_execution_timed_out_event_attributes: typing.Optional[
            global___ChildWorkflowExecutionTimedOutEventAttributes
        ] = ...,
        child_workflow_execution_terminated_event_attributes: typing.Optional[
            global___ChildWorkflowExecutionTerminatedEventAttributes
        ] = ...,
        signal_external_workflow_execution_initiated_event_attributes: typing.Optional[
            global___SignalExternalWorkflowExecutionInitiatedEventAttributes
        ] = ...,
        signal_external_workflow_execution_failed_event_attributes: typing.Optional[
            global___SignalExternalWorkflowExecutionFailedEventAttributes
        ] = ...,
        external_workflow_execution_signaled_event_attributes: typing.Optional[
            global___ExternalWorkflowExecutionSignaledEventAttributes
        ] = ...,
        upsert_workflow_search_attributes_event_attributes: typing.Optional[
            global___UpsertWorkflowSearchAttributesEventAttributes
        ] = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "activity_task_cancel_requested_event_attributes",
            b"activity_task_cancel_requested_event_attributes",
            "activity_task_canceled_event_attributes",
            b"activity_task_canceled_event_attributes",
            "activity_task_completed_event_attributes",
            b"activity_task_completed_event_attributes",
            "activity_task_failed_event_attributes",
            b"activity_task_failed_event_attributes",
            "activity_task_scheduled_event_attributes",
            b"activity_task_scheduled_event_attributes",
            "activity_task_started_event_attributes",
            b"activity_task_started_event_attributes",
            "activity_task_timed_out_event_attributes",
            b"activity_task_timed_out_event_attributes",
            "attributes",
            b"attributes",
            "child_workflow_execution_canceled_event_attributes",
            b"child_workflow_execution_canceled_event_attributes",
            "child_workflow_execution_completed_event_attributes",
            b"child_workflow_execution_completed_event_attributes",
            "child_workflow_execution_failed_event_attributes",
            b"child_workflow_execution_failed_event_attributes",
            "child_workflow_execution_started_event_attributes",
            b"child_workflow_execution_started_event_attributes",
            "child_workflow_execution_terminated_event_attributes",
            b"child_workflow_execution_terminated_event_attributes",
            "child_workflow_execution_timed_out_event_attributes",
            b"child_workflow_execution_timed_out_event_attributes",
            "event_time",
            b"event_time",
            "external_workflow_execution_cancel_requested_event_attributes",
            b"external_workflow_execution_cancel_requested_event_attributes",
            "external_workflow_execution_signaled_event_attributes",
            b"external_workflow_execution_signaled_event_attributes",
            "marker_recorded_event_attributes",
            b"marker_recorded_event_attributes",
            "request_cancel_external_workflow_execution_failed_event_attributes",
            b"request_cancel_external_workflow_execution_failed_event_attributes",
            "request_cancel_external_workflow_execution_initiated_event_attributes",
            b"request_cancel_external_workflow_execution_initiated_event_attributes",
            "signal_external_workflow_execution_failed_event_attributes",
            b"signal_external_workflow_execution_failed_event_attributes",
            "signal_external_workflow_execution_initiated_event_attributes",
            b"signal_external_workflow_execution_initiated_event_attributes",
            "start_child_workflow_execution_failed_event_attributes",
            b"start_child_workflow_execution_failed_event_attributes",
            "start_child_workflow_execution_initiated_event_attributes",
            b"start_child_workflow_execution_initiated_event_attributes",
            "timer_canceled_event_attributes",
            b"timer_canceled_event_attributes",
            "timer_fired_event_attributes",
            b"timer_fired_event_attributes",
            "timer_started_event_attributes",
            b"timer_started_event_attributes",
            "upsert_workflow_search_attributes_event_attributes",
            b"upsert_workflow_search_attributes_event_attributes",
            "workflow_execution_cancel_requested_event_attributes",
            b"workflow_execution_cancel_requested_event_attributes",
            "workflow_execution_canceled_event_attributes",
            b"workflow_execution_canceled_event_attributes",
            "workflow_execution_completed_event_attributes",
            b"workflow_execution_completed_event_attributes",
            "workflow_execution_continued_as_new_event_attributes",
            b"workflow_execution_continued_as_new_event_attributes",
            "workflow_execution_failed_event_attributes",
            b"workflow_execution_failed_event_attributes",
            "workflow_execution_signaled_event_attributes",
            b"workflow_execution_signaled_event_attributes",
            "workflow_execution_started_event_attributes",
            b"workflow_execution_started_event_attributes",
            "workflow_execution_terminated_event_attributes",
            b"workflow_execution_terminated_event_attributes",
            "workflow_execution_timed_out_event_attributes",
            b"workflow_execution_timed_out_event_attributes",
            "workflow_task_completed_event_attributes",
            b"workflow_task_completed_event_attributes",
            "workflow_task_failed_event_attributes",
            b"workflow_task_failed_event_attributes",
            "workflow_task_scheduled_event_attributes",
            b"workflow_task_scheduled_event_attributes",
            "workflow_task_started_event_attributes",
            b"workflow_task_started_event_attributes",
            "workflow_task_timed_out_event_attributes",
            b"workflow_task_timed_out_event_attributes",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "activity_task_cancel_requested_event_attributes",
            b"activity_task_cancel_requested_event_attributes",
            "activity_task_canceled_event_attributes",
            b"activity_task_canceled_event_attributes",
            "activity_task_completed_event_attributes",
            b"activity_task_completed_event_attributes",
            "activity_task_failed_event_attributes",
            b"activity_task_failed_event_attributes",
            "activity_task_scheduled_event_attributes",
            b"activity_task_scheduled_event_attributes",
            "activity_task_started_event_attributes",
            b"activity_task_started_event_attributes",
            "activity_task_timed_out_event_attributes",
            b"activity_task_timed_out_event_attributes",
            "attributes",
            b"attributes",
            "child_workflow_execution_canceled_event_attributes",
            b"child_workflow_execution_canceled_event_attributes",
            "child_workflow_execution_completed_event_attributes",
            b"child_workflow_execution_completed_event_attributes",
            "child_workflow_execution_failed_event_attributes",
            b"child_workflow_execution_failed_event_attributes",
            "child_workflow_execution_started_event_attributes",
            b"child_workflow_execution_started_event_attributes",
            "child_workflow_execution_terminated_event_attributes",
            b"child_workflow_execution_terminated_event_attributes",
            "child_workflow_execution_timed_out_event_attributes",
            b"child_workflow_execution_timed_out_event_attributes",
            "event_id",
            b"event_id",
            "event_time",
            b"event_time",
            "event_type",
            b"event_type",
            "external_workflow_execution_cancel_requested_event_attributes",
            b"external_workflow_execution_cancel_requested_event_attributes",
            "external_workflow_execution_signaled_event_attributes",
            b"external_workflow_execution_signaled_event_attributes",
            "marker_recorded_event_attributes",
            b"marker_recorded_event_attributes",
            "request_cancel_external_workflow_execution_failed_event_attributes",
            b"request_cancel_external_workflow_execution_failed_event_attributes",
            "request_cancel_external_workflow_execution_initiated_event_attributes",
            b"request_cancel_external_workflow_execution_initiated_event_attributes",
            "signal_external_workflow_execution_failed_event_attributes",
            b"signal_external_workflow_execution_failed_event_attributes",
            "signal_external_workflow_execution_initiated_event_attributes",
            b"signal_external_workflow_execution_initiated_event_attributes",
            "start_child_workflow_execution_failed_event_attributes",
            b"start_child_workflow_execution_failed_event_attributes",
            "start_child_workflow_execution_initiated_event_attributes",
            b"start_child_workflow_execution_initiated_event_attributes",
            "task_id",
            b"task_id",
            "timer_canceled_event_attributes",
            b"timer_canceled_event_attributes",
            "timer_fired_event_attributes",
            b"timer_fired_event_attributes",
            "timer_started_event_attributes",
            b"timer_started_event_attributes",
            "upsert_workflow_search_attributes_event_attributes",
            b"upsert_workflow_search_attributes_event_attributes",
            "version",
            b"version",
            "workflow_execution_cancel_requested_event_attributes",
            b"workflow_execution_cancel_requested_event_attributes",
            "workflow_execution_canceled_event_attributes",
            b"workflow_execution_canceled_event_attributes",
            "workflow_execution_completed_event_attributes",
            b"workflow_execution_completed_event_attributes",
            "workflow_execution_continued_as_new_event_attributes",
            b"workflow_execution_continued_as_new_event_attributes",
            "workflow_execution_failed_event_attributes",
            b"workflow_execution_failed_event_attributes",
            "workflow_execution_signaled_event_attributes",
            b"workflow_execution_signaled_event_attributes",
            "workflow_execution_started_event_attributes",
            b"workflow_execution_started_event_attributes",
            "workflow_execution_terminated_event_attributes",
            b"workflow_execution_terminated_event_attributes",
            "workflow_execution_timed_out_event_attributes",
            b"workflow_execution_timed_out_event_attributes",
            "workflow_task_completed_event_attributes",
            b"workflow_task_completed_event_attributes",
            "workflow_task_failed_event_attributes",
            b"workflow_task_failed_event_attributes",
            "workflow_task_scheduled_event_attributes",
            b"workflow_task_scheduled_event_attributes",
            "workflow_task_started_event_attributes",
            b"workflow_task_started_event_attributes",
            "workflow_task_timed_out_event_attributes",
            b"workflow_task_timed_out_event_attributes",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["attributes", b"attributes"]
    ) -> typing.Optional[
        typing_extensions.Literal[
            "workflow_execution_started_event_attributes",
            "workflow_execution_completed_event_attributes",
            "workflow_execution_failed_event_attributes",
            "workflow_execution_timed_out_event_attributes",
            "workflow_task_scheduled_event_attributes",
            "workflow_task_started_event_attributes",
            "workflow_task_completed_event_attributes",
            "workflow_task_timed_out_event_attributes",
            "workflow_task_failed_event_attributes",
            "activity_task_scheduled_event_attributes",
            "activity_task_started_event_attributes",
            "activity_task_completed_event_attributes",
            "activity_task_failed_event_attributes",
            "activity_task_timed_out_event_attributes",
            "timer_started_event_attributes",
            "timer_fired_event_attributes",
            "activity_task_cancel_requested_event_attributes",
            "activity_task_canceled_event_attributes",
            "timer_canceled_event_attributes",
            "marker_recorded_event_attributes",
            "workflow_execution_signaled_event_attributes",
            "workflow_execution_terminated_event_attributes",
            "workflow_execution_cancel_requested_event_attributes",
            "workflow_execution_canceled_event_attributes",
            "request_cancel_external_workflow_execution_initiated_event_attributes",
            "request_cancel_external_workflow_execution_failed_event_attributes",
            "external_workflow_execution_cancel_requested_event_attributes",
            "workflow_execution_continued_as_new_event_attributes",
            "start_child_workflow_execution_initiated_event_attributes",
            "start_child_workflow_execution_failed_event_attributes",
            "child_workflow_execution_started_event_attributes",
            "child_workflow_execution_completed_event_attributes",
            "child_workflow_execution_failed_event_attributes",
            "child_workflow_execution_canceled_event_attributes",
            "child_workflow_execution_timed_out_event_attributes",
            "child_workflow_execution_terminated_event_attributes",
            "signal_external_workflow_execution_initiated_event_attributes",
            "signal_external_workflow_execution_failed_event_attributes",
            "external_workflow_execution_signaled_event_attributes",
            "upsert_workflow_search_attributes_event_attributes",
        ]
    ]: ...

global___HistoryEvent = HistoryEvent

class History(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    EVENTS_FIELD_NUMBER: builtins.int
    @property
    def events(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___HistoryEvent
    ]: ...
    def __init__(
        self,
        *,
        events: typing.Optional[typing.Iterable[global___HistoryEvent]] = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["events", b"events"]
    ) -> None: ...

global___History = History
