"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import temporalio.api.common.v1.message_pb2
import temporalio.api.enums.v1.command_type_pb2
import temporalio.api.enums.v1.workflow_pb2
import temporalio.api.failure.v1.message_pb2
import temporalio.api.taskqueue.v1.message_pb2
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class ScheduleActivityTaskCommandAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ACTIVITY_ID_FIELD_NUMBER: builtins.int
    ACTIVITY_TYPE_FIELD_NUMBER: builtins.int
    NAMESPACE_FIELD_NUMBER: builtins.int
    TASK_QUEUE_FIELD_NUMBER: builtins.int
    HEADER_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    SCHEDULE_TO_CLOSE_TIMEOUT_FIELD_NUMBER: builtins.int
    SCHEDULE_TO_START_TIMEOUT_FIELD_NUMBER: builtins.int
    START_TO_CLOSE_TIMEOUT_FIELD_NUMBER: builtins.int
    HEARTBEAT_TIMEOUT_FIELD_NUMBER: builtins.int
    RETRY_POLICY_FIELD_NUMBER: builtins.int
    REQUEST_EAGER_EXECUTION_FIELD_NUMBER: builtins.int
    activity_id: typing.Text
    @property
    def activity_type(self) -> temporalio.api.common.v1.message_pb2.ActivityType: ...
    namespace: typing.Text
    @property
    def task_queue(self) -> temporalio.api.taskqueue.v1.message_pb2.TaskQueue: ...
    @property
    def header(self) -> temporalio.api.common.v1.message_pb2.Header: ...
    @property
    def input(self) -> temporalio.api.common.v1.message_pb2.Payloads: ...
    @property
    def schedule_to_close_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Indicates how long the caller is willing to wait for activity completion. The "schedule" time
        is when the activity is initially scheduled, not when the most recent retry is scheduled.
        Limits how long retries will be attempted. Either this or `start_to_close_timeout` must be
        specified. When not specified, defaults to the workflow execution timeout.

        (-- api-linter: core::0140::prepositions=disabled
            aip.dev/not-precedent: "to" is used to indicate interval. --)
        """
        pass
    @property
    def schedule_to_start_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Limits the time an activity task can stay in a task queue before a worker picks it up. The
        "schedule" time is when the most recent retry is scheduled. This timeout should usually not
        be set: it's useful in specific scenarios like worker-specific task queues. This timeout is
        always non retryable, as all a retry would achieve is to put it back into the same queue.
        Defaults to `schedule_to_close_timeout` or workflow execution timeout if that is not
        specified. More info:
        https://docs.temporal.io/docs/content/what-is-a-schedule-to-start-timeout/

        (-- api-linter: core::0140::prepositions=disabled
            aip.dev/not-precedent: "to" is used to indicate interval. --)
        """
        pass
    @property
    def start_to_close_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Maximum time an activity is allowed to execute after being picked up by a worker. This
        timeout is always retryable. Either this or `schedule_to_close_timeout` must be specified.

        (-- api-linter: core::0140::prepositions=disabled
            aip.dev/not-precedent: "to" is used to indicate interval. --)
        """
        pass
    @property
    def heartbeat_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Maximum permitted time between successful worker heartbeats."""
        pass
    @property
    def retry_policy(self) -> temporalio.api.common.v1.message_pb2.RetryPolicy:
        """Activities are provided by a default retry policy which is controlled through the service's
        dynamic configuration. Retries will be attempted until `schedule_to_close_timeout` has
        elapsed. To disable retries set retry_policy.maximum_attempts to 1.
        """
        pass
    request_eager_execution: builtins.bool
    """Request to start the activity directly bypassing matching service and worker polling
    The slot for executing the activity should be reserved when setting this field to true.
    """

    def __init__(
        self,
        *,
        activity_id: typing.Text = ...,
        activity_type: typing.Optional[
            temporalio.api.common.v1.message_pb2.ActivityType
        ] = ...,
        namespace: typing.Text = ...,
        task_queue: typing.Optional[
            temporalio.api.taskqueue.v1.message_pb2.TaskQueue
        ] = ...,
        header: typing.Optional[temporalio.api.common.v1.message_pb2.Header] = ...,
        input: typing.Optional[temporalio.api.common.v1.message_pb2.Payloads] = ...,
        schedule_to_close_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        schedule_to_start_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        start_to_close_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        heartbeat_timeout: typing.Optional[google.protobuf.duration_pb2.Duration] = ...,
        retry_policy: typing.Optional[
            temporalio.api.common.v1.message_pb2.RetryPolicy
        ] = ...,
        request_eager_execution: builtins.bool = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "activity_type",
            b"activity_type",
            "header",
            b"header",
            "heartbeat_timeout",
            b"heartbeat_timeout",
            "input",
            b"input",
            "retry_policy",
            b"retry_policy",
            "schedule_to_close_timeout",
            b"schedule_to_close_timeout",
            "schedule_to_start_timeout",
            b"schedule_to_start_timeout",
            "start_to_close_timeout",
            b"start_to_close_timeout",
            "task_queue",
            b"task_queue",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "activity_id",
            b"activity_id",
            "activity_type",
            b"activity_type",
            "header",
            b"header",
            "heartbeat_timeout",
            b"heartbeat_timeout",
            "input",
            b"input",
            "namespace",
            b"namespace",
            "request_eager_execution",
            b"request_eager_execution",
            "retry_policy",
            b"retry_policy",
            "schedule_to_close_timeout",
            b"schedule_to_close_timeout",
            "schedule_to_start_timeout",
            b"schedule_to_start_timeout",
            "start_to_close_timeout",
            b"start_to_close_timeout",
            "task_queue",
            b"task_queue",
        ],
    ) -> None: ...

global___ScheduleActivityTaskCommandAttributes = ScheduleActivityTaskCommandAttributes

class RequestCancelActivityTaskCommandAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SCHEDULED_EVENT_ID_FIELD_NUMBER: builtins.int
    scheduled_event_id: builtins.int
    """The `ACTIVITY_TASK_SCHEDULED` event id for the activity being cancelled."""

    def __init__(
        self,
        *,
        scheduled_event_id: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "scheduled_event_id", b"scheduled_event_id"
        ],
    ) -> None: ...

global___RequestCancelActivityTaskCommandAttributes = (
    RequestCancelActivityTaskCommandAttributes
)

class StartTimerCommandAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TIMER_ID_FIELD_NUMBER: builtins.int
    START_TO_FIRE_TIMEOUT_FIELD_NUMBER: builtins.int
    timer_id: typing.Text
    """An id for the timer, currently live timers must have different ids. Typically autogenerated
    by the SDK.
    """

    @property
    def start_to_fire_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """How long until the timer fires, producing a `TIMER_FIRED` event.

        (-- api-linter: core::0140::prepositions=disabled
            aip.dev/not-precedent: "to" is used to indicate interval. --)
        """
        pass
    def __init__(
        self,
        *,
        timer_id: typing.Text = ...,
        start_to_fire_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "start_to_fire_timeout", b"start_to_fire_timeout"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "start_to_fire_timeout", b"start_to_fire_timeout", "timer_id", b"timer_id"
        ],
    ) -> None: ...

global___StartTimerCommandAttributes = StartTimerCommandAttributes

class CompleteWorkflowExecutionCommandAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    RESULT_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> temporalio.api.common.v1.message_pb2.Payloads: ...
    def __init__(
        self,
        *,
        result: typing.Optional[temporalio.api.common.v1.message_pb2.Payloads] = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["result", b"result"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["result", b"result"]
    ) -> None: ...

global___CompleteWorkflowExecutionCommandAttributes = (
    CompleteWorkflowExecutionCommandAttributes
)

class FailWorkflowExecutionCommandAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    FAILURE_FIELD_NUMBER: builtins.int
    @property
    def failure(self) -> temporalio.api.failure.v1.message_pb2.Failure: ...
    def __init__(
        self,
        *,
        failure: typing.Optional[temporalio.api.failure.v1.message_pb2.Failure] = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["failure", b"failure"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["failure", b"failure"]
    ) -> None: ...

global___FailWorkflowExecutionCommandAttributes = FailWorkflowExecutionCommandAttributes

class CancelTimerCommandAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TIMER_ID_FIELD_NUMBER: builtins.int
    timer_id: typing.Text
    """The same timer id from the start timer command"""

    def __init__(
        self,
        *,
        timer_id: typing.Text = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["timer_id", b"timer_id"]
    ) -> None: ...

global___CancelTimerCommandAttributes = CancelTimerCommandAttributes

class CancelWorkflowExecutionCommandAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    DETAILS_FIELD_NUMBER: builtins.int
    @property
    def details(self) -> temporalio.api.common.v1.message_pb2.Payloads: ...
    def __init__(
        self,
        *,
        details: typing.Optional[temporalio.api.common.v1.message_pb2.Payloads] = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["details", b"details"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["details", b"details"]
    ) -> None: ...

global___CancelWorkflowExecutionCommandAttributes = (
    CancelWorkflowExecutionCommandAttributes
)

class RequestCancelExternalWorkflowExecutionCommandAttributes(
    google.protobuf.message.Message
):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    NAMESPACE_FIELD_NUMBER: builtins.int
    WORKFLOW_ID_FIELD_NUMBER: builtins.int
    RUN_ID_FIELD_NUMBER: builtins.int
    CONTROL_FIELD_NUMBER: builtins.int
    CHILD_WORKFLOW_ONLY_FIELD_NUMBER: builtins.int
    REASON_FIELD_NUMBER: builtins.int
    namespace: typing.Text
    workflow_id: typing.Text
    run_id: typing.Text
    control: typing.Text
    """Deprecated."""

    child_workflow_only: builtins.bool
    """Set this to true if the workflow being cancelled is a child of the workflow originating this
    command. The request will be rejected if it is set to true and the target workflow is *not*
    a child of the requesting workflow.
    """

    reason: typing.Text
    """Reason for requesting the cancellation"""

    def __init__(
        self,
        *,
        namespace: typing.Text = ...,
        workflow_id: typing.Text = ...,
        run_id: typing.Text = ...,
        control: typing.Text = ...,
        child_workflow_only: builtins.bool = ...,
        reason: typing.Text = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "child_workflow_only",
            b"child_workflow_only",
            "control",
            b"control",
            "namespace",
            b"namespace",
            "reason",
            b"reason",
            "run_id",
            b"run_id",
            "workflow_id",
            b"workflow_id",
        ],
    ) -> None: ...

global___RequestCancelExternalWorkflowExecutionCommandAttributes = (
    RequestCancelExternalWorkflowExecutionCommandAttributes
)

class SignalExternalWorkflowExecutionCommandAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    NAMESPACE_FIELD_NUMBER: builtins.int
    EXECUTION_FIELD_NUMBER: builtins.int
    SIGNAL_NAME_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    CONTROL_FIELD_NUMBER: builtins.int
    CHILD_WORKFLOW_ONLY_FIELD_NUMBER: builtins.int
    HEADER_FIELD_NUMBER: builtins.int
    namespace: typing.Text
    @property
    def execution(self) -> temporalio.api.common.v1.message_pb2.WorkflowExecution: ...
    signal_name: typing.Text
    """The workflow author-defined name of the signal to send to the workflow."""

    @property
    def input(self) -> temporalio.api.common.v1.message_pb2.Payloads:
        """Serialized value(s) to provide with the signal."""
        pass
    control: typing.Text
    """Deprecated"""

    child_workflow_only: builtins.bool
    """Set this to true if the workflow being cancelled is a child of the workflow originating this
    command. The request will be rejected if it is set to true and the target workflow is *not*
    a child of the requesting workflow.
    """

    @property
    def header(self) -> temporalio.api.common.v1.message_pb2.Header:
        """Headers that are passed by the workflow that is sending a signal to the external
        workflow that is receiving this signal.
        """
        pass
    def __init__(
        self,
        *,
        namespace: typing.Text = ...,
        execution: typing.Optional[
            temporalio.api.common.v1.message_pb2.WorkflowExecution
        ] = ...,
        signal_name: typing.Text = ...,
        input: typing.Optional[temporalio.api.common.v1.message_pb2.Payloads] = ...,
        control: typing.Text = ...,
        child_workflow_only: builtins.bool = ...,
        header: typing.Optional[temporalio.api.common.v1.message_pb2.Header] = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "execution", b"execution", "header", b"header", "input", b"input"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "child_workflow_only",
            b"child_workflow_only",
            "control",
            b"control",
            "execution",
            b"execution",
            "header",
            b"header",
            "input",
            b"input",
            "namespace",
            b"namespace",
            "signal_name",
            b"signal_name",
        ],
    ) -> None: ...

global___SignalExternalWorkflowExecutionCommandAttributes = (
    SignalExternalWorkflowExecutionCommandAttributes
)

class UpsertWorkflowSearchAttributesCommandAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SEARCH_ATTRIBUTES_FIELD_NUMBER: builtins.int
    @property
    def search_attributes(
        self,
    ) -> temporalio.api.common.v1.message_pb2.SearchAttributes: ...
    def __init__(
        self,
        *,
        search_attributes: typing.Optional[
            temporalio.api.common.v1.message_pb2.SearchAttributes
        ] = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "search_attributes", b"search_attributes"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "search_attributes", b"search_attributes"
        ],
    ) -> None: ...

global___UpsertWorkflowSearchAttributesCommandAttributes = (
    UpsertWorkflowSearchAttributesCommandAttributes
)

class RecordMarkerCommandAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class DetailsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> temporalio.api.common.v1.message_pb2.Payloads: ...
        def __init__(
            self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[temporalio.api.common.v1.message_pb2.Payloads] = ...,
        ) -> None: ...
        def HasField(
            self, field_name: typing_extensions.Literal["value", b"value"]
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal["key", b"key", "value", b"value"],
        ) -> None: ...

    MARKER_NAME_FIELD_NUMBER: builtins.int
    DETAILS_FIELD_NUMBER: builtins.int
    HEADER_FIELD_NUMBER: builtins.int
    FAILURE_FIELD_NUMBER: builtins.int
    marker_name: typing.Text
    @property
    def details(
        self,
    ) -> google.protobuf.internal.containers.MessageMap[
        typing.Text, temporalio.api.common.v1.message_pb2.Payloads
    ]: ...
    @property
    def header(self) -> temporalio.api.common.v1.message_pb2.Header: ...
    @property
    def failure(self) -> temporalio.api.failure.v1.message_pb2.Failure: ...
    def __init__(
        self,
        *,
        marker_name: typing.Text = ...,
        details: typing.Optional[
            typing.Mapping[typing.Text, temporalio.api.common.v1.message_pb2.Payloads]
        ] = ...,
        header: typing.Optional[temporalio.api.common.v1.message_pb2.Header] = ...,
        failure: typing.Optional[temporalio.api.failure.v1.message_pb2.Failure] = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "failure", b"failure", "header", b"header"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "details",
            b"details",
            "failure",
            b"failure",
            "header",
            b"header",
            "marker_name",
            b"marker_name",
        ],
    ) -> None: ...

global___RecordMarkerCommandAttributes = RecordMarkerCommandAttributes

class ContinueAsNewWorkflowExecutionCommandAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    WORKFLOW_TYPE_FIELD_NUMBER: builtins.int
    TASK_QUEUE_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    WORKFLOW_RUN_TIMEOUT_FIELD_NUMBER: builtins.int
    WORKFLOW_TASK_TIMEOUT_FIELD_NUMBER: builtins.int
    BACKOFF_START_INTERVAL_FIELD_NUMBER: builtins.int
    RETRY_POLICY_FIELD_NUMBER: builtins.int
    INITIATOR_FIELD_NUMBER: builtins.int
    FAILURE_FIELD_NUMBER: builtins.int
    LAST_COMPLETION_RESULT_FIELD_NUMBER: builtins.int
    CRON_SCHEDULE_FIELD_NUMBER: builtins.int
    HEADER_FIELD_NUMBER: builtins.int
    MEMO_FIELD_NUMBER: builtins.int
    SEARCH_ATTRIBUTES_FIELD_NUMBER: builtins.int
    @property
    def workflow_type(self) -> temporalio.api.common.v1.message_pb2.WorkflowType: ...
    @property
    def task_queue(self) -> temporalio.api.taskqueue.v1.message_pb2.TaskQueue: ...
    @property
    def input(self) -> temporalio.api.common.v1.message_pb2.Payloads: ...
    @property
    def workflow_run_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Timeout of a single workflow run."""
        pass
    @property
    def workflow_task_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Timeout of a single workflow task."""
        pass
    @property
    def backoff_start_interval(self) -> google.protobuf.duration_pb2.Duration:
        """How long the workflow start will be delayed - not really a "backoff" in the traditional sense."""
        pass
    @property
    def retry_policy(self) -> temporalio.api.common.v1.message_pb2.RetryPolicy: ...
    initiator: temporalio.api.enums.v1.workflow_pb2.ContinueAsNewInitiator.ValueType
    """Should be removed"""

    @property
    def failure(self) -> temporalio.api.failure.v1.message_pb2.Failure:
        """Should be removed"""
        pass
    @property
    def last_completion_result(self) -> temporalio.api.common.v1.message_pb2.Payloads:
        """Should be removed"""
        pass
    cron_schedule: typing.Text
    """Should be removed. Not necessarily unused but unclear and not exposed by SDKs."""

    @property
    def header(self) -> temporalio.api.common.v1.message_pb2.Header: ...
    @property
    def memo(self) -> temporalio.api.common.v1.message_pb2.Memo: ...
    @property
    def search_attributes(
        self,
    ) -> temporalio.api.common.v1.message_pb2.SearchAttributes: ...
    def __init__(
        self,
        *,
        workflow_type: typing.Optional[
            temporalio.api.common.v1.message_pb2.WorkflowType
        ] = ...,
        task_queue: typing.Optional[
            temporalio.api.taskqueue.v1.message_pb2.TaskQueue
        ] = ...,
        input: typing.Optional[temporalio.api.common.v1.message_pb2.Payloads] = ...,
        workflow_run_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        workflow_task_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        backoff_start_interval: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        retry_policy: typing.Optional[
            temporalio.api.common.v1.message_pb2.RetryPolicy
        ] = ...,
        initiator: temporalio.api.enums.v1.workflow_pb2.ContinueAsNewInitiator.ValueType = ...,
        failure: typing.Optional[temporalio.api.failure.v1.message_pb2.Failure] = ...,
        last_completion_result: typing.Optional[
            temporalio.api.common.v1.message_pb2.Payloads
        ] = ...,
        cron_schedule: typing.Text = ...,
        header: typing.Optional[temporalio.api.common.v1.message_pb2.Header] = ...,
        memo: typing.Optional[temporalio.api.common.v1.message_pb2.Memo] = ...,
        search_attributes: typing.Optional[
            temporalio.api.common.v1.message_pb2.SearchAttributes
        ] = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "backoff_start_interval",
            b"backoff_start_interval",
            "failure",
            b"failure",
            "header",
            b"header",
            "input",
            b"input",
            "last_completion_result",
            b"last_completion_result",
            "memo",
            b"memo",
            "retry_policy",
            b"retry_policy",
            "search_attributes",
            b"search_attributes",
            "task_queue",
            b"task_queue",
            "workflow_run_timeout",
            b"workflow_run_timeout",
            "workflow_task_timeout",
            b"workflow_task_timeout",
            "workflow_type",
            b"workflow_type",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "backoff_start_interval",
            b"backoff_start_interval",
            "cron_schedule",
            b"cron_schedule",
            "failure",
            b"failure",
            "header",
            b"header",
            "initiator",
            b"initiator",
            "input",
            b"input",
            "last_completion_result",
            b"last_completion_result",
            "memo",
            b"memo",
            "retry_policy",
            b"retry_policy",
            "search_attributes",
            b"search_attributes",
            "task_queue",
            b"task_queue",
            "workflow_run_timeout",
            b"workflow_run_timeout",
            "workflow_task_timeout",
            b"workflow_task_timeout",
            "workflow_type",
            b"workflow_type",
        ],
    ) -> None: ...

global___ContinueAsNewWorkflowExecutionCommandAttributes = (
    ContinueAsNewWorkflowExecutionCommandAttributes
)

class StartChildWorkflowExecutionCommandAttributes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    NAMESPACE_FIELD_NUMBER: builtins.int
    WORKFLOW_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_TYPE_FIELD_NUMBER: builtins.int
    TASK_QUEUE_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    WORKFLOW_EXECUTION_TIMEOUT_FIELD_NUMBER: builtins.int
    WORKFLOW_RUN_TIMEOUT_FIELD_NUMBER: builtins.int
    WORKFLOW_TASK_TIMEOUT_FIELD_NUMBER: builtins.int
    PARENT_CLOSE_POLICY_FIELD_NUMBER: builtins.int
    CONTROL_FIELD_NUMBER: builtins.int
    WORKFLOW_ID_REUSE_POLICY_FIELD_NUMBER: builtins.int
    RETRY_POLICY_FIELD_NUMBER: builtins.int
    CRON_SCHEDULE_FIELD_NUMBER: builtins.int
    HEADER_FIELD_NUMBER: builtins.int
    MEMO_FIELD_NUMBER: builtins.int
    SEARCH_ATTRIBUTES_FIELD_NUMBER: builtins.int
    namespace: typing.Text
    workflow_id: typing.Text
    @property
    def workflow_type(self) -> temporalio.api.common.v1.message_pb2.WorkflowType: ...
    @property
    def task_queue(self) -> temporalio.api.taskqueue.v1.message_pb2.TaskQueue: ...
    @property
    def input(self) -> temporalio.api.common.v1.message_pb2.Payloads: ...
    @property
    def workflow_execution_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Total workflow execution timeout including retries and continue as new."""
        pass
    @property
    def workflow_run_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Timeout of a single workflow run."""
        pass
    @property
    def workflow_task_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Timeout of a single workflow task."""
        pass
    parent_close_policy: temporalio.api.enums.v1.workflow_pb2.ParentClosePolicy.ValueType
    """Default: PARENT_CLOSE_POLICY_TERMINATE."""

    control: typing.Text
    workflow_id_reuse_policy: temporalio.api.enums.v1.workflow_pb2.WorkflowIdReusePolicy.ValueType
    """Default: WORKFLOW_ID_REUSE_POLICY_ALLOW_DUPLICATE."""

    @property
    def retry_policy(self) -> temporalio.api.common.v1.message_pb2.RetryPolicy: ...
    cron_schedule: typing.Text
    """Establish a cron schedule for the child workflow."""

    @property
    def header(self) -> temporalio.api.common.v1.message_pb2.Header: ...
    @property
    def memo(self) -> temporalio.api.common.v1.message_pb2.Memo: ...
    @property
    def search_attributes(
        self,
    ) -> temporalio.api.common.v1.message_pb2.SearchAttributes: ...
    def __init__(
        self,
        *,
        namespace: typing.Text = ...,
        workflow_id: typing.Text = ...,
        workflow_type: typing.Optional[
            temporalio.api.common.v1.message_pb2.WorkflowType
        ] = ...,
        task_queue: typing.Optional[
            temporalio.api.taskqueue.v1.message_pb2.TaskQueue
        ] = ...,
        input: typing.Optional[temporalio.api.common.v1.message_pb2.Payloads] = ...,
        workflow_execution_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        workflow_run_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        workflow_task_timeout: typing.Optional[
            google.protobuf.duration_pb2.Duration
        ] = ...,
        parent_close_policy: temporalio.api.enums.v1.workflow_pb2.ParentClosePolicy.ValueType = ...,
        control: typing.Text = ...,
        workflow_id_reuse_policy: temporalio.api.enums.v1.workflow_pb2.WorkflowIdReusePolicy.ValueType = ...,
        retry_policy: typing.Optional[
            temporalio.api.common.v1.message_pb2.RetryPolicy
        ] = ...,
        cron_schedule: typing.Text = ...,
        header: typing.Optional[temporalio.api.common.v1.message_pb2.Header] = ...,
        memo: typing.Optional[temporalio.api.common.v1.message_pb2.Memo] = ...,
        search_attributes: typing.Optional[
            temporalio.api.common.v1.message_pb2.SearchAttributes
        ] = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "header",
            b"header",
            "input",
            b"input",
            "memo",
            b"memo",
            "retry_policy",
            b"retry_policy",
            "search_attributes",
            b"search_attributes",
            "task_queue",
            b"task_queue",
            "workflow_execution_timeout",
            b"workflow_execution_timeout",
            "workflow_run_timeout",
            b"workflow_run_timeout",
            "workflow_task_timeout",
            b"workflow_task_timeout",
            "workflow_type",
            b"workflow_type",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "control",
            b"control",
            "cron_schedule",
            b"cron_schedule",
            "header",
            b"header",
            "input",
            b"input",
            "memo",
            b"memo",
            "namespace",
            b"namespace",
            "parent_close_policy",
            b"parent_close_policy",
            "retry_policy",
            b"retry_policy",
            "search_attributes",
            b"search_attributes",
            "task_queue",
            b"task_queue",
            "workflow_execution_timeout",
            b"workflow_execution_timeout",
            "workflow_id",
            b"workflow_id",
            "workflow_id_reuse_policy",
            b"workflow_id_reuse_policy",
            "workflow_run_timeout",
            b"workflow_run_timeout",
            "workflow_task_timeout",
            b"workflow_task_timeout",
            "workflow_type",
            b"workflow_type",
        ],
    ) -> None: ...

global___StartChildWorkflowExecutionCommandAttributes = (
    StartChildWorkflowExecutionCommandAttributes
)

class Command(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    COMMAND_TYPE_FIELD_NUMBER: builtins.int
    SCHEDULE_ACTIVITY_TASK_COMMAND_ATTRIBUTES_FIELD_NUMBER: builtins.int
    START_TIMER_COMMAND_ATTRIBUTES_FIELD_NUMBER: builtins.int
    COMPLETE_WORKFLOW_EXECUTION_COMMAND_ATTRIBUTES_FIELD_NUMBER: builtins.int
    FAIL_WORKFLOW_EXECUTION_COMMAND_ATTRIBUTES_FIELD_NUMBER: builtins.int
    REQUEST_CANCEL_ACTIVITY_TASK_COMMAND_ATTRIBUTES_FIELD_NUMBER: builtins.int
    CANCEL_TIMER_COMMAND_ATTRIBUTES_FIELD_NUMBER: builtins.int
    CANCEL_WORKFLOW_EXECUTION_COMMAND_ATTRIBUTES_FIELD_NUMBER: builtins.int
    REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_COMMAND_ATTRIBUTES_FIELD_NUMBER: builtins.int
    RECORD_MARKER_COMMAND_ATTRIBUTES_FIELD_NUMBER: builtins.int
    CONTINUE_AS_NEW_WORKFLOW_EXECUTION_COMMAND_ATTRIBUTES_FIELD_NUMBER: builtins.int
    START_CHILD_WORKFLOW_EXECUTION_COMMAND_ATTRIBUTES_FIELD_NUMBER: builtins.int
    SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_COMMAND_ATTRIBUTES_FIELD_NUMBER: builtins.int
    UPSERT_WORKFLOW_SEARCH_ATTRIBUTES_COMMAND_ATTRIBUTES_FIELD_NUMBER: builtins.int
    command_type: temporalio.api.enums.v1.command_type_pb2.CommandType.ValueType
    @property
    def schedule_activity_task_command_attributes(
        self,
    ) -> global___ScheduleActivityTaskCommandAttributes: ...
    @property
    def start_timer_command_attributes(
        self,
    ) -> global___StartTimerCommandAttributes: ...
    @property
    def complete_workflow_execution_command_attributes(
        self,
    ) -> global___CompleteWorkflowExecutionCommandAttributes: ...
    @property
    def fail_workflow_execution_command_attributes(
        self,
    ) -> global___FailWorkflowExecutionCommandAttributes: ...
    @property
    def request_cancel_activity_task_command_attributes(
        self,
    ) -> global___RequestCancelActivityTaskCommandAttributes: ...
    @property
    def cancel_timer_command_attributes(
        self,
    ) -> global___CancelTimerCommandAttributes: ...
    @property
    def cancel_workflow_execution_command_attributes(
        self,
    ) -> global___CancelWorkflowExecutionCommandAttributes: ...
    @property
    def request_cancel_external_workflow_execution_command_attributes(
        self,
    ) -> global___RequestCancelExternalWorkflowExecutionCommandAttributes: ...
    @property
    def record_marker_command_attributes(
        self,
    ) -> global___RecordMarkerCommandAttributes: ...
    @property
    def continue_as_new_workflow_execution_command_attributes(
        self,
    ) -> global___ContinueAsNewWorkflowExecutionCommandAttributes: ...
    @property
    def start_child_workflow_execution_command_attributes(
        self,
    ) -> global___StartChildWorkflowExecutionCommandAttributes: ...
    @property
    def signal_external_workflow_execution_command_attributes(
        self,
    ) -> global___SignalExternalWorkflowExecutionCommandAttributes: ...
    @property
    def upsert_workflow_search_attributes_command_attributes(
        self,
    ) -> global___UpsertWorkflowSearchAttributesCommandAttributes: ...
    def __init__(
        self,
        *,
        command_type: temporalio.api.enums.v1.command_type_pb2.CommandType.ValueType = ...,
        schedule_activity_task_command_attributes: typing.Optional[
            global___ScheduleActivityTaskCommandAttributes
        ] = ...,
        start_timer_command_attributes: typing.Optional[
            global___StartTimerCommandAttributes
        ] = ...,
        complete_workflow_execution_command_attributes: typing.Optional[
            global___CompleteWorkflowExecutionCommandAttributes
        ] = ...,
        fail_workflow_execution_command_attributes: typing.Optional[
            global___FailWorkflowExecutionCommandAttributes
        ] = ...,
        request_cancel_activity_task_command_attributes: typing.Optional[
            global___RequestCancelActivityTaskCommandAttributes
        ] = ...,
        cancel_timer_command_attributes: typing.Optional[
            global___CancelTimerCommandAttributes
        ] = ...,
        cancel_workflow_execution_command_attributes: typing.Optional[
            global___CancelWorkflowExecutionCommandAttributes
        ] = ...,
        request_cancel_external_workflow_execution_command_attributes: typing.Optional[
            global___RequestCancelExternalWorkflowExecutionCommandAttributes
        ] = ...,
        record_marker_command_attributes: typing.Optional[
            global___RecordMarkerCommandAttributes
        ] = ...,
        continue_as_new_workflow_execution_command_attributes: typing.Optional[
            global___ContinueAsNewWorkflowExecutionCommandAttributes
        ] = ...,
        start_child_workflow_execution_command_attributes: typing.Optional[
            global___StartChildWorkflowExecutionCommandAttributes
        ] = ...,
        signal_external_workflow_execution_command_attributes: typing.Optional[
            global___SignalExternalWorkflowExecutionCommandAttributes
        ] = ...,
        upsert_workflow_search_attributes_command_attributes: typing.Optional[
            global___UpsertWorkflowSearchAttributesCommandAttributes
        ] = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "attributes",
            b"attributes",
            "cancel_timer_command_attributes",
            b"cancel_timer_command_attributes",
            "cancel_workflow_execution_command_attributes",
            b"cancel_workflow_execution_command_attributes",
            "complete_workflow_execution_command_attributes",
            b"complete_workflow_execution_command_attributes",
            "continue_as_new_workflow_execution_command_attributes",
            b"continue_as_new_workflow_execution_command_attributes",
            "fail_workflow_execution_command_attributes",
            b"fail_workflow_execution_command_attributes",
            "record_marker_command_attributes",
            b"record_marker_command_attributes",
            "request_cancel_activity_task_command_attributes",
            b"request_cancel_activity_task_command_attributes",
            "request_cancel_external_workflow_execution_command_attributes",
            b"request_cancel_external_workflow_execution_command_attributes",
            "schedule_activity_task_command_attributes",
            b"schedule_activity_task_command_attributes",
            "signal_external_workflow_execution_command_attributes",
            b"signal_external_workflow_execution_command_attributes",
            "start_child_workflow_execution_command_attributes",
            b"start_child_workflow_execution_command_attributes",
            "start_timer_command_attributes",
            b"start_timer_command_attributes",
            "upsert_workflow_search_attributes_command_attributes",
            b"upsert_workflow_search_attributes_command_attributes",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "attributes",
            b"attributes",
            "cancel_timer_command_attributes",
            b"cancel_timer_command_attributes",
            "cancel_workflow_execution_command_attributes",
            b"cancel_workflow_execution_command_attributes",
            "command_type",
            b"command_type",
            "complete_workflow_execution_command_attributes",
            b"complete_workflow_execution_command_attributes",
            "continue_as_new_workflow_execution_command_attributes",
            b"continue_as_new_workflow_execution_command_attributes",
            "fail_workflow_execution_command_attributes",
            b"fail_workflow_execution_command_attributes",
            "record_marker_command_attributes",
            b"record_marker_command_attributes",
            "request_cancel_activity_task_command_attributes",
            b"request_cancel_activity_task_command_attributes",
            "request_cancel_external_workflow_execution_command_attributes",
            b"request_cancel_external_workflow_execution_command_attributes",
            "schedule_activity_task_command_attributes",
            b"schedule_activity_task_command_attributes",
            "signal_external_workflow_execution_command_attributes",
            b"signal_external_workflow_execution_command_attributes",
            "start_child_workflow_execution_command_attributes",
            b"start_child_workflow_execution_command_attributes",
            "start_timer_command_attributes",
            b"start_timer_command_attributes",
            "upsert_workflow_search_attributes_command_attributes",
            b"upsert_workflow_search_attributes_command_attributes",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["attributes", b"attributes"]
    ) -> typing.Optional[
        typing_extensions.Literal[
            "schedule_activity_task_command_attributes",
            "start_timer_command_attributes",
            "complete_workflow_execution_command_attributes",
            "fail_workflow_execution_command_attributes",
            "request_cancel_activity_task_command_attributes",
            "cancel_timer_command_attributes",
            "cancel_workflow_execution_command_attributes",
            "request_cancel_external_workflow_execution_command_attributes",
            "record_marker_command_attributes",
            "continue_as_new_workflow_execution_command_attributes",
            "start_child_workflow_execution_command_attributes",
            "signal_external_workflow_execution_command_attributes",
            "upsert_workflow_search_attributes_command_attributes",
        ]
    ]: ...

global___Command = Command
