"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SlackNotification = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
const logs = require("@aws-cdk/aws-logs");
const aws_logs_destinations_1 = require("@aws-cdk/aws-logs-destinations");
const snsSubscriptions = require("@aws-cdk/aws-sns-subscriptions");
const core = require("@aws-cdk/core");
/**
 * @stability stable
 */
class SlackNotification extends core.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, snsTopic, slackConfig, recipename) {
        super(scope, id);
        const pipelineSlackFn = new lambda.Function(this, 'PipelineSlackFunction', {
            runtime: lambda.Runtime.PYTHON_3_8,
            handler: 'main.lambda_handler',
            code: lambda.Code.fromAsset(path.join(__dirname, '..', 'lambda', 'slack-notification')),
            environment: {
                SLACK_WEBHOOK_URL: slackConfig.slackWebhookUrl,
                SLACK_CHANNEL: slackConfig.channel,
                SLACK_USERNAME: slackConfig.username,
            },
        });
        this.snsTopic = snsTopic;
        this.snsTopic.addSubscription(new snsSubscriptions.LambdaSubscription(pipelineSlackFn));
        const fn = new lambda.Function(this, 'SubFiltSlackFunction', {
            runtime: lambda.Runtime.PYTHON_3_8,
            handler: 'main.lambda_handler',
            code: lambda.Code.fromAsset(path.join(__dirname, '..', 'lambda', 'slack-notification-sub-filter')),
            environment: {
                SLACK_WEBHOOK_URL: slackConfig.slackWebhookUrl,
                SLACK_CHANNEL: slackConfig.channel,
                SLACK_USERNAME: slackConfig.username,
                RECIPE_NAME: recipename,
            },
        });
        const logGroup = new logs.LogGroup(this, `${recipename}LogGroup`, {
            logGroupName: `/aws/imagebuilder/${recipename}`,
            retention: logs.RetentionDays.ONE_DAY,
        });
        new logs.SubscriptionFilter(this, 'SlackSubFilter', {
            destination: new aws_logs_destinations_1.LambdaDestination(fn),
            filterPattern: logs.FilterPattern.allTerms('Step'),
            logGroup: logGroup,
        });
    }
}
exports.SlackNotification = SlackNotification;
_a = JSII_RTTI_SYMBOL_1;
SlackNotification[_a] = { fqn: "halloumi-ami-pipelines.SlackNotification", version: "0.0.14" };
//# sourceMappingURL=data:application/json;base64,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