"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cluster = exports.ClusterProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ehpc_generated_1 = require("./ehpc.generated");
Object.defineProperty(exports, "ClusterProperty", { enumerable: true, get: function () { return ehpc_generated_1.RosCluster; } });
/**
 * A ROS resource type:  `ALIYUN::EHPC::Cluster`
 */
class Cluster extends ros.Resource {
    /**
     * Create a new `ALIYUN::EHPC::Cluster`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosCluster = new ehpc_generated_1.RosCluster(this, id, {
            imageOwnerAlias: props.imageOwnerAlias,
            volumeProtocol: props.volumeProtocol,
            ecsOrderComputeCount: props.ecsOrderComputeCount,
            description: props.description,
            securityGroupName: props.securityGroupName,
            autoRenew: props.autoRenew,
            computeSpotPriceLimit: props.computeSpotPriceLimit,
            name: props.name,
            volumeId: props.volumeId,
            volumeType: props.volumeType,
            deployMode: props.deployMode,
            postInstallScript: props.postInstallScript,
            imageId: props.imageId,
            password: props.password,
            autoRenewPeriod: props.autoRenewPeriod,
            keyPairName: props.keyPairName,
            remoteDirectory: props.remoteDirectory,
            sccClusterId: props.sccClusterId,
            ecsOrderLoginInstanceType: props.ecsOrderLoginInstanceType,
            zoneId: props.zoneId,
            jobQueue: props.jobQueue,
            ecsOrderLoginCount: props.ecsOrderLoginCount,
            vSwitchId: props.vSwitchId,
            securityGroupId: props.securityGroupId,
            period: props.period,
            schedulerType: props.schedulerType,
            computeSpotStrategy: props.computeSpotStrategy,
            accountType: props.accountType,
            ecsOrderManagerInstanceType: props.ecsOrderManagerInstanceType,
            ehpcVersion: props.ehpcVersion,
            volumeMountpoint: props.volumeMountpoint,
            ecsOrderManagerCount: props.ecsOrderManagerCount,
            ecsOrderComputeInstanceType: props.ecsOrderComputeInstanceType,
            haEnable: props.haEnable,
            osTag: props.osTag,
            ecsChargeType: props.ecsChargeType,
            application: props.application,
            periodUnit: props.periodUnit,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosCluster;
        this.attrClusterId = rosCluster.attrClusterId;
        this.attrEcsInfo = rosCluster.attrEcsInfo;
        this.attrName = rosCluster.attrName;
        this.attrSecurityGroupId = rosCluster.attrSecurityGroupId;
    }
}
exports.Cluster = Cluster;
//# sourceMappingURL=data:application/json;base64,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