# Generated by Django 3.1.7 on 2021-03-26 21:53

import django
from django.db import migrations
from django_jsonfield_backport.models import JSONField  # noqa

django_version = float(django.get_version()[:3])

if django_version >= 3.1:
    from django.db.models import JSONField  # noqa


def convert_strings_to_lists(apps, schema_editor):
    Notification = apps.get_model('notifications', 'Notification')
    for notification in Notification.objects.all():
        channels = notification.channels
        if channels:
            notification.channels_json = channels
        else:
            notification.channels = list()

        notification.save()


def reverse_convert_strings_to_lists(apps, schema_editor):
    Notification = apps.get_model('notifications', 'Notification')
    for notification in Notification.objects.all():
        notification.channels_json = list()
        notification.save()


class Migration(migrations.Migration):

    dependencies = [
        ('notifications', '0002_django_jsonfield_backport'),
    ]

    operations = [
        migrations.AddField(
            model_name='notification',
            name='channels_json',
            field=JSONField(default=list),
        ),
        migrations.RunPython(
            convert_strings_to_lists, reverse_convert_strings_to_lists
        ),
    ]
