#!/usr/bin/env python
# -*- coding: utf-8 -*-

from os import path
import re

from setuptools import setup, find_packages

# read the contents of your README file
package_dir = path.abspath(path.dirname(__file__))
with open(path.join(package_dir, 'README.rst'), encoding='utf-8') as f:
    long_description = f.read()


def find_version():
    filename = path.join(package_dir, 'oauth2_xfel_client', '__init__.py')
    with open(filename, 'r', encoding='utf-8') as f:
        vers_file = f.read()
    print(vers_file.splitlines()[:10])
    match = re.search(r"^__version__ = '([.\d]+)'", vers_file, re.M)
    if match is not None:
        return match.group(1)
    raise RuntimeError("Unable to find version string.")


setup(
    name='oauth2_xfel_client',
    version=find_version(),
    description='Python OAUTH 2.0 Client used for Backend Application '
                'strategy login against European XFEL Web Applications',
    long_description=long_description,
    long_description_content_type='text/x-rst',
    author='Luís Maia',
    author_email='luis.maia@xfel.eu',
    maintainer='Luís Maia',
    maintainer_email='luis.maia@xfel.eu',
    url='https://git.xfel.eu/gitlab/ITDM/oauth2_xfel_client',
    platforms='any',
    license='MIT',
    packages=find_packages(),
    install_requires=['oauthlib',
                      'requests',
                      'requests-oauthlib',
                      'pytz'],
    extras_require={'test': [
        'pytest',
        'pytest-cov',
        'freezegun',
    ]},
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Environment :: Web Environment',
        'Environment :: Console',
        'Intended Audience :: Developers',
        'Intended Audience :: Science/Research',
        'Natural Language :: English',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.4',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Operating System :: OS Independent',
        'Topic :: Scientific/Engineering :: Information Analysis',
        'Topic :: Software Development :: Libraries :: Python Modules'
    ]
)
