# coding: utf-8

"""
    Getir-Locals Integration Swagger Documentation

    This documentation is created by Getir Developers for Getir-Locals Integration.For this integration, you need to take CLIENT NAME and CLIENT SECRET keys from Getir-dev team and use these keys for authentication. You also need to use access token provided after successful login to be able to use all other endpoints  You can view information about the active order through /orders/unapproved endpoints. The status of the order is managed via verify, prepare, handover and cancel endpoints. Details on order management are as follows:  For orders to be made by the Getir courier, the flow is as follows:  Supplier confirms order --verify<br />Supplier prepares order --prepare (1-2 minutes must pass before delivery)<br />Supplier hands over the order to Getir courier --handover<br />For Getir delivery, transactions are made by the Getir courier after handover.  A valid reason will be requested from the supplier to cancel an order. Valid reasons may vary depending on the instant status of the order. For this reason, before canceling an order, you have to get instant valid order cancellation reasons from /orders/{orderId}/cancel-options endpoint.   # noqa: E501

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from client.api_client import ApiClient


class ProductsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_batch_request_result(self, batch_request_id, **kwargs):  # noqa: E501
        """Get products update result with using batchRequestId  # noqa: E501

        By using this service, the product's price and quantity are updated in groups of 1000. This method supports single and multiple items in a single request.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_batch_request_result(batch_request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str batch_request_id: (required)
        :return: ApiResponsePriceAndQuantityBatchResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_batch_request_result_with_http_info(batch_request_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_batch_request_result_with_http_info(batch_request_id, **kwargs)  # noqa: E501
            return data

    def get_batch_request_result_with_http_info(self, batch_request_id, **kwargs):  # noqa: E501
        """Get products update result with using batchRequestId  # noqa: E501

        By using this service, the product's price and quantity are updated in groups of 1000. This method supports single and multiple items in a single request.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_batch_request_result_with_http_info(batch_request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str batch_request_id: (required)
        :return: ApiResponsePriceAndQuantityBatchResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['batch_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_batch_request_result" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'batch_request_id' is set
        if ('batch_request_id' not in params or
                params['batch_request_id'] is None):
            raise ValueError("Missing the required parameter `batch_request_id` when calling `get_batch_request_result`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'batch_request_id' in params:
            path_params['batchRequestId'] = params['batch_request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/products/price-and-quantity/batch-requests/{batchRequestId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponsePriceAndQuantityBatchResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_chain_productsby_chain_id(self, chain_id, page, page_size, **kwargs):  # noqa: E501
        """This method is used to get products by chain id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_chain_productsby_chain_id(chain_id, page, page_size, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str chain_id: (required)
        :param int page: (required)
        :param int page_size: (required)
        :return: PageableResponseSupplierProductResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_chain_productsby_chain_id_with_http_info(chain_id, page, page_size, **kwargs)  # noqa: E501
        else:
            (data) = self.get_chain_productsby_chain_id_with_http_info(chain_id, page, page_size, **kwargs)  # noqa: E501
            return data

    def get_chain_productsby_chain_id_with_http_info(self, chain_id, page, page_size, **kwargs):  # noqa: E501
        """This method is used to get products by chain id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_chain_productsby_chain_id_with_http_info(chain_id, page, page_size, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str chain_id: (required)
        :param int page: (required)
        :param int page_size: (required)
        :return: PageableResponseSupplierProductResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['chain_id', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_chain_productsby_chain_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'chain_id' is set
        if ('chain_id' not in params or
                params['chain_id'] is None):
            raise ValueError("Missing the required parameter `chain_id` when calling `get_chain_productsby_chain_id`")  # noqa: E501
        # verify the required parameter 'page' is set
        if ('page' not in params or
                params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `get_chain_productsby_chain_id`")  # noqa: E501
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params or
                params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `get_chain_productsby_chain_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'chain_id' in params:
            path_params['chainId'] = params['chain_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/chains/{chainId}/products', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageableResponseSupplierProductResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_shop_productsby_shop_id(self, shop_id, page, page_size, **kwargs):  # noqa: E501
        """This method is used to get products by shop id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_shop_productsby_shop_id(shop_id, page, page_size, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str shop_id: (required)
        :param int page: (required)
        :param int page_size: (required)
        :return: ApiResponsePageableResponseShopProductsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_shop_productsby_shop_id_with_http_info(shop_id, page, page_size, **kwargs)  # noqa: E501
        else:
            (data) = self.get_shop_productsby_shop_id_with_http_info(shop_id, page, page_size, **kwargs)  # noqa: E501
            return data

    def get_shop_productsby_shop_id_with_http_info(self, shop_id, page, page_size, **kwargs):  # noqa: E501
        """This method is used to get products by shop id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_shop_productsby_shop_id_with_http_info(shop_id, page, page_size, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str shop_id: (required)
        :param int page: (required)
        :param int page_size: (required)
        :return: ApiResponsePageableResponseShopProductsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['shop_id', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_shop_productsby_shop_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'shop_id' is set
        if ('shop_id' not in params or
                params['shop_id'] is None):
            raise ValueError("Missing the required parameter `shop_id` when calling `get_shop_productsby_shop_id`")  # noqa: E501
        # verify the required parameter 'page' is set
        if ('page' not in params or
                params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `get_shop_productsby_shop_id`")  # noqa: E501
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params or
                params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `get_shop_productsby_shop_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'shop_id' in params:
            path_params['shopId'] = params['shop_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/shops/{shopId}/products', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponsePageableResponseShopProductsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_price_and_quantity(self, body, **kwargs):  # noqa: E501
        """Update price and quantity of products  # noqa: E501

        This method is used for updating price and quantity information of approved products. You can send stock and price information separately on request.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_price_and_quantity(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductBatchRequest body: (required)
        :return: ApiResponseProductBatchTicketResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_price_and_quantity_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_price_and_quantity_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def update_price_and_quantity_with_http_info(self, body, **kwargs):  # noqa: E501
        """Update price and quantity of products  # noqa: E501

        This method is used for updating price and quantity information of approved products. You can send stock and price information separately on request.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_price_and_quantity_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductBatchRequest body: (required)
        :return: ApiResponseProductBatchTicketResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_price_and_quantity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_price_and_quantity`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/products/price-and-quantity', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseProductBatchTicketResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_price_and_quantity_by_vendor_id(self, body, **kwargs):  # noqa: E501
        """Update price and quantity of products by vendorId  # noqa: E501

        This method is used for updating price and quantity information of approved products by vendor id. You can send stock and price information separately on request.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_price_and_quantity_by_vendor_id(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductBatchVendorRequest body: (required)
        :return: ApiResponseProductBatchTicketResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_price_and_quantity_by_vendor_id_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_price_and_quantity_by_vendor_id_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def update_price_and_quantity_by_vendor_id_with_http_info(self, body, **kwargs):  # noqa: E501
        """Update price and quantity of products by vendorId  # noqa: E501

        This method is used for updating price and quantity information of approved products by vendor id. You can send stock and price information separately on request.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_price_and_quantity_by_vendor_id_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductBatchVendorRequest body: (required)
        :return: ApiResponseProductBatchTicketResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_price_and_quantity_by_vendor_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_price_and_quantity_by_vendor_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/products/price-and-quantity/vendor', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseProductBatchTicketResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
