RC-4のシリアル通信データ表
==========================

- チェックサムは末尾以外のデータをすべて加算して mod 256した1バイト
- datetime型
    - 7bytes year(2) month(1) day(1) hour(1) minute(1) second(1)  の整数7個
- time型
    - 3bytes hour(1) minute(1) second(1)  の整数3個


## 起動時

疎通確認。 固定データを渡して固定データが返る。特にデータに意味はない？
デバイスの種類を識別するIDが含まれているかも(RC-4以外)

### リクエスト

```
        00          04          08          0C         
        -----------------------------------------------
0000    CC 00 0A 00 D6
         a| b| c| d| e

a   定数: CC
b   セッショングループID: 00    常に00でOK
c   起動コマンド: 0A
d   取得ページ番号: 00  複数ページでリクエストすることはないから常に00
e   チェックサム hex((0xCC + 0x00 + 0x0A + 0x00) % 256)

```

### レスポンス

```
        00          04          08          0C         
        -----------------------------------------------
0000    55 A5 FA
         a  b  c   

a   定数: 55
b   定数: A5
c   チェックサム
```

## デバイス情報取得

デバイスの現在の設定値を取得する。

### リクエスト

```
        00          04          08          0C         
        -----------------------------------------------
0000    CC 00 06 00 D2
         a  b  c  d  e

a   定数: CC
b   セッショングループID: 00    常に00でOK
c   デバイス情報取得コマンド: 06
d   取得ページ番号: 00  複数ページでリクエストすることはないから常に00
e   チェックサム

```

### レスポンス


```text
        00          04          08          0C                   
        -----------------------------------------------
0000    55 02 01 28 0A 00 00 1E 02 58 FE D4 07 DF 05 0E
         a  b  ? c   ? [d     ] [e  ] [f  ] [g
0010    16 2F 04 02 07 DF 05 0E 07 38 0E 13 64 00 09 07
         g     ]  h [i                 ]  j  k [ l ] [m
0020    DF 05 0E 16 2F 36 52 43 2D 34 20 44 61 74 61 20
         m              ] [n
0030    4C 6F 67 67 65 72 00 00 00 00 00 00 00 00 00 00
 ...    ...............................................
0090    00 00 00 00 00 00 00 00 00 00 39 39 30 30 31 31
         n                          ] [o
00A0    32 32 33 33 00 31 00 31 F1 02 5D 01 31 00 0F B3
         o        ]  p  q  r  s  t [u  ] [v  ]  w  x  y

a   定数: 55
b   station no: uint8
c   model no? RC4:0x40 RC4HC:0x2A
d   record interval: hhmiss(time)
e   temperature upper limit int16 /10  0x0258 -> 600 -> 60.0
f   temperature lower limit int16 /10  0xFED4 -> -300 -> -30.0
g   last online time(datetime)
h   workstatus  00:not started / 01:start / 02:stop / 03:?
i   start time(datetime)
j   stop button 13:permit / 31:prohibit
k   ?
l   record count: uint16
m   current time(datetime)
n   User information 100 char (encode: OS dependent)
o   number 10char
p   delaytime 00:0h / 01:0.5h / 10:1.0h / 11:1.5h / 20:2.0h / 21: 2.5h
q   tone set 13:permit / 31:prohibit
r   alarm 00:prohibit / 03: 3times / 0A: 10times
s   temperature unit 13:F / 31:C
t   temperature calibration int8 / 10
u   humidity upper limit int16 /10  0x025D -> 605 -> 60.5
v   humidity lower limit int16 /10  0x0131 -> 305 -> 30.5
w   ?
x   humidity calibration int8 / 10
y   チェックサム

```


## デバイスパラメータ設定

デバイスに設定情報を書き込む。

user infomationとnumberはここでは書き込まない。デバイスナンバー書き込み、及びユーザ情報書き込みで行う。

### リクエスト

```
        00          04          08          0C         
        -----------------------------------------------
0000    33 02 05 00 00 00 1E 02 58 FE D4 02 13 00 31 00
         a  b [c  ] [d     ] [e  ] [f  ]  g  h  i  j  k
0010    31 F1 02 58 01 2C 00 0A EC
         l  m [n  ] [o  ]  p  q  r

a   定数: 33
b   更新前ステーション番号
c   パラメータ設定コマンド: 0500
d   record interval: hhmiss(time)
e   temperature upper limit int16 /10  0x0258 -> 600 -> 60.0
f   temperature lower limit int16 /10  0xFED4 -> -300 -> -30.0
g   更新後ステーション番号
h   stop button 13:permit / 31:prohibit
i   delaytime 00:0h / 01:0.5h / 10:1.0h / 11:1.5h / 20:2.0h / 21: 2.5h
j   tone set 13:permit / 31:prohibit
k   alarm 00:prohibit / 03: 3times / 0A: 10times
l   temperature unit 13:F / 31:C
m   temperature calibration int8 / 10
n   humidity upper limit int16 /10  0x0258 -> 600 -> 60.0
o   humidity lower limit int16 /10  0x012C -> 300 -> 30.0
p   ?
q   humidity calibration int8 / 10
r   チェックサム
```

### レスポンス

```
        00          04          08          0C         
        -----------------------------------------------
0000    55 A0 F5
         a  b  c

a   定数: 55
b   デバイスパラメータ設定(A0)
c   チェックサム

```

## デバイスナンバー書き込み

device numberの書き込みを行う。

### リクエスト

```
        00          04          08          0C         
        -----------------------------------------------
0000    33 03 0B 00 31 31 32 32 33 33 34 34 35 35 3F
         a  b [c  ] [d                          ] e

a   定数: 33
b   更新ステーション番号
c   デバイスナンバー書き込みコマンド: 0B00
d   device number 10 char
e   チェックサム
```

### レスポンス

```
        00          04          08          0C         
        -----------------------------------------------
0000    55 A7 FC
         a  b  c

a   定数: 55
b   デバイスナンバー書き込み
c   チェックサム

```


## ユーザー情報書き込み

100文字のUser Infomationの書き込みを行うコマンド

### リクエスト

```text
        00          04          08          0C         
        -----------------------------------------------
0000    33 03 09 00 52 43 2D 34 20 44 61 74 61 20 4C 6F   
        a  b  [c  ] [d
0010    67 67 65 72 00 00 00 00 00 00 00 00 00 00 00 00   
        d
...
0060    00 00 00 00 00 00 00 00 4F                        
        d                     ] e

a   定数: 33
b   更新ステーション番号
c   ユーザー情報書き込みコマンド: 0900
d   user information 100 char
e   チェックサム
```

### レスポンス

```text
        00          04          08          0C         
        -----------------------------------------------
        55 AB 00 
0000    a  b  c

a   定数: 55
b   ユーザー情報書き込みAB
c   チェックサム

```


## 温湿度データ：ヘッダ取得

デバイスに蓄積された温湿度データを収集のためのヘッダ情報を取得する。

ヘッダ情報からデータ件数や開始時間がわかり、この後に続くボディデータの取得回数などを決定できる。



### リクエスト

```text
        00          04          08          0C                   
        -----------------------------------------------
0000    33 01 01 00 35  
         a  b  c  d  e

a   定数: 33
b   station_no: 01
c   データヘッダ取得コマンド: 01
d   ページ番号: 00
e   チェックサム

```

### レスポンス

```text
        00          04          08          0C         
        -----------------------------------------------
0000    55 0B 76 07 DF 05 0E 17 04 35 1F
         a [b  ] [c                 ]  d

a   定数: 55
b   データ件数(2934)
c   start time(datetime)
d   チェックサム
```

## 温湿度データ：ボディ取得

デバイスに蓄積された温湿度データを収集する。

ヘッダ情報から決定したデータ件数を使用し、このコマンドを何度か繰り返す。
RC-4の場合、1ページにつき最大100件のデータが取得できるので、140件のデータの場合は、ページ0(100件)、ページ1(40件)の
ボディ取得を行う。
RC-5の場合、ページサイズは500件になる。RC-4かRC-5かはdevinfoのmodel_noで判別する。


### リクエスト

```text
        00          04          08          0C         
        -----------------------------------------------
0000    33 01 02 00 36
         a  b  c  d  e

a   定数: 33
b   station_no: 01    
c   データボディダ取得コマンド: 02
d   ページ番号: 00
e   チェックサム
```

### レスポンス

```text
        00          04          08          0C         
        -----------------------------------------------
0000    55 01 0B 01 0B 01 0B 01 0B 01 0B 01 0C 01 0C 01 
         a [b1 ] [b2 ] [b3 ] [b4 ] [b5 ] [b6 ] [b7 ]
0010    0C 01 0C 01 0C 01 0C 01 0C 01 0C 01 0C 01 0C 01 
0020    0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 
0030    0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 
0040    0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 
0050    0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 
0060    0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 
0070    0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 
0080    0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 
0090    0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 
00A0    0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 
00B0    0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 
00C0    0D 01 0D 01 0D 01 0D 01 0D B9
                                    c

a   定数: 55
b1  該当ページのデータ1件目
b2  該当ページのデータ2件目
    ...
c   チェックサム
```

## 時刻設定

デバイスの時計を設定する。


### リクエスト

```text
        00          04          08          0C         
        -----------------------------------------------
0000    33 03 07 00 07 DF 06 0E 15 1A 0D 73
         a  b  c  d [e                 ]

a   定数: 33
b   station_no: 03
c   時刻設定コマンド: 07
d   ページ番号: 00
e   設定時刻(datetime)
e   チェックサム
```

### レスポンス

```text
        00          04          08          0C         
        -----------------------------------------------
0000    55 A3 F8 
         a  b  c

a   定数: 55
b   固定: A3
c   チェックサム
```

