ledfx_presets = {
    "bar": {
        "reset": {
            "config": {
                "blur": 0,
                "background_brightness": 1,
                "color_step": 0.125,
                "skip_every": 1,
                "background_color": "#000000",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "brightness": 1,
                "mode": "wipe",
                "ease_method": "ease_out",
                "beat_skip": "none",
                "gradient_roll": 0,
                "mirror": False,
                "flip": False,
            },
            "name": "Reset",
        },
        "bouncing-blues": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 0,
                "brightness": 1,
                "color_step": 0.125,
                "ease_method": "ease_in",
                "flip": True,
                "gradient_name": "Winter",
                "gradient": "linear-gradient(90deg, rgb(0, 199, 140) 0%, rgb(0, 255, 50) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": True,
                "mode": "bounce",
            },
            "name": "Bouncing Blues",
        },
        "passing-by": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 2.8,
                "brightness": 1,
                "color_step": 0.3,
                "ease_method": "linear",
                "flip": True,
                "gradient_name": "Borealis",
                "gradient": "linear-gradient(90deg, rgb(255, 40, 0) 0%, rgb(128, 0, 128) 33%, rgb(0, 199, 140) 66%, rgb(0, 255, 0) 99%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": False,
                "mode": "wipe",
                "solid_color": False,
            },
            "name": "Passing By",
        },
        "plasma-cascade": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 0,
                "brightness": 1,
                "color_step": 0.125,
                "ease_method": "ease_out",
                "flip": True,
                "gradient_name": "Plasma",
                "gradient": "linear-gradient(90deg, rgb(0, 0, 255) 0%, rgb(128, 0, 128) 25%, rgb(255, 0, 0) 50%, rgb(255, 40, 0) 75%, rgb(255, 200, 0) 100%)",
                "solid_color": False,
                "gradient": "linear-gradient(90deg, rgb(0, 0, 255) 0%, rgb(128, 0, 128) 25%, rgb(255, 0, 0) 50%, rgb(255, 40, 0) 75%, rgb(255, 200, 0) 100%)",
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": True,
                "mode": "wipe",
                "solid_color": False,
            },
            "name": "Plasma Cascade",
        },
        "smooth-bounce": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 7.9,
                "brightness": 1,
                "color_step": 0.18,
                "ease_method": "ease_in_out",
                "flip": True,
                "gradient_name": "Dancefloor",
                "solid_color": False,
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 0, 178) 50%, rgb(0, 0, 255) 100%)",
                "gradient_repeat": 1,
                "gradient_roll": 3,
                "mirror": True,
                "mode": "bounce",
            },
            "name": "Smooth Bounce",
        },
        "Rainbow-lr": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 0,
                "brightness": 1,
                "color_step": 0.125,
                "ease_method": "ease_out",
                "flip": False,
                "gradient_name": "Rainbow",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": False,
                "mode": "wipe",
            },
            "name": "Rainbow LR",
        },
    },
    "energy": {
        "reset": {
            "config": {
                "color_mids": "#00ff00",
                "blur": 4,
                "color_cycler": False,
                "color_lows": "#ff0000",
                "sensitivity": 0.6,
                "mixing_mode": "additive",
                "background_brightness": 1,
                "background_color": "#000000",
                "brightness": 1,
                "color_high": "#0000ff",
                "mirror": True,
                "flip": False,
            },
            "name": "Reset",
        },
        "clear-sky": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 0.5,
                "brightness": 1,
                "color_cycler": False,
                "color_high": "#00ffff",
                "color_lows": "#ffc800",
                "color_mids": "#00ff00",
                "flip": False,
                "mirror": True,
                "mixing_mode": "overlap",
                "sensitivity": 0.65,
            },
            "name": "Clear Sky",
        },
        "smooth-plasma": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 8.3,
                "brightness": 1,
                "color_cycler": False,
                "color_high": "#ff0000",
                "color_lows": "#0000ff",
                "color_mids": "#ff00b2",
                "flip": False,
                "mirror": True,
                "mixing_mode": "overlap",
                "sensitivity": 0.4,
            },
            "name": "Smooth Plasma",
        },
        "smooth-rainbow": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "block_count": 4,
                "blur": 7.9,
                "brightness": 1,
                "color_cycler": False,
                "color_high": "#0000ff",
                "color_lows": "#ff0000",
                "color_mids": "#00ff00",
                "color_step": 0.18,
                "ease_method": "ease_in_out",
                "flip": False,
                "gradient_name": "Dancefloor",
                "solid_color": False,
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 0, 178) 50%, rgb(0, 0, 255) 100%)",
                "gradient_roll": 3,
                "mirror": True,
                "mixing_mode": "overlap",
                "mode": "bounce",
                "sensitivity": 0.7,
            },
            "name": "Smooth Rainbow",
        },
        "snappy-blues": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 1.2,
                "brightness": 1,
                "color_cycler": False,
                "color_high": "#00ff00",
                "color_lows": "#0000ff",
                "color_mids": "#00ffff",
                "flip": True,
                "mirror": True,
                "mixing_mode": "additive",
                "sensitivity": 0.9,
            },
            "name": "Snappy Blues",
        },
    },
    "fade": {
        "reset": {
            "config": {
                "blur": 0,
                "background_brightness": 1,
                "speed": 0.5,
                "background_color": "#000000",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "brightness": 1,
                "gradient_roll": 0,
                "mirror": False,
                "flip": False,
            },
            "name": "Reset",
        },
        "blues": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 4.5,
                "brightness": 1,
                "flip": True,
                "gradient_name": "Ocean",
                "gradient": "linear-gradient(90deg, rgb(0, 255, 255) 0%, rgb(0, 0, 255) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 1,
                "mirror": False,
                "speed": 5,
            },
            "name": "Blues",
        },
        "calm-reds": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 4.5,
                "brightness": 1,
                "flip": True,
                "gradient_name": "Rust",
                "gradient": "linear-gradient(90deg, rgb(255, 40, 0) 0%, rgb(255, 0, 0) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 1,
                "mirror": False,
                "speed": 5,
            },
            "name": "Calm Reds",
        },
        "rainbow-cycle": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 4.5,
                "brightness": 1,
                "flip": True,
                "gradient_name": "Rainbow",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 1,
                "mirror": False,
                "speed": 5,
            },
            "name": "Rainbow Cycle",
        },
        "red-to-blue": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 4.5,
                "brightness": 1,
                "flip": True,
                "gradient_name": "Dancefloor",
                "solid_color": False,
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 0, 178) 50%, rgb(0, 0, 255) 100%)",
                "gradient_repeat": 1,
                "gradient_roll": 1,
                "mirror": False,
                "speed": 4.9,
            },
            "name": "Red to Blue",
        },
        "sunset": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 4.5,
                "brightness": 1,
                "flip": True,
                "gradient_name": "Sunset",
                "gradient": "linear-gradient(90deg, rgb(0, 0, 128) 0%, rgb(255, 120, 0) 50%, rgb(255, 0, 0) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 1,
                "mirror": False,
                "speed": 5,
            },
            "name": "Sunset",
        },
    },
    "gradient": {
        "reset": {
            "config": {
                "modulate": False,
                "blur": 0,
                "background_brightness": 1,
                "modulation_speed": 0.5,
                "speed": 1,
                "modulation_effect": "sine",
                "background_color": "#000000",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "brightness": 1,
                "gradient_roll": 0,
                "mirror": False,
                "flip": False,
            },
            "name": "Reset",
        },
        "breathing": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 0.41,
                "brightness": 1,
                "flip": False,
                "gradient_name": "Viridis",
                "gradient": "linear-gradient(90deg, rgb(128, 0, 128) 0%, rgb(0, 0, 255) 25%, rgb(0, 128, 128) 50%, rgb(0, 255, 0) 75%, rgb(255, 200, 0) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 6,
                "mirror": True,
                "modulate": True,
                "modulation_effect": "breath",
                "modulation_speed": 0.59,
                "speed": 0.41,
            },
            "name": "Breathing",
        },
        "falling-blues": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 4,
                "brightness": 1,
                "flip": True,
                "gradient_name": "Ocean",
                "gradient": "linear-gradient(90deg, rgb(0, 255, 255) 0%, rgb(0, 0, 255) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 4,
                "mirror": True,
                "modulate": False,
                "modulation_effect": "breath",
                "modulation_speed": 0.12,
                "speed": 2.8,
            },
            "name": "Falling Blues",
        },
        "rolling-sunset": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 8.6,
                "brightness": 1,
                "flip": True,
                "gradient_name": "Sunset",
                "gradient": "linear-gradient(90deg, rgb(0, 0, 128) 0%, rgb(255, 120, 0) 50%, rgb(255, 0, 0) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 4,
                "mirror": False,
                "modulate": False,
                "modulation_effect": "sine",
                "modulation_speed": 0.5,
                "speed": 1,
            },
            "name": "Rolling Sunset",
        },
        "Rainbow-roll": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 0.24,
                "brightness": 1,
                "flip": False,
                "gradient_name": "Rainbow",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 1,
                "mirror": True,
                "modulate": True,
                "modulation_effect": "sine",
                "modulation_speed": 0.97,
                "speed": 5.6,
            },
            "name": "Rainbow Roll",
        },
        "spectrum": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 0.24,
                "brightness": 1,
                "flip": False,
                "gradient_name": "Rainbow",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": False,
                "modulate": False,
                "modulation_effect": "sine",
                "modulation_speed": 0.97,
                "speed": 5.6,
            },
            "name": "Spectrum",
        },
        "twister": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 9.3,
                "brightness": 1,
                "flip": False,
                "gradient_name": "Viridis",
                "gradient": "linear-gradient(90deg, rgb(128, 0, 128) 0%, rgb(0, 0, 255) 25%, rgb(0, 128, 128) 50%, rgb(0, 255, 0) 75%, rgb(255, 200, 0) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 7,
                "mirror": False,
                "modulate": True,
                "modulation_effect": "breath",
                "modulation_speed": 0.34,
                "speed": 6.7,
            },
            "name": "Twister",
        },
        "waves": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 6.2,
                "brightness": 1,
                "flip": False,
                "gradient_name": "Spring",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 178) 0%, rgb(255, 40, 0) 50%, rgb(255, 200, 0) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 3,
                "mirror": True,
                "modulate": True,
                "modulation_effect": "sine",
                "modulation_speed": 0.52,
                "speed": 6.4,
            },
            "name": "Waves",
        },
    },
    "magnitude": {
        "reset": {
            "config": {
                "blur": 0,
                "background_brightness": 1,
                "background_color": "#000000",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "brightness": 1,
                "frequency_range": "Lows (beat+bass)",
                "gradient_roll": 0,
                "mirror": False,
                "flip": False,
            },
            "name": "Reset",
        },
        "cold-fire": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 1.3,
                "brightness": 1,
                "flip": False,
                "frequency_range": "Bass",
                "gradient_name": "Frost",
                "gradient": "linear-gradient(90deg, rgb(0, 0, 255) 0%, rgb(0, 255, 255) 33%, rgb(128, 0, 128) 66%, rgb(255, 0, 178) 99%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 5,
                "mirror": True,
            },
            "name": "Cold Fire",
        },
        "jungle-cascade": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 8.4,
                "brightness": 1,
                "flip": True,
                "frequency_range": "Bass",
                "gradient_name": "Jungle",
                "gradient": "linear-gradient(90deg, rgb(0, 255, 0) 0%, rgb(34, 139, 34) 50%, rgb(255, 120, 0) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 4,
                "mirror": True,
            },
            "name": "Jungle Cascade",
        },
        "lively": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 2.3,
                "brightness": 1,
                "flip": True,
                "frequency_range": "Bass",
                "gradient_name": "Viridis",
                "gradient": "linear-gradient(90deg, rgb(128, 0, 128) 0%, rgb(0, 0, 255) 25%, rgb(0, 128, 128) 50%, rgb(0, 255, 0) 75%, rgb(255, 200, 0) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 7,
                "mirror": True,
            },
            "name": "Lively",
        },
        "rolling-rainbow": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 5.4,
                "brightness": 1,
                "flip": False,
                "frequency_range": "Bass",
                "gradient_name": "Borealis",
                "gradient": "linear-gradient(90deg, rgb(255, 40, 0) 0%, rgb(128, 0, 128) 33%, rgb(0, 199, 140) 66%, rgb(0, 255, 0) 99%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 5,
                "mirror": False,
            },
            "name": "Rolling Rainbow",
        },
        "warm-bass": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 8.5,
                "brightness": 1,
                "flip": False,
                "frequency_range": "Bass",
                "gradient_name": "Winamp",
                "gradient": "linear-gradient(90deg, rgb(0, 255, 0) 0%, rgb(255, 200, 0) 25%, rgb(255, 120, 0) 50%, rgb(255, 40, 0) 75%, rgb(255, 0, 0) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 1,
                "mirror": False,
            },
            "name": "Warm Bass",
        },
    },
    "multiBar": {
        "reset": {
            "config": {
                "blur": 0,
                "background_brightness": 1,
                "color_step": 0.125,
                "background_color": "#000000",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "brightness": 1,
                "mode": "wipe",
                "ease_method": "linear",
                "gradient_roll": 0,
                "mirror": False,
                "flip": False,
            },
            "name": "Reset",
        },
        "bright-cascade": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 3.8,
                "brightness": 1,
                "color_step": 0.41,
                "ease_method": "linear",
                "flip": True,
                "gradient_name": "Borealis",
                "gradient": "linear-gradient(90deg, rgb(255, 40, 0) 0%, rgb(128, 0, 128) 33%, rgb(0, 199, 140) 66%, rgb(0, 255, 0) 99%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 7,
                "mirror": True,
                "mode": "cascade",
            },
            "name": "Bright Cascade",
        },
        "falling-blues": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 9.1,
                "brightness": 1,
                "color_step": 0.2,
                "ease_method": "ease_in",
                "flip": False,
                "gradient_name": "Ocean",
                "gradient": "linear-gradient(90deg, rgb(0, 255, 255) 0%, rgb(0, 0, 255) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": False,
                "mode": "cascade",
            },
            "name": "Falling Blues",
        },
        "red-blue-expanse": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 3.8,
                "brightness": 1,
                "color_step": 0.41,
                "ease_method": "ease_out",
                "flip": False,
                "gradient_name": "Dancefloor",
                "solid_color": False,
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 0, 178) 50%, rgb(0, 0, 255) 100%)",
                "gradient_repeat": 1,
                "gradient_roll": 7,
                "mirror": True,
                "mode": "cascade",
            },
            "name": "Red Blue Expanse",
        },
        "Rainbow-oscillation": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 0,
                "brightness": 1,
                "color_step": 0.125,
                "ease_method": "ease_in_out",
                "flip": False,
                "gradient_name": "Rainbow",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": False,
                "mode": "wipe",
            },
            "name": "Rainbow Oscillation",
        },
    },
    "rain": {
        "reset": {
            "config": {
                "blur": 0,
                "mids_sensitivity": 0.05,
                "lows_color": "#ffffff",
                "background_brightness": 1,
                "raindrop_animation": "Blob",
                "high_color": "#0000ff",
                "high_sensitivity": 0.1,
                "background_color": "#000000",
                "brightness": 1,
                "mids_color": "#ff0000",
                "mirror": True,
                "flip": False,
                "lows_sensitivity": 0.1,
            },
            "name": "Reset",
        },
        "cold-drops": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 1.0,
                "brightness": 1.0,
                "flip": False,
                "high_color": "#ff00b2",
                "high_sensitivity": 0.1,
                "lows_color": "#ffffff",
                "lows_sensitivity": 0.1,
                "mids_color": "#00ffff",
                "mids_sensitivity": 0.05,
                "mirror": True,
                "raindrop_animation": "Laser",
            },
            "name": "Cold Drops",
        },
        "meteor-shower": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 2.3,
                "brightness": 1,
                "flip": False,
                "high_color": "#ffc800",
                "high_sensitivity": 0.1,
                "lows_color": "#ff0000",
                "lows_sensitivity": 0.1,
                "mids_color": "#ffa500",
                "mids_sensitivity": 0.05,
                "mirror": False,
                "raindrop_animation": "Blob",
            },
            "name": "Meteor Shower",
        },
        "prismatic": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 4.9,
                "brightness": 1,
                "flip": False,
                "high_color": "#ff00b2",
                "high_sensitivity": 0.1,
                "lows_color": "#ffa500",
                "lows_sensitivity": 0.1,
                "mids_color": "#00ff00",
                "mids_sensitivity": 0.05,
                "mirror": True,
                "raindrop_animation": "Laser",
            },
            "name": "Prismatic",
        },
        "ripples": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0.8,
                "brightness": 1,
                "flip": False,
                "high_color": "#00ffff",
                "high_sensitivity": 0.1,
                "lows_color": "#ffc800",
                "lows_sensitivity": 0.1,
                "mids_color": "yellow-acid",
                "mids_sensitivity": 0.05,
                "mirror": True,
                "raindrop_animation": "Ripple",
            },
            "name": "Ripples",
        },
        "smooth-rwb": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 9.8,
                "brightness": 1,
                "fade_rate": 0.7,
                "flip": False,
                "gradient_name": "Dancefloor",
                "solid_color": False,
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 0, 178) 50%, rgb(0, 0, 255) 100%)",
                "gradient_roll": 8,
                "high_color": "#0000ff",
                "high_sensitivity": 0.1,
                "lows_color": "#ffffff",
                "lows_sensitivity": 0.1,
                "mids_color": "#ff0000",
                "mids_sensitivity": 0.05,
                "mirror": False,
                "raindrop_animation": "Ripple",
                "responsiveness": 0.88,
            },
            "name": "Smooth RWB",
        },
    },
    "rainbow": {
        "reset": {
            "config": {
                "blur": 0,
                "background_brightness": 1,
                "speed": 1,
                "frequency": 1,
                "background_color": "#000000",
                "brightness": 1,
                "mirror": False,
                "flip": False,
            },
            "name": "Reset",
        },
        "cascade": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 7.7,
                "brightness": 1,
                "flip": False,
                "frequency": 0.32,
                "mirror": True,
                "speed": 0.3,
            },
            "name": "Cascade",
        },
        "crawl": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 2.3,
                "brightness": 1,
                "flip": True,
                "frequency": 3.6,
                "mirror": False,
                "speed": 3.5,
            },
            "name": "Crawl",
        },
        "faded": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 6.4,
                "brightness": 1,
                "flip": True,
                "frequency": 5.9,
                "mirror": False,
                "speed": 9.7,
            },
            "name": "Faded",
        },
        "gentle": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 7.7,
                "brightness": 1,
                "flip": True,
                "frequency": 1.9,
                "mirror": True,
                "speed": 3.3,
            },
            "name": "Gentle",
        },
        "slow-roll": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0,
                "brightness": 1,
                "flip": True,
                "frequency": 4.4,
                "mirror": True,
                "speed": 1.1,
            },
            "name": "Slow Roll",
        },
    },
    "scroll": {
        "reset": {
            "config": {
                "color_mids": "#00ff00",
                "blur": 3,
                "color_lows": "#ff0000",
                "background_brightness": 1,
                "speed": 3,
                "decay": 0.97,
                "threshold": 0,
                "background_color": "#000000",
                "brightness": 1,
                "color_high": "#0000ff",
                "mirror": True,
                "flip": False,
            },
            "name": "Reset",
        },
        "cold-crawl": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 1,
                "brightness": 1,
                "color_high": "#00ffff",
                "color_lows": "#ff00b2",
                "color_mids": "#ffb6c1",
                "decay": 1,
                "flip": False,
                "mirror": True,
                "speed": 1,
                "threshold": 1,
            },
            "name": "Cold Crawl",
        },
        "dynamic-rgb": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 3,
                "brightness": 1,
                "color_high": "#0000ff",
                "color_lows": "#ff0000",
                "color_mids": "#00ff00",
                "decay": 0.97,
                "flip": False,
                "mirror": True,
                "speed": 5,
                "threshold": 0,
            },
            "name": "Dynamic RGB",
        },
        "fast-hits": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0.2,
                "brightness": 1,
                "color_high": "#ffa500",
                "color_lows": "#00ff7f",
                "color_mids": "#dda0dd",
                "decay": 0.9,
                "flip": False,
                "mirror": True,
                "speed": 6,
                "threshold": 0.6,
            },
            "name": "Fast Hits",
        },
        "gentle-rgb": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 7,
                "brightness": 1,
                "color_high": "#0000ff",
                "color_lows": "#ff0000",
                "color_mids": "#00ff00",
                "decay": 0.97,
                "flip": False,
                "frequency": 1.9,
                "mirror": True,
                "speed": 3,
                "threshold": 0,
            },
            "name": "Gentle RGB",
        },
        "icicles": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 1,
                "brightness": 1,
                "color_high": "#00ff32",
                "color_lows": "#add8e6",
                "color_mids": "#00ffff",
                "decay": 0.97,
                "flip": True,
                "mirror": False,
                "speed": 2,
                "threshold": 0.0215,
            },
            "name": "Icicles",
        },
        "rays": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0,
                "brightness": 1,
                "color_high": "#00ffff",
                "color_lows": "#ffc800",
                "color_mids": "#ffc800",
                "decay": 1,
                "flip": False,
                "mirror": True,
                "speed": 5,
                "threshold": 0.7,
            },
            "name": "Rays",
        },
        "warmth": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 8.1,
                "brightness": 1,
                "color_high": "#00ff32",
                "color_lows": "#ff0000",
                "color_mids": "#ffa500",
                "decay": 0.97,
                "flip": False,
                "mirror": True,
                "speed": 8,
                "threshold": 0.55,
            },
            "name": "Warmth",
        },
    },
    "singleColor": {
        "reset": {
            "config": {
                "modulate": False,
                "blur": 0,
                "color": "#ff0000",
                "background_brightness": 1,
                "modulation_speed": 0.5,
                "speed": 1,
                "modulation_effect": "sine",
                "background_color": "#000000",
                "brightness": 1,
                "mirror": False,
                "flip": False,
            },
            "name": "Reset",
        },
        "blue": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0,
                "brightness": 1,
                "color": "#0000ff",
                "decay": 1,
                "flip": False,
                "mirror": True,
                "modulate": False,
                "modulation_effect": "sine",
                "modulation_speed": 0.5,
                "speed": 5,
                "threshold": 0.7,
            },
            "name": "Blue",
        },
        "cyan": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0,
                "brightness": 1,
                "color": "#00ffff",
                "decay": 1,
                "flip": False,
                "mirror": True,
                "modulate": False,
                "modulation_effect": "sine",
                "modulation_speed": 0.5,
                "speed": 5,
                "threshold": 0.7,
            },
            "name": "Cyan",
        },
        "green": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0,
                "brightness": 1,
                "color": "#00ff00",
                "decay": 1,
                "flip": False,
                "mirror": True,
                "modulate": False,
                "modulation_effect": "sine",
                "modulation_speed": 0.5,
                "speed": 5,
                "threshold": 0.7,
            },
            "name": "Green",
        },
        "magenta": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0,
                "brightness": 1,
                "color": "#ff00ff",
                "decay": 1,
                "flip": False,
                "mirror": True,
                "modulate": False,
                "modulation_effect": "sine",
                "modulation_speed": 0.5,
                "speed": 5,
                "threshold": 0.7,
            },
            "name": "Magenta",
        },
        "orange": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0,
                "brightness": 1,
                "color": "#ffc800",
                "decay": 1,
                "flip": False,
                "mirror": True,
                "modulate": False,
                "modulation_effect": "sine",
                "modulation_speed": 0.5,
                "speed": 5,
                "threshold": 0.7,
            },
            "name": "Orange",
        },
        "pink": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0,
                "brightness": 1,
                "color": "#ff00b2",
                "decay": 1,
                "flip": False,
                "mirror": True,
                "modulate": False,
                "modulation_effect": "sine",
                "modulation_speed": 0.5,
                "speed": 5,
                "threshold": 0.7,
            },
            "name": "#ff00b2",
        },
        "red": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0,
                "brightness": 1,
                "color": "#ff0000",
                "decay": 1,
                "flip": False,
                "mirror": True,
                "modulate": False,
                "modulation_effect": "sine",
                "modulation_speed": 0.5,
                "speed": 5,
                "threshold": 0.7,
            },
            "name": "Red",
        },
        "red-waves": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 6.2,
                "brightness": 1,
                "color": "#ff0000",
                "flip": False,
                "mirror": True,
                "modulate": True,
                "modulation_effect": "sine",
                "modulation_speed": 0.76,
                "speed": 0.62,
            },
            "name": "Red Waves",
        },
        "steel-pulse": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 6.2,
                "brightness": 1,
                "color": "#4682b4",
                "flip": False,
                "mirror": True,
                "modulate": True,
                "modulation_effect": "breath",
                "modulation_speed": 0.75,
                "speed": 0.62,
            },
            "name": "Steel Pulse",
        },
        "turquoise-roll": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 6.2,
                "brightness": 1,
                "color": "#00c78c",
                "flip": False,
                "mirror": False,
                "modulate": True,
                "modulation_effect": "sine",
                "modulation_speed": 0.76,
                "speed": 0.62,
            },
            "name": "Turquoise Roll",
        },
        "yellow": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0,
                "brightness": 1,
                "color": "#ffc800",
                "decay": 1,
                "flip": False,
                "mirror": True,
                "modulate": False,
                "modulation_effect": "sine",
                "modulation_speed": 0.5,
                "speed": 5,
                "threshold": 0.7,
            },
            "name": "Yellow",
        },
    },
    "strobe": {
        "reset": {
            "config": {
                "blur": 0,
                "strobe_decay": 1.5,
                "background_brightness": 1,
                "background_color": "#000000",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "brightness": 1,
                "strobe_frequency": "1/2 (.-. )",
                "beat_decay": 2,
                "gradient_roll": 0,
                "mirror": False,
                "flip": False,
            },
            "name": "Reset",
        },
        "aggro-red": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "beat_decay": 2,
                "blur": 6.2,
                "brightness": 1,
                "color": "#ff0000",
                "flip": False,
                "frequency": "1/4 (.o. )",
                "gradient_name": "Rainbow",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": False,
                "modulate": True,
                "modulation_effect": "sine",
                "modulation_speed": 0.76,
                "single_color": True,
                "speed": 0.62,
                "strobe_decay": 1.5,
                "strobe_frequency": "1/2 (.-. )",
            },
            "name": "Aggro Red",
        },
        "blues-on-the-beat": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "beat_decay": 2,
                "blur": 6.2,
                "brightness": 1,
                "color": "#0000ff",
                "flip": False,
                "frequency": "1/2 (.-. )",
                "gradient_name": "Rainbow",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": False,
                "modulate": True,
                "modulation_effect": "sine",
                "modulation_speed": 0.76,
                "single_color": True,
                "speed": 0.62,
                "strobe_decay": 1.5,
                "strobe_frequency": "1/2 (.-. )",
            },
            "name": "Blues on the Beat",
        },
        "fast-strobe": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "beat_decay": 2,
                "blur": 2.6,
                "brightness": 1,
                "color": "#ffffff",
                "flip": True,
                "frequency": "1/4 (.o. )",
                "gradient_name": "Rainbow",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "modulate": False,
                "modulation_effect": "sine",
                "modulation_speed": 0.76,
                "mirror": False,
                "single_color": False,
                "strobe_decay": 1.5,
                "strobe_frequency": "1/2 (.-. )",
            },
            "name": "Fast Strobe",
        },
        "faster-strobe": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "beat_decay": 2,
                "blur": 2.6,
                "brightness": 1,
                "color": "#ffffff",
                "flip": True,
                "frequency": "1/16 (◉﹏◉ )",
                "gradient_name": "Rainbow",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": False,
                "single_color": False,
                "strobe_decay": 1.5,
                "strobe_frequency": "1/2 (.-. )",
            },
            "name": "Faster Strobe",
        },
        "painful": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "beat_decay": 2,
                "blur": 2.6,
                "brightness": 1,
                "color": "#ffffff",
                "flip": True,
                "frequency": "1/32 (⊙▃⊙ )",
                "gradient_name": "Rainbow",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": False,
                "single_color": False,
                "strobe_decay": 1.5,
                "strobe_frequency": "1/2 (.-. )",
            },
            "name": "Painful",
        },
    },
    "wavelength": {
        "reset": {
            "config": {
                "blur": 3,
                "background_brightness": 1,
                "background_color": "#000000",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "brightness": 1,
                "gradient_roll": 0,
                "mirror": False,
                "flip": False,
            },
            "name": "Reset",
        },
        "classic": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 3,
                "brightness": 1,
                "flip": False,
                "gradient_name": "Rainbow",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": False,
            },
            "name": "Classic",
        },
        "greens": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 5.1,
                "brightness": 1,
                "flip": False,
                "gradient_name": "Winter",
                "gradient": "linear-gradient(90deg, rgb(0, 199, 140) 0%, rgb(0, 255, 50) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 1,
                "mirror": True,
            },
            "name": "Greens",
        },
        "icy": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 5.7,
                "brightness": 1,
                "flip": False,
                "gradient_name": "Frost",
                "gradient": "linear-gradient(90deg, rgb(0, 0, 255) 0%, rgb(0, 255, 255) 33%, rgb(128, 0, 128) 66%, rgb(255, 0, 178) 99%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 1,
                "mirror": False,
            },
            "name": "Icy",
        },
        "plasma": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 1.8,
                "brightness": 1,
                "flip": False,
                "gradient_name": "Plasma",
                "gradient": "linear-gradient(90deg, rgb(0, 0, 255) 0%, rgb(128, 0, 128) 25%, rgb(255, 0, 0) 50%, rgb(255, 40, 0) 75%, rgb(255, 200, 0) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 6,
                "mirror": True,
            },
            "name": "Plasma",
        },
        "rolling-blues": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 1,
                "brightness": 1,
                "flip": False,
                "gradient_name": "Dancefloor",
                "solid_color": False,
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 0, 178) 50%, rgb(0, 0, 255) 100%)",
                "gradient_repeat": 1,
                "gradient_roll": 3,
                "mirror": True,
            },
            "name": "rolling blues",
        },
        "rolling-warmth": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 5.9,
                "brightness": 1,
                "flip": False,
                "gradient_name": "Sunset",
                "gradient": "linear-gradient(90deg, rgb(0, 0, 128) 0%, rgb(255, 120, 0) 50%, rgb(255, 0, 0) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 7,
                "mirror": True,
            },
            "name": "Rolling Warmth",
        },
        "sunset-sweep": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 8.6,
                "brightness": 1,
                "flip": True,
                "gradient_name": "Sunset",
                "gradient": "linear-gradient(90deg, rgb(0, 0, 128) 0%, rgb(255, 120, 0) 50%, rgb(255, 0, 0) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 4,
                "mirror": False,
            },
            "name": "Sunset Sweep",
        },
    },
    "real_strobe": {
        "reset": {
            "config": {
                "blur": 0,
                "strobe_width": 10,
                "background_brightness": 1,
                "bass_strobe_decay_rate": 0.5,
                "color_step": 0.0625,
                "background_color": "#000000",
                "gradient": "Dancefloor",
                "brightness": 1,
                "strobe_color": "#ffffff",
                "color_shift_delay": 1,
                "gradient_roll": 0,
                "mirror": False,
                "flip": False,
                "strobe_decay_rate": 0.5,
            },
            "name": "Reset",
        },
        "dancefloor": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "bass_strobe_decay_rate": 0.7,
                "bass_threshold": 0.4,
                "blur": 0,
                "brightness": 1,
                "color_step": 0.0625,
                "flip": False,
                "gradient_name": "Dancefloor",
                "solid_color": False,
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 0, 178) 50%, rgb(0, 0, 255) 100%)",
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": False,
                "strobe_color": "#ffffff",
                "strobe_decay_rate": 0.85,
                "strobe_width": 50,
            },
            "name": "Dance floor",
        },
        "strobe_only": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "bass_strobe_decay_rate": 0.7,
                "bass_threshold": 1,
                "blur": 0,
                "brightness": 1,
                "color_step": 0.0625,
                "flip": False,
                "gradient_name": "Dancefloor",
                "solid_color": False,
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 0, 178) 50%, rgb(0, 0, 255) 100%)",
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": False,
                "strobe_color": "#ffffff",
                "strobe_decay_rate": 0.85,
                "strobe_width": 50,
            },
            "name": "Strobe only",
        },
        "bass_only": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "bass_strobe_decay_rate": 0.7,
                "bass_threshold": 0.4,
                "blur": 0,
                "brightness": 1,
                "color_step": 0.0625,
                "flip": False,
                "gradient_name": "Dancefloor",
                "solid_color": False,
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 0, 178) 50%, rgb(0, 0, 255) 100%)",
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": False,
                "strobe_color": "#000000",
                "strobe_decay_rate": 0.85,
                "strobe_width": 0,
            },
            "name": "Bass only",
        },
        "extreme": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "bass_strobe_decay_rate": 1,
                "bass_threshold": 0.45,
                "blur": 0,
                "brightness": 1,
                "color_step": 0.0625,
                "flip": False,
                "gradient_name": "Dancefloor",
                "solid_color": False,
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 0, 178) 50%, rgb(0, 0, 255) 100%)",
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": False,
                "strobe_color": "#ffffff",
                "strobe_decay_rate": 1,
                "strobe_width": 50,
            },
            "name": "Extreme",
        },
        "glitter": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "bass_strobe_decay_rate": 0.01,
                "bass_threshold": 0,
                "blur": 0,
                "brightness": 1,
                "color_step": 0.015,
                "flip": False,
                "gradient_name": "Dancefloor",
                "solid_color": False,
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 0, 178) 50%, rgb(0, 0, 255) 100%)",
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": True,
                "strobe_color": "#ffffff",
                "strobe_decay_rate": 0.5,
                "strobe_width": 50,
            },
            "name": "Glitter",
        },
        "color-shift": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "bass_strobe_decay_rate": 0,
                "blur": 0.0,
                "brightness": 1.0,
                "color_shift_delay": 0.1,
                "color_step": 0.0625,
                "flip": False,
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "gradient_roll": 0.0,
                "mirror": False,
                "strobe_color": "#000000",
                "strobe_decay_rate": 1,
                "strobe_width": 0,
            },
            "name": "Color shift",
        },
    },
    "blade_power_plus": {
        "reset": {
            "config": {
                "brightness": 1,
                "mirror": False,
                "background_brightness": 1,
                "background_color": "#000000",
                "flip": False,
                "blur": 2,
                "decay": 0.7,
                "frequency_range": "Lows (beat+bass)",
                "gradient_roll": 0,
                "multiplier": 0.5,
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "invert_roll": False,
            },
            "name": "Reset",
        },
        "orange-hi-hat": {
            "config": {
                "background_brightness": 0.3,
                "background_color": "#ffa500",
                "blur": 2,
                "brightness": 1,
                "color": "#00ffff",
                "color_correction": True,
                "flip": False,
                "frequency_range": "High",
                "gradient": "linear-gradient(90deg, #ff00b2 0.00%,#ffa500 50.00%,#ffc800 100.00%)",
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "invert_roll": False,
                "mirror": True,
                "multiplier": 1,
                "solid_color": False,
            },
            "name": "Orange HiHat",
        },
        "ocean-bass": {
            "config": {
                "background_brightness": 0.44,
                "background_color": "#0000ff",
                "blur": 2,
                "brightness": 1,
                "color": "#00ffff",
                "color_correction": True,
                "decay": 0.7,
                "flip": False,
                "frequency_range": "Lows (beat+bass)",
                "gradient": "linear-gradient(90deg, #00ffff 0.00%,#0000ff 100.00%)",
                "gradient_name": "Ocean",
                "gradient": "linear-gradient(90deg, rgb(0, 255, 255) 0%, rgb(0, 0, 255) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "invert_roll": False,
                "mirror": False,
                "multiplier": 0.5,
                "solid_color": False,
            },
            "name": "Ocean Bass",
        },
    },
    "bands": {
        "reset": {
            "config": {
                "blur": 0,
                "align": "left",
                "background_brightness": 1,
                "background_color": "#000000",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "brightness": 1,
                "gradient_roll": 0,
                "mirror": False,
                "flip": False,
                "band_count": 6,
            },
            "name": "Reset",
        }
    },
    "bands_matrix": {
        "reset": {
            "config": {
                "blur": 0,
                "flip_gradient": False,
                "flip_horizontal": False,
                "background_brightness": 1,
                "background_color": "#000000",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "brightness": 1,
                "gradient_roll": 0,
                "mirror": False,
                "flip": False,
                "band_count": 6,
            },
            "name": "Reset",
        }
    },
    "block_reflections": {
        "reset": {
            "config": {
                "blur": 0,
                "reactivity": 0.5,
                "background_brightness": 1,
                "speed": 0.5,
                "background_color": "#000000",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "brightness": 1,
                "gradient_roll": 0,
                "mirror": False,
                "flip": False,
            },
            "name": "Reset",
        }
    },
    "crawler": {
        "reset": {
            "config": {
                "blur": 0,
                "reactivity": 0.25,
                "stretch": 2.5,
                "chop": 30,
                "background_brightness": 1,
                "speed": 0.5,
                "sway": 20,
                "background_color": "#000000",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "brightness": 1,
                "gradient_roll": 0,
                "mirror": False,
                "flip": False,
            },
            "name": "Reset",
        }
    },
    "scan_multi": {
        "reset": {
            "config": {
                "color_intensity": True,
                "blur": 3,
                "filter": False,
                "multiplier": 3,
                "attack": 0.9,
                "background_brightness": 1,
                "scan_width": 30,
                "color_low": "#ff0000",
                "input_source": "Power",
                "advanced": True,
                "bounce": True,
                "decay": 0.7,
                "use_grad": False,
                "brightness": 1,
                "mirror": False,
                "speed": 50,
                "background_color": "#000000",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "color_high": "#0000ff",
                "gradient_roll": 0,
                "flip": False,
                "color_mid": "#00ff00",
            },
            "name": "Reset",
        }
    },
    "scan_and_flare": {
        "reset": {
            "config": {
                "color_intensity": True,
                "blur": 3,
                "sparkles_time": 1,
                "multiplier": 3,
                "background_brightness": 1,
                "frequency_range": "Lows (beat+bass)",
                "scan_width": 30,
                "sparkles_threshold": 0.6,
                "sparkles_size": 0.1,
                "sparkles_max": 10,
                "color_scan": "#ff0000",
                "bounce": True,
                "use_grad": False,
                "brightness": 1,
                "mirror": False,
                "speed": 50,
                "background_color": "#000000",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "gradient_roll": 0,
                "flip": False,
            },
            "name": "Reset",
        }
    },
    "scan": {
        "reset": {
            "config": {
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 3,
                "bounce": True,
                "brightness": 1,
                "color_intensity": True,
                "color_scan": "#ff0000",
                "count": 1,
                "flip": False,
                "frequency_range": "Lows (beat+bass)",
                "full_grad": False,
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "gradient_roll": 0,
                "mirror": False,
                "modulate": False,
                "modulation_effect": "sine",
                "modulation_speed": 0.5,
                "multiplier": 3,
                "scan_width": 30,
                "speed": 50,
                "use_grad": False,
            },
            "name": "Reset",
        },
        "painbow": {
            "config": {
                "advanced": True,
                "background_brightness": 0.0,
                "background_color": "#000000",
                "blur": 0.0,
                "bounce": False,
                "brightness": 1.0,
                "color_intensity": True,
                "color_scan": "#ff0000",
                "count": 2,
                "flip": False,
                "frequency_range": "Lows (beat+bass)",
                "full_grad": True,
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "gradient_roll": 1.0,
                "mirror": False,
                "modulate": False,
                "modulation_effect": "sine",
                "modulation_speed": 0.65,
                "multiplier": 3.0,
                "scan_width": 30,
                "speed": 31,
                "use_grad": True,
            },
            "name": "painbow",
        },
    },
    "blocks": {
        "reset": {
            "config": {
                "blur": 0,
                "background_brightness": 1,
                "block_count": 4,
                "background_color": "#000000",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "brightness": 1,
                "gradient_roll": 0,
                "mirror": False,
                "flip": False,
            },
            "name": "Reset",
        }
    },
    "energy2": {
        "reset": {
            "config": {
                "blur": 0,
                "reactivity": 0.2,
                "background_brightness": 1,
                "speed": 0.1,
                "background_color": "#000000",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "brightness": 1,
                "gradient_roll": 0,
                "mirror": False,
                "flip": False,
            },
            "name": "Reset",
        }
    },
    "equalizer": {
        "reset": {
            "config": {
                "blur": 0,
                "align": "left",
                "background_brightness": 1,
                "gradient_repeat": 6,
                "background_color": "#000000",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "brightness": 1,
                "gradient_roll": 0,
                "mirror": False,
                "flip": False,
            },
            "name": "Reset",
        }
    },
    "fire": {
        "reset": {
            "config": {
                "blur": 0,
                "color_shift": 0.15,
                "background_brightness": 1,
                "speed": 0.04,
                "background_color": "#000000",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "brightness": 1,
                "gradient_roll": 0,
                "mirror": False,
                "flip": False,
                "intensity": 8,
            },
            "name": "Reset",
        }
    },
    "glitch": {
        "reset": {
            "config": {
                "blur": 0,
                "reactivity": 0.2,
                "background_brightness": 1,
                "speed": 0.5,
                "background_color": "#000000",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "brightness": 1,
                "gradient_roll": 0,
                "mirror": False,
                "flip": False,
            },
            "name": "Reset",
        }
    },
    "hue_fix_demo": {"reset": {"config": {}, "name": "Reset"}},
    "lava_lamp": {
        "reset": {
            "config": {
                "blur": 0,
                "reactivity": 0.3,
                "background_brightness": 1,
                "speed": 7,
                "background_color": "#000000",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "brightness": 1,
                "contrast": 0.6,
                "gradient_roll": 0,
                "mirror": False,
                "flip": False,
            },
            "name": "Reset",
        }
    },
    "marching": {
        "reset": {
            "config": {
                "blur": 0,
                "reactivity": 0.2,
                "background_brightness": 1,
                "speed": 0.1,
                "background_color": "#000000",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "brightness": 1,
                "gradient_roll": 0,
                "mirror": False,
                "flip": False,
            },
            "name": "Reset",
        }
    },
    "melt": {
        "reset": {
            "config": {
                "blur": 0,
                "reactivity": 0.5,
                "background_brightness": 1,
                "speed": 0.5,
                "background_color": "#000000",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "brightness": 1,
                "gradient_roll": 0,
                "mirror": False,
                "flip": False,
            },
            "name": "Reset",
        },
        "bladesmooth": {
            "name": "Blade Smooth",
            "config": {
                "background_brightness": 0.27,
                "flip": False,
                "background_color": "#0000ff",
                "brightness": 1,
                "gradient": "linear-gradient(90deg, #ff00b2 0.00%,#ffa500 50.00%,#ffc800 100.00%)",
                "reactivity": 0.3,
                "blur": 0,
                "mirror": False,
                "gradient_roll": 0,
                "speed": 0.2,
            },
        },
    },
    "pitchSpectrum": {
        "reset": {
            "config": {
                "blur": 1,
                "fade_rate": 0.15,
                "responsiveness": 0.15,
                "background_brightness": 1,
                "background_color": "#000000",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "brightness": 1,
                "gradient_roll": 0,
                "mirror": True,
                "flip": False,
            },
            "name": "Reset",
        }
    },
    "power": {
        "reset": {
            "config": {
                "blur": 0,
                "sparks_color": "#ffffff",
                "background_brightness": 1,
                "sparks_decay_rate": 0.15,
                "background_color": "#000000",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "brightness": 1,
                "gradient_roll": 0,
                "mirror": True,
                "flip": False,
                "bass_decay_rate": 0.05,
            },
            "name": "Reset",
        }
    },
    "spectrum": {
        "reset": {
            "config": {
                "blur": 0,
                "background_brightness": 1,
                "background_color": "#000000",
                "brightness": 1,
                "mirror": False,
                "flip": False,
            },
            "name": "Reset",
        }
    },
    "melt_and_sparkle": {
        "reset": {
            "config": {
                "blur": 0,
                "reactivity": 0.5,
                "strobe_rate": 0.75,
                "strobe_width": 0.3,
                "background_brightness": 1,
                "speed": 0.5,
                "strobe_threshold": 0.75,
                "strobe_blur": 3.5,
                "background_color": "#000000",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "brightness": 1,
                "lava_width": 0.5,
                "gradient_roll": 0,
                "mirror": False,
                "flip": False,
                "bg_bright": 0.4,
                "strobe_decay_rate": 0.25,
            },
            "name": "Reset",
        }
    },
    "water": {
        "reset": {
            "config": {
                "blur": 0,
                "viscosity": 6,
                "bass_size": 8,
                "background_brightness": 1,
                "speed": 1,
                "background_color": "#000000",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "brightness": 1,
                "mids_size": 6,
                "gradient_roll": 0,
                "mirror": False,
                "flip": False,
                "high_size": 3,
                "vertical_shift": 0.12,
            },
            "name": "Reset",
        }
    },
}
