"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualRouterListener = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * (experimental) Represents the properties needed to define listeners for a VirtualRouter.
 *
 * @experimental
 */
class VirtualRouterListener {
    /**
     * (experimental) Returns an HTTP Listener for a VirtualRouter.
     *
     * @param port the optional port of the listener, 8080 by default.
     * @experimental
     */
    static http(port) {
        return new VirtualRouterListenerImpl(shared_interfaces_1.Protocol.HTTP, port);
    }
    /**
     * (experimental) Returns an HTTP2 Listener for a VirtualRouter.
     *
     * @param port the optional port of the listener, 8080 by default.
     * @experimental
     */
    static http2(port) {
        return new VirtualRouterListenerImpl(shared_interfaces_1.Protocol.HTTP2, port);
    }
    /**
     * (experimental) Returns a GRPC Listener for a VirtualRouter.
     *
     * @param port the optional port of the listener, 8080 by default.
     * @experimental
     */
    static grpc(port) {
        return new VirtualRouterListenerImpl(shared_interfaces_1.Protocol.GRPC, port);
    }
    /**
     * (experimental) Returns a TCP Listener for a VirtualRouter.
     *
     * @param port the optional port of the listener, 8080 by default.
     * @experimental
     */
    static tcp(port) {
        return new VirtualRouterListenerImpl(shared_interfaces_1.Protocol.TCP, port);
    }
}
exports.VirtualRouterListener = VirtualRouterListener;
_a = JSII_RTTI_SYMBOL_1;
VirtualRouterListener[_a] = { fqn: "@aws-cdk/aws-appmesh.VirtualRouterListener", version: "1.110.0" };
class VirtualRouterListenerImpl extends VirtualRouterListener {
    constructor(protocol, port) {
        super();
        this.protocol = protocol;
        this.port = port !== null && port !== void 0 ? port : 8080;
    }
    bind(_scope) {
        return {
            listener: {
                portMapping: {
                    port: this.port,
                    protocol: this.protocol,
                },
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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