import { MutualTlsCertificate } from './tls-certificate';
import { TlsValidation } from './tls-validation';
/**
 * (experimental) Represents the properties needed to define client policy.
 *
 * @experimental
 */
export interface TlsClientPolicy {
    /**
     * (experimental) Whether the policy is enforced.
     *
     * @default true
     * @experimental
     */
    readonly enforce?: boolean;
    /**
     * (experimental) TLS is enforced on the ports specified here.
     *
     * If no ports are specified, TLS will be enforced on all the ports.
     *
     * @default - all ports
     * @experimental
     */
    readonly ports?: number[];
    /**
     * (experimental) Represents the object for TLS validation context.
     *
     * @experimental
     */
    readonly validation: TlsValidation;
    /**
     * (experimental) Represents a client TLS certificate.
     *
     * The certificate will be sent only if the server requests it, enabling mutual TLS.
     *
     * @default - client TLS certificate is not provided
     * @experimental
     */
    readonly mutualTlsCertificate?: MutualTlsCertificate;
}
