import * as acm from '@aws-cdk/aws-certificatemanager';
import { CfnVirtualNode } from './appmesh.generated';
import { Construct } from '@aws-cdk/core';
/**
 * (experimental) A wrapper for the tls config returned by {@link TlsCertificate.bind}.
 *
 * @experimental
 */
export interface TlsCertificateConfig {
    /**
     * (experimental) The CFN shape for a TLS certificate.
     *
     * @experimental
     */
    readonly tlsCertificate: CfnVirtualNode.ListenerTlsCertificateProperty;
}
/**
 * (experimental) Represents a TLS certificate.
 *
 * @experimental
 */
export declare abstract class TlsCertificate {
    /**
     * (experimental) Returns an File TLS Certificate.
     *
     * @experimental
     */
    static file(certificateChainPath: string, privateKeyPath: string): MutualTlsCertificate;
    /**
     * (experimental) Returns an ACM TLS Certificate.
     *
     * @experimental
     */
    static acm(certificate: acm.ICertificate): TlsCertificate;
    /**
     * (experimental) Returns an SDS TLS Certificate.
     *
     * @experimental
     */
    static sds(secretName: string): MutualTlsCertificate;
    /**
     * (experimental) Returns TLS certificate based provider.
     *
     * @experimental
     */
    abstract bind(_scope: Construct): TlsCertificateConfig;
}
/**
 * (experimental) Represents a TLS certificate that is supported for mutual TLS authentication.
 *
 * @experimental
 */
export declare abstract class MutualTlsCertificate extends TlsCertificate {
    /**
     * @experimental
     */
    protected readonly differentiator = false;
}
