"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderListenerTlsOptions = exports.renderTlsClientPolicy = void 0;
/**
 * This is the helper method to render TLS property of client policy.
 */
function renderTlsClientPolicy(scope, tlsClientPolicy) {
    var _a;
    const certificate = (_a = tlsClientPolicy === null || tlsClientPolicy === void 0 ? void 0 : tlsClientPolicy.mutualTlsCertificate) === null || _a === void 0 ? void 0 : _a.bind(scope).tlsCertificate;
    const sans = tlsClientPolicy === null || tlsClientPolicy === void 0 ? void 0 : tlsClientPolicy.validation.subjectAlternativeNames;
    return tlsClientPolicy
        ? {
            certificate: certificate,
            ports: tlsClientPolicy.ports,
            enforce: tlsClientPolicy.enforce,
            validation: {
                subjectAlternativeNames: sans
                    ? {
                        match: sans.bind(scope).subjectAlternativeNamesMatch,
                    }
                    : undefined,
                trust: tlsClientPolicy.validation.trust.bind(scope).tlsValidationTrust,
            },
        }
        : undefined;
}
exports.renderTlsClientPolicy = renderTlsClientPolicy;
/**
 * This is the helper method to render the TLS config for a listener.
 */
function renderListenerTlsOptions(scope, listenerTls) {
    const tlsValidation = listenerTls === null || listenerTls === void 0 ? void 0 : listenerTls.mutualTlsValidation;
    return listenerTls
        ? {
            certificate: listenerTls.certificate.bind(scope).tlsCertificate,
            mode: listenerTls.mode,
            validation: tlsValidation
                ? {
                    subjectAlternativeNames: tlsValidation.subjectAlternativeNames
                        ? {
                            match: tlsValidation.subjectAlternativeNames.bind(scope).subjectAlternativeNamesMatch,
                        }
                        : undefined,
                    trust: tlsValidation.trust.bind(scope).tlsValidationTrust,
                }
                : undefined,
        }
        : undefined;
}
exports.renderListenerTlsOptions = renderListenerTlsOptions;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ1dGlscy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFrQ0E7O0dBRUc7QUFDSCxTQUFnQixxQkFBcUIsQ0FBQyxLQUFnQixFQUFFLGVBQTRDOztJQUVsRyxNQUFNLFdBQVcsU0FBRyxlQUFlLGFBQWYsZUFBZSx1QkFBZixlQUFlLENBQUUsb0JBQW9CLDBDQUFFLElBQUksQ0FBQyxLQUFLLEVBQUUsY0FBYyxDQUFDO0lBQ3RGLE1BQU0sSUFBSSxHQUFHLGVBQWUsYUFBZixlQUFlLHVCQUFmLGVBQWUsQ0FBRSxVQUFVLENBQUMsdUJBQXVCLENBQUM7SUFFakUsT0FBTyxlQUFlO1FBQ3BCLENBQUMsQ0FBQztZQUNBLFdBQVcsRUFBRSxXQUFXO1lBQ3hCLEtBQUssRUFBRSxlQUFlLENBQUMsS0FBSztZQUM1QixPQUFPLEVBQUUsZUFBZSxDQUFDLE9BQU87WUFDaEMsVUFBVSxFQUFFO2dCQUNWLHVCQUF1QixFQUFFLElBQUk7b0JBQzNCLENBQUMsQ0FBQzt3QkFDQSxLQUFLLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyw0QkFBNEI7cUJBQ3JEO29CQUNELENBQUMsQ0FBQyxTQUFTO2dCQUNiLEtBQUssRUFBRSxlQUFlLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsa0JBQWtCO2FBQ3ZFO1NBQ0Y7UUFDRCxDQUFDLENBQUMsU0FBUyxDQUFDO0FBQ2hCLENBQUM7QUFwQkQsc0RBb0JDO0FBRUQ7O0dBRUc7QUFDSCxTQUFnQix3QkFBd0IsQ0FBQyxLQUFnQixFQUFFLFdBQTJDO0lBRXBHLE1BQU0sYUFBYSxHQUFHLFdBQVcsYUFBWCxXQUFXLHVCQUFYLFdBQVcsQ0FBRSxtQkFBbUIsQ0FBQztJQUV2RCxPQUFPLFdBQVc7UUFDaEIsQ0FBQyxDQUFDO1lBQ0EsV0FBVyxFQUFFLFdBQVcsQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLGNBQWM7WUFDL0QsSUFBSSxFQUFFLFdBQVcsQ0FBQyxJQUFJO1lBQ3RCLFVBQVUsRUFBRSxhQUFhO2dCQUN2QixDQUFDLENBQUM7b0JBQ0EsdUJBQXVCLEVBQUUsYUFBYSxDQUFDLHVCQUF1Qjt3QkFDNUQsQ0FBQyxDQUFDOzRCQUNBLEtBQUssRUFBRSxhQUFhLENBQUMsdUJBQXVCLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLDRCQUE0Qjt5QkFDdEY7d0JBQ0QsQ0FBQyxDQUFDLFNBQVM7b0JBQ2IsS0FBSyxFQUFFLGFBQWEsQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLGtCQUFrQjtpQkFDMUQ7Z0JBQ0QsQ0FBQyxDQUFDLFNBQVM7U0FDZDtRQUNELENBQUMsQ0FBQyxTQUFTLENBQUM7QUFDaEIsQ0FBQztBQXBCRCw0REFvQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDZm5WaXJ0dWFsTm9kZSB9IGZyb20gJy4uL2FwcG1lc2guZ2VuZXJhdGVkJztcbmltcG9ydCB7IExpc3RlbmVyVGxzT3B0aW9ucyB9IGZyb20gJy4uL2xpc3RlbmVyLXRscy1vcHRpb25zJztcbmltcG9ydCB7IFRsc0NsaWVudFBvbGljeSB9IGZyb20gJy4uL3Rscy1jbGllbnQtcG9saWN5JztcblxuLy8ga2VlcCB0aGlzIGltcG9ydCBzZXBhcmF0ZSBmcm9tIG90aGVyIGltcG9ydHMgdG8gcmVkdWNlIGNoYW5jZSBmb3IgbWVyZ2UgY29uZmxpY3RzIHdpdGggdjItbWFpblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIG5vLWR1cGxpY2F0ZS1pbXBvcnRzLCBpbXBvcnQvb3JkZXJcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG4vKipcbiAqIEdlbmVyYXRlZCBDb25uZWN0aW9uIHBvb2wgY29uZmlnXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ29ubmVjdGlvblBvb2xDb25maWcge1xuICAvKipcbiAgICogVGhlIG1heGltdW0gY29ubmVjdGlvbnMgaW4gdGhlIHBvb2xcbiAgICpcbiAgICogQGRlZmF1bHQgLSBub25lXG4gICAqL1xuICByZWFkb25seSBtYXhDb25uZWN0aW9ucz86IG51bWJlcjtcblxuICAvKipcbiAgICogVGhlIG1heGltdW0gcGVuZGluZyByZXF1ZXN0cyBpbiB0aGUgcG9vbFxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vbmVcbiAgICovXG4gIHJlYWRvbmx5IG1heFBlbmRpbmdSZXF1ZXN0cz86IG51bWJlcjtcblxuICAvKipcbiAgICogVGhlIG1heGltdW0gcmVxdWVzdHMgaW4gdGhlIHBvb2xcbiAgICpcbiAgICogQGRlZmF1bHQgLSBub25lXG4gICAqL1xuICByZWFkb25seSBtYXhSZXF1ZXN0cz86IG51bWJlcjtcbn1cblxuLyoqXG4gKiBUaGlzIGlzIHRoZSBoZWxwZXIgbWV0aG9kIHRvIHJlbmRlciBUTFMgcHJvcGVydHkgb2YgY2xpZW50IHBvbGljeS5cbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIHJlbmRlclRsc0NsaWVudFBvbGljeShzY29wZTogQ29uc3RydWN0LCB0bHNDbGllbnRQb2xpY3k6IFRsc0NsaWVudFBvbGljeSB8IHVuZGVmaW5lZClcbiAgOiBDZm5WaXJ0dWFsTm9kZS5DbGllbnRQb2xpY3lUbHNQcm9wZXJ0eSB8IHVuZGVmaW5lZCB7XG4gIGNvbnN0IGNlcnRpZmljYXRlID0gdGxzQ2xpZW50UG9saWN5Py5tdXR1YWxUbHNDZXJ0aWZpY2F0ZT8uYmluZChzY29wZSkudGxzQ2VydGlmaWNhdGU7XG4gIGNvbnN0IHNhbnMgPSB0bHNDbGllbnRQb2xpY3k/LnZhbGlkYXRpb24uc3ViamVjdEFsdGVybmF0aXZlTmFtZXM7XG5cbiAgcmV0dXJuIHRsc0NsaWVudFBvbGljeVxuICAgID8ge1xuICAgICAgY2VydGlmaWNhdGU6IGNlcnRpZmljYXRlLFxuICAgICAgcG9ydHM6IHRsc0NsaWVudFBvbGljeS5wb3J0cyxcbiAgICAgIGVuZm9yY2U6IHRsc0NsaWVudFBvbGljeS5lbmZvcmNlLFxuICAgICAgdmFsaWRhdGlvbjoge1xuICAgICAgICBzdWJqZWN0QWx0ZXJuYXRpdmVOYW1lczogc2Fuc1xuICAgICAgICAgID8ge1xuICAgICAgICAgICAgbWF0Y2g6IHNhbnMuYmluZChzY29wZSkuc3ViamVjdEFsdGVybmF0aXZlTmFtZXNNYXRjaCxcbiAgICAgICAgICB9XG4gICAgICAgICAgOiB1bmRlZmluZWQsXG4gICAgICAgIHRydXN0OiB0bHNDbGllbnRQb2xpY3kudmFsaWRhdGlvbi50cnVzdC5iaW5kKHNjb3BlKS50bHNWYWxpZGF0aW9uVHJ1c3QsXG4gICAgICB9LFxuICAgIH1cbiAgICA6IHVuZGVmaW5lZDtcbn1cblxuLyoqXG4gKiBUaGlzIGlzIHRoZSBoZWxwZXIgbWV0aG9kIHRvIHJlbmRlciB0aGUgVExTIGNvbmZpZyBmb3IgYSBsaXN0ZW5lci5cbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIHJlbmRlckxpc3RlbmVyVGxzT3B0aW9ucyhzY29wZTogQ29uc3RydWN0LCBsaXN0ZW5lclRsczogTGlzdGVuZXJUbHNPcHRpb25zIHwgdW5kZWZpbmVkKVxuICA6IENmblZpcnR1YWxOb2RlLkxpc3RlbmVyVGxzUHJvcGVydHkgfCB1bmRlZmluZWQge1xuICBjb25zdCB0bHNWYWxpZGF0aW9uID0gbGlzdGVuZXJUbHM/Lm11dHVhbFRsc1ZhbGlkYXRpb247XG5cbiAgcmV0dXJuIGxpc3RlbmVyVGxzXG4gICAgPyB7XG4gICAgICBjZXJ0aWZpY2F0ZTogbGlzdGVuZXJUbHMuY2VydGlmaWNhdGUuYmluZChzY29wZSkudGxzQ2VydGlmaWNhdGUsXG4gICAgICBtb2RlOiBsaXN0ZW5lclRscy5tb2RlLFxuICAgICAgdmFsaWRhdGlvbjogdGxzVmFsaWRhdGlvblxuICAgICAgICA/IHtcbiAgICAgICAgICBzdWJqZWN0QWx0ZXJuYXRpdmVOYW1lczogdGxzVmFsaWRhdGlvbi5zdWJqZWN0QWx0ZXJuYXRpdmVOYW1lc1xuICAgICAgICAgICAgPyB7XG4gICAgICAgICAgICAgIG1hdGNoOiB0bHNWYWxpZGF0aW9uLnN1YmplY3RBbHRlcm5hdGl2ZU5hbWVzLmJpbmQoc2NvcGUpLnN1YmplY3RBbHRlcm5hdGl2ZU5hbWVzTWF0Y2gsXG4gICAgICAgICAgICB9XG4gICAgICAgICAgICA6IHVuZGVmaW5lZCxcbiAgICAgICAgICB0cnVzdDogdGxzVmFsaWRhdGlvbi50cnVzdC5iaW5kKHNjb3BlKS50bHNWYWxpZGF0aW9uVHJ1c3QsXG4gICAgICAgIH1cbiAgICAgICAgOiB1bmRlZmluZWQsXG4gICAgfVxuICAgIDogdW5kZWZpbmVkO1xufVxuIl19