import { CfnVirtualNode } from '../appmesh.generated';
import { ListenerTlsOptions } from '../listener-tls-options';
import { TlsClientPolicy } from '../tls-client-policy';
import { Construct } from '@aws-cdk/core';
/**
 * Generated Connection pool config
 */
export interface ConnectionPoolConfig {
    /**
     * The maximum connections in the pool
     *
     * @default - none
     */
    readonly maxConnections?: number;
    /**
     * The maximum pending requests in the pool
     *
     * @default - none
     */
    readonly maxPendingRequests?: number;
    /**
     * The maximum requests in the pool
     *
     * @default - none
     */
    readonly maxRequests?: number;
}
/**
 * This is the helper method to render TLS property of client policy.
 */
export declare function renderTlsClientPolicy(scope: Construct, tlsClientPolicy: TlsClientPolicy | undefined): CfnVirtualNode.ClientPolicyTlsProperty | undefined;
/**
 * This is the helper method to render the TLS config for a listener.
 */
export declare function renderListenerTlsOptions(scope: Construct, listenerTls: ListenerTlsOptions | undefined): CfnVirtualNode.ListenerTlsProperty | undefined;
