import * as cdk from '@aws-cdk/core';
import { Construct } from 'constructs';
import { VirtualGateway, VirtualGatewayBaseProps } from './virtual-gateway';
import { VirtualNode, VirtualNodeBaseProps } from './virtual-node';
import { VirtualRouter, VirtualRouterBaseProps } from './virtual-router';
/**
 * (experimental) A utility enum defined for the egressFilter type property, the default of DROP_ALL, allows traffic only to other resources inside the mesh, or API calls to amazon resources.
 *
 * @default DROP_ALL
 * @experimental
 */
export declare enum MeshFilterType {
    /**
     * (experimental) Allows all outbound traffic.
     *
     * @experimental
     */
    ALLOW_ALL = "ALLOW_ALL",
    /**
     * (experimental) Allows traffic only to other resources inside the mesh, or API calls to amazon resources.
     *
     * @experimental
     */
    DROP_ALL = "DROP_ALL"
}
/**
 * (experimental) Interface which all Mesh based classes MUST implement.
 *
 * @experimental
 */
export interface IMesh extends cdk.IResource {
    /**
     * (experimental) The name of the AppMesh mesh.
     *
     * @experimental
     * @attribute true
     */
    readonly meshName: string;
    /**
     * (experimental) The Amazon Resource Name (ARN) of the AppMesh mesh.
     *
     * @experimental
     * @attribute true
     */
    readonly meshArn: string;
    /**
     * (experimental) Creates a new VirtualRouter in this Mesh.
     *
     * Note that the Router is created in the same Stack that this Mesh belongs to,
     * which might be different than the current stack.
     *
     * @experimental
     */
    addVirtualRouter(id: string, props?: VirtualRouterBaseProps): VirtualRouter;
    /**
     * (experimental) Creates a new VirtualNode in this Mesh.
     *
     * Note that the Node is created in the same Stack that this Mesh belongs to,
     * which might be different than the current stack.
     *
     * @experimental
     */
    addVirtualNode(id: string, props?: VirtualNodeBaseProps): VirtualNode;
    /**
     * (experimental) Creates a new VirtualGateway in this Mesh.
     *
     * Note that the Gateway is created in the same Stack that this Mesh belongs to,
     * which might be different than the current stack.
     *
     * @experimental
     */
    addVirtualGateway(id: string, props?: VirtualGatewayBaseProps): VirtualGateway;
}
/**
 * Represents a new or imported AppMesh mesh
 */
declare abstract class MeshBase extends cdk.Resource implements IMesh {
    /**
     * The name of the AppMesh mesh
     */
    abstract readonly meshName: string;
    /**
     * The Amazon Resource Name (ARN) of the AppMesh mesh
     */
    abstract readonly meshArn: string;
    /**
     * (experimental) Adds a VirtualRouter to the Mesh with the given id and props.
     *
     * @experimental
     */
    addVirtualRouter(id: string, props?: VirtualRouterBaseProps): VirtualRouter;
    /**
     * (experimental) Adds a VirtualNode to the Mesh.
     *
     * @experimental
     */
    addVirtualNode(id: string, props?: VirtualNodeBaseProps): VirtualNode;
    /**
     * (experimental) Adds a VirtualGateway to the Mesh.
     *
     * @experimental
     */
    addVirtualGateway(id: string, props?: VirtualGatewayBaseProps): VirtualGateway;
}
/**
 * (experimental) The set of properties used when creating a Mesh.
 *
 * @experimental
 */
export interface MeshProps {
    /**
     * (experimental) The name of the Mesh being defined.
     *
     * @default - A name is automatically generated
     * @experimental
     */
    readonly meshName?: string;
    /**
     * (experimental) Egress filter to be applied to the Mesh.
     *
     * @default DROP_ALL
     * @experimental
     */
    readonly egressFilter?: MeshFilterType;
}
/**
 * (experimental) Define a new AppMesh mesh.
 *
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/meshes.html
 * @experimental
 */
export declare class Mesh extends MeshBase {
    /**
     * (experimental) Import an existing mesh by arn.
     *
     * @experimental
     */
    static fromMeshArn(scope: Construct, id: string, meshArn: string): IMesh;
    /**
     * (experimental) Import an existing mesh by name.
     *
     * @experimental
     */
    static fromMeshName(scope: Construct, id: string, meshName: string): IMesh;
    /**
     * (experimental) The name of the AppMesh mesh.
     *
     * @experimental
     */
    readonly meshName: string;
    /**
     * (experimental) The Amazon Resource Name (ARN) of the AppMesh mesh.
     *
     * @experimental
     */
    readonly meshArn: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: MeshProps);
}
export {};
