import { TlsCertificate } from './tls-certificate';
import { MutualTlsValidation } from './tls-validation';
/**
 * (experimental) Enum of supported TLS modes.
 *
 * @experimental
 */
export declare enum TlsMode {
    /**
     * (experimental) Only accept encrypted traffic.
     *
     * @experimental
     */
    STRICT = "STRICT",
    /**
     * (experimental) Accept encrypted and plaintext traffic.
     *
     * @experimental
     */
    PERMISSIVE = "PERMISSIVE",
    /**
     * (experimental) TLS is disabled, only accept plaintext traffic.
     *
     * @experimental
     */
    DISABLED = "DISABLED"
}
/**
 * (experimental) Represents TLS properties for listener.
 *
 * @experimental
 */
export interface ListenerTlsOptions {
    /**
     * (experimental) Represents TLS certificate.
     *
     * @experimental
     */
    readonly certificate: TlsCertificate;
    /**
     * (experimental) The TLS mode.
     *
     * @experimental
     */
    readonly mode: TlsMode;
    /**
     * (experimental) Represents a listener's TLS validation context.
     *
     * The client certificate will only be validated if the client provides it, enabling mutual TLS.
     *
     * @default - client TLS certificate is not required
     * @experimental
     */
    readonly mutualTlsValidation?: MutualTlsValidation;
}
