/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.functions;

import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.FieldValues;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UndefinedResultException;
import org.jpmml.evaluator.functions.BinaryFunction;
import org.jpmml.evaluator.functions.MissingValueTolerant;

public abstract class ArithmeticFunction
extends BinaryFunction
implements MissingValueTolerant {
    public ArithmeticFunction(String name) {
        super(name);
    }

    public abstract Number evaluate(Number var1, Number var2);

    @Override
    public FieldValue evaluate(FieldValue first, FieldValue second) {
        Number result;
        if (FieldValueUtil.isMissing(first) || FieldValueUtil.isMissing(second)) {
            return FieldValues.MISSING_VALUE;
        }
        DataType dataType = TypeUtil.getCommonDataType(first.getDataType(), second.getDataType());
        try {
            result = this.evaluate(first.asNumber(), second.asNumber());
        }
        catch (ArithmeticException ae) {
            throw new UndefinedResultException().initCause(ae);
        }
        return FieldValueUtil.create(dataType, OpType.CONTINUOUS, result);
    }
}

