/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.HasExpression;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.HasType;
import org.dmg.pmml.HasValue;
import org.dmg.pmml.InvalidValueTreatmentMethod;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ParameterField;
import org.dmg.pmml.TextIndex;
import org.jpmml.evaluator.DefineFunctionEvaluationContext;
import org.jpmml.evaluator.DiscretizationUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.FieldValues;
import org.jpmml.evaluator.Function;
import org.jpmml.evaluator.FunctionRegistry;
import org.jpmml.evaluator.Functions;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.JavaExpression;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.MissingElementException;
import org.jpmml.evaluator.NormalizationUtil;
import org.jpmml.evaluator.PMMLException;
import org.jpmml.evaluator.SymbolTable;
import org.jpmml.evaluator.TextUtil;
import org.jpmml.evaluator.TypeInfos;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.UnsupportedElementException;
import org.jpmml.model.XPathUtil;

public class ExpressionUtil {
    private ExpressionUtil() {
    }

    public static <E extends Expression> FieldName ensureField(E hasField) {
        FieldName name = ((HasFieldReference)hasField).getField();
        if (name == null) {
            throw new MissingAttributeException(MissingAttributeException.formatMessage(XPathUtil.formatElement(hasField.getClass()) + "@field"), (PMMLObject)hasField);
        }
        return name;
    }

    public static <E extends PMMLObject> Expression ensureExpression(E hasExpression) {
        Expression expression = ((HasExpression)hasExpression).getExpression();
        if (expression == null) {
            throw new MissingElementException(MissingElementException.formatMessage(XPathUtil.formatElement(hasExpression.getClass()) + "/<Expression>"), hasExpression);
        }
        return expression;
    }

    public static <E extends PMMLObject> FieldValue evaluateExpressionContainer(E hasExpression, EvaluationContext context) {
        return ExpressionUtil.evaluate(ExpressionUtil.ensureExpression(hasExpression), context);
    }

    public static <E extends PMMLObject & HasExpression<E>> FieldValue evaluateTypedExpressionContainer(E hasTypedExpression, EvaluationContext context) {
        FieldValue value = ExpressionUtil.evaluateExpressionContainer(hasTypedExpression, context);
        if (FieldValueUtil.isMissing(value)) {
            return FieldValues.MISSING_VALUE;
        }
        return value.cast((HasType)hasTypedExpression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FieldValue evaluate(DerivedField derivedField, EvaluationContext context) {
        FieldName name = derivedField.getName();
        if (name == null) {
            throw new MissingAttributeException((PMMLObject)derivedField, PMMLAttributes.DERIVEDFIELD_NAME);
        }
        SymbolTable<FieldName> symbolTable = EvaluationContext.DERIVEDFIELD_GUARD_PROVIDER.get();
        if (symbolTable != null) {
            symbolTable.lock(name);
        }
        try {
            FieldValue fieldValue = ExpressionUtil.evaluateTypedExpressionContainer(derivedField, context);
            return fieldValue;
        }
        finally {
            if (symbolTable != null) {
                symbolTable.release(name);
            }
        }
    }

    public static FieldValue evaluate(DefineFunction defineFunction, List<FieldValue> values, EvaluationContext context) {
        List parameterFields = defineFunction.getParameterFields();
        if (parameterFields.size() != values.size()) {
            throw new EvaluationException("Function " + PMMLException.formatKey(defineFunction.getName()) + " expects " + parameterFields.size() + " arguments, got " + values.size() + " arguments");
        }
        DefineFunctionEvaluationContext functionContext = new DefineFunctionEvaluationContext(defineFunction, context);
        for (int i = 0; i < parameterFields.size(); ++i) {
            ParameterField parameterField = (ParameterField)parameterFields.get(i);
            FieldValue value = values.get(i);
            FieldName name = parameterField.getName();
            if (name == null) {
                throw new MissingAttributeException((PMMLObject)parameterField, PMMLAttributes.PARAMETERFIELD_NAME);
            }
            value = value.cast((HasType<?>)parameterField);
            functionContext.declare(name, value);
        }
        return ExpressionUtil.evaluateTypedExpressionContainer(defineFunction, functionContext);
    }

    public static FieldValue evaluate(Expression expression, EvaluationContext context) {
        try {
            return ExpressionUtil.evaluateExpression(expression, context);
        }
        catch (PMMLException pe) {
            throw pe.ensureContext((PMMLObject)expression);
        }
    }

    static FieldValue evaluateExpression(Expression expression, EvaluationContext context) {
        if (expression instanceof Constant) {
            return ExpressionUtil.evaluateConstant((Constant)expression);
        }
        if (expression instanceof FieldRef) {
            return ExpressionUtil.evaluateFieldRef((FieldRef)expression, context);
        }
        if (expression instanceof NormContinuous) {
            return ExpressionUtil.evaluateNormContinuous((NormContinuous)expression, context);
        }
        if (expression instanceof NormDiscrete) {
            return ExpressionUtil.evaluateNormDiscrete((NormDiscrete)expression, context);
        }
        if (expression instanceof Discretize) {
            return ExpressionUtil.evaluateDiscretize((Discretize)expression, context);
        }
        if (expression instanceof MapValues) {
            return ExpressionUtil.evaluateMapValues((MapValues)expression, context);
        }
        if (expression instanceof TextIndex) {
            return ExpressionUtil.evaluateTextIndex((TextIndex)expression, context);
        }
        if (expression instanceof Apply) {
            return ExpressionUtil.evaluateApply((Apply)expression, context);
        }
        if (expression instanceof Aggregate) {
            return ExpressionUtil.evaluateAggregate((Aggregate)expression, context);
        }
        if (expression instanceof JavaExpression) {
            return ExpressionUtil.evaluateJavaExpression((JavaExpression)expression, context);
        }
        throw new UnsupportedElementException((PMMLObject)expression);
    }

    public static FieldValue evaluateConstant(Constant constant) {
        boolean missing = constant.isMissing();
        if (missing) {
            return FieldValues.MISSING_VALUE;
        }
        Object value = constant.getValue();
        DataType dataType = constant.getDataType();
        if (dataType != null) {
            if (ExpressionUtil.isEmptyContent(value)) {
                switch (dataType) {
                    case STRING: {
                        return FieldValueUtil.create(TypeInfos.CATEGORICAL_STRING, "");
                    }
                }
                return FieldValues.MISSING_VALUE;
            }
        } else {
            if (ExpressionUtil.isEmptyContent(value)) {
                return FieldValues.MISSING_VALUE;
            }
            dataType = TypeUtil.getConstantDataType(value);
        }
        OpType opType = TypeUtil.getOpType(dataType);
        return FieldValueUtil.create(dataType, opType, value);
    }

    public static FieldValue evaluateFieldRef(FieldRef fieldRef, EvaluationContext context) {
        FieldValue value = context.evaluate(ExpressionUtil.ensureField(fieldRef));
        if (FieldValueUtil.isMissing(value)) {
            return FieldValueUtil.create(TypeInfos.CATEGORICAL_STRING, fieldRef.getMapMissingTo());
        }
        return value;
    }

    public static FieldValue evaluateNormContinuous(NormContinuous normContinuous, EvaluationContext context) {
        FieldValue value = context.evaluate(ExpressionUtil.ensureField(normContinuous));
        if (FieldValueUtil.isMissing(value)) {
            return FieldValueUtil.create(TypeInfos.CONTINUOUS_DOUBLE, normContinuous.getMapMissingTo());
        }
        return NormalizationUtil.normalize(normContinuous, value);
    }

    public static FieldValue evaluateNormDiscrete(NormDiscrete normDiscrete, EvaluationContext context) {
        FieldValue value = context.evaluate(ExpressionUtil.ensureField(normDiscrete));
        if (FieldValueUtil.isMissing(value)) {
            return FieldValueUtil.create(TypeInfos.CATEGORICAL_DOUBLE, normDiscrete.getMapMissingTo());
        }
        NormDiscrete.Method method = normDiscrete.getMethod();
        switch (method) {
            case INDICATOR: {
                boolean equals = value.equals((HasValue<?>)normDiscrete);
                return equals ? FieldValues.CATEGORICAL_DOUBLE_ONE : FieldValues.CATEGORICAL_DOUBLE_ZERO;
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)normDiscrete, (Enum<?>)method);
    }

    public static FieldValue evaluateDiscretize(Discretize discretize, EvaluationContext context) {
        FieldValue value = context.evaluate(ExpressionUtil.ensureField(discretize));
        if (FieldValueUtil.isMissing(value)) {
            return FieldValueUtil.create(discretize.getDataType(DataType.STRING), OpType.CATEGORICAL, discretize.getMapMissingTo());
        }
        return DiscretizationUtil.discretize(discretize, value);
    }

    public static FieldValue evaluateMapValues(MapValues mapValues, EvaluationContext context) {
        LinkedHashMap<String, FieldValue> values = new LinkedHashMap<String, FieldValue>();
        List fieldColumnPairs = mapValues.getFieldColumnPairs();
        for (FieldColumnPair fieldColumnPair : fieldColumnPairs) {
            FieldName name = fieldColumnPair.getField();
            if (name == null) {
                throw new MissingAttributeException((PMMLObject)fieldColumnPair, PMMLAttributes.FIELDCOLUMNPAIR_FIELD);
            }
            String column = fieldColumnPair.getColumn();
            if (column == null) {
                throw new MissingAttributeException((PMMLObject)fieldColumnPair, PMMLAttributes.FIELDCOLUMNPAIR_COLUMN);
            }
            FieldValue value = context.evaluate(name);
            if (FieldValueUtil.isMissing(value)) {
                return FieldValueUtil.create(mapValues.getDataType(DataType.STRING), OpType.CATEGORICAL, mapValues.getMapMissingTo());
            }
            values.put(column, value);
        }
        return DiscretizationUtil.mapValue(mapValues, values);
    }

    public static FieldValue evaluateTextIndex(TextIndex textIndex, EvaluationContext context) {
        FieldName textName = textIndex.getTextField();
        if (textName == null) {
            throw new MissingAttributeException((PMMLObject)textIndex, PMMLAttributes.TEXTINDEX_TEXTFIELD);
        }
        FieldValue textValue = context.evaluate(textName);
        FieldValue termValue = ExpressionUtil.evaluateExpressionContainer(textIndex, context);
        if (FieldValueUtil.isMissing(textValue) || FieldValueUtil.isMissing(termValue)) {
            return FieldValues.MISSING_VALUE;
        }
        TextUtil.TextProcessor textProcessor = new TextUtil.TextProcessor(textIndex, textValue.asString());
        List<String> textTokens = textProcessor.process();
        TextUtil.TermProcessor termProcessor = new TextUtil.TermProcessor(textIndex, termValue.asString());
        List<String> termTokens = termProcessor.process();
        int termFrequency = TextUtil.termFrequency(textIndex, textTokens, termTokens);
        TextIndex.LocalTermWeights localTermWeights = textIndex.getLocalTermWeights();
        switch (localTermWeights) {
            case BINARY: 
            case TERM_FREQUENCY: {
                return FieldValueUtil.create(TypeInfos.CONTINUOUS_INTEGER, termFrequency);
            }
            case LOGARITHMIC: {
                return FieldValueUtil.create(TypeInfos.CONTINUOUS_DOUBLE, Math.log10(1.0 + (double)termFrequency));
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)textIndex, (Enum<?>)localTermWeights);
    }

    public static FieldValue evaluateApply(Apply apply, EvaluationContext context) {
        FieldValue result;
        String mapMissingTo = apply.getMapMissingTo();
        List expressions = apply.getExpressions();
        ArrayList<FieldValue> values = new ArrayList<FieldValue>(expressions.size());
        Iterator arguments = expressions.iterator();
        String function = apply.getFunction();
        if (function == null) {
            throw new MissingAttributeException((PMMLObject)apply, PMMLAttributes.APPLY_FUNCTION);
        }
        if ("if".equals(function) && arguments.hasNext()) {
            FieldValue flag = ExpressionUtil.evaluate((Expression)arguments.next(), context);
            if (flag == null && mapMissingTo != null) {
                return FieldValueUtil.create(TypeInfos.CATEGORICAL_STRING, mapMissingTo);
            }
            values.add(flag);
            if (flag == null) {
                if (arguments.hasNext()) {
                    arguments.next();
                    values.add(FieldValues.MISSING_VALUE);
                    if (arguments.hasNext()) {
                        arguments.next();
                        values.add(FieldValues.MISSING_VALUE);
                    }
                }
            } else if (flag.asBoolean().booleanValue()) {
                if (arguments.hasNext()) {
                    FieldValue trueValue = ExpressionUtil.evaluate((Expression)arguments.next(), context);
                    if (FieldValueUtil.isMissing(trueValue) && mapMissingTo != null) {
                        return FieldValueUtil.create(TypeInfos.CATEGORICAL_STRING, mapMissingTo);
                    }
                    values.add(trueValue);
                    if (arguments.hasNext()) {
                        arguments.next();
                        values.add(FieldValues.MISSING_VALUE);
                    }
                }
            } else if (arguments.hasNext()) {
                arguments.next();
                values.add(FieldValues.MISSING_VALUE);
                if (arguments.hasNext()) {
                    FieldValue falseValue = ExpressionUtil.evaluate((Expression)arguments.next(), context);
                    if (FieldValueUtil.isMissing(falseValue) && mapMissingTo != null) {
                        return FieldValueUtil.create(TypeInfos.CATEGORICAL_STRING, mapMissingTo);
                    }
                    values.add(falseValue);
                }
            }
        }
        while (arguments.hasNext()) {
            FieldValue value = ExpressionUtil.evaluate((Expression)arguments.next(), context);
            if (FieldValueUtil.isMissing(value) && mapMissingTo != null) {
                return FieldValueUtil.create(TypeInfos.CATEGORICAL_STRING, mapMissingTo);
            }
            values.add(value);
        }
        String defaultValue = apply.getDefaultValue();
        SymbolTable<String> symbolTable = EvaluationContext.FUNCTION_GUARD_PROVIDER.get();
        if (symbolTable != null) {
            symbolTable.lock(function);
        }
        try {
            result = ExpressionUtil.evaluateFunction(function, values, context);
        }
        catch (InvalidResultException ire) {
            InvalidValueTreatmentMethod invalidValueTreatmentMethod = apply.getInvalidValueTreatment();
            switch (invalidValueTreatmentMethod) {
                case RETURN_INVALID: {
                    throw new InvalidResultException("Function application yielded an invalid result", (PMMLObject)apply).initCause(ire);
                }
                case AS_IS: {
                    throw ire;
                }
                case AS_MISSING: {
                    FieldValue fieldValue = FieldValueUtil.create(TypeInfos.CATEGORICAL_STRING, defaultValue);
                    return fieldValue;
                }
            }
            throw new UnsupportedAttributeException((PMMLObject)apply, (Enum<?>)invalidValueTreatmentMethod);
        }
        finally {
            if (symbolTable != null) {
                symbolTable.release(function);
            }
        }
        if (result == null && defaultValue != null) {
            return FieldValueUtil.create(TypeInfos.CATEGORICAL_STRING, defaultValue);
        }
        return result;
    }

    private static FieldValue evaluateFunction(String name, List<FieldValue> values, EvaluationContext context) {
        Function function = FunctionRegistry.getFunction(name);
        if (function != null) {
            return function.evaluate(values);
        }
        DefineFunction defineFunction = context.getDefineFunction(name);
        if (defineFunction != null) {
            return ExpressionUtil.evaluate(defineFunction, values, context);
        }
        throw new EvaluationException("Function " + PMMLException.formatKey(name) + " is not defined");
    }

    public static FieldValue evaluateAggregate(Aggregate aggregate, EvaluationContext context) {
        FieldValue value = context.evaluate(ExpressionUtil.ensureField(aggregate));
        if (FieldValueUtil.isMissing(value)) {
            return FieldValues.MISSING_VALUE;
        }
        Collection<?> objects = value.asCollection();
        FieldName groupName = aggregate.getGroupField();
        if (groupName != null) {
            FieldValue groupValue = context.evaluate(groupName);
            TypeUtil.getDataType(FieldValueUtil.getValue(groupValue));
        }
        ArrayList<FieldValue> values = new ArrayList<FieldValue>(objects.size());
        for (Object object : objects) {
            if (FieldValueUtil.isMissing(object)) continue;
            values.add(FieldValueUtil.create(value, object));
        }
        Aggregate.Function function = aggregate.getFunction();
        if (function == null) {
            throw new MissingAttributeException((PMMLObject)aggregate, PMMLAttributes.AGGREGATE_FUNCTION);
        }
        switch (function) {
            case COUNT: {
                return FieldValueUtil.create(TypeInfos.CONTINUOUS_INTEGER, values.size());
            }
            case SUM: {
                return Functions.SUM.evaluate(values);
            }
            case AVERAGE: {
                return Functions.AVG.evaluate(values);
            }
            case MIN: {
                return (FieldValue)Collections.min(values);
            }
            case MAX: {
                return (FieldValue)Collections.max(values);
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)aggregate, (Enum<?>)function);
    }

    public static FieldValue evaluateJavaExpression(JavaExpression javaExpression, EvaluationContext context) {
        FieldValue value = javaExpression.evaluate(context);
        return value;
    }

    public static boolean isEmptyContent(Object value) {
        return value == null || "".equals(value);
    }
}

