
<img src="https://uploads-ssl.webflow.com/616e87dbb58bda5ac7435eb0/616ead050b8ac6154ca472a6_aeda-logo-web.svg" alt="mypic" style="width:600px; height:200px"/>

![PyPi](https://img.shields.io/pypi/v/aeda?label=pypi%20package)

# Aeda API 
An Aeda service for getting detailed info for cars using registration number.

# Getting Started
## 1.	Installation process
Install from PyPi using:
```console
python -m pip install aeda
```

Add global variables

```
AEDA_API_CAR_USER
``` 

and 

```
AEDA_API_CAR_PASSWORD
``` 

### Ubuntu

```console
export AEDA_API_CAR_USER=$(yq -r '.aeda.api.car.user' ~/.secrets/aeda.yaml)
```

Where `~/.secrets/aeda.yaml` is a YAML file containing
```
aeda:
        api:
                car:
                        user: XXXXXXXX
                        password: XXXXXXXXXXXXXX
```

Remember to install yq with
```console
apt install yq
```

## 2. Usage
Run either using command line or as a python library.


### Command line
Run from command line using:
```console
python -m aeda.car.main --regnumber XXXXXXXXX
``` 
Run in a python script using:
```python
import aeda.car
aeda.car.get_car_from_reg_number("XXXXXXXXX")
``` 


## 2.	API references



- 
- version "2022.12.1"