# Module 1: Data Wrangling with Python

## Sprint 1: Python Mastery

### Part 5: Calculator

[Install package from test-pypi]( https://test-files.pythonhosted.org/packages/8f/63/6312442a9785e7aa2d54f502f3042f2e06378749dd773097e669ed9d19bb/calculator_package_gusaezg-0.0.1-py3-none-any.whl)

The following project consists of a calculator written with Python. It contains a Calculator class. This class has an
internal memory, whose initial value is 0, and can perform a number of operations, which will modify the value in
memory:

- Add a value to the value stored in memory
- Subtract a value to the value stored in memory
- Multiply a value by the value stored in memory
- Divide the value stored in memory by another value
- Calculate the nth root of the value stored in memory
- Reset the value stored in memory to 0

Since all operations (except resetting the value in memory) require an argument, two assertions have been included in
order to make sure a valid argument is passed:
- For all operations, the argument passed must be a number (either an int or a float). Otherwise, an AssertionError will
be raised
- Furthermore, to calculate the nth root of the value in memory, the argument passed cannot be 0. This is to prevent 
division by 0 (since the nth root of a number is equal to said number raised to the 1/nth power)

Here is a practical example of how the application works

```python
# Package import
import Calculator
#An instance of Calculator is created.
# Value in memory is 0 (calculator.memory == 0)
calculator = Calculator()
# 10 is added to calculator.memory
calculator.add(10) # return 10
# 5 is subtracted to calculator.memory
calculator.subtract(5) # return 5
# 4 is multiplied by calculator.memory
calculator.multiply(4) # return 20
# calculator.memory is divided by 5
calculator.divide(5) # return 4
# the square root of calculator.memory is calculated
calculator.calculate_nth_root(2) # return 2
# calculator memory is set to 0
calculator.reset_memory()
# get memory
calculator.memory # return 0
```

In order to make sure the application works properly, unit tests have been written for all operations and assertions. 
unittest has been imported for this purpose.



