nostrfastr
================

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

### What is this?

- This package attempts to be a well documented and tested instance of a
  very basic client framework in nostr that can help others understand
  nostr quickly or get started sending messages in minutes.
- Contained is a collection of tools built on top of this basic
  [`Client`](https://armstrys.github.io/nostrfastr/client.html#client)
  class showing some potential uses of nostr any how quickly we can
  build on it in python.
  - A “sentinel” node that serves as a barebones client to rebroadcast
    user data across additional nostr relays. While this is a relatively
    simple concept I haven’t seen much discussion around the potential
    benefits and implications.
  - `notifyr` - a decorator that will alert on success or failure of any
    decorated function via nostr DM
  - a vanity address generator decorated with the notifyr function so
    you can leave it running and get notified when it finishes

### Why nbdev?

This library uses the [nbdev](https://nbdev.fast.ai/) framework to
aggregate some useful tools from
[python-nostr](https://github.com/jeffthibault/python-nostr) into a more
structured `client` class that could serve as the basis for other python
tools. `nbdev` is great because it allows for relatively easy
development of code in-line with readable and explanatory documentation.
This webpage is a rendering of the same notebooks that are exported to
form the package code. If you clone the Github repository you can view
and run the code you see in the documentation. It will almost certainly
not be the most perfomant way to implement much of what I am doing here,
but I hope it can make the
[nostr](https://github.com/nostr-protocol/nostr) protocol more
accessible to a wider audience.

### Known issues

- [`notifyr`](https://armstrys.github.io/nostrfastr/notifyr.html#notifyr) -
  see the
  [`notifyr`](https://armstrys.github.io/nostrfastr/notifyr.html#notifyr)
  page for more detail on these issues
  - `keyring` may need uninstalled dependencies on linux builds
  - Current spec of nostr DMs is likely not adequate for secure usage of
    this module for sensitive data.

## Install

``` sh
pip install nostrfastr
```

or alternatively, clone the github repositor [and refer to this
guide](https://nbdev.fast.ai/tutorials/tutorial.html) to get started
working in nbdev.

## How to use

Documentation can be found at https://armstrys.github.io/nostrfastr/

``` python
from nostrfastr.client import Client
```

Connect and perform an operation…

``` python
with Client(relay_urls=['wss://relay.damus.io']) as client:
    print('Are we connected?')
    print('\t', client.relay_manager.connection_statuses)
print('Are we connected?')
print('\t', client.relay_manager.connection_statuses)
```

    Are we connected?
         {'wss://relay.damus.io': True}
    Are we connected?
         {'wss://relay.damus.io': False}

And use the client to build something useful with nostr - like a bot
that notifies you of your python processing status on long code runs

``` python
from nostrfastr.notifyr import notifyr
```

``` python
@notifyr
def raise_error():
    raise Exception('Oh no! Process failed!')

@notifyr
def success():
    return 1+1
```

Or generate an vanity address and have it notify you at another nostr
address when it’s done

``` python
from nostrfastr.vanity import vanity_notifyr

private_key = vanity_notifyr(startswith='23', style='npub')
print(private_key.public_key.bech32())
```

    /Users/ryanarmstrong/python/nostrfastr/nostrfastr/client.py:479: UserWarning: the current implementation of messages should be used with caution
                        see https://github.com/nostr-protocol/nips/issues/107
      warnings.warn('''the current implementation of messages should be used with caution

    It might take 0 seconds to find a npub pubkey that starts with npub123. Note that this is a very rough estimate and due to the random nature of finding vanity keys it could take MUCH longer.
    npub1237z2shf8rlgs8xqg0cggz7dhxjtkszy205wesht2xr3nat86m7s30lqw5
