# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['aiotense',
 'aiotense.adapters',
 'aiotense.application',
 'aiotense.application.ports',
 'aiotense.domain',
 'aiotense.service_layer',
 'aiotense.service_layer.dot_tense']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'aiotense',
    'version': '0.0.3a0',
    'description': 'Time Processing Tool',
    'long_description': '<div id="top"></div>\nProject: aiotense\n<br>\nLicense: Apache 2.0\n<br>\nAbout: Time Processing Tool\n<br>\nOS: Independent\n<br>\nPython: 3.9+\n<br>\nTyping: Typed\n<br>\nTopic: Utilities\n<br />\n    <p align="center">\n    <br />\n    <a href="https://animatea.github.io/aiotense/">Documentation</a>\n    ·\n    <a href="https://github.com/Animatea/aiotense/issues">Report Bug</a>\n    ·\n    <a href="https://github.com/Animatea/aiotense/issues">Request Feature</a>\n    </p>\n<div id="top"></div>\n<p align="center">\n   <a href="i18n/ua_README.md"><img height="20" src="https://img.shields.io/badge/language-ua-green?style=social&logo=googletranslate"></a>\n   <a href="i18n/ru_README.md"><img height="20" src="https://img.shields.io/badge/language-ru-green?style=social&logo=googletranslate"></a>\n</p>\n<details>\n  <summary>Table of Contents</summary>\n  <ol>\n    <li>\n      <a href="#about-the-project">About The Project</a>\n      <ul>\n        <li><a href="#welcome">Welcome</a></li>\n      </ul>\n    </li>\n    <li>\n      <a href="#getting-started">Getting Started</a>\n      <ul>\n        <li><a href="#with-pypi">With PyPi</a></li>\n        <li><a href="#with-poetry">With Poetry</a></li>\n      </ul>\n    </li>\n    <li>\n      <a href="#usage">Usage</a>\n      <ul>\n        <li><a href="#built-in-basic">Built-in basics</a></li>\n        <li><a href="#reconfiguring-existing-settings">Reconfiguring existing settings</a></li>\n        <li><a href="#adding-new-settings">Adding new settings</a></li>\n        <li><a href="#faq">FAQ</a></li>\n      </ul>\n    </li>\n    <li><a href="#examples">Examples</a></li>\n    <li><a href="#contributing">Contributing</a></li>\n    <li><a href="#license">License</a></li>\n    <li><a href="#contact">Contact</a></li>\n    <li><a href="#acknowledgments">Acknowledgments</a></li>\n  </ol>\n</details>\n\n## About The Project\n<a href="https://circleci.com/gh/Animatea/aiotense/tree/main"><img height="20" src="https://circleci.com/gh/Animatea/aiotense/tree/main.svg?style=svg&circle-token=066eb74fc70db6eeaa6df5ade9e3d2df131b1de1"></a>\n<a href="https://pypi.org/project/aiotense/"><img height="20" alt="PyPi" src="https://img.shields.io/pypi/v/aiotense"></a>\n<a href="https://pypi.org/project/mypy/"><img height="20" alt="Mypy badge" src="http://www.mypy-lang.org/static/mypy_badge.svg"></a>\n<a href="https://github.com/psf/black"><img height="20" alt="Black" src="https://img.shields.io/badge/code%20style-black-000000.svg"></a>\n<a href="https://pycqa.github.io/isort/"><img height="20" alt="Supported python versions" src="https://img.shields.io/badge/%20imports-isort-%231674b1?style=flat&labelColor=ef8336">\n\n### Welcome\n> Have you ever needed to convert, for example, the string "1d1minute 2 sec" \nto the number of seconds or a datetime.timedelta object?\n\nNo? Then advise us to your friends :) And if you really need our tool - let\'s move on!\n\n<p align="right"><a href="#top"><img height="20" src="https://img.shields.io/badge/back_to-top-green?style=social&logo=github"></a></p>\n\n## Getting started\n### With PyPi\n```bash\n$ pip3 install aiotense\n```\n\n### With Poetry\n```bash\n$ poetry add aiotense\n```\n<p align="right"><a href="#top"><img height="20" src="https://img.shields.io/badge/back_to-top-green?style=social&logo=github"></a></p>\n\n## Usage\n### Built-in basic\n```py\nimport asyncio\nimport datetime\nfrom aiotense import TenseParser\n\ntime_string = "1d2minutes 5 sec"\n\n# <-- Digit parser -->\ndigit_parser = TenseParser(TenseParser.DIGIT)\ndigit_value = asyncio.run(digit_parser.parse(time_string))\n# <-- Assertions -->\nassert digit_value == 86525\n\n# <-- Timedelta parser -->\ndelta_parser = TenseParser(TenseParser.TIMEDELTA)\ndelta_value = asyncio.run(delta_parser.parse(time_string))\n# <-- Assertions -->\nassert isinstance(delta_value, datetime.timedelta)\nassert str(delta_value) == "1 day, 0:02:05"\n```\n<p align="right"><a href="#top"><img height="20" src="https://img.shields.io/badge/back_to-top-green?style=social&logo=github"></a></p>\n\n### Reconfiguring existing settings\n```py\nimport asyncio\nfrom aiotense import TenseParser, from_tense_file_source\n\nconfig_emulation = """\n[model.Tense]\nmultiplier = 2  # each unit of time will be multiplied by 2\n# !!! Note: If the multiplier is <= 0, then the parsers will \n# not work correctly. In this case, a warning will be sent to the console.\n\n[units.Minute]\nduration = 120  # Why not?...\naliases = my_minute, my_minutes, my_min, my_mins\n"""\nparser = TenseParser(\n    TenseParser.TIMEDELTA,\n    config=from_tense_file_source(config_emulation),\n)\ndelta_value = asyncio.run(parser.parse("1 my_min 10my_mins 9  my_minutes"))\n# <-- Assertions -->\nassert str(delta_value) ==  "1:20:00" # (each 120 * 2)\n```\n<p align="right"><a href="#top"><img height="20" src="https://img.shields.io/badge/back_to-top-green?style=social&logo=github"></a></p>\n\n### Adding new settings\n```py\nimport asyncio\nfrom aiotense import TenseParser, from_tense_file_source\n\nconfig_emulation = """\n[model.Tense]  # This header is required.\n\n[virtual]\nduration = exp(year * 10)\naliases = decade, dec, decs, decades\n"""\n\nparser = TenseParser(\n    TenseParser.TIMEDELTA,\n    config=from_tense_file_source(config_emulation),\n)\ndelta_value = asyncio.run(parser.parse("1year 10 decades5   seconds"))\n# <-- Assertions -->\nassert str(delta_value) == "36865 days, 0:00:05"\n```\n<p align="right"><a href="#top"><img height="20" src="https://img.shields.io/badge/back_to-top-green?style=social&logo=github"></a></p>\n\n### FAQ\nBut what if you need to parse a string like: "1day and 10 minutes + 5 seconds"?\nLet\'s see:\n```py\n>>> import asyncio\n>>> from aiotense import TenseParser\n\n>>> complex_string = "1day and 10 minutes + 5 seconds"\n\n>>> parser = TenseParser(TenseParser.TIMEDELTA)\n>>> asyncio.run(parser.parse(complex_string))\n\'0:00:05\'\n```\nWait... What? 5 second? But there are days and minutes...\n- It\'s okay, you\'re using flexible aiotense! This problem is solved in two ways:\n  1) You write your own time_resolver and pass it\n  2) Choose an existing one from aiotense.resolvers\n\nLet\'s demonstrate!\nI will use the second option, since the built-in time resolvers in aiotense are suitable for me.\n```py\n>>> import asyncio\n>>> from aiotense import TenseParser, resolvers\n\n>>> complex_string = "1day and 10 minutes + 5 seconds"\n\n>>> parser = TenseParser(TenseParser.TIMEDELTA, time_resolver=resolvers.smart_resolver)\n>>> asyncio.run(parser.parse(complex_string)) \n\'1 day, 0:10:05\'\n```\nWell, that\'s better!\n\n**aiotense.application.resolvers.smart_resolver()** is also case insensitive!\n```py\n>>> import asyncio\n>>> from aiotense import TenseParser, resolvers\n\n>>> complex_string = "1DAY and 10 MINUTES + 5 SECONDS"\n\n>>> parser = TenseParser(TenseParser.TIMEDELTA, time_resolver=resolvers.smart_resolver)\n>>> asyncio.run(parser.parse(complex_string)) \n\'1 day, 0:10:05\'\n```\n\n<p align="right"><a href="#top"><img height="20" src="https://img.shields.io/badge/back_to-top-green?style=social&logo=github"></a></p>\n\n## Examples.\nIf you think that this is where the possibilities of aiotense ends, then you are wrong! \nThe possibilities of aiotense are too many for a README, so I suggest you move on to viewing \nthe usage examples here:\n<p align="center">\n<br />\n<a href="https://github.com/Animatea/aiotense/tree/main/examples">Aiotense Examples</a>\n</p>\n<p align="right"><a href="#top"><img height="20" src="https://img.shields.io/badge/back_to-top-green?style=social&logo=github"></a></p>\n\n## Contributing\n\nContributions are what make the open source community such an amazing place to learn, inspire, and create. Any contributions you make are **greatly appreciated**.\n\nIf you have a suggestion that would make this better, please fork the repo and create a pull request. You can also simply open an issue with the tag "enhancement".\nDon\'t forget to give the project a star! Thanks again!\n\n1. Fork the Project\n2. Create your Feature Branch (`git checkout -b feature/AmazingFeature`)\n3. Commit your Changes (`git commit -m \'Add some AmazingFeature\'`)\n4. Push to the Branch (`git push origin feature/AmazingFeature`)\n5. Open a Pull Request\n<p align="right"><a href="#top"><img height="20" src="https://img.shields.io/badge/back_to-top-green?style=social&logo=github"></a></p>\n\n<!-- LICENSE -->\n## License\n\nDistributed under the Apache 2.0 License. See [`LICENSE`](https://github.com/Animatea/aiotense/blob/main/LICENSE) for more information.\n\n<p align="right"><a href="#top"><img height="20" src="https://img.shields.io/badge/back_to-top-green?style=social&logo=github"></a></p>\n\n\n<!-- CONTACT -->\n## Contact\n<div align="left">\n    <a href="https://discord.com/invite/KKUFRZCt4f"><img src="https://discordapp.com/api/guilds/744099317836677161/widget.png?style=banner4" alt="" /></a>\n</div>\n\n<p align="right"><a href="#top"><img height="20" src="https://img.shields.io/badge/back_to-top-green?style=social&logo=github"></a></p>\n\n\n## Acknowledgments\n* [Choose an Open Source License](https://choosealicense.com)\n* [Img Shields](https://shields.io)\n* [GitHub Pages](https://pages.github.com)\n* [Python](https://www.python.org)\n* [Python Community](https://www.python.org/community/)\n* [MkDocs](https://www.mkdocs.org)\n* [MkDocs Material](https://squidfunk.github.io/mkdocs-material/)\n\n<p align="right"><a href="#top"><img height="20" src="https://img.shields.io/badge/back_to-top-green?style=social&logo=github"></a></p>\n',
    'author': 'Animatea',
    'author_email': 'animatea.programming@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/Animatea/aiotense',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
