# auto generated by update_py.py
import os

from tlclient.trader.constant import USER_RSA_KEY_DIR


class KeyHelper(object):

    @staticmethod
    def get_key_paths(key_name):
        key_dir = USER_RSA_KEY_DIR
        private_key_path = os.path.join(key_dir, key_name)
        public_key_path = os.path.join(key_dir, key_name + '.pub')

        return private_key_path, public_key_path

    @staticmethod
    def key_exists(key_name):
        private_key_path, public_key_path = KeyHelper.get_key_paths(key_name)
        return os.path.exists(private_key_path) or os.path.exists(public_key_path)

    @staticmethod
    def write_key_to_file(key, path):
        with open(path, 'wb') as f:
            f.write(key)

    @staticmethod
    def get_existed_key_names(path=USER_RSA_KEY_DIR):
        key_names = set()
        paths = os.listdir(path)
        for p in paths:
            if p.endswith('.pub'):
                key_names.add(p.split('.pub')[0])

        return key_names
