# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2020-07-23 16:06
from __future__ import unicode_literals

from django.db import migrations
from django.db.utils import OperationalError

import kolibri.core.fields


def migrate_collection_ids(apps, schema_editor):
    try:
        LearnerProgressNotification = apps.get_model(
            "notifications", "LearnerProgressNotification"
        )
        LearnerGroup = apps.get_model("kolibriauth", "LearnerGroup")
        AdHocGroup = apps.get_model("kolibriauth", "AdHocGroup")
        LearnerGroupMap = {
            g["id"]: g["parent_id"]
            for g in LearnerGroup.objects.all().values("id", "parent_id")
        }
        AdHocGroupMap = {
            g["id"]: g["parent_id"]
            for g in AdHocGroup.objects.all().values("id", "parent_id")
        }

        for notification in LearnerProgressNotification.objects.all():
            collection_id = notification.classroom_id
            if collection_id in LearnerGroupMap:
                notification.classroom_id = LearnerGroupMap[collection_id]
            if collection_id in AdHocGroupMap:
                notification.classroom_id = AdHocGroupMap[collection_id]
            notification.assignment_collections = [collection_id]
            notification.save()
    except OperationalError:
        # Can get an error if the collections table doesn't exist yet
        # in which case we can't do any data migrations at all, so just skip
        pass


class Migration(migrations.Migration):

    dependencies = [
        ("notifications", "0004_learnerprogressnotification_quiz_num_answered"),
    ]

    operations = [
        migrations.AddField(
            model_name="learnerprogressnotification",
            name="assignment_collections",
            field=kolibri.core.fields.JSONField(default=[], null=True),
        ),
        migrations.RunPython(migrate_collection_ids),
    ]
