"""
    OpenAPI definition

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: v0
    Contact: support@gooddata.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from gooddata_api_client.api_client import ApiClient, Endpoint as _Endpoint
from gooddata_api_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from gooddata_api_client.model.json_api_analytical_dashboard_in_document import JsonApiAnalyticalDashboardInDocument
from gooddata_api_client.model.json_api_analytical_dashboard_out_document import JsonApiAnalyticalDashboardOutDocument
from gooddata_api_client.model.json_api_analytical_dashboard_out_list import JsonApiAnalyticalDashboardOutList
from gooddata_api_client.model.json_api_analytical_dashboard_patch_document import JsonApiAnalyticalDashboardPatchDocument
from gooddata_api_client.model.json_api_analytical_dashboard_post_optional_id_document import JsonApiAnalyticalDashboardPostOptionalIdDocument
from gooddata_api_client.model.json_api_attribute_hierarchy_in_document import JsonApiAttributeHierarchyInDocument
from gooddata_api_client.model.json_api_attribute_hierarchy_out_document import JsonApiAttributeHierarchyOutDocument
from gooddata_api_client.model.json_api_attribute_hierarchy_out_list import JsonApiAttributeHierarchyOutList
from gooddata_api_client.model.json_api_attribute_hierarchy_patch_document import JsonApiAttributeHierarchyPatchDocument
from gooddata_api_client.model.json_api_attribute_out_document import JsonApiAttributeOutDocument
from gooddata_api_client.model.json_api_attribute_out_list import JsonApiAttributeOutList
from gooddata_api_client.model.json_api_automation_in_document import JsonApiAutomationInDocument
from gooddata_api_client.model.json_api_automation_out_document import JsonApiAutomationOutDocument
from gooddata_api_client.model.json_api_automation_out_list import JsonApiAutomationOutList
from gooddata_api_client.model.json_api_automation_patch_document import JsonApiAutomationPatchDocument
from gooddata_api_client.model.json_api_custom_application_setting_in_document import JsonApiCustomApplicationSettingInDocument
from gooddata_api_client.model.json_api_custom_application_setting_out_document import JsonApiCustomApplicationSettingOutDocument
from gooddata_api_client.model.json_api_custom_application_setting_out_list import JsonApiCustomApplicationSettingOutList
from gooddata_api_client.model.json_api_custom_application_setting_patch_document import JsonApiCustomApplicationSettingPatchDocument
from gooddata_api_client.model.json_api_custom_application_setting_post_optional_id_document import JsonApiCustomApplicationSettingPostOptionalIdDocument
from gooddata_api_client.model.json_api_dashboard_plugin_in_document import JsonApiDashboardPluginInDocument
from gooddata_api_client.model.json_api_dashboard_plugin_out_document import JsonApiDashboardPluginOutDocument
from gooddata_api_client.model.json_api_dashboard_plugin_out_list import JsonApiDashboardPluginOutList
from gooddata_api_client.model.json_api_dashboard_plugin_patch_document import JsonApiDashboardPluginPatchDocument
from gooddata_api_client.model.json_api_dashboard_plugin_post_optional_id_document import JsonApiDashboardPluginPostOptionalIdDocument
from gooddata_api_client.model.json_api_dataset_out_document import JsonApiDatasetOutDocument
from gooddata_api_client.model.json_api_dataset_out_list import JsonApiDatasetOutList
from gooddata_api_client.model.json_api_export_definition_in_document import JsonApiExportDefinitionInDocument
from gooddata_api_client.model.json_api_export_definition_out_document import JsonApiExportDefinitionOutDocument
from gooddata_api_client.model.json_api_export_definition_out_list import JsonApiExportDefinitionOutList
from gooddata_api_client.model.json_api_export_definition_patch_document import JsonApiExportDefinitionPatchDocument
from gooddata_api_client.model.json_api_export_definition_post_optional_id_document import JsonApiExportDefinitionPostOptionalIdDocument
from gooddata_api_client.model.json_api_fact_out_document import JsonApiFactOutDocument
from gooddata_api_client.model.json_api_fact_out_list import JsonApiFactOutList
from gooddata_api_client.model.json_api_filter_context_in_document import JsonApiFilterContextInDocument
from gooddata_api_client.model.json_api_filter_context_out_document import JsonApiFilterContextOutDocument
from gooddata_api_client.model.json_api_filter_context_out_list import JsonApiFilterContextOutList
from gooddata_api_client.model.json_api_filter_context_patch_document import JsonApiFilterContextPatchDocument
from gooddata_api_client.model.json_api_filter_context_post_optional_id_document import JsonApiFilterContextPostOptionalIdDocument
from gooddata_api_client.model.json_api_filter_view_in_document import JsonApiFilterViewInDocument
from gooddata_api_client.model.json_api_filter_view_out_document import JsonApiFilterViewOutDocument
from gooddata_api_client.model.json_api_filter_view_out_list import JsonApiFilterViewOutList
from gooddata_api_client.model.json_api_filter_view_patch_document import JsonApiFilterViewPatchDocument
from gooddata_api_client.model.json_api_label_out_document import JsonApiLabelOutDocument
from gooddata_api_client.model.json_api_label_out_list import JsonApiLabelOutList
from gooddata_api_client.model.json_api_metric_in_document import JsonApiMetricInDocument
from gooddata_api_client.model.json_api_metric_out_document import JsonApiMetricOutDocument
from gooddata_api_client.model.json_api_metric_out_list import JsonApiMetricOutList
from gooddata_api_client.model.json_api_metric_patch_document import JsonApiMetricPatchDocument
from gooddata_api_client.model.json_api_metric_post_optional_id_document import JsonApiMetricPostOptionalIdDocument
from gooddata_api_client.model.json_api_user_data_filter_in_document import JsonApiUserDataFilterInDocument
from gooddata_api_client.model.json_api_user_data_filter_out_document import JsonApiUserDataFilterOutDocument
from gooddata_api_client.model.json_api_user_data_filter_out_list import JsonApiUserDataFilterOutList
from gooddata_api_client.model.json_api_user_data_filter_patch_document import JsonApiUserDataFilterPatchDocument
from gooddata_api_client.model.json_api_user_data_filter_post_optional_id_document import JsonApiUserDataFilterPostOptionalIdDocument
from gooddata_api_client.model.json_api_visualization_object_in_document import JsonApiVisualizationObjectInDocument
from gooddata_api_client.model.json_api_visualization_object_out_document import JsonApiVisualizationObjectOutDocument
from gooddata_api_client.model.json_api_visualization_object_out_list import JsonApiVisualizationObjectOutList
from gooddata_api_client.model.json_api_visualization_object_patch_document import JsonApiVisualizationObjectPatchDocument
from gooddata_api_client.model.json_api_visualization_object_post_optional_id_document import JsonApiVisualizationObjectPostOptionalIdDocument
from gooddata_api_client.model.json_api_workspace_data_filter_in_document import JsonApiWorkspaceDataFilterInDocument
from gooddata_api_client.model.json_api_workspace_data_filter_out_document import JsonApiWorkspaceDataFilterOutDocument
from gooddata_api_client.model.json_api_workspace_data_filter_out_list import JsonApiWorkspaceDataFilterOutList
from gooddata_api_client.model.json_api_workspace_data_filter_patch_document import JsonApiWorkspaceDataFilterPatchDocument
from gooddata_api_client.model.json_api_workspace_data_filter_setting_in_document import JsonApiWorkspaceDataFilterSettingInDocument
from gooddata_api_client.model.json_api_workspace_data_filter_setting_out_document import JsonApiWorkspaceDataFilterSettingOutDocument
from gooddata_api_client.model.json_api_workspace_data_filter_setting_out_list import JsonApiWorkspaceDataFilterSettingOutList
from gooddata_api_client.model.json_api_workspace_data_filter_setting_patch_document import JsonApiWorkspaceDataFilterSettingPatchDocument
from gooddata_api_client.model.json_api_workspace_setting_in_document import JsonApiWorkspaceSettingInDocument
from gooddata_api_client.model.json_api_workspace_setting_out_document import JsonApiWorkspaceSettingOutDocument
from gooddata_api_client.model.json_api_workspace_setting_out_list import JsonApiWorkspaceSettingOutList
from gooddata_api_client.model.json_api_workspace_setting_patch_document import JsonApiWorkspaceSettingPatchDocument
from gooddata_api_client.model.json_api_workspace_setting_post_optional_id_document import JsonApiWorkspaceSettingPostOptionalIdDocument


class WorkspaceObjectControllerApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_entity_analytical_dashboards_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiAnalyticalDashboardOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/analyticalDashboards',
                'operation_id': 'create_entity_analytical_dashboards',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'json_api_analytical_dashboard_post_optional_id_document',
                    'include',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'json_api_analytical_dashboard_post_optional_id_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "USERIDENTIFIERS": "userIdentifiers",
                        "VISUALIZATIONOBJECTS": "visualizationObjects",
                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "FILTERCONTEXTS": "filterContexts",
                        "DASHBOARDPLUGINS": "dashboardPlugins",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "PERMISSIONS": "permissions",
                        "ORIGIN": "origin",
                        "ACCESSINFO": "accessInfo",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'json_api_analytical_dashboard_post_optional_id_document':
                        (JsonApiAnalyticalDashboardPostOptionalIdDocument,),
                    'include':
                        ([str],),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'include': 'include',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'json_api_analytical_dashboard_post_optional_id_document': 'body',
                    'include': 'query',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_attribute_hierarchies_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiAttributeHierarchyOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/attributeHierarchies',
                'operation_id': 'create_entity_attribute_hierarchies',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'json_api_attribute_hierarchy_in_document',
                    'include',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'json_api_attribute_hierarchy_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "USERIDENTIFIERS": "userIdentifiers",
                        "ATTRIBUTES": "attributes",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'json_api_attribute_hierarchy_in_document':
                        (JsonApiAttributeHierarchyInDocument,),
                    'include':
                        ([str],),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'include': 'include',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'json_api_attribute_hierarchy_in_document': 'body',
                    'include': 'query',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_automations_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiAutomationOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/automations',
                'operation_id': 'create_entity_automations',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'json_api_automation_in_document',
                    'include',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'json_api_automation_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "NOTIFICATIONCHANNELS": "notificationChannels",
                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "USERIDENTIFIERS": "userIdentifiers",
                        "EXPORTDEFINITIONS": "exportDefinitions",
                        "USERS": "users",
                        "NOTIFICATIONCHANNEL": "notificationChannel",
                        "ANALYTICALDASHBOARD": "analyticalDashboard",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "RECIPIENTS": "recipients",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'json_api_automation_in_document':
                        (JsonApiAutomationInDocument,),
                    'include':
                        ([str],),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'include': 'include',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'json_api_automation_in_document': 'body',
                    'include': 'query',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_custom_application_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiCustomApplicationSettingOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/customApplicationSettings',
                'operation_id': 'create_entity_custom_application_settings',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'json_api_custom_application_setting_post_optional_id_document',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'json_api_custom_application_setting_post_optional_id_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'json_api_custom_application_setting_post_optional_id_document':
                        (JsonApiCustomApplicationSettingPostOptionalIdDocument,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'json_api_custom_application_setting_post_optional_id_document': 'body',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_dashboard_plugins_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiDashboardPluginOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/dashboardPlugins',
                'operation_id': 'create_entity_dashboard_plugins',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'json_api_dashboard_plugin_post_optional_id_document',
                    'include',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'json_api_dashboard_plugin_post_optional_id_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "USERIDENTIFIERS": "userIdentifiers",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'json_api_dashboard_plugin_post_optional_id_document':
                        (JsonApiDashboardPluginPostOptionalIdDocument,),
                    'include':
                        ([str],),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'include': 'include',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'json_api_dashboard_plugin_post_optional_id_document': 'body',
                    'include': 'query',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_export_definitions_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiExportDefinitionOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/exportDefinitions',
                'operation_id': 'create_entity_export_definitions',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'json_api_export_definition_post_optional_id_document',
                    'include',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'json_api_export_definition_post_optional_id_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "VISUALIZATIONOBJECTS": "visualizationObjects",
                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "AUTOMATIONS": "automations",
                        "USERIDENTIFIERS": "userIdentifiers",
                        "VISUALIZATIONOBJECT": "visualizationObject",
                        "ANALYTICALDASHBOARD": "analyticalDashboard",
                        "AUTOMATION": "automation",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'json_api_export_definition_post_optional_id_document':
                        (JsonApiExportDefinitionPostOptionalIdDocument,),
                    'include':
                        ([str],),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'include': 'include',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'json_api_export_definition_post_optional_id_document': 'body',
                    'include': 'query',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_filter_contexts_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiFilterContextOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/filterContexts',
                'operation_id': 'create_entity_filter_contexts',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'json_api_filter_context_post_optional_id_document',
                    'include',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'json_api_filter_context_post_optional_id_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "ATTRIBUTES": "attributes",
                        "DATASETS": "datasets",
                        "LABELS": "labels",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'json_api_filter_context_post_optional_id_document':
                        (JsonApiFilterContextPostOptionalIdDocument,),
                    'include':
                        ([str],),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'include': 'include',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'json_api_filter_context_post_optional_id_document': 'body',
                    'include': 'query',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_filter_views_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiFilterViewOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/filterViews',
                'operation_id': 'create_entity_filter_views',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'json_api_filter_view_in_document',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'json_api_filter_view_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "USERS": "users",
                        "ANALYTICALDASHBOARD": "analyticalDashboard",
                        "USER": "user",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'json_api_filter_view_in_document':
                        (JsonApiFilterViewInDocument,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'json_api_filter_view_in_document': 'body',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_metrics_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiMetricOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/metrics',
                'operation_id': 'create_entity_metrics',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'json_api_metric_post_optional_id_document',
                    'include',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'json_api_metric_post_optional_id_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "USERIDENTIFIERS": "userIdentifiers",
                        "FACTS": "facts",
                        "ATTRIBUTES": "attributes",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'json_api_metric_post_optional_id_document':
                        (JsonApiMetricPostOptionalIdDocument,),
                    'include':
                        ([str],),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'include': 'include',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'json_api_metric_post_optional_id_document': 'body',
                    'include': 'query',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_user_data_filters_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiUserDataFilterOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/userDataFilters',
                'operation_id': 'create_entity_user_data_filters',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'json_api_user_data_filter_post_optional_id_document',
                    'include',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'json_api_user_data_filter_post_optional_id_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "USERS": "users",
                        "USERGROUPS": "userGroups",
                        "FACTS": "facts",
                        "ATTRIBUTES": "attributes",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "USER": "user",
                        "USERGROUP": "userGroup",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'json_api_user_data_filter_post_optional_id_document':
                        (JsonApiUserDataFilterPostOptionalIdDocument,),
                    'include':
                        ([str],),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'include': 'include',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'json_api_user_data_filter_post_optional_id_document': 'body',
                    'include': 'query',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_visualization_objects_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiVisualizationObjectOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/visualizationObjects',
                'operation_id': 'create_entity_visualization_objects',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'json_api_visualization_object_post_optional_id_document',
                    'include',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'json_api_visualization_object_post_optional_id_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "USERIDENTIFIERS": "userIdentifiers",
                        "FACTS": "facts",
                        "ATTRIBUTES": "attributes",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'json_api_visualization_object_post_optional_id_document':
                        (JsonApiVisualizationObjectPostOptionalIdDocument,),
                    'include':
                        ([str],),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'include': 'include',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'json_api_visualization_object_post_optional_id_document': 'body',
                    'include': 'query',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_workspace_data_filter_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceDataFilterSettingOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings',
                'operation_id': 'create_entity_workspace_data_filter_settings',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'json_api_workspace_data_filter_setting_in_document',
                    'include',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'json_api_workspace_data_filter_setting_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "WORKSPACEDATAFILTERS": "workspaceDataFilters",
                        "WORKSPACEDATAFILTER": "workspaceDataFilter",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'json_api_workspace_data_filter_setting_in_document':
                        (JsonApiWorkspaceDataFilterSettingInDocument,),
                    'include':
                        ([str],),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'include': 'include',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'json_api_workspace_data_filter_setting_in_document': 'body',
                    'include': 'query',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_workspace_data_filters_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceDataFilterOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters',
                'operation_id': 'create_entity_workspace_data_filters',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'json_api_workspace_data_filter_in_document',
                    'include',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'json_api_workspace_data_filter_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "WORKSPACEDATAFILTERSETTINGS": "workspaceDataFilterSettings",
                        "FILTERSETTINGS": "filterSettings",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'json_api_workspace_data_filter_in_document':
                        (JsonApiWorkspaceDataFilterInDocument,),
                    'include':
                        ([str],),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'include': 'include',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'json_api_workspace_data_filter_in_document': 'body',
                    'include': 'query',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.create_entity_workspace_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceSettingOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceSettings',
                'operation_id': 'create_entity_workspace_settings',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'json_api_workspace_setting_post_optional_id_document',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'json_api_workspace_setting_post_optional_id_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'json_api_workspace_setting_post_optional_id_document':
                        (JsonApiWorkspaceSettingPostOptionalIdDocument,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'json_api_workspace_setting_post_optional_id_document': 'body',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.delete_entity_analytical_dashboards_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId}',
                'operation_id': 'delete_entity_analytical_dashboards',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_attribute_hierarchies_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/attributeHierarchies/{objectId}',
                'operation_id': 'delete_entity_attribute_hierarchies',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_automations_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/automations/{objectId}',
                'operation_id': 'delete_entity_automations',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_custom_application_settings_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId}',
                'operation_id': 'delete_entity_custom_application_settings',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_dashboard_plugins_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId}',
                'operation_id': 'delete_entity_dashboard_plugins',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_export_definitions_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/exportDefinitions/{objectId}',
                'operation_id': 'delete_entity_export_definitions',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_filter_contexts_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId}',
                'operation_id': 'delete_entity_filter_contexts',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_filter_views_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/filterViews/{objectId}',
                'operation_id': 'delete_entity_filter_views',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_metrics_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/metrics/{objectId}',
                'operation_id': 'delete_entity_metrics',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_user_data_filters_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/userDataFilters/{objectId}',
                'operation_id': 'delete_entity_user_data_filters',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_visualization_objects_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId}',
                'operation_id': 'delete_entity_visualization_objects',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_workspace_data_filter_settings_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings/{objectId}',
                'operation_id': 'delete_entity_workspace_data_filter_settings',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_workspace_data_filters_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId}',
                'operation_id': 'delete_entity_workspace_data_filters',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_workspace_settings_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId}',
                'operation_id': 'delete_entity_workspace_settings',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_analytical_dashboards_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiAnalyticalDashboardOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/analyticalDashboards',
                'operation_id': 'get_all_entities_analytical_dashboards',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('include',): {

                        "USERIDENTIFIERS": "userIdentifiers",
                        "VISUALIZATIONOBJECTS": "visualizationObjects",
                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "FILTERCONTEXTS": "filterContexts",
                        "DASHBOARDPLUGINS": "dashboardPlugins",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "PERMISSIONS": "permissions",
                        "ORIGIN": "origin",
                        "ACCESSINFO": "accessInfo",
                        "PAGE": "page",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_attribute_hierarchies_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiAttributeHierarchyOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/attributeHierarchies',
                'operation_id': 'get_all_entities_attribute_hierarchies',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('include',): {

                        "USERIDENTIFIERS": "userIdentifiers",
                        "ATTRIBUTES": "attributes",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "PAGE": "page",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_attributes_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiAttributeOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/attributes',
                'operation_id': 'get_all_entities_attributes',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('include',): {

                        "DATASETS": "datasets",
                        "LABELS": "labels",
                        "ATTRIBUTEHIERARCHIES": "attributeHierarchies",
                        "DATASET": "dataset",
                        "DEFAULTVIEW": "defaultView",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "PAGE": "page",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_automations_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiAutomationOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/automations',
                'operation_id': 'get_all_entities_automations',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('include',): {

                        "NOTIFICATIONCHANNELS": "notificationChannels",
                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "USERIDENTIFIERS": "userIdentifiers",
                        "EXPORTDEFINITIONS": "exportDefinitions",
                        "USERS": "users",
                        "NOTIFICATIONCHANNEL": "notificationChannel",
                        "ANALYTICALDASHBOARD": "analyticalDashboard",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "RECIPIENTS": "recipients",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "PAGE": "page",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_custom_application_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiCustomApplicationSettingOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/customApplicationSettings',
                'operation_id': 'get_all_entities_custom_application_settings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "PAGE": "page",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_dashboard_plugins_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiDashboardPluginOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/dashboardPlugins',
                'operation_id': 'get_all_entities_dashboard_plugins',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('include',): {

                        "USERIDENTIFIERS": "userIdentifiers",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "PAGE": "page",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_datasets_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiDatasetOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/datasets',
                'operation_id': 'get_all_entities_datasets',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('include',): {

                        "ATTRIBUTES": "attributes",
                        "FACTS": "facts",
                        "DATASETS": "datasets",
                        "WORKSPACEDATAFILTERS": "workspaceDataFilters",
                        "REFERENCES": "references",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "PAGE": "page",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_export_definitions_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiExportDefinitionOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/exportDefinitions',
                'operation_id': 'get_all_entities_export_definitions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('include',): {

                        "VISUALIZATIONOBJECTS": "visualizationObjects",
                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "AUTOMATIONS": "automations",
                        "USERIDENTIFIERS": "userIdentifiers",
                        "VISUALIZATIONOBJECT": "visualizationObject",
                        "ANALYTICALDASHBOARD": "analyticalDashboard",
                        "AUTOMATION": "automation",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "PAGE": "page",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_facts_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiFactOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/facts',
                'operation_id': 'get_all_entities_facts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('include',): {

                        "DATASETS": "datasets",
                        "DATASET": "dataset",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "PAGE": "page",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_filter_contexts_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiFilterContextOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/filterContexts',
                'operation_id': 'get_all_entities_filter_contexts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('include',): {

                        "ATTRIBUTES": "attributes",
                        "DATASETS": "datasets",
                        "LABELS": "labels",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "PAGE": "page",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_filter_views_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiFilterViewOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/filterViews',
                'operation_id': 'get_all_entities_filter_views',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('include',): {

                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "USERS": "users",
                        "ANALYTICALDASHBOARD": "analyticalDashboard",
                        "USER": "user",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "PAGE": "page",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_labels_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiLabelOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/labels',
                'operation_id': 'get_all_entities_labels',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('include',): {

                        "ATTRIBUTES": "attributes",
                        "ATTRIBUTE": "attribute",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "PAGE": "page",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_metrics_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiMetricOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/metrics',
                'operation_id': 'get_all_entities_metrics',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('include',): {

                        "USERIDENTIFIERS": "userIdentifiers",
                        "FACTS": "facts",
                        "ATTRIBUTES": "attributes",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "PAGE": "page",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_user_data_filters_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiUserDataFilterOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/userDataFilters',
                'operation_id': 'get_all_entities_user_data_filters',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('include',): {

                        "USERS": "users",
                        "USERGROUPS": "userGroups",
                        "FACTS": "facts",
                        "ATTRIBUTES": "attributes",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "USER": "user",
                        "USERGROUP": "userGroup",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "PAGE": "page",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_visualization_objects_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiVisualizationObjectOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/visualizationObjects',
                'operation_id': 'get_all_entities_visualization_objects',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('include',): {

                        "USERIDENTIFIERS": "userIdentifiers",
                        "FACTS": "facts",
                        "ATTRIBUTES": "attributes",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "PAGE": "page",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_workspace_data_filter_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceDataFilterSettingOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings',
                'operation_id': 'get_all_entities_workspace_data_filter_settings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('include',): {

                        "WORKSPACEDATAFILTERS": "workspaceDataFilters",
                        "WORKSPACEDATAFILTER": "workspaceDataFilter",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "PAGE": "page",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_workspace_data_filters_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceDataFilterOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters',
                'operation_id': 'get_all_entities_workspace_data_filters',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('include',): {

                        "WORKSPACEDATAFILTERSETTINGS": "workspaceDataFilterSettings",
                        "FILTERSETTINGS": "filterSettings",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "PAGE": "page",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_workspace_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceSettingOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceSettings',
                'operation_id': 'get_all_entities_workspace_settings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "PAGE": "page",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_analytical_dashboards_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiAnalyticalDashboardOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId}',
                'operation_id': 'get_entity_analytical_dashboards',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'include',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "USERIDENTIFIERS": "userIdentifiers",
                        "VISUALIZATIONOBJECTS": "visualizationObjects",
                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "FILTERCONTEXTS": "filterContexts",
                        "DASHBOARDPLUGINS": "dashboardPlugins",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "PERMISSIONS": "permissions",
                        "ORIGIN": "origin",
                        "ACCESSINFO": "accessInfo",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'include': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_attribute_hierarchies_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiAttributeHierarchyOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/attributeHierarchies/{objectId}',
                'operation_id': 'get_entity_attribute_hierarchies',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'include',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "USERIDENTIFIERS": "userIdentifiers",
                        "ATTRIBUTES": "attributes",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'include': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_attributes_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiAttributeOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/attributes/{objectId}',
                'operation_id': 'get_entity_attributes',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'include',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "DATASETS": "datasets",
                        "LABELS": "labels",
                        "ATTRIBUTEHIERARCHIES": "attributeHierarchies",
                        "DATASET": "dataset",
                        "DEFAULTVIEW": "defaultView",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'include': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_automations_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiAutomationOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/automations/{objectId}',
                'operation_id': 'get_entity_automations',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'include',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "NOTIFICATIONCHANNELS": "notificationChannels",
                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "USERIDENTIFIERS": "userIdentifiers",
                        "EXPORTDEFINITIONS": "exportDefinitions",
                        "USERS": "users",
                        "NOTIFICATIONCHANNEL": "notificationChannel",
                        "ANALYTICALDASHBOARD": "analyticalDashboard",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "RECIPIENTS": "recipients",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'include': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_custom_application_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiCustomApplicationSettingOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId}',
                'operation_id': 'get_entity_custom_application_settings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_dashboard_plugins_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiDashboardPluginOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId}',
                'operation_id': 'get_entity_dashboard_plugins',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'include',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "USERIDENTIFIERS": "userIdentifiers",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'include': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_datasets_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiDatasetOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/datasets/{objectId}',
                'operation_id': 'get_entity_datasets',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'include',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "ATTRIBUTES": "attributes",
                        "FACTS": "facts",
                        "DATASETS": "datasets",
                        "WORKSPACEDATAFILTERS": "workspaceDataFilters",
                        "REFERENCES": "references",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'include': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_export_definitions_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiExportDefinitionOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/exportDefinitions/{objectId}',
                'operation_id': 'get_entity_export_definitions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'include',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "VISUALIZATIONOBJECTS": "visualizationObjects",
                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "AUTOMATIONS": "automations",
                        "USERIDENTIFIERS": "userIdentifiers",
                        "VISUALIZATIONOBJECT": "visualizationObject",
                        "ANALYTICALDASHBOARD": "analyticalDashboard",
                        "AUTOMATION": "automation",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'include': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_facts_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiFactOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/facts/{objectId}',
                'operation_id': 'get_entity_facts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'include',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "DATASETS": "datasets",
                        "DATASET": "dataset",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'include': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_filter_contexts_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiFilterContextOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId}',
                'operation_id': 'get_entity_filter_contexts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'include',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "ATTRIBUTES": "attributes",
                        "DATASETS": "datasets",
                        "LABELS": "labels",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'include': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_filter_views_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiFilterViewOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/filterViews/{objectId}',
                'operation_id': 'get_entity_filter_views',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'include',
                    'x_gdc_validate_relations',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "USERS": "users",
                        "ANALYTICALDASHBOARD": "analyticalDashboard",
                        "USER": "user",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'include': 'query',
                    'x_gdc_validate_relations': 'header',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_labels_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiLabelOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/labels/{objectId}',
                'operation_id': 'get_entity_labels',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'include',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "ATTRIBUTES": "attributes",
                        "ATTRIBUTE": "attribute",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'include': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_metrics_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiMetricOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/metrics/{objectId}',
                'operation_id': 'get_entity_metrics',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'include',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "USERIDENTIFIERS": "userIdentifiers",
                        "FACTS": "facts",
                        "ATTRIBUTES": "attributes",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'include': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_user_data_filters_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiUserDataFilterOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/userDataFilters/{objectId}',
                'operation_id': 'get_entity_user_data_filters',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'include',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "USERS": "users",
                        "USERGROUPS": "userGroups",
                        "FACTS": "facts",
                        "ATTRIBUTES": "attributes",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "USER": "user",
                        "USERGROUP": "userGroup",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'include': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_visualization_objects_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiVisualizationObjectOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId}',
                'operation_id': 'get_entity_visualization_objects',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'include',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "USERIDENTIFIERS": "userIdentifiers",
                        "FACTS": "facts",
                        "ATTRIBUTES": "attributes",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'include': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_workspace_data_filter_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceDataFilterSettingOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings/{objectId}',
                'operation_id': 'get_entity_workspace_data_filter_settings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'include',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "WORKSPACEDATAFILTERS": "workspaceDataFilters",
                        "WORKSPACEDATAFILTER": "workspaceDataFilter",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'include': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_workspace_data_filters_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceDataFilterOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId}',
                'operation_id': 'get_entity_workspace_data_filters',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'include',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "WORKSPACEDATAFILTERSETTINGS": "workspaceDataFilterSettings",
                        "FILTERSETTINGS": "filterSettings",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'include': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_workspace_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceSettingOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId}',
                'operation_id': 'get_entity_workspace_settings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.patch_entity_analytical_dashboards_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiAnalyticalDashboardOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId}',
                'operation_id': 'patch_entity_analytical_dashboards',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_analytical_dashboard_patch_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_analytical_dashboard_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "USERIDENTIFIERS": "userIdentifiers",
                        "VISUALIZATIONOBJECTS": "visualizationObjects",
                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "FILTERCONTEXTS": "filterContexts",
                        "DASHBOARDPLUGINS": "dashboardPlugins",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_analytical_dashboard_patch_document':
                        (JsonApiAnalyticalDashboardPatchDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_analytical_dashboard_patch_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_attribute_hierarchies_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiAttributeHierarchyOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/attributeHierarchies/{objectId}',
                'operation_id': 'patch_entity_attribute_hierarchies',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_attribute_hierarchy_patch_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_attribute_hierarchy_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "USERIDENTIFIERS": "userIdentifiers",
                        "ATTRIBUTES": "attributes",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_attribute_hierarchy_patch_document':
                        (JsonApiAttributeHierarchyPatchDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_attribute_hierarchy_patch_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_automations_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiAutomationOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/automations/{objectId}',
                'operation_id': 'patch_entity_automations',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_automation_patch_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_automation_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "NOTIFICATIONCHANNELS": "notificationChannels",
                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "USERIDENTIFIERS": "userIdentifiers",
                        "EXPORTDEFINITIONS": "exportDefinitions",
                        "USERS": "users",
                        "NOTIFICATIONCHANNEL": "notificationChannel",
                        "ANALYTICALDASHBOARD": "analyticalDashboard",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "RECIPIENTS": "recipients",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_automation_patch_document':
                        (JsonApiAutomationPatchDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_automation_patch_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_custom_application_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiCustomApplicationSettingOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId}',
                'operation_id': 'patch_entity_custom_application_settings',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_custom_application_setting_patch_document',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_custom_application_setting_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_custom_application_setting_patch_document':
                        (JsonApiCustomApplicationSettingPatchDocument,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_custom_application_setting_patch_document': 'body',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_dashboard_plugins_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiDashboardPluginOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId}',
                'operation_id': 'patch_entity_dashboard_plugins',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_dashboard_plugin_patch_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_dashboard_plugin_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "USERIDENTIFIERS": "userIdentifiers",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_dashboard_plugin_patch_document':
                        (JsonApiDashboardPluginPatchDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_dashboard_plugin_patch_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_export_definitions_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiExportDefinitionOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/exportDefinitions/{objectId}',
                'operation_id': 'patch_entity_export_definitions',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_export_definition_patch_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_export_definition_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "VISUALIZATIONOBJECTS": "visualizationObjects",
                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "AUTOMATIONS": "automations",
                        "USERIDENTIFIERS": "userIdentifiers",
                        "VISUALIZATIONOBJECT": "visualizationObject",
                        "ANALYTICALDASHBOARD": "analyticalDashboard",
                        "AUTOMATION": "automation",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_export_definition_patch_document':
                        (JsonApiExportDefinitionPatchDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_export_definition_patch_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_filter_contexts_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiFilterContextOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId}',
                'operation_id': 'patch_entity_filter_contexts',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_filter_context_patch_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_filter_context_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "ATTRIBUTES": "attributes",
                        "DATASETS": "datasets",
                        "LABELS": "labels",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_filter_context_patch_document':
                        (JsonApiFilterContextPatchDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_filter_context_patch_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_filter_views_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiFilterViewOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/filterViews/{objectId}',
                'operation_id': 'patch_entity_filter_views',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_filter_view_patch_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_filter_view_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "USERS": "users",
                        "ANALYTICALDASHBOARD": "analyticalDashboard",
                        "USER": "user",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_filter_view_patch_document':
                        (JsonApiFilterViewPatchDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_filter_view_patch_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_metrics_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiMetricOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/metrics/{objectId}',
                'operation_id': 'patch_entity_metrics',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_metric_patch_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_metric_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "USERIDENTIFIERS": "userIdentifiers",
                        "FACTS": "facts",
                        "ATTRIBUTES": "attributes",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_metric_patch_document':
                        (JsonApiMetricPatchDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_metric_patch_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_user_data_filters_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiUserDataFilterOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/userDataFilters/{objectId}',
                'operation_id': 'patch_entity_user_data_filters',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_user_data_filter_patch_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_user_data_filter_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "USERS": "users",
                        "USERGROUPS": "userGroups",
                        "FACTS": "facts",
                        "ATTRIBUTES": "attributes",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "USER": "user",
                        "USERGROUP": "userGroup",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_user_data_filter_patch_document':
                        (JsonApiUserDataFilterPatchDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_user_data_filter_patch_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_visualization_objects_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiVisualizationObjectOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId}',
                'operation_id': 'patch_entity_visualization_objects',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_visualization_object_patch_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_visualization_object_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "USERIDENTIFIERS": "userIdentifiers",
                        "FACTS": "facts",
                        "ATTRIBUTES": "attributes",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_visualization_object_patch_document':
                        (JsonApiVisualizationObjectPatchDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_visualization_object_patch_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_workspace_data_filter_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceDataFilterSettingOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings/{objectId}',
                'operation_id': 'patch_entity_workspace_data_filter_settings',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_workspace_data_filter_setting_patch_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_workspace_data_filter_setting_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "WORKSPACEDATAFILTERS": "workspaceDataFilters",
                        "WORKSPACEDATAFILTER": "workspaceDataFilter",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_workspace_data_filter_setting_patch_document':
                        (JsonApiWorkspaceDataFilterSettingPatchDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_workspace_data_filter_setting_patch_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_workspace_data_filters_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceDataFilterOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId}',
                'operation_id': 'patch_entity_workspace_data_filters',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_workspace_data_filter_patch_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_workspace_data_filter_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "WORKSPACEDATAFILTERSETTINGS": "workspaceDataFilterSettings",
                        "FILTERSETTINGS": "filterSettings",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_workspace_data_filter_patch_document':
                        (JsonApiWorkspaceDataFilterPatchDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_workspace_data_filter_patch_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.patch_entity_workspace_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceSettingOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId}',
                'operation_id': 'patch_entity_workspace_settings',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_workspace_setting_patch_document',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_workspace_setting_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_workspace_setting_patch_document':
                        (JsonApiWorkspaceSettingPatchDocument,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_workspace_setting_patch_document': 'body',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_analytical_dashboards_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiAnalyticalDashboardOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/analyticalDashboards/{objectId}',
                'operation_id': 'update_entity_analytical_dashboards',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_analytical_dashboard_in_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_analytical_dashboard_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "USERIDENTIFIERS": "userIdentifiers",
                        "VISUALIZATIONOBJECTS": "visualizationObjects",
                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "FILTERCONTEXTS": "filterContexts",
                        "DASHBOARDPLUGINS": "dashboardPlugins",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_analytical_dashboard_in_document':
                        (JsonApiAnalyticalDashboardInDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_analytical_dashboard_in_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_attribute_hierarchies_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiAttributeHierarchyOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/attributeHierarchies/{objectId}',
                'operation_id': 'update_entity_attribute_hierarchies',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_attribute_hierarchy_in_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_attribute_hierarchy_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "USERIDENTIFIERS": "userIdentifiers",
                        "ATTRIBUTES": "attributes",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_attribute_hierarchy_in_document':
                        (JsonApiAttributeHierarchyInDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_attribute_hierarchy_in_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_automations_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiAutomationOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/automations/{objectId}',
                'operation_id': 'update_entity_automations',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_automation_in_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_automation_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "NOTIFICATIONCHANNELS": "notificationChannels",
                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "USERIDENTIFIERS": "userIdentifiers",
                        "EXPORTDEFINITIONS": "exportDefinitions",
                        "USERS": "users",
                        "NOTIFICATIONCHANNEL": "notificationChannel",
                        "ANALYTICALDASHBOARD": "analyticalDashboard",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "RECIPIENTS": "recipients",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_automation_in_document':
                        (JsonApiAutomationInDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_automation_in_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_custom_application_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiCustomApplicationSettingOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/customApplicationSettings/{objectId}',
                'operation_id': 'update_entity_custom_application_settings',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_custom_application_setting_in_document',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_custom_application_setting_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_custom_application_setting_in_document':
                        (JsonApiCustomApplicationSettingInDocument,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_custom_application_setting_in_document': 'body',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_dashboard_plugins_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiDashboardPluginOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/dashboardPlugins/{objectId}',
                'operation_id': 'update_entity_dashboard_plugins',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_dashboard_plugin_in_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_dashboard_plugin_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "USERIDENTIFIERS": "userIdentifiers",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_dashboard_plugin_in_document':
                        (JsonApiDashboardPluginInDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_dashboard_plugin_in_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_export_definitions_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiExportDefinitionOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/exportDefinitions/{objectId}',
                'operation_id': 'update_entity_export_definitions',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_export_definition_in_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_export_definition_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "VISUALIZATIONOBJECTS": "visualizationObjects",
                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "AUTOMATIONS": "automations",
                        "USERIDENTIFIERS": "userIdentifiers",
                        "VISUALIZATIONOBJECT": "visualizationObject",
                        "ANALYTICALDASHBOARD": "analyticalDashboard",
                        "AUTOMATION": "automation",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_export_definition_in_document':
                        (JsonApiExportDefinitionInDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_export_definition_in_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_filter_contexts_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiFilterContextOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/filterContexts/{objectId}',
                'operation_id': 'update_entity_filter_contexts',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_filter_context_in_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_filter_context_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "ATTRIBUTES": "attributes",
                        "DATASETS": "datasets",
                        "LABELS": "labels",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_filter_context_in_document':
                        (JsonApiFilterContextInDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_filter_context_in_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_filter_views_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiFilterViewOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/filterViews/{objectId}',
                'operation_id': 'update_entity_filter_views',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_filter_view_in_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_filter_view_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "USERS": "users",
                        "ANALYTICALDASHBOARD": "analyticalDashboard",
                        "USER": "user",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_filter_view_in_document':
                        (JsonApiFilterViewInDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_filter_view_in_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_metrics_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiMetricOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/metrics/{objectId}',
                'operation_id': 'update_entity_metrics',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_metric_in_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_metric_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "USERIDENTIFIERS": "userIdentifiers",
                        "FACTS": "facts",
                        "ATTRIBUTES": "attributes",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_metric_in_document':
                        (JsonApiMetricInDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_metric_in_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_user_data_filters_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiUserDataFilterOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/userDataFilters/{objectId}',
                'operation_id': 'update_entity_user_data_filters',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_user_data_filter_in_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_user_data_filter_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "USERS": "users",
                        "USERGROUPS": "userGroups",
                        "FACTS": "facts",
                        "ATTRIBUTES": "attributes",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "USER": "user",
                        "USERGROUP": "userGroup",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_user_data_filter_in_document':
                        (JsonApiUserDataFilterInDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_user_data_filter_in_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_visualization_objects_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiVisualizationObjectOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/visualizationObjects/{objectId}',
                'operation_id': 'update_entity_visualization_objects',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_visualization_object_in_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_visualization_object_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "USERIDENTIFIERS": "userIdentifiers",
                        "FACTS": "facts",
                        "ATTRIBUTES": "attributes",
                        "LABELS": "labels",
                        "METRICS": "metrics",
                        "DATASETS": "datasets",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_visualization_object_in_document':
                        (JsonApiVisualizationObjectInDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_visualization_object_in_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_workspace_data_filter_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceDataFilterSettingOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceDataFilterSettings/{objectId}',
                'operation_id': 'update_entity_workspace_data_filter_settings',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_workspace_data_filter_setting_in_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_workspace_data_filter_setting_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "WORKSPACEDATAFILTERS": "workspaceDataFilters",
                        "WORKSPACEDATAFILTER": "workspaceDataFilter",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_workspace_data_filter_setting_in_document':
                        (JsonApiWorkspaceDataFilterSettingInDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_workspace_data_filter_setting_in_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_workspace_data_filters_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceDataFilterOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceDataFilters/{objectId}',
                'operation_id': 'update_entity_workspace_data_filters',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_workspace_data_filter_in_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_workspace_data_filter_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "WORKSPACEDATAFILTERSETTINGS": "workspaceDataFilterSettings",
                        "FILTERSETTINGS": "filterSettings",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_workspace_data_filter_in_document':
                        (JsonApiWorkspaceDataFilterInDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_workspace_data_filter_in_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.update_entity_workspace_settings_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiWorkspaceSettingOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/workspaceSettings/{objectId}',
                'operation_id': 'update_entity_workspace_settings',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_workspace_setting_in_document',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_workspace_setting_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_workspace_setting_in_document':
                        (JsonApiWorkspaceSettingInDocument,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_workspace_setting_in_document': 'body',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )

    def create_entity_analytical_dashboards(
        self,
        workspace_id,
        json_api_analytical_dashboard_post_optional_id_document,
        **kwargs
    ):
        """Post Dashboards  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_analytical_dashboards(workspace_id, json_api_analytical_dashboard_post_optional_id_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            json_api_analytical_dashboard_post_optional_id_document (JsonApiAnalyticalDashboardPostOptionalIdDocument):

        Keyword Args:
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiAnalyticalDashboardOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['json_api_analytical_dashboard_post_optional_id_document'] = \
            json_api_analytical_dashboard_post_optional_id_document
        return self.create_entity_analytical_dashboards_endpoint.call_with_http_info(**kwargs)

    def create_entity_attribute_hierarchies(
        self,
        workspace_id,
        json_api_attribute_hierarchy_in_document,
        **kwargs
    ):
        """Post Attribute Hierarchies  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_attribute_hierarchies(workspace_id, json_api_attribute_hierarchy_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            json_api_attribute_hierarchy_in_document (JsonApiAttributeHierarchyInDocument):

        Keyword Args:
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiAttributeHierarchyOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['json_api_attribute_hierarchy_in_document'] = \
            json_api_attribute_hierarchy_in_document
        return self.create_entity_attribute_hierarchies_endpoint.call_with_http_info(**kwargs)

    def create_entity_automations(
        self,
        workspace_id,
        json_api_automation_in_document,
        **kwargs
    ):
        """Post Automations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_automations(workspace_id, json_api_automation_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            json_api_automation_in_document (JsonApiAutomationInDocument):

        Keyword Args:
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiAutomationOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['json_api_automation_in_document'] = \
            json_api_automation_in_document
        return self.create_entity_automations_endpoint.call_with_http_info(**kwargs)

    def create_entity_custom_application_settings(
        self,
        workspace_id,
        json_api_custom_application_setting_post_optional_id_document,
        **kwargs
    ):
        """Post Custom Application Settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_custom_application_settings(workspace_id, json_api_custom_application_setting_post_optional_id_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            json_api_custom_application_setting_post_optional_id_document (JsonApiCustomApplicationSettingPostOptionalIdDocument):

        Keyword Args:
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiCustomApplicationSettingOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['json_api_custom_application_setting_post_optional_id_document'] = \
            json_api_custom_application_setting_post_optional_id_document
        return self.create_entity_custom_application_settings_endpoint.call_with_http_info(**kwargs)

    def create_entity_dashboard_plugins(
        self,
        workspace_id,
        json_api_dashboard_plugin_post_optional_id_document,
        **kwargs
    ):
        """Post Plugins  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_dashboard_plugins(workspace_id, json_api_dashboard_plugin_post_optional_id_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            json_api_dashboard_plugin_post_optional_id_document (JsonApiDashboardPluginPostOptionalIdDocument):

        Keyword Args:
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiDashboardPluginOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['json_api_dashboard_plugin_post_optional_id_document'] = \
            json_api_dashboard_plugin_post_optional_id_document
        return self.create_entity_dashboard_plugins_endpoint.call_with_http_info(**kwargs)

    def create_entity_export_definitions(
        self,
        workspace_id,
        json_api_export_definition_post_optional_id_document,
        **kwargs
    ):
        """Post Export Definitions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_export_definitions(workspace_id, json_api_export_definition_post_optional_id_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            json_api_export_definition_post_optional_id_document (JsonApiExportDefinitionPostOptionalIdDocument):

        Keyword Args:
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiExportDefinitionOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['json_api_export_definition_post_optional_id_document'] = \
            json_api_export_definition_post_optional_id_document
        return self.create_entity_export_definitions_endpoint.call_with_http_info(**kwargs)

    def create_entity_filter_contexts(
        self,
        workspace_id,
        json_api_filter_context_post_optional_id_document,
        **kwargs
    ):
        """Post Context Filters  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_filter_contexts(workspace_id, json_api_filter_context_post_optional_id_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            json_api_filter_context_post_optional_id_document (JsonApiFilterContextPostOptionalIdDocument):

        Keyword Args:
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiFilterContextOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['json_api_filter_context_post_optional_id_document'] = \
            json_api_filter_context_post_optional_id_document
        return self.create_entity_filter_contexts_endpoint.call_with_http_info(**kwargs)

    def create_entity_filter_views(
        self,
        workspace_id,
        json_api_filter_view_in_document,
        **kwargs
    ):
        """Post Filter views  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_filter_views(workspace_id, json_api_filter_view_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            json_api_filter_view_in_document (JsonApiFilterViewInDocument):

        Keyword Args:
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiFilterViewOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['json_api_filter_view_in_document'] = \
            json_api_filter_view_in_document
        return self.create_entity_filter_views_endpoint.call_with_http_info(**kwargs)

    def create_entity_metrics(
        self,
        workspace_id,
        json_api_metric_post_optional_id_document,
        **kwargs
    ):
        """Post Metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_metrics(workspace_id, json_api_metric_post_optional_id_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            json_api_metric_post_optional_id_document (JsonApiMetricPostOptionalIdDocument):

        Keyword Args:
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiMetricOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['json_api_metric_post_optional_id_document'] = \
            json_api_metric_post_optional_id_document
        return self.create_entity_metrics_endpoint.call_with_http_info(**kwargs)

    def create_entity_user_data_filters(
        self,
        workspace_id,
        json_api_user_data_filter_post_optional_id_document,
        **kwargs
    ):
        """Post User Data Filters  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_user_data_filters(workspace_id, json_api_user_data_filter_post_optional_id_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            json_api_user_data_filter_post_optional_id_document (JsonApiUserDataFilterPostOptionalIdDocument):

        Keyword Args:
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiUserDataFilterOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['json_api_user_data_filter_post_optional_id_document'] = \
            json_api_user_data_filter_post_optional_id_document
        return self.create_entity_user_data_filters_endpoint.call_with_http_info(**kwargs)

    def create_entity_visualization_objects(
        self,
        workspace_id,
        json_api_visualization_object_post_optional_id_document,
        **kwargs
    ):
        """Post Visualization Objects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_visualization_objects(workspace_id, json_api_visualization_object_post_optional_id_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            json_api_visualization_object_post_optional_id_document (JsonApiVisualizationObjectPostOptionalIdDocument):

        Keyword Args:
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiVisualizationObjectOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['json_api_visualization_object_post_optional_id_document'] = \
            json_api_visualization_object_post_optional_id_document
        return self.create_entity_visualization_objects_endpoint.call_with_http_info(**kwargs)

    def create_entity_workspace_data_filter_settings(
        self,
        workspace_id,
        json_api_workspace_data_filter_setting_in_document,
        **kwargs
    ):
        """Post Settings for Workspace Data Filters  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_workspace_data_filter_settings(workspace_id, json_api_workspace_data_filter_setting_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            json_api_workspace_data_filter_setting_in_document (JsonApiWorkspaceDataFilterSettingInDocument):

        Keyword Args:
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceDataFilterSettingOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['json_api_workspace_data_filter_setting_in_document'] = \
            json_api_workspace_data_filter_setting_in_document
        return self.create_entity_workspace_data_filter_settings_endpoint.call_with_http_info(**kwargs)

    def create_entity_workspace_data_filters(
        self,
        workspace_id,
        json_api_workspace_data_filter_in_document,
        **kwargs
    ):
        """Post Workspace Data Filters  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_workspace_data_filters(workspace_id, json_api_workspace_data_filter_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            json_api_workspace_data_filter_in_document (JsonApiWorkspaceDataFilterInDocument):

        Keyword Args:
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceDataFilterOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['json_api_workspace_data_filter_in_document'] = \
            json_api_workspace_data_filter_in_document
        return self.create_entity_workspace_data_filters_endpoint.call_with_http_info(**kwargs)

    def create_entity_workspace_settings(
        self,
        workspace_id,
        json_api_workspace_setting_post_optional_id_document,
        **kwargs
    ):
        """Post Settings for Workspaces  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_workspace_settings(workspace_id, json_api_workspace_setting_post_optional_id_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            json_api_workspace_setting_post_optional_id_document (JsonApiWorkspaceSettingPostOptionalIdDocument):

        Keyword Args:
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceSettingOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['json_api_workspace_setting_post_optional_id_document'] = \
            json_api_workspace_setting_post_optional_id_document
        return self.create_entity_workspace_settings_endpoint.call_with_http_info(**kwargs)

    def delete_entity_analytical_dashboards(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Delete a Dashboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_analytical_dashboards(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.delete_entity_analytical_dashboards_endpoint.call_with_http_info(**kwargs)

    def delete_entity_attribute_hierarchies(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Delete an Attribute Hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_attribute_hierarchies(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.delete_entity_attribute_hierarchies_endpoint.call_with_http_info(**kwargs)

    def delete_entity_automations(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Delete an Automation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_automations(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.delete_entity_automations_endpoint.call_with_http_info(**kwargs)

    def delete_entity_custom_application_settings(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Delete a Custom Application Setting  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_custom_application_settings(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.delete_entity_custom_application_settings_endpoint.call_with_http_info(**kwargs)

    def delete_entity_dashboard_plugins(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Delete a Plugin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_dashboard_plugins(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.delete_entity_dashboard_plugins_endpoint.call_with_http_info(**kwargs)

    def delete_entity_export_definitions(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Delete an Export Definition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_export_definitions(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.delete_entity_export_definitions_endpoint.call_with_http_info(**kwargs)

    def delete_entity_filter_contexts(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Delete a Context Filter  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_filter_contexts(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.delete_entity_filter_contexts_endpoint.call_with_http_info(**kwargs)

    def delete_entity_filter_views(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Delete Filter view  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_filter_views(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.delete_entity_filter_views_endpoint.call_with_http_info(**kwargs)

    def delete_entity_metrics(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Delete a Metric  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_metrics(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.delete_entity_metrics_endpoint.call_with_http_info(**kwargs)

    def delete_entity_user_data_filters(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Delete a User Data Filter  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_user_data_filters(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.delete_entity_user_data_filters_endpoint.call_with_http_info(**kwargs)

    def delete_entity_visualization_objects(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Delete a Visualization Object  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_visualization_objects(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.delete_entity_visualization_objects_endpoint.call_with_http_info(**kwargs)

    def delete_entity_workspace_data_filter_settings(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Delete a Settings for Workspace Data Filter  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_workspace_data_filter_settings(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.delete_entity_workspace_data_filter_settings_endpoint.call_with_http_info(**kwargs)

    def delete_entity_workspace_data_filters(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Delete a Workspace Data Filter  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_workspace_data_filters(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.delete_entity_workspace_data_filters_endpoint.call_with_http_info(**kwargs)

    def delete_entity_workspace_settings(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Delete a Setting for Workspace  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_workspace_settings(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.delete_entity_workspace_settings_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_analytical_dashboards(
        self,
        workspace_id,
        **kwargs
    ):
        """Get all Dashboards  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_analytical_dashboards(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiAnalyticalDashboardOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_analytical_dashboards_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_attribute_hierarchies(
        self,
        workspace_id,
        **kwargs
    ):
        """Get all Attribute Hierarchies  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_attribute_hierarchies(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiAttributeHierarchyOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_attribute_hierarchies_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_attributes(
        self,
        workspace_id,
        **kwargs
    ):
        """Get all Attributes  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_attributes(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiAttributeOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_attributes_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_automations(
        self,
        workspace_id,
        **kwargs
    ):
        """Get all Automations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_automations(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiAutomationOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_automations_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_custom_application_settings(
        self,
        workspace_id,
        **kwargs
    ):
        """Get all Custom Application Settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_custom_application_settings(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiCustomApplicationSettingOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_custom_application_settings_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_dashboard_plugins(
        self,
        workspace_id,
        **kwargs
    ):
        """Get all Plugins  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_dashboard_plugins(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiDashboardPluginOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_dashboard_plugins_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_datasets(
        self,
        workspace_id,
        **kwargs
    ):
        """Get all Datasets  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_datasets(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiDatasetOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_datasets_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_export_definitions(
        self,
        workspace_id,
        **kwargs
    ):
        """Get all Export Definitions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_export_definitions(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiExportDefinitionOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_export_definitions_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_facts(
        self,
        workspace_id,
        **kwargs
    ):
        """Get all Facts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_facts(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiFactOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_facts_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_filter_contexts(
        self,
        workspace_id,
        **kwargs
    ):
        """Get all Context Filters  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_filter_contexts(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiFilterContextOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_filter_contexts_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_filter_views(
        self,
        workspace_id,
        **kwargs
    ):
        """Get all Filter views  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_filter_views(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiFilterViewOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_filter_views_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_labels(
        self,
        workspace_id,
        **kwargs
    ):
        """Get all Labels  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_labels(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiLabelOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_labels_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_metrics(
        self,
        workspace_id,
        **kwargs
    ):
        """Get all Metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_metrics(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiMetricOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_metrics_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_user_data_filters(
        self,
        workspace_id,
        **kwargs
    ):
        """Get all User Data Filters  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_user_data_filters(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiUserDataFilterOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_user_data_filters_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_visualization_objects(
        self,
        workspace_id,
        **kwargs
    ):
        """Get all Visualization Objects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_visualization_objects(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiVisualizationObjectOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_visualization_objects_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_workspace_data_filter_settings(
        self,
        workspace_id,
        **kwargs
    ):
        """Get all Settings for Workspace Data Filters  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_workspace_data_filter_settings(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceDataFilterSettingOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_workspace_data_filter_settings_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_workspace_data_filters(
        self,
        workspace_id,
        **kwargs
    ):
        """Get all Workspace Data Filters  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_workspace_data_filters(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceDataFilterOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_workspace_data_filters_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_workspace_settings(
        self,
        workspace_id,
        **kwargs
    ):
        """Get all Setting for Workspaces  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_workspace_settings(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceSettingOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_workspace_settings_endpoint.call_with_http_info(**kwargs)

    def get_entity_analytical_dashboards(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Get a Dashboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_analytical_dashboards(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiAnalyticalDashboardOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_analytical_dashboards_endpoint.call_with_http_info(**kwargs)

    def get_entity_attribute_hierarchies(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Get an Attribute Hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_attribute_hierarchies(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiAttributeHierarchyOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_attribute_hierarchies_endpoint.call_with_http_info(**kwargs)

    def get_entity_attributes(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Get an Attribute  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_attributes(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiAttributeOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_attributes_endpoint.call_with_http_info(**kwargs)

    def get_entity_automations(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Get an Automation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_automations(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiAutomationOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_automations_endpoint.call_with_http_info(**kwargs)

    def get_entity_custom_application_settings(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Get a Custom Application Setting  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_custom_application_settings(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiCustomApplicationSettingOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_custom_application_settings_endpoint.call_with_http_info(**kwargs)

    def get_entity_dashboard_plugins(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Get a Plugin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_dashboard_plugins(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiDashboardPluginOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_dashboard_plugins_endpoint.call_with_http_info(**kwargs)

    def get_entity_datasets(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Get a Dataset  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_datasets(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiDatasetOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_datasets_endpoint.call_with_http_info(**kwargs)

    def get_entity_export_definitions(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Get an Export Definition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_export_definitions(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiExportDefinitionOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_export_definitions_endpoint.call_with_http_info(**kwargs)

    def get_entity_facts(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Get a Fact  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_facts(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiFactOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_facts_endpoint.call_with_http_info(**kwargs)

    def get_entity_filter_contexts(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Get a Context Filter  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_filter_contexts(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiFilterContextOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_filter_contexts_endpoint.call_with_http_info(**kwargs)

    def get_entity_filter_views(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Get Filter view  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_filter_views(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiFilterViewOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_filter_views_endpoint.call_with_http_info(**kwargs)

    def get_entity_labels(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Get a Label  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_labels(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiLabelOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_labels_endpoint.call_with_http_info(**kwargs)

    def get_entity_metrics(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Get a Metric  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_metrics(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiMetricOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_metrics_endpoint.call_with_http_info(**kwargs)

    def get_entity_user_data_filters(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Get a User Data Filter  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_user_data_filters(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiUserDataFilterOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_user_data_filters_endpoint.call_with_http_info(**kwargs)

    def get_entity_visualization_objects(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Get a Visualization Object  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_visualization_objects(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiVisualizationObjectOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_visualization_objects_endpoint.call_with_http_info(**kwargs)

    def get_entity_workspace_data_filter_settings(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Get a Setting for Workspace Data Filter  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_workspace_data_filter_settings(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceDataFilterSettingOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_workspace_data_filter_settings_endpoint.call_with_http_info(**kwargs)

    def get_entity_workspace_data_filters(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Get a Workspace Data Filter  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_workspace_data_filters(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceDataFilterOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_workspace_data_filters_endpoint.call_with_http_info(**kwargs)

    def get_entity_workspace_settings(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Get a Setting for Workspace  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_workspace_settings(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceSettingOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_workspace_settings_endpoint.call_with_http_info(**kwargs)

    def patch_entity_analytical_dashboards(
        self,
        workspace_id,
        object_id,
        json_api_analytical_dashboard_patch_document,
        **kwargs
    ):
        """Patch a Dashboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_analytical_dashboards(workspace_id, object_id, json_api_analytical_dashboard_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_analytical_dashboard_patch_document (JsonApiAnalyticalDashboardPatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiAnalyticalDashboardOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_analytical_dashboard_patch_document'] = \
            json_api_analytical_dashboard_patch_document
        return self.patch_entity_analytical_dashboards_endpoint.call_with_http_info(**kwargs)

    def patch_entity_attribute_hierarchies(
        self,
        workspace_id,
        object_id,
        json_api_attribute_hierarchy_patch_document,
        **kwargs
    ):
        """Patch an Attribute Hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_attribute_hierarchies(workspace_id, object_id, json_api_attribute_hierarchy_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_attribute_hierarchy_patch_document (JsonApiAttributeHierarchyPatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiAttributeHierarchyOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_attribute_hierarchy_patch_document'] = \
            json_api_attribute_hierarchy_patch_document
        return self.patch_entity_attribute_hierarchies_endpoint.call_with_http_info(**kwargs)

    def patch_entity_automations(
        self,
        workspace_id,
        object_id,
        json_api_automation_patch_document,
        **kwargs
    ):
        """Patch an Automation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_automations(workspace_id, object_id, json_api_automation_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_automation_patch_document (JsonApiAutomationPatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiAutomationOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_automation_patch_document'] = \
            json_api_automation_patch_document
        return self.patch_entity_automations_endpoint.call_with_http_info(**kwargs)

    def patch_entity_custom_application_settings(
        self,
        workspace_id,
        object_id,
        json_api_custom_application_setting_patch_document,
        **kwargs
    ):
        """Patch a Custom Application Setting  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_custom_application_settings(workspace_id, object_id, json_api_custom_application_setting_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_custom_application_setting_patch_document (JsonApiCustomApplicationSettingPatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiCustomApplicationSettingOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_custom_application_setting_patch_document'] = \
            json_api_custom_application_setting_patch_document
        return self.patch_entity_custom_application_settings_endpoint.call_with_http_info(**kwargs)

    def patch_entity_dashboard_plugins(
        self,
        workspace_id,
        object_id,
        json_api_dashboard_plugin_patch_document,
        **kwargs
    ):
        """Patch a Plugin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_dashboard_plugins(workspace_id, object_id, json_api_dashboard_plugin_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_dashboard_plugin_patch_document (JsonApiDashboardPluginPatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiDashboardPluginOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_dashboard_plugin_patch_document'] = \
            json_api_dashboard_plugin_patch_document
        return self.patch_entity_dashboard_plugins_endpoint.call_with_http_info(**kwargs)

    def patch_entity_export_definitions(
        self,
        workspace_id,
        object_id,
        json_api_export_definition_patch_document,
        **kwargs
    ):
        """Patch an Export Definition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_export_definitions(workspace_id, object_id, json_api_export_definition_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_export_definition_patch_document (JsonApiExportDefinitionPatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiExportDefinitionOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_export_definition_patch_document'] = \
            json_api_export_definition_patch_document
        return self.patch_entity_export_definitions_endpoint.call_with_http_info(**kwargs)

    def patch_entity_filter_contexts(
        self,
        workspace_id,
        object_id,
        json_api_filter_context_patch_document,
        **kwargs
    ):
        """Patch a Context Filter  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_filter_contexts(workspace_id, object_id, json_api_filter_context_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_filter_context_patch_document (JsonApiFilterContextPatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiFilterContextOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_filter_context_patch_document'] = \
            json_api_filter_context_patch_document
        return self.patch_entity_filter_contexts_endpoint.call_with_http_info(**kwargs)

    def patch_entity_filter_views(
        self,
        workspace_id,
        object_id,
        json_api_filter_view_patch_document,
        **kwargs
    ):
        """Patch Filter view  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_filter_views(workspace_id, object_id, json_api_filter_view_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_filter_view_patch_document (JsonApiFilterViewPatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiFilterViewOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_filter_view_patch_document'] = \
            json_api_filter_view_patch_document
        return self.patch_entity_filter_views_endpoint.call_with_http_info(**kwargs)

    def patch_entity_metrics(
        self,
        workspace_id,
        object_id,
        json_api_metric_patch_document,
        **kwargs
    ):
        """Patch a Metric  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_metrics(workspace_id, object_id, json_api_metric_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_metric_patch_document (JsonApiMetricPatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiMetricOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_metric_patch_document'] = \
            json_api_metric_patch_document
        return self.patch_entity_metrics_endpoint.call_with_http_info(**kwargs)

    def patch_entity_user_data_filters(
        self,
        workspace_id,
        object_id,
        json_api_user_data_filter_patch_document,
        **kwargs
    ):
        """Patch a User Data Filter  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_user_data_filters(workspace_id, object_id, json_api_user_data_filter_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_user_data_filter_patch_document (JsonApiUserDataFilterPatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiUserDataFilterOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_user_data_filter_patch_document'] = \
            json_api_user_data_filter_patch_document
        return self.patch_entity_user_data_filters_endpoint.call_with_http_info(**kwargs)

    def patch_entity_visualization_objects(
        self,
        workspace_id,
        object_id,
        json_api_visualization_object_patch_document,
        **kwargs
    ):
        """Patch a Visualization Object  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_visualization_objects(workspace_id, object_id, json_api_visualization_object_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_visualization_object_patch_document (JsonApiVisualizationObjectPatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiVisualizationObjectOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_visualization_object_patch_document'] = \
            json_api_visualization_object_patch_document
        return self.patch_entity_visualization_objects_endpoint.call_with_http_info(**kwargs)

    def patch_entity_workspace_data_filter_settings(
        self,
        workspace_id,
        object_id,
        json_api_workspace_data_filter_setting_patch_document,
        **kwargs
    ):
        """Patch a Settings for Workspace Data Filter  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_workspace_data_filter_settings(workspace_id, object_id, json_api_workspace_data_filter_setting_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_workspace_data_filter_setting_patch_document (JsonApiWorkspaceDataFilterSettingPatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceDataFilterSettingOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_workspace_data_filter_setting_patch_document'] = \
            json_api_workspace_data_filter_setting_patch_document
        return self.patch_entity_workspace_data_filter_settings_endpoint.call_with_http_info(**kwargs)

    def patch_entity_workspace_data_filters(
        self,
        workspace_id,
        object_id,
        json_api_workspace_data_filter_patch_document,
        **kwargs
    ):
        """Patch a Workspace Data Filter  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_workspace_data_filters(workspace_id, object_id, json_api_workspace_data_filter_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_workspace_data_filter_patch_document (JsonApiWorkspaceDataFilterPatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceDataFilterOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_workspace_data_filter_patch_document'] = \
            json_api_workspace_data_filter_patch_document
        return self.patch_entity_workspace_data_filters_endpoint.call_with_http_info(**kwargs)

    def patch_entity_workspace_settings(
        self,
        workspace_id,
        object_id,
        json_api_workspace_setting_patch_document,
        **kwargs
    ):
        """Patch a Setting for Workspace  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_workspace_settings(workspace_id, object_id, json_api_workspace_setting_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_workspace_setting_patch_document (JsonApiWorkspaceSettingPatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceSettingOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_workspace_setting_patch_document'] = \
            json_api_workspace_setting_patch_document
        return self.patch_entity_workspace_settings_endpoint.call_with_http_info(**kwargs)

    def update_entity_analytical_dashboards(
        self,
        workspace_id,
        object_id,
        json_api_analytical_dashboard_in_document,
        **kwargs
    ):
        """Put Dashboards  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_analytical_dashboards(workspace_id, object_id, json_api_analytical_dashboard_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_analytical_dashboard_in_document (JsonApiAnalyticalDashboardInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiAnalyticalDashboardOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_analytical_dashboard_in_document'] = \
            json_api_analytical_dashboard_in_document
        return self.update_entity_analytical_dashboards_endpoint.call_with_http_info(**kwargs)

    def update_entity_attribute_hierarchies(
        self,
        workspace_id,
        object_id,
        json_api_attribute_hierarchy_in_document,
        **kwargs
    ):
        """Put an Attribute Hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_attribute_hierarchies(workspace_id, object_id, json_api_attribute_hierarchy_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_attribute_hierarchy_in_document (JsonApiAttributeHierarchyInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiAttributeHierarchyOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_attribute_hierarchy_in_document'] = \
            json_api_attribute_hierarchy_in_document
        return self.update_entity_attribute_hierarchies_endpoint.call_with_http_info(**kwargs)

    def update_entity_automations(
        self,
        workspace_id,
        object_id,
        json_api_automation_in_document,
        **kwargs
    ):
        """Put an Automation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_automations(workspace_id, object_id, json_api_automation_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_automation_in_document (JsonApiAutomationInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiAutomationOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_automation_in_document'] = \
            json_api_automation_in_document
        return self.update_entity_automations_endpoint.call_with_http_info(**kwargs)

    def update_entity_custom_application_settings(
        self,
        workspace_id,
        object_id,
        json_api_custom_application_setting_in_document,
        **kwargs
    ):
        """Put a Custom Application Setting  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_custom_application_settings(workspace_id, object_id, json_api_custom_application_setting_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_custom_application_setting_in_document (JsonApiCustomApplicationSettingInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiCustomApplicationSettingOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_custom_application_setting_in_document'] = \
            json_api_custom_application_setting_in_document
        return self.update_entity_custom_application_settings_endpoint.call_with_http_info(**kwargs)

    def update_entity_dashboard_plugins(
        self,
        workspace_id,
        object_id,
        json_api_dashboard_plugin_in_document,
        **kwargs
    ):
        """Put a Plugin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_dashboard_plugins(workspace_id, object_id, json_api_dashboard_plugin_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_dashboard_plugin_in_document (JsonApiDashboardPluginInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiDashboardPluginOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_dashboard_plugin_in_document'] = \
            json_api_dashboard_plugin_in_document
        return self.update_entity_dashboard_plugins_endpoint.call_with_http_info(**kwargs)

    def update_entity_export_definitions(
        self,
        workspace_id,
        object_id,
        json_api_export_definition_in_document,
        **kwargs
    ):
        """Put an Export Definition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_export_definitions(workspace_id, object_id, json_api_export_definition_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_export_definition_in_document (JsonApiExportDefinitionInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiExportDefinitionOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_export_definition_in_document'] = \
            json_api_export_definition_in_document
        return self.update_entity_export_definitions_endpoint.call_with_http_info(**kwargs)

    def update_entity_filter_contexts(
        self,
        workspace_id,
        object_id,
        json_api_filter_context_in_document,
        **kwargs
    ):
        """Put a Context Filter  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_filter_contexts(workspace_id, object_id, json_api_filter_context_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_filter_context_in_document (JsonApiFilterContextInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiFilterContextOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_filter_context_in_document'] = \
            json_api_filter_context_in_document
        return self.update_entity_filter_contexts_endpoint.call_with_http_info(**kwargs)

    def update_entity_filter_views(
        self,
        workspace_id,
        object_id,
        json_api_filter_view_in_document,
        **kwargs
    ):
        """Put Filter views  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_filter_views(workspace_id, object_id, json_api_filter_view_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_filter_view_in_document (JsonApiFilterViewInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiFilterViewOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_filter_view_in_document'] = \
            json_api_filter_view_in_document
        return self.update_entity_filter_views_endpoint.call_with_http_info(**kwargs)

    def update_entity_metrics(
        self,
        workspace_id,
        object_id,
        json_api_metric_in_document,
        **kwargs
    ):
        """Put a Metric  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_metrics(workspace_id, object_id, json_api_metric_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_metric_in_document (JsonApiMetricInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiMetricOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_metric_in_document'] = \
            json_api_metric_in_document
        return self.update_entity_metrics_endpoint.call_with_http_info(**kwargs)

    def update_entity_user_data_filters(
        self,
        workspace_id,
        object_id,
        json_api_user_data_filter_in_document,
        **kwargs
    ):
        """Put a User Data Filter  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_user_data_filters(workspace_id, object_id, json_api_user_data_filter_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_user_data_filter_in_document (JsonApiUserDataFilterInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiUserDataFilterOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_user_data_filter_in_document'] = \
            json_api_user_data_filter_in_document
        return self.update_entity_user_data_filters_endpoint.call_with_http_info(**kwargs)

    def update_entity_visualization_objects(
        self,
        workspace_id,
        object_id,
        json_api_visualization_object_in_document,
        **kwargs
    ):
        """Put a Visualization Object  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_visualization_objects(workspace_id, object_id, json_api_visualization_object_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_visualization_object_in_document (JsonApiVisualizationObjectInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiVisualizationObjectOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_visualization_object_in_document'] = \
            json_api_visualization_object_in_document
        return self.update_entity_visualization_objects_endpoint.call_with_http_info(**kwargs)

    def update_entity_workspace_data_filter_settings(
        self,
        workspace_id,
        object_id,
        json_api_workspace_data_filter_setting_in_document,
        **kwargs
    ):
        """Put a Settings for Workspace Data Filter  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_workspace_data_filter_settings(workspace_id, object_id, json_api_workspace_data_filter_setting_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_workspace_data_filter_setting_in_document (JsonApiWorkspaceDataFilterSettingInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceDataFilterSettingOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_workspace_data_filter_setting_in_document'] = \
            json_api_workspace_data_filter_setting_in_document
        return self.update_entity_workspace_data_filter_settings_endpoint.call_with_http_info(**kwargs)

    def update_entity_workspace_data_filters(
        self,
        workspace_id,
        object_id,
        json_api_workspace_data_filter_in_document,
        **kwargs
    ):
        """Put a Workspace Data Filter  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_workspace_data_filters(workspace_id, object_id, json_api_workspace_data_filter_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_workspace_data_filter_in_document (JsonApiWorkspaceDataFilterInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceDataFilterOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_workspace_data_filter_in_document'] = \
            json_api_workspace_data_filter_in_document
        return self.update_entity_workspace_data_filters_endpoint.call_with_http_info(**kwargs)

    def update_entity_workspace_settings(
        self,
        workspace_id,
        object_id,
        json_api_workspace_setting_in_document,
        **kwargs
    ):
        """Put a Setting for a Workspace  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_workspace_settings(workspace_id, object_id, json_api_workspace_setting_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_workspace_setting_in_document (JsonApiWorkspaceSettingInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiWorkspaceSettingOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_workspace_setting_in_document'] = \
            json_api_workspace_setting_in_document
        return self.update_entity_workspace_settings_endpoint.call_with_http_info(**kwargs)

