# -*- coding: utf-8 -*-
"""ColBertPyterrier.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1HBhH4hes5e44ULsVmSis9ixh3WJvHfx2
"""

!pip install --upgrade git+https://github.com/terrier-org/pyterrier.git
!pip install --upgrade git+https://github.com/cmacdonald/pyterrier_bert.git@colbert0.2 transformers==3.0.2

import pyterrier as pt
import os
import random
import math

if not pt.started():
    pt.init(version="snapshot")

!pip uninstall faiss
!pip install faiss-cpu

![ ! -e "colbert.dnn.zip" ] && wget http://www.dcs.gla.ac.uk/~craigm/colbert.dnn.zip
![ ! -e "colbert.dnn" ] && unzip colbert.dnn.zip

import os
import numpy as np
from pyterrier.transformer import TransformerBase
from colbert.indexing.faiss import index_faiss
from colbert.indexing.loaders import load_doclens
from pyterrier.transformer import TransformerBase
from colbertencoder import CollectionEncoder
from treccreatecollection import createCollection
import ujson
import random
import copy
import queue


from colbert.utils.parser import Arguments
import colbert.utils.distributed as distributed

from colbert.utils.utils import print_message, create_directory

docnos =[]

class Object(object):
  collection = None
  pass

class CollectionEncoder_Generator(CollectionEncoder):
    def _initialize_iterator(self):
      return self.args.generator


class ColBERTIndexer():
  def __init__(self, checkpoint, index_root, index_name, chunksize):
    args = Object()
    args.similarity = 'cosine'
    args.dim = 128
    args.query_maxlen = 32
    args.doc_maxlen = 180
    args.mask_punctuation = False
    args.checkpoint = checkpoint
    args.bsize = 128
    args.amp = False
    args.index_root = index_root
    args.index_name = index_name
    args.chunksize = chunksize
    args.rank = -1
    args.index_path = os.path.join(args.index_root, args.index_name)
    args.input_arguments = copy.deepcopy(args)
    args.nranks, args.distributed = distributed.init(args.rank)
    self.saver_queue = queue.Queue(maxsize=3)
    args.partitions = 100
    
    
    
    self.args = args
    self.args.sample = None
    self.args.slices = 1

    assert self.args.slices >= 1
    assert self.args.sample is None or (0.0 < self.args.sample <1.0), self.args.sample
    

  def index(self, name, trec_indexed, maxdocs):
        self.args.collection = pt.datasets.get_dataset(name).get_corpus()
        maxdocs = 100
        assert not os.path.exists(self.args.index_path), self.args.index_path
        
        def convert_gen():
            docid = -1
            if type(trec_indexed) !=bool:
              raise TypeError('trec_indexed needs to be given as a boolean, whether the dataset is indexed or not')
            if trec_indexed ==False:
                  
              dataset = pt.get_dataset(name)
              ds = dataset.get_corpus()
  
              f = open(ds[0],'r')
              for x in f:
                docid += 1
                if docid==maxdocs:
                    break
                docno, passage = x.split("\t")
                docnos.append(docno)
                yield "%d\t%s" %(docid,passage)
                
            else:
                collection = createCollection(pt.datasets.get_dataset('vaswani').get_corpus())
                while(collection.nextDocument()):
                  d = collection.getDocument()
                  contents = ""
                  while not d.endOfDocument():
                    docid += 1
                    if docid==maxdocs:
                      break
                    t = d.getNextTerm()
                    if t is not None:
                      contents += " " + t
                    docno, passage = d.getProperty("docno"),contents
                    docnos.append(docno)
                  yield "%d\t%s" %(docid,passage)
                
              
        self.args.generator = convert_gen()
        ceg = CollectionEncoder_Generator(self.args,0,1)

        if self.args.rank < 1:
            create_directory(self.args.index_root)
            create_directory(self.args.index_path)


        process_idx = max(0, self.args.rank)

        ceg.encode()


        assert os.path.exists(self.args.index_path), self.args.index_path
        num_embeddings = sum(load_doclens(self.args.index_path))
        print("#> num_embeddings =", num_embeddings)

        if self.args.partitions is None:
            self.args.partitions = 1 << math.ceil(math.log2(8 * math.sqrt(num_embeddings)))
            print('\n\n')
            Run.warn("You did not specify --partitions!")
            Run.warn("Default computation chooses", self.args.partitions,
                     "partitions (for {} embeddings)".format(num_embeddings))
            print('\n\n')

        index_faiss(self.args)

#todo - print out a marker for indexing process so we know there is no error

cindxr = ColBERTIndexer(checkpoint='colbert.dnn',index_root='/content/colBERTindex',index_name='index11K', chunksize=3) 
cindxr.index(name="antique",trec_indexed=False,maxdocs=100)

from pyterrier.transformer import TransformerBase

import os
import time
import faiss
import random
import torch

from collections import defaultdict, OrderedDict

from colbert.evaluation.loaders import load_colbert
from colbert.indexing.faiss import get_faiss_index_name
from colbert.ranking.faiss_index import FaissIndex
from colbert.modeling.inference import ModelInference
from colbert.utils.utils import print_message, batch, zipstar, flatten
from colbert.ranking.index_part import IndexPart
from colbert.ranking.rankers import Ranker



class Object(object):
  pass


class ColBERTSetRetrieve(TransformerBase):
    random.seed(12345)
    

    def __init__(self, checkpoint, index_root, index_name):
        args = Object()
        args.depth = 1000
        args.checkpoint = checkpoint
        args.index_root = index_root
        args.index_name = index_name
        args.partitions = 100
        args.faiss_name = None
        args.faiss_depth = 1024
        args.part_range = None
        args.batch = False
        args.similarity = 'cosine'
        args.dim = 128
        args.query_maxlen = 32
        args.doc_maxlen = 180
        args.bsize = 32
        args.accumsteps = 2
        args.amp = False
        args.nprobe = 10
        args.retrieve_only = False
        args.mask_punctuation = False

        args.index_path = os.path.join(args.index_root, args.index_name)

        if args.part_range:
          part_offset, part_endpos = map(int, args.part_range.split('..'))
          args.part_range = range(part_offset, part_endpos)

        if args.faiss_name is not None:
            args.faiss_index_path = os.path.join(args.index_path, args.faiss_name)
        else:
            args.faiss_index_path = os.path.join(args.index_path, get_faiss_index_name(args))

            
        args.colbert, args.checkpoint = load_colbert(args)
        self.args = args
        self.inference = ModelInference(args.colbert, amp=args.amp)
        self.ranker = Ranker(self.args, self.inference, faiss_depth=args.faiss_depth)
        self.index = IndexPart(args.index_path, dim=self.inference.colbert.dim, part_range=args.part_range, verbose=True)


    def transform(self, queries_df):

        def queryset(queriesdf):
          querie = OrderedDict()

          for index, row in queriesdf.iterrows(): 
              querie[row['qid']] = row['query'] 

          qidsinorder = list(querie.keys())

          return querie, qidsinorder


        def retrieve(queries, qids_in_order):

          faiss_index = FaissIndex(self.args.index_path, self.args.faiss_index_path, self.args.nprobe, self.args.part_range)
          rtr = []
          for qoffset, qbatch in batch(qids_in_order, 100_000, provide_offset=True):
              qbatch_text = [queries[qid] for qid in qbatch]

              print_message(f"#> Embedding {len(qbatch_text)} queries in parallel...")
              Q = self.inference.queryFromText(qbatch_text, bsize=512)

              print_message("#> Starting batch retrieval...")
              all_pids = faiss_index.retrieve(self.args.faiss_depth, Q, verbose=True)

            
              for qid, passage_id in zip(qbatch, all_pids):
                  rtr.append([qid, queries[qid],docnos[passage_id]])

          return pd.DataFrame(rtr, columns=["qid","query",'docno'])

        queries, qids_in_order = queryset(queries_df)
        output = retrieve(queries, qids_in_order)

        return output

#todo - check if above and below is refactored code
from pyterrier.transformer import TransformerBase

import os
import time
import faiss
import random
import torch

from collections import defaultdict, OrderedDict

from colbert.evaluation.loaders import load_colbert
from colbert.indexing.faiss import get_faiss_index_name
from colbert.ranking.faiss_index import FaissIndex
from colbert.modeling.inference import ModelInference
from colbert.utils.utils import print_message, batch, zipstar, flatten
from colbert.ranking.index_part import IndexPart
from colbert.ranking.rankers import Ranker
#from setretrieve import ColBERTSetRetrieve

class Object(object):
  depth=1000
  pass


class ColBERTRetrieve(ColBERTSetRetrieve): 

  def init__(self):
      super().__init__()
  
          
  def transform(self, queries_df): 

      def queryset(queriesdf):
          querie = OrderedDict()

          for index, row in queriesdf.iterrows(): 
              querie[row['qid']] = row['query'] 

          qidsinorder = list(querie.keys())

          return querie, qidsinorder

      def retrieve(queries, qids_in_order):
        rtr = []
        for qoffset, qbatch in batch(qids_in_order, 100, provide_offset=True):
            qbatch_text = [queries[qid] for qid in qbatch]

            for query_idx, q in enumerate(qbatch_text):

                Q = self.ranker.encode([q])
                pids, scores = self.ranker.rank(Q)

                for rank, (pid, score) in enumerate(zip(pids, scores)):
                  rtr.append([qids_in_order[query_idx],q,docnos[pid],score, rank])
        return pd.DataFrame(rtr, columns=["qid","query", "docno","score","rank"])
  
      queries, qids_in_order = queryset(queries_df)
      output = retrieve(queries, qids_in_order)
      
      return output

faissCol_retr = ColBERTRetrieve(checkpoint='colbert.dnn',index_root='colBERTindex', index_name='index11K')

import pandas as pd
faissCol_retr.transform(pt.get_dataset("antique").get_topics('test'))

def TerrierIndex(trec_indexing, datasetname):
  if trec_indexing ==False:
    df = pt.get_dataset("irds:"+ "%s"%(datasetname)).get_corpus_iter()
    iter_indexer = pt.IterDictIndexer("./passage_index")
    Tindex = iter_indexer.index(df, meta=['docno', 'text'])
    return Tindex
  else:
    dataset = pt.get_dataset("%s"%(datasetname))
    indexer = pt.TRECCollectionIndexer("./index")
    indexref = indexer.index(dataset.get_corpus())
    Tindex = pt.IndexFactory.of(indexref)
    return Tindex

Tindex = TerrierIndex(trec_indexing=False, datasetname="antique")

#from pyterrier_bert.pyt_colbert import ColBERTPipeline
#from pyterrier_bert.passager import SlidingWindowPassager, MaxPassage
#colbert = ColBERTPipeline("./colbert.dnn", doc_attr="body", verbose=True)

Baseline = pt.BatchRetrieve(Tindex) 

#DPH_TI = pt.BatchRetrieve(Tindex, wmodel="DPH", verbose=True, metadata=["docno", "title", "body"]) 
#colbert_maxp_DPH_TI = DPH_TI >> colbert 

#TFIDF_TI = pt.BatchRetrieve(Tindex, controls = {"wmodel": "TF_IDF"}, verbose=True, metadata=["docno", "title", "body"])
#colbert_maxp_TFIDF_TI = TFIDF_TI >> colbert

#BM25_TI = pt.BatchRetrieve(Tindex, wmodel="BM25", verbose=True, metadata=["docno", "title", "body"])
#colbert_maxp_BM25_TI = BM25_TI >> colbert

pt.Experiment(
    [Baseline, DPH_TI, TFIDF_TI, BM25_TI, colbert_maxp_DPH_TI, colbert_maxp_TFIDF_TI,colbert_maxp_BM25_TI, faissCol_retr], 
    dataset.get_topics('train'), 
    dataset.get_qrels('train'), 
    eval_metrics=["map", "P_10", "recip_rank", "num_rel_ret"], 
    names=["Baseline", "DPH_TI", "TFIDF_TI", "BM25_TI", "DPH_colbert","TFDIF_colbert", "BM25_colbert","faissCol_colbert"])

import pandas as pd
import matplotlib.pyplot as plt
#values = [0,0.1,1]
#name = ["Baseline", "DPH_TI", "TFIDF_TI", "BM25_TI", "DPH_colbert","TFDIF_colbert", "BM25_colbert","faissCol_colbert"]

vals = pt.Experiment(
    [Baseline, DPH_TI, TFIDF_TI, BM25_TI, colbert_maxp_DPH_TI, colbert_maxp_TFIDF_TI,colbert_maxp_BM25_TI, faissCol_retr], 
    dataset.get_topics(), 
    dataset.get_qrels(), 
    eval_metrics=["iprec_at_recall"], 
    names=["Baseline", "DPH_TI", "TFIDF_TI", "BM25_TI", "DPH_colbert","TFDIF_colbert", "BM25_colbert","faissCol_colbert"])

#shows comparisons of 
vals.set_index('name', inplace=True)
vals.plot()
vals.xlabel("Ranking System")
vals.ylabel("Precision")

import pandas as pd
import matplotlib.pyplot as plt

def deltas(measure,querydict):
  Baselineperquery = pt.Experiment(
    [Baseline], 
    dataset.get_topics(), 
    dataset.get_qrels(), 
    eval_metrics=[measure], 
    names=["Baseline"],
    perquery=True)

  Colbertperquery = pt.Experiment(
    [faissCol_retr], 
    dataset.get_topics(), 
    dataset.get_qrels(), 
    eval_metrics=[measure], 
    names=["ColBert"],
    perquery=True)


  newdf = pd.merge(Colbertperquery,Baselineperquery, on='qid',how='inner')
  queries = []
  deltas = []
  for index, row in newdf.iterrows():
    queries.append(n[row['qid']]['query'])
    deltas.append(row["value_x"]-row["value_y"])
  plt.bar(queries,deltas, width=1)
  plt.rcParams["figure.figsize"] = (27, 27)
  plt.xticks(labels=None,rotation=90)

querymismatch = pd.DataFrame([["1", "hate"]], columns=["qid", "query"])
#'data systems' is in reference to 'storage system', and not other references like 'systems of linear equations'
#TODO - display below trnaforms to demonstrate its functioning visually
Baseline.transform(querymismatch)
#faissCol_retr.transform(querymismatch)

faissCol_retr.transform(querymismatch)

def mismatchsnippet():
  dataset = pt.get_dataset("antique")
  ds = dataset.get_corpus()
  
  f = open(ds[0],'r')
  for x in f:
    docno, passage = x.split("\t")
    if docno=="165751_0":
      print(passage)

!nvidia-smi

t=dataset.get_topics()
t.set_index('qid', inplace=True)
n=t.to_dict('index')
deltas("map",n)

#Can produce a way to evaluate the scale of the dataset that the
#system can handle (antiq is bigger):
#antique eval metrics & recall precision graph

#Delta Graph for Baseline (Batch retrieve) and colBert for the set of queries given in antique set

#Comment on:
#"undiscovered" matches compared to baseline (antique)
#show that the number of relevant documents retrieved are more?

#Todo - make notebook a pip installable package