# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StorageVirtualMachineArgs', 'StorageVirtualMachine']

@pulumi.input_type
class StorageVirtualMachineArgs:
    def __init__(__self__, *,
                 file_system_id: pulumi.Input[str],
                 active_directory_configuration: Optional[pulumi.Input['StorageVirtualMachineActiveDirectoryConfigurationArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 root_volume_security_style: Optional[pulumi.Input[str]] = None,
                 svm_admin_password: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['StorageVirtualMachineTagArgs']]]] = None):
        """
        The set of arguments for constructing a StorageVirtualMachine resource.
        """
        pulumi.set(__self__, "file_system_id", file_system_id)
        if active_directory_configuration is not None:
            pulumi.set(__self__, "active_directory_configuration", active_directory_configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if root_volume_security_style is not None:
            pulumi.set(__self__, "root_volume_security_style", root_volume_security_style)
        if svm_admin_password is not None:
            pulumi.set(__self__, "svm_admin_password", svm_admin_password)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "file_system_id", value)

    @property
    @pulumi.getter(name="activeDirectoryConfiguration")
    def active_directory_configuration(self) -> Optional[pulumi.Input['StorageVirtualMachineActiveDirectoryConfigurationArgs']]:
        return pulumi.get(self, "active_directory_configuration")

    @active_directory_configuration.setter
    def active_directory_configuration(self, value: Optional[pulumi.Input['StorageVirtualMachineActiveDirectoryConfigurationArgs']]):
        pulumi.set(self, "active_directory_configuration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="rootVolumeSecurityStyle")
    def root_volume_security_style(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "root_volume_security_style")

    @root_volume_security_style.setter
    def root_volume_security_style(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_volume_security_style", value)

    @property
    @pulumi.getter(name="svmAdminPassword")
    def svm_admin_password(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "svm_admin_password")

    @svm_admin_password.setter
    def svm_admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "svm_admin_password", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageVirtualMachineTagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageVirtualMachineTagArgs']]]]):
        pulumi.set(self, "tags", value)


warnings.warn("""StorageVirtualMachine is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)


class StorageVirtualMachine(pulumi.CustomResource):
    warnings.warn("""StorageVirtualMachine is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_directory_configuration: Optional[pulumi.Input[pulumi.InputType['StorageVirtualMachineActiveDirectoryConfigurationArgs']]] = None,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 root_volume_security_style: Optional[pulumi.Input[str]] = None,
                 svm_admin_password: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StorageVirtualMachineTagArgs']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::FSx::StorageVirtualMachine

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StorageVirtualMachineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::FSx::StorageVirtualMachine

        :param str resource_name: The name of the resource.
        :param StorageVirtualMachineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StorageVirtualMachineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_directory_configuration: Optional[pulumi.Input[pulumi.InputType['StorageVirtualMachineActiveDirectoryConfigurationArgs']]] = None,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 root_volume_security_style: Optional[pulumi.Input[str]] = None,
                 svm_admin_password: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StorageVirtualMachineTagArgs']]]]] = None,
                 __props__=None):
        pulumi.log.warn("""StorageVirtualMachine is deprecated: StorageVirtualMachine is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""")
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StorageVirtualMachineArgs.__new__(StorageVirtualMachineArgs)

            __props__.__dict__["active_directory_configuration"] = active_directory_configuration
            if file_system_id is None and not opts.urn:
                raise TypeError("Missing required property 'file_system_id'")
            __props__.__dict__["file_system_id"] = file_system_id
            __props__.__dict__["name"] = name
            __props__.__dict__["root_volume_security_style"] = root_volume_security_style
            __props__.__dict__["svm_admin_password"] = svm_admin_password
            __props__.__dict__["tags"] = tags
            __props__.__dict__["resource_arn"] = None
            __props__.__dict__["storage_virtual_machine_id"] = None
            __props__.__dict__["u_uid"] = None
        super(StorageVirtualMachine, __self__).__init__(
            'aws-native:fsx:StorageVirtualMachine',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'StorageVirtualMachine':
        """
        Get an existing StorageVirtualMachine resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = StorageVirtualMachineArgs.__new__(StorageVirtualMachineArgs)

        __props__.__dict__["active_directory_configuration"] = None
        __props__.__dict__["file_system_id"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["resource_arn"] = None
        __props__.__dict__["root_volume_security_style"] = None
        __props__.__dict__["storage_virtual_machine_id"] = None
        __props__.__dict__["svm_admin_password"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["u_uid"] = None
        return StorageVirtualMachine(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activeDirectoryConfiguration")
    def active_directory_configuration(self) -> pulumi.Output[Optional['outputs.StorageVirtualMachineActiveDirectoryConfiguration']]:
        return pulumi.get(self, "active_directory_configuration")

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceARN")
    def resource_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "resource_arn")

    @property
    @pulumi.getter(name="rootVolumeSecurityStyle")
    def root_volume_security_style(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "root_volume_security_style")

    @property
    @pulumi.getter(name="storageVirtualMachineId")
    def storage_virtual_machine_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "storage_virtual_machine_id")

    @property
    @pulumi.getter(name="svmAdminPassword")
    def svm_admin_password(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "svm_admin_password")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.StorageVirtualMachineTag']]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="uUID")
    def u_uid(self) -> pulumi.Output[str]:
        return pulumi.get(self, "u_uid")

