# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ConnectionApiKeyAuthParameters',
    'ConnectionAuthParameters',
    'ConnectionBasicAuthParameters',
    'ConnectionClientParameters',
    'ConnectionHttpParameters',
    'ConnectionOAuthParameters',
    'ConnectionParameter',
    'EndpointEventBus',
    'EndpointFailoverConfig',
    'EndpointPrimary',
    'EndpointReplicationConfig',
    'EndpointRoutingConfig',
    'EndpointSecondary',
    'EventBusPolicyCondition',
    'EventBusTagEntry',
    'RuleAwsVpcConfiguration',
    'RuleBatchArrayProperties',
    'RuleBatchParameters',
    'RuleBatchRetryStrategy',
    'RuleCapacityProviderStrategyItem',
    'RuleDeadLetterConfig',
    'RuleEcsParameters',
    'RuleHttpParameters',
    'RuleInputTransformer',
    'RuleKinesisParameters',
    'RuleNetworkConfiguration',
    'RulePlacementConstraint',
    'RulePlacementStrategy',
    'RuleRedshiftDataParameters',
    'RuleRetryPolicy',
    'RuleRunCommandParameters',
    'RuleRunCommandTarget',
    'RuleSageMakerPipelineParameter',
    'RuleSageMakerPipelineParameters',
    'RuleSqsParameters',
    'RuleTag',
    'RuleTarget',
]

@pulumi.output_type
class ConnectionApiKeyAuthParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKeyName":
            suggest = "api_key_name"
        elif key == "apiKeyValue":
            suggest = "api_key_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionApiKeyAuthParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionApiKeyAuthParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionApiKeyAuthParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key_name: str,
                 api_key_value: str):
        pulumi.set(__self__, "api_key_name", api_key_name)
        pulumi.set(__self__, "api_key_value", api_key_value)

    @property
    @pulumi.getter(name="apiKeyName")
    def api_key_name(self) -> str:
        return pulumi.get(self, "api_key_name")

    @property
    @pulumi.getter(name="apiKeyValue")
    def api_key_value(self) -> str:
        return pulumi.get(self, "api_key_value")


@pulumi.output_type
class ConnectionAuthParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKeyAuthParameters":
            suggest = "api_key_auth_parameters"
        elif key == "basicAuthParameters":
            suggest = "basic_auth_parameters"
        elif key == "invocationHttpParameters":
            suggest = "invocation_http_parameters"
        elif key == "oAuthParameters":
            suggest = "o_auth_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key_auth_parameters: Optional['outputs.ConnectionApiKeyAuthParameters'] = None,
                 basic_auth_parameters: Optional['outputs.ConnectionBasicAuthParameters'] = None,
                 invocation_http_parameters: Optional['outputs.ConnectionHttpParameters'] = None,
                 o_auth_parameters: Optional['outputs.ConnectionOAuthParameters'] = None):
        if api_key_auth_parameters is not None:
            pulumi.set(__self__, "api_key_auth_parameters", api_key_auth_parameters)
        if basic_auth_parameters is not None:
            pulumi.set(__self__, "basic_auth_parameters", basic_auth_parameters)
        if invocation_http_parameters is not None:
            pulumi.set(__self__, "invocation_http_parameters", invocation_http_parameters)
        if o_auth_parameters is not None:
            pulumi.set(__self__, "o_auth_parameters", o_auth_parameters)

    @property
    @pulumi.getter(name="apiKeyAuthParameters")
    def api_key_auth_parameters(self) -> Optional['outputs.ConnectionApiKeyAuthParameters']:
        return pulumi.get(self, "api_key_auth_parameters")

    @property
    @pulumi.getter(name="basicAuthParameters")
    def basic_auth_parameters(self) -> Optional['outputs.ConnectionBasicAuthParameters']:
        return pulumi.get(self, "basic_auth_parameters")

    @property
    @pulumi.getter(name="invocationHttpParameters")
    def invocation_http_parameters(self) -> Optional['outputs.ConnectionHttpParameters']:
        return pulumi.get(self, "invocation_http_parameters")

    @property
    @pulumi.getter(name="oAuthParameters")
    def o_auth_parameters(self) -> Optional['outputs.ConnectionOAuthParameters']:
        return pulumi.get(self, "o_auth_parameters")


@pulumi.output_type
class ConnectionBasicAuthParameters(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")


@pulumi.output_type
class ConnectionClientParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientID":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionClientParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionClientParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionClientParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 client_secret: str):
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)

    @property
    @pulumi.getter(name="clientID")
    def client_id(self) -> str:
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> str:
        return pulumi.get(self, "client_secret")


@pulumi.output_type
class ConnectionHttpParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bodyParameters":
            suggest = "body_parameters"
        elif key == "headerParameters":
            suggest = "header_parameters"
        elif key == "queryStringParameters":
            suggest = "query_string_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionHttpParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionHttpParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionHttpParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 body_parameters: Optional[Sequence['outputs.ConnectionParameter']] = None,
                 header_parameters: Optional[Sequence['outputs.ConnectionParameter']] = None,
                 query_string_parameters: Optional[Sequence['outputs.ConnectionParameter']] = None):
        if body_parameters is not None:
            pulumi.set(__self__, "body_parameters", body_parameters)
        if header_parameters is not None:
            pulumi.set(__self__, "header_parameters", header_parameters)
        if query_string_parameters is not None:
            pulumi.set(__self__, "query_string_parameters", query_string_parameters)

    @property
    @pulumi.getter(name="bodyParameters")
    def body_parameters(self) -> Optional[Sequence['outputs.ConnectionParameter']]:
        return pulumi.get(self, "body_parameters")

    @property
    @pulumi.getter(name="headerParameters")
    def header_parameters(self) -> Optional[Sequence['outputs.ConnectionParameter']]:
        return pulumi.get(self, "header_parameters")

    @property
    @pulumi.getter(name="queryStringParameters")
    def query_string_parameters(self) -> Optional[Sequence['outputs.ConnectionParameter']]:
        return pulumi.get(self, "query_string_parameters")


@pulumi.output_type
class ConnectionOAuthParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationEndpoint":
            suggest = "authorization_endpoint"
        elif key == "clientParameters":
            suggest = "client_parameters"
        elif key == "httpMethod":
            suggest = "http_method"
        elif key == "oAuthHttpParameters":
            suggest = "o_auth_http_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionOAuthParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionOAuthParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionOAuthParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_endpoint: str,
                 client_parameters: 'outputs.ConnectionClientParameters',
                 http_method: 'ConnectionOAuthParametersHttpMethod',
                 o_auth_http_parameters: Optional['outputs.ConnectionHttpParameters'] = None):
        pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        pulumi.set(__self__, "client_parameters", client_parameters)
        pulumi.set(__self__, "http_method", http_method)
        if o_auth_http_parameters is not None:
            pulumi.set(__self__, "o_auth_http_parameters", o_auth_http_parameters)

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> str:
        return pulumi.get(self, "authorization_endpoint")

    @property
    @pulumi.getter(name="clientParameters")
    def client_parameters(self) -> 'outputs.ConnectionClientParameters':
        return pulumi.get(self, "client_parameters")

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> 'ConnectionOAuthParametersHttpMethod':
        return pulumi.get(self, "http_method")

    @property
    @pulumi.getter(name="oAuthHttpParameters")
    def o_auth_http_parameters(self) -> Optional['outputs.ConnectionHttpParameters']:
        return pulumi.get(self, "o_auth_http_parameters")


@pulumi.output_type
class ConnectionParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isValueSecret":
            suggest = "is_value_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: str,
                 value: str,
                 is_value_secret: Optional[bool] = None):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)
        if is_value_secret is not None:
            pulumi.set(__self__, "is_value_secret", is_value_secret)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="isValueSecret")
    def is_value_secret(self) -> Optional[bool]:
        return pulumi.get(self, "is_value_secret")


@pulumi.output_type
class EndpointEventBus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventBusArn":
            suggest = "event_bus_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointEventBus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointEventBus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointEventBus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_bus_arn: str):
        pulumi.set(__self__, "event_bus_arn", event_bus_arn)

    @property
    @pulumi.getter(name="eventBusArn")
    def event_bus_arn(self) -> str:
        return pulumi.get(self, "event_bus_arn")


@pulumi.output_type
class EndpointFailoverConfig(dict):
    def __init__(__self__, *,
                 primary: 'outputs.EndpointPrimary',
                 secondary: 'outputs.EndpointSecondary'):
        pulumi.set(__self__, "primary", primary)
        pulumi.set(__self__, "secondary", secondary)

    @property
    @pulumi.getter
    def primary(self) -> 'outputs.EndpointPrimary':
        return pulumi.get(self, "primary")

    @property
    @pulumi.getter
    def secondary(self) -> 'outputs.EndpointSecondary':
        return pulumi.get(self, "secondary")


@pulumi.output_type
class EndpointPrimary(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthCheck":
            suggest = "health_check"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointPrimary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointPrimary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointPrimary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health_check: str):
        pulumi.set(__self__, "health_check", health_check)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> str:
        return pulumi.get(self, "health_check")


@pulumi.output_type
class EndpointReplicationConfig(dict):
    def __init__(__self__, *,
                 state: 'EndpointReplicationState'):
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> 'EndpointReplicationState':
        return pulumi.get(self, "state")


@pulumi.output_type
class EndpointRoutingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failoverConfig":
            suggest = "failover_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointRoutingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointRoutingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointRoutingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failover_config: 'outputs.EndpointFailoverConfig'):
        pulumi.set(__self__, "failover_config", failover_config)

    @property
    @pulumi.getter(name="failoverConfig")
    def failover_config(self) -> 'outputs.EndpointFailoverConfig':
        return pulumi.get(self, "failover_config")


@pulumi.output_type
class EndpointSecondary(dict):
    def __init__(__self__, *,
                 route: str):
        pulumi.set(__self__, "route", route)

    @property
    @pulumi.getter
    def route(self) -> str:
        return pulumi.get(self, "route")


@pulumi.output_type
class EventBusPolicyCondition(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 type: Optional[str] = None,
                 value: Optional[str] = None):
        if key is not None:
            pulumi.set(__self__, "key", key)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class EventBusTagEntry(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class RuleAwsVpcConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignPublicIp":
            suggest = "assign_public_ip"
        elif key == "securityGroups":
            suggest = "security_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleAwsVpcConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleAwsVpcConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleAwsVpcConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnets: Sequence[str],
                 assign_public_ip: Optional[str] = None,
                 security_groups: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "subnets", subnets)
        if assign_public_ip is not None:
            pulumi.set(__self__, "assign_public_ip", assign_public_ip)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[str]:
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter(name="assignPublicIp")
    def assign_public_ip(self) -> Optional[str]:
        return pulumi.get(self, "assign_public_ip")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "security_groups")


@pulumi.output_type
class RuleBatchArrayProperties(dict):
    def __init__(__self__, *,
                 size: Optional[int] = None):
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def size(self) -> Optional[int]:
        return pulumi.get(self, "size")


@pulumi.output_type
class RuleBatchParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobDefinition":
            suggest = "job_definition"
        elif key == "jobName":
            suggest = "job_name"
        elif key == "arrayProperties":
            suggest = "array_properties"
        elif key == "retryStrategy":
            suggest = "retry_strategy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleBatchParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleBatchParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleBatchParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_definition: str,
                 job_name: str,
                 array_properties: Optional['outputs.RuleBatchArrayProperties'] = None,
                 retry_strategy: Optional['outputs.RuleBatchRetryStrategy'] = None):
        pulumi.set(__self__, "job_definition", job_definition)
        pulumi.set(__self__, "job_name", job_name)
        if array_properties is not None:
            pulumi.set(__self__, "array_properties", array_properties)
        if retry_strategy is not None:
            pulumi.set(__self__, "retry_strategy", retry_strategy)

    @property
    @pulumi.getter(name="jobDefinition")
    def job_definition(self) -> str:
        return pulumi.get(self, "job_definition")

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> str:
        return pulumi.get(self, "job_name")

    @property
    @pulumi.getter(name="arrayProperties")
    def array_properties(self) -> Optional['outputs.RuleBatchArrayProperties']:
        return pulumi.get(self, "array_properties")

    @property
    @pulumi.getter(name="retryStrategy")
    def retry_strategy(self) -> Optional['outputs.RuleBatchRetryStrategy']:
        return pulumi.get(self, "retry_strategy")


@pulumi.output_type
class RuleBatchRetryStrategy(dict):
    def __init__(__self__, *,
                 attempts: Optional[int] = None):
        if attempts is not None:
            pulumi.set(__self__, "attempts", attempts)

    @property
    @pulumi.getter
    def attempts(self) -> Optional[int]:
        return pulumi.get(self, "attempts")


@pulumi.output_type
class RuleCapacityProviderStrategyItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityProvider":
            suggest = "capacity_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleCapacityProviderStrategyItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleCapacityProviderStrategyItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleCapacityProviderStrategyItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_provider: str,
                 base: Optional[int] = None,
                 weight: Optional[int] = None):
        pulumi.set(__self__, "capacity_provider", capacity_provider)
        if base is not None:
            pulumi.set(__self__, "base", base)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="capacityProvider")
    def capacity_provider(self) -> str:
        return pulumi.get(self, "capacity_provider")

    @property
    @pulumi.getter
    def base(self) -> Optional[int]:
        return pulumi.get(self, "base")

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        return pulumi.get(self, "weight")


@pulumi.output_type
class RuleDeadLetterConfig(dict):
    def __init__(__self__, *,
                 arn: Optional[str] = None):
        if arn is not None:
            pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        return pulumi.get(self, "arn")


@pulumi.output_type
class RuleEcsParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskDefinitionArn":
            suggest = "task_definition_arn"
        elif key == "capacityProviderStrategy":
            suggest = "capacity_provider_strategy"
        elif key == "enableECSManagedTags":
            suggest = "enable_ecs_managed_tags"
        elif key == "enableExecuteCommand":
            suggest = "enable_execute_command"
        elif key == "launchType":
            suggest = "launch_type"
        elif key == "networkConfiguration":
            suggest = "network_configuration"
        elif key == "placementConstraints":
            suggest = "placement_constraints"
        elif key == "placementStrategies":
            suggest = "placement_strategies"
        elif key == "platformVersion":
            suggest = "platform_version"
        elif key == "propagateTags":
            suggest = "propagate_tags"
        elif key == "referenceId":
            suggest = "reference_id"
        elif key == "tagList":
            suggest = "tag_list"
        elif key == "taskCount":
            suggest = "task_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleEcsParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleEcsParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleEcsParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 task_definition_arn: str,
                 capacity_provider_strategy: Optional[Sequence['outputs.RuleCapacityProviderStrategyItem']] = None,
                 enable_ecs_managed_tags: Optional[bool] = None,
                 enable_execute_command: Optional[bool] = None,
                 group: Optional[str] = None,
                 launch_type: Optional[str] = None,
                 network_configuration: Optional['outputs.RuleNetworkConfiguration'] = None,
                 placement_constraints: Optional[Sequence['outputs.RulePlacementConstraint']] = None,
                 placement_strategies: Optional[Sequence['outputs.RulePlacementStrategy']] = None,
                 platform_version: Optional[str] = None,
                 propagate_tags: Optional[str] = None,
                 reference_id: Optional[str] = None,
                 tag_list: Optional[Sequence['outputs.RuleTag']] = None,
                 task_count: Optional[int] = None):
        pulumi.set(__self__, "task_definition_arn", task_definition_arn)
        if capacity_provider_strategy is not None:
            pulumi.set(__self__, "capacity_provider_strategy", capacity_provider_strategy)
        if enable_ecs_managed_tags is not None:
            pulumi.set(__self__, "enable_ecs_managed_tags", enable_ecs_managed_tags)
        if enable_execute_command is not None:
            pulumi.set(__self__, "enable_execute_command", enable_execute_command)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if launch_type is not None:
            pulumi.set(__self__, "launch_type", launch_type)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if placement_constraints is not None:
            pulumi.set(__self__, "placement_constraints", placement_constraints)
        if placement_strategies is not None:
            pulumi.set(__self__, "placement_strategies", placement_strategies)
        if platform_version is not None:
            pulumi.set(__self__, "platform_version", platform_version)
        if propagate_tags is not None:
            pulumi.set(__self__, "propagate_tags", propagate_tags)
        if reference_id is not None:
            pulumi.set(__self__, "reference_id", reference_id)
        if tag_list is not None:
            pulumi.set(__self__, "tag_list", tag_list)
        if task_count is not None:
            pulumi.set(__self__, "task_count", task_count)

    @property
    @pulumi.getter(name="taskDefinitionArn")
    def task_definition_arn(self) -> str:
        return pulumi.get(self, "task_definition_arn")

    @property
    @pulumi.getter(name="capacityProviderStrategy")
    def capacity_provider_strategy(self) -> Optional[Sequence['outputs.RuleCapacityProviderStrategyItem']]:
        return pulumi.get(self, "capacity_provider_strategy")

    @property
    @pulumi.getter(name="enableECSManagedTags")
    def enable_ecs_managed_tags(self) -> Optional[bool]:
        return pulumi.get(self, "enable_ecs_managed_tags")

    @property
    @pulumi.getter(name="enableExecuteCommand")
    def enable_execute_command(self) -> Optional[bool]:
        return pulumi.get(self, "enable_execute_command")

    @property
    @pulumi.getter
    def group(self) -> Optional[str]:
        return pulumi.get(self, "group")

    @property
    @pulumi.getter(name="launchType")
    def launch_type(self) -> Optional[str]:
        return pulumi.get(self, "launch_type")

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional['outputs.RuleNetworkConfiguration']:
        return pulumi.get(self, "network_configuration")

    @property
    @pulumi.getter(name="placementConstraints")
    def placement_constraints(self) -> Optional[Sequence['outputs.RulePlacementConstraint']]:
        return pulumi.get(self, "placement_constraints")

    @property
    @pulumi.getter(name="placementStrategies")
    def placement_strategies(self) -> Optional[Sequence['outputs.RulePlacementStrategy']]:
        return pulumi.get(self, "placement_strategies")

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> Optional[str]:
        return pulumi.get(self, "platform_version")

    @property
    @pulumi.getter(name="propagateTags")
    def propagate_tags(self) -> Optional[str]:
        return pulumi.get(self, "propagate_tags")

    @property
    @pulumi.getter(name="referenceId")
    def reference_id(self) -> Optional[str]:
        return pulumi.get(self, "reference_id")

    @property
    @pulumi.getter(name="tagList")
    def tag_list(self) -> Optional[Sequence['outputs.RuleTag']]:
        return pulumi.get(self, "tag_list")

    @property
    @pulumi.getter(name="taskCount")
    def task_count(self) -> Optional[int]:
        return pulumi.get(self, "task_count")


@pulumi.output_type
class RuleHttpParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerParameters":
            suggest = "header_parameters"
        elif key == "pathParameterValues":
            suggest = "path_parameter_values"
        elif key == "queryStringParameters":
            suggest = "query_string_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleHttpParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleHttpParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleHttpParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_parameters: Optional[Any] = None,
                 path_parameter_values: Optional[Sequence[str]] = None,
                 query_string_parameters: Optional[Any] = None):
        if header_parameters is not None:
            pulumi.set(__self__, "header_parameters", header_parameters)
        if path_parameter_values is not None:
            pulumi.set(__self__, "path_parameter_values", path_parameter_values)
        if query_string_parameters is not None:
            pulumi.set(__self__, "query_string_parameters", query_string_parameters)

    @property
    @pulumi.getter(name="headerParameters")
    def header_parameters(self) -> Optional[Any]:
        return pulumi.get(self, "header_parameters")

    @property
    @pulumi.getter(name="pathParameterValues")
    def path_parameter_values(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "path_parameter_values")

    @property
    @pulumi.getter(name="queryStringParameters")
    def query_string_parameters(self) -> Optional[Any]:
        return pulumi.get(self, "query_string_parameters")


@pulumi.output_type
class RuleInputTransformer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputTemplate":
            suggest = "input_template"
        elif key == "inputPathsMap":
            suggest = "input_paths_map"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleInputTransformer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleInputTransformer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleInputTransformer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_template: str,
                 input_paths_map: Optional[Any] = None):
        pulumi.set(__self__, "input_template", input_template)
        if input_paths_map is not None:
            pulumi.set(__self__, "input_paths_map", input_paths_map)

    @property
    @pulumi.getter(name="inputTemplate")
    def input_template(self) -> str:
        return pulumi.get(self, "input_template")

    @property
    @pulumi.getter(name="inputPathsMap")
    def input_paths_map(self) -> Optional[Any]:
        return pulumi.get(self, "input_paths_map")


@pulumi.output_type
class RuleKinesisParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "partitionKeyPath":
            suggest = "partition_key_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleKinesisParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleKinesisParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleKinesisParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 partition_key_path: str):
        pulumi.set(__self__, "partition_key_path", partition_key_path)

    @property
    @pulumi.getter(name="partitionKeyPath")
    def partition_key_path(self) -> str:
        return pulumi.get(self, "partition_key_path")


@pulumi.output_type
class RuleNetworkConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsVpcConfiguration":
            suggest = "aws_vpc_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_vpc_configuration: Optional['outputs.RuleAwsVpcConfiguration'] = None):
        if aws_vpc_configuration is not None:
            pulumi.set(__self__, "aws_vpc_configuration", aws_vpc_configuration)

    @property
    @pulumi.getter(name="awsVpcConfiguration")
    def aws_vpc_configuration(self) -> Optional['outputs.RuleAwsVpcConfiguration']:
        return pulumi.get(self, "aws_vpc_configuration")


@pulumi.output_type
class RulePlacementConstraint(dict):
    def __init__(__self__, *,
                 expression: Optional[str] = None,
                 type: Optional[str] = None):
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def expression(self) -> Optional[str]:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class RulePlacementStrategy(dict):
    def __init__(__self__, *,
                 field: Optional[str] = None,
                 type: Optional[str] = None):
        if field is not None:
            pulumi.set(__self__, "field", field)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def field(self) -> Optional[str]:
        return pulumi.get(self, "field")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class RuleRedshiftDataParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dbUser":
            suggest = "db_user"
        elif key == "secretManagerArn":
            suggest = "secret_manager_arn"
        elif key == "statementName":
            suggest = "statement_name"
        elif key == "withEvent":
            suggest = "with_event"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleRedshiftDataParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleRedshiftDataParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleRedshiftDataParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database: str,
                 sql: str,
                 db_user: Optional[str] = None,
                 secret_manager_arn: Optional[str] = None,
                 statement_name: Optional[str] = None,
                 with_event: Optional[bool] = None):
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "sql", sql)
        if db_user is not None:
            pulumi.set(__self__, "db_user", db_user)
        if secret_manager_arn is not None:
            pulumi.set(__self__, "secret_manager_arn", secret_manager_arn)
        if statement_name is not None:
            pulumi.set(__self__, "statement_name", statement_name)
        if with_event is not None:
            pulumi.set(__self__, "with_event", with_event)

    @property
    @pulumi.getter
    def database(self) -> str:
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def sql(self) -> str:
        return pulumi.get(self, "sql")

    @property
    @pulumi.getter(name="dbUser")
    def db_user(self) -> Optional[str]:
        return pulumi.get(self, "db_user")

    @property
    @pulumi.getter(name="secretManagerArn")
    def secret_manager_arn(self) -> Optional[str]:
        return pulumi.get(self, "secret_manager_arn")

    @property
    @pulumi.getter(name="statementName")
    def statement_name(self) -> Optional[str]:
        return pulumi.get(self, "statement_name")

    @property
    @pulumi.getter(name="withEvent")
    def with_event(self) -> Optional[bool]:
        return pulumi.get(self, "with_event")


@pulumi.output_type
class RuleRetryPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumEventAgeInSeconds":
            suggest = "maximum_event_age_in_seconds"
        elif key == "maximumRetryAttempts":
            suggest = "maximum_retry_attempts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleRetryPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleRetryPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleRetryPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_event_age_in_seconds: Optional[int] = None,
                 maximum_retry_attempts: Optional[int] = None):
        if maximum_event_age_in_seconds is not None:
            pulumi.set(__self__, "maximum_event_age_in_seconds", maximum_event_age_in_seconds)
        if maximum_retry_attempts is not None:
            pulumi.set(__self__, "maximum_retry_attempts", maximum_retry_attempts)

    @property
    @pulumi.getter(name="maximumEventAgeInSeconds")
    def maximum_event_age_in_seconds(self) -> Optional[int]:
        return pulumi.get(self, "maximum_event_age_in_seconds")

    @property
    @pulumi.getter(name="maximumRetryAttempts")
    def maximum_retry_attempts(self) -> Optional[int]:
        return pulumi.get(self, "maximum_retry_attempts")


@pulumi.output_type
class RuleRunCommandParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runCommandTargets":
            suggest = "run_command_targets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleRunCommandParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleRunCommandParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleRunCommandParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 run_command_targets: Sequence['outputs.RuleRunCommandTarget']):
        pulumi.set(__self__, "run_command_targets", run_command_targets)

    @property
    @pulumi.getter(name="runCommandTargets")
    def run_command_targets(self) -> Sequence['outputs.RuleRunCommandTarget']:
        return pulumi.get(self, "run_command_targets")


@pulumi.output_type
class RuleRunCommandTarget(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str]):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")


@pulumi.output_type
class RuleSageMakerPipelineParameter(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class RuleSageMakerPipelineParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pipelineParameterList":
            suggest = "pipeline_parameter_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleSageMakerPipelineParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleSageMakerPipelineParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleSageMakerPipelineParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pipeline_parameter_list: Optional[Sequence['outputs.RuleSageMakerPipelineParameter']] = None):
        if pipeline_parameter_list is not None:
            pulumi.set(__self__, "pipeline_parameter_list", pipeline_parameter_list)

    @property
    @pulumi.getter(name="pipelineParameterList")
    def pipeline_parameter_list(self) -> Optional[Sequence['outputs.RuleSageMakerPipelineParameter']]:
        return pulumi.get(self, "pipeline_parameter_list")


@pulumi.output_type
class RuleSqsParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageGroupId":
            suggest = "message_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleSqsParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleSqsParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleSqsParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message_group_id: str):
        pulumi.set(__self__, "message_group_id", message_group_id)

    @property
    @pulumi.getter(name="messageGroupId")
    def message_group_id(self) -> str:
        return pulumi.get(self, "message_group_id")


@pulumi.output_type
class RuleTag(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 value: Optional[str] = None):
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class RuleTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchParameters":
            suggest = "batch_parameters"
        elif key == "deadLetterConfig":
            suggest = "dead_letter_config"
        elif key == "ecsParameters":
            suggest = "ecs_parameters"
        elif key == "httpParameters":
            suggest = "http_parameters"
        elif key == "inputPath":
            suggest = "input_path"
        elif key == "inputTransformer":
            suggest = "input_transformer"
        elif key == "kinesisParameters":
            suggest = "kinesis_parameters"
        elif key == "redshiftDataParameters":
            suggest = "redshift_data_parameters"
        elif key == "retryPolicy":
            suggest = "retry_policy"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "runCommandParameters":
            suggest = "run_command_parameters"
        elif key == "sageMakerPipelineParameters":
            suggest = "sage_maker_pipeline_parameters"
        elif key == "sqsParameters":
            suggest = "sqs_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arn: str,
                 id: str,
                 batch_parameters: Optional['outputs.RuleBatchParameters'] = None,
                 dead_letter_config: Optional['outputs.RuleDeadLetterConfig'] = None,
                 ecs_parameters: Optional['outputs.RuleEcsParameters'] = None,
                 http_parameters: Optional['outputs.RuleHttpParameters'] = None,
                 input: Optional[str] = None,
                 input_path: Optional[str] = None,
                 input_transformer: Optional['outputs.RuleInputTransformer'] = None,
                 kinesis_parameters: Optional['outputs.RuleKinesisParameters'] = None,
                 redshift_data_parameters: Optional['outputs.RuleRedshiftDataParameters'] = None,
                 retry_policy: Optional['outputs.RuleRetryPolicy'] = None,
                 role_arn: Optional[str] = None,
                 run_command_parameters: Optional['outputs.RuleRunCommandParameters'] = None,
                 sage_maker_pipeline_parameters: Optional['outputs.RuleSageMakerPipelineParameters'] = None,
                 sqs_parameters: Optional['outputs.RuleSqsParameters'] = None):
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "id", id)
        if batch_parameters is not None:
            pulumi.set(__self__, "batch_parameters", batch_parameters)
        if dead_letter_config is not None:
            pulumi.set(__self__, "dead_letter_config", dead_letter_config)
        if ecs_parameters is not None:
            pulumi.set(__self__, "ecs_parameters", ecs_parameters)
        if http_parameters is not None:
            pulumi.set(__self__, "http_parameters", http_parameters)
        if input is not None:
            pulumi.set(__self__, "input", input)
        if input_path is not None:
            pulumi.set(__self__, "input_path", input_path)
        if input_transformer is not None:
            pulumi.set(__self__, "input_transformer", input_transformer)
        if kinesis_parameters is not None:
            pulumi.set(__self__, "kinesis_parameters", kinesis_parameters)
        if redshift_data_parameters is not None:
            pulumi.set(__self__, "redshift_data_parameters", redshift_data_parameters)
        if retry_policy is not None:
            pulumi.set(__self__, "retry_policy", retry_policy)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if run_command_parameters is not None:
            pulumi.set(__self__, "run_command_parameters", run_command_parameters)
        if sage_maker_pipeline_parameters is not None:
            pulumi.set(__self__, "sage_maker_pipeline_parameters", sage_maker_pipeline_parameters)
        if sqs_parameters is not None:
            pulumi.set(__self__, "sqs_parameters", sqs_parameters)

    @property
    @pulumi.getter
    def arn(self) -> str:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="batchParameters")
    def batch_parameters(self) -> Optional['outputs.RuleBatchParameters']:
        return pulumi.get(self, "batch_parameters")

    @property
    @pulumi.getter(name="deadLetterConfig")
    def dead_letter_config(self) -> Optional['outputs.RuleDeadLetterConfig']:
        return pulumi.get(self, "dead_letter_config")

    @property
    @pulumi.getter(name="ecsParameters")
    def ecs_parameters(self) -> Optional['outputs.RuleEcsParameters']:
        return pulumi.get(self, "ecs_parameters")

    @property
    @pulumi.getter(name="httpParameters")
    def http_parameters(self) -> Optional['outputs.RuleHttpParameters']:
        return pulumi.get(self, "http_parameters")

    @property
    @pulumi.getter
    def input(self) -> Optional[str]:
        return pulumi.get(self, "input")

    @property
    @pulumi.getter(name="inputPath")
    def input_path(self) -> Optional[str]:
        return pulumi.get(self, "input_path")

    @property
    @pulumi.getter(name="inputTransformer")
    def input_transformer(self) -> Optional['outputs.RuleInputTransformer']:
        return pulumi.get(self, "input_transformer")

    @property
    @pulumi.getter(name="kinesisParameters")
    def kinesis_parameters(self) -> Optional['outputs.RuleKinesisParameters']:
        return pulumi.get(self, "kinesis_parameters")

    @property
    @pulumi.getter(name="redshiftDataParameters")
    def redshift_data_parameters(self) -> Optional['outputs.RuleRedshiftDataParameters']:
        return pulumi.get(self, "redshift_data_parameters")

    @property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> Optional['outputs.RuleRetryPolicy']:
        return pulumi.get(self, "retry_policy")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="runCommandParameters")
    def run_command_parameters(self) -> Optional['outputs.RuleRunCommandParameters']:
        return pulumi.get(self, "run_command_parameters")

    @property
    @pulumi.getter(name="sageMakerPipelineParameters")
    def sage_maker_pipeline_parameters(self) -> Optional['outputs.RuleSageMakerPipelineParameters']:
        return pulumi.get(self, "sage_maker_pipeline_parameters")

    @property
    @pulumi.getter(name="sqsParameters")
    def sqs_parameters(self) -> Optional['outputs.RuleSqsParameters']:
        return pulumi.get(self, "sqs_parameters")


