# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetVPNGatewayResult',
    'AwaitableGetVPNGatewayResult',
    'get_vpn_gateway',
    'get_vpn_gateway_output',
]

@pulumi.output_type
class GetVPNGatewayResult:
    def __init__(__self__, tags=None, v_pn_gateway_id=None):
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if v_pn_gateway_id and not isinstance(v_pn_gateway_id, str):
            raise TypeError("Expected argument 'v_pn_gateway_id' to be a str")
        pulumi.set(__self__, "v_pn_gateway_id", v_pn_gateway_id)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.VPNGatewayTag']]:
        """
        Any tags assigned to the virtual private gateway.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vPNGatewayId")
    def v_pn_gateway_id(self) -> Optional[str]:
        """
        VPN Gateway ID generated by service
        """
        return pulumi.get(self, "v_pn_gateway_id")


class AwaitableGetVPNGatewayResult(GetVPNGatewayResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVPNGatewayResult(
            tags=self.tags,
            v_pn_gateway_id=self.v_pn_gateway_id)


def get_vpn_gateway(v_pn_gateway_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVPNGatewayResult:
    """
    Schema for EC2 VPN Gateway


    :param str v_pn_gateway_id: VPN Gateway ID generated by service
    """
    __args__ = dict()
    __args__['vPNGatewayId'] = v_pn_gateway_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getVPNGateway', __args__, opts=opts, typ=GetVPNGatewayResult).value

    return AwaitableGetVPNGatewayResult(
        tags=__ret__.tags,
        v_pn_gateway_id=__ret__.v_pn_gateway_id)


@_utilities.lift_output_func(get_vpn_gateway)
def get_vpn_gateway_output(v_pn_gateway_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVPNGatewayResult]:
    """
    Schema for EC2 VPN Gateway


    :param str v_pn_gateway_id: VPN Gateway ID generated by service
    """
    ...
