"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDestination = void 0;
/**
 * Use a Lambda Function as the destination for a log subscription.
 * Using this class temporarily until https://github.com/aws/aws-cdk/pull/14222 is merged and released.
 */
class LambdaDestination {
    constructor(fn) {
        this.fn = fn;
    }
    bind() {
        return { arn: this.fn.functionArn };
    }
}
exports.LambdaDestination = LambdaDestination;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGFtYmRhRGVzdGluYXRpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvbGFtYmRhRGVzdGluYXRpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBR0E7OztHQUdHO0FBQ0gsTUFBYSxpQkFBaUI7SUFDNUIsWUFBNkIsRUFBb0I7UUFBcEIsT0FBRSxHQUFGLEVBQUUsQ0FBa0I7SUFBRyxDQUFDO0lBRTlDLElBQUk7UUFDVCxPQUFPLEVBQUUsR0FBRyxFQUFFLElBQUksQ0FBQyxFQUFFLENBQUMsV0FBVyxFQUFFLENBQUM7SUFDdEMsQ0FBQztDQUNGO0FBTkQsOENBTUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBsYW1iZGEgZnJvbSBcIkBhd3MtY2RrL2F3cy1sYW1iZGFcIjtcbmltcG9ydCAqIGFzIGxvZ3MgZnJvbSBcIkBhd3MtY2RrL2F3cy1sb2dzXCI7XG5cbi8qKlxuICogVXNlIGEgTGFtYmRhIEZ1bmN0aW9uIGFzIHRoZSBkZXN0aW5hdGlvbiBmb3IgYSBsb2cgc3Vic2NyaXB0aW9uLlxuICogVXNpbmcgdGhpcyBjbGFzcyB0ZW1wb3JhcmlseSB1bnRpbCBodHRwczovL2dpdGh1Yi5jb20vYXdzL2F3cy1jZGsvcHVsbC8xNDIyMiBpcyBtZXJnZWQgYW5kIHJlbGVhc2VkLlxuICovXG5leHBvcnQgY2xhc3MgTGFtYmRhRGVzdGluYXRpb24gaW1wbGVtZW50cyBsb2dzLklMb2dTdWJzY3JpcHRpb25EZXN0aW5hdGlvbiB7XG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgZm46IGxhbWJkYS5JRnVuY3Rpb24pIHt9XG5cbiAgcHVibGljIGJpbmQoKTogbG9ncy5Mb2dTdWJzY3JpcHRpb25EZXN0aW5hdGlvbkNvbmZpZyB7XG4gICAgcmV0dXJuIHsgYXJuOiB0aGlzLmZuLmZ1bmN0aW9uQXJuIH07XG4gIH1cbn1cbiJdfQ==