import numpy as np

def get_igrf13():
    models=[1900, 1905, 1910, 1915, 1920, 1925, 1930, 1935, 1940, 1945, 1950,
            1955, 1960, 1965, 1970, 1975, 1980, 1985, 1990, 1995, 2000, 2005,
            2010, 2015, 2020, 2020.2]
    coeffs=[[-31543, -2298, 5922, -677, 2905, -1061, 924, 1121, 1022, -1469, -330, 1256, 3, 572, 523, 876, 628, 195, 660, -69, -361, -210, 134, -75, -184, 328, -210, 264, 53, 5, -33, -86, -124, -16, 3, 63, 61, -9, -11, 83, -217, 2, -58, -35, 59, 36, -90, -69, 70, -55, -45, 0, -13, 34, -10, -41, -1, -21, 28, 18, -12, 6, -22, 11, 8, 8, -4, -14, -9, 7, 1, -13, 2, 5, -9, 16, 5, -5, 8, -18, 8, 10, -20, 1, 14, -11, 5, 12, -3, 1, -2, -2, 8, 2, 10, -1, -2, -1, 2, -3, -4, 2, 2, 1, -5, 2, -2, 6, 6, -4, 4, 0, 0, -2, 2, 4, 2, 0, 0, -6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-31464, -2298, 5909, -728, 2928, -1086, 1041, 1065, 1037, -1494, -357, 1239, 34, 635, 480, 880, 643, 203, 653, -77, -380, -201, 146, -65, -192, 328, -193, 259, 56, -1, -32, -93, -125, -26, 11, 62, 60, -7, -11, 86, -221, 4, -57, -32, 57, 32, -92, -67, 70, -54, -46, 0, -14, 33, -11, -41, 0, -20, 28, 18, -12, 6, -22, 11, 8, 8, -4, -15, -9, 7, 1, -13, 2, 5, -8, 16, 5, -5, 8, -18, 8, 10, -20, 1, 14, -11, 5, 12, -3, 1, -2, -2, 8, 2, 10, 0, -2, -1, 2, -3, -4, 2, 2, 1, -5, 2, -2, 6, 6, -4, 4, 0, 0, -2, 2, 4, 2, 0, 0, -6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-31354, -2297, 5898, -769, 2948, -1128, 1176, 1000, 1058, -1524, -389, 1223, 62, 705, 425, 884, 660, 211, 644, -90, -400, -189, 160, -55, -201, 327, -172, 253, 57, -9, -33, -102, -126, -38, 21, 62, 58, -5, -11, 89, -224, 5, -54, -29, 54, 28, -95, -65, 71, -54, -47, 1, -14, 32, -12, -40, 1, -19, 28, 18, -13, 6, -22, 11, 8, 8, -4, -15, -9, 6, 1, -13, 2, 5, -8, 16, 5, -5, 8, -18, 8, 10, -20, 1, 14, -11, 5, 12, -3, 1, -2, -2, 8, 2, 10, 0, -2, -1, 2, -3, -4, 2, 2, 1, -5, 2, -2, 6, 6, -4, 4, 0, 0, -2, 2, 4, 2, 0, 0, -6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-31212, -2306, 5875, -802, 2956, -1191, 1309, 917, 1084, -1559, -421, 1212, 84, 778, 360, 887, 678, 218, 631, -109, -416, -173, 178, -51, -211, 327, -148, 245, 58, -16, -34, -111, -126, -51, 32, 61, 57, -2, -10, 93, -228, 8, -51, -26, 49, 23, -98, -62, 72, -54, -48, 2, -14, 31, -12, -38, 2, -18, 28, 19, -15, 6, -22, 11, 8, 8, -4, -15, -9, 6, 2, -13, 3, 5, -8, 16, 6, -5, 8, -18, 8, 10, -20, 1, 14, -11, 5, 12, -3, 1, -2, -2, 8, 2, 10, 0, -2, -1, 2, -3, -4, 2, 2, 1, -5, 2, -2, 6, 6, -4, 4, 0, 0, -2, 1, 4, 2, 0, 0, -6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-31060, -2317, 5845, -839, 2959, -1259, 1407, 823, 1111, -1600, -445, 1205, 103, 839, 293, 889, 695, 220, 616, -134, -424, -153, 199, -57, -221, 326, -122, 236, 58, -23, -38, -119, -125, -62, 43, 61, 55, 0, -10, 96, -233, 11, -46, -22, 44, 18, -101, -57, 73, -54, -49, 2, -14, 29, -13, -37, 4, -16, 28, 19, -16, 6, -22, 11, 7, 8, -3, -15, -9, 6, 2, -14, 4, 5, -7, 17, 6, -5, 8, -19, 8, 10, -20, 1, 14, -11, 5, 12, -3, 1, -2, -2, 9, 2, 10, 0, -2, -1, 2, -3, -4, 2, 2, 1, -5, 2, -2, 6, 6, -4, 4, 0, 0, -2, 1, 4, 3, 0, 0, -6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-30926, -2318, 5817, -893, 2969, -1334, 1471, 728, 1140, -1645, -462, 1202, 119, 881, 229, 891, 711, 216, 601, -163, -426, -130, 217, -70, -230, 326, -96, 226, 58, -28, -44, -125, -122, -69, 51, 61, 54, 3, -9, 99, -238, 14, -40, -18, 39, 13, -103, -52, 73, -54, -50, 3, -14, 27, -14, -35, 5, -14, 29, 19, -17, 6, -21, 11, 7, 8, -3, -15, -9, 6, 2, -14, 4, 5, -7, 17, 7, -5, 8, -19, 8, 10, -20, 1, 14, -11, 5, 12, -3, 1, -2, -2, 9, 2, 10, 0, -2, -1, 2, -3, -4, 2, 2, 1, -5, 2, -2, 6, 6, -4, 4, 0, 0, -2, 1, 4, 3, 0, 0, -6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-30805, -2316, 5808, -951, 2980, -1424, 1517, 644, 1172, -1692, -480, 1205, 133, 907, 166, 896, 727, 205, 584, -195, -422, -109, 234, -90, -237, 327, -72, 218, 60, -32, -53, -131, -118, -74, 58, 60, 53, 4, -9, 102, -242, 19, -32, -16, 32, 8, -104, -46, 74, -54, -51, 4, -15, 25, -14, -34, 6, -12, 29, 18, -18, 6, -20, 11, 7, 8, -3, -15, -9, 5, 2, -14, 5, 5, -6, 18, 8, -5, 8, -19, 8, 10, -20, 1, 14, -12, 5, 12, -3, 1, -2, -2, 9, 3, 10, 0, -2, -2, 2, -3, -4, 2, 2, 1, -5, 2, -2, 6, 6, -4, 4, 0, 0, -2, 1, 4, 3, 0, 0, -6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-30715, -2306, 5812, -1018, 2984, -1520, 1550, 586, 1206, -1740, -494, 1215, 146, 918, 101, 903, 744, 188, 565, -226, -415, -90, 249, -114, -241, 329, -51, 211, 64, -33, -64, -136, -115, -76, 64, 59, 53, 4, -8, 104, -246, 25, -25, -15, 25, 4, -106, -40, 74, -53, -52, 4, -17, 23, -14, -33, 7, -11, 29, 18, -19, 6, -19, 11, 7, 8, -3, -15, -9, 5, 1, -15, 6, 5, -6, 18, 8, -5, 7, -19, 8, 10, -20, 1, 15, -12, 5, 11, -3, 1, -3, -2, 9, 3, 11, 0, -2, -2, 2, -3, -4, 2, 2, 1, -5, 2, -2, 6, 6, -4, 4, 0, 0, -1, 2, 4, 3, 0, 0, -6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-30654, -2292, 5821, -1106, 2981, -1614, 1566, 528, 1240, -1790, -499, 1232, 163, 916, 43, 914, 762, 169, 550, -252, -405, -72, 265, -141, -241, 334, -33, 208, 71, -33, -75, -141, -113, -76, 69, 57, 54, 4, -7, 105, -249, 33, -18, -15, 18, 0, -107, -33, 74, -53, -52, 4, -18, 20, -14, -31, 7, -9, 29, 17, -20, 5, -19, 11, 7, 8, -3, -14, -10, 5, 1, -15, 6, 5, -5, 19, 9, -5, 7, -19, 8, 10, -21, 1, 15, -12, 5, 11, -3, 1, -3, -2, 9, 3, 11, 1, -2, -2, 2, -3, -4, 2, 2, 1, -5, 2, -2, 6, 6, -4, 4, 0, 0, -1, 2, 4, 3, 0, 0, -6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-30594, -2285, 5810, -1244, 2990, -1702, 1578, 477, 1282, -1834, -499, 1255, 186, 913, -11, 944, 776, 144, 544, -276, -421, -55, 304, -178, -253, 346, -12, 194, 95, -20, -67, -142, -119, -82, 82, 59, 57, 6, 6, 100, -246, 16, -25, -9, 21, -16, -104, -39, 70, -40, -45, 0, -18, 0, 2, -29, 6, -10, 28, 15, -17, 29, -22, 13, 7, 12, -8, -21, -5, -12, 9, -7, 7, 2, -10, 18, 7, 3, 2, -11, 5, -21, -27, 1, 17, -11, 29, 3, -9, 16, 4, -3, 9, -4, 6, -3, 1, -4, 8, -3, 11, 5, 1, 1, 2, -20, -5, -1, -1, -6, 8, 6, -1, -4, -3, -2, 5, 0, -2, -2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-30554, -2250, 5815, -1341, 2998, -1810, 1576, 381, 1297, -1889, -476, 1274, 206, 896, -46, 954, 792, 136, 528, -278, -408, -37, 303, -210, -240, 349, 3, 211, 103, -20, -87, -147, -122, -76, 80, 54, 57, -1, 4, 99, -247, 33, -16, -12, 12, -12, -105, -30, 65, -55, -35, 2, -17, 1, 0, -40, 10, -7, 36, 5, -18, 19, -16, 22, 15, 5, -4, -22, -1, 0, 11, -21, 15, -8, -13, 17, 5, -4, -1, -17, 3, -7, -24, -1, 19, -25, 12, 10, 2, 5, 2, -5, 8, -2, 8, 3, -11, 8, -7, -8, 4, 13, -1, -2, 13, -10, -4, 2, 4, -3, 12, 6, 3, -3, 2, 6, 10, 11, 3, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-30500, -2215, 5820, -1440, 3003, -1898, 1581, 291, 1302, -1944, -462, 1288, 216, 882, -83, 958, 796, 133, 510, -274, -397, -23, 290, -230, -229, 360, 15, 230, 110, -23, -98, -152, -121, -69, 78, 47, 57, -9, 3, 96, -247, 48, -8, -16, 7, -12, -107, -24, 65, -56, -50, 2, -24, 10, -4, -32, 8, -11, 28, 9, -20, 18, -18, 11, 9, 10, -6, -15, -14, 5, 6, -23, 10, 3, -7, 23, 6, -4, 9, -13, 4, 9, -11, -4, 12, -5, 7, 2, 6, 4, -2, 1, 10, 2, 7, 2, -6, 5, 5, -3, -5, -4, -1, 0, 2, -8, -3, -2, 7, -4, 4, 1, -2, -3, 6, 7, -2, -1, 0, -3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-30421, -2169, 5791, -1555, 3002, -1967, 1590, 206, 1302, -1992, -414, 1289, 224, 878, -130, 957, 800, 135, 504, -278, -394, 3, 269, -255, -222, 362, 16, 242, 125, -26, -117, -156, -114, -63, 81, 46, 58, -10, 1, 99, -237, 60, -1, -20, -2, -11, -113, -17, 67, -56, -55, 5, -28, 15, -6, -32, 7, -7, 23, 17, -18, 8, -17, 15, 6, 11, -4, -14, -11, 7, 2, -18, 10, 4, -5, 23, 10, 1, 8, -20, 4, 6, -18, 0, 12, -9, 2, 1, 0, 4, -3, -1, 9, -2, 8, 3, 0, -1, 5, 1, -3, 4, 4, 1, 0, 0, -1, 2, 4, -5, 6, 1, 1, -1, -1, 6, 2, 0, 0, -7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-30334, -2119, 5776, -1662, 2997, -2016, 1594, 114, 1297, -2038, -404, 1292, 240, 856, -165, 957, 804, 148, 479, -269, -390, 13, 252, -269, -219, 358, 19, 254, 128, -31, -126, -157, -97, -62, 81, 45, 61, -11, 8, 100, -228, 68, 4, -32, 1, -8, -111, -7, 75, -57, -61, 4, -27, 13, -2, -26, 6, -6, 26, 13, -23, 1, -12, 13, 5, 7, -4, -12, -14, 9, 0, -16, 8, 4, -1, 24, 11, -3, 4, -17, 8, 10, -22, 2, 15, -13, 7, 10, -4, -1, -5, -1, 10, 5, 10, 1, -4, -2, 1, -2, -3, 2, 2, 1, -5, 2, -2, 6, 4, -4, 4, 0, 0, -2, 2, 3, 2, 0, 0, -6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-30220, -2068, 5737, -1781, 3000, -2047, 1611, 25, 1287, -2091, -366, 1278, 251, 838, -196, 952, 800, 167, 461, -266, -395, 26, 234, -279, -216, 359, 26, 262, 139, -42, -139, -160, -91, -56, 83, 43, 64, -12, 15, 100, -212, 72, 2, -37, 3, -6, -112, 1, 72, -57, -70, 1, -27, 14, -4, -22, 8, -2, 23, 13, -23, -2, -11, 14, 6, 7, -2, -15, -13, 6, -3, -17, 5, 6, 0, 21, 11, -6, 3, -16, 8, 10, -21, 2, 16, -12, 6, 10, -4, -1, -5, 0, 10, 3, 11, 1, -2, -1, 1, -3, -3, 1, 2, 1, -5, 3, -1, 4, 6, -4, 4, 0, 1, -1, 0, 3, 3, 1, -1, -4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-30100, -2013, 5675, -1902, 3010, -2067, 1632, -68, 1276, -2144, -333, 1260, 262, 830, -223, 946, 791, 191, 438, -265, -405, 39, 216, -288, -218, 356, 31, 264, 148, -59, -152, -159, -83, -49, 88, 45, 66, -13, 28, 99, -198, 75, 1, -41, 6, -4, -111, 11, 71, -56, -77, 1, -26, 16, -5, -14, 10, 0, 22, 12, -23, -5, -12, 14, 6, 6, -1, -16, -12, 4, -8, -19, 4, 6, 0, 18, 10, -10, 1, -17, 7, 10, -21, 2, 16, -12, 7, 10, -4, -1, -5, -1, 10, 4, 11, 1, -3, -2, 1, -3, -3, 1, 2, 1, -5, 3, -2, 4, 5, -4, 4, -1, 1, -1, 0, 3, 3, 1, -1, -5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-29992, -1956, 5604, -1997, 3027, -2129, 1663, -200, 1281, -2180, -336, 1251, 271, 833, -252, 938, 782, 212, 398, -257, -419, 53, 199, -297, -218, 357, 46, 261, 150, -74, -151, -162, -78, -48, 92, 48, 66, -15, 42, 93, -192, 71, 4, -43, 14, -2, -108, 17, 72, -59, -82, 2, -27, 21, -5, -12, 16, 1, 18, 11, -23, -2, -10, 18, 6, 7, 0, -18, -11, 4, -7, -22, 4, 9, 3, 16, 6, -13, -1, -15, 5, 10, -21, 1, 16, -12, 9, 9, -5, -3, -6, -1, 9, 7, 10, 2, -6, -5, 2, -4, -4, 1, 2, 0, -5, 3, -2, 6, 5, -4, 3, 0, 1, -1, 2, 4, 3, 0, 0, -6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-29873, -1905, 5500, -2072, 3044, -2197, 1687, -306, 1296, -2208, -310, 1247, 284, 829, -297, 936, 780, 232, 361, -249, -424, 69, 170, -297, -214, 355, 47, 253, 150, -93, -154, -164, -75, -46, 95, 53, 65, -16, 51, 88, -185, 69, 4, -48, 16, -1, -102, 21, 74, -62, -83, 3, -27, 24, -2, -6, 20, 4, 17, 10, -23, 0, -7, 21, 6, 8, 0, -19, -11, 5, -9, -23, 4, 11, 4, 14, 4, -15, -4, -11, 5, 10, -21, 1, 15, -12, 9, 9, -6, -3, -6, -1, 9, 7, 9, 1, -7, -5, 2, -4, -4, 1, 3, 0, -5, 3, -2, 6, 5, -4, 3, 0, 1, -1, 2, 4, 3, 0, 0, -6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-29775, -1848, 5406, -2131, 3059, -2279, 1686, -373, 1314, -2239, -284, 1248, 293, 802, -352, 939, 780, 247, 325, -240, -423, 84, 141, -299, -214, 353, 46, 245, 154, -109, -153, -165, -69, -36, 97, 61, 65, -16, 59, 82, -178, 69, 3, -52, 18, 1, -96, 24, 77, -64, -80, 2, -26, 26, 0, -1, 21, 5, 17, 9, -23, 0, -4, 23, 5, 10, -1, -19, -10, 6, -12, -22, 3, 12, 4, 12, 2, -16, -6, -10, 4, 9, -20, 1, 15, -12, 11, 9, -7, -4, -7, -2, 9, 7, 8, 1, -7, -6, 2, -3, -4, 2, 2, 1, -5, 3, -2, 6, 4, -4, 3, 0, 1, -2, 3, 3, 3, -1, 0, -6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-29692, -1784, 5306, -2200, 3070, -2366, 1681, -413, 1335, -2267, -262, 1249, 302, 759, -427, 940, 780, 262, 290, -236, -418, 97, 122, -306, -214, 352, 46, 235, 165, -118, -143, -166, -55, -17, 107, 68, 67, -17, 68, 72, -170, 67, -1, -58, 19, 1, -93, 36, 77, -72, -69, 1, -25, 28, 4, 5, 24, 4, 17, 8, -24, -2, -6, 25, 6, 11, -6, -21, -9, 8, -14, -23, 9, 15, 6, 11, -5, -16, -7, -4, 4, 9, -20, 3, 15, -10, 12, 8, -6, -8, -8, -1, 8, 10, 5, -2, -8, -8, 3, -3, -6, 1, 2, 0, -4, 4, -1, 5, 4, -5, 2, -1, 2, -2, 5, 1, 1, -2, 0, -7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-29619.4, -1728.2, 5186.1, -2267.7, 3068.4, -2481.6, 1670.9, -458.0, 1339.6, -2288.0, -227.6, 1252.1, 293.4, 714.5, -491.1, 932.3, 786.8, 272.6, 250.0, -231.9, -403.0, 119.8, 111.3, -303.8, -218.8, 351.4, 43.8, 222.3, 171.9, -130.4, -133.1, -168.6, -39.3, -12.9, 106.3, 72.3, 68.2, -17.4, 74.2, 63.7, -160.9, 65.1, -5.9, -61.2, 16.9, 0.7, -90.4, 43.8, 79.0, -74.0, -64.6, 0.0, -24.2, 33.3, 6.2, 9.1, 24.0, 6.9, 14.8, 7.3, -25.4, -1.2, -5.8, 24.4, 6.6, 11.9, -9.2, -21.5, -7.9, 8.5, -16.6, -21.5, 9.1, 15.5, 7.0, 8.9, -7.9, -14.9, -7.0, -2.1, 5.0, 9.4, -19.7, 3.0, 13.4, -8.4, 12.5, 6.3, -6.2, -8.9, -8.4, -1.5, 8.4, 9.3, 3.8, -4.3, -8.2, -8.2, 4.8, -2.6, -6.0, 1.7, 1.7, 0.0, -3.1, 4.0, -0.5, 4.9, 3.7, -5.9, 1.0, -1.2, 2.0, -2.9, 4.2, 0.2, 0.3, -2.2, -1.1, -7.4, 2.7, -1.7, 0.1, -1.9, 1.3, 1.5, -0.9, -0.1, -2.6, 0.1, 0.9, -0.7, -0.7, 0.7, -2.8, 1.7, -0.9, 0.1, -1.2, 1.2, -1.9, 4.0, -0.9, -2.2, -0.3, -0.4, 0.2, 0.3, 0.9, 2.5, -0.2, -2.6, 0.9, 0.7, -0.5, 0.3, 0.3, 0.0, -0.3, 0.0, -0.4, 0.3, -0.1, -0.9, -0.2, -0.4, -0.4, 0.8, -0.2, -0.9, -0.9, 0.3, 0.2, 0.1, 1.8, -0.4, -0.4, 1.3, -1.0, -0.4, -0.1, 0.7, 0.7, -0.4, 0.3, 0.3, 0.6, -0.1, 0.3, 0.4, -0.2, 0.0, -0.5, 0.1, -0.9], [-29554.63, -1669.05, 5077.99, -2337.24, 3047.69, -2594.5, 1657.76, -515.43, 1336.3, -2305.83, -198.86, 1246.39, 269.72, 672.51, -524.72, 920.55, 797.96, 282.07, 210.65, -225.23, -379.86, 145.15, 100.0, -305.36, -227.0, 354.41, 42.72, 208.95, 180.25, -136.54, -123.45, -168.05, -19.57, -13.55, 103.85, 73.6, 69.56, -20.33, 76.74, 54.75, -151.34, 63.63, -14.58, -63.53, 14.58, 0.24, -86.36, 50.94, 79.88, -74.46, -61.14, -1.65, -22.57, 38.73, 6.82, 12.3, 25.35, 9.37, 10.93, 5.42, -26.32, 1.94, -4.64, 24.8, 7.62, 11.2, -11.73, -20.88, -6.88, 9.83, -18.11, -19.71, 10.17, 16.22, 9.36, 7.61, -11.25, -12.76, -4.87, -0.06, 5.58, 9.76, -20.11, 3.58, 12.69, -6.94, 12.67, 5.01, -6.72, -10.76, -8.16, -1.25, 8.1, 8.76, 2.92, -6.66, -7.73, -9.22, 6.01, -2.17, -6.12, 2.19, 1.42, 0.1, -2.35, 4.46, -0.15, 4.76, 3.06, -6.58, 0.29, -1.01, 2.06, -3.47, 3.77, -0.86, -0.21, -2.31, -2.09, -7.93, 2.95, -1.6, 0.26, -1.88, 1.44, 1.44, -0.77, -0.31, -2.27, 0.29, 0.9, -0.79, -0.58, 0.53, -2.69, 1.8, -1.08, 0.16, -1.58, 0.96, -1.9, 3.99, -1.39, -2.15, -0.29, -0.55, 0.21, 0.23, 0.89, 2.38, -0.38, -2.63, 0.96, 0.61, -0.3, 0.4, 0.46, 0.01, -0.35, 0.02, -0.36, 0.28, 0.08, -0.87, -0.49, -0.34, -0.08, 0.88, -0.16, -0.88, -0.76, 0.3, 0.33, 0.28, 1.72, -0.43, -0.54, 1.18, -1.07, -0.37, -0.04, 0.75, 0.63, -0.26, 0.21, 0.35, 0.53, -0.05, 0.38, 0.41, -0.22, -0.1, -0.57, -0.18, -0.82], [-29496.57, -1586.42, 4944.26, -2396.06, 3026.34, -2708.54, 1668.17, -575.73, 1339.85, -2326.54, -160.4, 1232.1, 251.75, 633.73, -537.03, 912.66, 808.97, 286.48, 166.58, -211.03, -356.83, 164.46, 89.4, -309.72, -230.87, 357.29, 44.58, 200.26, 189.01, -141.05, -118.06, -163.17, -0.01, -8.03, 101.04, 72.78, 68.69, -20.9, 75.92, 44.18, -141.4, 61.54, -22.83, -66.26, 13.1, 3.02, -78.09, 55.4, 80.44, -75.0, -57.8, -4.55, -21.2, 45.24, 6.54, 14.0, 24.96, 10.46, 7.03, 1.64, -27.61, 4.92, -3.28, 24.41, 8.21, 10.84, -14.5, -20.03, -5.59, 11.83, -19.34, -17.41, 11.61, 16.71, 10.85, 6.96, -14.05, -10.74, -3.54, 1.64, 5.5, 9.45, -20.54, 3.45, 11.51, -5.27, 12.75, 3.13, -7.14, -12.38, -7.42, -0.76, 7.97, 8.43, 2.14, -8.42, -6.08, -10.08, 7.01, -1.94, -6.24, 2.73, 0.89, -0.1, -1.07, 4.71, -0.16, 4.44, 2.45, -7.22, -0.33, -0.96, 2.13, -3.95, 3.09, -1.99, -1.03, -1.97, -2.8, -8.31, 3.05, -1.48, 0.13, -2.03, 1.67, 1.65, -0.66, -0.51, -1.76, 0.54, 0.85, -0.79, -0.39, 0.37, -2.51, 1.79, -1.27, 0.12, -2.11, 0.75, -1.94, 3.75, -1.86, -2.12, -0.21, -0.87, 0.3, 0.27, 1.04, 2.13, -0.63, -2.49, 0.95, 0.49, -0.11, 0.59, 0.52, 0.0, -0.39, 0.13, -0.37, 0.27, 0.21, -0.86, -0.77, -0.23, 0.04, 0.87, -0.09, -0.89, -0.87, 0.31, 0.3, 0.42, 1.66, -0.45, -0.59, 1.08, -1.14, -0.31, -0.07, 0.78, 0.54, -0.18, 0.1, 0.38, 0.49, 0.02, 0.44, 0.42, -0.25, -0.26, -0.53, -0.26, -0.79], [-29441.46, -1501.77, 4795.99, -2445.88, 3012.2, -2845.41, 1676.35, -642.17, 1350.33, -2352.26, -115.29, 1225.85, 245.04, 581.69, -538.7, 907.42, 813.68, 283.54, 120.49, -188.43, -334.85, 180.95, 70.38, -329.23, -232.91, 360.14, 46.98, 192.35, 196.98, -140.94, -119.14, -157.4, 15.98, 4.3, 100.12, 69.55, 67.57, -20.61, 72.79, 33.3, -129.85, 58.74, -28.93, -66.64, 13.14, 7.35, -70.85, 62.41, 81.29, -75.99, -54.27, -6.79, -19.53, 51.82, 5.59, 15.07, 24.45, 9.32, 3.27, -2.88, -27.5, 6.61, -2.32, 23.98, 8.89, 10.04, -16.78, -18.26, -3.16, 13.18, -20.56, -14.6, 13.33, 16.16, 11.76, 5.69, -15.98, -9.1, -2.02, 2.26, 5.33, 8.83, -21.77, 3.02, 10.76, -3.22, 11.74, 0.67, -6.74, -13.2, -6.88, -0.1, 7.79, 8.68, 1.04, -9.06, -3.89, -10.54, 8.44, -2.01, -6.26, 3.28, 0.17, -0.4, 0.55, 4.55, -0.55, 4.4, 1.7, -7.92, -0.67, -0.61, 2.13, -4.16, 2.33, -2.85, -1.8, -1.12, -3.59, -8.72, 3.0, -1.4, 0.0, -2.3, 2.11, 2.08, -0.6, -0.79, -1.05, 0.58, 0.76, -0.7, -0.2, 0.14, -2.12, 1.7, -1.44, -0.22, -2.57, 0.44, -2.01, 3.49, -2.34, -2.09, -0.16, -1.08, 0.46, 0.37, 1.23, 1.75, -0.89, -2.19, 0.85, 0.27, 0.1, 0.72, 0.54, -0.09, -0.37, 0.29, -0.43, 0.23, 0.22, -0.89, -0.94, -0.16, -0.03, 0.72, -0.02, -0.92, -0.88, 0.42, 0.49, 0.63, 1.56, -0.42, -0.5, 0.96, -1.24, -0.19, -0.1, 0.81, 0.42, -0.13, -0.04, 0.38, 0.48, 0.08, 0.48, 0.46, -0.3, -0.35, -0.43, -0.36, -0.71], [-29404.8, -1450.9, 4652.5, -2499.6, 2982.0, -2991.6, 1677.0, -734.6, 1363.2, -2381.2, -82.1, 1236.2, 241.9, 525.7, -543.4, 903.0, 809.5, 281.9, 86.3, -158.4, -309.4, 199.7, 48.0, -349.7, -234.3, 363.2, 47.7, 187.8, 208.3, -140.7, -121.2, -151.2, 32.3, 13.5, 98.9, 66.0, 65.5, -19.1, 72.9, 25.1, -121.5, 52.8, -36.2, -64.5, 13.5, 8.9, -64.7, 68.1, 80.6, -76.7, -51.5, -8.2, -16.9, 56.5, 2.2, 15.8, 23.5, 6.4, -2.2, -7.2, -27.2, 9.8, -1.8, 23.7, 9.7, 8.4, -17.6, -15.3, -0.5, 12.8, -21.1, -11.7, 15.3, 14.9, 13.7, 3.6, -16.5, -6.9, -0.3, 2.8, 5.0, 8.4, -23.4, 2.9, 11.0, -1.5, 9.8, -1.1, -5.1, -13.2, -6.3, 1.1, 7.8, 8.8, 0.4, -9.3, -1.4, -11.9, 9.6, -1.9, -6.2, 3.4, -0.1, -0.2, 1.7, 3.6, -0.9, 4.8, 0.7, -8.6, -0.9, -0.1, 1.9, -4.3, 1.4, -3.4, -2.4, -0.1, -3.8, -8.8, 3.0, -1.4, 0.0, -2.5, 2.5, 2.3, -0.6, -0.9, -0.4, 0.3, 0.6, -0.7, -0.2, -0.1, -1.7, 1.4, -1.6, -0.6, -3.0, 0.2, -2.0, 3.1, -2.6, -2.0, -0.1, -1.2, 0.5, 0.5, 1.3, 1.4, -1.2, -1.8, 0.7, 0.1, 0.3, 0.8, 0.5, -0.2, -0.3, 0.6, -0.5, 0.2, 0.1, -0.9, -1.1, 0.0, -0.3, 0.5, 0.1, -0.9, -0.9, 0.5, 0.6, 0.7, 1.4, -0.3, -0.4, 0.8, -1.3, 0.0, -0.1, 0.8, 0.3, 0.0, -0.1, 0.4, 0.5, 0.1, 0.5, 0.5, -0.4, -0.5, -0.4, -0.4, -0.6], [5.7, 7.4, -25.9, -11.0, -7.0, -30.2, -2.1, -22.4, 2.2, -5.9, 6.0, 3.1, -1.1, -12.0, 0.5, -1.2, -1.6, -0.1, -5.9, 6.5, 5.2, 3.6, -5.1, -5.0, -0.3, 0.5, 0.0, -0.6, 2.5, 0.2, -0.6, 1.3, 3.0, 0.9, 0.3, -0.5, -0.3, 0.0, 0.4, -1.6, 1.3, -1.3, -1.4, 0.8, 0.0, 0.0, 0.9, 1.0, -0.1, -0.2, 0.6, 0.0, 0.6, 0.7, -0.8, 0.1, -0.2, -0.5, -1.1, -0.8, 0.1, 0.8, 0.3, 0.0, 0.1, -0.2, -0.1, 0.6, 0.4, -0.2, -0.1, 0.5, 0.4, -0.3, 0.3, -0.4, -0.1, 0.5, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]] 

    return models,coeffs

def get_igrf12():
    models= [1900, 1905, 1910, 1915, 1920, 1925, 1930, 1935, 1940, 1945, 1950, 1955, 1960, 1965, 1970, 1975, 1980, 1985, 1990, 1995, 2000, 2005, 2010, 2015, 2015.20]
    coeffs=np.array([[-31543, -2298, 5922, -677, 2905, -1061, 924, 1121, 1022, -1469, -330, 1256, 3, 572, 523, 876, 628, 195, 660, -69, -361, -210, 134, -75, -184, 328, -210, 264, 53, 5, -33, -86, -124, -16, 3, 63, 61, -9, -11, 83, -217, 2, -58, -35, 59, 36, -90, -69, 70, -55, -45, 0, -13, 34, -10, -41, -1, -21, 28, 18, -12, 6, -22, 11, 8, 8, -4, -14, -9, 7, 1, -13, 2, 5, -9, 16, 5, -5, 8, -18, 8, 10, -20, 1, 14, -11, 5, 12, -3, 1, -2, -2, 8, 2, 10, -1, -2, -1, 2, -3, -4, 2, 2, 1, -5, 2, -2, 6, 6, -4, 4, 0, 0, -2, 2, 4, 2, 0, 0, -6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-31464, -2298, 5909, -728, 2928, -1086, 1041, 1065, 1037, -1494, -357, 1239, 34, 635, 480, 880, 643, 203, 653, -77, -380, -201, 146, -65, -192, 328, -193, 259, 56, -1, -32, -93, -125, -26, 11, 62, 60, -7, -11, 86, -221, 4, -57, -32, 57, 32, -92, -67, 70, -54, -46, 0, -14, 33, -11, -41, 0, -20, 28, 18, -12, 6, -22, 11, 8, 8, -4, -15, -9, 7, 1, -13, 2, 5, -8, 16, 5, -5, 8, -18, 8, 10, -20, 1, 14, -11, 5, 12, -3, 1, -2, -2, 8, 2, 10, 0, -2, -1, 2, -3, -4, 2, 2, 1, -5, 2, -2, 6, 6, -4, 4, 0, 0, -2, 2, 4, 2, 0, 0, -6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-31354, -2297, 5898, -769, 2948, -1128, 1176, 1000, 1058, -1524, -389, 1223, 62, 705, 425, 884, 660, 211, 644, -90, -400, -189, 160, -55, -201, 327, -172, 253, 57, -9, -33, -102, -126, -38, 21, 62, 58, -5, -11, 89, -224, 5, -54, -29, 54, 28, -95, -65, 71, -54, -47, 1, -14, 32, -12, -40, 1, -19, 28, 18, -13, 6, -22, 11, 8, 8, -4, -15, -9, 6, 1, -13, 2, 5, -8, 16, 5, -5, 8, -18, 8, 10, -20, 1, 14, -11, 5, 12, -3, 1, -2, -2, 8, 2, 10, 0, -2, -1, 2, -3, -4, 2, 2, 1, -5, 2, -2, 6, 6, -4, 4, 0, 0, -2, 2, 4, 2, 0, 0, -6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-31212, -2306, 5875, -802, 2956, -1191, 1309, 917, 1084, -1559, -421, 1212, 84, 778, 360, 887, 678, 218, 631, -109, -416, -173, 178, -51, -211, 327, -148, 245, 58, -16, -34, -111, -126, -51, 32, 61, 57, -2, -10, 93, -228, 8, -51, -26, 49, 23, -98, -62, 72, -54, -48, 2, -14, 31, -12, -38, 2, -18, 28, 19, -15, 6, -22, 11, 8, 8, -4, -15, -9, 6, 2, -13, 3, 5, -8, 16, 6, -5, 8, -18, 8, 10, -20, 1, 14, -11, 5, 12, -3, 1, -2, -2, 8, 2, 10, 0, -2, -1, 2, -3, -4, 2, 2, 1, -5, 2, -2, 6, 6, -4, 4, 0, 0, -2, 1, 4, 2, 0, 0, -6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-31060, -2317, 5845, -839, 2959, -1259, 1407, 823, 1111, -1600, -445, 1205, 103, 839, 293, 889, 695, 220, 616, -134, -424, -153, 199, -57, -221, 326, -122, 236, 58, -23, -38, -119, -125, -62, 43, 61, 55, 0, -10, 96, -233, 11, -46, -22, 44, 18, -101, -57, 73, -54, -49, 2, -14, 29, -13, -37, 4, -16, 28, 19, -16, 6, -22, 11, 7, 8, -3, -15, -9, 6, 2, -14, 4, 5, -7, 17, 6, -5, 8, -19, 8, 10, -20, 1, 14, -11, 5, 12, -3, 1, -2, -2, 9, 2, 10, 0, -2, -1, 2, -3, -4, 2, 2, 1, -5, 2, -2, 6, 6, -4, 4, 0, 0, -2, 1, 4, 3, 0, 0, -6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-30926, -2318, 5817, -893, 2969, -1334, 1471, 728, 1140, -1645, -462, 1202, 119, 881, 229, 891, 711, 216, 601, -163, -426, -130, 217, -70, -230, 326, -96, 226, 58, -28, -44, -125, -122, -69, 51, 61, 54, 3, -9, 99, -238, 14, -40, -18, 39, 13, -103, -52, 73, -54, -50, 3, -14, 27, -14, -35, 5, -14, 29, 19, -17, 6, -21, 11, 7, 8, -3, -15, -9, 6, 2, -14, 4, 5, -7, 17, 7, -5, 8, -19, 8, 10, -20, 1, 14, -11, 5, 12, -3, 1, -2, -2, 9, 2, 10, 0, -2, -1, 2, -3, -4, 2, 2, 1, -5, 2, -2, 6, 6, -4, 4, 0, 0, -2, 1, 4, 3, 0, 0, -6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-30805, -2316, 5808, -951, 2980, -1424, 1517, 644, 1172, -1692, -480, 1205, 133, 907, 166, 896, 727, 205, 584, -195, -422, -109, 234, -90, -237, 327, -72, 218, 60, -32, -53, -131, -118, -74, 58, 60, 53, 4, -9, 102, -242, 19, -32, -16, 32, 8, -104, -46, 74, -54, -51, 4, -15, 25, -14, -34, 6, -12, 29, 18, -18, 6, -20, 11, 7, 8, -3, -15, -9, 5, 2, -14, 5, 5, -6, 18, 8, -5, 8, -19, 8, 10, -20, 1, 14, -12, 5, 12, -3, 1, -2, -2, 9, 3, 10, 0, -2, -2, 2, -3, -4, 2, 2, 1, -5, 2, -2, 6, 6, -4, 4, 0, 0, -2, 1, 4, 3, 0, 0, -6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-30715, -2306, 5812, -1018, 2984, -1520, 1550, 586, 1206, -1740, -494, 1215, 146, 918, 101, 903, 744, 188, 565, -226, -415, -90, 249, -114, -241, 329, -51, 211, 64, -33, -64, -136, -115, -76, 64, 59, 53, 4, -8, 104, -246, 25, -25, -15, 25, 4, -106, -40, 74, -53, -52, 4, -17, 23, -14, -33, 7, -11, 29, 18, -19, 6, -19, 11, 7, 8, -3, -15, -9, 5, 1, -15, 6, 5, -6, 18, 8, -5, 7, -19, 8, 10, -20, 1, 15, -12, 5, 11, -3, 1, -3, -2, 9, 3, 11, 0, -2, -2, 2, -3, -4, 2, 2, 1, -5, 2, -2, 6, 6, -4, 4, 0, 0, -1, 2, 4, 3, 0, 0, -6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-30654, -2292, 5821, -1106, 2981, -1614, 1566, 528, 1240, -1790, -499, 1232, 163, 916, 43, 914, 762, 169, 550, -252, -405, -72, 265, -141, -241, 334, -33, 208, 71, -33, -75, -141, -113, -76, 69, 57, 54, 4, -7, 105, -249, 33, -18, -15, 18, 0, -107, -33, 74, -53, -52, 4, -18, 20, -14, -31, 7, -9, 29, 17, -20, 5, -19, 11, 7, 8, -3, -14, -10, 5, 1, -15, 6, 5, -5, 19, 9, -5, 7, -19, 8, 10, -21, 1, 15, -12, 5, 11, -3, 1, -3, -2, 9, 3, 11, 1, -2, -2, 2, -3, -4, 2, 2, 1, -5, 2, -2, 6, 6, -4, 4, 0, 0, -1, 2, 4, 3, 0, 0, -6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-30594, -2285, 5810, -1244, 2990, -1702, 1578, 477, 1282, -1834, -499, 1255, 186, 913, -11, 944, 776, 144, 544, -276, -421, -55, 304, -178, -253, 346, -12, 194, 95, -20, -67, -142, -119, -82, 82, 59, 57, 6, 6, 100, -246, 16, -25, -9, 21, -16, -104, -39, 70, -40, -45, 0, -18, 0, 2, -29, 6, -10, 28, 15, -17, 29, -22, 13, 7, 12, -8, -21, -5, -12, 9, -7, 7, 2, -10, 18, 7, 3, 2, -11, 5, -21, -27, 1, 17, -11, 29, 3, -9, 16, 4, -3, 9, -4, 6, -3, 1, -4, 8, -3, 11, 5, 1, 1, 2, -20, -5, -1, -1, -6, 8, 6, -1, -4, -3, -2, 5, 0, -2, -2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-30554, -2250, 5815, -1341, 2998, -1810, 1576, 381, 1297, -1889, -476, 1274, 206, 896, -46, 954, 792, 136, 528, -278, -408, -37, 303, -210, -240, 349, 3, 211, 103, -20, -87, -147, -122, -76, 80, 54, 57, -1, 4, 99, -247, 33, -16, -12, 12, -12, -105, -30, 65, -55, -35, 2, -17, 1, 0, -40, 10, -7, 36, 5, -18, 19, -16, 22, 15, 5, -4, -22, -1, 0, 11, -21, 15, -8, -13, 17, 5, -4, -1, -17, 3, -7, -24, -1, 19, -25, 12, 10, 2, 5, 2, -5, 8, -2, 8, 3, -11, 8, -7, -8, 4, 13, -1, -2, 13, -10, -4, 2, 4, -3, 12, 6, 3, -3, 2, 6, 10, 11, 3, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-30500, -2215, 5820, -1440, 3003, -1898, 1581, 291, 1302, -1944, -462, 1288, 216, 882, -83, 958, 796, 133, 510, -274, -397, -23, 290, -230, -229, 360, 15, 230, 110, -23, -98, -152, -121, -69, 78, 47, 57, -9, 3, 96, -247, 48, -8, -16, 7, -12, -107, -24, 65, -56, -50, 2, -24, 10, -4, -32, 8, -11, 28, 9, -20, 18, -18, 11, 9, 10, -6, -15, -14, 5, 6, -23, 10, 3, -7, 23, 6, -4, 9, -13, 4, 9, -11, -4, 12, -5, 7, 2, 6, 4, -2, 1, 10, 2, 7, 2, -6, 5, 5, -3, -5, -4, -1, 0, 2, -8, -3, -2, 7, -4, 4, 1, -2, -3, 6, 7, -2, -1, 0, -3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-30421, -2169, 5791, -1555, 3002, -1967, 1590, 206, 1302, -1992, -414, 1289, 224, 878, -130, 957, 800, 135, 504, -278, -394, 3, 269, -255, -222, 362, 16, 242, 125, -26, -117, -156, -114, -63, 81, 46, 58, -10, 1, 99, -237, 60, -1, -20, -2, -11, -113, -17, 67, -56, -55, 5, -28, 15, -6, -32, 7, -7, 23, 17, -18, 8, -17, 15, 6, 11, -4, -14, -11, 7, 2, -18, 10, 4, -5, 23, 10, 1, 8, -20, 4, 6, -18, 0, 12, -9, 2, 1, 0, 4, -3, -1, 9, -2, 8, 3, 0, -1, 5, 1, -3, 4, 4, 1, 0, 0, -1, 2, 4, -5, 6, 1, 1, -1, -1, 6, 2, 0, 0, -7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-30334, -2119, 5776, -1662, 2997, -2016, 1594, 114, 1297, -2038, -404, 1292, 240, 856, -165, 957, 804, 148, 479, -269, -390, 13, 252, -269, -219, 358, 19, 254, 128, -31, -126, -157, -97, -62, 81, 45, 61, -11, 8, 100, -228, 68, 4, -32, 1, -8, -111, -7, 75, -57, -61, 4, -27, 13, -2, -26, 6, -6, 26, 13, -23, 1, -12, 13, 5, 7, -4, -12, -14, 9, 0, -16, 8, 4, -1, 24, 11, -3, 4, -17, 8, 10, -22, 2, 15, -13, 7, 10, -4, -1, -5, -1, 10, 5, 10, 1, -4, -2, 1, -2, -3, 2, 2, 1, -5, 2, -2, 6, 4, -4, 4, 0, 0, -2, 2, 3, 2, 0, 0, -6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-30220, -2068, 5737, -1781, 3000, -2047, 1611, 25, 1287, -2091, -366, 1278, 251, 838, -196, 952, 800, 167, 461, -266, -395, 26, 234, -279, -216, 359, 26, 262, 139, -42, -139, -160, -91, -56, 83, 43, 64, -12, 15, 100, -212, 72, 2, -37, 3, -6, -112, 1, 72, -57, -70, 1, -27, 14, -4, -22, 8, -2, 23, 13, -23, -2, -11, 14, 6, 7, -2, -15, -13, 6, -3, -17, 5, 6, 0, 21, 11, -6, 3, -16, 8, 10, -21, 2, 16, -12, 6, 10, -4, -1, -5, 0, 10, 3, 11, 1, -2, -1, 1, -3, -3, 1, 2, 1, -5, 3, -1, 4, 6, -4, 4, 0, 1, -1, 0, 3, 3, 1, -1, -4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-30100, -2013, 5675, -1902, 3010, -2067, 1632, -68, 1276, -2144, -333, 1260, 262, 830, -223, 946, 791, 191, 438, -265, -405, 39, 216, -288, -218, 356, 31, 264, 148, -59, -152, -159, -83, -49, 88, 45, 66, -13, 28, 99, -198, 75, 1, -41, 6, -4, -111, 11, 71, -56, -77, 1, -26, 16, -5, -14, 10, 0, 22, 12, -23, -5, -12, 14, 6, 6, -1, -16, -12, 4, -8, -19, 4, 6, 0, 18, 10, -10, 1, -17, 7, 10, -21, 2, 16, -12, 7, 10, -4, -1, -5, -1, 10, 4, 11, 1, -3, -2, 1, -3, -3, 1, 2, 1, -5, 3, -2, 4, 5, -4, 4, -1, 1, -1, 0, 3, 3, 1, -1, -5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-29992, -1956, 5604, -1997, 3027, -2129, 1663, -200, 1281, -2180, -336, 1251, 271, 833, -252, 938, 782, 212, 398, -257, -419, 53, 199, -297, -218, 357, 46, 261, 150, -74, -151, -162, -78, -48, 92, 48, 66, -15, 42, 93, -192, 71, 4, -43, 14, -2, -108, 17, 72, -59, -82, 2, -27, 21, -5, -12, 16, 1, 18, 11, -23, -2, -10, 18, 6, 7, 0, -18, -11, 4, -7, -22, 4, 9, 3, 16, 6, -13, -1, -15, 5, 10, -21, 1, 16, -12, 9, 9, -5, -3, -6, -1, 9, 7, 10, 2, -6, -5, 2, -4, -4, 1, 2, 0, -5, 3, -2, 6, 5, -4, 3, 0, 1, -1, 2, 4, 3, 0, 0, -6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-29873, -1905, 5500, -2072, 3044, -2197, 1687, -306, 1296, -2208, -310, 1247, 284, 829, -297, 936, 780, 232, 361, -249, -424, 69, 170, -297, -214, 355, 47, 253, 150, -93, -154, -164, -75, -46, 95, 53, 65, -16, 51, 88, -185, 69, 4, -48, 16, -1, -102, 21, 74, -62, -83, 3, -27, 24, -2, -6, 20, 4, 17, 10, -23, 0, -7, 21, 6, 8, 0, -19, -11, 5, -9, -23, 4, 11, 4, 14, 4, -15, -4, -11, 5, 10, -21, 1, 15, -12, 9, 9, -6, -3, -6, -1, 9, 7, 9, 1, -7, -5, 2, -4, -4, 1, 3, 0, -5, 3, -2, 6, 5, -4, 3, 0, 1, -1, 2, 4, 3, 0, 0, -6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-29775, -1848, 5406, -2131, 3059, -2279, 1686, -373, 1314, -2239, -284, 1248, 293, 802, -352, 939, 780, 247, 325, -240, -423, 84, 141, -299, -214, 353, 46, 245, 154, -109, -153, -165, -69, -36, 97, 61, 65, -16, 59, 82, -178, 69, 3, -52, 18, 1, -96, 24, 77, -64, -80, 2, -26, 26, 0, -1, 21, 5, 17, 9, -23, 0, -4, 23, 5, 10, -1, -19, -10, 6, -12, -22, 3, 12, 4, 12, 2, -16, -6, -10, 4, 9, -20, 1, 15, -12, 11, 9, -7, -4, -7, -2, 9, 7, 8, 1, -7, -6, 2, -3, -4, 2, 2, 1, -5, 3, -2, 6, 4, -4, 3, 0, 1, -2, 3, 3, 3, -1, 0, -6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-29692, -1784, 5306, -2200, 3070, -2366, 1681, -413, 1335, -2267, -262, 1249, 302, 759, -427, 940, 780, 262, 290, -236, -418, 97, 122, -306, -214, 352, 46, 235, 165, -118, -143, -166, -55, -17, 107, 68, 67, -17, 68, 72, -170, 67, -1, -58, 19, 1, -93, 36, 77, -72, -69, 1, -25, 28, 4, 5, 24, 4, 17, 8, -24, -2, -6, 25, 6, 11, -6, -21, -9, 8, -14, -23, 9, 15, 6, 11, -5, -16, -7, -4, 4, 9, -20, 3, 15, -10, 12, 8, -6, -8, -8, -1, 8, 10, 5, -2, -8, -8, 3, -3, -6, 1, 2, 0, -4, 4, -1, 5, 4, -5, 2, -1, 2, -2, 5, 1, 1, -2, 0, -7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], [-29619.400000000001, -1728.2, 5186.1000000000004, -2267.6999999999998, 3068.4000000000001, -2481.5999999999999, 1670.9000000000001, -458.0, 1339.5999999999999, -2288.0, -227.59999999999999, 1252.0999999999999, 293.39999999999998, 714.5, -491.10000000000002, 932.29999999999995, 786.79999999999995, 272.60000000000002, 250.0, -231.90000000000001, -403.0, 119.8, 111.3, -303.80000000000001, -218.80000000000001, 351.39999999999998, 43.799999999999997, 222.30000000000001, 171.90000000000001, -130.40000000000001, -133.09999999999999, -168.59999999999999, -39.299999999999997, -12.9, 106.3, 72.299999999999997, 68.200000000000003, -17.399999999999999, 74.200000000000003, 63.700000000000003, -160.90000000000001, 65.099999999999994, -5.9000000000000004, -61.200000000000003, 16.899999999999999, 0.69999999999999996, -90.400000000000006, 43.799999999999997, 79.0, -74.0, -64.599999999999994, 0.0, -24.199999999999999, 33.299999999999997, 6.2000000000000002, 9.0999999999999996, 24.0, 6.9000000000000004, 14.800000000000001, 7.2999999999999998, -25.399999999999999, -1.2, -5.7999999999999998, 24.399999999999999, 6.5999999999999996, 11.9, -9.1999999999999993, -21.5, -7.9000000000000004, 8.5, -16.600000000000001, -21.5, 9.0999999999999996, 15.5, 7.0, 8.9000000000000004, -7.9000000000000004, -14.9, -7.0, -2.1000000000000001, 5.0, 9.4000000000000004, -19.699999999999999, 3.0, 13.4, -8.4000000000000004, 12.5, 6.2999999999999998, -6.2000000000000002, -8.9000000000000004, -8.4000000000000004, -1.5, 8.4000000000000004, 9.3000000000000007, 3.7999999999999998, -4.2999999999999998, -8.1999999999999993, -8.1999999999999993, 4.7999999999999998, -2.6000000000000001, -6.0, 1.7, 1.7, 0.0, -3.1000000000000001, 4.0, -0.5, 4.9000000000000004, 3.7000000000000002, -5.9000000000000004, 1.0, -1.2, 2.0, -2.8999999999999999, 4.2000000000000002, 0.20000000000000001, 0.29999999999999999, -2.2000000000000002, -1.1000000000000001, -7.4000000000000004, 2.7000000000000002, -1.7, 0.10000000000000001, -1.8999999999999999, 1.3, 1.5, -0.90000000000000002, -0.10000000000000001, -2.6000000000000001, 0.10000000000000001, 0.90000000000000002, -0.69999999999999996, -0.69999999999999996, 0.69999999999999996, -2.7999999999999998, 1.7, -0.90000000000000002, 0.10000000000000001, -1.2, 1.2, -1.8999999999999999, 4.0, -0.90000000000000002, -2.2000000000000002, -0.29999999999999999, -0.40000000000000002, 0.20000000000000001, 0.29999999999999999, 0.90000000000000002, 2.5, -0.20000000000000001, -2.6000000000000001, 0.90000000000000002, 0.69999999999999996, -0.5, 0.29999999999999999, 0.29999999999999999, 0.0, -0.29999999999999999, 0.0, -0.40000000000000002, 0.29999999999999999, -0.10000000000000001, -0.90000000000000002, -0.20000000000000001, -0.40000000000000002, -0.40000000000000002, 0.80000000000000004, -0.20000000000000001, -0.90000000000000002, -0.90000000000000002, 0.29999999999999999, 0.20000000000000001, 0.10000000000000001, 1.8, -0.40000000000000002, -0.40000000000000002, 1.3, -1.0, -0.40000000000000002, -0.10000000000000001, 0.69999999999999996, 0.69999999999999996, -0.40000000000000002, 0.29999999999999999, 0.29999999999999999, 0.59999999999999998, -0.10000000000000001, 0.29999999999999999, 0.40000000000000002, -0.20000000000000001, 0.0, -0.5, 0.10000000000000001, -0.90000000000000002], [-29554.630000000001, -1669.05, 5077.9899999999998, -2337.2399999999998, 3047.6900000000001, -2594.5, 1657.76, -515.42999999999995, 1336.3, -2305.8299999999999, -198.86000000000001, 1246.3900000000001, 269.72000000000003, 672.50999999999999, -524.72000000000003, 920.54999999999995, 797.96000000000004, 282.06999999999999, 210.65000000000001, -225.22999999999999, -379.86000000000001, 145.15000000000001, 100.0, -305.36000000000001, -227.0, 354.41000000000003, 42.719999999999999, 208.94999999999999, 180.25, -136.53999999999999, -123.45, -168.05000000000001, -19.57, -13.550000000000001, 103.84999999999999, 73.599999999999994, 69.560000000000002, -20.329999999999998, 76.739999999999995, 54.75, -151.34, 63.630000000000003, -14.58, -63.530000000000001, 14.58, 0.23999999999999999, -86.359999999999999, 50.939999999999998, 79.879999999999995, -74.459999999999994, -61.140000000000001, -1.6499999999999999, -22.57, 38.729999999999997, 6.8200000000000003, 12.300000000000001, 25.350000000000001, 9.3699999999999992, 10.93, 5.4199999999999999, -26.32, 1.9399999999999999, -4.6399999999999997, 24.800000000000001, 7.6200000000000001, 11.199999999999999, -11.73, -20.879999999999999, -6.8799999999999999, 9.8300000000000001, -18.109999999999999, -19.710000000000001, 10.17, 16.219999999999999, 9.3599999999999994, 7.6100000000000003, -11.25, -12.76, -4.8700000000000001, -0.059999999999999998, 5.5800000000000001, 9.7599999999999998, -20.109999999999999, 3.5800000000000001, 12.69, -6.9400000000000004, 12.67, 5.0099999999999998, -6.7199999999999998, -10.76, -8.1600000000000001, -1.25, 8.0999999999999996, 8.7599999999999998, 2.9199999999999999, -6.6600000000000001, -7.7300000000000004, -9.2200000000000006, 6.0099999999999998, -2.1699999999999999, -6.1200000000000001, 2.1899999999999999, 1.4199999999999999, 0.10000000000000001, -2.3500000000000001, 4.46, -0.14999999999999999, 4.7599999999999998, 3.0600000000000001, -6.5800000000000001, 0.28999999999999998, -1.01, 2.0600000000000001, -3.4700000000000002, 3.77, -0.85999999999999999, -0.20999999999999999, -2.3100000000000001, -2.0899999999999999, -7.9299999999999997, 2.9500000000000002, -1.6000000000000001, 0.26000000000000001, -1.8799999999999999, 1.4399999999999999, 1.4399999999999999, -0.77000000000000002, -0.31, -2.27, 0.28999999999999998, 0.90000000000000002, -0.79000000000000004, -0.57999999999999996, 0.53000000000000003, -2.6899999999999999, 1.8, -1.0800000000000001, 0.16, -1.5800000000000001, 0.95999999999999996, -1.8999999999999999, 3.9900000000000002, -1.3899999999999999, -2.1499999999999999, -0.28999999999999998, -0.55000000000000004, 0.20999999999999999, 0.23000000000000001, 0.89000000000000001, 2.3799999999999999, -0.38, -2.6299999999999999, 0.95999999999999996, 0.60999999999999999, -0.29999999999999999, 0.40000000000000002, 0.46000000000000002, 0.01, -0.34999999999999998, 0.02, -0.35999999999999999, 0.28000000000000003, 0.080000000000000002, -0.87, -0.48999999999999999, -0.34000000000000002, -0.080000000000000002, 0.88, -0.16, -0.88, -0.76000000000000001, 0.29999999999999999, 0.33000000000000002, 0.28000000000000003, 1.72, -0.42999999999999999, -0.54000000000000004, 1.1799999999999999, -1.0700000000000001, -0.37, -0.040000000000000001, 0.75, 0.63, -0.26000000000000001, 0.20999999999999999, 0.34999999999999998, 0.53000000000000003, -0.050000000000000003, 0.38, 0.40999999999999998, -0.22, -0.10000000000000001, -0.56999999999999995, -0.17999999999999999, -0.81999999999999995], [-29496.57, -1586.4200000000001, 4944.2600000000002, -2396.0599999999999, 3026.3400000000001, -2708.54, 1668.1700000000001, -575.73000000000002, 1339.8499999999999, -2326.54, -160.40000000000001, 1232.0999999999999, 251.75, 633.73000000000002, -537.02999999999997, 912.65999999999997, 808.97000000000003, 286.48000000000002, 166.58000000000001, -211.03, -356.82999999999998, 164.46000000000001, 89.400000000000006, -309.72000000000003, -230.87, 357.29000000000002, 44.579999999999998, 200.25999999999999, 189.00999999999999, -141.05000000000001, -118.06, -163.16999999999999, -0.01, -8.0299999999999994, 101.04000000000001, 72.780000000000001, 68.689999999999998, -20.899999999999999, 75.920000000000002, 44.18, -141.40000000000001, 61.539999999999999, -22.829999999999998, -66.260000000000005, 13.1, 3.02, -78.090000000000003, 55.399999999999999, 80.439999999999998, -75.0, -57.799999999999997, -4.5499999999999998, -21.199999999999999, 45.240000000000002, 6.54, 14.0, 24.960000000000001, 10.460000000000001, 7.0300000000000002, 1.6399999999999999, -27.609999999999999, 4.9199999999999999, -3.2799999999999998, 24.41, 8.2100000000000009, 10.84, -14.5, -20.030000000000001, -5.5899999999999999, 11.83, -19.34, -17.41, 11.609999999999999, 16.710000000000001, 10.85, 6.96, -14.050000000000001, -10.74, -3.54, 1.6399999999999999, 5.5, 9.4499999999999993, -20.539999999999999, 3.4500000000000002, 11.51, -5.2699999999999996, 12.75, 3.1299999999999999, -7.1399999999999997, -12.380000000000001, -7.4199999999999999, -0.76000000000000001, 7.9699999999999998, 8.4299999999999997, 2.1400000000000001, -8.4199999999999999, -6.0800000000000001, -10.08, 7.0099999999999998, -1.9399999999999999, -6.2400000000000002, 2.73, 0.89000000000000001, -0.10000000000000001, -1.0700000000000001, 4.71, -0.16, 4.4400000000000004, 2.4500000000000002, -7.2199999999999998, -0.33000000000000002, -0.95999999999999996, 2.1299999999999999, -3.9500000000000002, 3.0899999999999999, -1.99, -1.03, -1.97, -2.7999999999999998, -8.3100000000000005, 3.0499999999999998, -1.48, 0.13, -2.0299999999999998, 1.6699999999999999, 1.6499999999999999, -0.66000000000000003, -0.51000000000000001, -1.76, 0.54000000000000004, 0.84999999999999998, -0.79000000000000004, -0.39000000000000001, 0.37, -2.5099999999999998, 1.79, -1.27, 0.12, -2.1099999999999999, 0.75, -1.9399999999999999, 3.75, -1.8600000000000001, -2.1200000000000001, -0.20999999999999999, -0.87, 0.29999999999999999, 0.27000000000000002, 1.04, 2.1299999999999999, -0.63, -2.4900000000000002, 0.94999999999999996, 0.48999999999999999, -0.11, 0.58999999999999997, 0.52000000000000002, 0.0, -0.39000000000000001, 0.13, -0.37, 0.27000000000000002, 0.20999999999999999, -0.85999999999999999, -0.77000000000000002, -0.23000000000000001, 0.040000000000000001, 0.87, -0.089999999999999997, -0.89000000000000001, -0.87, 0.31, 0.29999999999999999, 0.41999999999999998, 1.6599999999999999, -0.45000000000000001, -0.58999999999999997, 1.0800000000000001, -1.1399999999999999, -0.31, -0.070000000000000007, 0.78000000000000003, 0.54000000000000004, -0.17999999999999999, 0.10000000000000001, 0.38, 0.48999999999999999, 0.02, 0.44, 0.41999999999999998, -0.25, -0.26000000000000001, -0.53000000000000003, -0.26000000000000001, -0.79000000000000004], [-29442.0, -1501.0, 4797.1000000000004, -2445.0999999999999, 3012.9000000000001, -2845.5999999999999, 1676.7, -641.89999999999998, 1350.7, -2352.3000000000002, -115.3, 1225.5999999999999, 244.90000000000001, 582.0, -538.39999999999998, 907.60000000000002, 813.70000000000005, 283.30000000000001, 120.40000000000001, -188.69999999999999, -334.89999999999998, 180.90000000000001, 70.400000000000006, -329.5, -232.59999999999999, 360.10000000000002, 47.299999999999997, 192.40000000000001, 197.0, -140.90000000000001, -119.3, -157.5, 16.0, 4.0999999999999996, 100.2, 70.0, 67.700000000000003, -20.800000000000001, 72.700000000000003, 33.200000000000003, -129.90000000000001, 58.899999999999999, -28.899999999999999, -66.700000000000003, 13.199999999999999, 7.2999999999999998, -70.900000000000006, 62.600000000000001, 81.599999999999994, -76.099999999999994, -54.100000000000001, -6.7999999999999998, -19.5, 51.799999999999997, 5.7000000000000002, 15.0, 24.399999999999999, 9.4000000000000004, 3.3999999999999999, -2.7999999999999998, -27.399999999999999, 6.7999999999999998, -2.2000000000000002, 24.199999999999999, 8.8000000000000007, 10.1, -16.899999999999999, -18.300000000000001, -3.2000000000000002, 13.300000000000001, -20.600000000000001, -14.6, 13.4, 16.199999999999999, 11.699999999999999, 5.7000000000000002, -15.9, -9.0999999999999996, -2.0, 2.1000000000000001, 5.4000000000000004, 8.8000000000000007, -21.600000000000001, 3.1000000000000001, 10.800000000000001, -3.2999999999999998, 11.800000000000001, 0.69999999999999996, -6.7999999999999998, -13.300000000000001, -6.9000000000000004, -0.10000000000000001, 7.7999999999999998, 8.6999999999999993, 1.0, -9.0999999999999996, -4.0, -10.5, 8.4000000000000004, -1.8999999999999999, -6.2999999999999998, 3.2000000000000002, 0.10000000000000001, -0.40000000000000002, 0.5, 4.5999999999999996, -0.5, 4.4000000000000004, 1.8, -7.9000000000000004, -0.69999999999999996, -0.59999999999999998, 2.1000000000000001, -4.2000000000000002, 2.3999999999999999, -2.7999999999999998, -1.8, -1.2, -3.6000000000000001, -8.6999999999999993, 3.1000000000000001, -1.5, -0.10000000000000001, -2.2999999999999998, 2.0, 2.0, -0.69999999999999996, -0.80000000000000004, -1.1000000000000001, 0.59999999999999998, 0.80000000000000004, -0.69999999999999996, -0.20000000000000001, 0.20000000000000001, -2.2000000000000002, 1.7, -1.3999999999999999, -0.20000000000000001, -2.5, 0.40000000000000002, -2.0, 3.5, -2.3999999999999999, -1.8999999999999999, -0.20000000000000001, -1.1000000000000001, 0.40000000000000002, 0.40000000000000002, 1.2, 1.8999999999999999, -0.80000000000000004, -2.2000000000000002, 0.90000000000000002, 0.29999999999999999, 0.10000000000000001, 0.69999999999999996, 0.5, -0.10000000000000001, -0.29999999999999999, 0.29999999999999999, -0.40000000000000002, 0.20000000000000001, 0.20000000000000001, -0.90000000000000002, -0.90000000000000002, -0.10000000000000001, 0.0, 0.69999999999999996, 0.0, -0.90000000000000002, -0.90000000000000002, 0.40000000000000002, 0.40000000000000002, 0.5, 1.6000000000000001, -0.5, -0.5, 1.0, -1.2, -0.20000000000000001, -0.10000000000000001, 0.80000000000000004, 0.40000000000000002, -0.10000000000000001, -0.10000000000000001, 0.29999999999999999, 0.40000000000000002, 0.10000000000000001, 0.5, 0.5, -0.29999999999999999, -0.40000000000000002, -0.40000000000000002, -0.29999999999999999, -0.80000000000000004], [10.300000000000001, 18.100000000000001, -26.600000000000001, -8.6999999999999993, -3.2999999999999998, -27.399999999999999, 2.1000000000000001, -14.1, 3.3999999999999999, -5.5, 8.1999999999999993, -0.69999999999999996, -0.40000000000000002, -10.1, 1.8, -0.69999999999999996, 0.20000000000000001, -1.3, -9.0999999999999996, 5.2999999999999998, 4.0999999999999996, 2.8999999999999999, -4.2999999999999998, -5.2000000000000002, -0.20000000000000001, 0.5, 0.59999999999999998, -1.3, 1.7, -0.10000000000000001, -1.2, 1.3999999999999999, 3.3999999999999999, 3.8999999999999999, 0.0, -0.29999999999999999, -0.10000000000000001, 0.0, -0.69999999999999996, -2.1000000000000001, 2.1000000000000001, -0.69999999999999996, -1.2, 0.20000000000000001, 0.29999999999999999, 0.90000000000000002, 1.6000000000000001, 1.0, 0.29999999999999999, -0.20000000000000001, 0.80000000000000004, -0.5, 0.40000000000000002, 1.3, -0.20000000000000001, 0.10000000000000001, -0.29999999999999999, -0.59999999999999998, -0.59999999999999998, -0.80000000000000004, 0.10000000000000001, 0.20000000000000001, -0.20000000000000001, 0.20000000000000001, 0.0, -0.29999999999999999, -0.59999999999999998, 0.29999999999999999, 0.5, 0.10000000000000001, -0.20000000000000001, 0.5, 0.40000000000000002, -0.20000000000000001, 0.10000000000000001, -0.29999999999999999, -0.40000000000000002, 0.29999999999999999, 0.29999999999999999, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]])
    return models,coeffs

def get_cals3k():
    models=[-1000,-990,-980,-970,-960,-950,-940,-930,-920,-910,-900,-890,-880,-870,-860,-850,-840,-830,-820,-810,-800,-790,-780,-770,-760,-750,-740,-730,-720,-710,-700,-690,-680,-670,-660,-650,-640,-630,-620,-610,-600,-590,-580,-570,-560,-550,-540,-530,-520,-510,-500,-490,-480,-470,-460,-450,-440,-430,-420,-410,-400,-390,-380,-370,-360,-350,-340,-330,-320,-310,-300,-290,-280,-270,-260,-250,-240,-230,-220,-210,-200,-190,-180,-170,-160,-150,-140,-130,-120,-110,-100,-90,-80,-70,-60,-50,-40,-30,-20,-10,0,10,20,30,40,50,60,70,80,90,100,110,120,130,140,150,160,170,180,190,200,210,220,230,240,250,260,270,280,290,300,310,320,330,340,350,360,370,380,390,400,410,420,430,440,450,460,470,480,490,500,510,520,530,540,550,560,570,580,590,600,610,620,630,640,650,660,670,680,690,700,710,720,730,740,750,760,770,780,790,800,810,820,830,840,850,860,870,880,890,900,910,920,930,940,950,960,970,980,990,1000,1010,1020,1030,1040,1050,1060,1070,1080,1090,1100,1110,1120,1130,1140,1150,1160,1170,1180,1190,1200,1210,1220,1230,1240,1250,1260,1270,1280,1290,1300,1310,1320,1330,1340,1350,1360,1370,1380,1390,1400,1410,1420,1430,1440,1450,1460,1470,1480,1490,1500,1510,1520,1530,1540,1550,1560,1570,1580,1590,1600,1610,1620,1630,1640,1650,1660,1670,1680,1690,1700,1710,1720,1730,1740,1750,1760,1770,1780,1790,1800,1810,1820,1830,1840,1850,1860,1870,1880,1890,1900,1910,1920,1930,1940]
    coeffs=np.array([[-33719.7383551,-263.748312707,-3182.51718048,-1429.82706058,-3025.5410826,213.155259437,2266.51141514,-360.234747256,-671.705672116,886.732039779,282.550399141,-672.340989688,-42.6562230009,-247.983163026,422.2624706,-352.989728466,-331.563134383,277.189968788,-930.510984722,-283.079111451,-124.458379384,-25.1987098669,243.399219266,-469.960044888,83.9046787025,94.6715625921,-62.8508455388,144.441607761,109.019363939,123.352707625,-180.138957665,-166.700991413,-13.4952584064,-209.212926401,268.465603334,-9.36433934422,27.4859163563,22.4897582198,12.7530025413,-15.3127311921,-45.8468405068,-75.3470129602,-91.9902117593,-3.90610128725,-68.9993902167,45.2482498001,-28.9350241055,-13.1915386411,2.15443667308,2.96670887781,1.33708714223,5.25984505842,-6.45194299119,-3.65250488186,-18.518252081,-1.50357286527,-29.6880521677,-30.8677610054,-2.22560178608,-12.0304104859,16.4293362981,3.959353332,9.81307259746,0.508496867888,0.892754815706,-5.04951318522,2.99223608283,1.18984898779,5.16126810248,-2.72424959905,-2.93166650903,-4.6895192021,-8.61616974617,6.11196767069,-3.40147084135,8.10463399849,-3.3960587882,-2.34016514915,-3.43653173898,-1.47884778825,-0.180750062376,-0.889317945872,0.257315221392,-0.218618402042,-0.080963047642,-0.541180388083,-0.455133175674,-0.640012340672,-1.60805464047,-0.809998928739,-0.270099275862,-0.951157574199,0.586727659478,-0.598526256261,-0.355648720842,-0.0982498984115,-1.04050581859,0.281614504234,-0.739380507402,-0.0753312870462,0.00901542800022,-0.13583818432,-0.057921066754,-0.13648361368,0.0257340571037,0.0475545012495,0.256384164088,-0.152571742257,-0.140122389204,0.0264797936968,0.210413134183,0.836796357888,0.611626383014,0.0881276528425,-0.0940766001223,-0.714844630893,-0.468516903706,-0.258791646165,-0.0968510440335,0.180331918475],[-33756.7513162,-311.420517835,-3168.86618334,-1398.81092723,-2996.25760606,217.986142726,2248.77402862,-349.046118036,-708.717080295,864.716570088,266.816460025,-659.647470949,-35.3490663284,-258.069134251,433.96159791,-348.830237479,-335.934908548,278.552553628,-928.25548469,-281.198178007,-118.834149016,-28.7068983192,244.612282973,-479.55021698,80.5766226198,94.832415576,-65.4204448668,144.876403323,107.526656022,126.36750355,-183.97524265,-167.160489281,-17.8233688152,-211.410995491,270.496961013,-8.84103785339,27.1972685776,23.8293348731,12.0244373335,-15.4492759722,-45.5440450629,-76.9257006352,-92.8360445566,-4.82403386593,-69.9045222465,45.5909688344,-28.5648018715,-13.4340272034,2.09010060562,3.14450652311,1.15517498125,5.24512682358,-6.71122714653,-3.42608985004,-18.8257610212,-1.46254527216,-29.9276529522,-31.1191437024,-2.04398363683,-12.0839719283,16.5113589645,3.8981908616,9.7610349045,0.52501213189,0.929334441485,-4.99223864906,2.92601397671,1.18069071665,5.20054491556,-2.7791771296,-2.90650586508,-4.80950113379,-8.72822692063,6.16092295255,-3.41852148473,8.16409299511,-3.42462934817,-2.39720312491,-3.44926630865,-1.47954187682,-0.168306431463,-0.884189242024,0.263210454257,-0.192409853939,-0.0519482970408,-0.550675054444,-0.462953104104,-0.634780380518,-1.64758667521,-0.825840174108,-0.269874333587,-0.966038503783,0.593363342008,-0.607336671734,-0.386188948994,-0.101765376474,-1.03771681031,0.283515470714,-0.73765951108,-0.0821921560254,0.00947750698842,-0.135602751928,-0.0540077085324,-0.137775899909,0.0269569791912,0.0447475552833,0.267383673518,-0.160680420479,-0.139573911834,0.0224770497515,0.20561007453,0.842796278027,0.608509410013,0.0839125121203,-0.101107058238,-0.720369893332,-0.471588868236,-0.260040331141,-0.0969735539762,0.182813841209],[-33793.0523859,-360.562883659,-3153.20103421,-1363.869828,-2965.17082847,222.114904916,2231.49552355,-336.25415117,-744.932164099,840.826857343,252.400644375,-646.961325772,-28.057742808,-268.37542123,447.591140188,-344.017742483,-340.821874012,279.984937128,-925.76819666,-278.770345194,-113.042633124,-31.8402342273,246.069128075,-489.957061855,77.3936595337,94.9868473946,-68.2905889353,145.57045991,106.148220499,129.626926908,-187.815725738,-167.710565869,-22.2795418317,-213.863656728,272.775402155,-8.24179673401,26.8888564019,25.1430441712,11.2833296269,-15.5820549198,-45.2905310853,-78.5226499154,-93.7500299576,-5.78045711036,-70.8702645247,45.9495906276,-28.1983364903,-13.7167550425,2.03689585678,3.31789827079,0.951921910372,5.22002039487,-6.99993099512,-3.20459332979,-19.128771058,-1.42219095115,-30.1796441771,-31.3872191653,-1.87263288767,-12.1339387178,16.5964682254,3.84345471906,9.71743963838,0.546137981842,0.966911392869,-4.93894904149,2.85673130741,1.16537472522,5.24332367622,-2.82871856203,-2.88250892183,-4.93001639247,-8.84572735942,6.21145884395,-3.43624660987,8.22515283762,-3.45577959481,-2.45823762157,-3.46394133044,-1.48280346513,-0.154599203981,-0.878800516559,0.269796909563,-0.165897593076,-0.0234457247429,-0.560129366262,-0.469626664186,-0.630303822353,-1.68771596918,-0.84196378321,-0.271730319286,-0.980940542738,0.597851544964,-0.61621887913,-0.418318972156,-0.104423922618,-1.03563695428,0.285759101182,-0.737061816188,-0.0891102329962,0.010271839232,-0.134983829204,-0.049855085683,-0.139625332511,0.0286219688263,0.0418713255582,0.279160162664,-0.168738241147,-0.138775268205,0.0180005973893,0.200965679858,0.84883320881,0.605809498429,0.0793704332232,-0.108240994648,-0.72626829338,-0.475179030718,-0.261450715116,-0.0972719789519,0.185629788885],[-33827.8260149,-411.041889541,-3134.5784429,-1325.4443414,-2931.96828094,225.680990752,2214.28450645,-322.16247157,-780.143058822,815.060050115,239.576597944,-634.382817728,-20.8030233217,-279.012097951,462.985017169,-338.595559814,-346.112013657,281.415229144,-923.11183766,-275.783662772,-107.1523454,-34.6158097957,247.743452655,-501.129105178,74.35724799,95.1484380914,-71.4750256563,146.522123184,104.892176532,133.126298704,-191.635095096,-168.351552343,-26.8616872428,-216.566408243,275.285499279,-7.56952483173,26.5640741673,26.4206929568,10.5373092338,-15.702493793,-45.0925828899,-80.1303527703,-94.7343621895,-6.77652120778,-71.8940577099,46.3159889128,-27.8340791916,-14.0369775496,1.99290967238,3.4849795542,0.727748394206,5.18644836023,-7.3196567653,-2.98842308918,-19.4261678751,-1.38316389815,-30.445622318,-31.6705553583,-1.71577581357,-12.1792362724,16.6855220374,3.79634810577,9.68300185941,0.57173269784,1.00504425509,-4.88940980956,2.78524522694,1.1434894787,5.28959020587,-2.87291484859,-2.85994751925,-5.05130669969,-8.96882238158,6.26287702592,-3.45416396313,8.28799186547,-3.48887801616,-2.52279041821,-3.48061304831,-1.48884772068,-0.139625549083,-0.87328409807,0.277313057853,-0.139113553989,0.00430602738694,-0.569340708968,-0.475253366397,-0.626727136272,-1.72844248658,-0.858511713064,-0.275856439105,-0.995745734084,0.600074734371,-0.625026175213,-0.451886140145,-0.106161627437,-1.03424454006,0.288362847461,-0.737574352726,-0.0960511057336,0.011344818048,-0.133899988811,-0.0455053235623,-0.142036324959,0.0307565716806,0.0388642334457,0.291742636179,-0.176778812295,-0.137733010911,0.0130589750389,0.196506735221,0.85488202306,0.603584056693,0.074556225877,-0.115418231676,-0.732497085193,-0.479278325551,-0.262994487971,-0.0977764223595,0.188774116897],[-33859.7291554,-462.844483371,-3111.63976126,-1284.4479122,-2896.36177555,228.463716987,2196.75299475,-307.280166839,-814.078078638,787.391640287,228.598839492,-621.997537164,-13.6252424963,-289.991553046,479.956246396,-332.631988269,-351.666948485,282.767074677,-920.364621619,-272.251583533,-101.226035176,-37.0703400308,249.596414954,-512.972057664,71.4660282882,95.3323032807,-74.9720974345,147.717065203,103.757387541,136.860705278,-195.408228516,-169.069912206,-31.5610582114,-219.5078486,278.009119192,-6.82809684623,26.2279878561,27.6529940096,9.7934762176,-15.797851856,-44.9568239686,-81.7397908141,-95.7883452869,-7.81128995524,-72.9718120621,46.6847494229,-27.4703536846,-14.3893044596,1.95566841483,3.64347175267,0.484083375252,5.14631186388,-7.67138447826,-2.7785946729,-19.7165099608,-1.34581492589,-30.7264223701,-31.9663078919,-1.57670784878,-12.218687992,16.7793272528,3.75747313998,9.65786808439,0.601641948261,1.043302905,-4.84341468489,2.712548439,1.11495988455,5.33887241221,-2.91174949324,-2.83902681272,-5.17349200143,-9.09733658231,6.31457487461,-3.47166713003,8.3529046838,-3.5233066519,-2.59018594931,-3.49936800238,-1.49783425573,-0.123406129966,-0.867778812274,0.285953017553,-0.112094978299,0.0310783042354,-0.578113429163,-0.479927657978,-0.624247458184,-1.76971739911,-0.875596864911,-0.282393465593,-1.01032191468,0.599937914144,-0.633671637985,-0.486719976258,-0.107022587697,-1.03347960049,0.291317047743,-0.73916149587,-0.102974142838,0.0126313268842,-0.132285538972,-0.0409955329335,-0.145001762839,0.033368576396,0.0356622459267,0.305143159462,-0.184839198376,-0.136445858864,0.00766257817911,0.19225378654,0.860896594579,0.601850780996,0.0695394863854,-0.122596387493,-0.738984994799,-0.483859950754,-0.264642577362,-0.098509206966,0.192222788776],[-33887.8547111,-515.961968415,-3082.75692975,-1242.12438839,-2858.24389721,230.337929569,2178.8474946,-292.189791404,-846.448773695,757.876584794,219.685444994,-609.819358726,-6.53585102718,-301.337521027,498.26884986,-326.209704545,-357.336154067,283.976628419,-917.622695998,-268.234395404,-95.315369363,-39.2652389345,251.592823157,-525.362778234,68.7203422312,95.5579277219,-78.7725630968,149.133907819,102.739800571,140.823945061,-199.111295732,-169.840978672,-36.3634272468,-222.672200469,280.927188883,-6.02261394544,25.8853068969,28.8322111734,9.05792494142,-15.8536174786,-44.8892851178,-83.3402708476,-96.9092405597,-8.88150095025,-74.0975918734,47.0506321748,-27.1053697008,-14.766995171,1.92217532122,3.79073568521,0.222860651128,5.1014793073,-8.05514989148,-2.57686037003,-19.9981590517,-1.30962438897,-31.0226491173,-32.2701279453,-1.45809897282,-12.2507854566,16.8791210414,3.72752511861,9.64180327012,0.635563566542,1.08132804937,-4.80085169743,2.63965803462,1.08001744639,5.39052579277,-2.9451083395,-2.81995230931,-5.29645655247,-9.23084588151,6.36616245804,-3.48791196072,8.42030576376,-3.55838458994,-2.65971108538,-3.52045663257,-1.50983771856,-0.105974895176,-0.862438265885,0.295909294799,-0.08490295532,0.0567148055929,-0.586330615362,-0.483765715816,-0.623098357162,-1.81145668339,-0.89327057601,-0.291417707284,-1.02451089265,0.597325549185,-0.642084631594,-0.522644395809,-0.107105053201,-1.03321161783,0.294647310074,-0.741774270799,-0.109847038034,0.0140602675086,-0.130090524932,-0.036366812914,-0.148511453563,0.0364561907228,0.0322056090058,0.319361338607,-0.192949966158,-0.134902722441,0.00181621188893,0.188229630813,0.866822586222,0.600609076757,0.0644189717351,-0.129745368834,-0.74562681492,-0.488882188967,-0.266354443749,-0.0994945678597,0.195944138333],[-33912.0518388,-569.486738071,-3047.95458352,-1199.50682107,-2817.73193939,231.315276385,2160.59541747,-277.438189801,-877.025527532,726.697363539,212.974364176,-597.811454469,0.414379658706,-313.057409133,517.539974011,-319.410558873,-362.932980687,285.00983167,-914.970606383,-263.822056492,-89.4392783129,-41.2793302095,253.700872608,-538.154218291,66.1217080803,95.8512457314,-82.8530947906,150.749033226,101.842719488,145.003500538,-202.726878448,-170.635900896,-41.2547991691,-226.039666207,284.01817708,-5.16246867192,25.5411956081,29.9534060226,8.33741972002,-15.8566742828,-44.8920819485,-84.9210881138,-98.0896318984,-9.98353116248,-75.2622309535,47.4089032146,-26.7364902309,-15.1624332026,1.88922179894,3.92439017665,-0.0535299965301,5.05448354979,-8.46894651901,-2.38536324328,-20.2688976043,-1.27338036017,-31.3346530047,-32.576939165,-1.36153248899,-12.2740970684,16.9861568564,3.70702208705,9.63424768188,0.672925148712,1.11859385232,-4.76158856808,2.56760944709,1.03919391806,5.44381956,-2.97282884383,-2.80290169545,-5.41998522029,-9.36861349215,6.41713318512,-3.50191531817,8.49037035749,-3.5933539239,-2.73067950783,-3.54413500617,-1.52492452301,-0.0873994797811,-0.8574618344,0.307317090974,-0.0576021290836,0.0811184982873,-0.593921881637,-0.486852330941,-0.623450487205,-1.85355353759,-0.911492525632,-0.302929400174,-1.03812487958,0.592154076335,-0.65018876039,-0.559442023009,-0.10655294816,-1.03326564099,0.298368925722,-0.745336028661,-0.116631906763,0.0155508427255,-0.127297369522,-0.0316685365081,-0.152535383616,0.0400171307672,0.0284605866805,0.334364615923,-0.201117958695,-0.133094658322,-0.00447702016474,0.184459198052,0.872583209123,0.599827634824,0.0592919616612,-0.136851867652,-0.752301833838,-0.494294375624,-0.2680913195,-0.100754095005,0.199892094918],[-33932.6818852,-620.656608221,-3008.12878384,-1157.51087967,-2774.88707437,231.144172485,2141.90954521,-263.726635353,-905.666459454,694.03450958,208.466357438,-585.845862577,7.16686140043,-325.024655824,537.328761088,-312.338148434,-368.269955771,285.841815463,-912.446008508,-259.110577283,-83.5870907007,-43.1918194918,255.873934982,-551.184424821,63.6646410476,96.2345688712,-87.1743214919,152.534321613,101.066653692,149.383810203,-206.247205276,-171.416932124,-46.2289537456,-229.585563159,287.253597256,-4.25934013569,25.2021678249,31.0151993958,7.63813272897,-15.7963866256,-44.961394376,-86.4743083834,-99.3174926679,-11.1150960161,-76.4552326144,47.7575500233,-26.3588119277,-15.5660520135,1.85413594274,4.04261098618,-0.341795854566,5.00798405075,-8.90931274817,-2.20619168545,-20.5268315974,-1.23577276381,-31.6621761087,-32.8809334178,-1.28728218538,-12.2871643108,17.100562742,3.69528049362,9.63369399563,0.712995546954,1.15440170525,-4.72540116761,2.49729635233,0.993229383668,5.49770078529,-2.99480795642,-2.7878532912,-5.5439227934,-9.50928387155,6.46660268828,-3.51261421064,8.56292224378,-3.6274855991,-2.80239591043,-3.57032330795,-1.54304815053,-0.067784540922,-0.853076359407,0.320175872282,-0.0302485195919,0.104267385801,-0.600865099708,-0.489163116681,-0.625392272776,-1.89589827918,-0.93010820449,-0.316867679649,-1.05093949692,0.584420147661,-0.657915719732,-0.596912697069,-0.105549910666,-1.03343925371,0.302425120196,-0.749742631584,-0.123283028129,0.0170068472543,-0.12392603552,-0.0269513875937,-0.157006100827,0.0440261577058,0.0244226829387,0.350071559109,-0.209331969257,-0.131009564058,-0.0112115486138,0.180978968716,0.87806783709,0.599440608726,0.0542312023892,-0.143901083641,-0.758881272641,-0.500015935258,-0.269837041122,-0.102294160371,0.20400131272],[-33950.5802981,-666.934141657,-2964.57052965,-1116.84161314,-2729.9532162,229.515441031,2122.43501273,-251.653969348,-932.283096637,659.932544154,206.099110194,-573.862743417,13.5593993913,-337.079972318,557.144975604,-305.081865021,-373.160506542,286.420084355,-910.065733858,-254.173528601,-77.7171715377,-45.0679606363,258.070480922,-564.327106695,61.339793742,96.7151109586,-91.6839698901,154.45750949,100.403931354,153.94677479,-209.675022073,-172.14817295,-51.2931395645,-233.283162926,290.602619503,-3.32539803276,24.877083335,32.0185066098,6.96529211239,-15.6653483279,-45.0908085835,-87.9946671076,-100.576571672,-12.2762452544,-77.6655193547,48.0931866041,-25.9654988358,-15.9697738068,1.81496724935,4.14444284499,-0.638240600577,4.96416559087,-9.37205465017,-2.0405258676,-20.769678175,-1.19537702499,-32.004706592,-33.1769618711,-1.23514644904,-12.288358895,17.2215445025,3.69128836147,9.63826991619,0.754987053227,1.18777361314,-4.69180879115,2.4293471441,0.94312701551,5.55073740972,-3.01107052261,-2.77451902408,-5.66821559262,-9.65106285386,6.51331767596,-3.51882093911,8.63730999022,-3.66013246176,-2.87430923651,-3.59871530531,-1.56399317938,-0.047317883025,-0.8494936423,0.334349513043,-0.0028929192775,0.126143062888,-0.607159959637,-0.490495620443,-0.628929948158,-1.93829104104,-0.948871575476,-0.333176532503,-1.06273783561,0.574195018613,-0.665136985107,-0.634869628473,-0.104212389109,-1.0335148708,0.306726920406,-0.754878027017,-0.129742042764,0.0183247472079,-0.120016561888,-0.0222736664491,-0.161824825261,0.0484245560629,0.0201179486029,0.366364806469,-0.217565112396,-0.128641248609,-0.0183681184348,0.177835834412,0.883159707106,0.599389738199,0.0492758838158,-0.150874566665,-0.765253277231,-0.505953013824,-0.271583470965,-0.104106994946,0.20821095883],[-33965.860536,-707.600617511,-2918.8261235,-1078.04449159,-2683.38772738,226.069141609,2101.56364625,-241.417060796,-956.894265113,624.33860541,205.743902773,-561.957510807,19.378002495,-349.035909859,576.543289175,-297.695380866,-377.432787402,286.672372758,-907.863154386,-249.032863759,-71.7671908028,-46.932512114,260.249859826,-577.49916957,59.1357654651,97.2777826721,-96.3203114263,156.482003983,99.8370846832,158.672241647,-213.014162253,-172.798174707,-56.4615828022,-237.09943314,294.031783466,-2.37207988641,24.5761146555,32.9660512796,6.32312419092,-15.46035144,-45.2730466566,-89.4761047848,-101.845546737,-13.4689948497,-78.8809632357,48.4083786069,-25.5511412792,-16.3671169145,1.77092537206,4.23000767401,-0.938917563559,4.92488431369,-9.85234076338,-1.88836601386,-20.9943589571,-1.1504121136,-32.362152417,-33.461136067,-1.20547525629,-12.2762694028,17.347838085,3.69453865121,9.6461658538,0.7981758473,1.21760008832,-4.65989999151,2.36426458727,0.890103149673,5.6013165594,-3.02206148586,-2.76227640964,-5.79300404438,-9.79185997895,6.55568490649,-3.51930656887,8.71256277842,-3.69066075156,-2.94586819456,-3.62889404627,-1.58743887076,-0.0262768009628,-0.846833118464,0.34960627828,0.0244735889612,0.146680679952,-0.612787495258,-0.49054616661,-0.633982987315,-1.98044181201,-0.967474223715,-0.351861427871,-1.07334232306,0.561643271675,-0.671642140777,-0.673074855958,-0.102571453282,-1.0333304242,0.311167294081,-0.760628269468,-0.135939401915,0.0194058090033,-0.115627655058,-0.0176949745128,-0.166874077336,0.0531347438935,0.0155989759707,0.383096309489,-0.225780872799,-0.125997691951,-0.0259205674855,0.175086458317,0.887757070255,0.599643956603,0.044438632262,-0.157745725838,-0.771342194878,-0.51200700956,-0.273311054984,-0.106166697146,0.212469782963],[-33978.6616949,-743.569685045,-2871.54654091,-1041.55067955,-2635.60318276,220.831984323,2078.81063146,-233.152868547,-979.60562487,587.240010237,207.212523159,-550.29801908,24.4536959454,-360.701053864,595.183988398,-290.212153429,-380.974022166,286.542893075,-905.880665919,-243.678630774,-65.6658388225,-48.8051180711,262.36749071,-590.666695048,57.0347141778,97.8934725221,-101.025711911,158.569698813,99.3421982255,163.535337287,-216.270664397,-173.338919791,-61.7482355584,-240.990130274,297.508456304,-1.41009662739,24.3086108757,33.8623867638,5.71211194387,-15.1817884422,-45.5004232063,-90.9131815784,-103.10124475,-14.696979523,-80.0888934688,48.6931704387,-25.1127134378,-16.7530791092,1.72178677716,4.30035232974,-1.23982134445,4.89131331391,-10.344550354,-1.74941942569,-21.1983452203,-1.09894494319,-32.7351842319,-33.7297720659,-1.19888811858,-12.2492064845,17.4779923912,3.70498877065,9.65573892941,0.84169858934,1.24287683793,-4.62851890965,2.30236347689,0.835476046038,5.64792804328,-3.02843801729,-2.75026891899,-5.9185981082,-9.92933975373,6.59198276883,-3.51289636779,8.78764361606,-3.71860529807,-3.01643235339,-3.6604043813,-1.61292062596,-0.00497797708595,-0.845171469835,0.365668599391,0.0519211828699,0.165884382556,-0.617770214362,-0.488937290752,-0.640420742736,-2.02206823476,-0.985543014807,-0.372981200403,-1.0825525917,0.54700589544,-0.677183592359,-0.711267650985,-0.100589598928,-1.03279896769,0.31563255311,-0.766895163125,-0.14181131002,0.0201519096548,-0.110837870523,-0.0132682340927,-0.172037894019,0.0580741435089,0.0109514863146,0.400095757032,-0.233925130873,-0.12308776663,-0.0338508818572,0.172810523857,0.891777737621,0.600197856346,0.0397229150463,-0.16447960272,-0.777092836759,-0.518079408578,-0.274982867654,-0.108432481725,0.216738128774],[-33989.6948797,-775.806536572,-2823.39454148,-1007.54442102,-2586.91498124,214.36931473,2054.05133312,-227.129188639,-1000.54607621,548.727620895,210.195315149,-539.072467714,28.6646791259,-371.903937875,612.851555798,-282.644189532,-383.737511829,286.000091554,-904.163943768,-238.104247478,-59.3189751902,-50.7086882635,264.380697802,-603.838739866,55.0183039774,98.5336368523,-105.755016867,160.687956853,98.8980663558,168.50477845,-219.452799094,-173.74720656,-67.1636765088,-244.903334733,301.00878629,-0.450647334554,24.0837580324,34.7132574187,5.12967748723,-14.8333591617,-45.7638254227,-92.30207041,-104.320145587,-15.96465181,-81.2766040586,48.9365543952,-24.6491804847,-17.1245647077,1.66754836606,4.35745279125,-1.53690584681,4.86431001299,-10.8421509269,-1.62353354068,-21.379813661,-1.03857604634,-33.1250990394,-33.9790600711,-1.2159458311,-12.2051812814,17.6106912866,3.72310949124,9.66576192094,0.884511055559,1.26279752483,-4.59642244043,2.243805262,0.780626655465,5.68944393384,-3.03076483598,-2.73748501932,-6.04527212256,-10.0611093761,6.62042967894,-3.49857566962,8.86149867786,-3.74372025561,-3.08532232629,-3.69280206081,-1.63992640286,0.0162653884782,-0.844605424604,0.38228533814,0.0795610985425,0.18387433975,-0.622205204149,-0.485243449973,-0.648063032677,-2.06293876487,-1.00262506658,-0.396611418332,-1.09014572996,0.530572326325,-0.681491294626,-0.749187386137,-0.0981485444789,-1.03191139656,0.320007780453,-0.773604852365,-0.14731110994,0.0204687266938,-0.105743787187,-0.00903647618741,-0.177212446521,0.0631612893789,0.00629326628606,0.417180833596,-0.241917767012,-0.119915132729,-0.0421467125637,0.171107221236,0.895164889342,0.601068559067,0.0351349039197,-0.171035800749,-0.782465667532,-0.524088308645,-0.276550147623,-0.110853906735,0.220994381874],[-34000.5431711,-805.335048952,-2775.40960098,-976.200432707,-2537.88585304,207.560858233,2027.11742357,-223.36271368,-1019.85373506,508.898276986,214.339940585,-528.523624545,31.9393949898,-382.569192256,629.377141045,-274.985933974,-385.714170982,285.021121432,-902.793853869,-232.332760024,-52.6500187779,-52.6516136051,266.251474193,-617.020938889,53.0784936573,99.1726489572,-110.472634577,162.800761672,98.4847220624,173.542106447,-222.562918412,-174.006036813,-72.7166333229,-248.786971422,304.509021105,0.495787611933,23.9101253148,35.5249469758,4.57141228855,-14.4205956942,-46.0545721628,-93.6401039939,-105.479769235,-17.2769875281,-82.4308529603,49.1259306366,-24.1612207048,-17.4799806703,1.6078368149,4.40419285954,-1.82617139128,4.84486726758,-11.3384296223,-1.51056964117,-21.53757601,-0.966188605983,-33.5339025475,-34.2051447706,-1.25777499195,-12.1429371078,17.7450315614,3.74974224359,9.67552718129,0.92546255567,1.27694602031,-4.56241882039,2.18882131424,0.727097967007,5.72513094861,-3.02956227461,-2.72285091113,-6.1733422904,-10.1850348753,6.63926761837,-3.47553734827,8.9332040712,-3.7657085562,-3.15191767251,-3.72573848509,-1.66808446318,0.0371544998672,-0.845238817202,0.399251839895,0.107532170673,0.200855908841,-0.626218369054,-0.47908807132,-0.656722047493,-2.10286035572,-1.01823860184,-0.422833730247,-1.09589042934,0.512641436029,-0.684290099711,-0.786577543404,-0.0950997335274,-1.03069142341,0.324215166108,-0.780665433191,-0.152405514207,0.0202642334946,-0.100453262594,-0.00503393778638,-0.182317663128,0.0683173576924,0.00175398669402,0.434175383981,-0.249655951211,-0.116475077297,-0.0507954461316,0.170079148534,0.89789017672,0.602288039703,0.0306983257646,-0.177365849782,-0.787433364141,-0.529965164358,-0.277957025489,-0.113384189364,0.225222120941],[-34013.4041525,-834.455949882,-2728.48453425,-947.711770248,-2489.48823081,201.037982682,1997.64731045,-221.631771775,-1037.55138796,467.743554164,219.377767665,-518.868793412,34.2141123729,-392.587590908,644.528685476,-267.210309111,-386.898131316,283.587570624,-901.864407396,-226.415323006,-45.6176097244,-54.6608052867,267.943980568,-630.186327383,51.214877251,99.7930350886,-115.145693325,164.86602567,98.0778843961,178.615385434,-225.601069362,-174.096940424,-78.4168692389,-252.588813327,307.978226485,1.41966967558,23.7958437017,36.303368592,4.03344000916,-13.9470874624,-46.3642029559,-94.9256153871,-106.558872347,-18.6401705953,-83.537287406,49.2508396808,-23.6501376545,-17.8171315946,1.54105402921,4.44367634967,-2.10380509131,4.8341560464,-11.8270915382,-1.40986968779,-21.6708669015,-0.878422333106,-33.9636054233,-34.4038786258,-1.32582621408,-12.0620756,17.8801695589,3.78548336749,9.68452578757,0.963340949514,1.28518348537,-4.52546254183,2.13778605784,0.676491321789,5.75447846683,-3.02515190215,-2.7052928051,-6.30311897466,-10.2992717188,6.64705212631,-3.44316967699,9.00214897712,-3.78400105856,-3.21560647752,-3.75886548156,-1.69718880204,0.0574183810774,-0.847191490401,0.416386707977,0.135955379837,0.217049373841,-0.629905325209,-0.470148047064,-0.666259134865,-2.14161179327,-1.03195907173,-0.451683951026,-1.09952939185,0.49352637299,-0.685316109521,-0.823189123619,-0.0913419436584,-1.02916419454,0.328200044214,-0.787934755756,-0.157060643178,0.0194365670645,-0.0950654624763,-0.00129110206667,-0.18730428158,0.0734625512929,-0.00254157466281,0.450914440773,-0.257024085333,-0.112753833016,-0.0597685565489,0.169818812252,0.899949309927,0.603896617854,0.0264545772414,-0.183401733575,-0.791967634088,-0.535639105607,-0.279150498198,-0.115979973527,0.229392251145],[-34029.4906866,-866.667228284,-2683.2283733,-922.649868514,-2442.62158832,195.193297908,1965.66396711,-221.405510807,-1053.58889148,425.253966352,225.164841646,-510.277542147,35.4099782743,-401.88557972,658.069005219,-259.275919139,-387.281521089,281.664412096,-901.448265894,-220.40749061,-38.1969741785,-56.7779117348,269.415436932,-643.289618754,49.4299733827,100.373776127,-119.738783142,166.838785303,97.6400684866,183.70026304,-228.566984383,-174.007217041,-84.2609354884,-256.253450886,311.386929925,2.31287943021,23.7476090582,37.0519124366,3.51303217668,-13.4163346543,-46.6851777781,-96.1558805633,-107.536915883,-20.0585381723,-84.5806299122,49.3027694983,-23.1197071656,-18.1339811141,1.4649793969,4.47883036691,-2.36629095749,4.83270246012,-12.3026310248,-1.31987833072,-21.7794354542,-0.77197893727,-34.4153348091,-34.5712766786,-1.4206124676,-11.9626577912,18.015820683,3.83139361696,9.69230140096,0.997046111777,1.28757517773,-4.48453343464,2.09111565672,0.630423395346,5.77696948962,-3.01797076322,-2.68378212511,-6.43480862629,-10.40211062,6.64301488152,-3.40104914874,9.06799201315,-3.79794597524,-3.27580647446,-3.79195166624,-1.72710751828,0.0767854296358,-0.850516745177,0.433532252358,0.164915265191,0.232635114503,-0.633319037477,-0.458216653254,-0.676552745456,-2.1789015089,-1.04342754785,-0.483084446036,-1.10081515981,0.473589461693,-0.684324080102,-0.858745927076,-0.0867916059603,-1.0273863221,0.331942619578,-0.795258345535,-0.161238408646,0.0178955555944,-0.0896646076305,0.00217025442064,-0.192131815991,0.078509481755,-0.00647915252077,0.467243837719,-0.263927139188,-0.108730598499,-0.0690152451451,0.170404153036,0.901371696432,0.605924988522,0.0224556426177,-0.189076028531,-0.796038874666,-0.541041912953,-0.280063367353,-0.118596977875,0.233474519209],[-34047.2775795,-903.545328073,-2640.26031224,-901.544874437,-2397.26476666,190.467447245,1931.81704227,-221.791373776,-1067.95886564,381.653163241,231.662723008,-502.742014823,35.512898769,-410.454102654,669.897404916,-251.177210079,-386.856418662,279.193406276,-901.557302185,-214.338659119,-30.3567557246,-58.9800848442,270.626294001,-656.263473958,47.7188430127,100.879267977,-124.218421673,168.684175851,97.1343354662,188.779323198,-231.441363134,-173.737472824,-90.2183858387,-259.728195744,314.718939513,3.16789816658,23.7661094743,37.7716601082,3.0082935111,-12.8342756982,-47.0120727321,-97.3236861316,-108.396275344,-21.5259920742,-85.5464808092,49.2776010933,-22.5765503481,-18.4305381666,1.37782599684,4.5117383511,-2.61059809036,4.83946948758,-12.7612949524,-1.23851167735,-21.863307132,-0.643740533513,-34.8876266618,-34.7045429561,-1.54068690724,-11.845858864,18.1527163876,3.88876791716,9.69899598771,1.02595070789,1.2843302938,-4.43859509588,2.04902930363,0.590258830461,5.79214279227,-3.00878939309,-2.65753830001,-6.56822750316,-10.4923055166,6.6274072914,-3.34924628273,9.13074014799,-3.80721860611,-3.33199008509,-3.82498006743,-1.75779048424,0.0950304225759,-0.855154259812,0.450600246287,0.194448059477,0.247738388883,-0.636511439627,-0.443332716214,-0.687499662284,-2.21443493373,-1.05237855532,-0.516816274852,-1.09968367048,0.453258737407,-0.681237927121,-0.892921357641,-0.0813669516105,-1.02544719405,0.335462256678,-0.802505105015,-0.164908884876,0.015595517714,-0.0843124701067,0.00534591888852,-0.196756491323,0.0833682083228,-0.00997996941456,0.483025934076,-0.27033503225,-0.104389922188,-0.0784714240044,0.171862896048,0.902238525312,0.608362638277,0.0187736031283,-0.194351359959,-0.799632220664,-0.546134628796,-0.280626246778,-0.121194178273,0.237450339101],[-34064.6854547,-945.195927725,-2600.3240404,-884.724628402,-2352.84958228,187.275084005,1896.85415329,-221.846401056,-1080.72896262,337.356453579,238.829710622,-496.159530832,34.5429543739,-418.3295192,679.987944204,-242.948917573,-385.624585735,276.114316943,-902.148564249,-208.247836069,-22.0783665116,-61.1984490522,271.537412925,-669.01772291,46.0717822116,101.270619483,-128.558282969,170.382019463,96.5284241274,193.836187274,-234.185968891,-173.298058395,-96.2370629534,-262.964334062,317.960144141,3.97817845556,23.8461902798,38.4635542966,2.51929678857,-12.208939727,-47.338821484,-98.4190299366,-109.122955115,-23.0275024375,-86.4220820069,49.174030867,-22.0284640216,-18.7081270208,1.27837409395,4.5436796864,-2.83377100441,4.85311723502,-13.2001552212,-1.16323155546,-21.9230895441,-0.490896845425,-35.3763604118,-34.801844667,-1.68326927928,-11.7138021061,18.2917716261,3.95873943346,9.7053020396,1.04975534951,1.27578187242,-4.38664136174,2.01161113509,0.557082538052,5.79990434024,-2.99856186983,-2.62592153176,-6.70272705027,-10.5691018881,6.6011936733,-3.28832793512,9.19059041537,-3.81164872768,-3.38362403582,-3.85799163885,-1.78924936426,0.112016819373,-0.860985835313,0.46756305896,0.224517707817,0.262475687283,-0.639512424411,-0.425758433329,-0.698977251609,-2.24796248481,-1.05863128821,-0.552488050357,-1.09620077483,0.433014661997,-0.676094097008,-0.925365762398,-0.0750095251209,-1.02345318792,0.338787668826,-0.809536544955,-0.168049941434,0.0125301800756,-0.0790546862231,0.00823181280825,-0.201141528688,0.0879571149246,-0.0130083527559,0.498136676347,-0.276261623313,-0.0997202735884,-0.0880436904057,0.174174573116,0.90266800971,0.61116252599,0.0154969259674,-0.199207324078,-0.802741732096,-0.550894722815,-0.280773781797,-0.123737367311,0.241301927236],[-34080.8409304,-991.363516836,-2563.45798678,-872.230892154,-2308.880038,185.861774398,1861.00478868,-220.720958037,-1091.91942564,292.858599628,246.621726477,-490.45036332,32.5724584623,-425.531282027,688.325534563,-234.628459471,-383.593434645,272.40029881,-903.1483176,-202.212221075,-13.3899373816,-63.3446229121,272.086027047,-681.420871153,44.4836480074,101.521982441,-132.735705395,171.920779889,95.7946291826,198.849439844,-236.750119342,-172.700610227,-102.253117847,-265.917626706,321.086994345,4.7386686683,23.9804486843,39.1288265228,2.04878408554,-11.5483739739,-47.6571654268,-99.4298170956,-109.706787768,-24.5433480987,-87.1968363732,48.9945803221,-21.4838806653,-18.9670308315,1.16570661027,4.57560934298,-3.03271187926,4.87295819672,-13.6161722511,-1.09149670642,-21.9599235566,-0.311377847332,-35.8753570377,-34.8619275041,-1.84447354679,-11.5697129029,18.4331611245,4.04139989598,9.71185421156,1.06821586282,1.26250320596,-4.3278474927,1.97899759604,0.531672765393,5.80056781346,-2.98817831048,-2.58837672825,-6.83724635228,-10.6321542561,6.5656987457,-3.21931840081,9.24789859613,-3.81110989465,-3.43004802816,-3.89091301561,-1.8215761561,0.127665022142,-0.867850191005,0.484407831525,0.255033219763,0.276976297481,-0.642278736635,-0.405892286322,-0.710811694742,-2.27928652152,-1.06211741064,-0.589558085232,-1.09051855373,0.413387024988,-0.669040974776,-0.955739978101,-0.0677871689684,-1.02151125872,0.34190789001,-0.816178739064,-0.170650558781,0.00871254766364,-0.0739275149973,0.0108312445094,-0.205252643354,0.0922175854536,-0.0155578091382,0.5124621554,-0.281738229731,-0.0947124826183,-0.0976227893189,0.177278703449,0.902783200694,0.614227633141,0.0127128578395,-0.203640036047,-0.805357538434,-0.555298702352,-0.280456858848,-0.126193363553,0.244988537359],[-34094.7710907,-1041.95469155,-2528.35421451,-863.863884369,-2264.89474721,186.483485522,1824.40082898,-217.655496012,-1101.49284999,248.781550606,255.058758142,-485.457148753,29.845142212,-432.010394933,694.97241107,-226.253185045,-380.783717396,268.068207328,-904.465934578,-196.289922214,-4.34683796659,-65.305581804,272.19414392,-693.315072632,42.9513179598,101.614859608,-136.728854964,173.295536595,94.9153545327,203.800824094,-239.072419152,-171.956183814,-108.190126107,-268.542780972,324.07619034,5.44543446721,24.1608358518,39.767774933,1.60056706904,-10.8612323189,-47.9573308138,-100.339821311,-110.141830743,-26.0478267014,-87.8629522522,48.7478656909,-20.9520618366,-19.2047143888,1.03969271797,4.6084248544,-3.20448003581,4.89816616079,-14.0063262116,-1.02089469161,-21.9750137256,-0.104168258823,-36.3772266838,-34.8847584765,-2.01906477729,-11.417507174,18.5772100309,4.13625439875,9.71920528087,1.08123147886,1.24529637365,-4.26157079443,1.951440254,0.514459824498,5.79470211568,-2.97853828303,-2.54455367589,-6.97039163672,-10.6815269704,6.52287310599,-3.14361013359,9.3034116419,-3.80564150145,-3.47045793142,-3.92369073647,-1.85474615825,0.141937384985,-0.875491999789,0.501130467654,0.285909523425,0.29133345876,-0.644744803218,-0.384231016392,-0.72277766254,-2.30822828662,-1.06290249821,-0.62737120402,-1.0829362846,0.394970232266,-0.660396712337,-0.983707211911,-0.0599133285924,-1.01973731219,0.344758426107,-0.822250051319,-0.172705010368,0.00418947262128,-0.0689632125608,0.0131700395656,-0.209048440578,0.0961163786501,-0.0176386285151,0.525901428856,-0.286818754608,-0.0893778501195,-0.107101386985,0.18108566596,0.902720656851,0.61742502023,0.0105030630164,-0.207675481739,-0.807475244486,-0.559332157632,-0.279636223594,-0.128532986602,0.24846202605],[-34105.8803794,-1097.0161099,-2493.47946629,-859.309247779,-2220.44293144,189.384127065,1787.23622379,-212.04998763,-1109.436543,205.850069639,264.1364224,-480.936442304,26.6993307591,-437.713031744,700.011305121,-217.86401538,-377.238294286,263.16124312,-905.991921925,-190.529946719,4.97517190447,-66.9644259387,271.778253968,-704.527984931,41.474358604,101.533843516,-140.522907202,174.509407709,93.8808960725,208.672834116,-241.082883736,-171.078408054,-113.958776742,-270.793380146,326.906781281,6.09622153059,24.3770509417,40.380416674,1.17871114434,-10.1582068571,-48.2283785082,-101.129970972,-110.425358639,-27.5100199225,-88.4140530575,48.4467852472,-20.4421259588,-19.4170716017,0.901208666331,4.64288368623,-3.34637855996,4.92788234585,-14.3678935907,-0.949266654242,-21.9695936873,0.131040583542,-36.8733081654,-34.8708646994,-2.20056227929,-11.2611388441,18.7244678095,4.2428123934,9.7280571439,1.08888109652,1.22516377521,-4.18729211631,1.9291734512,0.505483173506,5.78315637322,-2.97057260116,-2.49425277314,-7.10042381554,-10.7175275353,6.47524907534,-3.06282615793,9.35807569545,-3.79532344578,-3.50396796445,-3.95628961779,-1.88861300763,0.154869643193,-0.883575373098,0.517751770795,0.317060235953,0.305613527158,-0.646844509412,-0.361385778621,-0.734612826969,-2.33463033497,-1.06111640065,-0.665145638605,-1.07383419382,0.37838563555,-0.650573823326,-1.00891519616,-0.051671358679,-1.01822660641,0.347253330087,-0.827562948353,-0.174214645988,-0.000953310792612,-0.0641948642351,0.0152849661265,-0.212491562831,0.0996500669805,-0.0192887488679,0.538370151988,-0.291570185003,-0.0837376729544,-0.116364993891,0.185477833092,0.902628294984,0.620592564056,0.00895304387735,-0.211356749153,-0.809079645938,-0.562987376307,-0.278273427564,-0.130737271508,0.251675500584],[-34115.0107931,-1154.47854385,-2457.97228053,-858.251513235,-2175.06878967,194.43832227,1749.79142517,-203.523593778,-1115.83686098,164.685011309,273.739017916,-476.56863785,23.4421253578,-442.516141079,703.596115558,-209.510325331,-373.056881532,257.72344961,-907.575097169,-185.004604802,14.513951598,-68.191821698,270.755544314,-714.893672122,40.054166634,101.266217702,-144.11173946,175.575307592,92.6841154881,213.455103651,-242.715076917,-170.081973175,-119.46855907,-272.63083966,329.567651137,6.69151860988,24.6174620624,40.9687571073,0.787183615112,-9.45347362369,-48.4579642978,-101.783898629,-110.556878675,-28.8982700346,-88.8448152584,48.1086777125,-19.9614929545,-19.6002222373,0.752405044344,4.67984676065,-3.45583108744,4.96107027089,-14.6991281425,-0.874674599053,-21.9457003577,0.39444937634,-37.3540977164,-34.8207459593,-2.38164743481,-11.1042183892,18.8755091385,4.36000409841,9.7393854318,1.09146431341,1.20319506848,-4.10457161158,1.91224434813,0.504370265747,5.76704035094,-2.96516227402,-2.43735338595,-7.22546607643,-10.7404837671,6.42550435581,-2.97868095655,9.41303068604,-3.7804032838,-3.52966333271,-3.98855775258,-1.92306696694,0.166564059102,-0.891749957517,0.534320218459,0.348394184187,0.319926269794,-0.648529429941,-0.338020038185,-0.746034152432,-2.35841051583,-1.05689434024,-0.702055843925,-1.06360991959,0.36428297722,-0.640017190157,-1.03099747714,-0.0433324813354,-1.01704747229,0.349279103456,-0.831954719491,-0.175198981967,-0.00660776378602,-0.0596531932917,0.0172199570962,-0.215539239377,0.102835226985,-0.0205669617111,0.54980045998,-0.296068766845,-0.0778089748077,-0.125295214675,0.190323604784,0.902668931758,0.623559845973,0.00815286112544,-0.21472820924,-0.810146563416,-0.566274875583,-0.276344611404,-0.132792169056,0.254589637969],[-34124.2857811,-1212.18550056,-2422.33771453,-860.203980347,-2128.90408172,201.48889197,1712.28826813,-191.730451379,-1120.81410934,125.727945207,283.702037346,-472.137184977,20.2558415514,-446.32449492,705.784066428,-201.231784024,-368.357982495,251.797593612,-909.049892163,-179.81815061,24.2303023211,-68.9030230523,269.059683621,-724.279594959,38.6967954158,100.811302449,-147.49029334,176.508322102,91.3236066965,218.133538916,-243.921873902,-168.989838403,-124.64254983,-274.024247642,332.051754419,7.23238851969,24.8711564947,41.5360893285,0.431452645855,-8.76271244518,-48.632952593,-102.290870883,-110.537506564,-30.1875797734,-89.1490326877,47.748780185,-19.5154368954,-19.7523456619,0.595704234802,4.72038810744,-3.53060526456,4.99726186744,-14.998562149,-0.795136086925,-21.9058024702,0.685939501005,-37.8106634465,-34.7346279183,-2.55535142687,-10.9496518067,19.0308352148,4.48668996931,9.75467762506,1.08933256966,1.18038904277,-4.01310357359,1.9006731915,0.510510295919,5.74767479059,-2.96283225279,-2.37388170033,-7.34378143288,-10.750766552,6.37587854673,-2.89277956071,9.4691407144,-3.76109738194,-3.54672167306,-4.02024124164,-1.95807180067,0.177158421608,-0.899724150676,0.550877185965,0.379809988823,0.334387579025,-0.649723615334,-0.314765739738,-0.756742014553,-2.3795228865,-1.05038223001,-0.737309034947,-1.05256000254,0.353270702838,-0.629048285534,-1.04958164748,-0.0350733457076,-1.01624020348,0.350736565425,-0.835268361464,-0.175684530254,-0.0126666844942,-0.0553668987808,0.0190174248899,-0.218159637643,0.105705510771,-0.0215286744576,0.560131026449,-0.300366890968,-0.071614673888,-0.13377583403,0.195492868083,0.902990880364,0.626178046132,0.00818738219573,-0.217821652043,-0.810648252134,-0.56921900659,-0.273833847006,-0.134690378911,0.257174659502],[-34136.0578531,-1269.57543573,-2387.52727447,-864.792588325,-2082.61060164,210.652166328,1675.30391342,-176.200425505,-1124.50593222,89.3537907722,293.836492807,-467.603988905,17.263956981,-449.176292864,706.599795446,-193.056630105,-363.266688397,245.426288514,-910.256791392,-175.093828654,34.1054675341,-69.0591945728,266.63467363,-732.60304565,37.4138567667,100.17692318,-150.652125151,177.323169394,89.8001683215,222.684279217,-244.674401981,-167.836230308,-129.410445601,-274.950506958,334.352547391,7.7193362518,25.1282109008,42.0848464869,0.118266189223,-8.102793563,-48.7399305487,-102.643127103,-110.370403445,-31.3609945302,-89.3216238623,47.3745244322,-19.1102349593,-19.8740250866,0.433716730713,4.76547528538,-3.56868074521,5.0367879343,-15.2644602185,-0.708556376384,-21.8524843946,1.00466351927,-38.2354917575,-34.6133005857,-2.71548530464,-10.7995225312,19.1911102737,4.62246514085,9.7753829714,1.08276188486,1.15767421773,-3.91274206085,1.89460342724,0.523197286609,5.72656349812,-2.96391100582,-2.3040756348,-7.45384240966,-10.7488652654,6.3280766035,-2.80656805836,9.52686947927,-3.73761833997,-3.55456681647,-4.05116873546,-1.99359250226,0.186762596264,-0.907250458588,0.567477593981,0.411183946074,0.34906611297,-0.650302294083,-0.292217980907,-0.766399442175,-2.39792582656,-1.04176224116,-0.770153017863,-1.04087788521,0.345881989204,-0.617789381528,-1.06432346044,-0.0269663007908,-1.01586071175,0.351590571638,-0.83738922783,-0.175694706074,-0.0190273783403,-0.0513685215646,0.0207162955227,-0.220326664381,0.108307990144,-0.0222096746169,0.569307722952,-0.304479574577,-0.0651907743106,-0.141696493449,0.200867707868,0.903718486808,0.628329265942,0.0091167252252,-0.220661258787,-0.810567542253,-0.571841284846,-0.270714764878,-0.136424701386,0.259412229694],[-34152.8375807,-1326.91005489,-2353.28027322,-872.089737693,-2036.98384279,221.972525015,1639.44805793,-156.715698732,-1127.0058183,55.8417385891,303.93298242,-463.053077408,14.565695463,-451.141011126,706.124111849,-185.010702744,-357.917804756,238.651360635,-911.049096084,-170.956544349,44.0928944202,-68.658112377,263.391810176,-739.829210883,36.2187120761,99.3740800755,-153.588298792,178.037131541,88.1088027554,227.072586476,-244.960649154,-166.662492927,-133.715412144,-275.391676173,336.458901248,8.15374106479,25.3810069603,42.6154653441,-0.144286533209,-7.48884067593,-48.7674038191,-102.835452263,-110.062989293,-32.4083567373,-89.3607432161,46.9878238916,-18.7527429944,-19.9671697015,0.269481735083,4.81545083906,-3.56800769237,5.08039414299,-15.4953118421,-0.612793767724,-21.7883088053,1.34854244574,-38.6224715448,-34.4580995364,-2.85749503618,-10.6551606995,19.3556408039,4.76708809449,9.802207922,1.07215362165,1.13585699776,-3.80352778694,1.89423302241,0.541725351996,5.70524556579,-2.96861720792,-2.22824103748,-7.55432266559,-10.7352969594,6.28320393546,-2.72127600244,9.58623634531,-3.71012572666,-3.5528112625,-4.08101220607,-2.02958914577,0.195459429713,-0.914102720228,0.584186718118,0.442343672663,0.363961387391,-0.650062537789,-0.270895316054,-0.774656037168,-2.41358963088,-1.03125179672,-0.799912026948,-1.02870330369,0.342524996184,-0.606228342122,-1.07501129431,-0.0190131928917,-1.01602827112,0.351821491123,-0.838245155757,-0.175243630921,-0.0255856818696,-0.0476798484651,0.022354238247,-0.222010961893,0.110683472661,-0.0226355625473,0.577294345596,-0.308413187183,-0.0585828486236,-0.148946163617,0.206346809338,0.904944220642,0.629929881328,0.010951008516,-0.223244156969,-0.80991334389,-0.574137722219,-0.266961144984,-0.137972328869,0.261288809693],[-34177.4586026,-1384.2127661,-2318.1831378,-882.460912523,-1992.75227835,235.262393413,1604.99634667,-133.299566467,-1128.37357458,25.290932736,313.809776494,-458.568633004,12.2585827383,-452.159881805,704.482558896,-177.118857797,-352.461602091,231.530596619,-911.303249967,-167.508992509,54.1077781862,-67.7208922199,259.207710814,-745.954612559,35.123142347,98.4140622913,-156.290993825,178.66889712,86.2403624248,231.261777927,-244.779510472,-165.513407104,-137.522040222,-275.332268327,338.356768124,8.53787633813,25.6239981416,43.1270932719,-0.349097586122,-6.93321772549,-48.707219084,-102.866415702,-109.626986944,-33.3252238376,-89.2672071117,46.5906776492,-18.4485285575,-20.033433167,0.106039563139,4.87016193732,-3.52699771132,5.1286093738,-15.6904714208,-0.506089222454,-21.7157854216,1.71444073373,-38.966836631,-34.2708674074,-2.97883636999,-10.5176414075,19.5221758262,4.91989796774,9.83547330846,1.05805787025,1.11563698349,-3.68578091076,1.89962365791,0.565371233614,5.68514067478,-2.97710071338,-2.14666293558,-7.64410456699,-10.7107171634,6.24187153114,-2.63805727332,9.64706496139,-3.67865838821,-3.54116102073,-4.10916811363,-2.06610487802,0.203336053885,-0.920074527832,0.601045828846,0.473092617175,0.379028552294,-0.648783436311,-0.251229877731,-0.78123125171,-2.42650769361,-1.01910450457,-0.826041606253,-1.01616726071,0.343506154627,-0.594333124812,-1.08158052552,-0.0111995035497,-1.0169434305,0.351372707932,-0.837766383127,-0.174339007765,-0.0322353101458,-0.0443106009902,0.0239757431948,-0.223188158473,0.112860299608,-0.0228366138524,0.584068212938,-0.312171684472,-0.0518446110086,-0.15541802938,0.21183720974,0.906738883768,0.630924011602,0.0136550075165,-0.225536602499,-0.808732760071,-0.576089091912,-0.262562119824,-0.139297266214,0.262789740398],[-34211.8150425,-1442.49075456,-2281.11370766,-896.286575944,-1950.49510219,250.101076251,1571.99558312,-106.053164032,-1128.65235895,-2.24333232887,323.362231462,-454.195845112,10.4100249749,-452.069708784,701.758276644,-169.405513757,-347.017557322,224.142078191,-910.916496081,-164.830364132,64.0486027718,-66.3037074553,253.952592889,-750.997138,34.135012183,97.3108465802,-158.754205521,179.239442793,84.183357238,235.221770428,-244.135580534,-164.436255089,-140.812522423,-274.757394127,340.02810926,8.87418518802,25.8517334804,43.6173967248,-0.489112096455,-6.44526868941,-48.554159963,-102.736639169,-109.077315038,-34.1128388468,-89.0434096028,46.1844493516,-18.2023627067,-20.0740823491,-0.0539755038635,4.92868820966,-3.44500817914,5.18186801447,-15.8501108906,-0.387083288036,-21.6371508949,2.09841740961,-39.2654915154,-34.0539452657,-3.07873571494,-10.3878047452,19.6878430566,5.08025171347,9.87536446079,1.0411265697,1.09756919773,-3.56006857192,1.9107267926,0.593339113996,5.66748057896,-2.98948637471,-2.05962574069,-7.72235225499,-10.6760306538,6.20445115372,-2.55798502825,9.70908801577,-3.64314327645,-3.51948867399,-4.13500907452,-2.10323617594,0.210502406129,-0.924965884791,0.618073683183,0.503219149401,0.394165232218,-0.646264441362,-0.233609970186,-0.785925521248,-2.4366779374,-1.00561320697,-0.848134235526,-1.00335175727,0.349019924364,-0.582084298852,-1.08409757633,-0.00353958579227,-1.01886135865,0.350193558208,-0.835868851223,-0.172984885801,-0.0388713354615,-0.0412570162358,0.0256216222791,-0.223852241982,0.114863366406,-0.0228510339631,0.589626713343,-0.315752878137,-0.0450264718092,-0.161024280157,0.217259318564,0.90914842474,0.631271056523,0.0171542582268,-0.227498267205,-0.807100949813,-0.577668353161,-0.257513397621,-0.14036177372,0.263898222149],[-34255.6873112,-1501.49081802,-2241.66843624,-913.620840091,-1910.34271752,266.001198093,1540.18243483,-75.2985008349,-1127.83071236,-26.7105145196,332.557220633,-449.990777347,8.9700400705,-450.68337232,697.999322826,-161.912217477,-341.661167536,216.547170435,-909.784841562,-162.966592378,73.8145071928,-64.4821403219,247.522547903,-755.017853824,33.2529094935,96.0799878245,-160.968427194,179.773887992,81.9317190048,238.921496033,-243.046985836,-163.481639523,-143.589917176,-273.658139805,341.461543266,9.1645390021,26.0597488107,44.0833618598,-0.555681305643,-6.03141686664,-48.3079669786,-102.451009337,-108.431311519,-34.7767213933,-88.6931693929,45.7701477344,-18.0163909681,-20.0923539053,-0.208003548939,4.98957261484,-3.32226592891,5.24019047912,-15.9753834217,-0.254758414581,-21.5546784452,2.49590603967,-39.5163816051,-33.8101937181,-3.15772617075,-10.2660470447,19.8493437853,5.24723031268,9.92241487305,1.02223554007,1.08191112459,-3.42716967534,1.92734897773,0.624814652612,5.65327651428,-3.00576576093,-1.96754582669,-7.78859678267,-10.6322800927,6.17094892586,-2.4820772432,9.7717698131,-3.60364242471,-3.48785650544,-4.15789268351,-2.14103002553,0.217081036205,-0.928618125644,0.635256274148,0.53250665193,0.409242368156,-0.642314597063,-0.218358357434,-0.788612978766,-2.44414737388,-0.991076990831,-0.865947567638,-0.990345734998,0.359129307922,-0.569473718753,-1.08273033536,0.0039984651048,-1.02202480604,0.348230722501,-0.832479101709,-0.171187688284,-0.045388163857,-0.0385011071707,0.0273295856415,-0.223999988704,0.116710435531,-0.0227192163479,0.593983405002,-0.319174319701,-0.0381731419417,-0.165702109825,0.222534366587,0.912191522192,0.630950547159,0.0213406456808,-0.229094836443,-0.805113965742,-0.578868622452,-0.251826761383,-0.141130508586,0.26461231065],[-34307.5683529,-1559.29167474,-2199.99212722,-934.498051522,-1871.88556713,282.443073577,1509.4869316,-41.5971728344,-1125.85874571,-48.1313214091,341.437387194,-445.940064863,7.76080664358,-447.784086938,693.250857996,-154.696565666,-336.458548746,208.774634792,-907.780539437,-161.933909836,83.3412391561,-62.3511747824,239.856703074,-758.116017716,32.4706029062,94.7325261071,-162.924250856,180.301733317,79.4819714657,242.337758665,-241.547656525,-162.699984029,-145.866152356,-272.031473916,342.663616542,9.41179752977,26.2448976666,44.5209099882,-0.540802293445,-5.69592586843,-47.9733345466,-102.019495863,-107.707949013,-35.3241119987,-88.2212246035,45.3508168482,-17.8904215073,-20.0934762188,-0.353438967865,5.05113335296,-3.1596894764,5.30251424452,-16.0686959944,-0.10867007916,-21.4711255073,2.90186936787,-39.7182256141,-33.5427714032,-3.21653590494,-10.1519739261,20.0037477138,5.41981258579,9.97776845004,1.00240886719,1.06872613637,-3.2880487118,1.94911929229,0.658978465315,5.64320118659,-3.02581820191,-1.87109572517,-7.84273660336,-10.5805742961,6.14128537804,-2.4112699799,9.8345382868,-3.56051635114,-3.44643339121,-4.17731010112,-2.17943603693,0.223181838946,-0.930917860523,0.652568550377,0.560743766119,0.424114377066,-0.636780620516,-0.205702094677,-0.789290199218,-2.44903742669,-0.97580481778,-0.879399807404,-0.977249043292,0.373790684585,-0.556511197863,-1.07769857154,0.0114985421789,-1.02664194365,0.345421454398,-0.827563953168,-0.168956505904,-0.0516844879733,-0.0360090623638,0.0291404851078,-0.223628498072,0.118412169573,-0.022476873223,0.597162697787,-0.322482839881,-0.0313258973189,-0.169421149287,0.227590695476,0.915869544473,0.629961394073,0.0260895049155,-0.23030964677,-0.802873746727,-0.579719342779,-0.245521395684,-0.141576349155,0.264952395101],[-34365.7859964,-1615.26254615,-2156.81319708,-958.973355794,-1834.76382099,299.061621198,1479.97087507,-5.51940086996,-1122.57923893,-66.5976598399,350.155672089,-442.050418461,6.48199186836,-443.262567663,687.482090816,-147.792746355,-331.441158564,200.839191575,-904.798899362,-161.743581486,92.5629713011,-60.0479665868,230.935597932,-760.403345747,31.7845533332,93.2825576398,-164.613992496,180.848369488,76.8326406426,245.445753863,-239.682935627,-162.144483044,-147.657856523,-269.880757707,343.649564322,9.61874680973,26.4046039428,44.9245372989,-0.437804434217,-5.43857019315,-47.5613290814,-101.455391775,-106.928679301,-35.7652370055,-87.6327142948,44.9283214161,-17.8241832858,-20.0844194937,-0.488937832534,5.1113308886,-2.9593297753,5.36728971076,-16.1330590026,0.0507719483473,-21.3890125038,3.31060712462,-39.8710225524,-33.2547940788,-3.25631861786,-10.0450181858,20.1488406541,5.59719986412,10.042944728,0.982616468804,1.05793902608,-3.1439463668,1.97558040679,0.695097012762,5.63760120434,-3.0492341141,-1.77131907969,-7.88499336537,-10.5222111781,6.11539032836,-2.34640528532,9.89677323657,-3.5143149178,-3.39561848212,-4.19307767498,-2.21841049901,0.228926727553,-0.931818624904,0.669962920997,0.587710455776,0.438581147798,-0.629548398533,-0.195783890089,-0.788128932729,-2.45148071557,-0.960117184114,-0.888543610452,-0.964097431094,0.392823849566,-0.543222683919,-1.06929123431,0.0190424572366,-1.03289439671,0.34175251689,-0.821119877623,-0.166292588501,-0.057675022477,-0.0337352760496,0.0310852704994,-0.222775644685,0.119975064274,-0.0221561701183,0.599197666328,-0.325722420223,-0.0245220550983,-0.172183205878,0.232375035019,0.920159761621,0.628312658792,0.0312692691485,-0.231152959188,-0.800485198014,-0.580272825402,-0.238622212651,-0.141685486721,0.264947797543],[-34428.4655084,-1669.27997749,-2112.59369262,-987.04675388,-1798.81375517,315.836000988,1451.62341605,32.494104826,-1117.77209592,-82.2672959551,358.978677364,-438.35978712,4.83227199857,-437.108499686,680.654542689,-141.221524094,-326.624643667,192.751283439,-900.776995532,-162.397034365,101.412924856,-57.7046265943,220.781994001,-761.997664987,31.1939303928,91.74588676,-166.037034603,181.435356924,73.9907606651,248.222866645,-237.501344062,-161.864588665,-148.990107389,-267.221191161,344.441277842,9.78832617648,26.535958065,45.2881315302,-0.242251734754,-5.25522746274,-47.0885671834,-100.773596455,-106.117292597,-36.1117461509,-86.9342421796,44.502856936,-17.8171837489,-20.0737149568,-0.614230878547,5.16781195323,-2.72438884719,5.4325174707,-16.172409573,0.222192612715,-21.310455246,3.71658792111,-39.9761501936,-32.9495414357,-3.27919268292,-9.94497753229,20.2832188417,5.7786548535,10.1198666154,0.963789329124,1.04942101125,-2.99636659294,2.00618370632,0.732455548016,5.63663145272,-3.07531611584,-1.66958539397,-7.91580045364,-10.4587904439,6.09314887963,-2.28821153604,9.95804704014,-3.46573618841,-3.33598117721,-4.20532463063,-2.25800247099,0.234458974133,-0.931342820613,0.687407526265,0.613194622106,0.452415437474,-0.620575834736,-0.188682334785,-0.785481099028,-2.45161910395,-0.944343957554,-0.893577181399,-0.950916973615,0.415922129937,-0.529657314788,-1.05784350202,0.0267052261135,-1.04092114903,0.337262493348,-0.813185798413,-0.163203697989,-0.0632885885504,-0.031622945003,0.0331861013391,-0.221523677591,0.121404454461,-0.0217916159398,0.600131390519,-0.328924242793,-0.0177956824953,-0.174021355973,0.236850313592,0.925033173679,0.626039191565,0.0367691309797,-0.23165724336,-0.798059380112,-0.580607720856,-0.231169782547,-0.141459819539,0.264635983555],[-34493.8559143,-1720.36193214,-2067.67033944,-1018.52817794,-1764.02665986,332.82649374,1424.44814864,71.9961565368,-1111.24622586,-95.3606423516,368.182278131,-434.801608331,2.42448989099,-429.307792245,672.679369666,-134.984816146,-322.000438881,184.508085748,-895.694935693,-163.90319486,109.821109012,-55.43723158,209.468503613,-762.993353361,30.7005061395,90.1355300625,-167.201983024,182.077984228,70.9721604306,250.650838212,-235.056660699,-161.897128558,-149.897188962,-264.075892895,345.061281709,9.92216353415,26.6348974898,45.6053363085,0.0470134983791,-5.13974408126,-46.5759082241,-99.9904915517,-105.296763275,-36.375242583,-86.1306612682,44.0741752342,-17.867290473,-20.0687496585,-0.729404892731,5.21787148468,-2.45912324557,5.49556118214,-16.1909285532,0.403051532282,-21.2366512165,4.11469112441,-40.0362095923,-32.6299042954,-3.28850613458,-9.8519598018,20.4062952915,5.96325007234,10.2108787285,0.946863302653,1.04291099069,-2.84686170113,2.04013889386,0.770318585329,5.64014907751,-3.10333385618,-1.56750159584,-7.93580900882,-10.3918446393,6.07434314038,-2.23710845866,10.0181300071,-3.41545663488,-3.26810204812,-4.21434261753,-2.2982465071,0.239944160436,-0.929511282117,0.704911766884,0.636995417864,0.465347836461,-0.609944883611,-0.184425710177,-0.781822307623,-2.44962249757,-0.928765137251,-0.894830946832,-0.937731895241,0.442676187777,-0.515908694256,-1.04364683277,0.0345227363929,-1.05074740497,0.33202439922,-0.803811839878,-0.159697561775,-0.0684516114572,-0.0296045473869,0.0354583076826,-0.21997353112,0.122701444785,-0.0214223743389,0.600002702596,-0.332120453147,-0.0111859306328,-0.175001031279,0.240994196505,0.930445004226,0.623195330778,0.0425041483082,-0.231866133416,-0.795700191361,-0.580814830765,-0.2232196094,-0.140918185631,0.264057681268],[-34560.3947781,-1766.52007343,-2023.52667059,-1053.23341915,-1730.48156167,349.848255333,1398.42081094,112.658247439,-1102.94126788,-106.217160165,377.961971578,-431.257620322,-1.20459559645,-419.815327651,663.515872226,-129.071531966,-317.547509863,176.088471333,-889.58400091,-166.266276733,117.720066747,-53.3236506691,197.112385908,-763.461837193,30.3070599543,88.4574793912,-168.120883538,182.782775063,67.7934780426,252.712680057,-232.403424371,-162.267759575,-150.420160136,-260.471601716,345.532686808,10.0213657703,26.697635069,45.8701202365,0.428952047362,-5.08691629507,-46.0472735632,-99.1235386058,-104.48726886,-36.5676814282,-85.2251707021,43.6415764841,-17.9711556421,-20.075450078,-0.834218611768,5.2589581022,-2.16876501585,5.5537526369,-16.1930135061,0.590150075792,-21.1679453499,4.50000322186,-40.0549080202,-32.29855484,-3.28876054167,-9.76621187099,20.518073345,6.14985482463,10.3184336106,0.932826859306,1.03794834625,-2.69695498148,2.07654866683,0.807897455764,5.64773319723,-3.13276533133,-1.46677289115,-7.94592880923,-10.3226810778,6.05849136347,-2.19324266602,10.0768032768,-3.36414365542,-3.1925806644,-4.2204943355,-2.33908721264,0.245545541478,-0.926326444053,0.722462593751,0.658954716583,0.477053280779,-0.597812669548,-0.183009110435,-0.777685731225,-2.44566070049,-0.913589582451,-0.89276780317,-0.924552065561,0.472617384412,-0.502094431166,-1.02694491339,0.0425108372323,-1.06230997603,0.326127130906,-0.793052015583,-0.155779434498,-0.0730890186413,-0.0276128237435,0.0379017639889,-0.218229870806,0.123865325801,-0.0210956837058,0.598840128442,-0.335341320446,-0.00473945909831,-0.17521071269,0.244805158192,0.936331709683,0.619855292979,0.0483994888153,-0.23182727038,-0.793502130035,-0.580985805525,-0.214835014366,-0.140085842316,0.263258039115],[-34627.3057986,-1805.60849279,-1981.08627684,-1091.0334504,-1698.26907191,366.680521681,1373.55657929,154.215844907,-1092.86149474,-115.247603693,388.405620542,-427.629926878,-6.43332096358,-408.602300575,653.2830253,-123.447741389,-313.269138051,167.478198911,-882.515693494,-169.465532865,125.026227276,-51.4060455257,183.83956803,-763.469419158,30.016885648,86.7191646123,-168.812762468,183.548825778,64.4723403006,254.387628922,-229.589375327,-162.992957443,-150.600202058,-256.438987739,345.878685722,10.088637264,26.721612514,46.0779688372,0.899703380478,-5.09204378592,-45.5287801884,-98.1892742499,-103.707534646,-36.7017222436,-84.2221455926,43.204107093,-18.1254019664,-20.0987241171,-0.928298284576,5.28907754933,-1.85915293374,5.60491573865,-16.1831769953,0.779378335812,-21.1042851848,4.86754852574,-40.0365601319,-31.957768799,-3.28514664741,-9.68766980099,20.6186111408,6.33707760274,10.4444718175,0.922520876812,1.03404202546,-2.54816373173,2.11455634046,0.844270662107,5.65886752916,-3.16306241661,-1.36916075109,-7.94718263015,-10.2524120521,6.04481444468,-2.15662686954,10.1338826398,-3.31249800367,-3.10998923245,-4.22411769611,-2.38038912208,0.251413152186,-0.921827417334,0.740030422899,0.678984480059,0.487234734076,-0.584367863352,-0.184371766471,-0.773649831828,-2.43991241795,-0.898989075602,-0.887949822025,-0.911357959483,0.505234573766,-0.48831819075,-1.00796095277,0.0506811423901,-1.07549773479,0.319663784592,-0.780996569831,-0.151466946614,-0.0771399998102,-0.0255817442514,0.0405060836688,-0.216405418938,0.12490864859,-0.0208571594906,0.596668259023,-0.33859364163,0.00149672378783,-0.174754361847,0.248294146046,0.942611235707,0.616108524065,0.0543940826752,-0.231580057717,-0.791531852439,-0.581200992228,-0.206083281779,-0.138985452651,0.262281613094],[-34695.0850215,-1837.04956628,-1940.63192624,-1131.72912758,-1668.05585891,383.330881716,1349.96380742,196.512610299,-1081.06788792,-122.863202,399.53105285,-423.876324317,-13.4960924738,-395.716383463,642.152527031,-118.050951216,-309.187805945,158.689006974,-874.626474867,-173.474051174,131.648918581,-49.7112010159,169.780652474,-763.082610298,29.8354587848,84.9316000204,-169.3022338,184.363664719,61.0309088676,255.652140012,-226.661488298,-164.080783407,-150.481809203,-252.011644492,346.118950784,10.1257707811,26.7057788382,46.2262583991,1.45172574246,-5.15237582575,-45.0472097243,-97.2023839101,-102.975483338,-36.7912208186,-83.1267231544,42.7582659942,-18.3277069236,-20.1427360725,-1.01165125083,5.30699395317,-1.53658884318,5.64739765113,-16.1652446821,0.965625478824,-21.0451297715,5.21258490447,-39.9870574568,-31.609570887,-3.28351893188,-9.61608872994,20.7081483932,6.52373869015,10.5901927102,0.916350538521,1.03062130613,-2.40198127041,2.15345551071,0.878459455611,5.67303977213,-3.19364853902,-1.27656072184,-7.9407008771,-10.1819797467,6.03233058885,-2.12696070296,10.1891896289,-3.26118313695,-3.02096992926,-4.22566220087,-2.42194605117,0.257654113341,-0.916134346924,0.75756618155,0.697068982291,0.495614810021,-0.569856640735,-0.188371255107,-0.770288877184,-2.43252412891,-0.885100866612,-0.881017353431,-0.898104359709,0.539941154258,-0.474651881325,-0.986913622749,0.059044503161,-1.09015296505,0.312762188997,-0.767784801639,-0.146779104763,-0.0805735451124,-0.0234641910485,0.0432417508233,-0.214625650984,0.125864551777,-0.020732599132,0.593507511413,-0.341840073659,0.00746484479741,-0.173759302323,0.251495527179,0.949183649685,0.612066020967,0.0604395375929,-0.231150830154,-0.789831747073,-0.581519473691,-0.197028692984,-0.137639679263,0.261168277039],[-34765.3887432,-1861.53130332,-1902.62235932,-1175.03522115,-1641.08440058,400.046813507,1327.64525493,239.515996382,-1067.65474054,-129.546036184,411.347484655,-420.017158552,-22.5784706495,-381.255814237,630.245816584,-112.803503053,-305.330149992,149.73000706,-866.095817019,-178.269871834,137.516240247,-48.2613510097,155.075191129,-762.368725802,29.7733936374,83.1039956295,-169.618136449,185.205720656,57.4950345781,256.48339645,-223.668772414,-165.534799625,-150.115905662,-247.224876435,346.268584762,10.1338957075,26.6506887062,46.3122448747,2.0750598966,-5.26612568064,-44.6289497811,-96.1774400279,-102.306872798,-36.8512268468,-81.942717104,42.2971319693,-18.575822372,-20.2125782756,-1.08457826296,5.31220749618,-1.20757923893,5.67979763933,-16.142412648,1.14347899053,-20.9894721617,5.53110428546,-39.9134184896,-31.2555008134,-3.29042051321,-9.55113566552,20.7868359377,6.70885349887,10.7565414101,0.91438491946,1.02705798868,-2.25979336113,2.19263405075,0.909596207203,5.68969681646,-3.22392032143,-1.19082503259,-7.92773799983,-10.1120967939,6.01974125869,-2.10356638057,10.2423772154,-3.21076395151,-2.92619310536,-4.22563389525,-2.46361012875,0.264314507635,-0.909425705209,0.775018348167,0.713222279585,0.501911271313,-0.554539498622,-0.194761906576,-0.768137984873,-2.42360011915,-0.871997203176,-0.872680126536,-0.884684130494,0.576096056741,-0.461107863275,-0.963986715859,0.0676453744357,-1.10609123963,0.30557649994,-0.753578123001,-0.141728089551,-0.0833848714722,-0.0212240685684,0.0460606434756,-0.213022133546,0.126770500411,-0.0207252661645,0.58937392541,-0.345009205507,0.0131058309745,-0.172360286154,0.254474206607,0.955935546717,0.607863512939,0.0665002393551,-0.230551365195,-0.788432737402,-0.581987244928,-0.187732881349,-0.136070314875,0.259951388446],[-34839.3883403,-1880.15793242,-1867.34165091,-1220.61296059,-1618.77985102,416.952627716,1306.13062937,283.173820235,-1052.65034516,-135.800885193,423.903594457,-416.110855027,-33.7836838755,-365.236063287,617.618715959,-107.631491567,-301.697844037,140.598864505,-857.108813147,-183.812647876,142.579789589,-47.0656988099,139.84930334,-761.389183905,29.8437115608,81.2521995413,-169.793078197,186.051505286,53.8936953461,256.872587956,-220.657586638,-167.349796817,-149.56630851,-242.118625529,346.336519354,10.1150052992,26.5596286364,46.332429002,2.76027225609,-5.42915715519,-44.2982112048,-95.1285883334,-101.715728862,-36.8991350309,-80.6741179104,41.8141370152,-18.865908791,-20.3131209912,-1.14813344622,5.3046399224,-0.878436021296,5.70125468669,-16.1183466612,1.30767877541,-20.9361329542,5.8202654554,-39.8234131673,-30.8968448911,-3.31285118269,-9.49263689121,20.8543643463,6.89103768423,10.944256655,0.916485885419,1.02274869314,-2.1229838057,2.23161388148,0.936938111462,5.70819343029,-3.2530790929,-1.11355014849,-7.90974345604,-10.043453637,6.00549604947,-2.08547743438,10.2932816097,-3.16159764044,-2.82619456549,-4.2244270598,-2.50542489151,0.271383415399,-0.901986693817,0.792354354303,0.727451937566,0.505863887042,-0.53865655389,-0.203212506119,-0.767717138163,-2.41323081727,-0.859737593567,-0.863685263626,-0.870927249905,0.613080532203,-0.447663967267,-0.939331832118,0.0765102237823,-1.12310780835,0.298240652319,-0.738534003832,-0.136330659849,-0.0856063597986,-0.0188236292027,0.0489056245863,-0.211731093881,0.127652173259,-0.0208256533363,0.584299819878,-0.348001272151,0.0183744455454,-0.170684773364,0.257315832115,0.962769161621,0.603655649558,0.0725700013685,-0.229777250044,-0.787353550652,-0.582642443015,-0.178270326207,-0.134298948328,0.258648522069],[-34916.4730897,-1893.28043465,-1834.92033669,-1267.84042661,-1601.99442102,434.204709738,1284.87981303,327.271462427,-1036.0437273,-141.914324241,437.334582136,-412.113268123,-47.0878235862,-347.598440065,604.277171107,-102.486662087,-298.240934858,131.296034314,-847.796019784,-190.025704193,146.826939872,-46.1186695032,124.228110898,-760.189762528,30.0529666268,79.395108361,-169.862167636,186.883218113,50.2624838683,256.826166323,-217.665351,-169.506870636,-148.899583644,-236.733854961,346.326562936,10.0711788353,26.4350126702,46.2815678733,3.49914307162,-5.63538627108,-44.0745605275,-94.067500362,-101.213515214,-36.9523041328,-79.3257080268,41.3047731513,-19.1927831866,-20.4465971774,-1.20374397969,5.28395086714,-0.555458827747,5.7109068648,-16.0971695181,1.45324197315,-20.88393788,6.07801924502,-39.7245627221,-30.5346765268,-3.35663746575,-9.4404445388,20.9109176469,7.06854661707,11.1538359464,0.92245097442,1.01711832592,-1.99284575018,2.26982678047,0.959717017406,5.72764660712,-3.28030783599,-1.04615552657,-7.88829038321,-9.97673176709,5.98816671464,-2.07157994018,10.3421719085,-3.11389946442,-2.72125083784,-4.22237406257,-2.54745490472,0.278823740689,-0.894122118636,0.809575450162,0.739731948624,0.507240731174,-0.522474270478,-0.213395633274,-0.769526925869,-2.40153215321,-0.848396105434,-0.854698792415,-0.856627471289,0.650431095154,-0.434288872936,-0.913023171399,0.0855969770945,-1.14094945192,0.290849541165,-0.722800103955,-0.130612542218,-0.0872845967111,-0.0162118720225,0.0517182780759,-0.210873606793,0.128514412304,-0.0210218903945,0.578321820179,-0.350717610454,0.0232342558598,-0.168853612403,0.260113038298,0.969620203505,0.599585395624,0.0786849954699,-0.228835832579,-0.78658588077,-0.58351920929,-0.168723351632,-0.132353555458,0.257261127115],[-34994.4904008,-1900.07432137,-1804.52975579,-1315.91198727,-1590.77340884,452.286195737,1263.6936721,371.671818377,-1017.90910502,-147.914199401,451.852417012,-407.827509499,-62.3211384319,-328.295313038,590.200820234,-97.3586143565,-294.874605815,121.832940478,-838.24163819,-196.805345744,150.263038562,-45.4011847008,108.334262594,-758.769950687,30.3990181059,77.5460778314,-169.865269874,187.684078904,46.6416502082,256.360459573,-214.715646023,-171.975791064,-148.168642622,-231.110487051,346.236509132,10.0038507742,26.2747769126,46.1517181798,4.28271319888,-5.87868967505,-43.9722359756,-93.0016700018,-100.807728334,-37.0248576326,-77.9025716083,40.766598123,-19.5514634929,-20.6115836332,-1.25267607062,5.24903178455,-0.245037813624,5.70755770036,-16.0829705707,1.5753820473,-20.8316930638,6.30296521612,-39.6235552343,-30.169728302,-3.42583316742,-9.39441610728,20.9576530988,7.23959176601,11.3852039483,0.932095406546,1.00968047064,-1.87047537265,2.30657437198,0.977017307082,5.74694123918,-3.30507250928,-0.989857157215,-7.86489973038,-9.91251572792,5.96673635032,-2.06071078678,10.3897321493,-3.06773942458,-2.61143815198,-4.21985231487,-2.58973294529,0.286598432151,-0.886040078255,0.826718268529,0.750008855569,0.505817593159,-0.506289698344,-0.22507948236,-0.774002784035,-2.38864712156,-0.838052350197,-0.846235988052,-0.841561613464,0.687860113786,-0.420954134617,-0.885036939157,0.0947581347753,-1.15932914819,0.283482060442,-0.706517575219,-0.124604227706,-0.088455640899,-0.0133279328675,0.054444128053,-0.210546628727,0.12935410175,-0.0213097101426,0.571471694517,-0.353078658239,0.0276555677895,-0.166977790911,0.262957734598,0.976447403852,0.595767300813,0.0849195199643,-0.227759089205,-0.786087682129,-0.584639641519,-0.159170191469,-0.130269067303,0.255773024868],[-35070.9044395,-1900.645267,-1774.85907555,-1364.32427752,-1584.60367513,471.81025154,1242.55589828,416.129921075,-998.390016856,-153.639213026,467.66302968,-403.132599659,-79.1994280521,-307.360869717,575.38239191,-92.2626535936,-291.498437796,112.246878366,-828.534681695,-204.033361604,152.893868023,-44.9310011879,92.2718846424,-757.124704827,30.871098558,75.7178343364,-169.840960688,188.435206906,43.0658576577,255.488970457,-211.825091682,-174.719691639,-147.413082285,-225.278800902,346.060853463,9.91430875941,26.0752254733,45.933574222,5.10127469465,-6.15200207059,-44.0027800745,-91.9344402134,-100.502613507,-37.1307044521,-76.41049374,40.1959715268,-19.9383425556,-20.805041393,-1.29602938813,5.19791304008,0.0467919492029,5.69019837103,-16.0790867657,1.66905828504,-20.7779908451,6.49392213104,-39.5268605049,-29.8019599851,-3.52326445114,-9.35331087657,20.9958487979,7.40318877173,11.6374344134,0.945221519299,0.999889687612,-1.75682302581,2.34118071697,0.987916773807,5.76469009347,-3.32696715259,-0.945565321263,-7.84091325775,-9.85113621159,5.94041633286,-2.05153937137,10.4366238793,-3.02304344154,-2.49670325924,-4.21728496708,-2.63214122538,0.294697192581,-0.877890161429,0.843796138385,0.758211771741,0.501385928991,-0.490423314099,-0.238060734041,-0.781515168858,-2.37467407309,-0.828770129349,-0.838691396842,-0.825419336114,0.725170844834,-0.40754522602,-0.855331951783,0.103819447517,-1.17797848138,0.276211380328,-0.689830532743,-0.118327698051,-0.0891483507524,-0.010116141501,0.0570193829214,-0.21083121205,0.130158378824,-0.021693130654,0.563772417518,-0.355004827673,0.0316188338429,-0.165151356833,0.265959156713,0.983211854367,0.59230580936,0.0913573549498,-0.226587457922,-0.785777322245,-0.586001326711,-0.149659536013,-0.128074813722,0.254163241879],[-35143.8260036,-1896.60793768,-1744.6769907,-1412.65785157,-1582.69215929,493.157362987,1221.25777176,460.023129243,-977.57088864,-158.95418015,484.882837739,-398.037420463,-97.425425061,-284.836076987,559.806007634,-87.2236796028,-288.026129528,102.598369521,-818.765779084,-211.609605843,154.717321214,-44.7830696372,76.1227298414,-755.250050138,31.4533680531,73.9263872811,-169.825493305,189.114165756,39.556512553,254.216334277,-209.004771471,-177.693260015,-146.665872424,-219.256900935,345.786600109,9.80566472146,25.8323415051,45.6187537561,5.94368584943,-6.44622123303,-44.1751499825,-90.8684662436,-100.299086344,-37.2856240831,-74.8546747991,39.5886763936,-20.3494458709,-21.0226247969,-1.33493470219,5.1281573346,0.31488913286,5.65858473882,-16.0882822459,1.72923235334,-20.7215941725,6.64965770797,-39.4401083447,-29.4297117678,-3.65088654588,-9.3148471031,21.0259394123,7.55840421004,11.9090227238,0.961615394589,0.987268009237,-1.65266694571,2.3729965919,0.991524708884,5.77936540871,-3.34551437731,-0.913791022606,-7.81750278015,-9.79257914975,5.9082025594,-2.04268540662,10.4832646017,-2.97955540663,-2.37669926246,-4.21489097206,-2.67444552582,0.303162878867,-0.869802223754,0.860794220131,0.764266484541,0.493791177415,-0.475131942575,-0.252112071182,-0.792397474786,-2.35971441538,-0.820583129547,-0.832401519294,-0.80777068732,0.76223497119,-0.393853856026,-0.8238586583,0.112588509315,-1.19663996385,0.269059769271,-0.672840438205,-0.111800994953,-0.0893950767414,-0.00651906743194,0.0593783769223,-0.21180091139,0.130909846058,-0.0221904624508,0.555233090101,-0.356410742521,0.0351185180717,-0.163453775803,0.269233690495,0.989850286047,0.589286562562,0.0980868792234,-0.225355403836,-0.785529852283,-0.587575433828,-0.14021992212,-0.125788577499,0.252397524985],[-35211.5499693,-1889.21080633,-1713.12257019,-1460.18154709,-1584.10700742,516.452835661,1199.34509002,502.458591226,-955.458733237,-163.814553523,503.549902765,-392.552003192,-116.736646458,-260.762032561,543.442709147,-82.2748854509,-284.390041155,92.9521162193,-809.027549149,-219.456498839,155.733154747,-45.0529792267,59.9667086216,-753.137798205,32.1247471035,72.1884139437,-169.849971027,189.698329322,36.130062776,252.548792825,-206.265011643,-180.844285436,-145.962273171,-213.059089401,345.4007218,9.68143281404,25.5425924674,45.2025087888,6.79754201461,-6.75114198781,-44.4963571075,-89.8078841195,-100.19477848,-37.5041391926,-73.2385491923,38.9430374733,-20.7787224257,-21.2603656613,-1.37067153275,5.03744548732,0.554899026819,5.61271642378,-16.1131820972,1.75127988477,-20.661295,6.76967008011,-39.3680258232,-29.0498894978,-3.81007627146,-9.2763104383,21.0477062723,7.70391305432,12.1983027207,0.981092334205,0.971377583551,-1.55861519631,2.40136315791,0.98701835359,5.78942329087,-3.3601305799,-0.894789694973,-7.79565014176,-9.73648790677,5.86907843997,-2.03263305628,10.5299507951,-2.93690747907,-2.25095574469,-4.2126695455,-2.71637595278,0.312077274563,-0.861910000032,0.877673895988,0.768138946449,0.482937909631,-0.460642901506,-0.266963679331,-0.806973387933,-2.34387429083,-0.813465941455,-0.827693170707,-0.788160277577,0.798950204958,-0.379667257704,-0.790551509375,0.120903416868,-1.21501815344,0.262020172614,-0.655620479343,-0.105047946936,-0.0892318585548,-0.00248359688675,0.0614661186768,-0.213522177225,0.131594028776,-0.0228316884864,0.545852008328,-0.357221148294,0.0381531170907,-0.161959415338,0.272895145868,0.996293982886,0.586797932049,0.105210631466,-0.22407964983,-0.785192762836,-0.589325939297,-0.130879511996,-0.123423081474,0.250440428758],[-35272.4871351,-1878.77731363,-1679.31289617,-1505.82933293,-1587.81218053,541.743225522,1176.28075253,542.27481336,-932.083304854,-168.21608349,523.608275188,-386.669186018,-136.898894554,-235.224589761,526.292515812,-77.4714824634,-280.570914758,83.3866609595,-799.426919333,-227.525127495,155.936538214,-45.8311699994,43.8930929051,-750.770937913,32.8601016113,70.5220928682,-169.945709854,190.167751406,32.8051086252,250.497609084,-203.611289007,-184.118034618,-145.329536841,-206.700239709,344.895179319,9.54583129995,25.202206063,44.6859248997,7.64832870163,-7.0570998867,-44.9714000966,-88.7576631054,-100.185480916,-37.79571938,-71.5643069833,38.2605843104,-21.2182337531,-21.5154860386,-1.40411809532,4.92397958724,0.763569524718,5.55284817737,-16.1557148209,1.73082401193,-20.5962459808,6.85453381082,-39.3141927073,-28.6585543349,-4.00181797603,-9.23471953778,21.0604638388,7.83817002129,12.503684552,1.0034470761,0.951980499126,-1.47512952395,2.42567610742,0.973712410848,5.79356270702,-3.37016819159,-0.888604412554,-7.77605229334,-9.6822215591,5.82226318517,-2.01986659772,10.5769000024,-2.89476501608,-2.11907796413,-4.21051535397,-2.75762262239,0.321559095465,-0.85435552064,0.894393891719,0.769862233338,0.468861292236,-0.447220175094,-0.282331155393,-0.825535718952,-2.32731684623,-0.807308780159,-0.824873687431,-0.766162325755,0.835183187996,-0.364834440121,-0.755343334819,0.128641372053,-1.23278393737,0.255086420937,-0.638241348275,-0.0981139872606,-0.0886930924169,0.00201834745388,0.0632442808616,-0.216055937955,0.132214682535,-0.0236518636114,0.535618079392,-0.357375962282,0.0407276172541,-0.160740812128,0.277053406877,1.0024818052,0.584933406128,0.112845071027,-0.222755601465,-0.784600620387,-0.591216288388,-0.121670787923,-0.120994114664,0.248265886892],[-35324.9681767,-1864.62372473,-1643.28141321,-1548.51925175,-1592.51255912,569.10107248,1151.75604715,578.362654711,-907.577080525,-172.144505414,544.895812882,-380.424281569,-157.699565767,-208.41566915,508.461503247,-72.8944128365,-276.596808183,73.9975265094,-790.082412406,-235.787244596,155.346090632,-47.1803738523,28.0222425424,-748.128901807,33.6342151084,68.9471769761,-170.138371461,190.505041454,29.6025386505,248.076872503,-201.038336575,-187.461154311,-144.775947877,-200.196499818,344.272907988,9.40400905519,24.8081238405,44.0766530539,8.47943038559,-7.35580206169,-45.6031326308,-87.7230625657,-100.264283224,-38.1646152415,-69.8331099813,37.5444405984,-21.6599348899,-21.787159655,-1.43571807502,4.78700133694,0.939136682608,5.479714199,-16.2167903044,1.66368972159,-20.5261227139,6.90581940663,-39.2809483622,-28.2515333444,-4.22598181102,-9.18699656951,21.0638559329,7.95978924695,12.8239162146,1.0283760273,0.929164593387,-1.4025400129,2.44552654133,0.951240301202,5.79066907695,-3.3750194291,-0.895106409509,-7.75917976248,-9.62904176418,5.76728874456,-2.00309222434,10.624214734,-2.85302112204,-1.98085845574,-4.20838703717,-2.79781153634,0.331710872709,-0.847305292796,0.910891381929,0.769563122959,0.451753456491,-0.435176522451,-0.297953503126,-0.848334628184,-2.3102910283,-0.801941250267,-0.824210343923,-0.741409755983,0.870801734122,-0.349260460005,-0.718161208846,0.135746474927,-1.2495863092,0.248279502328,-0.620787887752,-0.0910741191038,-0.0878245651453,0.00697431598145,0.064698119558,-0.219451892307,0.132789550614,-0.0246831397201,0.524510148198,-0.356831874233,0.0428466734632,-0.159872551022,0.28179839522,1.00836584904,0.583773878389,0.121111381747,-0.221371553604,-0.783582607156,-0.59321843996,-0.112621080795,-0.118524225971,0.245863109221],[-35367.7391042,-1846.40355848,-1606.04189104,-1587.54714894,-1596.90247555,598.584756078,1126.05363486,610.163133618,-882.238707833,-175.694565728,567.171717901,-373.953176705,-178.991443713,-180.677510727,490.154960607,-68.6365942354,-272.530834334,64.8712063305,-781.117445716,-244.222309482,154.019431805,-49.1406036146,12.5217697746,-745.193985152,34.42477959,67.4756151177,-170.436953433,190.688454202,26.5392982941,245.303605607,-198.533436317,-190.822987021,-144.285256738,-193.566008479,343.546263426,9.26169082553,24.3581964551,43.3868769756,9.27371085618,-7.64097321294,-46.3911691286,-86.7084065275,-100.41926135,-38.6115780848,-68.0454100396,36.7962149887,-22.0978337065,-22.0759428345,-1.46501535938,4.62661836977,1.08128329517,5.39411091229,-16.2961032129,1.5465810626,-20.450852248,6.92546187569,-39.2691472267,-27.8249684844,-4.48075359396,-9.12980151895,21.0586013088,8.06809271917,13.1578637996,1.05556106366,0.903229803299,-1.34097601867,2.46068073691,0.919472412902,5.77956921423,-3.3743810793,-0.914075499888,-7.74529097709,-9.576080404,5.70412693137,-1.98137786378,10.6717725987,-2.81185881079,-1.83635293595,-4.20637664555,-2.83640943624,0.342569750057,-0.840847563231,0.92703826826,0.767420302912,0.431853410994,-0.424866484741,-0.313624081971,-0.875565829534,-2.29307020427,-0.797198181126,-0.8258566575,-0.713621379637,0.905739821279,-0.332842521513,-0.678890976341,0.142268469954,-1.26506903847,0.241688181135,-0.603387193298,-0.0840114114428,-0.0866768082207,0.0123393250823,0.0658316294689,-0.223728598089,0.133324437189,-0.0259517968863,0.512476564554,-0.355579902819,0.0444987268002,-0.159415983643,0.287183670295,1.01391342922,0.583367590931,0.130118861083,-0.219920673798,-0.781965008517,-0.595305121246,-0.103741399393,-0.11604006842,0.243238808485],[-35400.3776577,-1825.69520354,-1568.65957173,-1622.86805226,-1600.23132683,629.955463225,1099.57126513,637.539164858,-856.468557927,-179.085190617,590.213337893,-367.472906527,-200.61592809,-152.380133715,471.571691199,-64.8074539865,-268.455943361,56.0878759803,-772.651815446,-252.820871332,152.033134595,-51.7460792627,-2.42484927038,-741.935825658,35.2135296082,66.1166315664,-170.831597352,190.688779987,23.6239670225,242.208171612,-196.075254612,-194.151522521,-143.824692625,-186.824698984,342.726601934,9.1265224739,23.8509737914,42.6323801747,10.0168709224,-7.90674114977,-47.330164793,-85.7159147055,-100.636501019,-39.1340951995,-66.2026367673,36.0181434492,-22.5273970421,-22.3817538803,-1.49142057711,4.44365494307,1.19118759463,5.29679563967,-16.3928431345,1.37749170532,-20.3712579525,6.91592241893,-39.278053757,-27.3755655214,-4.76286618518,-9.0601401973,21.0459803592,8.16285157477,13.5044380998,1.08469329001,0.87472277347,-1.29046761998,2.47114249979,0.878526716178,5.75906941827,-3.36812987593,-0.945120388502,-7.73448273227,-9.52268415863,5.6333899979,-1.95431869601,10.7195004587,-2.7715128739,-1.68573711631,-4.20463232797,-2.87279545974,0.354114903238,-0.83502706365,0.942640703798,0.763602070524,0.409452196163,-0.416685401946,-0.329264506413,-0.907386705592,-2.27591588825,-0.792979090389,-0.829776828136,-0.682611975235,0.940018006435,-0.31551611697,-0.637437348552,0.148280613705,-1.27890641236,0.235441403905,-0.586152916433,-0.0770184380888,-0.0853146072755,0.0180461291741,0.0666570354533,-0.228892879822,0.133796974063,-0.027479409398,0.499449130066,-0.353644306995,0.0456816069177,-0.159403875923,0.293218678552,1.01912794353,0.583716158891,0.139972177676,-0.218397260698,-0.779585886493,-0.597440418308,-0.0950368103658,-0.113574349541,0.240400159583],[-35422.7977012,-1804.856001,-1531.5332856,-1654.57220656,-1602.21215076,662.933818166,1072.57549307,660.690871058,-830.663694968,-182.548962938,613.881971865,-361.282260673,-222.397068748,-123.960858678,452.875205785,-61.5165460696,-264.448573088,47.7056440088,-764.775316673,-261.5673486,149.474572295,-54.9973960323,-16.6254319028,-738.3297117,35.9833276439,64.8796285931,-171.300399003,190.476200864,20.8667795302,238.833127,-193.635166084,-197.398489221,-143.355000481,-179.993206604,341.826621066,9.00629699524,23.2852710049,41.8314398113,10.6986532224,-8.14763351319,-48.4106868115,-84.7451397446,-100.902817482,-39.7256415326,-64.3087788642,35.21286726,-22.9440797601,-22.7056011629,-1.51470635478,4.2394971341,1.27106373382,5.18795548907,-16.5063784259,1.15597564952,-20.2887115023,6.88047403736,-39.3050147933,-26.901499568,-5.06793349252,-8.97569443657,21.027475716,8.24424416995,13.8627701146,1.11553984382,0.844290785543,-1.25092149018,2.4769867428,0.828674164852,5.72813221138,-3.35612426966,-0.987698486938,-7.72658274245,-9.46867428363,5.55625968357,-1.92203550689,10.7673501828,-2.73226188349,-1.5294053714,-4.20333308079,-2.90636988015,0.366296182541,-0.829867260644,0.957477293552,0.758245682045,0.384890241017,-0.411045438905,-0.344919720626,-0.943881300815,-2.25904484713,-0.789265089769,-0.835752980321,-0.648357531294,0.973689991035,-0.297243744693,-0.593769929909,0.153920546886,-1.29080171816,0.229695434887,-0.569183559795,-0.070195445506,-0.0838028301938,0.0240185396648,0.0671970030279,-0.234943742338,0.134158407839,-0.0292873265547,0.485370913878,-0.351084050088,0.0464093580955,-0.159833308001,0.299859347801,1.02405660964,0.584792191923,0.150766529666,-0.216791862127,-0.776313662366,-0.599596339305,-0.0865146415725,-0.111168732508,0.237366128357],[-35434.1198255,-1786.11882538,-1494.19790552,-1682.5306293,-1602.47612305,697.641175467,1045.73576333,680.294025152,-805.25482749,-186.162309514,638.157307785,-355.553081123,-244.063539732,-95.9302070176,434.26590507,-58.8723327444,-260.55178021,39.7760844343,-757.529407614,-270.401144109,146.46201071,-58.8384266008,-29.8758551697,-734.356960278,36.7101952363,63.7691416498,-171.813907359,190.03083641,18.2858746921,235.23892705,-191.17344745,-200.523542615,-142.827374745,-173.099921743,340.865268548,8.9068501789,22.6594604339,41.0037735067,11.3119149191,-8.35945387105,-49.6184734635,-83.7905121242,-101.207075,-40.3723001263,-62.3721466454,34.3843240194,-23.3443088553,-23.0487562345,-1.53460643109,4.01581392127,1.32326521448,5.06696359553,-16.6360381901,0.883406967756,-20.2040337767,6.82241623244,-39.3454841125,-26.4031699312,-5.38998692217,-8.87470349212,21.005518031,8.31313183096,14.2318375864,1.14795225682,0.812500490474,-1.22202535039,2.47817397194,0.770211885712,5.68592287494,-3.33834949399,-1.04124615761,-7.72094007873,-9.41435598781,5.47480240661,-1.88495607002,10.8153861545,-2.69451792988,-1.36811032349,-4.20280632856,-2.93647060652,0.37905624736,-0.825321439161,0.971302131421,0.751484530562,0.358525095907,-0.408406028107,-0.360693677776,-0.985019207036,-2.24255759041,-0.786124428628,-0.843372923068,-0.611020760417,1.00683199864,-0.278043602625,-0.547955111062,0.159387519082,-1.30048866166,0.2246501063,-0.552607635206,-0.0636441998002,-0.0821922009369,0.0301672068191,0.0674743267547,-0.241860401389,0.134341557558,-0.0313968383022,0.470219040433,-0.34798396602,0.0466966425315,-0.160662982336,0.307024815358,1.0287885506,0.586552655601,0.1625684768,-0.215102898345,-0.772053855767,-0.60175320987,-0.078180719471,-0.108874280927,0.234176492254],[-35434.5125591,-1770.76946987,-1455.86115864,-1706.67033714,-1600.49726566,734.462189916,1020.28310118,697.501758752,-780.778142904,-189.915395874,663.077988642,-350.180083716,-265.317442346,-68.7914392869,415.965708307,-56.9579129912,-256.790463422,32.3503432591,-750.897282748,-279.234252019,143.144949052,-63.1617869899,-41.9645199171,-729.990562837,37.371954078,62.7823422162,-172.342305316,189.346044159,15.9014808601,231.508259751,-188.641930037,-203.493182302,-142.186300693,-166.180334834,339.863668993,8.83314424148,21.9715435399,40.1696559586,11.8508266183,-8.5410469018,-50.9337381406,-82.8431636688,-101.538793194,-41.0537631295,-60.404150568,33.5394299521,-23.7248883883,-23.410974571,-1.55057732713,3.77472564899,1.34995500885,4.93237695197,-16.7808482097,0.56256852662,-20.1174746506,6.74477655766,-39.3935125769,-25.8830909162,-5.72161553942,-8.75588737126,20.9837203314,8.37103285139,14.6102933197,1.18171350301,0.779860894877,-1.20320328109,2.47442081272,0.70342535374,5.63170577352,-3.31504789675,-1.10521150587,-7.71643626086,-9.36041302276,5.39203584894,-1.84370237868,10.8639803842,-2.65862634899,-1.20294854202,-4.20343439426,-2.96243115752,0.392314141909,-0.821262511388,0.983873854998,0.743447317603,0.3307369986,-0.409312860182,-0.376694702801,-1.03068381233,-2.22643278717,-0.783712964004,-0.852016741941,-0.570917097029,1.03960983548,-0.257978900789,-0.500124721499,0.164910079421,-1.30774403386,0.220535581503,-0.536570480498,-0.0574671350716,-0.0805243525194,0.0364012332948,0.0675087730898,-0.249594155592,0.134263969317,-0.0338222802254,0.453992043605,-0.344439155881,0.0465445062062,-0.161804774948,0.314608344533,1.03346130908,0.588948830305,0.17541302933,-0.21332675946,-0.766750110613,-0.603893361386,-0.0700401591797,-0.10675029592,0.230885403916],[-35426.1665947,-1758.71954404,-1415.31413986,-1727.0068822,-1595.82653457,773.591903512,997.768346956,713.346421888,-757.729686371,-193.76664391,688.673702133,-344.783922437,-285.973383815,-42.9695895731,398.160059041,-55.8064660223,-253.160168218,25.4673999815,-744.813048476,-287.984166231,139.682110309,-67.824905948,-52.6764386284,-725.191313211,37.9538898537,61.9151852387,-172.852629102,188.424668711,13.7353676462,227.742055425,-185.994261864,-206.267339654,-141.380065292,-159.273914982,338.838827593,8.78765388406,21.2221549728,39.3489313422,12.3112892474,-8.69161489651,-52.3317920626,-81.8926048609,-101.885506061,-41.7450744774,-58.4171407368,32.6887231406,-24.0812441084,-23.7887854123,-1.56245297525,3.51890843105,1.35320443694,4.78209868289,-16.9387995221,0.197293901996,-20.0284669703,6.65085092184,-39.4421368819,-25.3449302898,-6.0545693089,-8.61834617757,20.9663860512,8.41959469031,14.9962182246,1.2163960412,0.746736610282,-1.1938019562,2.46529167704,0.628772155031,5.56475969199,-3.2865323972,-1.1790071393,-7.71155175908,-9.30755612611,5.31163346617,-1.79888409768,10.9139039097,-2.62475855169,-1.03522873661,-4.20547980462,-2.98357477414,0.405932467318,-0.817533349228,0.994933432308,0.734244437003,0.301879871305,-0.414356474387,-0.392973897002,-1.08069410013,-2.21051392926,-0.782221624152,-0.86088872371,-0.528492052804,1.0722960014,-0.237160324777,-0.450457116302,0.170701632419,-1.31236460021,0.217578137375,-0.521217093753,-0.0517521577582,-0.0788361146216,0.0426304281805,0.067321662026,-0.258077465603,0.133829468124,-0.0365676543349,0.436694580604,-0.340548147567,0.0459340531812,-0.163124638215,0.322484385487,1.03825170685,0.591934356199,0.189308550953,-0.211451108579,-0.760383120006,-0.605988564315,-0.0621091150095,-0.104859095701,0.227552066586],[-35411.9894487,-1748.32815856,-1371.6825905,-1743.55343431,-1588.19866613,814.99210498,979.313738975,728.420613776,-736.459885596,-197.653475324,714.931051272,-338.917873077,-306.048392473,-18.8590601002,381.01521848,-55.4182148794,-249.612304265,19.1401874077,-739.189061792,-296.583948354,136.205629251,-72.6677802429,-61.8272448272,-719.936899098,38.4443849983,61.1621070846,-173.296671423,187.278582515,11.8057716325,224.03571155,-183.197875822,-208.810164415,-140.373865569,-152.419951584,337.801714798,8.76835896856,20.4167051909,38.5598643859,12.6943516654,-8.81125151299,-53.786454643,-80.9289843957,-102.233988888,-42.4187910522,-56.4237384394,31.8433390192,-24.407950221,-24.1785973295,-1.57019290292,3.25136785161,1.33541774132,4.61377341324,-17.1068646989,-0.207394459581,-19.9356384947,6.54361549869,-39.483590049,-24.7932104327,-6.38124935244,-8.46151002052,20.95683827,8.46026061104,15.3871426601,1.25152151744,0.713122399141,-1.19310486434,2.45035354375,0.547047342323,5.4845429179,-3.25316582808,-1.26200873396,-7.70444241492,-9.25637122205,5.23721543763,-1.75098767455,10.9656847122,-2.59290146246,-0.86638741259,-4.2088966317,-2.99923687946,0.419687657125,-0.81399371528,1.00419315534,0.723948445961,0.272264366785,-0.424032822111,-0.409522999896,-1.13474922712,-2.19449081976,-0.781832992336,-0.869125430763,-0.484296992138,1.10517058536,-0.215694018045,-0.399198833362,0.177030642075,-1.31419571722,0.215960593679,-0.506679120851,-0.0465634171792,-0.0771560941489,0.0487588657462,0.0669268784973,-0.26720401172,0.132930427483,-0.0396184270516,0.418338847923,-0.336414429991,0.0448316938007,-0.164447420497,0.330514631762,1.04333550321,0.595483439666,0.204208735702,-0.209438173928,-0.752974553251,-0.60800023346,-0.0544067872116,-0.103246823622,0.224240747644],[-35395.3061106,-1737.27379467,-1323.92395014,-1756.24863048,-1577.51839282,858.085665719,965.188836355,742.784779532,-717.09998353,-201.536285316,741.731869292,-332.226175737,-325.639456972,3.24203496662,364.69135658,-55.7745289408,-246.073529312,13.3664580197,-733.925546621,-304.996325731,132.795801403,-77.538483132,-69.2977902982,-714.236378351,38.8343665646,60.5271048153,-173.618907213,185.926433686,10.119508082,220.471408995,-180.232659527,-211.08790825,-139.15563833,-145.656522902,336.751418333,8.77039594983,19.5660041702,37.819626873,13.005387952,-8.90033956204,-55.2699978638,-79.9448557967,-102.572469571,-43.0503728887,-54.4384726888,31.0138698291,-24.6984914522,-24.5766120649,-1.57423439602,2.97518582958,1.29998726861,4.4256875802,-17.2815976458,-0.645564424536,-19.8375356336,6.42589695455,-39.50974926,-24.2327125353,-6.69543461213,-8.28516022867,20.9560278779,8.4938484559,15.7798359449,1.28650223226,0.678782359859,-1.20045504517,2.4292852242,0.459378909362,5.3908476176,-3.21511099274,-1.35323611517,-7.6930630244,-9.2072773965,5.17174455541,-1.70055117248,11.019406425,-2.56280995508,-0.69788399736,-4.21315838168,-3.00883985215,0.433303849711,-0.810599276687,1.01135579518,0.712578254582,0.242230353816,-0.43869154565,-0.426235933487,-1.19241147143,-2.17796741407,-0.782681792354,-0.875879110924,-0.438914795235,1.13844426409,-0.193638125193,-0.346732619777,0.184194017854,-1.31316046452,0.215778490042,-0.493041448055,-0.0419427933694,-0.0755236068302,0.0546850123371,0.0663344528056,-0.276835761896,0.13144595536,-0.0429432000951,0.398957695984,-0.332117310306,0.0432193413035,-0.165571251525,0.338559901117,1.04885544871,0.599579626419,0.220010536387,-0.207209544161,-0.744577479839,-0.609867004567,-0.0469596858503,-0.10193519785,0.221009432318],[-35379.5349159,-1725.36548375,-1271.8486726,-1765.13085376,-1564.19089768,902.092540286,955.408000007,756.482386867,-699.683343852,-205.347675188,768.879900517,-324.464077427,-344.922421579,22.9632245518,349.248166733,-56.8132130178,-242.419788151,8.13685582314,-728.922128038,-313.197404517,129.498560495,-82.3150108473,-75.0171594251,-708.123078413,39.1235235461,60.025226797,-173.762412245,184.395675627,8.67333555889,217.120029706,-177.092281384,-213.081765611,-137.72633734,-139.025691697,335.677367465,8.78644445819,18.6848366944,37.1442884367,13.2538263236,-8.96102926478,-56.7527743046,-78.9353222039,-102.891212611,-43.6210587283,-52.4775297132,30.2062253281,-24.9471273132,-24.9791086466,-1.57573832084,2.69344232724,1.25080955369,4.2177246034,-17.4590153475,-1.11019128563,-19.7323241207,6.30010378528,-39.5136041844,-23.6691271545,-6.9921328292,-8.08954585661,20.9638825529,8.52136631063,16.1702944588,1.32054013837,0.643192336573,-1.21514602253,2.40192085479,0.367239411043,5.28379032566,-3.17244404581,-1.45143480155,-7.67547501357,-9.16060545835,5.11758378582,-1.64815855173,11.0745949442,-2.53416676934,-0.531500272609,-4.21771085049,-3.01193642686,0.446484333152,-0.807432753673,1.01613910304,0.700092025889,0.212129619315,-0.458561191964,-0.442886876305,-1.25308570378,-2.16046757488,-0.784803334155,-0.880362365586,-0.392913816148,1.17218046629,-0.171026993611,-0.293546837698,0.192469460712,-1.30924170803,0.217111852075,-0.48038301865,-0.0378988139717,-0.0739965277088,0.0602969122541,0.0655248602402,-0.286822128767,0.129255183849,-0.0464779216056,0.378626651533,-0.327683502359,0.0411083733428,-0.166291044601,0.34649055156,1.05490052196,0.604189877524,0.236559728659,-0.204679741668,-0.735273449829,-0.611512839788,-0.0397981943093,-0.100941451073,0.217910586847],[-35368.0195505,-1714.51318097,-1216.65896971,-1770.38481006,-1548.89568944,946.247546732,949.952947597,769.624403523,-684.226189858,-208.897787503,796.096799904,-315.451300233,-364.124324542,39.7975881831,334.615193641,-58.4358604745,-238.483224677,3.44900530396,-724.096490456,-321.186041086,126.316909854,-86.9381495877,-78.9640642942,-701.646463292,39.3180813879,59.6782623473,-173.671563733,182.721239117,7.44862882828,214.035575516,-173.788924658,-214.793208134,-136.096685928,-132.568893476,334.561352158,8.80644991543,17.790089516,36.5483630254,13.4523713228,-9.00028474201,-58.2040721573,-77.8996106692,-103.182323319,-44.1187666245,-50.5580160121,29.4217918599,-25.1502698899,-25.3820754477,-1.57643760851,2.40912237974,1.19190302835,3.99159121033,-17.634341995,-1.59339336201,-19.6184454415,6.16791744345,-39.4902904563,-23.1088520762,-7.26745224113,-7.87526691774,20.9798042249,8.54425650295,16.5536840805,1.35252910145,0.605526262755,-1.23633662312,2.36828450631,0.272400616071,5.16388810552,-3.12541395227,-1.5551134082,-7.65000230223,-9.11647793036,5.07656801122,-1.59434085793,11.1301416472,-2.50660691404,-0.369365177021,-4.22215869379,-3.00813306697,0.458924902604,-0.804684684181,1.01827461317,0.686402106498,0.182354141499,-0.483745392711,-0.459145295103,-1.31598355782,-2.14144269593,-0.788090757448,-0.881885509601,-0.346800708193,1.20627556994,-0.147904668465,-0.240218950428,0.202065923082,-1.30247591144,0.220032289488,-0.468779639498,-0.0344052288641,-0.0726495348894,0.0654649234054,0.0644337520512,-0.296993698507,0.126257458506,-0.0501153572817,0.357462005124,-0.323080104566,0.0385458779954,-0.16641992704,0.35420724411,1.06148573796,0.609263393664,0.253644599226,-0.201775114827,-0.725158968755,-0.612850930874,-0.0329462064537,-0.100282181005,0.214986311083],[-35363.6890905,-1707.16080175,-1160.00983831,-1772.21538941,-1532.6169889,989.705863202,948.198055439,782.093648022,-670.696291265,-211.9452369,822.996343458,-305.094510247,-383.434016778,53.2826196084,320.664054708,-60.5403978904,-234.085604162,-0.685664074961,-719.400446689,-328.981811693,123.211863238,-91.3954501542,-81.1741289934,-694.880104876,39.4258583891,59.5133215523,-173.291531815,180.940515796,6.41635628032,211.254971449,-170.353524143,-216.231609848,-134.29951923,-126.325785212,333.376412285,8.81827876307,16.9008505442,36.0457950308,13.6156988181,-9.02871088054,-59.5930957898,-76.84161285,-103.440490367,-44.5376549699,-48.6985332995,28.660653067,-25.3043683138,-25.7805255176,-1.57801652787,2.12515442113,1.12759422586,3.75035757102,-17.8025877019,-2.08717952405,-19.4946966492,6.03047970219,-39.4367435642,-22.5583479253,-7.51883433261,-7.64293590305,21.0018382581,8.56363460222,16.9244942216,1.38124630623,0.564766771574,-1.2632035706,2.32853493028,0.176758324519,5.03206379507,-3.07425161422,-1.66258057116,-7.61520609303,-9.07479530979,5.0498525473,-1.53937127148,11.1844901077,-2.47959498638,-0.213676073517,-4.22599167089,-2.99705437544,0.470335479179,-0.802649654857,1.01751491467,0.6714038278,0.153327204081,-0.514247424777,-0.474583003225,-1.38017906861,-2.12033523442,-0.792324138203,-0.879872059837,-0.300985768122,1.24049113128,-0.124300944703,-0.187421967227,0.213121959667,-1.29292387711,0.224550830719,-0.458278528102,-0.0314171043332,-0.0715635059879,0.0700392717866,0.062972821414,-0.307165697363,0.122367371836,-0.0537227429739,0.335611482504,-0.318224514346,0.0356009618415,-0.165794267613,0.361646377156,1.06856601367,0.614756240621,0.271010259614,-0.198420931847,-0.714334489493,-0.613782438892,-0.0264295871393,-0.0999623363522,0.212265320698],[-35368.2008336,-1704.3661508,-1104.15722382,-1771.03922967,-1516.07170418,1031.77655407,949.454044835,793.560576547,-659.103725702,-214.213740285,849.070297625,-293.385908814,-403.107894475,62.8986698657,307.29945479,-63.0630819338,-229.06576887,-4.28926730129,-714.789061861,-336.628252203,120.141560138,-95.6827058748,-81.6858358423,-687.932980925,39.4558960124,59.5515203696,-172.574791525,179.094758305,5.54429102119,208.798735817,-166.826126434,-217.411536102,-132.3791781,-120.343024142,332.092588825,8.81000340267,16.0344924425,35.6495741356,13.7583943945,-9.05830115331,-60.890944594,-75.7699655387,-103.660866698,-44.8765745155,-46.9179601278,27.917563945,-25.404595134,-26.1712338549,-1.58158739237,1.84397800806,1.06283030753,3.49763983159,-17.9592512372,-2.58375318242,-19.3603254297,5.88904047225,-39.3508389069,-22.0234958672,-7.74515864597,-7.39248316365,21.0276733541,8.58064029391,17.2772333589,1.40570247132,0.519925619397,-1.29489609162,2.28281122757,0.0823625367885,4.8894576626,-3.01906780544,-1.77208074098,-7.56990971788,-9.0352107251,5.03781035005,-1.48320232443,11.2357166363,-2.45254369878,-0.0667246219863,-4.22869789009,-2.97838206063,0.480476765538,-0.801685424773,1.01370528017,0.654956006154,0.125509341714,-0.550004713272,-0.488745767241,-1.4447056897,-2.09667348566,-0.797145470641,-0.873888478891,-0.255749085149,1.27446747703,-0.100139860065,-0.135829518271,0.225811177916,-1.28061446666,0.230682970461,-0.44893741984,-0.028885819325,-0.0708055328153,0.0738667459168,0.0610470948929,-0.317147457267,0.117500746807,-0.0571621460751,0.313243486054,-0.313014669882,0.0323636867852,-0.16427403061,0.368765643663,1.07605450337,0.620651246777,0.288406451843,-0.194542467184,-0.702891153785,-0.614215402522,-0.0202759714042,-0.0999869390077,0.209785280678],[-35381.6716239,-1705.19960648,-1051.10898721,-1767.2376943,-1499.45741658,1071.83003137,953.09649593,803.355893279,-649.480221299,-215.328328832,873.825285357,-280.187795409,-423.470239223,68.2435855387,294.38597939,-65.965853742,-223.275991839,-7.39958536704,-710.187287152,-344.1813123,117.054732054,-99.8060088202,-80.547868157,-680.911890669,39.4153366155,59.8007470719,-171.481519297,177.227882554,4.7978334574,206.679195538,-163.252271171,-218.344254521,-130.386772679,-114.660799956,330.672171599,8.77000430202,15.2045170078,35.3697325016,13.8944497154,-9.10102768461,-62.0715987982,-74.6951309955,-103.837878623,-45.1360136683,-45.2313647105,27.1862475144,-25.4453438025,-26.5502678874,-1.58795008211,1.56727455957,1.00269046734,3.23662051108,-18.0998535541,-3.07587627433,-19.2148604647,5.74466639343,-39.2312609846,-21.5087533901,-7.94661931637,-7.12362103051,21.0547332972,8.5961415756,17.6067367854,1.42509107452,0.470002272933,-1.33042306758,2.23121670623,-0.00868997118722,4.73727900966,-2.95995686484,-1.88193624189,-7.51324312608,-8.99694926316,5.04026084891,-1.42545927098,11.281892913,-2.42470413961,0.0694855218177,-4.22968872223,-2.95185847945,0.489152795751,-0.802128630385,1.00677037912,0.636894591933,0.099348459613,-0.590850098563,-0.501183341902,-1.50861223636,-2.07004199629,-0.802107788012,-0.863665131567,-0.211255889936,1.30780378952,-0.0753274846295,-0.0860282716186,0.240257697545,-1.26555981437,0.238404179406,-0.44078534831,-0.0267492384526,-0.0704235414324,0.0768157409672,0.058560231815,-0.326746551074,0.111594522237,-0.0602942981284,0.290521902239,-0.307350546759,0.0289307612735,-0.161756065094,0.375548467149,1.08382391732,0.626950447851,0.305596271827,-0.190063563701,-0.690906744649,-0.614062412686,-0.014511419873,-0.100358567623,0.207575896449],[-35401.9032693,-1708.32314052,-1002.14747777,-1761.09938955,-1482.44903518,1109.18238112,958.876799862,810.7251435,-641.877370659,-214.673023241,896.892599456,-265.24996958,-444.747905298,69.0174168453,281.609574595,-69.2315056744,-216.566003078,-10.0358502553,-705.507507088,-351.700253361,113.858367254,-103.802439235,-77.8290461433,-673.872813843,39.3084657145,60.2607018227,-169.979685232,175.368809929,4.13763185002,204.895583603,-159.672243809,-219.03398283,-128.363063166,-109.300430303,329.06312109,8.68801956634,14.4183851073,35.2134990181,14.035188611,-9.1678670881,-63.1134212893,-73.6237204278,-103.967306063,-45.3168992782,-43.6480110954,26.4602966462,-25.4223051962,-26.9102721349,-1.59839272787,1.29602747336,0.952217837822,2.97048881903,-18.2197104657,-3.55752111255,-19.0581578804,5.5979405464,-39.0775519692,-21.0169262585,-8.12375429845,-6.83657003322,21.0804115174,8.61120330222,17.908225697,1.43861880145,0.414288299025,-1.36871192494,2.17415422195,-0.0943440945919,4.57669593032,-2.89704156282,-1.99067934708,-7.44472432959,-8.95901180237,5.05680284703,-1.36561828404,11.3212750936,-2.39500106478,0.193385601245,-4.22843666566,-2.91723014128,0.496227090616,-0.804233955285,0.99668421354,0.617097757349,0.075270172221,-0.636498544878,-0.511547803554,-1.57101867774,-2.04006666861,-0.806783918398,-0.849034106748,-0.167527167136,1.34003753254,-0.0497724733211,-0.0385426478141,0.256427659004,-1.24775564395,0.247669397659,-0.433772267857,-0.0249314725434,-0.070457266943,0.0787756158433,0.0554285827207,-0.335792748772,0.104628442551,-0.0629895480149,0.267597491825,-0.301124074892,0.0253984961466,-0.158189040703,0.38200794623,1.09169873556,0.633641628557,0.322361855623,-0.184917401513,-0.6784315011,-0.613218114305,-0.009148144947,-0.10108797762,0.205636193867],[-35426.1106314,-1712.64327725,-957.477196589,-1753.03412707,-1464.55747631,1143.44729172,966.766334408,814.963844235,-636.333593339,-211.616495899,918.060104202,-248.425367125,-467.115372632,64.9628911777,268.587724021,-72.8447923468,-208.817198883,-12.2066665803,-700.678203683,-359.253947536,110.432509817,-107.725030078,-73.6079530664,-666.840897688,39.1436998511,60.9285638792,-168.047901179,173.528177465,3.52187158463,203.424681899,-156.119949695,-219.485063756,-126.332040085,-104.268769302,327.212956773,8.55681945676,13.6808830271,35.1845650231,14.1883887681,-9.26792786431,-64.0026602935,-72.560717978,-104.047047154,-45.4200184892,-42.1716646012,25.7329329867,-25.3318437362,-27.2424067889,-1.61463461378,1.03138067048,0.915915408183,2.70253912548,-18.3142650106,-4.02438937547,-18.8909782878,5.44881298863,-38.889160985,-20.5490576022,-8.27692978657,-6.53142870095,21.1025763903,8.62720940913,18.1779768477,1.4454117769,0.352537404411,-1.40879211652,2.11233197346,-0.172681313546,4.40881463413,-2.83051225336,-2.09715988025,-7.36410183417,-8.92019337065,5.08679110107,-1.30308707141,11.3522933573,-2.36228136495,0.303915323496,-4.22452513468,-2.87428478313,0.50157007873,-0.808181982159,0.983453717708,0.595522535881,0.0536677273281,-0.686525483171,-0.51961068425,-1.6311640413,-2.00646156587,-0.81076513412,-0.829906401131,-0.124454188266,1.37068326336,-0.0233676224194,0.00622111369957,0.274209776237,-1.22718088214,0.258412353068,-0.427785206513,-0.0233645204562,-0.0709460647037,0.0796558492169,0.0515986966957,-0.344145366488,0.0966358293963,-0.0651417932007,0.24460914556,-0.294238766202,0.0218633810991,-0.153555538164,0.388172411593,1.09947395506,0.640687667991,0.338522618975,-0.17905529523,-0.66548006768,-0.611583549424,-0.0041749481063,-0.102191735725,0.20395172021],[-35452.9732454,-1717.46740374,-915.118105373,-1743.57963098,-1445.75148038,1174.64161284,976.491589616,815.652490089,-632.816620968,-205.83195978,937.186182723,-229.709780736,-490.679142441,55.9012496,254.946203606,-76.7377960013,-199.961393251,-13.9277208663,-695.671212868,-366.910888847,106.606770462,-111.62378774,-67.9934893481,-659.789918121,38.9493846823,61.8049032879,-165.679584557,171.694498661,2.90383394933,202.21591494,-152.624648246,-219.706748543,-124.304785218,-99.5646945132,325.07017996,8.3745100973,13.0003651465,35.2832241621,14.3584521612,-9.40894412633,-64.7330561657,-71.5133560676,-104.078702747,-45.4470910471,-40.8035759654,25.0001342157,-25.1703525687,-27.5355444936,-1.63873491901,0.776233046405,0.897803426422,2.43704344837,-18.3792694387,-4.47380099216,-18.714993446,5.29572054619,-38.6654956222,-20.1053083201,-8.4060367331,-6.20861223369,21.1193540326,8.64492401577,18.4131167219,1.44427390468,0.285082958645,-1.449732507,2.04692996155,-0.241868844731,4.23477918019,-2.76063663554,-2.20049785075,-7.27147320107,-8.87933462867,5.12924065858,-1.23738247217,11.3736720784,-2.32537528233,0.400523906932,-4.21748931722,-2.82289551832,0.504965946187,-0.814100795628,0.967113024396,0.572293779819,0.0349255439669,-0.740296474038,-0.525175875446,-1.68840719622,-1.96906662848,-0.813691081917,-0.80624656908,-0.0818234967771,1.39935004251,0.00401144880911,0.0479573482156,0.293387889094,-1.20380971213,0.270511351575,-0.422647324961,-0.0220023632096,-0.0719546704384,0.0793914133932,0.0470552954696,-0.351685751206,0.0877152294863,-0.0666614042294,0.221696392377,-0.286605859718,0.0184200094483,-0.147854053972,0.394075795878,1.10693093237,0.648026770278,0.353927238117,-0.172455094869,-0.652047183429,-0.609065701366,0.000423374419835,-0.103686206641,0.202485525846],[-35482.8801555,-1723.75807803,-872.504237227,-1733.50307879,-1426.73716204,1202.96876088,987.946371513,812.865249599,-631.190509496,-197.325895365,954.138039495,-209.304207969,-515.505844053,41.6439299165,240.410712959,-80.7504424227,-190.002512264,-15.2431940246,-690.535703942,-374.725429895,102.195882752,-115.526659305,-61.07987574,-652.67569248,38.7791626838,62.8886444176,-162.882547653,169.834394258,2.23315831153,201.2012316,-149.211636833,-219.710568413,-122.274954244,-95.1813546609,322.597454427,8.14456680604,12.3910903876,35.5073352489,14.5455589922,-9.59876073461,-65.3069186246,-70.4895608896,-104.064923963,-45.3999551249,-39.5429220764,24.2587964222,-24.9373174103,-27.7788367788,-1.67299145312,0.53620661577,0.901400846346,2.17887131829,-18.4108309068,-4.90421555631,-18.5323531944,5.13638464881,-38.4069421159,-19.685875847,-8.51065103461,-5.86908615384,21.1302272278,8.6654944831,18.6119930953,1.43366706227,0.212915177268,-1.49053196431,1.97976822956,-0.300138267089,4.05588542333,-2.68783469306,-2.30015583611,-7.16735933567,-8.83546635407,5.1830600264,-1.16824346827,11.384528242,-2.28330891769,0.483016599706,-4.20711610975,-2.76294813517,0.506078903232,-0.822049815518,0.947733292606,0.547777821282,0.0193759588415,-0.79699779452,-0.528068302979,-1.74222226895,-1.92780978709,-0.815277006452,-0.778157695809,-0.0394297973036,1.42571326233,0.0325207777326,0.0864963202421,0.313731742664,-1.17761707117,0.2838367341,-0.41818919912,-0.0208227108248,-0.0735731798567,0.0779327656203,0.0418265509472,-0.358324669466,0.078034466842,-0.0674673209562,0.199008944979,-0.278147019536,0.0151447743125,-0.141115903904,0.39974830326,1.11386144578,0.655611269967,0.368456501901,-0.165119127199,-0.638120018889,-0.605606664386,0.00467894164806,-0.105591548615,0.201202527485],[-35518.0777736,-1733.79187514,-827.651920036,-1723.71949423,-1408.97917159,1228.43161696,1000.73418996,806.671066858,-631.168291847,-186.383954381,968.77823965,-187.640396375,-541.674546797,22.137658782,224.712306539,-84.6557353209,-179.012928558,-16.2030416331,-685.383330047,-382.759112806,97.0207135689,-119.462349089,-52.960712272,-645.460206406,38.7072759057,64.1808725216,-159.674407313,167.896869853,1.45876815781,200.301773483,-145.906981871,-219.504254136,-120.236388754,-91.1022385874,319.766851212,7.87525232183,11.8718788644,35.8529660939,14.7462851144,-9.84424487882,-65.7333053426,-69.4985643205,-104.009375818,-45.2833993634,-38.3858466219,23.5078131516,-24.6327102804,-27.9618263284,-1.71964532244,0.31899169988,0.929901667952,1.93315858564,-18.4055690339,-5.31565422067,-18.3457721753,4.96827182992,-38.114894578,-19.2905769419,-8.59047596762,-5.51385092242,21.1348635544,8.69013281272,18.7741362107,1.41196565886,0.13763439192,-1.5303355434,1.91308149941,-0.345819933936,3.87344441774,-2.6124736916,-2.39586388392,-7.05262549189,-8.78784262941,5.24680114898,-1.0954090405,11.3842574022,-2.23511306281,0.551633348678,-4.19320925292,-2.69439039321,0.504519797169,-0.832048909551,0.925414528635,0.522493444269,0.00731178035839,-0.855705970505,-0.528138074241,-1.79220013565,-1.88270651845,-0.815318829454,-0.745896658652,0.00298335232281,1.44946876711,0.0623713274404,0.121745858063,0.33500699111,-1.14857273691,0.298210668343,-0.414205023092,-0.0198261611531,-0.0758981309551,0.0752440858813,0.0359847211971,-0.363997795273,0.0678073267048,-0.0674889550223,0.176702437848,-0.268782784087,0.0120988986519,-0.133407691558,0.405220760317,1.12005811903,0.663415934594,0.382008134951,-0.15704905267,-0.623674164683,-0.601174653335,0.00863900243819,-0.107925954145,0.200064856991],[-35561.0250741,-1748.64729065,-778.677612552,-1715.4170107,-1393.85269742,1250.94898746,1014.27110129,797.271300658,-632.504636192,-173.383777974,980.994183983,-165.126246987,-569.046925475,-2.42261804689,207.623523499,-88.2576369595,-167.139859248,-16.8676663289,-680.322217632,-391.045019077,90.9493095978,-123.424625851,-43.7479658705,-638.087720954,38.8146675708,65.6639254415,-156.087086746,165.828211409,0.532941066131,199.447075889,-142.720972404,-219.089212557,-118.178802801,-87.3025438597,316.556897249,7.58052770339,11.4579180733,36.3121667371,14.9536396957,-10.1535606836,-66.0221912705,-68.5480616791,-103.916265625,-45.1003523836,-37.3284338955,22.7496844584,-24.2569629191,-28.0745388649,-1.77939220673,0.132409382282,0.986081410339,1.70369236213,-18.3621733174,-5.70896664592,-18.1589848711,4.78952035389,-37.7908392524,-18.9195189865,-8.64492660772,-5.14482044424,21.1324814277,8.71979952291,18.8999834641,1.37796198265,0.0614435421015,-1.56844980357,1.84887629907,-0.377684269964,3.68865522438,-2.53528287975,-2.48732356416,-6.92832301875,-8.73613581743,5.31894808888,-1.01893654928,11.3725271045,-2.17983172893,0.607036001696,-4.17553764561,-2.61731543055,0.499930814947,-0.843942537668,0.900316567595,0.496942674326,-0.0010415628587,-0.915513303794,-0.525396099245,-1.83800440241,-1.83390199547,-0.81368522028,-0.709763773227,0.0455876678424,1.47037318609,0.0937321850667,0.153642929882,0.356941081887,-1.11669930316,0.313391134511,-0.410442638475,-0.0190384549203,-0.0789781249191,0.0713128752591,0.0296368265318,-0.368643812967,0.0572454214932,-0.066689013177,0.154930110967,-0.258464501174,0.00934617293698,-0.124813798463,0.410510070137,1.12533441466,0.671409841666,0.394496270526,-0.1482480133,-0.608698609966,-0.595753121513,0.012348172199,-0.110700254666,0.199025433007],[-35612.7265178,-1766.66577565,-723.260233525,-1709.81833433,-1381.8403693,1270.39329202,1028.00183004,785.111483392,-635.103451059,-158.63385233,990.669646808,-142.000225864,-597.239509791,-31.6065909077,189.102552445,-91.4337407857,-154.587927056,-17.3203545742,-675.408561951,-399.555700506,83.9088783304,-127.317922952,-33.5665864691,-630.474420743,39.1743831904,67.2932531124,-152.173342126,163.590084392,-0.579580683286,198.590336312,-139.629910936,-218.459668187,-116.076336008,-83.7592494978,312.951102528,7.27850076206,11.1551596986,36.8727582472,15.1580590445,-10.535678702,-66.1811517675,-67.6398361307,-103.788304896,-44.8474096989,-36.3693103436,21.9893015204,-23.812896671,-28.1091040384,-1.85066918267,-0.0172469674615,1.0722785838,1.49206764163,-18.2821437428,-6.08496098414,-17.9759171018,4.5996487691,-37.4351533367,-18.5739689704,-8.67342860059,-4.76562340563,21.121883071,8.75497070176,18.9907432031,1.3312360047,-0.0130131291398,-1.60418875806,1.78849838389,-0.395246123539,3.5026829864,-2.45757379513,-2.57399756913,-6.79544006763,-8.68062069362,5.39818222542,-0.939647177103,11.3494049021,-2.11675310612,0.650194506822,-4.15385354598,-2.53208278395,0.492054703095,-0.85731002257,0.872717619309,0.471519012309,-0.00555919730372,-0.97560097894,-0.520132511546,-1.87934159439,-1.78170713597,-0.810333992136,-0.670050425479,0.0882829476944,1.48830112598,0.126634950674,0.182178762496,0.379229741567,-1.08212782088,0.329111007641,-0.406666739192,-0.0185126658118,-0.0827780044519,0.0661622595011,0.0229175269731,-0.372191196295,0.0465285977184,-0.0650937146375,0.133845453678,-0.247211358533,0.00696063439879,-0.115420609064,0.415573921261,1.12955385354,0.679530112145,0.405856624246,-0.138731000152,-0.593228544727,-0.589342687656,0.0158272578572,-0.113914160808,0.198033459673],[-35673.994318,-1785.09319448,-660.85460631,-1708.37195595,-1372.82214288,1286.45082716,1041.79491918,771.001134114,-639.094503315,-142.404060267,997.617478298,-118.471601718,-625.74810485,-64.9026177425,169.348357127,-94.1048888654,-141.627097865,-17.6573442149,-670.658011686,-408.218159079,75.9015965214,-130.965656084,-22.5411386684,-622.56739023,39.8496191194,68.9984031148,-148.00476694,161.163927297,-1.90941315236,197.707481361,-136.586823554,-217.611647471,-113.890974162,-80.4516482913,308.944336171,6.98995631431,10.9618013298,37.5196587319,15.3484767992,-11.0035913512,-66.2146214414,-66.7702327771,-103.627350336,-44.5190639973,-35.5103350447,21.2283466371,-23.3080473264,-28.0622606336,-1.92929163134,-0.125049974649,1.19011340123,1.29823415373,-18.1693188592,-6.44383793875,-17.8005462291,4.39924725165,-37.0482435067,-18.2570888677,-8.67598092759,-4.38091326086,21.1017968755,8.79672544173,19.0482007181,1.27216496487,-0.0829239500888,-1.63677790767,1.73268809123,-0.398813722733,3.31684432762,-2.38130918407,-2.65517622244,-6.65490094458,-8.62221061347,5.48325606604,-0.859095162226,11.3151430731,-2.0456304575,0.68206672944,-4.12804250001,-2.43923023742,0.480770275492,-0.8714902146,0.843013097335,0.446530799049,-0.0062256242291,-1.03527600827,-0.512863541255,-1.91593958344,-1.72654038785,-0.805347535464,-0.627090613754,0.130708365841,1.50318756367,0.161060973086,0.207331722494,0.401667315475,-1.04514954091,0.34513854384,-0.40271702499,-0.0183163813132,-0.0871792831391,0.0598483984698,0.0159664252493,-0.374557077876,0.0358011421503,-0.0627850442315,0.113604713226,-0.235094541591,0.0050104324286,-0.105319992512,0.420322418861,1.13263490879,0.687697862101,0.416018619638,-0.128519590737,-0.577361964971,-0.581963829576,0.0190963833784,-0.117555155258,0.197056395484],[-35745.0228853,-1798.86335314,-591.427082897,-1712.45974585,-1365.99772115,1299.10652401,1056.05634644,756.538148816,-644.909974741,-124.887083876,1001.6273579,-94.513420933,-653.843884549,-101.704705452,148.744023306,-96.2630200491,-128.580591268,-18.0014393235,-666.030323072,-416.911357926,66.9944213935,-134.088650068,-10.8061305873,-614.299878292,40.8907891131,70.6782695503,-143.681982544,158.548794684,-3.47797442651,196.79798351,-133.513772031,-216.553107833,-111.569489493,-77.367011628,304.538690617,6.73702464498,10.8644019471,38.233069724,15.5106804084,-11.5767966456,-66.1230706274,-65.9301746743,-103.437446868,-44.1038685561,-34.7568046794,20.4683000033,-22.7535076826,-27.9340875615,-2.0084390043,-0.187854277983,1.33990519864,1.11994667523,-18.0304730006,-6.78528795693,-17.636824877,4.18946353866,-36.6296771582,-17.9742127271,-8.65245822385,-3.99709030267,21.071169287,8.84617127031,19.0747171275,1.20196042575,-0.145305124686,-1.66529926263,1.68135034719,-0.389698758704,3.13257271888,-2.30918874466,-2.73007174932,-6.50747148146,-8.56257729565,5.57336390963,-0.779571977022,11.2702974137,-1.96661516049,0.703502692088,-4.09811868051,-2.33955938407,0.466128330332,-0.885561756445,0.811769247175,0.422178625151,-0.00315502174251,-1.09403015573,-0.504388388622,-1.94752195826,-1.66894435486,-0.798915168736,-0.581163622629,0.172256900124,1.51508037768,0.196845128759,0.229078709897,0.424079977773,-1.00618496918,0.361287918542,-0.398473572362,-0.0185327919859,-0.0919710618422,0.052470981249,0.00893047666923,-0.375652018219,0.0251737355803,-0.0599113802897,0.094368646678,-0.222241799554,0.00356047224894,-0.0946024568578,0.424619233653,1.13456591749,0.695793862126,0.424917417754,-0.117652722325,-0.561262659399,-0.573651761739,0.0221590150274,-0.121605850411,0.19606816467],[-35824.8061842,-1800.02900544,-514.687163487,-1723.1706237,-1359.86340442,1308.86728217,1071.37296683,743.831962994,-653.165284905,-106.25306714,1002.60040457,-69.9134253379,-680.636099413,-141.195416162,127.798977581,-97.9792113237,-115.831614668,-18.4725956935,-661.436412073,-425.463016833,57.3387869416,-136.334607579,1.48564546693,-605.599277746,42.3297606298,72.2050493063,-139.320002642,155.759278831,-5.28986926112,195.886086936,-130.311604947,-215.302562078,-109.050003801,-74.4906628518,299.753227694,6.54153985072,10.8393861595,38.9906348751,15.6272634766,-12.2771657602,-65.9052204868,-65.106442545,-103.222790839,-43.584240979,-34.1119480417,19.7155578053,-22.1621340916,-27.7290811035,-2.07925904734,-0.204339249947,1.52079962436,0.952395510341,-17.8745858919,-7.10895614981,-17.4882343511,3.97262866963,-36.177652051,-17.7311476778,-8.60185021093,-3.62151031322,21.0289594313,8.90397790221,19.074134487,1.12262093578,-0.197156667875,-1.68892441462,1.63354276615,-0.369977669966,2.95125299326,-2.24420657303,-2.79785861107,-6.35360032633,-8.50376188419,5.66832149819,-0.703653819603,11.215951859,-1.88023515829,0.715672003094,-4.0640651871,-2.23415962197,0.448319335325,-0.898449078428,0.779638527523,0.398550391361,0.00341570300205,-1.15153479919,-0.495672546738,-1.97388357209,-1.60952553652,-0.791288206624,-0.532462500337,0.212206307223,1.52424972057,0.233668479331,0.247526358338,0.446346750972,-0.965739436894,0.3773684392,-0.393826375984,-0.0192595590019,-0.0968718185276,0.0441522050102,0.00197244555004,-0.375396063699,0.0147247808922,-0.0566612827627,0.0762703350656,-0.208821593751,0.00266224537931,-0.0833449368697,0.42831186428,1.13543519365,0.703677237743,0.432526398506,-0.106182429381,-0.545128893004,-0.564476930439,0.0250120754833,-0.126036258309,0.195047642264],[-35911.1926155,-1783.81433676,-432.300763487,-1740.89732213,-1353.22341057,1315.96654996,1087.96821425,734.048882651,-664.09268642,-86.715690243,1000.5267826,-44.7146081049,-705.500926547,-182.365254238,107.059633163,-99.2746196415,-103.74566108,-19.1388540232,-656.797467626,-433.71079836,47.1794618252,-137.444105378,14.1837195039,-596.493522282,44.1862523743,73.47341059,-135.010589247,152.823799369,-7.34061819688,195.010620037,-126.916141774,-213.870725497,-106.29180097,-71.7933555645,294.630997494,6.42014073564,10.8697741981,39.7726202541,15.6836079275,-13.1185485154,-65.561556663,-64.2894667101,-102.981158534,-42.9510580085,-33.5733860704,18.9776057747,-21.5486727569,-27.4556491519,-2.13402065575,-0.17379289499,1.73180132646,0.790233121633,-17.7088763506,-7.41477909693,-17.3574089908,3.75279027938,-35.6924471279,-17.5313698749,-8.52340179368,-3.25966487249,20.9745476329,8.97089646745,19.0516058713,1.0360584761,-0.236172593429,-1.70714956212,1.58824357761,-0.341505717651,2.77397912191,-2.18855679933,-2.8576503627,-6.19391428509,-8.44707627327,5.76783728262,-0.633323124633,11.1536902031,-1.78743546534,0.720418378196,-4.02583425997,-2.12415761535,0.427515063567,-0.909284869839,0.747159944344,0.375708067259,0.0131744476918,-1.20756426338,-0.487387505962,-1.99496346082,-1.54884987801,-0.782649601098,-0.481287671685,0.250012864858,1.53120233324,0.271252731468,0.2630143278,0.468455715107,-0.924387292827,0.393131035853,-0.388740273866,-0.0205663713385,-0.101635914096,0.0349926911702,-0.00474659772523,-0.373747130548,0.00449790744633,-0.053165032534,0.0593643351476,-0.19498223783,0.00233925563412,-0.0716373093209,0.431315085895,1.13540931933,0.711259167727,0.438877083951,-0.0941754210009,-0.529137829343,-0.554563216974,0.0276754800432,-0.130788756694,0.193994219084],[-36001.6613587,-1752.38222081,-349.647358797,-1764.82420939,-1346.22552533,1320.01819604,1105.50996541,726.88925633,-677.252862559,-66.5696740413,995.527047475,-19.3969812478,-728.472492944,-224.253596408,86.7948586447,-100.029532606,-92.5723482455,-19.9941711147,-652.095088122,-441.586581246,36.7936840073,-137.383161832,27.1820289263,-587.135522035,46.4784510596,74.4412327448,-130.806046768,149.780933199,-9.6120136941,194.212814518,-123.338006248,-212.25848952,-103.299141493,-69.2333661986,289.231793827,6.37920678986,10.9524725113,40.5652143562,15.6732821004,-14.0992814679,-65.0976200568,-63.4804912788,-102.702597452,-42.214422649,-33.1264785096,18.2580318966,-20.9272712133,-27.1265459809,-2.16916053019,-0.095642478527,1.97156512712,0.629706476742,-17.5362045322,-7.70299369476,-17.245426366,3.53565468897,-35.1787401231,-17.3734566171,-8.41817323067,-2.91361801863,20.9084048428,9.04820573862,19.0133498756,0.943577570401,-0.26117024111,-1.72005105635,1.54488024945,-0.305263906118,2.60160612446,-2.14275241357,-2.90881821401,-6.02945613714,-8.392484741,5.87122832582,-0.569124221892,11.0854230227,-1.68924816797,0.719946312474,-3.98347860329,-2.01071167949,0.403851052607,-0.917663910978,0.714681656159,0.35368558144,0.0257690795216,-1.26197307107,-0.479692140428,-2.01092700539,-1.48732843911,-0.77299485801,-0.428119338989,0.285612797198,1.53655094547,0.309499714715,0.276155460773,0.490534093201,-0.882636846276,0.408354969317,-0.383255592189,-0.0224625519275,-0.106120187042,0.025059015012,-0.01110080022,-0.370747434669,-0.00549629358601,-0.0494407027401,0.04361351575,-0.180794940513,0.00258532676854,-0.0595848733449,0.433666306762,1.13470347663,0.718555821919,0.444082783261,-0.0816953499856,-0.513400179455,-0.544087562557,0.0302002895105,-0.135793390813,0.192932808812],[-36092.6166469,-1711.06794153,-271.278670029,-1793.36192698,-1339.31265292,1320.66897816,1123.18852519,721.401478287,-691.893478446,-46.0242101538,987.900318824,5.30365497636,-749.736596675,-266.02014046,67.1075507519,-100.094584388,-82.4817232996,-20.9696873349,-647.354503453,-449.056594902,26.3969703494,-136.256539217,40.367306912,-577.729912559,49.207472793,75.1071808983,-126.748713411,146.672349379,-12.0721833681,193.524266948,-119.623759502,-210.461498206,-100.102691549,-66.7658027432,283.618892335,6.41807400414,11.0875674968,41.3561665312,15.594931112,-15.206631997,-64.5239475276,-62.6850537105,-102.378030311,-41.3960067721,-32.7517171799,17.5593167605,-20.311012468,-26.7551948044,-2.1838697023,0.0291918351925,2.23770363043,0.468339999566,-17.3577984834,-7.97465719822,-17.152556348,3.32699318235,-34.6433282565,-17.252598506,-8.28821928133,-2.58334082863,20.8313261787,9.13713135169,18.965443428,0.846313548058,-0.271688346334,-1.72815157585,1.50305645303,-0.262088186187,2.43492155214,-2.10619601602,-2.95106170215,-5.86136470938,-8.33927680763,5.9777334814,-0.510779599744,11.0134442939,-1.58667517302,0.716626864374,-3.9371069838,-1.89504003741,0.377565482951,-0.923458161554,0.682501481673,0.332461447908,0.0408371081807,-1.31468715138,-0.472519632199,-2.02213939701,-1.42529867144,-0.76225269493,-0.373479741529,0.319255502771,1.54094215265,0.348376167595,0.287666213788,0.512701018384,-0.840936867191,0.422840863162,-0.377450256821,-0.0249217231768,-0.110238389674,0.014422022518,-0.0169978420598,-0.366502999835,-0.0152674293355,-0.0454694119638,0.0289406428806,-0.166287385688,0.00338733243018,-0.0472988798511,0.435472680346,1.13356113473,0.725616135985,0.448325617091,-0.0688138702201,-0.497970187511,-0.533245053054,0.0326426874634,-0.140973874233,0.191891329524],[-36180.7417029,-1665.20485193,-198.650370506,-1825.02791458,-1332.50428966,1317.91071781,1139.94871556,716.163537488,-707.244803548,-25.1492229931,978.024061328,28.590634298,-769.438308707,-306.936904533,48.055568839,-99.3567302513,-73.6247113568,-21.9705682705,-642.631304616,-456.095632558,16.0983116063,-134.258010738,53.5671663222,-568.485463039,52.3492741151,75.4819403411,-122.892684911,143.539137983,-14.6928261835,192.955907451,-115.8397554,-208.481593097,-96.739897463,-64.3399732287,277.856533146,6.5322337794,11.2725732247,42.1310349388,15.4482743876,-16.4247477353,-63.8570482155,-61.9114068973,-102.004618898,-40.5212586699,-32.4294061816,16.8860942757,-19.7131299235,-26.3544849315,-2.17847627642,0.197698935764,2.52663052313,0.304224400181,-17.1752426767,-8.23199826644,-17.079483556,3.1312096308,-34.0939702832,-17.1622940959,-8.13590730509,-2.26789306335,20.7433444432,9.23823867437,18.9132344731,0.745426155446,-0.267851312395,-1.73214925685,1.46228446178,-0.213162143924,2.27476198168,-2.07794632893,-2.98436969492,-5.69084684908,-8.28644936876,6.08667826052,-0.457710600455,10.9402146353,-1.48084611347,0.712956415758,-3.88686466691,-1.77836011304,0.349045394595,-0.926696597935,0.650971848236,0.311944834723,0.0579817946893,-1.36564540354,-0.465741217672,-2.02909446339,-1.36310325438,-0.750361047421,-0.31786879475,0.351328700566,1.54499615897,0.38778628707,0.298246389179,0.534983573349,-0.799753117467,0.436368063879,-0.371427711629,-0.027889624518,-0.113919521758,0.0031845956246,-0.0223851381522,-0.361157552221,-0.0248229425076,-0.0412454957289,0.0152676225208,-0.151476004216,0.0047275204704,-0.0348848170617,0.436879065547,1.13222524734,0.732477733616,0.451811764758,-0.0556136807986,-0.48287898428,-0.522223679968,0.0350507812671,-0.146241921722,0.190882908486],[-36263.9881626,-1619.30961683,-131.735201239,-1858.61761176,-1325.63848033,1312.30548901,1154.6787377,709.791616371,-722.648975339,-4.00744297104,966.316819035,49.6685073387,-787.755762196,-346.424880552,29.622017469,-97.7254570737,-66.1452220206,-22.8985870272,-638.009708996,-462.674884139,5.93946786224,-131.645237816,66.5977876664,-559.601512415,55.8687472312,75.5781240176,-119.300870481,140.424645266,-17.4444227036,192.501100431,-112.070337061,-206.332617124,-93.2505373682,-61.9023622024,272.011876527,6.71478483986,11.5028315367,42.8740939073,15.2342798041,-17.7376812637,-63.1182408818,-61.1722204009,-101.582473353,-39.6175680292,-32.1372670811,16.2437512757,-19.1465305065,-25.9389829464,-2.15373826982,0.405699760966,2.83377788535,0.136246663553,-16.9903379009,-8.47779283434,-17.0268379126,2.9516498622,-33.5392106561,-17.0949571104,-7.96389574493,-1.96574052406,20.6440656573,9.3517821705,18.8621571854,0.642108624467,-0.250264642711,-1.73278119676,1.42202216053,-0.159873395219,2.12210275296,-2.05687158463,-3.00899107481,-5.51915203302,-8.23276321766,6.1975286324,-0.409045251395,10.8680215979,-1.37294460019,0.711408669016,-3.83295634384,-1.66185232049,0.318774382959,-0.927526407945,0.620496904746,0.291989079951,0.0767652812471,-1.41476484232,-0.45917402836,-2.03235670784,-1.30104992005,-0.737215113993,-0.26176096308,0.382336977294,1.54928576338,0.427613193749,0.308628258475,0.557405636206,-0.759512089602,0.448737577924,-0.365316976674,-0.0312901209034,-0.117094497529,-0.00852594549329,-0.0272541860184,-0.35487718675,-0.0341526139197,-0.036773085341,0.00251868902317,-0.136354333778,0.00658083239374,-0.0224306207363,0.43804943377,1.13093264606,0.739183433914,0.454757469862,-0.0421778585284,-0.468139497647,-0.511208579756,0.037463995799,-0.151510821882,0.189915838639],[-36340.6010406,-1574.39506348,-70.3300294405,-1893.10371658,-1318.16275191,1305.14194663,1166.65056179,701.62219015,-737.679736283,17.3296705095,953.248434183,67.8874774271,-804.851980649,-384.148561722,11.7286382909,-95.1522379338,-60.1714954629,-23.6803505102,-633.581741457,-468.771483114,-4.06163353042,-128.674060077,79.2949753549,-551.232152884,59.7275675211,75.3994876115,-116.03938618,137.37296155,-20.2923796371,192.140491114,-108.409366282,-204.046488942,-89.6730105467,-59.4079141343,266.157951714,6.95733130527,11.7698354094,43.5689381876,14.9540797536,-19.1324678715,-62.3318435328,-60.4841955195,-101.114405739,-38.7112429144,-31.8500905963,15.6374771379,-18.6231839956,-25.5259701035,-2.10999064472,0.648125857001,3.15381889058,-0.0364825838822,-16.8057133616,-8.71495642613,-16.9951062767,2.79094638638,-32.9881457713,-17.0425745192,-7.77433272839,-1.67552345574,20.5336409794,9.47772640138,18.8178778806,0.537797754999,-0.219793522519,-1.73067608182,1.38163862977,-0.103784539952,1.9778916581,-2.0419791938,-3.02549154549,-5.34755331218,-8.17689250596,6.31006960282,-0.363551544741,10.7989464362,-1.26426404632,0.714154556546,-3.77574455712,-1.54673263863,0.287312785922,-0.926091099399,0.591540656946,0.272424932751,0.0967304818411,-1.4619723651,-0.452650019362,-2.03249966547,-1.23942566536,-0.722651905702,-0.205581439812,0.412836509507,1.55434415648,0.467693691731,0.319560395783,0.580033538449,-0.720540891562,0.459841966865,-0.359274093016,-0.0350396992015,-0.11968143714,-0.0205608223858,-0.0316218103459,-0.347813764517,-0.0432322163888,-0.0320672794333,-0.00937408490195,-0.120918678352,0.00891679446771,-0.0100192543583,0.439161390767,1.12991557869,0.74577240389,0.457383154667,-0.0286015095443,-0.453755495521,-0.500384783544,0.0399078930834,-0.156708214929,0.189001600968],[-36408.2112474,-1528.54510734,-15.0476872752,-1927.48815277,-1308.96613623,1298.50934475,1176.02367813,691.996735502,-752.175666799,38.8275391973,939.339934889,82.8135663733,-820.701497771,-420.047356816,-5.64381334492,-91.6619395769,-55.8050985196,-24.264806668,-629.424811315,-474.341309572,-13.8612132994,-125.553084086,91.5358997625,-543.478747878,63.8812890961,74.9395473623,-113.173111315,134.427962174,-23.1948651252,191.847584257,-104.938064109,-201.672869029,-86.0302029515,-56.8268506616,260.378141887,7.25105089234,12.0605641718,44.1987284542,14.607868429,-20.6001772892,-61.5219048475,-59.8644215856,-100.606533775,-37.8237330141,-31.5442879158,15.0717384705,-18.1543911287,-25.1338022391,-2.04692765203,0.918983845268,3.48066983011,-0.214748498125,-16.625610356,-8.94604075663,-16.9846654747,2.65068889551,-32.4492240927,-16.9976160428,-7.56738548765,-1.39628740954,20.4140666255,9.61595193198,18.7858564673,0.434162929684,-0.177469807763,-1.7263698795,1.34036828294,-0.0467866861156,1.84292453614,-2.03263028064,-3.03475632513,-5.17718509264,-8.11774111133,6.42462620033,-0.319990234111,10.7349267817,-1.15640249146,0.722876838204,-3.71591345881,-1.43416196943,0.255273336077,-0.922495849646,0.564599184883,0.253058655333,0.117385017632,-1.50723541176,-0.446088996051,-2.0300722584,-1.17850872739,-0.706506880796,-0.149614327592,0.443335114607,1.56071445319,0.507784286079,0.331757443012,0.602968768578,-0.683065894468,0.469686977344,-0.353491236248,-0.0390564057045,-0.1215898321,-0.0327536116337,-0.0355272139279,-0.340099077481,-0.0520387274371,-0.0271721084568,-0.0204570953595,-0.105178087357,0.0116931808894,0.00228167605248,0.44038419195,1.12940438982,0.752241686348,0.459915302544,-0.0150165411793,-0.439717800038,-0.489934550337,0.0423971828137,-0.161783370013,0.188163801733],[-36463.7810465,-1479.55508428,34.0960203766,-1960.68508698,-1296.61476252,1294.97793422,1183.03130232,681.341815176,-766.113491989,60.5449530588,925.149566703,94.2124185039,-835.116603409,-454.160761639,-22.4270833692,-87.33480583,-53.1003416676,-24.579120744,-625.586723378,-479.283289832,-23.442243213,-122.468471791,103.181862182,-536.407434253,68.2720319155,74.1907274121,-110.757373985,131.642564127,-26.1052651614,191.585966505,-101.725594408,-199.274044877,-82.33776765,-54.1332207566,254.750125249,7.58611012502,12.3614746133,44.7463358265,14.1990550188,-22.1331502739,-60.7100585578,-59.3286543609,-100.069144888,-36.9709472139,-31.2005066129,14.5523468558,-17.749563127,-24.7782433627,-1.96375778723,1.21158590062,3.80769033423,-0.398323157584,-16.4544629521,-9.1728986119,-16.9954485844,2.53001709614,-31.9293910608,-16.9532793989,-7.34221514285,-1.12688186627,20.2873179813,9.76571682213,18.7703235909,0.332897054529,-0.124778939806,-1.72035765891,1.29742029109,0.00905591431068,1.71793820322,-2.0284326641,-3.03788048938,-5.00887262943,-8.05423082498,6.54177640566,-0.277110290288,10.6775563234,-1.05098379486,0.739002586245,-3.65405622779,-1.3250806726,0.223272701424,-0.916888461671,0.540096937792,0.233661026997,0.138196938042,-1.55047298812,-0.439404999549,-2.02555938744,-1.11848508633,-0.688618031645,-0.0939780326769,0.474296757331,1.56895946863,0.547564902426,0.345844016053,0.626282136888,-0.647290691121,0.47827161861,-0.348167083967,-0.0432491829803,-0.122735809002,-0.0449373055976,-0.039051758315,-0.331846681645,-0.0605425738944,-0.0221434677846,-0.0307658977907,-0.0891328043656,0.014854691995,0.0144516268686,0.441878330074,1.12960374622,0.758555039129,0.462549891726,-0.00155776723102,-0.426015605529,-0.480002261435,0.0449320317392,-0.166688080214,0.187422361759],[-36504.1792069,-1427.3920392,77.7360492698,-1991.52773649,-1280.1643809,1296.91327506,1186.93591378,670.205892181,-779.4569023,82.5109424835,911.24722548,101.744369991,-847.837359179,-486.6381385,-38.5298427704,-82.2632740627,-52.0370545277,-24.5372550607,-622.140629357,-483.448438524,-32.8756170186,-119.596623422,114.053407568,-530.082580554,72.8314366915,73.162571861,-108.828551786,129.072635607,-28.974116915,191.303927394,-98.8372438361,-196.931334961,-78.6239279936,-51.31126733,249.340305936,7.95085689364,12.6633428175,45.1978006219,13.7383709467,-23.7221993573,-59.9192145693,-58.892087633,-99.5192483383,-36.1679637488,-30.8052908097,14.0855642096,-17.4158611689,-24.4746018569,-1.86035888762,1.5193265469,4.12808116371,-0.584975572614,-16.2966178064,-9.39650267615,-17.0265519637,2.42574961029,-31.4345761672,-16.9042028893,-7.09893160629,-0.866228528886,20.1535401567,9.92542643533,18.7741034715,0.235651006996,-0.0637760467337,-1.71323163312,1.25233012221,0.0617553563937,1.60379880872,-2.0287714254,-3.03610388274,-4.84324849675,-7.98549231334,6.6619484999,-0.233706879313,10.6276326432,-0.949525241392,0.763420325941,-3.59056245867,-1.22035652818,0.191917668547,-0.909591845566,0.51831901544,0.214003562497,0.158617558879,-1.59149372673,-0.432445208873,-2.01937749912,-1.05939873221,-0.668848037178,-0.0387574953577,0.506147228957,1.57944459469,0.586654346259,0.362210406941,0.650034195475,-0.613431370551,0.485579371719,-0.343498477321,-0.0475161841827,-0.12307276935,-0.0569607600612,-0.0423210515549,-0.323175833693,-0.0687034193121,-0.0170330306539,-0.0403072917545,-0.0727587748924,0.0183453228254,0.0265045088013,0.443784178349,1.13066215194,0.764668235713,0.465405535032,0.0116692465361,-0.412658949647,-0.470694397437,0.0474866261148,-0.171369463364,0.186788709531],[-36526.0134604,-1370.70085293,116.344096993,-2018.84726815,-1258.60487584,1305.91611182,1186.90644448,659.177242943,-792.15544371,104.689658951,898.12883364,105.17078301,-858.567863824,-517.558201339,-53.7371240944,-76.5570062931,-52.5825611581,-24.0702038209,-619.135394123,-486.674227743,-42.2254114558,-117.054472549,123.978670342,-524.540361961,77.4871237319,71.8722996803,-107.402068714,126.770748535,-31.7545964653,190.961877888,-96.325142141,-194.723708779,-74.9104117832,-48.3570564316,244.220242677,8.33554371355,12.9603228031,45.5452616316,13.2391438775,-25.3578167606,-59.1709949527,-58.5684316487,-98.9749988742,-35.4231804833,-30.350762241,13.6839546676,-17.1582746097,-24.2374799313,-1.73687284454,1.83657137803,4.43568885301,-0.772411248784,-16.1567764076,-9.61734350699,-17.0772179971,2.33450028876,-30.9683652449,-16.8463286383,-6.83671651977,-0.613705359024,20.0121587217,10.0923775837,18.7992788936,0.144056531997,0.00343466885509,-1.70571506319,1.20480909064,0.109561892758,1.5011511458,-2.03285353075,-3.03070022022,-4.68070574507,-7.91092804383,6.78584068963,-0.188899038775,10.5857308075,-0.853661776141,0.796691878142,-3.52572019877,-1.12073074446,0.161737499059,-0.901011908014,0.499392855723,0.193899704946,0.178192715675,-1.63013112188,-0.425046131925,-2.01193991549,-1.00124577061,-0.647097377738,0.0160070576268,0.539186652669,1.59244353182,0.624575412577,0.381098628069,0.67426225045,-0.58165991418,0.491568927682,-0.339684912249,-0.0517781856594,-0.122585680659,-0.0686986195345,-0.045454382509,-0.314197482188,-0.0764926676494,-0.0118778445701,-0.0490884130928,-0.056046428874,0.0221154970023,0.0384635426899,0.446207898867,1.1327077864,0.770527151126,0.468566532461,0.0245681764348,-0.399658206607,-0.462109913097,0.0500117506623,-0.17577656088,0.186272860158],[-36527.4548535,-1307.71226677,150.930016365,-2041.78546246,-1231.57799359,1322.41471332,1182.08873729,648.8621547,-804.180189878,126.853468019,886.152016116,104.499281658,-866.983945433,-546.840285309,-67.7880841221,-70.2996768452,-54.7075004512,-23.1075254921,-616.598078993,-488.831688266,-51.5733768255,-114.894554055,132.784346065,-519.743611292,82.1790378689,70.3442603277,-106.469723422,124.773627435,-34.410458899,190.540011818,-94.2234741913,-192.71399564,-71.2104256528,-45.2775653343,239.448021381,8.73416891898,13.2501050296,45.7890982392,12.7148679864,-27.0293515441,-58.4822050452,-58.3684522517,-98.4555032835,-34.7377773309,-29.8353422914,13.3652168886,-16.9789518667,-24.07627639,-1.59396300378,2.15927116386,4.7255727818,-0.95862382953,-16.0387000257,-9.8358528747,-17.1470307058,2.25263221827,-30.5317901797,-16.7769729923,-6.55452879643,-0.369695726254,19.8617191918,10.262888251,18.8464448267,0.0594250062679,0.0750267465449,-1.69868581465,1.1547182441,0.151225321859,1.41029390768,-2.03983629397,-3.02297268018,-4.521391185,-7.83036275887,6.91426588782,-0.142301741677,10.5522727271,-0.764708015011,0.839021581999,-3.45959669104,-1.02683042128,0.133150268226,-0.891554720009,0.483251653573,0.173224765684,0.19662985654,-1.66632210581,-0.417066928388,-2.00370257549,-0.943998476411,-0.623374114516,0.070339242294,0.573561010281,1.60807674571,0.660812978968,0.402562851918,0.698915596951,-0.552089515381,0.496188075993,-0.336853912398,-0.0559769836578,-0.12129900479,-0.0800671753297,-0.0485504123549,-0.305017591157,-0.0839034123633,-0.00669430366729,-0.0571339247936,-0.0390013274701,0.0261182851822,0.0503515417899,0.449207744609,1.13581171242,0.776062145357,0.4720811734,0.0370806524425,-0.387023518136,-0.454305113314,0.0524406242317,-0.179865961028,0.185869864618],[-36510.2956367,-1238.56601927,182.38038463,-2059.86876817,-1199.79436652,1345.74536927,1172.05273898,639.514871537,-815.399401423,148.606598438,875.526913446,99.9687856204,-872.842226457,-574.397366815,-80.4635481274,-63.4959757096,-58.3710739845,-21.5663604553,-614.523541223,-489.871298698,-61.0022425185,-113.142883701,140.312723099,-515.60561501,86.8694869782,68.6184796684,-105.998297779,123.107369188,-36.9200695594,190.037466613,-92.5571099276,-190.947602416,-67.5239579253,-42.0889216663,235.068532816,9.14320822167,13.537148298,45.9391494947,12.1780332728,-28.7232929329,-57.863272325,-58.2992856855,-97.9816145698,-34.1055911356,-29.2641794828,13.1465871786,-16.87921661,-23.995972918,-1.43406630538,2.485307996,4.99443545679,-1.14181074858,-15.9437509187,-10.0520192888,-17.2356779332,2.17635418264,-30.1240636962,-16.6952062705,-6.25112334756,-0.135805796213,19.7003904114,10.4333812125,18.9146129039,-0.0177779184076,0.149423782157,-1.6931278188,1.10213556055,0.186358782166,1.33125457774,-2.04880405314,-3.01428165495,-4.3651826438,-7.74417551409,7.04814465607,-0.0940883565746,10.5274285292,-0.683694859419,0.890124412297,-3.39221865299,-0.939168832574,0.106405260544,-0.881670551268,0.469619049559,0.151949726091,0.213828202798,-1.70011542413,-0.408307676819,-1.99515001436,-0.887599143987,-0.597839413168,0.124326684712,0.609193787807,1.62624005161,0.694892791065,0.426401713057,0.72392771756,-0.524823599779,0.499418830785,-0.335100917757,-0.0600586118888,-0.11930295605,-0.0910378206244,-0.0516848408863,-0.29574641082,-0.0909475491565,-0.00146705163667,-0.0644744628803,-0.0216404815652,0.0303009245983,0.0621883722106,0.452802882508,1.13998184796,0.781202711092,0.475949652314,0.0491920603571,-0.374784325311,-0.447289596755,0.0547033693948,-0.18360740962,0.185571829033],[-36478.8662548,-1164.54791647,209.890588428,-2072.81436617,-1164.72988602,1374.56000924,1157.05021183,631.056824141,-825.571165017,169.484629277,866.283390247,91.9441836393,-876.052689519,-600.259501916,-91.5282165002,-56.0788016083,-63.5131159247,-19.3857391933,-612.8955338,-489.811435962,-70.5538145414,-111.797302836,146.455388921,-512.020880891,91.5375470939,66.7437060164,-105.931729276,121.790323569,-39.2726609331,189.465000144,-91.346295244,-189.455007213,-63.8364856843,-38.8164833939,231.128115328,9.55928422818,13.8324592329,46.0116544988,11.6409419935,-30.4253382708,-57.3197050686,-58.3639833063,-97.5711081178,-33.5136687839,-28.6483324938,13.0419152107,-16.8616299594,-24.00025363,-1.26100713273,2.8141214042,5.24015742565,-1.32064592101,-15.8710670705,-10.265047562,-17.3426206475,2.10268675108,-29.7436351056,-16.6018875654,-5.92510578237,0.0852073948574,19.5270808707,10.6009033255,19.0016329023,-0.0878386296369,0.225061115508,-1.6899806656,1.04734754673,0.215261864075,1.26388600672,-2.05891710018,-3.0059465843,-4.2118374815,-7.6531189627,7.18837386262,-0.0450466338291,10.5110714959,-0.611751443781,0.949216445059,-3.32387798153,-0.858109100042,0.0815782708588,-0.871826003191,0.458048044944,0.130143698215,0.229796197719,-1.73162469409,-0.398520344433,-1.98672885023,-0.831966867546,-0.57074900287,0.178047713848,0.645701551204,1.64667815401,0.726357566268,0.452249186316,0.749264316372,-0.499991303808,0.501303712932,-0.334549806111,-0.0639663232972,-0.116736203235,-0.101625138821,-0.0549195122067,-0.286491224231,-0.0976471637856,0.00384756309079,-0.071148123844,-0.00401080044561,0.034602621968,0.073979130935,0.456970655189,1.14518434367,0.785879626075,0.480137850107,0.0608919127315,-0.363000975813,-0.441058722393,0.0567347244407,-0.186976251953,0.185384708205],[-36437.6821226,-1086.4423206,231.028794866,-2080.45874832,-1127.94316788,1407.17675606,1138.05203085,623.356570429,-834.517205327,189.041801989,858.339606581,80.9015369814,-876.704823506,-624.499718828,-100.756430455,-47.967549126,-70.0477801943,-16.5423869971,-611.69550045,-488.705527723,-80.2176023097,-110.800209004,151.182582528,-508.848775251,96.1722759924,64.7673606586,-106.200848694,120.827348598,-41.4601634068,188.840438962,-90.592903242,-188.250610712,-60.1181596274,-35.4964057584,227.670534683,9.98097071735,14.147240878,46.0267853437,11.1149476846,-32.119970705,-56.8551490403,-58.5603120144,-97.2343786543,-32.9434125934,-28.0012022124,13.0615786275,-16.9276955202,-24.0904480665,-1.07908738363,3.14583583513,5.46126057714,-1.49389108084,-15.8181684006,-10.4738805443,-17.4665607998,2.03007461754,-29.3877802189,-16.4990798926,-5.57531133484,0.2895588854,19.3422860723,10.762985917,19.1048722477,-0.1513955343,0.300484079965,-1.69003655288,0.990740385924,0.238729034718,1.20770783539,-2.06933731698,-2.9991996342,-4.06113295932,-7.55812297948,7.33573293999,0.00350250703925,10.5029931405,-0.549938194444,1.01512469156,-3.25516271463,-0.783938970477,0.0586319177982,-0.862461400277,0.448019461162,0.107921575456,0.244602097874,-1.76102008467,-0.387465590931,-1.97888841882,-0.777033475101,-0.542385361244,0.231576555886,0.682485912511,1.6690993403,0.754752240172,0.479720099819,0.774851560023,-0.477709543043,0.501944936831,-0.335295205872,-0.0676559617847,-0.113757321715,-0.111862929639,-0.0583062529465,-0.277369456511,-0.104027906864,0.00930862880582,-0.0772233337276,0.0138204196699,0.0389563562557,0.0857259136832,0.461638243008,1.15137160387,0.790010534436,0.484618503849,0.0721523031302,-0.351759535132,-0.435603199577,0.0584689739188,-0.189958387041,0.18532365571],[-36390.4235034,-1005.59236886,241.559518024,-2082.77607916,-1090.76641462,1441.74201314,1116.10182873,616.067425219,-842.217782788,206.925452192,851.530717626,67.292486415,-875.130502454,-647.168626815,-108.080839199,-39.1199897809,-77.8183918845,-13.0664319977,-610.914698663,-486.623817091,-89.9181969917,-110.07834114,154.563487502,-505.905351483,100.769525296,62.7430369309,-106.73603356,120.216451904,-43.4676803962,188.188178065,-90.2710270547,-187.332135672,-56.3240015216,-32.1747262588,224.729846398,10.4123007766,14.4901534992,46.0080374011,10.6129873212,-33.7861360596,-56.4741188707,-58.8810968354,-96.9724757356,-32.3726740296,-27.3369617201,13.2102986521,-17.0756393038,-24.2674397031,-0.892730929083,3.48052407595,5.65714956616,-1.65886089547,-15.7816325123,-10.6779345137,-17.6049770427,1.95896418648,-29.0525869671,-16.3896260513,-5.20181986173,0.47275928549,19.1474257993,10.9176572607,19.2221254914,-0.209192933874,0.374411148273,-1.69381119556,0.932857604265,0.257958634687,1.16172870414,-2.07900496962,-2.99499831652,-3.91307668766,-7.46045760599,7.49062496165,0.0497444940635,10.5026308642,-0.498943235431,1.08645013033,-3.18699676026,-0.716959117003,0.0374416876905,-0.854026335174,0.43900883015,0.0853756893201,0.25834644798,-1.7885043262,-0.374953168896,-1.97214261196,-0.722818840618,-0.512998708388,0.284958047584,0.718838684063,1.69313362787,0.779696725951,0.508480401613,0.800537835419,-0.45804295578,0.501502277237,-0.337364186234,-0.0711317942625,-0.110537803551,-0.121794482723,-0.0619129916205,-0.268541164926,-0.110104722294,0.0149623831884,-0.082793520005,0.0317771150795,0.0433258762482,0.0974459358997,0.466671323718,1.1584783007,0.79351091664,0.489399872712,0.0829229670608,-0.341157974182,-0.430915567516,0.0598266604425,-0.192557763166,0.185399481618],[-36339.551398,-924.999848961,238.420007991,-2080.09663127,-1054.08609924,1476.99217971,1092.38937164,608.814488723,-848.857781442,222.932481389,845.669103149,51.581319504,-871.694755378,-668.273972272,-113.468394602,-29.5596528468,-86.6173217007,-9.0431828877,-610.558381589,-483.600516845,-99.5003088644,-109.544435135,156.71484957,-502.993945106,105.325590553,60.7203516414,-107.475360432,119.958659543,-45.2707309293,187.548817595,-90.3231399025,-186.691678956,-52.3927586978,-28.9070793399,222.336584563,10.8639009146,14.8669869368,45.979154438,10.1500036127,-35.3977054113,-56.1807867092,-59.3122146226,-96.7799146341,-31.773867674,-26.6749860524,13.4881026485,-17.3010251944,-24.5326548074,-0.70508999655,3.81785645831,5.82790327545,-1.8121603005,-15.7576364559,-10.8770323022,-17.7542676054,1.89139340522,-28.7332523658,-16.2777800024,-4.80575567132,0.631044530659,18.9447173757,11.0639495015,19.3510110753,-0.261846399983,0.445721962335,-1.70146058299,0.874194019589,0.274313118509,1.12445878809,-2.08696740661,-2.99394066687,-3.76774845269,-7.36178250215,7.65346726672,0.0916593537586,10.5092277108,-0.459175092338,1.16161551519,-3.12074780899,-0.657401181257,0.0177889336718,-0.846886743614,0.430529858184,0.062525684129,0.271116781816,-1.81435392912,-0.360860790389,-1.96702773535,-0.669415555256,-0.482808441403,0.33826818858,0.753946905431,1.71839751152,0.800886658964,0.538250062533,0.82609767537,-0.441063492995,0.500193786801,-0.340763270857,-0.0744532283786,-0.107231952209,-0.131464178141,-0.0658359842421,-0.260186402256,-0.115892428208,0.0208371408813,-0.0879539019589,0.049751726329,0.0477132289965,0.109193261768,0.471891791522,1.16645532172,0.796311767903,0.494531344064,0.0931212439675,-0.331299882748,-0.426990160916,0.0607338825025,-0.194779402193,0.185630280605],[-36287.0933101,-845.935335362,220.973212321,-2073.25605651,-1018.09433262,1511.85071124,1068.17251418,601.134066284,-854.917558734,236.980481316,840.499176024,34.4773418949,-866.658420157,-687.568742625,-116.966724289,-19.4187002145,-96.2458116,-4.57371845976,-610.630319485,-479.65161457,-108.757782095,-109.109561135,157.748071198,-499.923036729,109.821156086,58.7211330077,-108.357212219,120.050571885,-46.8466893445,186.990969252,-90.6697472032,-186.296879703,-48.2760428292,-25.7466770973,220.507359499,11.348695999,15.2751339973,45.965273611,9.73999000199,-36.9265680566,-55.9725688699,-59.8331162156,-96.6423584186,-31.1191264865,-26.0371981893,13.8940406625,-17.5946842692,-24.8839957672,-0.517591977171,4.15565986387,5.97431295399,-1.95123041697,-15.7419350758,-11.0705422056,-17.9101350005,1.83238057595,-28.4251940136,-16.1671459362,-4.39018067135,0.762303559491,18.7361352383,11.201382813,19.4879571495,-0.309575631661,0.513201451899,-1.71304768045,0.814802393992,0.289267900122,1.09429318182,-2.09246840246,-2.99573356063,-3.62520228381,-7.26351704811,7.82436684792,0.127573909832,10.522179094,-0.430389388149,1.23903436071,-3.05788896405,-0.605421017086,-0.000472019216645,-0.841275925454,0.422074944907,0.0392395234885,0.28302629627,-1.83894729169,-0.345100184859,-1.9640159115,-0.616887101531,-0.451930338017,0.391577441632,0.78706217267,1.74453816355,0.81817210301,0.568726912749,0.85118334815,-0.426866581045,0.498217344674,-0.345417674394,-0.0776743670656,-0.103943963699,-0.140922879819,-0.0702138112962,-0.252482281106,-0.121445451415,0.0269494200226,-0.0928045436424,0.0676423805274,0.052162868869,0.121052991699,0.47714007534,1.17526534338,0.798398955568,0.500088290553,0.102672409711,-0.322283306994,-0.423797048188,0.0611372339465,-0.196613452711,0.186023230433],[-36236.4628926,-768.900787796,189.924839097,-2063.26782568,-983.455469238,1545.11047435,1043.98475286,592.528392237,-860.912296687,248.840502388,835.608683707,16.6497875695,-860.303279776,-704.682575279,-118.880399705,-8.86288378506,-106.516039399,0.202292638778,-611.208664307,-474.843081418,-117.508353789,-108.720482352,157.738269202,-496.529254838,114.241455022,56.7573452198,-109.315872288,120.468821495,-48.1865254401,186.579884569,-91.2328817598,-186.106324666,-43.9692687582,-22.7424063356,219.241635468,11.8812302241,15.7121921377,45.9924794446,9.39791036558,-38.3461434205,-55.8441215906,-60.4234198518,-96.5407209605,-30.3896019136,-25.4445102398,14.4242133836,-17.9401030022,-25.3162703804,-0.330804664318,4.49196483757,6.09800403018,-2.07243346913,-15.7297619898,-11.2572943452,-18.0684266279,1.7888771467,-28.1260545379,-16.0603945207,-3.96163770946,0.866180975158,18.5225752,11.3295133715,19.628303606,-0.352580422783,0.575740279308,-1.72866271555,0.754986548089,0.304592039048,1.06988907626,-2.09489065251,-2.99944106411,-3.48575632499,-7.16679731517,8.00227970337,0.156556702826,10.5406839044,-0.41144967352,1.31701719039,-2.9998377716,-0.561164043256,-0.0175050935515,-0.837379851887,0.413115212286,0.0153634971646,0.294235839217,-1.8625577769,-0.327542102882,-1.96349081739,-0.565242291951,-0.420394999953,0.444821828772,0.817612575135,1.77116485513,0.831650598346,0.599535876633,0.875363238692,-0.41552247604,0.495720352079,-0.351090195845,-0.0808417462738,-0.100770136426,-0.150216050995,-0.0752042202619,-0.245590997598,-0.12681602623,0.0333279208103,-0.0974486119182,0.0853831917129,0.0567388137685,0.133129227962,0.482306048893,1.18484891318,0.799845369051,0.506143194115,0.11154226112,-0.314197676919,-0.421278192589,0.0610182343394,-0.198032128348,0.186564313655],[-36191.6393731,-694.45452373,146.528789533,-2050.89952404,-951.464263533,1575.58799597,1019.8124338,582.514561238,-867.300076032,258.211950611,830.470330594,-1.33022848812,-853.08124721,-719.36555691,-119.898348741,1.91490547482,-117.210925478,5.09500463725,-612.456896269,-469.330351876,-125.615617787,-108.353470423,156.748387318,-492.694588595,118.581695894,54.8363847248,-110.27726518,121.172027976,-49.2936317059,186.368861758,-91.9334401649,-186.081477435,-39.5134362008,-19.946761235,218.524308283,12.4761750414,16.1758671949,46.089029587,9.14044566473,-39.6324174248,-55.7893970907,-61.0631523791,-96.4524555832,-29.5754290697,-24.9144771351,15.0680468802,-18.3116949067,-25.8233102784,-0.145036513038,4.82511268817,6.2012738727,-2.17056793761,-15.7158945441,-11.4352050786,-18.2249905211,1.7699621486,-27.8355174153,-15.9594012164,-3.53048883442,0.943977013697,18.3047381397,11.4484794038,19.7664541354,-0.39113726849,0.632417581639,-1.74861580527,0.695348776154,0.322598860712,1.05025507784,-2.09382192188,-3.00376958388,-3.34989842911,-7.07251249271,8.18497940232,0.178499482214,10.5636747481,-0.400350363734,1.39333471162,-2.94818292681,-0.524802849371,-0.033530884646,-0.835374406667,0.403123673626,-0.00931351946353,0.304960455245,-1.88536301126,-0.308065751513,-1.96579901035,-0.514416833542,-0.388125355255,0.497788389818,0.845193114207,1.79779819795,0.841668394557,0.630240301379,0.898168256049,-0.407000201948,0.492876663034,-0.357358039754,-0.0840007418567,-0.0978007395249,-0.159381384025,-0.080980345345,-0.239662462148,-0.132056034016,0.0400087767744,-0.101994379479,0.102946484348,0.0615038645955,0.145546073344,0.487325695684,1.1951337307,0.800813032554,0.512781708902,0.119740861373,-0.307126363957,-0.419358580585,0.060400383607,-0.199002869398,0.187230743591],[-36156.1240421,-625.2389504,92.9931785096,-2036.57564396,-923.619431058,1602.67509781,995.980021284,570.755622369,-874.404558295,264.887060234,824.480363556,-18.9506179508,-845.567614336,-731.513615022,-120.968078112,12.7175029571,-128.106382324,9.87821963087,-614.574281003,-463.296114204,-132.936034177,-108.023757836,154.837827906,-488.407951784,122.841247026,52.9557637331,-111.164036625,122.113920903,-50.1781959049,186.400124762,-92.6919780921,-186.198505015,-34.9761376119,-17.4130350418,218.3473488,13.1476104028,16.6625135538,46.2832723618,8.982781947,-40.7645732531,-55.8039110728,-61.7310431734,-96.3521373939,-28.6715139301,-24.4617721207,15.8100798902,-18.6776214076,-26.4000398357,0.0399701568826,5.15345492596,6.28649849974,-2.24053219562,-15.6948655801,-11.6017491734,-18.3755734648,1.78620227592,-27.5540840137,-15.8655457942,-3.10893245923,0.99940415186,18.0841418201,11.5599958738,19.8962891572,-0.425475115912,0.682503228262,-1.77346954446,0.636374504956,0.345950257496,1.03462215598,-2.089125506,-3.00724452069,-3.21800287944,-6.98117309665,8.36965068097,0.193882587479,10.5898892147,-0.394743362287,1.46521102842,-2.90488786095,-0.496417690343,-0.0488190335029,-0.835382288137,0.391614757498,-0.0350938069962,0.315425159098,-1.90751630589,-0.286606368812,-1.97127449718,-0.46429612806,-0.354917680807,0.550155521609,0.869483492811,1.82390757896,0.848741718799,0.660398895598,0.919159428934,-0.401219769193,0.489892061961,-0.363684157273,-0.0872024064456,-0.0950852412715,-0.168438420646,-0.0877138799566,-0.234834517321,-0.137224417255,0.0470266441833,-0.106553545615,0.120313359989,0.0665098610573,0.158442360173,0.49215705764,1.20605585405,0.80152320295,0.520109774521,0.127295206305,-0.301140634266,-0.417979929886,0.0593704509195,-0.199481060683,0.188020729549],[-36130.5070424,-564.508038095,35.2031227455,-2020.19586292,-900.486030808,1626.96491071,974.073814173,557.61970515,-882.544651948,269.00141221,816.975812511,-35.5624809849,-838.078253913,-741.121977618,-123.084580509,23.3064995896,-138.996473693,14.304971447,-617.730856936,-456.869016058,-139.29619432,-107.744861245,152.02418267,-483.709437825,127.007914762,51.0913672501,-111.909772244,123.244510114,-50.8528407288,186.707550139,-93.4060453347,-186.449232153,-30.4142256756,-15.1948744526,218.714751509,13.9098523115,17.1607094556,46.5996851915,8.93460915673,-41.727389472,-55.8810514812,-62.3971037328,-96.2121474799,-27.6699236672,-24.1031938823,16.634814878,-19.004592318,-27.0398113961,0.226292777536,5.47424468832,6.35561678096,-2.27858781676,-15.6617536452,-11.7545611353,-18.5157118349,1.84844184832,-27.2808551739,-15.7807420735,-2.70779107544,1.03783806704,17.8635076529,11.6669081507,20.010262779,-0.45553185751,0.725600799987,-1.80382345342,0.578058226223,0.376915740172,1.02211627942,-2.08131374286,-3.00823613731,-3.08997933834,-6.89314428217,8.55361057615,0.203185854822,10.6181096177,-0.392304631467,1.52948462251,-2.87233778044,-0.475944163432,-0.0636139806104,-0.837284121654,0.378165385176,-0.0623730016873,0.325812050803,-1.92921793918,-0.263311995833,-1.98019372528,-0.414756241605,-0.320547097966,0.601702134345,0.890107031049,1.8490735416,0.853452720656,0.689573808462,0.937818303272,-0.398132578951,0.48698890165,-0.369479221598,-0.09051036246,-0.0925945391064,-0.177374855619,-0.0955583341577,-0.231217788477,-0.142387743835,0.0543839449116,-0.111251988089,0.137441578781,0.0718024977106,0.171978000262,0.4967442174,1.21756546789,0.802183382959,0.528248608966,0.134205679997,-0.296294607748,-0.417079157611,0.0580710052769,-0.19939749319,0.188935171639],[-36111.8131271,-514.226801809,-15.3610798762,-2000.71971237,-881.234686362,1649.98511008,956.921857685,544.126593248,-892.01274306,271.082322705,807.227104417,-50.2077365299,-830.569240189,-748.136335601,-127.294978768,33.3937285825,-149.685302067,18.13438478,-622.046349439,-450.130983355,-144.533453674,-107.526060876,148.233972049,-478.646237629,131.053852059,49.2053776185,-112.458276154,124.508502835,-51.3333596165,187.323426509,-93.9442525039,-186.834021807,-25.8740038405,-13.3516657643,219.632704581,14.7782795638,17.6507541344,47.0611326562,9.00077918656,-42.5096483649,-56.0093780388,-63.0220836765,-96.0031070469,-26.5593269919,-23.8605098393,17.5313550588,-19.2569360112,-27.7315093297,0.417920511105,5.78362252685,6.41033565944,-2.28187403066,-15.6117991548,-11.8915034959,-18.6409517305,1.96783366092,-27.0128132897,-15.707275357,-2.3367401543,1.06575398825,17.6454494167,11.7720230939,20.0980187492,-0.481005387565,0.761761909031,-1.8403677816,0.519900818932,0.417342136762,1.0118015616,-2.07146449969,-3.00481463995,-2.9652274241,-6.80860309569,8.73422732055,0.206626683476,10.6471849785,-0.390602433036,1.58247590543,-2.85313409341,-0.463306691174,-0.0781329081513,-0.840697761365,0.362390311137,-0.0916419575208,0.33632852588,-1.95072342336,-0.238508611406,-1.99276956521,-0.36569596922,-0.284777788648,0.652336376275,0.906591901631,1.87294517106,0.85637113509,0.71723085692,0.953420797034,-0.397771876038,0.484372328303,-0.374067991216,-0.0940100348544,-0.0902294706886,-0.186148167739,-0.104641607386,-0.228887707033,-0.147620640209,0.0620667023739,-0.116231397402,0.154271014355,0.0774334849519,0.186337274305,0.501006207747,1.22960029209,0.802958660712,0.537316051271,0.140463165802,-0.292637544798,-0.41655400783,0.056674533683,-0.198640825479,0.189952953879],[-36095.6628395,-475.054820708,-42.6763963033,-1976.21540748,-864.411559759,1673.80553357,948.494372908,531.656923449,-902.962038717,271.764507142,794.411116802,-61.7446353063,-822.85167821,-752.474505097,-134.847297702,42.685750749,-159.996212241,21.1008112825,-627.598789867,-443.147496915,-148.482252915,-107.412625282,143.310441465,-473.297524587,134.94379205,47.2544327698,-112.759139098,125.84122534,-51.63817318,188.278890661,-94.1729643496,-187.368750362,-21.4034006774,-11.9445603657,221.119135409,15.7674730109,18.1111372591,47.691307503,9.18149355878,-43.1033458176,-56.1748426523,-63.5641826708,-95.6971639666,-25.3299718585,-23.7562371457,18.4929720871,-19.3949200153,-28.4643947943,0.619633560482,6.07776860538,6.45269836753,-2.24832230073,-15.5406448543,-12.0107352107,-18.7468439394,2.15576735428,-26.7457627811,-15.6474102963,-2.00428854074,1.09114158261,17.4313295812,11.8779812042,20.1473979004,-0.501533793493,0.791257503316,-1.88394222138,0.461030097815,0.468920734731,1.00261869566,-2.06077439837,-2.99489024851,-2.84278489293,-6.72752849749,8.90868034736,0.204475002309,10.6756878572,-0.387271679385,1.61995809979,-2.84992228199,-0.45842063574,-0.0926115502925,-0.845158944211,0.343911213981,-0.123471802102,0.347206459438,-1.97233969276,-0.212526539098,-2.00919463259,-0.316969571965,-0.247340526679,0.702028625382,0.918463643776,1.89513701414,0.85812259709,0.742695399668,0.965206113297,-0.400195223135,0.482253352744,-0.376708389608,-0.0977915096853,-0.0878636046135,-0.194695180844,-0.115069308722,-0.227893152112,-0.153018180137,0.0700686994992,-0.121635546269,0.170755347004,0.0834590405938,0.201727961972,0.504853939721,1.2420821084,0.803998190679,0.547405420472,0.146079159385,-0.290223265638,-0.416271233816,0.0553735949781,-0.197065786028,0.191041975395],[-36077.3730613,-444.894469276,-44.4999128836,-1947.1335274,-848.064560129,1699.28560704,949.310979718,520.340452602,-915.779214161,271.587330886,778.516042793,-69.5187862835,-814.961312217,-754.262511059,-145.809091843,51.0550062082,-169.819150701,23.1216808876,-634.203308817,-435.963845449,-150.993736249,-107.324512308,137.411132514,-467.740613661,138.684759146,45.1904276117,-112.796802507,127.24118224,-51.7868644016,189.60852184,-94.0311438864,-188.013612594,-17.0334451724,-11.0057020848,223.104245476,16.8866812483,18.524283183,48.4922355946,9.46679282251,-43.5023495973,-56.3592179413,-64.0046870948,-95.2778535194,-23.9754488211,-23.8051384631,19.4923723821,-19.4069490953,-29.2340349905,0.832084253867,6.35356630391,6.48492638148,-2.18350246936,-15.4440371151,-12.1097896004,-18.8285848101,2.4166607918,-26.4759999642,-15.6024330075,-1.71569193549,1.11688043579,17.2196563307,11.9869867759,20.1537606051,-0.517162913173,0.814250768854,-1.93373730955,0.399848976816,0.533143903244,0.993214346581,-2.04854409462,-2.97654746483,-2.7217486614,-6.64946426703,9.07587295478,0.19765452544,10.7014335999,-0.380515193444,1.63967950063,-2.8628698481,-0.460931629698,-0.107024451916,-0.850219857144,0.322600969037,-0.15803763681,0.358594853642,-1.99444263058,-0.185324689401,-2.02912457312,-0.26834969163,-0.207990193833,0.750905907007,0.92589285697,1.91520498266,0.859350928862,0.765181423264,0.973204523612,-0.405455335526,0.480835372944,-0.377329893874,-0.101835961837,-0.0853644079599,-0.203033452658,-0.126810929835,-0.228260309769,-0.158713383972,0.0783019769081,-0.127518695935,0.186877242144,0.0899078099058,0.218241094402,0.508293877164,1.25492429425,0.805455303648,0.558394760581,0.151118750142,-0.289093192795,-0.416064439745,0.054176254172,-0.194681518787,0.192184237572],[-36052.8151029,-419.737800556,-31.7478343182,-1916.35764309,-830.431605232,1726.12187108,955.980429567,509.601736742,-931.101583461,270.896046353,760.42840982,-73.5377291183,-807.146803986,-753.910321494,-159.087028946,58.5457251168,-179.112081044,24.2917389596,-641.465841916,-428.614841323,-151.971770709,-107.04614464,130.997906148,-462.057356929,142.323826395,42.9699625194,-112.585534273,128.76249283,-51.7927326597,191.346942951,-93.5344683844,-188.686733565,-12.7901561768,-10.5507297747,225.429650775,18.1388084309,18.8767280511,49.4462574507,9.83957723303,-43.7005420297,-56.5437723367,-64.3486444791,-94.7422444305,-22.495019175,-24.0149394937,20.4807135052,-19.3102236458,-30.0444742588,1.05110626344,6.60875622208,6.50896694157,-2.10016952695,-15.3173182012,-12.1853141196,-18.8811354863,2.74812371415,-26.2009119677,-15.5733041598,-1.47444324023,1.13997878122,17.0060222613,12.1008172389,20.1200677823,-0.528268707034,0.830651484967,-1.98735907361,0.334211926696,0.611377205658,0.982146731101,-2.03195536599,-2.94825654795,-2.60143783223,-6.57373234879,9.23631412483,0.187706782294,10.7213776366,-0.368964083115,1.64107309988,-2.88971001454,-0.470494001632,-0.121040594961,-0.855527995042,0.298569970911,-0.195143598749,0.370565154611,-2.01746478375,-0.156524598945,-2.05166901495,-0.219520543933,-0.166547802432,0.799168467151,0.929665214001,1.93254366868,0.86068885299,0.783769749,0.978269714926,-0.413633821767,0.480354482656,-0.376529054087,-0.106008461567,-0.082603703641,-0.21126262921,-0.139715466025,-0.230018531275,-0.164872121914,0.0866074045298,-0.133836065082,0.20264320921,0.0967818960655,0.235843119562,0.511416106399,1.26803090826,0.807507140336,0.569934154624,0.1557193403,-0.289302250632,-0.41574658577,0.0528977068398,-0.191647060949,0.193380840779],[-36020.0343103,-396.274175958,-11.9787829797,-1886.3281792,-810.616829256,1753.4107681,965.194765423,499.151993958,-949.382374029,269.866663971,740.885061777,-73.9989060676,-799.624857172,-751.695751084,-173.826261351,65.2392330205,-187.868258903,24.6830793317,-649.044963744,-421.175810231,-151.366451418,-106.437932178,124.406635345,-456.375997187,145.898733771,40.5709927083,-112.129898783,130.440899271,-51.6749194813,193.523860621,-92.723413043,-189.329728027,-8.72460460845,-10.5939354064,227.944151017,19.5234798816,19.1602430933,50.5410576863,10.2864400769,-43.6927930414,-56.7109162166,-64.6026742408,-94.0912950686,-20.8976641573,-24.3925732935,21.4122099596,-19.1205122594,-30.9028949192,1.27190727143,6.84178724744,6.5272270786,-2.00995590114,-15.1548389082,-12.2337161467,-18.9002055923,3.1482740495,-25.9193717214,-15.5610310961,-1.28583310367,1.15805371329,16.7829394878,12.2207927878,20.0481693017,-0.535329312057,0.840007676942,-2.04266793857,0.26226251211,0.704922999082,0.968316649944,-2.00786030031,-2.90838359324,-2.48132719082,-6.49948001822,9.38966980298,0.176289393573,10.7318308402,-0.35116685483,1.62321790253,-2.92792350482,-0.487020017625,-0.134328304686,-0.860879186319,0.271822695086,-0.234675655352,0.383189888269,-2.04177527532,-0.12566831679,-2.07586094606,-0.170075157391,-0.122866466685,0.846863723976,0.930592757522,1.94634447494,0.862809207421,0.797390167955,0.98130330434,-0.424936054935,0.481031628178,-0.374836182276,-0.110149458012,-0.0794784562337,-0.219477088686,-0.153653554516,-0.233206347529,-0.171659631166,0.094871126241,-0.140546112803,0.218093722,0.104088257355,0.254497721815,0.51432334302,1.28126221362,0.810364564702,0.581606240059,0.160091841165,-0.290946341651,-0.415102558866,0.0513610002819,-0.188071664277,0.194621830847],[-35979.5152944,-375.033352456,9.3128126621,-1858.48761764,-788.770432246,1779.94483311,973.712573543,488.661669314,-970.732724484,268.580436843,720.34659649,-71.511390307,-792.652154908,-748.028204184,-189.374871821,71.2626095919,-196.081392754,24.3549993866,-656.7052473,-413.75865529,-149.194722955,-105.455057564,117.841428905,-450.920474506,149.431787671,38.0067476502,-111.423495768,132.302805303,-51.4537087659,196.143658142,-91.6542288274,-189.9225692,-4.90838745098,-11.1427831646,230.518001466,21.0348143319,19.3753686468,51.7717338543,10.8001405897,-43.4752756421,-56.8471002278,-64.7730020628,-93.3315389307,-19.2027371986,-24.9440459737,22.2404130049,-18.8524100549,-31.8220482738,1.48942514638,7.05185938407,6.54251037338,-1.92122558301,-14.9499819501,-12.2513078035,-18.8821627351,3.61516694727,-25.6321740548,-15.5666826132,-1.1572596083,1.1703830781,16.5408813523,12.3483319078,19.9390603901,-0.539020321316,0.841356494339,-2.09794120194,0.182758559269,0.814907888758,0.951336097703,-1.9731693305,-2.85534573,-2.3609329832,-6.42586240019,9.53451165595,0.164962924899,10.7284766977,-0.326044342298,1.58486478492,-2.9750592084,-0.510466704042,-0.146567516404,-0.866286736996,0.242258251782,-0.276554622974,0.396550142139,-2.06761053724,-0.0922589467844,-2.10070785708,-0.11956470209,-0.0768673534654,0.893808520548,0.929396614864,1.95561852799,0.866410721806,0.804889535956,0.983314411455,-0.439671746804,0.483103274273,-0.372735277319,-0.114087440009,-0.0759245510452,-0.227768244999,-0.168540910222,-0.237860160669,-0.179209199301,0.103012093528,-0.14759955488,0.233295264603,0.111824511855,0.274158100769,0.517106572126,1.2944337256,0.814255950194,0.592950503854,0.16450052298,-0.294146817174,-0.413914089704,0.0494357109315,-0.184017482089,0.19590484029],[-35933.5294854,-362.940214034,27.3699667425,-1832.90106787,-766.348742841,1804.42263416,978.243489586,477.430102281,-994.78724491,267.11305683,698.993850506,-67.1474582471,-786.600838418,-743.581076677,-205.281428244,76.8075775382,-203.70642172,23.377978018,-664.322766257,-406.509279466,-145.552022658,-104.147304908,111.398803007,-446.020686601,152.932171405,35.3301557893,-110.452115916,134.372358768,-51.1465156449,199.177334524,-90.3978369582,-190.477930447,-1.42973284272,-12.1993751718,233.043696876,22.6590704795,19.5316097788,53.1389033614,11.3784806683,-43.0449520546,-56.9430922637,-64.8657250124,-92.4743559707,-17.4382610142,-25.6736993462,22.9173317361,-18.5196809098,-32.8182442254,1.69804994811,7.2385036359,6.55775532736,-1.83870857342,-14.6953766567,-12.2346181021,-18.8236790602,4.14641228561,-25.3417495029,-15.5910004616,-1.0972663317,1.17787003314,16.2698839651,12.4853343851,19.7930102941,-0.540222307992,0.833212739726,-2.15194504128,0.0950348943056,0.942299708087,0.931560798088,-1.92502632684,-2.7877805698,-2.23970328746,-6.35201622876,9.66855330269,0.155140660758,10.7068365191,-0.292973203988,1.52460150463,-3.02884211223,-0.540754294572,-0.157427992906,-0.872005830922,0.20974155972,-0.320738034905,0.410709823254,-2.09507250513,-0.0558043039467,-2.12524395037,-0.0675516394101,-0.0285182983486,0.939640200654,0.926663842865,1.95930691823,0.872198980407,0.805147572677,0.985403272963,-0.458181095949,0.486816748008,-0.370676487239,-0.117633311612,-0.0719106212821,-0.236221911953,-0.184340757753,-0.244012657873,-0.187619996047,0.110962897067,-0.154926188034,0.248334122907,0.119968256609,0.294766220665,0.51982842952,1.3073346494,0.81939432218,0.603510280025,0.169235544236,-0.299023244178,-0.411976673628,0.0470481188753,-0.17951254475,0.197246624414],[-35884.8781675,-368.368379834,38.1496919617,-1808.73191242,-745.100380015,1825.46350663,975.834839274,464.570569991,-1020.93237566,265.585041331,676.841600477,-61.9968620528,-781.847414727,-739.058944351,-221.332033048,82.0677025589,-210.702035017,21.8328976034,-671.826311295,-399.598093779,-140.603049542,-102.609667731,105.101394222,-442.009803262,156.403877732,32.6024747892,-109.202609948,136.660669507,-50.779021999,202.576558142,-89.0279697958,-191.018830152,1.61929611719,-13.7549734773,235.426789075,24.3799014631,19.6405116783,54.6452408115,12.0188978087,-42.4045293375,-56.9914680256,-64.8902783098,-91.5328272912,-15.6357328323,-26.5817554524,23.4022682728,-18.1339956403,-33.9044770409,1.89249943698,7.40199879917,6.5761136051,-1.76487721202,-14.3846337801,-12.180858709,-18.7238267718,4.73957036616,-25.0517236471,-15.6337877252,-1.11383528748,1.18149290144,15.9605958642,12.6330284249,19.6100868914,-0.53993126479,0.814294333922,-2.20385397435,-0.00111546411605,1.08792766123,0.909824948865,-1.86131892794,-2.70444164957,-2.11744103741,-6.27699172275,9.7890900787,0.147917695546,10.6629621382,-0.251580872637,1.44127587743,-3.08712319318,-0.577738857181,-0.166613872429,-0.878390756046,0.174168687895,-0.367184499281,0.425799362187,-2.12414064095,-0.0159028468453,-2.14856250841,-0.0137514676826,0.0222331331677,0.98385786891,0.922921949003,1.95641192657,0.880764684824,0.797174825966,0.988541867947,-0.480746778187,0.492339617498,-0.369002744445,-0.120608727776,-0.0674298467973,-0.244910582586,-0.201031498015,-0.251668108809,-0.196952039713,0.118682583666,-0.162443356917,0.263305070815,0.128503816681,0.316225979846,0.522549213503,1.31973013065,0.825950900785,0.612873447144,0.174584607649,-0.305671122906,-0.409108028859,0.0441514208029,-0.174578874565,0.198648515248],[-35834.9118711,-387.784449209,41.5435842995,-1786.16305008,-724.175750925,1842.52243699,966.61140805,450.61334168,-1048.99112824,264.024251241,653.791401943,-56.3118315931,-778.2511695,-734.718919829,-236.945156175,87.1195535825,-217.264415033,19.7361167676,-679.07610673,-393.153070722,-134.387950265,-100.795933726,98.9626045573,-439.064914868,159.86242866,29.8182922093,-107.683872425,139.142370866,-50.4114125287,206.312376825,-87.5870869843,-191.552950424,4.21608663463,-15.7872014035,237.626073799,26.1936354027,19.7095003192,56.2903850148,12.7022506709,-41.5744515834,-56.9839202947,-64.8635515811,-90.5132092788,-13.8131304052,-27.6653045145,23.6821770755,-17.7095099561,-35.0833510376,2.0715961532,7.54648117734,6.60199256474,-1.70421232248,-14.0149378512,-12.0896421857,-18.5880339624,5.39301546356,-24.7651785579,-15.6937831889,-1.20761372669,1.18049578806,15.6085446743,12.7903454833,19.3915745517,-0.539132162343,0.785153531662,-2.25260640838,-0.105529338559,1.25269356848,0.886423111978,-1.78170738091,-2.60409910783,-1.99511265995,-6.19949508573,9.89412720987,0.143487080541,10.5948554567,-0.202671978678,1.33488221631,-3.14824813608,-0.621030641344,-0.174145798465,-0.885559979833,0.135567982112,-0.415571243011,0.442284596587,-2.15479577252,0.0277517633502,-2.16986526603,0.041593259374,0.0755825609602,1.02581429916,0.918641176394,1.94642621079,0.892274234801,0.780442638839,0.993288478524,-0.507521589873,0.499622743146,-0.367992713304,-0.122943207068,-0.062524971652,-0.253899106333,-0.218497821428,-0.260710111804,-0.207221473621,0.126247173322,-0.170096011284,0.278234753892,0.137466254478,0.338312902752,0.52538330334,1.33139352737,0.833987203792,0.620750060251,0.180694599746,-0.314113262145,-0.405229927415,0.0407057204519,-0.169251739861,0.200077998008],[-35783.8469556,-414.912713376,40.9045109229,-1765.64324453,-701.609318331,1856.02714538,952.002533477,436.692226121,-1078.85430465,262.582717886,629.94306614,-49.9554719263,-775.280992857,-730.670733298,-251.443866679,91.9571692377,-223.681808102,17.1404496149,-685.900536252,-387.193495458,-126.914412502,-98.6360442175,92.9900554166,-437.360925771,163.308389435,26.9317978475,-105.908464788,141.786398291,-50.096967969,210.371010557,-86.1005782208,-192.0732494,6.3560644755,-18.2505834709,239.622566585,28.0981652315,19.7388268957,58.0676950847,13.4018227512,-40.5793516511,-56.9110348917,-64.7980438133,-89.4161470722,-11.9816026954,-28.9133175503,23.7560987072,-17.2605638312,-36.3536317326,2.23709454006,7.67566047648,6.6387490981,-1.66371668657,-13.5854751118,-11.9613875912,-18.4224274133,6.10558316129,-24.4838794297,-15.7672708191,-1.37584832316,1.17537326127,15.2115643941,12.9564656797,19.1390574614,-0.538132874239,0.746999411384,-2.29743663232,-0.218349746397,1.4370473323,0.861326602308,-1.68648173526,-2.48574325737,-1.87335404264,-6.11766500006,9.98268481536,0.142325999015,10.5016874463,-0.147161995349,1.20602245692,-3.21061607851,-0.670038718061,-0.180027899461,-0.893384817477,0.0940670912058,-0.465593127598,0.46060556264,-2.18715488093,0.0753753076088,-2.18848467637,0.0982244550331,0.131757882446,1.06497484146,0.914374410679,1.92914960169,0.906839496592,0.754700191314,1.00015922322,-0.538584782908,0.508544192585,-0.367903092311,-0.124592188919,-0.0571875364086,-0.26321935759,-0.23658904062,-0.270971119131,-0.218476811878,0.13375570105,-0.177863957527,0.293123820628,0.146878833098,0.360798658199,0.528499774815,1.34215107956,0.843575273911,0.626921009124,0.187707552539,-0.324317455351,-0.400298841268,0.036708085468,-0.163557745035,0.201503962577],[-35732.7651073,-445.049424505,41.3256432387,-1747.50039551,-675.83930285,1866.93491135,933.708015996,424.164021164,-1110.33660436,261.432906809,605.586609739,-42.6633936558,-772.236429487,-726.994997513,-264.283658255,96.5373811466,-230.267449361,14.1526151388,-692.159413953,-381.662891632,-118.215384034,-96.0654177335,87.2150659005,-437.086690422,166.730012443,23.8791098996,-103.881192793,144.551783639,-49.875117727,214.746650966,-84.5809361421,-192.554508084,8.030372108,-21.0723354821,241.40269538,30.0891326996,19.7239620598,59.9677582891,14.0883105202,-39.4454835694,-56.7616130054,-64.7009209768,-88.2351629731,-10.1491013431,-30.302262308,23.630301781,-16.7986559538,-37.7100555066,2.3920444879,7.79276917512,6.68836574047,-1.65126852552,-13.0962940502,-11.7962132033,-18.2324625854,6.87741075036,-24.2082142572,-15.8474715173,-1.614111927,1.16788685103,14.7696339387,13.1310820428,18.8547409607,-0.53673546052,0.701261460326,-2.33808120495,-0.339883834212,1.64119911486,0.834488484841,-1.57610777525,-2.34847744498,-1.75218788384,-6.02898470911,10.0547595374,0.145419522395,10.3837338131,-0.085585110675,1.05574570042,-3.27255279367,-0.723939944994,-0.184180360656,-0.901641683123,0.0498238008683,-0.517029638118,0.481126417099,-2.22148517371,0.127106693403,-2.20387221283,0.156054799932,0.191047143744,1.10103612274,0.910816291525,1.90470748001,0.924604920885,0.719972714129,1.00970089047,-0.573881486182,0.518957016601,-0.368904398446,-0.125504777603,-0.0513638631834,-0.27288256479,-0.255157633899,-0.282280258038,-0.230816403624,0.141312376155,-0.185773945177,0.307995236769,0.156738813743,0.383505608316,0.532112411644,1.35192181512,0.854820557106,0.631256608667,0.195808514075,-0.336203810942,-0.394278770641,0.0321913049493,-0.157526936572,0.202892058494],[-35682.349927,-478.744600099,46.0440796843,-1730.86328386,-646.503484239,1876.28303817,912.826761776,414.262049097,-1142.83915156,260.873920367,581.154403732,-34.5705125088,-768.441476753,-724.248122131,-275.070666207,100.8577342,-237.247697667,10.9347572553,-697.818883621,-376.473901767,-108.467792384,-93.049716141,81.6536014684,-438.499013598,170.102033835,20.6219944553,-101.59003142,147.400439096,-49.7720311214,219.403062055,-83.0456615512,-192.994770581,9.21132041416,-24.1691781272,242.957841146,32.1527916472,19.6647464354,61.980497568,14.7414867966,-38.2011837799,-56.5275618051,-64.5768764223,-86.9692162096,-8.32856840864,-31.8048114975,23.3065607096,-16.3387069219,-39.1498793492,2.53842413035,7.9005388424,6.751077688,-1.6719121833,-12.5477698192,-11.5922243067,-18.0232203803,7.70794378095,-23.9398500998,-15.9284428493,-1.91941848763,1.15857782542,14.2834815782,13.3144389531,18.5413764767,-0.534692958308,0.64873247278,-2.37492969713,-0.469877330034,1.86524235453,0.806861774806,-1.45115558347,-2.19173778749,-1.63131965436,-5.93128418883,10.1103891926,0.153298341787,10.2413411687,-0.0188444848791,0.884880598506,-3.33256880471,-0.781808582508,-0.186435372681,-0.910298304177,0.00298018123657,-0.569756262396,0.504131039098,-2.2579494666,0.183054769059,-2.21543726687,0.215222481769,0.25366503934,1.13369345254,0.908497023772,1.87319795887,0.945586138661,0.676292758052,1.02256203296,-0.613349566321,0.530740445211,-0.371185297899,-0.125585314759,-0.0450030204698,-0.282885458614,-0.274129292555,-0.294474258683,-0.244338911646,0.149039716794,-0.193823182201,0.322920020557,0.167030937587,0.40627644935,0.536434227651,1.3606515994,0.867811412547,0.633621138026,0.205187263988,-0.349717395742,-0.387169190451,0.0272044414888,-0.151207164261,0.204220283028],[-35632.8691871,-515.567745623,55.0269710615,-1714.93194233,-613.396862786,1884.92882088,890.865287222,408.165551256,-1175.75922911,261.195191191,557.113348796,-25.9073963176,-763.306677963,-723.275887912,-283.510354479,104.888215211,-244.875850361,7.66888981791,-702.918278032,-371.542578578,-97.9159502304,-89.5897575166,76.3447167532,-441.913084256,173.390528628,17.1068459536,-99.0112442156,150.281214566,-49.8126317812,224.284238972,-81.5304377994,-193.395204686,9.8472519135,-27.4448269444,244.283185606,34.271377935,19.5591921569,64.0932346533,15.34113319,-36.8790638384,-56.2047715259,-64.4333760529,-85.6172207231,-6.54164027369,-33.3865822329,22.7807581731,-15.8975799103,-40.6730430105,2.67927018889,8.00150659709,6.82571602452,-1.73055803244,-11.941155753,-11.3474200356,-17.8005931143,8.59628277024,-23.6832171982,-16.003390595,-2.29094614096,1.14792314202,13.7543522633,13.5077414982,18.2017795706,-0.531264524283,0.590262456561,-2.40884240341,-0.607805745118,2.10918567445,0.779649553115,-1.31258352962,-2.01554672376,-1.51067457194,-5.82238884442,10.149109977,0.166557483675,10.0747053698,0.0521296337887,0.693960296691,-3.38925995705,-0.842707889559,-0.186549600328,-0.91926536244,-0.0462824900081,-0.623639883778,0.529864609691,-2.29672335122,0.243264757882,-2.22270545853,0.275932089222,0.319776812963,1.16246225074,0.907942929108,1.83458030195,0.96985316328,0.623666112806,1.03955252072,-0.656915715048,0.543814539063,-0.374952316131,-0.124726338155,-0.0380242749945,-0.293204022969,-0.293438447922,-0.307371239093,-0.259147381227,0.157087399693,-0.202023406735,0.337983228217,0.177708812598,0.428918657792,0.541703451211,1.36825449713,0.882670501755,0.633856699218,0.216066190412,-0.364813727916,-0.378993560755,0.0218210066953,-0.144653060828,0.20548721737],[-35584.7838848,-553.119618562,64.4217157964,-1699.44311722,-576.393092462,1892.76482331,870.079119103,406.910159672,-1208.50899187,262.540129717,533.881329814,-16.7157368767,-756.294512667,-724.956903508,-289.430746693,108.565543831,-253.462386172,4.54313102176,-707.547682507,-366.823607636,-86.8499305214,-85.7359230519,71.3441646316,-447.653262948,176.558995176,13.2563523192,-96.1151927458,153.11871137,-50.0355248061,229.333985865,-80.0862695603,-193.740189183,9.86223910056,-30.7844123935,245.370252183,36.4256756533,19.4018646033,66.2896815638,15.8628617312,-35.5153823357,-55.7894478449,-64.2820976585,-84.1752105167,-4.81951927836,-35.0050648244,22.0473580129,-15.4935182267,-42.2773927814,2.81851031341,8.09817108632,6.9102306592,-1.83279797172,-11.2793250402,-11.0597500806,-17.5717441665,9.54206364636,-23.4455865659,-16.0634927648,-2.7295955401,1.13584427445,13.1842720505,13.7125619515,17.8385068246,-0.525113369709,0.527218928895,-2.44102860222,-0.752878748524,2.37302204145,0.754066347491,-1.16176327303,-1.82022180482,-1.39060213418,-5.70006723404,10.1700297207,0.185813476712,9.884356717,0.126684384616,0.483467596752,-3.44118213984,-0.905777969077,-0.184182392224,-0.928306889983,-0.0976809224313,-0.678478463837,0.55856133714,-2.33802813389,0.307684967143,-2.22536461237,0.338379756763,0.38949844772,1.18669326981,0.909734176365,1.78877591065,0.99752082763,0.562097185998,1.06152578104,-0.704486252855,0.558093382923,-0.380361810541,-0.12281244839,-0.0303211609836,-0.303780906496,-0.312989793357,-0.320773618598,-0.275364412678,0.165626654624,-0.210404022423,0.353271880388,0.188704640502,0.451189780101,0.548187852162,1.37461772533,0.899541803076,0.63181338487,0.228705079771,-0.381445671022,-0.369786809875,0.0161350561565,-0.137925567782,0.206689997308],[-35536.5346539,-587.218790069,66.7824847666,-1684.02008144,-535.173157521,1898.88184675,853.921240415,411.560968054,-1240.4409242,265.047911414,511.909910349,-6.72157737065,-746.900651405,-730.142477657,-292.709970536,111.81686443,-263.323816807,1.76756496591,-711.800979429,-362.268222002,-75.5651340845,-81.5311754868,66.7244577233,-456.035223214,179.564065679,8.97673504427,-92.863172359,155.823925257,-50.4811325808,234.508554251,-78.764510505,-193.999647107,9.17313116296,-34.0583148085,246.217211816,38.593342303,19.1850379133,68.5501108917,16.2797603043,-34.147465182,-55.2770814057,-64.1330499143,-82.6369789546,-3.19595576656,-36.6102191824,21.1033837761,-15.1473576579,-43.9575170241,2.96067941394,8.19296201847,7.00123411702,-1.98499861491,-10.5667604228,-10.7269406063,-17.3437946496,10.5452553187,-23.2351372428,-16.0985369452,-3.23603446975,1.12120977597,12.5774456719,13.930705968,17.4542429895,-0.514309267014,0.461393454917,-2.47306781479,-0.904044581939,2.65654501587,0.731308566108,-1.00048040963,-1.606496049,-1.27145242919,-5.56221186472,10.1725142412,0.211453107875,9.67174205789,0.204038034575,0.25400317326,-3.48696324844,-0.97022588851,-0.178927290787,-0.937010682982,-0.150844335991,-0.733959813245,0.590365050058,-2.38211779675,0.376121192322,-2.22328694721,0.402802783383,0.462823249399,1.20570551843,0.914365982468,1.73582419101,1.02859549755,0.491689849734,1.08933485782,-0.755935112216,0.573498810629,-0.387540559835,-0.119731519752,-0.021762318796,-0.314519769232,-0.332642387407,-0.334477678486,-0.293119003188,0.174830627421,-0.218996455009,0.368855510572,0.199913477067,0.472818281158,0.556147267684,1.37964977835,0.91853183298,0.627381963083,0.243356424232,-0.399561294868,-0.359615454628,0.0102643813273,-0.131097496954,0.207830935628],[-35486.8622763,-613.223963717,54.4497247814,-1668.62297693,-490.322648907,1901.92154521,845.761443745,423.454817943,-1270.92152345,268.529524648,491.6902477,4.42784331749,-734.621472987,-739.371732342,-293.344377641,114.618252536,-274.77214738,-0.451785156766,-715.826256811,-357.825877747,-64.343181646,-76.9984637827,62.5663135534,-467.254844527,182.385893395,4.1878124241,-89.2203576594,158.282551375,-51.1789610619,239.774704105,-77.6117735989,-194.127386461,7.69906461899,-37.1368158595,246.817623695,40.7572100812,18.9051005907,70.8537397452,16.563519697,-32.8082726874,-54.6674353166,-63.9944803633,-80.9964382606,-1.70586302863,-38.1477834737,19.9522798758,-14.8775636343,-45.7032422019,3.1105002401,8.29020824645,7.0947924663,-2.19264817951,-9.8091849624,-10.3491098732,-17.1230548146,11.6052097938,-23.0604519248,-16.0976959897,-3.81069469153,1.10213008245,11.9391554462,14.1630527769,17.0523315696,-0.496908117248,0.395462538908,-2.50669248674,-1.05970567479,2.95913919112,0.712023063423,-0.830425602259,-1.3757244448,-1.15378451242,-5.40711658515,10.1561416307,0.243950097184,9.43926202743,0.283764074317,0.00674038891001,-3.52520778545,-1.03547161373,-0.17050188397,-0.94480002583,-0.205366191394,-0.789556737826,0.625333513129,-2.42923649965,0.448287258301,-2.21661346528,0.46941435576,0.539592046682,1.2188774874,0.922347822357,1.67593471929,1.06302116275,0.412773898962,1.12365170636,-0.811021407605,0.589940233945,-0.396520241379,-0.115446215362,-0.0122345951324,-0.325310945308,-0.352176492963,-0.348301685012,-0.312486351656,0.184860544078,-0.227850985301,0.384815318922,0.21120910063,0.493535312979,0.565814227611,1.38329720486,0.939712406109,0.620538613538,0.260255105307,-0.419074649335,-0.348552558297,0.0043168915984,-0.124248506292,0.208896703303],[-35436.5232013,-628.374911103,25.8338830441,-1654.76598498,-443.606212367,1900.6102337,846.757646634,442.311439447,-1299.82501105,272.605401124,473.311222666,16.8947459268,-719.396488065,-752.300408599,-291.810887912,116.928038464,-288.003820789,-2.070556606,-719.769556438,-353.51691397,-53.3179416377,-72.2464086789,58.9113503757,-481.213095436,185.041130067,-1.14791959331,-85.2009036942,160.400031561,-52.1325050885,245.127150681,-76.6772978895,-194.062531948,5.40298533849,-39.9222914337,247.134608164,42.9135311167,18.5566767891,73.1836818514,16.696554235,-31.5176087995,-53.9651613549,-63.8750738834,-79.2494939557,-0.378725579995,-39.5740272657,18.6017989822,-14.6915063445,-47.502497567,3.2728395621,8.39256983629,7.19008768684,-2.45791809016,-9.01325759648,-9.93180479352,-16.9145534777,12.7205978095,-22.9306028837,-16.0525901507,-4.45456760388,1.07781604892,11.2718076845,14.4087847106,16.6379041002,-0.471550925798,0.332075032516,-2.54279896509,-1.21876267327,3.27915530194,0.695787628529,-0.653018396689,-1.12947244303,-1.0395222768,-5.23388248601,10.1203707695,0.284405786784,9.18944242384,0.366456645751,-0.255576942798,-3.55469723881,-1.10128523204,-0.158857429936,-0.951150665656,-0.26075309205,-0.844964340656,0.663304816884,-2.47954646747,0.523718538597,-2.20568995942,0.537938496768,0.619700130582,1.22580598708,0.934325190454,1.60941765592,1.10078149266,0.326129267296,1.16454994881,-0.869358155926,0.607293842332,-0.407213252507,-0.11001821546,-0.00164124653763,-0.33609470006,-0.37139277698,-0.362129438293,-0.333424413948,0.195794932722,-0.237012201853,0.401220608442,0.222564520518,0.51311694908,0.577348837714,1.38554567702,0.963099908994,0.611391232424,0.279519082312,-0.439856457944,-0.336626568723,-0.00168660588488,-0.117445070974,0.209842660572],[-35386.8031405,-633.992279626,-11.9731048911,-1644.7597865,-397.700008258,1895.14079945,855.373153102,466.37764015,-1327.44943073,276.933602014,456.383438147,30.3022593362,-701.547605687,-768.046437319,-288.774161776,118.699364717,-303.017998249,-3.26361787097,-723.773580426,-349.348735071,-42.4609469013,-67.3958717968,55.7462699433,-497.51858211,187.572448658,-7.00668235042,-80.880980788,162.13529312,-53.2948388202,250.569949201,-75.9902442131,-193.764205145,2.33621395567,-42.3713265875,247.125782781,45.0669539576,18.1371855703,75.5259968184,16.6795075833,-30.2815409827,-53.181620755,-63.7779887823,-77.398634946,0.774906912964,-40.866940288,17.0626942185,-14.5883940668,-49.3477106537,3.45229770993,8.50032298672,7.28982780521,-2.777944169,-8.18656035156,-9.48518787312,-16.7204733097,13.8879627736,-22.8523096233,-15.9611899166,-5.16666562671,1.04845510769,10.5756332425,14.665697188,16.2183038667,-0.437797188178,0.27297793022,-2.5809640573,-1.38058353683,3.61352673964,0.68161122626,-0.469653902167,-0.869520342634,-0.931494411972,-5.04308101562,10.0651395774,0.333824913093,8.92463443848,0.45273581922,-0.528589639897,-3.57482475785,-1.16759216162,-0.144245112222,-0.955767704117,-0.316374874676,-0.900133042336,0.703795591764,-2.53293832645,0.601725200841,-2.19085109198,0.607539648502,0.703063531192,1.22644561752,0.950693926376,1.53678873521,1.14173047537,0.233150823125,1.2115270619,-0.930401541122,0.625434936538,-0.419543265933,-0.103594024276,0.0100776122672,-0.346870627133,-0.390163698702,-0.375887705027,-0.355723637562,0.207591765217,-0.246446724597,0.418067300698,0.234067106251,0.531415541906,0.590746342691,1.3864575683,0.988583003941,0.600204226915,0.301049412478,-0.461723614473,-0.323865508323,-0.00780663790236,-0.110735516945,0.210639425835],[-35337.953247,-633.34092178,-53.2818476296,-1639.89782441,-355.378039614,1885.89180893,869.325005342,493.798586267,-1353.93798179,281.213430443,440.287220412,44.0539742113,-681.596752114,-785.857843886,-284.891489578,119.931392914,-319.659180013,-4.27331321105,-727.978067172,-345.323960778,-31.7095511323,-62.5325799774,53.0564696581,-515.66179779,190.028514833,-13.3173085332,-76.3522407509,163.47648561,-54.5973507376,256.099286484,-75.5543097812,-193.216705124,-1.40036761374,-44.4681141802,246.771996167,47.2194215378,17.6512471738,77.8682591858,16.5220735421,-29.1023048636,-52.3310222733,-63.7027402095,-75.451227044,1.75744137669,-42.0129932331,15.3523018251,-14.5663813995,-51.2341017429,3.65184243227,8.61380522338,7.39708133642,-3.14616622807,-7.33810491857,-9.02011540268,-16.5414471234,15.1016906268,-22.8288269821,-15.8250214116,-5.94209512641,1.01307633139,9.85253173256,14.9306421703,15.8017590212,-0.395830285371,0.219590247409,-2.62044010898,-1.54414041776,3.95849598245,0.668707042427,-0.282054778078,-0.598093349215,-0.832184750337,-4.83664445135,9.99132650695,0.392148242369,8.6476096221,0.542464893944,-0.807554373402,-3.58552994474,-1.23436067449,-0.12707380839,-0.958525743398,-0.371536859229,-0.954903228764,0.746244081125,-2.58905134257,0.681427410652,-2.17245076298,0.677184461912,0.789383868392,1.2209841842,0.971388863808,1.4588020793,1.18542527073,0.135544348159,1.26386222505,-0.99345407278,0.644255905515,-0.433418347814,-0.0963702556189,0.0229035518061,-0.357643315051,-0.40836491937,-0.389490160248,-0.3790657542,0.220132567248,-0.256042938988,0.435276725087,0.245810196994,0.548310978975,0.605841446972,1.38614340836,1.01589225555,0.587330133328,0.324601094594,-0.484438660264,-0.310360551322,-0.0141032166367,-0.10417433159,0.211286036383],[-35289.4714052,-634.127314527,-92.6422199921,-1639.48845344,-320.140316274,1873.42363237,884.738251076,523.627828757,-1378.73808052,285.102594947,424.592270443,57.1909776629,-659.763190505,-805.331851327,-280.689689792,120.747054899,-337.583722125,-5.2784260364,-732.553456539,-341.361043188,-21.1651329191,-57.6499556709,50.7352610079,-535.045009906,192.460364072,-19.9427539603,-71.696535325,164.4244912,-55.9482580488,261.66755022,-75.3265768737,-192.442876799,-5.67930430129,-46.2191400845,246.07015909,49.3645604286,17.1170219401,80.1952427729,16.2442491274,-27.9761972371,-51.4307231009,-63.6381224113,-73.4292357662,2.58373683815,-43.0094390951,13.5014183032,-14.6258172239,-53.1527450328,3.87086180355,8.73425281842,7.5135536705,-3.55157451795,-6.47825905193,-8.54644848619,-16.375404855,16.3511216066,-22.8568867623,-15.6501366772,-6.7704509478,0.966937804583,9.10601936246,15.1982802887,15.3958039271,-0.346614287394,0.173138695631,-2.66077044199,-1.70745234644,4.30972924505,0.656958884346,-0.0919694028544,-0.318138845463,-0.742531939616,-4.61850235881,9.90109678655,0.457323720718,8.36195240902,0.634695584557,-1.08756533248,-3.58685884845,-1.30164466879,-0.107898781386,-0.959491677266,-0.425567064773,-1.00889893825,0.790033090778,-2.6471010206,0.76179112349,-2.15084317024,0.745974797154,0.877820066991,1.21004042769,0.995625677038,1.37657208839,1.23094509804,0.0351169911339,1.32056074884,-1.05770503908,0.663538733301,-0.448630609953,-0.0885708077811,0.0366935965258,-0.368389273248,-0.425849131225,-0.402821590738,-0.403039298065,0.233229233495,-0.265600064195,0.452725165246,0.257826679944,0.563756150787,0.622252823457,1.38475962134,1.04451712456,0.573161869102,0.349806950112,-0.507711863077,-0.296261012516,-0.0206164879974,-0.0978169229975,0.211776693742],[-35239.6640901,-639.602061273,-126.00099694,-1643.00162959,-293.618549801,1858.2137535,899.004418851,555.441896577,-1401.39185252,288.449065335,409.015267644,69.2414291476,-636.100301554,-826.046328953,-276.519843767,121.199536113,-356.437014982,-6.41928147321,-737.509716025,-337.305385124,-10.8645445006,-52.6854926691,48.6866134866,-555.040296746,194.890234545,-26.7737987639,-66.9835440087,165.004049615,-57.2520707822,267.253263072,-75.2325445166,-191.457816927,-10.3461618992,-47.6295550299,245.036741002,51.4931760993,16.5421911733,82.4878489149,15.864555984,-26.8979712321,-50.4887176438,-63.5639301581,-71.3495864038,3.28029362192,-43.8541930575,11.5506397204,-14.7689506551,-55.0920361115,4.1095699537,8.8601625306,7.6396517571,-3.98608409773,-5.61908355756,-8.07191279155,-16.218929459,17.6257360692,-22.9277379172,-15.44274341,-7.63615863555,0.904464072522,8.34161799609,15.4627744238,15.0072591028,-0.29037586234,0.134857185032,-2.70155845756,-1.86948816114,4.66240971065,0.645874502223,0.0984032312311,-0.0324059252852,-0.662228107271,-4.39284548376,9.79808999064,0.526528092736,8.07191182299,0.728055800972,-1.36368385575,-3.57897069975,-1.36936154021,-0.0871591494281,-0.958467901592,-0.477805860323,-1.06185687618,0.834502248214,-2.70641704383,0.841557939465,-2.1263608486,0.813122653724,0.967399575895,1.19461709776,1.02233853939,1.29154684895,1.27719829424,-0.0662598749368,1.3805555214,-1.12227657022,0.683019529845,-0.464929680493,-0.0804306172751,0.0513555854916,-0.37905235238,-0.44244147467,-0.415721710407,-0.427304437934,0.246638889272,-0.274921695587,0.470205687745,0.270146892607,0.577760786216,0.639530261349,1.38252260797,1.07384971438,0.558113887513,0.376243996454,-0.531210672147,-0.281751743946,-0.0273472306426,-0.0917172488299,0.212110306499],[-35186.7900783,-649.606881596,-151.774287627,-1650.73473364,-275.801694087,1840.27107112,911.514856147,588.858063101,-1421.74431746,291.231148493,393.32101445,80.240789869,-610.75402769,-847.55300223,-272.671241576,121.260963169,-375.911318276,-7.81938872422,-742.712491436,-332.962787788,-0.730367320096,-47.5812989421,46.8663112911,-575.062971901,197.308816642,-33.7455386544,-62.2673658778,165.255436372,-58.4200600991,272.872579986,-75.1871803833,-190.266138278,-15.2327965847,-48.6933304739,243.703185769,53.5964708825,15.9219355928,84.7263901108,15.3966677473,-25.8618538633,-49.5054241086,-63.4538113819,-69.2212697502,3.87964869254,-44.5413637082,9.54164395436,-14.9991619603,-57.041365886,4.36989346941,8.98773850117,7.77461965334,-4.44551687355,-4.77338429711,-7.60216745768,-16.067778143,18.9159687188,-23.0294968826,-15.2083788185,-8.52119495857,0.820923915747,7.56624532738,15.7191889804,14.6424955472,-0.226402757264,0.106035309916,-2.74232182957,-2.03025227804,5.01158615153,0.634353550381,0.286415267286,0.256533777958,-0.590234439122,-4.1637137461,9.68690978562,0.596815851772,7.78179032709,0.820953541595,-1.6312498847,-3.56217596529,-1.437162307,-0.0651645553056,-0.954949565222,-0.527632474268,-1.11362220084,0.878986884738,-2.76656432675,0.919308772067,-2.09933815503,0.877944525132,1.05709165889,1.17589121883,1.0503458474,1.20525475713,1.32307469094,-0.166754837967,1.44287683478,-1.18625907445,0.702480487635,-0.482070027809,-0.0721943285757,0.0668698608226,-0.389553327064,-0.457945883357,-0.427998510098,-0.451614074304,0.260095591821,-0.283832676518,0.487436232951,0.282792444919,0.590359333646,0.657198260754,1.37966825073,1.1032586518,0.542572388037,0.403478371118,-0.554590851664,-0.26703395575,-0.0342473226486,-0.085933206652,0.212304488817],[-35130.4734148,-661.806546462,-169.376933203,-1664.03872549,-265.696236475,1819.31935719,922.967066216,623.620569286,-1440.02681925,293.442946463,377.375598949,90.4785159655,-583.926877531,-869.414917974,-269.411877249,120.824058343,-395.758731443,-9.55359835907,-747.949588193,-328.085519626,9.37909233689,-42.286418687,45.2669088664,-594.585579133,199.672254433,-40.8310217673,-57.5849526853,165.222353261,-59.3592189664,278.562205997,-75.0973355663,-188.868216913,-20.1737074471,-49.3966149769,242.105803527,55.6658204017,15.2379729949,86.8922982553,14.8486450369,-24.8583801123,-48.4790844663,-63.2743218871,-67.0499238971,4.41607872689,-45.0626562122,7.51328294017,-15.3190995985,-58.9923209307,4.65515188666,9.11046710451,7.91598053918,-4.92916767174,-3.95419817746,-7.14218492455,-15.9160419561,20.2119583397,-23.1478474048,-14.9528021418,-9.40714652447,0.712491903967,6.78671700496,15.9633278034,14.3069309856,-0.152939049566,0.0877917724288,-2.78261476078,-2.19084023284,5.35210640232,0.620525313965,0.469351966235,0.54590652815,-0.52476587227,-3.93539749932,9.57260519504,0.665180377571,7.49549336468,0.911750904654,-1.88616016834,-3.5368874255,-1.50456348802,-0.042011059005,-0.948183918302,-0.574507282926,-1.16417907891,0.922800738923,-2.82737449712,0.993489750553,-2.07019708752,0.939917529088,1.14569777495,1.15514285368,1.07832049576,1.11912856154,1.36746870172,-0.26472344718,1.50663874401,-1.24876362132,0.721751094944,-0.499806730765,-0.0641105999207,0.0832983754498,-0.399795732852,-0.472164152649,-0.439459589098,-0.475811739044,0.273299265568,-0.292190488336,0.504087447464,0.295750609763,0.601614482095,0.674729112089,1.37642061653,1.13209717227,0.5268560652,0.431081731484,-0.57753415554,-0.252312847349,-0.0412442297603,-0.0805222185246,0.212387957323],[-35072.2758093,-672.663060091,-179.234716503,-1684.73097971,-262.154701353,1794.84308324,934.260074835,659.033561568,-1456.73949162,294.923141392,361.196832733,100.128555059,-556.093136064,-891.298035203,-267.188183542,119.740692541,-415.776108512,-11.6168562052,-753.014438326,-322.398587092,19.5973411078,-36.8136583525,43.9119184517,-613.227549822,201.909966092,-48.0218053571,-52.9476700049,164.940886196,-59.9571491689,284.348981983,-74.883292442,-187.266011038,-25.0543515646,-49.7238264896,240.264800718,57.6911919914,14.4650053931,88.9691628426,14.2256583783,-23.8710928074,-47.4133390904,-62.9883661997,-64.842042698,4.9131368935,-45.4066571826,5.49067411042,-15.7268943364,-60.9442811948,4.96942756909,9.22014814115,8.05872420773,-5.4379051818,-3.17417657016,-6.69762945482,-15.7551867545,21.5017953343,-23.2675495187,-14.6821337787,-10.2793787161,0.577162285286,6.00654288527,16.1916644508,14.0038876503,-0.0674488228164,0.0807844107511,-2.82242511563,-2.35298685845,5.67844994603,0.601994706199,0.644930508123,0.832122605588,-0.463161669793,-3.71265862827,9.45952148735,0.728830261809,7.21543731322,0.999032925946,-2.12566288843,-3.50330789892,-1.57132869549,-0.0176186378123,-0.937346491062,-0.618028128751,-1.21361609123,0.965131187043,-2.88877869909,1.0624798023,-2.03952829573,0.998811264908,1.23174013034,1.13367302447,1.10479612568,1.0342459159,1.40940080844,-0.359000329453,1.57116454057,-1.30908481942,0.740730163035,-0.517966690216,-0.0564185415536,0.100750806616,-0.40965512612,-0.484921468214,-0.449937179039,-0.499786118461,0.285891877387,-0.299873055027,0.519828342735,0.308930554802,0.611655882787,0.691512641685,1.37295394612,1.15972482384,0.511124816013,0.458676008517,-0.599837055214,-0.23777794003,-0.048306239997,-0.0755287537545,0.212385142692],[-35012.2687343,-675.107358446,-183.461846738,-1714.49322167,-262.970197988,1766.16090383,946.992139394,693.938502025,-1472.56384431,295.569301771,344.912399193,109.466311779,-527.894600861,-912.825914932,-266.414045554,117.823095999,-435.790922599,-13.9364486646,-757.673200249,-315.606545735,30.1075170333,-31.2175922843,42.8844869689,-630.735966251,203.926295041,-55.3265403164,-48.34786695,164.448173596,-60.0894525414,290.260936294,-74.4778802708,-185.44275302,-29.7984147866,-49.6466493784,238.198602924,59.6630009027,13.5729627482,90.9405401378,13.5311992555,-22.8797374753,-46.3163834038,-62.5566306478,-62.6004495214,5.38700747177,-45.5552624739,3.49047696502,-16.2162640892,-62.9009754212,5.31852520363,9.30773909624,8.19532427928,-5.97414723564,-2.44650602265,-6.2751536416,-15.5754912232,22.7722976777,-23.3730438352,-14.4003554489,-11.1255001344,0.416397350157,5.22831854708,16.4018458491,13.735604306,0.0333558872562,0.0855618115267,-2.86198498367,-2.51873794355,5.98449189686,0.575985288866,0.81080639044,1.11077284908,-0.402238727739,-3.50020109104,9.35163091653,0.785757748046,6.94345110406,1.08170403834,-2.34752314458,-3.46142485039,-1.63720056287,0.00817685994204,-0.921434239745,-0.65784220304,-1.2619654503,1.00508528316,-2.95074349513,1.12451578649,-2.00811983688,1.05451325919,1.313515244,1.11276117203,1.12831780647,0.951545369115,1.44809922139,-0.448618556924,1.63602435212,-1.3665704245,0.759377027697,-0.536438746815,-0.0493875573927,0.119373083142,-0.418964810516,-0.496034302175,-0.459246647975,-0.52342588625,0.297467628276,-0.306773087581,0.534278819524,0.322162883092,0.62063400755,0.706896538522,1.36942097141,1.18553955793,0.495463236124,0.485926932491,-0.621322442111,-0.223616237613,-0.055392937158,-0.0709817221712,0.212335692416],[-34948.1675884,-664.167655775,-184.218559537,-1753.56535169,-265.771878912,1733.28566246,962.57386452,727.65836365,-1488.0362482,295.526856043,328.826966797,118.612620796,-499.866951469,-933.790415626,-267.406914949,114.892967521,-455.531433344,-16.3828663794,-761.711092432,-307.358843436,41.0775867354,-25.5237556917,42.309613146,-646.8992536,205.602388592,-62.73967285,-43.777297933,163.792034375,-59.6149160998,296.31307759,-73.7988341669,-183.378037702,-34.3353927871,-49.1304618934,235.936699845,61.5672891677,12.5283094727,92.7867343264,12.7721503368,-21.8637760819,-45.200078913,-61.9338850986,-60.3275419738,5.85446502381,-45.485543842,1.5287362216,-16.7768901407,-64.8641906142,5.7089452918,9.36264594881,8.3156961548,-6.53970782427,-1.78575974292,-5.88166202633,-15.3662231161,24.0088543881,-23.4477272277,-14.1104856835,-11.9324923921,0.234330972248,4.45742637242,16.5929676454,13.5048528396,0.153368316776,0.102488111752,-2.90155751663,-2.6902300158,6.26335949478,0.539777991023,0.964070008261,1.37676352329,-0.338490125337,-3.30306740411,9.25310080093,0.834520521673,6.68196111564,1.15907157638,-2.54917927398,-3.41123519213,-1.70155098691,0.0356579213236,-0.899257424058,-0.693500762457,-1.30920569026,1.04172740414,-3.01321456002,1.17756201743,-1.97687942542,1.10684034019,1.38907517783,1.09365945003,1.14740504422,0.872076891861,1.4829689995,-0.53242183907,1.70092379501,-1.4203465987,0.777731213719,-0.555033633302,-0.043319788831,0.13935752596,-0.427503112365,-0.505306904659,-0.467160575791,-0.5465969863,0.307567679235,-0.312771797798,0.546978941749,0.335209629344,0.628664931137,0.720176111667,1.36597114074,1.20895367932,0.479991142695,0.512508520161,-0.641735158362,-0.210023205607,-0.0623835429758,-0.066911718412,0.212310878697],[-34876.2739701,-638.781280949,-185.280327573,-1800.10650838,-268.413366321,1696.72461603,981.401632841,759.433537211,-1503.37885882,295.251103201,313.422208599,127.499599952,-472.581454981,-954.116537506,-270.601569707,110.790695855,-474.571641051,-18.7835893232,-764.918889378,-297.295894064,52.6337146404,-19.751426145,42.3554382099,-661.542462147,206.801668316,-70.2283379898,-39.2345779629,163.037034963,-58.3835327568,302.502333363,-72.7499199486,-181.053125968,-38.6061467803,-48.1344706198,233.509728785,63.3837568798,11.2964845607,94.484353909,11.9614120599,-20.8051168272,-44.0778134951,-61.0731701644,-58.0279213376,6.3332891771,-45.1709866048,-0.377416458407,-17.3913764464,-66.8313702318,6.14657229166,9.37302739529,8.40807395068,-7.13461329381,-1.2074980218,-5.52355772739,-15.1168058925,25.1952299032,-23.4740220987,-13.8153455024,-12.6865758836,0.0373526752899,3.70189671056,16.765286914,13.3155376861,0.296534505982,0.131567182118,-2.94133086465,-2.86948923801,6.50770666248,0.491085443164,1.10126401632,1.62460673275,-0.268345768616,-3.12670219915,9.16815474201,0.874153588977,6.43394782972,1.23107078053,-2.7276506532,-3.35261407247,-1.76332618379,0.0651808897671,-0.869598237684,-0.724445738075,-1.35529067266,1.07413744545,-3.07601893803,1.21940935663,-1.94672257669,1.15546719869,1.45627915559,1.07757741682,1.16060644553,0.797009455529,1.51358350659,-0.609075931228,1.76565122102,-1.46928759586,0.795865286957,-0.573404374031,-0.0385275289252,0.16090577069,-0.434999831155,-0.512549325782,-0.473407414151,-0.56912856246,0.31569932178,-0.317726651245,0.557407539845,0.347779747529,0.635824970188,0.73061333099,1.36273281869,1.22939084712,0.464853460315,0.538107445537,-0.660744344253,-0.197192248565,-0.0690831703809,-0.0633629855318,0.212402425776],[-34793.4085404,-604.572242368,-191.59264692,-1850.49418803,-269.832606619,1657.3686546,1002.81639887,787.552257869,-1518.34441503,295.409435189,299.32378332,135.761285134,-446.741088712,-973.927107686,-276.604738427,105.422962336,-492.357042761,-20.9242876319,-767.140912097,-285.061736076,64.8227108262,-13.957597286,43.2342859468,-674.579103272,207.384567099,-77.7229029066,-34.7200467357,162.260710525,-56.2414443613,308.800437,-71.237800196,-178.450864017,-42.5730211692,-46.607473963,230.948644284,65.0861741995,9.85111958512,96.0082378105,11.1199075224,-19.687631244,-42.964477864,-59.9288703468,-55.7108147473,6.83946476648,-44.5842927691,-2.21264487033,-18.0345704733,-68.7948794732,6.63549546682,9.32758588803,8.46001094542,-7.75581214583,-0.726508769187,-5.20590545503,-14.8170611413,26.3137003414,-23.4350266323,-13.5180933857,-13.3745854793,-0.165380452277,2.97176481403,16.9204471748,13.1722991576,0.466151150571,0.172220861993,-2.98155917623,-3.05788640382,6.71039519907,0.428479933092,1.21891819724,1.84865975886,-0.188238447845,-2.9766195462,9.10081469763,0.904297095965,6.20264198492,1.29814461058,-2.87981281516,-3.28542524512,-1.82080208172,0.0970431345024,-0.831465508463,-0.750095281302,-1.40013417908,1.10143686093,-3.13878304781,1.24797384042,-1.9184764388,1.20009411081,1.51294007657,1.065666589,1.16655627101,0.727528601144,1.53971591758,-0.677203551323,1.83008950228,-1.51206275125,0.813848309622,-0.591100595774,-0.0353021852963,0.184171550759,-0.441166444045,-0.517614207672,-0.477703197036,-0.590803164269,0.321398587904,-0.321456554862,0.565065543588,0.359543049381,0.642187957851,0.737491523659,1.35981987485,1.24634128883,0.450202311867,0.562443801237,-0.677970775049,-0.185305844753,-0.0752368793944,-0.0604034285231,0.212724904163],[-34700.2247622,-575.377118109,-207.145683085,-1900.04678634,-270.896279493,1615.80179593,1024.31426511,808.734632675,-1531.99618656,296.516405936,287.119876843,142.639640018,-423.203270758,-993.41613883,-286.086437617,98.8549289001,-508.267472292,-22.565378281,-768.331098986,-270.374349341,77.5347217553,-8.27778251034,45.1144645056,-685.990530612,207.238488447,-85.0987264401,-30.2297515969,161.540433287,-53.0620776996,315.148619801,-69.1933971044,-175.554483716,-46.2270174677,-44.4927912102,228.270988716,66.6464473526,8.18879932678,97.3362154335,10.2777719949,-18.4951387663,-41.8744820937,-58.4644513641,-53.3921547271,7.38380181591,-43.7059557503,-3.96090773723,-18.6771586356,-70.7403432915,7.17594918978,9.21856467952,8.46077397884,-8.39549267082,-0.3542500955,-4.93173182142,-14.4583511934,27.3455321287,-23.3162300442,-13.2224311138,-13.9854143663,-0.363381595924,2.27605351431,17.0597376823,13.078958527,0.663751029843,0.223247342278,-3.02258783465,-3.25541502109,6.86547399163,0.351714270764,1.31426140959,2.04392703103,-0.0948943591272,-2.85786407288,9.05437055046,0.924972047102,5.99110262064,1.36105870675,-3.00250615905,-3.20925911098,-1.87172810326,0.131284129607,-0.784399188895,-0.770039351004,-1.44353175614,1.12290457333,-3.20079566062,1.26171002035,-1.89274634793,1.24056449635,1.55702399279,1.05896072399,1.16408842767,0.664754652415,1.56126770098,-0.735602658492,1.89408203896,-1.54734037366,0.831633939641,-0.607640407666,-0.0338788860652,0.209154759663,-0.445753190207,-0.520425310578,-0.479790541974,-0.611353147205,0.324302289656,-0.323742862665,0.569564415495,0.370181275705,0.647853904638,0.740192407073,1.35731355731,1.2593973449,0.436164902176,0.585290208869,-0.693023504954,-0.174497213393,-0.080588819314,-0.0581040899942,0.213376710764],[-34601.7466581,-567.737465289,-234.44702543,-1944.23298748,-274.312201677,1572.15791134,1042.02787265,819.625803548,-1542.96346311,298.545760755,277.142648097,147.232720935,-402.857687651,-1012.83821013,-299.563983584,91.3459256885,-521.734349034,-23.5342575376,-768.561807442,-253.125311991,90.5093945902,-2.83960629448,48.0558348954,-695.725078128,206.322158536,-92.1874869777,-25.760070562,160.931607154,-48.7838729655,321.465766746,-66.5812941048,-172.372942503,-49.5771958683,-41.762467532,225.478111291,68.0416522012,6.33595240202,98.4550552876,9.46963026598,-17.2167511456,-40.8192919013,-56.6650206424,-51.0964415365,7.97068681089,-42.5337619653,-5.6043761619,-19.2930749254,-72.6500593982,7.76269698126,9.04525414045,8.40383066751,-9.04090719937,-0.0973745990071,-4.70145520537,-14.0360272568,28.273174128,-23.1081242356,-12.9342860476,-14.5111372832,-0.549564810121,1.62109985894,17.1821991029,13.0372695798,0.888199395402,0.283291483585,-3.06468915678,-3.46023038608,6.96944525994,0.261818397758,1.38561199475,2.20679066567,0.0138077444306,-2.77487617202,9.03085108138,0.935852238862,5.8017217458,1.42041774303,-3.09350782835,-3.12360149318,-1.9142080674,0.167506135678,-0.728693474599,-0.784141213526,-1.48506732243,1.13817525892,-3.26101263534,1.25990360465,-1.86983544418,1.27683115996,1.58692676235,1.05821385966,1.15231505885,0.609603538209,1.57810081696,-0.783531679226,1.95731958023,-1.57411557729,0.849097228903,-0.622611604975,-0.0344192806137,0.235612129758,-0.448609578944,-0.520979180165,-0.479493495026,-0.63046808692,0.324228677694,-0.324345679961,0.570706162585,0.379453761775,0.652936286111,0.738268956302,1.3552568233,1.26826515759,0.422811528436,0.606461456602,-0.705619749455,-0.164839485969,-0.084986562036,-0.0565246198727,0.214396217936],[-34504.5463331,-590.604908159,-272.011423521,-1980.57165007,-282.428843974,1526.59364511,1053.21963339,819.068454918,-1550.16144797,300.894068667,269.227568806,148.957017175,-386.218427873,-1032.61155527,-316.825788927,83.2573716462,-532.453230707,-23.8597797709,-767.986156465,-233.421410321,103.41418727,2.4045897941,51.9593712507,-703.617767945,204.684883179,-98.8305180598,-21.3222619156,160.451152293,-43.4587505212,327.670540805,-63.3919721824,-168.974134683,-52.600000872,-38.4507058612,222.583241117,69.2640699754,4.34642579012,99.366070558,8.72576729712,-15.8598278159,-39.8051324668,-54.547333457,-48.8563387082,8.60324230933,-41.0947134953,-7.12281189785,-19.872443058,-74.5095641831,8.3859875802,8.8162314849,8.28945031542,-9.67641131391,0.0428919129586,-4.51220283427,-13.5540143904,29.0840752785,-22.8094197658,-12.663787593,-14.9470955935,-0.724659180312,1.01023094303,17.2838039335,13.0456829517,1.13539536133,0.351248192098,-3.10773837857,-3.66859858958,7.0224741005,0.160954515301,1.43204042365,2.33597057388,0.137654024186,-2.73084776136,9.03083500979,0.935320798941,5.63570443303,1.47532526737,-3.15279896963,-3.02859148429,-1.94739672768,0.204791100425,-0.665504021433,-0.792614907501,-1.52412842212,1.14747458587,-3.31828395029,1.2428818875,-1.84964682406,1.30881763601,1.60192864562,1.06363218412,1.13068410798,0.562579297962,1.58977925233,-0.821013405402,2.01929909011,-1.59213616933,0.866139941372,-0.635899786392,-0.0369823780698,0.263025919145,-0.449735458516,-0.51937362786,-0.476759045741,-0.647853865573,0.321275298199,-0.323055413522,0.568515099949,0.387291983362,0.657507702857,0.731570349239,1.3536577483,1.27278458238,0.41012561108,0.625778980894,-0.715716946896,-0.156351587026,-0.0884624781678,-0.0556930024961,0.215745388731],[-34413.6333505,-640.295031312,-314.11113434,-2009.2394856,-295.588653175,1479.2056477,1057.34750658,808.395125719,-1553.21827051,302.580966916,262.670438224,147.89931096,-373.290765146,-1053.1091401,-336.795474102,74.9340126927,-540.45147065,-23.7802266869,-766.744623908,-211.601895289,115.92038917,7.70671646923,56.5574841645,-709.363314461,202.450739592,-104.909366978,-16.9448777132,160.077202671,-37.2695684633,333.704075997,-59.6387843757,-165.476853275,-55.2255707206,-34.6551213132,219.608884202,70.323039573,2.29143118514,100.086917293,8.06695307722,-14.4528070241,-38.8265289943,-52.1636406316,-46.707487027,9.28270157812,-39.4462070495,-8.49316581251,-20.4235042053,-76.3062295892,9.03248751323,8.54756072836,8.12537385094,-10.2856234405,0.0715664855358,-4.3579164806,-13.0264850413,29.772883602,-22.4274782908,-12.4239756686,-15.291666793,-0.897702756427,0.44340178551,17.357005595,13.0987628253,1.39867489237,0.426053160215,-3.15128551653,-3.87567540684,7.02875128669,0.0517504761749,1.45342165282,2.43306300496,0.273701239572,-2.72689586157,9.05319510808,0.92051271982,5.49300363261,1.5232936647,-3.18273069611,-2.92499701584,-1.97167444658,0.241889859865,-0.596843798084,-0.796114646029,-1.56012058961,1.15166252329,-3.37167686848,1.21206086619,-1.8317435394,1.33635639924,1.60244052544,1.07485369787,1.09923735321,0.523821299436,1.59560068602,-0.848881195728,2.07928954163,-1.6020397516,0.882682497687,-0.64770413639,-0.0414755735315,0.290654829029,-0.449295964562,-0.515837133613,-0.471697794056,-0.663332415444,0.315826101412,-0.319795819035,0.563254691649,0.393817829089,0.661587356416,0.720320391832,1.35249406386,1.2729492175,0.398024764116,0.643087232908,-0.72353440447,-0.148964754732,-0.0912590437954,-0.0555926983449,0.217293228287],[-34332.374995,-702.947981412,-353.996863693,-2032.73838753,-311.981799736,1429.95871312,1056.37593959,790.347755788,-1552.56923615,302.550085956,256.463755738,144.808235804,-363.772733205,-1074.53768831,-357.882953308,66.5967867138,-546.032761919,-23.6620964559,-764.901450835,-188.150678776,127.809305269,13.4464650013,61.5485175124,-712.634749474,199.774407728,-110.370473139,-12.66743834,159.763366628,-30.4853346566,339.543788991,-55.3441401839,-162.009339244,-57.3600121524,-30.5013384166,216.582825776,71.240790591,0.241809264816,100.643978842,7.50222819252,-13.0406051346,-37.8659892498,-49.5873235611,-44.678784088,10.0074867299,-37.6592221313,-9.6958318065,-20.9624049776,-78.0271061191,9.68871081896,8.25838080907,7.92387222811,-10.8544642141,-0.00267497214454,-4.23042295595,-12.4747873608,30.341000228,-21.9751512237,-12.2275468479,-15.5456014726,-1.08075128261,-0.080302965305,17.3935096721,13.1890304651,1.67041783835,0.506793308698,-3.19468156894,-4.07661755786,6.99495042921,-0.0633604625977,1.44990507259,2.50176021665,0.417292721207,-2.76197802047,9.09557960499,0.888415101045,5.37282685553,1.56118590895,-3.18714746493,-2.81405028342,-1.98795248741,0.277485588757,-0.525073823434,-0.795550176427,-1.59259767576,1.15197281267,-3.42063924484,1.16945111581,-1.81551224174,1.35922647501,1.58975864851,1.09117451151,1.05861528783,0.493296585477,1.59492291859,-0.868408274987,2.13654489287,-1.6049778291,0.898676716316,-0.658388829109,-0.0477006512113,0.317697594874,-0.447544173553,-0.510676526879,-0.464521932378,-0.676868673607,0.308422813822,-0.314641392069,0.555328543279,0.399268902926,0.665168801279,0.705037698554,1.35174722884,1.26891657794,0.386421264084,0.658291914902,-0.729437598612,-0.142542476229,-0.09371723711,-0.0561906105176,0.218869001319],[-34263.4356024,-763.223883044,-386.535886273,-2054.08057055,-329.137831253,1379.04948889,1053.27735567,767.513541617,-1549.00692889,299.89543146,249.766602269,140.660217553,-357.354089384,-1096.94530446,-378.560525377,58.3591368167,-549.60664002,-23.8457041802,-762.48408899,-163.557064475,138.979118983,19.9885067792,66.7127783803,-713.23109862,196.799871805,-115.209200948,-8.52729832304,159.455696689,-23.3778050899,345.191938298,-50.5304035208,-158.672743001,-58.9287036794,-26.1004935563,213.53300791,72.0432901346,-1.74206943867,101.063123327,7.03201015623,-11.6700806816,-36.9042280217,-46.8909161851,-42.7880191688,10.7740043119,-35.7970043527,-10.7187003973,-21.5000653938,-79.6593380462,10.3430674527,7.9670856513,7.69672328258,-11.3725393199,-0.169985173831,-4.12214119857,-11.9205249693,30.7934615993,-21.4659510401,-12.0832651053,-15.711573661,-1.28213876399,-0.560552581485,17.3873502507,13.309311112,1.9434459184,0.592691945751,-3.23748106137,-4.26723996311,6.92803899193,-0.182533029276,1.42193599238,2.54600516346,0.563990192424,-2.8335373585,9.15542957745,0.837401087365,5.2744422663,1.58655612027,-3.17005666434,-2.6971680927,-1.99694509215,0.310388629387,-0.452391448013,-0.79187785906,-1.62122657198,1.14956506529,-3.46496616882,1.11713314511,-1.80053397847,1.37739176996,1.56547221495,1.11189195878,1.00992880505,0.471009654917,1.58752840757,-0.880791183109,2.19054593182,-1.6020927986,0.914116980854,-0.668284906953,-0.0554369773923,0.343443197557,-0.444721468741,-0.504199860687,-0.45550556008,-0.688507047787,0.29958872545,-0.307803615828,0.545182782439,0.403843952335,0.668292680727,0.68636997909,1.35145856105,1.26102237118,0.375304433287,0.671400335294,-0.733765399937,-0.136924351824,-0.0961218786652,-0.0574563870355,0.220327693828],[-34207.5455922,-811.86879091,-410.741955271,-2075.42582893,-345.338527912,1327.20347151,1050.76440772,741.928886564,-1543.2745123,294.004806585,242.065768178,136.111128555,-353.822588339,-1120.49111835,-397.605497307,50.3157475881,-551.529606753,-24.5892796245,-759.569090547,-138.240654652,149.384739535,27.6167378723,71.9254090246,-711.136221267,193.655225278,-119.430120075,-4.55148356934,159.1008105,-16.1876917778,350.641012767,-45.226817483,-155.55814334,-59.8893851191,-21.5433548499,210.489188138,72.7536090799,-3.60353637022,101.366241975,6.65563322855,-10.3857476107,-35.9278332465,-44.1392689444,-41.0480878871,11.5758872546,-33.9133246868,-11.5615142784,-22.0416580629,-81.1923473796,10.9850918463,7.69166278024,7.45351520879,-11.8304439076,-0.419952521766,-4.02633178969,-11.382598993,31.1358641207,-20.9133207533,-11.997862066,-15.7939226413,-1.50604840029,-0.995191820057,17.3359023216,13.4536396468,2.21102575707,0.682957198534,-3.27941799162,-4.44334723879,6.83465720831,-0.30409307984,1.37020885115,2.56919456595,0.709986950149,-2.93852711197,9.23017508792,0.767011142809,5.19701331656,1.59755955245,-3.1353619326,-2.57609276065,-1.99890351948,0.339464375242,-0.380796189604,-0.786032222588,-1.64559490289,1.14537356151,-3.50452593677,1.05710795105,-1.78655530377,1.39105466555,1.53114972206,1.13634048812,0.95442121848,0.456964802633,1.57353053398,-0.887033735052,2.24101221736,-1.59437669706,0.929053425494,-0.677665625438,-0.0644812268005,0.367260617819,-0.441041303759,-0.496692274638,-0.444953650342,-0.698279909816,0.289792459418,-0.299551625721,0.533273161195,0.407650623791,0.671037547083,0.664967914213,1.35171195796,1.24969009902,0.36473108861,0.682458637134,-0.736806206312,-0.131965228212,-0.0986605509432,-0.0593754000796,0.221574215893],[-34164.06552,-846.231229195,-427.588632701,-2098.1069107,-360.134601269,1275.56217387,1050.74773243,714.955308643,-1535.89538321,284.478655918,233.138410544,131.428428107,-353.030140002,-1145.39908942,-414.126507292,42.571589218,-552.091789579,-26.0721055672,-756.318374236,-112.570933898,158.982795071,36.4943618902,77.1001416404,-706.507112451,190.453190601,-123.033279808,-0.756419122205,158.642492745,-9.12060172184,355.86534953,-39.4869545936,-152.75066289,-60.2443279144,-16.9033273808,207.478156818,73.3886967229,-5.28716837938,101.571678083,6.37245361553,-9.22592812948,-34.9323536746,-41.3905753052,-39.4722521151,12.4017003526,-32.0539782671,-12.2343278725,-22.5871290566,-82.6183352083,11.6046724684,7.44924289631,7.20232807225,-12.2196469745,-0.741420456627,-3.93770095814,-10.8766312609,31.3735185382,-20.3314046147,-11.9761206939,-15.7995232554,-1.75264426481,-1.38175451305,17.2393126281,13.6168451349,2.46683879193,0.776690776614,-3.32031846382,-4.60060512741,6.72110122581,-0.426301996651,1.29593730297,2.5740912305,0.85202359719,-3.07365149689,9.31706051942,0.678047001882,5.13949289934,1.5930256875,-3.08674469153,-2.45271559154,-1.99373140559,0.363632939864,-0.312130814777,-0.778867169115,-1.66518681584,1.14013272003,-3.53916906243,0.991329500368,-1.77343873582,1.4006059284,1.48826071732,1.16381183326,0.893397458711,0.451025492348,1.5533131351,-0.88801744983,2.28785040348,-1.58268087689,0.943582838558,-0.686742153193,-0.074645443609,0.388582247051,-0.436703271055,-0.488408332555,-0.433180336616,-0.706189142806,0.279461836498,-0.290166658241,0.520054646222,0.410717973359,0.67349087253,0.641460088243,1.35259671711,1.23541410293,0.35479242602,0.691549049512,-0.738805802293,-0.127530189726,-0.101428617781,-0.0619334107964,0.222557151116],[-34131.8501921,-869.047499063,-438.405324592,-2122.8170413,-374.374506057,1225.33879805,1054.03312427,687.27223069,-1527.13306086,271.052037183,223.049454001,126.509536989,-354.896589472,-1171.90100823,-427.592850235,35.2480091749,-551.50934103,-28.3865408474,-752.962718839,-86.8952252017,167.6729197,46.6334084014,82.1589669863,-699.629408341,187.286300871,-126.006597869,2.85335125929,158.018689022,-2.3482100371,360.817963447,-33.401980335,-150.322001816,-60.0473900927,-12.2428574352,204.515268003,73.9574354804,-6.7422064894,101.695101762,6.18339992532,-8.21899025798,-33.9219288571,-38.6991217228,-38.0756490895,13.2305062266,-30.2576598292,-12.7544605037,-23.1308486485,-83.9305015737,12.1912247947,7.25441457935,6.94996766359,-12.5326268544,-1.12265636611,-3.85238371474,-10.4151688707,31.5113167818,-19.7352337837,-12.0200921704,-15.7379898753,-2.01842293949,-1.71857834917,17.0993403665,13.793804516,2.70517942437,0.872669525466,-3.36013504068,-4.73480979335,6.59323710475,-0.547226199564,1.20119099648,2.56296840369,0.987224145449,-3.23532321088,9.41292360474,0.572511762553,5.10060969143,1.57255706257,-3.02766430233,-2.32888322135,-1.98113289389,0.381993172169,-0.24810267537,-0.771139328057,-1.67949959168,1.13443998558,-3.56868975114,0.921706927397,-1.76112761352,1.4065666954,1.43818270507,1.19352434343,0.828271217853,0.452822038045,1.52749573685,-0.884585048076,2.33103605079,-1.56769604802,0.95783246733,-0.69564063558,-0.0857340723654,0.40690911385,-0.431889938429,-0.479589833924,-0.42050230456,-0.712224594445,0.268988824946,-0.279917638816,0.505982354602,0.413038517424,0.675727305567,0.616447389486,1.35416478784,1.21873058964,0.345590326732,0.698779612925,-0.739957751611,-0.12348308489,-0.104451964026,-0.0651086923173,0.223251293417],[-34109.2263426,-883.861744641,-443.742649738,-2149.82991154,-388.776036461,1177.28675948,1060.66065851,658.991816402,-1517.14690042,253.706666288,212.068375595,121.28632448,-359.260133842,-1199.94649977,-437.871083588,28.4032169952,-549.947442907,-31.5491789329,-749.691142245,-61.5389188903,175.324881781,57.9074240508,86.999709077,-690.844770342,184.213763774,-128.340577514,6.27452841209,157.173126907,3.98567740598,365.45255054,-27.0809663819,-148.319290977,-59.3965090364,-7.61047526524,201.598008122,74.4634391255,-7.93277178553,101.749271589,6.08930100664,-7.38306774113,-32.9024031279,-36.1144416389,-36.8723557691,14.0331628498,-28.5558965595,-13.1388799516,-23.6597968434,-85.1202329707,12.7344382255,7.11699348573,6.7022129521,-12.7639382917,-1.55243057993,-3.76734839399,-10.0083618424,31.5547943113,-19.139493181,-12.1285699368,-15.6206774603,-2.29721433343,-2.00608357068,16.9178712844,13.9790328411,2.92144506006,0.969437125157,-3.39890803325,-4.84262353342,6.45627888078,-0.664948534879,1.08882160901,2.5381690679,1.11302563948,-3.41964879131,9.51415082486,0.453309478149,5.07891624796,1.5367355795,-2.96124889615,-2.20612369104,-1.96076189825,0.39399560226,-0.190186079619,-0.763500227341,-1.68823400816,1.12882347661,-3.59289658838,0.850036759534,-1.74959492336,1.4094688094,1.38225075068,1.22464079638,0.760602775815,0.461788918412,1.49686826668,-0.877627555857,2.3704519442,-1.54997971519,0.971889921199,-0.704307481828,-0.0975381551326,0.421852113925,-0.426752620135,-0.470472902626,-0.407232138431,-0.716407287499,0.258714858198,-0.269070077785,0.491493195861,0.414617162417,0.677796817246,0.590510245663,1.35639938422,1.20019420355,0.337206202637,0.704288444744,-0.740414995223,-0.119664857021,-0.107713585036,-0.0688616439285,0.223618194259],[-34093.4809869,-892.848447327,-443.317981996,-2178.76460785,-403.813582977,1131.96962126,1070.43289595,630.526342976,-1506.07974137,232.674671002,200.614979443,115.903744393,-365.864064533,-1229.27585179,-445.097607037,22.0635573463,-547.518544621,-35.5401971848,-746.617791735,-36.789394419,181.813431499,70.1518070053,91.5082326718,-680.49555233,181.270446903,-130.037236231,9.50630949174,156.058767574,9.76954932089,369.732259577,-20.6372470581,-146.776264941,-58.4111459442,-3.05210626097,198.719749963,74.9052445765,-8.83795799351,101.745566569,6.09040497267,-6.73020728519,-31.880000146,-33.6793135257,-35.8730796491,14.7803897876,-26.9722033156,-13.3996362121,-24.1557709463,-86.1781500325,13.2248930136,7.04295554975,6.46388507873,-12.9108693154,-2.01985372749,-3.67996526941,-9.66367452238,31.5105507369,-18.557356268,-12.2981147837,-15.4587709687,-2.58165421993,-2.24529457767,16.6966787558,14.1668563618,3.11212489048,1.06535419246,-3.43652421257,-4.92167074845,6.31484493704,-0.777605506794,0.962063548454,2.50202667074,1.22715566653,-3.62245246733,9.61718384201,0.323969498748,5.07301490584,1.48679372626,-2.89050672938,-2.08579782684,-1.93239909942,0.399385167615,-0.139566402324,-0.756505113552,-1.69125787786,1.12374576815,-3.61163760123,0.77794589105,-1.73876831413,1.40980800438,1.32178943363,1.25629367169,0.691955237938,0.47724773921,1.46225223098,-0.868000400577,2.40589776409,-1.52994732709,0.985845108245,-0.712551737655,-0.109839117939,0.433138941525,-0.421425985734,-0.461278976595,-0.393662608833,-0.718780435883,0.248944908093,-0.257879553891,0.476972802297,0.415473994084,0.679708899823,0.564187666619,1.35922986989,1.18034623582,0.32969572284,0.708219753592,-0.740305506946,-0.115915564147,-0.111164992464,-0.0731358134348,0.223608962931],[-34081.0734812,-896.868257353,-436.439689925,-2208.70700338,-419.401275785,1089.82073302,1082.82471158,602.159155134,-1493.94657285,208.44190904,189.20047112,110.688672947,-374.367566477,-1259.36202752,-449.513555835,16.2439275457,-544.292956129,-40.2919338475,-743.755035491,-12.9107639399,187.039091532,83.1530003361,95.5482155535,-668.929359464,178.470196758,-131.099799137,12.5413728658,154.648691204,14.9179443663,373.626641387,-14.1936587871,-145.709512595,-57.2279139027,1.38708784401,195.871503213,75.2765705116,-9.44867199064,101.69236739,6.18519488411,-6.26541627487,-30.8602635947,-31.4324431116,-35.086093301,15.4422748001,-25.5255414638,-13.5424798198,-24.5982613106,-87.0934271431,13.6536741241,7.03462666851,6.2390534936,-12.9732357574,-2.51431786981,-3.58842581909,-9.38630732144,31.385502275,-18.000248504,-12.5231727326,-15.2621426566,-2.8636232938,-2.43800944942,16.4368958994,14.3512663799,3.27455642839,1.15864885422,-3.47268411837,-4.97064821247,6.17292147811,-0.883431495957,0.824601230133,2.45691140595,1.32768309025,-3.83932054294,9.71858908072,0.188377953217,5.08172092974,1.42433558337,-2.81810887589,-1.96894026359,-1.89603694911,0.398175972891,-0.0972089546975,-0.750571751543,-1.68857510686,1.1196324122,-3.62478608407,0.706960941579,-1.72851436242,1.40796828457,1.25809861342,1.28763110014,0.623849968562,0.498503770184,1.42443784785,-0.856551197577,2.43707861814,-1.50795902679,0.999727322452,-0.720117743505,-0.122416755723,0.440597238364,-0.416029597505,-0.452198372458,-0.380062416731,-0.719402444059,0.239947794668,-0.246577780597,0.462755965779,0.415647149868,0.681431302522,0.537964759938,1.3625437175,1.15967546469,0.323083373136,0.71070293503,-0.739736232394,-0.112080811909,-0.114746464781,-0.0778495072871,0.223160795157],[-34067.6154468,-898.565629114,-424.971091686,-2238.20715817,-435.259374791,1051.04990419,1096.55705562,573.792632741,-1480.54812065,181.692977964,178.328095521,105.844861793,-384.456261615,-1289.58417668,-451.467325683,10.9534727385,-540.274105011,-45.7028371028,-741.071696762,9.8408226471,190.923049372,96.6078329469,98.9726490328,-656.529059176,175.809302301,-131.523099279,15.3638100948,152.938030621,19.3638209962,377.095486126,-7.88473070004,-145.12930476,-55.9986337998,5.66615269681,193.046034726,75.5656696163,-9.76333217602,101.593978226,6.37200375487,-5.98724689741,-29.8494953649,-29.4105947303,-34.5182148758,15.9845180027,-24.2318921447,-13.5723993645,-24.9671709038,-87.8564154835,14.0120642286,7.09095101253,6.03145050291,-12.9518450392,-3.02577192212,-3.49133263491,-9.17939878455,31.1865759092,-17.4792006479,-12.7965530492,-15.0399161871,-3.13458103676,-2.58669950866,16.1395569054,14.5265114487,3.4068050084,1.24734910111,-3.50688080001,-4.98897534332,6.03392164641,-0.980516185002,0.680421477783,2.40543101634,1.41280021711,-4.06577243918,9.81473178522,0.0504083272439,5.10371639006,1.3510137664,-2.74640291088,-1.85645708241,-1.85179816818,0.390636394918,-0.0639320993672,-0.745969133953,-1.68028555995,1.11683451895,-3.63213526285,0.638504892532,-1.71859247656,1.4041899023,1.19248499919,1.31775499174,0.557733280007,0.524838044425,1.38417454534,-0.844138756467,2.46364641161,-1.48436548088,1.01350733161,-0.726707174655,-0.135042633231,0.444135824322,-0.410675075221,-0.44340550163,-0.366681769244,-0.718331280109,0.231938557463,-0.235345751795,0.449138500571,0.415204204049,0.682891254152,0.512269678186,1.36618625613,1.13859556539,0.317358081135,0.711824233783,-0.738799279793,-0.108031400345,-0.118377547896,-0.082903661316,0.222207673339],[-34048.3906797,-902.212811104,-413.583902944,-2265.8315476,-451.279978319,1015.55950338,1109.99237691,545.13638922,-1465.56227582,153.165157359,168.395257241,101.420142632,-395.942027405,-1319.41602322,-451.321453901,6.21997296409,-535.435850279,-51.6865192625,-738.530112196,31.213956845,193.407671646,110.163390827,101.663452076,-643.692451722,173.280525107,-131.300741044,17.9498256631,150.936932179,23.0535836705,380.092540037,-1.85943082835,-145.040638944,-54.8738896661,9.74557666813,190.243902424,75.7582304813,-9.78397040519,101.450647819,6.64827341983,-5.89111318477,-28.8566878532,-27.6490655717,-34.1734897607,16.3727129282,-23.10325005,-13.4948915583,-25.2451515512,-88.4607238384,14.2922452924,7.2091761807,5.8446703139,-12.8485850381,-3.5450392873,-3.38775469873,-9.04452227968,30.9206080098,-17.0053921579,-13.110114557,-14.8002787888,-3.38597324241,-2.69349027213,15.8062111179,14.6875351226,3.50758945579,1.3295866871,-3.53826871052,-4.97642545045,5.90078907837,-1.06690930816,0.533433445478,2.35011782472,1.48065920257,-4.29731009121,9.90218633504,-0.0861289773209,5.13770986472,1.26832301098,-2.67741518444,-1.74927285597,-1.79978903121,0.377153699379,-0.0403587682003,-0.742793981336,-1.66647935054,1.11563440919,-3.63340671194,0.573851032733,-1.70867914619,1.39855749976,1.12623896363,1.34569986366,0.49487246037,0.555504573418,1.34212731164,-0.831521077048,2.48527402516,-1.45942729906,1.0271685714,-0.732055417092,-0.147505504768,0.443732463869,-0.405472727734,-0.43504123422,-0.353730011488,-0.715604128146,0.22509055428,-0.224305981246,0.436352573592,0.414228966528,0.683964088716,0.487459316236,1.36998096468,1.11745251909,0.312496906094,0.711618727081,-0.737551115927,-0.103680068008,-0.121953057565,-0.088197812313,0.220703202835],[-34019.0247608,-910.633175964,-408.14090808,-2290.85408866,-467.007890859,982.858527747,1121.73845559,515.828284245,-1448.73977163,123.565519489,159.720103245,97.5229919206,-408.648843877,-1348.19031536,-449.284638034,2.05137605646,-529.789486935,-58.1583936976,-736.048842331,50.999951615,194.521677406,123.486643433,103.561999185,-630.768594108,170.872066503,-130.443638429,20.2742338415,148.661957716,25.9491733592,382.591997764,3.74123808638,-145.416307074,-53.978550965,13.599883061,187.475714089,75.841106423,-9.51891076384,101.259391347,7.00654347006,-5.96928757899,-27.8892527514,-26.1770713103,-34.045731794,16.5783477764,-22.143693644,-13.3096847124,-25.4184829656,-88.9008618795,14.4885856876,7.38521270246,5.68215947997,-12.6678199782,-4.06417299414,-3.27779091857,-8.98164301149,30.5953281089,-16.5884138421,-13.4538373355,-14.5484882056,-3.60935464851,-2.75947787285,15.4382237156,14.8305507891,3.57651287461,1.40394009113,-3.56584161213,-4.93332813295,5.77585709374,-1.141211161,0.387292492072,2.29340580945,1.5295571223,-4.52931332543,9.97827024661,-0.217492962526,5.18310886288,1.17758886029,-2.61227994204,-1.64812851187,-1.73993980294,0.358216424443,-0.0268061107382,-0.741035372856,-1.6472343111,1.11623137273,-3.62840661451,0.514030103897,-1.69847870238,1.39101744622,1.0605696302,1.37056073249,0.436409158535,0.589982696575,1.29889443515,-0.819159059072,2.50164488494,-1.43323351364,1.04069127195,-0.735941697924,-0.15962784067,0.439452413816,-0.400533876593,-0.427184992763,-0.341369173526,-0.71126588568,0.219523042362,-0.213574316495,0.424557715122,0.412799944904,0.684486291307,0.463822926268,1.37377933726,1.09653886462,0.308515739712,0.710085485683,-0.735970665417,-0.0989673346986,-0.125349314547,-0.0936326394134,0.218602866736],[-33975.8496999,-925.799507413,-415.320583828,-2313.81126071,-481.967703147,952.452395038,1130.6456218,485.991895361,-1429.99486868,93.5062416547,152.602527329,94.1379088834,-422.291501445,-1375.30119761,-445.330605429,-1.55408865206,-523.412082245,-65.0396354639,-733.508002831,69.074513661,194.384305565,136.305620003,104.678636053,-618.058062558,168.575225556,-128.989922356,22.3156988665,146.133516712,28.0308066882,384.581565516,8.79270011905,-146.205993022,-53.3992686565,17.2217675171,184.762225587,75.8043047343,-8.98294821699,101.012901061,7.43415537458,-6.21315536863,-26.9530828146,-25.0142370935,-34.1189646505,16.5794991587,-21.3482061411,-13.0160620569,-25.4810326416,-89.1761655845,14.5983729743,7.61409772447,5.54697177412,-12.4167171702,-4.57688319374,-3.16230855595,-8.98876378124,30.2190962119,-16.2358124402,-13.816712974,-14.2863215528,-3.79724415346,-2.78480773062,15.0374863315,14.9538092251,3.6141928097,1.46962801171,-3.58848840401,-4.86059632445,5.66081055886,-1.20273944038,0.245286339826,2.23741731763,1.55810916969,-4.75726533285,10.0411592312,-0.340170041197,5.23975968445,1.07989288607,-2.55118382246,-1.55358548072,-1.6720162382,0.334401220437,-0.0232214315845,-0.740572906145,-1.62262491901,1.11870839238,-3.61708055581,0.459780900288,-1.68774932271,1.38147017444,0.996551729923,1.39157643606,0.383362521559,0.628000510699,1.25511096441,-0.80716699576,2.5125913236,-1.40571182898,1.05409248357,-0.738239102858,-0.171263774564,0.431461152105,-0.395966741528,-0.419844928582,-0.329707112118,-0.705392825763,0.21530152161,-0.203278133997,0.413854490049,0.410984082874,0.684270868505,0.441593566975,1.37748219481,1.07610821187,0.305465962074,0.707198942997,-0.733963294653,-0.0938702977929,-0.128422322562,-0.0991187761644,0.215869398941],[-33917.4482255,-947.627643048,-438.294457367,-2336.20924856,-495.932080669,924.320317751,1136.05551722,456.902719479,-1409.44834407,63.3369615271,147.285851511,91.1824459604,-436.39451742,-1400.22666111,-439.463879363,-4.64957295755,-516.459683198,-72.2886706696,-730.800016632,85.380138298,193.160048744,148.422367183,105.036582767,-605.801278712,166.385017406,-127.00434503,24.0663118309,143.35730202,29.2999541127,386.05184727,13.2054365434,-147.354857601,-53.1965485555,20.606159072,182.135824172,75.6434386823,-8.19774192594,100.704488193,7.91450062656,-6.61314255776,-26.0544011575,-24.1682429064,-34.3696776788,16.3614146417,-20.7038268323,-12.6106760956,-25.426343444,-89.2889487744,14.6221160826,7.89047751658,5.44176183188,-12.1038000441,-5.07849665757,-3.04304539595,-9.06219808592,29.8009185954,-15.9519583692,-14.1870914641,-14.0131684509,-3.94257508133,-2.76901935579,14.606573546,15.0562333841,3.62218017889,1.52662977494,-3.60540612962,-4.75959018543,5.55681101612,-1.25156415982,0.110200437921,2.18367527227,1.56549348472,-4.97687811061,10.089568433,-0.45078001077,5.30770146911,0.976659450075,-2.49397519833,-1.46612101052,-1.59597281308,0.306307997182,-0.0292415046258,-0.741268221046,-1.59280923436,1.12306036433,-3.59950901809,0.411538863705,-1.67642024705,1.36982382536,0.935110322115,1.40821429141,0.336631775107,0.669454963528,1.21152283048,-0.795392907265,2.51804661976,-1.37665214506,1.0674026968,-0.738771568926,-0.182310024137,0.419993042634,-0.391859711786,-0.412972929858,-0.318807849896,-0.698099958372,0.212457110678,-0.193581398974,0.404301929904,0.408825851568,0.683170108269,0.420961518698,1.38103405554,1.05640118012,0.303439416552,0.702960313111,-0.731377380159,-0.0883911677922,-0.131005559848,-0.104558558405,0.212480136327],[-33844.6082483,-973.848232167,-468.884213807,-2359.13292893,-508.369251589,899.145819857,1140.72661579,430.953941506,-1387.31746844,33.3166741143,143.523071633,89.0032318183,-450.269154089,-1422.21158055,-432.305953041,-7.44730889681,-509.146209162,-79.9536570056,-727.887418348,99.9242454841,191.147290742,159.639006896,104.539308257,-594.233383403,164.262519356,-124.580448133,25.5603771441,140.308302234,29.7855680885,387.027898016,16.9651683448,-148.807036989,-53.4081120534,23.7438963565,179.686358839,75.3605085623,-7.19486039174,100.341813335,8.43245792778,-7.1521545759,-25.195040577,-23.6196824675,-34.7561184865,15.9210699863,-20.1916080291,-12.0794935869,-25.234272416,-89.2387953089,14.5654779958,8.20735100697,5.36834675236,-11.7364508509,-5.56432501016,-2.92177901075,-9.19606806987,29.3550718492,-15.7364128121,-14.5514710744,-13.7280687113,-4.03499847214,-2.70988488024,14.1505466112,15.1338663856,3.60308773578,1.57534096169,-3.61721223629,-4.63238189881,5.46463607698,-1.28838911685,-0.0162707095978,2.13338366074,1.5519784388,-5.18371785705,10.1222223646,-0.546194797451,5.38735894261,0.870109334074,-2.44090626035,-1.38716812189,-1.51228820061,0.274482121884,-0.0442339249742,-0.743148460887,-1.5583723336,1.12914644868,-3.57604818543,0.369425304676,-1.66486275885,1.35608448498,0.877059331996,1.42025429967,0.296810159466,0.714326551546,1.16907290282,-0.783372737698,2.51785317268,-1.3458442428,1.08054845561,-0.737056897173,-0.192711520517,0.405358981482,-0.388238447618,-0.406541831165,-0.308738506418,-0.689584084774,0.211032031778,-0.184716770034,0.395929615307,0.406344403537,0.681190733606,0.402085689911,1.38444455934,1.03767405247,0.30265883917,0.697453212016,-0.728007317307,-0.0825807847268,-0.132826037327,-0.10977115441,0.2084741862],[-33760.3303873,-1003.38299522,-498.571465812,-2383.40648654,-519.500177495,876.654434043,1146.64890808,409.894438991,-1363.71876069,3.5606243501,140.925505886,87.8068875555,-463.364074352,-1440.49853289,-424.621963547,-10.1216295139,-501.644229451,-88.0516264342,-724.777852591,112.736166008,188.595800831,169.798092481,103.08049359,-583.530106418,162.172918211,-121.794735369,26.8536318103,136.963932942,29.5376073669,387.542197464,20.0898958882,-150.494845535,-54.0582364228,26.6384177581,177.488549506,74.9590018372,-6.00011055011,99.9382354935,8.97827065171,-7.80679544811,-24.3764822508,-23.3357093589,-35.2380977629,15.2633157918,-19.7902776394,-11.408795074,-24.8866750424,-89.0259679611,14.4352478625,8.55880079164,5.32809778786,-11.320063816,-6.02929004368,-2.80087458511,-9.38214489623,28.8936668954,-15.5859805524,-14.8984823606,-13.4305219187,-4.06602660177,-2.60691417084,13.6745363956,15.1835650729,3.55954999326,1.61631678039,-3.62504753985,-4.48074220677,5.38461512456,-1.31413496503,-0.132949244346,2.08680896814,1.51856123267,-5.37467710182,10.1382542333,-0.624003209829,5.47912236896,0.76277467833,-2.39160937314,-1.31772632474,-1.42151673227,0.239384942027,-0.0675138107564,-0.746379951519,-1.51984638057,1.13667491896,-3.54706185032,0.333337653201,-1.65366121265,1.34035053661,0.822710046525,1.4276784471,0.264126002897,0.762576438167,1.12867678022,-0.770536890224,2.51193671669,-1.31303886711,1.09339276577,-0.732610170806,-0.202435762577,0.387852361939,-0.385139100967,-0.400509723441,-0.299562946008,-0.680006964421,0.211004028943,-0.176901737352,0.388735196387,0.403478352192,0.678396086926,0.385015604925,1.38773126327,1.02014853723,0.303321374002,0.69081841152,-0.723640073972,-0.0764901836057,-0.133625581003,-0.11458579722,0.203895226726],[-33668.5332016,-1032.4418815,-521.679867192,-2410.0791465,-529.702615901,856.573476866,1155.14581583,395.693383046,-1339.01514184,-25.9468960417,139.213705283,87.7364845772,-475.263128361,-1454.55319505,-417.046398932,-12.813325998,-494.106824349,-96.572092469,-721.474722756,123.91972644,185.738323552,178.880703526,100.657171443,-573.773632989,160.093607345,-118.731593514,28.0107654953,133.31105467,28.6364156869,387.630005908,22.6259334986,-152.34998511,-55.1414693394,29.3038111369,175.596860452,74.4428332326,-4.63759394063,99.506760636,9.5430104085,-8.5541642488,-23.6007239584,-23.2752023887,-35.7785166833,14.404686927,-19.4729755706,-10.5895997687,-24.3727458365,-88.6554338479,14.2397554796,8.94037569862,5.32103582886,-10.8601964166,-6.46891442285,-2.68305335139,-9.60974843186,28.425127355,-15.4946375532,-15.2202352641,-13.1189310069,-4.03086794222,-2.45991285325,13.1836561372,15.205326648,3.49441394256,1.65029948172,-3.63007672456,-4.3064743461,5.3164636896,-1.33015691533,-0.239366562185,2.04299864313,1.4668433006,-5.54818308648,10.1378632139,-0.682536183814,5.58323864546,0.657035722846,-2.3450339004,-1.25824395571,-1.32411861133,0.201423215924,-0.0982512782323,-0.75117781595,-1.47763867108,1.14515774613,-3.51299864888,0.30288958912,-1.64350241997,1.32280266406,0.771888745334,1.43071966596,0.238461811971,0.81424174942,1.09112323762,-0.756111294549,2.50046673451,-1.27785193646,1.10583783917,-0.725072806267,-0.211472243606,0.367779169133,-0.38261130115,-0.394804450455,-0.29131904162,-0.66949954678,0.212265170912,-0.170334178618,0.382664156376,0.40006480843,0.674882415383,0.369681429166,1.39094513846,1.00399178382,0.305582704455,0.683209330669,-0.718065402031,-0.070195678069,-0.13319392978,-0.118893180452,0.198800506644],[-33573.6275966,-1057.32231932,-534.382005072,-2439.77136812,-539.907071728,838.716307737,1166.65504074,389.680256016,-1313.52190766,-55.2785998302,138.271384609,88.7655440558,-485.840233196,-1464.20554964,-410.208781681,-15.5908661743,-486.609468546,-105.450435629,-717.992199394,133.620168611,182.711521093,186.902288466,97.3480962314,-564.996747636,158.006952144,-115.457773009,29.1042654301,129.351556886,27.1962717712,387.315165774,24.6203803422,-154.305189458,-56.6461306151,31.7641074929,174.034801353,73.8109623653,-3.12724285036,99.0588811445,10.122425274,-9.36703504821,-22.8705823408,-23.3919646438,-36.3470443943,13.3643535694,-19.2078098184,-9.62290202339,-23.6883045016,-88.1369411502,13.9871366833,9.34795746449,5.34568322604,-10.3615445042,-6.87833052657,-2.57074678378,-9.86505193762,27.9535554096,-15.4551611302,-15.5111640263,-12.7927383373,-3.9272432764,-2.2701443678,12.6827994866,15.2012149569,3.41054563608,1.67771189515,-3.63354078435,-4.11132531902,5.25941981913,-1.33780045216,-0.335009420762,1.99987456439,1.39909990368,-5.70385846726,10.1218095517,-0.720518920317,5.69942040015,0.555177045937,-2.29975848768,-1.2085902998,-1.2204439698,0.161001072925,-0.135625537044,-0.757767799209,-1.43211375307,1.15393022015,-3.47430698724,0.277607447598,-1.63510250146,1.30383101458,0.724022844525,1.42981975777,0.219487281408,0.869269467295,1.0571427656,-0.739275383574,2.48385583885,-1.23979773555,1.11783497381,-0.714261236255,-0.219802274087,0.345437163589,-0.380705600345,-0.389362932359,-0.28403384823,-0.658166028746,0.214654837091,-0.165162593813,0.377671405503,0.395860889261,0.670795023202,0.355930103877,1.39413390741,0.989341130818,0.30952155085,0.6748122065,-0.711088214242,-0.0637796017692,-0.131383262218,-0.122641392649,0.193257084802],[-33479.9778114,-1077.59330294,-536.417208009,-2472.12104615,-551.660281507,822.400508116,1180.12945148,391.285382856,-1287.15222016,-84.4944573133,138.147092123,90.5403434038,-495.419217121,-1469.63399739,-404.82222638,-18.4398008395,-479.101428638,-114.512252218,-714.334561572,141.975789883,179.548531382,193.797649699,93.3100519539,-557.224189453,155.889230986,-111.992792999,30.2198561717,125.116696189,25.3642180912,386.613765472,26.1048217021,-156.27599514,-58.5748492,34.0634581772,172.782151249,73.0536781017,-1.48355241412,98.6056225789,10.720689195,-10.2058771548,-22.1847209736,-23.6376045934,-36.9169567346,12.1538460346,-18.9561945904,-8.52366924372,-22.8353020451,-87.4852541535,13.6833596795,9.77599174499,5.39938019859,-9.82651461534,-7.25162660768,-2.46491540462,-10.1307410504,27.4800094802,-15.4603464315,-15.7653660328,-12.4537579196,-3.75416709981,-2.04155522222,12.1763129299,15.1751426433,3.31078654,1.69825281574,-3.63704444134,-3.89696657045,5.21229591134,-1.33804821025,-0.418473099661,1.95484362708,1.31834467698,-5.84203730915,10.0908073045,-0.736722005982,5.82673382527,0.459580465301,-2.25376115409,-1.16778695228,-1.11073151733,0.118669931291,-0.179001298624,-0.766423150699,-1.38369902509,1.16216391089,-3.43135577862,0.25707157912,-1.62915527122,1.28411794087,0.678251717989,1.42558484928,0.206917075549,0.927500244539,1.02755467179,-0.719228129637,2.46277404707,-1.19832229044,1.12936164391,-0.70017571579,-0.227368531723,0.321102674174,-0.379476544717,-0.384163515773,-0.277762337673,-0.646100470298,0.217954390579,-0.161474574711,0.373790816895,0.39058440663,0.666344386214,0.343577749476,1.39732805932,0.976345869925,0.315143825161,0.665871076121,-0.702510931192,-0.0573088343436,-0.128117010093,-0.125831349832,0.187330082678],[-33390.876551,-1095.98667974,-533.136607975,-2505.78281,-566.504809426,806.029987203,1193.86528471,397.715580753,-1259.49585202,-113.499656739,138.9541313,92.5103703919,-504.906682258,-1471.2595619,-401.846931866,-21.3118123212,-471.432959853,-123.490976297,-710.4652747,149.097072963,176.2656793,199.370292107,88.7904555608,-550.53147572,153.699726544,-108.327917573,31.4560749278,120.671675388,23.3110967225,385.55614266,27.0899874326,-158.156183901,-60.9497524016,36.2803635822,171.783324986,72.1528112825,0.27902098988,98.1587750739,11.3472314352,-11.0202214297,-21.5344017793,-23.9619598888,-37.4586198791,10.7746551247,-18.6674783445,-7.32307442812,-21.8199815261,-86.7224675617,13.3328446852,10.2164309627,5.47877994393,-9.25683980163,-7.5817416231,-2.36451613,-10.3866146163,27.0053392381,-15.5040264881,-15.9749404847,-12.1067682982,-3.51026596825,-1.7807353185,11.6693369552,15.133353867,3.19820914435,1.71089349552,-3.64254149439,-3.6654729042,5.17363915873,-1.33167771053,-0.487587140448,1.90540006275,1.22823770959,-5.96312854872,10.0454844327,-0.729467555822,5.96354679983,0.372864671889,-2.20442579161,-1.1341895222,-0.995062718719,0.0751962234035,-0.22785954522,-0.777454713547,-1.33301082649,1.16887650525,-3.38458737144,0.240927423489,-1.62631080061,1.26463785895,0.633616481906,1.41873523291,0.20070216654,0.988665089329,1.00339530958,-0.695153912255,2.43822830929,-1.15284006982,1.14043827709,-0.682952490758,-0.2340623865,0.2950722144,-0.378980136962,-0.379231419273,-0.27259231978,-0.633438412023,0.22189176176,-0.159323169491,0.371130078872,0.383944748591,0.661805393657,0.332478876224,1.40056881665,0.965224705071,0.322408696324,0.65671123806,-0.692129586418,-0.0508406400368,-0.123346567557,-0.12851190465,0.181098520693],[-33308.0183172,-1119.07716423,-533.417334101,-2538.44581604,-586.00181152,787.457098491,1205.65481915,404.448502283,-1229.82054322,-142.022243177,140.872041558,93.8960828134,-515.627597994,-1469.79062992,-402.541201665,-24.1249631101,-463.365109205,-132.060997545,-706.341151685,155.080988545,172.829108503,203.287161234,84.0721012524,-545.060861064,151.384713902,-104.431134444,32.9206492662,116.102730551,21.2208940724,384.174690934,27.5628245218,-159.838493905,-63.8135754491,38.5166208748,170.953652303,71.0829099901,2.14797710616,97.7309629083,12.0153529038,-11.7516034763,-20.9063443958,-24.3148934945,-37.9447485633,9.21775879173,-18.2862986157,-6.06867616083,-20.6528156896,-85.8773085105,12.9379696589,10.6595341474,5.58065768691,-8.65382802935,-7.86034719165,-2.26667672883,-10.6108819088,26.5299435459,-15.5822048064,-16.131909911,-11.7602062211,-3.19431272468,-1.49745198268,11.1681675015,15.0834011533,3.07572547857,1.71397406505,-3.65216072629,-3.41914380281,5.14207301156,-1.3192411039,-0.539532851205,1.84926177531,1.13269595494,-6.06783124686,9.98609797342,-0.697032458666,6.1070962556,0.297727177167,-2.1490582217,-1.10578822716,-0.873517572335,0.0314538951477,-0.281819855308,-0.791220979879,-1.28082354614,1.1730118635,-3.33450462887,0.228989711065,-1.62715294578,1.24659666836,0.589073793224,1.41001305593,0.200918978947,1.05221832652,0.985837084749,-0.666409659202,2.41148891954,-1.10289366106,1.15110346927,-0.662850668909,-0.239720231332,0.267633399029,-0.379281364182,-0.374636547899,-0.268637128456,-0.620361612863,0.226186800075,-0.15873346958,0.369865739631,0.375650014333,0.657499543934,0.322527781088,1.40387738342,0.956241204436,0.331196792645,0.647721067783,-0.679787477438,-0.0444200403047,-0.117058137846,-0.13076900856,0.174659125138],[-33232.5669685,-1150.06970082,-543.323946552,-2569.16692998,-610.519534444,764.775005396,1214.27793317,407.589755829,-1197.74493298,-169.886346531,143.912634076,94.154758854,-528.534302769,-1466.09483125,-407.737659557,-26.8490090066,-454.82699433,-139.980542172,-701.912335195,160.054480811,169.151070326,205.304804421,79.3747755908,-540.897182616,148.903187845,-100.318425752,34.6889875012,111.482294297,19.2388294856,382.499645403,27.526430482,-161.241811993,-67.1675753102,40.8602152488,170.203270625,69.8289136862,4.10716249741,97.3312306841,12.7272219624,-12.3548568798,-20.2853833287,-24.6510076376,-38.3579510985,7.48194197403,-17.773128865,-4.80990737887,-19.3555898581,-84.979922609,12.5032202562,11.0972226672,5.70368374584,-8.02162427335,-8.08205423734,-2.16784850294,-10.785998224,26.0530911342,-15.6915610627,-16.2329540846,-11.4222624724,-2.8095489374,-1.20339993492,10.6785850282,15.0320626015,2.9462148983,1.70694535624,-3.66726178207,-3.16049643424,5.11627448998,-1.30129962381,-0.572667387685,1.78478701865,1.03497533932,-6.15765155236,9.91321250885,-0.639426104382,6.25390691472,0.235855518461,-2.0854781856,-1.08065705033,-0.746439614476,-0.0118177390822,-0.340248010431,-0.8079256348,-1.22781245902,1.17374372932,-3.28170485453,0.220992876038,-1.63202840497,1.23091049914,0.543608929929,1.40012417514,0.207299564329,1.11740786621,0.97564696805,-0.632708400091,2.38375624371,-1.04841032706,1.16136482373,-0.640310389909,-0.244222993621,0.239078285915,-0.380449925354,-0.370397836195,-0.265926653699,-0.607090461115,0.230592201287,-0.15967466616,0.37010317783,0.365489785141,0.653705315046,0.313614202763,1.40724888496,0.949548190988,0.341293961834,0.639237114042,-0.665465909401,-0.0380826753211,-0.109328512923,-0.132699707501,0.168106665734],[-33164.4314424,-1182.09689822,-563.178113968,-2599.33761546,-638.636763997,737.358627154,1220.27471684,406.026466019,-1163.71639901,-197.131245849,147.928107169,93.2628887934,-543.70805997,-1461.1101762,-417.354750994,-29.5255515696,-446.03970335,-147.17487431,-697.123831622,164.218763498,165.10265137,205.454373157,74.8292137985,-537.969405573,146.242083062,-96.0956308388,36.7758540386,106.844910613,17.4530080027,380.550854225,27.0117673595,-162.331512027,-70.9393125642,43.3550009305,169.452601542,68.3915599169,6.13385660645,96.9598763044,13.4659986681,-12.8130072134,-19.6577823706,-24.9339192479,-38.6948795928,5.5852479924,-17.1143478195,-3.58783359172,-17.9674250869,-84.0590897855,12.0372027682,11.5256390005,5.84856472086,-7.36913491814,-8.24625928176,-2.06436440017,-10.9010017245,25.57251912,-15.8290218997,-16.2820447146,-11.0978452312,-2.36698279253,-0.910609905946,10.2046969,14.9847012997,2.81261747433,1.69110444778,-3.68759850291,-2.8920922573,5.09486312237,-1.27830113871,-0.587332798037,1.71113758705,0.936963541463,-6.23483711695,9.82830104962,-0.559074839633,6.40018663396,0.187247345211,-2.01235907739,-1.05720144417,-0.614757209088,-0.0541120091484,-0.402059856025,-0.827446839964,-1.1743008072,1.17059006962,-3.22683142493,0.216492223044,-1.64080818606,1.21794409897,0.496416947041,1.38969223659,0.219054514175,1.18339449958,0.972824482402,-0.594139817133,2.35597403452,-0.989840675423,1.17118768377,-0.616035155334,-0.247530335401,0.209709551756,-0.382558948382,-0.366427474656,-0.264346469144,-0.593849220452,0.234925199646,-0.162027430612,0.371810288452,0.353385100647,0.650585050353,0.305620078622,1.41068362879,0.945094305887,0.352392926188,0.631452354193,-0.649342041113,-0.0318721387047,-0.100378243295,-0.134397422465,0.161524969338],[-33101.7485486,-1210.25628694,-590.637773053,-2629.90965662,-669.006845182,705.247753373,1224.06696634,398.780535684,-1128.05438305,-223.708481154,152.781283309,91.0641917259,-560.922877856,-1455.86750514,-431.076467206,-32.1308182622,-437.268126163,-153.582688087,-691.996129755,167.791881401,160.440586375,203.738476484,70.4850944093,-536.197953378,143.389874823,-91.8679252323,39.1687519909,102.202543108,15.9210023456,378.311359399,26.0163337496,-163.093875938,-75.0506241342,46.0314834559,168.613679866,66.7701143136,8.21128421127,96.612438842,14.2105880118,-13.1187053526,-19.0130715547,-25.1381424759,-38.9598296422,3.54244075382,-16.3106435295,-2.44314154818,-16.5362968875,-83.1404504091,11.5472608423,11.9428324706,6.01672492621,-6.7046911471,-8.35143586682,-1.95216632329,-10.9478824602,25.0849278665,-15.9955195444,-16.2852002595,-10.7920598449,-1.88014911211,-0.632541478212,9.75002029052,14.9448985784,2.67709663788,1.66760506117,-3.71214724723,-2.61587953216,5.07677576203,-1.25012542726,-0.583833244015,1.62823954109,0.839302651772,-6.30089271144,9.7324723372,-0.458995846454,6.54162041584,0.151218455408,-1.92875389664,-1.03384198138,-0.479585396822,-0.094974126276,-0.466308008367,-0.849607592732,-1.1204295041,1.16320555151,-3.17037877332,0.215396873111,-1.6530040887,1.20791812361,0.44703083213,1.37915309504,0.235409447465,1.24926484408,0.977049413365,-0.551039017269,2.32890036305,-0.928020001485,1.18046414298,-0.590890955928,-0.249551914907,0.179770796084,-0.385698955567,-0.362659989094,-0.263768927014,-0.580835484194,0.239103053266,-0.165655887769,0.374996362277,0.339333120212,0.64822971463,0.298515877567,1.41416550014,0.942756679529,0.364134685367,0.624491275918,-0.631700045484,-0.0257885001735,-0.0905103895746,-0.13592988629,0.154987686608],[-33042.172759,-1234.76343727,-620.22506473,-2660.59800147,-701.127044806,669.67862463,1225.91931403,386.286837682,-1090.71362928,-249.518205542,158.457718509,87.1489370234,-579.476534594,-1451.45790765,-448.306294961,-34.5425970711,-428.759089828,-159.167966588,-686.617611041,171.031393692,154.876587492,200.209317618,66.3792048051,-535.468014647,140.338528944,-87.7193242777,41.8257008669,97.5539331817,14.6778406177,375.735900347,24.5322595118,-163.52974218,-79.3906561314,48.9050560325,167.622457664,64.9600453564,10.3298057184,96.2793299229,14.9395371473,-13.2757069765,-18.3441688571,-25.2450669844,-39.1599062571,1.37434714666,-15.3702864422,-1.40627546837,-15.1125796194,-82.2427969434,11.0387180412,12.3485154625,6.20957646862,-6.03497917278,-8.39608615729,-1.82636249893,-10.9212017916,24.5872672907,-16.1930587977,-16.2487369049,-10.5065166494,-1.36282975793,-0.379814635732,9.31864546669,14.9165488038,2.54115569034,1.63729577753,-3.73930844295,-2.33316614432,5.06118757843,-1.21595659293,-0.562518820119,1.53661388192,0.741718446065,-6.35627651499,9.62716162515,-0.342164581231,6.67445327451,0.126760322096,-1.83345323953,-1.00923182321,-0.342004100276,-0.133927752925,-0.532255457858,-0.874137518783,-1.06623272225,1.15137410997,-3.11268863929,0.217847862196,-1.66785836481,1.20083248407,0.395379618873,1.36879995636,0.255752517551,1.31426381918,0.987852110897,-0.503570333412,2.30318276931,-0.863873049578,1.18905457572,-0.565777192796,-0.250139060872,0.149451614309,-0.389953425237,-0.359065268072,-0.264061309145,-0.568224754632,0.243120514992,-0.170413299021,0.379673911695,0.323398037858,0.646642402893,0.292367700039,1.41769903311,0.942378110581,0.376233266826,0.618425023666,-0.612817380011,-0.019815357255,-0.0800347283709,-0.137349659236,0.148586654631],[-32984.5570903,-1255.29524146,-647.041583088,-2690.85026001,-734.630273366,632.105328171,1226.71006165,370.485660321,-1051.57748335,-274.620674691,164.953486039,81.2734864527,-598.397779367,-1448.70659937,-468.243345462,-36.6065599371,-420.815891864,-163.936789304,-681.055775553,174.140243587,148.191601814,194.990173789,62.6033626918,-535.596767948,137.093597848,-83.737111499,44.6781529324,92.882653198,13.7183111204,372.779463871,22.5565603286,-163.630372476,-83.8152609725,51.9833654778,166.446279335,62.9596279673,12.4810851691,95.9470376404,15.625781078,-13.3014872137,-17.6455260987,-25.2455719941,-39.3004877878,-0.889903245205,-14.3013867109,-0.490435550129,-13.7442605964,-81.3751900902,10.5164924483,12.7445433978,6.42872019611,-5.36688916012,-8.38047229841,-1.6825963036,-10.8193851869,24.0769704301,-16.4228186167,-16.1774280245,-10.2376087521,-0.828442487851,-0.158497726109,8.91481349564,14.9051481163,2.40607496108,1.60161117726,-3.76704421956,-2.04494343472,5.04750776895,-1.17487748292,-0.524234884902,1.43693130948,0.643145672272,-6.40070394353,9.51437565232,-0.211390949632,6.79617715464,0.112815126406,-1.72458459851,-0.982215522755,-0.203092026719,-0.170502857319,-0.599182987756,-0.900616007311,-1.01158623701,1.13512193258,-3.05406232585,0.223972208699,-1.68458333694,1.1963136052,0.341642935404,1.35879889719,0.279678525968,1.37790300484,1.0046632544,-0.451614957658,2.27931647713,-0.79825346876,1.19675897871,-0.541506056026,-0.249155068296,0.118900278362,-0.395379665621,-0.355581627461,-0.265055449541,-0.556175142634,0.247009421478,-0.176159532744,0.385801501103,0.305686014321,0.645719933895,0.287296105965,1.42130463736,0.94375662893,0.38850002163,0.613267679458,-0.592919744903,-0.0139592372466,-0.0692441579669,-0.138713783329,0.142419625808],[-32929.6587054,-1269.96746296,-670.150189743,-2720.34438089,-769.03925798,593.077863766,1228.05422128,352.911116958,-1010.52766029,-299.222347147,172.143681771,73.5434536008,-616.923862166,-1448.14626489,-490.26598571,-38.1676546192,-413.816013298,-167.915165539,-675.332406482,177.188832335,140.22098353,188.144515556,59.284937702,-536.413094774,133.673164113,-80.0247552331,47.644214685,88.1610410304,12.9911807683,369.402982834,20.0718960501,-163.374246146,-88.1836097967,55.2700966406,165.065866638,60.7721747498,14.6557428647,95.6005707188,16.2354071356,-13.22334075,-16.9129147981,-25.140309387,-39.3879221301,-3.21899195647,-13.1132761885,0.300847051479,-12.4734230233,-80.5391354475,9.98550147786,13.1345929674,6.67602301608,-4.70858300696,-8.30640007931,-1.51751153712,-10.6440131774,23.5509913356,-16.685495477,-16.0749314707,-9.97970740777,-0.289263760448,0.0274755331739,8.54281740036,14.9163725707,2.27298440414,1.56273929082,-3.79311767342,-1.75219752897,5.03551783508,-1.12608384902,-0.470221527807,1.32968890529,0.542043649308,-6.43358384501,9.39620490185,-0.0693271491673,6.90482207136,0.108425487397,-1.60017192512,-0.951925440372,-0.0639528732152,-0.204283983229,-0.666336162013,-0.928496912575,-0.956248636602,1.11469618502,-2.99480142599,0.233828136839,-1.70248512207,1.1937243117,0.286131657622,1.34921042878,0.306887303059,1.43972517613,1.02681697319,-0.395045436425,2.25757839495,-0.731998429447,1.2032699038,-0.518788869714,-0.246498305824,0.0882384945433,-0.402005012495,-0.352103003062,-0.266560369948,-0.544830004214,0.250806176,-0.182746182471,0.393288718418,0.286326291453,0.645298252238,0.28343910983,1.42498426609,0.946646373274,0.400777370645,0.608978856254,-0.572218743677,-0.00825699225151,-0.0584195974324,-0.140095239128,0.136581716445],[-32878.7486574,-1278.63125276,-691.240112971,-2748.7903102,-803.834922409,552.42443642,1231.5500226,334.368892102,-967.278167055,-323.5025728,179.847016654,64.1368572014,-634.451852589,-1450.08681305,-513.906723371,-39.0677774121,-408.15212752,-171.113343984,-669.46208732,180.1799666,130.812863309,179.655166,56.5584819919,-537.808385114,130.091964392,-76.688380172,50.6442203877,83.3579717508,12.4091292075,365.56176185,17.0517265883,-162.729556128,-92.3666346982,58.7634305825,163.468951102,58.4031326396,16.8464769885,95.2234484784,16.7339365051,-13.0728168794,-16.1450387515,-24.9324505921,-39.4304132805,-5.57912527511,-11.8229452029,0.969273802688,-11.3366274686,-79.7293879329,9.45037403595,13.5234210601,6.95329071839,-4.06830017346,-8.17630040849,-1.32850824217,-10.3981218976,23.0048247469,-16.9806506218,-15.9454765804,-9.72697671849,0.244107248581,0.174847705959,8.20725861588,14.9550533034,2.14296178585,1.52318040353,-3.81528305181,-1.4557188302,5.02531918788,-1.06891492146,-0.401934598285,1.2151275966,0.436835855706,-6.45428911045,9.27449521499,0.0813230810321,6.99842644631,0.112693315421,-1.4582414164,-0.917800004161,0.0744482335571,-0.234899258549,-0.732969965954,-0.95721147051,-0.899899871112,1.09046985493,-2.935151259,0.247384687503,-1.72097431506,1.19231721904,0.229199858867,1.33997649303,0.337010035334,1.49918980775,1.05354550879,-0.333815217146,2.23801465902,-0.666007024269,1.20814588723,-0.498270031902,-0.24209569461,0.0575670089665,-0.409830080844,-0.348507524168,-0.268374773132,-0.534314696442,0.254525084072,-0.190022271202,0.401994146266,0.265461827385,0.645184507814,0.280906051222,1.42869949944,0.950760686784,0.412915494445,0.605465424853,-0.550927749873,-0.00276093502185,-0.04782624679,-0.141570140045,0.131174551262],[-32832.357834,-1283.85232457,-710.814397734,-2775.3329888,-838.571305138,509.881709931,1237.75335676,315.941729354,-921.306035653,-347.565663406,188.053175112,53.0684407343,-650.237574025,-1454.73324462,-538.904334624,-39.1601761108,-404.156303012,-173.520920006,-663.453096054,183.099752058,119.752994032,169.44590354,54.513317584,-539.735303036,126.353435858,-73.8159727213,53.5906053493,78.4442350188,11.8661212017,361.19694474,13.4733320948,-161.67248743,-96.2592733061,62.4407896566,161.634391764,55.8570013252,19.0465081395,94.7953577269,17.0913703134,-12.8818635395,-15.3441018018,-24.6246838228,-39.4451766981,-7.93847664359,-10.4587158171,1.518387869,-10.3648579344,-78.9355065269,8.91418634737,13.915563977,7.26149279725,-3.45300526042,-7.99399255448,-1.1130839052,-10.0851502367,22.4317502705,-17.3060248408,-15.7951702127,-9.47432214851,0.76188718969,0.279967794529,7.91285669794,15.0249658627,2.01707876317,1.48548182672,-3.83144867862,-1.15606289323,5.01699782596,-1.00251016267,-0.320637009484,1.09322223929,0.326173132071,-6.46278242333,9.15066176829,0.237626531405,7.07492796913,0.125122632938,-1.2970664474,-0.879344842209,0.210957546553,-0.261917836114,-0.798414889737,-0.98613700053,-0.842218154307,1.06287482457,-2.87521337815,0.264483192426,-1.73953300701,1.19132116616,0.171102019418,1.33098139706,0.369620013249,1.5556208364,1.08407873664,-0.268069297908,2.22047713031,-0.601283312936,1.2108515943,-0.480486447546,-0.235881703514,0.026962965256,-0.418808075779,-0.344673106226,-0.270309934219,-0.524737490216,0.258124208165,-0.197803303255,0.411752396031,0.243251118937,0.645186503144,0.279751296103,1.43237019189,0.955777911942,0.424745151224,0.602613213029,-0.529288866735,0.00248051730185,-0.0377230120708,-0.143214714251,0.12629540938],[-32789.9542888,-1284.50527681,-729.441596623,-2799.55255296,-871.743500321,465.237537646,1247.78308725,299.372264682,-872.352192304,-371.438478169,196.873182342,40.7292642668,-663.412846791,-1461.9841091,-564.879334098,-38.3781022381,-402.172101534,-175.140796725,-657.219257781,185.908172444,106.920089251,157.492964626,53.2816971984,-542.144312599,122.453062133,-71.5160175887,56.378863835,73.400237123,11.2423866813,356.277922233,9.33340959608,-160.165242627,-99.7553238587,66.2666287192,159.545993937,53.1419151144,21.2385107867,94.2920543437,17.2747112993,-12.6863598691,-14.5107545033,-24.22014618,-39.4487711222,-10.2597022024,-9.05114002469,1.95716147181,-9.58452981488,-78.141365594,8.38107498348,14.3141265419,7.6005849354,-2.87221919368,-7.76599570655,-0.869231422431,-9.70970074249,21.8256591435,-17.6564967031,-15.6292731022,-9.21499556086,1.25552326799,0.341881618015,7.66469530744,15.1300558048,1.8970752929,1.45260408095,-3.83938876515,-0.854542463548,5.01026868344,-0.926405804726,-0.228088631987,0.963988739118,0.209072940164,-6.45895514185,9.02671840929,0.396951697163,7.13316767798,0.145604662658,-1.11488869229,-0.836140673635,0.34440486235,-0.284787280504,-0.861749623857,-1.0145104398,-0.782934601359,1.0323758807,-2.81524808381,0.284636375502,-1.75771534395,1.18984771708,0.112163710866,1.32219000614,0.404368214595,1.60850553956,1.11769836494,-0.197900840233,2.20477339698,-0.538742514365,1.21085286309,-0.46588619347,-0.227833217742,-0.00341935706674,-0.428843793276,-0.340437847049,-0.272162787206,-0.516236789705,0.261478966274,-0.205905123994,0.422308297522,0.219877868643,0.645099157388,0.280012825519,1.43595622162,0.961378736046,0.436162417388,0.600302586383,-0.507505883474,0.00740576187657,-0.028332839563,-0.145114551112,0.122051323247],[-32750.7826631,-1275.11325562,-749.45325997,-2821.66881148,-901.07596507,418.309033369,1262.70617644,286.665019501,-820.545525567,-395.091730411,206.470276084,27.890343052,-673.174267518,-1471.36919864,-591.315991851,-36.7382466778,-402.510600088,-175.990961931,-650.583420263,188.503961305,92.3123139883,143.836244648,53.0405432128,-544.9712216,118.386772703,-69.9043655065,58.8889865027,68.2229066398,10.4161706593,350.802762528,4.64289955432,-158.158157097,-102.763886854,70.193585134,157.184510017,50.2705034441,23.3950064074,93.6863569557,17.2502708482,-12.522815577,-13.6447379126,-23.7257556046,-39.4556951147,-12.5019508853,-7.62912691023,2.29906775753,-9.015864263,-77.3263128294,7.85627026538,14.720220914,7.96923980199,-2.33746267181,-7.50085014739,-0.596231695527,-9.27730316552,21.181458414,-18.0243348324,-15.4509415167,-8.9412892936,1.71772715181,0.362252784994,7.46759243358,15.2742935115,1.78523381563,1.42762267372,-3.83678756397,-0.553296153156,5.0043623735,-0.840617746581,-0.126347014293,0.827560151384,0.0850332435118,-6.44254461454,8.90518663693,0.557280921507,7.17286880364,0.174586363562,-0.910039882459,-0.787645596232,0.473513801585,-0.302861873767,-0.921857580411,-1.04145238448,-0.721844800296,0.999432355134,-2.75567079479,0.307088599015,-1.77512355606,1.18692908918,0.0527818849859,1.31367533503,0.441062100333,1.65749622226,1.1537580198,-0.123383361085,2.19070866132,-0.479147348081,1.20763699278,-0.454802527015,-0.217984739853,-0.0333481313593,-0.439805578819,-0.33561184924,-0.27373289134,-0.508958673187,0.264389865874,-0.214147024189,0.433334450539,0.195538198753,0.64472001033,0.281716393113,1.43944088758,0.967262163292,0.447117225038,0.598419371677,-0.485723426074,0.0119385339899,-0.0198475037902,-0.147357007521,0.118549755918],[-32715.0044325,-1253.06545714,-774.277412127,-2841.61716978,-925.56506753,369.030051011,1281.51408464,279.502183825,-766.024916237,-418.555982384,217.096988932,15.1267861178,-679.006729137,-1482.39074187,-617.748572664,-34.2304008792,-405.310227899,-176.082921765,-643.400792185,190.720007258,75.8826183203,128.551866341,53.9372518329,-548.171009592,114.169757665,-69.0470619422,60.9998421329,62.9229533219,9.29010405506,344.757979177,-0.581133253224,-155.626189047,-105.245136759,74.1533037921,154.503508685,47.2558469108,25.4901576937,92.9529041005,16.9943442516,-12.4187581519,-12.7518222831,-23.1533149451,-39.4888676618,-14.6311509705,-6.22183679985,2.55224065738,-8.67160770089,-76.4684003931,7.34299015806,15.1334918265,8.36514411567,-1.85775567425,-7.20666737099,-0.294591421825,-8.79275841281,20.49321384,-18.4008275891,-15.2628157589,-8.64882209793,2.1415042742,0.343268333039,7.3254419621,15.4605624206,1.68342515452,1.41288009981,-3.82154927301,-0.254342075559,4.99838046606,-0.744867819128,-0.0167917348336,0.684035066562,-0.0458071528044,-6.41382695475,8.78807491476,0.716892511147,7.19380327885,0.213142553651,-0.681770667803,-0.73301264694,0.596697332116,-0.315520167068,-0.977840466607,-1.0661020527,-0.658783170081,0.964442537909,-2.69674251625,0.331114558704,-1.79133138458,1.1817766802,-0.00673779439003,1.30551966217,0.479557444743,1.70209818961,1.19167409582,-0.0448692223464,2.17814949876,-0.423157246684,1.20075087005,-0.447429135796,-0.206395308423,-0.0626108226278,-0.45156237481,-0.330045152723,-0.274886047077,-0.502982919375,0.266637968526,-0.222303121346,0.444547229187,0.170411963473,0.643889968794,0.284829884969,1.44274792404,0.973146618145,0.457515035287,0.596899558406,-0.46408443544,0.0160012802405,-0.0124521723425,-0.15002930046,0.115883246105],[-32684.17838,-1219.08943527,-806.442996869,-2859.41965676,-945.280393341,317.583077596,1302.0302917,278.615773381,-708.930460059,-441.935956349,228.915978546,2.78965902028,-680.768571982,-1494.55248039,-643.629631762,-30.8004344793,-410.566958357,-175.46019463,-635.557430082,192.34838866,57.5781203892,111.749279985,56.0596610068,-551.722290521,109.837518331,-68.963292024,62.5888903567,57.5188604144,7.78842045603,338.1179254,-6.32135993143,-152.573390536,-107.195642574,78.069249841,151.442230396,44.1131339522,27.5020983731,92.0682996693,16.4905206493,-12.3930290797,-11.8425644836,-22.520655297,-39.576943794,-16.6214792521,-4.8576109658,2.71913463417,-8.55765772919,-75.5442247241,6.84295080586,15.5521665826,8.78582900701,-1.440064369,-6.89090962653,0.0336184680808,-8.26120999143,19.7544217737,-18.7767931269,-15.066819215,-8.33561419335,2.52126243146,0.288196865539,7.24077107862,15.6897587679,1.5928818393,1.40992520332,-3.7916183329,0.0403525365479,4.99117852725,-0.638916250343,0.0996022141841,0.533767956194,-0.182763312983,-6.37329213297,8.67676096373,0.874315495937,7.19590659166,0.262384560866,-0.430354839622,-0.67116677105,0.712387434461,-0.322268607514,-1.02898358249,-1.08762991655,-0.593605985478,0.927719684813,-2.6385640471,0.356110004829,-1.80581610923,1.17376885119,-0.0661564969593,1.29782848236,0.519737878854,1.74178844102,1.23091071105,0.0370063635775,2.16705095239,-0.37132851454,1.1897999125,-0.443845610954,-0.193145282909,-0.0910102686693,-0.463981801107,-0.323608273936,-0.275531936256,-0.498320329264,0.26801886628,-0.230118058881,0.455697055651,0.144660860437,0.6424905667,0.289277099631,1.44573308417,0.978756318051,0.46721080448,0.59572078569,-0.44272057384,0.0195215137746,-0.00629819672751,-0.153201471669,0.114126946924],[-32659.4452552,-1174.71055392,-847.412138396,-2875.21526314,-960.56138486,264.88037458,1322.0987186,284.012849722,-649.517325444,-465.257193578,241.976132407,-8.87430009161,-678.722987431,-1507.40335536,-668.364266691,-26.386175648,-418.130357305,-174.225518055,-626.930990215,193.159584313,37.4215144691,93.5991503849,59.437856672,-555.604446696,105.446443379,-69.6333978309,63.5366203582,52.0356206931,5.86192250603,330.84831236,-12.5503402473,-149.046232508,-108.624833272,81.8578769709,147.948972009,40.8622793446,29.4103367847,91.0120367579,15.7278069969,-12.4564922766,-10.9328515725,-21.8516349551,-39.7522844458,-18.4517248488,-3.56119558907,2.79867564173,-8.67244155084,-74.5306557138,6.3568583129,15.9730133426,9.22860161412,-1.08978759204,-6.56091190034,0.384188003119,-7.68913725868,18.958912931,-19.1416003183,-14.8642530858,-7.99984462149,2.85274889183,0.203118327904,7.21464786198,15.9610971905,1.51422199185,1.41972014463,-3.74512646365,0.328654270773,4.98150146982,-0.522986699824,0.221928839516,0.37728840125,-0.324640540166,-6.32175675145,8.57230970688,1.02812341939,7.17957090831,0.322985928954,-0.157266710789,-0.60121882836,0.819002051876,-0.322828925369,-1.074724151,-1.10523765676,-0.526252595826,0.889526605534,-2.58114006689,0.381530607308,-1.81803768367,1.16238890058,-0.125268784693,1.29083870245,0.561489634346,1.77616545413,1.27092055512,0.121397376726,2.15743740362,-0.324085297863,1.1744816168,-0.44399185139,-0.178361717923,-0.118354475827,-0.476919953252,-0.316178962766,-0.275620530435,-0.494922974531,0.268368727343,-0.23732486681,0.466552033441,0.118437194141,0.640457328006,0.294935514821,1.44821604969,0.983777261509,0.476043079476,0.594856473245,-0.421752329868,0.0224015592317,-0.00148374207703,-0.156927174005,0.113335781578],[-32637.202542,-1120.16523553,-896.528706054,-2888.65640108,-970.775405402,212.904996766,1340.335196,295.432206087,-588.281022744,-488.075965507,256.393297744,-19.4225435603,-673.242204459,-1520.37195313,-691.29137682,-20.998163687,-427.662989938,-172.519857375,-617.314452937,193.001159633,15.5934108949,74.4162625067,64.0602911693,-559.756069166,101.053314774,-71.0107450916,63.7275105174,46.5208156501,3.50792282534,322.934872524,-19.19478403,-145.125571045,-109.533293511,85.4343771704,143.993072801,37.5280845631,31.1887242509,89.7657575488,14.7020887236,-12.6110084126,-10.0409645429,-21.1658548512,-40.0479143912,-20.0961022193,-2.35253715092,2.79199606365,-9.0068673846,-73.4039232214,5.88528556481,16.3898113181,9.68943239478,-0.811402532862,-6.22470653733,0.750971251706,-7.08333200482,18.1019945335,-19.4811994174,-14.6567389019,-7.63778558791,3.13216311679,0.0983037506577,7.24655258262,16.2728338266,1.44781143102,1.4424899326,-3.68058478955,0.607868673939,4.96768382508,-0.398109969154,0.349046691772,0.215213833901,-0.469323812459,-6.26061795486,8.47632944345,1.17671181594,7.14643287324,0.395047043254,0.135121655338,-0.522720079773,0.915046304986,-0.317093453886,-1.1145931195,-1.1181694019,-0.456872000614,0.849978795714,-2.52449901788,0.406749719446,-1.82752118606,1.14730321996,-0.183953951915,1.28508792581,0.604539771075,1.80519467815,1.31102776133,0.207408182828,2.14930465014,-0.281674165981,1.15458934216,-0.447635030983,-0.162222704781,-0.144422251808,-0.490201997687,-0.307656047276,-0.275156936016,-0.492698396813,0.267535350666,-0.243670532431,0.476881193276,0.0918755085411,0.637806586726,0.301607043571,1.45006209823,0.98783307992,0.483894259338,0.59424152616,-0.401293061619,0.0245061369707,0.00195157089419,-0.161247725943,0.113535724021],[-32613.440677,-1055.73669227,-953.22324949,-2899.66386604,-975.63268238,163.852860216,1355.71926845,312.382171429,-526.038590823,-509.944990867,272.200000296,-28.529144807,-665.131465416,-1532.86422101,-711.850109608,-14.6703146724,-438.705576038,-170.545780796,-606.529461353,191.691267127,-7.60033392869,54.5784954566,69.9019944086,-564.11938874,96.7363206347,-73.0188719828,63.0645195065,41.0284078429,0.746270361094,314.377525023,-26.1764291627,-140.925239128,-109.938498133,88.7089599535,139.563539572,34.1425949598,32.8134826888,88.3181634687,13.4184322788,-12.8533434316,-9.191977195,-20.4887285163,-40.4945401896,-21.5347565694,-1.24376913846,2.69633646237,-9.54312536231,-72.1431848957,5.42865391204,16.7957065402,10.163639722,-0.607032731164,-5.88961929545,1.12586564396,-6.45210606166,17.1812338033,-19.7819841276,-14.4452545498,-7.24748293278,3.35762515184,-0.0126890814622,7.33520915962,16.6226016077,1.39336728895,1.47774654688,-3.59693035425,0.875410896302,4.9483688004,-0.265899826592,0.479711565786,0.0481848634733,-0.614453945667,-6.19122071444,8.3901012683,1.31903566341,7.09881919969,0.478411742223,0.443396194104,-0.435745897295,0.999044192585,-0.305278996227,-1.14834277898,-1.12578198286,-0.385735541188,0.809175168204,-2.4686262149,0.431285324327,-1.83385963404,1.12838471164,-0.241987653196,1.28111312577,0.648695702859,1.8289671281,1.35062540197,0.294118031897,2.14273593922,-0.244177259742,1.13006762386,-0.454397606382,-0.144952889646,-0.169028065271,-0.503642270178,-0.297978357944,-0.274190791708,-0.491481105602,0.26545627927,-0.248919544202,0.486496798839,0.0651212058135,0.634602643272,0.309098479975,1.45114454294,0.990588411382,0.490678307861,0.593823440653,-0.381456291007,0.025668825664,0.00403755612143,-0.166191528757,0.11474565342],[-32584.5634775,-982.917887132,-1015.1806327,-2909.03506926,-975.105213291,119.885847327,1367.72867774,333.376940899,-463.827124091,-530.394649731,289.252930512,-36.0520189573,-655.540865594,-1544.21104841,-729.446253767,-7.45053335285,-450.720967528,-168.531259701,-594.488525869,189.028533968,-31.7485157696,34.4707019763,76.8842648397,-568.635791847,92.5903935878,-75.5527554496,61.4820080723,35.6105952171,-2.39127189301,305.190744322,-33.4185013098,-136.574465101,-109.863483922,91.601869266,134.673205,30.7458482887,34.2670352624,86.6660906375,11.8904258087,-13.1723617672,-8.41753139376,-19.8486293846,-41.1173135515,-22.7529213653,-0.242886126935,2.50710935298,-10.2579757095,-70.7289468865,4.98747281205,17.1832593626,10.6464056507,-0.476508318712,-5.56087570203,1.49815450019,-5.80542504714,16.1964608024,-20.0320628762,-14.2297888557,-6.82892011893,3.53008363931,-0.113797062547,7.47881207606,17.0062963441,1.34976194275,1.5242485183,-3.49363424819,1.12898513553,4.92268055448,-0.128756706843,0.612561916288,-0.123092125231,-0.7575011534,-6.11461019683,8.31457601374,1.4546857101,7.03981396169,0.572613759587,0.763456132028,-0.340977284948,1.06979018448,-0.287976832131,-1.17592111748,-1.12762809742,-0.313210430018,0.767206264748,-2.41348507124,0.45490689128,-1.83677372906,1.10574585136,-0.299054947474,1.27940980887,0.693856584788,1.84771993572,1.38920446414,0.380586629819,2.13781270074,-0.211607688894,1.10096892207,-0.463816286108,-0.126813639355,-0.192023297155,-0.517062013947,-0.287126976491,-0.272814382229,-0.491029169042,0.262186662096,-0.252882394789,0.495257745256,0.0383276314457,0.630944693517,0.317262240121,1.45133492094,0.991784524391,0.496341682674,0.593556083252,-0.362342963667,0.0257172923366,0.004885162558,-0.171747392745,0.116974434569],[-32547.8547117,-904.802694503,-1077.62914044,-2918.1223092,-969.659908684,82.977462336,1375.51766583,355.977436895,-402.793160662,-549.010551908,307.221295694,-42.1326946737,-645.899467507,-1553.5432654,-743.667349669,0.579799684881,-463.075758849,-166.691523237,-581.2377652,184.800360395,-56.3589277581,14.4382004586,84.8401305206,-573.228886902,88.7230899499,-78.4676084818,58.9598033112,30.3118216585,-5.8587697668,295.407043472,-40.841418195,-132.210201271,-109.353147228,94.0468002267,129.356114323,27.3852687974,35.5396499274,84.817242335,10.1431895269,-13.5469108286,-7.75344966025,-19.2760517826,-41.9323626545,-23.7468170571,0.645797418414,2.22361987235,-11.1186875095,-69.1429411885,4.56254577677,17.5443039327,11.1326640591,-0.415677929871,-5.24144556984,1.8540384014,-5.15448506779,15.1504819719,-20.2218476939,-14.0096683069,-6.38405130225,3.6538008942,-0.187851427094,7.67417543423,17.4178425668,1.31516112735,1.57997649476,-3.37125616708,1.36666878173,4.89030750558,0.00998137430947,0.746232071143,-0.297717008238,-0.895788071036,-6.0317591829,8.2500374748,1.58399741839,6.97337920164,0.677272799282,1.09069120653,-0.239582541096,1.12640597448,-0.266123699317,-1.19753601019,-1.12354255509,-0.23985582275,0.724180043024,-2.35903303729,0.477623924935,-1.8362173073,1.07977462864,-0.354766501022,1.28041603894,0.740097571716,1.86196235186,1.42645411179,0.465885807655,2.13444785883,-0.183859035466,1.06743687985,-0.475233953995,-0.108108116692,-0.213299415901,-0.530284540685,-0.275144749941,-0.271161885493,-0.491031732769,0.257893230377,-0.255443960894,0.503107950818,0.0116709379275,0.626978679318,0.325994622063,1.45051772781,0.991274596371,0.500874823618,0.593385849267,-0.3440314297,0.0244959145524,0.00468078365348,-0.177853529186,0.120194319404],[-32501.7055093,-825.3967601,-1132.44736945,-2928.37148362,-959.949906886,55.1979593779,1377.97819017,377.129945991,-344.110687427,-565.432433854,325.599249619,-47.1631611648,-637.833052749,-1559.96935514,-754.461862434,9.28281578902,-475.056153349,-165.204218455,-566.948766268,178.800331495,-80.9247534051,-5.25620226399,93.4914222166,-577.815043938,85.2449963972,-81.5832844568,55.5245133723,25.1723130608,-9.59905200067,285.068176443,-48.3630476929,-127.981673196,-108.478577947,95.9889560903,123.668359346,24.113304955,36.6281423831,82.7898135018,8.21324369198,-13.948291514,-7.2388596535,-18.802235712,-42.9472558948,-24.5252155565,1.42091155708,1.85094923743,-12.0815326048,-67.3717449215,4.15525845812,17.8696768157,11.6165044278,-0.415986760769,-4.93262798319,2.17675951694,-4.51115196602,14.0486834763,-20.3439440747,-13.7838491212,-5.91664775141,3.73693574031,-0.218363915521,7.91663010085,17.8487691601,1.28716048093,1.64217784394,-3.23186394501,1.58675822039,4.85151208177,0.146166523724,0.879360827771,-0.474750091286,-1.02629747374,-5.94363534043,8.1961257926,1.70808084554,6.90409522369,0.79224398044,1.41986869879,-0.13321426492,1.1683549502,-0.240954939681,-1.21368048876,-1.11363385777,-0.166528964984,0.680278031251,-2.3052384254,0.49966813549,-1.83245933608,1.05115992928,-0.408619568752,1.2845396775,0.78770158879,1.87245144207,1.46235514201,0.549066270448,2.13234490269,-0.160701109263,1.02975046894,-0.487801058416,-0.0891717748156,-0.232784423296,-0.543110645638,-0.262154275458,-0.269392837232,-0.491121436082,0.252839593035,-0.256562872212,0.510092896088,-0.0146237295493,0.622915131242,0.335232357095,1.44860107488,0.989042206815,0.504308577128,0.593245821198,-0.326576697262,0.0218927246907,0.00368212837829,-0.184392437121,0.124334095563],[-32445.7670772,-749.79721721,-1170.12811981,-2940.96754669,-946.882686168,38.2300812593,1373.57207901,393.506692351,-288.870330228,-579.33601043,343.872095169,-51.698407236,-632.93718086,-1562.57815756,-762.094928281,18.4910945617,-485.883565542,-164.147047447,-551.85866164,170.833790935,-104.960151476,-24.4299533373,102.488116029,-582.313282149,82.2660182607,-84.6887026542,51.2499894848,20.2365204263,-13.5485243539,274.223787014,-55.9046541581,-124.027676828,-107.34354791,97.3772724315,117.678069748,20.9834564994,37.5342911855,80.6095124826,6.14713792892,-14.3436952044,-6.91389293749,-18.4575470243,-44.1613481363,-25.1098590806,2.08014505364,1.40087293085,-13.0950304401,-65.4055065521,3.76664988235,18.1489800324,12.0904973235,-0.465734336906,-4.63439343276,2.4472590146,-3.88711658056,12.8983576239,-20.3929215884,-13.5514713316,-5.43134402277,3.79042738673,-0.190544087253,8.20011843451,18.2883099639,1.26267345032,1.70740598889,-3.07902561717,1.78753571731,4.80702646561,0.275098443856,1.0108612312,-0.653331190194,-1.14548015592,-5.85106033894,8.15203169233,1.82869293631,6.83694326523,0.917812188375,1.74534879137,-0.0238914061054,1.19541633266,-0.213933630033,-1.22506809111,-1.09827377429,-0.094395706112,0.635804261587,-2.25203903926,0.521519161096,-1.82602653094,1.02094090722,-0.459952620885,1.29216342964,0.837095567503,1.88009132222,1.49720666995,0.629120795909,2.13091472951,-0.141799926376,0.988296633047,-0.500561984014,-0.0703425327812,-0.250439112943,-0.555309365561,-0.248351216445,-0.267663854119,-0.490878548937,0.247364611323,-0.256263954288,0.516362849346,-0.0402568577609,0.618999195833,0.344944966916,1.44549154546,0.985192965473,0.506690921166,0.593028879649,-0.310014685624,0.0178575927817,0.00218207362461,-0.19119985344,0.129274147205],[-32380.3692874,-681.756317826,-1187.50713047,-2955.88082562,-931.359837017,32.7137354494,1362.34061251,403.637689774,-237.794079226,-590.547824144,361.825253357,-56.1614597525,-632.278731597,-1560.98297577,-766.936346399,28.0495449794,-494.824335218,-163.321058806,-536.27840424,160.769803771,-128.09216055,-42.9276759238,111.472691436,-586.766670888,79.8712789367,-87.5705767685,46.2959364647,15.5310149279,-17.6660416719,262.925050268,-63.3858164409,-120.465153581,-106.110737349,98.1875269883,111.496264079,18.0406802586,38.2656431089,78.3064418283,3.99379847445,-14.7109483014,-6.81205871863,-18.2702878198,-45.559811999,-25.5420533937,2.62871896198,0.897385407164,-14.1084383036,-63.237789216,3.3970750521,18.3728442583,12.5412427898,-0.551185371457,-4.34685486432,2.64809607836,-3.29423323609,11.7092337145,-20.3654146212,-13.3112427667,-4.93072490136,3.82534137189,-0.0887156857249,8.51785368673,18.7229154227,1.2385289036,1.77201813998,-2.91876360645,1.96759270912,4.75849120349,0.392080393778,1.1394888332,-0.833049691069,-1.24856351975,-5.75485882467,8.11700458298,1.94738283424,6.77772333558,1.0542018371,2.06048846666,0.0859289708734,1.207885073,-0.186551015924,-1.23254981158,-1.07812391016,-0.0247361948944,0.591405668267,-2.1994947609,0.543847236621,-1.81779856457,0.990780086257,-0.508093192293,1.30358047099,0.888666613367,1.88604932898,1.53157119009,0.704914325064,2.12945646148,-0.126691835981,0.943627082739,-0.512468216773,-0.051934260182,-0.266272841034,-0.566547457828,-0.23398184156,-0.266075134052,-0.489915924674,0.241914209422,-0.25465742364,0.522185520091,-0.06491438563,0.615455810091,0.355144351735,1.44111147622,0.979951569102,0.508072644548,0.592596445116,-0.294366720294,0.0123716230565,0.000549692547447,-0.198084238988,0.134849894836],[-32307.2333366,-622.895851571,-1185.56622942,-2972.21505209,-914.113212151,37.9982486704,1345.15375092,407.876325158,-191.297845728,-599.096655716,379.471982656,-60.7653234549,-636.191368576,-1554.99122925,-769.400489956,37.8072362896,-501.245872318,-162.2853395,-520.523774159,148.543742028,-150.062857357,-60.6024328844,120.064191901,-591.31227062,78.1289931815,-90.0199195219,40.8829598466,11.0771018756,-21.9413807678,251.227754976,-70.7172896473,-117.371634972,-104.994894093,98.4062758968,105.268394535,15.326637734,38.8353078795,75.9140283277,1.80387964376,-15.0402558266,-6.96053077545,-18.2663930691,-47.1163840043,-25.8794881909,3.06929841243,0.382701595263,-15.07147733,-60.8639185689,3.0468549639,18.5338685276,12.9508973197,-0.657469442095,-4.07133675368,2.76248414718,-2.74505717237,10.4928137907,-20.2600154238,-13.0629302129,-4.41438190067,3.85197363735,0.101301072265,8.86211184168,19.1370165863,1.21149202832,1.83265235351,-2.75913411776,2.1255266794,4.7082836604,0.492396277744,1.26387403994,-1.01391578902,-1.33014905492,-5.65596733226,8.09043208262,2.06512715364,6.73291586313,1.20196641703,2.35843093403,0.193524684248,1.20640161696,-0.16033741178,-1.23706538845,-1.05408298428,0.0410308359189,0.548132117208,-2.14777752328,0.567441083845,-1.80903433367,0.962690218174,-0.552278957341,1.31901570599,0.942669562425,1.89175223456,1.5662737302,0.775261881747,2.12695605965,-0.114856826379,0.896327599345,-0.522404297854,-0.0342606645395,-0.280345721993,-0.576404211372,-0.219326136912,-0.264656328782,-0.487883112048,0.237003907227,-0.251934158561,0.527914419667,-0.0882134706998,0.612476505249,0.365853079006,1.43542360271,0.973643896086,0.508526671431,0.59174200048,-0.279647069656,0.00545660593128,-0.00083226593534,-0.204817361656,0.14085217956],[-32228.5964729,-576.512246385,-1167.01473129,-2989.49371772,-896.104532719,52.7156081688,1323.00972632,407.451765304,-149.752005089,-605.072281319,396.851646323,-65.786042881,-644.450567748,-1544.43413125,-769.774607397,47.6241317261,-504.636256467,-160.486862436,-504.891023858,134.195948743,-170.612687583,-77.3108962145,127.921003101,-596.151608045,77.1002376403,-91.8442640445,35.2627378258,6.91852379449,-26.3814815028,239.200528285,-77.8067358512,-114.775488581,-104.214261269,98.0176850919,99.170470585,12.8837793751,39.2627124908,73.4678310256,-0.368234656393,-15.3317247238,-7.38430286561,-18.4631768836,-48.7916663146,-26.1849063289,3.39381638747,-0.0908362600693,-15.9391481413,-58.2864359402,2.71768097319,18.6267465844,13.3003141849,-0.769965032597,-3.80979546105,2.77323763187,-2.25110993312,9.26199706422,-20.0784689309,-12.8094416265,-3.87911168465,3.88042127902,0.390879428478,9.22616259912,19.5153869707,1.17827453316,1.88620012568,-2.6090056637,2.25972222153,4.65905794851,0.5711244067,1.38242987247,-1.19645165639,-1.38522886141,-5.55516880527,8.07215838053,2.18252605804,6.70894033654,1.36184446654,2.63318282618,0.295613709988,1.19207279622,-0.136935150444,-1.23954323157,-1.02721532692,0.101363112738,0.507187248,-2.09714292961,0.593080774983,-1.80125986798,0.938722915426,-0.591536966404,1.33860861784,0.999083818619,1.89878311327,1.60238459679,0.839252076408,2.12208957168,-0.105772417057,0.84700696873,-0.529427812786,-0.0176419720725,-0.292726341204,-0.584451872445,-0.204688260717,-0.263374021306,-0.48443375171,0.233152554351,-0.248355820956,0.533925320554,-0.109687874477,0.610200894655,0.377060647281,1.42847487333,0.966689511909,0.508177060396,0.590128940139,-0.265856425345,-0.00283791747746,-0.00161390859044,-0.21113631858,0.147078758546],[-32147.5362773,-544.190028955,-1136.70019773,-3007.39671398,-878.133598136,74.6484529339,1296.56203372,403.925473383,-113.444639548,-608.717368416,414.092174379,-71.3273219122,-656.419166852,-1529.10479934,-768.281076577,57.3508829846,-504.627576161,-157.298837685,-489.616475268,117.823008816,-189.533089931,-92.913113263,134.763987123,-601.462529283,76.833304226,-92.8766561283,29.6898477253,3.10668674111,-31.005120986,226.930497144,-84.5585619544,-112.650135631,-103.983721198,97.0202926557,93.3760408039,10.7508250841,39.5690458255,71.0030115846,-2.47230078293,-15.5917695275,-8.10009984388,-18.8729633476,-50.5373959315,-26.5229726558,3.59283228972,-0.46127233486,-16.6715403696,-55.5133061211,2.41127037499,18.6481384343,13.5708212493,-0.875553948049,-3.5651221372,2.66449522973,-1.82287026337,8.03073958381,-19.8248146837,-12.5541330109,-3.31936038853,3.9191081777,0.787250669458,9.60270781998,19.8442944847,1.13578963826,1.93015323687,-2.47740816317,2.3685248792,4.61347188478,0.623553058031,1.4936478019,-1.38117737884,-1.40950785918,-5.45308360092,8.06246838354,2.2997914845,6.71202017483,1.5347516535,2.87994027364,0.389158032825,1.16641512431,-0.117873594539,-1.24087617199,-0.998649993716,0.154769085699,0.469867447182,-2.04794159277,0.621460093569,-1.79610309312,0.920774927065,-0.624826584585,1.36242790871,1.05777015405,1.90883479923,1.64101232688,0.896209149076,2.11334964868,-0.0988148294031,0.796269844242,-0.53270983847,-0.00237878906917,-0.303501875051,-0.590288674421,-0.190350147699,-0.262152997804,-0.479269053455,0.230825454221,-0.24423000417,0.540592681826,-0.128839867746,0.608705769427,0.388735749818,1.42038671797,0.959540800575,0.507186839395,0.587369598745,-0.252950945861,-0.0124127736139,-0.00151389597433,-0.216781192015,0.153307234182],[-32067.5837075,-523.841825709,-1105.09343641,-3026.30550423,-860.499600105,101.234377042,1265.79284008,398.42617794,-82.6251985376,-610.446120964,431.630960918,-77.2056762805,-671.451285099,-1509.09702212,-764.733538262,66.8902396552,-501.001829906,-152.092255154,-474.748839274,99.5414219442,-206.690350873,-107.256063278,140.492034433,-607.316331572,77.3728652881,-92.9806349974,24.3717107031,-0.289640013248,-35.8259362176,214.526814588,-90.9076489262,-110.928041937,-104.480804964,95.4447374623,88.0134203379,8.95578240318,39.7738134444,68.5456753849,-4.47188285239,-15.8289730791,-9.11092268735,-19.5121385714,-52.3083858686,-26.9561321098,3.66747190269,-0.670906147533,-17.2455039656,-52.5639800545,2.12716329837,18.5962852421,13.7468290886,-0.965891765817,-3.34128674789,2.42406722388,-1.46898217478,6.81150582024,-19.5055650339,-12.2984362706,-2.7270574866,3.97276596245,1.29287631235,9.98257738465,20.1147731277,1.08142782344,1.96269098198,-2.37195149897,2.45047031908,4.57372900342,0.645647791817,1.59679652471,-1.56820996664,-1.3998285508,-5.35027106961,8.0627258134,2.41707484112,6.74772360184,1.72086422683,3.09545324031,0.472280136508,1.13152818424,-0.104305640732,-1.2418832325,-0.96936379605,0.200127302136,0.437408683551,-2.00064169242,0.65311423638,-1.7949161458,0.910415266765,-0.651213675847,1.39049401313,1.11874843008,1.9236100578,1.68309655955,0.945613194032,2.09950940998,-0.0931216047154,0.744872789348,-0.53181025396,0.0112823655521,-0.312774160133,-0.59360526659,-0.176520475128,-0.260905625845,-0.472173424166,0.230357588429,-0.239848844775,0.548252942859,-0.145200142984,0.607970932394,0.400844550892,1.41136195486,0.952633494457,0.505701403397,0.583086880613,-0.240810104771,-0.0231032296285,-0.000378924220817,-0.221587623852,0.159278563834],[-31992.5656256,-512.858891635,-1082.37957362,-3046.62992461,-843.377743048,129.757631445,1231.08173242,391.407698946,-57.5090137725,-610.783399664,449.791668307,-83.0626676905,-688.968192278,-1484.70175463,-758.828853892,76.1457592522,-493.706518399,-144.361566877,-460.23819878,79.4795030123,-222.010361967,-120.207974822,145.074223695,-613.738818978,78.7417020054,-92.0588681004,19.4648745599,-3.20909936875,-40.8546605704,202.109803369,-96.8112888673,-109.526903212,-105.841753488,93.3436595443,83.1817385142,7.51888658575,39.8934339614,66.1182243514,-6.34309031223,-16.0541105785,-10.4068817057,-20.3963620697,-54.0633344214,-27.5410811078,3.625574481,-0.670223955517,-17.6487457689,-49.4643668445,1.8648925233,18.4709715175,13.8171843257,-1.03615764287,-3.14261218653,2.04432671303,-1.19761768008,5.61634721361,-19.1293897866,-12.0420728645,-2.09430462136,4.04387684492,1.90585324269,10.356165042,20.3207024633,1.01329519011,1.9826384013,-2.29857024295,2.50445514656,4.54136643693,0.634319688889,1.69125340146,-1.75701464145,-1.35453181728,-5.24687037463,8.07446140427,2.53417882329,6.82038804724,1.91951034414,3.27755103586,0.543862663701,1.08986626251,-0.0970483198267,-1.24323104766,-0.940189936948,0.23664359463,0.410878281278,-1.95580864661,0.688392048648,-1.79871639756,0.908723373255,-0.669891785601,1.42274109699,1.18204092557,1.94460427572,1.72931048636,0.987062862694,2.07966304555,-0.0877520804596,0.693570230394,-0.526574014329,0.0231475232727,-0.320641169032,-0.594176512241,-0.163345180372,-0.259542165645,-0.463035623831,0.231985331166,-0.235488550624,0.55716039819,-0.158365598313,0.607918228124,0.413371976062,1.40165189931,0.946339811623,0.503855220349,0.576976604257,-0.229258034816,-0.0347065442255,0.00185085679891,-0.225457980669,0.164744160713],[-31925.4065029,-509.133091813,-1075.01174153,-3068.78542164,-826.92255718,157.971636722,1193.36694801,382.975720047,-38.4399723865,-610.261493913,468.582710111,-88.6546093769,-708.361097048,-1456.32610715,-750.153525866,84.9710853571,-482.88072094,-133.770184946,-446.05489068,57.8503471878,-235.421569649,-131.634647188,148.470705047,-620.785715882,80.9226478399,-90.0664904729,15.0868922927,-5.60910411524,-46.0880727147,189.803649462,-102.241546557,-108.379917496,-108.160668107,90.7875920855,78.9773717729,6.45312929044,39.9415092615,63.7436726594,-8.07317473852,-16.282259689,-11.9703120946,-21.5353053768,-55.7641304771,-28.3242100072,3.47884678794,-0.419265390794,-17.8764811998,-46.2482635381,1.6262837872,18.2735441086,13.7751768084,-1.08461442919,-2.97326003657,1.52166235912,-1.01623872334,4.4574527477,-18.7068231377,-11.7850095552,-1.41497558666,4.13420638595,2.6202036968,10.7148078183,20.4579435746,0.930551445448,1.98912676054,-2.26152903298,2.52968964204,4.51710659539,0.587316601118,1.77597519581,-1.94651430683,-1.2733598617,-5.14264858245,8.09888573435,2.65064932736,6.93264398925,2.12893191308,3.42478707411,0.60322882933,1.04415714755,-0.0966280159906,-1.24540780252,-0.911885898292,0.263801179511,0.391054743363,-1.91414464487,0.727441691586,-1.80815562617,0.91631244272,-0.680220833192,1.45893429025,1.24748337194,1.97297669658,1.77998093764,1.02030734644,2.05332231852,-0.0818111077624,0.643048975793,-0.517060104712,0.0330732666361,-0.32715633951,-0.591878795112,-0.150924916564,-0.257965668693,-0.451852148411,0.235870917252,-0.23141696345,0.567461863411,-0.168046403757,0.608435227811,0.426313487811,1.3915356744,0.940969118554,0.501750866922,0.568837417488,-0.218101137569,-0.0470190010885,0.00519736492541,-0.228318029942,0.169513823647],[-31867.4125367,-508.524170411,-1086.73151381,-3093.26085898,-810.772331525,184.252033889,1153.96601071,372.972793049,-25.9104378278,-609.360985361,487.738550414,-93.7137421175,-728.992753876,-1424.35306908,-738.339574258,93.1425643215,-468.817871118,-120.162648204,-432.147730149,34.9277345518,-246.822667005,-141.446102939,150.635405346,-628.497008988,83.8611612678,-87.0093437771,11.3077837681,-7.45822195657,-51.5066137499,177.735264723,-107.191220915,-107.441315924,-111.486414189,87.8648078641,75.4869457369,5.76312191712,39.9261163741,61.4430879128,-9.65929753522,-16.5307273814,-13.7755630061,-22.9358339832,-57.3795920045,-29.3404635633,3.24392143118,0.112129172168,-17.9288468977,-42.9574050681,1.41466479426,18.0060162577,13.6187453305,-1.11240360481,-2.83772836207,0.856321671518,-0.931303189176,3.34650559912,-18.2495853395,-11.5268076928,-0.684575956419,4.24513817829,3.42524728903,11.0505699775,20.5250904152,0.833420225521,1.98162474618,-2.26333738972,2.52560489791,4.50083425253,0.503349070547,1.84982379634,-2.13502171632,-1.15745039291,-5.03716296725,8.13679833666,2.76609622061,7.08504507885,2.34649993834,3.53654810672,0.650258575834,0.997168922851,-0.10321464443,-1.24873927131,-0.885068451962,0.281343706643,0.378420149693,-1.87640429223,0.77021071333,-1.82349820518,0.933275901627,-0.681703759929,1.49871093664,1.3148942188,2.00944853928,1.83509754875,1.04518690772,2.02041305928,-0.0744751612799,0.59393118694,-0.503472366342,0.0409720876498,-0.332329700989,-0.586690691691,-0.139311695771,-0.256086889972,-0.438711973196,0.24207766215,-0.227866101277,0.579199009843,-0.174047936383,0.609381323832,0.439687048651,1.38128483522,0.936748769397,0.499441852324,0.55857390675,-0.207141573353,-0.0598269454667,0.00963912959421,-0.230123082019,0.17344783746],[-31819.2691385,-507.448278571,-1116.41191066,-3119.67654767,-794.67022857,207.647569254,1114.29344961,360.984292831,-20.100337811,-608.65499903,506.797857695,-97.8835741122,-750.308745923,-1389.17639492,-723.480246274,100.422153605,-451.88703795,-103.575604904,-418.461720171,10.9959417551,-256.172457963,-149.72494254,151.464547522,-636.840118942,87.465596611,-82.9146463306,8.14538518541,-8.74872359803,-57.0682083876,166.022027756,-111.684133606,-106.696376863,-115.829606783,84.6810616063,72.7681586206,5.43944433018,39.8528467108,59.2347857661,-11.1086202272,-16.8082690361,-15.7903624871,-24.6002560801,-58.8896370947,-30.6163141975,2.94721372086,0.943733637285,-17.8084033044,-39.6417286186,1.23190562879,17.6707897876,13.3506976753,-1.12218420909,-2.73955526848,0.052990623944,-0.945661850148,2.29350155609,-17.77033219,-11.2644760715,0.0983384906131,4.37799991178,4.3036319916,11.3556236789,20.5231875129,0.722934326378,1.95995881195,-2.30473506996,2.49223377511,4.49170787094,0.382324980707,1.91246579628,-2.32040472425,-1.009359069,-4.92980484088,8.18822831223,2.88062839088,7.27558139731,2.56929713392,3.61317673907,0.68563443705,0.951321037893,-0.116530715568,-1.25348959914,-0.860176364126,0.289321159793,0.373087554474,-1.84325844809,0.81653800573,-1.84469599647,0.959197158641,-0.674133117101,1.54156751243,1.38426508853,2.05413867092,1.89437816893,1.06164480068,1.98124034506,-0.0649770031154,0.546793515659,-0.486092457423,0.0468486128359,-0.336180326563,-0.578682399881,-0.128501082177,-0.253874615855,-0.423793040738,0.250546489489,-0.225017184809,0.592335731054,-0.176306069337,0.610609870047,0.453537756648,1.3711210971,0.933828987196,0.496935021969,0.546250103386,-0.196151301537,-0.0728683230412,0.0151002714749,-0.230856861576,0.17642883234],[-31781.2397549,-504.099428243,-1158.91389557,-3146.8000666,-778.690969718,228.198648104,1075.8499615,346.57433285,-20.7767215756,-608.831763556,525.278597224,-100.800795154,-771.916692035,-1351.36570675,-706.039418464,106.603595622,-432.493707095,-84.2141752938,-404.929662367,-13.6520442169,-263.491662768,-156.723063654,150.8482296,-645.724720734,91.612489822,-77.8253125862,5.5739817231,-9.49131587106,-62.7082573053,154.765633101,-115.782641266,-106.160407634,-121.158999981,81.3456273784,70.8512892421,5.45648267207,39.7266366064,57.1311108795,-12.436908396,-17.1140355483,-17.9771818355,-26.5279023944,-60.2846214446,-32.1685327954,2.62259734248,2.08281272959,-17.5218416452,-36.3581380702,1.07749266493,17.2705607255,12.9774011145,-1.11846242768,-2.6810546398,-0.878747493933,-1.05787386869,1.30553125909,-17.2816351683,-10.9929737059,0.933204837684,4.53392624864,5.23337649896,11.6226607807,20.45572949,0.600808723541,1.9241267244,-2.38480906101,2.43008826751,4.48825604555,0.225249613159,1.96453873788,-2.50050743256,-0.832818797897,-4.81978230835,8.25279329996,2.99485001278,7.49984649649,2.79399123925,3.65583716442,0.710713951194,0.908659213948,-0.135885575988,-1.25987465866,-0.837461001615,0.28806171996,0.374756022059,-1.81526782447,0.866201719131,-1.87140549268,0.993230694719,-0.657608222286,1.58694146714,1.45574583027,2.1066169082,1.95725466929,1.0697929989,1.9364951272,-0.0525893735502,0.502195173404,-0.465348560375,0.0508121932045,-0.338740645083,-0.567997729578,-0.118434873909,-0.251355378614,-0.40736643213,0.261103560919,-0.222986712159,0.606753451475,-0.174905034523,0.611979925489,0.467927586652,1.36121334582,0.932264630238,0.494193133525,0.53204782885,-0.184870516901,-0.0858568280653,0.021443029391,-0.230544201008,0.178380423268],[-31752.789804,-497.801414562,-1208.79656195,-3173.48883997,-762.925484488,246.415854227,1039.97680287,329.402528159,-27.5483601445,-610.517787077,542.807109527,-102.210429362,-793.434085418,-1311.45049406,-686.528537726,111.502082343,-411.087252367,-62.364667841,-391.457687593,-38.7179009569,-268.778926444,-162.755255215,148.722180948,-655.03044114,96.1613101697,-71.8058680502,3.53989966802,-9.69862283335,-68.3575382697,144.059564743,-119.569570614,-105.852475172,-127.39889114,77.9636547463,69.74514894,5.78007397797,39.5513529188,55.1360801699,-13.6633031027,-17.4444676859,-20.2959570821,-28.7128521963,-61.5610041916,-34.0005174788,2.3035273356,3.52488503585,-17.0817924214,-33.1643854667,0.950162721906,16.8083772157,12.5069351587,-1.10728504127,-2.66387778057,-1.92627030787,-1.26391045459,0.387060827894,-16.7948574936,-10.707352284,1.81845868368,4.71347719603,6.19093551158,11.8458717965,20.3285940053,0.469284400916,1.87433736181,-2.50141534796,2.3400145702,4.48854310236,0.0338070190707,2.00700011526,-2.67342407205,-0.63219629575,-4.7062137677,8.33001084047,3.10957401057,7.75205962191,3.01696424096,3.66668590335,0.727205922941,0.870878804041,-0.160353331867,-1.26799851124,-0.816999896592,0.278082088584,0.382827859147,-1.79287734428,0.918849932112,-1.90304999497,1.03423361432,-0.632425739794,1.6342708677,1.52946771828,2.16612059447,2.02291259607,1.06995919696,1.88710778347,-0.0367394286869,0.460622694669,-0.441814647247,0.053032160614,-0.34003970147,-0.554817530599,-0.109019917893,-0.248576766692,-0.389746436749,0.273492141321,-0.221839501485,0.622243399889,-0.170019822311,0.613349018318,0.48291139927,1.35169949489,0.932007019436,0.491162837037,0.516194979166,-0.173051935476,-0.0985103429265,0.0284952289978,-0.229242701875,0.17927455277],[-31732.6834521,-487.844576227,-1262.86176419,-3198.9860093,-747.47851024,262.967204307,1007.8944897,309.685241887,-40.0590669402,-614.182423393,559.126551675,-101.942935198,-814.370003979,-1269.89266948,-665.414003242,114.941828765,-388.138130044,-38.3539746955,-377.932204681,-63.9147605815,-271.983197411,-168.11739502,145.081233873,-664.606810913,100.970250563,-64.938141281,1.97106847927,-9.37804999664,-73.947823503,133.996150962,-123.129249372,-105.79035512,-134.436680019,74.6257687737,69.4417330655,6.37267720502,39.3296751845,53.2471974414,-14.8054582008,-17.7984653815,-22.7048886664,-31.1433003171,-62.7206793714,-36.1037890885,2.01885272928,5.25375378246,-16.5065863758,-30.1169913831,0.848712906663,16.2880623627,11.9479752033,-1.09490972264,-2.68976178795,-3.07504189758,-1.55854606682,-0.459129946557,-16.3206265706,-10.4044089386,2.75123412473,4.91582453164,7.1529959086,12.0212771308,20.1495741365,0.330889338837,1.81111030841,-2.651622009,2.22326340698,4.4903421665,-0.189673459963,2.04066438299,-2.83762773236,-0.412329062263,-4.58859868712,8.41924650472,3.22551647314,8.02566914666,3.23447230463,3.64847658167,0.736791995669,0.839233584414,-0.188912098527,-1.27788211459,-0.7986935461,0.260029588639,0.396536676916,-1.77643890914,0.973934326127,-1.9388948001,1.08083309926,-0.599045877955,1.68296308711,1.60542655762,2.23159649719,2.09035722516,1.06259779094,1.83414811147,-0.0170311689154,0.422528073878,-0.416152038473,0.0536946217767,-0.340116403642,-0.53933762406,-0.100154405889,-0.24559522793,-0.371254035524,0.287403765405,-0.221582472865,0.638528012328,-0.161873490786,0.614557529157,0.498515014962,1.34268545763,0.932922019646,0.487780672171,0.498933647255,-0.160495401504,-0.110565026171,0.0360733493246,-0.227041559969,0.179123877355],[-31719.9310433,-472.756423003,-1318.70840305,-3222.88095159,-732.469856678,278.374661781,980.303260143,287.911736907,-57.9788888925,-620.154365481,574.043728015,-99.6873418877,-834.071594776,-1226.77289656,-643.045593801,116.74881122,-364.111374514,-12.5159023429,-364.199456652,-88.9836871198,-273.029019182,-173.044105795,139.941252932,-674.248067849,105.899107889,-57.3127942715,0.7778905707,-8.53091176035,-79.4169499105,124.67157786,-126.531565086,-105.970574962,-142.139695351,71.4099651138,69.9067219301,7.19463282593,39.0631811725,51.4557847176,-15.8778259745,-18.1759719211,-25.1570686776,-33.8028158663,-63.7674477946,-38.458178367,1.79135316856,7.25033055842,-15.8172976961,-27.2620035789,0.771983387752,15.7139074292,11.3094834736,-1.08705193843,-2.76031167267,-4.30892806318,-1.93619621397,-1.23118742044,-15.8674685059,-10.0816463186,3.72773324651,5.13801640792,8.09712622895,12.1455530005,19.9273432473,0.188229047179,1.73521840502,-2.83200701306,2.08134742418,4.49110437049,-0.442132197341,2.06611723919,-2.99154319328,-0.178210243145,-4.46659388493,8.51967731279,3.34290799844,8.31413092881,3.44311039513,3.60479640928,0.741424373897,0.814529916452,-0.220481521262,-1.28950104986,-0.782305144458,0.234637117234,0.4149839792,-1.76616644476,1.03074640844,-1.97804335796,1.13147237951,-0.558041081591,1.73249910749,1.68345306521,2.30189859395,2.15840694441,1.04832058788,1.77863269719,0.00677576563995,0.388172813131,-0.388976136955,0.0529913316617,-0.339026092836,-0.521763481803,-0.0917318328615,-0.242479863667,-0.352204055725,0.302491187055,-0.222169625536,0.655289380068,-0.150719492802,0.615457665869,0.514724819636,1.33424600585,0.934784798048,0.484009698237,0.480531527332,-0.147026789702,-0.121781859802,0.0439763244466,-0.224046778898,0.177956941225],[-31713.9676524,-452.091661869,-1376.27203319,-3245.43398104,-717.93998938,292.892058073,956.823462156,263.986976061,-80.994944187,-628.550762178,587.435804926,-95.2968535575,-851.943982649,-1181.99109386,-619.413077574,116.756753879,-339.444538739,14.8375777414,-350.109806191,-113.703893505,-271.847340712,-177.636645501,133.390727032,-683.725365605,110.815942516,-49.0259517112,-0.137353069585,-7.14573078511,-84.7097760969,116.17143186,-129.810599956,-106.354931175,-150.352186087,68.3828953021,71.0731745924,8.20649413236,38.7540437854,49.7485502342,-16.8896139061,-18.575669323,-27.6044329411,-36.6676896742,-64.7033619052,-41.0314226287,1.63611359664,9.48518237636,-15.0393638388,-24.6335977162,0.719015225797,15.0905576418,10.601027882,-1.08773943486,-2.87675931235,-5.61059832336,-2.39106612148,-1.92784437807,-15.4414496492,-9.73794179672,4.74188644475,5.37474033153,9.00357665857,12.2166988877,19.6718320877,0.0438466547519,1.64766728597,-3.03883657032,1.91623254331,4.48817027414,-0.719800221738,2.08342938976,-3.13356648787,0.0653056388666,-4.34018189568,8.63011859029,3.46111323333,8.61141054567,3.63984481071,3.54022759588,0.743194931872,0.797267950563,-0.254010638346,-1.30282800616,-0.767505079923,0.202704778961,0.437148785486,-1.76206946663,1.08839578124,-2.01950492502,1.18449176502,-0.510101839773,1.78243208943,1.76306674569,2.375910336,2.22581231129,1.02798432379,1.72156907834,0.0347395580138,0.357623126016,-0.360891802166,0.0511059694032,-0.336846717211,-0.502322100027,-0.0836575433555,-0.239308496265,-0.332881350507,0.318367134882,-0.223506230085,0.672186325996,-0.136840398123,0.615939255502,0.531450934821,1.32644796032,0.937310579367,0.479877548177,0.46127608517,-0.132521634966,-0.131972030254,0.0520027961048,-0.220390809183,0.175829678511],[-31714.4864432,-429.812700854,-1434.93801377,-3266.70515238,-704.75495247,307.340781528,936.143834652,237.817544593,-108.441863121,-639.515804118,599.220498744,-88.9931659107,-867.461769545,-1135.70677904,-594.274294185,114.904604698,-314.509552121,43.3648974032,-335.637503699,-137.855063325,-268.485248309,-181.9029586,125.545983008,-692.725347042,115.608308474,-40.1560282707,-0.880716751182,-5.22194749218,-89.7607808378,108.541584634,-132.962040473,-106.908511925,-158.874895081,65.6013655105,72.8531657966,9.36600384433,38.4131123672,48.1104548662,-17.8459618575,-18.9887565516,-30.00495996,-39.7029092882,-65.5356151329,-43.7774901697,1.56371419883,11.9183803877,-14.2055969584,-22.259503123,0.687070431034,14.4246632132,9.83349337856,-1.09756424674,-3.03931895944,-6.96145788097,-2.91478016928,-2.55024907412,-15.0466372665,-9.37395494352,5.78560232115,5.61749596153,9.85527885803,12.2335874359,19.3943643789,-0.100173894837,1.54984159296,-3.26786704958,1.73113383468,4.47885125793,-1.01794402393,2.09255630566,-3.26255284399,0.313526163658,-4.21034411506,8.74941654953,3.57832938632,8.91184436443,3.82153752074,3.4601949582,0.744042431268,0.787604028853,-0.288537006144,-1.31790289953,-0.753882050739,0.165302963053,0.461832645489,-1.76382185623,1.14588102897,-2.06228636711,1.23819868221,-0.456264694476,1.83242422052,1.84336076761,2.45253426104,2.29112654811,1.00275852173,1.6640013021,0.0667845498905,0.330871588595,-0.332530381016,0.0482217407664,-0.333736595027,-0.481282498785,-0.0758357096566,-0.236186877346,-0.313506015928,0.334606958688,-0.225426043941,0.688878019745,-0.120601718972,0.61595099689,0.548488767778,1.31937498605,0.940117354706,0.475496492854,0.441462465805,-0.116888067349,-0.141005857574,0.0599561315504,-0.216233963758,0.172816677116],[-31719.7559306,-409.282309996,-1494.48893859,-3286.52615256,-693.43642534,322.412584835,917.390761627,209.421368733,-139.492804483,-653.191698675,609.162722142,-80.9441394419,-880.279151837,-1088.20401126,-567.364364705,111.166241962,-289.659301333,72.6452997769,-320.787616224,-161.259510075,-263.036374112,-185.826626213,116.55847594,-700.867092638,120.165501834,-30.7913079074,-1.56699164787,-2.77357645962,-94.5059655674,101.81512391,-135.963595145,-107.587761475,-167.475216396,63.1195725543,75.1438978102,10.6270132672,38.0515873307,46.5288473286,-18.7538806124,-19.4000647368,-32.3157083356,-42.8682830057,-66.2686152843,-46.6429030212,1.58798532224,14.5015164013,-13.3541099377,-20.1634558394,0.672387518096,13.7239681924,9.02019007816,-1.11598158525,-3.24742241357,-8.34039605138,-3.49728307708,-3.09902165186,-14.6865348151,-8.98888977114,6.84921768744,5.85560297678,10.6368217485,12.196316823,19.107617701,-0.241550783084,1.4436891998,-3.51417003237,1.52988507342,4.46061558203,-1.33102500575,2.09336036259,-3.37720536333,0.561234106221,-4.07813005622,8.87620303655,3.69215764298,9.20974590063,3.98519486702,3.37082561502,0.745845945551,0.785175734112,-0.322994348045,-1.33469494202,-0.740964247513,0.12370042197,0.487737054112,-1.77094985135,1.20209114187,-2.10538506357,1.2907114763,-0.397695382403,1.88214929059,1.92333916118,2.53058671857,2.35285793953,0.974100280415,1.60707286494,0.102715274889,0.307841343102,-0.304520633333,0.0445436685109,-0.329881567002,-0.458978071287,-0.0681527365734,-0.233239422304,-0.294322743377,0.350753137591,-0.227719614955,0.705011536197,-0.102415569469,0.615462853631,0.565617106747,1.31310600916,0.942777409586,0.471047052599,0.421425313891,-0.10005020832,-0.148811085828,0.0676364623732,-0.211756391985,0.169016208682],[-31727.175881,-391.624471768,-1555.10828138,-3304.32430449,-683.973299869,338.694817583,900.285828875,178.322757668,-173.165007788,-669.659835971,616.987141654,-71.08845346,-890.398093104,-1039.87895322,-538.573350705,105.563802366,-265.231410238,102.19908764,-305.525957637,-183.788282675,-255.643660797,-189.417361211,106.638543711,-707.702029118,124.376218439,-21.038462774,-2.31588220124,0.175124695825,-98.8804733042,96.0134865554,-138.801867426,-108.335583852,-175.894390674,60.9925375212,77.8253067306,11.9383176586,37.67836398,44.9925317975,-19.6235168034,-19.787929781,-34.4918587689,-46.124354248,-66.9038026027,-49.5668366565,1.72840128565,17.1807871633,-12.5249246335,-18.3648028957,0.669738867707,12.9970572302,8.17636420299,-1.14290305714,-3.49883479005,-9.72361355658,-4.12737773999,-3.57485739339,-14.364111954,-8.57976705635,7.92237892635,6.07701814538,11.3339259009,12.1057955334,18.8254967057,-0.377808738463,1.33153732155,-3.77209771489,1.31655958499,4.4312715004,-1.65285425698,2.08594059276,-3.47623273556,0.802463461566,-3.94415133342,9.0090254087,3.80009648081,9.49917763034,4.12802964972,3.27882614048,0.750539772148,0.78923256806,-0.356156486477,-1.35308758628,-0.728262546646,0.0793173730019,0.51349614852,-1.78285771174,1.25592948988,-2.1477692746,1.33994200588,-0.335573812318,1.93129675693,2.00210093336,2.60874833156,2.40947395177,0.943698690503,1.55198990447,0.142261152943,0.288373278464,-0.277479595938,0.0403287921767,-0.325475360231,-0.435803878105,-0.0604721374545,-0.230613975475,-0.275612164597,0.366337743784,-0.230150222666,0.720213695825,-0.0827317443887,0.614449949896,0.582652446806,1.30769226165,0.944837127944,0.466745762407,0.401532416181,-0.0819479181715,-0.155358036357,0.074822333252,-0.20716278858,0.164549740603],[-31734.4827085,-377.179789806,-1617.02492216,-3319.37860891,-676.279361252,356.730540692,884.916972981,144.081922088,-208.3664034,-688.944543069,622.457440474,-59.2167295132,-897.972602617,-991.142992722,-508.004830947,98.2090964876,-241.545746525,131.533068616,-289.782558134,-205.336347535,-246.484215361,-192.756054188,96.0073532908,-712.73733527,128.136638662,-11.018638921,-3.2452567985,3.59498652814,-102.822853457,91.1444511143,-141.489927929,-109.095396871,-183.85843452,59.2740980238,80.7657740532,13.2450935269,37.3006014353,43.4910564658,-20.4657851667,-20.1279731037,-36.4892400049,-49.4332640461,-67.4437509592,-52.4841219926,2.00648763499,19.8992850169,-11.7591538855,-16.8792513562,0.672702325977,12.2530915513,7.31828174211,-1.17884183787,-3.78957137336,-11.08585463,-4.79236023748,-3.9795256483,-14.0821052946,-8.1426504146,8.99459606538,6.26979195474,11.9328430597,11.963676424,18.5625108923,-0.506441073967,1.215825386,-4.03537345822,1.09530125971,4.38896792812,-1.97681127307,2.07083913541,-3.55849343556,1.03081279373,-3.8086376013,9.14643932394,3.90010235626,9.77381634817,4.24745537741,3.19124673903,0.760027784726,0.798678603062,-0.386686040253,-1.37286393563,-0.715296405328,0.0336640520277,0.537732010504,-1.79882902809,1.30640764887,-2.18835248788,1.38375723579,-0.271049509611,1.97957663866,2.07895365173,2.68554634833,2.45944302207,0.913361823512,1.49995269311,0.18502854209,0.272257840355,-0.252010903988,0.035888650145,-0.320709220047,-0.412199539388,-0.0526550936343,-0.228464208418,-0.257666062184,0.380908762708,-0.232463150284,0.73411397562,-0.0620092495025,0.612884203909,0.599469418823,1.30314199279,0.945833447498,0.462803886794,0.382158278153,-0.0625547844141,-0.160630509977,0.081292107107,-0.202667228095,0.159549530649],[-31740.1918211,-364.028468707,-1679.31751805,-3330.28377997,-669.938627612,377.337684894,871.215006466,106.914057652,-243.859995276,-710.998618685,625.389886302,-45.1519612698,-903.239542878,-942.464105394,-476.135696232,89.303199996,-218.883246607,160.14014132,-273.483815556,-225.836149969,-235.780223604,-196.016920787,84.8668130806,-715.453225904,131.354211036,-0.856063270672,-4.47266025548,7.45237121221,-106.278458648,87.1966019997,-144.071410046,-109.830205284,-191.086127787,57.9965946179,83.8293531721,14.4890649284,36.9241050634,42.0160892376,-21.2905574955,-20.397706246,-38.2677911441,-52.7618801688,-67.8955770767,-55.3270714366,2.44098815161,22.5982887196,-11.093714838,-15.7209802333,0.673231426987,11.5017327377,6.46257313016,-1.22392949571,-4.11464169767,-12.4017526144,-5.47846106269,-4.31592624389,-13.8422071423,-7.67445296791,10.0550579504,6.42338790897,12.4202325511,11.7718997816,18.3330855407,-0.625256324802,1.09900655929,-4.29740316603,0.870242150584,4.33232063113,-2.29595574838,2.0491493082,-3.62308873596,1.23983600908,-3.67173833738,9.28677670227,3.9908695523,10.0269790378,4.34104212851,3.11488206662,0.776011132829,0.811925532138,-0.413214459104,-1.39379534521,-0.701574418161,-0.0117469825375,0.559197090531,-1.81803725695,1.35270336546,-2.22602551293,1.42002034933,-0.205174227634,2.02668109824,2.15345359992,2.75934409365,2.50126588473,0.884907037619,1.45209872139,0.230491296149,0.259296349409,-0.228641934677,0.0315732066171,-0.315788726018,-0.388617565574,-0.0445775579466,-0.22692616891,-0.240767461406,0.394042564182,-0.234384542648,0.746352391004,-0.0406756993722,0.610739400109,0.615988427731,1.29941594854,0.945295170086,0.459417410418,0.363663209988,-0.0419078437933,-0.164616672887,0.0868443307686,-0.198484971478,0.154151839493],[-31743.9283447,-350.153139961,-1741.19630157,-3335.01566478,-664.257520909,401.358547957,858.594733306,67.80263837,-278.096403116,-735.610780339,625.698341997,-28.8316218499,-906.361449859,-894.369669403,-443.773759581,79.1648795437,-197.473298021,187.552656146,-256.604123029,-245.249166475,-223.821224052,-199.490212507,73.3951359606,-715.360198864,133.951046095,9.32647206236,-6.10947134391,11.71031158,-109.209239916,84.1354128175,-146.619759899,-110.51684924,-197.308231774,57.1713694087,86.8751308161,15.6081962626,36.5547439687,40.5606731637,-22.1071275394,-20.5772490937,-39.7947237412,-56.0817188198,-68.270042902,-58.0279705791,3.04413712995,25.2174403189,-10.5628625862,-14.9010024047,0.660885724164,10.7531950898,5.625313506,-1.27777545899,-4.46823749225,-13.6462213209,-6.17114165277,-4.58777181459,-13.6457436591,-7.17349276036,11.0919305947,6.52854266906,12.7837003069,11.5337361606,18.1510033712,-0.732630913473,0.983670899652,-4.55161507203,0.645505395948,4.26054707975,-2.60295021719,2.02243575747,-3.66937055927,1.42328815671,-3.53362722264,9.42826530824,4.07174789084,10.2518393128,4.40691915275,3.05613202936,0.799877165911,0.826795216581,-0.434367648286,-1.41564271199,-0.686579187384,-0.0554097049131,0.576807395244,-1.83955043818,1.39419758748,-2.2597138635,1.44667626748,-0.138892881979,2.07224232182,2.22535262951,2.82831247698,2.53353633109,0.860088492357,1.40947041837,0.277874873364,0.249277088108,-0.207806525193,0.0277741980983,-0.310930541824,-0.365510728839,-0.0361253845957,-0.226117539277,-0.225182736243,0.405350414748,-0.235614718943,0.756591644159,-0.0191203537622,0.607984467521,0.632176198033,1.29643098908,0.942775101728,0.456763278514,0.346401111438,-0.0201333258188,-0.167315258185,0.0913158980466,-0.19481599738,0.148504174284],[-31747.3824467,-334.576162725,-1800.19376558,-3331.06269147,-658.455533158,429.956873644,846.458582419,28.5579677981,-309.151483344,-762.543162221,623.297853872,-10.3754156677,-907.387153943,-847.657294227,-411.946560158,68.2476861488,-177.52259677,213.32571178,-239.182792413,-263.54834277,-211.003849556,-203.569752073,61.731726055,-712.039755484,135.866628913,19.4041364449,-8.26029999207,16.3257405859,-111.595554255,81.8868685965,-149.235271377,-111.143782539,-202.273605977,56.7885707624,89.7677675222,16.5370771767,36.2007095048,39.1180098532,-22.9261774813,-20.6497394875,-41.0449428508,-59.3670494212,-68.5790290684,-60.5226385549,3.82107686342,27.6940528373,-10.1995758983,-14.4286912844,0.623365958275,10.0184171259,4.82207685881,-1.33966510954,-4.84395404189,-14.794123558,-6.85451433081,-4.79965092883,-13.4939519238,-6.6394403447,12.0929661448,6.57737957551,13.0115031509,11.254384751,18.0286295645,-0.827533158121,0.872611057812,-4.79147448126,0.42509480369,4.17342342075,-2.89000945279,1.99260449989,-3.6969792483,1.57535993772,-3.3943731978,9.56895126566,4.14254072135,10.4413453538,4.44390802544,3.02103434762,0.832636098678,0.840684571881,-0.44884282435,-1.43811044665,-0.669760411377,-0.0958365861622,0.589613000891,-1.86226443844,1.43052194598,-2.28838938858,1.46182494287,-0.0730413713202,2.11587286446,2.2944816405,2.89048896374,2.5551413936,0.840659719182,1.37304966841,0.326193846736,0.241976690681,-0.189903933806,0.0249222472897,-0.306361333235,-0.343325016946,-0.0271823407298,-0.226115189878,-0.211166158114,0.41448856778,-0.235825771518,0.764529863338,0.00229349564369,0.604605258494,0.648033563928,1.29407262684,0.937890803559,0.455020614415,0.330720118606,0.00257508006764,-0.168738392942,0.0945820256021,-0.191823260039,0.142777746224],[-31754.5701834,-316.787844415,-1848.82446592,-3315.09068656,-651.789326113,465.233697541,835.191552934,-9.13573439748,-334.727977256,-791.586100416,618.095187947,10.2324303933,-906.474365986,-803.463086705,-381.991732687,57.1165837141,-159.233766339,236.999264932,-221.282516988,-280.725266095,-197.857652408,-208.747824824,49.9691788195,-705.152034098,137.057892997,29.2500774598,-11.0307182042,21.2391871757,-113.419602229,80.3356041448,-152.043225866,-111.714601518,-205.761748027,56.8271014837,92.3855626064,17.2095810452,35.8712062871,37.6830950161,-23.7643747806,-20.5969132347,-42.0008289169,-62.5967905028,-68.8356319774,-62.7532841829,4.77558330707,29.968224541,-10.0328523436,-14.3123868124,0.547066607199,9.30905690965,4.06848419349,-1.40962054599,-5.23408966319,-15.8207912744,-7.51210970142,-4.95665326995,-13.3882177288,-6.07185297759,13.0459917547,6.56287100714,13.0920753028,10.9401249494,17.9761636306,-0.909520851277,0.768829827119,-5.01052478266,0.212707880538,4.0713202917,-3.14914392229,1.96210581147,-3.70587973911,1.69062624971,-3.2537854709,9.70664490768,4.20309532304,10.5882102026,4.45153208569,3.01480315617,0.874973308892,0.850851368314,-0.455453566691,-1.46087666997,-0.650547078728,-0.13158478051,0.596801108506,-1.88498031633,1.46165158851,-2.31114544616,1.46373253803,-0.00837160631438,2.15717004032,2.36066930399,2.94378551091,2.56529606294,0.828262739641,1.34375099417,0.374401714974,0.237139722211,-0.175301038521,0.023466108187,-0.302310383213,-0.322490243959,-0.0176148748876,-0.226980564143,-0.19896727334,0.421199710409,-0.234696995715,0.769920252433,0.0232015325891,0.600609783866,0.66358809484,1.29218990398,0.930355652479,0.45436208828,0.316981975607,0.0259813191643,-0.168922610063,0.0965167289848,-0.189631646532,0.137155728629],[-31770.3885711,-297.765604315,-1877.21878347,-3284.0252209,-643.713548536,509.280595973,826.72590893,-44.9260115764,-352.727832515,-822.400410634,609.849257163,33.3044579658,-904.015404327,-762.912858788,-355.26369815,46.331880754,-142.786951249,258.131645814,-202.951620265,-296.787408785,-184.930227799,-215.506617408,38.140890277,-694.540368891,137.499545054,38.7400023912,-14.5116311858,26.3785847088,-114.657916966,79.3486849369,-155.172282134,-112.238650548,-207.631818134,57.2752284877,94.62190525,17.5702112226,35.572604144,36.2560843214,-24.6427351044,-20.4003088969,-42.6524041281,-65.7535139043,-69.0509325392,-64.6822796091,5.91390487328,31.9843497381,-10.0860006899,-14.5537898535,0.42101993105,8.6356671204,3.37966938264,-1.48879589768,-5.62999601614,-16.7052883875,-8.12966703907,-5.06305997889,-13.3318531655,-5.46949343815,13.9386567877,6.4794837538,13.0161070388,10.5981152474,17.9998022877,-0.978537893961,0.675133542897,-5.20288025566,0.0114132980393,3.95470026313,-3.37320155373,1.93316193631,-3.69609426288,1.76442448882,-3.11130518032,9.8387034649,4.2531862905,10.6857953009,4.43015220556,3.04100220392,0.927275331981,0.854844322961,-0.453325055937,-1.48352839925,-0.628472543724,-0.161380486618,0.597669981808,-1.90657388049,1.48782023737,-2.32718747703,1.4510822333,0.0544020736382,2.19570575868,2.42365432154,2.98616401749,2.56365674414,0.824072478919,1.32235035769,0.421467937315,0.234420489079,-0.164292521827,0.0237834505185,-0.298951929826,-0.303404533854,-0.00728534924889,-0.22873840255,-0.188783654625,0.425356366927,-0.231966821729,0.772622989204,0.0432319636324,0.596017454246,0.678869849792,1.29056932691,0.920021536862,0.454863628793,0.305541172323,0.0498172888089,-0.167942854665,0.0970131117195,-0.188308082727,0.131808903819],[-31798.416098,-279.86376821,-1881.39685116,-3237.47536897,-633.983600471,562.480329622,823.000379781,-79.0644987096,-362.341122648,-854.485130885,598.160028222,59.1011210317,-900.528198202,-726.387578199,-332.554682367,36.2827825275,-128.289134951,276.428088598,-184.239796868,-311.789042118,-172.524289989,-224.081763324,26.244915475,-680.337637758,137.216292539,47.7619274579,-18.7374868276,31.6750312411,-115.296806273,78.8230026712,-158.707982636,-112.715553839,-207.886067409,58.1088093602,96.3660444529,17.5966538458,35.304053457,34.8472459955,-25.577468499,-20.0481951433,-42.9991845009,-68.8276969488,-69.2269608528,-66.3098814009,7.23587220748,33.6861740091,-10.3751448175,-15.137265369,0.242520545755,8.00600053271,2.76861822762,-1.57769685202,-6.02341227017,-17.4363564288,-8.69996190145,-5.12081401461,-13.3310521065,-4.83293251304,14.7567348074,6.32326690539,12.7821227151,10.2373085197,18.0999141536,-1.03475048629,0.593983390094,-5.3642925425,-0.176700409697,3.82405443626,-3.55775830651,1.90638646722,-3.66753063775,1.79363151113,-2.96649923645,9.96151643152,4.29255006886,10.7301201187,4.38205170382,3.10048039535,0.989622069735,0.850145175157,-0.442256911437,-1.50547781039,-0.603382940294,-0.184385899014,0.591800261876,-1.92623322246,1.50934701385,-2.3359282556,1.42334031585,0.114685281054,2.23103646577,2.48317412169,3.01608965779,2.5507123274,0.828414386668,1.30934608282,0.466216641203,0.233321182461,-0.156955231767,0.0260282214747,-0.296355597972,-0.286420902547,0.00389324688389,-0.23131712485,-0.180697720649,0.427026991835,-0.22749657814,0.772697277704,0.0620915498556,0.590874222448,0.693898906538,1.2889233633,0.906956578725,0.456411065626,0.296703232406,0.0737082889529,-0.165960300257,0.0960428183638,-0.187829339557,0.12686515018],[-31840.100807,-264.404701182,-1866.3443271,-3177.52736949,-622.019274418,622.986600476,824.588947927,-112.205941311,-364.044928399,-887.214774641,582.68499259,87.4876085483,-896.684948065,-693.497904883,-313.900957794,27.1212644616,-115.741194148,291.800286337,-165.243648895,-325.849500484,-160.686162479,-234.349522135,14.3324686683,-662.957492441,136.277108211,56.2290907167,-23.6674621646,37.073801193,-115.335010586,78.6970472662,-162.646646594,-113.111131582,-206.666190315,59.2750897673,97.506183356,17.3022045891,35.0584687654,33.478023348,-26.5719614989,-19.5334670367,-43.0515605334,-71.8129988221,-69.3506415657,-67.6710454775,8.72974265752,35.0173869976,-10.9076867102,-16.0286130656,0.0171142735267,7.4245205688,2.2447875278,-1.67411399922,-6.40735117519,-18.0123975291,-9.22300287211,-5.12818853957,-13.3926817173,-4.16613259528,15.4834230566,6.09094006808,12.3987738771,9.86882099825,18.272299567,-1.0782873477,0.527375151808,-5.49294247236,-0.350299477453,3.6802109577,-3.70129837717,1.88062541504,-3.62005212502,1.77729906409,-2.81960384515,10.0705490213,4.32035743673,10.7209214829,4.31188274444,3.19158542568,1.0616166319,0.833987462703,-0.422710057224,-1.52608205704,-0.575540070133,-0.200342056174,0.579146716805,-1.94348090244,1.52648773459,-2.33716946429,1.38088629108,0.172033569633,2.26271555572,2.53885683294,3.03284373,2.52792619794,0.840890250615,1.30490299116,0.507295878407,0.233187734092,-0.153075101943,0.0301059583242,-0.294505931526,-0.271818660978,0.0159056489898,-0.23455960704,-0.174687512763,0.426444805215,-0.221288512404,0.77040861406,0.0796217025906,0.585295728041,0.708652030948,1.2869728591,0.89149589181,0.458767497374,0.29070264021,0.097141713082,-0.163261552243,0.093671624133,-0.188085518102,0.122420097435],[-31894.7163492,-250.886725697,-1841.61570888,-3107.85859573,-606.746707124,687.691105278,830.148655792,-145.276121247,-359.064277716,-919.866557098,563.367065494,117.819061739,-893.195977389,-663.468041321,-298.572978946,18.8295845757,-105.03619128,304.338954693,-146.107126292,-339.116066778,-149.349188173,-245.837772849,2.51557683787,-642.97377298,134.778979204,64.0832911396,-29.2019385327,42.5430646603,-114.787347313,78.9369315444,-166.893331367,-113.353558766,-204.196036453,60.6911440123,97.9370247552,16.7252806135,34.82697432,32.1734920066,-27.6126692642,-18.8521521358,-42.827312193,-74.7001596227,-69.3969255234,-68.8179057965,10.3692723791,35.9268828309,-11.6865433364,-17.1785021275,-0.24450946095,6.89268050904,1.81361603975,-1.77276422875,-6.77654927003,-18.4377231928,-9.70371944082,-5.08076100655,-13.5213693839,-3.47712060466,16.1014379175,5.77819665518,11.8832909023,9.50468011127,18.5097220735,-1.10926421201,0.476609847345,-5.58920220159,-0.508541355787,3.524426934,-3.80427102548,1.85345585318,-3.55352058776,1.71673590775,-2.6715811957,10.1611335466,4.33475397505,10.6615596836,4.22588779366,3.3111807237,1.1423849997,0.803540691861,-0.39562704845,-1.54478231382,-0.545515386424,-0.209551804038,0.559960028346,-1.95801220427,1.53940457533,-2.33103384036,1.32490449259,0.226165046515,2.29041299501,2.5900808829,3.03660365515,2.49742927074,0.86071331999,1.30882152033,0.543254722327,0.233241020047,-0.152245479174,0.0357574839246,-0.293341781479,-0.259783654372,0.0286172522865,-0.238257777501,-0.17066238592,0.423944178495,-0.213433695731,0.766158879511,0.09581608022,0.57948065604,0.723050874995,1.2845263848,0.874164942928,0.461678877682,0.287674872125,0.119504578179,-0.160236577797,0.0900249782815,-0.188904580923,0.118542263044],[-31960.4692526,-242.353966593,-1816.2692176,-3032.73205958,-588.142368468,753.883177093,836.92338759,-178.343496326,-348.844554225,-951.779494789,540.549290054,148.914121626,-890.477439013,-635.549606726,-285.285417051,11.3615439497,-95.9619281763,314.28266954,-127.03094272,-351.670828612,-138.42468263,-257.821951696,-9.10286123841,-621.044518026,132.846622789,71.311379065,-35.2008724209,48.0704533162,-113.670525203,79.5104241699,-171.28824527,-113.380048951,-200.730835331,62.2467142196,97.5837474275,15.9196675158,34.6077155364,30.9575563368,-28.6699569032,-18.0038160133,-42.3511758498,-77.4738033354,-69.3440752914,-69.8050866684,12.1146422192,36.3764937728,-12.7119796071,-18.5285758818,-0.529267130729,6.41104161574,1.47631117924,-1.86491205758,-7.12733060059,-18.7202569655,-10.1491295073,-4.97534955139,-13.7174769814,-2.77826456955,16.5975452754,5.38021391028,11.2597955939,9.15675000728,18.8025393729,-1.12806944946,0.44226381199,-5.65508843292,-0.650584095959,3.35821105166,-3.86817389831,1.82183592521,-3.46840963698,1.61552647255,-2.52425199545,10.2297358807,4.33311719886,10.5583051728,4.13055126182,3.45496048778,1.23043581449,0.75624051732,-0.362327935494,-1.56122229355,-0.514044309737,-0.212660918183,0.534671627931,-1.96952660059,1.54818493606,-2.31783329421,1.25726655486,0.276860486714,2.31413729708,2.63597450651,3.02834449386,2.46154037901,0.886844891791,1.32055939616,0.572715150558,0.232693818689,-0.153979742636,0.0426183942549,-0.292803586677,-0.250407367058,0.0417978350871,-0.242185518566,-0.168452369715,0.419916643374,-0.204026878497,0.760434297285,0.11077271221,0.573717518108,0.736958228936,1.28151869771,0.855523911605,0.464902383067,0.287606820761,0.140166639401,-0.157337170348,0.0852743337744,-0.190079629056,0.115282412166],[-32035.0967411,-242.281615756,-1797.96529608,-2956.09583159,-566.378108837,819.270269379,842.184485979,-211.393400036,-334.849406396,-982.299906115,514.683001682,179.337593035,-888.908644814,-609.25977102,-272.673830479,4.65087242385,-88.3120654625,321.935533079,-108.253154033,-363.594175152,-127.850952441,-269.525592469,-20.3915887735,-597.880631575,130.601256261,77.913720941,-41.505738625,53.6484710409,-112.014401207,80.3814469667,-175.645517243,-113.116943918,-196.532869223,63.8284454372,96.4046143937,14.9452693078,34.3997394455,29.8536636192,-29.7059810125,-16.9931966493,-41.6493270404,-80.1127643422,-69.1647723411,-70.6871424379,13.9213651535,36.336787422,-13.9808024436,-20.0190938095,-0.82262004713,5.97975458998,1.2309073878,-1.94021409886,-7.45626637523,-18.8691326407,-10.567375833,-4.80810342809,-13.9788591487,-2.08324165302,16.960686276,4.89320402375,10.5556107942,8.83704985748,19.1396266771,-1.13505567292,0.424556579835,-5.69357592213,-0.775799775646,3.18339676494,-3.89500435371,1.7823610704,-3.36571868953,1.47857253444,-2.37948909892,10.2732473444,4.31237574902,10.4188874621,4.03237527876,3.61803480565,1.32357294514,0.690029211366,-0.324264071634,-1.57510764295,-0.481922640504,-0.210581900755,0.503898487625,-1.97781800247,1.55279806434,-2.29814427617,1.1802115863,0.324057946597,2.33401048355,2.67549153428,3.00950209477,2.42273761795,0.918207495019,1.33929988294,0.594389259858,0.230834494491,-0.157752185717,0.0502702732179,-0.292814178265,-0.24368931817,0.0551468662834,-0.246128443198,-0.167866020171,0.414776121789,-0.193222578561,0.753739334413,0.124671123725,0.568330416565,0.750203256282,1.27796672814,0.83616890068,0.468250177898,0.290363676112,0.158499710481,-0.155028172447,0.0796332128365,-0.191375731908,0.112684024852],[-32117.8218397,-248.602690075,-1792.25818339,-2880.79859946,-540.65211515,881.799975901,843.624224964,-244.963187085,-318.257387347,-1010.80203473,486.175061332,207.698604389,-888.973314418,-584.842777485,-259.482787016,-1.34801742222,-81.9831958162,327.609176552,-90.0526367392,-375.026943353,-117.810265647,-280.179364505,-31.1110183189,-574.113747115,128.142953562,83.8734190904,-47.9717165428,59.254341416,-109.863450417,81.4783329234,-179.754379305,-112.433107271,-191.839365134,65.3380234854,94.3623321643,13.8567187682,34.1973761391,28.8823462397,-30.6854611458,-15.8264421664,-40.7465876314,-82.5860974445,-68.8161302474,-71.5116814209,15.7479933632,35.7816748217,-15.4919714089,-21.5945087604,-1.11139554705,5.59941255567,1.07347882889,-1.98838645468,-7.75901708736,-18.8918222881,-10.9653005084,-4.57290084104,-14.3018062676,-1.40453601432,17.1796501257,4.31117822057,9.79666154502,8.55769871518,19.5105413408,-1.1304762649,0.424100703744,-5.70785674365,-0.883734148568,3.00213586416,-3.88628799101,1.73175948234,-3.24691138476,1.31124036419,-2.2389952781,10.2885570018,4.26827924366,10.251214407,3.93834947324,3.79628762316,1.41927551503,0.603231087581,-0.282700566061,-1.58606316944,-0.449862372107,-0.204311173662,0.468392297311,-1.98272921577,1.55305625303,-2.27291705893,1.09602571297,0.367790446213,2.3501541388,2.70726094886,2.98167397975,2.38369524479,0.954087348391,1.36400411002,0.607056817351,0.227062890032,-0.163058377691,0.0583221610805,-0.293295430404,-0.239551747462,0.0683437853461,-0.249923981399,-0.168742969039,0.408886027298,-0.1812705918,0.746551904916,0.137729059077,0.563649554018,0.762555792797,1.27394683734,0.816752908079,0.471684982663,0.295751221437,0.173870582765,-0.153740740515,0.0732860026526,-0.192557553204,0.110782923005],[-32208.7301777,-254.925257768,-1802.55011429,-2808.43985339,-509.27457103,939.960896355,839.387895126,-280.343642498,-299.899131683,-1036.69897498,455.379629634,232.77148568,-891.360255054,-563.131182962,-244.691335308,-6.63332014395,-76.9398431964,331.587596221,-72.7269779696,-386.163165618,-108.654392404,-289.09128548,-40.9206253443,-550.244309086,125.555883696,89.1572104973,-54.4824619485,64.8552404365,-107.269266457,82.7124876507,-183.398560949,-111.157235801,-186.842062487,66.7020807996,91.4113784077,12.6995316891,33.9920965658,28.0586461235,-31.5793281761,-14.508744051,-39.662376906,-84.8568785477,-68.2442024532,-72.3155570768,17.5615928149,34.6845307276,-17.2472009231,-23.2052781828,-1.38488801355,5.27122845953,0.999154052161,-1.99995489799,-8.02995033659,-18.7933175897,-11.3471499265,-4.26239494532,-14.681649659,-0.752158035208,17.2431177103,3.62668001404,9.00656132901,8.33016988049,19.9063057692,-1.11471817019,0.441852276624,-5.70080193433,-0.97406582438,2.81676656654,-3.84303866617,1.66722347627,-3.11361004138,1.11886068275,-2.10413463621,10.2727972142,4.1960016104,10.062724892,3.85531508519,3.98650689323,1.51505027689,0.494589016938,-0.238680486228,-1.59365213016,-0.418414242384,-0.194792337398,0.428885456596,-1.98416040356,1.54875178472,-2.24328015347,1.00688558632,0.408121010587,2.36271225504,2.72978906956,2.94647680799,2.34701330853,0.994147737009,1.39362010393,0.609624955861,0.220924633034,-0.169470215003,0.0664528942084,-0.294180794719,-0.23787081338,0.0810834624361,-0.253474470482,-0.170964299832,0.402544787943,-0.168471781172,0.73930857891,0.150141724739,0.559999298136,0.773761885847,1.26957420701,0.797914909391,0.475289446732,0.303576345542,0.185677413678,-0.153844418065,0.0663730611881,-0.19342269018,0.109600990729],[-32307.9692184,-254.896025693,-1825.76937619,-2739.35414981,-470.756244106,993.917360116,829.006121419,-319.83588148,-280.24878792,-1059.59431847,422.561083535,253.853704472,-897.085305605,-545.377178259,-227.581825192,-11.167492227,-73.151328392,333.988247158,-56.5402815074,-397.174138129,-100.859524913,-295.655723234,-49.4722000158,-526.654800395,122.908957613,93.7217248491,-60.9759673576,70.3952778904,-104.254230131,83.9753015078,-186.36780459,-109.134623862,-181.692604578,67.8948900554,87.5144474967,11.508375331,33.7737726223,27.3900134609,-32.3727758909,-13.0349717511,-38.4130139311,-86.8861659675,-67.3978312521,-73.1235547111,19.3514830724,33.0249951365,-19.2491622683,-24.8095421401,-1.63526486677,4.99630677078,1.00450172502,-1.96874344081,-8.26218380783,-18.5756514035,-11.7138061865,-3.86967532443,-15.1123532877,-0.130248261211,17.1419782672,2.83078641913,8.2054832055,8.16414743266,20.3198455237,-1.08821747312,0.47873283799,-5.6740144568,-1.04670369718,2.62937338182,-3.76567426224,1.58677822022,-2.96710596047,0.906363460834,-1.97556522494,10.223837537,4.09030726188,9.85960157187,3.78920417497,4.18608059383,1.60871489135,0.363471747369,-0.193017026172,-1.59741696112,-0.387846490753,-0.182724082414,0.385788658524,-1.98199910916,1.5397674513,-2.21026917775,0.91471533364,0.445003063143,2.37192239769,2.74154593919,2.90535027281,2.3148869663,1.03826336573,1.42726961227,0.601367218928,0.212034350972,-0.176651478957,0.0744301520638,-0.295396616402,-0.238516665652,0.0931490003295,-0.256788094897,-0.174469000564,0.395979365507,-0.155113869634,0.732368366046,0.161969235319,0.557693536368,0.78356149955,1.26497571116,0.780179862911,0.479203591457,0.313689521228,0.193455386435,-0.155672873554,0.0589545629238,-0.193809987392,0.109148594464],[-32415.466107,-241.667352817,-1850.53333152,-2672.96685124,-423.602521698,1045.61825357,813.783301073,-366.548560011,-259.428487976,-1079.35664671,387.858200037,270.925303836,-907.368171907,-533.179646693,-207.78681572,-14.899921701,-70.6209878888,334.736449408,-41.6722289807,-408.1848606,-95.0347728698,-299.423485154,-56.4837893184,-503.593612519,120.250830443,97.5097990872,-67.4484264417,75.7935692501,-100.818005818,85.1320605,-188.479171326,-106.252032318,-176.492858147,68.9459027111,82.6518397531,10.3073157822,33.5310330906,26.8757379255,-33.0688684458,-11.3898617647,-37.0129372989,-88.6375997828,-66.237462159,-73.9464863371,21.131220716,30.7963148916,-21.499527627,-26.3756482485,-1.85765596672,4.77560306384,1.0887416907,-1.89332466416,-8.44848356088,-18.2383467227,-12.0632231406,-3.39025405324,-15.5859098745,0.464482553847,16.8718626715,1.91483775689,7.40789662472,8.06627425363,20.7458067028,-1.05129495138,0.535776039884,-5.62759703223,-1.10187714655,2.44177539263,-3.65416331084,1.48952582111,-2.80834108288,0.67809326626,-1.85295147553,10.1407451864,3.94613924876,9.64612935197,3.74448742423,4.39303783339,1.69862641977,0.210031308716,-0.146266626311,-1.59684738203,-0.358137467942,-0.168499770288,0.339244978833,-1.97608994567,1.5260851834,-2.17477711856,0.82105751731,0.478284057071,2.37818403506,2.7411896487,2.85942174508,2.28891218313,1.08640369898,1.46425292131,0.582018586147,0.20007411109,-0.184376355168,0.0821110809514,-0.296858342423,-0.24136691149,0.104450192412,-0.259953128882,-0.179268650273,0.389326187961,-0.141451295238,0.725973738177,0.173127485946,0.557020678531,0.791721482583,1.26025658028,0.763895853802,0.483580086954,0.325976119224,0.196946023954,-0.159487014236,0.0510019613442,-0.193601191215,0.109415858494],[-32530.8094001,-209.068428007,-1862.89087856,-2608.21038566,-367.060183332,1097.59092941,795.50417404,-421.779395874,-237.484157135,-1096.22618754,351.462988449,284.455708405,-922.76278629,-527.836211344,-185.422006444,-17.8148364349,-69.4017067454,333.751699224,-28.1911450041,-419.189346354,-91.7211647861,-300.155291915,-61.789183026,-481.225045265,117.607956701,100.459875961,-73.9140956083,80.9709264737,-96.9598611502,86.0665947395,-189.602460142,-102.44871843,-171.329400843,69.899133653,76.8342439756,9.11243212097,33.2533387843,26.5084678901,-33.6802807529,-9.56408642505,-35.4707309799,-90.0813197381,-64.7429793302,-74.7870807661,22.919573067,28.0177573869,-23.9899701306,-27.8797303875,-2.0486916359,4.61011191624,1.25065806352,-1.7760031589,-8.58415220705,-17.7810036011,-12.3903710508,-2.82443263537,-16.0923642834,1.03774103623,16.4365411285,0.87500516582,6.6224089714,8.03910278627,21.1791883449,-1.00397011875,0.613914437444,-5.56132608011,-1.14047770372,2.25550074554,-3.50894895169,1.37587244361,-2.63836049682,0.438329252114,-1.73547082336,10.0243611066,3.76050765055,9.4250242522,3.72411238298,4.60548035417,1.78358111142,0.0350200294045,-0.0987499985749,-1.59144985356,-0.329166239469,-0.152385983992,0.289421113367,-1.96639946806,1.50781581092,-2.13753560616,0.727270874571,0.50788270192,2.38211464213,2.72798646163,2.80959664467,2.27001420151,1.13832396075,1.50375229763,0.551703223045,0.184837106327,-0.192454998181,0.0894130817626,-0.298475311792,-0.246278441151,0.114980456992,-0.26305037626,-0.185421500724,0.382624254065,-0.127686978044,0.720296137913,0.18350375471,0.558210601677,0.79808319369,1.25550075611,0.749215049729,0.488488552284,0.340251115174,0.196069779821,-0.165397478882,0.0424435905128,-0.19271395896,0.110348985876],[-32652.1726268,-156.321931317,-1852.79715308,-2544.79182702,-301.9397207,1151.73459073,776.18033799,-483.484352253,-214.928126376,-1110.60497944,313.686349398,295.387370734,-942.565792893,-529.655775351,-161.044256237,-20.0076004398,-69.5290357967,331.12848903,-16.0156791942,-429.993596982,-91.1278559799,-297.842486428,-65.3869473436,-459.748368348,114.992616317,102.53198445,-80.3612561821,85.8898278696,-92.6954185515,86.7379132674,-189.672124052,-97.7290497225,-166.325629895,70.7935587865,70.1214214263,7.94208216164,32.9312038,26.2774070643,-34.2166253612,-7.5673102372,-33.7860298877,-91.1973255965,-62.9171688274,-75.653566273,24.7278656986,24.7440339378,-26.6952130254,-29.3000917133,-2.20330573496,4.4990528797,1.48521726548,-1.62085828694,-8.6686321799,-17.2069530357,-12.6891388979,-2.178100082,-16.6214202902,1.59397759729,15.8507618133,-0.283160651056,5.85445009228,8.08157602649,21.6130940241,-0.945993296387,0.713246468978,-5.47590947132,-1.16452796082,2.07166780178,-3.33212157489,1.24714453309,-2.45847638391,0.192155014895,-1.62204873123,9.877975077,3.53418534013,9.1983887893,3.72979636606,4.82055359238,1.86235800292,-0.160033760063,-0.0507309268823,-1.58083404668,-0.300898531057,-0.134838867291,0.236728829966,-1.95322319773,1.4852507316,-2.09904858015,0.634958903284,0.53399193345,2.38462485354,2.70219236654,2.75672884908,2.25855553324,1.19316218302,1.5445179479,0.510938894696,0.166282694382,-0.200639966308,0.0962381682881,-0.300117997987,-0.253053612172,0.12473121098,-0.266081301206,-0.192962245859,0.375882194996,-0.113964120807,0.715538448303,0.193068927756,0.561410978845,0.80262956697,1.25074977101,0.736140708564,0.493798067396,0.356142552503,0.190927410989,-0.173321081196,0.0332402958599,-0.191077299742,0.111834057903],[-32777.2527675,-88.0310391216,-1820.86440869,-2483.28516688,-230.323118591,1207.96070885,757.480507203,-547.672865993,-192.622092459,-1122.86394359,274.765950161,304.824131811,-965.371745559,-537.988273106,-135.583947744,-21.6253239447,-70.9881305125,327.167614098,-4.96322612783,-440.387287221,-93.0891113253,-292.755200858,-67.3747244752,-439.467690993,112.414972773,103.722819296,-86.7395258366,90.5745778525,-88.0794660264,87.1826930736,-188.706417399,-92.1352939452,-161.653654087,71.6637309846,62.6178790917,6.81661534424,32.5578037795,26.1727114576,-34.6780102294,-5.42811119883,-31.952846036,-91.9802675302,-60.7750059904,-76.56476833,26.5606338529,21.0527973453,-29.5770820727,-30.6185318749,-2.31537567365,4.43913070622,1.78352785153,-1.43217443882,-8.70406083112,-16.5237138004,-12.9536891305,-1.45982794701,-17.1645757665,2.13723695521,15.1362312873,-1.54461454542,5.10843315901,8.19107207147,22.0395692585,-0.877210863263,0.832671556345,-5.37325829444,-1.177033163,1.8912959768,-3.12712357444,1.10537034411,-2.27024786987,-0.0545973130047,-1.51121743989,9.70655200997,3.27160940623,8.9682123233,3.76241984874,5.03475602794,1.93351610527,-0.373084297683,-0.00246731973935,-1.56482675597,-0.273416591257,-0.116592251669,0.181862139122,-1.93717761047,1.45888807358,-2.05973929499,0.545985146159,0.5571032041,2.38670477115,2.66497945006,2.70163337621,2.2545889276,1.2496378429,1.58501745174,0.460480246384,0.144548696622,-0.208622998827,0.102476977299,-0.301632889998,-0.261451366596,0.133636141888,-0.268989178205,-0.201877779183,0.369108606436,-0.100408797744,0.711944689747,0.20187927029,0.566670590298,0.805484748967,1.24600246483,0.724621120874,0.499238941132,0.373119527947,0.181761106875,-0.183046403398,0.0234491513749,-0.188617453744,0.113730427642],[-32904.2104292,-13.1108948576,-1774.26557629,-2424.14731953,-154.743283423,1264.52854531,740.803168145,-611.239378914,-171.105529094,-1133.2184316,234.733502503,313.791365266,-989.928054345,-551.731241126,-110.281504836,-22.7420204598,-73.702306192,322.263259558,5.14900443773,-450.25331904,-97.269985659,-285.441922156,-67.8914488371,-420.671129451,109.877236293,104.063246127,-92.9790302877,95.0754457245,-83.197117819,87.4733876201,-186.790899204,-85.7071163804,-157.469972203,72.5603305854,54.4414360204,5.74829620874,32.1307808783,26.1842338837,-35.0593918027,-3.17721489975,-29.9621355564,-92.4312308581,-58.3299994275,-77.538557905,28.4227482599,17.0269254069,-32.5957484781,-31.8197645884,-2.38137768728,4.42508206598,2.13518695657,-1.2139532866,-8.69157002694,-15.740368568,-13.1770766229,-0.678365096279,-17.7146413011,2.6734519112,14.3163074702,-2.88931322936,4.38752907898,8.3643116988,22.4507717963,-0.797939886843,0.970077680128,-5.2557394646,-1.18117923312,1.71541697412,-2.89787192329,0.953354224659,-2.0751947327,-0.296149597977,-1.40093853343,9.5156460976,2.9789785844,8.73626443018,3.82211441035,5.2451656374,1.99562492907,-0.601781123151,0.0458903525825,-1.5434693952,-0.246862245538,-0.0984577394086,0.125488183075,-1.91899021421,1.42938243627,-2.02004377667,0.46219536468,0.577793237493,2.38932920621,2.61797578217,2.64510874451,2.25791468965,1.30658254045,1.62368940811,0.401133719967,0.119861899786,-0.216103483994,0.108092799222,-0.302880158092,-0.271218921891,0.141592800393,-0.271753887654,-0.212133062565,0.362295355561,-0.0871711642028,0.709738486745,0.209993780689,0.573980157031,0.806844012968,1.24124844495,0.714550642773,0.504560979824,0.390618627108,0.168912392368,-0.194291701349,0.0132041988037,-0.185261724985,0.115887755754],[-33031.0543234,59.6319042135,-1720.06226532,-2367.50610544,-77.1578650443,1319.2176361,727.336037403,-672.300747477,-150.486825008,-1141.76018346,193.50630821,323.064122022,-1015.27756428,-569.711153321,-86.2675968643,-23.3639777178,-77.5868546524,316.805494754,14.45852702,-459.52368994,-103.315548943,-276.541246189,-67.1044267756,-403.540565883,107.367023906,103.59987625,-99.0097843383,99.4444106208,-78.142124631,87.6850736452,-184.035608977,-78.486854273,-153.860889325,73.5341742119,45.7120376208,4.73967790953,31.6507769426,26.2987644326,-35.3557626875,-0.841371037595,-27.8078181029,-92.5508380603,-55.5960980911,-78.5784200823,30.31573024,12.7454122997,-35.7159191891,-32.8926960998,-2.40056193093,4.45023799726,2.52953204918,-0.970699996896,-8.63150418004,-14.8666173304,-13.3513040481,0.156919874297,-18.2634414044,3.20813473349,13.4132152976,-4.2963205678,3.69337230063,8.59699579904,22.839784059,-0.708663689457,1.122796142,-5.12577010254,-1.17994678108,1.54485741857,-2.64838830137,0.794294411293,-1.87491733916,-0.527134520601,-1.28920856458,9.3107721337,2.66259394499,8.5039527347,3.90787194494,5.44974330248,2.04747784505,-0.843735775842,0.0943326061866,-1.51691979462,-0.221357475335,-0.0811963479347,0.0680924762037,-1.89937216112,1.39737684058,-1.98039584142,0.385149058431,0.596546951243,2.39337510668,2.56278590171,2.58787984426,2.26798452856,1.36312281031,1.65913558216,0.333627410656,0.0924857994498,-0.222872785155,0.113132385526,-0.303729507437,-0.282096770355,0.148511139341,-0.274398433051,-0.223689294974,0.355393696196,-0.074406805751,0.709044097888,0.217443547736,0.583295498031,0.806886991081,1.23648108163,0.705741838788,0.509577897898,0.408110638057,0.152744494051,-0.20675691493,0.0026698648073,-0.18094854497,0.118170260675],[-33156.6423178,123.356545822,-1663.25524017,-2313.95423316,1.33873440809,1370.02075168,717.387542976,-729.539034094,-130.704874054,-1148.53692013,151.096434395,333.036356987,-1040.51804814,-590.755101289,-64.3917638131,-23.4654138622,-82.6026775579,311.192202299,23.0394489581,-468.148271025,-110.897140137,-266.677687611,-65.2022148614,-388.128535231,104.874427201,102.379003453,-104.773868244,103.73351301,-73.0143641708,87.886006827,-180.548052298,-70.5249685023,-150.837746695,74.6260630531,36.5331426498,3.7919611179,31.1181834198,26.4983617353,-35.5625406123,1.55487963926,-25.4891782742,-92.3398515014,-52.5933513074,-79.6719638368,32.2325718797,8.27686100766,-38.907878824,-33.8298439684,-2.37365656809,4.50737246449,2.95553968738,-0.707148242828,-8.52482832279,-13.9129823448,-13.469027345,1.03530139611,-18.8016830839,3.74433215561,12.4461016376,-5.74565606207,3.0259458177,8.88430667058,23.2012608487,-0.609903919448,1.28827139666,-4.98579877658,-1.17612280106,1.38024849913,-2.38266793819,0.631425226646,-1.67119919612,-0.742737478953,-1.17477573098,9.09709107399,2.32831724833,8.27227424872,4.01785752911,5.64728450315,2.08826423364,-1.09682539595,0.142939815212,-1.48535041072,-0.196937987149,-0.0655307050789,0.010075442228,-1.87899828398,1.36344645116,-1.94124162551,0.316051856707,0.613712666408,2.39960934756,2.50093352876,2.53050355152,2.28395409262,1.41857433186,1.69020160552,0.258470862487,0.0627086519184,-0.228783903612,0.117676610999,-0.304054199359,-0.293808046067,0.154317381166,-0.276971277683,-0.236498777478,0.348330385327,-0.0622441593983,0.709893165359,0.224265328165,0.594551407196,0.805779999472,1.23168537829,0.697940954122,0.514144104067,0.425141107687,0.133565194234,-0.220131135415,-0.00798187971448,-0.175641161101,0.12046542929],[-33281.5834133,174.585169372,-1606.66306949,-2264.04943742,80.3440778752,1415.55847389,710.856314328,-782.288286504,-111.659636752,-1153.60958108,107.533530251,343.849096328,-1064.9772225,-613.813151057,-45.4213323966,-22.9947263809,-88.7542625813,305.80244542,30.9060253001,-476.108025838,-119.692088734,-256.461060522,-62.3670806612,-374.328409634,102.394973071,100.440278782,-110.228099941,107.985705175,-67.9088187974,88.1406778308,-176.438600472,-61.8862436714,-148.34039792,75.8575751484,26.9869543827,2.90544057353,30.5312730543,26.7635702337,-35.6784933343,3.98622382813,-23.0084857341,-91.8031040568,-49.3464636628,-80.7931003062,34.1586222255,3.67610957733,-42.1444307942,-34.6295546031,-2.3018854319,4.58950923411,3.40184333374,-0.427953187893,-8.37330833486,-12.8910377286,-13.5242205267,1.94493274354,-19.3200633075,4.28179494887,11.4302149053,-7.21844165352,2.3835870748,9.22024063593,23.5310047002,-0.502168994495,1.46421978403,-4.83825882483,-1.17232557405,1.22189150175,-2.10486404416,0.46762529232,-1.46613699184,-0.939160249962,-1.05734138664,8.87898665821,1.98158241619,8.04153117518,4.14931826857,5.83687773193,2.11750778581,-1.35918557273,0.191854876939,-1.44889823732,-0.173578282414,-0.0521027371336,-0.0482237871428,-1.85858392541,1.32806593146,-1.90303650352,0.255645882044,0.629517226007,2.40862409231,2.4338351904,2.47332386843,2.30469233163,1.47237625719,1.71601507075,0.176017760867,0.0309246688495,-0.233760440394,0.121818330475,-0.303725020566,-0.306062124873,0.158957473498,-0.27952825946,-0.250494069193,0.341020349459,-0.0507897180316,0.71222664205,0.230504316594,0.607647957323,0.803665212715,1.22681689164,0.690829070363,0.518131413822,0.441339496287,0.111598648291,-0.234077469969,-0.0185984153753,-0.169341890989,0.122674044262],[-33408.1647021,213.28291514,-1555.48643561,-2217.96694355,160.188058753,1454.21138809,707.616118718,-831.379960047,-93.2254614449,-1156.96051436,62.652686758,355.510406801,-1088.66388066,-637.989418168,-30.3867571032,-21.8645588735,-96.0502647734,300.981211548,38.0452329751,-483.53767674,-129.356380779,-246.622386242,-58.7549916252,-361.94180834,99.9324283019,97.8206550153,-115.343668472,112.24201024,-62.936219867,88.5140774326,-171.870324948,-52.6506255114,-146.272365996,77.2234269896,17.1274735144,2.07819543345,29.885851192,27.0753762031,-35.7062406569,6.42246537316,-20.3691964496,-90.9629741449,-45.8842225745,-81.9152151487,36.0722445833,-1.02201128619,-45.3992215213,-35.2967122512,-2.18703798244,4.68982645213,3.85691122132,-0.137541825247,-8.1789654479,-11.8134432244,-13.5141326517,2.87279391997,-19.8127645142,4.81692638993,10.3749439109,-8.69635080059,1.76284548833,9.59772009734,23.8252939146,-0.386117948052,1.64856437329,-4.68557072677,-1.17116092656,1.07012045514,-1.8193034621,0.305206827182,-1.26218469109,-1.1143476657,-0.937449174536,8.65917132469,1.62767860226,7.81083006446,4.29859506348,6.01731355716,2.13494479316,-1.62924744913,0.241253632514,-1.40768199811,-0.151182841886,-0.0415101755997,-0.106404012867,-1.83892867562,1.29172318072,-1.86622877618,0.204091464071,0.644122631203,2.42058430567,2.36287631607,2.41621654419,2.32883594238,1.52391116383,1.73597194115,0.0864831054058,-0.00234701941452,-0.23780710003,0.125660665305,-0.302611328275,-0.318561148465,0.162389443898,-0.282104282042,-0.26559245003,0.333416378409,-0.0401155045455,0.715911566433,0.236218664045,0.622393649309,0.800676641699,1.2217026891,0.684028082784,0.521349849521,0.456407470899,0.0869598455728,-0.248243473333,-0.0290526174484,-0.162103313428,0.124706982602],[-33540.1930555,241.746954398,-1510.4897735,-2175.89318106,241.594926204,1485.54907146,706.849319419,-878.179782668,-75.2436273071,-1158.5501993,16.3830144559,367.695392831,-1111.71262275,-662.523136632,-20.1386892908,-19.962115812,-104.517710235,297.078893858,44.3901876742,-490.562390204,-139.547179131,-237.869762581,-54.5007263156,-350.66854777,97.4957255988,94.5573298985,-120.098550225,116.543351277,-58.1940341893,89.0692193581,-167.022775255,-42.9009005748,-144.483305788,78.689417968,6.98854422194,1.30606736924,29.1790820932,27.4122258211,-35.6490827688,8.83228044862,-17.574827762,-89.8478626814,-42.2368511208,-83.0002758321,37.9419534229,-5.79535460967,-48.6464986817,-35.8380743485,-2.03060454093,4.8016988059,4.30853938172,0.1601304234,-7.94382774505,-10.6935677492,-13.4371315504,3.80475245748,-20.2734433496,5.34280113503,9.28665202854,-10.1607667835,1.16003878886,10.0084017287,24.080506127,-0.262520315461,1.83923273796,-4.5303755709,-1.17514486936,0.92500382216,-1.53046568457,0.146177899637,-1.06206264991,-1.26679809347,-0.816030182636,8.43971840408,1.27195841909,7.5789910469,4.46114794158,6.18752848069,2.14072069748,-1.90543763341,0.291285591085,-1.36181203142,-0.129643239915,-0.0343436958515,-0.164125207224,-1.82089491054,1.25494796802,-1.83118260574,0.16123649788,0.65767793291,2.43558768379,2.28938907886,2.3589540312,2.35482014114,1.57271052038,1.74973443327,-0.00996217772202,-0.0365261191968,-0.241039234352,0.129318297107,-0.300570344546,-0.33100694559,0.16457421643,-0.284704964076,-0.281706051144,0.325494323138,-0.0302711002374,0.720760490721,0.241476450633,0.638603030305,0.796946144084,1.21614433815,0.677125435118,0.523624772415,0.470123806244,0.0597177449101,-0.262256413549,-0.0392297752892,-0.154014422443,0.126499695187],[-33681.0066773,263.886884369,-1468.07758277,-2137.58288104,325.627575479,1510.37831723,707.068383013,-924.236529771,-57.4763592978,-1158.21655783,-31.0528193755,379.895994214,-1134.10297615,-686.629920236,-15.3006947422,-17.2056582503,-114.161194852,294.484846092,49.8580756607,-497.217564867,-149.900030179,-230.80924111,-49.6994970122,-340.137679035,95.0872495623,90.6863459957,-124.460562562,120.930654417,-53.7483757642,89.8727795423,-162.060484957,-32.7100969383,-142.780647422,80.1937710187,-3.40298981484,0.581828460635,28.4080739539,27.7505270729,-35.5095861761,11.1854494017,-14.6288422069,-88.4831253961,-38.434836886,-83.9948937545,39.7263922177,-10.6253602837,-51.8566540008,-36.2583350893,-1.83324210099,4.91794036278,4.74371558633,0.461044195154,-7.67027055201,-9.5456932544,-13.2912085696,4.72613457066,-20.692553608,5.84932091883,8.17128786193,-11.5922433645,0.572269262751,10.4427150372,24.2928472932,-0.131920361693,2.0339662225,-4.37581113563,-1.18674577128,0.786369328697,-1.2431981909,-0.00762377828459,-0.868762482005,-1.39480595676,-0.694295811941,8.22262653377,0.919894114318,7.34506429811,4.63184748404,6.34656177862,2.13531259249,-2.18593616998,0.342111143251,-1.3113953065,-0.108909788617,-0.0312315512616,-0.221155534346,-1.80542159225,1.21822711162,-1.7982287418,0.126774091698,0.670338798142,2.45380569148,2.21455638039,2.3013831478,2.38092232126,1.61844649331,1.75713235784,-0.113052708623,-0.071027673368,-0.243621930355,0.13292544287,-0.297429654286,-0.343098523378,0.165474577622,-0.287309142208,-0.298756616307,0.317218111235,-0.0213148371189,0.726521153521,0.246344239439,0.656118662351,0.792568038954,1.20996732477,0.669679355798,0.524833609908,0.482319565694,0.0299406135843,-0.275725847739,-0.0490214206328,-0.145197532175,0.128009616996],[-33827.836691,285.780300309,-1421.12664455,-2101.63785516,414.550960448,1531.09789557,706.297790127,-969.579934018,-39.7666882854,-1155.38535965,-78.8562510456,391.72712667,-1155.08643042,-709.531417529,-16.1601895747,-13.6482608508,-124.900749076,293.67498313,54.4540168272,-503.34103635,-160.074472408,-225.817066695,-44.4547543602,-329.906871978,92.681558131,86.2360204562,-128.393509592,125.459613979,-49.6264983601,90.9867324804,-157.08071884,-22.1618272411,-140.933272732,81.6428206743,-14.0111507237,-0.104779574521,27.5610841242,28.0606718659,-35.2890878257,13.449922345,-11.5361781299,-86.8820084342,-34.5173248665,-84.8262171659,41.3722475501,-15.4834165894,-54.998370494,-36.559648928,-1.59441337043,5.02903904046,5.1470950992,0.760352399323,-7.36417254781,-8.38483526153,-13.0734988467,5.62022737211,-21.0542189086,6.32201532049,7.03904965506,-12.9735111589,-0.00246583156853,10.8897753725,24.4586429458,0.00590208180437,2.23039316398,-4.22568495964,-1.20879307069,0.653247858776,-0.962542432346,-0.154886146771,-0.685803223985,-1.49578458236,-0.574613539201,8.01099969313,0.575930466818,7.10871140786,4.80510841741,6.49349659981,2.11933815826,-2.46881758313,0.394039635265,-1.25646373366,-0.0889074374831,-0.0328908443366,-0.277378561681,-1.79346544766,1.18169017268,-1.76775140842,0.100295987857,0.68207989377,2.47569564524,2.13912878152,2.2435528401,2.40513568899,1.66085387583,1.75793367584,-0.22236537019,-0.105303241562,-0.245712253219,0.136618171557,-0.292960628156,-0.35448702178,0.165071543883,-0.289868893688,-0.316671142849,0.308455198035,-0.0132842342473,0.7328508395,0.250874290615,0.674807740951,0.787500015865,1.20306369189,0.661126296285,0.524907293475,0.492786914771,-0.0022743061019,-0.288271544765,-0.058355796205,-0.135803828647,0.129199924951],[-33977.574287,310.382603134,-1361.98051302,-2066.49054741,509.482062317,1550.62663442,701.423836007,-1013.01989405,-22.0205131119,-1149.71059569,-125.908450394,402.580905143,-1173.59210969,-730.630361845,-22.7349188994,-9.40280214964,-136.594613251,295.14454962,58.178351287,-508.70528364,-169.813094437,-223.10201348,-38.8849215031,-319.578454825,90.2569394469,81.2601781977,-131.853333951,130.19059276,-45.8420069608,92.4468522518,-152.150493494,-11.3647836531,-138.73112641,82.9124392456,-24.7799121435,-0.760934963274,26.6317612357,28.3133847545,-34.9840590185,15.5920517444,-8.31076352011,-85.0600061225,-30.5340605808,-85.4210020592,42.8198019104,-20.3324885963,-58.0363274676,-36.7463178457,-1.31363043007,5.12602333502,5.50240250607,1.05468648845,-7.03411850423,-7.22650243907,-12.7825842252,6.46925669622,-21.3406515465,6.74454709198,5.90213933612,-14.2886477085,-0.566040183642,11.3379540205,24.5745301296,0.151199658005,2.42595672058,-4.08436051328,-1.24370800118,0.52470182183,-0.693201621808,-0.294505040853,-0.516893595694,-1.56686703032,-0.459892414855,7.80820647709,0.243875872467,6.86980840583,4.975295614,6.62706300529,2.0934507901,-2.752009169,0.447288973825,-1.19725967731,-0.0695952153417,-0.0400058801504,-0.332580157199,-1.78578441889,1.14536170376,-1.74013826762,0.0813668145739,0.692882462423,2.50171943259,2.06360304234,2.18552999584,2.42544750222,1.69959575676,1.75191879127,-0.337199996802,-0.138814902105,-0.24746372239,0.140496331968,-0.286978642054,-0.364801704223,0.163342794687,-0.292318436324,-0.335338561662,0.299047815403,-0.00616076877803,0.73938314926,0.255142130597,0.694543985622,0.781618775516,1.1953639874,0.65090378472,0.523809986938,0.501296115063,-0.0367581636859,-0.299546448253,-0.0671995055283,-0.126000645656,0.130052767632],[-34127.7299445,339.634648161,-1286.04492118,-2031.49390735,610.729490743,1571.18371155,689.795539086,-1053.6014188,-4.4116069562,-1141.07652562,-171.090320477,411.992961148,-1188.7231985,-749.143965561,-34.9132221461,-4.63898920967,-149.072449435,299.333491358,61.0840621142,-513.117582603,-178.782484624,-222.785875528,-33.0756964982,-308.842807031,87.8089904983,75.8257245632,-134.785315842,135.183879376,-42.4063438705,94.2939123065,-147.338918004,-0.423119763943,-136.005850914,83.8817994375,-35.6295646208,-1.38581670673,25.6196777733,28.4836896738,-34.5897423761,17.5797052705,-4.97269652037,-83.0410635262,-26.5336828816,-85.7147445635,44.018425024,-25.1286959647,-60.9285483134,-36.8224863686,-0.989759982405,5.20094712593,5.79464871788,1.34064265099,-6.68950687167,-6.08732363632,-12.4197871986,7.25745074022,-21.5350419917,7.10397550146,4.7745835078,-15.5202306005,-1.11868542987,11.776141356,24.637640957,0.304005209221,2.61803344867,-3.95625398359,-1.29360085458,0.400195004405,-0.440040422141,-0.425616726951,-0.36541301798,-1.60536763663,-0.352115260545,7.61772534189,-0.0717951681618,6.6288726832,5.13727685618,6.74588397811,2.05842537274,-3.03306414698,0.501821400596,-1.13417498603,-0.0510034558797,-0.0531919197796,-0.386456512916,-1.78299795653,1.10932257786,-1.71574966361,0.0695740689817,0.702941354431,2.53231318391,1.98861431899,2.12751836517,2.44015315637,1.7343579708,1.73903845844,-0.456476977555,-0.17103534798,-0.248986427377,0.14460319169,-0.279345966173,-0.373694816552,0.160284309249,-0.294573488272,-0.354611209552,0.288879765416,8.76361422893e-05,0.745760057845,0.259238967434,0.715207761693,0.774830815199,1.18685085928,0.638564711226,0.521562612143,0.507666584311,-0.073208097869,-0.309229932911,-0.075506268951,-0.115953402687,0.130574994421],[-34277.5917881,378.247953966,-1195.76986753,-1997.16009474,718.721163966,1593.34158313,671.129148098,-1090.63855518,12.6644549751,-1129.53514154,-213.482199988,420.066505719,-1199.68613419,-764.109246605,-52.3621532984,0.463869156194,-162.241168532,306.627557563,63.3436606374,-516.424094314,-186.5300259,-224.911823248,-27.0444100335,-297.533014187,85.3580791603,69.9808974815,-137.109892664,140.484245017,-39.3326464358,96.5733802733,-142.720653906,10.5785150293,-132.647108849,84.4698237157,-46.4514578594,-1.9695021169,24.5228178042,28.5595874523,-34.1124119819,19.3791672372,-1.54773860169,-80.8590295707,-22.5564503521,-85.661483618,44.9427776599,-29.8229254444,-63.6286028108,-36.788600291,-0.621892597144,5.24684892088,6.01240726751,1.611000643,-6.34130479987,-4.98468551065,-11.9906884356,7.97354814766,-21.6244759724,7.39654099612,3.67317742592,-16.6487831794,-1.65586092538,12.1942060262,24.6461794363,0.463712795843,2.8043906986,-3.84547226607,-1.3608341365,0.279209131777,-0.207918379949,-0.547862830078,-0.233874553993,-1.60925438028,-0.250970009086,7.44333241628,-0.365687675041,6.38797800714,5.28622956979,6.84867929238,2.01522342061,-3.30904476655,0.557270778534,-1.06756520013,-0.0333811311347,-0.0729451822402,-0.438624923123,-1.7855512301,1.0736531895,-1.6948302709,0.0645634095695,0.712830138293,2.5679142266,1.91505853135,2.07015648763,2.44783984355,1.76489864606,1.71959346949,-0.578714491483,-0.201469896532,-0.250326877465,0.148915346229,-0.269934598831,-0.380928891738,0.155961106431,-0.296521529705,-0.374287093242,0.277894289652,0.0054729579467,0.751690382865,0.263247065186,0.736670547208,0.767110785266,1.17761722443,0.623772399776,0.518248220813,0.511824709264,-0.111154785141,-0.317052236025,-0.0831675754325,-0.10583259042,0.130798811265],[-34427.9858395,429.725178174,-1094.21901059,-1964.60339316,833.082254607,1617.4976167,646.513390182,-1122.28770805,28.6191200993,-1115.27907937,-252.297564166,427.133354176,-1205.25639445,-774.552729971,-74.3771679946,5.72548251134,-176.070737157,317.334037866,65.1506274811,-518.40689621,-192.579587289,-229.353637001,-20.8361960579,-285.552451863,82.9340732926,63.7673529812,-138.753745703,146.110710446,-36.619636965,99.3162422931,-138.33765085,21.5417197112,-128.570914509,84.6172100697,-57.1078044708,-2.49736239512,23.3391314469,28.5374321104,-33.5670656205,20.954783652,1.93344211928,-78.5449496194,-18.6447357608,-85.2235095846,45.5781876079,-34.3588499399,-66.09398594,-36.6422127003,-0.209461891693,5.2582162176,6.14719021028,1.8568582286,-6.00168698091,-3.93582360833,-11.502974327,8.60887603045,-21.5984514776,7.62183978555,2.6175622188,-17.6570935871,-2.16992067857,12.5824816751,24.5994577012,0.629267666289,2.98303868936,-3.75544009985,-1.44754328858,0.160899046572,-0.0011881658099,-0.661362326418,-0.123999550044,-1.57703060795,-0.155530046093,7.28909121307,-0.633071503399,6.15022071348,5.41717770826,6.93441708718,1.96469733531,-3.57675007241,0.613112809381,-0.997803277207,-0.0170915160612,-0.0995589923787,-0.488678113528,-1.79373302364,1.03833013156,-1.67740635609,0.0659844035456,0.723178737708,2.60892245935,1.8436495597,2.01437311258,2.4470977417,1.79102632558,1.69400567697,-0.702209638,-0.22972664459,-0.251515476499,0.153365927687,-0.258639170312,-0.386360777074,0.150476045093,-0.298048091919,-0.394119966247,0.266058353662,0.0100179913979,0.756933561835,0.26723193471,0.758770618608,0.75842270139,1.16784753435,0.606204393587,0.513996833607,0.513720501976,-0.150026921598,-0.322816072101,-0.0900589438574,-0.0958137598415,0.130762130632],[-34579.18473,492.183146605,-983.468486397,-1933.95074537,951.943016856,1644.18814966,615.998943456,-1146.43808105,43.0030196183,-1098.48427228,-286.980398877,433.16212683,-1204.13688097,-779.870519736,-100.358028823,10.9561823807,-190.433809784,331.629874421,66.6405042322,-518.842026409,-196.576491714,-235.964907179,-14.5975279405,-272.878543208,80.5426241936,57.2572794373,-139.666077143,152.081555757,-34.2479343993,102.522732505,-134.224447094,32.3340462386,-123.736658879,84.2669599858,-67.4605117127,-2.96372337122,22.0710341164,28.4166711208,-32.9605358007,22.2745887796,5.44319477066,-76.1252429803,-14.8457547059,-84.3759170742,45.909921755,-38.6861154577,-68.2888216789,-36.3893164127,0.246539518664,5.2290871045,6.19271525325,2.0723178005,-5.68205658017,-2.95392355849,-10.9631620092,9.15725237446,-21.4498159146,7.7786840485,1.62492935438,-18.5320500298,-2.65713929469,12.9317629465,24.4969296188,0.799749152335,3.15108540638,-3.68877770072,-1.55528350981,0.0443068602021,0.17724412592,-0.766034912197,-0.0362810496275,-1.50778306655,-0.0652298078841,7.1578869859,-0.87033165684,5.91727026246,5.52531918966,7.00184929876,1.90768821725,-3.83321950481,0.669009782288,-0.925519984771,-0.00249907219412,-0.133323316064,-0.536281674345,-1.80762466905,1.00330991724,-1.66309889041,0.0735166152385,0.734610020907,2.65551964169,1.77483065785,1.96081399014,2.43663965614,1.81236162799,1.66278830015,-0.825329586007,-0.255465311423,-0.25264489376,0.157936578477,-0.245387479121,-0.389896058042,0.143853574797,-0.299066337437,-0.413895712643,0.253320959319,0.0138088543688,0.761297287609,0.271300575573,0.78133408442,0.7487243827,1.15771564373,0.585588212454,0.508882917323,0.513326703283,-0.189286972506,-0.326345336335,-0.0961261198836,-0.0860497397995,0.1304918028],[-34729.8437067,559.90315634,-872.00455804,-1904.00681386,1072.82786289,1671.22977336,578.968711009,-1163.23892987,55.7893247111,-1079.2233837,-317.976428235,438.049731299,-1195.97395189,-779.973481169,-130.114381515,15.9917446748,-205.090838966,349.408539821,67.9428181577,-517.800172945,-198.364781217,-244.793809663,-8.55218138505,-259.618100744,78.1602602298,50.551025801,-139.839594044,158.43090059,-32.2569714293,106.17200607,-130.480904426,42.8241909048,-118.193109103,83.383938581,-77.4002132107,-3.37590960419,20.7264482011,28.2006854348,-32.2891043304,23.3027665086,8.9687137565,-73.6434947192,-11.1970865647,-83.1272068862,45.9328758223,-42.7713387999,-70.1874985882,-36.0462535813,0.742653195126,5.15283498309,6.14784481722,2.25537435467,-5.3934597091,-2.04318046358,-10.3814401665,9.61904118911,-21.1821706645,7.86995686989,0.704410974643,-19.2652599572,-3.12071954198,13.2339428475,24.3376227812,0.97447640379,3.30490629867,-3.64641651923,-1.68484420758,-0.0712832647695,0.327070729429,-0.86266023219,0.0314478271465,-1.40326821218,0.0217088413164,7.04959237755,-1.07469720133,5.68824992755,5.60678742159,7.04960646658,1.84530334306,-4.07592023486,0.724904911553,-0.851575289392,0.0101943097788,-0.174504744181,-0.581055066297,-1.82692647764,0.968456037401,-1.65084186142,0.0863801583896,0.748127271763,2.70710032632,1.70905788387,1.90943089915,2.41557124041,1.82826843603,1.62659411047,-0.946632363376,-0.278441352386,-0.253908746522,0.162684145004,-0.230155907918,-0.391498524457,0.13603190677,-0.299460572036,-0.433473540178,0.239625424551,0.0170512167569,0.76456006199,0.275699082199,0.804033748672,0.738110480311,1.1472380605,0.561819783805,0.502863571398,0.510706313704,-0.228463141536,-0.327477385321,-0.101420958277,-0.0766510736458,0.129999469898],[-34877.6674877,631.429180366,-767.687894973,-1873.66089737,1194.35233065,1695.79045549,536.469379024,-1173.42203955,66.9422214523,-1057.72196087,-346.334637023,442.219993906,-1180.84910628,-775.301486642,-163.280409215,20.6263754149,-219.881918166,370.294331066,69.1883411925,-515.481880528,-198.000068777,-255.819281805,-2.90521766984,-245.867750254,75.745925648,43.7112364264,-139.321135942,165.161603556,-30.7090266905,110.213012703,-127.187696736,52.9100977523,-112.011713687,81.9651417078,-86.8232138383,-3.7445003413,19.3094032188,27.8936537435,-31.5602475158,24.0088089766,12.5013160534,-71.1442884709,-7.72230765188,-81.4990301161,45.6588180674,-46.5845173807,-71.7789216495,-35.6327759762,1.27545356685,5.02386432571,6.01635908916,2.40327518103,-5.14647059946,-1.20257610769,-9.76966745843,9.99929220719,-20.8049481932,7.90401897925,-0.137770489276,-19.8554266122,-3.56611681629,13.4824659441,24.1216230194,1.15340830643,3.44178609633,-3.6275413263,-1.83649811571,-0.186500791795,0.449412604921,-0.953044524407,0.0825578610391,-1.26716384445,0.107855671005,6.96279196214,-1.24526187362,5.46143723897,5.6587866819,7.07708472758,1.7786344764,-4.30258821952,0.780951808039,-0.776630511242,0.021015397216,-0.223084172658,-0.622670664395,-1.85117125162,0.933461734941,-1.63950222893,0.103343732324,0.764714290275,2.7625745805,1.64650726019,1.85988388078,2.38337638878,1.83830756516,1.58611888721,-1.06468809656,-0.298542041812,-0.255575961864,0.167679659076,-0.212944294954,-0.391187649695,0.12699520966,-0.299109929788,-0.452796214896,0.224898573599,0.0199533258789,0.766449614448,0.280646608349,0.826432715805,0.726720589238,1.13636289148,0.534930310827,0.495926013646,0.505976648832,-0.267064003748,-0.326134528707,-0.106082870077,-0.0676977535374,0.129293826353],[-35020.5412455,707.10682251,-674.729364296,-1842.40248035,1315.51661645,1716.01118224,490.423021803,-1176.70003344,76.3003666237,-1034.51934375,-373.092631255,446.270646366,-1158.80402525,-766.851514565,-199.086904826,24.6332322229,-234.724292276,393.778114409,70.4613977854,-512.057153241,-195.74398643,-268.836925704,2.1648719077,-231.766493982,73.2597551687,36.7700876713,-138.188533123,172.245447895,-29.6473714247,114.549064392,-124.376934631,62.5009200296,-105.291458811,80.0262154455,-95.6179101861,-4.07819492175,17.822860605,27.4994016533,-30.7918326707,24.3749697465,16.0244286242,-68.6657819123,-4.43814701755,-79.5224101107,45.113103978,-50.0966524312,-73.066131891,-35.171918077,1.84195370288,4.83836038758,5.80455972347,2.51234026297,-4.95060732026,-0.428938098957,-9.13900073239,10.3049676663,-20.3299443841,7.89261009322,-0.896487491633,-20.3080365827,-3.99878177441,13.6732254596,23.8502663106,1.33693139348,3.56001167853,-3.63034863398,-2.01001461626,-0.301840302708,0.546186184527,-1.03935057188,0.120403452077,-1.10354389097,0.195788791865,6.89583350359,-1.38305767653,5.2350680581,5.67971873089,7.08410738248,1.70858734169,-4.51138879436,0.837340934826,-0.701152397135,0.0301303368199,-0.278750122236,-0.660912378611,-1.87976421339,0.898008895587,-1.62821939031,0.123178711322,0.785102140303,2.82069197859,1.5869635577,1.81174000266,2.33999867455,1.84221295251,1.54213709724,-1.17810566781,-0.315766211087,-0.257965946425,0.172966298791,-0.193781584686,-0.389020633707,0.116790794629,-0.297921166931,-0.471852990178,0.209083880994,0.0226779447149,0.766719789609,0.286260934138,0.848096449938,0.714673003513,1.12504056985,0.505086347035,0.488099170419,0.499289418421,-0.304592142191,-0.322361304728,-0.11029464825,-0.0592292977742,0.12839450216],[-35155.3296231,784.272225004,-597.170521543,-1809.1276012,1434.99913363,1730.58633026,442.724020821,-1173.05586796,84.02050739,-1010.22689081,-399.162941837,450.740305174,-1130.16842993,-755.868271025,-236.631149988,27.891731579,-249.462206679,419.333411303,71.7980130234,-507.720953881,-191.946694384,-283.594801848,6.51550490242,-217.54042719,70.6850243625,29.7855765093,-136.518206486,179.642596756,-29.0891736712,119.05635149,-122.072369939,71.5207607783,-98.1745555957,77.5965989792,-103.673450813,-4.38538138481,16.281089588,27.0275674153,-30.0038367149,24.4031173615,19.5142705944,-66.2475301974,-1.35422865836,-77.2427753295,44.3314653991,-53.2846533071,-74.0610941299,-34.6869688344,2.43694846269,4.59562831843,5.52137466527,2.58048186454,-4.81073898082,0.281392378325,-8.49989677562,10.5447176293,-19.7722580443,7.85049865902,-1.56901841389,-20.6322854366,-4.42297924551,13.8045953993,23.5256460327,1.52460820334,3.6584456148,-3.65242720966,-2.20418469639,-0.416794849738,0.619674593905,-1.12326736166,0.148209630933,-0.916862725716,0.288278450759,6.84645311029,-1.48997981731,5.00759304885,5.66920151644,7.07068999235,1.63587730797,-4.70092612136,0.894020331811,-0.625696492088,0.0376901330165,-0.34084581754,-0.695531228227,-1.91201728225,0.862145771415,-1.61645814978,0.144751028133,0.809877844747,2.8800190524,1.53015603782,1.76450834454,2.28591369742,1.83982348929,1.49549789128,-1.28559500153,-0.33022403111,-0.261391031861,0.178538743861,-0.172813211195,-0.385129375909,0.105516305758,-0.295846548028,-0.490635445478,0.192247443396,0.0253067292541,0.765211584156,0.292574402844,0.868600648295,0.702135508644,1.11319904148,0.472623625097,0.47944610471,0.490834780767,-0.340566908924,-0.316312487467,-0.114237044453,-0.0512503028278,0.127327653392],[-35278.8155184,855.494608935,-539.364145607,-1772.11386134,1550.66171682,1739.06861566,394.15743,-1162.73704568,90.5164842355,-985.428071508,-425.236874233,455.869590489,-1095.58206622,-743.647230728,-275.016787559,30.4049165053,-263.835127236,446.470534555,73.1465435658,-502.69977207,-186.995379583,-299.825150484,10.0382789129,-203.475637137,68.0382334457,22.8559016825,-134.382083186,187.300738544,-29.0128403385,123.59243315,-120.291008699,79.8961941054,-90.8388799848,74.7054650082,-110.901238318,-4.67288990944,14.7078862756,26.4954398321,-29.2154937957,24.1158684235,22.9405120385,-63.9311434755,1.52274319571,-74.717131662,43.354388822,-56.136545767,-74.7806678462,-34.1981993242,3.05283048596,4.29795957249,5.17816239637,2.60832180268,-4.72599981741,0.93116883965,-7.86213849945,10.7280370679,-19.1491453357,7.79362512572,-2.15649746346,-20.8397324538,-4.84094823971,13.8772334879,23.1503337142,1.71502728934,3.7365151585,-3.69089473617,-2.41672543174,-0.529944504172,0.672374373587,-1.20568792031,0.169041901379,-0.711732348705,0.387808521566,6.81166167931,-1.56840901697,4.77770405326,5.62806643915,7.03665979444,1.56106174825,-4.87045121849,0.950744627738,-0.55093297595,0.0437844021501,-0.408400078196,-0.726239756588,-1.9472306224,0.82626989834,-1.60394413886,0.167027625272,0.839458250569,2.93901366871,1.47590402591,1.71759992264,2.22201275719,1.83096907165,1.44709565891,-1.38607157629,-0.342109788372,-0.266054431424,0.184337805802,-0.150289783135,-0.379739143221,0.0932985347573,-0.292913584663,-0.509118257965,0.174576927361,0.027839546093,0.761874047959,0.299550713287,0.887558620276,0.689317618829,1.10072240695,0.438002119551,0.470039727044,0.480848721921,-0.374571024268,-0.308235209479,-0.118057763155,-0.043748239239,0.126118120864],[-35389.2760595,915.598829704,-502.243137014,-1730.30511072,1660.71566089,1742.14099005,344.926722508,-1146.3596897,95.9688400969,-960.693905735,-451.96052937,461.711832374,-1056.00486984,-731.39947011,-313.179189167,32.1977073223,-277.612681838,474.637292942,74.391568567,-497.230204386,-181.250071913,-317.154389735,12.6732947912,-189.825397819,65.3534166313,16.0684772916,-131.870213061,195.143440192,-29.3567894266,128.019981162,-119.024434102,87.565338298,-83.4592536324,71.3737143902,-117.251886009,-4.94360769826,13.1234674551,25.9233662013,-28.4487465069,23.5503428179,26.2740056612,-61.755705612,4.19355217808,-72.0035072622,42.2225363731,-58.6559833752,-75.2468293556,-33.7200902645,3.68255319652,3.94919866146,4.78857531195,2.59748103771,-4.69193856563,1.52322215572,-7.23561710568,10.8657350813,-18.4780591702,7.73655784009,-2.6648248683,-20.9446951337,-5.25192291401,13.8936149635,22.7270289522,1.90680881744,3.79441075123,-3.7420971433,-2.64473604493,-0.640006581258,0.706820981444,-1.28748995179,0.185847448118,-0.492989107728,0.496039248614,6.7877583322,-1.62141152548,4.54470884567,5.55827994343,6.98171562958,1.48470070719,-5.01999739467,1.00725058753,-0.477385065899,0.0485080601587,-0.480249208348,-0.752945690324,-1.9847744829,0.790776848759,-1.59052742526,0.188968132574,0.873953112245,2.99619405131,1.42400255881,1.67048961437,2.14951903687,1.81554187716,1.39786362168,-1.47879882581,-0.351707983026,-0.272015454269,0.190256481712,-0.126469535874,-0.373144316451,0.080284163221,-0.289218462059,-0.527282970095,0.156313594492,0.0302069991248,0.756704770016,0.30708089482,0.904673973535,0.67643566211,1.08747696079,0.401772060326,0.459956828572,0.469617303815,-0.406324107706,-0.29846548667,-0.121854226064,-0.0366892289482,0.124786126488],[-35487.3606318,960.114990395,-485.114478293,-1683.87389891,1763.54808436,1741.0270817,294.984756613,-1124.57426483,100.273509948,-936.614884072,-479.879484687,468.217179538,-1012.59548954,-719.952171069,-350.051120733,33.315002087,-290.600759256,503.260803061,75.3848430753,-491.54231611,-174.956117788,-335.178467058,14.3691109576,-176.817345265,62.6806426361,9.49540360812,-129.079412939,203.070955778,-30.0335307765,132.224649209,-118.253054392,94.4693157069,-76.2052867793,67.6211131046,-122.709041686,-5.19530602517,11.5428561381,25.3329845054,-27.7284915971,22.7550004758,29.4862698234,-59.7569136821,6.66330939771,-69.15976004,40.9768745165,-60.8577411223,-75.4835855243,-33.2614847229,4.31979467252,3.55388097981,4.36736060669,2.54997635972,-4.70165586725,2.05943700989,-6.62990552318,10.9689175466,-17.7755693294,7.69234942859,-3.10316519214,-20.9621010255,-5.65266655227,13.857542499,22.2579508652,2.09867453625,3.83290220433,-3.80195710407,-2.88488919489,-0.746061035047,0.725162751506,-1.36953044971,0.201375736756,-0.265387566844,0.613765460581,6.77065516348,-1.65216441748,4.30852191025,5.462594703,6.90534407589,1.40740704823,-5.1502045691,1.06325573917,-0.405415779755,0.051932306372,-0.555097111137,-0.775790387616,-2.02408055898,0.756006294057,-1.57617268426,0.209605978367,0.913087517267,3.05016800606,1.37428991591,1.62272247316,2.06982691317,1.79343034728,1.34874642389,-1.56332844271,-0.359352818618,-0.279151741832,0.196153045934,-0.101602975299,-0.365679259622,0.0666364619461,-0.284913556222,-0.545101788761,0.13772058834,0.0322852167343,0.749736524868,0.314974288534,0.919732537314,0.663685212249,1.07331245562,0.364508733774,0.449260201112,0.457467346918,-0.435642924919,-0.28738841714,-0.125642847299,-0.030015711013,0.123330921079],[-35574.8519699,985.115822444,-484.445215435,-1634.26269823,1858.04967673,1737.47959671,244.674246304,-1098.16202738,103.030904113,-913.664896284,-509.310855579,475.570540162,-966.518754939,-709.376094996,-384.606959084,33.781991793,-302.631764985,531.783739878,76.0177161185,-485.783877745,-168.161897601,-353.461631413,15.0582217833,-164.611808772,60.0723536799,3.17903835713,-126.107050563,210.96233892,-30.9268731981,136.138315154,-117.936768158,100.556321276,-69.2196942158,63.4685561693,-127.282233289,-5.42186867352,9.9719641006,24.7434994639,-27.0855912803,21.7881926383,32.5515143466,-57.9610351999,8.94010476248,-66.2340943514,39.6554386632,-62.7579483851,-75.5124531654,-32.8232917897,4.95978556739,3.11571847145,3.92938373552,2.46631488859,-4.74688405447,2.5395940898,-6.05294204201,11.0483090229,-17.0546762328,7.67160872322,-3.48084382691,-20.9058119313,-6.03831424912,13.7732213655,21.7441035198,2.28980402084,3.85307345733,-3.86629050637,-3.13389165472,-0.847914366716,0.728487114081,-1.45267079489,0.218318339583,-0.0332263408638,0.741113564824,6.75666012104,-1.66358015322,4.06975589554,5.34428630172,6.80684750347,1.32995232639,-5.26194692475,1.11854510637,-0.335165139397,0.0540812479528,-0.631593616612,-0.795285873852,-2.06472267858,0.722176190709,-1.56088831368,0.228072757478,0.956276697608,3.09982025753,1.32664177023,1.57404453941,1.98433081601,1.76451398021,1.30058998368,-1.63939787998,-0.36542514117,-0.287133140192,0.201889222158,-0.0758819609198,-0.357690268063,0.0525519512742,-0.280203608153,-0.562545099209,0.119036743321,0.0339007122228,0.74100582402,0.32297705924,0.932621292509,0.651216891725,1.05810883748,0.326752450806,0.43800376318,0.444752956558,-0.462408473369,-0.275380563175,-0.129358145747,-0.0236512095197,0.121721165299],[-35652.7614712,990.183613961,-493.963401713,-1582.96134563,1944.299712,1733.94571927,195.951191183,-1068.7456939,103.848932325,-892.090700004,-540.230924999,484.512201502,-919.071357953,-699.034640693,-415.727492824,33.5970111923,-313.547394408,559.670336481,76.2850378456,-479.967876295,-160.679661028,-371.438827712,14.7157192859,-153.176242134,57.5603884949,-2.87522715646,-123.042161697,218.667134436,-31.8604788582,139.753320143,-117.985798651,105.793415812,-62.556427618,58.9288904453,-131.000103598,-5.62234181469,8.40500491088,24.1716218753,-26.5625469824,20.7258831245,35.449931205,-56.3773479995,11.0365072606,-63.2479132189,38.2903554033,-64.3721445644,-75.3552484331,-32.4024983597,5.59777640102,2.63681583123,3.48909911374,2.34363611442,-4.8179272269,2.9619524686,-5.5094858118,11.1146301856,-16.3219038053,7.68105127492,-3.80520638444,-20.7908578723,-6.40347352789,13.6449933266,21.1859574883,2.48017918946,3.85610187333,-3.93113334383,-3.38858908562,-0.94638118,0.716546910794,-1.5376383613,0.239258422857,0.199457849149,0.877209675814,6.74313129487,-1.65912246459,3.82939626687,5.20683204454,6.68540103455,1.25352057678,-5.35626934279,1.17317988919,-0.266590955616,0.0548710259615,-0.70826782712,-0.812518732394,-2.1065188272,0.689265879482,-1.54473059182,0.243394238365,1.00262436628,3.14446477885,1.28077791679,1.52441427288,1.89436447618,1.7287141975,1.25435685399,-1.70687691983,-0.370293908905,-0.295469624551,0.207391211984,-0.0494246931757,-0.349534610909,0.0382966436856,-0.275393478993,-0.579608134999,0.100423566856,0.034844257257,0.730491860917,0.330793044414,0.943344223181,0.639109941497,1.0418394874,0.288982858501,0.426256242798,0.431910494853,-0.48656622658,-0.262797085478,-0.132872021605,-0.0175308889195,0.119925869046],[-35720.7797039,979.090439206,-500.176970254,-1531.57404199,2023.87598675,1734.31466627,151.385559256,-1037.66324498,102.267780066,-871.864440239,-572.258670496,496.00704271,-871.265513762,-688.072270429,-442.354549392,32.720515789,-323.22390428,586.372936708,76.2694187708,-473.934243725,-152.266308862,-388.486139085,13.3461626641,-142.367964479,55.1546307359,-8.69788521989,-119.992867244,226.030592998,-32.6205018851,143.094879778,-118.273431703,110.158805089,-56.2071741606,54.0205380429,-133.916595251,-5.80023028693,6.82668446688,23.6271964988,-26.2049065223,19.6498664006,38.1706566479,-54.9969302491,12.9640064002,-60.2038198228,36.9121059223,-65.7186337022,-75.0319620686,-31.9918431062,6.22917078632,2.1182357225,3.06101049742,2.17789793137,-4.90564334507,3.32646881351,-4.99991037486,11.17752952,-15.5781127708,7.72449364871,-4.08217643764,-20.6316345669,-6.74217915072,13.4770798388,20.5844349987,2.6703932598,3.8433403243,-3.99225271555,-3.6458439109,-1.04311152069,0.688983929335,-1.62463170565,0.266744173933,0.429508411884,1.02043805261,6.72847817291,-1.64223562627,3.58902594752,5.05356607014,6.54051840129,1.17957311071,-5.43416177343,1.22743582089,-0.199514662781,0.0542864536422,-0.783661429415,-0.828908401916,-2.14934370511,0.657076215623,-1.52766867617,0.254760623122,1.05095517955,3.18387014757,1.23637191399,1.47405746144,1.80111194763,1.68611791936,1.21099680835,-1.76572167423,-0.374319577473,-0.303594939598,0.212635342589,-0.0223057887184,-0.341555983778,0.0241453235224,-0.27081803391,-0.5963201967,0.0819401328386,0.0349276408964,0.718175464738,0.338074352864,0.952035078339,0.627378848491,1.02458062734,0.251595734288,0.414124887177,0.419393826089,-0.508121282218,-0.249970495317,-0.136025019523,-0.0116193915089,0.117908605404],[-35776.7940543,954.373746471,-490.835742779,-1481.23269181,2098.64049455,1741.98364775,111.705491996,-1006.8314218,97.9994653193,-852.572425285,-604.847170505,510.552497952,-824.164211553,-675.760594835,-463.840679439,31.1323201007,-331.452824548,611.39747992,76.0969558021,-467.514803978,-142.745379739,-404.124939255,10.9618632201,-132.104422945,52.8483068441,-14.3063128234,-117.067550272,232.938199033,-33.0067999822,146.191605589,-118.703839088,113.627707654,-50.1796254036,48.7512651704,-136.131072996,-5.96783762643,5.22068809126,23.1137970642,-26.0421979848,18.6348797435,40.7107649444,-53.8062277971,14.7263171095,-57.1094530623,35.5401535547,-66.8316136082,-74.5587324674,-31.5861689509,6.84788787052,1.55900852331,2.658716424,1.96761884037,-5.00164495354,3.63600229486,-4.52157511905,11.2443019136,-14.8231894791,7.80092847296,-4.32127599626,-20.4398913627,-7.05152201247,13.2735999744,19.9398227881,2.86102638823,3.81529925737,-4.04550965426,-3.90255730927,-1.13985139395,0.646290421086,-1.71299668615,0.303383812713,0.65455236384,1.16854284572,6.71055023312,-1.61571813968,3.34929076817,4.88772580618,6.37126473466,1.10975060996,-5.49661807073,1.28172701236,-0.133924838284,0.0524241032497,-0.856623413573,-0.845880002753,-2.19289008507,0.625391638407,-1.50935539503,0.261689465545,1.10006828118,3.2178775328,1.19314865163,1.4229707005,1.70569355902,1.63657067471,1.1713783398,-1.8161145046,-0.37776725831,-0.310990348322,0.217677108555,0.00541274027657,-0.33404661961,0.0102782699882,-0.266777212388,-0.612707574575,0.0635703194891,0.0340585884398,0.704086492907,0.344520914855,0.9588787914,0.615974427331,1.00637438572,0.214928002059,0.401609529034,0.407628598888,-0.527213847956,-0.237152007019,-0.138672230602,-0.00590864883122,0.115620620855],[-35817.296334,919.540195019,-463.497106692,-1432.94824851,2170.47180836,1757.63315063,76.3586334026,-979.899958932,90.921169281,-833.741020685,-637.713895842,528.259726349,-779.378013837,-661.555224132,-480.154897242,28.874875182,-338.051055707,634.261038637,75.9095810137,-460.754944558,-132.013409844,-418.169853748,7.63066491024,-122.371107309,50.6457361529,-19.7096944843,-114.370652311,239.291250961,-32.8974632595,149.062616708,-119.274854514,116.189677048,-44.5218775161,43.1283420693,-137.784121499,-6.13849565775,3.57710958276,22.6314021525,-26.094547797,17.7348074725,43.0697920574,-52.80749393,16.320662106,-53.9925300282,34.1858643665,-67.7609491041,-73.9490549349,-31.1863981285,7.44675281315,0.960235913639,2.29587600069,1.71311053695,-5.09906559632,3.89386054489,-4.07421407576,11.3189086472,-14.0622809926,7.90572999381,-4.53655511021,-20.2245455689,-7.33346474508,13.0380883116,19.2524756505,3.05208780082,3.77276090079,-4.08651830751,-4.15519884367,-1.23761863211,0.589336887843,-1.80195464982,0.351194705768,0.871115030846,1.31876346445,6.6855397888,-1.5814962528,3.10916227773,4.71239455198,6.17653751065,1.04587037099,-5.544447774,1.33632959639,-0.0698896369007,0.0495777438565,-0.926004963889,-0.864416788044,-2.23662977351,0.593986503498,-1.48928784398,0.263567016092,1.14877020118,3.24583827583,1.15095903103,1.370627184,1.60919647941,1.57963654711,1.13624832775,-1.85835780402,-0.380752039825,-0.317269856281,0.222573306137,0.0336148380722,-0.327236628118,-0.00313077229525,-0.263439259528,-0.628723780611,0.045294041525,0.0322205583825,0.688226937727,0.349889668426,0.963891629163,0.60478716993,0.987096231216,0.17926635796,0.388555857084,0.396967970705,-0.544073981017,-0.224485183148,-0.140712443426,-0.000432340402557,0.112996875002],[-35840.1297606,873.789629776,-420.981824333,-1387.47528783,2239.54197421,1780.63863322,42.317256649,-960.855063616,81.3321021991,-815.185140271,-670.298169333,548.546106252,-738.318867164,-645.228226864,-491.538391546,26.1581149418,-342.875230684,654.679449156,75.7642586353,-453.718599106,-120.163299107,-430.609342447,3.48907835532,-113.173021798,48.5791197256,-24.8772077458,-111.986733921,245.00069693,-32.2090704083,151.694000062,-120.031223632,117.865344373,-39.3028479083,37.1698254992,-139.045545416,-6.32496833685,1.90477670079,22.1749469486,-26.3723898077,16.9913359798,45.2427289565,-52.0032839953,17.7346235957,-50.890039023,32.8545674962,-68.5583100115,-73.2164955486,-30.797614965,8.0161447008,0.327856442285,1.98340797985,1.41806605386,-5.19177117225,4.10209581435,-3.65528097668,11.3998382221,-13.3013944529,8.03171140323,-4.74127314052,-19.992066155,-7.5943699899,12.7732123539,18.5239063347,3.24232099424,3.71711241312,-4.11145834621,-4.39929488761,-1.33682292198,0.519386371388,-1.88954479105,0.410940324964,1.07640411398,1.4679627714,6.65011594519,-1.54042599343,2.86705245459,4.53072335577,5.9559512137,0.990148214897,-5.57806598016,1.39123618495,-0.00765973546763,0.0461234299345,-0.99044257458,-0.885107034345,-2.27974256461,0.562788165506,-1.46701418416,0.26011619594,1.19585688537,3.26717212481,1.1098508829,1.31641914579,1.51271825551,1.51484712991,1.10618938348,-1.89270663895,-0.383251790488,-0.322252167237,0.227346830228,0.0620563991522,-0.321293059417,-0.0158766314233,-0.260894025117,-0.644187628991,0.0270520666172,0.0294701639518,0.670668326028,0.353980274966,0.967047597909,0.593656392523,0.96662627,0.144866263358,0.374759832193,0.387680876711,-0.55891980365,-0.211983297239,-0.14210712799,0.0047278832297,0.109954557316],[-35844.6665469,816.967958538,-372.843967401,-1346.34745157,2305.32826853,1808.83911524,5.29804535337,-953.88320378,69.5207148743,-797.129128522,-701.668104541,570.432671073,-702.130281961,-626.894682528,-498.163354772,23.2637878461,-345.932701848,672.604061988,75.7190798117,-446.422366193,-107.414247799,-441.49301941,-1.16661701015,-104.518112978,46.6951846337,-29.7789277995,-109.964913717,249.993375452,-30.8907099747,154.065546823,-121.040234708,118.732460025,-34.5927255622,30.9119832596,-140.106423704,-6.53439903048,0.222305694816,21.7353674113,-26.8824437826,16.4338275486,47.2236393772,-51.3923642095,18.9546573858,-47.843902257,31.5494319231,-69.2755967009,-72.3769397398,-30.4330302274,8.54633840952,-0.328644025906,1.7285124769,1.08571680277,-5.27500095456,4.26154099668,-3.25959652295,11.4815139293,-12.5461378169,8.17026271787,-4.94574172889,-19.7463338134,-7.84492222455,12.4810503996,17.7578999683,3.42995925689,3.65037718421,-4.11731136753,-4.63054334591,-1.4372229072,0.437266957516,-1.97265068231,0.482239363175,1.26864389414,1.61326365623,6.60233743123,-1.49207596916,2.62102805101,4.34590590872,5.71009625892,0.945338013002,-5.59728984389,1.44625521874,0.052522417133,0.0424341616078,-1.04855083562,-0.908090085521,-2.32141540198,0.53187255914,-1.44218687317,0.251514215518,1.24033713335,3.28155265112,1.07021842388,1.25984351921,1.41750811539,1.44181515281,1.08174286188,-1.91929298552,-0.385033136098,-0.326095547471,0.231983153608,0.0904413584529,-0.316312090338,-0.0277213051946,-0.259141326656,-0.658866885864,0.00874466729447,0.0258990966904,0.651552600334,0.356692997133,0.968314661541,0.582433597907,0.944927757809,0.112017361253,0.359987960737,0.379950116494,-0.571929960278,-0.199517302265,-0.142910749556,0.0094259094088,0.106414346275],[-35832.158468,752.011666134,-330.118866388,-1311.14183281,2366.94735014,1839.73489272,-37.6519474945,-961.209626309,55.7540797765,-780.307246818,-730.41556802,593.105226982,-671.180174523,-606.683017774,-500.14806864,20.4729089529,-347.438825829,688.292841898,75.8462213832,-438.69942441,-93.9797332649,-450.812606965,-5.92688126446,-96.4261840987,45.0313968194,-34.4194795587,-108.264200205,254.190575513,-28.8962254722,156.169027425,-122.334213998,118.928756291,-30.4487057654,24.3890713939,-141.121602056,-6.76881241182,-1.44830239268,21.3092310954,-27.6325617273,16.0842545043,49.0077264999,-50.955137276,19.9814210745,-44.8893883817,30.2701075031,-69.9481882715,-71.4411416225,-30.1102900262,9.02974909368,-0.996855381375,1.53294407802,0.716832426969,-5.34355170338,4.37194847241,-2.87743683372,11.5584003194,-11.7979354739,8.31258644048,-5.15416692149,-19.4874118475,-8.09829506773,12.1649070005,16.9589018657,3.61335290805,3.57513292942,-4.10296716218,-4.84581473154,-1.53748600129,0.342884299402,-2.04715750559,0.563766447867,1.44775039192,1.75310938907,6.54216156382,-1.43480496598,2.36893808464,4.16186724472,5.44030177919,0.913948993588,-5.60170952078,1.50107278976,0.110530278536,0.038638370151,-1.09918749571,-0.933079872586,-2.36108854322,0.501566419777,-1.41469699224,0.238539196756,1.28179356302,3.28918355962,1.03278269662,1.20064401717,1.3251704306,1.36048578211,1.06325369547,-1.93812951155,-0.385831068484,-0.329114073858,0.236464179151,0.118476994964,-0.312305013574,-0.0384062446327,-0.258107657583,-0.672585369591,-0.00969298028748,0.0215802080441,0.631127806641,0.358089985183,0.967772584457,0.571063460258,0.922126695208,0.08110800464,0.344069495215,0.37387358448,-0.583190494291,-0.186895102182,-0.143224233984,0.0135121710694,0.102348475553],[-35806.4588309,679.132960652,-290.42678973,-1280.20370639,2422.73642359,1871.55930612,-83.8809324654,-981.657618266,40.7923704303,-765.710505941,-755.795777188,616.38466823,-644.938180443,-584.388794581,-498.971170713,17.905294597,-347.707603027,702.066257538,75.9595621355,-430.306867064,-80.0455816417,-458.708662407,-10.6885243394,-89.0936228655,43.5708148604,-38.8252404733,-106.72606536,257.452647544,-26.2088973225,157.976659651,-123.856026748,118.564117284,-26.9557965027,17.5854519678,-142.102023282,-7.02313029152,-3.08299195672,20.918171865,-28.6205083911,15.954574165,50.5829903468,-50.6401137555,20.8356550226,-42.0557519131,29.001550853,-70.5764361157,-70.3865153372,-29.8366669098,9.46432677763,-1.66263518151,1.39250626367,0.317493038144,-5.39172426165,4.43215904948,-2.49837548693,11.6304896906,-11.0542118618,8.44949932607,-5.36906868971,-19.2072012326,-8.3663969213,11.8331931412,16.1237649771,3.79074720195,3.49434301898,-4.07098995354,-5.04288629651,-1.63525372424,0.236195032884,-2.1103953981,0.653091488763,1.61497155305,1.88727626473,6.46911168863,-1.36725575354,2.10822013255,3.98405087255,5.14652421051,0.895606456884,-5.59190365781,1.55496669957,0.166246547484,0.034544760334,-1.14194445658,-0.959460906721,-2.39830831396,0.472326069889,-1.38518389775,0.22226534715,1.32030309311,3.29057696393,0.997814343355,1.13844336488,1.23750526522,1.27119778383,1.05022829409,-1.94940084648,-0.385741198799,-0.331030972893,0.240750209065,0.145848684133,-0.309084069712,-0.047742129083,-0.257666117345,-0.685215657363,-0.0281560434545,0.0165406757375,0.609711486258,0.358322229377,0.965702873895,0.559524985317,0.898421857228,0.0525145993454,0.327039397492,0.369479265585,-0.592693928625,-0.174005756461,-0.142996296696,0.0170175948327,0.0978743935474],[-35772.6035277,601.946494374,-249.330293904,-1252.78410499,2471.87616253,1903.36107992,-129.912095362,-1011.86144609,25.0766762178,-754.317427655,-777.034832419,640.403930674,-621.996450055,-559.817792908,-495.781250336,15.5373779788,-347.131031179,714.34082945,75.8952178591,-420.881777403,-65.8197266387,-465.192456474,-15.3820646559,-82.726605001,42.2771319669,-43.058120012,-105.178505883,259.670228129,-22.8315160598,159.447148603,-125.491769169,117.746890126,-24.1820722172,10.4767222933,-143.018536943,-7.29223608068,-4.66455669048,20.5773472639,-29.8400373322,16.0429083864,51.9381531957,-50.3842114223,21.5359022254,-39.3591724491,27.7196093178,-71.1443697142,-69.1888164675,-29.6126223549,9.85018891506,-2.31463236834,1.29903317848,-0.106588458022,-5.41667707182,4.44132629263,-2.11092289492,11.6961775974,-10.3084226711,8.57024210516,-5.58792082085,-18.8971881479,-8.65897152833,11.4943173514,15.2489610634,3.96046187678,3.41039364443,-4.02524159235,-5.22077927377,-1.7283142069,0.11765769093,-2.16017814172,0.747436075522,1.77309116689,2.01569660309,6.38409863613,-1.28857250547,1.83711731324,3.81751373685,4.82910573253,0.889310236731,-5.5684384422,1.60727500174,0.219475317561,0.0299917618039,-1.17683449885,-0.986576711576,-2.43257480453,0.444629667717,-1.35429435023,0.204038284425,1.35612741389,3.28656644831,0.965318871297,1.07311138268,1.15606594514,1.17448963869,1.04184569637,-1.95328872581,-0.384968516048,-0.331584211664,0.24487601184,0.172275641678,-0.306396242649,-0.0556103803346,-0.2576590816,-0.696643154307,-0.0465735047155,0.010870837027,0.587654351214,0.357574440747,0.96243964674,0.547773707169,0.874068724999,0.0265164610103,0.308983653841,0.366676721849,-0.600378374297,-0.160765182785,-0.142172885012,0.0199819930749,0.0931487635603],[-35734.6750816,528.176151752,-200.375293583,-1229.40109732,2514.83518446,1935.44215536,-172.946119254,-1047.5260786,8.66411646298,-746.854880232,-793.318065615,665.345443968,-600.480116365,-532.94196029,-490.909142951,13.247256549,-346.077037367,725.539713287,75.5667480436,-409.980483025,-51.5412390514,-470.071545639,-19.9502743628,-77.4474905591,41.1026232856,-47.1908846301,-103.482101276,260.786659862,-18.7696018777,160.523469583,-127.089956781,116.563938216,-22.1410444182,3.0379884781,-143.833627817,-7.57686920947,-6.18213944327,20.2883048024,-31.280219575,16.3380851287,53.0635601569,-50.1215897719,22.088594801,-36.7955360221,26.3946719283,-71.6299721611,-67.8312825166,-29.4350512682,10.1877799772,-2.94596410153,1.2424036416,-0.550260979483,-5.41875268133,4.39921768345,-1.70305787257,11.750669592,-9.54933851608,8.66255067515,-5.80354520203,-18.5503872911,-8.9831771452,11.1544749243,14.3321743749,4.12090967577,3.32440669788,-3.96981854242,-5.37939003625,-1.81528133509,-0.0115225827228,-2.19478643224,0.844188209131,1.92619507444,2.13800256461,6.28960075024,-1.19852244044,1.55498743018,3.6658977608,4.48899468125,0.894211149377,-5.53162946004,1.6575060809,0.269817648091,0.0249551171934,-1.20412645082,-1.01398435905,-2.46324217892,0.418814771353,-1.32235410174,0.18528535501,1.38954406094,3.27830381307,0.935044145111,1.004848606,1.08194026208,1.07106373234,1.03726491682,-1.94989334325,-0.383692111112,-0.330693708952,0.248970424845,0.197519997321,-0.303983243888,-0.0619720821271,-0.257937824168,-0.70673813365,-0.0649771408307,0.00477530444934,0.565274118231,0.356030266257,0.958351047282,0.535702776494,0.849367508473,0.00324290814243,0.290009738914,0.36529164095,-0.606136320701,-0.147110604579,-0.14071637811,0.0224134960121,0.0883315556032],[-35693.553627,463.902222604,-141.706659516,-1210.73041103,2552.72417913,1967.13713613,-211.032166863,-1086.1723382,-8.32825740474,-743.583045923,-804.309623155,691.28250797,-579.191067963,-503.828531626,-484.514059596,10.9324299134,-344.750749041,735.984141439,74.9411395969,-397.369291369,-37.4378404616,-473.24660837,-24.4197353995,-73.3818790723,40.0057958296,-51.2628255587,-101.530317794,260.805180482,-14.0771865452,161.143892564,-128.555127328,115.056918945,-20.8380819524,-4.75198712594,-144.517278466,-7.88166085892,-7.62265006346,20.046576264,-32.9187641044,16.8209334241,53.9500606384,-49.8064155926,22.4865046907,-34.3628069424,24.9953305724,-72.0209757481,-66.3046113981,-29.3024645583,10.4766189201,-3.55312617784,1.21348112665,-1.00685628325,-5.39951402209,4.3065319807,-1.26715753051,11.7876008353,-8.76921048217,8.71377928996,-6.01109119118,-18.160516709,-9.34572585996,10.8177970842,13.3711808182,4.27013322294,3.23635066195,-3.90831543419,-5.51885330465,-1.89478598526,-0.149310371907,-2.21350602511,0.941358796809,2.07749745318,2.25370198977,6.1874512418,-1.09705369834,1.26115362289,3.53125085296,4.12694155516,0.909373277474,-5.48196630831,1.70514488583,0.316655293958,0.0196090421237,-1.22426397515,-1.04125210991,-2.48946888894,0.395170840438,-1.28931003432,0.167101874525,1.42089676314,3.26659253351,0.906660517168,0.933628460881,1.01575255393,0.96146724062,1.03566342416,-1.93944845464,-0.382013478734,-0.32844595378,0.253194041787,0.221355423485,-0.30159531609,-0.06686656475,-0.258327337218,-0.715337881017,-0.0833903721645,-0.00141875225168,0.542804840257,0.353902069337,0.953705008648,0.523221183859,0.824488688081,-0.0172844860579,0.270125995591,0.365102848807,-0.60990785982,-0.13301004358,-0.138597384879,0.0243092276004,0.0835666775766],[-35647.5678254,409.720699479,-75.0251191219,-1197.15271493,2586.10242507,1997.44069863,-243.64363817,-1125.99854322,-25.5985794014,-744.372866051,-809.813250748,718.023851844,-557.493226916,-472.490649813,-476.727182217,8.6029122379,-343.120639569,745.942324736,74.0435037518,-383.015680153,-23.6666393144,-474.729186025,-28.9273207871,-70.6699702444,38.9746563021,-55.2486602033,-99.2335929876,259.791697342,-8.84480226761,161.255971722,-129.8625757,113.204935895,-20.2869407096,-12.9229307024,-145.038775433,-8.2111162886,-8.96529231946,19.845162838,-34.7154182802,17.4680196904,54.5880716064,-49.4169684665,22.7075670006,-32.0667100347,23.4888236531,-72.3123072546,-64.605767159,-29.2148689676,10.714538088,-4.13431614457,1.20370277647,-1.46704199301,-5.36006941903,4.16483754871,-0.80063135425,11.7999665147,-7.96453702427,8.71079789229,-6.20769369553,-17.7218404129,-9.75175441247,10.4863060153,12.3637503213,4.40537551819,3.14512937615,-3.84377929266,-5.63928058944,-1.96499324457,-0.292928931616,-2.21624623081,1.03766290123,2.2290940542,2.36227680958,6.07887661821,-0.983914242039,0.955186531727,3.41418077244,3.74312160534,0.93357189446,-5.42046235617,1.74947700422,0.359113130898,0.0142900685949,-1.2378345979,-1.06780883298,-2.51022602626,0.374096860927,-1.25469753361,0.150296882245,1.45067526895,3.25185866888,0.879959034974,0.859235197694,0.957717932077,0.846063479006,1.03620897508,-1.92234094299,-0.379935343563,-0.325031714528,0.257690598153,0.243529451257,-0.298988567294,-0.0704099939702,-0.258618807713,-0.722232354245,-0.101733175619,-0.0072708573304,0.520421267533,0.351475312807,0.94866347218,0.510313128258,0.799485729082,-0.0351254921831,0.249234845502,0.36583918424,-0.611687514938,-0.118486378132,-0.135776911528,0.0256656247576,0.0789676819985],[-35593.8733331,363.75511845,-1.16658679977,-1188.7304688,2615.19367298,2026.46599958,-270.895389707,-1164.61183592,-42.9398922834,-748.775057697,-809.515874339,745.343427034,-534.857719905,-438.781950941,-467.48833357,6.33411613783,-340.996782852,755.663428613,73.0021988391,-366.954948717,-10.2387201966,-474.523021321,-33.653829916,-69.4356009793,38.0179929175,-59.0823149854,-96.5177253447,257.861841977,-3.16214713416,160.831884073,-131.026306546,110.941073863,-20.4896593742,-21.5092366278,-145.349914777,-8.56800850793,-10.1881847481,19.6767650224,-36.6197568768,18.2523491653,54.9712990505,-48.9486727322,22.7207949911,-29.9113322971,21.8463092117,-72.4977292867,-62.7329594477,-29.1699353199,10.8991021221,-4.68916950408,1.20464517527,-1.92150356422,-5.30069247516,3.97619608455,-0.30464292849,11.7813939383,-7.13321521512,8.64156596769,-6.38891964201,-17.2279207368,-10.2023734846,10.1602052175,11.3084216306,4.52345195753,3.04874547951,-3.77866279926,-5.74135341678,-2.02378991174,-0.439390640518,-2.20322304857,1.13245842161,2.38243351718,2.46367767498,5.96536668968,-0.858287603346,0.637641561263,3.31405275723,3.33743546277,0.965371108005,-5.34834553302,1.78967683602,0.396202201617,0.00939431823286,-1.24558354507,-1.0929225002,-2.52457574973,0.356128027992,-1.21768863586,0.135462049844,1.47958778659,3.23438256163,0.854945632702,0.781557348381,0.907724065288,0.725270728488,1.0381352537,-1.89888707659,-0.377370162192,-0.320688275248,0.262577239722,0.263810962541,-0.295945603823,-0.0727781076788,-0.258571741973,-0.727223223008,-0.119811688748,-0.0122972146699,0.498249523583,0.349078664155,0.943314773341,0.497061852354,0.774370518723,-0.0503983160301,0.227224016704,0.367198531785,-0.611435339139,-0.103624572869,-0.132179179203,0.0264678448657,0.0746411485019],[-35529.2908281,322.278421413,77.0412021452,-1185.17283124,2639.9323326,2054.48381492,-292.915402741,-1200.01723042,-60.2703205795,-756.060252324,-803.30295663,773.204159591,-511.09939535,-402.340296717,-456.818022554,4.24717284795,-338.089628337,765.356749828,72.0331210331,-349.384683143,2.98582020704,-472.732960205,-38.8376559765,-69.7781355894,37.1590601898,-62.6752517514,-93.3253441941,255.166387721,2.86433090812,159.871513259,-132.119520015,108.163418806,-21.4485604362,-30.5294271258,-145.393816223,-8.95329934197,-11.2719403786,19.5375784044,-38.5774966737,19.1409355873,55.1004553103,-48.4188546562,22.4898083289,-27.9053098783,20.0480783743,-72.5729507851,-60.6854729006,-29.1641357856,11.0286452367,-5.21846991889,1.20911219574,-2.36184609168,-5.220369827,3.74297147508,0.214490877524,11.7268448996,-6.27757630177,8.496718354,-6.55059575171,-16.6716381549,-10.6967006429,9.83788310868,10.2042537834,4.62104086603,2.94470793768,-3.71461826745,-5.82656260779,-2.06873625285,-0.585748523615,-2.17546682971,1.22577561853,2.53754422477,2.55846502017,5.84787954446,-0.718698876915,0.309365619263,3.22925654914,2.90964523162,1.00321458714,-5.26700923883,1.82489262945,0.42697104687,0.00534507373742,-1.24839591435,-1.11566131742,-2.53183254257,0.341867744517,-1.17717934245,0.122798735505,1.50854281113,3.21411297648,0.8318630658,0.700422072161,0.865385480607,0.599532464001,1.04076451559,-1.86933754976,-0.374143715648,-0.315671721777,0.267934589493,0.282020079022,-0.292301143226,-0.0741969494722,-0.25790429141,-0.73016001939,-0.137315784138,-0.0160197240099,0.476357144179,0.347063841306,0.937623319372,0.483669289178,0.749054081605,-0.063262635165,0.203943192819,0.368890761386,-0.609078635778,-0.0885411909749,-0.127698656456,0.0266980522032,0.0706701837401],[-35451.7049208,274.972223409,155.069954595,-1185.88982173,2658.99456812,2082.00062477,-310.656263307,-1230.77087578,-77.359891351,-765.423793364,-791.218051039,801.367356116,-486.336590968,-362.920238273,-444.936158111,2.55014654124,-334.029442019,775.196343274,71.3213771197,-330.645607053,16.1514032082,-469.614431916,-44.8093715499,-71.7952267054,36.4421887161,-65.9104259725,-89.6147181511,251.867091792,9.11109340094,158.361687173,-133.266189268,104.721230519,-23.1755261015,-39.9776074068,-145.120452095,-9.36594965377,-12.1940227589,19.425765428,-40.5310572972,20.099226478,54.9765127582,-47.8629672051,21.9660948945,-26.0679022595,18.0808637472,-72.5432531069,-58.4668033312,-29.1942769356,11.101424343,-5.72258065826,1.21148910191,-2.77884511769,-5.11655043621,3.46744371809,0.745824953923,11.6298057466,-5.40575445106,8.26809174566,-6.69113701942,-16.0466346173,-11.233443688,9.51666170795,9.05072505639,4.69448778632,2.83049356099,-3.65266639696,-5.89643750273,-2.0971282412,-0.728955766368,-2.13468458987,1.31763904102,2.69289848938,2.64694481212,5.72626322464,-0.563834617909,-0.0291193500751,3.15745729707,2.45937143704,1.04544523501,-5.17815605333,1.85422883361,0.450471275748,0.00256589889298,-1.24715272319,-1.13500295076,-2.531428341,0.33198823183,-1.13200491085,0.112185505042,1.53834282815,3.19062104002,0.81100468747,0.615454795748,0.830090919389,0.469229387697,1.04353938717,-1.83404250158,-0.370015513652,-0.310247342335,0.273810248442,0.297979017602,-0.287944808929,-0.0749234453388,-0.256330013821,-0.730910826128,-0.153838514773,-0.0179803485886,0.454792922863,0.345741901215,0.931452785843,0.470397599262,0.723320516512,-0.0739411814102,0.179169460554,0.370665552939,-0.60456486174,-0.0733821615688,-0.122214067949,0.0263389213143,0.0671104494003],[-35359.1537781,212.716444287,227.038995279,-1190.79345929,2671.65717771,2109.12248232,-325.115569272,-1257.01542368,-94.0740870589,-776.046089449,-773.489904354,829.739178853,-461.187975531,-320.362007336,-432.244876757,1.41291248909,-328.4889869,785.28352069,71.0996128222,-311.216053245,29.3914796501,-465.564267032,-51.8808038374,-75.6005808422,35.9115696936,-68.6909085464,-85.3624287221,248.129217193,15.4398307798,156.29446099,-134.632183415,100.470044969,-25.7051046801,-49.8135017304,-144.511534464,-9.80094201843,-12.9397766224,19.3409432758,-42.42639562,21.0959723106,54.605469637,-47.3331906577,21.1009370392,-24.4329459401,15.9435813391,-72.430266989,-56.0827555627,-29.25678116,11.1167308035,-6.20272740607,1.2085067058,-3.16517551214,-4.98644304951,3.15310094273,1.27415538142,11.4841384656,-4.53167828907,7.95144875711,-6.81438731191,-15.3473662,-11.8122070545,9.19339707552,7.84780016771,4.74065454666,2.70402750067,-3.59332151019,-5.95298190508,-2.10624803866,-0.866089138049,-2.08293963338,1.40810310656,2.84533139347,2.72973874531,5.59877248079,-0.392621827893,-0.37778305597,3.09643695056,1.98618582828,1.09076913773,-5.08398009664,1.87692928558,0.465914892079,0.00145059912947,-1.24279124522,-1.14995345291,-2.52300909481,0.327172551608,-1.08115141838,0.103213486925,1.56972451515,3.16310287475,0.79280464739,0.525995859199,0.801292948339,0.33464078832,1.04615507616,-1.79356923919,-0.364722829185,-0.304742312808,0.280235530755,0.311553217745,-0.282820593668,-0.0752116807453,-0.253594146649,-0.729427647288,-0.168928041348,-0.0177888191046,0.433605453688,0.345368617582,0.924609167199,0.457590936227,0.696825939549,-0.0826305673629,0.152606044546,0.372401818623,-0.597916021914,-0.0583181541611,-0.115649014306,0.0253702787913,0.0640006043078],[-35250.2586405,130.119045283,288.574579225,-1199.97456985,2677.86034333,2135.65477653,-336.617228762,-1280.57862875,-110.248803972,-787.288630253,-750.588523082,858.371597445,-436.807546538,-274.707569572,-419.371997084,1.00612175485,-321.272152841,795.586135442,71.5690235575,-291.688147749,42.7516011469,-461.072450812,-60.2976215219,-81.239133413,35.6110870885,-70.9509842583,-80.5761558474,244.075723472,21.7153112942,153.654387096,-136.398242877,95.2953587004,-29.0628452211,-59.948694143,-143.587644635,-10.2511073304,-13.4997518356,19.2850951688,-44.2210182742,22.109435382,53.9954914364,-46.8861301653,19.8493996882,-23.0417570472,13.6530245807,-72.2713930931,-53.545957672,-29.3462152862,11.0737950701,-6.65818950039,1.20045309583,-3.51515710005,-4.82631921008,2.80461824097,1.78269474241,11.2840303692,-3.67377245697,7.54658711343,-6.92880076649,-14.5715216812,-12.433072802,8.8650395407,6.59739411617,4.75679980543,2.56446512052,-3.5362742792,-5.99769586426,-2.09373304091,-0.994220804792,-2.02226016614,1.4967386415,2.99019720241,2.80720964813,5.46270860302,-0.204982407716,-0.736505812053,3.0443556541,1.49044182598,1.13830741639,-4.98739464983,1.89237220142,0.472694820563,0.00234105400865,-1.23598792951,-1.15974006789,-2.50635995698,0.328004049238,-1.02393587185,0.095275639392,1.60301771057,3.13061183699,0.777625588207,0.431323643221,0.77851000497,0.19624234539,1.04854661746,-1.74877441553,-0.358010435322,-0.299553430359,0.287224771414,0.322577718973,-0.276957184202,-0.0752618062602,-0.249525944853,-0.725717471611,-0.182143483222,-0.0151419469697,0.412874832448,0.346062754688,0.91690702361,0.445607340044,0.669205627719,-0.0895324732849,0.123968716518,0.374108256202,-0.589243990991,-0.0435687466716,-0.107990976929,0.0237647960314,0.0613672699089],[-35124.7866892,29.2951645051,338.203857722,-1213.2987289,2678.33118544,2161.04384688,-344.967456255,-1304.98191517,-125.660791391,-798.8292059,-723.432512811,887.283525845,-414.8808007,-226.425693945,-406.913864383,1.50243147727,-312.385974102,805.901838112,72.8160425279,-272.754984577,56.1064333631,-456.596569878,-70.2054921395,-88.6000381251,35.5745240776,-72.6581863964,-75.2985262392,239.765119228,27.8184159313,150.399793167,-138.725676181,89.131478062,-33.2330317301,-70.2534491802,-142.401807211,-10.7087081704,-13.8678275654,19.265050256,-45.885529574,23.1280863156,53.1563250472,-46.5731683678,18.1766165325,-21.9320761937,11.2423075933,-72.1151208376,-50.8788707948,-29.4537750685,10.972467532,-7.08464794236,1.19148526391,-3.82360204293,-4.63133959537,2.42808271197,2.25457909064,11.0244275641,-2.85271633181,7.05644916135,-7.04639373851,-13.7223303605,-13.0956865572,8.5277933661,5.30410641074,4.74088961203,2.4126086684,-3.48030659379,-6.03099939923,-2.05798630233,-1.11023403436,-1.95464711449,1.58226102455,3.12164932018,2.87905419712,5.31466679123,-0.00269178623181,-1.10455614075,2.99956105652,0.973973850933,1.18757405085,-4.89208304356,1.90012865001,0.470455044917,0.00548387007995,-1.22697789014,-1.16386983746,-2.48139338435,0.334794354862,-0.96011644342,0.0875409124509,1.63796889659,3.09215463526,0.765441875883,0.330860751542,0.761215207793,0.0550270884094,1.05079716836,-1.7007735213,-0.349667976841,-0.295175044515,0.294744646525,0.330852533487,-0.270483942168,-0.0751939261156,-0.244051987689,-0.71982303061,-0.193110175142,-0.00986236149124,0.392697482229,0.347763475788,0.908196515942,0.434739758135,0.640130899231,-0.0948841988975,0.0930779180538,0.375885818527,-0.578734922574,-0.0294269830961,-0.099312143099,0.02149227415,0.0592361702024],[-34982.9829368,-81.8434194623,379.4623235,-1230.55633048,2674.48781094,2185.82605278,-350.360422576,-1332.71607032,-140.193798602,-810.637578409,-693.042535062,916.195559187,-396.583451355,-176.437691873,-394.81801628,3.0976193102,-302.060895186,815.915710755,74.758611165,-255.002516638,69.1353828194,-452.274479077,-81.6693788826,-97.3333734631,35.8559829785,-73.818958465,-69.6227687445,235.186473832,33.6443155564,146.43149125,-141.667163168,81.9399381394,-38.0978139558,-80.577377727,-140.993394481,-11.1510616613,-14.0371165267,19.2825180154,-47.4046337835,24.1339833749,52.0866802323,-46.426674114,16.0484242242,-21.1126626017,8.74425654845,-71.9958400445,-48.1142307452,-29.5577115004,10.8164627031,-7.47042443426,1.18640966928,-4.08533729071,-4.40008892108,2.02665147102,2.6721183772,10.6967588843,-2.08453752225,6.48099772452,-7.17338655448,-12.8101144281,-13.7935823684,8.1763658535,3.97614926865,4.6913240393,2.25228551254,-3.423489701,-6.05184245678,-1.99892757865,-1.21161183917,-1.88339261027,1.66131483553,3.23379857699,2.94280566724,5.1526977817,0.209392300707,-1.47853384264,2.95983871486,0.440808039711,1.237883695,-4.801910641,1.89957731055,0.459478270224,0.0111398425588,-1.21522223995,-1.16206087067,-2.44805788089,0.34721532645,-0.890160292421,0.0789189489626,1.67346885113,3.04699172299,0.755308241566,0.224836027726,0.748454892203,-0.0871317061497,1.05274663056,-1.65069391148,-0.339592937056,-0.292103510669,0.302556800736,0.336175085662,-0.263551129719,-0.0749171631139,-0.237133295288,-0.71167573274,-0.201583558347,-0.00194055929531,0.373078748654,0.350175853147,0.898327083559,0.425045273236,0.609413365494,-0.0991104959102,0.0600007702389,0.377741258587,-0.566537629397,-0.0162905482778,-0.0897118020568,0.0185092670717,0.0576405142808],[-34827.0413696,-193.265057428,417.048901262,-1251.93246524,2668.29539578,2211.10784075,-353.495862903,-1364.66459693,-153.967052785,-822.598450408,-660.433154376,944.822689835,-382.450110766,-125.875625607,-382.666510063,5.90849498408,-290.582419025,825.285165232,77.3185189895,-238.92628237,81.4430531139,-448.065820327,-94.7116873543,-106.977758035,36.4928575958,-74.4706249522,-63.6659141396,230.33374141,39.0786586215,141.640763106,-145.207485343,73.7057141817,-43.4952863351,-90.7552029267,-139.372268045,-11.552682537,-14.011625865,19.3333663753,-48.7607075255,25.0969240935,50.7911163619,-46.4676256132,13.4370747666,-20.5762700968,6.18794915305,-71.9278953473,-45.2903963218,-29.6237154812,10.612120979,-7.80451155984,1.18955610015,-4.2958325476,-4.13433253888,1.60508380861,3.01677403516,10.2934248482,-1.3827470399,5.81863280202,-7.30951082251,-11.8492792873,-14.5150885756,7.80350112371,2.6235520217,4.6072898289,2.08782912656,-3.36362365718,-6.05955362177,-1.9172556421,-1.29572661922,-1.81277051382,1.73062655518,3.3209670228,2.99537993832,4.97613760634,0.424521127595,-1.85286867586,2.9222198067,-0.103809338388,1.28795797797,-4.72072896199,1.89022565569,0.440370420757,0.0195807204296,-1.20023212776,-1.15403882046,-2.40641491478,0.36454649059,-0.814652518451,0.0682653937954,1.70829505453,2.99446161075,0.745748008123,0.114124172327,0.738853955519,-0.227888025779,1.05380729087,-1.59967062111,-0.327748218929,-0.290873444334,0.31037426617,0.338425263918,-0.256296689721,-0.0743381527034,-0.228711224647,-0.701223499254,-0.207394459796,0.00854610274039,0.353967723151,0.352999226146,0.887087842021,0.416489341624,0.576954844837,-0.102779228047,0.0249556429796,0.379523849449,-0.552767739339,-0.00460783695407,-0.0793268107595,0.0147731759078,0.0565938669497],[-34660.8069035,-300.826653022,453.560380769,-1277.49840144,2660.52232508,2237.47055787,-356.294643136,-1400.781451,-166.904709409,-834.557042462,-626.685202264,972.689130252,-372.658340129,-76.0187932748,-370.177060579,10.0449258436,-278.158750823,833.625382404,80.4182502543,-224.990591768,92.5745732673,-443.961533034,-109.33673874,-117.097945085,37.5112262778,-74.6411054403,-57.553214708,225.217184868,43.9882511276,135.91890307,-149.322918865,64.4361473404,-49.2829401697,-100.594101663,-137.519562296,-11.8905577049,-13.7990072344,19.4084416602,-49.9268375208,25.9787635784,49.2822058525,-46.7130744458,10.3243034136,-20.3164488036,3.6075426481,-71.906749163,-42.4436624546,-29.608237671,10.3661194814,-8.07792782202,1.20558606616,-4.45047598452,-3.83765247814,1.1712175247,3.27057485165,9.81007064224,-0.761045311159,5.07000517979,-7.4492563913,-10.8542563688,-15.2453443963,7.40090370822,1.2570342354,4.48855786578,1.92323181855,-3.29821963155,-6.05380997763,-1.81376731813,-1.35963281659,-1.7469364817,1.78786630978,3.37770093493,3.03431385306,4.78505001194,0.63573743604,-2.22055194224,2.88360939493,-0.653997405861,1.33614654404,-4.6522116262,1.87174188972,0.413857296644,0.0311223331664,-1.18171783165,-1.13949141592,-2.35657939675,0.38597159509,-0.734089183427,0.0545944191951,1.74138304739,2.93380396492,0.735204693545,2.38797505414e-06,0.73088183769,-0.364637571213,1.05308893564,-1.54869924751,-0.314083475763,-0.292013752347,0.317920727835,0.337565677775,-0.248838781933,-0.0733993299241,-0.218699375929,-0.688474494071,-0.210409870029,0.0214613146463,0.335310086459,0.355967417274,0.87417860934,0.409036253298,0.54270019274,-0.106502367418,-0.0117317548087,0.380986762657,-0.53744284704,0.00518834439397,-0.0683114564609,0.0102686211986,0.05609884942],[-34488.5037243,-409.337716184,486.83291731,-1306.63845616,2650.48662776,2263.89754159,-361.674575005,-1441.63476775,-178.56353594,-846.189389152,-593.072866083,999.066842593,-367.421145521,-28.1838383002,-357.557722993,15.6089424882,-264.851816615,840.515940733,84.0112635689,-213.660887418,102.080437406,-440.140878686,-125.456768397,-127.419088778,38.9097225047,-74.3243051162,-51.4094270467,219.87883112,48.2323991009,129.17822353,-154.015602047,54.1950269643,-55.3828860379,-109.854473137,-135.394742469,-12.1482540403,-13.4094028459,19.4956528154,-50.8622291753,26.7409704462,47.5836885245,-47.1760115108,6.71029334129,-20.3402222425,1.05312385958,-71.9163618045,-39.5991440525,-29.461326941,10.0844511242,-8.28564590749,1.23915977438,-4.54379176682,-3.51448156652,0.736688951767,3.41852630849,9.24763417512,-0.234364421274,4.2420941009,-7.58415982672,-9.83422315777,-15.9676682865,6.96090841575,-0.112249958846,4.33559437841,1.76137706689,-3.22493143818,-6.03461209837,-1.68947523798,-1.40000275985,-1.68881128978,1.83187765983,3.39938523655,3.05865530429,4.57973565381,0.837507407733,-2.57366279676,2.84164291265,-1.20344087939,1.38073464875,-4.59949436036,1.84406361523,0.380625779495,0.0460053909265,-1.15970338057,-1.1182054519,-2.29870906726,0.410732247694,-0.648919673376,0.0374041613487,1.7718644418,2.86414825873,0.722389770602,-0.116042606049,0.723300770566,-0.494617297994,1.04965180667,-1.49846701706,-0.298441535382,-0.296051815159,0.324965918534,0.333650313778,-0.241278154603,-0.0721226952427,-0.207048459692,-0.673502860754,-0.210568765314,0.0365948059253,0.317129865992,0.358808223849,0.859262476088,0.402671406382,0.506616632048,-0.110803349364,-0.0496454404516,0.381887527461,-0.520424743398,0.0127462161447,-0.0568117189643,0.00501992398219,0.0561765253082],[-34314.832885,-524.06752538,512.197616572,-1339.43284555,2637.86125482,2288.20748298,-372.24264833,-1487.6363685,-188.805942243,-856.897269711,-561.11813568,1023.52602202,-366.743649987,16.4853917382,-345.334384616,22.5207857951,-250.691210639,845.47216522,88.2260148679,-205.399672155,109.626788189,-436.919250568,-142.878992077,-137.807747462,40.6387902571,-73.5339850323,-45.3680325653,214.411495534,51.6464150924,121.38760365,-159.315819291,43.1080288779,-61.7724003837,-118.270122448,-132.92795145,-12.313445584,-12.8713147557,19.5808802705,-51.5168727983,27.3359462327,45.7396654178,-47.8710571066,2.61567981274,-20.665208017,-1.41703089451,-71.9261368336,-36.769979545,-29.1250992047,9.77504975954,-8.42959883111,1.29559636321,-4.57296082496,-3.17141246544,0.317815733856,3.44660160912,8.61400033544,0.180782615192,3.34731887914,-7.70207781975,-8.79332857167,-16.663162586,6.47569165951,-1.47291701187,4.15036932333,1.60380801148,-3.14145290135,-6.00365873778,-1.54544620213,-1.41336991258,-1.64037711088,1.86330895498,3.38184065479,3.06936893569,4.3606539307,1.02571081498,-2.90343546265,2.79423704149,-1.74568932421,1.4197149132,-4.565189591,1.80759924155,0.34143426683,0.0644206596435,-1.13485134939,-1.08989984714,-2.23328825543,0.43815918854,-0.559406573516,0.0165077634345,1.79935652156,2.78444251509,0.706338762186,-0.232420894684,0.715030108539,-0.615088153343,1.04236794919,-1.44941903615,-0.28060859585,-0.303563386718,0.331358581129,0.326910157778,-0.233712071748,-0.0706497683488,-0.193711338652,-0.656552218635,-0.207858769707,0.0536624064897,0.299516543747,0.361332649993,0.841925373599,0.397451166858,0.468653268481,-0.116141639977,-0.0883326013039,0.381921238333,-0.501471339532,0.0177728172887,-0.0450048621736,-0.000924719465102,0.0568648551681],[-34142.2862691,-640.735076069,533.421422551,-1377.08176396,2625.27174278,2310.37477583,-389.8777524,-1536.22049118,-198.352735905,-865.42706167,-531.978382092,1046.34429572,-369.524875462,57.0380542506,-333.88415772,30.3227427403,-235.654587078,847.998622537,93.5286162592,-200.405396669,115.07918648,-434.477154308,-161.30041859,-148.129292925,42.5552634451,-72.3496030444,-39.5754782498,209.006704764,54.1075731902,112.623734489,-165.185969434,31.371910874,-68.4181073947,-125.567852551,-130.013168271,-12.3850892642,-12.2546266099,19.6442328265,-51.8259847836,27.7172118714,43.8320953786,-48.7892793209,-1.90728011816,-21.2939837992,-3.73775907225,-71.8845906783,-33.9599026994,-28.5336186073,9.44928348181,-8.52535928775,1.37949908569,-4.5405063901,-2.81751063301,-0.0601329811566,3.34805339246,7.92894720195,0.474912259497,2.40441399097,-7.78270239887,-7.73212580029,-17.3081552221,5.93677262258,-2.81239174011,3.9377450623,1.44966174782,-3.04567811791,-5.96643095094,-1.38324388696,-1.39586182252,-1.60197765551,1.88603398729,3.32360329037,3.0700142261,4.13059665072,1.1976428669,-3.19887236971,2.7393751536,-2.27370556441,1.450624986,-4.55187896863,1.76368204407,0.297210535561,0.0865599195336,-1.10916614618,-1.05437704277,-2.16146784391,0.46759589744,-0.465374024872,-0.00750946558378,1.8243883677,2.6942728714,0.686600199273,-0.346805313927,0.705111168037,-0.722988904462,1.02986644966,-1.40184379256,-0.260303086596,-0.315199035219,0.337113524361,0.317886455495,-0.226226099305,-0.06937918852,-0.178663488635,-0.63823407192,-0.202378603476,0.0723255779114,0.282682997768,0.363585525904,0.821912794601,0.393595841662,0.428979537366,-0.122907710262,-0.127151859001,0.380684199566,-0.480258711972,0.0199943843086,-0.0331265189066,-0.0074927648706,0.058207177696],[-33971.8015778,-753.124854905,565.10679464,-1420.54479603,2615.76418758,2332.48821515,-418.796283319,-1581.69129447,-208.155927605,-870.485305916,-506.741073594,1067.28982566,-373.745047139,91.9511929838,-323.303069015,38.4254255616,-219.629282949,847.468794242,100.397769936,-198.664538885,118.159520742,-432.843724454,-180.382225584,-158.267791646,44.4789049788,-70.852806662,-34.212898124,203.915257326,55.5080187422,102.969396434,-171.531969765,19.2011579428,-75.2882026713,-131.482166354,-126.525062904,-12.3663650473,-11.6386736115,19.6600369923,-51.7032988164,27.8299974091,41.956827094,-49.9076292384,-6.79498303566,-22.220268881,-5.8436766026,-71.7308292479,-31.1654654588,-27.6184737359,9.12063752436,-8.59301482008,1.49550019899,-4.44728698754,-2.4672246846,-0.364615145762,3.12109207504,7.21658841322,0.643443272147,1.43428989867,-7.8017384081,-6.64909404253,-17.8756211511,5.33471121716,-4.11645578246,3.70407698181,1.29702375031,-2.9351282391,-5.92948547753,-1.2052393847,-1.34230977825,-1.57339028032,1.90531616841,3.22519510373,3.06481931665,3.89375808473,1.3510790919,-3.44729071135,2.6748819742,-2.77978747367,1.47076444748,-4.56216273341,1.71393983979,0.248973814138,0.11273514529,-1.08524712951,-1.01144506309,-2.08445680648,0.498215887156,-0.366469299103,-0.033505257941,1.84775414784,2.59367305588,0.662768820531,-0.456251985938,0.692631851963,-0.814876495939,1.01069430122,-1.35588107722,-0.237133868893,-0.331745554531,0.342261412394,0.30725185568,-0.218873675629,-0.0688616563882,-0.161826855482,-0.619318368138,-0.19435185682,0.0922603384867,0.266899441815,0.365682553365,0.799112572518,0.391302804941,0.387947757113,-0.131481891878,-0.16528830265,0.377695818573,-0.456414231032,0.0191530130267,-0.0214931261376,-0.0145764838558,0.0602576006667],[-33803.9199988,-851.829046489,620.527703482,-1469.40941646,2612.84070333,2356.34936713,-460.297068509,-1617.5613481,-218.81409659,-871.040102319,-486.159922244,1086.96733911,-377.164183687,120.562361038,-312.750712988,46.2539650029,-202.520887893,843.430988753,109.370526714,-199.983952935,118.949365899,-431.65707552,-199.590467563,-167.872122097,46.2071449696,-69.1363955359,-29.4051768877,199.346495984,55.7956742099,92.5894749203,-178.159654902,6.88561867806,-82.2353380474,-135.770514563,-122.301628,-12.2690325706,-11.1046535502,19.6071806353,-51.086912065,27.6314588572,40.2069923637,-51.1920977764,-11.9608652716,-23.4002131357,-7.67615540004,-71.3850489911,-28.3740852217,-26.3155648939,8.80190309701,-8.65320778216,1.64465241182,-4.30047681614,-2.13619945398,-0.568938658434,2.76457862065,6.50402634519,0.68831252731,0.457241768351,-7.72861911939,-5.54034137866,-18.339408888,4.66263697395,-5.37109939957,3.45658949282,1.14400712002,-2.80910258051,-5.89971832303,-1.01461356138,-1.250281648,-1.55543646946,1.9262919841,3.08718279073,3.05803968061,3.65586260659,1.48436596358,-3.63604384399,2.60057534049,-3.25683426024,1.47842699225,-4.59842870402,1.66027319405,0.197920721771,0.142898411352,-1.06531517011,-0.961271963086,-2.00395921265,0.528798509498,-0.262713262347,-0.0607792128382,1.87042531239,2.48288465884,0.634489305269,-0.55767941955,0.677578141189,-0.887467307797,0.984117156286,-1.31142831913,-0.210452819798,-0.353972474402,0.346883908443,0.295763368478,-0.211673016698,-0.0694738587017,-0.143191593437,-0.600571256407,-0.184094777243,0.113060113209,0.252251044697,0.367815316816,0.773426071475,0.390743253324,0.346018520581,-0.141977479594,-0.201911108916,0.372768947023,-0.429490262955,0.0151328283899,-0.0104002025017,-0.0220317441965,0.063118481661],[-33641.74518,-937.904373382,700.096633939,-1520.46418084,2617.19307326,2380.89348445,-514.818108723,-1640.15414239,-229.677062002,-866.478412458,-470.92208828,1106.03992636,-378.569939344,142.865398785,-301.220471685,53.4938123002,-184.06802615,835.673541233,120.87473281,-204.280483118,117.780006523,-430.518751921,-218.24402813,-176.496216292,47.5503294098,-67.2064072837,-25.1894882307,195.465953555,54.955399654,81.6871461591,-184.871348904,-5.23389578839,-89.0693615664,-138.216907829,-117.166909153,-12.1180548379,-10.7127228814,19.478186801,-49.9293630919,27.1021135931,38.6612297128,-52.615980741,-17.3031944889,-24.7781109224,-9.18201702068,-70.7622623583,-25.5637117401,-24.5682969324,8.50021087672,-8.72458660113,1.82529792904,-4.10829684483,-1.83623125749,-0.653556294195,2.27727042449,5.81965753113,0.611602294721,-0.505885130095,-7.53190847261,-4.39890253874,-18.6756487021,3.91650287441,-6.56173535933,3.20178605173,0.988409678257,-2.66893264061,-5.8829172084,-0.814205954119,-1.11954505836,-1.54894322927,1.95362553665,2.90925866288,3.05404742539,3.42244352208,1.59708747787,-3.75340067021,2.51855684171,-3.69803882295,1.47281265964,-4.66250605755,1.60459066639,0.145021784334,0.176532834091,-1.05097782238,-0.904256107646,-1.92185705913,0.558162478282,-0.154521135497,-0.0891000330856,1.89354867709,2.36194514254,0.601698235962,-0.648245615578,0.660973594777,-0.937607429781,0.950121319848,-1.26785128896,-0.179388382859,-0.382460065201,0.351097961159,0.284119490618,-0.204646589683,-0.071411383656,-0.122866765131,-0.582638442597,-0.171907147474,0.134261415567,0.238722541777,0.370234017117,0.744701628578,0.392103645623,0.303644201072,-0.154176450261,-0.236180333592,0.366029104752,-0.398849510893,0.00793879847893,-1.96794605075e-05,-0.0296925675265,0.0669678451843],[-33490.7632917,-1025.01195442,800.678464622,-1569.76870951,2626.04456971,2403.93471644,-585.53110452,-1647.13789553,-239.41278736,-856.828667419,-461.885805535,1124.06371939,-377.375763556,158.595546518,-288.134582402,60.1183095593,-163.914044755,823.987080294,135.036571796,-211.61057143,114.852607215,-429.231158335,-235.627500286,-183.831737212,48.3970984879,-64.9761117371,-21.590219597,192.413367347,52.955656004,70.4101605988,-191.520799012,-16.8138882561,-95.6672876816,-138.607230307,-110.970350975,-11.9268663291,-10.4872617583,19.2733714005,-48.1766914901,26.2285546915,37.3762644359,-54.1664005488,-22.7194222643,-26.3174775491,-10.3046644245,-69.7910057878,-22.7036786216,-22.325593103,8.2200727996,-8.81713579632,2.03745196875,-3.87217493253,-1.57711116884,-0.601528764775,1.65862852626,5.18992006171,0.410506232397,-1.43167458633,-7.18490507733,-3.21510764842,-18.8621093572,3.09347856585,-7.67253473449,2.94435360217,0.829296022909,-2.51557564054,-5.88226201685,-0.605798939312,-0.949780420402,-1.55405708631,1.99127141986,2.69072733322,3.05738663517,3.19767254315,1.69027077532,-3.78844410203,2.43199482566,-4.09642506081,1.4531225845,-4.75601446944,1.54810178773,0.0910863165144,0.213108563067,-1.0431854957,-0.840513947497,-1.83959339351,0.585484948367,-0.0425786568502,-0.11815763835,1.9182244479,2.23063678495,0.564637267251,-0.725308594209,0.644293057181,-0.962170383476,0.908812667633,-1.22428257887,-0.143014810762,-0.417731616033,0.354852894567,0.272821627402,-0.197845128907,-0.0747761029227,-0.10092759542,-0.565981128652,-0.157994709506,0.15540259911,0.226364395512,0.373129673847,0.712781252225,0.395564620122,0.261245639465,-0.167702250903,-0.267216566531,0.357670549827,-0.363795366708,-0.00237724111679,0.00946545668621,-0.0373638780724,0.0719952165825],[-33354.9422407,-1127.62634912,906.331037619,-1612.90955765,2635.97931081,2421.1219386,-671.654325929,-1639.70577009,-246.18939117,-842.837634629,-459.559677713,1141.25722504,-374.047773942,168.541243881,-273.089263882,66.409200454,-141.871883338,808.491945176,151.786601599,-222.098952715,110.722501012,-427.652628258,-250.918066233,-189.555659131,48.7401936415,-62.3304593453,-18.5341078126,190.190303412,49.8191456356,58.90626509,-197.959223784,-27.4928332983,-101.889478285,-136.752278145,-103.606572795,-11.6889536995,-10.4140536393,19.0068196419,-45.8187408396,25.0288993285,36.3651412359,-55.8309683042,-28.1090219112,-27.9749216444,-11.001464871,-68.42087547,-19.7621687952,-19.5606261534,7.96297715437,-8.92541517843,2.27835638061,-3.59481000859,-1.36159557277,-0.4123642366,0.909591842181,4.63336859921,0.0818589540294,-2.30219157422,-6.66621762388,-1.98141529693,-18.8883427195,2.19313569536,-8.6917756563,2.68613432556,0.66903599636,-2.35151713038,-5.89701027189,-0.390472228422,-0.744314228413,-1.57097187984,2.04000170165,2.43047138674,3.07027713317,2.98473034948,1.76437152388,-3.73479817958,2.34537564409,-4.44810114085,1.41893473989,-4.88111750765,1.49098704559,0.0369067796811,0.251653992694,-1.04109146449,-0.77033551893,-1.75830037555,0.610062313238,0.0716324383136,-0.147947762742,1.94491604711,2.08870316431,0.523119392741,-0.787197158795,0.629439853563,-0.959397293683,0.860682502713,-1.18026708925,-0.100330936001,-0.460373468694,0.357899466037,0.262029707379,-0.191330344185,-0.0792721594411,-0.0775464503317,-0.550602494554,-0.142488078711,0.176006070545,0.215132399471,0.376576360687,0.677545421215,0.401105860925,0.219160922391,-0.182074642203,-0.294466151618,0.348069256251,-0.323856385604,-0.0156725857192,0.0177645225666,-0.0448368678177,0.0783507715982],[-33234.7079091,-1247.69409937,998.480011985,-1647.9170107,2645.55477307,2428.21480577,-767.738863541,-1621.64634088,-248.833783504,-826.03396626,-463.973292109,1158.60713253,-369.62121498,174.548079666,-256.112795953,72.7408970349,-118.204602749,789.565110032,170.836081106,-235.808029154,106.252363788,-425.757247424,-263.183392776,-193.446201781,48.6747372696,-59.2083638933,-15.893398021,188.627339217,45.6426534527,47.2884211716,-204.031292907,-36.8864268087,-107.634554286,-132.461801028,-95.0608647136,-11.3656548934,-10.4536086037,18.6953979888,-42.8990731056,23.5503831441,35.5886550595,-57.5846697265,-33.3760707816,-29.7108902275,-11.2331998098,-66.638838331,-16.7023251535,-16.2723733764,7.73115440544,-9.02829385153,2.54211940047,-3.28124102353,-1.18680063461,-0.104314194021,0.0373878884433,4.15673329341,-0.377121036085,-3.1028268573,-5.96478670898,-0.690777972069,-18.7583577699,1.21715694634,-9.61293894177,2.42648740332,0.513898930264,-2.18019126276,-5.92238556359,-0.169607127639,-0.510206337657,-1.59886681469,2.09602686292,2.12836745324,3.09241740347,2.78480780303,1.82001158232,-3.59163197212,2.26457743463,-4.75253786821,1.37028805637,-5.04071052247,1.43236270781,-0.0166618590403,0.290930698657,-1.0420720029,-0.694419618983,-1.67858439651,0.631301602773,0.185606179007,-0.178220377403,1.97297248934,1.93597568625,0.476592811472,-0.833434767732,0.61867475712,-0.929168570673,0.806477633484,-1.13602209422,-0.0503742208396,-0.511079211418,0.359785454643,0.251547331418,-0.18515134596,-0.0842461681651,-0.0530236328964,-0.535980218847,-0.125534084157,0.195546568837,0.205007627878,0.380320916468,0.63900505812,0.408425131885,0.177577624118,-0.196741711184,-0.317797133903,0.337771731209,-0.278908891387,-0.0316965931953,0.0244025618774,-0.0518790789748,0.0861064743393],[-33127.0960757,-1375.79039121,1070.49506417,-1675.55280234,2656.28273189,2424.20957809,-867.271226106,-1595.64886587,-247.353685769,-807.894445545,-474.724206596,1177.19321336,-364.522863598,178.523448636,-237.261342795,79.2747901604,-93.4288902649,767.591223115,191.812126832,-252.563427412,102.289105274,-423.450523233,-271.572379642,-195.347264429,48.2982372522,-55.6292707743,-13.5848946532,187.512666492,40.5835126535,35.6242237353,-209.52036642,-44.6568709969,-112.814158769,-125.56139707,-85.3870674108,-10.9053958336,-10.5808958503,18.3427161183,-39.4813848603,21.8482443145,34.9850461469,-59.3801151029,-38.4386931283,-31.4796899575,-10.9699112393,-64.4566509333,-13.4908779674,-12.4707436242,7.53025545359,-9.10484180703,2.82101517663,-2.93895191844,-1.05116695183,0.298948275521,-0.944047533787,3.75922472127,-0.965624807951,-3.82199347539,-5.07558156373,0.659799648407,-18.4818006769,0.166627126082,-10.4301864496,2.16524547126,0.37097719273,-2.00460234218,-5.95325553889,0.0537336143061,-0.255361814746,-1.63649131908,2.15390759722,1.78628247882,3.12169444417,2.59834952174,1.85717770705,-3.3605272743,2.19496364386,-5.01010980143,1.30688703487,-5.23775147679,1.37135425163,-0.0685310979477,0.329894818145,-1.04334244851,-0.613918095998,-1.60082454055,0.648394996445,0.296576669095,-0.208359000006,2.00102584742,1.77260465654,0.424211311049,-0.863994277444,0.613965057142,-0.87215594314,0.74677051588,-1.09208300403,0.00758836096493,-0.570507649977,0.360043820259,0.241188419211,-0.179308502338,-0.0890216237694,-0.027723480876,-0.521461765278,-0.10741051313,0.213500198048,0.195990621956,0.383896055907,0.597301353521,0.417027370592,0.136633083203,-0.211218043572,-0.337253944196,0.327309863317,-0.229044247815,-0.0501976611012,0.028794645743,-0.0582473272458,0.09527044267],[-33029.9204025,-1506.91186157,1125.91057725,-1697.14917116,2668.87824982,2410.74972435,-965.869331924,-1563.35534753,-241.901689545,-789.761791702,-491.094017725,1197.15490247,-358.591233906,181.713847214,-216.551089134,86.1447578172,-68.0459894721,742.933881492,214.15047729,-272.012438074,99.4042402847,-420.522397573,-275.485343942,-195.137408252,47.7097424325,-51.5980033038,-11.5744452188,186.630681199,34.8436329558,23.8919206059,-214.144837206,-50.5860360645,-117.332319714,-115.919532024,-74.6934527869,-10.2582079556,-10.7718577834,17.9392811741,-35.6254578856,19.9807496759,34.4748222989,-61.1488542278,-43.2484943632,-33.2222926902,-10.2053458242,-61.9046464145,-10.1055974988,-8.1724161219,7.36526511947,-9.13629967069,3.10587596906,-2.57222625093,-0.954963651473,0.773708072059,-2.0158334518,3.431905628,-1.67812602256,-4.45507173625,-3.9973162772,2.065093837,-18.0706570377,-0.959468300044,-11.136839984,1.90244128346,0.246692113103,-1.82744295233,-5.98369020316,0.274901399053,0.0133110405231,-1.68252552438,2.20756152748,1.40817923476,3.15345729178,2.42562119709,1.87395293811,-3.04425353597,2.14004292722,-5.2213689801,1.22776595603,-5.47473276087,1.3072875515,-0.117720244452,0.367721675998,-1.04226335979,-0.530391955108,-1.52499258345,0.660251245038,0.401939370741,-0.237464781487,2.02702780547,1.59917900791,0.364615387492,-0.878993967047,0.616540002622,-0.789620203643,0.68183652112,-1.04908661938,0.0739811271356,-0.639124208836,0.358267112792,0.230789434533,-0.173749357007,-0.0930093734571,-0.00208037467847,-0.506327164536,-0.0885191903045,0.229424161615,0.188071710982,0.3866958651,0.552699156159,0.42622939948,0.0964949855577,-0.225183289088,-0.352940836484,0.317132575065,-0.17449674073,-0.0709614913227,0.0303323496775,-0.0637085478512,0.105799035143],[-32943.3270903,-1640.43304076,1171.37282654,-1713.7005026,2682.95229952,2390.17983929,-1061.423275,-1526.23741408,-232.406404468,-772.782621181,-512.226939925,1217.77765056,-351.469559235,184.585459706,-194.139606929,93.5077654703,-42.4821304168,715.957719522,237.166986316,-293.766236052,97.8367555537,-416.73467762,-274.596899075,-192.803873105,47.0019685119,-47.0884788037,-9.85888554594,185.78067524,28.6347194017,11.9894485691,-217.598567936,-54.568719648,-121.120377354,-103.434592984,-63.143107361,-9.38204396318,-11.0022352327,17.4651120844,-31.3809362675,18.0042270204,33.9696174695,-62.8124108081,-47.7861813856,-34.8755311026,-8.94859571241,-59.0309727988,-6.53493225192,-3.40098604516,7.23952058242,-9.10689643734,3.38576988719,-2.1819616434,-0.900063294742,1.29950422864,-3.15623886889,3.16056767558,-2.50539237686,-5.00012803585,-2.73322432359,3.51227855941,-17.5390825782,-2.16438207299,-11.7251793172,1.63863427678,0.146352103635,-1.65137668449,-6.00715558627,0.488228716189,0.290646297422,-1.73553769582,2.25128443347,1.00011844826,3.18171632554,2.2663659038,1.86708465918,-2.64660863535,2.10134530322,-5.38694704226,1.13158371113,-5.75351269494,1.23983027466,-0.16341065811,0.403795713096,-1.03648620437,-0.445592105121,-1.45067172685,0.66559010774,0.499435737892,-0.264312145328,2.04853253338,1.41670372541,0.296286477143,-0.878672595562,0.626946107566,-0.683484866424,0.611792720253,-1.00772612182,0.14888237035,-0.717101429562,0.35413782685,0.220227581816,-0.1683499826,-0.095746974089,0.0234315849738,-0.489878556052,-0.0693359891413,0.242971282208,0.181244290498,0.388051331222,0.505583640577,0.435269703201,0.0573723941211,-0.238437468035,-0.365003380701,0.307648141138,-0.115632533105,-0.0938005751624,0.0284256595391,-0.0680404073639,0.117589429762],[-32869.548906,-1775.74053872,1211.9635581,-1725.95353988,2697.96934619,2364.35604715,-1152.77093402,-1486.39887021,-218.659816548,-757.850503627,-537.235350925,1238.1317572,-342.998944949,187.203654016,-170.455478391,101.514674144,-17.0747555475,687.035616315,260.200182521,-317.481657874,97.6311276317,-411.901064042,-268.791554285,-188.422425719,46.2532258184,-42.0682281315,-8.44369800013,184.7852359,22.159268642,-0.220715894953,-219.582772533,-56.5726258733,-124.137695347,-88.0305907189,-50.9462390067,-8.24515860068,-11.2536888806,16.8933311321,-26.790961387,15.9733987756,33.3791349463,-64.2920023143,-52.0468843744,-36.3743334188,-7.21977841333,-55.8955647946,-2.776035067,1.81109139826,7.15503886344,-9.00513117622,3.64815206185,-1.76885185788,-0.889241035195,1.859025038,-4.34172909632,2.9285955809,-3.43569065033,-5.45427053886,-1.29008553834,4.98267351052,-16.9038201053,-3.45280165128,-12.1860955958,1.37535810836,0.0738894734034,-1.47912783193,-6.0173631101,0.687549628637,0.572581507695,-1.79406816646,2.28029282937,0.569505230697,3.20035091005,2.11971248223,1.83290784891,-2.17279709516,2.07887292263,-5.50725201777,1.01669003159,-6.07497017424,1.16904929406,-0.204848423376,0.437631056647,-1.0240616535,-0.361377589485,-1.37721708691,0.663039708033,0.587117142625,-0.287512598704,2.06303245943,1.22652496659,0.217961241215,-0.863434724924,0.645303878284,-0.556331538767,0.536628732487,-0.968642405489,0.232020816862,-0.8042657613,0.347454751823,0.20946100217,-0.162923408267,-0.0969009423628,0.0483182112611,-0.471508245094,-0.0503683546256,0.253865449806,0.175482063502,0.387313229694,0.456413670439,0.443405587516,0.0194976079667,-0.250805883012,-0.37362120827,0.299219830638,-0.0529226196126,-0.11852378675,0.0225104838671,-0.0710214563222,0.130478019399],[-32809.5187686,-1908.04443987,1249.20098025,-1734.33760164,2714.85945865,2334.88804685,-1238.58586797,-1446.13773447,-200.478901084,-745.291797668,-565.079401172,1257.51897674,-333.18575702,189.604533613,-146.21128901,110.258591448,7.98027224469,656.544597158,282.737425358,-342.843709686,98.8536964235,-405.894387755,-258.055124818,-182.090445319,45.5270119279,-36.5119111672,-7.3320360144,183.519113487,15.6174582262,-12.8616218527,-219.804887927,-56.6055214991,-126.334724523,-69.6768138934,-38.3378119203,-6.82681207641,-11.5172968831,16.1919234137,-21.8904388845,13.9435982062,32.6149960685,-65.508071244,-56.0256361976,-37.641881849,-5.05455695685,-52.562384885,1.1650695423,7.41810371744,7.11224988223,-8.82437472129,3.87906015659,-1.33484524082,-0.925393086978,2.43780299338,-5.54584195829,2.71966584802,-4.45385057611,-5.81374144384,0.324914630809,6.45255161515,-16.1831838268,-4.82877415573,-12.5071546061,1.11499548644,0.0317260395942,-1.31343645865,-6.00868369052,0.866532599695,0.855642734006,-1.85649977463,2.29084749773,0.124883686928,3.20348569946,1.98511205057,1.7679063938,-1.62958354059,2.0715034648,-5.58178432964,0.880643776551,-6.43868311883,1.09532315107,-0.241329620475,0.468824265719,-1.00349620886,-0.279723708714,-1.30382754446,0.65121625938,0.663271963164,-0.305630732786,2.06818329888,1.03042923241,0.128808508507,-0.833795997394,0.67149588933,-0.41114602402,0.456114315631,-0.932320766655,0.322804004582,-0.900073639819,0.338139734019,0.198517713517,-0.15724771302,-0.0962596917283,0.072063161118,-0.45069444784,-0.0321375427009,0.261885104942,0.170710277481,0.383916581512,0.405710321146,0.449939320494,-0.016815979094,-0.262065728568,-0.378929286904,0.292083785349,0.0130828728674,-0.144939323763,0.0120617689147,-0.0724307529717,0.144264411089],[-32762.887756,-2030.66533638,1282.27583147,-1738.28955906,2735.28923605,2303.45987577,-1317.47134969,-1407.21136387,-177.50375719,-734.952579011,-594.57023377,1275.31845771,-321.999650216,191.668513696,-122.338147285,119.831380053,32.6314725902,624.844201049,304.362995181,-369.554988645,101.592219085,-398.640525711,-242.431817235,-173.873828943,44.8843513846,-30.3822199923,-6.52221789976,181.901557948,9.20402783175,-26.0374164307,-217.983213354,-54.7130035897,-127.630021265,-48.4140950855,-25.5585714934,-5.11585563508,-11.786067488,15.3292316717,-16.7062840963,11.9683420095,31.5900568322,-66.383142848,-59.7154130172,-38.586017805,-2.5123085752,-49.0924604065,5.27254303168,13.360360815,7.10893901307,-8.56030596373,4.06415824115,-0.882287000416,-1.01109229005,3.02437139175,-6.73983808648,2.51819664222,-5.54162927031,-6.07559856087,2.10599779675,7.89247672909,-15.3951713095,-6.29517658282,-12.671612135,0.860212423438,0.0212868071394,-1.15682799466,-5.97564039268,1.01920619464,1.13697091372,-1.92087149747,2.28008961609,-0.324426048772,3.18517538764,1.86275725441,1.66859149846,-1.02515386936,2.07682189806,-5.60888799055,0.719831519151,-6.84260124366,1.01915826908,-0.272214209796,0.497047059175,-0.973604019053,-0.202464865822,-1.22956286872,0.628855642728,0.726398089808,-0.317309513054,2.06180392728,0.830646381347,0.0283973398297,-0.790370894389,0.705096642482,-0.251246822321,0.369676809082,-0.899028988262,0.42033950765,-1.00361892532,0.326185857932,0.187429104906,-0.151093053485,-0.0937006639157,0.0941627686749,-0.426985936055,-0.0151271100287,0.26687163423,0.166808012036,0.377407733091,0.354027078331,0.454195646795,-0.0511429164441,-0.271943812785,-0.380966675754,0.286264009365,0.0817365796553,-0.172848294199,-0.00342650729516,-0.0720585818155,0.158714266157],[-32731.1573686,-2141.30906065,1306.93392802,-1735.96043458,2759.29745141,2271.05179549,-1388.30726339,-1371.9686064,-148.887387401,-726.547414122,-624.627220029,1290.72616551,-309.724024185,193.07097959,-100.095663202,130.438394635,56.9269036397,592.236389664,324.690764124,-397.460331888,105.931867582,-390.189014322,-222.032096686,-163.83874171,44.4137649013,-23.6048239247,-5.99900860018,179.875386796,3.07601781105,-39.8380189719,-213.893173366,-50.9784820508,-127.929845672,-24.3511922501,-12.8461016057,-3.1042768066,-12.0420137052,14.283538643,-11.2602442536,10.0932681544,30.2190203038,-66.8553853045,-63.1071326307,-39.1070013512,0.325771300095,-45.5397359,9.52225505878,19.5666098981,7.14026804846,-8.20682989217,4.19207725907,-0.413759465427,-1.1470554889,3.61011015433,-7.89666740637,2.30972085781,-6.6807149576,-6.23665703743,4.04859285935,9.26748109166,-14.5563232748,-7.8536511901,-12.658378899,0.613268639548,0.0436943203059,-1.0108852947,-5.91252323188,1.14096407127,1.41418856512,-1.98519436743,2.24616660775,-0.769304241854,3.1398168039,1.75316611215,1.5317011624,-0.368931125423,2.09091852169,-5.5856804244,0.529564855368,-7.28254888683,0.940854075143,-0.296929361635,0.522074774295,-0.933393288534,-0.130873920989,-1.15341151947,0.594959566417,0.775284304766,-0.3215123195,2.04193126017,0.629755371644,-0.0832707172989,-0.733837912503,0.745248936896,-0.0804179369496,0.276391300758,-0.868772524378,0.523353066558,-1.11360033828,0.311564078631,0.176173271746,-0.144261949926,-0.089158936103,0.114212873234,-0.400020983794,0.000316360928572,0.268724647628,0.163583361205,0.367458991026,0.301897258422,0.45552883351,-0.0829393187271,-0.280144998716,-0.379684335144,0.281545512759,0.152260649791,-0.202021415997,-0.0244516312213,-0.069695784291,0.173539147136],[-32719.2957585,-2240.0849482,1320.61300259,-1725.65381936,2785.20975711,2238.74267641,-1450.31380375,-1342.26661799,-113.890639392,-719.779013068,-654.272320855,1302.70349762,-296.457712917,193.178307319,-80.7095058362,142.215133219,80.9148595339,558.876080797,343.355809461,-426.425014778,111.897477173,-380.562073886,-197.078951228,-152.061399914,44.2013515629,-16.1078507888,-5.76171319872,177.399357642,-2.63435374429,-54.3503626779,-207.338445189,-45.5483954554,-127.130178697,2.32828428169,-0.429992602205,-0.78661055871,-12.2683148301,13.036937303,-5.57195260908,8.35147867427,28.4146022088,-66.873748767,-66.1992789299,-39.0962000149,3.35316243105,-41.9501031329,13.881156291,25.9542724334,7.20123672477,-7.75938634772,4.25340393473,0.0661609813302,-1.33526246383,4.18851130088,-8.99141353615,2.07866040486,-7.85230592499,-6.29482450568,6.14784012242,10.5361979252,-13.6811376828,-9.50443013158,-12.4419622976,0.377054965814,0.0991692442299,-0.876522140572,-5.81383041209,1.22746384469,1.68529441941,-2.04773982162,2.18769781283,-1.20076529568,3.06150860585,1.65673928576,1.35387265411,0.328212474559,2.10814685717,-5.50824271227,0.304272804686,-7.75180707035,0.860742536611,-0.314943837216,0.543768326023,-0.882241785995,-0.0659749211988,-1.07429981188,0.548636892173,0.808928714434,-0.317531636896,2.0065278984,0.430623337596,-0.205925962862,-0.665106015361,0.79055267862,0.0968405643821,0.175097817317,-0.841286164108,0.630118370754,-1.2282876481,0.29427726606,0.164745309642,-0.136572597491,-0.082659989265,0.131840846775,-0.369530175802,0.0139052018361,0.267406133747,0.160763271138,0.353796513057,0.249822731547,0.453258839772,-0.11158667404,-0.286366170895,-0.375003586982,0.277491460654,0.223690443826,-0.232184225647,-0.0515079555335,-0.0651267020613,0.188384113849],[-32731.461217,-2324.88088601,1325.60863391,-1705.85143297,2811.19229094,2208.54232698,-1503.02735504,-1318.27950599,-72.1817116643,-714.158279529,-682.505907447,1310.11886967,-281.666639279,191.05901841,-64.8781889123,155.116057064,104.633309479,524.809344713,360.035786268,-456.1842558,119.437777121,-369.60132468,-167.933467084,-138.613806101,44.3023027388,-7.84937002262,-5.8184657099,174.45344884,-7.7943471995,-69.6551855589,-198.114438758,-38.6368783015,-125.107833277,31.3522964629,11.465144242,1.8358307071,-12.4565385448,11.5754042007,0.335549718338,6.76844845427,26.0862109989,-66.3913244491,-68.9968280495,-38.4323303509,6.43405667968,-38.3609806652,18.3025949036,32.4285438396,7.28772468934,-7.21710919733,4.23988281283,0.548927722935,-1.57860272574,4.7537865547,-9.9991845457,1.80705668811,-9.03539739648,-6.24955405813,8.39755937915,11.6493869248,-12.7818943027,-11.2460081884,-11.9928535134,0.155603915943,0.186752359616,-0.754305411589,-5.67491118882,1.27442990517,1.94801714552,-2.10692594685,2.10330555006,-1.60947162776,2.94389395438,1.57360360154,1.1313549321,1.05365846307,2.12107431775,-5.37162654839,0.037839609926,-8.24090946799,0.779284249624,-0.325672732309,0.561982170955,-0.819951858873,-0.00869687887369,-0.991260487585,0.489220782866,0.82631226308,-0.304928438999,1.95333159531,0.236441424546,-0.339097792229,-0.58538819659,0.839021491489,0.275186721318,0.0645174491312,-0.816096265366,0.738366866716,-1.34549901121,0.274382123803,0.153195599103,-0.127885424733,-0.0742999005775,0.146677269799,-0.335381958353,0.0254065460719,0.262883906049,0.15801508779,0.336124739408,0.198293271885,0.446627207127,-0.136425720751,-0.290299075069,-0.366863367012,0.273461281509,0.294819936985,-0.263009724073,-0.0850881005958,-0.0581141230388,0.202818685601],[-32767.1885534,-2388.44534311,1330.94576147,-1674.73227697,2836.57061111,2184.06245949,-1546.17145502,-1298.04246475,-23.8323592845,-708.915053961,-708.126459982,1311.81575695,-264.071908881,185.467073957,-52.5677028417,168.868231405,128.11368756,490.034842122,374.463374588,-486.254823311,128.418182059,-356.92010245,-135.111985782,-123.576965284,44.7249066877,1.17270796678,-6.17439460554,171.044781158,-12.2552382235,-85.8267308697,-186.001475322,-30.5361441103,-121.718510159,62.34592567,22.6225002246,4.75106473001,-12.6076852956,9.89042291954,6.42859617036,5.36844438495,23.136236853,-65.3656756021,-71.5118543939,-36.9798579192,9.40115270399,-34.8004622546,22.7241011097,38.8789823842,7.39608144127,-6.58385831877,4.14426977464,1.02030911971,-1.88011288821,5.29930044005,-10.8936385696,1.47275747916,-10.2059234236,-6.10218630788,10.7891174518,12.5490625938,-11.8689157887,-13.0749130154,-11.2778698111,-0.0457754250522,0.30420259777,-0.644729082148,-5.49237412726,1.2779515887,2.19917847212,-2.16101973191,1.99112163101,-1.98542915576,2.77995449573,1.50346045904,0.859868913958,1.79270046174,2.12013911262,-5.16997888951,-0.276104814054,-8.73745701267,0.697063210154,-0.328453855526,0.576478518541,-0.746761851585,0.0401320596171,-0.903519248136,0.416476919037,0.826186432696,-0.283539916614,1.87973840273,0.0506867738503,-0.482157550566,-0.496302828883,0.887941847282,0.448262824808,-0.056648936666,-0.792589186934,0.845225432454,-1.46256796258,0.25198706383,0.141634332008,-0.118118689001,-0.0642178245679,0.158355923772,-0.297616473361,0.0346620107411,0.255106417527,0.154948319956,0.314069676195,0.147795558586,0.434763583578,-0.156794363295,-0.291647663891,-0.355270198702,0.268605970542,0.364131532218,-0.294108300557,-0.125678868284,-0.0483866437212,0.216336411545],[-32826.053789,-2424.07814862,1354.7594578,-1630.93855437,2859.62070704,2170.10642498,-1580.58020218,-1277.92223488,30.782742322,-703.569748444,-729.870644482,1306.33874616,-241.98899306,174.939504767,-43.0125836951,183.094731283,151.31682127,454.496759563,386.341362626,-516.034253827,138.592557638,-341.978725456,-99.3036003552,-107.057053021,45.4650118292,10.9299003672,-6.83142101093,167.197929862,-15.8822007242,-102.91610614,-170.811438632,-21.6039723747,-116.810346293,94.8202367629,32.8220000545,7.94166637242,-12.7229491423,7.98389844582,12.6591900819,4.17294609415,19.4640923776,-63.7725596046,-73.7576950246,-34.593748424,12.058489173,-31.2881936009,27.0685638558,45.1809804268,7.52321865759,-5.86579284773,3.96264124826,1.45997901336,-2.24213126231,5.81820052987,-11.6483863202,1.05113791709,-11.3371608537,-5.85272782132,13.3097750759,13.1701187639,-10.9500285251,-14.9851842163,-10.2610614717,-0.220724666627,0.448596695239,-0.547556239734,-5.26405347377,1.23518568912,2.43487339303,-2.208065259,1.84968971631,-2.31787999083,2.5632545794,1.44577510339,0.535612292803,2.52877678085,2.093765179,-4.89652024938,-0.643757615934,-9.2259671015,0.614605173383,-0.322415997544,0.587028554417,-0.663300698663,0.0800338713919,-0.810466096493,0.330779692991,0.807306155927,-0.253469906796,1.78315915313,-0.122656929518,-0.63395774198,-0.399764462353,0.93387030815,0.608667401925,-0.189602225311,-0.770026931785,0.947178978625,-1.57629881112,0.227190274008,0.130228651766,-0.107248852875,-0.0525799968223,0.166578362022,-0.256479293496,0.041635578693,0.244074922848,0.151127911021,0.287264330313,0.0989053897054,0.416755092974,-0.171973444637,-0.290112627151,-0.340262638422,0.261906994238,0.429757266627,-0.324974414236,-0.173747526668,-0.0356230880331,0.228349035896],[-32911.9509611,-2427.10015602,1395.99764287,-1573.24897319,2876.44642548,2165.09375407,-1605.92506261,-1261.94215761,91.4652669942,-698.356361189,-747.646211993,1292.70280398,-216.597646314,159.376118469,-36.5236943424,197.565216878,174.073568977,418.073562059,395.471392593,-545.521782311,150.179196571,-324.922000408,-60.949983962,-89.5182496847,46.5770725093,21.3878239221,-7.74553209419,162.96529969,-18.6518296808,-120.789011218,-152.643902015,-12.0474700947,-110.380845341,128.282203948,41.7888100476,11.3960736575,-12.7843368107,5.88984543077,18.9550963312,3.20476576638,14.9931147321,-61.6587887081,-75.6783985877,-31.1710182774,14.2489792023,-27.8594288822,31.2752037859,51.1964724607,7.66691793459,-5.0647502572,3.70007762762,1.83989928312,-2.65854505726,6.3035582283,-12.2410465256,0.530229294285,-12.4106992819,-5.47467745865,15.9331908541,13.4593387729,-10.0299936987,-16.9618582273,-8.90254339672,-0.362975722373,0.617904100582,-0.460827144606,-4.98891644409,1.1469318273,2.64945594986,-2.24477165885,1.68022228859,-2.59676957264,2.29478670721,1.39779509713,0.162934717461,3.24379668046,2.03221788099,-4.54228206677,-1.06929418478,-9.68698876821,0.531816094028,-0.306297163442,0.593462391518,-0.570316986765,0.111477067063,-0.711998603374,0.233864102491,0.768406214187,-0.215151557728,1.66221597144,-0.279269506532,-0.790600919871,-0.297779881968,0.974265336939,0.748505594224,-0.334414926606,-0.747091577242,1.040235847,-1.68266573473,0.199919072744,0.119140152778,-0.0953714677576,-0.0394835642239,0.171216189807,-0.212478161731,0.0466020289602,0.229728491454,0.14616516024,0.255395301254,0.052342349829,0.39207253409,-0.181130923281,-0.284864616861,-0.321715747767,0.252613582493,0.489655321501,-0.354772740948,-0.229539100644,-0.0193987387645,0.238251685931],[-33026.3623712,-2394.34550863,1433.26959368,-1498.6292887,2882.66944782,2161.05054819,-1621.96722839,-1262.53861478,158.528572956,-693.281445222,-762.510903997,1270.3675514,-191.913614857,139.653098273,-34.9895051405,212.178355391,196.389460211,380.603809368,401.852138948,-575.260008639,163.618347327,-306.804960808,-20.299174112,-71.9877009668,48.1345041032,32.5748914195,-8.85559632215,158.515187885,-20.6289268144,-139.160802339,-131.937955447,-1.92306833185,-102.680026597,162.260231381,49.157580765,15.086876365,-12.7471419409,3.66258065793,25.2476988755,2.49441665815,9.67523352422,-59.1422805806,-77.1515199497,-26.6795197077,15.8692873861,-24.5779567709,35.3055783347,56.7709135007,7.82067528557,-4.18221567404,3.36761736465,2.13215435725,-3.1135879369,6.75236496675,-12.6475485446,-0.0912971087,-13.420475926,-4.9093543221,18.6127160097,13.3804460563,-9.11364616596,-18.9781301681,-7.15900835891,-0.467296409572,0.808649732175,-0.381729475099,-4.66602971743,1.01711323233,2.83779960614,-2.26435712318,1.48629641847,-2.8116808973,1.98419696042,1.35333610026,-0.243256066635,3.91711553502,1.92914608518,-4.09566729471,-1.55419777677,-10.0965410872,0.448049180005,-0.279196558491,0.595536563903,-0.468837914362,0.135466195972,-0.607897795814,0.12940986306,0.708161396623,-0.168640962319,1.51677400919,-0.414510291323,-0.944702939576,-0.192731333175,1.00808577869,0.859419914341,-0.489837412782,-0.721725060842,1.11987657775,-1.77672548253,0.170053711746,0.108366885237,-0.0827148412614,-0.0251184429916,0.172154151083,-0.166270222499,0.0501552460709,0.211977470181,0.139979646641,0.218099659213,0.00906435975504,0.360703908753,-0.183397835822,-0.274320531614,-0.299332629694,0.240342777051,0.541665570879,-0.382254156328,-0.293032063549,0.00084311271568,0.245425654884],[-33169.5774874,-2327.65716524,1463.07744315,-1404.03057307,2873.08394808,2152.99809088,-1631.88972707,-1289.86215802,232.116381847,-688.177578635,-775.198311803,1238.33396064,-171.079885272,116.219183439,-39.4432049641,226.79130843,218.408157059,341.992962709,405.481470607,-605.49507032,178.923158475,-288.591757702,22.0342869313,-55.6088134395,50.1895424455,44.5459238947,-10.1451448379,154.121246818,-21.8681561473,-157.755576872,-109.201580617,8.6080460249,-93.9903006766,196.134653701,54.5171183564,18.9602392055,-12.5535614074,1.35058964084,31.4688169252,2.07288467891,3.4635864234,-56.3656032187,-78.0715608507,-21.0869765691,16.7808218883,-21.5037495607,39.1028884258,61.7352310706,7.97340060543,-3.2250016838,2.97626097037,2.30909377679,-3.5898777486,7.16247911626,-12.8392478262,-0.82424535925,-14.3564590157,-4.09744369941,21.2924756493,12.8909591675,-8.20632191983,-21.0015767898,-4.98735718886,-0.528809250074,1.01456199201,-0.307477707315,-4.29500990814,0.85004838636,2.99589039783,-2.25870692158,1.27139041995,-2.94974555193,1.64189946799,1.30624292456,-0.66643148899,4.52526890177,1.77693302158,-3.54404476067,-2.09840549942,-10.4266890444,0.362551194816,-0.240699827415,0.592981624209,-0.360361648397,0.152871242373,-0.497499723401,0.0222896056332,0.625359846986,-0.113917376637,1.34670669821,-0.522726273985,-1.08795402162,-0.0874220553017,1.03361144317,0.931843945142,-0.654315791974,-0.691755107832,1.18067288895,-1.85280662413,0.137591646288,0.0977978201571,-0.0695713563921,-0.00982531263979,0.169212690389,-0.118603942701,0.0530062107068,0.190921564179,0.132589259836,0.174951341176,-0.0296869130683,0.322632281694,-0.177882670942,-0.256862521762,-0.272880057614,0.224607592168,0.583191697982,-0.405929899602,-0.364098621525,0.0257287009099,0.249162155324],[-33341.7754895,-2227.76626072,1503.28260569,-1289.05096687,2843.64615825,2140.49594,-1639.83977691,-1349.37707184,311.147478845,-682.793286009,-785.751599238,1195.81045576,-155.671840275,89.5669709957,-49.6545217542,241.016977816,240.21080088,302.312055868,406.395088411,-636.001699905,195.842933665,-270.99196294,65.093739026,-41.5435212158,52.7558836225,57.2991264519,-11.6591265875,150.135935043,-22.4003209178,-176.277202526,-84.9629946814,19.2826023026,-84.5794962142,229.124442825,57.424512432,22.941534142,-12.1515744158,-1.01138685809,37.526663663,1.97191080348,-3.69441962918,-53.4928832309,-78.3502411324,-14.3542559319,16.8068740752,-18.6868445294,42.5879623437,65.9077881362,8.11206205513,-2.20740697656,2.53342360887,2.33902661873,-4.07017624184,7.52615618584,-12.7844115522,-1.69167507691,-15.2046439425,-2.98069415463,23.9080994192,11.9416039667,-7.31228852284,-22.9917457731,-2.3451926665,-0.542166634913,1.22717068535,-0.23620670662,-3.87663395315,0.649693022529,3.11889061273,-2.21952191077,1.03773021494,-2.99633775815,1.27846081574,1.25051514156,-1.08851569484,5.04194934184,1.56725603333,-2.87387315534,-2.70016571253,-10.6452331467,0.274709732454,-0.190617455374,0.585370696432,-0.246690771633,0.164142775015,-0.37997899604,-0.0815819529098,0.518420006667,-0.051316337371,1.15179953859,-0.597506436022,-1.21102387113,0.0147676886061,1.04859544836,0.954949782295,-0.825855697185,-0.654836199122,1.21628306758,-1.9043436781,0.102681581418,0.0872584679381,-0.0562799591508,0.00598916328933,0.16204859255,-0.0702786919425,0.055953207483,0.166784082797,0.124030188875,0.125447090866,-0.0625089679333,0.277866270263,-0.163771735314,-0.230796996227,-0.242207518668,0.204871631773,0.611210425602,-0.424043858313,-0.442392511231,0.0559355676088,0.248668870262],[-33541.6160185,-2110.1238756,1584.79116666,-1154.06060189,2788.45950556,2125.92277017,-1653.59334555,-1442.80452183,394.068746769,-676.973319911,-793.63954406,1141.25658818,-146.330998282,59.8424725224,-64.6658494174,254.509681248,261.997356644,261.939419144,404.447182224,-666.262384094,213.642841969,-254.767928081,107.440788985,-31.1213081961,55.8599719632,70.8671852704,-13.4693847591,146.991583595,-22.275004767,-194.457105031,-59.8808596979,29.6858203928,-74.7913510428,260.268376807,57.3839289778,26.9358653027,-11.4662208059,-3.38650814505,43.3127956626,2.22741419122,-11.8664552435,-50.7390194849,-77.9269005663,-6.47764954433,15.7318777803,-16.1819829759,45.655072641,69.0949315758,8.21802929568,-1.14524772047,2.04609703454,2.1929559661,-4.53202349997,7.82877253952,-12.4518167392,-2.73098562888,-15.9589839675,-1.50124777401,26.3778830237,10.477422072,-6.435243566,-24.897971597,0.808469841203,-0.503531198884,1.43657435123,-0.166587916773,-3.41117025916,0.421806121619,3.20177645049,-2.13809465194,0.78630521477,-2.93730807646,0.905359264977,1.17759949345,-1.488925407,5.4371137119,1.29172158972,-2.07081847008,-3.3557761165,-10.7155981292,0.183483561173,-0.129203672814,0.572011508958,-0.129506962257,0.169861272797,-0.254050577639,-0.174547571486,0.385392730947,0.0182977731618,0.93204062446,-0.632500107941,-1.30310507653,0.109295249771,1.05045326284,0.916541967131,-1.0019152438,-0.608486096049,1.21947785515,-1.92374074584,0.0655083685953,0.076308623269,-0.0433328462036,0.021888298333,0.150225958279,-0.0220456700564,0.0601122967695,0.139956584849,0.114515115108,0.0690598711522,-0.0879786982003,0.226572337558,-0.140557603146,-0.194297067891,-0.20735117538,0.180596776643,0.622241877115,-0.434528990212,-0.527247040866,0.0922145642971,0.243075648207],[-33764.3065351,-2025.61214699,1736.4478671,-995.374281786,2697.9872901,2111.84143256,-1688.45233504,-1566.31941129,480.241986371,-669.722556786,-797.767373075,1071.71542711,-142.610621582,25.027060473,-82.433351573,267.173990499,284.571963524,221.840258032,399.38855913,-695.498178113,230.480725503,-240.643787697,146.637838664,-25.7158289952,59.5000378872,85.3771347548,-15.5883811424,145.307281422,-21.5920710788,-212.127731419,-34.7533210249,39.0585453559,-65.0473612446,288.336699156,53.8913446561,30.7980273663,-10.4149009604,-5.70865312258,48.7168559255,2.87726916245,-21.1215401898,-48.386508334,-76.8011682602,2.48383602819,13.2775250608,-14.0333567296,48.1501931623,71.114349794,8.26105085772,-0.0647993017763,1.52404089387,1.84357561685,-4.94500164132,8.05717484466,-11.814413931,-3.99368045047,-16.6329335736,0.394693435943,28.6015571221,8.43057493434,-5.56763321776,-26.6601147142,4.51752048011,-0.411118960053,1.63012338529,-0.098436114916,-2.90126271084,0.175147648962,3.24137101315,-2.00616636777,0.519381143154,-2.761423448,0.536490561891,1.0748902107,-1.84577534095,5.67946238114,0.940790749851,-1.11755091425,-4.05945725488,-10.5956532537,0.0875416205216,-0.0569937627634,0.551439263368,-0.0110731405626,0.170914628628,-0.11797395364,-0.246841021097,0.224650106497,0.0935538898258,0.688635028166,-0.622143815546,-1.35174570634,0.190589839965,1.03566224016,0.803713225584,-1.1793992562,-0.549494642718,1.1823928617,-1.90188491659,0.0263295463552,0.0643327487508,-0.0315749295646,0.0373660799626,0.133211977748,0.02528757332,0.0670269049189,0.111099526352,0.104737517991,0.00548619580558,-0.104732068242,0.169239325815,-0.108141467682,-0.145617369593,-0.16853856761,0.151244354416,0.612484502351,-0.434866050405,-0.617375646738,0.135458985697,0.231495397996],[-34002.1168778,-2034.1920569,1946.79035183,-809.476384448,2565.35478283,2092.36899512,-1754.24684229,-1717.93125041,568.632685024,-659.230347831,-797.739995095,987.00120032,-146.025959088,-15.2036959223,-101.083281253,279.105637225,308.997170993,183.750796635,391.461588842,-723.386215937,244.950197114,-229.888028015,180.051188641,-26.6562699223,63.7113361323,100.920692677,-17.8836228894,145.887796323,-20.6028796995,-228.829071118,-10.6767883189,46.7023129932,-55.83178611,311.997844946,46.4651318593,34.3529086391,-8.91947334677,-7.85621597024,53.5762553883,3.9742323056,-31.4776348044,-46.8214355747,-74.9025010049,12.4021102928,9.20103652694,-12.2509790385,49.9010823488,71.8122879967,8.20339999575,1.00159738281,0.983174526587,1.25431303424,-5.25979055144,8.19168781468,-10.8519110514,-5.52114352672,-17.2619531,2.79005498151,30.4689640688,5.74302338855,-4.68099203238,-28.1981201312,8.83141151553,-0.265966028148,1.79519648281,-0.0330056734487,-2.35379206869,-0.0753548470159,3.23096383049,-1.81626607942,0.242246849399,-2.46088777983,0.196375812257,0.928622563355,-2.12651530989,5.74010191222,0.509889596107,0.00933237314595,-4.80164128314,-10.2362464903,-0.0152113116329,0.0256110603571,0.521207736604,0.106085823124,0.16890633937,0.0290221386629,-0.285968620495,0.0339190781727,0.17232300036,0.425337969687,-0.561224988842,-1.34015910106,0.253059278909,1.0021268102,0.604457947455,-1.35360180518,-0.472732036809,1.09689484484,-1.82754467332,-0.0146443865156,0.0504319488242,-0.0223209704838,0.0520077367916,0.110381016932,0.0707223827293,0.0788541920123,0.0807727916226,0.0958901978165,-0.0653631552508,-0.111448388742,0.107185743805,-0.0666817124386,-0.0824336527452,-0.125732822392,0.11679461926,0.578420780535,-0.421848725414,-0.710375328424,0.186730324822,0.213130816347],[-34242.5542771,-2181.15150045,2178.05940433,-599.041799861,2392.09804522,2057.88324516,-1849.91824421,-1892.29313496,655.69348931,-643.087535947,-793.43201508,891.45744121,-158.604171929,-58.0487971684,-118.930378448,290.327134536,336.181880304,150.209616066,381.484313075,-749.784849567,256.534160472,-224.262625257,205.137555632,-35.3313128253,68.6211448793,117.412492173,-20.1489976776,149.705554539,-19.7000722801,-243.729014,11.0399513287,52.0902893833,-47.7182899418,329.887319344,34.5653743236,37.4249541331,-6.92132577491,-9.67094802951,57.6519101754,5.57547484541,-42.9012882665,-46.5080050023,-72.0672256716,23.0885183131,3.32740890756,-10.835076564,50.7250196758,71.0414633055,8.00764916677,2.01830357943,0.443124480347,0.378453595232,-5.41417459138,8.19950452534,-9.54561537,-7.34603022689,-17.893970404,5.80208419521,31.8587951282,2.37306976359,-3.73545768331,-29.4075104709,13.7960641268,-0.0714502029394,1.92164201753,0.0277328052278,-1.78043902892,-0.309950898942,3.15895324588,-1.56350132107,-0.0384223852551,-2.02770336171,-0.0802577948468,0.726881187932,-2.28582312146,5.59054673511,0.00141205695464,1.33567514511,-5.56905603781,-9.58359875305,-0.12768198479,0.118876661249,0.47846138336,0.219216274256,0.166072302925,0.186468590713,-0.27734343562,-0.190340954902,0.251978381861,0.148107096604,-0.443789432555,-1.2469286142,0.291144347645,0.949612851008,0.306949261189,-1.51826594599,-0.372247967308,0.954521534501,-1.68777028239,-0.057328033219,0.0334952601566,-0.0172782695657,0.0654850579461,0.0811538302238,0.113043003394,0.0981661684598,0.0493946913038,0.0895173041259,-0.143495733485,-0.106658310481,0.0425442234502,-0.0164516788214,-0.001803371215,-0.0786997879234,0.0777551854215,0.516555228075,-0.391651365456,-0.802900826943,0.247190758904,0.187143103595],[-34472.1329739,-2491.83335255,2405.67438376,-376.554944961,2191.14799975,2005.78092545,-1967.29489791,-2063.48944275,734.029554648,-618.034647113,-783.70682446,793.283683838,-177.554907413,-100.227407698,-131.522524935,300.394708657,366.830305509,124.619991659,370.706671304,-773.651549675,264.539767072,-224.839471533,218.550303045,-52.8490680311,74.3565048177,134.460480882,-22.200488458,157.963112382,-19.3404034457,-255.858228453,29.2366712249,54.4744519896,-41.2275476899,340.407416705,17.5953280745,39.8206543518,-4.43637197914,-10.9911316666,60.6323692636,7.71090363322,-55.3287718798,-47.9246360251,-68.1465051939,34.3404816085,-4.54507604094,-9.76790298094,50.3727746728,68.6467095972,7.64030787131,2.92957867011,-0.0802572006164,-0.841767414924,-5.35347239804,8.03970535557,-7.87373751289,-9.51297782519,-18.5757738247,9.54904070599,32.643445664,-1.73209801549,-2.68566375288,-30.1681600945,19.4434858791,0.169574077735,2.00012414061,0.0803218155251,-1.20138991005,-0.509665556971,3.01232257346,-1.25034188599,-0.315133558838,-1.45050504337,-0.256233443502,0.462803123158,-2.27574004434,5.20170102195,-0.581246132696,2.88502173397,-6.34638824281,-8.58268778011,-0.252446112144,0.224315164575,0.420249921238,0.324249192363,0.164266754276,0.353243811932,-0.206017742941,-0.452100869422,0.329458250631,-0.135592735465,-0.262387249021,-1.0487904023,0.299410874769,0.876931870534,-0.101844862277,-1.66686039617,-0.243057687346,0.746345514372,-1.46857298601,-0.101547347048,0.0126046015448,-0.0184650202536,0.0773936451674,0.0450522811027,0.150763649201,0.12743768981,0.0176522438149,0.0873662160949,-0.228653579956,-0.0885928725115,-0.0221879074993,0.0422815064834,0.0988920389062,-0.0274123389564,0.0345850324981,0.422768167391,-0.340048434024,-0.891035762334,0.318079637988,0.152457556722],[-34679.3784784,-2917.50459331,2621.38526939,-175.852628379,1998.09096431,1941.58656286,-2080.05905553,-2177.68526503,788.254281593,-580.672979526,-766.966730561,707.986933766,-193.849834218,-135.887160847,-130.103918654,307.663190882,400.534172693,111.050873436,361.135237802,-792.993027344,268.909922886,-231.527809234,216.379112642,-79.5429051866,81.0433873735,151.010158519,-23.9717542683,172.029830352,-20.1555032249,-263.930768875,42.9894416249,53.0208788644,-36.6554998266,341.743409079,-4.99594151708,41.3690106996,-1.61403705714,-11.6696969241,62.066892922,10.3440961482,-68.6530599444,-51.5777137508,-62.956061742,45.9776803786,-14.6196314972,-8.96146336827,48.5192329815,64.4816979683,7.0893567035,3.66038776876,-0.575173304391,-2.48891070582,-5.04116072979,7.65409484121,-5.82044397089,-12.0707239167,-19.3505097161,14.1579544166,32.7041405515,-6.63507047966,-1.47006712782,-30.3441489372,25.792342554,0.457884794241,2.02698266626,0.121022319283,-0.647533470717,-0.656844815019,2.77264476751,-0.891638461792,-0.579394580076,-0.716733815298,-0.289862265011,0.137587205274,-2.04441604973,4.54783999623,-1.23345514775,4.68039226215,-7.11663946896,-7.17788579582,-0.391733645258,0.346114832719,0.344099073003,0.416347619907,0.165292712313,0.526670784892,-0.0572830862371,-0.756449999256,0.399982092649,-0.416179391658,-0.00846947103645,-0.720075599298,0.273400313012,0.781917600635,-0.634838849032,-1.79297245907,-0.0808699442707,0.463023365828,-1.15492778596,-0.147238148442,-0.0128288159321,-0.0281592737924,0.0875342904568,0.00192883755535,0.182076992696,0.169056875933,-0.0136707091859,0.0910982476497,-0.32024098185,-0.0555124578688,-0.0839143444971,0.109236471032,0.221917417721,0.0282188886886,-0.0124384447183,0.292585575183,-0.262532520719,-0.970146258799,0.400704929826,0.107746426275],[-34858.7740954,-3265.80798403,2823.85454579,-65.8573121594,1885.6469411,1876.10971146,-2128.95266754,-2150.74475612,789.845855361,-528.043403107,-742.516942697,663.145314134,-192.533443418,-153.007695455,-100.709610962,308.271782282,434.696121886,113.883753886,356.175155257,-805.203792009,271.721664232,-242.887755826,194.803243808,-114.497345236,88.770053912,164.92490274,-25.6155270299,193.399387375,-23.1123141804,-265.971685831,51.6065993518,47.1371470868,-33.892226894,331.934936413,-33.5799133029,41.9693153321,1.19011834792,-11.5890567299,61.289299372,13.333652931,-82.6784723682,-58.033757734,-56.1653011206,57.8836136485,-27.0439895479,-8.19479052342,44.7716746632,58.430139246,6.38667087769,4.11641997213,-1.03316674816,-4.68954250676,-4.46570116075,6.95764679056,-3.38724452141,-15.0500669498,-20.2536464278,19.7839245945,31.9491350991,-12.3969865382,0.0025160188135,-29.7811888849,32.8513808402,0.802195080855,2.00942975252,0.147025749216,-0.163628917373,-0.734189810724,2.40961414902,-0.518836460761,-0.820200514658,0.184866337449,-0.129625200109,-0.236126264614,-1.53139062446,3.61147846369,-1.94708235046,6.7476047377,-7.86091398934,-5.31282042815,-0.547306584007,0.492653878956,0.248580613958,0.490459639831,0.171504175701,0.700641847931,0.183044024738,-1.11061756032,0.455495395702,-0.680764407019,0.327107868639,-0.231150745775,0.210609638068,0.662464362943,-1.30276690797,-1.89022840622,0.118743704581,0.0949415795486,-0.730708446564,-0.19466506078,-0.0429228610381,-0.0488263509133,0.0962566074819,-0.04782179126,0.204615736774,0.225402273154,-0.0441084215562,0.101888311987,-0.41723170644,-0.00611501079006,-0.138455784887,0.184083602555,0.369531835717,0.0888281660358,-0.0631614567957,0.121721652551,-0.154400304841,-1.0346325432,0.496434178797,0.0514862760349],[-35011.2358435,-3342.47982974,3017.21825367,-81.1714597498,1910.685897,1821.13366221,-2073.7155609,-1940.20102595,728.533291158,-461.726596907,-712.052202926,676.499848718,-161.519403485,-145.609472147,-36.5440114722,300.320129366,466.558408091,131.616734542,357.764618842,-809.000223912,274.294484336,-255.005804443,153.60555243,-153.938745811,96.730151701,175.130490817,-27.4984849113,222.313243449,-28.7242125016,-260.721390809,55.0879799012,37.241358777,-32.2370359789,310.887679629,-66.4193597572,41.8032009394,3.6329893922,-10.8207360148,58.193415926,16.5789875125,-96.8327681864,-66.963615359,-47.834044642,69.6626462213,-40.9837677098,-6.87073880881,38.9198407711,50.8846766068,5.70738062511,4.21888587336,-1.49294923135,-7.4413834648,-3.65831375685,5.95997040958,-0.520373803039,-18.3975621207,-21.1826701477,26.1977252627,30.3332855046,-18.7640717523,1.945152935,-28.4170914123,40.3057845424,1.23849706742,1.93870483373,0.169611259222,0.240161200357,-0.778631118492,1.90005649287,-0.140178652852,-1.03496315674,1.22667572822,0.198725488844,-0.600762835804,-0.789351655344,2.42840958849,-2.67413295361,9.07869030759,-8.50559415521,-3.12230554024,-0.718863486751,0.673710117469,0.131276097059,0.5361004927,0.17600933351,0.879961859071,0.518359587012,-1.52107161256,0.487155479196,-0.92269746919,0.736993000404,0.411120524418,0.126706594404,0.527459501254,-2.09783435467,-1.95820769883,0.344073038301,-0.341788938928,-0.197511748923,-0.244242840335,-0.0763794710151,-0.0812299239188,0.102874711555,-0.104103765462,0.212593804112,0.292710620328,-0.0709397975253,0.121107419114,-0.522327518698,0.0589050881306,-0.181649389282,0.267036312628,0.541840836187,0.157101685033,-0.112516142878,-0.0872092758328,-0.0161652818599,-1.08568844237,0.603334205387,-0.0137505111089],[-35139.0481845,-3432.42874875,3176.22175587,-44.7308398611,1961.14642211,1759.68431828,-2032.22475145,-1717.60508579,689.630630876,-395.404323664,-682.996148114,700.20681702,-120.731718301,-145.412815261,32.776339339,295.482273606,500.060299327,145.645830707,359.316306849,-809.811169884,269.554661747,-263.234709373,103.475557577,-190.000536316,101.834579671,187.312032105,-29.7962249712,254.812962864,-35.0095864556,-251.166899886,54.5561666285,26.2583810599,-31.3215628518,284.829947024,-96.2815678981,41.6176667469,6.11855212672,-9.81102089376,54.9769661735,20.4626771801,-109.744601578,-75.2787196944,-39.5746171776,79.7949043359,-52.8064540871,-4.00350164286,31.6483254853,43.6376838209,5.48530398214,3.99814826969,-2.10312647812,-10.2247611603,-2.67187505406,5.04026756791,3.03830178942,-21.8368863021,-21.6782906736,32.0159080405,27.8567918726,-24.5272792854,4.74303460378,-26.4788882697,46.9241340544,1.84895622882,1.72806982042,0.233728367293,0.692482068302,-0.974615486187,1.27938792704,0.360209833029,-1.24254525785,2.27273204095,0.432398968762,-0.801864854182,-0.212887513986,1.16129732765,-3.24575857221,11.5348829546,-8.82196440829,-1.30094943582,-0.90186661823,0.888921934627,-0.0164867877979,0.528291505313,0.143414111311,1.1092121103,0.924501401862,-1.98400801007,0.495688116661,-1.15905577509,1.16677521298,1.08683874931,0.0836931781114,0.421677452316,-2.96537682549,-2.01193453368,0.53460177478,-0.754166292086,0.386488608202,-0.296025633409,-0.109240245308,-0.12052200519,0.101428155584,-0.169350598813,0.191777262733,0.349569855679,-0.0841435422393,0.152585281758,-0.649649545845,0.135224639637,-0.21143532662,0.360032575974,0.734392431088,0.239903886524,-0.140136853001,-0.312105762749,0.135343432659,-1.14665732068,0.709814650174,-0.0730738080707],[-35245.5613977,-3547.53250992,3342.87444189,42.6906844758,2039.81498207,1672.91580025,-2008.58558591,-1450.39987372,673.042421688,-329.875941199,-660.401028376,737.384464444,-71.5448064685,-161.905434781,123.743233955,294.155522524,533.926803791,155.941206849,362.081292336,-808.318789159,256.757606565,-269.21201781,45.7844910299,-218.201907945,103.335302834,202.061086234,-32.7621273371,289.493895739,-41.115083301,-237.491095518,50.3963345154,14.4183006781,-32.6178829829,255.14650669,-120.7632743,41.3198451291,8.62010357452,-8.44527981937,51.7116373934,24.9922680511,-121.354829955,-82.5654971916,-31.7084438332,88.0224618711,-61.9621654288,-0.0948085040434,23.526127814,37.2574790717,5.78025093838,3.38398954321,-2.86384885194,-13.002195553,-1.49639972917,4.26180989477,7.2780462592,-25.2688829595,-21.6585855412,37.0781870446,24.6220774867,-29.418141651,8.18105607401,-23.8097501729,52.507759868,2.63723531532,1.36457885744,0.321191711723,1.17532309645,-1.33721993011,0.543163746604,1.00171129241,-1.40789784644,3.30083682031,0.573791275773,-0.781245248664,0.15071100268,-0.1401714573,-3.59921622292,14.009813827,-8.75458209658,0.0522613749312,-1.09352566999,1.13556058323,-0.197919583545,0.464730148933,0.0628618892607,1.38302883818,1.4062906291,-2.4938772414,0.478080296561,-1.37506355175,1.61943150474,1.79005365294,0.0935269748142,0.355365080932,-3.89158318761,-2.05343249717,0.678443881351,-1.12701994996,1.01057456133,-0.350275384806,-0.140695991143,-0.165313068058,0.0886975238512,-0.244747477927,0.138179170168,0.391549237334,-0.0821017918058,0.196461547546,-0.798403192614,0.223798989303,-0.223374666466,0.462432616943,0.949779056562,0.338604864646,-0.143579653823,-0.54861410359,0.293636484423,-1.21651848192,0.81447789483,-0.12501365662],[-35330.2474562,-3630.20163313,3455.06578858,168.515489966,2145.6630869,1572.03473871,-1983.69383773,-1158.30472302,675.23129724,-268.075546289,-649.940356183,790.604643845,-6.76481142153,-196.132929764,243.524728369,297.36385592,564.762310246,160.962064099,367.202678653,-806.06411963,235.204019215,-271.44772706,-16.3858391788,-233.256471011,100.953914862,219.754357196,-36.6675841493,323.848684476,-46.3316517463,-219.320985376,42.7889165278,1.34540153568,-36.7508956932,223.325385857,-137.103710811,40.9714680141,11.1800407936,-6.53543251263,48.4183890542,30.0865278658,-131.887920482,-88.4328699552,-24.2260356781,94.2548010802,-68.2390815953,4.26782346171,15.442739334,32.3471814956,6.67661765784,2.36055464023,-3.76634883143,-15.7047335562,-0.146945000437,3.66716484984,12.1518103972,-28.632429258,-21.0905843283,41.3089836277,20.8368648601,-33.2365487787,11.9119240523,-20.1005834256,56.9168131337,3.59538983948,0.859291114611,0.410625109534,1.66873069352,-1.8775120163,-0.302965374486,1.78730163078,-1.50157401142,4.2859020423,0.631535077027,-0.498288447344,0.284258824731,-1.38609890227,-3.68605822528,16.3430638801,-8.24501943628,0.88302915218,-1.29452313523,1.41114660868,-0.415408685704,0.348887350303,-0.0742696359983,1.689298677,1.96548763884,-3.04032029536,0.426948497759,-1.55519595903,2.09954627577,2.5143660205,0.163342404912,0.339944537318,-4.84883478577,-2.08742630654,0.755847324429,-1.45293610004,1.66062938659,-0.408342507091,-0.170903859959,-0.213807471168,0.0622006031392,-0.330729971284,0.0489490395146,0.414903328009,-0.0651375014277,0.251137074861,-0.965897212861,0.324462931089,-0.213335188774,0.573458770451,1.18883625365,0.451833109519,-0.121214390832,-0.790446439575,0.450807578644,-1.29328120427,0.917015718864,-0.171196583127],[-35390.0552288,-3583.90914403,3582.59068487,304.483607416,2265.15480118,1463.49723813,-1929.07791847,-871.406815645,689.484591543,-220.721611805,-656.300372614,862.396907442,60.3342142141,-241.846828193,377.530222113,305.240580692,588.776950897,157.331926988,371.517906761,-803.179768771,208.527389855,-273.167617425,-76.3704512217,-234.075910642,95.0244934253,239.996578917,-42.2534764539,355.149591043,-49.9485501001,-197.551869073,32.6673663958,-12.3008612561,-43.1929231648,190.680483536,-142.792881897,40.9882808917,13.8048790295,-3.7010925065,45.0562003339,35.3623009358,-141.800386528,-92.4299727778,-17.4039113991,98.5059427725,-71.576752757,8.98615798457,8.12798341074,29.6849644102,8.28048605155,1.03173478085,-4.75046950108,-18.2972660375,1.35443945226,3.30628165832,17.52399998,-31.9431039492,-20.0017720593,44.6380034693,16.7041661759,-35.8525750316,15.627697899,-15.1259243817,60.0652179755,4.70081784443,0.255464071579,0.472017709398,2.16622964628,-2.58811360196,-1.25782508943,2.69846152693,-1.50026894691,5.19643377256,0.626764202927,0.0728300919114,0.205407832245,-2.46801095154,-3.47654634512,18.3347054613,-7.26357255412,1.17028332243,-1.50935114867,1.71469501945,-0.67057157904,0.191870484277,-0.273527241944,2.01592282017,2.60138401647,-3.612918584,0.331075244951,-1.69053552648,2.61328956845,3.25709686303,0.298689000938,0.387615464002,-5.79486200161,-2.11282333094,0.737231127567,-1.73247901063,2.32044101367,-0.473358441113,-0.200605914979,-0.2636603591,0.0206396265898,-0.426664744942,-0.0773949990644,0.416705552843,-0.0329484864692,0.312897275424,-1.15006294662,0.436547820516,-0.180322601577,0.691259509943,1.45229170585,0.577134354844,-0.073390923672,-1.02922469781,0.600163355881,-1.374319692,1.01896767809,-0.214676962394],[-35418.5156937,-3492.96870961,3775.91223527,426.779288653,2378.51899999,1345.52795672,-1858.10522227,-641.398153915,709.595645413,-193.403166129,-684.320283934,945.820772759,103.816976663,-288.501073657,508.149737723,316.814806599,604.093724316,141.095780441,370.861409603,-799.132278868,177.920080811,-279.907482404,-125.43370375,-219.954044955,85.8662332847,261.890537829,-50.1824346069,381.344592331,-51.7008518993,-173.980400934,21.0058436898,-26.2779779981,-50.484168369,158.358130434,-136.994897049,41.7796699741,16.4242751222,0.416090429683,41.5377824239,40.3547360978,-151.497644802,-94.2852912825,-11.7414867415,100.619923513,-72.0666733102,14.2615910114,2.17951998719,29.6215634964,10.6716997813,-0.497271376595,-5.74690455168,-20.7458584422,2.98279056411,3.21437143521,23.225416503,-35.3150371466,-18.4782116932,46.9797117315,12.3611844185,-37.163815786,19.0876470518,-8.81980426005,61.7756477991,5.92752143042,-0.405350132477,0.47899757423,2.66367170404,-3.45060452685,-2.31565025942,3.70974436011,-1.39851439169,6.0114824114,0.560415963839,0.960263364612,-0.0498604303267,-3.28867971744,-2.96759729756,19.7914081604,-5.82094157148,0.909448270509,-1.74119620728,2.04434770493,-0.964217839868,0.00354077399365,-0.536592670014,2.35352975794,3.31147434171,-4.19703971295,0.179347558592,-1.77831951832,3.17506437251,4.01163569355,0.507968867558,0.50957109507,-6.68122014177,-2.12602751645,0.600076690679,-1.97434681586,2.97843845,-0.547927632772,-0.230611298279,-0.312281243874,-0.0371299577672,-0.531380464849,-0.241816982452,0.394914437049,0.0169316573228,0.376353009773,-1.34850754188,0.560185629298,-0.124212558346,0.81533287534,1.73961586351,0.711318340397,-0.00106646873189,-1.25482776071,0.737956981527,-1.45341203052,1.12077967095,-0.256560159308],[-35410.3085264,-3441.26019604,4143.30147665,529.352674191,2457.57474781,1239.79613058,-1753.33290386,-429.306917585,733.538440483,-184.887748535,-732.781284836,1024.75565,121.519009596,-309.62846464,637.305637898,330.22480186,612.477220459,110.890170958,363.735296314,-791.404109535,143.648865944,-288.218007287,-152.821060474,-198.960023414,73.8004904408,284.116917739,-61.0789971003,402.532455555,-51.7292337829,-149.782194814,8.85026845579,-39.6840245211,-54.2857115114,129.73629511,-125.361426833,43.6666917275,18.9389481429,5.88923467788,37.5543041595,44.5465288358,-160.740269924,-94.0423018879,-7.35756650811,100.170447976,-69.8361458413,20.9565253144,-1.31975883786,30.7893353272,13.8626276919,-2.12236105769,-6.70528427085,-23.0551165377,4.70504228495,3.36299695697,29.0386084914,-38.8084238945,-16.6875252861,48.3117991771,7.76886833387,-37.0954418132,22.1403791215,-1.35114037875,61.6431298894,7.24707225769,-1.10154944155,0.410398916925,3.16898908323,-4.44342111033,-3.48662711478,4.80141399961,-1.21518612257,6.72536747157,0.405595131495,2.16917879745,-0.433900877753,-3.82304588647,-2.16778821603,20.5984943062,-4.04547370315,0.10237179818,-1.98916695273,2.39549338944,-1.29447945313,-0.211671374108,-0.865014136237,2.69739727359,4.09317117503,-4.77927254223,-0.0389056130914,-1.82152809505,3.81490806058,4.7489737995,0.798502972225,0.711844033096,-7.4687349318,-2.11762674507,0.347423502793,-2.21720075836,3.62795439424,-0.63418320231,-0.261101997391,-0.35626545359,-0.113105110268,-0.642970411837,-0.444705182124,0.347297270888,0.0879303010768,0.435245327523,-1.55673397973,0.696193868698,-0.045024052779,0.950941173335,2.04480202892,0.849043435642,0.0928781663178,-1.45720955898,0.868497504376,-1.51996487876,1.21727708146,-0.295608805562],[-35361.5005612,-3341.57886842,4419.49259513,609.415955393,2464.4464176,1148.85752598,-1614.31993819,-233.208141506,760.643074469,-196.466467934,-789.864677172,1083.80556741,132.318287295,-312.912079363,761.880277853,344.316589743,616.066189279,69.4301223181,350.562914649,-776.945101956,108.625514594,-291.82171565,-162.731077354,-182.81410982,59.5180047387,305.233181482,-75.4094290321,419.876695636,-51.0839950018,-127.020773534,-2.3582760272,-50.4887029819,-52.3410073165,107.185117228,-114.78332748,46.732064005,21.3463720123,12.5398084524,32.6717095115,47.6868853128,-169.151440152,-92.248005518,-4.5060718906,97.3036043405,-64.6836755563,29.6303580339,-1.27996359696,30.9665485015,17.8280485568,-3.7358207831,-7.56250459695,-25.2753609356,6.55433376319,3.74402113542,34.7300264629,-42.4213687895,-14.8938852733,48.5212004882,2.99532487915,-35.5402668241,24.6791472132,7.04338821994,59.365511176,8.63930696756,-1.81328878228,0.245715121007,3.69506338105,-5.5447007926,-4.78689000017,5.98717939669,-0.960137446189,7.29075997572,0.110038953561,3.67364419499,-0.91786376806,-4.09522976869,-1.06797924354,20.7299720369,-2.15237438842,-1.20135392356,-2.25267191416,2.76165849608,-1.65692827531,-0.450811348185,-1.261118751,3.04830293404,4.94057566158,-5.34923406433,-0.324402042176,-1.82567329588,4.55411010694,5.42268877385,1.18347780261,0.995160477798,-8.1342688671,-2.0834677155,-0.0109307953729,-2.50249289303,4.26306368366,-0.734103360398,-0.292828443224,-0.391434744638,-0.208459666992,-0.758952354996,-0.685672393324,0.272405399383,0.183672356232,0.482036996292,-1.76742618865,0.848104080942,0.0542677780819,1.10325162334,2.35995344961,0.986415421191,0.20218471436,-1.62903337243,0.998442515475,-1.56222600886,1.30121610837,-0.330167956766],[-35266.6478156,-3255.49528604,4537.82134865,640.132088497,2410.82368526,1043.03311037,-1497.05878114,-29.1817157643,791.429436457,-236.275479696,-843.621008437,1119.12663687,145.079465242,-317.642620754,880.008049207,359.983536409,617.046161502,23.4224417819,329.84606587,-752.808680232,78.3369546925,-289.701256418,-164.808724329,-176.069986735,43.4653872678,324.344287776,-93.3875422678,434.221040536,-49.9821697228,-107.710054578,-11.6532840296,-56.8897030796,-45.8117438044,91.7538338967,-107.770161312,50.9209507794,23.5640088277,19.9254201472,26.6315244109,49.7688929757,-176.395717938,-89.3645804582,-3.18812360908,92.1881153394,-56.6717359515,39.9650762603,2.02843969409,29.4381841833,22.5355840346,-5.24066018856,-8.22957695995,-27.433735647,8.53114627446,4.31460295784,40.1480200357,-46.0973649652,-13.4139469912,47.4882618706,-1.81880447009,-32.5696763588,26.5495586177,15.7826245102,54.8966197931,10.0723475376,-2.50873688288,-0.0244917767546,4.24249107172,-6.72704746744,-6.21928253079,7.28290351479,-0.682111393298,7.6474284347,-0.341114029397,5.40307135257,-1.48215283281,-4.17093301494,0.34710860164,20.1704317686,-0.435869686429,-2.90351077374,-2.52950076028,3.13338822443,-2.04694782887,-0.710380392762,-1.71944876383,3.40595019814,5.83762182287,-5.89092598849,-0.667356323572,-1.80589311656,5.39672344082,6.00034590852,1.67063443626,1.3549650431,-8.67775425092,-2.01460964454,-0.454832581722,-2.85662748208,4.87876625231,-0.848236951239,-0.326698177497,-0.413216468338,-0.322597696078,-0.875864237247,-0.9639369729,0.171426207256,0.308905340649,0.507918099329,-1.97108878286,1.02276070632,0.169603158904,1.27294025861,2.67772661146,1.1221603867,0.319922540562,-1.77018511841,1.13228677796,-1.56406646196,1.37125138718,-0.349229902502],[-35119.5687622,-3171.94560942,4670.91151162,617.069036989,2341.01966679,939.383042667,-1381.00658006,215.468365184,826.218779653,-304.555438143,-884.117566228,1143.02472229,165.019179548,-314.091165596,981.13155164,378.798492651,616.411467591,-20.3315259683,304.580321073,-718.833857895,58.8236473377,-284.573547999,-164.362292782,-177.876554594,26.4765554456,340.877633511,-114.633734703,445.6890867,-48.2196795674,-91.847321199,-18.8648073177,-59.1585112943,-38.8966086797,81.8900627755,-101.448025468,55.9540324086,25.6838838089,27.4016449175,19.1775655064,51.1929957282,-182.01328462,-85.5229967783,-2.97363924879,84.7972079471,-46.6903745062,50.5266744433,6.52972443172,27.3263165138,27.8890974051,-6.58995347712,-8.63670844945,-29.4714059432,10.5764903141,4.94534160118,45.3284618818,-49.6839030487,-12.4891616308,45.1091389243,-6.55403042523,-28.4249984961,27.4817014616,23.8632085095,48.5175364169,11.506872366,-3.15124778308,-0.384196957129,4.79202778695,-7.9719724179,-7.76086463047,8.7125381082,-0.478025039876,7.7672039182,-0.886719311325,7.26732653206,-2.12402841516,-4.13814873835,2.05276010573,18.915219457,0.768090444201,-4.82694288324,-2.81561036805,3.50250531017,-2.45535226519,-0.985272545999,-2.22138061065,3.76771958592,6.75635742938,-6.38112891712,-1.04521421971,-1.77349763332,6.33425110126,6.46663644948,2.259423808,1.77520521435,-9.11141010574,-1.90621884543,-0.956644281527,-3.29582341623,5.48220282054,-0.976295370118,-0.363561890109,-0.417161425132,-0.451947020915,-0.987894719128,-1.27670305831,0.0478368110701,0.46902566682,0.504312237204,-2.15453192789,1.22796232962,0.299305313497,1.45679705293,2.99166248888,1.2515032254,0.439290947259,-1.88660895347,1.26922254052,-1.50710910237,1.42965059434,-0.330621789246],[-34918.9720709,-3194.00243027,4797.24552972,556.472841404,2294.76048438,879.917414471,-1253.3569331,416.857294512,862.791104766,-391.964686392,-905.790343666,1163.4531494,203.104542652,-282.919856874,1033.42684375,403.171001895,612.892921801,-55.7559158722,282.640067966,-679.055472007,47.5654697559,-274.948686076,-159.86475133,-186.405867229,10.0567061676,354.631768808,-138.087577648,453.900234703,-45.8946862555,-78.3027415309,-24.3073347758,-60.3407138317,-36.1938400626,76.3529049985,-91.4189245686,61.3142040694,28.0961546821,34.0727752182,10.1447936177,52.7314076686,-185.169286632,-80.7377495437,-3.25908249343,75.3151924701,-36.0294285887,59.1403661546,9.60455142934,26.2733767074,33.7327861057,-7.79336229738,-8.78041802977,-31.2206225208,12.5572830495,5.47230942416,50.4036582984,-52.8963399992,-12.3125592154,41.2785277856,-10.958774248,-23.4157525295,27.0971703577,30.2912624318,40.6375878163,12.9047120866,-3.69901597261,-0.79632425451,5.30687917064,-9.28120799284,-9.37183178283,10.300240992,-0.45913557451,7.6197894747,-1.41019409772,9.17511985998,-2.85759017448,-4.05094998247,3.98452936875,16.9632681447,1.17348782403,-6.74913216359,-3.10588279662,3.862774322,-2.86728096447,-1.26789973319,-2.73703125617,4.12590434532,7.65780430916,-6.78664595097,-1.43092989978,-1.7314141705,7.34544153008,6.81929054244,2.9472533657,2.22741243666,-9.43777789756,-1.76644943727,-1.49612814769,-3.82643817698,6.08063223458,-1.11768157578,-0.405047543995,-0.399237473211,-0.591039616675,-1.08654138901,-1.61875996238,-0.0938472245195,0.669902481392,0.46368883752,-2.30047365641,1.46899453428,0.443975195017,1.64904598117,3.29736343329,1.36570428442,0.552054829712,-1.98458331402,1.40160484818,-1.37725917342,1.4764390253,-0.249143215585],[-34666.4984551,-3292.80008453,4995.90218119,464.922116077,2295.61307791,863.989436423,-1092.7048121,575.745177304,900.419654593,-494.988845468,-899.477685336,1179.60045967,248.744350257,-225.62175974,1029.71369754,436.115429648,607.067781027,-74.8706455722,269.16590747,-636.360707405,38.9345248666,-261.942166416,-151.954793593,-199.861193107,-4.34479418482,365.402052263,-162.738669974,459.125063388,-42.1740304683,-67.3810653895,-27.8852499527,-62.6163747565,-40.5553512832,75.9323382474,-75.3227093915,66.4513175954,31.1750607095,38.906487565,-0.483854168283,55.1129146032,-184.498351997,-74.6182155723,-3.80716522177,64.2498705237,-25.5303644195,64.4190532636,9.4829603392,27.3466244989,39.860248457,-8.81674170919,-8.67500623398,-32.468673569,14.324479071,5.80805269582,55.4515086863,-55.3436110207,-12.9399397152,35.8478507048,-14.6272676863,-17.8625666138,25.14407577,34.2947707345,31.5495959125,14.2030217133,-4.11117954534,-1.22864536213,5.7542569513,-10.6554388727,-10.9971766637,12.0632657976,-0.709353591942,7.158847564,-1.76519169755,11.0619057393,-3.67211438523,-3.93171240666,6.0319548763,14.2741703932,0.544572357186,-8.43278246054,-3.39024144878,4.19997084708,-3.26375671996,-1.55026206693,-3.23673282099,4.47077606025,8.49104140042,-7.06041672909,-1.79538989995,-1.67318357407,8.39988429534,7.06633803839,3.73476799103,2.68386066179,-9.64404774995,-1.61132578517,-2.07920559292,-4.45215777043,6.68096855981,-1.27040255104,-0.452220435959,-0.354510154523,-0.733927636374,-1.16147115349,-1.98260159536,-0.250246590855,0.918608940828,0.378358941362,-2.38814213326,1.74939457337,0.605980559628,1.84180343788,3.59328659312,1.45368943578,0.64791884512,-2.06844949875,1.51905755715,-1.16522136219,1.5050532707,-0.0770525312176],[-34363.9035643,-3312.18435967,5167.42707503,349.881268343,2348.50661378,838.397479441,-950.875285503,721.213656946,941.554935208,-618.359833382,-853.576319872,1198.03728637,263.457276637,-187.917037073,1002.76581383,477.378945086,602.752978338,-71.6330716682,262.059612602,-591.719745425,27.5810181001,-258.816137061,-153.167189551,-214.586351421,-15.5728108725,372.053265296,-187.528773248,463.260007894,-36.8009468245,-60.3903942282,-29.0178117655,-65.3931316638,-51.6468776405,78.0198002756,-51.8510429973,70.8547761889,35.0927711918,41.0074254737,-12.6690023039,58.8686154603,-178.51152406,-66.2587833732,-5.14692126462,51.3100911248,-15.5058075462,66.1651080582,6.16563570449,30.6617498428,45.9609280715,-9.59317069563,-8.33412969053,-33.0986211726,15.7879734222,5.95901197618,60.3545180602,-56.7117090662,-14.2649139385,28.7949294537,-17.2717113884,-12.4290120194,21.6255524348,35.5884224506,21.5228299637,15.3270873923,-4.36507995871,-1.65463341053,6.11497978114,-12.0800200588,-12.5973297676,13.9731130081,-1.22037373069,6.32580147888,-1.88187767778,12.9004927272,-4.48227540748,-3.77621476745,7.95081273295,10.8036716983,-1.20447460137,-9.57124809169,-3.65082263904,4.49535145648,-3.62255383163,-1.82458143963,-3.69207358353,4.7895761379,9.20085435654,-7.15645481846,-2.11702807269,-1.57058123945,9.45848545014,7.20859674594,4.61258114823,3.12374628048,-9.71174223795,-1.4803334685,-2.73803963663,-5.15206448841,7.31289172643,-1.43180170423,-0.50399643669,-0.277578497147,-0.874653173716,-1.19957358139,-2.3575054037,-0.417595450281,1.21877657176,0.241535854711,-2.39471897662,2.06881346863,0.787895790892,2.02638604661,3.87703302579,1.50004577592,0.712527411477,-2.13466976842,1.60786259309,-0.868664847319,1.5078366871,0.21086588963],[-34013.6151115,-3234.9471634,5459.92991997,260.401285582,2432.76977855,745.971138945,-828.055231824,891.344747028,964.695877603,-739.61291212,-792.613134437,1233.80940091,253.548533767,-135.029083699,995.27751755,520.160253079,600.051336626,-52.485534424,256.13651254,-546.818836365,12.4997848078,-264.497456649,-155.172756502,-217.874044302,-23.3011244968,374.979960249,-210.769384474,468.533522352,-31.8183206991,-56.0744555103,-25.8784918508,-62.4473348279,-65.6409733146,78.7551801718,-24.8006423334,73.450014317,39.8348847921,40.5807293914,-25.9946206854,64.1571581708,-167.787911333,-55.5302396818,-7.48120917223,35.3066332726,-5.63790888438,65.0313268836,2.09209404759,34.3376758554,51.7356685982,-10.3953301871,-7.93819016825,-33.233386566,16.8221998042,6.30056814325,64.9530046094,-56.9177972459,-16.429918162,20.523107079,-18.8628790948,-7.66758641753,16.4973732717,34.6796964201,11.0462575822,16.2695361868,-4.44415523023,-2.00245974805,6.30646689402,-13.5557094691,-14.1360733821,15.8825629671,-1.85176770485,5.15470121109,-1.79579811112,14.6277859479,-5.23527646312,-3.57290910727,9.47188416708,6.64821397957,-3.92117374325,-9.90852788348,-3.8733049073,4.74989973913,-3.92815033532,-2.08044016377,-4.05761563517,5.04605079815,9.74985268112,-7.06491372539,-2.4079891971,-1.36122692206,10.5220809682,7.2251221832,5.5359971579,3.50214344392,-9.64206550778,-1.41186837699,-3.487843336,-5.87637538399,7.99430951271,-1.59896265031,-0.5566010487,-0.169112807787,-1.00677009526,-1.18834486442,-2.72774315026,-0.587604186592,1.5612322235,0.0527768150918,-2.3042881111,2.4186524708,0.991273069698,2.1945244492,4.13545622315,1.48827236914,0.730778738554,-2.1742493639,1.66632557706,-0.507509376143,1.49869352651,0.618912679886],[-33623.9248901,-3144.08832423,5650.94723727,236.102637222,2509.91596789,583.35043714,-676.338828917,1087.62929911,962.93506361,-842.701320023,-741.110271766,1280.8157483,250.147964198,-55.8368164236,987.527287626,560.107909409,598.711863445,-21.8777642964,258.687327251,-502.374591225,-16.8651886001,-260.485230058,-143.493218055,-209.471479228,-28.9117805306,377.10106236,-230.801793513,474.803442772,-27.2922666109,-53.0187440897,-19.8178251002,-54.9761156648,-79.358406016,78.1947179893,2.16889666357,73.2437114338,45.3225409002,37.9446424983,-39.608303615,70.6506924081,-154.533728627,-43.7219798498,-9.97683624146,16.4439998313,3.48520410912,63.4416205897,-0.595274784337,36.0928418628,56.9961603305,-11.6538673266,-7.72587902822,-33.0166095178,17.145589291,7.38603289643,69.1030015194,-56.1022159298,-19.4721272242,11.5339759837,-19.3387058223,-3.88517257708,10.2373745024,32.3340894909,0.965991337082,17.0294624266,-4.33159046158,-2.17981846812,6.17161049295,-15.0580217837,-15.5839969149,17.5960367775,-2.44378217298,3.7500266776,-1.55992143689,16.2238981607,-5.92892665845,-3.34638507634,10.4066310693,2.10002753255,-7.21225784075,-9.36622891109,-4.04314509146,4.98798952659,-4.17639674139,-2.30244065585,-4.28317417452,5.18275000149,10.1179669781,-6.78719974519,-2.68915398933,-1.00103448324,11.6104795097,7.10385975096,6.43666829606,3.75597207293,-9.40377657436,-1.42725034359,-4.27734194563,-6.54501602755,8.73177585107,-1.76901393086,-0.600785901198,-0.0330244108084,-1.12321524407,-1.12110347361,-3.06949398315,-0.748465195138,1.92451250555,-0.178295680687,-2.10713982908,2.77755740594,1.21844742062,2.33571095633,4.35394763233,1.40928903485,0.701427557782,-2.17780086631,1.69871537366,-0.110358847657,1.51102718938,1.129945906],[-33212.3982773,-3120.27872783,5737.82702334,241.004097881,2595.88659703,425.307724011,-544.899518425,1215.92100422,955.242348872,-930.946147881,-686.911243803,1316.06702636,256.852710509,25.5851512483,963.128996844,597.545838272,598.627300293,20.5401541606,271.991705416,-456.842000035,-57.7387075222,-247.978112707,-122.105169015,-195.178032148,-34.6562190801,378.723354509,-247.442657728,480.787590245,-21.4400120943,-51.7192188004,-12.8821042687,-50.0158466405,-90.0525241559,77.4296145092,27.7576006347,69.8669422261,50.9056130887,33.5073555936,-52.3897009475,77.7481876032,-141.350761764,-32.3156274724,-13.5994582483,-3.06969188173,10.8082784594,62.3883104191,-2.60996492844,34.7814352297,61.4866374937,-13.6345587044,-7.94071327476,-32.5558558993,16.7904145294,9.36776400155,72.2439264359,-54.5023072937,-22.9993065371,2.30705798952,-18.7731050515,-1.62250595851,4.01707830834,29.2887058238,-8.11646090736,17.5695355221,-4.01256431137,-2.1375720866,5.58908645637,-16.4895843866,-16.9749346227,18.9771168092,-2.83740094919,2.24626066493,-1.24244904859,17.7084113389,-6.64210129327,-3.10159181334,10.6824456468,-2.37852587811,-10.6143599525,-7.95654510252,-4.13145791436,5.24895177736,-4.35814183619,-2.46908774407,-4.31280301436,5.14579364409,10.2762445922,-6.33414253235,-2.92118406906,-0.49120037547,12.6809514827,6.84190823579,7.26813595358,3.79073222425,-8.95572435024,-1.5522921985,-5.02440989011,-7.04917487427,9.54474659056,-1.94247872498,-0.617917136978,0.125993224201,-1.21597428845,-0.987233205803,-3.35276855881,-0.886165719343,2.27793083317,-0.434618289049,-1.7992455502,3.11658036557,1.46220383807,2.43571451581,4.50766655128,1.26549929073,0.630013645971,-2.13139747222,1.70556929391,0.308017713305,1.56959800281,1.70363356481],[-32806.5898837,-3069.69673157,5757.45331112,223.368923529,2687.1773451,286.213589756,-385.13221561,1285.69303685,950.238269204,-1011.83940709,-624.455072401,1330.22807699,251.115110782,92.3288219987,943.943871331,630.836231527,595.028490312,68.7483707902,293.787618599,-410.225201822,-103.637442275,-235.575420247,-95.135372282,-179.187494157,-42.501450826,378.425318897,-260.605347589,484.089174741,-13.4523613131,-53.9486069362,-7.65131786984,-50.6620196423,-97.1322310608,79.3174645166,50.2336631348,63.1270802843,56.0840540636,28.2630387944,-63.589476765,84.7653801487,-130.911592037,-22.7702411881,-19.6177416384,-21.140332067,15.3421130375,62.2762018152,-5.98994271594,29.6842377674,64.9034330459,-16.4901917638,-8.80639748185,-31.9263938377,15.9634813155,12.1617051989,73.6573573501,-52.2948129471,-26.6722919803,-6.82354576044,-17.2626938535,-1.14766712554,-1.02618672381,26.2814063948,-16.0468763534,17.8440985106,-3.48526226078,-1.84269587761,4.49168304289,-17.7293737537,-18.3105597904,19.8967714228,-2.88815303862,0.798970060793,-0.921235443959,19.0215490493,-7.50429260522,-2.84376301937,10.2552584,-6.24700603085,-13.5972574943,-5.76111442595,-4.09490832099,5.56632783251,-4.46060777813,-2.55855372535,-4.08225389007,4.8924336557,10.1807041692,-5.71709482711,-3.04215373307,0.146628095393,13.6662725687,6.42337101117,7.96296169885,3.51153650083,-8.26485808269,-1.83169753677,-5.65775698629,-7.29153880566,10.4231668725,-2.11893398718,-0.584605304118,0.301406192339,-1.27766645351,-0.772475316598,-3.54207376516,-0.984469724211,2.58534015979,-0.698793952518,-1.37958045976,3.40802748369,1.71116016468,2.47499196724,4.55984866094,1.05760121981,0.525482703385,-2.01062047419,1.69001003617,0.730093366324,1.68527578936,2.28222906672],[-32450.9568391,-2944.03124675,5750.23266107,161.379237393,2743.29928391,142.767356377,-217.040129912,1291.25989896,965.598642177,-1078.5666122,-557.599651496,1333.56874316,223.004303672,147.054947521,935.839028425,659.784413395,588.235083222,113.675708069,328.463647636,-367.31490319,-146.075827009,-230.463375736,-70.5218225242,-164.202866839,-53.9829168812,375.202758464,-270.705905066,482.060277365,-5.98410298382,-58.7832251122,-7.97914305823,-55.0580065676,-101.067737189,86.2547868152,66.3923515307,53.2439872056,60.4964611151,23.3760517865,-72.9342775617,90.2883116351,-125.417012534,-17.2673617552,-27.9063482282,-36.6004857631,17.1563356681,63.3948380465,-12.6675297108,20.559659344,66.9884331594,-20.3125135286,-10.5445674476,-31.1725966331,14.7286466518,15.5713722226,72.4219709246,-49.4888069764,-30.386957229,-15.3654837318,-15.1266346929,-2.3942909515,-3.91420804132,23.8482881532,-22.5991521278,17.8027410684,-2.74353944298,-1.29348003181,2.83823097303,-18.6711151492,-19.5477860359,20.1953238593,-2.50205926991,-0.440412216752,-0.627801195604,19.9720580654,-8.66558788214,-2.5922420808,9.08216197658,-8.97890883528,-15.5490375506,-2.91153125534,-3.87820834426,5.96539684926,-4.47343425134,-2.54969925175,-3.52815897486,4.36800606734,9.77343361224,-4.94491735971,-2.98799570359,0.885111440135,14.4723702215,5.82035077264,8.42434922781,2.82929213531,-7.29997565242,-2.31504485718,-6.11966215955,-7.1710935656,11.3392209894,-2.29530384903,-0.476154625303,0.485586219423,-1.30282627094,-0.462103499321,-3.59851561211,-1.02517896065,2.80453214675,-0.95508320181,-0.844214485802,3.6199102674,1.95426199399,2.43069733285,4.46416365945,0.781433510317,0.400967818482,-1.78477227053,1.65561946438,1.13096658772,1.86257559864,2.80048943727],[-32215.2530019,-2804.32480827,5797.30149227,54.3298230394,2748.94243587,46.3500038333,-45.7333335597,1356.9048262,1032.60169644,-1127.20435948,-483.575809274,1353.21495289,185.007088482,261.574568373,936.482039037,689.99359947,587.822190213,144.35669248,375.013278411,-330.88055881,-168.592584214,-233.57806964,-44.5108868338,-145.181278785,-68.0479003316,370.776389398,-278.318044009,469.124940503,-7.50244085508,-54.1296964682,-10.834036374,-56.0457677711,-104.154233376,93.9979972163,69.190444393,42.7717134241,64.5952229599,20.4812104796,-80.6610520275,91.7867047857,-126.120049895,-17.4286868645,-35.2354638114,-50.4503585031,19.1599832288,65.8523904968,-21.2476633786,8.71251319351,67.841687677,-24.7005600311,-13.2243337613,-30.0646976755,12.6542145803,19.2822688459,68.1462462893,-46.3060625454,-34.2184822672,-22.7576878651,-12.9579702623,-4.21764244228,-4.32284160525,22.4595733699,-27.0227812891,17.4050576534,-1.73978404962,-0.548979099609,0.776722269631,-19.3929979104,-20.4958857881,19.8517150231,-1.77544526246,-1.38079247985,-0.36892355868,20.1882406727,-10.1971917197,-2.28295739953,7.19893971156,-10.2997301151,-15.7924963033,0.19815143929,-3.42830476959,6.45254954284,-4.41082291128,-2.39377309137,-2.63775248062,3.51757050623,9.00433444679,-4.02853828566,-2.75549765708,1.65970249705,15.0029801816,4.99479465077,8.56150398652,1.73605672796,-6.07462764794,-3.04811463095,-6.40603953991,-6.58956350944,12.2235719193,-2.4711457357,-0.279367691236,0.674839958248,-1.2824013487,-0.0508362800958,-3.48888753798,-0.987679304888,2.89074335839,-1.20242445527,-0.200565893098,3.71527752302,2.17716528198,2.29490166017,4.17143320021,0.433319835308,0.268817531794,-1.43944230708,1.59659968353,1.4695368995,2.10128264744,3.20427849716],[-32148.3062751,-2699.58147005,5826.44731825,-62.6308615531,2791.68532997,-88.8853415391,48.5793679126,1379.04591559,1105.33517554,-1170.36498691,-419.082403273,1402.77452667,132.946177147,362.766826528,886.564809532,729.316222365,594.92899785,160.936092856,419.671115315,-301.202578688,-179.945402549,-231.522534662,-13.6954565493,-116.632652962,-83.3466795863,368.462401197,-283.050146003,441.854459222,-15.6487135979,-37.2774019848,-8.83103945289,-53.3296682969,-108.19657071,101.75588065,61.0465348134,35.2429678986,68.6190262804,20.6748700941,-84.4653969937,89.5010512386,-133.296879211,-21.0651740575,-41.6721319203,-62.1168950389,23.1886231544,68.1982255784,-26.1355957264,-4.40265565133,68.0131914079,-28.7201698512,-16.7896551364,-27.9651380084,9.80542291087,22.8851187414,61.3902595329,-43.4375966193,-37.9609924811,-29.2346169563,-10.5070481479,-5.69749693211,-3.46021933194,22.8764669141,-29.5905453444,16.6949666527,-0.409438746725,0.300778926777,-1.44923446554,-20.0149707312,-20.8154063857,19.0336597893,-0.971503326441,-1.89432619201,-0.135291275782,19.3651853329,-12.0288089848,-1.75969462347,4.89293549573,-10.3811932202,-14.0973021581,2.86744402595,-2.69502187845,7.00023940338,-4.35533421062,-2.03959500779,-1.4393007205,2.28632069492,7.86200266893,-2.97243586379,-2.39680839459,2.37122787183,15.2316238351,3.94296527379,8.35583435268,0.297990111101,-4.68459926527,-3.9919824345,-6.5232213115,-5.52116842084,12.9447843589,-2.64678389673,-0.0048311099482,0.868387240431,-1.21170479433,0.444669654336,-3.21456548643,-0.866038421868,2.82616424478,-1.43814152812,0.509218119058,3.67608547026,2.36437716021,2.08245178116,3.65222402472,0.0157409245832,0.126326830131,-0.988440591477,1.51285072429,1.70265027505,2.41067017044,3.45042254184],[-32117.9365425,-2644.44928829,5905.61728547,-179.469746901,2861.40777728,-303.973038259,222.387242471,1430.91711709,1131.24582237,-1223.6335578,-354.167658101,1437.02344511,86.5360254684,422.190769883,804.058704491,767.20653588,607.132379324,175.697695704,463.375926186,-262.811538233,-207.534344448,-220.787675743,27.3139149414,-102.122900456,-102.174615142,368.367826918,-285.583008655,406.909716815,-18.3931353,-15.429321825,-5.10571473135,-50.3842152227,-112.02675777,115.833302222,47.9211802623,32.3421492916,70.4518240795,23.0295194007,-81.5644007485,84.6535521932,-144.644632151,-24.9975941747,-48.9161371347,-69.5150937292,30.0081075487,69.6183662333,-26.5389533374,-19.5260687832,68.0992018045,-32.28748446,-21.2926157115,-24.6887558715,6.59698112256,26.6613623975,52.9129802607,-41.2074313024,-40.8226425675,-35.4725136842,-7.21384325304,-6.43420603362,-2.69654793736,24.5746461822,-31.9532541141,15.7750789468,1.11555668619,1.12135409715,-3.71788716796,-20.616864374,-20.3316827494,17.9807802589,-0.20703426669,-1.92996939655,0.173685497466,17.6107966072,-14.0348594208,-1.04236118971,2.53855117558,-9.80970159686,-10.9302920663,4.58932378957,-1.66381063604,7.54750521653,-4.4188194843,-1.53941124874,-0.0153615984052,0.745142100142,6.4502550001,-1.78336648904,-1.93592867391,2.98216520875,15.1789981078,2.78057613542,7.90972060615,-1.42652332425,-3.21296554245,-5.04351808347,-6.49995730692,-4.07976566161,13.4181718832,-2.81228444874,0.3094028291,1.06933123453,-1.11818458122,0.984291211537,-2.82384020303,-0.687973737028,2.63255265172,-1.63949495242,1.24003930186,3.51296683265,2.53299763507,1.8303182602,2.93645286671,-0.446569014246,-0.0324302221557,-0.458047426337,1.41806312627,1.83046308465,2.78243831548,3.53057881529],[-31995.6590298,-2532.39676313,5946.45416133,-290.128441265,2888.03719749,-547.591647185,445.212360415,1494.50197025,1102.76302517,-1286.3220865,-317.704902412,1420.02377361,37.0614816072,431.770277063,710.452484533,797.742689521,616.576581619,195.006474262,505.623177781,-218.312966031,-249.885104312,-209.02322216,73.5652496503,-107.380182295,-121.076400459,367.331565258,-286.855057098,372.149454184,-13.1015801119,1.05136543227,-4.58949076894,-48.6692768714,-115.100956189,128.610284993,32.7075642048,33.2979642664,69.5933048961,25.5075607507,-72.2480395645,78.6424326678,-158.522207249,-28.9427086669,-57.1423046637,-71.6586017654,38.3403113688,69.4371082821,-25.2927434836,-36.6555783377,68.1472783397,-35.8461350073,-26.8104355833,-20.5193285778,3.35628454328,30.8262753871,43.3939045393,-39.9602074123,-42.2606404263,-40.9219330674,-2.9949263466,-5.8057399858,-2.49749049541,26.6656105577,-34.3585000073,14.6975233864,2.58120816581,1.75493432525,-5.85357111319,-21.1763081021,-19.1506733266,16.8309717374,0.509664337791,-1.57594759841,0.541460240357,15.2956459544,-16.0137965954,-0.0959257558928,0.375497858192,-8.85834468684,-6.97383832963,5.22992520317,-0.411986382546,8.00680557431,-4.70652887482,-1.00627643503,1.52497547784,-0.954317107374,4.92614741094,-0.538975087223,-1.40834443024,3.53846585141,14.8782187106,1.59068082374,7.378285165,-3.28461307154,-1.68316705496,-6.08606828337,-6.34092863752,-2.43450127658,13.5534269997,-2.95552474243,0.600966854858,1.27591467199,-1.03341039483,1.52141433776,-2.38266029143,-0.486539154916,2.32919253948,-1.7799411928,1.96815838462,3.24455862251,2.69556455553,1.57804181755,2.08538361405,-0.904618459247,-0.199441305848,0.114334240062,1.31957820684,1.87243811642,3.17351694594,3.46058072093],[-31809.1065246,-2400.32638817,5973.98191236,-427.959913559,2912.47378637,-749.016443319,603.560983129,1439.21612492,1074.56604632,-1373.27670044,-313.703594665,1381.92756057,-10.121267778,434.547034889,635.919976052,827.102525308,619.962298454,218.498389065,544.489968101,-174.101077489,-286.299587019,-196.06217039,108.637092747,-116.743646959,-139.76570296,363.248779856,-286.274360408,336.665145661,-1.99722338827,8.55807727676,-7.53124065005,-49.4123694575,-117.967979688,123.460993173,17.2087837517,36.355483237,65.9393845124,27.6007504449,-58.8356943976,73.2286669514,-174.365648544,-32.4641459356,-64.7881962176,-67.2101610547,45.819154861,67.2505701685,-26.4056897389,-53.812979066,67.9216599148,-39.6830500064,-33.0700596951,-16.0073441255,0.589692421357,35.0251642525,33.574558791,-39.4150933295,-41.4695158909,-44.5263934264,2.31235616263,-3.06445552902,-2.51382681498,28.3406646097,-36.3758612572,13.4425682853,3.79256252907,2.12858202768,-7.73088129301,-21.5324845014,-17.5129825007,15.6879683378,1.32168623127,-0.93292088289,1.08421645622,12.8708548388,-17.8480464767,1.22288003576,-1.2848318162,-7.5168377308,-2.84872809317,4.80813786587,0.988677286143,8.31659771329,-5.30377691164,-0.509899106687,3.11479727236,-2.69645520338,3.46286469869,0.695677089158,-0.834342796406,4.1146125554,14.3583794461,0.454161364453,6.90177098964,-5.05946223585,-0.0827877027358,-6.97951183611,-6.04681101392,-0.756150838523,13.2508274334,-3.05960858502,0.815338623851,1.472087996,-0.967578999109,2.01090174164,-1.94966779763,-0.285423458023,1.92919947626,-1.82433681965,2.68147976803,2.89026455517,2.85480841711,1.35702844276,1.16600549933,-1.31013762169,-0.357088081181,0.688123859143,1.22156676855,1.84004747318,3.5345100392,3.25985645401],[-31624.8851361,-2358.25510702,5944.05364707,-572.321111199,2948.15938215,-892.068685603,737.565657797,1301.45182186,1061.21863675,-1445.707583,-333.473727184,1319.42479749,-22.0298817864,481.399623974,588.6742326,855.070101762,623.773103419,240.750213158,584.384798188,-133.849054183,-319.241126498,-180.084605794,133.411754779,-107.748400134,-157.350721738,356.419591916,-281.467881887,303.614146688,13.9165874506,7.88424622967,-9.25269690286,-51.9936144997,-118.780032873,96.0199236218,5.26983890616,40.8134510895,60.7178471355,28.267600593,-44.003491734,71.5880185278,-190.732401565,-34.8579695093,-70.6257418524,-57.6469840277,52.9942997649,61.4489668497,-33.026659386,-68.7419240596,67.7894633578,-43.6899814,-39.6040329438,-11.2887276212,-1.15135743457,38.6886178491,23.6904839093,-38.9585535082,-38.5266609602,-45.1313381408,7.91037723305,2.43645492765,-2.78407541743,28.7116251148,-37.7251515003,12.1084275868,4.66479242576,2.21486175935,-9.15853250584,-21.5044692703,-15.6713640497,14.3910137512,2.402012687,-0.408400957556,1.99103227846,10.4290871879,-19.2748545885,2.95621671897,-2.17063346169,-5.89211226245,1.03284198531,3.2566540114,2.48815865615,8.45534252119,-6.29061653199,-0.037334268,4.71309788559,-4.38309362704,2.17190054193,1.90309736819,-0.297378351518,4.75679464408,13.5491608891,-0.518384096285,6.53132704016,-6.55738917624,1.58217579427,-7.57096435372,-5.63265199271,0.828989178444,12.4406790205,-3.11137285735,0.91931248567,1.63740279718,-0.901486149904,2.41623253984,-1.56887230205,-0.0951722376727,1.45355116135,-1.73630251661,3.35136118157,2.46316959019,3.01494013231,1.17245355053,0.257187764869,-1.63833933802,-0.477689776006,1.23465238409,1.14360755233,1.75926191835,3.81974035113,2.93410821365],[-31492.4881943,-2302.95779043,5930.3900264,-702.013759742,2942.36270645,-1011.02889015,935.12622787,1142.80221407,1044.19478484,-1486.05407887,-377.538983701,1260.04222349,14.5716016192,587.735566733,525.44758348,873.666544319,636.168572399,252.733782416,624.690146854,-107.189682706,-363.931184519,-174.185353318,154.753364084,-66.4649918706,-175.111834754,347.817968469,-265.133226405,275.455630623,32.6033439562,-1.17165170458,-7.91594131047,-62.506693683,-121.169513031,52.5333522657,8.31662246183,46.6862228646,55.2649487703,26.9728882489,-29.8230720758,76.1943283194,-208.055958785,-34.8851586167,-74.3709213381,-46.7678048327,58.9621377316,51.5646338008,-45.3727428579,-78.6725692328,68.3991308365,-47.5155248417,-45.731535797,-5.94213334839,-2.14668446756,41.2806444188,13.896172369,-38.4570702374,-33.8011754575,-42.3871049871,13.2735146483,9.91166557306,-3.64070585804,28.051450163,-38.3164754638,10.8061402574,5.08235865992,1.97311543782,-9.89912800554,-21.102380331,-13.7506650175,12.6734942476,3.782979777,-0.489458836486,3.36017368708,8.07319325643,-19.9073925868,5.0628621078,-1.97807797266,-4.21913522856,4.46478941038,0.441404277109,4.05634507202,8.36829422063,-7.78474433564,0.461653262353,6.28361132731,-5.8952508373,1.11247161167,3.10732553954,0.117826199428,5.47686973145,12.3641868832,-1.192371339,6.30695364774,-7.61335346616,3.26395283117,-7.75079720313,-5.12113834913,2.17337127462,11.1178940154,-3.09282182803,0.886783530888,1.73877669575,-0.81095849967,2.71369197452,-1.27221569164,0.0724914860338,0.938925239496,-1.48168419453,3.95374345068,1.97775007698,3.17750857357,1.02170652014,-0.548196904425,-1.89516106124,-0.558040026512,1.73894967297,1.10135052401,1.66138650975,3.98482706166,2.46390251287],[-31295.0818033,-2311.76842044,5883.91055175,-783.408464547,2962.16996595,-1093.47208858,1171.53588938,1015.35051502,1062.32268788,-1531.78384852,-435.82063584,1232.00370657,86.2441424421,708.850662124,418.058167566,885.213142327,658.94221163,265.334057398,640.89187602,-111.738087932,-404.44572231,-171.06489498,174.174208963,-42.4715917334,-196.969873172,338.030515785,-223.760180638,247.684405788,47.7620712011,-9.84976617485,-4.08795438918,-86.015749274,-128.729345047,0.566214536045,24.2657187022,53.655437653,50.5268177793,26.051601224,-18.8484177994,86.7993486378,-224.971122858,-31.6962300361,-71.0726477177,-34.7302095375,59.5665906592,35.8063871633,-61.2897775625,-79.7750528336,70.112101112,-50.3373227053,-49.5655442128,0.0220481014083,-3.26525406051,42.4235314386,4.61475312138,-36.7034876979,-26.6836583329,-36.2735933344,18.6288343002,18.195140999,-5.58723532364,27.8549454265,-37.7067840001,9.60397414554,5.18333458172,1.60122661412,-9.84682218225,-20.3409995162,-11.9511658735,10.5086327004,5.71595583857,-1.29309844568,5.34980314929,6.23850412889,-19.2157198788,7.44076671912,-0.245035107432,-2.5223426232,7.28244854943,-3.3176873799,5.68146281958,8.10582054129,-9.86365635173,1.02388996647,7.807353958,-7.15612296169,0.389589178156,4.36280891982,0.413472622436,6.34819948985,10.8465781835,-1.45788502053,6.33197481025,-7.99058113705,4.96567959632,-7.44603329898,-4.45599005196,3.00412299701,9.34781120249,-2.98343858136,0.732966725511,1.74673000344,-0.663931822563,2.88514057305,-1.10289034598,0.208889353421,0.412064456907,-1.01545156616,4.49601074601,1.47606614988,3.33735832004,0.926268594228,-1.15258863851,-2.06692292277,-0.628022917441,2.19975253888,1.08842806278,1.56432246702,3.97297234311,1.81073946622],[-31029.2518816,-2336.35849454,5818.49782661,-843.358614885,2962.10398161,-1215.37971353,1396.93251292,842.803248027,1111.80607433,-1595.62663149,-498.034770868,1210.47700764,120.045180645,834.029105211,280.088461539,892.204548723,692.847314726,272.793507175,618.858353394,-149.886974885,-428.332498472,-143.005005547,219.410742862,-52.9405485771,-223.853922973,330.100992778,-165.164326115,216.140291712,54.6034511291,-19.4475181328,-6.86245083331,-112.947841998,-131.077875411,-46.3081457771,46.6579391804,61.0940232031,47.3764676805,24.4778925809,-11.7610550034,97.5788542558,-240.088797207,-22.2952550031,-59.7296484731,-19.502493396,50.9693624067,16.8323079238,-79.5669810849,-69.65212764,73.09048034,-51.4479255882,-49.3979685405,5.55114902313,-5.64010846047,40.970868341,-3.89950229288,-33.8706007874,-17.4332736728,-28.4933355429,24.170978795,23.4221849608,-9.30486626511,27.8311835388,-35.5747554173,8.58114726783,5.28928168646,1.74570333937,-9.10159715308,-19.138046757,-10.7100160421,8.12322681454,7.5985443211,-2.99803738808,7.57639685414,5.11879039254,-17.3760595922,9.9904582152,2.5101157756,-1.07657336629,9.35035948879,-7.46156698548,7.30653341843,7.80222978356,-12.4343484485,1.6631983598,9.30872884351,-8.18889669411,0.0816134114697,5.62566090481,0.478548290724,7.20083654679,8.91597397011,-1.38904293792,6.5945426442,-7.64150058662,6.59047201292,-6.587529401,-3.6299087023,3.16989590898,7.29448858307,-2.77744143423,0.497074995608,1.66800777591,-0.425394417215,2.93511565447,-1.10250066901,0.298857083503,-0.120499787512,-0.339889064427,4.97139134265,0.910513526069,3.49720204905,0.884593017178,-1.49709824771,-2.15430037768,-0.697198886696,2.60068129468,1.14346901802,1.48879725196,3.72839596299,0.971518993019],[-30788.2800342,-2312.67508552,5786.30187143,-962.803335925,2979.60643828,-1388.49892262,1525.98616789,663.126294952,1176.87421625,-1693.40136508,-527.684836451,1199.27376099,144.906376765,912.534365462,162.060402325,906.210870526,732.73206859,256.508495568,593.862283527,-214.024105865,-431.262353313,-105.887843889,254.684439221,-93.134606754,-247.515155951,330.44579701,-106.223209434,192.318682161,63.6309543624,-25.6280539946,-28.523315549,-132.1498015,-128.09867233,-69.1410481769,65.3199380651,63.9531879943,45.5300354379,17.7129462251,-8.06447746225,104.476810499,-251.892544222,-6.12798624452,-42.0631157292,-10.5429518634,37.740345742,1.94265139151,-95.3383122407,-54.7597593499,75.2393351774,-51.8553335984,-46.6938227282,8.01944314639,-10.289436839,36.062539967,-10.1512972805,-31.2079505034,-9.22221401553,-20.3295888062,29.3504646057,23.8691592927,-13.921316338,26.7165014535,-32.1422443671,7.67241524858,5.32562487055,2.9615297901,-8.24686875347,-17.5353093941,-10.4486089905,6.33288824626,8.28866439291,-5.53145143316,9.29127863779,4.34566331029,-14.8964859243,12.8494832137,5.48753308099,-0.0363374679185,10.4132230985,-11.3088910852,8.72946409878,7.50535800866,-15.2422446729,2.24611302215,10.8006717201,-9.10971996062,0.263708371128,6.80290621141,0.340579011733,7.63915039029,6.49060335374,-1.14342214879,7.09184676469,-6.64365565982,8.13943122405,-5.19480606412,-2.72664963501,2.74683138186,5.28220369573,-2.5006276262,0.165553920224,1.52271469462,-0.0982023532088,2.87831473898,-1.28673598147,0.361998941586,-0.646224171485,0.505113058533,5.34871117168,0.211169265142,3.67421415543,0.86433583229,-1.5497163352,-2.17384600942,-0.717388399051,2.9564758575,1.28765653544,1.43561669975,3.28562274943,-0.012700092837],[-30649.13763,-2287.66289005,5805.21623251,-1122.77938472,2972.72527823,-1588.14472762,1578.64396953,549.600685896,1239.41029019,-1792.58120223,-538.262308483,1229.97130185,171.995720456,916.612166119,30.4855102851,929.803623213,774.595352376,207.045719326,555.333644873,-272.772391397,-417.817839957,-67.0434012898,290.95500099,-133.362699374,-256.353867615,339.077999652,-54.5639939936,185.611092545,78.4976400296,-24.4185621924,-57.3091986581,-146.322478114,-124.178898972,-78.4818974758,71.3991339096,60.5097613408,46.7801477355,8.90547924804,-5.23730823573,107.75594449,-259.117986136,17.5767304101,-24.0758526376,-9.68447999856,21.1138823958,-8.32900145769,-104.137834119,-38.8400918966,75.3955487834,-51.9911367746,-44.4162463391,7.44915539898,-16.0546465209,28.1619309747,-12.0770183744,-30.5717316531,-3.19385515501,-14.0362015853,30.9770248703,21.5287703576,-17.0221592641,23.7261135755,-27.8384986269,7.12987787083,5.2703407553,5.00380183787,-7.41783610171,-15.8438201827,-11.2626742501,5.76969570914,6.66267125303,-8.31099133652,9.81727797047,3.22702063663,-11.9173083353,15.805047495,8.55010789756,0.403338989864,10.3092754032,-14.2134019876,9.68917007976,7.2833348178,-17.9711377171,2.63577278346,12.1853036139,-10.0474023389,1.05314950965,7.68297847614,0.115763503354,7.2664156673,3.52519056025,-0.905330888141,7.71369752438,-5.06305838964,9.61320680915,-3.35961811984,-2.03888169975,1.87796902959,3.60646084863,-2.22036796588,-0.309165602664,1.35757086899,0.291744899285,2.72759502848,-1.64637545556,0.474273481829,-1.16420256711,1.48348503734,5.55514328086,-0.625908291773,3.84530065475,0.793970422169,-1.33941511531,-2.12692825318,-0.636091045894,3.27194249223,1.50466821901,1.35167607446,2.71833780734,-1.09562441488]])
    return models,coeffs

def get_arch3k():
    models=[-1000,-990,-980,-970,-960,-950,-940,-930,-920,-910,-900,-890,-880,-870,-860,-850,-840,-830,-820,-810,-800,-790,-780,-770,-760,-750,-740,-730,-720,-710,-700,-690,-680,-670,-660,-650,-640,-630,-620,-610,-600,-590,-580,-570,-560,-550,-540,-530,-520,-510,-500,-490,-480,-470,-460,-450,-440,-430,-420,-410,-400,-390,-380,-370,-360,-350,-340,-330,-320,-310,-300,-290,-280,-270,-260,-250,-240,-230,-220,-210,-200,-190,-180,-170,-160,-150,-140,-130,-120,-110,-100,-90,-80,-70,-60,-50,-40,-30,-20,-10,0,10,20,30,40,50,60,70,80,90,100,110,120,130,140,150,160,170,180,190,200,210,220,230,240,250,260,270,280,290,300,310,320,330,340,350,360,370,380,390,400,410,420,430,440,450,460,470,480,490,500,510,520,530,540,550,560,570,580,590,600,610,620,630,640,650,660,670,680,690,700,710,720,730,740,750,760,770,780,790,800,810,820,830,840,850,860,870,880,890,900,910,920,930,940,950,960,970,980,990,1000,1010,1020,1030,1040,1050,1060,1070,1080,1090,1100,1110,1120,1130,1140,1150,1160,1170,1180,1190,1200,1210,1220,1230,1240,1250,1260,1270,1280,1290,1300,1310,1320,1330,1340,1350,1360,1370,1380,1390,1400,1410,1420,1430,1440,1450,1460,1470,1480,1490,1500,1510,1520,1530,1540,1550,1560,1570,1580,1590,1600,1610,1620,1630,1640,1650,1660,1670,1680,1690,1700,1710,1720,1730,1740,1750,1760,1770,1780,1790,1800,1810,1820,1830,1840,1850,1860,1870,1880,1890,1900,1910,1920,1930,1940]
    coeffs=np.array([[-35442.00185,-5581.93725,-2788.952135,-722.957971667,2384.25115167,-101.519988767,995.450500667,641.048914333,-744.9152325,-309.171524833,-699.663918,120.585123433,-473.928992333,-1072.994595,148.2877391,-404.370941333,-259.9676955,-276.835615667,296.054265667,-317.516778,168.8133075,121.297345,-76.5088868667,-680.843634833,-107.558298333,1.25702119,-38.8363388333,163.252904,-99.9489627167,140.5617345,-12.1732746,-122.214406167,-295.6268535,-8.83372448333,-34.16152625,-5.71226826333,32.6825645,8.20257266333,48.6089771167,-25.6492067833,47.2122755333,-23.7736568333,-54.078435,-66.4343332833,3.50893533667,-4.53771406483,31.24981385,-15.8208231333,7.01743350333,9.580563075,3.950929465,8.676137505,-6.976487835,10.5543420667,-6.413725175,-12.3141324167,-7.22647108167,8.64280564,-3.07368870167,16.4415188333,-9.89298240167,-2.95657417833,-3.936359395,2.86189283,-0.482910932333,0.139363821833,0.317727031333,-1.24698948167,1.180571905,0.06902060355,-0.448326519833,0.8903172585,3.92547785667,-2.03229955,5.08494030167,-4.12248995333,-0.693284893167,-1.99377857833,1.661652535,2.44255471833,0.432025898333,-1.04666304667,-0.202699857167,-0.4108860095,0.0400315327,-0.08716767415,0.433315240333,0.848772993833,0.798408043333,1.038761275,-0.624943841833,1.27984523333,-1.038802965,0.2421321085,-0.590293182,1.00735977183,1.15692575667,0.0683605878833,-0.227478181833,-0.0387326936333,-0.26990283,-0.0236197467833,-0.182476422833,0.0727217695833,-0.0565102939167,0.0727430715667,0.384737398167,0.254232192833,0.174623523,-0.0400560311167,0.267405362667,-0.1471133155,0.265869048667,-0.156947054667,0.447935138167,0.390135888,0.00143985193183,-0.03867022145,-0.07613102665,0.0468598583],[-35489.7856667,-5705.19769,-2973.12161167,-644.631576333,2389.179175,-186.660027167,1054.42426783,627.698023167,-780.554755167,-359.537901333,-735.4462295,169.712252333,-447.8563955,-1080.206295,201.37109,-431.501336333,-284.670885333,-284.980622667,324.683971167,-312.257783,202.0763605,141.397636833,-74.1190228167,-694.4898145,-115.052439833,-3.10426157833,-39.4541007,171.548959667,-103.521182733,156.960394833,-12.31258865,-125.8169885,-293.928888833,-19.9691173167,-27.7453858333,-5.66766976,33.2599684333,8.87754499833,49.3710700833,-28.7942642333,52.0252603,-25.56673815,-56.33090255,-62.1472817333,-1.41715976333,-0.452965437667,32.07160935,-16.7827305667,7.85462493667,10.041168825,4.211393995,8.41500247,-8.26246755,11.4413884333,-7.04941451,-12.8768106,-5.46200494667,7.40875026,-1.65048889933,16.5648282333,-10.54837262,-3.48871051667,-4.40000752167,3.14309023833,-0.387622049,0.144635814,0.198477135867,-1.50401523667,1.19401244167,-0.0715325668833,-0.436660176667,1.24811480867,3.71891543333,-1.65719136833,4.94477074333,-4.39446833833,-0.958055156667,-2.22456321833,1.748103975,2.56729456167,0.447922513,-1.03771877833,-0.216702818833,-0.430896963167,0.0574253927667,-0.134927439933,0.4085011725,0.914069352167,0.8099381425,1.02756916,-0.549956834,1.19653272833,-1.10287131167,0.15346496325,-0.645168150833,1.03351013333,1.20667054833,0.0659357542,-0.273931099833,-0.0556266908,-0.269125127167,-0.0257700813167,-0.179313518333,0.1003515682,-0.0715126790833,0.0691575267167,0.411270677167,0.235158851333,0.184569637833,-0.0309029442833,0.244705558833,-0.152141532333,0.242460051833,-0.165678284833,0.452104317,0.397077476333,0.000478544102333,-0.0613963062333,-0.0789632882667,0.05215680125],[-35583.6940333,-5806.150265,-3174.32576833,-576.0145085,2405.06938,-271.900787,1105.25801,624.526778167,-814.042917667,-406.4627795,-766.233414333,214.0442435,-421.9727755,-1082.57621333,253.330277833,-457.797096167,-309.687227,-290.879279,351.9044045,-307.102331833,237.307492,161.069428833,-71.9488595,-709.068710667,-122.684403167,-7.95022852833,-39.5263873,179.5812695,-107.0859655,173.683791167,-12.7781773833,-129.361550333,-292.7135445,-31.4914643167,-20.9896741667,-5.715497055,33.7107443667,9.62020640167,50.0563197833,-32.0113524167,56.8098365,-27.5450642333,-58.5557191333,-57.9284621167,-6.52533735667,3.81286325517,32.9580629667,-17.7063608833,8.693768305,10.5048152167,4.46361512167,8.11977768667,-9.61730726,12.30472905,-7.76050466333,-13.4414801167,-3.67311296333,6.11366977333,-0.173116437333,16.7266823333,-11.2165715333,-4.01090243,-4.86873576667,3.43534061333,-0.278650078167,0.1415682885,0.07036144945,-1.786478645,1.205576395,-0.232221610683,-0.42633419,1.619641305,3.49503852333,-1.275275429,4.81392957333,-4.68422931333,-1.22259835767,-2.45665793333,1.83279790833,2.69321274,0.466131703167,-1.02337536667,-0.233223960833,-0.450366127167,0.0730125403167,-0.180462101167,0.380864734,0.980451899,0.8236675065,1.01213959067,-0.4766547295,1.11278115833,-1.17508242,0.0640206148,-0.700628715,1.05978524167,1.25832593667,0.06232807605,-0.3197891045,-0.073261589,-0.267235379,-0.0281905027833,-0.174734133333,0.13031225505,-0.0854539043167,0.0659040936167,0.438809045667,0.215722355833,0.193964399667,-0.0228875718333,0.221001118667,-0.159598617333,0.219115791667,-0.175037358,0.456642284667,0.405036515167,-0.00117623470983,-0.0838758919667,-0.0820038736167,0.0577081305667],[-35713.3376833,-5886.34435833,-3385.1458,-517.086784,2433.56713833,-352.0980025,1146.26196167,629.186187167,-845.5770165,-448.850682333,-791.265895,253.586877667,-397.488647,-1080.31805167,303.306474333,-483.149496,-334.699463667,-294.741203667,377.658153833,-302.4495545,274.094730833,180.201855667,-70.2297263833,-724.331396833,-130.369359833,-13.2214337283,-39.2008968833,187.3165335,-110.7219005,190.535793,-13.5269462333,-132.920262833,-291.906611167,-43.34022515,-13.94430793,-5.83678123833,34.0417988,10.3893899633,50.6689259333,-35.2818833833,61.50690315,-29.6902352833,-60.7560654333,-53.7954316333,-11.78811662,8.22076827,33.8828014333,-18.5774408167,9.531413255,10.97096965,4.70511511167,7.79818054667,-11.0212073367,13.1323874333,-8.54604831667,-14.0046891333,-1.8798286105,4.76572949,1.34054717233,16.91313,-11.88867995,-4.51986355167,-5.339161355,3.73571137333,-0.156950957,0.132988193167,-0.0635820655333,-2.08806180333,1.21448389167,-0.413269399,-0.416427183333,1.99727096667,3.25686634167,-0.892977187667,4.6890333,-4.988225285,-1.48644982833,-2.68873716833,1.91391828833,2.81758651333,0.486137653333,-1.0042642055,-0.251042664667,-0.468843301333,0.0873280593333,-0.223301315667,0.350740553333,1.04773568133,0.837977268667,0.993495380333,-0.406901154167,1.02838202083,-1.25443894333,-0.0265198882167,-0.756448955167,1.085341845,1.31053788833,0.0573583310167,-0.364752572,-0.0915632098333,-0.264469530667,-0.0306665724167,-0.168884904333,0.162234004167,-0.0981099669833,0.0631881316167,0.4671578535,0.195829921,0.203053127,-0.0164187405333,0.196478735167,-0.1693110015,0.195695150833,-0.185005785,0.461300969667,0.413628449667,-0.00365054895667,-0.106035171883,-0.0851965823833,0.063368622],[-35870.7480833,-5943.48737333,-3594.62535833,-467.546035667,2476.63326,-421.140420833,1176.176555,637.8537635,-875.067105333,-485.4839875,-809.470894167,288.530638,-375.935891833,-1073.83301833,350.391336333,-507.400948333,-359.314621333,-296.669045667,401.911652333,-298.6415315,311.990488833,198.6456125,-69.1029871167,-739.852284667,-138.035261167,-18.8523912,-38.6037268667,194.713608833,-114.451331167,207.325397167,-14.5014906333,-136.5095945,-291.3677215,-55.4050176167,-6.66309564,-6.02044863667,34.2489867667,11.1414501167,51.20712175,-38.5711066833,66.0588328333,-31.96667575,-62.9156116667,-49.7497368833,-17.1577917833,12.7322097333,34.81574525,-19.3846027667,10.3629803583,11.4338180667,4.93027089667,7.455388995,-12.4530568333,13.9111834,-9.39911048167,-14.5592842167,-0.0983409153333,3.37619511833,2.87460618667,17.1092017667,-12.5546729,-5.01330340167,-5.80490580167,4.04163142667,-0.0241082056667,0.120860971167,-0.201110906017,-2.40322323,1.219240525,-0.614332948,-0.406110828667,2.3744757,3.00683094667,-0.5155130015,4.56652106667,-5.30146624,-1.74935277,-2.91786726167,1.98978660167,2.93815618333,0.507620888667,-0.9806656575,-0.268955151833,-0.486006322,0.10058004905,-0.263131932833,0.318131159,1.11542271333,0.8514499095,0.972202724333,-0.342166942167,0.942981154,-1.33934165833,-0.118477556533,-0.811878376833,1.10928684167,1.36217986833,0.0509298407,-0.408546942833,-0.110439269783,-0.260879788667,-0.03292286095,-0.161880059,0.1957189175,-0.10925531325,0.06106758735,0.496018696833,0.175358679333,0.211969775667,-0.01184693233,0.1712289945,-0.180972614,0.172043285667,-0.1954450355,0.465748777333,0.422516631167,-0.00705161036833,-0.127793544333,-0.0885347456333,0.0689593108333],[-36049.5548,-5974.30948333,-3790.37198667,-426.932349833,2536.05741,-472.696477667,1193.999145,646.350493,-902.209659833,-515.0211295,-819.5918405,319.197738667,-358.910852667,-1063.38552833,393.618092667,-530.350889833,-383.046232167,-296.669232,424.658692,-295.940881333,350.5891125,216.218559833,-68.6411001333,-755.114845833,-145.619507667,-24.7688213667,-37.8403157333,201.729597333,-118.241344833,223.870272667,-15.6276564333,-140.095672333,-290.915586,-67.5460485333,0.803513746667,-6.26258882667,34.3169065167,11.83009565,51.6646627333,-41.8272718,70.4067760333,-34.3211305167,-64.9996532167,-45.7801202167,-22.5723093333,17.3109813333,35.7255718667,-20.1134314667,11.1826006167,11.8822285,5.13064835833,7.094058205,-13.8897534333,14.6261738,-10.30655691,-15.0948387167,1.6590718895,1.9590783075,4.415395125,17.29971745,-13.2013823333,-5.488243085,-6.257427245,4.35083108,0.117712804,0.106548540683,-0.340824652667,-2.72709806833,1.21770309667,-0.834378814,-0.3948261145,2.74579571333,2.74706831167,-0.146851367333,4.442819075,-5.61726919167,-2.01065767,-3.139783905,2.05852503667,3.05266803333,0.530478992667,-0.952499588667,-0.285701446167,-0.501654704833,0.112597238167,-0.299767899667,0.282747191333,1.18265417833,0.862791300833,0.948463588333,-0.283506255833,0.856112165833,-1.42764363833,-0.2120996195,-0.865686077833,1.13055605,1.41217881833,0.04292478975,-0.450802120167,-0.129764575667,-0.256340524833,-0.0346226291667,-0.153795507333,0.230311316667,-0.118671664,0.0594563090667,0.524982996667,0.154128415667,0.220739101,-0.00945448497667,0.145258272333,-0.194170208167,0.147970290333,-0.206097644833,0.469552682667,0.431387752667,-0.0115093428317,-0.1490154075,-0.09202620365,0.0742893632],[-36247.5594167,-5977.77682667,-3962.23209167,-394.976575667,2612.92780833,-501.462581667,1198.26345667,649.6495225,-926.465093333,-536.126961333,-820.588897333,345.790271167,-348.196947,-1049.2587,431.805891,-551.688110167,-405.3512735,-294.752203,445.869634833,-294.607768833,389.425031,232.633359,-68.8637633167,-769.588827667,-153.0358275,-30.8834616333,-37.0031166333,208.3182695,-122.044499333,239.963542833,-16.84954915,-143.612832667,-290.358986667,-79.6174087333,8.39923317333,-6.56038911,34.22739555,12.4128266667,52.0348555,-44.9926485167,74.4861323167,-36.6960977667,-66.9629838333,-41.8730197667,-27.96701725,21.9152342167,36.5807144167,-20.7477825833,11.9815864833,12.30288275,5.29805379,6.71646446667,-15.3064352833,15.2617918667,-11.2520431333,-15.59927305,3.380554715,0.527855641,5.94710612333,17.4691738833,-13.8148464833,-5.94065626667,-6.68751050667,4.66007846667,0.265971247667,0.0912494332333,-0.481547775,-3.05456733167,1.20790538333,-1.071651374,-0.382276307667,3.10590038333,2.47900596667,0.208587855833,4.31433118667,-5.92878516667,-2.26904997333,-3.34977414333,2.118053025,3.15858929833,0.554531938833,-0.919604630333,-0.300104551833,-0.515649478833,0.123131783167,-0.332925817167,0.2442801665,1.24831830167,0.870720593167,0.9221731325,-0.232007953333,0.767311772667,-1.51726365833,-0.307361316667,-0.916487028,1.147972585,1.45931674167,0.0332450222,-0.4910865685,-0.149354390667,-0.250673404167,-0.0354516041167,-0.144707487667,0.2655004895,-0.126123586833,0.0582078760167,0.5535648705,0.131947487333,0.229307808167,-0.00951280687333,0.1185655931,-0.208545557667,0.123363849383,-0.2166672645,0.472233771333,0.439881508667,-0.0171311504833,-0.169532129833,-0.09566989925,0.0791720431667],[-36474.5991667,-5954.47642833,-4094.28508833,-369.495537833,2707.18263333,-503.318101667,1185.60329,635.735725167,-946.20434,-547.887187333,-812.280218167,367.8397755,-346.779519333,-1032.78749,464.0370485,-570.959103333,-425.680618167,-291.058905333,465.437325667,-294.753224667,427.660163333,247.421761667,-69.3254939,-783.114562667,-160.224521833,-37.0579788667,-36.1511161,214.455011833,-125.7062625,255.322551333,-18.2362394167,-146.849589667,-289.630705,-91.5641538333,16.0533230567,-6.92580550333,33.9747985167,12.86377815,52.3222095167,-47.9959329333,78.2255564833,-39.0604948333,-68.7415589333,-38.0348754167,-33.2987883,26.48671895,37.3891704333,-21.2641029833,12.7481611,12.6798268833,5.42485633833,6.32699197667,-16.6821811,15.80449565,-12.2157488167,-16.0629841167,5.05446063667,-0.903739335167,7.44515757167,17.6170414333,-14.38053645,-6.37022377333,-7.09074125,4.96583289833,0.415857167,0.0747233159167,-0.621997875667,-3.38238899667,1.18928193333,-1.320880145,-0.369727292833,3.45025394667,2.205409265,0.5436090325,4.18054530333,-6.23026398333,-2.523408255,-3.54435677333,2.16719045667,3.25567405333,0.579714388333,-0.8822747665,-0.311446449,-0.527925004667,0.131650429667,-0.3618519135,0.203152822833,1.311063995,0.874112148,0.893361448667,-0.189168974833,0.67638894,-1.60683535333,-0.403496078667,-0.962844547833,1.16072661667,1.503249155,0.0218989694933,-0.5295565495,-0.1689150465,-0.243625727333,-0.03509498865,-0.134745520167,0.300775967333,-0.131284444833,0.0570739387833,0.581310663,0.108664811267,0.237496433333,-0.0122170554733,0.0911400651167,-0.2239755305,0.0985391685833,-0.226720679833,0.473383314333,0.447789043,-0.0239387344167,-0.189371699,-0.0995511809667,0.0836155784833],[-36740.4017833,-5912.34587,-4178.92681,-347.605562,2814.6869,-478.952039333,1150.53458333,592.630460667,-960.037500833,-550.700915667,-795.677928167,384.513671167,-356.680574667,-1014.32192417,489.9543495,-587.968359833,-443.587404833,-285.708192,483.349539167,-295.958687833,464.898224833,260.075563,-69.58609835,-795.9126095,-167.195869833,-43.0610612667,-35.2135995167,220.173504333,-128.956032667,269.7881665,-19.95992615,-149.642159833,-288.778755,-103.402643133,23.7974896,-7.36838684,33.5932516333,13.2038256167,52.5408188,-50.7732432167,81.5719689667,-41.41716905,-70.30309965,-34.2846664,-38.54479455,31.0095872,38.1933512333,-21.64994985,13.47764385,13.0015093667,5.50906867833,5.92908810833,-18.0084063833,16.2387249333,-13.1796850167,-16.4876056833,6.67175343333,-2.323601244,8.89603764,17.7564354833,-14.8899129667,-6.78482724167,-7.46462210667,5.26656431333,0.560702106167,0.0548914612833,-0.7613929655,-3.710751325,1.15899112833,-1.57460679833,-0.360636956,3.77529945667,1.929746915,0.853242306,4.04407136667,-6.51807513833,-2.77592208833,-3.72084884833,2.20629612667,3.34517483,0.606051865667,-0.841668442,-0.320097683667,-0.538380277833,0.137431621167,-0.3866312245,0.160511216,1.36951543833,0.871854554833,0.862223550833,-0.156032864167,0.583580744833,-1.69566478833,-0.500452604333,-1.00358948967,1.16859962,1.544351575,0.00871803687667,-0.5668845195,-0.1882539515,-0.235057815167,-0.03347845785,-0.124008015167,0.335799377,-0.134011914,0.0558289912333,0.6079077325,0.0841234713,0.245083490167,-0.0176785723167,0.0630318945167,-0.240544038833,0.0737177482,-0.2359030615,0.472673963833,0.455129185167,-0.0319801804,-0.208786775333,-0.10376161345,0.0877845969333],[-37045.5639,-5867.868215,-4223.502395,-328.115879,2928.96513833,-433.617065833,1088.60058667,514.576705167,-967.936185167,-545.3408055,-772.297829,395.643472667,-377.4442565,-992.675421833,508.974971667,-602.89921,-458.62486,-278.629016333,499.794812667,-297.216035833,501.368530167,270.008263667,-69.4323546333,-808.213957667,-173.998381667,-48.6409635667,-33.9978129167,225.532599667,-131.4640765,283.368006833,-22.2094033833,-151.921157667,-287.845820667,-115.130989,31.7430940667,-7.88430209333,33.1229995,13.4875719167,52.6993188333,-53.2777086833,84.49728535,-43.7709740333,-71.6407482,-30.63968175,-43.6764880667,35.5124270667,39.03606255,-21.9008283833,14.17280165,13.2570425,5.55231243167,5.52255212,-19.2859423167,16.5464315833,-14.1257545833,-16.8796585333,8.22361637667,-3.71923805167,10.3037250467,17.9011821833,-15.3378136,-7.19465520833,-7.80609695333,5.562574425,0.6936895605,0.0283935112567,-0.899806354167,-4.04194717833,1.11102740833,-1.825124525,-0.3591308715,4.077627995,1.65544023167,1.13767945917,3.90837124333,-6.78949042333,-3.030568865,-3.87678293333,2.23577721667,3.42791211333,0.633775887,-0.799056285667,-0.3272623055,-0.546966145667,0.13962225,-0.408567533333,0.117659051967,1.42224151,0.862971538,0.829019837,-0.132608758167,0.489603192,-1.78330871833,-0.599098276667,-1.03788543333,1.17136804167,1.58290449333,-0.00648443512667,-0.603735199667,-0.2072240235,-0.224871832333,-0.0307661761333,-0.1125658935,0.3703260395,-0.134440562,0.0543123309333,0.6330498345,0.05824857345,0.251894024,-0.0259573133,0.0344656864767,-0.258421776,0.04876481425,-0.244011554,0.469756128833,0.461967888833,-0.0412711300667,-0.228076134,-0.108360597,0.0918146173333],[-37384.3491,-5823.80573833,-4234.0812,-310.266868833,3049.20752833,-372.075804167,998.2498745,399.143892167,-970.501715833,-531.645897167,-743.547153833,402.437948167,-406.838837,-966.580568167,521.168540167,-616.0735265,-470.474513,-269.7311905,515.2467475,-297.071178,537.238613833,276.996811333,-68.6764043667,-820.112812833,-180.671319667,-53.6628212167,-32.3030328,230.57991,-132.871072,296.038328333,-25.06396575,-153.615588333,-286.800841667,-126.746993667,40.0281738167,-8.45863132833,32.5748746667,13.7729389667,52.7798094833,-55.4792595,86.9670235833,-46.1114884,-72.7394876333,-27.0992886833,-48.6679559167,40.0409936333,39.9448893167,-22.0085583667,14.8378174167,13.4345428833,5.55690695167,5.09880383833,-20.5202187333,16.7093693833,-15.0377780833,-17.2412259167,9.70228447833,-5.07956133167,11.6794146167,18.0552404833,-15.7162400167,-7.61060756833,-8.113303985,5.853647575,0.809771735333,-0.00823365217333,-1.03827885167,-4.37789605167,1.03955582783,-2.06600781667,-0.368264456333,4.353120985,1.38593590667,1.39903956,3.773493955,-7.04036434333,-3.292029325,-4.01068650833,2.255710095,3.50378066667,0.662957835667,-0.755118892167,-0.3343007375,-0.5534087605,0.137803101667,-0.4290349415,0.0757909109333,1.46774020167,0.846277960667,0.794222604167,-0.118680201833,0.394541433,-1.868871175,-0.700638252167,-1.06536153,1.16861148167,1.61865108667,-0.02391263453,-0.640796276333,-0.225647259333,-0.212916894667,-0.0271807952667,-0.100368441683,0.404177598667,-0.132788445667,0.05244954705,0.656270819,0.0309794084017,0.257813815667,-0.0371707873667,0.00568989445667,-0.277686625,0.0234521596867,-0.250950775667,0.464199592667,0.468187907167,-0.0518394237333,-0.247592710667,-0.113364554167,0.09578048425],[-37749.2457,-5778.49174333,-4216.12141,-293.517024667,3174.200275,-298.523716667,878.096659167,245.766716683,-968.5523435,-510.000662833,-710.773643,406.058660167,-442.412296667,-935.232018167,526.794269167,-627.825609333,-478.985789167,-258.985305833,530.099154333,-294.213661667,572.4911405,280.869427667,-67.21726945,-831.7109515,-187.226690167,-58.0128536167,-29.9606830833,235.329599833,-132.9015965,307.747742667,-28.5982257333,-154.681642833,-285.610707333,-138.2444385,48.77282,-9.065483625,31.9646529833,14.1112489333,52.7589475,-57.3663466833,88.9527025667,-48.4315792667,-73.58573605,-23.6652633667,-53.4925772167,44.62824385,40.9387566167,-21.96908,15.4775536667,13.5259351,5.526021465,4.6501804,-21.7153864833,16.71414245,-15.90171845,-17.5719121167,11.098235375,-6.39397067167,13.0296366167,18.2181737167,-16.0190590167,-8.04110131,-8.38568976167,6.13868399,0.905064107,-0.0573978752767,-1.17709032833,-4.718332645,0.940228754667,-2.29139023167,-0.389842160167,4.59725781667,1.124661175,1.63844983,3.63844237,-7.26692260167,-3.56355607833,-4.12197617167,2.26641585167,3.57225254667,0.693310007,-0.710426859333,-0.3422763075,-0.557254248,0.132221974167,-0.449233843,0.0361320117493,1.5048041,0.820633265,0.758426093167,-0.114067044167,0.2984235205,-1.95144359,-0.8057603085,-1.08605257167,1.16010083333,1.65113267333,-0.0437550116833,-0.678607149,-0.243392990667,-0.199116581167,-0.0229446751833,-0.08736918345,0.437233471667,-0.129337431167,0.0502516671333,0.677111925333,0.00232560275667,0.2627801265,-0.0513672608167,-0.02299235924,-0.298362432,-0.00232811735333,-0.256728744667,0.455662149833,0.473619237,-0.0636928464833,-0.267617379,-0.118751812833,0.0997358391],[-38130.7557667,-5724.81029833,-4171.63465667,-278.3908435,3297.45965,-214.706508667,726.509912333,59.7094039,-963.606800667,-483.502007167,-675.179410833,406.6580625,-482.301314333,-899.583873167,526.235664333,-638.605481333,-484.642278333,-246.657804833,544.302468667,-288.372913,606.665897833,281.4184805,-65.2507007167,-843.3859,-193.631852833,-61.6057313167,-26.9432182667,239.725396,-131.667414833,318.467481,-32.936935,-155.202446167,-284.352594333,-149.624608667,57.99152555,-9.64789598333,31.3488180833,14.5278699167,52.6293167,-58.9938782667,90.4849486167,-50.7519907667,-74.1928291833,-20.3679393333,-58.1284746333,49.2501374833,42.0212755333,-21.8006200333,16.1039853833,13.5415194667,5.466936265,4.18079749167,-22.87057575,16.5719396,-16.7135266,-17.8693795167,12.3985321,-7.65309961667,14.34181625,18.3859432167,-16.2538636167,-8.48538494833,-8.62852270833,6.41612687,0.979413568833,-0.117285286517,-1.31372721,-5.05622187833,0.814288918333,-2.49738137167,-0.421590776333,4.80657516333,0.8756688845,1.85294907333,3.50298307667,-7.47034762333,-3.84295661667,-4.21379551,2.27010413167,3.63325845667,0.723673045667,-0.66570345,-0.351050556833,-0.557991243833,0.125225251,-0.470032191833,6.45690473333e-05,1.533985245,0.785699434333,0.722882343,-0.118767713833,0.202019945,-2.03112595,-0.913068125833,-1.10154659,1.14694793333,1.68020250333,-0.0659747077833,-0.717290512167,-0.260626909333,-0.183783366333,-0.0182367330333,-0.0737058396,0.4696600255,-0.124674518667,0.0480116525833,0.695523253167,-0.027420035665,0.267001290333,-0.06827996945,-0.05104684095,-0.320425340167,-0.0281402154467,-0.261768636167,0.4444177735,0.4782329565,-0.0767195504167,-0.288183574333,-0.124440091667,0.103704310917],[-38523.9544667,-5662.57676167,-4102.79620667,-267.550258,3412.01585333,-121.078347633,543.783388667,-150.361968483,-957.261841667,-455.040165,-637.6197275,404.08178,-524.863519,-861.127970833,519.254026167,-648.695495667,-487.974837333,-233.062226333,557.485253333,-279.715631,639.148668167,278.4027945,-63.0241501,-855.373095333,-199.801677167,-64.4117129833,-23.2746604667,243.6436605,-129.397830167,328.161177667,-38.1580208,-155.273019833,-283.100595333,-160.8649475,67.6121548167,-10.1473593667,30.7749887333,15.0358179667,52.3906288833,-60.4180856833,91.6036818333,-53.0833146,-74.5725141,-17.25606355,-62.54970665,53.8564470833,43.1749558333,-21.5147303667,16.7257427,13.4960581833,5.38792712,3.70118026333,-23.9768798333,16.2980177,-17.47214145,-18.1289534667,13.5843330333,-8.84891532833,15.6003933333,18.5496329333,-16.4281165167,-8.93604908,-8.84813990333,6.68345827,1.03503914983,-0.184542022667,-1.44475243667,-5.38222806833,0.663978318,-2.68180473,-0.460264033333,4.97760826333,0.642528292333,2.03971752333,3.36743896333,-7.652628415,-4.12559809,-4.28987763833,2.26824185,3.68648921,0.752836776833,-0.621434126,-0.360088262833,-0.555327425167,0.119309711,-0.492190530833,-0.031113497984,1.55605525333,0.741621798167,0.688932454833,-0.132791180333,0.10663324575,-2.10827373833,-1.02070900933,-1.11368188667,1.13023535833,1.705618505,-0.0901415282667,-0.756637207333,-0.27749328,-0.167391671333,-0.0132515463667,-0.0596141622167,0.501560929167,-0.1194274265,0.0461863875833,0.711460668333,-0.057832725,0.270765441167,-0.0876665625833,-0.0778574351333,-0.3438184845,-0.05351809905,-0.266549406167,0.430862731667,0.481983055167,-0.0906781844167,-0.309193366333,-0.130359731667,0.1076013],[-38924.20805,-5594.00291833,-4011.85853333,-263.907565833,3510.70964,-17.7196821167,330.596894533,-375.499616333,-950.977527,-427.3253095,-598.69679,398.069425333,-568.5313795,-821.334370333,505.390575833,-658.266192833,-489.463521167,-218.441868167,569.157332333,-268.465321667,669.289867167,271.5448795,-60.7749091667,-867.774772667,-205.624658167,-66.4088371333,-18.9727890833,246.918003,-126.325059833,336.771827833,-44.32632515,-154.968650167,-281.891485833,-171.922348,77.5430121,-10.5086403,30.28345845,15.6458381667,52.0348781667,-61.68687065,92.3418767833,-55.42876085,-74.7259548833,-14.37721155,-66.72411995,58.3894439667,44.3738808833,-21.11798685,17.3473387,13.40305945,5.29642935833,3.221546185,-25.0211636167,15.9061162167,-18.1754238333,-18.3430317833,14.63487695,-9.973344355,16.7886700167,18.6973241667,-16.54670385,-9.383455545,-9.049950605,6.93696756333,1.07446042,-0.2558997615,-1.56655293667,-5.68616829833,0.491465211333,-2.842676135,-0.502451742833,5.10648757333,0.428273736167,2.19600963667,3.23173669833,-7.814842895,-4.40600592,-4.35342401167,2.26167850167,3.73104796333,0.779538442,-0.5779378725,-0.3688777475,-0.548922932167,0.116892451333,-0.516387921333,-0.05617430485,1.57154559,0.6886004805,0.657705610833,-0.1561055475,0.0136093405167,-2.18302155833,-1.12669366333,-1.12411454833,1.11078446667,1.72685398167,-0.115740123317,-0.796274452833,-0.294056587333,-0.150404446333,-0.00820993565333,-0.0453141956167,0.532941701667,-0.114194199167,0.0452484106167,0.724756628833,-0.0884467471667,0.2743000195,-0.109295382367,-0.102793675083,-0.368451477,-0.07800756275,-0.271498522833,0.415324786167,0.484739557833,-0.1052905353,-0.330481403667,-0.136431256,0.111304508167],[-39323.0308167,-5519.30115667,-3899.237465,-269.9657825,3586.09551667,94.0120063667,88.5263193,-607.320905667,-946.295390167,-402.944391833,-558.9476305,388.420936667,-611.506605167,-781.662267667,484.228028333,-667.396590333,-489.516519,-202.921153667,578.885613333,-254.8586925,696.552100333,260.6498775,-58.7328919833,-880.5204105,-210.9587285,-67.5828142333,-14.0518459367,249.378739833,-122.689883833,344.234390167,-51.4771790333,-154.353602833,-280.722525667,-182.733343333,87.6824455667,-10.6812816333,29.90636975,16.367784,51.53957115,-62.83896895,92.7263355167,-57.7805722833,-74.6461212667,-11.7585501983,-70.6242864,62.7918445333,45.5820979167,-20.6169772167,17.9698885833,13.2745154167,5.20109625833,2.74844178167,-25.9867695667,15.4106553833,-18.81833325,-18.50150465,15.5331980667,-11.0191652883,17.8891624333,18.8147918667,-16.6114568167,-9.81696504167,-9.23728678833,7.17211373333,1.100172845,-0.328326685167,-1.67564347333,-5.95738602167,0.298778674817,-2.97816099,-0.544647143667,5.18892385833,0.235009784333,2.319246845,3.09437858833,-7.95734541667,-4.67797199,-4.40765847167,2.25119592833,3.76539039333,0.8023449955,-0.535402137667,-0.377126649,-0.5384113975,0.120424167667,-0.543496749667,-0.07417139845,1.580759925,0.62672772,0.62981815,-0.188453892333,-0.0760047680167,-2.25527610833,-1.22891693,-1.13428366167,1.08906649167,1.74310926167,-0.14229416,-0.8357607075,-0.310344437167,-0.133224134667,-0.00334905753167,-0.0309957145333,0.563753235,-0.109571517667,0.0456233937333,0.7351291735,-0.118795314833,0.277752466333,-0.132911743833,-0.1252329195,-0.3941740545,-0.101154764217,-0.277009264833,0.398085629333,0.486278398833,-0.120243859167,-0.351781367333,-0.142565532333,0.114689581667],[-39705.1176667,-5439.63857167,-3766.29561,-286.2234835,3630.42518,211.327159083,-180.090695967,-838.590758833,-944.452937,-384.050618667,-518.710026833,374.985344667,-651.780123,-743.452802333,455.343900833,-676.0419735,-488.337677667,-186.465322167,586.3181315,-239.086909333,720.5391435,245.623715333,-57.0737668333,-893.338917833,-215.6447735,-67.8977957833,-8.52495509667,250.870250667,-118.71702,350.479295333,-59.5941402833,-153.463608,-279.532662833,-193.2034425,97.93471185,-10.6261823667,29.6695617167,17.20496355,50.87503005,-63.9006428833,92.7781039,-60.1099054333,-74.3146944,-9.397990185,-74.2229329333,67.0165515167,46.7535412167,-20.0127218333,18.5898276,13.1197088333,5.10965851333,2.286929335,-26.8549669167,14.8274383,-19.3903185333,-18.5919328,16.2693922167,-11.9790236333,18.8877424333,18.8852702833,-16.6175048667,-10.22553185,-9.410132515,7.383545485,1.11415290167,-0.399363196333,-1.76821928667,-6.18581159833,0.0883948431,-3.08640094,-0.583488484333,5.22115027333,0.0638783472833,2.40838645333,2.95222454667,-8.07814968833,-4.93500915,-4.45495695167,2.23724432333,3.78748834833,0.819742722333,-0.493960563,-0.384695399667,-0.523365627667,0.132046015833,-0.574295188,-0.0846309354,1.58375775,0.556177885833,0.605266385833,-0.228994802333,-0.161589217483,-2.32416796,-1.325399115,-1.145003595,1.06500326333,1.75343499167,-0.169427530667,-0.874576393667,-0.326323370833,-0.116183978883,0.001137390135,-0.0168365940767,0.593841533,-0.106059232667,0.0475828055167,0.742226637,-0.148400526333,0.2811524805,-0.158165699333,-0.144615942167,-0.420629536,-0.122607314833,-0.283291717667,0.379277685833,0.486346031167,-0.135240830833,-0.372719322,-0.1486739035,0.117622714833],[-40038.0647167,-5366.84027833,-3625.41598833,-305.266173167,3636.17255167,330.925134,-472.592052167,-1064.8224095,-944.770945167,-371.403682,-477.451743,358.048072,-687.6469195,-707.208218,418.284675667,-683.9621375,-485.5598195,-168.685357,591.281800333,-221.174414667,741.163606833,226.545088,-55.7686509333,-905.662989667,-219.582998333,-67.2100930333,-2.35808284,251.278947167,-114.540586,355.51372,-68.5257198167,-152.2380735,-278.077629167,-203.195642833,108.277133133,-10.34193453,29.59563625,18.1444462667,50.0183174167,-64.88125885,92.53349965,-62.3344018,-73.6871241167,-7.22003581167,-77.4800523,71.0618910167,47.8333,-19.2812666833,19.1932386833,12.93995955,5.01909125333,1.84334256167,-27.6104114833,14.1762977667,-19.8695039,-18.5985549833,16.8558770333,-12.8466227833,19.7906716167,18.8858733,-16.5430512833,-10.5996899833,-9.56225960333,7.564790895,1.11639379167,-0.4692516085,-1.83993486333,-6.36507721833,-0.135218216683,-3.165895645,-0.616133265833,5.2046,-0.0864612348667,2.46946226833,2.79929027333,-8.167700845,-5.17216055,-4.49366486333,2.21878764833,3.795436485,0.830580341167,-0.453733684667,-0.391569142667,-0.503118282667,0.152479453667,-0.608587417667,-0.08837035015,1.58035591833,0.477893941667,0.582874684333,-0.275036401167,-0.243605400833,-2.38635953,-1.41513821,-1.15531384333,1.0374359,1.75711699333,-0.197046280833,-0.9120495395,-0.341753743333,-0.0994706950833,0.00522705383,-0.00294099035667,0.622789561667,-0.103805988667,0.0508614494,0.745769926833,-0.176820210333,0.284211198167,-0.184390207667,-0.1607311105,-0.446866407833,-0.1424724615,-0.2899351965,0.3584935255,0.484869523,-0.150207996667,-0.3928415335,-0.154697646833,0.119913767333],[-40292.4345167,-5317.63175833,-3496.89308167,-318.3962635,3594.64765,446.888944833,-785.424909,-1283.03409833,-945.7520405,-365.600566667,-434.885895667,338.43657,-717.924192667,-672.945812333,372.642863333,-690.692264667,-480.630476333,-149.073048167,593.7275485,-201.2160655,758.5069095,203.567729333,-54.73024025,-916.743147333,-222.653854833,-65.3262175667,4.53458870333,250.490885667,-110.2725935,359.381764167,-78.0666115333,-150.577366667,-276.0134825,-212.553735833,118.6999095,-9.83963369833,29.7080197167,19.1776879,48.9384788667,-65.774282,92.0313978667,-64.3505279333,-72.7039507333,-5.118630175,-80.3503642,74.9331873333,48.7596605667,-18.3916886333,19.7593234167,12.7332465167,4.92330801,1.42198568333,-28.2332747333,13.4758504,-20.2293414667,-18.5022971833,17.3113796167,-13.61662015,20.6083470167,18.7899647,-16.3611222167,-10.9289007,-9.684800055,7.707858675,1.10596353167,-0.539476482,-1.88639522333,-6.48865745333,-0.367812847667,-3.21503451667,-0.639720802333,5.141545825,-0.21846898105,2.51037844,2.62838186833,-8.21388924833,-5.38399600167,-4.52051865833,2.19413916333,3.78707114167,0.8337457595,-0.414861024167,-0.397891484167,-0.476827139833,0.182003189833,-0.646037112333,-0.08655006645,1.57007747833,0.392834810833,0.561029866667,-0.323305754833,-0.322847700333,-2.43765403,-1.49709928167,-1.16364332833,1.00478951717,1.75339028833,-0.225153697333,-0.947336607,-0.3562598275,-0.0832215909167,0.00893070640167,0.01063677529,0.649985243333,-0.102866474667,0.0550508276333,0.745372818,-0.203643737167,0.286521796667,-0.210812733833,-0.173465947,-0.471729678,-0.160934750667,-0.296337387333,0.335133484167,0.481802832833,-0.165147970333,-0.411606776333,-0.160574945833,0.121330683833],[-40456.6514167,-5320.87441833,-3408.507665,-320.235155,3495.47900667,550.228523333,-1111.95915517,-1491.39145667,-945.359283167,-366.993395833,-391.301395833,317.496618333,-742.670459333,-640.769943333,317.517680167,-695.318146167,-472.895383,-127.129147333,593.561846,-179.7256435,772.749222167,176.830452167,-53.7221503833,-925.5295885,-224.646542667,-62.0547820833,12.27292868,248.362361,-106.057384833,362.1909295,-87.9574406833,-148.302279,-272.919410667,-221.104868,129.1417565,-9.140087355,30.0251226,20.3093073167,47.6025875833,-66.5454023667,91.32352785,-66.0365093667,-71.2804322,-2.98407700917,-82.7862956667,78.6282204333,49.4587351333,-17.2955254833,20.2569701167,12.4979297833,4.81876445,1.02754113967,-28.6910914333,12.7429287833,-20.4417211333,-18.2796136833,17.65312455,-14.2854659667,21.3549722333,18.5674412,-16.0383187,-11.1984483167,-9.77029804167,7.80246019333,1.08245921,-0.6116085795,-1.90362959167,-6.54808709667,-0.606856291333,-3.23266425167,-0.6516871625,5.03452506833,-0.3355348765,2.54103043667,2.43207170333,-8.20320220167,-5.563989385,-4.53241041333,2.16013605167,3.76011835167,0.828221828167,-0.377515521167,-0.404108056167,-0.443897053167,0.220518863167,-0.686740179667,-0.0803788324333,1.55192380333,0.302205514333,0.53790694,-0.370246788333,-0.400099524833,-2.47367231333,-1.57027000833,-1.16831640167,0.965016861833,1.74143810667,-0.253440965667,-0.979408444833,-0.369278387,-0.0676684083667,0.0121398197183,0.0238217662833,0.674553426167,-0.103315981167,0.0597925619333,0.740454626667,-0.2284593525,0.2876318115,-0.236729407333,-0.182773608833,-0.494040901667,-0.178272585833,-0.301833551667,0.3085456,0.477079178833,-0.179968168,-0.4284104995,-0.166302810167,0.121570209667],[-40547.7604667,-5427.48578667,-3384.040635,-311.902821333,3331.64784167,634.712965333,-1438.58975833,-1689.03978833,-940.626954833,-373.734859333,-346.362496333,296.434083333,-764.030728833,-612.443560833,251.003610333,-696.1798835,-461.595910333,-102.424413083,590.129705333,-157.885884833,783.841892833,146.678086167,-52.0555584667,-930.460985,-225.252255167,-57.3564038167,20.9126572333,244.655666,-102.04378595,364.101043,-97.76545585,-145.065649167,-268.3686265,-228.697462167,139.378476,-8.30064724333,30.53095075,21.5376579833,46.0014017333,-67.1018804833,90.4799320167,-67.2458707,-69.2999838333,-0.758996318333,-84.7582567167,82.1241500167,49.84680415,-15.8930263667,20.63897195,12.2386122667,4.70650375333,0.675343588,-28.9346498667,11.9916875333,-20.4866337,-17.9065053,17.88558365,-14.8554064667,22.0544617833,18.1922642333,-15.5271829167,-11.38573535,-9.82073966,7.83739078667,1.04934466833,-0.685681767167,-1.88782128667,-6.535008995,-0.852168235667,-3.22081124833,-0.651234437,4.88769184,-0.441127756167,2.575181205,2.20648390667,-8.12111131,-5.70500838,-4.52875184833,2.110133615,3.713925455,0.8139426955,-0.341754511667,-0.410796113167,-0.404641893667,0.266660490333,-0.73113229,-0.0708383991333,1.52429692833,0.208589681667,0.512215395,-0.412284493,-0.475350618,-2.49038560167,-1.63446022167,-1.16761902833,0.915266327333,1.72119324,-0.280585355167,-1.00726414933,-0.379989004333,-0.0533740691167,0.0145591279667,0.03638176235,0.6953275705,-0.105130596333,0.06508366265,0.730329898167,-0.250709268167,0.2872079765,-0.261746969667,-0.188717518667,-0.5126407185,-0.195080896167,-0.305514706,0.2781437405,0.4708057885,-0.1942927245,-0.442758995167,-0.172134607667,0.120228093],[-40593.5258333,-5649.06307833,-3423.07018167,-293.179155333,3103.77702833,698.821994167,-1755.40114167,-1878.442715,-928.4811505,-385.126082333,-300.096845333,275.987131667,-784.1085725,-588.833948667,174.232094583,-692.0641585,-446.759049167,-74.858243,583.161555333,-136.305906667,791.9917295,114.218532983,-49.0686662167,-930.744255833,-224.3358785,-51.2802461,30.4814142833,239.316355667,-98.1954178833,365.283139667,-107.088246383,-140.585786667,-262.157373833,-235.324116333,149.374561333,-7.38297011833,31.2400827667,22.8778308167,44.1464927667,-67.3581597,89.55404365,-67.8996844667,-66.6878662833,1.61022118083,-86.28002015,85.4633577333,49.90188815,-14.1216490167,20.8747151667,11.9688018833,4.59124692167,0.371365954333,-28.93677505,11.2306604167,-20.35829875,-17.37285875,18.0305690833,-15.3299454167,22.7382552,17.6612017167,-14.79708895,-11.48626595,-9.83922866167,7.80698948333,1.0086686055,-0.76280512,-1.839205925,-6.44752956,-1.10402460017,-3.18007578667,-0.6396102715,4.71007102833,-0.535266084167,2.62448702167,1.950930935,-7.957300055,-5.80703320667,-4.50943690833,2.04221820333,3.65005022667,0.791107064333,-0.3086190915,-0.419123906167,-0.359708608,0.318896766833,-0.779516067833,-0.05778728865,1.48597924833,0.11447585915,0.4838223455,-0.4466528505,-0.549222087167,-2.48442028333,-1.69060268667,-1.16005926167,0.8548444035,1.69348937833,-0.305936287333,-1.03094751,-0.3879101625,-0.0409183784667,0.0158636099,0.04826122995,0.711578784,-0.1082806965,0.0709603263,0.714608163667,-0.2701894075,0.284988282833,-0.285429885833,-0.191713646167,-0.526469611333,-0.211818955167,-0.3065470675,0.243847167667,0.463252727,-0.207989474333,-0.454621751,-0.178236528,0.117278754667],[-40613.3834,-5916.86278667,-3488.536045,-269.531361667,2830.665295,748.718989333,-2050.581195,-2053.63134833,-909.796037667,-400.344541167,-252.9668815,258.683190667,-801.188611833,-570.230944167,92.1405239683,-683.186832667,-429.538501167,-45.0594826,573.275248167,-114.506076767,797.500435,81.7897955333,-44.605527,-926.104647167,-222.015556667,-44.2461966667,40.77647265,232.513088167,-94.3873371,365.889551833,-115.365675,-134.851499,-254.193656667,-241.118846333,159.2072845,-6.41558407833,32.10165475,24.3046530333,42.0538417,-67.3152007833,88.5906550667,-67.94456005,-63.4656179333,4.19934815667,-87.4233824833,88.7138657333,49.6454135,-11.9775115567,20.9703163167,11.6957144333,4.475193025,0.103536142833,-28.7183878333,10.4706213217,-20.0675240333,-16.6905294833,18.1296481,-15.7257829,23.4332122833,16.9864421167,-13.84708275,-11.5064158333,-9.83133863333,7.71673201667,0.963429833667,-0.842550366667,-1.76464096167,-6.29556186333,-1.36012707833,-3.11566701833,-0.619304709,4.51509835833,-0.619291469167,2.69627168,1.66650376833,-7.711286795,-5.87329197667,-4.47684723333,1.959497575,3.570885185,0.7610291505,-0.277885473667,-0.4292269815,-0.310621742167,0.375189238833,-0.831374618833,-0.0424605832167,1.43726585333,0.0219930660833,0.452820413,-0.471521023,-0.622977813667,-2.454990745,-1.73946513833,-1.14570950167,0.785678732667,1.65939477,-0.3292387925,-1.05108224333,-0.393000091833,-0.0302246726,0.0161240007167,0.0595468846,0.723325141,-0.112686782667,0.0769897097333,0.693693712833,-0.287173976833,0.280878189667,-0.307226261167,-0.1924805045,-0.535047225333,-0.228500833667,-0.304757881333,0.206453669833,0.454641042833,-0.220944096833,-0.464198649667,-0.184636666833,0.1130117955],[-40620.9623667,-6154.57963,-3538.35355333,-248.998501833,2533.02496833,792.063063167,-2311.42674667,-2203.05635833,-887.031506833,-418.531208167,-205.2112235,247.557393833,-811.438235333,-556.5619765,10.0146496567,-670.207009667,-411.205817333,-13.66671985,561.282174167,-91.5421154333,800.718075333,51.8160371833,-38.8023399,-916.320854667,-218.454979333,-36.7229702667,51.57695615,224.459982667,-90.4723795667,366.05549,-122.035089667,-127.9926415,-244.3987615,-246.221281,168.977191,-5.40911892,33.05069785,25.7850571833,39.7428013,-67.00426195,87.6228806833,-67.3333886167,-59.7005673333,7.08325578333,-88.2628653167,91.9499883833,49.1034435,-9.47371022833,20.9421902,11.4235442,4.35826013333,-0.142410409167,-28.3144188167,9.71909962667,-19.6277181667,-15.8813823333,18.2255351,-16.0605965,24.1668386667,16.1823019,-12.6850792167,-11.4543993333,-9.80281957333,7.574616135,0.916445022833,-0.924765560333,-1.67204871333,-6.09210954167,-1.61853902167,-3.03358683333,-0.593777166,4.31678318833,-0.694679128667,2.797760755,1.35495468167,-7.38570464833,-5.90781562,-4.43383086333,1.86583968833,3.47861618667,0.725209643167,-0.2491086505,-0.44115845,-0.259149949167,0.433352557667,-0.886144308,-0.026359543,1.37878446,-0.06659478975,0.419379855833,-0.4850708255,-0.697764358833,-2.40223894,-1.78203933,-1.12504234333,0.7101630595,1.61986622333,-0.350206978167,-1.068313365,-0.395326131167,-0.0210960729667,0.0154649491167,0.0702957132,0.7307560585,-0.118250699333,0.0826619651833,0.668202356,-0.3019204615,0.274831629333,-0.326569138833,-0.191747824167,-0.538128781167,-0.245210531667,-0.300147849,0.166951652,0.445152739667,-0.232971194,-0.471719745,-0.191321532,0.107748248],[-40613.8948,-6311.74226167,-3554.18145,-237.282745167,2228.07002667,831.453449167,-2527.25241,-2314.76889667,-862.831122667,-438.026287667,-157.275967,245.396284167,-810.799667833,-547.753118167,-68.8230392317,-653.948001833,-392.467786333,18.92267575,548.115607167,-66.4991758167,801.942118167,25.888338855,-32.2338945333,-901.437987167,-213.847429,-29.0312073167,62.7561872833,215.456819333,-86.3575987667,365.891400667,-126.760961167,-120.344242,-232.8374715,-250.7723615,178.744013,-4.37435031667,34.0358009333,27.3023888,37.2636396167,-66.47929745,86.6765966667,-66.0620879833,-55.52182375,10.2799867383,-88.8774549667,95.2209294333,48.2938747167,-6.64929610167,20.80729995,11.1514980833,4.23994342,-0.373656497667,-27.7640341667,8.98225287833,-19.05648955,-14.9788057667,18.3447768833,-16.3549183167,24.9566233,15.2590944667,-11.3348857017,-11.34101405,-9.76280215167,7.38855587167,0.867830223333,-1.010508053,-1.56879431333,-5.84987202333,-1.87736063,-2.93908199167,-0.566876143667,4.126283625,-0.763594666667,2.93288201167,1.01698964483,-6.98999793833,-5.91669112833,-4.38593141,1.76477615167,3.37429088333,0.685089701333,-0.2225685835,-0.4554325935,-0.207421471833,0.491620826667,-0.943189447,-0.0104003383167,1.31181093333,-0.14902235585,0.383802325833,-0.486484477167,-0.774870497833,-2.328693525,-1.820410265,-1.099998975,0.630529391167,1.57509854667,-0.368456687,-1.08344893667,-0.394950913333,-0.013457090255,0.0138987550833,0.0803583655667,0.734189879167,-0.124846953,0.08768387835,0.6390312925,-0.314478626667,0.266953546167,-0.343168858167,-0.190250654333,-0.536149542,-0.262464259333,-0.293295306,0.1262854327,0.434612606833,-0.243811971833,-0.477614238,-0.1982639015,0.10173286255],[-40572.21125,-6341.32637167,-3538.43668333,-235.575208,1935.44257,864.734272667,-2688.25584167,-2381.27651,-839.2818465,-455.631881167,-110.2193089,255.1608355,-796.617891833,-543.955078333,-142.326757467,-635.2843135,-373.576500667,52.3012578833,534.907326833,-38.7901361883,801.355160667,5.07800665333,-25.6101325333,-881.690025667,-208.4324095,-21.4322524667,74.2022732667,205.882349,-82.0036033167,365.488797333,-129.340186333,-112.289359,-219.6792055,-254.912499833,188.494459833,-3.338213525,34.99417885,28.8435675167,34.6872524833,-65.7955198167,85.7833586333,-64.1504663167,-51.0664008,13.7625731167,-89.3498195167,98.5334913833,47.22286385,-3.558027756,20.57825505,10.8709182167,4.12055431667,-0.594286801333,-27.1028073333,8.27129971833,-18.3741441,-14.0147136333,18.49957475,-16.6319690333,25.8041889667,14.2210941667,-9.82872663167,-11.1772169833,-9.722652535,7.16580559167,0.815755299167,-1.10048035,-1.46253111833,-5.5799745,-2.13281317167,-2.83734903333,-0.541081173333,3.95156854167,-0.828956304167,3.10105683167,0.651532786,-6.537017975,-5.90635817167,-4.340577685,1.65930796667,3.257615645,0.642236206,-0.198762518,-0.472490049333,-0.157947822333,0.5485072025,-1.0015005595,0.00469430366667,1.23808504,-0.223374172833,0.3464529,-0.475963683,-0.8558815245,-2.23807960167,-1.856947575,-1.07360131667,0.5486974855,1.52437992,-0.383571399833,-1.097330315,-0.391810182167,-0.00721298384167,0.0114138649967,0.0894403072833,0.7339176625,-0.132356816333,0.0918721741667,0.607163005,-0.324827723167,0.257465354,-0.356909235,-0.188724580333,-0.529903058,-0.280921352833,-0.285215996,0.0852730128833,0.422421317333,-0.253187676333,-0.4824049125,-0.2054060025,0.0951426728833],[-40466.3601333,-6201.544025,-3490.65139833,-242.9483945,1675.10574,891.769420833,-2785.88778667,-2396.13443833,-818.447501167,-467.762019167,-64.5306416,279.625102,-766.4346085,-545.183086833,-208.88306,-615.189172,-354.747865333,86.0814985,522.7503505,-7.85621915333,799.168851333,-9.66020056167,-19.5447046667,-857.255515833,-202.464519167,-14.2261316717,85.7592938667,196.085520167,-77.3761986,364.946846833,-129.5728665,-104.152134833,-205.0468335,-258.735546833,198.210729833,-2.32271833167,35.8456060833,30.3793028167,32.0705640667,-65.0097567667,84.9757958,-61.6146375667,-46.4493976167,17.5178113167,-89.7439230833,101.8957602,45.8925332833,-0.246140082333,20.2704249,10.5719959833,3.99920865167,-0.8117504085,-26.3660146333,7.59680327333,-17.60170695,-13.0151948833,18.7031413667,-16.9112638,26.7137516167,13.0704953,-8.19329625167,-10.9729987167,-9.69031483,6.91407667667,0.760057093,-1.19419634,-1.36098406167,-5.29298966167,-2.381647985,-2.73484372833,-0.518093104167,3.79951470833,-0.893472588,3.302851585,0.257025821333,-6.03690318167,-5.88304431667,-4.30315391667,1.55161564333,3.12816343333,0.598087154333,-0.1774413185,-0.492253298667,-0.112953445833,0.602759472,-1.06027284167,0.0177488100333,1.15918580833,-0.288393455167,0.307706651667,-0.453549385167,-0.942380531667,-2.13324358833,-1.89408829333,-1.04809368667,0.4660550185,1.46701275667,-0.3952606135,-1.11060921667,-0.385943991667,-0.00216849465,0.00806656602167,0.09737432595,0.730289190167,-0.140702610667,0.0950302212333,0.573444207833,-0.333157786667,0.246629975333,-0.3677524995,-0.187859589,-0.520000338,-0.301317090333,-0.276682848833,0.044490070835,0.4080242025,-0.260916705667,-0.486536864667,-0.212690914167,0.0881090087667],[-40314.9110667,-5931.80604,-3425.51015833,-260.376471333,1440.91925667,908.964423,-2825.541995,-2367.78172333,-799.910734167,-475.7214485,-21.0682717667,316.268657667,-724.410055833,-551.7326745,-271.388616833,-593.635266333,-336.4469455,119.8506149,511.3029285,25.0653661783,795.402865833,-19.55651045,-14.1581556133,-828.962623333,-195.997446667,-7.508892125,97.2753823333,186.132683167,-72.7110072667,364.307772667,-127.927832833,-96.00618795,-189.363683167,-262.145067833,207.7941915,-1.33887771833,36.6032835333,31.8927288,29.4500488333,-64.1658687667,84.2771688833,-58.6073004167,-41.7007794667,21.4223156667,-90.0203888333,105.268432333,44.3376126,3.24927858733,19.8917809167,10.2689661033,3.883142725,-1.0201773665,-25.5666713833,6.96812485167,-16.7736552167,-11.9846598,18.9345638333,-17.17747785,27.6703803,11.83079035,-6.45360541667,-10.7307755833,-9.665096275,6.63771144833,0.7040723805,-1.28853185833,-1.26472557333,-4.99176176167,-2.62109407333,-2.63552829833,-0.496153677667,3.66853834167,-0.951559849667,3.532363365,-0.158454743833,-5.49991281833,-5.84835110167,-4.27376339833,1.44333676667,2.98726142833,0.553042674,-0.1586682465,-0.5143302125,-0.0728983081667,0.654690744667,-1.11891465,0.0293056850333,1.07655312867,-0.344204258333,0.269479642833,-0.421184425333,-1.03260052417,-2.017255615,-1.93208936667,-1.02365323,0.383831829333,1.40378550833,-0.403595927667,-1.12341756,-0.377660533667,0.00144168698167,0.00379730633667,0.104121335267,0.723778877833,-0.149835493833,0.0975563240667,0.538404166833,-0.3396468285,0.234962222667,-0.376113948667,-0.1874309985,-0.507155623,-0.323543920833,-0.267853768333,0.00452214949,0.391608746333,-0.267031906667,-0.4901515015,-0.220134515,0.0807329517],[-40146.8661667,-5586.29285833,-3361.197875,-288.9079,1222.987055,912.263258833,-2814.11018333,-2307.658255,-782.475834167,-481.3292705,19.4101741833,362.454566667,-676.040837167,-563.632314333,-333.398543833,-570.336410333,-319.144659167,153.219298667,500.152447,58.3997103833,790.111407333,-26.1300157,-9.47341783667,-797.605094667,-189.054332167,-1.36501693667,108.590159633,176.018741333,-68.2723065833,363.608167667,-124.945311333,-87.8827480333,-173.014838167,-264.9997815,217.126011667,-0.4045357315,37.283763,33.3630924833,26.8359098,-63.2954436167,83.706197,-55.2936146,-36.8349763667,25.3580582667,-90.1179537833,108.6016095,42.5928086167,6.89213153667,19.44706765,9.97830426333,3.77968967833,-1.21631525,-24.7118421833,6.39292593667,-15.9263600167,-10.9217222983,19.1687440833,-17.4090572333,28.6561775667,10.5270629467,-4.63493668833,-10.449923,-9.64335006833,6.34072411833,0.6523126125,-1.37979787667,-1.17279327,-4.67783813167,-2.84887922333,-2.543809415,-0.472076588833,3.55432671,-0.996465319333,3.7831046,-0.5854863645,-4.93600216667,-5.80230997167,-4.25064432333,1.33573405,2.83649332833,0.507522948333,-0.142207413833,-0.538121985167,-0.037518127955,0.704705733833,-1.17693467,0.0398701502,0.9916510385,-0.391690620667,0.233936786,-0.380944675167,-1.12416909333,-1.892824255,-1.97063795333,-0.9997188635,0.303093612667,1.33587489167,-0.408773041,-1.13557702667,-0.367295188833,0.00337144018,-0.00142912078,0.109749549667,0.714832240167,-0.1597033095,0.0999331062,0.502425136667,-0.3445472185,0.223045935,-0.382460299167,-0.18704795,-0.491907944,-0.347344793833,-0.258647467833,-0.0341044951983,0.373583740833,-0.271645373833,-0.493237517667,-0.227763435,0.0730787984],[-39983.4442833,-5211.86972,-3314.81431333,-328.488047667,1014.791864,897.898237,-2756.43707,-2226.343795,-765.037734833,-485.527250167,56.2832736333,416.592099667,-626.383299833,-580.461809167,-398.067193833,-545.094991167,-303.2219185,185.828416167,489.155569333,90.706688,783.521238333,-30.6622811167,-5.461753715,-763.764519,-181.6803475,4.078990445,119.536282667,165.7593585,-64.2849310667,362.928224333,-121.065603333,-79.7709115667,-156.274333333,-267.133902,226.100083667,0.458263622333,37.8785139667,34.7622559667,24.22595985,-62.4202689667,83.2862331667,-51.81223095,-31.8490924167,29.2403921667,-89.96656565,111.857111667,40.6830840333,10.653185515,18.9404116167,9.710940975,3.69381455167,-1.4028863,-23.8071247167,5.87731377833,-15.0926511833,-9.820465005,19.3871016167,-17.5830701667,29.6603312667,9.17961287167,-2.75615496383,-10.129955035,-9.618783825,6.02731476667,0.609368819167,-1.46445275833,-1.08550143,-4.35303088833,-3.06368376,-2.46471037833,-0.442429984167,3.45304215,-1.02164307017,4.05135606667,-1.01614588983,-4.3515684,-5.74538286833,-4.23030462333,1.22930208667,2.67711156333,0.462116279333,-0.1273783435,-0.562885522,-0.00658622472,0.752874098167,-1.23408827667,0.04945271115,0.905580821667,-0.431962515833,0.203096126167,-0.334237618167,-1.21508096167,-1.76137562667,-2.00980513833,-0.975008250833,0.224376937333,1.26432855833,-0.411064659667,-1.14675137833,-0.355125071,0.00351266153167,-0.00759335264333,0.114402729667,0.703768361167,-0.170274072,0.102520242017,0.465705678,-0.3482377415,0.211399443833,-0.3872049475,-0.186422426833,-0.474487766333,-0.372680470333,-0.248736510167,-0.0711204371667,0.354337938333,-0.274945808833,-0.4957270635,-0.235589132833,0.0651662953],[-39841.64305,-4851.39902333,-3303.68731833,-378.367051333,811.708586,861.855354333,-2655.94953,-2134.16363833,-746.483025167,-488.7028665,88.9277420833,477.7807245,-580.368196833,-601.412503333,-468.3542525,-517.736241833,-288.976675167,217.331286,478.347642333,120.586534967,776.000206,-34.3197116833,-2.02536032667,-727.862554,-173.926119167,8.676013625,129.9438695,155.386292833,-60.9477187833,362.382848667,-116.668353667,-71.6064624833,-139.3377385,-268.3474535,234.616326167,1.22386546017,38.36181015,36.0581601167,21.6106277,-61.5502765833,83.0443188,-48.2817302667,-26.71963655,33.00675195,-89.4816738,115.004376,38.6257176333,14.50988045,18.3741188833,9.47332486833,3.62903732,-1.58673097833,-22.8549317333,5.42620466667,-14.3012649,-8.67013668667,19.575427,-17.6731999,30.6773357,7.80531473333,-0.829865430333,-9.77038758667,-9.58233555667,5.70138957333,0.579645004667,-1.53908599333,-1.00423584867,-4.01897418667,-3.26494399167,-2.4032245,-0.403694231833,3.36132773333,-1.020377455,4.33558993833,-1.4434477,-3.74962948167,-5.67830378833,-4.20749575167,1.12382207333,2.51005384833,0.417511099333,-0.113234383883,-0.587814703333,0.020020744495,0.798946143667,-1.29033687667,0.05773627425,0.8190151175,-0.466206393167,0.178824481333,-0.281925571,-1.30353275833,-1.62317719833,-2.049931715,-0.947538339333,0.147749143983,1.19006405667,-0.410799098333,-1.156441755,-0.341350858667,0.00185637233167,-0.0146516850983,0.118267510167,0.690749306833,-0.181535564167,0.105561378167,0.428256606167,-0.351175025,0.200447853,-0.390711813833,-0.185340305667,-0.454868180333,-0.3996736885,-0.2375666445,-0.1064723223,0.334238342,-0.277178757667,-0.497489327333,-0.2436023935,0.05697777115],[-39730.5066333,-4538.61930833,-3336.13851667,-437.6092275,612.004434167,802.962818833,-2515.44976667,-2038.35094,-726.144119833,-490.728005,117.2254484,545.2963365,-541.673325333,-625.922244667,-546.554530333,-488.237927333,-276.712854667,247.358026,467.7678465,146.935907167,767.710010333,-37.9449297333,0.793660615,-690.164191667,-165.861728167,12.22789418,139.589670333,144.914756,-58.4148998167,362.005116167,-112.016280167,-63.3975337333,-122.330834167,-268.449001833,242.547404,1.867741575,38.6858425,37.19886565,18.9734242667,-60.69563335,82.9874707333,-44.79321435,-21.4504029,36.6114141,-88.5922225,117.9971725,36.4271648167,18.4332260167,17.7516263,9.26784128333,3.58549199167,-1.776212125,-21.8605938333,5.04259572333,-13.5781231,-7.46719820667,19.7220145833,-17.6615012167,31.69655145,6.41569333833,1.1279898895,-9.36960337833,-9.52489622833,5.36732508333,0.567868567167,-1.599870335,-0.930554052833,-3.678492555,-3.45132763167,-2.36538352,-0.353685938333,3.27587974167,-0.989249944,4.63317861333,-1.86213852333,-3.13440013833,-5.60108807167,-4.17730064833,1.01893286617,2.335666655,0.374545075333,-0.0984011072667,-0.611678803667,0.0424447899,0.8423206115,-1.345212275,0.0637576295333,0.732553175667,-0.495722841333,0.1622180515,-0.2249927035,-1.38815272833,-1.47891806333,-2.091070825,-0.915682785833,0.0732861982152,1.11364880333,-0.408232619833,-1.16396391333,-0.326141839167,-0.00148246147,-0.0224452957167,0.121546363667,0.675878030667,-0.193375569667,0.109145459833,0.390151733833,-0.353877786667,0.190533274667,-0.393321676,-0.183702473833,-0.433144959833,-0.428380905833,-0.224750530833,-0.140058232333,0.3135153665,-0.278536451,-0.4983088995,-0.251754937833,0.04847892245],[-39644.6707667,-4288.35920167,-3388.86855333,-506.487435833,417.721452,730.284525167,-2339.89590167,-1936.51941833,-704.743631667,-491.257376667,142.929192333,616.8734745,-510.3375075,-655.134197667,-633.499414167,-457.020556833,-266.875271667,275.5268225,456.894465167,169.510817667,757.817781,-41.7763673167,2.406671915,-650.841421833,-157.630711833,14.4524437333,148.096035,134.245212167,-56.7260210167,361.472104833,-107.1878935,-55.4578849,-105.367232383,-267.325457,249.676592167,2.36719783333,38.77260405,38.0702237,16.2957117333,-59.88000485,83.0399741667,-41.3986444667,-16.1628218833,39.9988486,-87.2840997,120.7301175,34.0794888167,22.3676706667,17.0831340667,9.090739235,3.55116639833,-1.97222306333,-20.8441331167,4.72206277,-12.94567525,-6.24043185167,19.8099494333,-17.5570748333,32.6821323,5.015054655,3.083499675,-8.923492985,-9.440883395,5.03252717333,0.578925314667,-1.64239724333,-0.8633605045,-3.33959712,-3.618089755,-2.35901134,-0.295793830167,3.19222013667,-0.934225143,4.93365629167,-2.26943270333,-2.51854794667,-5.51180423833,-4.13785169833,0.914636832667,2.15338170833,0.334776316833,-0.0808461505667,-0.631956088333,0.0611526387833,0.881392417667,-1.39632062,0.06542459235,0.646911227,-0.521860603333,0.152207372833,-0.166109884333,-1.468239095,-1.33243475667,-2.13224676833,-0.879615388,0.00150885231067,1.035040637,-0.403463500833,-1.16846827833,-0.309648587,-0.00612080771,-0.03036313125,0.1243465675,0.6592954385,-0.205206525333,0.113044734333,0.3519628605,-0.3568244445,0.181786784833,-0.395508450333,-0.181587091167,-0.410299634833,-0.458456882,-0.2106615525,-0.171461843833,0.292118687333,-0.279077781667,-0.497900321167,-0.2599497265,0.0396185058167],[-39578.5951167,-4123.58081,-3450.73203667,-588.5742955,228.168590617,649.786323667,-2136.94205,-1821.08220833,-684.266282667,-490.1320995,167.724944833,689.060895,-484.686853833,-689.5111745,-729.8854755,-424.753717833,-259.7182705,301.673776667,444.910994667,188.380560667,745.663814167,-46.0327133667,2.0334777805,-610.190367167,-149.383009833,15.14607655,155.164602667,123.253698167,-55.9001272333,360.464018833,-102.2401955,-48.19565645,-88.6493811,-264.863793667,255.789439833,2.71266055667,38.5537725333,38.56828995,13.5738445333,-59.1396967167,83.10911965,-38.1368909,-11.0132697083,43.0741723333,-85.5496160833,123.098204833,31.5788821833,26.25136145,16.3845700667,8.93540986833,3.51132865,-2.167755595,-19.8329394333,4.45212788,-12.4212080333,-5.02798410333,19.81206625,-17.3741842833,33.5984667167,3.61242033167,4.999635465,-8.42776282667,-9.32514298667,4.70609103833,0.615893752,-1.66394201333,-0.799815063667,-3.01265239333,-3.76259027167,-2.39089658833,-0.235116626167,3.104902285,-0.863745628333,5.22653836667,-2.65991365333,-1.91587560667,-5.408389065,-4.08794345167,0.810598994333,1.96267368667,0.300058526833,-0.05898412615,-0.646515507333,0.0766052737667,0.914075178,-1.44153389167,0.06056722315,0.562799211,-0.5454972555,0.1470443985,-0.108052658067,-1.54217529833,-1.18801413667,-2.17243209833,-0.840063564167,-0.0671929627515,0.954308615167,-0.396471933167,-1.168932585,-0.292046364,-0.011698877755,-0.0378122754,0.126622712667,0.641149431333,-0.216396330167,0.116918134,0.314410679167,-0.360241337833,0.174239361,-0.397808204333,-0.178921957833,-0.387463495167,-0.489560861333,-0.195937105667,-0.2002803415,0.2700849975,-0.278765249667,-0.495906693833,-0.268065636,0.0303118353667],[-39522.56355,-4063.77074,-3523.63299333,-686.871011667,41.7885894667,562.648055167,-1917.62748833,-1683.60104667,-667.105506,-487.700235667,192.5237975,757.892023167,-462.186600333,-728.046104,-835.2413595,-392.307135333,-255.403098333,325.793545833,431.109419167,203.910399667,731.111482,-50.6793190833,-1.16298537133,-568.8103965,-141.278774,14.2338978167,160.643625333,111.8798015,-55.9176800333,358.770519667,-97.22456495,-42.0572845667,-72.4605941333,-261.000779667,260.759132167,2.91168473333,38.0038335,38.63428505,10.816369885,-58.5218876667,83.10978675,-35.0535349167,-6.17417766833,45.73476415,-83.4016119,125.028295833,28.93996855,30.0082534333,15.6777680333,8.79965493333,3.455894075,-2.354413005,-18.85959355,4.215787925,-12.0191949,-3.87106476667,19.7026866,-17.1318921333,34.4169081667,2.223702974,6.83510674833,-7.88463069333,-9.173279965,4.39726434,0.679869554667,-1.66370496667,-0.7365208385,-2.70805831333,-3.88472875333,-2.465308695,-0.176727720167,3.00894144833,-0.7871818365,5.50251268667,-3.02667122667,-1.34030046,-5.29102694667,-4.02733951167,0.707673711167,1.763434715,0.271722749833,-0.032211441595,-0.654290462,0.0895271983333,0.938763290333,-1.47951795667,0.04769260255,0.481119708667,-0.567370205,0.14481575,-0.05332460648,-1.60806796,-1.04967777033,-2.21088841167,-0.798407423833,-0.132024273633,0.871675729167,-0.387354678833,-1.16451615167,-0.273685675667,-0.0180245233,-0.0444392724333,0.1283542865,0.621733665667,-0.226453091333,0.120473340167,0.278254522,-0.364226666,0.1678602405,-0.400683017,-0.175585511333,-0.365682173833,-0.521332078667,-0.181461449167,-0.22607257,0.247494596667,-0.277523622833,-0.492032976667,-0.275901335,0.0205638156833],[-39440.8059333,-4064.17805667,-3577.66081,-790.975462167,-132.617618383,475.156349,-1699.31910833,-1523.28160167,-653.799141167,-485.3920765,217.738515333,819.6843635,-439.987978667,-768.468908667,-944.041391167,-360.9007285,-254.523395,347.693883667,415.5713645,217.421979833,714.246776,-54.4714200167,-7.89025745283,-528.091928333,-133.613555667,11.780363725,164.469596167,100.271731267,-56.4781751833,356.157574833,-92.15874995,-37.4890598,-57.1516364167,-255.882357667,264.712586,2.981122295,37.1909458167,38.26449565,8.029787765,-58.0539875667,82.9378466,-32.2359941833,-1.83636576,47.9487082167,-80.9187268167,126.513455333,26.2327305167,33.5193019167,14.9944556333,8.697219795,3.38487798,-2.53642403667,-17.9611381,3.99405204167,-11.7521915167,-2.81665007333,19.486348,-16.8560148167,35.1095296833,0.874990355667,8.53668519333,-7.320969925,-8.98085965833,4.11449707833,0.769576024167,-1.64179894,-0.671113172167,-2.43419128,-3.983598255,-2.57918810667,-0.126282133033,2.90267667833,-0.712294100333,5.74847503333,-3.36590783,-0.805400436,-5.16789399833,-3.95632910333,0.612207066667,1.55686967667,0.249320645167,-0.00137849446333,-0.655069970667,0.101896004333,0.955744038833,-1.50882709833,0.0276689972483,0.4027416815,-0.58927382,0.144007871,-0.00489458990333,-1.66611191,-0.9203607805,-2.24744455667,-0.756488790167,-0.190360159333,0.787483980333,-0.377269504167,-1.15566045667,-0.255428035833,-0.0250195327333,-0.0500421159167,0.1299788625,0.601779774167,-0.2349943995,0.123640226,0.244111513167,-0.3691529955,0.162397739833,-0.404240939833,-0.1718589835,-0.3457114225,-0.553005231833,-0.168244832667,-0.2482691175,0.224242931833,-0.275609571167,-0.486486200167,-0.2830228295,0.010800645375],[-39303.1303667,-4054.95800167,-3565.93516167,-891.169481833,-281.045310167,397.9947915,-1498.60483667,-1339.52273667,-645.353406333,-484.6686065,244.40028,871.813386167,-414.695810167,-807.810882833,-1048.89493433,-331.975954833,-257.9450395,367.2356115,398.7985105,230.537817333,695.299128833,-55.5831621833,-18.7424812817,-489.413371667,-126.707554833,7.76960865833,166.589329,88.6368683833,-57.2050134,352.389221667,-86.9483020333,-34.8795774667,-42.9728894667,-249.6830135,267.857167167,2.95100162667,36.1642197167,37.4557255667,5.20086510667,-57.7575458333,82.4755524333,-29.7554725,1.827844935,49.74292645,-78.1850991167,127.5758725,23.5350012,36.6604804167,14.3722982833,8.63692753667,3.29626241,-2.731739495,-17.1753397667,3.762289565,-11.6279362667,-1.90644558667,19.1868522,-16.5709306333,35.6553027333,-0.408085902333,10.0535255467,-6.77019208,-8.74075151,3.86704117333,0.882871758167,-1.59923793333,-0.604862682667,-2.198877905,-4.05991473667,-2.72779330333,-0.0886233678833,2.78775594,-0.645817497167,5.95284029833,-3.67559601667,-0.321456124667,-5.04944308167,-3.87338507667,0.531391643333,1.34451083167,0.2322263845,0.0329033128883,-0.648786945,0.1153494775,0.965664282833,-1.52851817333,0.00152300149333,0.328311555833,-0.613029451833,0.143344438,0.0347806286533,-1.71734312833,-0.801470885,-2.28220098667,-0.715391095167,-0.2394373345,0.702155673333,-0.367702771,-1.14296644333,-0.238212859167,-0.0323511198,-0.0543864401333,0.132027341833,0.582069712333,-0.2417936595,0.126244453833,0.2123576095,-0.3755510795,0.1575394665,-0.408406489333,-0.168255913833,-0.3278673535,-0.583785161833,-0.156978651667,-0.266425798333,0.2002339545,-0.273425868833,-0.479523960333,-0.288920182167,0.00154290686167],[-39136.84575,-4012.78163333,-3483.46368,-980.601058667,-404.312928333,327.034612833,-1334.167015,-1144.61762033,-639.655931667,-488.946091333,270.9883485,911.145685333,-388.774333333,-842.066099,-1144.685985,-305.661403167,-266.125496167,384.403728,381.335044,243.286785333,675.022088833,-53.3848075667,-33.8628796333,-454.304310167,-120.640887333,2.47649006167,167.1780585,77.2624323333,-57.91701555,347.410128333,-81.8674493167,-34.3201381167,-30.2678443333,-242.466272833,270.391065167,2.83658241833,35.0455752667,36.2778109833,2.35030455383,-57.6101704833,81.6497536,-27.75061645,4.76729092,51.1060859167,-75.2177070333,128.235537833,20.93074125,39.3163229167,13.8251999333,8.63252923833,3.19759085,-2.950271905,-16.5084975333,3.50346209667,-11.6534426,-1.1463979635,18.8181632,-16.27272345,36.0332455833,-1.59285895367,11.3424626333,-6.26471423667,-8.44040026333,3.65690400667,1.01391376883,-1.538728905,-0.538520646667,-2.00105862167,-4.11385079333,-2.90098999,-0.0614589329833,2.66471090167,-0.585404581833,6.10398221167,-3.94939421833,0.1052682425,-4.94503224,-3.77314745833,0.471611574833,1.12838803583,0.219004707,0.0682518007667,-0.636630355667,0.131051692,0.970249985333,-1.5378346,-0.0276192628183,0.259097618667,-0.640057216,0.144003948667,0.0631268909,-1.760904085,-0.69305842,-2.31448617667,-0.6744670765,-0.276960947667,0.616580528,-0.360331052333,-1.12677416833,-0.222730220667,-0.0400704020333,-0.0575701581,0.134772175167,0.563176907333,-0.246735769333,0.128596532667,0.183179868833,-0.383660756833,0.153490236833,-0.41313582,-0.164678065333,-0.312137322167,-0.612485701667,-0.147729466333,-0.280256938167,0.175657828,-0.271526186833,-0.471247767,-0.293094885,-0.006708669545],[-38982.9538667,-3928.702115,-3338.64481333,-1052.70163967,-507.493781333,253.245693667,-1224.73606333,-954.453471833,-633.613693333,-502.057048667,295.105601167,934.5220985,-366.332796833,-866.830441667,-1226.95113167,-281.699008167,-279.3456595,399.188905167,363.741932833,255.241309333,654.342005167,-47.58447075,-53.2407336833,-424.265559333,-115.4259515,-3.73709732833,166.468211667,66.4536105,-58.4725984333,341.219708333,-77.2777376333,-35.8040727333,-19.38673675,-234.2433215,272.4891975,2.64458220833,33.9729619667,34.8195232,-0.492605153,-57.5673103333,80.3998468667,-26.3715209,6.96695291167,52.0157439333,-72.00739375,128.503937167,18.5021477667,41.3738154333,13.35821955,8.697697775,3.09890186833,-3.19963682167,-15.9557031833,3.20273911,-11.8333683667,-0.532585753983,18.3902024,-15.94826805,36.2211841667,-2.64524291,12.36315635,-5.83595554,-8.06486364667,3.48376856667,1.15569175167,-1.46331527333,-0.4726711675,-1.83722384833,-4.1453023,-3.08690500333,-0.0409085764333,2.53345933,-0.526455509667,6.190434825,-4.17951533833,0.470178649667,-4.86332149833,-3.64865073333,0.4386812945,0.910576720833,0.208084128,0.101827924067,-0.620069878667,0.150030889167,0.9712243415,-1.53600243,-0.05616262005,0.196359729333,-0.671638086333,0.1476754605,0.0776837711,-1.79524474833,-0.594611941,-2.34328142167,-0.632436751167,-0.300897559167,0.5317245445,-0.356830263167,-1.10721294333,-0.2095423105,-0.0483166540167,-0.0597744203,0.138410726833,0.545497567333,-0.249711877,0.131088180667,0.156669278833,-0.393618878667,0.150537757,-0.418345999167,-0.160850882,-0.298379651,-0.637799816167,-0.140356112667,-0.2895438245,0.150769012667,-0.2704792095,-0.4616592385,-0.295026059333,-0.0134747697383],[-38864.61085,-3805.85041667,-3139.461885,-1102.59311167,-592.498347,169.245311467,-1179.90239833,-779.067252667,-625.243852667,-525.331253667,315.253343833,941.106743167,-350.0809065,-878.727437333,-1292.31226333,-259.929112167,-297.427559,411.715173833,346.754555833,265.968529833,634.128417167,-37.8574904,-76.5965788667,-399.992273167,-111.042774,-10.6059780967,164.643517,56.4626740833,-58.7814411167,333.922304167,-73.3474258167,-39.2302776333,-10.396679635,-225.001770667,274.197071167,2.38327435167,33.0165185333,33.14229625,-3.3123113145,-57.58350645,78.706135,-25.6995934,8.42851381333,52.5001651167,-68.5497994667,128.373612833,16.2915294333,42.75906465,12.9729615833,8.835679915,3.00617377,-3.48810571333,-15.5070412667,2.84950364,-12.16591165,-0.0598682532667,17.9173624,-15.5925121667,36.2084474167,-3.54684953833,13.0894672167,-5.50585900167,-7.60564184167,3.34710605833,1.303569195,-1.37495310667,-0.408414768,-1.70322559667,-4.15614157,-3.27712285333,-0.0236007619683,2.39439941,-0.468183434333,6.20756804167,-4.36154371333,0.771293417167,-4.81035499,-3.49490841667,0.434550973333,0.693594260333,0.198349548667,0.1321169715,-0.599985101667,0.172887439667,0.9697874855,-1.52313891333,-0.0820025521167,0.141103587833,-0.708833588833,0.1552825305,0.07744007375,-1.819213815,-0.505496756,-2.36776216667,-0.588170713333,-0.310733839333,0.4486876085,-0.3580348285,-1.08401197333,-0.199064749167,-0.0570687513667,-0.0611139927667,0.143062585,0.5292098565,-0.250717037833,0.133961195667,0.132847388667,-0.405622741,0.148975651167,-0.424002231167,-0.156606733833,-0.2864512195,-0.658813051333,-0.134580155667,-0.294355006167,0.1258346945,-0.270565631333,-0.450627951667,-0.294359185667,-0.01848612445],[-38793.4447833,-3651.12487833,-2896.07672333,-1126.91823833,-657.595111667,68.9608553667,-1202.13813667,-619.084150833,-613.213398833,-557.999035,331.015911167,931.375023667,-340.386012,-876.545939,-1339.249465,-240.160346,-319.8727635,422.343528333,330.966568,275.108936333,614.706876,-24.217034475,-103.202650867,-381.6256475,-107.429449167,-17.9699564167,161.861484667,47.4307754333,-58.8396051,325.605885,-70.1659423667,-44.3291515833,-3.21366155167,-214.678448833,275.469548167,2.056393425,32.1876862833,31.27980225,-6.1065892,-57.6279534333,76.5772064833,-25.7701112667,9.18898079833,52.59592245,-64.8302383833,127.832603833,14.2900548,43.43401125,12.6649056333,9.0431042,2.91937076833,-3.82007135333,-15.1496521667,2.44108403833,-12.6437543667,0.28075932385,17.410386,-15.2031819667,35.9982415167,-4.30030403333,13.5069615333,-5.284699425,-7.06446582,3.24574499,1.45579828167,-1.27513834333,-0.345712073667,-1.59367343833,-4.148101785,-3.46541112167,-0.00678433207333,2.248277215,-0.4124700195,6.15727894167,-4.49585615667,1.00802382067,-4.78803071333,-3.31119238833,0.458256775667,0.481029086167,0.189194559833,0.158775497167,-0.576720993,0.200045189167,0.966981726,-1.499818035,-0.10396975175,0.0938988686833,-0.751946419833,0.1670538245,0.0625314017833,-1.83219622,-0.425380109333,-2.38659439667,-0.541563138667,-0.306828620167,0.3691004255,-0.364066622333,-1.05635649667,-0.191517140833,-0.0662428857,-0.0616062814167,0.148726517833,0.5143421645,-0.249860497833,0.137419301333,0.111611810667,-0.41972284,0.149045116,-0.4301969605,-0.151821475,-0.276308191167,-0.6747673635,-0.1302070355,-0.294760824833,0.101301841033,-0.271855393333,-0.437790577,-0.290907539833,-0.0217189978333],[-38775.5879,-3471.231955,-2613.58864167,-1122.715965,-699.52364,-50.1814960333,-1292.35062333,-471.588964833,-596.444749333,-598.605144,342.749219333,905.961842,-336.471171167,-859.898892833,-1366.53741167,-222.253577667,-346.110753,431.418634333,316.797429167,282.40226,596.138197167,-6.78666818333,-132.156315667,-369.097342,-104.5204905,-25.7243798667,158.233624,39.4327683667,-58.6616252167,316.304392667,-67.7911099667,-50.7748542167,2.27724524167,-203.171746333,276.215276333,1.670665875,31.472142,29.2527034167,-8.87490202667,-57.6733826167,74.0177366167,-26.5982699167,9.29832743833,52.3355888,-60.8246996833,126.864654167,12.4721995167,43.3719301333,12.4289366833,9.31425714833,2.836345965,-4.19674659833,-14.8701894833,1.97754472333,-13.2564976,0.500187708,16.8785942167,-14.7756478667,35.5974216167,-4.913949315,13.60803455,-5.18058800333,-6.44512723,3.17802035167,1.61193029333,-1.16491905667,-0.284428418833,-1.503171135,-4.121841915,-3.645996155,0.011657272315,2.09625540333,-0.361385297,6.04345784333,-4.58415167,1.18155525333,-4.79719290833,-3.097489405,0.507682542167,0.27688302725,0.179983877167,0.181933637667,-0.550261907333,0.231660904333,0.963665283833,-1.46650044667,-0.121172819667,0.0549564523667,-0.800808766667,0.1828661155,0.033573604745,-1.83374350333,-0.353656972,-2.39845462,-0.4925871115,-0.289917468,0.294569009667,-0.374712740167,-1.02319673,-0.187065346667,-0.0757166466667,-0.0612340762667,0.1553550275,0.500861626667,-0.247264437667,0.141615620667,0.0927934435833,-0.435829297667,0.150844917833,-0.437006628667,-0.146421423667,-0.267834037833,-0.685025228,-0.126984953833,-0.290863411167,0.0776184723,-0.274328584667,-0.422697151333,-0.2844982305,-0.02321988315],[-38817.3736,-3294.33632667,-2297.80713667,-1091.13652333,-717.565361833,-185.527654167,-1444.14795833,-333.0883325,-574.116279167,-644.647933333,351.9554225,866.925286667,-337.454195,-830.398524333,-1374.88082833,-205.867167333,-375.251794167,439.216984167,304.240968333,287.295744833,578.180616667,13.7135021083,-162.347545833,-361.681618167,-102.182945333,-33.8150448333,153.835479,32.3314702333,-58.3747043,306.065292667,-66.2434418667,-58.2026681833,6.27831984333,-190.363188167,276.181266,1.2387065615,30.8176168333,27.0793802333,-11.62097634,-57.6932801167,71.0512008167,-28.1553691667,8.82944277667,51.7361778167,-56.5177893167,125.420479833,10.7924831133,42.5986260667,12.2537434,9.64117879833,2.75313585333,-4.60706276833,-14.64706955,1.46550894683,-13.9935498833,0.616782377,16.32232615,-14.3034748333,35.0118594,-5.39903259,13.4074460333,-5.18989580667,-5.758326995,3.13914201167,1.77422538667,-1.045148163,-0.223379821833,-1.42485046833,-4.07724732667,-3.81658546833,0.0336890738833,1.93831116333,-0.31568379,5.87202173167,-4.62779501167,1.29514366333,-4.833652105,-2.856277855,0.5775425955,0.0855541728333,0.1698518255,0.2023926345,-0.520139224,0.267185910667,0.960421320833,-1.42387713833,-0.133134352667,0.0240647499593,-0.8544735805,0.2025025805,-0.00804558578667,-1.82295762667,-0.290458581167,-2.40198298167,-0.4412996865,-0.2619050875,0.226290486833,-0.3886381,-0.983558214,-0.1856376575,-0.08544514155,-0.0600141626,0.162771682,0.488600961667,-0.243068781667,0.146873991,0.0762117765333,-0.453420880833,0.154350715167,-0.444483527833,-0.140200047167,-0.260999910333,-0.689337669667,-0.124455385667,-0.282908619833,0.0552179158167,-0.277660885,-0.404962586333,-0.2752283665,-0.0232396645833],[-38921.7097667,-3133.25525667,-1962.76238833,-1035.48357317,-711.755214167,-333.7195605,-1644.46778333,-207.143184767,-545.475331167,-693.458209667,360.277759,817.628249667,-344.284525167,-790.709856667,-1368.11290667,-190.352505333,-406.343383333,446.105872833,293.1312495,289.41181,560.5133325,36.07495425,-193.159361167,-358.524083167,-100.253469767,-42.1743084667,148.759738333,25.9216657833,-58.0342511833,294.96129,-65.53812035,-66.3452705167,8.98379588667,-176.232588167,275.235313333,0.762135603833,30.1818645,24.7651319833,-14.3475236333,-57.6451822667,67.71406045,-30.3626856667,7.892446395,50.8141577,-51.9007427,123.477836333,9.22519246667,41.2086426,12.1223224,10.0120248667,2.66369307667,-5.03652521667,-14.45404505,0.9097236435,-14.8380161333,0.658420957,15.73657985,-13.7781337,34.2450545833,-5.76284222333,12.9423714333,-5.28982484,-5.01225664667,3.12252188667,1.94322463167,-0.916394054167,-0.160765484367,-1.35265565167,-4.016071085,-3.97640739,0.0612231056,1.77397488167,-0.272915255333,5.64683086333,-4.62704865667,1.35331490833,-4.88745977167,-2.5894904,0.664015936167,-0.09255812575,0.1582599995,0.220965986833,-0.485836695667,0.3058523955,0.957540595833,-1.37277475833,-0.139427791833,0.000115838604,-0.911637077833,0.225738082833,-0.0610831658883,-1.79927268667,-0.236327489,-2.39580555667,-0.387104911,-0.224431506333,0.164355738167,-0.404862848,-0.937639926667,-0.186921405333,-0.0953563199,-0.0579389291667,0.170713005667,0.477316128833,-0.237285020833,0.153523517167,0.0614119521,-0.471875313167,0.159359986833,-0.452556862333,-0.132919242833,-0.255892353333,-0.687761010333,-0.1220818905,-0.271245853333,0.03444695965,-0.281695821667,-0.384597349333,-0.263637287667,-0.0221235842667],[-39093.2053167,-2997.057885,-1629.84252167,-960.282261667,-685.262587,-492.238208833,-1879.37531667,-99.7921737,-509.650367,-742.507344833,368.788831667,761.612499167,-359.432069833,-743.470017833,-1351.11724833,-174.7899365,-438.389743,452.4344225,283.2152995,288.319663333,542.916030667,58.91979175,-223.9943315,-358.745768167,-98.5470093667,-50.7092461667,143.127836833,20.00298755,-57.69276115,283.078312667,-65.76494005,-74.9213186667,10.5588308617,-160.762822667,273.277782667,0.2356761945,29.539996,22.3136224833,-17.0496164167,-57.4722320167,64.0488294167,-33.1283924,6.63275267667,49.5867048167,-46.9436174833,121.021727167,7.751962115,39.3110011167,12.0142779167,10.4127963,2.56287439667,-5.47000327167,-14.2563374833,0.314261305833,-15.7673084833,0.657499527667,15.1134684667,-13.1874916167,33.3004275,-6.01213331833,12.25744115,-5.45356850167,-4.21217136167,3.11994159333,2.117692795,-0.779075911667,-0.0947612166667,-1.28033314167,-3.94087888833,-4.12376421,0.0962288235333,1.603134245,-0.228401590667,5.37160992167,-4.58096469333,1.36181846,-4.9473375,-2.29823031,0.763592097667,-0.258260016333,0.144736387333,0.238316287333,-0.447080521,0.346700242167,0.95502148,-1.31405062333,-0.139248671167,-0.0184560714907,-0.970632773,0.252177594667,-0.124206974983,-1.76227796167,-0.191293453833,-2.378565925,-0.3287933515,-0.1790682035,0.108633906367,-0.422524020667,-0.8858093535,-0.190456103833,-0.10539646595,-0.0550139352667,0.178835530667,0.466634119833,-0.229899744,0.161811279333,0.0477049321833,-0.490538849167,0.165507012667,-0.4610828345,-0.1243333395,-0.252556761667,-0.680376103667,-0.1193075655,-0.2562776545,0.0155683181967,-0.286332878833,-0.361674889167,-0.250333889167,-0.0202262124333],[-39334.0532833,-2895.84906333,-1317.548495,-869.306868167,-641.018898833,-657.674312,-2135.13537333,-16.2433529833,-465.636036167,-788.97022,378.637604167,702.405029833,-385.0815375,-691.276517667,-1328.47056667,-158.2449295,-470.286801167,458.503601,274.279963833,283.6363595,525.1561615,80.97888295,-254.235641833,-361.356426833,-96.8755410167,-59.3134660667,137.039553667,14.4017073967,-57.38524585,270.496482833,-66.967984,-83.63432635,11.2172664667,-143.925769,270.204606,-0.348110731833,28.8623645667,19.7246827333,-19.7143048333,-57.1096982,60.0990768,-36.3446605333,5.20029823167,48.0868259167,-41.61412005,118.040130333,6.34827864167,37.0149881333,11.9072046333,10.82684965,2.44560021833,-5.89184529167,-14.0172836,-0.315212660833,-16.7544098667,0.6475203995,14.4495656167,-12.5196879333,32.1848345167,-6.15675085167,11.3995637167,-5.65523522,-3.362108485,3.12260819333,2.29572830833,-0.6333347485,-0.0240991176,-1.20160708,-3.85371289,-4.25634999333,0.140724063567,1.42673422833,-0.178179585167,5.0517643,-4.4896875,1.32804488167,-5.002523375,-1.98287537833,0.872347208833,-0.412425587333,0.128783967,0.255036609167,-0.403538768333,0.3885164965,0.9526391985,-1.24849623333,-0.131959107,-0.0332923263,-1.02960255017,0.281148870833,-0.195571425333,-1.71190245833,-0.154735299167,-2.34914123833,-0.264920727667,-0.1275902151,0.0589017783,-0.440722489333,-0.828293686167,-0.195733664833,-0.115484885,-0.05125390195,0.186742755667,0.456080774167,-0.220909154333,0.171871064,0.0343612510167,-0.508766042167,0.172357506167,-0.469815222,-0.114323037,-0.250864422333,-0.667363261667,-0.115500383,-0.238484019167,-0.00120000046333,-0.2914484405,-0.336215693167,-0.2358841625,-0.0178988411667],[-39612.8446167,-2823.954575,-1028.86254817,-763.412595333,-573.11107,-820.775619333,-2395.63173167,45.62929585,-413.903925833,-827.8583005,392.340488833,644.8973105,-420.109353,-636.290483833,-1303.35227833,-140.493042167,-500.814780833,464.705415833,266.577741167,275.825255833,507.192854,101.773635933,-283.409429667,-365.042117167,-95.1804844333,-68.01121545,130.5231495,9.02160989333,-57.03959795,257.358412333,-68.9141446333,-92.2608390167,11.3734169333,-125.723526833,265.959662667,-0.990643933667,28.0622546,16.967723,-22.3386015833,-56.5153464333,55.9199966,-39.84632475,3.71283169833,46.4218066833,-35.9042115833,114.557097,4.977371845,34.4344117833,11.7908102667,11.2283795333,2.30191539167,-6.29614983167,-13.7175141333,-0.973509736333,-17.76954585,0.653524418333,13.7602390333,-11.77466275,30.92318695,-6.21485803667,10.4203222783,-5.87240970167,-2.46464583333,3.12591849333,2.47681646167,-0.478712817167,0.0499334137333,-1.11487525,-3.75785232333,-4.37545746333,0.195614071,1.24807270333,-0.1224256114,4.69868610333,-4.35694908333,1.26246016833,-5.04513127167,-1.64264077,0.985346491833,-0.555917217167,0.110430753583,0.272937517667,-0.354340961833,0.429960082333,0.949720417,-1.17735038667,-0.118644512833,-0.0458603985333,-1.08717091167,0.311236632167,-0.272153816,-1.64922055333,-0.124870561467,-2.30782625333,-0.193605126667,-0.0724758619667,0.01495513425,-0.4586542185,-0.765259500667,-0.2024041815,-0.125221181,-0.04653309975,0.1941852675,0.4453815605,-0.210377327,0.1834995315,0.0207963532117,-0.526297685667,0.1794926625,-0.4784841885,-0.10307291185,-0.250407334167,-0.649461744,-0.109866224167,-0.218707524333,-0.0156523485033,-0.296987904833,-0.308258573,-0.220841889833,-0.0155142142833],[-39893.0562333,-2789.40157333,-757.096128667,-650.356219667,-481.614003667,-971.656051333,-2646.276055,98.5646146833,-358.262282833,-856.255547167,412.776724667,592.681673,-460.133846,-579.669077,-1278.452705,-121.999046167,-529.237975833,471.613536667,259.974991833,265.823986,489.317069833,121.008753667,-311.396204167,-368.432360333,-93.4078812167,-76.87506275,123.632026,3.67458038,-56.64274685,243.882268,-71.38811855,-100.743598467,11.4805896167,-106.18791785,260.554975,-1.64959841133,27.0682504833,14.0136781667,-24.9435493,-55.7145730833,51.56661375,-43.5007408833,2.21392601267,44.6973949,-29.81854595,110.625787167,3.60748277167,31.6797291833,11.6729383833,11.6018573667,2.12314344,-6.67890341333,-13.3614627833,-1.664625431,-18.7945083667,0.6789067305,13.0549057833,-10.95938355,29.55156475,-6.20208425333,9.367082315,-6.08622173167,-1.52179939367,3.12975059333,2.66347698833,-0.314791994,0.1282277899,-1.0226059015,-3.660708,-4.48564776167,0.258476938333,1.06777398567,-0.063794121195,4.32599811833,-4.18439504,1.17443531833,-5.07044157833,-1.27611532633,1.0971209245,-0.689283658833,0.0899420778667,0.294238925833,-0.298965313667,0.4706716065,0.945732608667,-1.102770485,-0.101222919717,-0.0574251925167,-1.14278415,0.340895385667,-0.351239424333,-1.57431754167,-0.10040740535,-2.256082875,-0.112986589017,-0.0164497303333,-0.0229696461333,-0.475556554333,-0.6968202775,-0.210422723833,-0.1342946665,-0.0408242246667,0.201068519333,0.4346241185,-0.198424049,0.196464177333,0.00675095621833,-0.543052796167,0.186666888167,-0.487169807833,-0.0904907178167,-0.251065744333,-0.627798164833,-0.101670647917,-0.197902937,-0.0274607292167,-0.302810754167,-0.277852790833,-0.205757226833,-0.01342157895],[-40140.3692,-2794.50576333,-489.248631167,-538.036322,-367.666232667,-1100.23314267,-2875.08946333,155.311657717,-302.885619,-872.412085,442.522847,548.563442333,-500.391543333,-522.089896833,-1255.47592,-103.415473417,-555.089870167,479.726992333,254.2720975,254.735075,471.888893333,138.550552167,-338.106752167,-370.371109,-91.5270966667,-85.9668873833,116.426014833,-1.818290005,-56.1543251167,230.2702415,-74.21285625,-109.050402,11.9364575833,-85.3868976333,254.050264167,-2.273129115,25.8289142,10.8421765867,-27.5526242167,-54.7438472333,47.0829567167,-47.2002514167,0.7278598965,43.0144834667,-23.3721687167,106.308625,2.22345329733,28.8470512,11.5668475,11.9359665833,1.902174225,-7.03806179333,-12.9608940167,-2.39500408333,-19.81394495,0.720953243,12.3437881167,-10.0813221333,28.1045524833,-6.128027025,8.28152237,-6.28290108167,-0.534928964833,3.135110135,2.85786380667,-0.141528981567,0.211804775667,-0.928619677333,-3.56985870333,-4.59057992,0.325988681667,0.886187183167,-0.00475504763,3.94593902167,-3.97241702,1.07244750533,-5.07541777167,-0.881550209333,1.203302975,-0.812501165,0.06747306315,0.320835111,-0.237138880833,0.510612154333,0.9402408065,-1.0268654135,-0.0813825273667,-0.06914049045,-1.19617040333,0.3686874515,-0.430439213833,-1.48708681833,-0.0801050958667,-2.19539969667,-0.0212546987,0.0382140101,-0.054390561,-0.490873708167,-0.6232480545,-0.219859488167,-0.1424196835,-0.0341332897,0.207370569667,0.4240049635,-0.185156869167,0.2105033235,-0.00793937895167,-0.559002053833,0.19363324,-0.495933006667,-0.0764659045667,-0.252734533167,-0.603378968667,-0.0902139868667,-0.1769505585,-0.036259411,-0.3088010355,-0.245109162,-0.19110784,-0.0118617381167],[-40336.3049167,-2842.13420833,-216.08547945,-434.3562855,-233.6172555,-1200.13401833,-3072.16311333,225.971599333,-251.1149055,-875.304934,482.822688167,515.253921833,-536.699069,-464.221518167,-1235.39879333,-85.1298667667,-578.034485167,489.339875833,249.436020833,243.5526015,455.240745167,154.400978,-363.427029667,-369.826245,-89.4506617833,-95.3178212,109.007725167,-7.58251678,-55.5517265167,216.720167667,-77.2236331667,-117.1376515,13.1284278333,-63.4432715167,246.531099167,-2.80627068,24.31568275,7.46487581167,-30.1873765,-53.64243855,42.5186909833,-50.8526529167,-0.717387522333,41.48654265,-16.6071667133,101.678486917,0.8097164465,26.0164186167,11.4811309167,12.2246540667,1.63847612833,-7.374822145,-12.5260399667,-3.166963235,-20.814592,0.780077005667,11.6426184167,-9.15449044667,26.61905535,-6.00681731667,7.19871554667,-6.45334665667,0.491887847333,3.14059278,3.06172123,0.0406989215667,0.300877050667,-0.834956918333,-3.49182798833,-4.69286802,0.3961207415,0.704221969167,0.0512354621717,3.57122275,-3.72456165667,0.963485579833,-5.05868955167,-0.459235910683,1.30039004333,-0.925823414667,0.0426210674,0.353995079667,-0.16925675795,0.549821150333,0.933394066667,-0.951771037333,-0.0602885218,-0.0818881232833,-1.24722690667,0.3932699545,-0.507161444833,-1.38847030333,-0.0628659528333,-2.12748295167,0.0823727652833,0.0896452071667,-0.0792759346833,-0.504080576667,-0.5450866605,-0.230751874333,-0.149478230667,-0.0266634699333,0.213125774333,0.413728375333,-0.170785195167,0.2254542035,-0.0234753062117,-0.574155776333,0.200220313333,-0.5047381105,-0.06107294865,-0.255248347333,-0.577164512167,-0.07510558365,-0.1566194955,-0.0419466123667,-0.314785958333,-0.210300594,-0.177266464333,-0.01101945695],[-40479.2454333,-2945.83397333,63.4934733667,-348.8962,-84.9429599333,-1269.34222167,-3228.32235833,319.394717833,-205.7212865,-864.503290833,533.70444,495.490211167,-565.458331,-406.858582833,-1219.18572333,-67.1836224667,-597.751976833,500.593271,245.504460167,232.996865333,439.665796333,168.528518167,-387.250478833,-365.726486333,-86.9941804333,-104.920308733,101.522227433,-13.724274605,-54.8794377667,203.43749,-80.2666279,-124.956391667,15.4638906167,-40.5020324833,238.066595333,-3.18826752167,22.5179036167,3.92207742183,-32.8676315833,-52.4519713333,37.93393385,-54.37221055,-2.0885655925,40.23226705,-9.58166887667,96.8063128833,-0.660838127333,23.2590899,11.4171903667,12.4666029333,1.33782037167,-7.69091865,-12.0614595667,-3.97837538333,-21.7844548333,0.860903943667,10.96766345,-8.197835515,25.13355685,-5.86008611667,6.14958995167,-6.58923246,1.5515508065,3.14162746833,3.27685684167,0.2313903426,0.395495718667,-0.740850803833,-3.432405285,-4.794704475,0.468349973,0.522582657,0.09969741965,3.215576125,-3.447346995,0.853312436,-5.01923416667,-0.0115992242333,1.38480248167,-1.03011559667,0.01445223435,0.394477429333,-0.09630197435,0.588359413667,0.925871128167,-0.879758007667,-0.0387393133333,-0.0962923487833,-1.29582333333,0.413378859667,-0.578497748333,-1.28010509,-0.0478097818667,-2.05412945,0.197649060367,0.1360617802,-0.0981432974833,-0.514489562667,-0.4629414125,-0.243045822833,-0.155556360667,-0.0188303697167,0.218365482833,0.4039206535,-0.155621230667,0.241290570333,-0.0401093514833,-0.588456598167,0.2063548925,-0.513482654,-0.0444743554333,-0.258404971667,-0.5501211495,-0.0562526147833,-0.137586378667,-0.0446768917,-0.320465083833,-0.173776655333,-0.164528735333,-0.0110992831667],[-40572.4806667,-3115.305165,350.328039217,-289.20066,72.0146891,-1307.44194833,-3337.03534,439.9500665,-168.7628905,-840.2828385,594.4836735,491.412530667,-584.287057167,-350.642703,-1207.21640333,-49.584304,-613.986478,513.496763667,242.559458,223.628516667,425.459393833,180.883994667,-409.3832755,-357.2723915,-83.9996963667,-114.7109385,94.1306807167,-20.2957156333,-54.1649409833,190.621376167,-83.25928685,-132.420872333,19.2637075833,-16.745708115,228.741500167,-3.36718417,20.4445593333,0.269068754,-35.60202035,-51.2039305167,33.3904922,-57.6955379333,-3.34573793167,39.3579496833,-2.36134718167,91.7589283333,-2.20030165617,20.6336849167,11.3748537167,12.66031845,1.00825004983,-7.98837069333,-11.5699143333,-4.824098815,-22.7107304333,0.9700004825,10.33567961,-7.22772828833,23.6807333667,-5.70451677,5.160703485,-6.68691113167,2.6364085,3.13348998667,3.50289710667,0.4294670275,0.495096698667,-0.645022874667,-3.39613169333,-4.89595304,0.542904708,0.342239748333,0.137698703833,2.89049214167,-3.14673977167,0.747221664167,-4.95736853333,0.458659254983,1.45390819167,-1.12571172333,-0.0179631278333,0.4423604765,-0.0195645165833,0.626144397167,0.918466247167,-0.812882503333,-0.0169533898017,-0.112715246733,-1.341819295,0.428175454667,-0.641845335333,-1.16368134333,-0.0339551002833,-1.97706509,0.324160737167,0.176013601167,-0.111407224817,-0.521602416333,-0.377671689333,-0.256640180833,-0.160744276167,-0.0110839283417,0.2230741195,0.394683566,-0.140004669833,0.257978894,-0.05805252725,-0.601808728667,0.211990037833,-0.521964708667,-0.026853813585,-0.2619393425,-0.523061409833,-0.0335992515583,-0.120495884167,-0.0446410551,-0.3255864755,-0.135996639617,-0.1531312595,-0.01221252835],[-40623.1875333,-3332.718495,650.85115,-252.7811855,232.871977233,-1317.25969,-3401.895195,576.9420465,-139.925740333,-804.718637333,662.566003333,503.326624,-594.157635167,-295.989367667,-1197.34740667,-32.51712755,-626.848027,527.725172667,241.044084,215.932324833,412.845196167,191.673293167,-429.454496167,-344.842156,-80.5132531833,-124.506015667,87.0519065,-27.1198587,-53.3163965667,178.4420165,-86.3258606333,-139.3897815,24.50952295,7.46247934,218.780213167,-3.32930503667,18.1635600667,-3.39557261983,-38.3678373167,-49.9212043667,28.9596504333,-60.8445003167,-4.445334935,38.9380763,4.94529696,86.6218752333,-3.76108034333,18.1568627,11.3573089333,12.8043396333,0.663931410833,-8.27541731667,-11.0617493667,-5.68729823,-23.5848018667,1.11589921417,9.77210192167,-6.257142615,22.2800847833,-5.54033961667,4.24317424833,-6.76373929833,3.73628251,3.114189645,3.73287921667,0.631824455,0.5962296075,-0.5469305585,-3.382866065,-4.99063907167,0.622466648833,0.166363442622,0.167381361,2.60000698333,-2.82878221333,0.648574841,-4.88087873667,0.947126299167,1.50962157,-1.21111309167,-0.0552385742667,0.495772440333,0.0587459433833,0.662749275,0.912830218667,-0.752472387333,0.00655652071,-0.130319144333,-1.38549466,0.438408515167,-0.696034567833,-1.04206727833,-0.0201038941283,-1.89876349,0.460681583667,0.209534858333,-0.119014574667,-0.5259584805,-0.2913980755,-0.2714316685,-0.1650844775,-0.00390633966167,0.227193035333,0.386410235333,-0.124466452333,0.275468445167,-0.0772319901333,-0.614294242833,0.217251538,-0.529826711167,-0.00859598553,-0.265501480167,-0.496516520333,-0.00734212286667,-0.105909921317,-0.0421609443167,-0.330289974333,-0.09794518755,-0.143188626167,-0.0141019570333],[-40638.2555333,-3573.62199833,971.839151333,-234.491744833,394.1998125,-1302.24717333,-3429.314915,716.863793,-118.272902833,-760.094046,735.017649833,530.746776333,-596.428039667,-243.520714333,-1186.97268833,-16.1993326592,-636.473106333,542.8749205,241.365419,210.450394667,401.794470167,201.059945833,-447.0642945,-329.147858667,-76.62657635,-134.089658167,80.5070876333,-33.9831547167,-52.2068391667,166.973569667,-89.6624733667,-145.713401333,31.0397886,31.734660235,208.409186333,-3.07239728333,15.7526682833,-6.967563505,-41.1308529333,-48.6264406833,24.6976193833,-63.8632293167,-5.34635127167,39.0082999,12.2311067417,81.4681274667,-5.28129852333,15.8325688667,11.3668617167,12.8959805667,0.319092493817,-8.55871665333,-10.5502825,-6.54752389667,-24.3978815667,1.30700697833,9.29579647333,-5.29301737333,20.94157755,-5.36222286167,3.40359980333,-6.84047092167,4.84051702333,3.082122915,3.958121125,0.834749389,0.6955365785,-0.446425824333,-3.38967702,-5.070802915,0.710288235,-0.00233195384667,0.193372509167,2.34470940333,-2.498299415,0.560181732167,-4.798265005,1.449108259,1.554756805,-1.28424968,-0.0978390071,0.552372892667,0.136303021567,0.697708673333,0.910783469,-0.699144368,0.0338104162483,-0.147906030333,-1.42686483667,0.445391739167,-0.740481882167,-0.917845737833,-0.00500523446333,-1.821418725,0.605845735833,0.236996479167,-0.1207057255,-0.5283169265,-0.2064328705,-0.287268199667,-0.168600012,0.002260865285,0.230597026167,0.379563019,-0.109512189283,0.29372235,-0.0974739109,-0.625815950667,0.222277471,-0.536641099833,0.00999847792167,-0.268694031333,-0.47081044,0.0223100728917,-0.0943409080833,-0.0375178753667,-0.334799625333,-0.0606774148333,-0.134765815,-0.0164404177333],[-40630.2562833,-3825.31771667,1308.50539917,-230.8878295,549.657523333,-1270.79044333,-3425.50493,845.839012167,-102.820294483,-709.017239333,808.295198333,572.662804833,-593.498263833,-193.551380167,-1174.42621,-0.55804867,-642.886533,558.538416333,243.838398833,207.3186565,392.2449585,208.8780225,-461.8554925,-310.867697333,-72.3463223167,-143.180181333,74.71614685,-40.6711923667,-50.7881845167,156.305632333,-93.5436260667,-151.225585833,38.6943019333,55.7159411,197.8096745,-2.59701024833,13.301273,-10.3337761817,-43.8512180167,-47.3423165,20.6655354167,-66.8049582833,-5.99772133667,39.57633615,19.4090040667,76.3530810833,-6.71012472167,13.66307625,11.3990231667,12.9329058,-0.00785817206667,-8.84035747667,-10.041283535,-7.384171425,-25.1395603167,1.55591404167,8.91609594667,-4.340198195,19.66990225,-5.166123575,2.64552917333,-6.9337187,5.93970358667,3.03375326667,4.16955887167,1.03455414533,0.790852021167,-0.340866486333,-3.41299992667,-5.12789955333,0.810494928167,-0.162137152212,0.220286355667,2.12432898333,-2.159894355,0.484602888833,-4.71666539,1.95972982,1.59159150833,-1.34367811,-0.146475824317,0.609522762667,0.210512893167,0.730436825333,0.914158883,-0.653272393333,0.06695700195,-0.1642521865,-1.46578236,0.450551681,-0.7746628815,-0.793156602833,0.0124313179717,-1.74674667167,0.758274567167,0.258458525667,-0.116447755333,-0.5293013875,-0.12486090085,-0.303905013667,-0.171436751,0.00692457701333,0.2330490335,0.374444352833,-0.0956441852667,0.3127838675,-0.11864517635,-0.6361306595,0.227190988667,-0.541982083167,0.02873798351,-0.271168614333,-0.4462034425,0.0550890911667,-0.0862435226833,-0.0310491606667,-0.339257761167,-0.025103681955,-0.1278990005,-0.0189632703667],[-40608.9276167,-4071.92147333,1648.25887,-239.656854333,694.589676833,-1234.94882667,-3393.35312333,949.3304115,-93.0637715333,-653.845813667,878.4430075,628.814403333,-588.4363255,-145.552487417,-1158.39905167,14.5214356408,-646.111993333,574.302457167,248.992612,206.486396833,384.371109833,214.9082375,-473.325516,-290.594067333,-67.6393524667,-151.5081575,69.8878511667,-46.9435014333,-49.0394091,146.623343167,-98.2383237,-155.673890333,47.3740583667,79.07785985,187.148356167,-1.901519875,10.8896970983,-13.3758013,-46.49795625,-46.0914597,16.9416483167,-69.7144397833,-6.324032085,40.6534046833,26.4116344333,71.3335706167,-7.99862679667,11.655953155,11.4480030167,12.91099405,-0.295248223017,-9.12537217,-9.53703564833,-8.17786484833,-25.7961065333,1.880266915,8.64257589333,-3.40084388667,18.4721688167,-4.94675086,1.97357839833,-7.05688765833,7.02541825667,2.96511197667,4.35851991333,1.22746799833,0.879577400667,-0.226426112833,-3.45011324333,-5.15339931333,0.927577800167,-0.310809138667,0.252794026833,1.94003706667,-1.81806459167,0.425808025333,-4.64224097667,2.47411216667,1.62217226167,-1.38792431333,-0.202019923667,0.6647785995,0.278568001167,0.760229166833,0.924689540167,-0.615440492333,0.107870084467,-0.1783237285,-1.50208865667,0.455314277,-0.797626199167,-0.670029968167,0.0336427518167,-1.67609797,0.9167701695,0.273770025333,-0.106152959167,-0.529380475333,-0.0486452880667,-0.321087616,-0.173727993833,0.0095755841,0.234325451,0.371255159167,-0.0834175960167,0.332659457333,-0.140699492333,-0.645012235833,0.232038419167,-0.545384459167,0.0474171328167,-0.272510937833,-0.422931776833,0.09075405955,-0.08201528675,-0.0230820537667,-0.3437124295,0.00797857048,-0.122608695667,-0.0214205075667],[-40580.0898833,-4308.23566333,1967.14108833,-262.293834833,824.706955167,-1207.95836167,-3331.16433333,1015.16827983,-89.5846320333,-595.838431833,941.767926167,699.547628167,-584.211459,-99.17150895,-1139.39512833,29.1419143,-645.972462667,589.765064333,257.165092333,207.603650333,378.287128667,218.4499385,-480.860507167,-268.6386365,-62.4129761667,-158.873336,66.1806514833,-52.64698065,-47.0339579333,138.104886167,-104.028165383,-158.750953667,56.9860227333,101.586824783,176.451394333,-0.976091318333,8.55714957667,-15.99503335,-49.04636105,-44.9017604333,13.6024641667,-72.6194085333,-6.236604875,42.2078034,33.2075902833,66.4158013667,-9.108422315,9.832309885,11.5054045,12.8209886167,-0.5239214265,-9.41487546167,-9.03673128333,-8.91030140167,-26.3533626833,2.29960719333,8.46602662667,-2.46876123833,17.3451060167,-4.69686624333,1.3950955585,-7.21121247,8.08806445167,2.871781035,4.51824578,1.41063059,0.960035929333,-0.0990732694167,-3.49855106333,-5.14113439167,1.06582628767,-0.449614893333,0.296424628167,1.79147130833,-1.47364399333,0.386692957833,-4.57568818833,2.98721659333,1.64670787333,-1.41534216667,-0.265026935,0.716581715833,0.338166264167,0.786267008833,0.943664688,-0.5860831625,0.157592708,-0.189146878333,-1.53549789167,0.461205848167,-0.808878294,-0.548740647167,0.0591719321,-1.60932085167,1.08018251183,0.282413483,-0.0895369127167,-0.528392015667,0.020812709,-0.338438963333,-0.1755035745,0.00979169205667,0.234124317833,0.370073226,-0.0732486512333,0.353317114,-0.163539426333,-0.652029424333,0.236936698333,-0.5465843605,0.0662406348333,-0.272557146,-0.400906009167,0.129107157283,-0.08187816385,-0.0137850812133,-0.347923023667,0.0380450704117,-0.1189711825,-0.0236720624167],[-40539.5465333,-4536.64353833,2268.99612,-302.948599833,938.1603975,-1191.82898,-3239.44229833,1037.81595167,-93.9568972,-534.996073167,996.928243833,782.941037,-582.020403167,-56.6690255833,-1119.388475,43.3167160667,-642.335033,604.469353333,267.679010333,210.4973895,372.83795,218.590382333,-484.065334833,-245.148977833,-56.5609572833,-165.274139,63.53424575,-57.8748305333,-44.8374372167,130.518996833,-111.108923,-160.275443833,67.3393134333,123.086263333,165.502828,0.187273161667,6.27157036167,-18.1691391333,-51.49307295,-43.7978372667,10.63082793,-75.5154076833,-5.70348138667,44.1170403833,39.7806348333,61.4917878167,-10.0170756767,8.21242909333,11.561593,12.6479923,-0.685345118167,-9.703707215,-8.54214294167,-9.57428526833,-26.7999711,2.81426017833,8.34318266833,-1.540525794,16.2468500667,-4.407788415,0.9093742205,-7.38128706333,9.11698309333,2.75062170667,4.64627217667,1.58345084,1.03307815867,0.0421691256667,-3.55364806333,-5.08999116833,1.22463546167,-0.587031881667,0.353619191833,1.66695917833,-1.12311142617,0.363616106833,-4.50932031167,3.49336995333,1.66391193833,-1.42458361333,-0.335212774667,0.765275115667,0.388669656667,0.808172478333,0.971148759333,-0.563795725333,0.215497824833,-0.196301320333,-1.56632347833,0.468915365167,-0.810943886167,-0.427403203,0.0865922672333,-1.54331764167,1.24689514333,0.283992398333,-0.0663053120833,-0.5255844875,0.0829238749,-0.355446998667,-0.176460484167,0.00757975560833,0.2322218055,0.3708539525,-0.06493961715,0.374553863,-0.1868611295,-0.656663800333,0.241967304,-0.545934175333,0.0859652051833,-0.272012787167,-0.379097873167,0.169704117667,-0.0855554190333,-0.00320647140167,-0.351381739167,0.0650033224167,-0.117108806333,-0.02568857275],[-40490.7458333,-4761.59236833,2566.46895833,-367.507195,1037.53154633,-1182.61647167,-3121.14343167,1018.154518,-106.855505483,-469.912835,1043.8405295,875.232274833,-582.418805833,-21.0083335033,-1100.72657833,57.5797770667,-635.116991833,617.7767425,279.228934833,214.746202833,366.421327833,214.771487333,-482.932052333,-219.849410333,-49.8832069,-170.844061,61.7098776,-62.8100483833,-42.5604558333,123.458857,-119.443747,-160.1789635,78.3006434833,143.499433667,154.017496833,1.58264440833,3.97601028167,-19.92041285,-53.8218622833,-42.78588915,7.96468674,-78.3502711,-4.71278909167,46.2426046,46.1162003833,56.4390347333,-10.7451777167,6.81169043,11.5962135,12.3854841333,-0.772227279667,-9.97854155167,-8.048208165,-10.1668174617,-27.1286114667,3.42171324667,8.22440603333,-0.623325644333,15.1343518,-4.083791765,0.512648212833,-7.54255834833,10.10681925,2.59677221167,4.74516820333,1.74821473667,1.10098967833,0.197750017917,-3.60850584167,-5.00364578167,1.40227743167,-0.731728062333,0.4216653305,1.55407138667,-0.764637810333,0.351988739667,-4.43298360833,3.989133475,1.67076427833,-1.41665478,-0.412135697,0.812000763167,0.430436211167,0.8257833885,1.0063385995,-0.545786057,0.2798599215,-0.199719800833,-1.59463706833,0.478081833667,-0.806988712833,-0.3041963935,0.113456708233,-1.47492426667,1.41570071167,0.277756687167,-0.0371165199183,-0.520147452667,0.137896514683,-0.3715419695,-0.176443772667,0.003068895165,0.228516520667,0.373378037,-0.0578726204333,0.396170196667,-0.210359626167,-0.65847272,0.247189259667,-0.543985494,0.107221451217,-0.271446152167,-0.356571001167,0.212109536,-0.09270728125,0.00843766711,-0.353634714167,0.08904387305,-0.117053548333,-0.0276320050667],[-40449.6446167,-5001.31188333,2857.96584667,-460.909521667,1121.683105,-1179.47306167,-2979.662295,958.805724333,-127.451959333,-399.694124167,1082.20567,971.986529167,-586.269214667,4.28498353667,-1085.7604,72.9619712,-624.14772,629.094143167,290.229879,219.547035667,357.255507667,206.4397225,-477.537748167,-192.483506833,-42.1013330167,-175.626046167,60.4875321833,-67.6759960667,-40.40960435,116.501115,-128.978,-158.405353167,89.7044222333,162.794585167,141.708840333,3.195052465,1.65070157417,-21.26798375,-56.0030507833,-41.8722278833,5.55137925667,-81.0698124167,-3.250742675,48.4378180167,52.21085065,51.1435879167,-11.3287097333,5.65392541167,11.5796417667,12.0368367833,-0.777790035,-10.2168718067,-7.54318193,-10.6796729167,-27.33273735,4.12158407,8.06213213167,0.276005907667,13.9699054667,-3.73488389667,0.20599761405,-7.66977157,11.0509832167,2.40284251833,4.81828849167,1.90691839833,1.16870841667,0.37015238,-3.65501548333,-4.88587428333,1.59746293833,-0.890466879833,0.4963992025,1.44226899333,-0.397675709017,0.34896084,-4.33680823833,4.470559735,1.66410881667,-1.393085095,-0.4956533275,0.857276777,0.463779253,0.8393889735,1.04850160833,-0.529107606833,0.3490645485,-0.1992842365,-1.61990755667,0.487759447167,-0.799710439667,-0.177491328183,0.1378239505,-1.40133793333,1.58525928,0.2630466275,-0.00289919215667,-0.511199507667,0.186263692333,-0.386130199167,-0.175606298667,-0.00361899194833,0.222906620167,0.377288547667,-0.05138320195,0.418020186667,-0.233714562333,-0.656964149333,0.252549085167,-0.541192243,0.130554174833,-0.271246842833,-0.332537537833,0.255932851167,-0.102935631367,0.020890577235,-0.354198297167,0.110493429333,-0.118834182167,-0.02972259675],[-40430.0088333,-5273.52740167,3133.733965,-586.029665333,1187.50475667,-1181.81492167,-2818.28822,862.7042755,-154.5435715,-324.240650167,1112.18890667,1068.504068,-594.932528667,15.8655692633,-1076.61329333,90.4354172333,-609.3226875,637.9422415,298.951694167,223.754785167,343.705144,192.992882333,-467.997754167,-162.900096333,-32.9706419333,-179.616109167,59.64421105,-72.7267803833,-38.6699871333,109.299102167,-139.6844145,-154.891916833,101.371634467,180.968464833,128.3066325,5.0040049,-0.704953911667,-22.2412924333,-58.0041271667,-41.06131815,3.36436929167,-83.6249925333,-1.29656288167,50.56913405,58.0664178167,45.49503095,-11.80829085,4.76149526333,11.4823955167,11.60780445,-0.699048019833,-10.3925552167,-7.00836476167,-11.0996074167,-27.4041200167,4.91671896167,7.816872795,1.14959606,12.7150703833,-3.372588005,-0.00923526546667,-7.73854817167,11.9423013167,2.16191286833,4.86803177333,2.061264345,1.24221494,0.564168877333,-3.68549937,-4.739185035,1.809510275,-1.067994057,0.5718756815,1.32066193833,-0.0217565239,0.3517856645,-4.211063235,4.93340096333,1.641319075,-1.35590260333,-0.585477450333,0.9010969815,0.489273433167,0.849357754167,1.09704357833,-0.511420118167,0.421783460333,-0.194845998333,-1.64143608667,0.496355963,-0.791712327333,-0.0454666921833,0.157691456833,-1.31968453333,1.75411093167,0.239434957,0.0350995471817,-0.497910230167,0.228737512333,-0.398606534667,-0.174173836333,-0.0122620429933,0.2152104115,0.382064924833,-0.04496188495,0.4399552355,-0.256628952,-0.651720795,0.257895425167,-0.537891689167,0.156560622667,-0.2718060085,-0.306149006833,0.300807818333,-0.115808925333,0.0338101978,-0.352562692667,0.129750055833,-0.122437631,-0.03218640185],[-40438.6179667,-5568.976625,3389.50469167,-740.330398833,1235.21294333,-1186.54155,-2647.73476167,730.656017667,-186.287041,-244.650594,1134.381735,1158.98025667,-610.066948333,12.8734737483,-1073.72927,110.5460571,-590.950695667,643.866351833,303.898977,226.422002,324.912664667,174.219372667,-454.691636,-131.458486767,-22.4266437,-182.787403833,58.9590217667,-78.0905080333,-37.5190571,101.6162064,-151.559407667,-149.667170833,113.043736667,197.987074,113.751876633,6.97696970833,-3.0543007875,-22.8702170833,-59.7784574833,-40.3461122833,1.372423545,-86.0035332667,1.15227801333,52.5377793667,63.6636220667,39.4484634333,-12.1999837667,4.10660955,11.2868120667,11.1097662833,-0.534802645333,-10.4841659167,-6.43170495833,-11.4178393,-27.3392454833,5.80892309333,7.46939214167,1.98529926333,11.3384062917,-2.99902073667,-0.149543633117,-7.73626666167,12.78210965,1.87123890667,4.89465313167,2.21236509333,1.32570802167,0.782156578333,-3.69310047833,-4.563707345,2.03777525667,-1.265596765,0.641879182,1.17717088333,0.364598227983,0.355306519833,-4.05003590833,5.37681581667,1.603296475,-1.30786513,-0.681146408167,0.942481316167,0.507485055,0.856042353,1.15125884333,-0.490617939,0.4975524435,-0.186303724833,-1.65896351,0.5023684695,-0.785823158333,0.0932978065167,0.171458309167,-1.22765446333,1.92139178667,0.207701697833,0.0754436734,-0.480497621833,0.265755902167,-0.4086148505,-0.1723932175,-0.0226052218167,0.205342428333,0.387306538667,-0.03820610835,0.461794244,-0.278811195333,-0.642648475167,0.263072547,-0.534244843333,0.185653347333,-0.273287864333,-0.276502914667,0.346384752,-0.130819328667,0.0468646646667,-0.348643464833,0.147047361333,-0.127586915167,-0.0350628219667],[-40483.5154,-5872.41915333,3626.178265,-918.9234045,1264.57957667,-1192.43858167,-2480.74251667,564.814640333,-220.508721167,-163.372332533,1149.34545667,1238.86831833,-631.875223,-3.19390415667,-1076.44027167,133.335187167,-569.6706515,646.8741445,304.216292167,227.3980555,300.997084333,150.253827833,-438.111824333,-98.9400767833,-10.639096035,-185.072213833,58.3938695,-83.79557705,-36.9093708833,93.3992192,-164.675232667,-142.905672,124.413402333,213.7503995,98.2277306333,9.06209650167,-5.319934865,-23.16207575,-61.2861489667,-39.7150508833,-0.459873298333,-88.27370045,4.03918855667,54.2734954667,68.95338245,33.0498058333,-12.4869625667,3.63111981833,10.9928223333,10.5624940567,-0.28853815395,-10.47527185,-5.82111292167,-11.6367325167,-27.1531786333,6.78802686167,7.01403972667,2.77355961833,9.83142946833,-2.60125948667,-0.246881735167,-7.66534819,13.573359,1.53503672833,4.89749151,2.35924565,1.42279923167,1.01999925633,-3.67421863,-4.35813578333,2.279943795,-1.48244235,0.7054795345,1.00484915933,0.7651873885,0.3512435905,-3.85357474333,5.80152821167,1.55395608,-1.25041070167,-0.781712659167,0.979588599333,0.518558631,0.8598802105,1.21010088333,-0.465376829167,0.577514251167,-0.173824003333,-1.6723505,0.506135992667,-0.783796416333,0.23977719955,0.177571612333,-1.12449938667,2.08675273667,0.169632469667,0.11779309275,-0.459910486167,0.297152630333,-0.416171515667,-0.170660155833,-0.0345427152,0.193255988,0.392975159,-0.0309352484833,0.483603958,-0.299981228833,-0.629742390667,0.268119699833,-0.530288725167,0.217997244833,-0.2757773835,-0.243153105167,0.392424216167,-0.147377353167,0.0601295566,-0.342790959,0.1622867495,-0.133932178833,-0.0381736645833],[-40563.9828333,-6167.85075333,3845.23016167,-1116.65589067,1276.43552833,-1199.11085333,-2328.742195,369.982238667,-255.663410833,-82.491529155,1157.61163833,1304.396805,-659.157433667,-30.3929909517,-1083.78290167,158.555799167,-546.036731,647.079728167,299.283611333,226.896464167,272.3229905,121.416938017,-418.765364833,-66.0599395,2.17449329333,-186.401752,57.9430920167,-89.8269000333,-36.7405975,84.6519784333,-179.040260833,-134.820995667,135.207057167,228.121674333,81.94753995,11.2136538583,-7.432838485,-23.1256758333,-62.4825662667,-39.1617743667,-2.167218165,-90.4970083333,7.28742625833,55.7186409333,73.86542505,26.36347375,-12.6534196667,3.27715735167,10.6058333333,9.983250415,0.0331542228667,-10.3501371667,-5.19033134333,-11.7617089667,-26.8618697667,7.83934794833,6.448803855,3.50150163,8.19356811,-2.16663417167,-0.3332631525,-7.52929402333,14.31682115,1.159055895,4.87568634667,2.50057839333,1.53639687667,1.27207414333,-3.62627698333,-4.12139118333,2.533066985,-1.71709590667,0.7621872825,0.7994217895,1.1832186065,0.331404782167,-3.62206694667,6.20728509,1.496859865,-1.18482290833,-0.886067741667,1.0106752215,0.522812541,0.8611092545,1.27236295833,-0.4346078585,0.6627794185,-0.157571852167,-1.681394555,0.508429885833,-0.7867455595,0.394604666833,0.174563631167,-1.00989036317,2.24951728333,0.126757547967,0.161892953833,-0.437080233333,0.322660660333,-0.421330964667,-0.169318513,-0.0479365342667,0.178886258667,0.399060498167,-0.02301831765,0.505432342833,-0.319818912167,-0.612999827833,0.273167711167,-0.525983777167,0.253632608833,-0.279299227833,-0.2058808695,0.438654141667,-0.164990014833,0.0737153894167,-0.3353563575,0.175296242333,-0.141102754333,-0.0413390494167],[-40664.9238667,-6424.77106333,4059.101395,-1327.947825,1277.725425,-1202.71188167,-2200.99124,154.951657067,-291.269581333,-2.95734753667,1160.13286833,1352.91422333,-688.8219305,-66.7204385333,-1093.59319167,185.545111667,-520.653307167,644.492409333,288.818953333,225.557018333,239.333840667,88.6340432,-397.2287015,-33.2775787477,15.743627715,-186.817189167,57.54663925,-96.1167510667,-36.8760900333,75.41894485,-194.450756833,-125.667247,145.292176333,240.885710167,65.1565826667,13.3966850833,-9.36233453833,-22.7786343167,-63.3301338167,-38.693934,-3.77207618333,-92.6918605333,10.8038277233,56.8674690167,78.2857572333,19.4801606333,-12.6986054167,2.989930285,10.1375566267,9.38380810167,0.42367643305,-10.1011134883,-4.56009171833,-11.79630935,-26.47928855,8.94529026,5.78468332333,4.14265947,6.43602047167,-1.69347921333,-0.4378773565,-7.334314995,15.0101166667,0.750568669833,4.82903372,2.63552956667,1.66666646167,1.531585505,-3.54726257333,-3.85448223167,2.79422910833,-1.96663614333,0.808356629167,0.560269465167,1.616870065,0.288943789667,-3.35809468333,6.59200026167,1.43463081667,-1.11285834,-0.992903510833,1.03457852,0.520734391833,0.859601875667,1.33685902167,-0.397702759,0.753596454833,-0.137482714333,-1.68615457333,0.5096785945,-0.795000282333,0.5569218545,0.161451616667,-0.884621556833,2.408267595,0.0800442598,0.206964535833,-0.412928673,0.341772397833,-0.424152158333,-0.168527564833,-0.06263279685,0.162234165667,0.405607898833,-0.014472251195,0.527184184833,-0.337951545333,-0.592585974,0.278400791833,-0.521206180667,0.292299699833,-0.2836848105,-0.164860021,0.484639602833,-0.183397226,0.0874842342833,-0.326676361833,0.185724007833,-0.148694445333,-0.0444171198833],[-40750.3283833,-6593.17952167,4293.448965,-1545.53717167,1283.80912,-1194.719875,-2103.73972167,-66.9429702333,-327.879293333,76.067613145,1158.65885833,1383.32928833,-715.593267167,-109.99323995,-1102.38920167,213.114897667,-494.080191667,639.081518167,273.021848667,224.5855065,202.612463667,53.51972295,-374.126264,-0.764603340667,29.69316615,-186.486401333,57.0866399833,-102.517372,-37.0956967667,65.80650835,-210.443485333,-115.726116167,154.703831833,251.755149167,48.1425005,15.5767256,-11.1320580867,-22.1544490167,-63.7988164,-38.32607705,-5.279711315,-94.8153815833,14.4814574333,57.7800668833,82.06061425,12.52374593,-12.6353977833,2.72024346,9.607108245,8.76544065333,0.8737166715,-9.73128795167,-3.96024541167,-11.7419409,-26.0134653,10.0846225367,5.05096528,4.65750912,4.585169775,-1.19064220333,-0.5851965945,-7.08928469333,15.6486528167,0.319792891333,4.757509925,2.76329971167,1.80995930667,1.78892354167,-3.43607261,-3.56063169333,3.05986685333,-2.22532019833,0.836637459,0.291714726492,2.05916877333,0.219289679,-3.06648795833,6.95250867333,1.368914985,-1.03644978983,-1.1002943715,1.05101721833,0.513062139167,0.8546737205,1.40199052167,-0.3546822125,0.848884715667,-0.113467530583,-1.68683336,0.509588327167,-0.807773197833,0.724173056667,0.1380525295,-0.750703948667,2.56117406167,0.0298510903833,0.2519200395,-0.388423897333,0.353794040667,-0.424681273167,-0.168097542,-0.0783836699,0.143392876167,0.412713284,-0.00548103489333,0.548442257,-0.3539626395,-0.568911932333,0.283941876833,-0.515715255833,0.333325466333,-0.288508307,-0.12072817145,0.529868428333,-0.202615044333,0.10114343835,-0.317124761,0.1930789925,-0.156292323833,-0.0472930815],[-40774.2044667,-6620.85082167,4570.20960167,-1759.53232167,1313.32376333,-1167.69459833,-2039.496655,-283.7664051,-365.803685,156.48282575,1154.87253833,1396.057675,-734.279382333,-157.703161167,-1106.26509833,239.985674167,-466.712518333,630.818976833,252.535510667,225.262209667,162.922232667,17.9244130833,-350.0462955,31.3371159857,43.6050453167,-185.595289667,56.4389366333,-108.805913333,-37.1340726667,56.0034537,-226.456530333,-105.240672617,163.513459,260.464338167,31.1918115667,17.70908595,-12.7859423,-21.2874843333,-63.86340385,-38.0627162167,-6.67097736,-96.7983669167,18.22422145,58.5362731833,85.0511497833,5.62563169167,-12.4714222833,2.43311331333,9.033400305,8.12422308167,1.37406417283,-9.250810555,-3.42093924167,-11.5962439667,-25.46834165,11.23904135,4.28497046167,5.01216670667,2.67384484583,-0.666126644333,-0.791207293333,-6.80428560667,16.22726895,-0.121990065333,4.66096817167,2.88308439333,1.96063644667,2.03382694667,-3.29201358833,-3.2437444,3.32703431167,-2.485505105,0.840474393,0.0008437528,2.50273859167,0.121511008488,-2.75321548333,7.2859729,1.30109346167,-0.9574028905,-1.20597951167,1.06010320833,0.5005567535,0.845486588833,1.46592635667,-0.305985237333,0.946877574833,-0.08536151405,-1.683566395,0.507861680833,-0.823527802333,0.893535366333,0.105219120217,-0.610610571667,2.70669019667,-0.0235730462667,0.295741343,-0.364531296333,0.358168135,-0.422964383167,-0.167674825833,-0.0949081382167,0.1225432505,0.420440813833,0.003663919585,0.568630404167,-0.367453678833,-0.542526361167,0.289864392,-0.509144403167,0.3759237535,-0.293117928167,-0.0742694445,0.574006007333,-0.222712376333,0.114439163,-0.307070492667,0.196957437167,-0.163516815,-0.0498353648833],[-40735.7516833,-6512.62017,4869.9493,-1960.66378,1368.61866,-1131.67927833,-2005.62297667,-498.792185,-402.1563345,237.767261,1147.3804,1392.65425,-745.862119,-207.178160167,-1102.82446,266.1430035,-438.7311335,619.6837305,228.269664167,227.406769333,121.211018367,-17.1214062333,-325.503230833,62.4043516167,57.2634287667,-184.081311,55.6349049667,-114.728308,-36.8546257333,46.3565779167,-242.237018,-94.3009863,171.563932833,266.979811,14.473818585,19.7190266667,-14.2948491167,-20.1528545667,-63.50966455,-37.8558803,-7.86727615,-98.6413005167,22.0041504167,59.13755175,87.2570625667,-1.13664202,-12.1772980667,2.13497158833,8.41209097333,7.466094305,1.92891945,-8.672150285,-2.94255246833,-11.34638525,-24.8504969,12.4129129167,3.50976507333,5.22006404167,0.723860846667,-0.107666561,-1.05179558433,-6.48997594,16.7425306333,-0.568617022333,4.53814910333,2.99427640833,2.11427137333,2.26394400667,-3.11466424,-2.90441459167,3.59815744333,-2.73937433,0.8243156195,-0.305824705175,2.94848492,0.00249422795333,-2.424824035,7.59233823333,1.23337902,-0.877415572667,-1.308144695,1.06088213167,0.4829505075,0.831647147833,1.527518515,-0.252806650167,1.047070935,-0.0526625850333,-1.67583796167,0.506014276833,-0.840316634833,1.06469609033,0.0656614818333,-0.466336001833,2.84489537667,-0.0791943783833,0.337930564167,-0.342055275667,0.355254260167,-0.418960382,-0.167251002,-0.1122448553,0.09986066425,0.4285086035,0.0124084598533,0.587565722667,-0.378370721333,-0.513864404333,0.2962814985,-0.500886470833,0.419814954833,-0.2966420055,-0.0259145348667,0.617446377,-0.243372926,0.127409904,-0.296756249167,0.197567961667,-0.170176189667,-0.0518276081833],[-40637.6548833,-6325.21654667,5166.97077333,-2147.947085,1443.53992167,-1098.14429167,-1990.36409833,-705.453157167,-435.5073755,320.313604333,1135.27100833,1375.935225,-749.655348167,-257.667718,-1091.96845333,291.954660833,-409.795795,605.8046675,200.7415385,230.482798333,77.90344415,-50.97680655,-301.2001275,92.7898559167,70.6674657167,-181.895793667,54.67225765,-120.2256685,-36.30817935,37.1836186333,-257.410644667,-83.0629980833,178.9418275,271.349473667,-2.07623787667,21.5504820833,-15.6726944,-18.7451934333,-62.74308335,-37.6694616667,-8.77214461167,-100.283271883,25.7735719333,59.5776116833,88.6998763,-7.74851080833,-11.7792190333,1.88923285667,7.72718559,6.79369818333,2.542111685,-7.99902290667,-2.51400803833,-10.9764106833,-24.16295625,13.6074022667,2.72996860667,5.293300175,-1.24207380417,0.477299357667,-1.34298185,-6.14153024,17.1833496833,-1.0173815215,4.39190255167,3.098183125,2.269514745,2.48032983333,-2.90460944167,-2.548134265,3.87554825667,-2.98257993,0.7897715535,-0.616824279833,3.39468483667,-0.127992573678,-2.08380839167,7.86900426333,1.16220667,-0.799017023667,-1.40487153,1.05371069833,0.460513525167,0.812803589833,1.58544468167,-0.196735141667,1.14737686167,-0.0147418370667,-1.66260551833,0.504975218333,-0.855159259167,1.23777347833,0.02169322235,-0.320175076667,2.975505125,-0.138118093933,0.377591937333,-0.320579271333,0.34621201,-0.412412499167,-0.166875878333,-0.130460870833,0.0753581040833,0.436367490833,0.02023573115,0.605133695833,-0.386605087833,-0.483059551833,0.303384853167,-0.490489809167,0.464869675833,-0.298405274167,0.0233603757,0.660672172167,-0.264586356333,0.139995842833,-0.285958369833,0.1954320145,-0.176348640333,-0.0533868293],[-40491.0218833,-6119.64336667,5439.60632667,-2328.01254,1529.75343,-1076.33451,-1979.58688167,-891.8772935,-466.232649333,403.6418905,1118.26761833,1348.56570833,-744.126614833,-307.96091,-1074.72476667,317.761024,-379.931187833,589.327498667,170.0213275,233.7163605,33.4657801,-83.3348659333,-277.786587833,123.133707167,83.9347639167,-179.110494833,53.5045692833,-125.419666833,-35.6659541167,28.7473257167,-271.626653667,-71.6400451,185.762131667,273.723616,-18.5469014983,23.1818563,-16.9500942333,-17.0725513333,-61.60371205,-37.4825497167,-9.32448568333,-101.665249167,29.4947609,59.8180413833,89.4408876833,-14.1993168367,-11.3155077667,1.77787755167,6.96483642667,6.11663097833,3.216546015,-7.236033725,-2.12106083833,-10.4821841617,-23.4142026167,14.8229451,1.93276616167,5.25435488833,-3.20189349,1.08034718467,-1.63278382167,-5.74641673167,17.5425106667,-1.46658083333,4.22923167,3.19687425333,2.426599155,2.68571667,-2.664720525,-2.18297053333,4.15973141667,-3.21527799,0.739811418667,-0.922008577167,3.84138342,-0.258764870833,-1.72993913167,8.11549829,1.08189346917,-0.724684143333,-1.49454487167,1.03968084667,0.433797152833,0.789245235,1.63857002,-0.139320164183,1.245399325,0.0283866420167,-1.64323639,0.505781923167,-0.866106167667,1.41398004833,-0.02459961215,-0.173999846167,3.098850005,-0.202197823333,0.413997836333,-0.299605459333,0.332716551167,-0.403113158167,-0.166702028167,-0.149617880167,0.0491976061167,0.443434282333,0.0268507197667,0.621419694833,-0.392126969167,-0.450105951,0.311374339333,-0.477906713,0.51124143,-0.297925453667,0.07260541685,0.7042795965,-0.286420362667,0.152309310833,-0.274465763167,0.191283256167,-0.182152804,-0.0547560381333],[-40321.9879167,-5960.73515667,5668.27198167,-2508.00442333,1616.25331167,-1072.17947333,-1962.47717833,-1051.88019383,-494.2644145,486.768012333,1097.04832167,1312.370645,-729.6508005,-356.1713455,-1053.30726167,343.988695333,-349.2471595,570.597240167,136.085532017,236.1707335,-11.5688785167,-114.379044433,-255.550035833,153.661551833,97.16762895,-175.801693333,52.0994973667,-130.419054167,-35.0658921,21.2189395333,-284.678910667,-60.0165812667,191.971289333,274.350293333,-34.9859521167,24.5922336833,-18.1531712833,-15.15785755,-60.1334938667,-37.2572066833,-9.507516395,-102.7420025,33.1572870167,59.7922077833,89.5983485167,-20.471295,-10.7876956,1.88631010333,6.11418113833,5.44350701833,3.94857830833,-6.39262700167,-1.746897675,-9.87067737833,-22.61058985,16.0571297167,1.103713136,5.14410914667,-5.13776511667,1.70837590167,-1.88508602833,-5.290895915,17.82059205,-1.91405444167,4.056583345,3.29100023333,2.584465605,2.88225868833,-2.398963545,-1.81576262,4.44867926333,-3.4370792,0.681929018,-1.2145135715,4.29268819,-0.377614704833,-1.36188053567,8.33507278167,0.987353554667,-0.654901616167,-1.57561877,1.01995449867,0.403362343167,0.7613399445,1.68571831833,-0.0816929047,1.33908190333,0.0760871449833,-1.61707666833,0.509828079167,-0.8722840345,1.59492782667,-0.0710459011333,-0.0291521913333,3.216471455,-0.272980138167,0.447540309,-0.279170565167,0.316709470333,-0.390931956333,-0.166814716833,-0.169621977833,0.02167802169,0.449184175667,0.0321766783167,0.636512246333,-0.394945325667,-0.415035247667,0.3203520885,-0.463266913667,0.559071237333,-0.294869554333,0.1210874882,0.749045086167,-0.308872957,0.164835091,-0.2623457705,0.186004151667,-0.187741268,-0.0560749325],[-40145.4342667,-5893.69298,5832.22818167,-2693.05227167,1693.11271833,-1087.298205,-1931.68598667,-1179.12339333,-519.5568705,569.215425333,1072.51829167,1268.89915333,-707.280455,-399.505063167,-1029.85039167,370.966696667,-317.976957833,549.960757167,98.9806289,237.277141167,-56.3695104,-144.037286833,-234.72213,184.323079167,110.3532903,-172.101104167,50.4205013333,-135.252663667,-34.6015565333,14.738098715,-296.4145525,-48.2125135,197.396885,273.472682,-51.33675875,25.7539425,-19.2947447833,-13.0439048667,-58.3608550833,-36.9593682,-9.31701482333,-103.459404833,36.7673830667,59.4391834167,89.3093772833,-26.5118933167,-10.1802722933,2.28273419167,5.17364568667,4.78162721167,4.73293083167,-5.48210299833,-1.37587653167,-9.15071633167,-21.7560384833,17.3041897,0.232020744833,5.00346314833,-7.02615955167,2.37078605,-2.06483901333,-4.76542844833,18.0227607167,-2.35617385333,3.87905273167,3.381586625,2.740640355,3.069484595,-2.11100956667,-1.45312225833,4.73996848167,-3.64547016,0.6263183555,-1.48765234667,4.753785915,-0.4723513595,-0.9797480785,8.53158454833,0.874699779833,-0.590556183167,-1.64642075333,0.995788391833,0.369729369667,0.7291833505,1.72556570333,-0.0246394525833,1.42676731667,0.1276769905,-1.583170265,0.5183905145,-0.872988676833,1.781428245,-0.114565604683,0.112521517667,3.33029181667,-0.351460024833,0.478695839333,-0.259731413833,0.300161181167,-0.375802244833,-0.167272554,-0.190292179333,-0.00689153404,0.4532568275,0.0361250939667,0.6503198795,-0.395155314833,-0.377994619,0.3302862565,-0.446672114,0.6083908875,-0.288777269833,0.168051330167,0.795522776667,-0.331910996167,0.1779609815,-0.249885969667,0.180433572667,-0.193153489,-0.0573981583333],[-39958.1119667,-5901.72567667,5915.88131,-2876.25737167,1764.27681167,-1119.03776167,-1893.704585,-1272.46405333,-540.165971333,651.049286333,1046.36839333,1218.53768333,-678.389837667,-431.598659667,-1004.34695483,398.4044005,-286.830341,527.886132333,59.4806009,237.2339905,-99.1678029333,-171.383662667,-215.855348,213.963235833,123.109005833,-168.217023167,48.4295661833,-139.683786667,-34.0885986167,9.46808805833,-306.598074667,-36.3742680833,201.603853167,271.368655333,-67.1899417,26.5951063167,-20.3745836667,-10.793170035,-56.2999954333,-36.5321322,-8.79041496167,-103.779616333,40.3235589833,58.71604395,88.7187709833,-32.1663195,-9.44319181667,2.953317025,4.16015373667,4.13687298167,5.55727758,-4.53302808833,-1.00764760433,-8.33879543667,-20.8560436833,18.56324115,-0.669380459,4.87668011833,-8.83542531,3.08994961667,-2.16339735833,-4.17766617333,18.1696271833,-2.78155254,3.698136275,3.46876888,2.88766575333,3.24073638167,-1.80294430167,-1.09836865267,5.03287881333,-3.83259723833,0.585905202667,-1.73818012833,5.23118346667,-0.532516791667,-0.589047939667,8.71432125,0.746727212,-0.5351217325,-1.70460187,0.967653127667,0.333616559167,0.692454275333,1.756431575,0.0317912987,1.50775934667,0.182322963333,-1.54079040833,0.533180924333,-0.868412354,1.97332520833,-0.150120029,0.2486269435,3.44293973167,-0.436138018833,0.507217994,-0.243478012333,0.285002729167,-0.357989829667,-0.167922584667,-0.2113039095,-0.03602572666,0.4555880915,0.0385340808,0.662473563167,-0.393042808167,-0.339525423167,0.341024174667,-0.4280813325,0.658933578833,-0.278512442,0.212970039667,0.8440256165,-0.355165267833,0.191963724333,-0.238133401833,0.175343053,-0.1979366095,-0.0585094988667],[-39758.0447333,-5949.22269167,5906.68578167,-3047.21895667,1835.77182333,-1162.06115333,-1859.63431833,-1339.06013333,-553.433581167,731.5937125,1020.7671665,1160.73381833,-646.4558895,-446.629406167,-976.454562,425.891292833,-256.737421833,504.798234167,18.3660179,235.995755,-138.258305267,-195.515697,-199.431625833,241.473311667,134.996027333,-164.328525833,46.0512535167,-143.425147667,-33.3232068333,5.57515419667,-315.0527225,-24.6380512833,204.186884667,268.395872,-82.1114251333,27.0484383667,-21.36560925,-8.47738778167,-53.9510198833,-35.9107431833,-7.96791621333,-103.692584167,43.8216390333,57.5909478333,87.9832343833,-37.2779775833,-8.538200005,3.83362357833,3.09703764833,3.51996250833,6.40756964167,-3.572895325,-0.642373137833,-7.45439196333,-19.92046265,19.83251195,-1.5853606975,4.80670103833,-10.538063945,3.88400644167,-2.19152684167,-3.544361665,18.2894024833,-3.17780460333,3.51430426167,3.552719725,3.0175467,3.38951771667,-1.47785790333,-0.753865051333,5.326346545,-3.99117849,0.572612040333,-1.96531514167,5.73005014333,-0.551583730167,-0.197770714,8.89475937,0.6100009015,-0.4914005475,-1.74825356333,0.935363501167,0.2959239735,0.650670079167,1.776935655,0.0874988088333,1.58188181,0.2391081495,-1.48962251167,0.556004105667,-0.85940887,2.17018247667,-0.1729809155,0.3768639525,3.55690948833,-0.524011449667,0.5330416535,-0.232704678333,0.2724730145,-0.337978417167,-0.168674605167,-0.232279199167,-0.0652479570667,0.456179326167,0.0393432881,0.672659178167,-0.388885527167,-0.300249636833,0.35256407,-0.407522044833,0.710390355333,-0.262909014,0.255599273833,0.894606709833,-0.377966982667,0.207125012,-0.228172568333,0.171187294833,-0.201658429167,-0.0591757773],[-39559.4079833,-5983.80119833,5807.97786333,-3200.521985,1913.06845167,-1207.19066,-1839.955105,-1388.16094167,-557.9517795,808.366850667,997.727777333,1095.047165,-616.194460167,-440.628859833,-944.919403333,452.986654333,-229.126265167,480.747326333,-23.5961310833,232.987829667,-172.324281167,-215.342964333,-185.950537,266.371464833,145.7014105,-160.676337833,43.1106478333,-146.234928833,-32.2709561333,3.17400961667,-321.6096885,-13.2030391467,204.998575667,264.9085425,-95.6834297,27.09789115,-22.2271469333,-6.18029401833,-51.3302350167,-35.0747824,-6.896480655,-103.217076333,47.2276506,56.0913225833,87.2343147333,-41.6927633833,-7.46694841,4.82878370667,2.01701998533,2.95184041,7.27096711833,-2.63344939667,-0.284070856167,-6.523065355,-18.9717292,21.0993871833,-2.49482527167,4.81933249167,-12.1046962167,4.74916573667,-2.17137849333,-2.89094185167,18.4131060833,-3.53366483167,3.330538775,3.63515193,3.12162684167,3.51135446333,-1.14191455483,-0.426275080167,5.61669290333,-4.11676957167,0.592503925833,-2.16870900833,6.24749673333,-0.5269362935,0.182241709333,9.08398693,0.472512129833,-0.461413130667,-1.776739625,0.899129979833,0.258030903167,0.603630636333,1.78665505167,0.141925909467,1.64810740833,0.296976531,-1.430921395,0.587781878667,-0.84744185,2.36935808667,-0.179493063667,0.493881940833,3.67388766833,-0.611603264333,0.5560871855,-0.22945364,0.263002489,-0.31659228,-0.169443290667,-0.252759648667,-0.0938842814,0.455261075667,0.03866879405,0.680588758833,-0.382857399833,-0.2612612505,0.365001344667,-0.385388761167,0.761951989833,-0.241158533167,0.295411592,0.946850850667,-0.39966329,0.223515804667,-0.221016240333,0.168017654333,-0.204043755333,-0.0592382511167],[-39373.45165,-5937.60049167,5642.187445,-3333.11379333,2005.27527,-1240.28972,-1843.45223167,-1422.906955,-553.679106,878.684712,979.561806167,1021.6616515,-590.5217075,-410.024881833,-907.024104667,478.981944833,-205.7363425,455.539950167,-65.4862950333,227.8742065,-200.115522833,-229.118842667,-176.049172833,288.496145833,154.937030667,-157.623657167,39.35198535,-147.891756667,-30.9305444,2.34298492,-325.911885167,-2.36503531833,204.0576025,261.167765333,-107.426783717,26.7552339,-22.9367794333,-3.999493685,-48.4753362167,-34.0400458,-5.63307175833,-102.348996333,50.4742312667,54.2983746833,86.5580171833,-45.22309665,-6.249461205,5.84612236,0.962203117567,2.45820252667,8.13420119833,-1.7544155925,0.0531892561667,-5.573607955,-18.0370306333,22.3412136,-3.36445257,4.92441732333,-13.4921834167,5.667504965,-2.121139015,-2.24678530667,18.5695714,-3.836629985,3.15278505833,3.71890704333,3.18993372833,3.60065387833,-0.802499072,-0.1267102455,5.89815854167,-4.204847465,0.647364044,-2.34506969167,6.77386636,-0.454846704333,0.535964584,9.29142343667,0.341377715667,-0.447498825667,-1.789769175,0.8600408995,0.221754015667,0.551548001333,1.78540447,0.194344676833,1.704062985,0.3548946865,-1.36682175667,0.628669993,-0.833655613333,2.565950625,-0.165641597,0.594776831167,3.794886185,-0.6959259445,0.57590458,-0.235841512833,0.256809724167,-0.294871209833,-0.1700293825,-0.272194705,-0.1209762937,0.453282136333,0.0366869724,0.6858356775,-0.374997669,-0.2240378765,0.378364102833,-0.362206543167,0.812238965333,-0.212423546667,0.331269744167,1.00008292783,-0.4198784345,0.240975877333,-0.217758716667,0.165719096167,-0.204809306167,-0.0585665169833],[-39208.5852,-5751.24712,5432.970035,-3440.03209833,2119.75662333,-1247.07952,-1881.32371167,-1446.90945833,-539.832691667,939.767134333,968.478521667,939.902937333,-572.537205833,-351.6805465,-860.375000833,503.341160167,-188.145947,428.960840833,-106.535080933,220.221905,-220.5537585,-235.248781,-170.391298,307.550004167,162.440027833,-155.437673833,34.5375608167,-148.165510833,-29.3097553167,3.110541265,-327.630699833,7.55867036,201.300925167,257.406547833,-116.873397167,26.0279331,-23.4419435333,-2.0219118945,-45.4051560667,-32.8137119,-4.24024962167,-101.0884572,53.4841541833,52.2619864167,86.0308725333,-47.6911784,-4.90339132667,6.78889167167,-0.0301178534,2.07013548167,8.98578718167,-0.968007364167,0.359996226833,-4.63238658833,-17.1421504833,23.53321285,-4.16789470667,5.13307872667,-14.6621072167,6.62248416667,-2.06133853167,-1.640493785,18.78458895,-4.07577916667,2.98646923,3.80660428333,3.214139895,3.65327228167,-0.465566342333,0.135209955833,6.164791055,-4.25144367333,0.740138464667,-2.49274366,7.29992480833,-0.332647187333,0.848967964667,9.52494523333,0.223701069833,-0.4519886515,-1.78730324667,0.818453634,0.188696375,0.494815456333,1.77316765,0.244409923167,1.74793643,0.411950044333,-1.29900769333,0.679163411667,-0.819441355667,2.75528934,-0.127695420583,0.674977297167,3.92032593333,-0.773822655333,0.5920164225,-0.253940282167,0.254058384333,-0.2738339825,-0.170463504333,-0.290108946167,-0.145611379333,0.4506191475,0.0336312641167,0.6880926375,-0.365270047667,-0.189787475,0.392683851833,-0.338436236833,0.859936653667,-0.175880045667,0.362170277167,1.053497735,-0.438118114,0.2593756775,-0.219467019667,0.164156015167,-0.203636500833,-0.0570248703],[-39065.6343167,-5410.16673,5200.537965,-3511.58327,2251.50978,-1216.51863,-1973.14550833,-1466.54217667,-513.409597333,987.751133,965.957720667,846.31648,-566.417609667,-264.456947167,-805.035019167,526.3147065,-177.225651833,400.917411,-146.620758667,209.130259667,-233.3877095,-233.3208505,-169.737181833,322.797761333,168.127991333,-153.979800833,28.5625910333,-146.884997333,-27.5191466833,5.29190291667,-326.781012,16.182780835,196.4045695,253.865046,-123.692578167,24.92253225,-23.5771840167,-0.289593726333,-42.0913963,-31.3862866167,-2.80310294833,-99.4961104667,56.1629877,49.9126494333,85.7453924333,-49.0105020333,-3.44025226,7.54930940833,-0.943713611767,1.83415363833,9.82189423,-0.276052299833,0.649184781833,-3.717058005,-16.3093122833,24.6522121333,-4.91666072833,5.47118974,-15.6120999667,7.60579515833,-2.02286168833,-1.09413881033,19.0778093667,-4.24933777667,2.83422662,3.90060814333,3.1947422,3.67395294667,-0.131658007667,0.357422232,6.41279468167,-4.25879092667,0.8801412275,-2.619766685,7.82237149833,-0.1632160179,1.11250013483,9.789641665,0.126490704983,-0.4773131205,-1.77111223667,0.772105467333,0.159631359333,0.434697213,1.7514933,0.293255692667,1.78103827167,0.467860319167,-1.227973975,0.741476340333,-0.807667381,2.93570628167,-0.0638635616333,0.732792590833,4.04984179,-0.841785362333,0.604144133167,-0.285464188833,0.2549925325,-0.254390592333,-0.171681035333,-0.306431712167,-0.167300343167,0.447423152333,0.0299122668667,0.687795833833,-0.353579656167,-0.158552656833,0.408178051667,-0.314416008667,0.904722330167,-0.131120536133,0.38816701,1.10623005667,-0.453508496833,0.278859335167,-0.227021575833,0.163339911,-0.200206756167,-0.0545129238],[-38918.28845,-4963.43881833,4957.66575667,-3541.82004,2380.72963,-1145.72493667,-2125.63474833,-1482.36079667,-473.690373667,1019.927571,972.076144667,740.980415333,-572.827769833,-151.057963433,-744.650123167,548.2216515,-172.387952,371.581089667,-185.584488833,194.205545667,-239.461733833,-224.458666833,-174.284511333,334.539858167,172.187035333,-152.8393475,21.4823020167,-144.1078595,-25.7788469667,8.59773764667,-323.5878965,23.2538725333,189.445416333,250.7241635,-127.903934667,23.5031454,-23.2165073167,1.17699889217,-38.5467021833,-29.7933778333,-1.37449725005,-97.5848863667,58.4239386,47.2253725667,85.7843228333,-49.2282310833,-1.9046430015,8.10063242833,-1.774743102,1.77205877167,10.6349500533,0.332532546667,0.936556275,-2.83317229,-15.5359205667,25.6730228667,-5.64039262,5.96276136167,-16.3580827,8.590135375,-2.00945497333,-0.610553378833,19.4475412667,-4.36419574,2.69719253833,4.00184544667,3.13923311167,3.67218269333,0.199161703333,0.540141473,6.63820878333,-4.23671598167,1.07396700983,-2.73001546333,8.33351200833,0.0520476834,1.32736993667,10.08267646,0.04995748025,-0.523597334667,-1.74420689,0.720189971167,0.1352654335,0.373191823333,1.72258145333,0.3415117055,1.80367841333,0.522445067167,-1.15427456667,0.816574938,-0.798889937667,3.10591146167,0.0255379278833,0.768779459,4.18169968667,-0.899329539333,0.61248044,-0.330036229167,0.259961157167,-0.237075375667,-0.174306511667,-0.321126964667,-0.185919370833,0.443551552167,0.0259108411,0.6851881575,-0.339845157,-0.129685193333,0.424860281833,-0.290259447667,0.946727926,-0.07856147535,0.409349082333,1.15750078833,-0.465766844833,0.2995159565,-0.240313491,0.163455007833,-0.194662104167,-0.0511864191],[-38780.2370667,-4464.50819333,4716.68083333,-3539.34479167,2497.09560833,-1043.15008167,-2330.11342,-1493.98342167,-421.8203845,1038.63582333,983.171980833,626.868794,-588.964054667,-18.6792262333,-684.800915667,569.883930833,-172.1357775,340.776825833,-223.462488333,176.315769333,-240.871695833,-210.94973,-182.876747667,343.913018833,175.070229667,-151.797435167,13.5097811267,-140.095102333,-24.1135143667,12.5906699417,-318.588965,29.03278455,180.7774125,247.926153167,-129.8522425,21.8554713167,-22.3907351333,2.43208807333,-34.8085201167,-28.0880776,0.00725308646667,-95.41101395,60.3090151833,44.20528005,86.1334991667,-48.4850838,-0.331964604333,8.50855422333,-2.53791791,1.868862375,11.4302159,0.876236961667,1.21817211183,-1.97852119833,-14.8183707833,26.5958911833,-6.37561478667,6.60462973167,-16.91855065,9.55056539833,-2.00180807333,-0.181041159833,19.8652355,-4.433823145,2.57654564333,4.11026070833,3.05687560833,3.651524915,0.527667089167,0.686135892,6.84079757333,-4.19769129333,1.32111241167,-2.82131572667,8.82664511,0.308720526267,1.499482745,10.3930816,-0.0116306004167,-0.586216206833,-1.70964197833,0.664369642833,0.1150400407,0.311543435667,1.68788124,0.389874850833,1.81723082,0.5754481765,-1.07840347,0.904003591667,-0.792012633833,3.265310025,0.136385372867,0.784673544667,4.31382733167,-0.9484296115,0.6183602885,-0.385106381833,0.268609753167,-0.221819924,-0.1782725385,-0.334539947,-0.201812741167,0.439092617833,0.0220688699333,0.680857297833,-0.324363800833,-0.102387180233,0.442708312167,-0.266180017667,0.9863065615,-0.0197937235167,0.425921542833,1.20718420167,-0.475148775833,0.321258821,-0.258259797,0.164421944667,-0.187719655,-0.0472466286667],[-38669.7283167,-3935.61697167,4472.33949667,-3511.93872167,2599.07759,-920.425942333,-2572.52153167,-1498.42323667,-358.8122555,1047.188455,995.845312667,507.891103,-610.9787815,123.779849067,-631.016787667,591.9028195,-175.251659,308.665180167,-260.3333755,156.418757833,-240.142696,-195.251163667,-193.781183167,351.781810667,177.102237667,-150.823832167,4.95837788167,-135.175674333,-22.6090405833,16.8235091,-312.391180333,34.0362716667,170.652627833,245.3709765,-129.840219167,20.0282904833,-21.1884697833,3.53802373,-30.9328211833,-26.35495495,1.34056555162,-93.0476726833,61.93034105,40.8412500667,86.7576755333,-46.8976936,1.2248855285,8.846105945,-3.251873295,2.09972943833,12.2071792833,1.3698891535,1.482771415,-1.13587881667,-14.1540266,27.4332264333,-7.15495666167,7.387413605,-17.3048449833,10.4512070517,-1.981203975,0.207607818667,20.29119125,-4.46952668167,2.47311285667,4.223297135,2.95577496167,3.615574895,0.857106444833,0.799212024167,7.02083516833,-4.15157752333,1.61886203167,-2.89152355667,9.29086921,0.599947802667,1.63748972167,10.7047564333,-0.0637795501833,-0.658433848167,-1.66913792167,0.606665634167,0.0980936015667,0.25056412,1.64947065833,0.438709409167,1.82344971667,0.626183557,-1.000267251,1.00268842383,-0.7867774035,3.41249990833,0.263338949,0.783355839667,4.44266265667,-0.990738513,0.623958087667,-0.448293201333,0.280353361,-0.2081972435,-0.183339026833,-0.346910847167,-0.215467547,0.4343658605,0.0184833308667,0.675443359833,-0.307584287333,-0.0758740021167,0.461616958167,-0.242766337333,1.02382963883,0.0432745882167,0.438414497,1.25492134,-0.481767684833,0.344174415667,-0.279935568667,0.166038409333,-0.180082104167,-0.0429637376167],[-38588.9340667,-3410.02767667,4208.79048333,-3463.275245,2682.23767167,-788.057701167,-2831.900445,-1495.30138,-285.447864833,1048.17527333,1007.8994425,389.566412667,-636.086093333,267.961282167,-587.045535,614.600833667,-180.636306667,275.7266585,-296.1220575,135.133779167,-239.459116167,-179.202164,-205.571234333,359.0392015,178.492226667,-149.889938333,-3.83652589,-129.713313667,-21.4122352833,20.9700158,-305.441480333,38.6461797833,159.359805667,242.935831833,-128.213916333,18.0507795833,-19.6949044333,4.53961295167,-26.99260015,-24.6793244,2.65607827,-90.54206915,63.3575470667,37.14474165,87.6087757167,-44.6042886667,2.72208448667,9.18861968167,-3.93349514333,2.44057516333,12.9566106667,1.82468902333,1.72139582667,-0.2830839765,-13.5391856333,28.1871290333,-8.00077956833,8.29832046667,-17.5347654667,11.26032985,-1.927331965,0.56705955,20.6850176167,-4.48018939667,2.38752950667,4.33669654333,2.84356031667,3.56851304667,1.19014388517,0.882045865,7.176774015,-4.10553658667,1.96307074667,-2.94014739833,9.716107505,0.919279139333,1.74900052333,11.0015332833,-0.112782044833,-0.733842491667,-1.62362875167,0.548978634833,0.0836901070333,0.191140962167,1.609380065,0.487770929333,1.823430585,0.6739229055,-0.919439592667,1.111021615,-0.783148722167,3.54616524333,0.401206074167,0.767238340667,4.56463453833,-1.02831206767,0.631132328,-0.517084965,0.2942858505,-0.195691069167,-0.189243517333,-0.358301824667,-0.227303872333,0.429615831333,0.01507935345,0.669380135333,-0.289817705833,-0.0494380570667,0.4813339075,-0.220584996,1.059618095,0.108796714217,0.4471478915,1.30037318167,-0.485915044333,0.368201700167,-0.304336799333,0.167879036167,-0.172355140333,-0.0385857537667],[-38539.9671667,-2929.52101667,3923.17266667,-3401.95283333,2739.04747667,-654.117051167,-3080.565215,-1489.312,-204.083569333,1043.36515167,1017.040235,279.377813667,-663.220593333,407.474806333,-554.323518833,638.009954333,-187.284344,242.304887,-330.4372385,112.8228146,-240.250836,-163.82851,-217.370647833,366.9504875,179.429348,-148.960865667,-12.5658404417,-124.074497667,-20.60946455,24.8404154833,-297.98688,43.0036506833,147.338558,240.426854333,-125.447371833,15.9590556,-17.9998918833,5.479836905,-23.07700035,-23.10429135,3.98293158333,-87.9099325667,64.59434015,33.1613140167,88.6120442167,-41.8088408667,4.14320535833,9.61088112167,-4.59617576,2.86148332667,13.66868745,2.24606446833,1.93280624667,0.592396187333,-12.9675171333,28.8483005,-8.93043882167,9.321096205,-17.6447618,11.96159835,-1.819308125,0.902687947167,21.0084984,-4.473345965,2.31796279833,4.44590900833,2.726028465,3.51332001833,1.52611880833,0.9368949985,7.30629582833,-4.06651235333,2.34942482833,-2.96941612167,10.0969452883,1.26082124617,1.83815252833,11.2691178167,-0.166344666333,-0.8084846425,-1.573619375,0.492779615833,0.07104754765,0.13367146925,1.56848304667,0.536296655167,1.81774137167,0.718205892,-0.835481113167,1.22725071833,-0.780640534833,3.66568774333,0.5452034135,0.7374445675,4.67689159333,-1.06394166667,0.640262918167,-0.588300391333,0.3090164285,-0.183691266,-0.195603325,-0.368764061667,-0.2378216385,0.4247603185,0.0118149272917,0.662850407333,-0.271241575833,-0.0223535421233,0.50146834,-0.199824928833,1.09382190333,0.175075692167,0.4520405025,1.34335923,-0.4881686815,0.392707315333,-0.330051094833,0.169221331667,-0.1650826085,-0.0342612553],[-38527.4658667,-2527.26304167,3620.44801833,-3338.24027167,2763.42114333,-524.803941333,-3289.712175,-1484.34850667,-117.559062217,1034.39296,1021.11837167,185.082146667,-691.1393345,535.918921,-533.806099333,662.021033,-194.307928667,208.705822167,-362.833285833,89.8538107333,-243.930723667,-149.970064667,-228.305039333,376.804870833,180.073500167,-148.0381765,-20.9380552,-118.6288545,-20.2756493,28.2347533833,-290.198119667,47.2395832833,135.038496833,237.6148785,-122.011152833,13.7866064833,-16.2053537333,6.39406668333,-19.2813108833,-21.6657986333,5.34573659167,-85.1471779167,65.6365602,28.9401922167,89.6785602667,-38.7161232167,5.470791035,10.1857561317,-5.25213383,3.32902539333,14.33007155,2.63623390167,2.11620853833,1.50186422017,-12.4293018333,29.4039475167,-9.95813979,10.437687785,-17.6708546333,12.5372303167,-1.63635771833,1.21953448283,21.2202045167,-4.45538330167,2.26178183167,4.54555112667,2.60772264333,3.45219314333,1.86394688333,0.966021442,7.40600418833,-4.040293925,2.77317222,-2.98136280667,10.4265769167,1.61859357667,1.90883259833,11.49149785,-0.2321845565,-0.878571595167,-1.51914279,0.439517691333,0.05943805545,0.0782959581167,1.52719384667,0.583400066,1.80654142167,0.758381722667,-0.747667516333,1.34934438667,-0.778546382,3.76983875833,0.6906053775,0.695017989333,4.77586094167,-1.10025891833,0.651506108,-0.6586250725,0.323059329,-0.171492553667,-0.2019189055,-0.378241597333,-0.2475254875,0.4195785235,0.00862595925,0.655836938,-0.252022892667,0.00612441707333,0.521488213667,-0.180571458333,1.12635978667,0.24045804,0.452946651667,1.383490455,-0.489024983833,0.416957261667,-0.355590871333,0.169291418,-0.158770880333,-0.0301327683],[-38552.16365,-2212.49156,3336.978165,-3282.56339667,2754.327605,-398.038142167,-3441.73014833,-1479.213025,-29.3388662,1022.46056,1018.541025,111.234202933,-716.995524833,645.877160333,-525.526425667,686.191201333,-201.327703,174.846216667,-393.297327333,66.8660862833,-252.532447167,-138.080895,-238.011820667,389.316089167,180.517648667,-147.256437333,-28.8333494667,-113.748787667,-20.4891259167,30.7127173667,-282.146675,51.2888913833,122.6794185,234.270095167,-118.380856833,11.575666985,-14.42593585,7.28250444667,-15.6940506833,-20.4248951833,6.72085042,-82.2438955,66.43353035,24.4768874333,90.70698065,-35.5597304167,6.698174355,10.9418478667,-5.90412175333,3.81325802167,14.9256241,2.996351975,2.259340175,2.457449045,-11.9197041833,29.83470485,-11.1043117517,11.6243333333,-17.6679698833,12.9754528833,-1.37549827167,1.52497284667,21.2825511667,-4.42990435667,2.21816234667,4.632098595,2.49258559667,3.384942065,2.20650452333,0.969433590667,7.47275301,-4.03318726667,3.22758815667,-2.98527558833,10.6997998667,1.98209280167,1.96723230667,11.6529995667,-0.315539812,-0.941212195,-1.46005830667,0.391165601833,0.0490840771333,0.0253899483667,1.48598746833,0.629538946667,1.78927852667,0.7943929935,-0.6555182985,1.47488367,-0.7775719245,3.85772738833,0.832046166167,0.642499063,4.85726290833,-1.13847593167,0.664735674167,-0.725212542333,0.335356075333,-0.158569029,-0.207531232833,-0.3864275345,-0.256736768667,0.4140557325,0.00563101713667,0.648163831167,-0.232068528167,0.03664222426,0.540852198833,-0.1628766895,1.15719026667,0.303271478667,0.450327588,1.41997796167,-0.488504204667,0.4402607595,-0.379632876833,0.167578873167,-0.153744515167,-0.0262728120833],[-38618.2175667,-1934.15538833,3125.56501,-3242.12174667,2722.32134167,-264.0318625,-3542.88212167,-1465.183205,57.49670595,1007.46803633,1008.575214,56.8786666,-735.954542,732.905440167,-527.549744667,709.606184333,-209.042136833,140.305112167,-421.980250833,44.93934825,-267.747399167,-127.911167167,-247.560437667,403.901002,180.664860333,-146.9196605,-36.2920144167,-109.5962115,-21.2664241833,31.6241077833,-273.8224375,54.6412088333,110.0511214,230.303950333,-114.734999333,9.36260556333,-12.7519855167,8.11733666833,-12.3682068933,-19.4648718333,7.99298858667,-79.2201445833,66.8665225167,19.71259715,91.62074555,-32.5030259167,7.82762193,11.7731318,-6.537601695,4.29773437333,15.4399032,3.31817346167,2.33147456167,3.461919855,-11.4466029333,30.1203510167,-12.37974625,12.8546668,-17.6986174667,13.2717440667,-1.082120528,1.818278075,21.1846300667,-4.39452207,2.18711590167,4.70337979667,2.38031830167,3.30646545167,2.56110977167,0.945869471833,7.5052835,-4.04787889167,3.703313,-3.00048038,10.91329785,2.33252605333,2.01734869167,11.7463527167,-0.414115223333,-0.998980363667,-1.39592467,0.349232257667,0.04081113005,-0.0245586754,1.44531423833,0.677114261667,1.76548595333,0.826647497167,-0.558971433833,1.60094021,-0.780960837,3.92860831333,0.964338410833,0.5830399605,4.91721936833,-1.17636274167,0.677911943333,-0.787482191833,0.345849965833,-0.1447996395,-0.2117398135,-0.392819885333,-0.265358504167,0.408573862333,0.003161656855,0.639575626833,-0.211142747167,0.0694169172,0.559061002167,-0.1467554135,1.18620137833,0.362193218333,0.445257741833,1.451444695,-0.4858208105,0.461748806,-0.401764681667,0.164024069333,-0.149627686667,-0.0226313212167],[-38701.6117333,-1630.94735,3027.08059333,-3216.71387667,2683.18549167,-111.39380535,-3599.251805,-1433.60493667,140.228656167,990.539185,991.8906295,21.252959335,-743.642709167,794.967937333,-537.872483667,730.996276667,-217.9541685,104.906378383,-448.6940035,25.1351975883,-290.210164667,-119.043216,-258.0337995,419.979511333,180.295601667,-147.310523167,-43.37556845,-106.206152333,-22.5505227667,30.6083310667,-265.123736,56.8539199167,97.0761148667,225.690003833,-111.097942,7.172445525,-11.2802413,8.86273622333,-9.34117901833,-18.8368719667,9.08679702667,-76.066859,66.8577872,14.6555133983,92.3561403667,-29.6346686667,8.85219892833,12.5715316333,-7.13253361,4.76176963667,15.8591641667,3.58898941333,2.30789189167,4.51250047167,-11.01120305,30.2528805333,-13.7735241,14.09968115,-17.8004081833,13.42007,-0.798607436833,2.095319195,20.9234466667,-4.34468054667,2.16762863667,4.757694605,2.26768397833,3.211428955,2.93085993667,0.894556183333,7.50385423167,-4.08379434833,4.189677115,-3.04037776833,11.0627855833,2.65493350167,2.06048287667,11.7680298667,-0.525308357333,-1.05554982233,-1.32623992167,0.315169581,0.0352951777333,-0.0716856184833,1.405135095,0.7274467795,1.73435113,0.855141896167,-0.458515933333,1.724662225,-0.790851127333,3.98133362167,1.084180698,0.518839046667,4.953199315,-1.21208466333,0.688711022167,-0.845355809,0.354743851833,-0.130200722167,-0.213776115167,-0.397004461,-0.2732247535,0.403418786167,0.00140956944775,0.629696211333,-0.189270482833,0.104290519467,0.575730882333,-0.132143106667,1.21309344333,0.416447841333,0.438465776167,1.476847475,-0.4805398925,0.480599557667,-0.421837136167,0.158657424333,-0.1459333615,-0.0192052506833],[-38776.4126333,-1307.76866033,3021.92093667,-3199.39950167,2640.79105167,55.4121931,-3607.11124167,-1385.66280333,219.249255833,973.4210845,968.975639833,4.64866431667,-740.825793167,833.72719,-558.36445,750.223574833,-227.465417667,69.4122911333,-473.174945333,7.39780669167,-318.776111167,-112.285955333,-269.459183833,437.562074833,179.364662833,-148.3311435,-49.83381175,-103.600809167,-24.2831457333,27.9673082,-256.176853,58.0624279333,83.9936111333,220.570325833,-107.387700833,4.98600322333,-10.0429108633,9.572527365,-6.63749151333,-18.4900470667,10.0570652367,-72.7737572333,66.5290667833,9.35426728667,92.95018355,-26.9421800667,9.74824664,13.3203538833,-7.69795784833,5.18611591167,16.18830925,3.80741796167,2.21212541833,5.60230864167,-10.5970280333,30.27308825,-15.2733147,15.3560343167,-17.9604748667,13.4199983,-0.527151928833,2.35701695833,20.5042279333,-4.283440115,2.15562177833,4.79121358833,2.15377881167,3.10601749333,3.30945034333,0.821281175667,7.47535646667,-4.13943417333,4.68351944333,-3.10231799,11.1484624,2.95044856167,2.09666893,11.7202896333,-0.651115883167,-1.11314324167,-1.25156186667,0.288566405,0.0305820935167,-0.116904353783,1.36588505,0.778832470333,1.697041785,0.878827297,-0.3542712165,1.84573582167,-0.806341019667,4.01709861667,1.19296538167,0.451193730833,4.96670833667,-1.24701195167,0.696227367667,-0.898493551,0.362608448167,-0.114564517833,-0.213603442,-0.399345382167,-0.280578652833,0.398306989333,-6.97064733333e-06,0.618808305333,-0.167451117333,0.141333641833,0.590928856667,-0.118974540167,1.23822147333,0.466349665667,0.430180243833,1.49669784167,-0.47327901,0.4967087575,-0.4397747495,0.151840977333,-0.142439028,-0.0162195869833],[-38826.63395,-991.369381333,3075.05125,-3183.05988833,2593.43037,226.94241115,-3561.48490333,-1324.72521167,295.958865667,957.3542685,939.9225285,7.040240125,-729.4865905,851.464663333,-591.8165235,767.577214,-236.734635667,34.803592515,-495.26608,-8.62797730833,-352.0321775,-108.775983,-281.625317667,456.752952667,177.897613,-149.748100833,-55.3165840833,-101.816348,-26.4151843333,24.0925075,-247.165436333,58.50961425,71.0819318167,215.096853,-103.495732183,2.77081622033,-9.04087213167,10.327913805,-4.276484025,-18.3486954167,10.9759161,-69.3306102667,66.0319739833,3.85068267667,93.4509785667,-24.3908622333,10.4842090783,14.0229566667,-8.25292955333,5.554198715,16.4355757667,3.977214245,2.07989396167,6.72319422833,-10.1830427517,30.2271828333,-16.8690507333,16.6237117833,-18.1540773167,13.2692346,-0.261045367115,2.60522764833,19.9318650167,-4.216195865,2.14582970333,4.79872087167,2.03902990667,2.99931551333,3.68899856667,0.733650603833,7.42707525167,-4.21295848,5.18259996167,-3.180202865,11.1696098667,3.22323223333,2.12518735833,11.60496355,-0.7946190145,-1.17362719167,-1.172580095,0.2682067995,0.0239516031167,-0.161160562167,1.32804076,0.829070024333,1.65519232333,0.896408826333,-0.246038018,1.96413034,-0.82588777,4.03697192,1.29283497833,0.3810009515,4.95928624833,-1.28312738333,0.699716442167,-0.946404525,0.370015381667,-0.0975557413,-0.21142887,-0.400354567333,-0.287764055833,0.392752539333,-0.00157706378058,0.607317085833,-0.146827478667,0.180744284333,0.604733817333,-0.10718163715,1.26190250167,0.512342816667,0.420409302667,1.511556155,-0.4648294785,0.510026788333,-0.455471952667,0.1439784695,-0.138971993167,-0.0139530267833],[-38834.7236667,-708.245418833,3147.58113333,-3163.98174,2538.780415,394.989653667,-3461.777195,-1249.30720333,370.786586167,943.100017,905.646680667,27.3575929767,-710.107868333,850.2681845,-639.396529667,783.288134667,-245.079387333,2.13211219333,-514.813944833,-23.0782053617,-388.737620667,-109.238890667,-294.202324833,477.495153833,175.960497333,-151.355710333,-59.5457126667,-100.870107,-28.9031567333,19.2770042167,-238.225509833,58.3895663,58.5835740333,209.322626667,-99.3926185167,0.507264424667,-8.274309785,11.1809840667,-2.28565948433,-18.3505322667,11.8918118667,-65.73025115,65.468616,-1.81455394333,93.8659366167,-21.9693846833,11.0057002,14.68751835,-8.81463046667,5.85305261333,16.6069311167,4.09820996667,1.94152501833,7.86548210833,-9.74850621667,30.1439841667,-18.5476516333,17.8933284,-18.3563125833,12.9575411,0.00576205237333,2.84617226333,19.2123707833,-4.14769959167,2.13453888,4.77671580667,1.92420224833,2.89912930167,4.06250825667,0.639567045333,7.36393478167,-4.30199185167,5.68245216833,-3.26690568167,11.1235226167,3.47529568333,2.14658783667,11.4225664667,-0.957035452667,-1.239962615,-1.08977678833,0.253188641333,0.0133094728817,-0.204672374,1.29194938833,0.8763407655,1.61017750167,0.907015404333,-0.133665495333,2.07915662333,-0.847739197833,4.04157212167,1.38502975667,0.309307844833,4.93115466167,-1.32154915833,0.697887808667,-0.9887212865,0.377123474167,-0.0788788944167,-0.207445539833,-0.400498238167,-0.294915319,0.386313543667,-0.00371294435667,0.595445812667,-0.128278868333,0.222703522333,0.617045943167,-0.0967110357,1.28422571833,0.554667719667,0.409066762167,1.52143503333,-0.455783875333,0.520359286167,-0.468796645167,0.1353519645,-0.135428824,-0.01255872915],[-38781.0358167,-484.360683333,3196.82315167,-3141.77771,2474.045335,552.6473965,-3311.74281,-1153.06224667,443.174188333,930.975718833,867.913106833,63.49849515,-681.656330667,832.034746833,-700.6489565,797.518248333,-251.973072667,-27.473219885,-531.663923833,-35.8612758667,-427.820019667,-113.990047333,-306.7388595,499.566996333,173.657675,-152.977656833,-62.3153432833,-100.760703333,-31.7075249333,13.715808305,-229.446449,57.8485735833,46.70549955,203.203186667,-95.1288401,-1.81122509967,-7.74361352667,12.1540712167,-0.701138535,-18.4467365,12.8293013333,-61.9689881833,64.89203965,-7.60167258833,94.1623174667,-19.6903133667,11.23565985,15.3269598833,-9.39813235667,6.07314401,16.7059223667,4.16622870667,1.82184478333,9.01776611333,-9.27303176333,30.0350185667,-20.2929342,19.1462298833,-18.54217475,12.4669484667,0.278657062885,3.09045251833,18.3529887333,-4.08201075833,2.11960776333,4.72341604667,1.810408935,2.81196000167,4.42380303333,0.547239918833,7.288512785,-4.40363533833,6.17639382,-3.35428546167,11.0055990333,3.70648205667,2.16272220333,11.1723447,-1.137689736,-1.31618576167,-1.003432778,0.242943547667,-0.00280041685667,-0.2469203665,1.25783019833,0.919201812667,1.563118695,0.910192500167,-0.01706932,2.18946395167,-0.869936001167,4.03109734167,1.46988107833,0.237342069667,4.88123665,-1.36252034167,0.6889135645,-1.025190838,0.383679340667,-0.05828373515,-0.2018289195,-0.4001932695,-0.301954489,0.378595059833,-0.00674836954333,0.583238004667,-0.112427080533,0.267370164667,0.627584334833,-0.0875268411333,1.30505586833,0.593355294833,0.3959804105,1.525804325,-0.446536016667,0.527370003167,-0.479587005,0.126124995667,-0.131775870167,-0.0120644398],[-38651.2984667,-337.086892833,3184.78999,-3116.339635,2397.99110667,693.9243555,-3117.58865333,-1029.8041885,512.619846667,921.118255833,828.055603167,112.731517033,-642.980684167,798.262335333,-774.669672667,810.335989,-256.9970645,-53.0920045667,-545.650959667,-46.8489380667,-468.296168833,-123.357866833,-318.7659475,522.478626667,171.0608845,-154.444918333,-63.44267575,-101.439212833,-34.7894581167,7.56795015167,-220.947090833,57.0205547167,35.5513900167,196.655813333,-90.7519980667,-4.189659065,-7.44605194667,13.2725375167,0.45717775,-18.59538995,13.8115626333,-58.05627675,64.3513357667,-13.4883216233,94.2903078167,-17.56980075,11.1101188833,15.9415461167,-10.0155865867,6.20530754167,16.7364237,4.178222335,1.741076055,10.17207373,-8.73832718333,29.9107188667,-22.08665375,20.36288255,-18.6887639667,11.78542935,0.558699798833,3.34723239333,17.3594147833,-4.02227111333,2.09838359833,4.63699538167,1.69779172,2.74311434333,4.76789245833,0.465439501333,7.20342359833,-4.51393645667,6.658129175,-3.43527328667,10.8118668167,3.91456162833,2.175531655,10.8523598833,-1.33476898833,-1.40562282333,-0.913665042667,0.236727841167,-0.0257423935517,-0.287596715667,1.22589662333,0.9563491725,1.51530472333,0.905705611667,0.103970090167,2.293704315,-0.890521965,4.00556705833,1.547202155,0.166692933783,4.80785838833,-1.40561345833,0.671049313167,-1.05552309167,0.3892879955,-0.0355292793667,-0.194707270667,-0.3998108295,-0.308789629167,0.369279688667,-0.0110571968733,0.57067559,-0.09980014105,0.314891784833,0.636027322333,-0.07948698825,1.32410288333,0.628346931333,0.381122753667,1.52392947833,-0.437295009333,0.530734719,-0.487663011167,0.116421614,-0.127943908333,-0.01243594735],[-38454.5082,-258.512865,3102.70387167,-3091.13469333,2314.61071333,817.306057833,-2894.88453167,-878.422507167,578.308705167,913.172672333,785.327797667,170.392275667,-593.7740195,750.236371667,-858.761134,821.557612833,-260.1235375,-74.86775455,-556.478210167,-55.9144229167,-509.1403645,-137.626720833,-329.9448625,545.0683895,168.189793167,-155.642611167,-62.87796315,-102.636720833,-38.0795361167,0.984013348333,-212.966770667,55.9798850167,24.9599292333,189.496087667,-86.3487224667,-6.613712095,-7.37486185167,14.59103385,1.241733374,-18.7654003833,14.8733914,-54.05799705,63.9021155833,-19.4865441833,94.1559387833,-15.6549896833,10.6371630317,16.4842886,-10.6690217667,6.240324055,16.7158916667,4.13485400833,1.70643289833,11.3332659167,-8.13519427,29.7921416667,-23.9038016667,21.5251682333,-18.7910161833,10.9373706667,0.829586321833,3.619515825,16.2419219833,-3.97016516,2.06605834167,4.51836327,1.58141097333,2.69449356,5.094118205,0.405370338333,7.11559052833,-4.62676800667,7.125349135,-3.50820005833,10.5478077833,4.09136426833,2.18745759,10.4631755,-1.54333001333,-1.50950844667,-0.820763516833,0.2331460995,-0.0566927274667,-0.327975176667,1.19662853667,0.986969804833,1.46924262833,0.894740490167,0.229770347833,2.39190810167,-0.907556041167,3.96660340833,1.61584244333,0.100238524383,4.71024273333,-1.44893937,0.6430293095,-1.07959305833,0.393122686,-0.0104948824,-0.1860528385,-0.399893601833,-0.315493217,0.358446961833,-0.0171927476833,0.557759121833,-0.0906427265667,0.3653881655,0.6423734235,-0.0719254885333,1.34113966833,0.659691271833,0.3651704915,1.51532273833,-0.427965462333,0.530357122667,-0.492917412667,0.1062280693,-0.1237665725,-0.0133760924167],[-38204.72355,-280.179276667,2978.27272,-3075.29198,2220.938485,926.019235333,-2665.31273333,-715.255318,637.725942667,906.378805,737.037708,230.192281667,-538.385907667,692.200874167,-949.050719167,830.744787833,-260.919808667,-94.1025932333,-563.710127833,-63.5340386833,-548.236060833,-156.818287,-340.518872333,566.6793275,165.149960667,-156.286563,-60.7907653833,-103.876495,-41.3794585667,-5.71369741833,-205.657613667,54.5463407167,14.9720842583,181.382841333,-82.1865966833,-9.019108795,-7.50379692667,16.1836882333,1.77581741,-18.8593409833,16.02850695,-50.0368032333,63.5238207833,-25.5719203833,93.5823924,-14.0845443333,9.88834171333,16.87715315,-11.3517556,6.164423485,16.6815339333,4.04458222,1.73102448667,12.4884584833,-7.45606243667,29.6896033333,-25.7193290667,22.5978247167,-18.8728747833,9.98086669333,1.06141357383,3.90468409167,15.0225159167,-3.92828887833,2.01429411667,4.37356272667,1.45292925167,2.665252505,5.39784782667,0.377890328667,7.03219274333,-4.74073712167,7.57409301,-3.57747404833,10.2278656483,4.22491547,2.198555875,10.01198183,-1.75981321333,-1.62946621,-0.726177116667,0.229899034667,-0.0965220295167,-0.370822160667,1.169112325,1.0103975225,1.42700726667,0.879428348,0.358771461667,2.48506650667,-0.9192709025,3.91722938667,1.67407365833,0.0402948992167,4.58956356667,-1.49157435167,0.6027650635,-1.096651935,0.393640768333,0.01664021025,-0.175751310667,-0.401318969,-0.322336283333,0.345953135,-0.0252881651833,0.544317076667,-0.08482002255,0.4187055605,0.6470709895,-0.0638248604667,1.35569903833,0.687536429833,0.348646681667,1.49986914167,-0.418912239,0.525752549167,-0.494843956333,0.0951344651167,-0.118997481,-0.0143726291833],[-37929.00745,-418.893215167,2857.323015,-3081.29276333,2117.77938667,1026.0771925,-2447.477195,-561.1537945,687.9614425,899.530976833,679.594943,285.912330167,-482.6471975,629.037793667,-1040.135309,837.418686833,-259.388561,-112.645881367,-567.007265667,-70.41224215,-583.038958667,-180.243482167,-350.781785333,587.1992465,162.066324833,-156.177146167,-57.4555298167,-104.6976605,-44.4641097,-12.1044554833,-198.979577667,52.5087502833,5.80890461833,171.9683965,-78.4728547833,-11.3229032983,-7.79524367,18.12989995,2.18764604167,-18.7691413833,17.2875880333,-46.0497206667,63.1790479833,-31.6887726167,92.3679434167,-12.9611062,8.93747169,17.0342098833,-12.0495989,5.97582313167,16.677387,3.91750089333,1.82372855,13.6140449,-6.706067045,29.6069011333,-27.5037730333,23.5341957167,-18.9450772,8.97635981,1.22453160667,4.18968869667,13.7296935833,-3.89794105333,1.93752304167,4.21008416,1.303772085,2.65196151167,5.670904065,0.389270050833,6.95850342167,-4.85527135667,7.99697731833,-3.64577046,9.865772405,4.30476287333,2.20318157167,9.50926330667,-1.98063017333,-1.76540583833,-0.631787889333,0.224598201167,-0.146020328317,-0.418817943,1.14197547667,1.025784405,1.38990635167,0.861665926167,0.488461055167,2.57378874333,-0.924149907167,3.8596509,1.721005515,-0.01252672735,4.44784876333,-1.53265610833,0.548692708667,-1.10575677667,0.388815154,0.0453792793333,-0.163868639,-0.404992488,-0.329424700667,0.3317391555,-0.0351977599833,0.530211432667,-0.0820914023333,0.474297167333,0.650645039,-0.0543726872,1.366867765,0.712200562167,0.331680159333,1.47755494667,-0.4106698595,0.516483635833,-0.4929430025,0.0824916194,-0.113481521333,-0.0149137348],[-37658.91835,-601.835062167,2771.25583167,-3126.832625,2021.21551333,1119.71679833,-2236.63954667,-419.185041667,724.083803333,890.131273333,609.514072333,338.0998245,-427.649553833,565.286053833,-1121.89439,840.683039167,-257.19249,-132.119259167,-565.595315333,-76.9803776167,-610.952109,-205.278222333,-360.471944,607.047840333,159.047275,-155.575951167,-53.1271708,-104.915455333,-47.3973694,-17.5984699833,-192.551017167,49.8821044833,-2.09540167667,160.965937,-75.07719735,-13.4041567333,-8.22812672667,20.4820478333,2.484893745,-18.5058712833,18.7144076667,-42.1609294667,62.8724362167,-37.68320825,90.3383023167,-12.2003520167,7.79317551667,16.9494302833,-12.72951485,5.70110563833,16.7365142,3.74220303167,1.97662629833,14.6919816667,-5.91962128167,29.5488349833,-29.2055896,24.2907603167,-18.9650439,7.946096235,1.32973347167,4.447192515,12.3852856167,-3.87691950833,1.84076951,4.03487482667,1.12792086,2.65422714667,5.90208364833,0.435944814,6.8976589,-4.96771586,8.38602327833,-3.705829635,9.46418317,4.334396485,2.18841378,8.96322462667,-2.20230106167,-1.91407887167,-0.539830685833,0.216333666333,-0.205035044,-0.472148760167,1.11611333,1.03051326167,1.35829299,0.842767032,0.615104888167,2.65798485,-0.921067971333,3.793790745,1.75843805167,-0.0607840922333,4.28702542667,-1.57179861333,0.480880667,-1.10690615833,0.376670076833,0.0747614668667,-0.1508264525,-0.411436590167,-0.336223591333,0.316244029667,-0.0470828478667,0.515646976833,-0.0822308807,0.5308235285,0.653467087167,-0.0435609991,1.373788865,0.734174308,0.313679939667,1.44863537667,-0.404038368,0.502529504667,-0.487412906167,0.0676514750833,-0.107309422333,-0.0147601946333],[-37411.4861167,-727.8531905,2724.858295,-3221.53625667,1947.25753,1202.744885,-2023.80427667,-282.564760667,742.351594167,876.357733833,524.916412667,390.361890333,-371.981221667,504.136943167,-1184.25842167,839.638618,-256.100472333,-153.112424167,-559.085322833,-83.3236961667,-630.4587685,-228.612484167,-368.953147333,626.115372833,156.035298,-154.873260667,-47.8623874333,-104.476852,-50.33866895,-21.6236533333,-186.006652333,46.9021482667,-8.74434999833,148.169644,-71.8185942833,-15.1877384833,-8.77278081,23.2584141,2.65846923667,-18.1254054667,20.3907411667,-38.4379400667,62.6386144,-43.4159394833,87.3925611667,-11.6388094667,6.45449149167,16.6793785333,-13.3561979333,5.37153668667,16.8663537667,3.50186859667,2.18392987833,15.7164143667,-5.13558668333,29.5196637333,-30.77498275,24.8407208833,-18.89145105,6.89065061,1.40547386167,4.648278845,10.99722386,-3.860432415,1.72910837833,3.8505906,0.921725216167,2.67445749833,6.08277149333,0.512590831833,6.85018125667,-5.07110531667,8.73857783833,-3.7478734,9.02552828333,4.32458321,2.14514221833,8.37655124167,-2.41891542167,-2.070697695,-0.451474346667,0.204354127667,-0.2727857095,-0.530141418833,1.09322889833,1.0209541455,1.333624865,0.823530872667,0.736539913667,2.737541405,-0.909663191333,3.719207105,1.78815262333,-0.107683678,4.10795211,-1.60793571167,0.400881403167,-1.10078344667,0.355896076667,0.10404909055,-0.137211532333,-0.420630062,-0.342223276167,0.299966166333,-0.0615567545167,0.501118254333,-0.0849882326833,0.586802308,0.655583348833,-0.0317470662167,1.37625140667,0.753814654667,0.2944322645,1.41337876833,-0.3991214275,0.484091399,-0.478791472833,0.0500429141333,-0.100655974817,-0.01385051015],[-37192.6415,-780.894854,2709.96729667,-3356.74722667,1894.11556,1273.49189667,-1817.97341833,-153.465304183,744.558529167,857.213051,426.7399805,439.701200667,-316.718220333,448.952072333,-1223.41145167,834.033495667,-256.351200333,-175.167336167,-548.709129167,-89.5769022667,-640.9377005,-249.294470333,-375.526940667,642.393428333,152.7973345,-153.978259333,-41.5075359167,-103.408095833,-53.2235162833,-24.0439985667,-179.594944,43.9044116167,-15.046090975,133.485756333,-68.6037010167,-16.7008499833,-9.33110093833,26.4712793333,2.79024423833,-17.5784896,22.2841362333,-35.0196013667,62.5562943167,-48.9952688167,83.5443469667,-11.2028604667,5.02284427333,16.29772875,-13.9173614667,5.00416033333,17.0556616667,3.21500095333,2.46654896,16.6761951167,-4.37664029333,29.5354376333,-32.21463565,25.2141145167,-18.73782265,5.86123378333,1.47821288667,4.78379689833,9.57019454167,-3.845093755,1.59665333333,3.65408229167,0.6871937035,2.71718255333,6.21094585833,0.62657996,6.81767184833,-5.16280495667,9.07123053667,-3.77856569667,8.57256886,4.28292182,2.07632872833,7.75301854167,-2.62457046,-2.23102191833,-0.366505527167,0.1850476705,-0.349113299333,-0.593090333333,1.07394620167,0.9955443755,1.32173852,0.804365111833,0.852840384333,2.81609086333,-0.892516216,3.64149835333,1.81026427333,-0.152042311,3.91300548,-1.63931126333,0.311050785333,-1.08872338167,0.326539319333,0.1332079855,-0.1238402455,-0.4323904125,-0.347787913333,0.282848147333,-0.0791903432167,0.487818230167,-0.0903628128667,0.642071881,0.657158043,-0.0191631532617,1.37569223167,0.771165015167,0.2753225415,1.37277616333,-0.3953282115,0.462052218333,-0.467793551167,0.0296840011433,-0.0933931151833,-0.0119204855917],[-37006.1000667,-751.913309,2704.37408333,-3516.36219333,1856.387575,1330.076495,-1640.084985,-40.0677360167,734.813935333,831.173268,316.8146665,480.071425,-264.2176905,403.004223167,-1236.19063,823.843427333,-257.872316,-197.521868667,-535.910592667,-95.8433244667,-642.051832333,-266.923142333,-379.566490333,653.394534667,149.028222667,-152.604847667,-33.8736132833,-101.650800717,-55.87626545,-24.8949755167,-173.7613775,41.1922963167,-22.0920436833,116.9577961,-65.35540165,-18.0078646333,-9.76289946,30.1215592,2.99570776333,-16.7766655,24.3225852667,-32.07848985,62.6974001167,-54.5777810167,78.8633689167,-10.8468356333,3.58692291667,15.8351642667,-14.4091001167,4.61365295667,17.2865762,2.906890745,2.85210518333,17.56023615,-3.65999106833,29.6109498333,-33.53468215,25.4563486833,-18.53098655,4.90845228,1.55952439833,4.84484827667,8.12428852,-3.828059435,1.43306017,3.440870055,0.427117637,2.78699653333,6.28760985333,0.790376120333,6.80164185167,-5.24090366667,9.40298435667,-3.80901877167,8.12963812333,4.21400152167,1.985905805,7.10168679333,-2.80944774167,-2.39261597,-0.284314320833,0.153464334,-0.433795361167,-0.661322030333,1.05846213667,0.9536696245,1.32973765667,0.785668204,0.964291521333,2.89731675,-0.8728196135,3.56731369167,1.82473259167,-0.191763524167,3.70518435167,-1.662493555,0.213120713167,-1.07278813,0.288639991,0.162417447833,-0.1116064515,-0.446427165667,-0.353399487167,0.264626591167,-0.10050959105,0.4769802455,-0.0983710642167,0.696695398167,0.658258953333,-0.00592480338333,1.373829185,0.786278216667,0.258080448,1.32765167,-0.391727104667,0.437277910167,-0.455394635833,0.00664330142333,-0.0852757915333,-0.00862865924],[-36843.0371167,-683.637118667,2688.09083833,-3683.75233333,1819.44586,1369.86143167,-1496.075275,54.5206206833,717.342794167,798.2084185,196.662382617,507.477223333,-216.0876005,366.190060167,-1225.62263167,809.366576,-259.676717167,-219.421293,-522.774455,-102.568939183,-634.330810833,-282.475508167,-380.976324333,658.272767,144.557081667,-150.395229167,-24.7860761333,-99.4253866167,-58.24478255,-24.2808511833,-168.845434333,38.9595375667,-30.5247547,98.98666165,-62.23039555,-19.1684227333,-9.97582600667,34.18815035,3.39037602,-15.6119220667,26.46148565,-29.67349245,63.1452131333,-60.3085864333,73.51918785,-10.6137302667,2.15640160067,15.32098325,-14.8420752,4.20444949167,17.5330115167,2.62644940667,3.38914571333,18.36564345,-2.98827089667,29.7675917167,-34.7671457,25.6159690667,-18.3081812333,4.05176359,1.66295206667,4.83900004667,6.67773382667,-3.81164786,1.23091083617,3.20638805167,0.149284592833,2.89273118167,6.31421913167,1.011022076,6.80232902,-5.30746637833,9.74617764333,-3.84728189167,7.71473103333,4.12236834333,1.88440649167,6.43135020833,-2.969698935,-2.553422235,-0.2045206345,0.106153912467,-0.5256262575,-0.735782763833,1.04611375167,0.8948259135,1.36260434667,0.766486322167,1.07224892433,2.98296766,-0.852039900667,3.50311637167,1.83109862167,-0.223641884667,3.48759263667,-1.67592067333,0.108177174572,-1.05292861667,0.243737887667,0.192221978333,-0.101363071267,-0.4621113175,-0.359943582667,0.244372697167,-0.125857913217,0.469847811,-0.109305955333,0.751216656667,0.658912231333,0.00810161064167,1.37247743667,0.798964355667,0.244175499333,1.27885116833,-0.387448267,0.410312559167,-0.441784073,-0.01843418734,-0.0761696548,-0.004344506845],[-36685.7166667,-644.837574667,2661.47761333,-3836.0854,1764.63862667,1391.16711167,-1382.49463,128.889777383,697.485261333,759.059058333,66.64444635,518.7235505,-173.437381,336.825154333,-1198.37038833,790.850392167,-260.256715,-240.2878905,-511.914039,-110.157963667,-618.662513833,-297.540265333,-380.346943667,656.700512333,139.170712,-146.892685,-14.0051336883,-97.1111348833,-60.2754699667,-22.3359036333,-165.034467333,37.2335209167,-40.8392123833,80.0841985833,-59.3266799667,-20.2428028667,-9.88034700667,38.6679956167,4.10880963833,-13.9682435167,28.6627340333,-27.7832992167,63.9783828333,-66.3258488833,67.6950348667,-10.5420552333,0.748867999,14.7704370333,-15.2264834333,3.77758501333,17.7633088,2.44232309167,4.12982386,19.0896679667,-2.35728149167,30.0297779333,-35.9466139833,25.7313358,-18.10803095,3.30654601333,1.80065570833,4.771972545,5.23660072,-3.79915133833,0.983044285833,2.94289466167,-0.135182876667,3.043395475,6.29169133833,1.291351715,6.81846899833,-5.36405387667,10.107047135,-3.901496,7.34103260167,4.01304656667,1.78180432333,5.74677618333,-3.10593677833,-2.70939580167,-0.1272228604,0.0399466693167,-0.623484932167,-0.817900624667,1.03576937667,0.818738863333,1.423929645,0.744819767167,1.17867781,3.07336276667,-0.831047437833,3.45350223333,1.82904710167,-0.244626209167,3.26277033667,-1.67950694833,-0.00244778554667,-1.02775198583,0.1943581035,0.223125133,-0.09397836505,-0.478502667667,-0.368529321667,0.2209467865,-0.155333840667,0.467666818333,-0.123559782333,0.806253753333,0.659075464667,0.02328024008,1.37298679667,0.8089123965,0.2348394725,1.227213255,-0.381805182,0.381493199167,-0.4267203055,-0.04457191345,-0.0658345698833,0.000144291365],[-36502.0758833,-682.413640167,2620.43718333,-3948.86961833,1680.98308667,1395.01317667,-1291.048175,185.1564225,680.167751667,715.386677667,-71.4554086833,512.560229833,-136.3275675,313.171719167,-1159.96858,768.233734167,-258.3956795,-259.347302667,-505.437059167,-118.857657333,-596.031566667,-313.2705065,-378.244147,648.296984833,132.5513775,-141.830244,-1.35891597,-95.0967085333,-61.9584348667,-19.2153461167,-162.423340167,36.0025787,-53.4512958,60.7331823167,-56.7294898667,-21.3070937833,-9.43975758333,43.5244856833,5.23098249667,-11.7749673383,30.8992562333,-26.3815957,65.2473878333,-72.7291345333,61.5700770833,-10.65336655,-0.640135169,14.2088819667,-15.5670263833,3.32966647333,17.9404681167,2.40579184167,5.10770140333,19.7361992667,-1.76867401,30.4150807167,-37.0959498667,25.8385152,-17.9566918333,2.67697319667,1.98784026,4.646725735,3.808165525,-3.7898503,0.685266125667,2.64256386667,-0.416754277833,3.24386767833,6.22285533833,1.62971231833,6.84931509667,-5.41082492333,10.4900822667,-3.97648794667,7.01720531667,3.89218193833,1.68472746833,5.052215345,-3.21773369,-2.85670788833,-0.0516616710833,-0.0467564192333,-0.72601158,-0.9084219815,1.02617706833,0.725439510167,1.51543007833,0.719364743,1.28504815833,3.168142585,-0.810440103833,3.421671885,1.81868972667,-0.2530376765,3.03265275333,-1.67290905667,-0.117457839095,-0.995979056,0.14267660295,0.2555579825,-0.0899397346,-0.494510771333,-0.379916538833,0.193531931667,-0.189061814833,0.471315119,-0.1413248705,0.8621231205,0.658543412167,0.0397998732833,1.37634209833,0.815853220333,0.230809782167,1.17333987667,-0.374190005833,0.351068496667,-0.4099948085,-0.0709007747667,-0.0541488637667,0.00406816957667],[-36286.0927667,-761.717511333,2569.41494333,-4019.36402,1577.32011167,1388.545685,-1202.18748,236.530344333,665.4300485,668.274038667,-214.379109783,493.598077167,-102.312655133,295.631038,-1111.96552667,741.325710667,-254.970731333,-276.334521667,-503.789778,-128.766851,-567.3326505,-329.582443833,-374.685586833,633.406033167,124.540061833,-135.729989,12.9210264283,-93.82640415,-63.5349192833,-15.1277272833,-160.985409,35.33424795,-68.2835419833,41.3144746833,-54.46943905,-22.3981588,-8.76221049833,48.6567146333,6.62567994333,-9.13384653167,33.1481599333,-25.4707049167,66.9615685167,-79.49181555,55.33615865,-10.9042278167,-2.06390598033,13.6888807667,-15.85381445,2.86435496,18.0453081,2.50034452833,6.29611655833,20.3182163833,-1.24492020417,30.9274239667,-38.2250753167,25.9808583167,-17.8433389,2.14615645667,2.24143780833,4.46950491333,2.41390203833,-3.77659371167,0.348516836367,2.30532715,-0.691826183,3.48820277667,6.11500193833,2.01177374333,6.89572823667,-5.45167225167,10.9007205667,-4.06898770167,6.74612174,3.76800327167,1.5951632,4.356786265,-3.302255955,-2.99298831333,0.0237496725,-0.150031993717,-0.831519379667,-1.00562561033,1.01672371833,0.616206868833,1.633451955,0.690315454167,1.390304315,3.26688380333,-0.791374481333,3.40965310667,1.80160674333,-0.249401573333,2.80002738167,-1.65534040833,-0.234817656167,-0.957359410667,0.0895299202167,0.2894649035,-0.0887600389833,-0.509356744,-0.393719217667,0.162533034167,-0.227060782167,0.480581100833,-0.1624700785,0.918436424,0.6570051335,0.0569034491,1.38339884833,0.819968796333,0.232098127833,1.11797611833,-0.3641762725,0.319678201667,-0.391599406833,-0.0969966906667,-0.0413798236,0.006962675285],[-36059.43575,-827.9503975,2506.144405,-4061.74628667,1467.87236,1375.12968833,-1104.69466217,290.209917333,650.644723,618.909285833,-360.156426167,466.884104667,-69.4375635333,284.291165833,-1055.30377383,710.354464667,-251.1774805,-291.5751235,-506.237916,-139.565513333,-533.4501225,-346.213251667,-369.533171833,613.369750667,115.225992,-129.234459167,28.4163913833,-93.4404006167,-65.1545873667,-10.23460702,-160.645252667,35.3109001667,-84.9636746833,22.2036105517,-52.49994015,-23.5244718333,-7.98874029667,53.9636297,8.15178091167,-6.184963465,35.3930981333,-25.03060345,69.11080795,-86.5743233167,49.1682149667,-11.2330442833,-3.53941102833,13.2229333333,-16.0822255,2.37967247667,18.0800896333,2.68535140167,7.64426494667,20.8431213667,-0.8011554005,31.5600611,-39.3565156833,26.19088595,-17.7554710833,1.7036535,2.56173899167,4.25030012333,1.0694623145,-3.753586085,-0.0152664912,1.93748736667,-0.962898417167,3.76594991,5.97399682667,2.42228918,6.95588904833,-5.49427417,11.34216935,-4.177278095,6.52820971,3.64555713333,1.51541166667,3.668688435,-3.36019945167,-3.11737592333,0.100659466017,-0.264786828833,-0.938441915333,-1.10817866,1.00720513667,0.492901561833,1.77260741667,0.657546803667,1.49287545333,3.36967360833,-0.775814407333,3.41810490667,1.77935804833,-0.234303410167,2.56795064833,-1.62727323167,-0.352569491,-0.912612895667,0.03556533575,0.324779159667,-0.0895419378,-0.522791616167,-0.409364234167,0.12878655735,-0.269015314667,0.494635528167,-0.1867619075,0.974731106333,0.6545345405,0.0735328973833,1.394807795,0.821553231667,0.238565091333,1.061951625,-0.351567140167,0.2880894405,-0.3717653825,-0.12261093455,-0.0277964755167,0.00875260699167],[-35840.4881667,-855.171713333,2430.928515,-4088.17836333,1360.89802667,1358.59928333,-997.449664167,348.058211,634.265439167,568.612289833,-506.9916215,434.689333667,-37.0027908183,278.352785167,-991.517501333,675.93964,-247.590562333,-305.55683,-512.2380205,-150.967676333,-495.529102667,-363.159903667,-362.840545833,589.737654333,104.7799089,-122.731418667,44.6534917833,-93.9606270167,-66.9048971333,-4.77564354383,-161.380157,35.897519,-103.0577632,3.70944112333,-50.7843889833,-24.6965478,-7.20800036667,59.3409198667,9.72540924833,-3.05075705983,37.5962560333,-25.0436273167,71.6395414333,-93.9373931833,43.1920698,-11.5939996667,-5.07352517,12.8009742667,-16.2559339833,1.87557326833,18.0518334667,2.93559065,9.10245086667,21.3140136833,-0.449342797,32.2936100667,-40.5166954833,26.4812449333,-17.6867591333,1.33924021,2.93897228,3.99826334167,-0.211535510333,-3.718214975,-0.396888980633,1.54722924667,-1.22982922117,4.066179205,5.80652173333,2.84711385,7.02617657833,-5.54812106333,11.81246035,-4.30158519167,6.36120452167,3.52635684333,1.44706363667,2.99530956,-3.39368155833,-3.22916093333,0.180037785167,-0.387053436333,-1.04503867083,-1.21460993667,0.997253878333,0.358535848833,1.92752136667,0.621251343,1.59064546667,3.47599174,-0.766002816167,3.44622533333,1.75255433333,-0.208653676833,2.339101665,-1.58983287333,-0.468974252333,-0.862538057333,-0.0186741877,0.3613932425,-0.09163309555,-0.5346652635,-0.426403023667,0.0931021149167,-0.314148296667,0.512584297167,-0.213646929833,1.03044763867,0.651337968333,0.08861549045,1.41073514,0.820653085833,0.249844399667,1.00586135417,-0.336396397833,0.256927379,-0.350737642,-0.1475940855,-0.0136333063303,0.00945371694833],[-35637.2071,-817.232470833,2351.19069833,-4108.29336667,1266.160755,1345.432215,-879.878477667,413.849517833,614.886701,519.274693833,-652.473777,399.165407667,-3.32300535667,276.822609333,-921.577452,638.589861,-244.644741167,-318.704559,-521.189082667,-162.376477,-454.752077833,-380.116327667,-354.691039833,564.127386667,93.34545905,-116.588894167,61.1294681167,-95.3919771167,-68.8158478,0.978679589667,-163.055485,37.0175738833,-122.049433,-13.8824870817,-49.2556135667,-25.9207413333,-6.50915405,64.6664824,11.2634505067,0.144991107333,39.7062686167,-25.4682059,74.468245,-101.503463917,37.5139265,-11.9231630167,-6.67765600333,12.41624155,-16.3747426167,1.352528801,17.9632651833,3.22629806167,10.615548095,21.7293612667,-0.199914997817,33.0995332,-41.7195667,26.8549926,-17.6211156667,1.03864683267,3.36666734167,3.720556825,-1.41449988217,-3.66703678667,-0.786309521833,1.1427031615,-1.49173777167,4.37602457333,5.61838831167,3.2707384,7.100850475,-5.62098335667,12.3059008833,-4.43926425667,6.23987647,3.41310774,1.39032034833,2.344278285,-3.40469101,-3.326986935,0.262683367333,-0.512546187,-1.14917155333,-1.32295614333,0.9862101075,0.216263441917,2.09205029833,0.581416872833,1.68106243667,3.58426092,-0.763625458667,3.49187891833,1.72211021167,-0.173953156,2.11610784667,-1.54419744167,-0.58212026,-0.8078566125,-0.0726438733,0.399031633833,-0.0943538530167,-0.544668399167,-0.444210373167,0.0563371644167,-0.361516292333,0.5333543165,-0.242488753333,1.08470979333,0.647430024667,0.1010686487,1.43086879,0.817304622,0.265264709667,0.950238109667,-0.318819631833,0.226815485167,-0.328763013833,-0.171770591667,0.000864455328667,0.00908111569333],[-35456.6736833,-707.532996333,2278.58315,-4127.67374833,1188.811075,1343.709335,-754.968818333,491.903234333,592.787181167,472.518497833,-793.595090833,361.160374333,33.630107865,278.030482333,-846.2068555,599.231144,-242.445361667,-331.245553,-532.715904667,-173.010534167,-412.550834167,-396.629738167,-345.271006333,538.1783065,81.1294785,-110.994079333,77.3831624,-97.7449792333,-70.8377201833,6.67081629617,-165.462037333,38.5205736167,-141.360891167,-30.3200968167,-47.8194237,-27.20614605,-5.92792670833,69.8205256333,12.69962095,3.30397893183,41.6495928167,-26.2356759333,77.4838174167,-109.160408167,32.2159856667,-12.1397033333,-8.37228549,12.0646054833,-16.4448461833,0.820783065333,17.8150849333,3.54282632,12.1338206833,22.0834242,-0.0548290646283,33.9379847833,-42.9649606833,27.3039577,-17.5323209333,0.781380201667,3.841529295,3.420986885,-2.52403158167,-3.59941970833,-1.1732905335,0.731126964667,-1.74403063833,4.68310763333,5.41537274167,3.67961683,7.171582965,-5.71708269833,12.8124679,-4.58401272167,6.15538158833,3.31005925167,1.343258165,1.72356097,-3.39534393,-3.40888512167,0.348560228333,-0.637695818167,-1.24888792167,-1.430289615,0.973210684,0.0697279819,2.260242005,0.537695982167,1.762043575,3.69160394333,-0.769275473833,3.55141959,1.68957641667,-0.132550416867,1.90171920333,-1.49176541167,-0.6898679045,-0.749285689833,-0.12580890115,0.437271505167,-0.0973705376167,-0.552490241167,-0.462029284833,0.01922322785,-0.409908721333,0.555838379167,-0.272602970833,1.13661853833,0.642535574,0.110048386,1.45435516,0.811720452833,0.283778672833,0.8956803445,-0.299189599833,0.198438620667,-0.306144115667,-0.194930982667,0.015420287403,0.00764003628333],[-35314.7024667,-574.7051375,2197.88447667,-4141.96274,1120.615455,1354.43937,-632.386729667,578.048189167,573.364782833,429.271557,-928.103521833,319.327650667,72.6795846167,279.766346,-767.557645167,560.1967595,-240.141269167,-343.133126667,-546.743891667,-182.75333,-370.4848115,-412.897001667,-334.7479375,513.358402833,68.5404082167,-105.624977,93.13475085,-100.970162117,-72.9216799833,11.9315287983,-168.5573335,40.26696005,-160.456766667,-45.35109535,-46.3706181167,-28.58667025,-5.352901875,74.7382052333,14.0288883833,6.38879887333,43.3623706333,-27.29245545,80.58048825,-116.7999475,27.38226125,-12.1552197833,-10.1838023633,11.74219545,-16.4990596667,0.3136639855,17.6159090833,3.89728538167,13.6347682167,22.3758429,-0.00544759881333,34.772512,-44.2482406833,27.8213898167,-17.3876328333,0.544396488333,4.36239877833,3.09951015833,-3.52415637333,-3.52417046167,-1.54948140833,0.318289612367,-1.97437444333,4.98184296833,5.20518922667,4.06685766333,7.231179745,-5.83785347667,13.3224437,-4.726647895,6.09775183833,3.22311447833,1.301889455,1.1416482165,-3.36796313,-3.47240826167,0.435654672833,-0.7616173485,-1.34347298667,-1.53232494167,0.958023989167,-0.07673105715,2.42827305833,0.489892729833,1.83265261167,3.79511865833,-0.782390536667,3.62084247167,1.65744860833,-0.0873661360667,1.69908610833,-1.434171415,-0.789818374667,-0.68752995,-0.177745320833,0.475594571333,-0.10134720875,-0.558190912333,-0.479132523833,-0.01780777555,-0.457871723,0.5793577305,-0.303337730667,1.18566893167,0.636313170833,0.115102567833,1.48018857833,0.804478834333,0.304167305833,0.843039164,-0.2780393495,0.172615142333,-0.2832401555,-0.2168797835,0.0297281351167,0.00509227348833],[-35224.8988,-455.663982,2101.31971,-4147.91920333,1056.06083533,1380.63454833,-518.9014495,670.490263167,561.3629345,390.464957833,-1053.384548,273.3264515,113.46753385,280.232393833,-686.99493,523.6688895,-237.0550345,-354.276457167,-562.9613085,-191.315975,-329.865448,-428.773748,-323.242278167,491.278524667,55.9927049,-100.2154755,108.101443283,-105.013233333,-74.99808535,16.4579437,-172.204145833,42.1306705833,-178.689274167,-58.7365631,-44.7613679167,-30.0806002833,-4.67972748833,79.3528491167,15.2290311833,9.36233832667,44.7892587833,-28.5709074,83.6543523,-124.270137,23.0865671,-11.85810465,-12.14587295,11.4476652167,-16.5650464,-0.133192811833,17.37469885,4.29612529333,15.0960958,22.6036159,-0.0429220127283,35.5667795,-45.55284405,28.3961846667,-17.1437138,0.30017698915,4.93044065,2.75309721167,-4.39881175167,-3.44959343667,-1.905034535,-0.0897215555333,-2.170930015,5.267227495,4.993713515,4.42504399833,7.27264924833,-5.98330494667,13.8247715333,-4.85509280833,6.05477066833,3.15907725167,1.26050599,0.606752058833,-3.324822985,-3.5149131,0.521634697167,-0.883096713,-1.43214705,-1.624471865,0.940684114667,-0.219268347433,2.59219409833,0.437849629667,1.89162568833,3.89169550833,-0.801864771333,3.69539484,1.62847549333,-0.0418477819683,1.5111233,-1.37311914833,-0.879644519667,-0.6232227035,-0.228154088,0.5133201915,-0.106964661333,-0.561836537833,-0.494645440333,-0.0542785732167,-0.504003972333,0.603285468833,-0.334068831833,1.231169755,0.628436979167,0.115810817167,1.50716419,0.796170602667,0.325039389333,0.793074413333,-0.255988907167,0.1500630455,-0.260400589333,-0.237482966,0.04347837025,0.00135733777667],[-35205.79555,-327.221867333,1988.88667,-4149.75646667,1001.2101015,1425.66795,-414.789117167,766.222186167,557.9208375,356.442368333,-1167.39225167,225.4997885,155.420595,279.379824833,-604.568140167,490.7253135,-233.569864667,-364.8023015,-580.3347975,-198.396537833,-291.243026833,-443.807454333,-310.667577,473.280079167,43.7249642167,-94.8797929333,121.958472333,-109.7778235,-77.0101023167,20.13264425,-176.282023667,44.0860623,-195.449862,-70.2496597167,-42.7747754167,-31.6854339167,-3.89382676,83.5951427833,16.2174583833,12.1669311,45.8964189333,-30.0375275,86.6339985167,-131.407010667,19.4033563,-11.1200644633,-14.2763345333,11.1600398667,-16.647272,-0.498172717333,17.1015957667,4.71399887667,16.48661715,22.75755465,-0.168935825383,36.2921876667,-46.8554910667,29.0208096667,-16.7572897833,0.0269042967667,5.53863246,2.37282337333,-5.13177286833,-3.37641662167,-2.22996172333,-0.4862698123,-2.33056351833,5.53287283667,4.781858505,4.74500023167,7.29017609667,-6.15382963833,14.3102289667,-4.95940453333,6.01476157667,3.12236343833,1.21148679,0.126129867667,-3.26616129833,-3.53372815667,0.6053591885,-0.999617081333,-1.51390874,-1.703312235,0.921528690667,-0.355996382167,2.74779337667,0.381174114167,1.93645035833,3.97875209667,-0.827433631667,3.77015406167,1.60474832167,0.000620604476667,1.339887515,-1.30943115,-0.957284885,-0.557196024167,-0.277075862167,0.5497165525,-0.114256196,-0.563406231333,-0.507560976167,-0.0894971991167,-0.547470513833,0.626952077167,-0.364462550167,1.27193329,0.618631862833,0.1115533895,1.53401535333,0.7871181865,0.345204361,0.746138785667,-0.233459148833,0.131262919,-0.2380265855,-0.256770156833,0.0564457056167,-0.00359697980667],[-35277.5641167,-144.799029,1864.12445,-4150.23172833,963.331575167,1492.46731,-325.173556167,855.935057667,563.566974,326.369068667,-1268.08211333,177.774178667,196.894546,277.800383333,-520.3816085,461.860223167,-230.4217105,-374.659675167,-597.483967333,-203.495743,-255.020663667,-457.8124455,-297.037280833,459.834918667,31.8022052167,-89.7762101833,134.453475667,-115.0631135,-78.7568224167,22.8170998667,-180.7802155,46.06398185,-210.368526667,-79.6686731667,-40.1948778167,-33.4123602167,-2.99746432167,87.4035673167,16.9006253,14.7757104167,46.6315799833,-31.6669345667,89.4348661167,-138.061883833,16.40428765,-9.84369483833,-16.5741621,10.7982618167,-16.7412652833,-0.772266368167,16.8024203167,5.109951195,17.77541665,22.8229038833,-0.374322500833,36.9169811167,-48.1199085167,29.6852408333,-16.2024288167,-0.292369810183,6.15323027167,1.94403237167,-5.70773425833,-3.30111791667,-2.51899180167,-0.867033304,-2.45547148667,5.77074936,4.569135945,5.02229737333,7.27727948667,-6.34500850667,14.76790145,-5.034610215,5.96527213667,3.11006281167,1.145799515,-0.295615862,-3.18893638333,-3.528176075,0.686621484833,-1.10919434167,-1.58815368833,-1.76639283,0.900346529333,-0.4856170295,2.89134713833,0.319199857167,1.9651298,4.05301749167,-0.859097325667,3.83925312667,1.58705709833,0.036915076415,1.18554497333,-1.24255833,-1.02201639917,-0.490737564667,-0.324920524333,0.5841657945,-0.1229204975,-0.562796374833,-0.516927566,-0.12288513335,-0.587737248667,0.649405282667,-0.3943291645,1.30661685333,0.606427172333,0.102056191583,1.55909858667,0.7774951895,0.3636565125,0.701834504167,-0.2105850355,0.116106780833,-0.216649319667,-0.274999136333,0.0686080755,-0.00981523233833],[-35435.2805167,113.9426875,1706.55078667,-4152.00264167,948.340890167,1577.77918333,-250.414429667,931.757503167,577.2688005,301.323550833,-1353.30407833,132.979230933,236.166173833,276.2663885,-438.405897833,437.159016833,-227.667758,-383.3098915,-613.063448333,-206.3951535,-221.501638333,-471.742028833,-282.421264,451.284838667,20.254541265,-85.0494743,145.449893333,-120.719947333,-80.11980865,24.407746,-185.789491,48.0307251,-223.154729167,-86.6738145167,-36.9947153667,-35.2726364167,-2.05361507333,90.7135526667,17.18261395,17.1661514167,46.94961485,-33.3969319667,92.0006332167,-144.131232,14.20042235,-8.01782276667,-19.05747995,10.283881415,-16.8433299167,-0.967035754167,16.4750338833,5.44708910667,18.9407050833,22.7830536333,-0.636069805,37.4187131,-49.32206795,30.38515645,-15.4723785833,-0.6803462775,6.73591851333,1.4676923485,-6.11693657167,-3.21973385,-2.76886149833,-1.22958404083,-2.54766023667,5.97488110167,4.35338974167,5.25310317667,7.22894305,-6.55264836,15.18589885,-5.07741813,5.89394665167,3.11539838667,1.060481132,-0.657064896,-3.09273696333,-3.50019028833,0.765831235333,-1.20921739333,-1.65431161,-1.81207657667,0.876624694333,-0.607350294833,3.01841039833,0.2510763165,1.97672929667,4.11076563,-0.896543700333,3.89742639833,1.574600395,0.0651165366167,1.04698020567,-1.17291262333,-1.07434565,-0.424695149667,-0.371388612667,0.616303877833,-0.132398016833,-0.559801073833,-0.5221538905,-0.154109465,-0.624366670833,0.669548759833,-0.423643436333,1.334222025,0.591357433833,0.0871082449167,1.58087281333,0.767076660833,0.379348455333,0.659376226833,-0.187615887833,0.104098659767,-0.196562125167,-0.292177010833,0.0799423460833,-0.0175695878667],[-35650.03375,437.3791155,1502.78562667,-4152.57244333,958.571146167,1674.82838167,-191.491223833,993.166461167,597.0387815,283.645982833,-1421.61469667,91.5804711,274.093968333,275.951327167,-364.931954833,415.886830667,-224.873418667,-389.8476695,-626.535564,-206.228216667,-190.953282,-486.961745833,-267.153968,447.198427667,8.89943390833,-80.8528367667,155.003725833,-126.664952,-80.86315565,24.8009085833,-191.3545635,49.9596308167,-233.799025833,-91.11903135,-33.1518141833,-37.2915740833,-1.186312081,93.4872113333,17.0051067333,19.3206062833,46.8088317333,-35.1275047667,94.3067322333,-149.5813715,12.8503412,-5.64675567333,-21.7166241667,9.583985265,-16.9386602667,-1.11740344133,16.1088161167,5.70047561167,19.95406625,22.6207503,-0.923123080833,37.785266,-50.44528215,31.1062413833,-14.5627930167,-1.15204301,7.26087450667,0.959034858667,-6.36214266833,-3.12297901167,-2.97991894167,-1.576567205,-2.61070965,6.13635317333,4.130910195,5.43370160333,7.14112384833,-6.76992722167,15.55125005,-5.082992995,5.78913558,3.133212065,0.956624467333,-0.9609677375,-2.98081615333,-3.45385649333,0.844584935,-1.29650403833,-1.71265563167,-1.84076959833,0.849241154333,-0.721289260833,3.12421839333,0.175438763667,1.97190378667,4.148407455,-0.938365638167,3.93927429833,1.56660000667,0.08375413815,0.9223936435,-1.10247215833,-1.11534132167,-0.360402859667,-0.41541205,0.6458562855,-0.1416063665,-0.554028416167,-0.523205183,-0.1828047565,-0.657232113,0.68624179,-0.452642859,1.354132935,0.573043300667,0.0667839598167,1.597701645,0.755652686833,0.391035828,0.617944419833,-0.165271577833,0.0946443482167,-0.178164064167,-0.308043998667,0.0905147308833,-0.0269344241],[-35883.7026,781.097399333,1255.41520067,-4151.09820833,993.410173,1780.89794833,-144.034623,1051.42244633,619.981796667,277.525663667,-1471.66371333,55.0085512,315.395827167,275.103005667,-305.163783167,397.069234333,-221.0006055,-393.5087,-637.647704,-201.753618167,-164.212416667,-504.177772333,-251.538789167,447.9978775,-2.443190275,-77.3686794333,163.186907167,-132.891653333,-80.8502342667,23.8650022333,-197.202702333,51.7549530333,-242.024541,-93.0374316833,-28.7329777333,-39.4767706667,-0.577728976667,95.68362725,16.3397013333,21.1848017167,46.1950973,-36.7000075667,96.3058550667,-154.321878,12.3193958667,-2.73317235733,-24.5793085833,8.74015573,-17.0115786333,-1.27085850833,15.6863847667,5.85550773333,20.7814725833,22.3288375833,-1.21401678533,37.9983479833,-51.4684923,31.8135902667,-13.4546549,-1.74019433167,7.734950495,0.4377531282,-6.45720109167,-3.00245784833,-3.15182041,-1.91075106,-2.65014792167,6.24548628167,3.89791886333,5.55367501,7.00846566333,-6.99195951,15.8481991167,-5.03950574667,5.63355814667,3.16338169167,0.836553577167,-1.21295333417,-2.860865895,-3.39141363167,0.924837898,-1.36688071,-1.76262014167,-1.854234665,0.817055230833,-0.828471505333,3.20288155333,0.0912250283285,1.95081209333,4.16215878667,-0.981733142333,3.95849288667,1.562243485,0.0902533293167,0.810185113667,-1.03501282367,-1.145678665,-0.298229943333,-0.455985444667,0.67280293,-0.1492116865,-0.544956978,-0.5202089175,-0.208511686667,-0.686420883667,0.698381285,-0.481329762,1.36567871333,0.551262868333,0.0409353513833,1.60793593333,0.742902246,0.396856607333,0.577042235333,-0.144720787833,0.0873577035,-0.161621651833,-0.3224048395,0.100136670467,-0.0380404103],[-36105.35955,1093.24284117,959.174440667,-4149.482155,1049.569572,1892.73195333,-101.36345525,1119.01398,642.983239167,286.823374833,-1502.75582167,25.8129929883,365.329878833,271.746879333,-262.283652333,379.8336025,-214.9486755,-393.655296167,-646.111670667,-191.8068585,-141.912091,-523.331707833,-235.915772833,454.309526833,-13.8412276517,-74.74280965,170.147006167,-139.4120825,-79.9899881333,21.4982296167,-202.778561333,53.2259066167,-247.512569667,-92.4879464667,-23.9018513,-41.79356935,-0.393978274333,97.2878513333,15.1748867,22.71069845,45.0886004667,-37.89538075,97.9173972833,-158.240314833,12.53983815,0.683208367333,-27.6765776,7.80787554667,-17.0462450167,-1.46838775167,15.1906076167,5.90181464,21.3941660333,21.89834555,-1.48416645667,38.02822265,-52.3649010667,32.4662811833,-12.1403121167,-2.47469700333,8.17598579,-0.0782794825333,-6.41745594333,-2.85427479333,-3.28310680833,-2.23493051667,-2.67250010667,6.29324542167,3.65010845333,5.60193804667,6.82214490833,-7.21388423667,16.0598534,-4.93696054667,5.41191631,3.207149855,0.703293634667,-1.418744095,-2.74094270167,-3.31539642667,1.00733175633,-1.416431285,-1.80344372333,-1.85436755667,0.778808559667,-0.929943880667,3.24849056333,-0.00281838285267,1.913721045,4.14759155667,-1.02369226033,3.949798055,1.56079752667,0.08188864085,0.709059478667,-0.974438668333,-1.16677361167,-0.237941654667,-0.492374239333,0.697117727167,-0.1540750625,-0.5322054585,-0.513143909,-0.230828553167,-0.711849164667,0.704755254,-0.509441049833,1.36836749,0.525636021333,0.00945521688333,1.61023081,0.7286271855,0.3949037055,0.536340544333,-0.127216378667,0.08172697535,-0.146930456333,-0.335229228333,0.10857037,-0.0510705645167],[-36293.5652333,1327.84030667,620.326508667,-4146.07811167,1120.338125,2011.30755167,-65.4228861,1199.41851833,664.168452333,313.202274333,-1513.38116333,3.86016377,426.839470333,265.577961667,-237.349240333,363.391638667,-205.965642833,-389.5582955,-652.0017285,-175.223349167,-124.255616333,-543.710433,-220.6991965,466.1145865,-25.3795844333,-73.0136164167,176.033578,-146.238875833,-78.0084653333,17.5831024667,-207.414350833,54.1396398667,-250.101020667,-89.5256252667,-18.7839290833,-44.2022759833,-0.73565575,98.2821150333,13.5038440667,23.9085181,43.4257294167,-38.4722074167,99.0378426333,-161.219049333,13.4416581167,4.54831735767,-30.9884998167,6.81563936833,-17.0231709833,-1.739405455,14.6025262,5.82997587,21.7702635833,21.3064052833,-1.69634300667,37.8357400333,-53.0929148333,33.0203989167,-10.62691914,-3.36225863667,8.59491696667,-0.578359292633,-6.25046815,-2.67502476833,-3.37372905667,-2.55270547333,-2.68280336667,6.26973804333,3.38212355667,5.57246013,6.57069865667,-7.42687104833,16.1671363333,-4.770499325,5.11460479167,3.26678724833,0.558104660667,-1.58076695333,-2.62578941833,-3.22886714,1.09188911167,-1.44239154667,-1.83453179167,-1.84214407,0.732713926333,-1.025934021,3.25587096333,-0.108366334005,1.86111592333,4.09919737167,-1.061670395,3.90842921833,1.56287834333,0.0563065322167,0.618446812333,-0.9234514595,-1.18040258667,-0.179711704333,-0.523961727667,0.7184895455,-0.155276661833,-0.5153640815,-0.501759865333,-0.249485456667,-0.733048035667,0.703935420833,-0.536666942167,1.36162463167,0.495394200167,-0.0273661545833,1.603048265,0.713121628333,0.383579951167,0.495580779167,-0.113894333667,0.0770645313333,-0.134163562833,-0.346474777167,0.115731493833,-0.0660164883],[-36455.3282,1488.82309667,282.303503217,-4137.33518,1205.91139833,2142.66802833,-41.7567567167,1286.128035,683.207459167,356.064117,-1503.016725,-11.8765388283,500.7993885,256.4447285,-227.027118333,347.064776,-194.295140667,-380.942972,-655.195251833,-150.613673833,-111.294631333,-563.467080333,-205.724533667,482.554623,-37.1973055,-72.26004355,180.991849167,-153.258129167,-74.41933135,12.0449825267,-210.431137333,54.4667217333,-249.844185167,-84.4155744667,-13.3401478,-46.6677306833,-1.63687977767,98.6891797333,11.3317712817,24.82854275,41.1508384333,-38.25130135,99.60562025,-163.134562167,14.8977914833,8.85863087167,-34.4216171333,5.77740058833,-16.9181063167,-2.09640188667,13.9149075167,5.62431798167,21.8875956,20.5330779167,-1.81953524667,37.3899045167,-53.5903054167,33.4332189,-8.91759066,-4.38296008,8.99769030667,-1.07012205467,-5.96814874333,-2.461012055,-3.42544643333,-2.86771275167,-2.68771903333,6.16494455167,3.09039323167,5.46537798333,6.24544823333,-7.61652581667,16.1567848667,-4.53721507167,4.73595011667,3.34515179833,0.3966059145,-1.70270121333,-2.51519947167,-3.13151447167,1.177416465,-1.44385327833,-1.856155645,-1.81828424167,0.6777017215,-1.11605624833,3.222479985,-0.2261963145,1.79372371167,4.0133692,-1.093186365,3.82925707167,1.57014020667,0.0114473014167,0.537743555167,-0.882652818833,-1.18701761833,-0.12432817205,-0.551460866,0.736288283333,-0.152229232167,-0.494227365667,-0.485666572,-0.263987547667,-0.7495022465,0.694818850833,-0.562580974167,1.34476468667,0.459934476167,-0.0687622757167,1.584648245,0.697104183333,0.3620629345,0.454655642333,-0.105469701167,0.0729114723667,-0.123630701,-0.356572751167,0.1215808655,-0.0824513516833],[-36634.9712833,1567.529825,-48.1582504667,-4123.19514167,1296.876815,2277.10189667,-35.3928357667,1361.03419,701.6694625,411.721484333,-1475.55895333,-22.7588858167,582.137958333,244.681130667,-229.1520175,331.319741667,-180.323079667,-368.144132667,-655.5346515,-118.5701345,-102.59428965,-581.935276333,-190.475950333,502.097749167,-49.1181896667,-72.2458940667,185.286735167,-160.232101167,-69.14832785,5.07693691167,-211.761661333,54.4133315,-247.171550667,-77.4452298333,-7.60207960333,-49.1305552833,-2.97979437667,98.63442905,8.736863385,25.51022015,38.31362575,-37.2400064833,99.6758639333,-164.008757167,16.817992,13.552487655,-37.8476356333,4.69773054333,-16.7266582167,-2.52040362167,13.15173615,5.29581807667,21.7571752333,19.5895904833,-1.84560311333,36.70738335,-53.8336198167,33.6983324167,-7.04234183833,-5.491639275,9.38265111333,-1.559452915,-5.587134915,-2.21921591167,-3.44184369,-3.18017083,-2.68797205167,5.98454792833,2.77806968333,5.28883142833,5.85285528167,-7.77366235333,16.0336388833,-4.24242243333,4.28330599667,3.44218770833,0.2186797902,-1.78967062,-2.40685290167,-3.02199371667,1.26017057667,-1.42352372333,-1.86991754333,-1.78343235,0.616361390667,-1.19927456,3.15121964833,-0.353913709167,1.71358166,3.89243347333,-1.11682572333,3.71241579,1.583648675,-0.0512191572333,0.466442365333,-0.851090367833,-1.18638815333,-0.0723944836667,-0.575889734833,0.749790055167,-0.145610341833,-0.469372206333,-0.465047385167,-0.273730481167,-0.760976737333,0.677875593333,-0.586611400333,1.31828272667,0.419841438,-0.113525378017,1.55493353667,0.681363876667,0.331220554333,0.413799639833,-0.101854433333,0.0691606853167,-0.115472366333,-0.3659206675,0.1260861785,-0.0998226162667],[-36881.5866667,1584.29128167,-356.21738145,-4110.72905667,1386.05771333,2401.98594333,-48.1275696667,1414.31306333,719.558537667,474.879655333,-1437.381305,-29.5416372667,666.246354333,229.712335667,-238.727104667,316.7568155,-164.9125865,-352.192062833,-652.785213667,-80.5912571667,-97.8793189833,-597.954702167,-175.123268667,523.784296167,-60.8214012333,-72.6998979667,189.143423833,-166.888364167,-62.52202755,-3.05954627,-211.520499333,53.9778456333,-242.352938667,-69.1533231,-1.51381941667,-51.5143506667,-4.59646601667,98.2889108167,5.82218893,25.9297234,35.0200803833,-35.5749033333,99.2967035333,-163.876604667,19.02110065,18.5896637333,-41.2030087833,3.576473375,-16.4549258167,-2.98429328333,12.3560587,4.86535341667,21.40308,18.5066674833,-1.79716160333,35.8264026333,-53.8231938167,33.7986058333,-5.03332211167,-6.66918179333,9.74474414833,-2.06617540333,-5.131278835,-1.9614253,-3.430171885,-3.48788759667,-2.68312708333,5.74404633667,2.45184034167,5.05128637333,5.409612485,-7.89735185,15.8079358333,-3.89546862833,3.760046985,3.55652628333,0.0181204533,-1.8499924,-2.29998820833,-2.90171181333,1.33596772,-1.38642385667,-1.87822331333,-1.73917817,0.553382542667,-1.27476926333,3.04763950833,-0.486951424333,1.62177922333,3.74213351833,-1.13273337,3.55918374833,1.603959595,-0.131223677833,0.403305054167,-0.828574091833,-1.17956135833,-0.0244591720167,-0.599025718833,0.758643112833,-0.136557354333,-0.441805781167,-0.440688145833,-0.278235053667,-0.7676634175,0.654452148333,-0.608214158833,1.28305425167,0.376560057,-0.1606784485,1.51468688333,0.66649606,0.2921526015,0.373259941667,-0.1031281655,0.0653927676333,-0.109788919667,-0.375257476167,0.129338492167,-0.117717823917],[-37208.8985167,1567.94834667,-636.7813625,-4100.26441667,1469.68897833,2501.46458833,-80.4756135667,1436.55908167,737.021750333,541.135783667,-1395.54919333,-32.61323055,749.1016575,211.4790575,-250.867784667,303.599696667,-148.7279925,-334.2271485,-646.561836833,-37.8865482517,-96.5284379167,-610.456240667,-159.820698667,546.572784333,-72.1300581833,-73.3274467333,192.763443167,-172.909152667,-54.7735401,-11.9584315117,-209.867082,53.1730546,-235.691045167,-60.07997715,4.99477126667,-53.77075575,-6.32991402833,97.8174447667,2.6963192745,26.079047,31.41619065,-33.4015885833,98.5185764333,-162.788184833,21.3298811333,23.9351386167,-44.4221750667,2.41173340833,-16.1080623667,-3.46883099,11.5696104167,4.351821655,20.8469439667,17.3204514667,-1.69434750167,34.7848347333,-53.5637866833,33.7190660667,-2.91924150033,-7.89352824667,10.0773703383,-2.61140325333,-4.62498286667,-1.69622770333,-3.39994313167,-3.78918014,-2.67442170667,5.45576659167,2.11736050333,4.762732335,4.93176977,-7.98742546167,15.4904252333,-3.50419375667,3.17158976667,3.686270695,-0.211811378133,-1.89223368167,-2.19356494667,-2.77194905167,1.40194122167,-1.33761144333,-1.88373019333,-1.68784753333,0.491964540667,-1.34268697667,2.91732522167,-0.621228628167,1.51935629833,3.568160805,-1.140526785,3.37164024833,1.631333355,-0.2280701425,0.346915468833,-0.814764959,-1.16743696667,0.0190274580167,-0.622658646333,0.762782069167,-0.125931202333,-0.412588371833,-0.413561422,-0.277448302833,-0.7701353565,0.6256778755,-0.627059465,1.23994831,0.331382601167,-0.209096946,1.464859045,0.652925259,0.245975173167,0.333197214167,-0.109316778833,0.0612422151167,-0.1065917795,-0.385290956333,0.131440542833,-0.135720911667],[-37589.2225,1564.25293667,-884.783079667,-4085.70664167,1550.19158833,2560.84930667,-128.117269667,1420.94895667,753.723688,607.213164333,-1356.46117,-30.8487644833,828.751349833,191.557384667,-260.676875167,291.517204667,-132.474807333,-315.270109,-636.2227865,9.24074064333,-97.1769709667,-618.149233333,-144.352751833,569.406466833,-82.9978351333,-73.9427728667,196.307383,-178.007201167,-45.88253435,-21.01473785,-206.807937167,52.1605433667,-227.441079167,-50.6589130167,12.0193711133,-55.8480114,-8.05982752333,97.3542383167,-0.571706832,25.9817725,27.66966045,-30.8059564833,97.4162982667,-160.759259333,23.6147672333,29.57653405,-47.41324525,1.21015433196,-15.6771707333,-3.95677105667,10.82574965,3.76008065167,20.10114865,16.0585294667,-1.54230124833,33.6159619333,-53.0452526667,33.4553462833,-0.713802241333,-9.12814333833,10.37893575,-3.211344505,-4.08965551167,-1.42672289333,-3.35695970167,-4.08328721167,-2.66522941833,5.12516123333,1.77477274,4.434121095,4.43057403333,-8.03961711,15.0916342,-3.0699567,2.52831457667,3.831891225,-0.4752644075,-1.92314787333,-2.08550368667,-2.63279107833,1.45607952,-1.280129865,-1.88893385,-1.63132984667,0.4330779055,-1.40475944333,2.76476386667,-0.754601513167,1.40782505,3.37500637667,-1.137833095,3.15279878667,1.66678387333,-0.3403616195,0.2964715265,-0.808674429,-1.15016694333,0.0578267926667,-0.648261730667,0.761964832167,-0.1140474365,-0.38267518,-0.384217308167,-0.271698793167,-0.769173484833,0.592121849333,-0.643296630833,1.189663265,0.285012096333,-0.2572472575,1.40633427667,0.641229506333,0.193923888333,0.293924496333,-0.120187944167,0.05661484415,-0.105720639167,-0.396517435167,0.13248729,-0.153364289],[-37995.6131833,1598.15472667,-1106.18097183,-4067.56320833,1628.62377,2569.68743667,-181.416900667,1367.51724667,767.655698,671.259169833,-1324.375435,-22.4709286333,904.509136667,170.997060167,-266.066550167,280.0682785,-116.5843695,-296.055734,-621.573395833,60.3014881817,-98.6178403333,-620.507961,-128.5435435,591.752854833,-93.3281589,-74.4906955667,199.86036,-182.086078667,-35.9245861167,-29.6907310667,-202.349676667,51.08680235,-217.789885167,-41.1446448667,19.4755225167,-57.6811696167,-9.73735283333,96.9827709833,-3.93035304717,25.66465065,23.9233071333,-27.836301,96.0689443167,-157.833432667,25.8001383167,35.4463227167,-50.11610495,-0.00543362215333,-15.1536278167,-4.43969968,10.1471352733,3.10040422833,19.18505915,14.7417932167,-1.34388197333,32.3543082333,-52.2728886333,33.01237245,1.56230669967,-10.3414473283,10.65309785,-3.86600003667,-3.54602601167,-1.15575025133,-3.303645315,-4.36817688167,-2.65774660333,4.75778131167,1.42285640833,4.07335209167,3.91636615,-8.05249418667,14.6219444333,-2.59346923167,1.84286841,3.99241063,-0.7697234535,-1.94894489667,-1.97640297,-2.484910365,1.49699302833,-1.21543832667,-1.89506006833,-1.571650105,0.376850940333,-1.46272723333,2.59362347333,-0.8853746575,1.28902528167,3.16672584833,-1.12204853833,2.90706939,1.71015562,-0.465741751,0.251408397167,-0.809949704333,-1.12827075833,0.09261825115,-0.676317162,0.756126079333,-0.10103501685,-0.352788754333,-0.353264188667,-0.261533417333,-0.765397734333,0.554418711167,-0.657139562667,1.13312882333,0.238125496167,-0.303709377333,1.34024084667,0.631720939,0.1371319326,0.255827705167,-0.135380395833,0.0514144066667,-0.106669026833,-0.409037229333,0.132473838167,-0.170426610667],[-38427.1665833,1646.85246,-1323.92416833,-4058.12922167,1701.490055,2524.06510833,-226.994042333,1281.11354333,775.6530205,733.487422333,-1300.58947167,-6.59475193333,974.125436167,148.752149333,-270.3883345,269.272202667,-100.969343833,-277.085569167,-603.300156833,113.425647983,-100.418323983,-618.758039667,-112.534039717,613.565482,-102.872389883,-75.0290944667,203.360866167,-185.2277245,-25.2950573833,-37.6303797667,-196.754554,50.0195490167,-207.036703167,-31.5589027167,26.9162567167,-59.22042125,-11.3871699617,96.7314900667,-7.29972162167,25.17549725,20.3028375,-24.5604484167,94.5642621667,-154.184937167,27.8894981667,41.3411065333,-52.5231486667,-1.21287642137,-14.5484377,-4.918468605,9.55320822167,2.40191890167,18.1486408667,13.3975674,-1.1094815755,31.0447394833,-51.2972134833,32.41404025,3.85442360167,-11.5089347833,10.8931309833,-4.54999307,-3.01815059667,-0.889530685667,-3.24043522,-4.637833355,-2.65275982333,4.36586116833,1.06378348667,3.686201835,3.40274501833,-8.03124245167,14.09563095,-2.08295018167,1.133109111,4.156904455,-1.0827674005,-1.97790448833,-1.86992012833,-2.33092050167,1.52445274,-1.14457423333,-1.90195789833,-1.51210539167,0.323129048167,-1.51750546333,2.40851312333,-1.0110813645,1.16579237333,2.94854195167,-1.09238293167,2.64206299,1.75703916,-0.599967207667,0.2102127615,-0.818163227333,-1.10333515667,0.125513649733,-0.705944984,0.745870934167,-0.0872352231333,-0.323633663667,-0.321830460667,-0.247939289667,-0.7593617365,0.514006138167,-0.668677114333,1.07199654167,0.191821644333,-0.3474216725,1.26850909833,0.623724889667,0.077029762,0.2189346285,-0.153726406,0.04532208535,-0.108300946,-0.422455023667,0.1312844235,-0.187033964],[-38869.1154333,1691.69505833,-1548.08240333,-4074.86141167,1768.07922,2428.47771833,-246.336140333,1172.83992,772.249798333,794.490733667,-1284.20133667,17.96335655,1035.82441267,123.270043133,-277.3209725,258.823467667,-85.8034402167,-258.780551833,-582.450296333,166.2607515,-102.309863833,-614.033456667,-96.8141057167,635.236228333,-111.3554915,-75.76877605,206.603651333,-187.648691667,-14.5735265183,-44.50344915,-190.2455715,48.8853218167,-195.394521333,-21.91398345,33.7958370833,-60.40228185,-13.06526585,96.5823607667,-10.6158001833,24.5442939667,16.9318479333,-21.0629778833,92.95417115,-150.009822667,29.88218275,47.0160596,-54.6658368833,-2.38625014333,-13.87206725,-5.39211051,9.061650295,1.697290725,17.0495840833,12.0531754,-0.863789001333,29.7291814,-50.1846799333,31.6813572167,6.09640556,-12.61881795,11.0891986333,-5.23391986167,-2.53499366,-0.634269457667,-3.16563929,-4.88336153333,-2.64956056167,3.96477866667,0.7002323675,3.27450220167,2.90515378167,-7.984731105,13.5271609667,-1.550112605,0.416078129167,4.31168252333,-1.40193656333,-2.02099017833,-1.771366355,-2.175507125,1.53846389,-1.068459702,-1.90864688,-1.45606690333,0.271994439833,-1.56961771167,2.21406368833,-1.12830166167,1.04087650567,2.72646262167,-1.0491898075,2.36615839,1.80178313333,-0.739290006167,0.170313097667,-0.833185305167,-1.07800153833,0.159095742333,-0.736086610667,0.731909822,-0.07316870275,-0.2958972255,-0.291236733,-0.232034405833,-0.751506509167,0.472732373333,-0.677775056667,1.0081242315,0.147509105333,-0.3875504935,1.19337384333,0.616218903833,0.01487514275,0.182999894667,-0.173897892667,0.0376448948,-0.1092623935,-0.436382259167,0.1288075405,-0.203518815],[-39293.1251167,1692.53104833,-1773.90653167,-4125.66959333,1819.168505,2292.76554,-232.521237167,1051.6062565,754.394434333,852.7012635,-1273.285365,48.4136137167,1087.48757333,91.9314384333,-289.113712833,248.751066833,-71.2767237333,-241.563730333,-560.860207167,216.5237725,-104.726694,-607.033786,-82.29427095,656.751633833,-118.461391667,-76.6772110833,209.291683,-189.648955833,-4.32328603,-50.26397315,-183.02138,47.3625094667,-183.157778667,-12.29940048,39.6348315833,-61.1501895333,-14.7170033167,96.4798491,-13.8030424167,23.7830961167,13.8569506833,-17.4522356833,91.1859646333,-145.497957833,31.7387874167,52.2298709333,-56.56454045,-3.51871718167,-13.1322930167,-5.83334411,8.68325398333,1.03375250067,15.9352591333,10.7255007483,-0.639360709167,28.4193710667,-48.9948742333,30.8203974,8.21399877667,-13.6601366167,11.2243677333,-5.896098245,-2.12455824833,-0.397773466333,-3.07507505,-5.09544778667,-2.63968608667,3.56790979,0.337192003233,2.838551565,2.433801605,-7.92127843833,12.92605235,-1.0108673605,-0.2941299075,4.442432965,-1.71814787833,-2.08926824667,-1.68388599833,-2.02328665833,1.537482955,-0.988740538833,-1.91342195,-1.404316155,0.223645134167,-1.61757085333,2.014418195,-1.233582955,0.916303521167,2.50512065333,-0.993769305,2.08608610333,1.83892976833,-0.880716448167,0.128723124517,-0.854078847667,-1.05487736167,0.195424527,-0.765875380167,0.7143781775,-0.0598054843167,-0.269999069,-0.262342026667,-0.2147750325,-0.7415522545,0.432285240333,-0.683881241,0.943041659667,0.106266365183,-0.423269459167,1.11654008167,0.608199112833,-0.0482552809,0.147612962833,-0.1944784005,0.0276209339167,-0.108388098333,-0.450476628,0.125024976167,-0.2200929105],[-39655.2176833,1641.34228667,-1960.79648667,-4198.35895,1846.56505667,2134.89041667,-199.633343667,919.612376667,723.680636667,903.52635,-1265.19125333,77.3681344,1127.3143,53.0612707717,-302.605836833,239.120210167,-58.1565476833,-225.8931665,-540.3808665,262.924401167,-108.2949075,-596.967398833,-70.2548760833,676.863118833,-124.069966,-77.4792626333,211.100831667,-191.342882333,5.15420882167,-55.0870054833,-175.178509,44.9435776333,-170.794344167,-2.97412388,44.3582584833,-61.4070284333,-16.13804815,96.34942495,-16.7656222,22.87924415,11.0589692983,-13.8735519333,89.1271908833,-140.7484575,33.3582059333,56.8640938667,-58.1741233833,-4.66755259833,-12.3245118333,-6.184070045,8.41775172,0.45580314365,14.8222367667,9.42878449167,-0.4711589795,27.1023549333,-47.73530925,29.82261005,10.1461643283,-14.6085109333,11.2654374833,-6.542151135,-1.802544975,-0.18503897078,-2.96463501333,-5.26805890167,-2.61115072667,3.18255017,-0.0152132054,2.38185427,1.99410171667,-7.83929313667,12.2983358667,-0.483706216783,-0.987041953167,4.53742717167,-2.03228718167,-2.18883754833,-1.60285397,-1.87768699167,1.51871647167,-0.9084484465,-1.91453204667,-1.35463180333,0.179101485833,-1.65776595167,1.81387163833,-1.32361604833,0.793208692167,2.28791575333,-0.928036389667,1.80551726667,1.86577535833,-1.02262381283,0.0835102735667,-0.8773398345,-1.03583083167,0.234410472167,-0.795275873667,0.692623957333,-0.0483924748333,-0.245904351833,-0.235131266167,-0.196479557667,-0.728810031833,0.393832555333,-0.686097178833,0.877353982833,0.0687162927667,-0.453457958,1.03891018,0.599439007,-0.111237420417,0.1125826642,-0.213952343,0.0146717153317,-0.105360823333,-0.464641035,0.120266920833,-0.236458663],[-39907.2162333,1562.723995,-2066.01949833,-4275.850905,1852.14775167,1974.23720167,-162.341399667,776.774503667,682.385777833,943.7777225,-1256.818715,99.0696716833,1154.12253833,5.96337033667,-313.5566865,229.4945135,-47.3169140833,-212.030681167,-522.116814667,304.6906445,-113.318984667,-582.820941,-61.7455984333,694.063295667,-128.328978,-78.0383809,211.777310667,-192.723774833,13.6865926933,-59.0804379667,-166.789312667,41.2330716,-158.799018167,5.80097448,48.0629826,-61.1639358333,-17.1810591167,96.1172036667,-19.4309971333,21.8168752333,8.53625982833,-10.4693024233,86.6832606667,-135.824774833,34.6448077333,60.8752936,-59.4375848,-5.89894767667,-11.4377763667,-6.40213818333,8.25510455833,-0.0123508182333,13.71531905,8.18248784,-0.3917378325,25.7734022667,-46.39529245,28.6853573333,11.85035485,-15.4398397667,11.1814866833,-7.18676077,-1.58013671833,0.00536214888,-2.83250725333,-5.39862635667,-2.557740305,2.8130484,-0.347087999267,1.90852978833,1.59156869,-7.73397579,11.65143555,0.0151023660333,-1.6548621825,4.58776979167,-2.348578005,-2.32369762333,-1.522243015,-1.74081532,1.48122377833,-0.829996270833,-1.91040843167,-1.30533825,0.139540600833,-1.68771056167,1.61638361167,-1.39573554833,0.672331279333,2.07807219167,-0.854164083,1.52687549167,1.88079190167,-1.16422542833,0.0332300344833,-0.899189733667,-1.02210120667,0.275265176833,-0.824472958167,0.6661727345,-0.0396476918667,-0.223309519333,-0.2094206725,-0.177196948167,-0.713115458833,0.358283831333,-0.683797334167,0.811261212667,0.0353028348667,-0.4772427535,0.961175536333,0.589931021833,-0.1731108415,0.0778189777833,-0.2310035925,-0.00158466314,-0.100251668583,-0.478896288333,0.114948524167,-0.2522266215],[-40049.67265,1462.43395667,-2064.78207167,-4344.88804333,1834.56314333,1827.06874333,-132.728752167,617.531678667,634.946830167,971.450578167,-1245.66538833,110.704630833,1165.06609167,-48.695051495,-319.365116667,219.763894167,-39.0006729,-200.036986667,-506.602554,340.776227833,-119.399487,-564.750548333,-57.1700151833,707.493392,-131.5805595,-78.1925042667,211.333951667,-193.810544833,21.1991754,-62.1787531333,-158.156544167,36.1403406333,-147.530827,13.8789688733,51.01322915,-60.5092349833,-17.7728696833,95.7873880167,-21.7580631167,20.6642117833,6.31593792667,-7.37407597333,83.8892005167,-130.7790285,35.5585584333,64.3309432333,-60.3245821167,-7.24491111667,-10.47865455,-6.48124067333,8.18334995667,-0.362401635517,12.6432352333,7.00517717833,-0.419122611,24.4618575667,-44.9725291167,27.4343884333,13.3199800833,-16.1397585833,10.9685035,-7.85236465333,-1.46055027,0.177739902387,-2.68574678333,-5.49134145833,-2.481087015,2.46538306667,-0.6547879895,1.427318888,1.23323604583,-7.60542410667,10.9999202167,0.475795076883,-2.29250606667,4.59293565,-2.67407975167,-2.492897445,-1.43950582667,-1.61252999667,1.42726315167,-0.756338036667,-1.90143248167,-1.25710274167,0.10502345505,-1.70855039333,1.42674089667,-1.44972157333,0.553687929833,1.87906582667,-0.7745041715,1.2522074215,1.88441719833,-1.306601985,-0.0217218658,-0.917766192333,-1.014104525,0.317205160833,-0.853664466167,0.635566477667,-0.0336649973333,-0.2021254545,-0.185359423,-0.1574685965,-0.695310206167,0.326476128,-0.6775123865,0.745092979333,0.00615316731667,-0.494469221667,0.884104525833,0.579978865333,-0.233525291667,0.04367445655,-0.2451373345,-0.021091619685,-0.0934274195167,-0.493439484333,0.109477920667,-0.267206945667],[-40096.5776833,1319.74159,-1958.54581167,-4401.652705,1790.7701,1700.55272167,-112.745104,440.243704333,584.020584667,986.922264833,-1230.78459667,113.6001745,1158.40990333,-109.769547217,-319.783064833,209.917442167,-32.6684718167,-189.9647935,-493.560913833,370.123564167,-125.924805,-543.479331,-56.9579039167,717.110839,-134.049938833,-77.8164419833,209.8786765,-194.573468167,27.5725609167,-64.2556002,-149.499045,29.5754495,-137.126424667,21.24359165,53.3233131333,-59.5225103167,-17.93392305,95.3936256,-23.7234497,19.4952037833,4.43535300667,-4.64609506333,80.7904089,-125.6627365,36.1107543833,67.2524194333,-60.837833,-8.70377751333,-9.46286534,-6.44255843667,8.19518773167,-0.5958252135,11.6413557167,5.91425861333,-0.557054452,23.2023425833,-43.48350565,26.1080102333,14.54592625,-16.7039011667,10.6374743333,-8.549246715,-1.44424689667,0.3340235995,-2.53297347667,-5.550148275,-2.38720851833,2.14624648,-0.9365348455,0.944685291667,0.9268101695,-7.45940305167,10.3598286983,0.890977231667,-2.89483925667,4.55549265667,-3.01145313833,-2.69358229167,-1.35680155833,-1.493408055,1.35963389833,-0.689062767833,-1.88833558,-1.21209967833,0.0750116658333,-1.72217804,1.24799464333,-1.48564615,0.437182629667,1.69444178667,-0.6909378615,0.984501319833,1.87719691667,-1.45061372333,-0.0803456413667,-0.933227942667,-1.01256658833,0.360235264833,-0.882327704667,0.6017792595,-0.0300577647833,-0.1824946395,-0.163367997833,-0.138061129667,-0.676383542667,0.298969959667,-0.667945174333,0.679524388833,-0.0185418129,-0.505202559167,0.808745652833,0.569763336667,-0.292475273667,0.0106243584,-0.256314923833,-0.0438271360833,-0.08495543235,-0.508195784333,0.104152045333,-0.2814699105],[-40062.3087167,1156.20247333,-1771.54876167,-4449.03026667,1731.39140167,1590.012975,-92.8177169833,250.929277167,529.555723167,992.842263,-1213.778045,113.807011,1135.92629833,-174.603277,-314.2772955,199.326178333,-27.9974305167,-181.921626833,-481.516184833,392.471966833,-131.642940667,-519.327447333,-61.2644778833,722.969314833,-136.031781333,-77.0874871667,207.6516615,-194.831155833,32.7180131667,-64.9695247667,-140.827394833,21.6180097167,-127.711834,27.9472175333,55.1506650833,-58.2747990333,-17.7954563833,95.0096576,-25.33001955,18.3332185333,2.98913369333,-2.28595516633,77.4918304833,-120.536729,36.3440068667,69.6961523833,-60.9831561,-10.25933651,-8.39732221333,-6.32718090167,8.28689329833,-0.7358634195,10.7251599317,4.93696346,-0.803214599833,22.0449315333,-41.9463025,24.7526063333,15.5372738167,-17.1290559,10.207137615,-9.28113348667,-1.53141481333,0.4800780515,-2.38204168833,-5.58042290833,-2.289220935,1.85954180333,-1.19091616033,0.464270915267,0.6826323265,-7.300080045,9.748674345,1.258636514,-3.456051955,4.48138970667,-3.36010486667,-2.92321427167,-1.27733448167,-1.383528135,1.28220610333,-0.628059164167,-1.87252799,-1.174001925,0.0495209298167,-1.731570085,1.08154854433,-1.50351738,0.3236664465,1.52824846667,-0.604686845333,0.727327531167,1.860655585,-1.59595488333,-0.142087093,-0.9462290665,-1.01760861333,0.404315320333,-0.909542744333,0.565893826833,-0.02787605525,-0.164640655833,-0.144008327333,-0.119330767833,-0.657814689,0.275998243333,-0.655922515333,0.615398556667,-0.0383736614667,-0.509656872667,0.7363989935,0.559638062667,-0.349676198333,-0.02097281665,-0.2646581305,-0.0694842933167,-0.0749451591667,-0.522869716833,0.0992760992333,-0.295153004333],[-39956.0211167,1015.58922167,-1534.144765,-4489.09522167,1675.03224833,1487.948695,-61.2581692667,60.7334191667,471.192758,993.234272167,-1196.749145,118.4033435,1102.43145167,-240.2386185,-302.409060333,187.042621667,-24.7295361833,-175.946312833,-468.753285833,408.4641155,-135.317970833,-492.657032667,-70.0313014667,724.916541,-137.933986833,-76.3100696333,204.961918,-194.387854667,36.6619219833,-63.99477125,-132.129294333,12.4687189,-119.533577667,34.0882184167,56.7356658,-56.8534591833,-17.5325127667,94.7255728333,-26.5882122167,17.1728333333,2.07792268167,-0.274787463667,74.1399703167,-115.503174833,36.3257226833,71.76917885,-60.7595701833,-11.8926771167,-7.28456422333,-6.18329975833,8.45377992167,-0.808004535333,9.89169217833,4.106692815,-1.14836269817,21.0503263667,-40.3855378167,23.4222038667,16.32235215,-17.4098907667,9.699459155,-10.04958067,-1.72258225333,0.625122471833,-2.240543535,-5.58936837667,-2.20049669833,1.605668285,-1.41461680333,-0.0096091471,0.512490102333,-7.13035294667,9.18504423833,1.58102299,-3.96988110833,4.37908534167,-3.718102615,-3.17999350667,-1.20434154167,-1.28181970833,1.19966835833,-0.572693402333,-1.855982615,-1.14666838833,0.0289066583,-1.73959843167,0.9283458315,-1.50351784833,0.215154369167,1.38457759667,-0.51668265,0.484244221167,1.83740026833,-1.74165527667,-0.206985088833,-0.957523701167,-1.02845956333,0.449240040333,-0.9341263615,0.528994584167,-0.0259971871667,-0.148785628667,-0.1279986675,-0.101252381717,-0.641224584333,0.257612560167,-0.6423980015,0.553887414667,-0.0529168950333,-0.508173847,0.668355582167,0.550244642667,-0.404623526333,-0.05089210355,-0.270405616167,-0.0973884620667,-0.0635812298667,-0.536996564,0.0951933278,-0.308399174167],[-39795.8449167,913.010004,-1265.07159517,-4521.86591,1632.00056167,1391.069965,-14.1988889167,-119.195729333,410.339123833,990.701821167,-1180.90138333,131.318226833,1063.26715333,-304.685932667,-284.305831833,172.741949833,-22.531848,-171.966063167,-454.436277667,419.011732667,-136.364113167,-464.094692333,-83.18063975,722.594613833,-140.013307167,-75.6176822167,202.124412833,-193.1919245,39.5154315667,-61.2919853333,-123.428437833,2.28361198167,-112.931744,39.77896365,58.2904836667,-55.3312228333,-17.2433359667,94.6266933833,-27.4982826167,16.0232145167,1.71821662,1.41352209533,70.8376996833,-110.682742833,36.1182811333,73.5654749667,-60.1502654333,-13.59436085,-6.13573176167,-6.038067505,8.68865920667,-0.8211538035,9.13757652333,3.44393693167,-1.57754424333,20.2585260167,-38.8256635333,22.1641251833,16.9252328,-17.5358679833,9.13169059333,-10.85254075,-2.01788850667,0.773117437667,-2.11365195333,-5.58442912,-2.127418335,1.38427612833,-1.60267476833,-0.4709003109,0.421958717333,-6.95213822,8.68311855167,1.85923394167,-4.42988218667,4.25499045333,-4.08135545833,-3.46180740833,-1.140543185,-1.18645809667,1.11518182,-0.5232241955,-1.84060858,-1.13206809333,0.0134148686217,-1.74724820333,0.789561840833,-1.48666538,0.113975312683,1.26584070333,-0.428052983833,0.258088328033,1.809388875,-1.88608919333,-0.275101184333,-0.967543280667,-1.04396983333,0.494785977333,-0.954810871167,0.491953002,-0.0239115205833,-0.135155463667,-0.1158529045,-0.0837717109167,-0.627526035333,0.243851612833,-0.628106160333,0.496226098667,-0.0621209334333,-0.501082485167,0.605500339,0.542114683167,-0.456717428333,-0.0788992790333,-0.273722338,-0.1266857962,-0.0510662459167,-0.550068454,0.0922550628333,-0.321311503333],[-39604.49775,830.025761333,-981.037601667,-4544.18323,1602.10531833,1297.36479667,46.5012229333,-281.3475795,349.989021167,985.387273167,-1166.14646333,152.675932833,1022.79002217,-365.636863667,-260.988568667,156.8144825,-21.3166678,-169.422208667,-438.7739625,425.088329667,-134.492786333,-434.439861333,-100.261158883,715.214989667,-142.287761667,-75.00355235,199.523031667,-191.353185667,41.5086992,-57.0196793,-114.753946333,-8.62643249,-108.382408667,45.2291984,60.01815645,-53.7462064667,-16.9313807833,94.7940836,-28.0770610667,14.9293161,1.846854975,2.81906104,67.6809957833,-106.215324333,35.8386063,75.1724358667,-59.1025988333,-15.34411065,-4.96938825833,-5.88681723333,8.98139022333,-0.780740973167,8.46507582167,2.945893945,-2.066488145,19.6850279833,-37.2837892,21.0334527167,17.3702294333,-17.4823107,8.52465895,-11.68052165,-2.412825925,0.922241986333,-2.00053898333,-5.57398185,-2.07081857333,1.19559218667,-1.75327156,-0.910997137167,0.406596836333,-6.76246249333,8.25377504667,2.09500820333,-4.82644413833,4.117514345,-4.44323342167,-3.76383098833,-1.08692279833,-1.09428321833,1.0299001145,-0.480050219,-1.82873018333,-1.129338575,0.00322564727167,-1.75451487833,0.666594332,-1.45601942167,0.0234523857833,1.17230587167,-0.339702373833,0.0516257734667,1.77900762167,-2.02653824667,-0.345594118833,-0.975779561333,-1.06196248167,0.540489161667,-0.970100181167,0.455183014667,-0.0217250369833,-0.124059465333,-0.107346510667,-0.0668946702,-0.616903159667,0.234776700167,-0.61383851,0.443630157667,-0.0666692194333,-0.488615624,0.548323114833,0.535763597833,-0.505079477,-0.1045024502,-0.274450518167,-0.1561432875,-0.0376320327,-0.561373574667,0.0907453050333,-0.3338616845],[-39412.9381667,728.908334667,-696.115674333,-4549.51307833,1579.35475833,1205.68929167,112.594200233,-420.454228,294.904182667,976.133856667,-1152.10665667,179.731464333,984.568648667,-421.317846167,-233.0449355,140.1397045,-21.0427533833,-167.725637833,-422.589217167,427.6113665,-129.8029905,-404.259593,-120.872917517,701.749394167,-144.679340333,-74.3327871333,197.5158205,-189.022029,42.9151963667,-51.4939166333,-106.09582925,-20.000626035,-106.4083795,50.6127369833,62.1545300833,-52.1307302,-16.5336036667,95.2980989833,-28.3254156167,13.9460275333,2.35245535833,3.97673477333,64.72103725,-102.232557517,35.5826637833,76.6852112,-57.54812915,-17.1190844167,-3.80884415,-5.70666063833,9.32149880667,-0.683503275167,7.87458681333,2.60008335333,-2.59276793,19.3261652333,-35.7676862667,20.0735472333,17.68280975,-17.2205732167,7.89867793167,-12.5253808333,-2.90054173333,1.06809899833,-1.89828273667,-5.56569616,-2.02759975333,1.03871203783,-1.86426168833,-1.32127366483,0.4572864605,-6.55561985,7.90294743833,2.289727455,-5.15045591333,3.97526298333,-4.79852685167,-4.07959569667,-1.04351755667,-1.001298504,0.943959972,-0.444140072167,-1.82255130667,-1.13619141333,-0.00164496597167,-1.76017167333,0.560790324,-1.415041725,-0.0530644752833,1.10285045333,-0.252721441667,-0.133460358967,1.74866667833,-2.16066767333,-0.4171759185,-0.981291988667,-1.07967486,0.585556288333,-0.978420679167,0.418804437,-0.0199343535667,-0.1158124135,-0.10196242075,-0.0505830469167,-0.609006718667,0.230409479167,-0.600180085167,0.397079242833,-0.0675480359667,-0.470976804167,0.496762152833,0.531653428,-0.548944829167,-0.127099689667,-0.272385609,-0.184371000833,-0.0236258109567,-0.570115996,0.09092092575,-0.345878522167],[-39248.8431,567.6497315,-420.661907167,-4525.78387333,1557.25610833,1116.78859667,170.479091,-533.093882833,251.7012015,961.817026667,-1138.06655167,208.069174333,951.953689833,-471.030566667,-199.548530667,123.892039,-21.50609355,-166.357802667,-406.917815667,427.6473595,-122.804297167,-373.488245,-144.653129667,681.317449333,-147.107379,-73.3567879333,196.396607167,-186.318768,44.0842371667,-45.1383885333,-97.2940883333,-31.6522751167,-107.417467,56.06805765,64.9715115667,-50.52950215,-15.9441065667,96.1906744333,-28.22251285,13.13397375,3.09950057,4.93888760333,61.9576998333,-98.8139277333,35.41511445,78.2205325833,-55.4263678333,-18.89667395,-2.68099986167,-5.465184955,9.69749181667,-0.518816417333,7.35981784,2.39049483667,-3.13400552,19.1606632667,-34.26846755,19.3111734667,17.8980444667,-16.7282848333,7.27455300333,-13.38481405,-3.46822953,1.20562579667,-1.80348352333,-5.56617550167,-1.991863675,0.909865890167,-1.93266841333,-1.69405762167,0.561610564167,-6.3228715,7.630296265,2.44728148833,-5.39625632333,3.83814759,-5.14563510833,-4.39963707333,-1.00902487417,-0.902454916833,0.857124887333,-0.416947471667,-1.82394866833,-1.14937266167,-0.00166046708167,-1.7620448,0.472820188333,-1.36720669667,-0.112403865783,1.05475368667,-0.1678360238,-0.297278824,1.72138159667,-2.28743791333,-0.487884483667,-0.982742633,-1.09370260667,0.628885365333,-0.978445053833,0.382736846167,-0.0192451419833,-0.1106876145,-0.0989981014333,-0.0347493487333,-0.603074281167,0.230509456333,-0.587469580833,0.357210777167,-0.0660159920333,-0.448336875833,0.450041563,0.530372926167,-0.587963589,-0.145969471333,-0.267421027333,-0.209818264167,-0.00953156377667,-0.5755655555,0.0929383641167,-0.357069053667],[-39133.5810667,335.484720117,-183.730134278,-4460.37512333,1535.05436833,1028.72646,206.802481333,-627.9118525,226.700722167,941.570117,-1123.68001833,234.3798415,924.829731,-515.513328833,-158.869825,109.039806483,-22.6253715,-165.013978167,-392.312482167,425.697031833,-114.164441333,-342.071616167,-170.770135667,653.502441833,-149.557101333,-71.8605692667,196.362753333,-183.2759745,45.317028,-38.2777380833,-88.2883364667,-43.2982367667,-111.676915833,61.8705965667,68.5923804167,-48.9975467167,-15.06453735,97.5059628167,-27.7529252,12.5483808167,3.99869563333,5.71740728,59.3820093667,-96.0310464833,35.4442628167,79.8470785333,-52.7179741167,-20.6820875333,-1.61086325967,-5.13321653667,10.1014333033,-0.282600179333,6.91133101333,2.307928775,-3.676400035,19.1607781833,-32.7864098667,18.7766621333,18.0443950833,-15.9958031,6.66169817333,-14.2632626,-4.08878422333,1.331631395,-1.71398624333,-5.57918118,-1.95886679667,0.804640501833,-1.95656525833,-2.02330021667,0.70727149,-6.05961178833,7.43345152833,2.570854745,-5.55914945833,3.71401117,-5.48617920667,-4.709695225,-0.9780033515,-0.791349667333,0.7696195245,-0.400125354167,-1.83424525167,-1.16565035167,0.0028777375,-1.758577695,0.402799927833,-1.31525990667,-0.152438431333,1.024625685,-0.08634144241,-0.439712482167,1.69998215667,-2.40653124667,-0.5555216365,-0.977306152167,-1.09995105833,0.6693578895,-0.969940222,0.346876415167,-0.0203085012167,-0.108978797667,-0.0977894619167,-0.0191723835583,-0.598414520833,0.234706911333,-0.575825509667,0.324449386667,-0.0633360722,-0.421170252,0.407362241833,0.532405653,-0.6218596675,-0.160699779667,-0.259293708667,-0.230841491,0.00420219696,-0.577392836833,0.0965884106833,-0.367082776167],[-39075.3906833,72.3186814667,-6.79832228,-4351.04129833,1523.08593833,940.972696667,217.811814333,-718.856535333,221.238586833,916.284632,-1109.86222,258.973827167,900.595703167,-554.061409833,-110.170598033,95.4338713667,-24.6805170667,-163.959731667,-378.5597535,421.867313,-103.5717626,-310.1024855,-197.911634667,618.437734333,-152.1557725,-69.9481530167,197.458851333,-179.812980333,46.8183403833,-30.89667145,-79.1374406167,-54.4767167833,-119.273899,68.281942,73.06204645,-47.5635402333,-13.8978694833,99.2509972667,-26.9128995167,12.2318662333,5.03460285,6.29732192,57.0493447167,-93.9221113167,35.7817838667,81.5994745167,-49.3995979333,-22.4825624667,-0.603733963667,-4.70650341333,10.5325676333,0.0119983371667,6.52206718833,2.3441622,-4.21685800667,19.3116288833,-31.3308990167,18.49733005,18.1419066167,-15.0115852833,6.06501015667,-15.1636315,-4.73336209333,1.44801742667,-1.630246295,-5.60342300333,-1.93077262,0.7185223385,-1.93927685833,-2.30644077,0.885988836333,-5.76714694,7.31215567833,2.661448695,-5.630913675,3.60683297667,-5.82074443333,-4.99479041,-0.9457396415,-0.660808567667,0.682727009667,-0.394375560333,-1.85371477167,-1.18388751833,0.01177332925,-1.75013052667,0.350508847,-1.26104911,-0.173085001833,1.01025359,-0.0104980678233,-0.559621260167,1.68587355333,-2.51713864333,-0.617591976833,-0.962489065667,-1.09392774333,0.706178170667,-0.953086977333,0.311207193167,-0.0233005268167,-0.110936782167,-0.0981112429167,-0.00354407836667,-0.594772481833,0.242656262833,-0.565390191,0.298693966,-0.0602076435167,-0.390321822,0.368316245667,0.537684326333,-0.6500637455,-0.171028654167,-0.2478892045,-0.245923229833,0.01727699625,-0.575521852167,0.10150648865,-0.375567974],[-39079.14535,-205.36966205,135.304755388,-4205.394975,1522.57847833,862.0192245,207.300849,-815.4762725,233.594420667,886.039470333,-1097.75719667,282.010163667,877.628607,-588.659537667,-53.6273660117,82.9342940167,-28.03241735,-163.8576055,-366.551447667,416.542095167,-91.4412405667,-277.428776,-224.817227,577.585643333,-154.805255167,-67.76469945,199.6041495,-176.198133,48.75485145,-23.1521035,-69.7535694,-64.8661880167,-129.834143167,75.35118935,78.3323238,-46.1745129333,-12.4364439167,101.398270033,-25.7317244167,12.2130999167,6.135222905,6.71101324667,54.9396614167,-92.4409039667,36.4297231,83.47977165,-45.4676049333,-24.2560797333,0.344121208667,-4.16979890333,10.9910628167,0.364740735667,6.187671865,2.46531315333,-4.757611175,19.5616891167,-29.9184922667,18.4511456833,18.2077066833,-13.7847377833,5.50214407667,-16.0872557167,-5.38822335167,1.552590935,-1.54715860167,-5.634097445,-1.90279461,0.646969336833,-1.89121152833,-2.547397515,1.0799669215,-5.45384276167,7.25296263667,2.72040979,-5.61145048,3.51821219333,-6.15117380167,-5.24541237833,-0.913993707333,-0.501933185333,0.595956771333,-0.3991602985,-1.88161116333,-1.20147671333,0.0246216600333,-1.73711633333,0.314499747333,-1.20780003,-0.176472110667,1.00651219667,0.0567575865567,-0.659041599167,1.67794849333,-2.62008763667,-0.672527316833,-0.938698171167,-1.07089160167,0.739830299833,-0.9285000705,0.275346676667,-0.0286729219333,-0.116700001833,-0.0996010537667,0.0123576365083,-0.591167372167,0.2540699015,-0.556200688333,0.2793336445,-0.0575806925667,-0.357227318333,0.331719092,0.545042486,-0.672787674333,-0.177020690333,-0.233935610333,-0.254018599833,0.0298400197833,-0.570277742833,0.107041878167,-0.382405492667],[-39123.5005,-487.090300333,258.864872167,-4036.48372333,1536.248635,800.463973167,189.278868333,-913.775023667,258.786962,852.837675667,-1087.14001333,306.812330833,858.340268333,-620.7353915,8.26768503667,70.9165952167,-32.6593840833,-164.924493167,-356.883729333,410.539148667,-77.9763469833,-244.189549667,-250.517737833,533.350972333,-157.327663167,-65.5921394833,202.714193333,-172.809552667,51.21904995,-15.137247845,-59.8558920333,-74.2013694833,-142.612355,83.2928773,84.256,-44.7346604333,-10.7658766417,103.876640833,-24.2870407,12.4937659667,7.23625629667,7.08895145167,53.03331595,-91.4731641,37.4357132333,85.4594781,-40.9747093667,-25.9375294833,1.24118923833,-3.52452022667,11.4659167667,0.767023998333,5.90408016833,2.63272604667,-5.28562984333,19.86156715,-28.5641243167,18.6141452333,18.2632364,-12.3474498667,4.999662075,-17.0181250167,-6.037270545,1.64293273,-1.45610826167,-5.66562815667,-1.87050818667,0.586428419333,-1.82590797167,-2.75338036667,1.27099436333,-5.12949775167,7.23723118167,2.75435724333,-5.50443952833,3.451234495,-6.47290091667,-5.45087536167,-0.8888434725,-0.308334296733,0.508967858,-0.411396267333,-1.91620552167,-1.215694945,0.04074434625,-1.72073597833,0.291232972,-1.15935153333,-0.164637921,1.00676568,0.11390597265,-0.739878916833,1.67479957,-2.71532045833,-0.718686782,-0.9080991465,-1.02704042083,0.771421918333,-0.895621840667,0.238983865,-0.03640007305,-0.126231418167,-0.101839200917,0.0285486163667,-0.5866343825,0.2683725725,-0.548495351167,0.2658602245,-0.0564937385833,-0.323306757,0.296517384333,0.553084720333,-0.69049432,-0.178783674333,-0.218503380167,-0.254294918667,0.0423360605833,-0.561513988,0.1124903025,-0.387825598833],[-39194.7905667,-783.4170155,332.409245667,-3862.07537333,1565.03182167,755.114649167,182.930294333,-1005.7487745,291.420019,820.186268667,-1078.26795833,338.9183945,845.363981833,-650.121130833,69.553780455,59.0567613833,-38.0847253833,-167.058343667,-349.817776333,404.124509667,-62.7035544,-211.525132167,-274.0410805,488.581922,-159.414958333,-63.7546473833,206.812562167,-170.040108167,54.1095425833,-6.77801381333,-49.2322610667,-82.0918023,-156.778311333,92.5841633167,90.6279813667,-43.1389526,-9.02091447333,106.623835833,-22.6694384167,13.0681642833,8.30556697,7.58854312667,51.3928962833,-90.9124502833,38.9404955167,87.50844195,-36.0162715,-27.44842765,2.08602908167,-2.77914995,11.9440437167,1.20625979567,5.68013132667,2.81200091167,-5.782922745,20.1896852833,-27.2915746333,18.98478515,18.3427341667,-10.743959685,4.59409380667,-17.9233041167,-6.655722965,1.71346535,-1.34613720833,-5.69221609167,-1.83101606167,0.537666329333,-1.757986185,-2.93269780667,1.44541357833,-4.805225435,7.249619495,2.77635425167,-5.31261851333,3.41236611167,-6.77424407667,-5.59592463833,-0.8793370565,-0.0756756532667,0.421543329333,-0.426918192,-1.95562427333,-1.22419123333,0.0598495309,-1.703079875,0.276805515333,-1.11985799167,-0.138913949667,1.00484754017,0.160859184667,-0.802483349667,1.676083065,-2.8015062,-0.753118350833,-0.873870818333,-0.958945757,0.80217933,-0.852545749333,0.2020681245,-0.0463960664833,-0.1396115505,-0.1044298245,0.0448855892167,-0.5804744075,0.285109696667,-0.542934157167,0.258060917333,-0.0578128738833,-0.289968369833,0.2621163005,0.560774139833,-0.703654151,-0.176022235,-0.2028529055,-0.2456383335,0.0551707515667,-0.548521433167,0.1171670035,-0.392331734667],[-39283.91655,-1093.4796195,320.186158667,-3704.82426167,1606.67282,720.0384235,211.6331025,-1083.30584,325.1939415,789.596329667,-1072.66009167,384.5384925,840.639352167,-676.366837333,125.144420583,47.3632949,-44.3247549167,-170.462517833,-345.577524,396.590888333,-44.6495024833,-180.488872167,-294.5036175,446.456398167,-160.569216333,-62.5886117167,211.884575167,-168.348923667,57.0093322667,2.09270082167,-37.80898535,-88.14352685,-171.4788135,103.659538867,97.2658431,-41.2445774,-7.2815473,109.608141833,-20.9925825833,13.9031411167,9.33819204833,8.28926599,50.1112120833,-90.645281,41.0572960333,89.610647,-30.7122406833,-28.7143813167,2.87566739833,-1.91943592783,12.4268943,1.67212541,5.53662483833,2.97742482,-6.25176322167,20.5428261167,-26.1346777833,19.5713269667,18.4819299667,-9.02532193167,4.32680069833,-18.7726044833,-7.222050005,1.75389321333,-1.20368382667,-5.706058425,-1.778835555,0.508951062667,-1.70274579667,-3.09481645,1.59547195167,-4.49789542333,7.28114074333,2.79967812833,-5.03985602333,3.40926631,-7.04404972,-5.667229665,-0.894449157167,0.1988043336,0.331736762667,-0.442557287333,-1.99825787167,-1.22398481667,0.0837820675667,-1.6869669,0.268840760167,-1.09249575,-0.1012804192,0.996837423,0.197515125,-0.846249346333,1.68248692333,-2.87766841333,-0.772768478833,-0.839366501667,-0.863929261167,0.8334060585,-0.797589324833,0.164417620167,-0.0591388786,-0.157213121,-0.1069137675,0.0612667367667,-0.572087119333,0.30453368,-0.540297378833,0.255896514833,-0.0618065208167,-0.258671888,0.228479343667,0.567536647333,-0.712723005,-0.1682064205,-0.188214420667,-0.227048649333,0.0688246323,-0.530657512833,0.120480426333,-0.396416342167],[-39365.79075,-1401.21616167,217.144448433,-3583.45074833,1660.22667167,693.457102,291.846959333,-1136.11995167,353.919711333,761.9018075,-1071.03894667,446.918686833,847.127495333,-700.915782667,171.972870167,35.8474211,-51.5294011,-175.470246833,-344.564782667,387.364290833,-23.6280459583,-151.6373625,-311.687992333,409.765014333,-160.344423333,-62.3595244333,217.7568455,-168.107702,59.4806807667,11.42784245,-25.5911716833,-92.2640441,-186.005779667,116.717014167,103.952958883,-38.9315509667,-5.58909170333,112.783528833,-19.3412341333,14.9460062833,10.315183805,9.21325214167,49.2131212,-90.5801521167,43.7997931333,91.7249574167,-25.2027360167,-29.7146028,3.608954095,-0.927686022167,12.9212923667,2.165864835,5.48869576167,3.11641443667,-6.70294287167,20.9162664167,-25.1293199333,20.3651931333,18.6952536833,-7.24724182667,4.21471696333,-19.5458622667,-7.72435945833,1.75494496167,-1.018365275,-5.69940336833,-1.70655359167,0.508882755833,-1.66952583833,-3.247593085,1.71818199,-4.22458939167,7.324101365,2.83186068833,-4.69432842,3.44248787,-7.27464899667,-5.659545565,-0.940041115333,0.5147792755,0.237302768667,-0.4564573955,-2.04243241,-1.21270008667,0.114889168933,-1.67397501833,0.266269432833,-1.07844044167,-0.0535636597883,0.980675857833,0.223613123167,-0.870990615667,1.69377166167,-2.94345378833,-0.7764297055,-0.807295804,-0.7414404395,0.866480541,-0.7302376155,0.125892652983,-0.07521851205,-0.179233674167,-0.109090398167,0.07763243285,-0.560911479667,0.327170065833,-0.540987643833,0.259486101167,-0.0681762212667,-0.230507969667,0.195860023,0.573011050333,-0.718104624833,-0.155219003333,-0.175465556333,-0.1983259885,0.0838983608333,-0.507755047833,0.122064723833,-0.400505597833],[-39428.7508167,-1745.84644167,44.2636442333,-3489.42215667,1713.56352333,675.655812167,400.1282635,-1176.136865,379.716293333,737.243061167,-1072.841495,518.216336167,861.449674167,-729.260062333,206.6793395,25.0973877667,-58.5889358167,-182.066567,-347.4160035,376.3537375,-1.8488641,-126.367056667,-326.304699667,378.1594065,-158.832986333,-62.6581314833,224.2497525,-169.073540167,61.6159479333,20.7805200833,-13.0167037343,-94.8746134,-200.5740145,131.5571065,110.2842725,-36.2877687,-3.89727002167,116.116592167,-17.6093734,16.2303122333,11.21725805,10.3336571267,48.6012859,-90.7995268833,47.06938685,93.6930619333,-19.5686541167,-30.5936021,4.27166243833,0.172120678833,13.4281235667,2.715212845,5.54915818167,3.24774117833,-7.11672263667,21.2980877833,-24.2899399667,21.3282482,18.9246961833,-5.43086782833,4.19045508833,-20.2443046,-8.166791255,1.71618842333,-0.8018543015,-5.67342717,-1.61356834,0.5390229535,-1.64955023333,-3.38391749667,1.81636358667,-3.983180125,7.37309610667,2.86280592167,-4.285157865,3.49121854167,-7.46298510333,-5.58486082833,-1.010129419,0.868757385833,0.138889729583,-0.470694799167,-2.08757499333,-1.19303953167,0.152377165167,-1.66262554167,0.270509446667,-1.07553433,0.00549882989667,0.956741806167,0.2397859255,-0.878162734,1.70574157,-2.99742380833,-0.767648983,-0.776543381,-0.594662254833,0.902520021,-0.652820869167,0.0871325546333,-0.0945222184,-0.205134804167,-0.111711296333,0.0935660673833,-0.547289666833,0.352832637667,-0.5444646865,0.269091333667,-0.0764942737667,-0.204792794333,0.164387302167,0.577005599167,-0.719449793333,-0.138351623833,-0.164004994833,-0.160773925833,0.10078014255,-0.480802003833,0.122059994667,-0.4048154755],[-39462.6588167,-2145.87386667,-171.9727044,-3412.19463167,1758.43883833,666.6992075,512.343887,-1218.536325,404.881559167,715.228847167,-1077.54276167,590.671397167,879.097279667,-765.753070667,227.0008865,15.555407225,-64.6935878,-190.28628,-354.402679167,363.515589333,18.712248275,-105.83734655,-338.904405833,350.8620975,-156.210051167,-63.0971362333,231.135675667,-170.897567833,63.56153295,29.7959694167,-0.549885370667,-96.34473995,-215.432278667,147.91668,115.904691167,-33.4146571333,-2.1604133455,119.5672065,-15.6927046167,17.7824177,12.0419426167,11.6055767833,48.1940591833,-91.3696942667,50.7603729333,95.3743737833,-13.8710116033,-31.5094997,4.85505816833,1.35227387583,13.9480899667,3.34043436,5.72475909833,3.39137494167,-7.47379228,21.6815938667,-23.6155656833,22.42174375,19.1107404,-3.58630503,4.17930399333,-20.8733850333,-8.55212061333,1.639770855,-0.5671463755,-5.62991431333,-1.50191209833,0.599375190667,-1.63272929167,-3.49564802,1.89434005833,-3.767232625,7.42468551667,2.88160293333,-3.82038791667,3.53420650667,-7.606951605,-5.45583988167,-1.09631978667,1.2570274545,0.0373548526,-0.4873363445,-2.13300124167,-1.16818577667,0.195132399667,-1.65122010833,0.28305631,-1.08114818333,0.076988758545,0.926235894333,0.247090228667,-0.869226445667,1.71437085333,-3.03774559333,-0.749783559333,-0.74536307,-0.4271303735,0.942257438,-0.568219874167,0.0487413786833,-0.11673068885,-0.2342049275,-0.115445081833,0.108711075567,-0.531737286333,0.3811581675,-0.550073191333,0.284686944167,-0.08630530125,-0.1805704295,0.13422883,0.579495538333,-0.716176854667,-0.118818178567,-0.153022556167,-0.1157963505,0.119648955667,-0.450951017167,0.120676910167,-0.409463814],[-39461.8076667,-2582.237065,-410.366553833,-3351.51877333,1794.00376333,665.1712585,615.298799167,-1270.88289,428.48145,694.905945333,-1085.04037667,660.2144775,896.994110333,-811.637506833,232.920487333,7.33216339933,-69.8892988,-200.417258667,-365.126131333,348.628705667,37.1559314833,-90.43622265,-349.626410333,327.412796,-152.527147167,-63.5783486,238.064576167,-173.265519333,65.2792323667,38.3327994667,11.4567179823,-96.8748679667,-230.582623167,165.437797,120.5831415,-30.3515538167,-0.373936472,123.067734,-13.5572740833,19.5708153833,12.8002771167,12.9646830667,47.9467017833,-92.266503,54.7446455167,96.6934541167,-8.17359173833,-32.5594439667,5.36282338,2.59387629333,14.4853680333,4.03905666,6.01332259167,3.55971013833,-7.76993689833,22.0658523833,-23.0884059167,23.60732095,19.2184246333,-1.72634946267,4.13126356333,-21.4335573667,-8.88031555,1.52844437167,-0.320457517483,-5.56652205167,-1.375527695,0.690657653167,-1.61224069,-3.57929894,1.95749707167,-3.57155908167,7.47734481833,2.88281304333,-3.30858156833,3.55663179833,-7.70392051833,-5.28227587833,-1.192496645,1.675020395,-0.0670610045167,-0.506659311333,-2.177042485,-1.140120145,0.242888349333,-1.63866841667,0.304470240833,-1.09243831167,0.16003624155,0.891118754,0.246802604,-0.845644904667,1.71666398333,-3.06296518,-0.724871510333,-0.713179845833,-0.242256174267,0.9856322375,-0.4789296195,0.0109950733833,-0.141418984667,-0.265760674667,-0.120435750333,0.122982554333,-0.514766302667,0.411768883,-0.5571616215,0.3056086675,-0.0969937213,-0.157216110833,0.105602514267,0.580504562,-0.707925859167,-0.0973456195,-0.142128524833,-0.0645674065767,0.140323472667,-0.419144606,0.118107860833,-0.414428273833],[-39424.4767333,-3017.001145,-646.129458,-3315.31148,1823.404505,670.8829445,703.071218333,-1331.67669167,447.076964,674.914741167,-1094.90247,724.976237667,914.132278833,-867.1084225,225.856308,0.298181844,-74.8456919333,-212.849010833,-378.863989833,331.466919667,52.9340752833,-80.0384227167,-358.229317,307.570410667,-147.741179333,-64.2432840167,244.566271333,-175.9197775,66.57594085,46.3196039667,22.7395531,-96.5489273,-245.845297,183.601158,124.109081,-27.0939957,1.4242013545,126.511272333,-11.2221475233,21.5079806667,13.5073633,14.3413475333,47.8220586,-93.3999064667,58.8428474667,97.59627605,-2.541447615,-33.7859713,5.80735519833,3.88342582667,15.0431008333,4.79304842167,6.40267818667,3.76170788667,-8.009234435,22.4461512667,-22.6784562667,24.8386413167,19.2264059667,0.133943971,4.01414229167,-21.91676475,-9.15466799167,1.38597849833,-0.0620317192667,-5.47744027,-1.23936703833,0.813650039833,-1.58281537,-3.63480453,2.01057127,-3.39178992833,7.52971134167,2.864939705,-2.75891492333,3.54652283667,-7.74911592667,-5.074022355,-1.29513949333,2.11733674333,-0.1742524704,-0.527161714167,-2.21690396167,-1.10989913167,0.296016198833,-1.62418260833,0.334279292,-1.10632116333,0.252366919167,0.853860851333,0.240448647833,-0.809036779833,1.70955674833,-3.071598205,-0.694516924667,-0.6805963725,-0.0435363920667,1.03231899367,-0.3872509585,-0.02603622745,-0.168008225167,-0.299040840833,-0.1264485905,0.136540391333,-0.496885977167,0.444142421,-0.564958294667,0.330698965167,-0.107790890417,-0.134356948667,0.0786841629333,0.57994373,-0.694532644667,-0.0743786554167,-0.131276137667,-0.00821135075667,0.1625458045,-0.386222838833,0.114488322667,-0.419532227167],[-39347.6085,-3397.46493333,-858.121776167,-3307.439625,1851.996,683.047583333,770.359613667,-1392.593995,458.445362667,653.135680667,-1105.92457667,782.787767167,931.229219167,-933.0090575,206.978977,-5.507199544,-80.6466295833,-227.583255667,-395.073733833,311.938771667,65.2398880167,-74.5666288833,-364.089016667,291.2145285,-141.824717333,-65.2892550667,250.223639167,-178.672554667,67.18575105,53.6505173667,33.0187688833,-95.3035051167,-260.934966333,201.810020833,126.353095333,-23.6554801667,3.21609147333,129.778742333,-8.726454755,23.4721080667,14.1800920167,15.6650076667,47.7972564833,-94.65240305,62.8462872333,98.0624282667,2.96202869167,-35.2211392833,6.196764595,5.220404355,15.6185267833,5.58413059167,6.87624102167,4.00569877,-8.19225696667,22.8103941333,-22.35351225,26.0585047167,19.1239092,1.97879082733,3.79685323333,-22.31411195,-9.3739832,1.21631694,0.211098411017,-5.35782003667,-1.0957283465,0.971077911333,-1.5400198,-3.66089793167,2.0544776,-3.224758525,7.57753865667,2.82738722833,-2.18070318667,3.492353325,-7.73846176833,-4.83790460667,-1.401999195,2.57831021667,-0.283956469167,-0.547275463,-2.249814375,-1.07750969167,0.355939107667,-1.60710844667,0.3719838245,-1.12068019333,0.350988661,0.8166764925,0.228751837833,-0.761142618333,1.69005911667,-3.06231999167,-0.659338227667,-0.649108695667,0.165603333067,1.08194721167,-0.2956465145,-0.0623400304833,-0.196192821667,-0.333205782333,-0.133103583667,0.149725091333,-0.478542884333,0.477699277167,-0.572775316,0.358606715167,-0.117845455833,-0.1120358135,0.0535624667,0.577653430167,-0.675889172667,-0.0501514196167,-0.120850348,0.05209127329,0.186114786167,-0.3530924495,0.109851602,-0.424503814333],[-39223.4750333,-3708.40733833,-1034.43379033,-3318.31661,1876.867425,696.597486333,808.2625955,-1450.79631167,465.033068667,626.666267333,-1116.19870167,829.409393667,947.1636005,-1009.62617967,176.577671833,-9.18949488167,-87.9094955,-243.764814,-413.678630833,290.000615,73.2822086333,-74.2711587833,-366.041348667,277.785050667,-134.775171667,-66.5813394,254.888082,-181.410807333,67.0574055333,60.22265375,41.87334665,-92.8103762667,-275.680074167,219.5895165,127.330016167,-20.1271467167,5.087308415,132.7997345,-6.11999586667,25.421523,14.8231164667,16.8464288333,47.8977167167,-95.9543114,66.6344637167,98.1252536667,8.30441239167,-36.8538316167,6.51467427833,6.61657157167,16.2098865167,6.40202058167,7.436023055,4.28547951667,-8.30562131333,23.1443170333,-22.0960079833,27.2322522167,18.9152795167,3.80656724167,3.46643401,-22.6204876,-9.528936015,1.020354571,0.497942193833,-5.2080612,-0.9403719505,1.16881649317,-1.48505704333,-3.64876669,2.08547295667,-3.06888227667,7.61858132,2.770314895,-1.578026002,3.39155215,-7.67174548833,-4.575742755,-1.51005957833,3.05345908333,-0.395866204667,-0.567959963833,-2.27555368,-1.04124504167,0.424029874,-1.58756058667,0.418786426167,-1.13568836667,0.453385714833,0.781124135333,0.2110872375,-0.7025149945,1.65782634333,-3.03434391667,-0.6182813755,-0.620254268333,0.383092623833,1.13372092,-0.206724533833,-0.09779753185,-0.2263409955,-0.367811964833,-0.140028123333,0.162530646333,-0.4599688895,0.512077241667,-0.580617390333,0.388305973167,-0.126808166,-0.0908881921167,0.03039553543,0.573670357833,-0.651803701167,-0.0245083668983,-0.111497989333,0.11551190405,0.210757241333,-0.320620449,0.104129542883,-0.429020091333],[-39049.4544833,-3927.01551333,-1177.77177167,-3339.750345,1897.45650167,702.1878925,816.665796667,-1498.66024167,468.963562833,592.51309,-1124.26814667,863.6067415,962.219051667,-1097.12160667,137.314765967,-9.92271774333,-97.5370209,-260.449224667,-434.025747,265.801711167,76.2001721333,-78.3943432667,-363.299791,266.529095,-126.600948333,-68.0949465333,258.4335275,-184.0239875,66.1031400167,65.9072994833,49.1265064833,-88.8842854833,-289.957186833,236.590444833,127.088338,-16.6014651,7.10101973,135.4976545,-3.497136525,27.2805819167,15.4417071,17.82058625,48.1102157,-97.2472290667,70.1471876167,97.8298396167,13.43547118,-38.6427628167,6.7462801,8.08371077667,16.8122130833,7.22196573,8.07271780333,4.59726972,-8.34310156167,23.42790195,-21.8889265333,28.3395386167,18.60958645,5.60685784667,3.02612428,-22.8333755667,-9.61020447,0.800509502667,0.799450801667,-5.02906069,-0.770230026167,1.41105347167,-1.41813652,-3.594267315,2.100432705,-2.92175205,7.65187471667,2.69465883833,-0.957223414167,3.24824645667,-7.55155490167,-4.29023612667,-1.61449312,3.53671874667,-0.509215335667,-0.589381996,-2.29384934167,-0.998727006167,0.501875708167,-1.565417475,0.4744880585,-1.15090345167,0.557279465,0.748476350833,0.186686920833,-0.634091905333,1.61432749,-2.988014115,-0.571113865333,-0.5944859355,0.606292396,1.18649194167,-0.122509985,-0.1322973715,-0.2586643565,-0.402311633,-0.1465678945,0.175163519833,-0.441392858333,0.546743752333,-0.588288921167,0.418724163667,-0.134468253167,-0.0716692093,0.00930605542,0.568245248667,-0.622426869833,0.00239849102333,-0.1034695104,0.181022267167,0.2360900835,-0.289292499333,0.0972216048167,-0.432800243333],[-38837.5206167,-4040.83056,-1294.19171,-3365.53785167,1911.86271,694.002278,798.201880167,-1527.699175,472.936926833,547.950042667,-1128.41613833,885.725716833,976.713614667,-1195.552285,92.6612664833,-6.70765639617,-110.3040421,-277.007145667,-455.267733667,239.407468167,73.11518865,-85.9122460333,-355.617950667,256.5503125,-117.300062333,-69.7939813,260.6437545,-186.447042667,64.22543895,70.5074862,54.718777,-83.5830847667,-303.726877333,252.572434833,125.7027335,-13.1699533,9.31837165833,137.790039167,-0.964176141667,28.9813127167,16.0159297167,18.5476961833,48.37384495,-98.4888092667,73.3513867833,97.2382278167,18.2833479333,-40.5471157833,6.87725685833,9.634248615,17.42303425,8.020492555,8.777780675,4.93563374833,-8.30164396667,23.64029665,-21.7140244833,29.3634453,18.2185034667,7.36258783667,2.481805395,-22.9479279333,-9.60912913,0.559131917333,1.117129242,-4.82039572,-0.581178725667,1.70067810667,-1.337801735,-3.49634678667,2.09818318833,-2.779678415,7.67544300833,2.60034534333,-0.326417053833,3.06695052,-7.37943327167,-3.98572525667,-1.70998338333,4.02082023833,-0.623338631833,-0.611612342667,-2.30409781333,-0.947219405333,0.590540142,-1.539757235,0.538213003667,-1.16524613667,0.660778552,0.719304730667,0.154391295667,-0.557398663,1.56099314333,-2.92372211167,-0.518562121333,-0.571830732833,0.832038848167,1.23867941667,-0.0444040891,-0.165794900167,-0.293377442333,-0.436145845667,-0.151992206167,0.187797711833,-0.4228309015,0.581169039333,-0.5954334605,0.448826602833,-0.140739832167,-0.0551302850667,-0.00975530887,0.561602288833,-0.5879959845,0.030150134685,-0.09680669735,0.2475810335,0.261462112167,-0.259302699333,0.0891690267333,-0.435617608833],[-38621.71265,-4059.35230333,-1389.71647,-3395.09426,1919.08557333,671.417454,756.5338325,-1527.580915,480.128387,492.076808,-1125.93433833,896.066487167,990.198678333,-1304.138825,45.1356732883,1.97841481533,-126.635608833,-293.061038167,-476.7523655,210.5265625,63.3298450667,-95.8085172667,-343.401121833,247.127176333,-106.774456433,-71.6718522333,261.147977833,-188.663728833,61.33440555,73.7983592667,58.6984702833,-77.1948894,-316.961079667,267.440771167,123.215799667,-9.93506249833,11.78038465,139.572992,1.38205695333,30.4962199167,16.4968903667,19.0130884667,48.59251785,-99.66332185,76.2490385,96.4178789333,22.7435592167,-42.5219039167,6.88523274333,11.2814079733,18.0464062167,8.782175005,9.55234376,5.28696295833,-8.18262890667,23.7638668833,-21.557625,30.2853206833,17.7596865167,9.05127415,1.838214045,-22.9512321,-9.51441654167,0.297725457283,1.454316385,-4.57837517333,-0.367428178,2.03916030333,-1.24258716,-3.3572704,2.08022036667,-2.63727201,7.684094635,2.48787654167,0.307360649667,2.85093950333,-7.1555912,-3.66640818333,-1.79191699,4.49603529,-0.737349528833,-0.634524422667,-2.30537569333,-0.884039962,0.6897454175,-1.50877184833,0.608718029833,-1.177192535,0.7628735135,0.6933973895,0.11264899285,-0.473534576,1.498769885,-2.842194495,-0.461674723,-0.552207525167,1.05649007417,1.288373705,0.0271570020667,-0.198226437833,-0.330827487333,-0.4688894395,-0.155648221167,0.200358945667,-0.403960423,0.615039110167,-0.601686339,0.477641342167,-0.145563842833,-0.0421307084667,-0.0269278407833,0.553845325833,-0.548960816667,0.0582222909,-0.0913227824833,0.314140616833,0.286003013667,-0.230447887167,0.0801430561167,-0.437405018],[-38428.6404333,-4005.40979667,-1498.408305,-3432.29414667,1917.302445,627.9782615,693.730289667,-1483.81600333,491.867487,425.1310305,-1114.812795,894.4298895,1003.6600265,-1420.57889333,-3.87327624667,17.2403395405,-146.624434833,-308.161193333,-498.043659333,179.026410833,46.9174115333,-107.337433917,-327.271820333,237.618232333,-94.9686314333,-73.7512527833,259.646272,-190.696703833,57.3189699833,75.7533945833,61.1319377,-70.0887510833,-329.689753833,281.134369667,119.5996355,-6.99300525167,14.4878933167,140.757358667,3.45102288167,31.7853195,16.86883245,19.21837185,48.6543720833,-100.7948323,78.8341972167,95.41716435,26.7039391,-44.51115525,6.75175540333,13.0280240667,18.6878626,9.49362399333,10.3902586367,5.638723875,-7.98744197333,23.78069685,-21.41936365,31.0789663167,17.2548435167,10.651906105,1.10394885533,-22.82405605,-9.31593017833,0.0201112449667,1.81374013167,-4.29887432333,-0.124010362333,2.42445462333,-1.13335854667,-3.18083551,2.04921151167,-2.49129542667,7.66924242667,2.36098253833,0.941059825833,2.60282407667,-6.87839422833,-3.33724290333,-1.85685336167,4.95111852,-0.849261928333,-0.657566883667,-2.29685631167,-0.8070168405,0.7982918175,-1.47170448833,0.684229048,-1.18467141833,0.862913977667,0.669717534333,0.0606941550273,-0.3817959145,1.42800024833,-2.74427812333,-0.402388529333,-0.535684396,1.27530584167,1.33379130667,0.0923101344333,-0.229306527833,-0.371178075833,-0.5002935025,-0.1570158645,0.212741132167,-0.384696652167,0.6479424125,-0.606526327833,0.504438207167,-0.148884704667,-0.0335207469833,-0.0419475663333,0.544908825333,-0.506004622,0.0857190788,-0.0868461141667,0.3796383175,0.308939589,-0.2023164385,0.0702876832833,-0.438186634],[-38263.7218833,-3883.57679333,-1673.07859833,-3481.59485833,1909.22207167,557.299108,606.201553333,-1391.72433667,506.924755833,348.672566667,-1094.150115,881.240085333,1017.40954833,-1540.02994167,-53.4393182783,38.6288633667,-170.232592667,-322.2462755,-518.356318333,144.938266333,25.4938980033,-120.384244667,-307.761166,227.041431833,-82.2092216333,-76.2248767333,255.911949167,-192.483914,52.1322678167,76.6733198833,61.9271796833,-62.6091956833,-342.204757333,293.542966833,114.7939445,-4.44278195167,17.3350696167,141.285053833,5.16271448667,32.8119500333,17.1614119333,19.14022775,48.4720994333,-101.947382667,81.0478678,94.2542962,30.1035399167,-46.4905108833,6.481175555,14.84170985,19.3502416,10.12446299,11.2693548333,5.9844158,-7.72158159833,23.6848908,-21.30499105,31.7174245,16.7184048667,12.1617881167,0.283071295333,-22.55240745,-9.00585888833,-0.26131236105,2.19130403,-3.97877106333,0.1431691135,2.84615006333,-1.01385129017,-2.97071637667,2.011510655,-2.34244662667,7.62488145,2.22280497167,1.57844911117,2.32127489,-6.54587686833,-3.002613275,-1.90147807,5.374328705,-0.954572260667,-0.679671654,-2.27762026667,-0.716647314167,0.9134865105,-1.43001345833,0.762786794833,-1.18474996833,0.959546867333,0.6476048415,-0.00174966285756,-0.279964334,1.34797790833,-2.630972435,-0.3436499505,-0.521790002167,1.48333129167,1.37317005,0.151004325967,-0.258309191833,-0.413573673,-0.530213526,-0.155810419833,0.224936991333,-0.365588237,0.679059353333,-0.609365039,0.528586703,-0.150503008333,-0.0299369994333,-0.0543568329833,0.534668477167,-0.459846082167,0.1112584652,-0.0834117499667,0.442764491167,0.329615931167,-0.1748545575,0.0598551614,-0.437781154333],[-38118.3086333,-3701.667895,-1906.39150333,-3537.86220333,1898.87623333,461.5118555,496.3975145,-1258.42000333,525.14844,265.3605215,-1065.052855,858.125831667,1030.80987833,-1658.53815833,-104.28985045,65.0669634167,-196.9985165,-336.033052,-536.997173167,108.958838083,0.57021038,-135.374261833,-285.4521325,214.381410667,-69.0555198333,-79.22125775,249.740973667,-193.987825,46.00077075,76.8399910167,60.9742464167,-55.0717950167,-354.834993167,304.449736333,108.818452167,-2.39228225683,20.1917727,141.142717833,6.466031705,33.5760083333,17.4023500333,18.7891160333,47.9918869,-103.186743333,82.7937305,92.9477419333,32.9778313167,-48.4435543,6.088469495,16.67101415,20.0377329667,10.6531672,12.1586394167,6.31864285833,-7.37907963833,23.4813804167,-21.2185212833,32.17341075,16.1555286,13.6060208667,-0.618401217,-22.1356534,-8.59343931167,-0.531851184333,2.577306105,-3.618254465,0.426434134333,3.28882740167,-0.887449449667,-2.728611,1.97431715667,-2.190871135,7.54736670333,2.07367002667,2.22508145667,2.00603456,-6.15886146833,-2.67166774667,-1.92439933,5.758671465,-1.04870887,-0.700017086333,-2.247411005,-0.615042175333,1.03178321183,-1.38495122333,0.842361715333,-1.17497841,1.051888047,0.626951656833,-0.0745083887394,-0.1673427198,1.25841401833,-2.50289979333,-0.288842805667,-0.510589981333,1.67667608833,1.40580623333,0.2028376275,-0.284479634833,-0.456680805167,-0.5583633005,-0.152147688167,0.236919915,-0.3470709095,0.707329194333,-0.609768929167,0.549663596667,-0.150189616333,-0.0315050542667,-0.0642391828667,0.523078927,-0.41080894,0.133673637333,-0.0811809379,0.5021856515,0.347824719333,-0.148182529167,0.0490936579667,-0.4358893935],[-37975.1737667,-3489.322975,-2121.04471333,-3583.15040667,1887.62823833,350.888121,378.271735333,-1091.75834017,548.7412835,178.412782517,-1030.62231867,828.312829333,1044.34685667,-1772.90408333,-158.712166667,95.1912878833,-225.979392333,-350.764114833,-553.605209167,72.5529668,-26.6914970133,-152.796902667,-261.337609333,198.101563833,-56.23848865,-82.7044172833,241.047741333,-195.2764985,39.38000385,76.4556958167,58.3690012333,-47.86867915,-368.008706167,313.4712715,101.886945167,-0.9576708705,22.9508429167,140.378832667,7.33782359,34.1078257667,17.6200502333,18.2648324167,47.1713084667,-104.5656875,83.9414500833,91.55165705,35.4619161,-50.3165035333,5.59548669833,18.4587158167,20.7544727,11.0766296,13.0241543833,6.64238523667,-6.93641740833,23.1802376,-21.1477767667,32.4211260667,15.56620485,15.0363269333,-1.58087318767,-21.5741098833,-8.11359739667,-0.776704968667,2.95818137667,-3.22315235833,0.720278981167,3.73498284,-0.755050176333,-2.45510732,1.94388593333,-2.03021790333,7.4348502,1.91100996833,2.88660984333,1.65993022333,-5.71729155667,-2.36167837667,-1.92682827667,6.100610285,-1.12793067333,-0.7186013605,-2.20722875,-0.5052354885,1.14919521667,-1.337162745,0.9206395645,-1.15367245833,1.14089025167,0.607512132167,-0.156767631883,-0.0450297239667,1.15953646167,-2.35953867833,-0.241996190833,-0.502652311667,1.853010745,1.43114027,0.247805111333,-0.307205305667,-0.4991362865,-0.584285403833,-0.146506510667,0.2485509985,-0.3294925825,0.731569708667,-0.607324165833,0.567629213,-0.148026362167,-0.0376394676333,-0.0720876855667,0.5101734525,-0.358729521,0.1521843755,-0.0801255207833,0.556949811,0.363443508333,-0.1221965908,0.0383505478667,-0.431961042333],[-37814.4538167,-3302.19724,-2225.15803833,-3597.16254333,1872.38904333,237.638634333,268.821855333,-896.859203167,580.178869333,91.30437,-994.304335833,794.886898333,1058.40736833,-1878.68020167,-220.565971833,127.592258533,-255.898739167,-367.776456,-568.124086,36.96518267,-54.9644751667,-173.465248167,-236.723816333,176.209770667,-44.4873577333,-86.5514211333,229.746936167,-196.473006833,32.68752765,75.6913230833,54.21341155,-41.45233105,-382.2462775,320.144534833,94.2286411333,-0.2476252745,25.5119270333,139.0397665,7.76970157,34.4490504667,17.8317068667,17.6826187167,45.97147865,-106.145207333,84.3575563667,90.0998865667,37.7135791667,-52.0145987167,5.02448792,20.14497135,21.5024552,11.4012934,13.8388494333,6.95747007333,-6.36771625333,22.7951715,-21.0784081,32.4408077333,14.9390603333,16.5117808167,-2.5752647,-20.8522341,-7.60732576,-0.982041528833,3.31932932333,-2.799628605,1.02080135283,4.16810409833,-0.6158961385,-2.15088946833,1.92712420167,-1.852742625,7.287739485,1.72940915833,3.57028983667,1.28595464733,-5.21562841333,-2.09132678,-1.91140218667,6.39375529167,-1.18886388167,-0.735642818833,-2.15785158333,-0.3905082205,1.26137152167,-1.286711985,0.995355874667,-1.119075975,1.22801959667,0.589246416167,-0.247655756667,0.0863660068,1.05102093733,-2.19907851833,-0.206977517833,-0.4986742135,2.0094033,1.44781637167,0.286649184,-0.325883199167,-0.539612106167,-0.607398361667,-0.139516674,0.2594811395,-0.313131179333,0.750662873167,-0.601525833,0.582622357,-0.144224210833,-0.0474946695667,-0.0782114026167,0.495839286667,-0.3032606905,0.166175275167,-0.0799904588167,0.606178598833,0.376138320167,-0.09645340845,0.0281024797333,-0.425173071833],[-37622.86615,-3199.85017167,-2162.78616333,-3567.38950833,1847.93701,131.06222935,178.779394917,-681.298114333,620.735813167,7.56001206667,-957.972451,759.354377333,1072.663995,-1973.20278667,-293.458082167,161.193334833,-285.3365255,-387.733809167,-580.7948685,3.09612994667,-83.34883535,-198.389789667,-212.314906833,147.455054333,-34.3081244,-90.62363165,215.858748833,-197.711831833,26.2564422833,74.6176483667,48.5031045833,-36.0572020833,-397.899908,324.182994167,85.8686439333,-0.327801574833,27.7752121,137.155592833,7.773537695,34.6534893833,18.0356644167,17.1214716,44.3979651667,-107.983199,83.9611887667,88.5551298167,39.8290017,-53.4486752167,4.39064016333,21.6743515167,22.2743647333,11.6399832833,14.5890177833,7.263013535,-5.65489819667,22.3402412833,-21.00791265,32.2245455,14.25407595,18.0694191667,-3.57168253333,-19.9517929167,-7.10428892333,-1.13957486267,3.64852279667,-2.354085375,1.32478275667,4.57564901833,-0.470000404167,-1.81593570167,1.92794931333,-1.65482103833,7.10774926167,1.52445387833,4.28124499167,0.885788945333,-4.64671831667,-1.87353502,-1.880569355,6.63195894167,-1.22915162167,-0.751058489667,-2.09964898167,-0.2741124985,1.36447581833,-1.23375085833,1.06540268067,-1.07055661833,1.31455703,0.5719570145,-0.34598138,0.2273001154,0.931736150833,-2.01963032333,-0.186262898167,-0.4989756115,2.14289643167,1.45499730167,0.319958908833,-0.339878394333,-0.5769731535,-0.627156276167,-0.131840040833,0.269247716333,-0.298159346833,0.7639193205,-0.5921192805,0.595039141833,-0.139024269833,-0.0603753881167,-0.0824427070167,0.479680344167,-0.244138199,0.1752142665,-0.0804346828333,0.649080228833,0.385764321167,-0.0706694615333,0.018618503355,-0.414864020167],[-37398.7963,-3142.151285,-1969.50325833,-3505.49516667,1822.86807167,38.61989325,93.5353626683,-470.050115333,666.7434965,-70.1061021333,-917.982667333,720.380333667,1084.57067,-2059.33634667,-371.082730167,195.014213167,-313.756866667,-409.2941,-591.479196667,-28.3311783633,-111.7037883,-226.391851333,-186.3038225,113.090680333,-25.7589051,-95.0121671833,199.820777833,-198.8979725,20.44881875,73.1601806833,41.3563112,-31.1418838,-414.648186,325.7829805,76.4219300167,-1.109754675,29.6420979333,134.746048833,7.40168136167,34.8328500833,18.1850272,16.5465322,42.5799526167,-109.981892833,82.7766248667,86.7679707833,41.7398623667,-54.6113525,3.71568822,23.0146591667,23.0308598167,11.7896628167,15.2850157833,7.54553105833,-4.82538714833,21.8170964667,-20.9192806667,31.7947024167,13.4886214167,19.6771443667,-4.54471459667,-18.8896637667,-6.59056079667,-1.25182727167,3.94128999667,-1.89809887167,1.62038614,4.95172427667,-0.324023507333,-1.45265511,1.93641669667,-1.44001964,6.90131213,1.29887326667,5.01095287333,0.459850010833,-4.01404919,-1.69900236833,-1.83032667667,6.81656232833,-1.2498743,-0.763989795833,-2.03263710167,-0.15950889685,1.45657869667,-1.18059179167,1.13299445,-1.011621222,1.39932772667,0.5546809645,-0.448687342333,0.377665935333,0.8004914555,-1.82339009,-0.177037229,-0.500603951167,2.25257687,1.45301642333,0.3459808885,-0.349029146333,-0.610428417833,-0.6431017015,-0.123530750333,0.2775970565,-0.284763272333,0.771967748833,-0.579668347,0.605091174,-0.132978154,-0.0757623840667,-0.0841475066333,0.461287122167,-0.182070176667,0.179597361167,-0.0809311536333,0.685646624167,0.392276390167,-0.04606473755,0.00947969459483,-0.400818326167],[-37146.7151,-3076.97861167,-1711.71732333,-3430.00693167,1806.80848833,-34.3641999833,-8.28711157667,-289.1300135,713.381218833,-139.15932985,-869.349722,676.082671333,1091.61448833,-2140.583035,-445.3250665,228.2063025,-340.627979333,-430.584199167,-599.829610833,-56.7776788167,-139.977116167,-255.7789285,-156.6882655,75.09503405,-18.7345763333,-99.8059745,182.170538,-199.859028167,15.5851973333,71.17048275,33.0345661667,-26.1239290333,-431.972069167,325.331148333,65.4010539667,-2.46235058167,31.0139872167,131.822371,6.71937884833,35.1133129167,18.2006269833,15.93017415,40.6416968333,-112.014851667,80.8750008333,84.5538110833,43.3132370167,-55.51639195,3.01904763667,24.1377267833,23.72237625,11.8437286167,15.9458805,7.78512828833,-3.91515170333,21.2202917167,-20.7962066333,31.18483075,12.6172667,21.2764302333,-5.46781020333,-17.6867733333,-6.03814014833,-1.32521580833,4.19487617,-1.44443953167,1.89337696833,5.29254812167,-0.1854833047,-1.066032795,1.93903948333,-1.21446814217,6.67557624833,1.05672739883,5.74484134167,0.0101369983333,-3.322702205,-1.55235187833,-1.75553426,6.94835533167,-1.253003705,-0.773415395333,-1.95646889333,-0.0502219155,1.535857355,-1.12951474167,1.20021913167,-0.946560096333,1.480703025,0.536105306667,-0.552168778833,0.536871979667,0.656728821,-1.61371876333,-0.175620923333,-0.499782504833,2.336990885,1.44224699,0.363023834167,-0.353205008167,-0.639264746167,-0.654748320333,-0.114437148833,0.284162359667,-0.272974464167,0.775627436833,-0.564756555167,0.6130756715,-0.126737294667,-0.0931397040833,-0.0826530595333,0.440392826167,-0.118273023083,0.179528588167,-0.0807681089667,0.7158722975,0.395519616333,-0.0239243326767,0.000202497192667,-0.383032282167],[-36870.8768167,-2994.77827833,-1427.73106333,-3351.82223667,1802.65506667,-83.28716425,-130.816675165,-148.662944617,757.203733667,-197.176172833,-809.5481895,627.375872833,1094.28565167,-2217.51014167,-513.572898,259.680742167,-365.159614833,-450.186740167,-605.814284333,-81.82885775,-167.543464,-285.739592833,-123.188072667,34.922445175,-13.241853865,-105.036152383,163.533638667,-200.623900167,11.8109421417,68.4957650667,24.0293062,-20.8330686667,-449.500643833,323.1786965,52.7847863167,-4.25833603667,31.7883417,128.4454685,5.78615380333,35.5837372833,17.9725270833,15.3612089667,38.6962362167,-113.996290333,78.3157900667,81.8532207333,44.5044081333,-56.1703324833,2.32681288167,25.01344105,24.300303,11.8103934167,16.5904272833,7.95501209167,-2.948987895,20.5635127167,-20.6270834833,30.4255368333,11.6220796,22.8316445833,-6.30918869167,-16.3583795833,-5.447863145,-1.36451382167,4.40687579333,-1.01007872817,2.132331865,5.59641081167,-0.0611657323167,-0.667368834,1.92522049167,-0.983386955,6.437347005,0.796381669333,6.46700600167,-0.457693709167,-2.57568289667,-1.42822921,-1.66106681,7.02756056667,-1.2407831,-0.778099281667,-1.871698965,0.0495348534167,1.60075772667,-1.08194158333,1.26663777167,-0.880639941833,1.55762953333,0.5154804675,-0.654285488667,0.702072527833,0.501086760667,-1.39322582667,-0.179794430833,-0.496388663667,2.39434754333,1.42362378667,0.372330827167,-0.3524369485,-0.662732222167,-0.661402700167,-0.10472908085,0.288478835833,-0.262602437,0.775578846667,-0.548276426,0.619393529667,-0.120724807667,-0.111891565567,-0.0779050008833,0.416908920333,-0.0539314075833,0.175385078,-0.0796971829167,0.739596970333,0.395500707167,-0.00433404014,-0.00895455025517,-0.361910249167],[-36575.53285,-2900.09630167,-1147.7698995,-3268.79421333,1809.866625,-107.8594009,-257.506021833,-43.4356125833,797.425423667,-243.083523833,-738.7448055,579.266204667,1095.86500833,-2288.40823,-577.636431833,288.003980333,-386.953674833,-466.9510205,-609.382835333,-103.187784483,-193.352909833,-316.1779105,-86.6815443167,-7.07478846667,-9.54271830667,-110.770841333,144.704909167,-201.375647833,9.04107453167,64.9885639,14.97968247,-15.2724118033,-467.179688333,319.5845355,39.2222390667,-6.40196088833,31.8770156333,124.733508167,4.64373645833,36.2620503833,17.3844962333,15.0164796667,36.9108722,-115.887433167,75.1340012333,78.8159054167,45.3698958167,-56.6005724667,1.67539497167,25.6180201333,24.7127749167,11.7042210333,17.22968185,8.03100554333,-1.94085248767,19.8874034167,-20.39728185,29.5447520333,10.5113402083,24.3315098167,-7.04445237333,-14.9159393167,-4.84721976167,-1.37011200833,4.576019845,-0.618379126667,2.32702556667,5.864112285,0.0443917702333,-0.271720714,1.88630023,-0.748981296667,6.19541497,0.512139902333,7.15924408833,-0.937625479667,-1.772767992,-1.32977378833,-1.561117205,7.055853715,-1.2151471,-0.7767529485,-1.78010861167,0.134944851567,1.65107025,-1.0387602315,1.33005242333,-0.82094669,1.62943174167,0.4933804195,-0.754782071833,0.867516554833,0.3351539815,-1.1624830285,-0.187955783,-0.494126694,2.423659335,1.39822946833,0.377266334,-0.346921459667,-0.680098185167,-0.662036327167,-0.0947856913,0.290305569667,-0.253531572833,0.772289593667,-0.531675707167,0.624321147167,-0.114987103833,-0.131489699667,-0.07050640795,0.391048429167,0.0103803144167,0.167969967833,-0.0782658196667,0.7568833055,0.392216820667,0.0133723638567,-0.0168910358783,-0.3380379495],[-36269.4798,-2791.90473667,-891.125544667,-3181.81644833,1829.343015,-107.762590383,-376.455965333,25.2187163,832.564065833,-275.774031,-657.985328,535.578360667,1097.489065,-2349.69187833,-637.410059667,311.907421667,-405.5625405,-480.1956825,-610.283904333,-120.686256333,-216.002223167,-346.554007667,-48.3557746917,-50.8336165083,-7.78144915667,-117.0041285,126.305826833,-202.191780333,7.28530475333,60.5311326167,6.425876315,-9.53410593667,-484.935219667,314.865914333,25.3556200333,-8.77902446833,31.2143632333,120.789080333,3.32512839833,37.1906537,16.3206005667,15.0067184167,35.4303895167,-117.627342833,71.414264,75.5747773333,45.9502556333,-56.82943795,1.09949589483,25.9267073333,24.92282125,11.5324187667,17.8736496333,7.98779035,-0.913834497167,19.2353420667,-20.0844474333,28.5799568833,9.29094515333,25.7591193167,-7.648957465,-13.3734390667,-4.25471890167,-1.34358384333,4.69896145333,-0.287283826233,2.46842090833,6.09459603667,0.127302949317,0.107024368167,1.81891163,-0.511932823667,5.95851166,0.197755939833,7.803312825,-1.420782526,-0.916951442967,-1.25740079333,-1.465446665,7.03380267333,-1.17856064333,-0.768493,-1.68332214167,0.202252239833,1.68600806667,-1.0001988435,1.38868989667,-0.772867930833,1.69508573167,0.469968372167,-0.853447985333,1.02779251167,0.1617652389,-0.9223634795,-0.198231518333,-0.495069784333,2.42422213,1.36590302667,0.3808509155,-0.337043589167,-0.6905723555,-0.6559054555,-0.0848580860667,0.289305552833,-0.245514417333,0.766267168,-0.5162714555,0.627854312167,-0.109747639333,-0.151268274,-0.0609686993,0.363138660333,0.07414822625,0.158113492167,-0.0767375049667,0.767894507833,0.385200941667,0.0298871616333,-0.0225106451,-0.311903843833],[-35954.5659167,-2684.49164333,-682.408731667,-3095.84404667,1859.11069833,-85.4664724667,-493.134673667,54.5634080167,860.843046833,-294.855991833,-567.265709167,495.026126833,1098.27165333,-2398.887255,-689.999494,331.223623833,-420.450464667,-489.238936833,-607.948004667,-134.590439833,-235.114965,-375.936964167,-8.99983666667,-96.8042365167,-7.72547814,-123.498106667,108.6131361,-202.792880333,6.51320993833,54.8426695,-1.475972955,-3.629926965,-502.683886167,309.2592365,11.5157554017,-11.287906835,29.83586185,116.643652833,1.881675385,38.39725925,14.7050149833,15.30751805,34.3262788,-119.168447,67.2872357833,72.1506176,46.2311962333,-56.869876,0.603854451833,25.9324498167,24.9232601833,11.2976081,18.53098445,7.82019031333,0.114837464667,18.6304794167,-19.6736163667,27.5737651,7.96417693,27.0860804333,-8.11368842833,-11.7378985333,-3.66296956833,-1.29185146833,4.77110559333,-0.0222123712667,2.554774875,6.290159435,0.189516353833,0.464786360167,1.72644819833,-0.271171414733,5.73334028,-0.149287107333,8.38604922833,-1.89873263333,-0.0148023367,-1.20347995833,-1.37519020333,6.96126361833,-1.133861155,-0.7541732355,-1.583252115,0.250511184167,1.70604083833,-0.964647162,1.44183444667,-0.738014135167,1.754509165,0.4455617825,-0.949843825667,1.17965549667,-0.0151612832333,-0.6732590925,-0.208054062333,-0.499048983167,2.39715947,1.32532061667,0.384141849333,-0.323365707333,-0.694040763833,-0.6431466995,-0.0753589282333,0.285151585667,-0.2381012615,0.757836439167,-0.5029543925,0.630035699833,-0.105116401333,-0.1704781515,-0.0497754682333,0.333605207167,0.137235306333,0.1467024535,-0.0753782835833,0.773121390333,0.3739457165,0.0456429470167,-0.0254257923333,-0.283747759333],[-35640.8401167,-2602.524285,-534.400616,-3017.49067,1893.35038667,-43.7796243833,-610.899158,44.98820534,880.672018,-301.340219333,-467.3566155,456.470540667,1097.84135833,-2433.74872333,-732.884477667,346.156526667,-431.401147333,-493.779600833,-601.671185333,-145.1069055,-250.523190667,-403.758301333,30.4974708917,-145.46144065,-9.03476978167,-130.007265833,91.7452057167,-202.898569,6.65977751667,47.6336099333,-8.803431275,2.35379835833,-520.279484,302.9493175,-1.95850974333,-13.8319097333,27.8061319833,112.309993333,0.33069088,39.8795230833,12.4856194467,15.8340633167,33.6219685,-120.4616365,62.88841745,68.5771226167,46.196388,-56.7362257,0.184781863833,25.6377614833,24.7201705667,10.9942168333,19.2011826,7.53071604,1.12796145183,18.0856171667,-19.1560472833,26.5680355,6.54867886667,28.2871299167,-8.43929238,-10.01771593,-3.06142054833,-1.22290285,4.78951905667,0.176756460933,2.586736735,6.45254199667,0.234652791667,0.800704665167,1.61461264667,-0.0279084642667,5.52584584167,-0.527492480833,8.897840315,-2.365733215,0.9237435657,-1.160044565,-1.28988,6.83860183,-1.083739865,-0.734656893333,-1.48154864333,0.280237424333,1.712091575,-0.930079866667,1.48914892167,-0.7163830045,1.80690510333,0.420561771833,-1.04335952167,1.321166315,-0.192159422267,-0.416218779833,-0.2152419385,-0.505730882833,2.34459861333,1.27504695833,0.387477506667,-0.306447015667,-0.690541299833,-0.624151144167,-0.0665045290167,0.2776770365,-0.230840991167,0.747207039667,-0.492294647,0.630748834167,-0.101142045217,-0.188569993333,-0.0371941511,0.302777676833,0.1994003065,0.134469743167,-0.0746470601333,0.773352393833,0.358103343833,0.0609152219667,-0.0254804193333,-0.253738630667],[-35323.1062167,-2574.33131833,-443.189177167,-2953.44346167,1924.33986,12.2020061,-724.893562167,3.43631076,889.193929333,-297.143037667,-361.423165167,419.904891333,1098.12292667,-2452.3797,-763.434992167,356.461029667,-438.548260667,-494.1991915,-590.975457667,-151.979584,-261.887333333,-429.210583833,69.04409185,-197.024723,-11.4332862067,-136.374669167,75.73522485,-202.366734,7.65320025167,38.7724982,-15.5407735317,8.203504085,-537.490196667,295.993191833,-14.7124043317,-16.30325655,25.1806683167,107.815068833,-1.33872826167,41.5903742333,9.6624188,16.5163714,33.29273835,-121.4574065,58.29805905,64.9085101833,45.8386417667,-56.42672575,-0.151553854333,25.0488234667,24.3313318,10.6169206833,19.8658061,7.12839777833,2.10542524,17.60479835,-18.5290626167,25.5854738667,5.07591915833,29.3409324167,-8.62499301667,-8.222662195,-2.450800395,-1.14141272667,4.75364993667,0.312681007333,2.56686331667,6.57990133167,0.265189479833,1.11104398483,1.490484615,0.2147063901,5.33765636167,-0.930965584167,9.33043525333,-2.81678131833,1.88673073683,-1.124742725,-1.21017506333,6.66719759833,-1.03040261833,-0.710152939333,-1.37963394833,0.292500529667,1.705119945,-0.895152664,1.52923413,-0.706589278333,1.85109769667,0.394943962833,-1.13272265,1.45073608667,-0.366141198833,-0.153072672833,-0.219474283333,-0.515347488,2.26915629833,1.21416570333,0.390880245667,-0.286965299333,-0.680038594667,-0.599432893833,-0.0584441850333,0.267031947167,-0.223417667,0.7343668555,-0.484426467,0.629833079667,-0.0977365529333,-0.205094732333,-0.0234322154467,0.2709502555,0.260148525167,0.121654481833,-0.0751976067667,0.769430504167,0.337641147,0.07588590275,-0.0226418862,-0.222026521],[-34982.7692833,-2635.02098667,-411.574911333,-2913.11438,1941.03859833,72.4836624667,-829.188888,-54.56100471,881.515943667,-284.263439333,-253.443697,385.893420333,1103.17525667,-2452.02234833,-779.6249115,361.506646333,-441.949043,-491.113147,-575.8163185,-154.959578,-268.631443833,-451.132201333,105.18600525,-251.232005333,-14.63033055,-142.510324,60.5880302833,-201.148276167,9.33256883167,28.3403867667,-21.49592895,13.5968202717,-554.074553833,288.412196667,-26.4905088833,-18.5735086,21.9946594667,103.189627317,-3.12243408833,43.4425407167,6.269205025,17.3221754833,33.2737864167,-122.112691333,53.5642547667,61.20017285,45.13009425,-55.9177637,-0.390283078333,24.1732950833,23.7757211667,10.167834855,20.4983749,6.62388321333,3.024141755,17.19140685,-17.8012572667,24.62949895,3.57635935333,30.2152567,-8.66694176833,-6.356551155,-1.83662755833,-1.04991676517,4.66454113667,0.390014338167,2.49908225167,6.66944776167,0.2823897665,1.386243765,1.36210480667,0.452009168667,5.16485219,-1.35011593567,9.67627181167,-3.24455642833,2.86559240833,-1.098114595,-1.13817014667,6.446457375,-0.975918813167,-0.680280699667,-1.2785381,0.288128722167,1.68583482167,-0.859292217,1.55921147167,-0.706443933667,1.88655795833,0.368206057833,-1.21605617667,1.56706953667,-0.534171967667,0.114009824,-0.221864362333,-0.528990590167,2.17272996667,1.14209819333,0.394935276833,-0.265679361333,-0.662437262833,-0.569533548667,-0.0515211005333,0.2534896405,-0.215562766167,0.719246165167,-0.479150477,0.6272735825,-0.09461676445,-0.21965326,-0.00856710558167,0.2385363245,0.3189053945,0.10808058845,-0.0776377095333,0.761899137333,0.312714020833,0.0908780059333,-0.0168944856733,-0.188915467167],[-34634.6103833,-2798.26988167,-437.245704667,-2903.84972333,1935.98879167,129.3240866,-923.918267,-121.312747067,855.325016333,-265.534923,-146.720019017,354.020177167,1114.649755,-2429.80356,-779.494044667,361.1863725,-442.191960833,-485.220980167,-556.437360833,-154.131336333,-270.092075833,-468.255127333,137.66958,-307.995259833,-18.3594338667,-148.401196167,46.31645375,-199.1282515,11.623535425,16.5650746633,-26.5853798,18.2942624833,-570.083605167,280.1892805,-36.9524863333,-20.5501823333,18.3310577,98.4824377167,-4.97574345,45.3713093167,2.33874704667,18.1528837667,33.4911190667,-122.440308833,48.7059681333,57.5820709333,44.10310625,-55.2242528667,-0.519706184833,23.0409448667,23.073074,9.64862539333,21.0717456833,6.01966552167,3.84818558167,16.8448200833,-16.9856283667,23.6960991167,2.08779758317,30.9035020833,-8.580898515,-4.44168546833,-1.2278588315,-0.949815393833,4.524490885,0.412435463667,2.38486081,6.71754785167,0.285665854667,1.61820188667,1.23481532333,0.681920174,5.00520316,-1.77569402833,9.93701645,-3.64431993333,3.84673588667,-1.08197703167,-1.07365387667,6.17936719833,-0.922329658833,-0.645872080667,-1.17961750333,0.2677201155,1.65500831667,-0.822156049,1.57823469,-0.714059291,1.91350831333,0.341341379833,-1.292900085,1.66989351167,-0.693991913833,0.3815861665,-0.2240583595,-0.546880063,2.05863783667,1.058769322,0.399690673167,-0.2434592135,-0.638036762333,-0.535064982333,-0.0458737908167,0.237567825,-0.206849200833,0.702240692333,-0.476111681667,0.622896871667,-0.0912455675,-0.232214207,0.00732204419,0.2060446125,0.3754278735,0.0934705668,-0.0821545861667,0.751484620333,0.283632131,0.105835406833,-0.00820490575667,-0.154714652833],[-34315.6878167,-3027.65455167,-548.617276167,-2925.462575,1908.53886833,173.270001,-1010.8912675,-206.764100667,813.52967,-244.935464,-43.66782255,323.167829,1129.69211667,-2388.40514667,-765.858107167,356.656851167,-440.543298167,-476.856108833,-533.5904325,-150.301164667,-266.608772667,-481.090293333,165.9930295,-365.664493833,-22.2839587667,-154.0907135,33.0576273,-196.3656565,14.40539835,3.696632665,-31.0710284167,22.3872289167,-585.353589167,271.825983667,-45.8474618,-22.1978421667,14.3367493333,93.7710898833,-6.87465502833,47.34786525,-2.05378776,18.8867712333,33.9686071333,-122.521480833,43.8739217833,54.1506213333,42.7902447,-54.5229451667,-0.5531129465,21.7157743667,22.2468124833,9.06498698833,21.5826321667,5.322265635,4.55196870167,16.5774517167,-16.1315746167,22.7959306667,0.634377436667,31.4108011333,-8.434704755,-2.52238177667,-0.620005649425,-0.847675323833,4.343475665,0.384044277833,2.228677125,6.72915512333,0.272178975333,1.805789255,1.11043283783,0.895582777,4.85760774167,-2.20476594667,10.12206089,-4.02060909167,4.81396172333,-1.07140497167,-1.01592907483,5.87654924667,-0.871863241667,-0.60802494,-1.08435312017,0.233334974667,1.61527047333,-0.784220175333,1.58819990833,-0.729959989667,1.932258465,0.316134579333,-1.36496381667,1.76176549,-0.8440166065,0.648013629,-0.225564939667,-0.568426302667,1.93187759167,0.967423148333,0.405149271667,-0.220990381,-0.607969992167,-0.496889527667,-0.0411383278167,0.219798127333,-0.196901687833,0.684371678167,-0.4755714715,0.616943078,-0.0867879175,-0.243246385167,0.024818622405,0.174070893833,0.430522685,0.0779559726333,-0.0884100966833,0.738869374833,0.2518106,0.120577028333,0.00342262820667,-0.120475045733],[-34064.25135,-3275.23391167,-759.697824333,-2971.56142,1859.34493,196.946333833,-1085.78114333,-325.3646,761.171135333,-226.781031167,52.58652055,293.343609333,1144.309635,-2332.32988,-744.2012255,349.330129833,-438.442931833,-466.646325667,-508.194080167,-144.379122,-258.959335167,-490.920349333,189.508187,-421.9297625,-26.1136469,-159.642397667,20.92015643,-193.052184333,17.5817530667,-10.0373790733,-35.2932172,25.9596167,-599.511010333,263.984792,-52.8920572,-23.5103721167,10.1683773733,89.1401191333,-8.822729685,49.3610875667,-6.81258855667,19.4194303167,34.7449155,-122.419692333,39.2738652833,51.0006688667,41.2271384833,-54.0334035333,-0.511583510833,20.2683978167,21.3246081833,8.42244886167,22.0336039667,4.54500140833,5.11807637167,16.40538465,-15.2957040833,21.9477388833,-0.7625858275,31.74199115,-8.313448995,-0.648549666667,-0.00765294253333,-0.750786260667,4.13359673,0.310404746833,2.03655668,6.71009869,0.240006059,1.94963552667,0.990265566833,1.080609208,4.72113511333,-2.63572421333,10.2405852333,-4.38187409167,5.74897108333,-1.05983787167,-0.9650510075,5.54983202,-0.8263567945,-0.567614858667,-0.993911477833,0.187691439167,1.56908836,-0.746045885333,1.59127955333,-0.755191496667,1.94228416667,0.294114456167,-1.43411990333,1.84546592333,-0.983172295167,0.911456151667,-0.225008649333,-0.592923489667,1.797772905,0.872043109667,0.411501316,-0.198767855333,-0.573493435,-0.455889429,-0.0367440263667,0.200571350333,-0.185450031667,0.666660975,-0.477868717333,0.609593766167,-0.0805171402333,-0.253225320167,0.0446983530167,0.143208699333,0.484991822667,0.0618839909167,-0.0958384764167,0.724740799167,0.218955805833,0.134901330167,0.0180208524033,-0.0874212086167],[-33914.4983,-3505.38741667,-1024.73274683,-3028.21984167,1785.947685,199.260973333,-1131.07632833,-486.6682095,704.281109167,-215.932499,136.94716635,265.8926655,1155.86815,-2266.18239,-722.554184667,340.305844667,-437.383566,-455.796743833,-481.760971333,-136.946985,-248.0850305,-499.196367,206.6560035,-474.272208333,-29.6663527167,-165.105777167,10.0291812295,-189.593183833,21.1086410833,-24.453550955,-39.3980762,28.8854878,-611.9847765,257.248808333,-57.5498656833,-24.4782230167,5.98934479833,84.7014330833,-10.8328406217,51.3985169333,-11.843254485,19.71493,35.8477959,-122.135837833,35.1015263333,48.2868960833,39.5046657,-53.9514726167,-0.408876158667,18.7711414167,20.33518775,7.73699211333,22.4230615,3.70221603,5.53407794333,16.3474159167,-14.5221879167,21.1683877,-2.07553338267,31.9103390833,-8.29879705833,1.13056395167,0.596666585575,-0.665477806333,3.90769912,0.19532410445,1.816858455,6.66446405333,0.187869246,2.04749734333,0.87495488,1.22557435333,4.594349035,-3.066636065,10.2987311167,-4.73623074,6.63076870333,-1.044839285,-0.925862344667,5.210212025,-0.787957876833,-0.525268231833,-0.909561925167,0.133385258967,1.51843032667,-0.707913571833,1.58878890167,-0.7913445615,1.94255314667,0.276568286667,-1.50143613167,1.92219844833,-1.11033872717,1.16877113433,-0.220612641833,-0.621006748667,1.661831235,0.776318225667,0.419940629833,-0.1773650125,-0.5358374595,-0.412710449833,-0.03214645945,0.180203534167,-0.172180892167,0.650098923167,-0.48326823,0.600810843333,-0.0718312594167,-0.262249962,0.0675793634167,0.114096470233,0.5391127215,0.0460346694333,-0.103919436867,0.709928714333,0.186776034333,0.148865061333,0.03588687145,-0.05665878805],[-33898.3504,-3690.28645333,-1263.16539,-3086.45321333,1682.68338333,185.047413833,-1122.223615,-692.594959167,646.5635575,-218.274407333,204.734967833,242.713452,1163.96991833,-2195.04040167,-707.5896045,330.277874833,-439.163052167,-445.4662865,-456.143098667,-128.261898,-234.994083333,-506.583167167,215.905369167,-519.783456,-32.6985456333,-170.602323833,0.499054778,-186.525830667,24.8794259833,-39.3379560167,-43.302371,31.02226095,-621.963698167,251.987858667,-59.2381578167,-25.0386190667,1.95397214167,80.5460858667,-12.9374545167,53.3957620667,-17.0451562,19.7646867333,37.2760857667,-121.6073435,31.4809649333,46.1807338667,37.7283439333,-54.4106102167,-0.245367808467,17.29988375,19.2993904833,7.02618899333,22.73530515,2.801837925,5.77986580333,16.4083446667,-13.8438320333,20.4556647333,-3.26592124833,31.9266467,-8.45030572167,2.765530925,1.16579502933,-0.597136417333,3.68179002,0.0414230109667,1.57928724,6.59508779,0.111387848303,2.09185753,0.762087203833,1.32019949,4.47288721833,-3.49163748,10.2992218,-5.08599383167,7.4358836,-1.02840059667,-0.906652196333,4.86963148667,-0.759453672833,-0.480550026667,-0.832268848,0.0732362413617,1.46575698667,-0.670475322667,1.58061130167,-0.840114476833,1.931640205,0.2648748415,-1.56714729,1.99192095167,-1.22346494333,1.41573120333,-0.210918009667,-0.654820625833,1.53001488667,0.684186057,0.431495970833,-0.157666666833,-0.496108863167,-0.3677147,-0.0267472006667,0.159262222833,-0.156635885,0.6355681675,-0.491805426167,0.590280318667,-0.05994830735,-0.270440130167,0.0938926174333,0.08738355025,0.592674939667,0.0314160176833,-0.112548808167,0.695210481167,0.157106212667,0.1624656445,0.0571917367833,-0.0292275575167],[-34035.6550833,-3818.00787,-1449.15401333,-3145.015215,1543.97947833,155.127195833,-1051.58445983,-937.727407333,588.951948,-238.142988833,254.501973833,222.734291833,1170.03239333,-2120.64419,-701.975277667,319.584398,-444.959171833,-435.520748,-432.832631833,-118.330646833,-219.757485,-512.7882855,216.660717833,-556.525691667,-34.9143818333,-176.137185,-7.3886142505,-184.082418333,28.75120415,-54.3799883667,-46.8547262,32.43426205,-628.879491,248.274335833,-57.5165895333,-25.0944139333,-1.795171555,76.7243065167,-15.1010275167,55.25815075,-22.3506596167,19.5421399667,39.0248542,-120.783236833,28.4275598333,44.8244433333,35.9835582167,-55.4734897,-0.0147583950333,15.9154801833,18.2145484167,6.31003552167,22.9472358333,1.83307538667,5.83249256667,16.5790017667,-13.27546925,19.7828170833,-4.29004174167,31.7995358833,-8.79878473833,4.21875215167,1.67905025667,-0.550632109,3.467295465,-0.153590476383,1.33085988833,6.50427482667,0.00218725804667,2.07598747,0.6463324495,1.36188724167,4.34981320833,-3.901697915,10.2459025333,-5.42663200167,8.14556442833,-1.01232574283,-0.913404828667,4.537473365,-0.743790433833,-0.433539340167,-0.763341579667,0.00904465684667,1.41389205333,-0.6345138055,1.56652560667,-0.9031793725,1.90968239,0.260665833667,-1.63100765,2.054614695,-1.31967881333,1.649193015,-0.1955540765,-0.696424352667,1.407080875,0.5986951105,0.446452625167,-0.140717990167,-0.455229952833,-0.321047130167,-0.0202788217,0.138487918,-0.138112412667,0.6237416285,-0.503438475167,0.5778057995,-0.04385894165,-0.2779757105,0.123740860617,0.0636018528833,0.645515849667,0.018628924165,-0.122109251833,0.681035882,0.131385060333,0.175630023667,0.0818859120667,-0.00591493736667],[-34298.1629833,-3902.26953167,-1644.22211167,-3201.77188167,1372.09343167,110.729195383,-948.799689333,-1212.71080017,532.412469167,-274.932602333,292.527048,201.560817333,1175.60544333,-2038.10771667,-700.798684,308.653359,-454.445579667,-424.232677833,-411.160984833,-106.531633933,-201.109908,-516.875924833,211.019772,-584.935595667,-36.2326300333,-181.445775,-13.5409122067,-181.733663167,32.9217025,-69.1894854667,-50.2049233833,33.5866595667,-632.655861833,245.7842315,-52.5108619333,-24.6780913667,-5.14217469,73.1556294167,-17.2334154667,56.9857733667,-27.7239103,18.9714366833,41.0310041167,-119.570874167,25.8542968,44.2797556833,34.2530577333,-57.11814135,0.265091720033,14.64355805,17.0635364,5.58367951,23.0500797,0.784251228167,5.70818393833,16.8100812667,-12.7764666667,19.1232714,-5.09016569333,31.5337016,-9.34807948667,5.47725690167,2.16901723167,-0.526838879167,3.263482565,-0.388487339833,1.0733735325,6.39118267,-0.143782094197,2.01376012333,0.518882965,1.36188345167,4.220878345,-4.27760666667,10.14965615,-5.75604257833,8.75176863,-0.985993529,-0.935091010333,4.21787016,-0.7404770975,-0.386770404667,-0.7033740765,-0.0567810885717,1.36344503667,-0.600429033,1.54872101833,-0.97980719,1.877932365,0.264000104833,-1.691144685,2.112157585,-1.39804705333,1.86654154667,-0.174903787333,-0.7428767485,1.29576061833,0.519851587167,0.461344960667,-0.126809534667,-0.414108814667,-0.273173542,-0.0125704836583,0.1182455674,-0.116307577217,0.6141974035,-0.5177008515,0.563175228833,-0.0235100906138,-0.285190013667,0.156608903667,0.04309608165,0.697219182833,0.007163355055,-0.13304564,0.668150273833,0.109815584883,0.187215470333,0.1089060673,0.0134769627833],[-34639.4959833,-3941.34401,-1888.86682667,-3250.06588167,1176.075701,57.7687735167,-846.622693333,-1511.44738333,478.714985333,-327.255017,325.804353,174.890525333,1180.54778833,-1943.84157167,-697.114998833,297.979099167,-467.380632,-410.2955995,-390.064505667,-92.1015640167,-178.64634,-517.638104667,201.811068333,-605.514511,-36.7054689333,-186.295811667,-18.15098735,-178.914674667,37.74687555,-83.5045602333,-53.4903515,35.01047355,-633.070323,244.155575167,-44.59916045,-23.8898125667,-7.98865665333,69.7164892,-19.2817436667,58.61263345,-33.11390995,17.9925469333,43.2161001,-117.822909,23.6841739833,44.5470915667,32.4650243333,-59.3185340333,0.568329079167,13.5044348667,15.8415971667,4.83175266333,23.0386381833,-0.340407979,5.43763230667,17.0415296333,-12.2946221167,18.45883115,-5.62056902667,31.1191517,-10.104297285,6.53150823,2.68490222333,-0.523254850333,3.06956972667,-0.655734698167,0.809968216667,6.25238895667,-0.3243805755,1.923923615,0.370612641667,1.330635235,4.0822998,-4.599804315,10.0170460733,-6.07668896833,9.24834342833,-0.933437267333,-0.954889274667,3.91432164167,-0.747256786333,-0.342716551,-0.6520379875,-0.120506153933,1.31346516,-0.568096830833,1.52918625667,-1.0679312505,1.83624818667,0.273642575667,-1.745090425,2.16566114667,-1.458631205,2.06476833833,-0.148489856833,-0.7887366425,1.198325765,0.446937702,0.471325657833,-0.115874149833,-0.373662396333,-0.224770120333,-0.00325986643,0.0986904755833,-0.0913246552,0.6059006105,-0.533838898833,0.545925107833,0.000560105428,-0.292367867667,0.191758017833,0.02627805105,0.7472742055,-0.00351086247167,-0.1453493305,0.657415803167,0.0922506663833,0.195467692167,0.136816674333,0.0294689903],[-35013.5021833,-3947.78358333,-2177.62363667,-3281.72459167,964.716952667,7.80597976667,-760.742075333,-1827.703255,430.632286333,-392.459219333,359.543893833,142.07429,1184.91439833,-1838.57757667,-685.753963333,288.385042667,-483.251636,-393.500067167,-368.614102667,-74.14141915,-153.416921833,-514.191988,191.564140167,-617.814289833,-36.3769082333,-190.520457833,-21.6943847333,-175.372778167,43.6409546167,-97.2948754,-56.7533296333,37.0802803667,-629.554761167,243.119026,-34.2743145167,-22.8695676167,-10.2823544083,66.2679946,-21.2818052,60.1924814667,-38.46151355,16.6158081667,45.4565643833,-115.353505667,21.8831368333,45.6017836333,30.49758825,-62.0237144667,0.854109619333,12.51235075,14.5646478333,4.03411913,22.9097285333,-1.52263438517,5.06860678167,17.2091866,-11.7883025833,17.7750228667,-5.82816609833,30.52217905,-11.0724218167,7.37963354667,3.267536045,-0.537509379167,2.88760288667,-0.939006173833,0.548967642167,6.08189454333,-0.533474513167,1.82507616667,0.195324899232,1.272950715,3.92723001667,-4.84443711333,9.84800285,-6.39387126833,9.62996531333,-0.8419656785,-0.958695031,3.63088459833,-0.760252549333,-0.302558399167,-0.607915902,-0.1763793555,1.261435775,-0.5369357125,1.508326975,-1.16410278167,1.78323176333,0.286574593667,-1.78992615167,2.21483756833,-1.50287297167,2.24022191167,-0.116573312967,-0.8295252875,1.11751153167,0.379767637333,0.471456657667,-0.107332386333,-0.3347001235,-0.176906848667,0.008287613605,0.0796490349833,-0.063393563,0.5972537705,-0.5508696375,0.5254781585,0.0272984203862,-0.300124365333,0.228142906,0.0133205573183,0.794683763833,-0.013983522155,-0.159150845,0.649823799333,0.0787320668667,0.198526028167,0.163985195333,0.0424701473],[-35365.89135,-3954.77608833,-2484.14174167,-3292.704405,745.307956333,-25.9074490833,-697.661457333,-2157.14851833,389.357659667,-466.006442,397.672771667,104.578828483,1187.85782667,-1722.25082333,-663.6052555,280.594835667,-500.8647565,-374.298517167,-345.8280195,-51.9999293667,-126.07303625,-506.146494333,182.113223333,-620.771299,-35.2244566,-193.932360833,-24.8302389,-170.9678285,51.0027839167,-110.423082167,-60.0444331833,39.90697295,-621.3418005,242.525484333,-22.1508046367,-21.7480230667,-12.0288267,62.6528008333,-23.3065290167,61.8014658,-43.7001806833,14.8758976667,47.5815877167,-111.964863,20.4635752833,47.3793421833,28.2070349167,-65.1436885333,1.0762110045,11.6614802,13.2611919667,3.16561756833,22.6689462833,-2.75010976333,4.653390125,17.2542018,-11.2238327,17.062818,-5.66110699333,29.7051109833,-12.2436797167,8.02487881167,3.95132596167,-0.568279933667,2.71802046667,-1.21511865667,0.299186161717,5.87333465833,-0.7667547685,1.73461481833,-0.00645340257333,1.190844475,3.747993625,-4.986174055,9.64416039667,-6.71041347833,9.89066046,-0.702866815333,-0.934439244,3.369196125,-0.774891031,-0.266574785167,-0.568477247,-0.218310860833,1.20351223333,-0.506396678667,1.48570841667,-1.26280730333,1.716906255,0.299266339333,-1.82266887333,2.26026937667,-1.53257831667,2.38808209167,-0.0809339231833,-0.861498798333,1.05512134167,0.318371823833,0.457743980667,-0.1002581201,-0.297671736833,-0.130923318883,0.02273842272,0.0605243451,-0.0326808499183,0.586471003333,-0.567610557,0.5011389435,0.0555273987833,-0.309311194667,0.264777604167,0.00403805635667,0.837851003333,-0.0251499811167,-0.174661679,0.646105828167,0.0694093017167,0.195030099667,0.1887414775,0.0526298676],[-35659.70775,-3951.24982667,-2802.68039333,-3282.51838667,533.187495,-35.7904588333,-649.402711,-2495.06422167,354.779820167,-543.4387665,442.154362333,68.7430496,1188.32993167,-1595.215295,-628.650524333,274.556957833,-519.666607333,-353.323380667,-320.214297833,-25.4874509633,-97.0259413667,-493.551431,174.9113295,-613.908570833,-33.43012805,-196.638551833,-28.0507739667,-165.6691835,59.9870039,-122.593096833,-63.4669801167,43.5263035,-608.009627667,242.396955667,-8.81724801667,-20.65188045,-13.3196768167,58.7656907833,-25.4745846167,63.4565704667,-48.70304235,12.7856464333,49.4651648667,-107.563638667,19.5163026,49.79210475,25.4906517833,-68.5764289667,1.20437849833,10.9307440833,11.95645265,2.18623704,22.3183673,-3.99414214167,4.22457723833,17.1447017,-10.5847222,16.3448585167,-5.089784175,28.6447727667,-13.59705515,8.46752862167,4.75177782667,-0.609421575,2.56118457833,-1.46468691167,0.0627784010333,5.62313631,-1.01865312833,1.66395615167,-0.227953578768,1.08535414017,3.54655949667,-5.00789528,9.40996654833,-7.02651987,10.0249639267,-0.515168898333,-0.8708827195,3.13052734167,-0.785533604333,-0.233968836333,-0.531406221,-0.242085136,1.13723330667,-0.477426563167,1.46093834333,-1.35793725833,1.63584087333,0.309768091333,-1.84144917333,2.30340845667,-1.54981060333,2.50382188,-0.0452361172167,-0.879968219833,1.01208130667,0.262998146667,0.427800743167,-0.09350137425,-0.262529607333,-0.0879389799333,0.0406244241667,0.0410632649667,-0.000208679573333,0.5722910125,-0.582959989667,0.472505811167,0.0840843795167,-0.320667087167,0.301237893667,-0.00206522506,0.8753194235,-0.0382284648333,-0.191271382,0.646719058,0.0643904566833,0.184293369167,0.209629424,0.05998775],[-35903.8461833,-3921.01145,-3105.12857667,-3244.69165833,338.713255833,-18.2654404833,-594.900810667,-2829.71740667,330.137300167,-622.525298833,489.124452333,42.4942826833,1186.68426667,-1462.652685,-584.612147167,270.3490155,-539.442231,-332.2304295,-291.432863667,4.93474136333,-68.10040495,-478.020851,169.3391155,-598.1261375,-31.2244228833,-198.674392333,-31.47541025,-159.771136333,70.25346885,-133.732304333,-67.1825560667,47.4609516333,-589.914848833,242.862072833,5.41130536667,-19.6593404333,-14.1818428167,54.6756622,-27.8299673,65.0381537833,-53.3143815,10.365573145,51.0175164167,-102.291498667,19.17152415,52.7444139667,22.4210801,-72.24035225,1.22485214667,10.3220142217,10.68378643,1.10551055118,21.85118245,-5.19019151667,3.78563787167,16.8948453333,-9.89277816,15.6670037833,-4.13945665167,27.3732201667,-15.1133187667,8.71610375667,5.63034416167,-0.659009251667,2.42135559667,-1.67756672833,-0.152905809783,5.336088585,-1.27113210833,1.61336903833,-0.453611425667,0.957762211333,3.33516073833,-4.91331102333,9.15621641833,-7.344789705,10.03638142,-0.29541622995,-0.7666581775,2.91720479167,-0.789923446167,-0.204584776167,-0.496051327167,-0.245632133667,1.06441910517,-0.449249266833,1.434417,-1.44309788,1.54140530667,0.318770663,-1.84613036667,2.34578733667,-1.558032245,2.586612025,-0.0150650315067,-0.881513102167,0.989070303667,0.2143437415,0.384160723167,-0.0865251970833,-0.229890314833,-0.0487779805667,0.061807047,0.0220408699467,0.0326638135483,0.555016579167,-0.595639889833,0.4403927475,0.1122479731,-0.333860073833,0.337679554167,-0.005757937175,0.9066885405,-0.054084288,-0.207287301667,0.652213025333,0.0638013899,0.1675052445,0.226277746833,0.0645962617333],[-36104.14835,-3871.70935167,-3380.30988167,-3181.18766833,166.614963267,27.33809405,-525.5419175,-3144.964595,315.544869,-700.982159833,534.382063333,29.7511060167,1183.539385,-1326.42766833,-536.318946833,267.672625333,-559.553285,-312.461659167,-259.685790167,38.4085253367,-40.0718064167,-461.226385,164.195484333,-574.465786667,-28.67506055,-199.942428333,-35.0853361,-153.396768,81.2669238167,-143.638137333,-71.2492620333,51.1237561667,-567.5102535,243.892282833,20.2176062633,-18.7555356833,-14.6277711,50.4763283667,-30.2987657333,66.3834937,-57.4105112167,7.657952115,52.1623859833,-96.3397953,19.4771614833,56.09750025,19.1129645333,-76.06237255,1.13994794833,9.83421819,9.47253503667,-0.0412654502667,21.2589489833,-6.29322312333,3.331708855,16.52738425,-9.18201101333,15.0502897,-2.85893253333,25.9406348667,-16.7744640667,8.79602728167,6.548415945,-0.717944804667,2.30141748833,-1.84641414167,-0.342063176167,5.01904659333,-1.50932137667,1.578305275,-0.6674896885,0.808839579167,3.12454670167,-4.71258555333,8.89915224167,-7.66630266333,9.936439415,-0.0582542758,-0.626270809,2.72784917,-0.788081346167,-0.178523385,-0.462221326667,-0.229411422833,0.987717858167,-0.4204746525,1.4059823,-1.51235424167,1.43577166667,0.328952199833,-1.83691596333,2.39020591167,-1.55987967,2.63807118833,0.00510841555667,-0.865104625667,0.985009448667,0.172869587833,0.330780582833,-0.0793210170333,-0.200402045333,-0.0142044112667,0.0855190744333,0.00444203457,0.06503938995,0.535229099167,-0.604343940833,0.406015600667,0.140245883,-0.348195207167,0.374496244167,-0.00757026380167,0.931889939833,-0.07327191975,-0.221573292833,0.662606553667,0.0676788555167,0.146345683333,0.2388590805,0.06651930305],[-36255.9151333,-3841.77500833,-3691.364295,-3111.55588667,17.4064112333,95.67863005,-455.860488167,-3409.80332333,306.000226667,-775.028055833,576.719793167,27.8318471833,1181.63372833,-1182.65937833,-490.635061667,266.037043,-578.818544667,-294.457221,-225.989383167,73.4885327,-11.8699128667,-445.250451,158.081774333,-543.071337,-25.5758705333,-200.375329333,-38.8258483,-146.5003895,92.1997087833,-151.883647333,-75.6594395,53.9514500333,-540.993489167,245.441053667,35.0727968167,-17.8426922333,-14.7213199833,46.2022794667,-32.6916545333,67.3023034667,-60.9186838,4.74741400833,52.8606542,-89.8770138167,20.3931003833,59.6398627667,15.59627405,-79.9970712333,0.956381875833,9.457913315,8.336693185,-1.19620415882,20.54379695,-7.289702155,2.86034437333,16.0722703833,-8.493035175,14.4686507667,-1.30641760167,24.37955425,-18.572571,8.765200565,7.50137725667,-0.790274839833,2.20640389833,-1.96295836333,-0.5013327465,4.68142551333,-1.72518489667,1.55173989,-0.8560144605,0.636822998167,2.914116325,-4.41489295667,8.65871847,-7.99523939333,9.749948125,0.196485963717,-0.459513490333,2.55100222,-0.780742784833,-0.154859452,-0.428566475833,-0.196381923667,0.909332337833,-0.3898482675,1.37487072333,-1.56136560667,1.32096253167,0.3429018695,-1.813530345,2.44246328,-1.55855371,2.66222471833,0.0144423324767,-0.832582956333,0.994272501333,0.138617210833,0.272966664667,-0.0718977890333,-0.174650500167,0.0151150594667,0.110424331583,-0.0109734641367,0.0964571457333,0.513517891333,-0.608050877833,0.370685440667,0.1692899725,-0.36307393,0.412650332667,-0.00794385622,0.950709738833,-0.09592444155,-0.234054709,0.676849477833,0.0758452783333,0.122844448233,0.247923341667,0.0655769542833],[-36367.5559333,-3842.062095,-4048.81150333,-3049.43286667,-106.512519567,183.0416951,-389.610753167,-3610.19235833,299.118895333,-841.922684333,613.004507667,35.6650393667,1181.63855333,-1032.16980183,-453.170509333,265.570048833,-596.628177,-279.664492,-191.138982333,108.851778017,16.4706493833,-431.964254167,150.198366667,-503.739406833,-21.7918351167,-200.038293167,-42.9187856833,-139.193488167,102.456295517,-158.37277,-80.5430882333,55.5503770167,-510.523942333,247.464842667,49.4326610833,-16.8885076833,-14.5085925333,41.9067704167,-34.9153296333,67.6775416333,-63.7807222667,1.68165846,53.0910070333,-83.0014417833,21.8586276333,63.1714578833,11.9071610517,-84.0301907333,0.674652225833,9.19857389,7.314984205,-2.31496501833,19.7040002833,-8.14421624,2.37436522167,15.5561746167,-7.85818995167,13.91052315,0.460144916667,22.72379285,-20.51110735,8.66657297833,8.486431515,-0.878632632333,2.14368999667,-2.01474482833,-0.625141302333,4.32692881167,-1.90566008167,1.53092200333,-1.00688372117,0.4346348155,2.70534746167,-4.028467535,8.44830605,-8.34513028333,9.497714485,0.469399595667,-0.27259638095,2.37917172,-0.768191213833,-0.132564266,-0.393346700167,-0.147817387983,0.8305845425,-0.355554555333,1.341328935,-1.58579213,1.19705841,0.361859679,-1.775194065,2.50618282,-1.55948869167,2.66203208167,0.0141888475717,-0.784961099167,1.012541399,0.11172700195,0.213964220167,-0.0640218019167,-0.153256939167,0.03841009245,0.135860841667,-0.0235057782833,0.1264255132,0.490344665167,-0.605644261833,0.335257633167,0.199981319333,-0.377883838667,0.4527198705,-0.00746938221333,0.962974552333,-0.121688345767,-0.244214345,0.694152395167,0.0881945860833,0.0981447078667,0.2537285815,0.06196952425],[-36445.0955333,-3843.98714833,-4420.28290333,-2999.66086,-201.329809833,286.406562333,-318.510198667,-3752.475845,294.163941333,-901.702160833,639.459550333,55.4467332833,1181.02371167,-876.526078667,-424.452869833,266.503305333,-613.412243333,-269.856685167,-154.743565167,143.269428833,44.918015,-421.733050667,140.033299833,-457.5052635,-17.3040050167,-199.136516667,-47.7474185,-131.514311833,111.742470833,-163.212462667,-86.02505455,55.6455304667,-476.720249,249.922399,62.95948725,-15.8893525,-14.0057777833,37.63796465,-36.9893148167,67.4876682167,-65.9863665167,-1.56398006667,52.84926085,-75.8079731,23.8209274667,66.55407055,8.12852721,-88.1734267667,0.305366173833,9.07117202167,6.45061785833,-3.39336583333,18.7416020667,-8.82162092333,1.866853855,15.00404395,-7.28890772833,13.39269545,2.37959469667,21.02194685,-22.5931639833,8.52255311833,9.49995702,-0.982962927167,2.119204335,-1.991332715,-0.7131786545,3.9571699,-2.03790918833,1.515604305,-1.10927878333,0.199042285617,2.50626308667,-3.56604480667,8.27665421,-8.729507435,9.19524413333,0.7579120445,-0.0655579853,2.20744924,-0.751718961833,-0.110811856683,-0.354891567667,-0.0839610411633,0.752935024,-0.315369941667,1.30687198,-1.58205281667,1.06422775817,0.386697745167,-1.72191628667,2.582500835,-1.56712485833,2.64045457667,0.00565151080667,-0.721749410833,1.03644305,0.0911992774,0.1551639947,-0.05583676305,-0.136457602167,0.0553218989167,0.162107970333,-0.0325400839333,0.154750154167,0.466236912833,-0.596349032667,0.300149072333,0.232269909167,-0.3918573515,0.4946834375,-0.00652992973333,0.969224125,-0.150360822667,-0.251137398333,0.713789501167,0.104246037967,0.0727480141667,0.256650865667,0.0563810612167],[-36489.1891833,-3834.173505,-4772.743855,-2954.20981667,-268.1190555,406.775951333,-240.939053167,-3846.19419167,294.324131,-955.264114333,655.146614667,87.1148205833,1176.549775,-720.505400333,-402.411151667,269.567396333,-629.466382167,-265.805433667,-116.773504817,175.721793167,72.1686215167,-413.920723833,127.7320335,-405.982715333,-12.169173605,-197.733107333,-53.5411742667,-123.529136333,119.975633667,-166.789564333,-91.9943269667,54.2217781667,-440.335752667,252.717594833,75.3682015,-14.8990585167,-13.1934239333,33.4169281167,-38.9434966667,66.8044047,-67.5576901333,-4.96900804833,52.166553,-68.3879246333,26.2187772833,69.6490134833,4.26684796633,-92.4172734667,-0.156252465167,9.08844412,5.76403072,-4.43297019167,17.68677745,-9.28830350333,1.3408140785,14.4287626167,-6.77934183333,12.9284353333,4.38273966,19.2759793167,-24.80737705,8.35894675333,10.5439406667,-1.1052593805,2.13480647,-1.88871036,-0.766262100333,3.57851700333,-2.10947193167,1.50779557,-1.16109877833,-0.0661150617,2.322561125,-3.04467578667,8.13518565167,-9.15410134,8.85972248333,1.06327099717,0.161989194717,2.03151143,-0.732561609,-0.0899211622667,-0.312019655667,-0.00493646187,0.677214130333,-0.2673703755,1.27330391833,-1.54951813833,0.923887300833,0.416798783,-1.65469353333,2.66832068833,-1.58334633167,2.60135621,-0.008216573765,-0.642423289167,1.06276326167,0.074600879,0.0966518500167,-0.0473560605,-0.1245123925,0.06587950915,0.189591637833,-0.0382281232167,0.181200013,0.441669538167,-0.579993789833,0.265734789167,0.265355944667,-0.404192269167,0.537972438167,-0.00504165735667,0.970112087333,-0.181230488,-0.253996043833,0.734860504,0.122600153167,0.04641220255,0.257151395,0.0497321895833],[-36497.2102167,-3791.511445,-5065.67009667,-2900.165285,-307.9201845,546.167444167,-155.192376167,-3906.009615,303.711376667,-1003.7123845,659.0090555,130.169666267,1163.91820333,-571.394258167,-384.264447333,275.3923595,-644.997349333,-268.1920075,-77.50983955,205.270427833,96.1151104,-407.491897667,113.65495845,-350.4513315,-6.52223596317,-195.819213833,-60.4493054667,-115.390339667,127.163822667,-169.5764885,-98.1784633,51.36980875,-401.9767785,255.833190667,86.3417852167,-13.98404105,-12.0374718667,29.2836222833,-40.8101421333,65.7221515333,-68.4978048833,-8.46851155333,51.1001936667,-60.8130431333,29.0246084833,72.2892753667,0.286337700333,-96.7565709667,-0.713576275667,9.261152405,5.27471913667,-5.42870926,16.57235355,-9.50389576833,0.8048942775,13.8449737333,-6.324971355,12.53228955,6.39129210333,17.4618586667,-27.1409209667,8.19852099833,11.6241261833,-1.246265365,2.19064565,-1.705094255,-0.782853532833,3.19678582833,-2.10792999667,1.50808807,-1.16176088833,-0.35750859655,2.15728306667,-2.483015525,8.00613294,-9.62113166333,8.50724581833,1.38947185,0.411292582,1.84822287167,-0.711720865667,-0.0706000685833,-0.264335782333,0.08921969107,0.603736843,-0.210255551833,1.24150868,-1.48843417833,0.777635258167,0.450367925667,-1.574320585,2.7584391,-1.60849572833,2.548812185,-0.02338171188,-0.545955688,1.088611575,0.05940354575,0.0379067690833,-0.0386287890667,-0.1176894845,0.0700533202667,0.218542727333,-0.0409004016833,0.20534821,0.416957561167,-0.556613744833,0.232545218,0.298157681333,-0.413862646167,0.581822176,-0.00259088941667,0.966383504833,-0.213269055,-0.251804011,0.756328277,0.141672425,0.0185689273667,0.2555907865,0.04290774815],[-36462.8665333,-3702.914865,-5287.66238333,-2835.607815,-323.327048167,700.130037667,-61.7689123167,-3939.20401167,321.600291333,-1047.79333,650.208158833,183.5299925,1141.46933167,-433.2534165,-365.5797665,283.590896333,-659.940784333,-276.927694167,-37.144923905,231.493350167,116.02693985,-400.697068833,98.1036967833,-292.592323833,-0.494597101,-193.3487505,-68.3396330833,-107.102934067,133.280911,-171.684761667,-104.1408428,47.1925091167,-362.431725333,259.187428,95.6337479167,-13.1314938167,-10.5326247583,25.30926125,-42.5603217167,64.2735097,-68.7754502833,-11.9957037967,49.7239738,-53.2125077667,32.17365655,74.3389893167,-3.82533140533,-101.14844175,-1.34318821633,9.58088570333,4.98825219667,-6.36623569167,15.4106852833,-9.44485000167,0.252892992167,13.2747708167,-5.925510365,12.2023482333,8.33974675167,15.5669058167,-29.5570481,8.06305209833,12.73709125,-1.40338284167,2.281543415,-1.44662185167,-0.764596044833,2.81520897333,-2.02949879333,1.51080123167,-1.10873161667,-0.666980807833,2.01044917167,-1.89574817167,7.87587132,-10.1220902833,8.15436753833,1.73566423,0.682320348167,1.65565335333,-0.69099434,-0.0539074433667,-0.213139775333,0.195915090367,0.5334489275,-0.144524239367,1.211181805,-1.39892195833,0.629477505833,0.4862430665,-1.48057016333,2.84872372333,-1.64003568833,2.48783846833,-0.0375377598,-0.432198576667,1.111492605,0.04337902465,-0.02118671395,-0.0301816817,-0.115901724,0.0679316442,0.248398345,-0.04047099495,0.226752795333,0.392507610167,-0.526323597,0.2016174235,0.330212063,-0.419665324,0.625675402333,0.00153348455333,0.959146752,-0.245792576,-0.244003322667,0.777109634,0.159964239833,-0.0109880471833,0.252347439,0.0366264285167],[-36378.8354,-3549.437015,-5451.89213833,-2767.68615,-314.484214833,858.498886167,41.2674780667,-3949.46488333,343.656762833,-1087.62702333,627.691250333,247.321197833,1108.55441167,-306.644644333,-341.215588833,293.093355833,-674.208491333,-291.561267833,4.58590564667,254.0810515,132.516962167,-391.544279333,81.5287943333,-234.409695667,5.79360494683,-190.349039,-76.9566905333,-98.5440381167,138.238422667,-172.902486667,-109.436376167,41.8846142333,-322.602318833,262.661752,103.036093967,-12.2801888,-8.71916291333,21.5716867,-44.1487072,62.4511734333,-68.3262746833,-15.5110071667,48.1446007,-45.74598455,35.5974174667,75.6805418333,-8.054568335,-105.5048765,-2.00682677,10.0239494833,4.90296272333,-7.23723984333,14.2032878333,-9.09758361833,-0.334980997833,12.7495895667,-5.58224050167,11.9383366667,10.1717570783,13.5914446833,-31.9964963,7.97687721,13.8736761167,-1.57198941,2.39978771,-1.12230454617,-0.7175982095,2.43581764333,-1.875670895,1.50666894833,-0.997225795833,-0.984230536,1.884446255,-1.29462835533,7.73569836167,-10.64040945,7.81886067667,2.09843274,0.974354733167,1.45203216667,-0.6723443165,-0.04063486365,-0.16021737,0.311004847,0.467590284167,-0.0718604685383,1.18156341167,-1.28081127667,0.484202933667,0.524451349,-1.37260697,2.93641369167,-1.673745675,2.42416258833,-0.0491733185333,-0.301300672,1.12905098333,0.024285611933,-0.0802328090833,-0.0226943975833,-0.118736630167,0.0596791123333,0.27827027,-0.0366554329167,0.2448541205,0.368817032667,-0.489278002,0.1740760755,0.361401213833,-0.4203740395,0.669276605167,0.00809798859167,0.949705590167,-0.278219718167,-0.230136315167,0.796146681833,0.1759509175,-0.0420917151167,0.247828274333,0.03156761815],[-36241.2423,-3322.34757167,-5584.67145,-2699.44137167,-280.721460833,1011.15639367,154.628755017,-3943.79623,367.677269833,-1122.061055,591.730926167,320.902805333,1062.97502,-192.717504617,-308.081247333,303.34064,-687.371795167,-311.148607833,47.6521865783,272.389483167,145.7742815,-378.5847115,64.79970385,-177.593768,12.23376161,-186.8269905,-85.9871155667,-89.6409569833,141.966833667,-173.164519,-113.651186833,35.8366162667,-283.261707167,266.138136667,108.290301667,-11.4119513333,-6.64801352333,18.12786,-45.5228687833,60.2934889,-67.1225998,-18.9492560667,46.5138388667,-38.5571881333,39.23458495,76.16882045,-12.3969625233,-109.7118165,-2.68333558,10.5651708833,5.00710138833,-8.0272907,12.9696113167,-8.454786995,-0.968610442,12.3009628667,-5.2984911,11.7409413333,11.8225931333,11.5295728667,-34.3927594833,7.97043470667,15.0234118333,-1.749529695,2.53853031,-0.742727028167,-0.646353153667,2.06329250667,-1.64758185667,1.48814297,-0.826988825667,-1.3003630325,1.78183144,-0.694201016667,7.574513445,-11.1586578333,7.52025660833,2.475118675,1.28372832917,1.23424558333,-0.656979290833,-0.0313605662167,-0.107235729783,0.430460144667,0.406718264667,0.00660866231333,1.15196755333,-1.13604460283,0.346082991,0.5649815855,-1.25054352833,3.01793483333,-1.70593606667,2.36386689333,-0.0560820158167,-0.154518010313,1.13819528167,0.000197132632,-0.1382791624,-0.0164478548833,-0.1258726135,0.04561192845,0.307212589833,-0.0296447923667,0.259243858167,0.346355496,-0.446110050667,0.150898449167,0.391494827,-0.415016751833,0.7121666965,0.0175202505567,0.939350328,-0.309669167833,-0.209916868667,0.81205244,0.188201338833,-0.0743418262333,0.242466400167,0.0282737102333],[-36067.1395333,-3078.505445,-5748.30975167,-2635.84704333,-227.172794667,1149.04673833,267.135655667,-3922.38596833,393.826224333,-1146.776925,546.9386955,397.806481333,1002.972982,-95.9612452667,-270.387738167,314.980176667,-697.809582333,-333.219421333,90.1979688833,285.264875833,154.293531833,-362.430867,48.8723307833,-123.0435217,18.92630195,-182.654281833,-94.9223547333,-80.5764422,144.265642833,-172.966385,-116.542880833,29.50980955,-245.0235545,269.549426667,111.023469667,-10.5479843433,-4.37982067833,14.9880821667,-46.56935415,57.8750100167,-65.2832846333,-22.1758919,44.9948770667,-31.8308486667,43.0180835333,75.6161067833,-16.8604923333,-113.6661485,-3.38189489667,11.1814728167,5.26051315167,-8.67924885667,11.7599571333,-7.53866272833,-1.62986768,11.9487009333,-5.10449373333,11.5942462833,13.2140393667,9.37775341,-36.7022832833,8.09020534,16.1658390833,-1.939349445,2.69435066333,-0.324584208,-0.545431557,1.71006283167,-1.34851832283,1.45262671667,-0.607906495167,-1.61128729,1.69866675,-0.1164793585,7.38500133,-11.67327415,7.282889275,2.85961945,1.597493495,0.999292619667,-0.6455662615,-0.02636766765,-0.0560019051767,0.5504873105,0.351394433167,0.0911349374617,1.12251526833,-0.970799158833,0.2196538375,0.606800480167,-1.11836355617,3.09084165833,-1.73834405167,2.31374171833,-0.0565880439667,0.00315509491333,1.13620856833,-0.028444313667,-0.192851959833,-0.01119342469,-0.137487301167,0.0264621680433,0.333760788167,-0.0202270541983,0.270252358167,0.325870133833,-0.398388138167,0.1332988895,0.420313077333,-0.4039407335,0.753857923167,0.0287722841667,0.929411265167,-0.339209292667,-0.183721389,0.823610948,0.196474153667,-0.10675472495,0.236678186167,0.0266335048833],[-35878.0924667,-2912.39881667,-5996.88591833,-2583.35498333,-165.631531167,1266.03931833,367.5768055,-3883.989185,422.491858167,-1157.00634167,498.741878167,470.571646,927.3298795,-22.6994440667,-234.346481667,328.951921167,-703.351164667,-355.0999125,129.854668367,291.697445333,155.990306333,-344.273680167,34.4523629833,-71.2282989333,26.0683200333,-177.554059,-103.231224117,-71.6170399667,144.958048333,-172.89482,-117.932532167,23.21219435,-208.410967167,272.863336333,110.809852833,-9.70090383833,-1.954838687,12.15300754,-47.1501460167,55.2738816333,-62.9417360667,-25.0471195167,43.6889332667,-25.7729555167,46.8861678167,73.8266028,-21.4515093833,-117.263462,-4.11677414833,11.8506418667,5.61816483,-9.11889695167,10.6258794033,-6.37774315167,-2.29648783333,11.6960165,-5.04340338667,11.4755423333,14.27243465,7.13593907667,-38.8863679333,8.37844877667,17.2714073167,-2.14702422,2.863454015,0.114455170333,-0.405284191667,1.38871397167,-0.983285757667,1.39816252333,-0.352471204917,-1.91445908333,1.62745431667,0.4182242685,7.162078865,-12.18357,7.12775904833,3.24161956833,1.90072358,0.7472154525,-0.6391806795,-0.0262982880667,-0.00834973145667,0.667401836333,0.302066364833,0.182162966467,1.09355251833,-0.791284504167,0.109968925217,0.648024794333,-0.980190671167,3.15325494667,-1.773963475,2.27931429667,-0.05035229585,0.16592970552,1.12184558,-0.0599239183333,-0.241576429167,-0.00670525684833,-0.1539662735,0.00304754410667,0.356213679833,-0.00923291048167,0.278490116167,0.308256956,-0.347516711333,0.122721466167,0.447596369667,-0.387772851167,0.793850363333,0.0404446113667,0.9208521745,-0.366185836667,-0.152103324833,0.829979105667,0.2011251765,-0.138372879667,0.230626641833,0.0262525360333],[-35693.6742833,-2887.47506333,-6339.42032,-2547.872685,-105.77136155,1363.10733833,451.225216333,-3828.47979167,452.931257833,-1150.46036833,451.772719667,534.3703135,835.998169667,22.4205618333,-202.562993833,345.582027833,-702.704101333,-374.6682115,164.926562333,291.450948333,149.397437167,-324.461399667,22.3330769,-23.2294823667,33.78287385,-171.320137167,-110.475357333,-62.9958056167,144.004547333,-173.4087105,-117.660544167,17.2038894333,-174.0193395,275.856319333,107.515629,-8.83831321333,0.616954497,9.624181295,-47.1820997667,52.5329467167,-60.2310562667,-27.4757103833,42.6512079333,-20.5455401333,50.7351058667,70.71894755,-26.0929213,-120.3873475,-4.879561285,12.5594511,6.03894438667,-9.295840825,9.59526983167,-5.00991419333,-2.95690772333,11.5315741833,-5.13549841167,11.3643546333,14.9509028667,4.831218985,-40.89871355,8.8555124,18.2982969167,-2.37499374667,3.042747045,0.557871620667,-0.21930926047,1.10770651833,-0.559476453933,1.32362558667,-0.07442875,-2.20440126667,1.564509995,0.893210022833,6.90345621833,-12.6847464833,7.06677494833,3.60566291167,2.18104422833,0.482762407,-0.639939932167,-0.0315642985167,0.0342298824233,0.778690296833,0.2598431605,0.279819150833,1.06580299667,-0.603059034,0.0207681207333,0.687321188667,-0.839923859167,3.20222031667,-1.81465209667,2.26427028333,-0.0383322679,0.328712891667,1.09593812167,-0.09275507565,-0.283157061167,-0.003348056365,-0.175486463667,-0.02368947404,0.373501729167,0.00299912604833,0.2846329665,0.294280383333,-0.294607795,0.119959440667,0.4727915175,-0.367171551667,0.831190894333,0.0512297865667,0.914428086,-0.390069998833,-0.1157158483,0.830800337833,0.202498743167,-0.168619248667,0.224467652667,0.0269944306833],[-35526.9204667,-2962.33227167,-6695.85832833,-2518.37464333,-44.61887985,1453.27461833,516.891747,-3769.751925,487.164786,-1129.96563667,407.394598,587.220888167,727.508837667,36.5088961833,-171.725648,364.3797925,-696.827867333,-391.5667105,194.783749667,285.29985,133.419046333,-302.179934,13.5753132183,18.5715219333,41.7838337333,-164.000159167,-116.517247833,-54.8809780833,141.7332285,-174.958085333,-115.710867,11.8033925517,-142.598945167,278.060650833,101.5542427,-7.95842425333,3.38286314633,7.42023299667,-46.6930475167,49.6995977833,-57.2933807667,-29.4783469,41.9267696667,-16.2099932667,54.4232658667,66.3902666833,-30.56902835,-122.974872167,-5.638094835,13.31482955,6.50353223333,-9.20917685,8.66917189333,-3.46997068667,-3.60595575167,11.4367493667,-5.35345401833,11.2557160167,15.2259786333,2.53340988283,-42.7076151667,9.49941996667,19.2021636667,-2.61806240333,3.22990418833,0.9949708365,0.0129107314533,0.869503252667,-0.0815625742333,1.23485242167,0.211448775083,-2.47160346,1.51546342,1.28937459617,6.60967857333,-13.17059955,7.09627394833,3.935054555,2.43444765833,0.215666826833,-0.649895750833,-0.0425815821167,0.0711649665333,0.8842755055,0.226550232167,0.3847602715,1.04143130333,-0.411537957833,-0.04770185705,0.724722246333,-0.702382947,3.23259144167,-1.860558135,2.27012388833,-0.0220295283383,0.489082667333,1.061377865,-0.127005027433,-0.318185852167,-0.00193809136,-0.201828632833,-0.0527373905,0.3858273785,0.0166821928117,0.289142428667,0.284213506833,-0.240732009167,0.124392366333,0.4948711865,-0.342580481833,0.864287892667,0.0601690600667,0.911123661,-0.4104759505,-0.0751667063,0.826133471833,0.2004741265,-0.197571857333,0.218637082,0.02937446195],[-35382.0205,-3089.22098833,-6970.625745,-2475.45057667,18.3203137167,1550.48683333,558.4776195,-3716.07745167,528.244528167,-1101.23858,365.4162385,627.557378667,603.258871667,22.4521801,-137.717439567,384.280957167,-687.397592167,-406.019117833,219.778723667,275.12228,108.830836467,-276.800501333,8.183673335,50.3649775333,49.5365408,-155.6091355,-121.2884385,-47.1200045333,138.6759475,-177.668204333,-112.336314667,6.89211121,-115.318914233,278.871147167,93.8543559833,-7.07816166167,6.43891124,5.57007444667,-45.69734545,46.7950488,-54.2611832833,-31.1606372167,41.4405393667,-12.8553916167,57.7536716833,61.1430220333,-34.55997575,-125.0339585,-6.34585840333,14.1250851167,6.997181695,-8.88181838833,7.82296614167,-1.80299676947,-4.24386330333,11.3732576333,-5.6488116,11.1342869,15.1214729167,0.360484604667,-44.3038732167,10.2593134317,19.9371329667,-2.86594064167,3.41748735833,1.41558085117,0.283833394197,0.671029932,0.4437636624,1.142811795,0.490850524833,-2.699798115,1.487028525,1.59368364,6.294564925,-13.63627135,7.20026618333,4.20827084,2.66088364833,-0.0429511991667,-0.670784278333,-0.0609473336667,0.1020541813,0.983558845167,0.204389968167,0.4975499445,1.02392216833,-0.2207337101,-0.0952088860667,0.761518510167,-0.572004895667,3.24138680667,-1.910775775,2.29565496833,-0.00645204312333,0.645050874333,1.0220756435,-0.163523335667,-0.347628461667,-0.00350398189,-0.232451801333,-0.0829123107167,0.393745979,0.03250062575,0.292497173667,0.278095064833,-0.18650685,0.134908474667,0.513203368167,-0.314372056167,0.891677219,0.06657576175,0.911563067,-0.428352065667,-0.0317844405167,0.816513113,0.1948744895,-0.2252646615,0.213916037667,0.0340036854167],[-35258.05185,-3191.32551833,-7099.86797667,-2414.511035,92.3043689833,1661.813335,579.833758,-3675.36433167,574.17175,-1068.06524667,323.6709175,657.610941833,464.400098333,-15.2314261333,-97.86104325,403.5179005,-676.293364,-419.007048167,241.1350655,262.401991167,77.53314035,-247.729179667,6.23432579833,70.4492712667,56.5590717833,-146.524983,-124.933583,-39.4497247333,135.239923667,-181.2440085,-107.595227833,2.44205307833,-92.6751337667,278.0564695,85.1546122833,-6.170439875,9.747161775,4.07393773,-44.2280509167,43.8250301667,-51.1715285333,-32.5580335667,41.1502645833,-10.4701855283,60.6393342,55.2576259167,-37.8647333333,-126.6076265,-6.94461323833,14.9780527833,7.51417389167,-8.35830780667,7.025416845,-0.0498931862,-4.87039855833,11.31527265,-5.97881226667,10.99496375,14.6868309167,-1.6062612755,-45.6894540167,11.08612605,20.4885563667,-3.10356641667,3.60082445333,1.81601086333,0.577360487833,0.504120051833,1.0033253135,1.05043677817,0.754048641167,-2.87937818,1.48378062167,1.80632105667,5.97066102667,-14.0766576333,7.360196085,4.41656146,2.86166853833,-0.2838293885,-0.702420523167,-0.0857239910667,0.127889057833,1.07414594733,0.193821925167,0.616054292667,1.01347191833,-0.0334876200667,-0.1232355334,0.799032486167,-0.450472844667,3.22790110167,-1.96277005667,2.33761300167,0.00593557403167,0.795091499667,0.981700691833,-0.202291091333,-0.373158928167,-0.008820660915,-0.266052559833,-0.11308146305,0.3977669515,0.0510239728,0.294723963,0.275333627,-0.132387904017,0.149985748667,0.5278157985,-0.282973540833,0.912555488,0.0706852660167,0.915507488667,-0.444442529833,0.0130455885833,0.802722141,0.185877666667,-0.252109525833,0.2106066015,0.0411085160833],[-35166.1474167,-3182.29206667,-7040.81607,-2331.89929333,185.723856033,1788.413075,584.700069833,-3662.67682333,623.4493135,-1034.80877833,278.3246365,679.9157715,309.4675365,-71.3194441333,-50.7453896535,420.517572833,-665.501435667,-431.870117,260.153219833,247.944976167,41.7126333383,-214.823044667,7.82287907833,77.61024335,62.3997876833,-137.140106333,-127.622592333,-31.6059550833,131.757090333,-185.314194167,-101.639457,-1.471581385,-75.0117963,275.591621167,76.1666956833,-5.21506293167,13.27214528,2.94570494333,-42.32445805,40.8166090167,-48.0403295,-33.7130936667,41.0608022167,-9.02717260833,63.07629655,48.9970255667,-40.3162913667,-127.757325833,-7.38135174833,15.86341965,8.05737417167,-7.68693952,6.25460222333,1.7531277422,-5.48399094167,11.2524599,-6.30713982,10.8511676333,13.9696652167,-3.296822005,-46.8719334,11.9307197167,20.8582298,-3.31618761667,3.775382575,2.195183975,0.876575658833,0.36138775,1.58407623083,0.960922769333,0.994491821833,-3.00428153667,1.51292335,1.92742751833,5.65021903333,-14.4854094,7.55629389,4.55893671333,3.03966793667,-0.499384650333,-0.744062427333,-0.116071981883,0.149758519167,1.15366590667,0.1948567055,0.737742406667,1.01024850667,0.1473670419,-0.134145300667,0.838822746667,-0.3394708055,3.19213931667,-2.01294620833,2.39238535333,0.01479831958,0.938467038167,0.943548212,-0.243549647,-0.3963197565,-0.018490584595,-0.301359498,-0.142318517833,0.398435937167,0.0726290265833,0.295664230333,0.275314279,-0.0789954028333,0.1679879435,0.538745791,-0.248793817167,0.926356730667,0.0731309570667,0.9225943085,-0.4590593995,0.05820552165,0.785581474333,0.173491847667,-0.278463223167,0.2089512505,0.0508115404667],[-35117.9190667,-3046.616525,-6822.73842667,-2233.45493167,295.977453333,1918.21738167,581.022447833,-3676.433395,673.300953167,-1003.37295933,226.069160667,697.139125167,139.12236935,-139.868864333,-1.68066153067,434.4549735,-655.712317167,-445.251378833,277.520230833,231.613416167,3.56867827,-179.658776833,12.1717542667,71.9367234667,66.9360326,-127.738622667,-129.449789167,-23.5285112833,128.15017,-189.534203167,-94.6604563333,-4.95720100833,-62.3655977,271.8433505,67.36921795,-4.17825283333,16.9229803667,2.172486795,-40.01788575,37.767523,-44.8922488667,-34.5946620333,41.1850207167,-8.538636515,65.1733451167,42.5509767,-41.8804566333,-128.5171695,-7.62860982,16.7597551333,8.62282903333,-6.89346093167,5.51139251,3.56817187,-6.07447213833,11.18964635,-6.635873765,10.72097175,13.0140070833,-4.68573284167,-47.8485826667,12.7754244333,21.0603581833,-3.49648132667,3.93994460167,2.553459855,1.17044502233,0.242445711,2.17337282167,0.871813165,1.2081648315,-3.076366335,1.57490846167,1.960800395,5.34038114333,-14.85428925,7.77891364667,4.63950453333,3.19016432833,-0.689352527333,-0.7948659525,-0.149818767667,0.169489021833,1.21959463167,0.207202664167,0.860469242667,1.01248265833,0.318363863333,-0.129742761667,0.880650315167,-0.240094352833,3.135528995,-2.05812901833,2.45702867833,0.02082699605,1.07149572267,0.908024939,-0.286819528667,-0.416034683833,-0.0325683954167,-0.3372768015,-0.169734004667,0.3958388215,0.0971402624833,0.295322118167,0.277578219167,-0.02723691215,0.1878724455,0.546089864,-0.2126226835,0.933051502,0.0742688201833,0.931731277667,-0.472417334667,0.102131129117,0.765406805167,0.157919209167,-0.303645349,0.209241754667,0.0624752026833],[-35131.5737,-2800.42809833,-6511.61909333,-2133.39621333,417.949250167,2031.576745,581.875889667,-3706.10505333,719.320109,-974.060348667,163.8054448,712.504202667,-44.8134782667,-214.9310915,40.6201023632,444.706661667,-647.017970833,-459.481319167,293.6548365,212.581699333,-34.725589595,-144.693456,18.1550025167,54.3209984667,70.2232319833,-118.621505333,-130.488575167,-15.26940801,124.081874,-193.5235095,-86.8308353333,-8.16628641167,-54.5797028,267.361931833,59.0617597167,-3.01345920833,20.5486302167,1.72917914167,-37.3339091,34.65157365,-41.7381011,-35.1385092833,41.5454762167,-9.04946172167,67.0856792667,36.0501838667,-42.59726425,-128.890682,-7.67101344167,17.6357922167,9.20410155333,-5.99131913833,4.807095035,5.35935941333,-6.63190680333,11.1425102,-6.99129506333,10.6243514333,11.858532,-5.77166160167,-48.6066129833,13.6201652,21.1117716,-3.640003575,4.09536059833,2.89250500667,1.449998385,0.151317599483,2.758673305,0.776255408667,1.39310776833,-3.10272762,1.66651289667,1.91164731667,5.044805085,-15.1732748,8.02363227667,4.66400636167,3.30366783,-0.8569445115,-0.8536930825,-0.183916958167,0.1895014355,1.26876382333,0.230643270333,0.982014389833,1.01709320833,0.475938406333,-0.111703305083,0.923706484,-0.15326613255,3.060246805,-2.095647315,2.52888174333,0.0249946910333,1.18871720833,0.8739121325,-0.331005821667,-0.4299131915,-0.0507949401333,-0.372732461333,-0.194458570667,0.389666938167,0.1241485405,0.293693356,0.281850417333,0.0219218988,0.208911302333,0.550106917667,-0.1755250325,0.932871463833,0.0741838763,0.9413503655,-0.484635935333,0.143029135167,0.742149743,0.139530618,-0.326442151,0.2117116675,0.07504524945],[-35219.1033833,-2466.72771833,-6171.80257333,-2039.21768833,543.247044667,2111.91740833,590.860045,-3743.82246167,759.549191167,-947.7344955,89.642964585,726.330963167,-240.532421317,-292.566092667,68.6637497167,451.145305333,-639.258146667,-474.615083833,308.342729167,190.210138667,-71.7186249667,-112.01699905,24.5280987833,26.2316653583,72.36277445,-109.893815333,-130.7647635,-6.95965290667,119.299816833,-197.055476333,-78.2306187,-11.3347939217,-51.2968009667,262.775022333,51.43983655,-1.69014385617,24.0683488333,1.59252838333,-34.27818235,31.46301565,-38.6035138167,-35.2677422,42.1251481833,-10.5661015067,68.9714550667,29.5875526667,-42.5605406,-128.912849833,-7.504316255,18.4761085667,9.791310635,-4.97792485333,4.15430655833,7.09527841167,-7.145771875,11.1168489,-7.39667372,10.5728863333,10.5359102217,-6.57575572333,-49.1440023667,14.46093855,21.0410709167,-3.74581931833,4.24322371167,3.21256055167,1.71218373167,0.0913369188333,3.33018146333,0.667534263833,1.54603538333,-3.09113493,1.77911723333,1.78585136167,4.76162880833,-15.4339880667,8.28427879,4.643115205,3.3740346,-1.00636727317,-0.920090697167,-0.2163670145,0.211804109833,1.29946470333,0.264661504833,1.10095358417,1.02106528833,0.616738887667,-0.0815856743167,0.9655401465,-0.0791631783,2.96779546167,-2.12261636833,2.604705755,0.0290543822333,1.286325385,0.839387515,-0.375196882167,-0.435965782333,-0.0729700715167,-0.407141161167,-0.215731146333,0.379726646833,0.15318607,0.291014384333,0.287886312,0.0677472167667,0.2306156405,0.550844848,-0.1383065115,0.926018638,0.07322808765,0.949754421,-0.4958191425,0.179501696833,0.7156424745,0.118593942567,-0.34584552,0.216441373,0.0874769587167],[-35372.7668667,-2102.835025,-5839.6878,-1947.90092833,655.103512333,2163.506105,592.622809333,-3775.79386833,796.532086333,-925.825930333,8.76635562333,734.1781095,-442.434689833,-370.968360667,80.8023436833,454.751745,-631.826920833,-489.379704333,320.330127,165.10243,-106.810236167,-82.0433263667,30.5139879,-10.1482412667,73.5475952167,-101.389938167,-130.197178333,1.03319476167,113.888708667,-200.196918667,-68.6316439167,-14.7172381833,-51.7890820833,258.481568833,44.4245788,-0.231787354667,27.5133479,1.70929427667,-30.88425035,28.2854256333,-35.5610876833,-34.86259495,42.8440105167,-12.9316542,70.8712335833,23.1822852333,-41.9481105,-128.614429333,-7.15685469,19.2981157833,10.3599047183,-3.83977459833,3.58009633833,8.75478967,-7.59485021333,11.098921,-7.83295652833,10.5545025333,9.078964145,-7.15426115833,-49.4621260167,15.3088390833,20.8848449,-3.82149380167,4.38906438667,3.510802765,1.96438367667,0.0647124964333,3.88461364333,0.544846153833,1.66318102833,-3.043888015,1.90024927167,1.59684378,4.48251908833,-15.6345510167,8.56207837833,4.59123499667,3.40066436,-1.146478405,-0.994129742667,-0.246680448333,0.237285291333,1.31440349333,0.307482177167,1.21714782,1.02320884667,0.7390918075,-0.0399438472833,1.00246701917,-0.01467563465,2.85995662667,-2.137845615,2.68259493667,0.0350946651167,1.36398799667,0.8005713655,-0.419563084167,-0.432751778167,-0.0986214475833,-0.440900820167,-0.23335892,0.366605489167,0.183388887167,0.2877230205,0.2955469285,0.110056677167,0.253192761833,0.548144647333,-0.1008217574,0.913207703333,0.0721736049833,0.955591926667,-0.505987775,0.2111899905,0.685637931833,0.0950111411,-0.361212722,0.223383238667,0.0992734258833],[-35583.5621833,-1713.72429333,-5546.82608667,-1865.799985,752.4465065,2194.92842167,584.016781167,-3782.72707833,828.881020333,-907.590662167,-71.8993596483,736.532456167,-642.705254667,-445.786493,76.1285389333,455.447474,-624.636989333,-502.080882667,329.438864833,138.394282,-138.216610833,-54.9978383833,35.9421567333,-52.4700123583,73.76878535,-93.4061026167,-128.644067167,8.39114310333,108.032788333,-202.640854,-57.7546079667,-18.2606069667,-55.2330999333,254.8857395,37.8790148167,1.32238818717,30.75137965,2.02494108667,-27.25321905,25.2229468,-32.5980648,-33.7830356833,43.73383915,-15.9458508833,72.8472840167,16.8456985667,-40.9341874667,-128.005308833,-6.647252515,20.0861462,10.8819377667,-2.59972806833,3.11458692333,10.3269512367,-7.949617125,11.1094533667,-8.26815025,10.5772892167,7.52606884667,-7.55617842667,-49.5570530167,16.1840042667,20.6769712,-3.867498945,4.53692674667,3.78325084667,2.20279339,0.0731833943,4.41556622333,0.410371108833,1.74887970333,-2.96062293333,2.02618303333,1.36181874333,4.204724935,-15.7737253833,8.86300223833,4.52236316,3.3832261,-1.28741538,-1.073123473,-0.272505426833,0.2663447995,1.31408540667,0.3569003405,1.32762807,1.02301162667,0.842123216833,0.01330165085,1.03319741667,0.0445261352667,2.74121587167,-2.140738485,2.76228362333,0.04527109555,1.421995115,0.752934856833,-0.4642669775,-0.418672785667,-0.126685365533,-0.473485394667,-0.247345748333,0.350703609,0.213767945,0.2831471795,0.304724567333,0.148265897833,0.2770924745,0.542286094333,-0.0626427038167,0.896080086,0.07182512985,0.958102977833,-0.514976076667,0.238127956833,0.6518076855,0.0687500251833,-0.3718519335,0.232470202833,0.110035429717],[-35834.54975,-1320.924151,-5321.08254667,-1795.56675667,832.843976667,2213.18611667,569.263712833,-3748.81591167,856.074888833,-891.321117167,-146.489420383,735.809389167,-834.465433667,-513.710095333,52.0385154333,453.228365333,-617.14865,-511.275428667,335.699948,111.03729975,-164.325012333,-31.77032635,40.74522615,-98.3400615833,72.98184245,-86.1547814667,-125.977233833,14.7898885217,101.8803898,-204.009097667,-45.4700505333,-21.8945535167,-60.8143371833,252.336955333,31.6345568,2.91192364333,33.6481241,2.49719518833,-23.4834027667,22.3724133167,-29.6602659833,-31.9047068667,44.8200262167,-19.4283006167,74.9504327667,10.58201161,-39.6652924333,-127.0723325,-5.99911299167,20.8188392833,11.3343949333,-1.27649304267,2.78644187,11.81001415,-8.17912699833,11.1687629,-8.67929427833,10.6504420833,5.91550279667,-7.81894593333,-49.41883635,17.1015349667,20.4392714,-3.88421619667,4.6891538,4.02657875,2.42480723167,0.118304967017,4.917421025,0.266914784667,1.80886749833,-2.84320631667,2.15434459167,1.09802442733,3.92798939,-15.84987705,9.19007488167,4.44583738,3.31995733,-1.43656494833,-1.15395363,-0.291727897333,0.299249121167,1.29894474167,0.4107213895,1.42914528333,1.01992187833,0.925625167833,0.0778768296667,1.056690125,0.1024930023,2.61623800333,-2.13125393,2.84252806333,0.0607500678,1.46003779167,0.6930105025,-0.508740600167,-0.392434539833,-0.155967266167,-0.5043670725,-0.257773289333,0.332263364667,0.243367049167,0.2764880265,0.315265302833,0.181968759333,0.302746571167,0.533537322333,-0.0235300680167,0.876200312833,0.07276674715,0.9562833095,-0.522660863333,0.260240485333,0.614006301167,0.0401006150683,-0.377188684833,0.24343885,0.119323747667],[-36094.35235,-929.8926405,-5171.19166667,-1729.86792,895.8862045,2225.67383,549.441255333,-3670.411505,879.273738,-876.016724667,-210.450620333,734.150697333,-1013.03644883,-573.2781555,8.17088453333,447.874059833,-608.902742833,-515.8660025,339.407973667,84.1328071833,-184.1154185,-12.9548483433,45.3550412833,-146.032758917,70.9880000333,-79.7318248833,-122.073570333,20.0132298,95.6795229833,-203.994831167,-31.7796299667,-25.4568470333,-67.8827101333,250.929850667,25.56664025,4.45662730167,36.1155250667,3.10211761167,-19.6602284667,19.8165403667,-26.6879118167,-29.1690843833,46.1049565,-23.2029425333,77.1462460667,4.39782022833,-38.2273327333,-125.797349833,-5.23002027833,21.4771114,11.6968565667,0.108697991,2.60896903667,13.2067780667,-8.26177981333,11.2807661167,-9.03670334333,10.7708394167,4.27588932333,-7.96325066,-49.0351677167,18.0571700833,20.18265635,-3.869802415,4.84473728667,4.23632425667,2.627450745,0.1984747555,5.38617315167,0.118728509567,1.84531086,-2.693731395,2.28223516833,0.818085435167,3.65098662,-15.86069055,9.538938425,4.36658239,3.21195587333,-1.59729220833,-1.23361327833,-0.303275680333,0.335961192,1.26980482833,0.467107907,1.51871269,1.01384640333,0.989478409667,0.152091751733,1.07197069,0.162164110167,2.487588115,-2.10959977667,2.92068627167,0.0815401776,1.478733145,0.618605691333,-0.552617288833,-0.354153222833,-0.185458382167,-0.533015546833,-0.2646316295,0.311665414333,0.2715740795,0.2669557875,0.326864903,0.211065411333,0.330069386333,0.521974355,0.01661140565,0.854449877,0.0753030347167,0.949042157,-0.529100861333,0.277458559167,0.5721511355,0.00927227889,-0.377234424167,0.255889993,0.127049518333],[-36337.8740667,-536.386325333,-5091.588615,-1664.54423667,942.264139667,2237.10148333,525.738991333,-3548.42239167,898.8728995,-861.953766833,-260.663729333,732.838512667,-1175.0789,-626.542594,-53.8600981667,439.224632667,-599.973232,-515.116563167,340.6716055,58.64074685,-197.880809167,1.17606302667,50.8830089167,-193.754858833,67.6679762833,-74.25857275,-116.916152833,23.8326338667,89.5924030667,-202.502818833,-16.760789405,-28.6736909,-75.72218695,250.540149167,19.4145533,5.897064925,38.08607125,3.80341270667,-15.8764372,17.5744705667,-23.6322342667,-25.5816895833,47.5662922667,-27.1040092333,79.3262365,-1.74943131667,-36.7029483167,-124.151206167,-4.35533346,22.0499247167,11.9528025333,1.536406394,2.57645346333,14.5234194167,-8.19377742333,11.4263554,-9.32349792333,10.9176814833,2.62141993217,-8.012774425,-48.3945354667,19.0400229,19.9134887333,-3.82284682333,5.00515880667,4.40951075,2.81010573167,0.310257475667,5.81999252833,-0.0324148945667,1.854484395,-2.519642045,2.40437205333,0.531497687,3.36866456667,-15.8069600667,9.90289021333,4.28772402833,3.061774145,-1.76973719833,-1.30959028667,-0.305922792833,0.376855787167,1.22821609667,0.524881394833,1.59428924,1.004211116,1.0336710465,0.232440659167,1.07786317,0.225525701167,2.356173625,-2.07745401667,2.99359868167,0.107258517133,1.47911809,0.528702712833,-0.595154260833,-0.3054284895,-0.214312406167,-0.559045857667,-0.267771841167,0.289401323833,0.298168150833,0.254023636,0.339092324833,0.235887664333,0.358591144167,0.507669116167,0.0574661166833,0.831270915,0.0791786088333,0.935296961167,-0.534473876,0.289712107667,0.526213381333,-0.0232930858983,-0.372657765833,0.269084001667,0.133405769667],[-36564.05235,-175.289051333,-5051.82250167,-1600.741035,968.895916,2247.38061667,495.595741167,-3386.87863667,916.5366775,-849.0974455,-297.482811667,729.897517167,-1319.11890667,-678.216896667,-132.150652117,428.2665335,-590.231188667,-509.4002445,339.215009,34.9752110333,-207.485667333,10.3130830233,57.9417568833,-239.523156833,63.27925115,-69.58958765,-110.783767,26.15417515,83.6283551,-199.891370333,-0.628160353333,-31.5414383167,-83.3646034833,250.802340667,12.8396400317,7.21615043833,39.5821597333,4.55449533667,-12.182732835,15.59886225,-20.50599745,-21.2241105833,49.0956338667,-30.952346,81.3293823833,-7.95127653167,-35.1823929833,-122.111018833,-3.40929261167,22.5442773333,12.1133601167,3.012077625,2.66174868667,15.7747620667,-7.99011781,11.5674847333,-9.54090392,11.0421557167,0.956772024667,-8.001744435,-47.5049093833,20.0415177,19.6425249333,-3.75039780667,5.17553807,4.55206576833,2.98238409333,0.4484298745,6.22509620833,-0.188196179767,1.83270058,-2.33577222,2.50707992667,0.245080566383,3.07094640333,-15.6966882333,10.2732034117,4.21337713167,2.87223629333,-1.95339161167,-1.38157143667,-0.299185800333,0.422824416,1.17740882,0.583879912833,1.657902475,0.989265865167,1.060299405,0.313088638833,1.072596105,0.293647707833,2.220436645,-2.03782346333,3.057514565,0.1386960215,1.4613293,0.423830762,-0.635664872,-0.248558474667,-0.242180684167,-0.582809210167,-0.2673701765,0.265886888833,0.323426287333,0.238220306667,0.3514112475,0.257456551,0.387362908333,0.490893150833,0.0984800622333,0.806350851667,0.08378537025,0.913874784,-0.538634268667,0.296696172333,0.47640475,-0.05695850125,-0.364290630833,0.2820850675,0.138743720667],[-36777.6227167,120.836705167,-5008.378605,-1546.53489667,974.453245667,2256.31682167,457.181899333,-3189.581785,932.2242995,-837.157907,-322.6096475,723.144476,-1444.09085167,-732.006839167,-224.201893833,415.979384,-579.6412225,-499.683018667,334.758630333,13.3016737133,-214.612788167,14.3653623,66.6835377667,-281.177024667,58.2235473,-65.5962499833,-104.115273117,26.9060812333,77.7109839667,-196.513415833,16.4081937117,-34.2140576,-89.7239156333,251.348968667,5.47973634667,8.44586053333,40.6256359667,5.29968572333,-8.63162169667,13.8156398,-17.33060035,-16.2054070333,50.5552853,-34.5500746,83.0040424,-14.3147880467,-33.7583644,-119.643969333,-2.42094155,22.9694866167,12.20122945,4.54251275333,2.830463255,16.9728428333,-7.67888245,11.6678913167,-9.69191383833,11.0934256333,-0.7171440455,-7.965624645,-46.3725358167,21.0532832667,19.3819785833,-3.66074224333,5.363036325,4.67431289833,3.15543159833,0.607026270167,6.60784595833,-0.3540418215,1.779439035,-2.15870330667,2.57488162333,-0.0351526468,2.74744796,-15.5366855167,10.6401021167,4.14824972833,2.64659114167,-2.14815207667,-1.45018952167,-0.2820625105,0.475293630333,1.12099482,0.644189741833,1.71223276667,0.966552570667,1.07252949167,0.387376129167,1.05405547167,0.367480430667,2.07856009667,-1.99340982167,3.10834618667,0.1770809925,1.425577755,0.304661043167,-0.673582535833,-0.185474573333,-0.269049720167,-0.604650444,-0.263707411,0.241580666,0.347787061167,0.220313651,0.363361460667,0.276937356833,0.415189393,0.471890217333,0.139115864467,0.7792545335,0.0884656872167,0.883514033667,-0.541250615167,0.2982308285,0.422970100667,-0.0911245833,-0.352682947667,0.293941926,0.1433713765],[-36975.8612167,353.787172667,-4918.62835,-1515.87480833,965.773992833,2263.21148,417.874514667,-2962.54696667,942.484426,-825.174453333,-337.675112667,714.132911167,-1549.02420333,-788.9200915,-325.8010045,402.4340155,-568.4927195,-486.865944167,328.007657167,-5.92007998,-219.922800333,13.9170260167,77.6557258167,-316.801012167,52.7996592667,-62.3633478,-97.34842135,26.1414718667,71.9133253833,-192.439273667,34.2781574667,-36.603289,-93.7574034667,251.925646833,-2.96677278833,9.64088040667,41.1596109333,5.97922460833,-5.31410385667,12.1865130333,-14.0850728,-10.61003193,51.8897927,-37.6827654,84.2768267333,-20.9158219833,-32.5121307,-116.701707167,-1.40206217767,23.3140909833,12.2387996,6.105864935,3.05092006667,18.1258604333,-7.281007785,11.71475605,-9.76697846833,11.0528439833,-2.38794777733,-7.93315118333,-44.9951062833,22.0697083167,19.1454598,-3.55647360833,5.57221547667,4.78665278,3.33192418833,0.7785977225,6.96990455333,-0.5334322595,1.69902513667,-2.00026453833,2.60147215833,-0.298704304117,2.39109292,-15.32863145,10.99600355,4.09823703333,2.38981748167,-2.35331393833,-1.51500178333,-0.252547035333,0.535619457,1.061238115,0.705022825167,1.75805336833,0.933726269833,1.07367445333,0.449663789167,1.02189093517,0.449410010333,1.93000182667,-1.94521449167,3.14343904833,0.224188975333,1.37292596333,0.172472352883,-0.7086568335,-0.118201947517,-0.2948731275,-0.624178171833,-0.257093819333,0.216961770833,0.371428800667,0.200542909667,0.3743370195,0.295114853,0.440948466667,0.450963108333,0.1792525245,0.7499486535,0.0930031460167,0.843548400833,-0.541676611833,0.294480378833,0.36647093,-0.125295581917,-0.3383609725,0.303772004333,0.147663065],[-37132.9521167,581.589354,-4755.78674333,-1520.022625,958.341686667,2262.58914833,383.750121667,-2713.671035,941.833876,-812.236959333,-344.636178167,705.874429667,-1633.56057667,-846.975590167,-429.503693667,386.997299667,-557.444850167,-471.634001,320.683859333,-21.6834839533,-223.322200667,10.8668697,91.7699523,-345.238182,47.1550506,-60.0976698667,-90.86454415,24.19346265,66.53761865,-187.613244,52.9814008333,-38.4326263333,-94.59227275,252.316467667,-12.6427266133,10.8381876033,41.1119372333,6.52415516,-2.33722266,10.6953251483,-10.7406786917,-4.53821868167,53.1035071667,-40.10323365,85.15556475,-27.7740916167,-31.5180958,-113.250802333,-0.354279588333,23.5550409333,12.2478427833,7.64709657,3.28947854167,19.2387206833,-6.80796247,11.70619475,-9.73598182167,10.9280180333,-4.03187930333,-7.93635752833,-43.3764371,23.0816256,18.96024785,-3.43525997667,5.80170761333,4.90033544833,3.50685695667,0.953340783167,7.311432215,-0.724505862833,1.59871126167,-1.865921565,2.58886778333,-0.532221117167,1.99578744167,-15.0723352333,11.3318312,4.07361487,2.11255722667,-2.5698067,-1.57444649333,-0.208985458167,0.6047696115,1.00020838867,0.764827959167,1.795638705,0.8895138975,1.06772755667,0.495156327667,0.977201348333,0.542414319667,1.77426688333,-1.89263943667,3.16053036333,0.282739202167,1.30667486167,0.0290230155333,-0.742115826833,-0.0493213624833,-0.3194536625,-0.640535513667,-0.247973395,0.192736936167,0.394421790167,0.178850727833,0.3834497025,0.312571791333,0.463306383667,0.428279711833,0.219030839833,0.718530921333,0.09754824745,0.7938195255,-0.5393260395,0.286092111667,0.307669079167,-0.159462327833,-0.322050758,0.310813619833,0.152279094667],[-37226.2237667,853.272147167,-4525.29505833,-1563.08394,966.679141167,2245.91440167,354.721477167,-2447.002835,927.396019167,-796.436820667,-345.370447167,699.8952645,-1698.51476,-902.580169833,-530.255058667,369.541461,-546.697258833,-454.476264333,314.399704167,-33.4553655667,-224.290318,6.651965,109.18874215,-366.025253667,41.36609525,-58.8968011833,-84.9449292,21.5297098333,61.7685890667,-181.968085,72.3533729333,-39.6714534,-91.7192749667,252.339602,-23.4697419333,12.01300585,40.4550775833,6.87049633667,0.257471556667,9.31152654333,-7.27639673833,1.87886443667,54.18591815,-41.6341352833,85.6648542833,-34.8332045167,-30.8344074667,-109.303242167,0.709581131667,23.6742671833,12.2447913,9.121227665,3.520217235,20.3184067667,-6.27423440667,11.6439283167,-9.57370865667,10.7226254833,-5.61884297,-8.00255642,-41.5374098667,24.0750128667,18.8513013167,-3.29546666,6.046102795,5.02476949167,3.67484402,1.123652746,7.63478744,-0.925110002667,1.48746814333,-1.75828500833,2.53950096,-0.727185300667,1.558446945,-14.7722980333,11.6360318,4.08175473167,1.82518605667,-2.79928154833,-1.62652771,-0.151400920317,0.683244212667,0.939368945667,0.822356062833,1.826082275,0.833687125,1.059121655,0.520046160833,0.921490601167,0.646963043333,1.611107245,-1.83561554167,3.15651951167,0.3544528115,1.23032674333,-0.12368299745,-0.7756640445,0.0193684565167,-0.342351684333,-0.653213526667,-0.2367089205,0.169401451167,0.416886158667,0.155255117833,0.390060391333,0.329912169667,0.4808173955,0.404159907333,0.258066777333,0.685165667333,0.102129295667,0.734136029833,-0.53404646,0.273769980667,0.247400254667,-0.193921109,-0.304274781333,0.314625608333,0.157636439667],[-37271.1458333,1182.83051817,-4236.81986833,-1638.139965,1000.33122283,2209.06799833,330.575959167,-2174.500925,902.284169667,-775.486277333,-342.810481667,696.748306,-1748.32856833,-951.52287,-628.854079667,350.541000833,-536.031200333,-436.267253333,309.755168333,-41.6634305833,-221.738951,0.938599768333,128.845863167,-379.382067333,35.2949162167,-58.7183985,-79.6135674167,18.4171312333,57.77244515,-175.3710185,92.0615407333,-40.5661331333,-85.2084473167,252.090601,-35.07372075,13.0709632333,39.2142254167,7.07547664333,2.49395054833,8.09292963333,-3.6724483794,8.520165475,55.1760295333,-42.2640488,85.8885413833,-41.9627499667,-30.4491188833,-104.953595,1.77047476067,23.66470545,12.2539708167,10.5128674233,3.74856530667,21.37364975,-5.69734624,11.5639400667,-9.28027159833,10.4590920333,-7.13003842167,-8.13066399,-39.5199636333,25.0255306167,18.8252756833,-3.13529437333,6.29668078667,5.163089175,3.83092931667,1.28651309,7.94087019,-1.13256842833,1.378276295,-1.68009757833,2.46036918667,-0.8878386385,1.08369363383,-14.4392110167,11.8965387833,4.12454478333,1.534571875,-3.04091833667,-1.669062465,-0.0823716157717,0.769323176333,0.8782311495,0.876616972833,1.849086995,0.768396828833,1.050800015,0.522648931,0.856905990333,0.76002687,1.4420392,-1.77471036333,3.12877489,0.439794711,1.14782797667,-0.2832598635,-0.810590342667,0.08807136405,-0.363056751167,-0.6622502415,-0.223984954667,0.146899332333,0.438852532167,0.129407987333,0.394531280167,0.347030072667,0.492833427333,0.379146557333,0.295769736167,0.6505335105,0.106935599667,0.664969999833,-0.525810781,0.258724247,0.186744880333,-0.229123212333,-0.285136304,0.315445802667,0.1636632445],[-37289.7797667,1554.62027167,-3900.14960167,-1735.07227667,1062.15758467,2151.31022,307.197559667,-1908.209225,870.840913167,-747.486744667,-339.247713833,695.628502,-1787.63178333,-989.579912667,-726.74943,330.553888167,-524.856687833,-417.7696245,307.0636805,-46.7519054667,-214.537015167,-6.82799791,149.158628667,-386.08375,28.7657654167,-59.3704668333,-74.8112695167,15.1465603333,54.7632142667,-167.7277865,111.742743167,-41.5424594833,-75.42634305,251.673032,-46.9784653667,13.90939325,37.4434183333,7.21630848,4.44146452833,7.12577931833,0.0723586790667,15.2592556633,56.0849284167,-42.0546983833,85.8995838167,-49.0034925333,-30.3356351,-100.3058007,2.809373125,23.5173915833,12.2959338333,11.8174444167,3.98789953667,22.4089800667,-5.096871915,11.5004019167,-8.86226017667,10.1572908317,-8.54595239667,-8.31558268667,-37.3639598333,25.9042009,18.8790495167,-2.95329249333,6.54075317667,5.31546921667,3.96906501,1.43973972,8.22970638667,-1.34402997833,1.28340304667,-1.63189692167,2.35806308333,-1.02061336967,0.576213420783,-14.0825729833,12.1000427833,4.19926996333,1.24613408017,-3.293705465,-1.70009860333,-0.00565817352,0.860648367333,0.815104759667,0.9264311705,1.864174275,0.696437838,1.04521695,0.502652,0.7855450715,0.878097378333,1.26835570667,-1.71018699,3.07452201333,0.537612297667,1.06273300367,-0.4476520565,-0.848095885833,0.1574958882,-0.381064740667,-0.6677126505,-0.210462754833,0.124856244333,0.460223470167,0.1009647288,0.397487889,0.363681986167,0.499031638333,0.3538143185,0.331634871833,0.615260985667,0.112113081167,0.586836517667,-0.514987461667,0.242016350167,0.126636295033,-0.265580324667,-0.264569828,0.313727675667,0.170147476],[-37282.4971333,1949.33847,-3528.80906667,-1835.99366,1149.77740333,2074.13209,275.947148,-1657.238455,838.40476,-712.510112667,-334.886670167,694.326216,-1819.38886333,-1015.276369,-822.538760167,310.006512333,-512.769148667,-398.959113333,306.4837975,-48.6417630667,-202.477633333,-16.1922247817,169.106618667,-387.442670833,21.5300098,-60.5396910833,-70.3431859167,12.0425119483,53.0578202333,-159.1056705,131.2434155,-42.8787891833,-62.9470282167,251.0556695,-58.68091075,14.4145411167,35.2552697333,7.35716751,6.182728505,6.50945786833,3.94556755893,22.00525555,56.90246165,-41.10553385,85.7162108167,-55.7840619167,-30.4867174,-95.466361,3.80763263833,23.23297435,12.3758608667,13.0312937333,4.25443209667,23.4287850667,-4.48388167167,11.4633986,-8.32454024,9.82427516167,-9.84404586167,-8.565639005,-35.1089632667,26.6844012667,19.00730635,-2.74764603333,6.76431980833,5.47772352,4.0833048,1.5828238,8.50129886,-1.554407005,1.20674550333,-1.61026971,2.23711507667,-1.13087161833,0.0348844231333,-13.7099748333,12.2360602,4.30155855667,0.965937042833,-3.55584798333,-1.71774128167,0.0739915174283,0.9546085455,0.748490292167,0.970966581167,1.87076861167,0.620805383333,1.043234915,0.461169107667,0.709257514667,0.998055147,1.08969438183,-1.64174786,2.99263252333,0.645741402833,0.978351073333,-0.614861265,-0.8894348605,0.227303965167,-0.395914473833,-0.6698659345,-0.1965481015,0.102966582867,0.480750572333,0.0695822759667,0.399444509167,0.37963243,0.49937961,0.328623930167,0.365321257167,0.5796765985,0.117890116333,0.500684511667,-0.502302744167,0.2244447105,0.0678081598667,-0.303831432333,-0.242926553167,0.309904369333,0.1770710535],[-37243.9154167,2326.19240167,-3164.69542167,-1926.67387667,1257.55551167,1977.01134833,233.533191667,-1417.257825,809.284397333,-670.376689833,-327.385054667,691.5701395,-1842.53470167,-1028.83372167,-915.245262833,289.4025075,-499.239164167,-378.638018833,308.146248333,-46.8384247833,-185.709642333,-26.66255965,188.362510833,-384.765036167,13.444111975,-61.9350812,-65.8058122833,9.40793231,52.8809532667,-149.571832333,150.4866625,-44.6277145333,-48.4443583333,250.101858333,-69.7126521833,14.4901218,32.7510203167,7.54301478667,7.80499231333,6.30704764,7.93789589833,28.7004966667,57.62562505,-39.5646757167,85.3074139333,-62.11166815,-30.90465305,-90.5120014333,4.74279820167,22.81424435,12.4772958833,14.1519144,4.56346739333,24.4298263,-3.86169375167,11.4465683667,-7.68031499833,9.455184675,-10.9819701383,-8.88909246667,-32.7866622667,27.35072965,19.1961653833,-2.51829783167,6.95555843167,5.64003094667,4.166930065,1.71823009333,8.75135458833,-1.75760303,1.14499257667,-1.60892711167,2.101062705,-1.21698463667,-0.53922801455,-13.3282231333,12.2994131,4.42355135333,0.6967303305,-3.8234411,-1.72015948667,0.152330370483,1.04829427,0.676425023167,1.01031707917,1.86735059,0.5446222445,1.044011525,0.401346721667,0.630479574333,1.1175967375,0.906660365833,-1.56979146667,2.88357985333,0.761035909667,0.896220936,-0.782073370833,-0.934661862833,0.29661215,-0.407062705667,-0.669038779,-0.182350134833,0.0808693979667,0.500185505333,0.0349801271283,0.4009816735,0.3945295835,0.494310372,0.304261189333,0.396229794667,0.54423383,0.124246638,0.407684515,-0.488601599667,0.206310351,0.0111765740667,-0.343840144667,-0.220741432333,0.304167938167,0.184402953833],[-37185.4257333,2635.3849,-2852.58344667,-1997.48909833,1376.18583667,1856.87268,178.229832,-1184.15447117,787.461717333,-621.750347167,-315.240377,686.008340333,-1856.178785,-1030.65420667,-1004.42275333,269.465736,-483.890606,-355.732658833,311.8308265,-41.0508647667,-164.4018835,-38.0127151,206.6365215,-379.118913333,4.47123783333,-63.2968614167,-60.7845414,7.40703193167,54.37991095,-139.200093667,169.298688,-46.8276817667,-32.5560977667,248.617221667,-79.64561865,14.0617115667,30.0321822167,7.82991892333,9.37303933667,6.56787720333,12.0245527567,35.2617524,58.24512945,-37.5901587167,84.61048905,-67.8030923667,-31.5884186667,-85.50382675,5.59278184833,22.2688736667,12.5866047833,15.1778079333,4.92928712667,25.4003106,-3.23863198833,11.4417981,-6.95221572833,9.03772257667,-11.91841225,-9.29113700833,-30.4242994333,27.88757435,19.4269145667,-2.26624899,7.10498786167,5.79283384833,4.21483498,1.84885035667,8.97319037,-1.94795488667,1.09419506667,-1.62441098833,1.95242264833,-1.27724563,-1.14352594583,-12.9432704,12.2849234833,4.555974925,0.439736129667,-4.091990545,-1.70587317833,0.225715566,1.13867846,0.5974021015,1.04478287833,1.85209738167,0.4711650865,1.04625043833,0.325983910667,0.5516511735,1.23412719667,0.720257277167,-1.49502535833,2.74777451833,0.8800790425,0.817085193667,-0.9464357115,-0.983407586333,0.3645265905,-0.414042341,-0.665512987333,-0.168057552,0.0582848849833,0.5183160435,-0.00301444517,0.4027731045,0.4078774695,0.4843023485,0.281425919333,0.4235853635,0.509392044,0.131021022833,0.308935414333,-0.474651677667,0.187692322667,-0.04240291645,-0.3854072845,-0.198497174833,0.2966338235,0.1920573045],[-37128.0917667,2851.30509,-2632.922045,-2039.94197167,1495.626585,1703.71830167,115.56659455,-970.744474667,777.350404,-569.288027833,-301.800799333,678.371869,-1864.76996333,-1021.17745,-1090.3478,250.986158167,-467.055477333,-330.6296755,317.015620333,-32.2713747333,-138.334086333,-50.3578622833,223.641161167,-370.685109,-5.401327275,-64.5059970833,-55.0351499667,5.86880601,57.51438525,-127.937214667,187.353499667,-49.49769965,-15.6527313983,246.373018167,-88.1701770667,13.0815500833,27.2116538667,8.31513227,10.8649840933,7.34005874333,16.1979611667,41.5522499,58.7624470167,-35.31360765,83.5256903667,-72.7410479333,-32.5461204833,-80.5220933667,6.34546672333,21.6243867167,12.7182777833,16.1036638667,5.368676405,26.3280802667,-2.63951422333,11.4527834333,-6.18468561667,8.549978205,-12.6335735667,-9.782238645,-28.0614106333,28.2784722667,19.6807129833,-1.99137717333,7.21046912167,5.93472757,4.22687131167,1.977657865,9.15878383667,-2.12384680667,1.05434795,-1.66603878333,1.79280744333,-1.31563573,-1.77687198333,-12.5647349,12.1881808,4.69012382333,0.195322920933,-4.35780034,-1.67403534333,0.2919379495,1.22343430167,0.512052055667,1.07487805167,1.82271676667,0.403131891,1.04896587,0.234615743833,0.475226171167,1.34359787167,0.531090634333,-1.41922763167,2.58594715333,0.999357255667,0.741265613,-1.106006426,-1.03512280883,0.429869167167,-0.416807275833,-0.659604735667,-0.154378906667,0.0354305934333,0.535100988833,-0.0445500550383,0.405521984333,0.419113183,0.469586286167,0.260834444167,0.446300945,0.475558693667,0.137943588333,0.205495685567,-0.461354050333,0.168591419,-0.0925982075667,-0.428362377667,-0.176843123333,0.287449651,0.199941159333],[-37086.2055833,2970.08718667,-2509.064865,-2049.15831333,1607.16735167,1515.26028333,56.611593945,-791.460884333,781.868060333,-516.853099667,-290.899370167,670.323452667,-1872.84978333,-1001.37382917,-1171.97216833,234.516567333,-449.706086,-304.4641245,322.795873667,-21.5808702367,-107.214227133,-63.2985492833,239.495608,-358.896533,-16.1277492667,-65.6182035333,-48.5311384333,4.36928447333,62.2339330667,-115.676334667,204.420167333,-52.4980620333,2.19426487333,243.150054167,-95.0513754667,11.543617275,24.3963024333,9.074275645,12.1933146833,8.67752134667,20.4571506167,47.4448970833,59.1908299167,-32.7877523,81.9590337833,-76.8295002667,-33.78406345,-75.6053502167,6.998423235,20.9230587667,12.8969647167,16.9190702833,5.896178185,27.1961918667,-2.09069723833,11.4798034333,-5.41473778833,7.971592345,-13.1054988667,-10.371442615,-25.7218482,28.5099519,19.94209385,-1.69277639667,7.27616384167,6.06995394667,4.2064938,2.105686105,9.29680733167,-2.285404835,1.02318194183,-1.74580352833,1.62252509167,-1.33354407833,-2.43681735,-12.1970902667,12.0059675167,4.82125734667,-0.0365033904333,-4.61596841167,-1.62422704333,0.3501207795,1.30119929167,0.422857483333,1.10055477,1.77610377333,0.342507837333,1.05010795833,0.125382939753,0.4023569715,1.442536285,0.3399991715,-1.343424245,2.399290645,1.11739497533,0.66879536,-1.25828893667,-1.08905433167,0.491175419333,-0.415622508833,-0.651645368167,-0.142195687,0.012947795265,0.550411119,-0.0897143342833,0.409752424667,0.427432830667,0.450065210667,0.242618377333,0.463307752333,0.443038941833,0.144837325667,0.09843777425,-0.448859156,0.148978095833,-0.138931137583,-0.472498943167,-0.156473788333,0.2766564745,0.208040402],[-37064.1944833,2976.51535167,-2440.61883167,-2036.519375,1703.0163,1301.44004833,11.5349662467,-645.140018833,798.813924667,-466.820950333,-284.616228167,663.354049333,-1879.74944667,-975.230815167,-1246.18445167,220.395671667,-432.626640167,-278.769919333,328.223801,-9.29173193833,-71.9336430833,-75.7454852167,254.771875167,-343.06145,-27.3650895667,-66.8447971833,-41.5830234,2.47251831178,68.4304400333,-102.575248267,220.427358,-55.6320584833,20.965174835,238.686171833,-100.346908967,9.531709415,21.6170849333,10.094685365,13.2667839833,10.5724858183,24.76986875,52.8472778,59.4962994333,-30.0437858667,79.8223672,-80.05343565,-35.3201512167,-70.6770221333,7.55401837667,20.1986474667,13.1464613,17.6133703167,6.50715731333,27.9922238,-1.61313800667,11.5017572833,-4.671312985,7.29029372,-13.3130108667,-11.0701837167,-23.38551145,28.5833751333,20.1904578667,-1.372906185,7.311118345,6.209791075,4.15811045667,2.22983445833,9.38018987667,-2.43374902667,0.994908498,-1.87164228667,1.442138385,-1.324764425,-3.12009894833,-11.8356796167,11.7402840667,4.9448073,-0.259169558067,-4.86040329167,-1.55691948833,0.401908091333,1.37282343667,0.332764831,1.121105115,1.71062783333,0.290119827,1.04783783333,-0.00208463615467,0.332661596833,1.52996588833,0.148059359767,-1.26849157,2.18944953833,1.233760665,0.597963330667,-1.40018065,-1.14412628667,0.5466432235,-0.410813009667,-0.641562614667,-0.132275752667,-0.00844186359,0.564161803833,-0.138275337033,0.415565373833,0.432289848833,0.425883645333,0.2260481955,0.473800079333,0.411888713333,0.151160182667,-0.01154418,-0.436674017,0.128355475667,-0.1806569605,-0.517535674,-0.138175293333,0.264065878333,0.216347441667],[-37052.3208,2874.44319667,-2384.118115,-2016.33493667,1780.97842333,1074.376619,-15.6501809383,-520.214586167,823.6728345,-420.661565167,-284.060131667,658.5858155,-1881.68250667,-945.559950833,-1308.92279667,208.457672333,-416.543707333,-255.079798667,332.8007015,4.85764704667,-33.4505656117,-86.3389047,269.420649667,-322.589771,-38.8022101833,-68.4612483,-34.6519818,-0.0927020612,75.9788602167,-88.8723495167,235.392217333,-58.9329698,40.6850257167,232.785776167,-104.073368833,7.14144157667,18.85084745,11.3086546667,14.0068369333,12.9685594667,29.07991225,57.6957277833,59.6017693833,-27.0685444167,77.0387892667,-82.37695915,-37.2037377167,-65.6799508,8.02100739667,19.4656621333,13.4819915,18.16709165,7.18130349833,28.7047214,-1.22133323017,11.4944478833,-3.96700933667,6.49167476833,-13.2335380833,-11.9036984833,-21.0345759833,28.4980681667,20.4145809,-1.03217573933,7.32188691667,6.36609061833,4.08253552,2.34331441667,9.40552824833,-2.570318185,0.9647904215,-2.04774399333,1.24862276833,-1.28145884333,-3.82780936,-11.47467135,11.3924650333,5.059580915,-0.475330357667,-5.088239025,-1.47196148333,0.4497321845,1.44010539167,0.2440178805,1.13491542,1.625680705,0.245499883167,1.04091538833,-0.147894484914,0.264423571,1.60573674167,-0.0446282702667,-1.19472769167,1.95731302833,1.348178465,0.527107645833,-1.53011313333,-1.19997085167,0.594956065833,-0.402504358833,-0.628734385667,-0.125069695833,-0.028086946835,0.5761608805,-0.189971142833,0.4224606545,0.433290918833,0.397004068833,0.2101719575,0.477202177167,0.381907580833,0.156462527833,-0.12406806385,-0.424401210833,0.10603209555,-0.217342590333,-0.563450838,-0.122563491333,0.249717671833,0.2247503425],[-37029.4773667,2691.38815333,-2299.17078333,-1995.624855,1842.98982333,845.31711,-30.4034743167,-406.744081167,852.938490167,-380.2273465,-290.062138167,655.546726833,-1875.00342333,-914.0135235,-1355.68535167,198.310232667,-402.212078667,-234.7631565,336.343607167,21.2792260917,7.32747018667,-94.0597025833,283.0654305,-297.769254333,-50.2622802333,-70.6147208333,-28.16490525,-3.37257560822,84.7609547333,-74.8417084667,249.139308333,-62.5636083833,61.11133635,225.174987667,-106.131889667,4.44385553833,16.1086180167,12.6545121,14.3820416833,15.7853524833,33.3194760667,61.8833683833,59.41061185,-23.8780647167,73.4972240833,-83.7416581833,-39.4550973833,-60.6179104833,8.40839675833,18.7329905333,13.91572425,18.5622105,7.89216875167,29.3270219333,-0.925956041667,11.4350543167,-3.30784218167,5.55789260167,-12.8573449,-12.8877441333,-18.67270155,28.2401559333,20.6022578,-0.6704270845,7.30920574333,6.54837944667,3.97883976667,2.44018636833,9.37396959833,-2.69127726167,0.930358635333,-2.27552673833,1.03973996733,-1.20233161167,-4.560608585,-11.11329665,10.96034265,5.16229882833,-0.684664397667,-5.298024745,-1.36921565333,0.4943682675,1.50454162833,0.158207741367,1.14112349167,1.521852365,0.209167431,1.02924656833,-0.311964964167,0.196592641833,1.668414795,-0.238451980733,-1.12312673333,1.70340806333,1.458745665,0.455600134667,-1.64767691167,-1.25672589833,0.634504812167,-0.390737423667,-0.612579075667,-0.120890780333,-0.04556802495,0.586361142833,-0.244509479667,0.4297655095,0.430346275,0.363341365833,0.194319316667,0.473023237167,0.352751681,0.160206051667,-0.23849438,-0.412178636333,0.08135434545,-0.2490261665,-0.610298005333,-0.110416178333,0.233890583833,0.233212805167],[-36964.6048167,2480.68882667,-2176.81979667,-1975.76577,1898.51416,622.6332155,-36.4174178333,-296.2618345,885.381420167,-346.046742667,-301.781035167,655.666590667,-1857.13599333,-880.647247833,-1385.81290333,189.9223825,-390.085660167,-218.288763667,339.463858833,39.4664219167,50.319289105,-99.9064015833,295.812279667,-269.987543333,-61.5731980667,-73.2842059833,-22.2663172833,-7.154076415,94.3988810667,-60.5427536,260.987696667,-66.4565310833,81.4981517833,215.531264833,-106.479132333,1.477181525,13.4590607667,14.1215122667,14.4312490667,18.94147225,37.4757003,65.2416935833,58.9135901,-20.6186776167,69.0865069667,-84.1443535,-42.0198503167,-55.5551933,8.70248154,18.0181843667,14.4584691,18.7965964167,8.64042594167,29.8737543,-0.722034825,11.3298358833,-2.71549470667,4.49430872667,-12.2016354667,-13.9983362667,-16.3326207333,27.8009364333,20.726477,-0.295070583583,7.27041778167,6.76342750333,3.84770980167,2.52813218,9.29307075,-2.78037304167,0.897587957167,-2.55480568167,0.82703377,-1.09642104883,-5.30409049667,-10.7633701,10.447566675,5.24135891,-0.887084586333,-5.48986789667,-1.24959173167,0.533455904333,1.566954705,0.0763342510958,1.14250434167,1.40118686833,0.18545038,1.01520337167,-0.492200431167,0.13307556035,1.71433859167,-0.429696856667,-1.05790595833,1.43088046167,1.56060692667,0.382980594333,-1.75372372333,-1.31365918167,0.663617132333,-0.375324779833,-0.593594938667,-0.120234319667,-0.0610126891167,0.594999234333,-0.301464840333,0.437477812667,0.423922975333,0.325686996167,0.179146545167,0.460764835333,0.324929665333,0.161470790667,-0.353180833667,-0.4008253985,0.0538394399667,-0.276273491,-0.657554026667,-0.102626840783,0.2170064195,0.241639246667],[-36834.5685833,2293.20073667,-2024.20156333,-1964.80591667,1956.27815,417.117353333,-36.5181278167,-176.383770017,919.047763833,-318.9727915,-316.2406495,661.710756833,-1824.485615,-842.835998167,-1397.31251,183.6468555,-380.724527167,-205.642862167,343.101671167,58.83187115,96.24767545,-104.775809667,308.2045415,-241.108127167,-72.3396076,-76.4381134833,-17.0747241167,-11.2387715033,104.45732505,-45.9896231833,270.198449167,-70.4075170667,100.934279217,203.513306,-105.0870445,-1.67148028667,11.0004840517,15.6810610833,14.1585624833,22.3605064667,41.4861884167,67.5838599167,58.1134318,-17.4409926167,63.7064389833,-83.5731141833,-44.8073048333,-50.5229448167,8.88648420667,17.3547660333,15.1150842167,18.85914165,9.43367495833,30.34003695,-0.602172835,11.1818073167,-2.20093876167,3.32275598833,-11.2774262167,-15.1902321167,-14.0334896167,27.1813957667,20.7548543667,0.0814826973333,7.207032905,7.01782485667,3.69167131833,2.61717492333,9.16699997,-2.81802307,0.8706317365,-2.88158241167,0.627556277167,-0.97087301,-6.03546494667,-10.4343393333,9.86324108833,5.28296278667,-1.08198445533,-5.66458569833,-1.1155976905,0.564780645833,1.62834056,0.00147859151667,1.14220715833,1.26613729167,0.179594927167,1.00068879767,-0.685734173,0.0783325467833,1.73997980667,-0.612788061333,-1.00331430283,1.14450111217,1.64822201333,0.309258327833,-1.84934325167,-1.369878315,0.680917983167,-0.356381042167,-0.572629315,-0.1236390565,-0.0739356977667,0.602238287,-0.359847855333,0.445639272667,0.414421058833,0.284904165333,0.165076300333,0.439912063,0.299002718667,0.159335410667,-0.466075477833,-0.391099299333,0.0232409004917,-0.299544606167,-0.70448169,-0.0998935666333,0.199628063667,0.250022801167],[-36641.3487333,2131.47167,-1880.917105,-1963.01897667,2012.32297833,235.713307183,-42.3777413333,-55.8450778667,955.9775425,-300.310689833,-329.749923,674.190982667,-1778.21204333,-800.718294,-1389.51713333,180.478557167,-373.893349,-196.3881815,347.859499667,78.6426832667,145.00278365,-110.122629667,320.9651605,-213.109810167,-82.2081431,-79.74436435,-12.61188006,-15.4176015,114.702758,-31.3048097167,275.955304167,-74.2729828833,118.359106333,189.085218,-102.188743333,-4.95500100833,8.882170695,17.3109229333,13.59643685,26.0076455667,45.2849874,68.7440491833,56.9366690167,-14.5513052667,57.3467771167,-82.1074506167,-47.7054951,-45.57880865,8.93671423,16.7756879667,15.8840908333,18.7508626167,10.272497065,30.7201011333,-0.550694541833,10.9690009167,-1.78629894667,2.06768627117,-10.11679179,-16.4043816,-11.8029355233,26.3729808667,20.6703888333,0.446494174417,7.11768756667,7.31462538,3.51701017167,2.71316166333,8.99940151,-2.78553213667,0.850255250833,-3.25072735167,0.450419933,-0.8356651175,-6.72752853,-10.1350167367,9.212639745,5.27798054833,-1.26388453833,-5.81775025,-0.970071058,0.585322504833,1.688856355,-0.0626306790042,1.14309903,1.119534017,0.1957668545,0.988079251833,-0.888375360667,0.034046529365,1.74147392333,-0.781955651333,-0.963054471667,0.8483502505,1.71585130833,0.236142993167,-1.93379436333,-1.42368734167,0.684460247833,-0.334241057333,-0.550667299833,-0.131600919333,-0.0839130182,0.608462087167,-0.418243822667,0.454138566667,0.4026413695,0.2421555645,0.152297458333,0.4099797975,0.275155203833,0.152929340167,-0.575097507333,-0.384203792333,-0.0104288980167,-0.319211761333,-0.749887048667,-0.10299402995,0.181756580667,0.258335650167],[-36391.4395833,1975.69706,-1786.97830667,-1962.85520667,2055.92190167,86.5596754167,-68.5886062833,47.6332902833,999.842954333,-291.431851667,-337.170526833,691.652848,-1720.51099333,-756.505165333,-1363.89242,181.1656,-368.953251833,-189.280399667,353.6415,98.6718091,195.9982075,-117.474736,334.921481,-187.552436667,-90.9806301,-82.7975967,-8.67077694333,-19.5505082333,125.169083167,-16.615096255,277.72486,-77.8536116167,132.791851667,172.550606833,-98.1501135167,-8.33910619333,7.23788750833,18.9977602,12.8080928833,29.89915265,48.8167588667,68.6744905333,55.3024924,-12.1408942667,50.0962398667,-79.87562245,-50.5910011667,-40.7936277667,8.837609325,16.3046396333,16.7446258333,18.4820066833,11.1549881667,31.0043651,-0.535438514167,10.6576033667,-1.486451575,0.758740924667,-8.76176205833,-17.5779743833,-9.66848468,25.3649390333,20.4715057667,0.789875334167,6.999762855,7.649518305,3.328918415,2.81868380667,8.790600655,-2.66696763833,0.831916059,-3.65168490167,0.298038179667,-0.6992148335,-7.35264688,-9.87029349167,8.49997635833,5.224352605,-1.42472432,-5.94074785667,-0.815825055833,0.59242658,1.74793332167,-0.1134284622,1.14750516,0.9633889015,0.236782745,0.978619502167,-1.09378194183,-0.000375924373333,1.71645363167,-0.931758277667,-0.939238921667,0.546101255167,1.75913434667,0.166635106,-2.004650465,-1.47300351167,0.672633895667,-0.309387280333,-0.528505982333,-0.144274634333,-0.0907217959667,0.614069244667,-0.475180225833,0.462851777,0.389447822333,0.198991726,0.1408556205,0.371015063,0.2533902705,0.141781120167,-0.678269328833,-0.381273202333,-0.0467365324417,-0.335350687667,-0.792379379167,-0.112482929167,0.162919063667,0.266508164167],[-36098.1280833,1807.37947667,-1733.29205833,-1960.43886667,2079.16522833,-20.8417475833,-112.068792317,127.0678332,1051.46324633,-293.170168833,-335.422201167,714.243446167,-1652.223185,-711.320504833,-1324.86942833,185.5807765,-365.618363667,-183.273573,359.2785395,118.678233417,248.479796,-127.9242995,349.831471333,-165.309679833,-98.5155670167,-85.4675275,-4.89877748333,-23.8695864333,135.860430333,-2.11522778667,275.560972167,-81.0653094667,143.6474035,154.320407333,-93.1708179,-11.724130835,6.10944909333,20.77572775,11.8412388833,34.05682215,51.9967191667,67.4754884833,53.21341965,-10.2944724683,42.1060776,-76.9744811,-53.3267122667,-36.1863988667,8.60316971833,15.9569628167,17.6681952833,18.0769385167,12.0854511,31.1730717833,-0.532334357833,10.2433021817,-1.29955009833,-0.558541223833,-7.26505906333,-18.6566761,-7.64547700833,24.1659042833,20.144599,1.105170306,6.85625471167,8.01108703,3.13200001167,2.93579269167,8.53926126667,-2.459762565,0.809923226,-4.07252421,0.174125586783,-0.5704947575,-7.89219893833,-9.64329445,7.73424622333,5.12047656167,-1.56370560333,-6.02901307167,-0.6567382555,0.585870943,1.80442502333,-0.150553996167,1.15637466167,0.799048883,0.302955730333,0.970657248167,-1.29597953167,-0.026084573035,1.66457419167,-1.05907596383,-0.933861734333,0.240730821117,1.77644322333,0.102118802233,-2.06028726667,-1.51645220833,0.646425574667,-0.282653910167,-0.5065663735,-0.161304467333,-0.094467461,0.6191382175,-0.529463077333,0.472015606,0.375045502,0.156817349,0.130491877333,0.323891885333,0.233755775,0.125667175667,-0.774243314667,-0.382307922,-0.0847740150667,-0.347689446,-0.830771551,-0.128132391167,0.1430810305,0.274494445333],[-35813.4947333,1638.24600667,-1678.89661,-1965.09181167,2078.89537833,-86.8469438167,-170.2717595,173.051417333,1107.943275,-308.747899667,-324.6503345,741.129407833,-1575.99281,-666.1443495,-1273.92786333,193.069409,-365.088559833,-177.828868,363.385827833,138.680889,301.148977167,-140.914652333,366.119248667,-147.297004167,-104.72463525,-88.0484701167,-1.08138271,-28.7794115833,146.865245833,12.0023400783,269.894491333,-83.63262015,150.578147667,134.635256333,-87.6136989167,-14.9821141,5.45082877667,22.6826825833,10.658311595,38.4401430333,54.7343463167,65.2600100833,50.7166111333,-9.05639694,33.4814953333,-73.5440820333,-55.7817948,-31.7197039,8.28089117833,15.7456095,18.6374660333,17.5459530833,13.03913745,31.1971912667,-0.543931184167,9.72813294167,-1.2205282,-1.85907040833,-5.69791504833,-19.5877983,-5.737093535,22.7982711,19.6848975833,1.395318365,6.69831382167,8.38861433167,2.92973460167,3.06008666,8.24548862333,-2.173554885,0.777366084,-4.50268675,0.0807161553333,-0.458101625333,-8.33652710167,-9.45149639,6.93090335833,4.96687722833,-1.67956455833,-6.07874945333,-0.496963284,0.568417462333,1.857485345,-0.174231250833,1.16994830833,0.628118805,0.392121944,0.961914591,-1.49131358333,-0.0434933620833,1.58725156833,-1.16375459833,-0.947895209167,-0.0633876930333,1.76803597667,0.0433880676617,-2.09983954167,-1.553758535,0.606941623333,-0.255415008333,-0.484902965,-0.1820880325,-0.0951351039833,0.624240152167,-0.5804187995,0.481800209833,0.359646539333,0.116397786233,0.120912332333,0.269774365167,0.216053466667,0.104579031283,-0.861804290333,-0.387064779,-0.12333222625,-0.356247721,-0.864732219833,-0.149475995333,0.122260116667,0.2825856235],[-35597.0784667,1489.39783,-1588.78596,-1990.82138167,2055.79887833,-117.507151833,-240.6283835,172.2656735,1165.21874833,-340.924040667,-306.386873833,772.3252315,-1495.923715,-620.797629833,-1212.37419833,202.892855167,-368.793152167,-172.664325333,365.087060167,158.5014155,352.919721,-155.873686333,384.559821333,-134.563291167,-109.529816833,-90.9968124,2.92587314167,-34.6123955333,158.245686,25.6059981333,261.066739333,-85.1539127,153.208293833,113.665173567,-81.9369537167,-17.9959730667,5.15806326167,24.7551685167,9.18510327833,42.9895132167,56.94538355,62.1019256,47.8818063,-8.491863,24.3228719833,-69.7503239,-57.81956875,-27.3404743167,7.91934819333,15.6723548333,19.64194975,16.8788805667,13.98337325,31.0466958833,-0.582074132167,9.11963643833,-1.25446300333,-3.11229344167,-4.13843418333,-20.3126956,-3.94566701167,21.2908474,19.0910929333,1.66592189,6.53762981667,8.773239785,2.720811045,3.18519006,7.90977106,-1.82012493833,0.7292557545,-4.934923225,0.0242061436167,-0.371366813667,-8.67440422833,-9.29173805667,6.10835265167,4.76474362167,-1.77060242667,-6.08639474,-0.339619242667,0.543966928833,1.90645405667,-0.185172817833,1.18817874667,0.451980508167,0.501509766,0.950520248,-1.67742120333,-0.05160747135,1.48552098,-1.24513956833,-0.982644226667,-0.360910459217,1.73427984,-0.00883145718667,-2.12258634333,-1.5848807,0.5550857585,-0.228809949667,-0.463156916,-0.206040342667,-0.09255515845,0.630043530833,-0.627717369333,0.492199177667,0.343456068333,0.0781538438833,0.111920706833,0.209553777,0.200287652333,0.0783610565833,-0.939543931333,-0.395359373333,-0.161038966333,-0.361076643667,-0.894082424333,-0.176014310167,0.1005030601,0.291186011667],[-35472.9691833,1399.709165,-1441.477485,-2041.81340167,2021.85661167,-120.0730785,-314.751802833,109.296976958,1220.25094667,-388.210287167,-284.003682667,809.4798275,-1418.01152167,-576.2158415,-1142.61950667,213.9965395,-377.132569667,-168.106307667,364.4366725,177.620233833,402.863243333,-172.597199833,405.6835805,-128.1938845,-113.135121,-94.6896345667,7.16146259,-41.4335872667,169.938772,38.5982380667,249.2967585,-85.3954382667,151.190699,91.5161667833,-76.54160425,-20.7468443333,5.07785068333,27.0117985833,7.401530995,47.6081721167,58.6141548667,58.0555466667,44.7806739667,-8.67933468667,14.7132203183,-65.7652239833,-59.3121986833,-23.0066710167,7.551007485,15.7066501833,20.6742727167,16.0702116833,14.8794454,30.71782345,-0.662129010833,8.43258602,-1.41065595333,-4.29638939167,-2.66000742333,-20.7772010167,-2.27181575367,19.6674996833,18.3584856667,1.92392730667,6.37531085167,9.15808721167,2.50073186833,3.30216339167,7.538188155,-1.41387523433,0.667579049,-5.36451447333,0.0108542579333,-0.322630482833,-8.89738905167,-9.16306263333,5.28008785167,4.51232838667,-1.83688859833,-6.04802409,-0.185586364867,0.514822312,1.95082629667,-0.185997397333,1.21032604333,0.2729734122,0.627102428,0.937187041833,-1.85313702,-0.0489431344833,1.35915852,-1.303449355,-1.03948325567,-0.6474824255,1.67502762167,-0.0544409597217,-2.12777270167,-1.60961765667,0.491659455333,-0.203127355333,-0.440792241,-0.232519167333,-0.08722319475,0.637147714,-0.671228449667,0.502734762333,0.327071136833,0.0420557663667,0.103647178433,0.1437192632,0.186197530333,0.0465694282533,-1.00649164383,-0.407226944333,-0.197067662,-0.3623396595,-0.9187297235,-0.207177181167,0.0778182386667,0.300634279],[-35433.4640667,1399.79105667,-1238.78482,-2119.16096333,1997.400115,-99.5091882667,-379.587301167,-16.0900101667,1269.90311,-443.7005365,-260.099466333,854.948404167,-1346.286325,-533.496384333,-1070.18467,225.275912,-389.1352345,-164.482446333,361.962463167,195.414960167,450.292839833,-191.284904833,428.946936167,-128.5452755,-115.8926155,-99.4727516,11.5582744017,-49.1465854667,181.7181295,50.8451415,234.949786333,-84.5263508167,144.432288833,68.4666657167,-71.80498725,-23.3083884,4.96935821167,29.4164752167,5.34261694667,52.1801656333,59.7565835,53.2630455,41.46024985,-9.682977505,4.77341706167,-61.7613215,-60.2164822333,-18.6974093167,7.18303432667,15.7826474167,21.7215377667,15.1264898667,15.6961746833,30.2234813167,-0.786787973667,7.69001266667,-1.700468225,-5.40324605,-1.31970717117,-20.9557524167,-0.716462308667,17.9627538833,17.4917637,2.17535497833,6.20457590667,9.53823033333,2.263251215,3.40129073333,7.141204335,-0.973198770167,0.600685524167,-5.78619349,0.0402348856,-0.321814516333,-9.0023858,-9.06609186833,4.45931998167,4.20969153,-1.88304665667,-5.96419497667,-0.0332643059667,0.482431027333,1.99054190333,-0.1814842445,1.23404019,0.09456022295,0.762815401333,0.924317150667,-2.01662933833,-0.0352647746667,1.208038845,-1.33927566333,-1.11920543833,-0.919718178833,1.590514885,-0.0949447576333,-2.11629881,-1.62752989667,0.418961965333,-0.177590262833,-0.417201621167,-0.260835264333,-0.0804428306333,0.645636652667,-0.710888416167,0.512475161333,0.311187269667,0.00808881281667,0.0964209405333,0.0725522010633,0.173314711333,0.00878162429667,-1.06255541167,-0.422853928667,-0.231243718667,-0.360491129333,-0.938668699833,-0.241704720167,0.0543362801167,0.31079677],[-35458.1226333,1495.230385,-1002.63662883,-2226.537305,2000.16081,-59.9180871217,-426.362702,-188.635268208,1310.53336333,-498.962634667,-234.875898833,909.702653,-1281.32113,-492.179335667,-1001.76699683,235.9936075,-403.204059167,-161.4121165,357.951249,211.414278,494.860170833,-212.056413,453.2184185,-135.263354333,-117.985634,-105.609135267,16.0923125167,-57.6197731,193.297194833,62.2387373167,218.578340667,-82.8350456,133.053424333,44.9959691833,-68.1300431667,-25.7446540667,4.59119838833,31.90473135,3.07933852567,56.6070543333,60.3800820333,47.9382269,37.9655482667,-11.5301192433,-5.32030206167,-57.8987683167,-60.5578557833,-14.39637575,6.80968967833,15.83622795,22.7629248333,14.0654412167,16.4190575333,29.5737247167,-0.9467469125,6.92222991,-2.13155929,-6.42210264833,-0.1617203565,-20.8438244167,0.719157062,16.2232287333,16.5091758833,2.421839245,6.02023746833,9.90843345,2.00404667,3.47678461167,6.72939599,-0.516313387667,0.538695593,-6.19184741333,0.1092980821,-0.372805073833,-8.986850945,-8.999266095,3.662634365,3.86257208,-1.915391905,-5.839383925,0.1185947413,0.448338944333,2.02568699,-0.176438561667,1.25675606833,-0.0794289477,0.902624748667,0.914125977167,-2.16445991333,-0.0107820475667,1.0334082015,-1.35183353333,-1.22172610167,-1.17416583967,1.48211987833,-0.13246789095,-2.09024910333,-1.63809674333,0.340621423333,-0.151286477833,-0.392037349833,-0.290316253667,-0.0736289421833,0.65520876,-0.7464685155,0.5207405855,0.29635194,-0.0233624222,0.0907278881667,-0.00345373546333,0.16156436,-0.0351044786133,-1.10787253667,-0.442185673,-0.263405948,-0.355961681333,-0.9538263125,-0.277755322667,0.0303145429967,0.3211656585],[-35528.0263,1646.17719667,-751.921254,-2368.91632,2030.56725,0.23178903,-464.6512605,-377.1486755,1339.33836333,-548.996540333,-204.821924,969.256019,-1217.62684167,-450.904684,-938.1680695,246.400332833,-417.643616667,-157.385342833,352.006727,226.611699167,536.3156685,-232.8093015,477.713936833,-147.087185833,-119.1720015,-112.977816,20.8669551833,-66.6055776333,204.649674167,72.6445457333,201.229865167,-80.52860965,117.71140975,21.433635075,-65.80245405,-28.0356424167,3.87661544333,34.38049495,0.763565577667,60.8344366333,60.4787205167,42.3781799667,34.3124460667,-14.0244457833,-15.4543899117,-54.2315985833,-60.41308195,-10.0432102,6.41847490667,15.8504958667,23.7614776333,12.93147075,17.0445072833,28.78023765,-1.11509956333,6.140834765,-2.64728997167,-7.35792313333,0.8269461815,-20.4633357667,2.05974457267,14.4923128667,15.4448204667,2.65453654833,5.823507165,10.26093827,1.72764189167,3.52644771,6.31666034333,-0.0550169363333,0.487616662833,-6.55916059667,0.2121503455,-0.455421200167,-8.85554253667,-8.94761725333,2.90282635667,3.48626027833,-1.93916705,-5.678017845,0.267400994333,0.412922138667,2.05652475333,-0.173000683833,1.27659136333,-0.243539774683,1.04281070483,0.9090124385,-2.290782455,0.02408849055,0.843933023,-1.34156404167,-1.34180976333,-1.40970299333,1.35493318333,-0.169208341333,-2.05075795333,-1.64149275,0.260216362167,-0.124062570983,-0.366070538667,-0.320146925,-0.0677164997167,0.665431890167,-0.777179306667,0.527447100833,0.283614598167,-0.05154129145,0.0871252258833,-0.0820094806033,0.1508412095,-0.0832999236333,-1.14353536167,-0.463749755833,-0.29370881,-0.348290585667,-0.964415357667,-0.313388278,0.00590548043667,0.331343475833],[-35623.0525333,1768.19831667,-526.177395,-2543.30231,2077.41046167,78.6574860117,-503.0127695,-554.6484415,1356.70688167,-590.079259833,-166.048145667,1028.7412005,-1150.85717167,-407.644648833,-881.252261333,257.527236,-430.411810667,-150.474325667,343.329469667,241.846514333,574.460366833,-251.994148833,501.394776667,-162.369513333,-119.107384333,-121.2108185,26.0993918333,-76.01012175,215.784910833,81.8759362833,183.732145333,-77.9331035,99.1878201833,-1.92470331667,-65.0296676,-30.17953425,2.84016407333,36.7595178667,-1.48749040933,64.8391461167,60.0057487,36.82747635,30.4599875667,-16.9521138,-25.5312219,-50.76829905,-59.8740493833,-5.59877646833,5.981575955,15.8253356167,24.6765183167,11.7701043167,17.5790169333,27.8395158667,-1.27014113,5.340994865,-3.20061445,-8.22164684667,1.6722430965,-19.8446466333,3.31654146,12.8066341833,14.3297134167,2.86023353333,5.61686278,10.5856114333,1.44400735333,3.54995622167,5.913937795,0.400434325167,0.450277168667,-6.87142188667,0.340581287167,-0.5469850035,-8.61513634167,-8.89964977333,2.18872089167,3.09416321833,-1.958227835,-5.48353402667,0.409925218333,0.375916050333,2.08271238667,-0.170820615833,1.29162397167,-0.392116157167,1.18065446333,0.910994477333,-2.39130326,0.0683382194833,0.647934005167,-1.30918698667,-1.47514992833,-1.62666506,1.212924585,-0.206804419167,-1.99829791333,-1.63752133333,0.181198468833,-0.0957677567667,-0.340457355833,-0.349522985833,-0.06307361545,0.675697143333,-0.801795815333,0.532851797333,0.274084640667,-0.0758611288833,0.0860589224333,-0.16113552405,0.141038591333,-0.13410235045,-1.17100321,-0.486346725833,-0.322127004833,-0.336721711667,-0.9703457115,-0.346667409167,-0.01881262872,0.340891229],[-35714.5659333,1808.21066167,-330.084954667,-2735.00467,2133.83814,173.09164735,-535.826106333,-712.383610167,1365.647225,-619.757424,-118.127981933,1086.78025333,-1080.96032833,-362.101791833,-834.874763833,270.2443715,-440.194546333,-140.0462455,331.156473833,257.519719833,608.649750167,-269.168532833,523.3621425,-179.273009,-117.683335833,-130.063766667,31.83845935,-86.01487275,226.819555167,89.7713170167,166.593707167,-75.31017225,78.3072775167,-24.6896069417,-66.0655556667,-32.23321805,1.50184639823,39.00493545,-3.66984561833,68.6396399667,58.9528294833,31.4730971667,26.3685678,-20.1360905833,-35.4009356,-47.56005035,-59.0246382667,-1.06591223833,5.470263045,15.7684211,25.4935253833,10.6083564683,18.0287492167,26.7565007167,-1.39002446667,4.51613333833,-3.77315217167,-9.00899978167,2.38096726333,-19.0172252167,4.47948755,11.1941234117,13.1940036667,3.03035382,5.40475513167,10.87643565,1.16592674733,3.544048865,5.53046080667,0.8421849345,0.428418250667,-7.12346679333,0.486503637833,-0.632021518167,-8.27242310667,-8.85061959667,1.52627637583,2.69880588667,-1.97278772333,-5.25820691,0.544519233,0.3372560595,2.10321593167,-0.1672382085,1.29899560167,-0.521044065,1.31345959833,0.921501488667,-2.46445492833,0.119510801283,0.4517910015,-1.25533564833,-1.618985425,-1.825244215,1.059460598,-0.245089046667,-1.933119685,-1.625930735,0.105994143883,-0.0661119611333,-0.316348250667,-0.378131569333,-0.05953744,0.685277568667,-0.819489932667,0.536991498,0.268624677167,-0.0958971366167,0.0872931300333,-0.239215691667,0.132133387333,-0.1861494935,-1.19135812,-0.509169212,-0.348070410833,-0.320766897167,-0.971469092667,-0.376160031333,-0.0438747647,0.3495052555],[-35770.1140833,1765.63748167,-152.371622067,-2924.15279333,2199.322725,276.5425795,-557.224628167,-856.3584715,1369.43728333,-637.743758,-63.0529256833,1143.13916667,-1009.9613055,-312.334776167,-801.409193167,284.749919833,-446.701362167,-126.196160167,315.191101,273.674684167,638.641304,-284.467663,542.7827415,-196.977815,-115.001992167,-139.399073167,38.0435993667,-96.7881120667,237.892253833,96.22640165,150.0645135,-72.8402934167,55.7091663833,-46.499149,-69.0249414833,-34.2570998667,-0.1136286104,41.1102152833,-5.855535525,72.25201935,57.3048620333,26.4112386667,22.0158873,-23.4503808167,-44.9054362167,-44.6768073833,-57.9114271667,3.501168645,4.86808574833,15.6853979,26.20904235,9.44572010667,18.3891076333,25.5337096,-1.457879455,3.66612541,-4.34951605167,-9.70280557,2.94499652667,-17.9980293,5.52732507833,9.67315058333,12.07232065,3.16088759,5.19012736167,11.1280361333,0.903225344,3.50419425333,5.17349165,1.26691313417,0.424197331667,-7.31394311667,0.644480402,-0.7054547505,-7.83336324,-8.79931969667,0.919450314667,2.31163430333,-1.97855460667,-5.00577037333,0.670181171833,0.296742804833,2.11663603667,-0.158660101333,1.296106985,-0.627099453333,1.43888610333,0.94159286,-2.51069057667,0.1752145995,0.2598674839,-1.18067588,-1.77029918833,-2.00422409333,0.897636677667,-0.282119890333,-1.85600206833,-1.60748948833,0.0364890751167,-0.03489150063,-0.294586379333,-0.405772706,-0.0564741373167,0.693466022,-0.829689626833,0.5395894825,0.267800997667,-0.11150905895,0.0902245025667,-0.314682640333,0.124035512167,-0.238277830833,-1.20495998333,-0.531889270167,-0.370733216833,-0.300522072333,-0.968052662667,-0.400707852167,-0.0690978595,0.3571060245],[-35766.38235,1671.03603833,16.9239137333,-3092.09354667,2275.86078,379.778348167,-563.064387,-999.337645,1370.89408833,-645.171813667,-4.38312011667,1198.67328667,-941.630466167,-255.779033333,-781.967564333,300.838559,-450.195545167,-109.6543033,295.739117167,289.861371333,664.3060375,-298.364639833,558.968112333,-215.259778167,-111.295806333,-149.159215167,44.5509000833,-108.384795383,249.056461333,101.136337283,134.117988833,-70.6597194167,31.8763873017,-67.0631416333,-73.96315915,-36.3246383333,-1.9934377501,43.0697253333,-8.13797418167,75.68360645,55.0562634667,21.6519468833,17.3840001333,-26.7839611167,-53.89229565,-42.1904498,-56.5732983,8.036628595,4.16236059667,15.5742918333,26.8266776167,8.26372660333,18.6531052,24.1853385667,-1.46424248333,2.79452957667,-4.91578592167,-10.2710511533,3.34725134833,-16.8048870667,6.43584612,8.254748305,11.0019174333,3.25072703,4.97274985833,11.3376143333,0.661382335333,3.42543033167,4.85347015667,1.67458762167,0.441744758833,-7.44530884333,0.815075060667,-0.766868525667,-7.30512999667,-8.746352555,0.370052849667,1.94523143667,-1.96899668167,-4.730656055,0.787069619667,0.253803446,2.121980985,-0.1417126235,1.280269195,-0.707325926333,1.555369755,0.972922112167,-2.53224744833,0.233888525833,0.07556446855,-1.08604674717,-1.92655204167,-2.162649665,0.730795016167,-0.3150058425,-1.76803980333,-1.583822405,-0.02583432795,-0.00163010040333,-0.275725758833,-0.432342280667,-0.05315798415,0.699478333833,-0.832290319333,0.540173215333,0.272180656333,-0.1228352595,0.0940531827167,-0.3859860555,0.116787414333,-0.289411034167,-1.212066775,-0.5541980415,-0.38915016,-0.276147280167,-0.9607131755,-0.419373954,-0.0941768133,0.363846102167],[-35696.9920833,1534.88521667,179.776170933,-3228.06344,2362.18074,483.369465167,-563.967926333,-1140.99382867,1371.73005333,-642.354104833,56.3214396833,1251.56819667,-876.009347667,-192.772688833,-773.551605167,318.231012333,-450.335428167,-91.23752235,273.339312833,305.857345167,685.007293333,-309.972952333,571.187071167,-233.550884167,-106.720217667,-159.1627295,51.1058049667,-120.528516333,260.1747325,104.172813,119.065471833,-69.1072980667,7.39469199,-86.23835175,-80.8146359333,-38.4458934667,-4.116587355,44.82503205,-10.46016372,78.8691516167,52.1801584167,17.2239886167,12.4080936883,-29.9622105667,-62.31540505,-40.1073153333,-55.1175636833,12.50483614,3.35734947667,15.4318337167,27.33130725,7.07366951167,18.79814655,22.7415952667,-1.42296524333,1.8922171075,-5.43320976167,-10.7068835667,3.60150727667,-15.4952814667,7.21653403833,6.93636652333,10.0260172183,3.29888019167,4.75164481833,11.50208575,0.443161657167,3.30018025333,4.58714056167,2.05583767833,0.482965166833,-7.51740731833,0.9969216425,-0.808412861167,-6.70967289833,-8.682642035,-0.126237388167,1.616804415,-1.94040867833,-4.43603668833,0.894346907833,0.207954396667,2.11998612333,-0.115559874817,1.249279285,-0.7574854125,1.66005360833,1.01752167683,-2.53160254667,0.294274455833,-0.0959568953,-0.976145221,-2.08206632667,-2.30300747667,0.564575535667,-0.341844853667,-1.67028178833,-1.55663431833,-0.0794906394167,0.03374051487,-0.260103806167,-0.4572278925,-0.04937075515,0.703014991,-0.827069306333,0.538341130833,0.282610792833,-0.130252388333,0.0983588483,-0.451428306,0.109805892333,-0.337771190667,-1.21423703333,-0.575116294167,-0.403051751333,-0.247605085167,-0.950523319833,-0.4314408465,-0.118821786217,0.369856441667],[-35568.10655,1374.06262333,330.607917,-3330.20446333,2457.33903333,587.9474445,-572.218194333,-1277.95369333,1371.32787167,-630.533345667,117.39009495,1298.98102667,-812.442474333,-123.59834255,-771.089309667,336.261025167,-447.183455333,-71.86269265,248.627996833,321.149343,700.510075833,-318.162829,578.867059833,-251.554447167,-101.3695576,-169.2706265,57.4265652667,-132.858813,270.891979167,104.974458167,105.15464275,-68.561667,-17.1911957483,-104.000258267,-89.39448905,-40.5610518167,-6.46683141667,46.2987907833,-12.7553629333,81.6719685167,48.6226997333,13.082698085,7.02741371,-32.8302505667,-70.1705935667,-38.4164113833,-53.643614,16.8749235333,2.47538307667,15.2536072667,27.6998074,5.88663858333,18.7896112333,21.2244532,-1.373062075,0.946231015383,-5.86266512167,-11.0143336333,3.72979857833,-14.1279171833,7.89489647333,5.70806894,9.18614659333,3.30538713667,4.52683756333,11.6176067333,0.248824030617,3.12159506,4.38736294167,2.39628451,0.547747917833,-7.532317135,1.1887334825,-0.8252799395,-6.07021535833,-8.59793497333,-0.576135930167,1.341491945,-1.88966409,-4.12397157833,0.990272396333,0.159272049667,2.112049155,-0.0803094561667,1.20210837667,-0.773653801,1.74961985333,1.07720921667,-2.51267065833,0.355859033667,-0.250861834883,-0.856156493,-2.23073822,-2.42792857667,0.404744025167,-0.361047804833,-1.56322684,-1.52747763667,-0.123064879833,0.0708426496,-0.247777132167,-0.479444590667,-0.0448743551833,0.704121671833,-0.8136153275,0.533835929833,0.2997903745,-0.134585785,0.102929612767,-0.509744355,0.102376449917,-0.381937122833,-1.21300564333,-0.593753016833,-0.4124979965,-0.214884595833,-0.938579209167,-0.436237995333,-0.1427251065,0.375241428667],[-35402.2879,1219.91231,476.2336595,-3401.90412833,2562.24367,694.217423833,-592.3613305,-1410.08985,1367.24932,-611.527404833,176.550458167,1340.38330667,-751.121958167,-46.3602604833,-769.931090833,353.6358505,-441.180019833,-52.61607265,222.6885765,335.046202333,711.576451833,-322.320383833,581.730672333,-269.113172,-95.4558945333,-179.449407667,63.2083904333,-144.978888833,280.847601,103.485030167,92.4076067333,-69.2165960667,-41.3534283667,-120.3189335,-99.3932040333,-42.5994397333,-9.06822088,47.4185606167,-14.98460135,83.97234295,44.379742,9.136643445,1.24517438667,-35.2279708667,-77.4406515667,-37.0586191,-52.2259132333,21.1240911,1.55316922267,15.0186249333,27.9129264833,4.69851301167,18.6018550333,19.6493885167,-1.35164786,-0.0410344193,-6.16498066833,-11.1925968167,3.76256844,-12.7509994167,8.49829214167,4.55286934833,8.51935542833,3.27563419,4.29434733833,11.6816763,0.0732238518,2.88569620833,4.25869381167,2.68544845167,0.637513270333,-7.49419490333,1.39098307667,-0.814217785333,-5.40543397,-8.48206442333,-0.987891747167,1.132570255,-1.81333734,-3.79585054667,1.07408185283,0.107776124583,2.09996780667,-0.0377843006733,1.137967565,-0.754837398167,1.82162176667,1.15316166167,-2.48089918333,0.419054777333,-0.386995241833,-0.729592613667,-2.36717581333,-2.53937568667,0.256731383667,-0.371400478833,-1.447124335,-1.497668285,-0.155431099,0.1092603791,-0.238319994333,-0.4979226825,-0.0397794835167,0.7026098085,-0.792036638167,0.5263696885,0.323983554333,-0.137198775667,0.107922612,-0.560254870667,0.0943589942667,-0.420918832167,-1.20931628,-0.6091563355,-0.417838227667,-0.178042306833,-0.925798625667,-0.4332548605,-0.165540383667,0.380074981667],[-35244.5160167,1045.50310133,607.227298,-3444.31405,2666.12327167,797.0817085,-626.319415,-1545.26775333,1359.80109333,-587.0160835,230.514012667,1374.9663,-695.649818,38.6923118167,-770.05813,369.8957495,-432.065594667,-34.5955542833,196.345251667,345.998488667,718.381841333,-323.568422,579.841415833,-286.409955833,-89.1230936833,-189.464581833,68.2103649,-156.483506333,289.621121167,99.6554291,80.4601504667,-71.1098819333,-64.8542839833,-135.104017,-110.65048325,-44.5358342833,-11.9238017733,48.1479136,-17.0737096833,85.7031458667,39.4945364333,5.26665121833,-4.90074047333,-37.1199439167,-84.06925565,-36.0306754833,-50.9436487,25.2362908333,0.608124495,14.70093365,27.96357155,3.51703668667,18.2339748667,18.04657525,-1.38105145833,-1.06092824795,-6.335057295,-11.2270811167,3.7136882,-11.4109417833,9.04553431167,3.46042882,8.05019757167,3.21333073833,4.04738842667,11.6936080833,-0.0881330982167,2.59359198167,4.206922105,2.91981239167,0.754663839667,-7.41068317667,1.60778559167,-0.776578888167,-4.73021661667,-8.33071852667,-1.367236028,0.997661616,-1.70983710833,-3.45362081,1.14607639667,0.05282699607,2.085167315,0.00909594412333,1.05609643383,-0.700699850833,1.87520745667,1.246526485,-2.44075846333,0.485237802833,-0.503985579167,-0.5980062525,-2.48858248333,-2.63851919333,0.124099357975,-0.372327601667,-1.32296104,-1.46746173667,-0.176133422833,0.148993220333,-0.231319759333,-0.511857049667,-0.0346589365,0.697986230167,-0.762769727333,0.515809947333,0.355367101667,-0.138977296833,0.113722984167,-0.602787783333,0.0862766998833,-0.454356798333,-1.203793855,-0.620766417667,-0.419400077,-0.13764446875,-0.912510856667,-0.4224440295,-0.186948113333,0.384321236167],[-35138.6394667,791.990088667,686.719729333,-3461.36101333,2752.981785,889.122651333,-680.847428833,-1687.72940333,1350.04832,-558.1899275,277.609064167,1400.519015,-649.318648667,129.654878883,-773.858867167,385.358369667,-419.135175167,-18.464282665,170.274913833,352.253591,720.521880333,-323.7440915,572.898289167,-303.659961667,-82.3380715167,-198.954562167,72.1346687333,-166.917546667,296.722366667,93.3533121667,68.8124387167,-74.3971318,-87.5740545167,-148.238144667,-123.039727333,-46.3651218167,-15.0108039167,48.41040335,-18.9245268667,86.7989119333,34.0124407667,1.34814344667,-11.403014745,-38.5356258,-89.98876685,-35.3463610167,-49.8756412833,29.2175676667,-0.363186166667,14.2798322167,27.8444763333,2.357649945,17.6919052,16.4514841667,-1.47614843667,-2.10925108167,-6.38645842,-11.1011246333,3.590536545,-10.1522267783,9.553472995,2.43741092667,7.79680858167,3.11833405333,3.78013143833,11.6563502,-0.237034633667,2.24875177167,4.24018037667,3.09942636667,0.901578116667,-7.28977108333,1.84330719167,-0.715064902167,-4.057139035,-8.14338733,-1.71495836833,0.942172869667,-1.57998938833,-3.10371274833,1.20697941,-0.00641397953667,2.06972165833,0.0580641922767,0.955980129667,-0.610016132167,1.91043975167,1.35863303,-2.39528666333,0.555719381,-0.601995298,-0.462093548833,-2.59404202167,-2.72635755,0.00965556258333,-0.364098273833,-1.19316907333,-1.43750472833,-0.184588362,0.190317408333,-0.226614225,-0.520649567167,-0.0300491516667,0.68963763,-0.726021681167,0.502118655333,0.394233083167,-0.1403454125,0.120641973,-0.637306206667,0.07880694235,-0.482288177167,-1.19733437167,-0.6282087885,-0.417550128333,-0.0944380048833,-0.899076242167,-0.403779195333,-0.206678261667,0.387953093333],[-35086.65425,485.697566833,705.9193935,-3457.293515,2827.52533333,970.683700833,-755.300916167,-1836.48204,1336.40664167,-524.1694115,317.805723167,1419.5094,-611.971661333,223.561093167,-783.488096167,399.096682,-402.184102167,-4.556359985,146.315411667,353.222964333,717.901294167,-324.3766635,561.098925333,-321.158558333,-75.3863574833,-207.878593333,74.7404097667,-175.717949333,301.885403667,84.7283489167,57.15221915,-78.9881622167,-109.456221267,-159.4970855,-136.312717333,-48.1008731333,-18.4047687,48.1301834833,-20.4660903333,87.20459255,28.0763986,-2.66515435833,-18.1532180167,-39.51204015,-95.08307405,-34.99551795,-49.0212749833,33.0797323167,-1.34603074567,13.71519425,27.5477561167,1.21902194047,16.9733929,14.9184060333,-1.62562508833,-3.15182974333,-6.33251852,-10.77137815,3.39610800833,-8.98371600333,10.041493645,1.49075796417,7.77114706167,2.99898783667,3.48583415833,11.5738492667,-0.380848507333,1.85381549833,4.36544855667,3.231797105,1.08477024617,-7.13628404333,2.11068098,-0.634170245167,-3.3883073,-7.91867267833,-2.028890095,0.971185475333,-1.42547837667,-2.75195133333,1.25940915667,-0.06954761153,2.05568617833,0.10539156455,0.8381710135,-0.483706236,1.92850519333,1.49003693833,-2.34507363833,0.633346374167,-0.6812670265,-0.320410537667,-2.682191985,-2.802698635,-0.0834985922917,-0.347473779667,-1.05956427383,-1.40864318167,-0.180849681833,0.23355443,-0.223401823167,-0.523995996667,-0.0267802303833,0.677322574833,-0.682752633333,0.4850601445,0.440271519833,-0.140863080333,0.128973467667,-0.663615061167,0.0730011412333,-0.504605935667,-1.19029409333,-0.6309550915,-0.412877392167,-0.048865145065,-0.885898084333,-0.377625610833,-0.224529704833,0.391035534],[-35074.7218667,183.74053815,688.8743475,-3439.20935333,2902.06908167,1049.77337783,-843.252009333,-1985.82858833,1314.79861333,-483.172963167,351.4614355,1436.74275333,-580.597596,316.114603167,-799.3040325,409.235719333,-381.248608,6.62510620167,126.639756,349.086029833,710.359614333,-326.3551485,545.256754667,-339.124772833,-68.72045915,-216.390077833,75.7713452667,-182.322088833,304.927706833,74.0284539167,45.3691893167,-84.59637045,-130.437558667,-168.715203167,-150.225038667,-49.73799275,-22.2520391,47.2298096,-21.6384024,86.84711205,21.8698697167,-6.76662272833,-25.0014167333,-40.0647787833,-99.2564509,-34.9593341667,-48.3328664833,36.8670593,-2.308172935,12.9513505833,27.0602730667,0.0925352385333,16.06338045,13.5084659,-1.80988472,-4.1493944,-6.17738009,-10.1905058583,3.13681537333,-7.89453734667,10.5473817,0.622888908833,7.97601769333,2.86839881667,3.15704304167,11.4482037667,-0.5308661525,1.40839982233,4.58768855333,3.324827405,1.30995026667,-6.95152416667,2.42601855167,-0.536028911333,-2.72077116167,-7.64953333333,-2.30613614,1.08744389733,-1.24883791333,-2.39995573667,1.30668083667,-0.135137073067,2.04494525667,0.146095738833,0.703166031833,-0.3241655045,1.93016092833,1.640647495,-2.28936999,0.721416682167,-0.741146127833,-0.170844236833,-2.75051347167,-2.86662958667,-0.152266015483,-0.323700807333,-0.922425999167,-1.38099907167,-0.165558906167,0.278980422833,-0.220359093833,-0.521525475,-0.0258735828333,0.660903678,-0.634277928167,0.464104232,0.4929390705,-0.1397823335,0.138930469167,-0.681281053,0.0699045913833,-0.52099855,-1.18262145167,-0.628146762167,-0.406139931333,-0.000982677443333,-0.873104294167,-0.344586796667,-0.240395521333,0.393661345667],[-35089.7869333,-66.8283282333,680.352725,-3410.08392167,2983.49452833,1135.58550167,-937.225834833,-2125.59961,1282.49277167,-435.028585167,377.947171,1456.40647667,-550.2666415,402.991022167,-818.711216833,414.102951167,-356.561720833,14.307191225,113.059892167,340.510791667,697.834549167,-329.428917833,526.259449833,-357.1730995,-62.7778415167,-224.561110667,74.9961740333,-186.255382333,305.711112,61.59094275,33.5826407833,-90.8936088333,-150.1877235,-175.779129667,-164.3644745,-51.2670980167,-26.6499764,45.6699029333,-22.3973627,85.6355247167,15.6029155,-10.934202125,-31.7894164833,-40.1351504667,-102.432962733,-35.1321673667,-47.7506967167,40.6513310333,-3.215452575,11.9449990667,26.3796391333,-1.03010091287,14.9383278667,12.2841264,-2.01782064,-5.05974560667,-5.91590605667,-9.31788134833,2.84626532667,-6.87142854833,11.1265102167,-0.168465918667,8.41909698,2.73987445333,2.78798306833,11.2815701,-0.696452476667,0.911510555667,4.90955085333,3.38236563667,1.58408374167,-6.73805022167,2.80392082667,-0.416680716333,-2.051303705,-7.31993150333,-2.54525787167,1.297781575,-1.05160183,-2.04606638333,1.35172582333,-0.201773169333,2.03853083667,0.176012362333,0.552150641667,-0.134785397917,1.91531495167,1.81056845667,-2.22857512333,0.8232080095,-0.7803563285,-0.0112948051667,-2.79359980833,-2.91701071667,-0.191631029167,-0.293715929667,-0.780207069167,-1.35462083,-0.139401064,0.326608205,-0.216245346667,-0.513101199,-0.0281375361167,0.640537622667,-0.582090377333,0.438759238333,0.5516124605,-0.136672245833,0.150848914833,-0.689959164167,0.0706468033167,-0.530509760333,-1.173929415,-0.618202643667,-0.398043682,0.0498054801517,-0.860784718167,-0.305105481667,-0.254220515833,0.396026754667],[-35123.4082833,-247.917470017,685.781192167,-3368.33244,3073.52863667,1226.41212,-1031.2719425,-2250.59657333,1239.73879333,-379.873243833,395.327266667,1481.06085167,-518.593971667,481.393429167,-838.5308185,412.9795185,-328.205715667,17.9104907,106.966122667,327.518415167,680.964570667,-332.961385,505.406220833,-374.788153333,-57.8487467333,-232.309851667,72.3352803833,-187.050392833,304.056129667,47.9618046,21.9459238833,-97.3465846167,-168.397059167,-180.556532,-178.309123167,-52.6937313833,-31.6165182,43.4650586333,-22.68239315,83.5137252833,9.51392801833,-15.17878015,-38.31075435,-39.68873805,-104.531772833,-35.38258045,-47.215219,44.5212413667,-4.04881754167,10.6774050067,25.5158322833,-2.151348285,13.5890820167,11.3029918333,-2.25385635167,-5.83528029333,-5.55215385333,-8.11427418167,2.57033617833,-5.89634465667,11.8402406667,-0.878634538833,9.11390225833,2.62275612,2.37647776333,11.0763567833,-0.884473701,0.365203814333,5.32997288,3.40605509833,1.91374284333,-6.50017724667,3.25855774833,-0.2695183599,-1.37263911383,-6.91100827667,-2.741983365,1.61244280833,-0.8333242495,-1.68793668,1.39681962667,-0.268806422,2.03637694667,0.192130324,0.386770553667,0.0802801565,1.884557225,1.99955448,-2.16355151,0.942174398333,-0.798025914333,0.161761715333,-2.80521625167,-2.95151725167,-0.1955613065,-0.257098719167,-0.630577874167,-1.32956901167,-0.102872443017,0.376299873833,-0.210419519167,-0.499012792667,-0.0339892664,0.616450766167,-0.527628627167,0.408999101667,0.615566422667,-0.131252758833,0.165170790833,-0.6896822755,0.0766468242167,-0.531989169667,-1.16331202333,-0.5993194535,-0.388714296167,0.104506317733,-0.849012064833,-0.259425992,-0.265982202333,0.398456475833],[-35175.0954667,-365.2565725,683.943778,-3311.107155,3169.09393,1312.01764333,-1124.65820167,-2362.74451333,1188.35818667,-318.269376833,400.225636333,1511.09457667,-486.669045333,549.179812833,-857.130353667,405.844153333,-296.130071,16.8368538833,109.420576,309.159527167,660.569616667,-336.892845,484.110169333,-391.819422333,-54.04411245,-239.414116333,67.7810071,-184.186009,299.630896167,33.7320706833,10.3912615217,-103.30841655,-184.9730825,-182.847850167,-191.682006667,-54.0052543167,-37.1068618833,40.6646274,-22.4039345167,80.4324834833,3.83856879,-19.5788843333,-44.3224383333,-38.7749504,-105.434571667,-35.6076788833,-46.6509335333,48.5522376333,-4.79596303833,9.14726796167,24.48830545,-3.267664095,12.0190106833,10.61629875,-2.53590142667,-6.4226013,-5.11224678167,-6.53033129167,2.34107311833,-4.94049578667,12.7411556167,-1.49813658317,10.0758739567,2.52231506667,1.92317353667,10.8354490833,-1.1005901725,-0.223930136167,5.84566323167,3.39726197833,2.30506331667,-6.245181265,3.80662557667,-0.0929484462667,-0.6721477773,-6.40606769833,-2.88947643,2.04249951833,-0.592426041,-1.32357788233,1.442879225,-0.335839856,2.03780635,0.191890178833,0.209632612383,0.316739309583,1.839489325,2.20666339,-2.09525123,1.08245068517,-0.794916229667,0.353541863,-2.77986470667,-2.96634849,-0.15806780265,-0.212582743667,-0.471194351,-1.30576163333,-0.05640035421,0.427591301167,-0.202580639167,-0.479754110833,-0.0436059423833,0.5889357825,-0.472173213667,0.375255885333,0.683820455667,-0.123207056,0.182407737,-0.680843902667,0.08967725325,-0.5246029445,-1.14921444833,-0.569813087,-0.377816415167,0.164126607,-0.837696948333,-0.207735771667,-0.275563593833,0.4012505985],[-35255.83965,-470.7411495,653.904467167,-3231.32754333,3258.73913833,1380.63758667,-1226.24207167,-2468.30039333,1133.49159,-252.276802167,389.8685595,1542.04323667,-458.782811333,605.950120833,-873.346845667,393.994882333,-260.358992333,10.8966376917,120.298393167,284.028761333,637.532878167,-341.143071667,463.407719833,-408.125267667,-51.2143753833,-245.437428333,61.44104035,-177.305910833,292.184679,19.3690418467,-1.18769933,-108.2612995,-199.8870455,-182.490309,-204.064328167,-55.1828721167,-42.9600667167,37.36794115,-21.4855188,76.4025335,-1.29162269833,-24.2578547833,-49.6082220167,-37.5081816167,-105.051068667,-35.6834514,-45.98312015,52.77251945,-5.45558575333,7.38808220333,23.3296432167,-4.36821455167,10.2517343,10.2333174667,-2.8988687,-6.78187369,-4.64707179167,-4.53455286333,2.18396411833,-3.97170997,13.8592999833,-2.01717205167,11.3231089667,2.43856538333,1.43471607533,10.5601592,-1.34493512,-0.84570636,6.445455145,3.35527673167,2.75802758833,-5.98558678333,4.45959223167,0.109264681267,0.0635778904667,-5.79379547,-2.98123112167,2.59889125,-0.326243702933,-0.952699418,1.488681565,-0.403085884667,2.04045074333,0.174817405833,0.0234083240333,0.570616083667,1.78255788667,2.42902161833,-2.02581422,1.24771494833,-0.774216827333,0.568969746333,-2.712709495,-2.957721555,-0.0740817745,-0.158096553183,-0.300364238167,-1.2832838,-0.000286829223333,0.4794477015,-0.193151392333,-0.456143513167,-0.0565416442,0.558251921,-0.416291436,0.338585289,0.754926798,-0.112444965,0.2031296295,-0.664507735,0.111212692883,-0.5076866925,-1.12983103833,-0.528471076,-0.364708143,0.229445194167,-0.826721243167,-0.150259370917,-0.28264624,0.404652126833],[-35370.3624167,-596.071769667,606.3611835,-3125.01501,3335.69422333,1427.78106167,-1338.14385833,-2565.02846833,1079.36057833,-185.201508833,363.358006167,1570.01637167,-437.027090833,652.831951833,-884.100379667,378.9468315,-221.736822333,0.321425866667,138.992789,251.518388833,612.8436555,-344.758042333,444.182278667,-423.036822167,-49.0524608333,-250.035328833,53.4640876,-166.347074,281.640750833,5.21958772667,-12.6633894283,-111.819980667,-212.873028667,-179.383862667,-214.980240833,-56.1697913833,-48.9739355667,33.6782383333,-19.94132135,71.4555291,-5.84743740333,-29.2981907,-54.0059985,-35.9451941167,-103.337598,-35.4474275667,-45.1521127833,57.17782215,-6.02532196667,5.458914425,22.0699992333,-5.44814628667,8.313639715,10.1239999,-3.376693425,-6.90190213333,-4.200762295,-2.124499101,2.12821011667,-2.96957004667,15.2082696833,-2.429448495,12.8675285,2.36781403833,0.924969191833,10.24837568,-1.61133190833,-1.49037264583,7.11128375333,3.27824989833,3.26231978833,-5.733695355,5.21749061333,0.333640317833,0.841356520033,-5.06837485333,-3.01224862167,3.288519085,-0.0320680965667,-0.576447812833,1.53113866167,-0.470606131833,2.04087181833,0.143394176,-0.169803287283,0.838653524,1.71595789167,2.66163470167,-1.95784766,1.43857091,-0.739519450167,0.810145509167,-2.60023996,-2.92295203333,0.0593303380833,-0.09150187085,-0.117592924133,-1.26214743167,0.06485726949,0.530446546333,-0.183168027833,-0.429009491667,-0.0716736835,0.524504375833,-0.359684107167,0.300091528833,0.8272914145,-0.0990441387667,0.227388433667,-0.6419131495,0.141828266333,-0.480846212667,-1.10367057167,-0.474787644,-0.348775530167,0.300676510333,-0.815863333667,-0.0875359862,-0.286859501833,0.408746620333],[-35505.5033333,-757.342212,575.7839815,-2992.691865,3401.79084,1454.55576667,-1453.66912333,-2635.56831333,1028.0833855,-118.46912275,320.889749667,1593.44978167,-418.0943065,691.122284167,-884.888217167,361.881332667,-181.3307355,-14.5498150417,165.048267167,212.155697333,587.372999167,-346.040096667,427.20528,-435.310645167,-47.2500599,-253.123974333,43.9551785667,-151.395377167,268.054337833,-8.49815586,-23.6737609667,-113.676505833,-223.375069167,-173.570322,-223.954669833,-56.9030794167,-55.0225701333,29.6793467,-17.8715469,65.62331265,-9.85755444667,-34.71529575,-57.4066656167,-34.04574,-100.31021555,-34.7132211,-44.1277871167,61.7766147333,-6.50324656833,3.41361387,20.7393910333,-6.523757385,6.22490592333,10.2408584167,-3.98947738,-6.79183384333,-3.797356075,0.679355812667,2.220968715,-1.93265151217,16.79537805,-2.725852665,14.7122444167,2.30769939333,0.41267098415,9.89960385,-1.894272965,-2.15042202333,7.82097241667,3.165102385,3.80245632833,-5.49984814833,6.07345581333,0.582385367833,1.66094466383,-4.22974256667,-2.97936293,4.11385065333,0.291043511067,-0.1977611135,1.56821384833,-0.536356890667,2.03590164833,0.101596419333,-0.3683891735,1.11720173933,1.641161965,2.89848759667,-1.89468122,1.65378606667,-0.694002378333,1.07673913567,-2.44170275167,-2.86120331333,0.243460078767,-0.0115941390167,0.0767792463,-1.24225400333,0.138036410867,0.579373459833,-0.173330208167,-0.399255908333,-0.0872430128167,0.487731284167,-0.30194268,0.260553285333,0.899174071167,-0.08353480245,0.254806208167,-0.6146304685,0.181391084333,-0.4443888955,-1.07016767667,-0.4087505425,-0.3296335535,0.377683412333,-0.80475885,-0.0204110349333,-0.287911452667,0.413579045833],[-35637.0842,-992.4753425,582.7187225,-2840.98993167,3452.26650667,1459.51474,-1567.62977667,-2667.58002833,979.903173833,-54.63242988,263.704740167,1608.89477833,-399.239085333,722.459381167,-873.906904167,344.246099167,-140.2372679,-32.7706172167,197.025849667,166.777364833,561.791962333,-344.072859,412.817655,-444.4922075,-45.2451670833,-254.558722,33.12312655,-132.818586167,251.695535,-21.7856348933,-33.9560048333,-113.730384833,-231.1412545,-165.290384667,-230.824123667,-57.2796019333,-60.9378078667,25.44538185,-15.4141762333,59.0145173667,-13.4546161533,-40.48878785,-59.7957718167,-31.8146258833,-96.0633511667,-33.4194968667,-42.9161304667,66.5667992333,-6.89932664833,1.31873239083,19.3626562333,-7.60492422,4.020643265,10.5083251667,-4.735227055,-6.48565765167,-3.45457672833,3.83767667067,2.482701095,-0.8755386915,18.6111484,-2.902446175,16.8395367667,2.24909176667,-0.0825110087333,9.51382625,-2.18187320333,-2.817943685,8.54997687167,3.02009939833,4.35979650333,-5.28911316333,7.01783750833,0.8552387015,2.51803946167,-3.28610168,-2.88452914,5.066824525,0.6402541775,0.178151242833,1.59698756,-0.598902288167,2.02272055667,0.0554547073,-0.571563357833,1.40388402333,1.56025361833,3.13356600667,-1.83867086,1.89182361333,-0.640753287833,1.36780027667,-2.23959243167,-2.77362573667,0.4761563295,0.0811644334167,0.2812451227,-1.22412742833,0.218210839333,0.625293174167,-0.164680898333,-0.367833723333,-0.101274524383,0.447638512167,-0.242087592167,0.220723155833,0.968973227667,-0.0665871569167,0.284873829333,-0.584236161833,0.229709236167,-0.399435327,-1.02934417333,-0.331043323167,-0.307161239,0.4598963,-0.793289821167,0.0502663902667,-0.285735181667,0.4192209295],[-35742.9782333,-1322.02188633,638.413337167,-2675.33200333,3480.04742833,1441.64905333,-1678.65246,-2662.44206667,934.6419865,2.25623764667,194.1743165,1612.377535,-380.490923667,747.6714985,-851.610450667,327.504771167,-99.4644911167,-52.8626582833,232.890723167,116.515115183,536.061309,-338.7481135,400.8025085,-451.2110425,-42.4613722833,-254.114978,21.32432235,-111.201666033,233.125817167,-34.8393617833,-43.3967674667,-112.102401,-236.383509667,-154.880463667,-235.690503833,-57.2120067,-66.5037282667,21.0497582333,-12.69634751,51.8093176833,-16.8202840167,-46.5778261167,-61.2504557833,-29.3271052333,-90.75752865,-31.62097735,-41.5474955,71.5054255,-7.228591055,-0.753555785,17.94964905,-8.68771713167,1.74076921167,10.8413907167,-5.59458741333,-6.03468047833,-3.18575082167,7.29826893667,2.89394937333,0.1772915615,20.6244298833,-2.97434717,19.2103437167,2.17970390333,-0.54704288035,9.08662122667,-2.45752869167,-3.487897625,9.27708607667,2.85130206667,4.91552667167,-5.10075123,8.03744587,1.14574115917,3.40207571,-2.25104131333,-2.738586305,6.12957131833,1.0108355005,0.546334710333,1.61380270333,-0.658868133167,1.99829172833,0.0117176544,-0.7795069175,1.69770744,1.47579849333,3.36117715167,-1.79035920333,2.15008659167,-0.5825280065,1.68104432167,-1.99787777333,-2.66324802667,0.751774803667,0.1855565578,0.493333533,-1.208901645,0.304043066833,0.667572956167,-0.158557504833,-0.335461967,-0.112253870167,0.403841012167,-0.178934181333,0.181321319667,1.03543324117,-0.0487225684333,0.317021035,-0.5519011685,0.286538388333,-0.347349253,-0.981493685667,-0.242964601167,-0.281520025,0.546286187833,-0.781801390833,0.12359937195,-0.280517458833,0.425727022333],[-35827.5014833,-1713.29401,732.463279333,-2505.92514167,3488.19748333,1399.11809333,-1780.17492167,-2627.19678667,890.050982167,49.60997172,114.15201365,1605.04200167,-363.493874,767.5609915,-819.6472385,311.718127667,-60.1817457333,-73.5870789333,271.4299455,62.231568155,510.388200333,-330.579943,391.047453167,-456.325469333,-38.86374655,-252.025620833,8.92660032833,-87.2073163,212.8738745,-47.7257585833,-51.9462065833,-108.931389,-239.579617333,-142.4992475,-238.718904833,-56.6899422167,-71.69767565,16.54744615,-9.87822930333,44.1770639333,-20.1037215333,-52.9262027,-61.8464188167,-26.7075748333,-84.5383671333,-29.3871735833,-40.0488229,76.521633,-7.482247415,-2.77927099917,16.4908067333,-9.79299234333,-0.587387401667,11.16065565,-6.55477902333,-5.481094905,-3.01038267,11.0177575783,3.41655149833,1.21159044717,22.7962279333,-2.96232814167,21.7795649,2.10103495167,-0.974600132833,8.61100738,-2.71774578167,-4.16162083667,9.98111180167,2.66110891,5.45270217167,-4.93610111333,9.11953511,1.44119857167,4.30173176333,-1.14252018712,-2.552041885,7.28126326333,1.39784098167,0.904568950667,1.61877656333,-0.715299130167,1.96102198667,-0.02646689525,-0.993363261167,1.99554618667,1.38894876667,3.57512483333,-1.75077331167,2.424710385,-0.523321196167,2.01299161667,-1.72251722,-2.53360918,1.062956927,0.300370378167,0.710351576167,-1.19729978833,0.394512887,0.706251157667,-0.155041692333,-0.302333167167,-0.119240515167,0.3562260335,-0.112357741033,0.142689211833,1.09722077167,-0.0307180642167,0.350451580833,-0.519156519,0.3512555535,-0.289894406667,-0.927372160167,-0.1464223334,-0.252992966333,0.635744762667,-0.7708913835,0.198757892333,-0.272557242,0.432943719833],[-35900.3820833,-2113.73021,846.672696167,-2345.31471333,3484.44582833,1332.62349,-1863.34642833,-2567.29317333,843.104612167,86.32771165,26.0428030667,1589.82029833,-348.666582,783.217940667,-779.686397667,296.465968833,-23.4550604667,-93.6544863167,311.782604667,4.89323882,485.3253245,-319.926135667,383.494097,-460.417076333,-34.5574084667,-248.680880333,-3.69037955333,-61.4732862833,191.469478,-60.4500526,-59.4681653833,-104.285647867,-241.142513,-128.261640333,-240.057108,-55.7155298333,-76.5630089667,11.9714411483,-7.12552341667,36.2947732167,-23.4418500833,-59.43811815,-61.65078385,-24.0496845667,-77.54462355,-26.78240325,-38.4501101833,81.5431275833,-7.64766018167,-4.75001779167,14.9650572167,-10.9499702117,-2.94063709833,11.3881696833,-7.597582505,-4.86349386,-2.939671145,14.9498193167,4.020492835,2.21078097167,25.0859997667,-2.88320557167,24.5015491667,2.01775990333,-1.36069529117,8.07874728,-2.963449215,-4.84286915167,10.63872028,2.45006053167,5.95442093,-4.79466512,10.2497389017,1.73135538333,5.20503170667,0.0227053948667,-2.33434266333,8.501184485,1.79567267333,1.2504954365,1.61329648833,-0.766455083,1.90961926,-0.0571295044167,-1.21466892967,2.293276995,1.29998977167,3.76837822167,-1.72051022167,2.71119671,-0.4664914155,2.35955272167,-1.41922432333,-2.38784490667,1.40249456333,0.423928354833,0.929523814333,-1.18979615333,0.488719769,0.741543921,-0.153759851667,-0.268473903833,-0.121414040333,0.30